import { Injectable } from '@angular/core';
import { menuController } from '@ionic/core';
import * as i0 from "@angular/core";
export class MenuController {
    /**
     * Programmatically open the Menu.
     * @param [menuId]  Optionally get the menu by its id, or side.
     * @return returns a promise when the menu is fully opened
     */
    open(menuId) {
        return menuController.open(menuId);
    }
    /**
     * Programmatically close the Menu. If no `menuId` is given as the first
     * argument then it'll close any menu which is open. If a `menuId`
     * is given then it'll close that exact menu.
     * @param [menuId]  Optionally get the menu by its id, or side.
     * @return returns a promise when the menu is fully closed
     */
    close(menuId) {
        return menuController.close(menuId);
    }
    /**
     * Toggle the menu. If it's closed, it will open, and if opened, it
     * will close.
     * @param [menuId]  Optionally get the menu by its id, or side.
     * @return returns a promise when the menu has been toggled
     */
    toggle(menuId) {
        return menuController.toggle(menuId);
    }
    /**
     * Used to enable or disable a menu. For example, there could be multiple
     * left menus, but only one of them should be able to be opened at the same
     * time. If there are multiple menus on the same side, then enabling one menu
     * will also automatically disable all the others that are on the same side.
     * @param [menuId]  Optionally get the menu by its id, or side.
     * @return Returns the instance of the menu, which is useful for chaining.
     */
    enable(shouldEnable, menuId) {
        return menuController.enable(shouldEnable, menuId);
    }
    /**
     * Used to enable or disable the ability to swipe open the menu.
     * @param shouldEnable  True if it should be swipe-able, false if not.
     * @param [menuId]  Optionally get the menu by its id, or side.
     * @return Returns the instance of the menu, which is useful for chaining.
     */
    swipeGesture(shouldEnable, menuId) {
        return menuController.swipeGesture(shouldEnable, menuId);
    }
    /**
     * @param [menuId] Optionally get the menu by its id, or side.
     * @return Returns true if the specified menu is currently open, otherwise false.
     * If the menuId is not specified, it returns true if ANY menu is currenly open.
     */
    isOpen(menuId) {
        return menuController.isOpen(menuId);
    }
    /**
     * @param [menuId]  Optionally get the menu by its id, or side.
     * @return Returns true if the menu is currently enabled, otherwise false.
     */
    isEnabled(menuId) {
        return menuController.isEnabled(menuId);
    }
    /**
     * Used to get a menu instance. If a `menuId` is not provided then it'll
     * return the first menu found. If a `menuId` is `left` or `right`, then
     * it'll return the enabled menu on that side. Otherwise, if a `menuId` is
     * provided, then it'll try to find the menu using the menu's `id`
     * property. If a menu is not found then it'll return `null`.
     * @param [menuId]  Optionally get the menu by its id, or side.
     * @return Returns the instance of the menu if found, otherwise `null`.
     */
    get(menuId) {
        return menuController.get(menuId);
    }
    /**
     * @return Returns the instance of the menu already opened, otherwise `null`.
     */
    getOpen() {
        return menuController.getOpen();
    }
    /**
     * @return Returns an array of all menu instances.
     */
    getMenus() {
        return menuController.getMenus();
    }
}
/** @nocollapse */ MenuController.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: MenuController, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ MenuController.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: MenuController, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: MenuController, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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