import { Injectable, InjectionToken, Injector, } from '@angular/core';
import { LIFECYCLE_DID_ENTER, LIFECYCLE_DID_LEAVE, LIFECYCLE_WILL_ENTER, LIFECYCLE_WILL_LEAVE, LIFECYCLE_WILL_UNLOAD, } from '@ionic/core';
import { NavParams } from '../directives/navigation/nav-params';
import { isComponentFactoryResolver } from '../util/util';
import * as i0 from "@angular/core";
// TODO(FW-2827): types
export class AngularDelegate {
    constructor(zone, appRef) {
        this.zone = zone;
        this.appRef = appRef;
    }
    create(resolverOrInjector, injector, location, elementReferenceKey) {
        return new AngularFrameworkDelegate(resolverOrInjector, injector, location, this.appRef, this.zone, elementReferenceKey);
    }
}
/** @nocollapse */ AngularDelegate.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: AngularDelegate, deps: [{ token: i0.NgZone }, { token: i0.ApplicationRef }], target: i0.ɵɵFactoryTarget.Injectable });
/** @nocollapse */ AngularDelegate.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: AngularDelegate });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: AngularDelegate, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return [{ type: i0.NgZone }, { type: i0.ApplicationRef }]; } });
export class AngularFrameworkDelegate {
    constructor(resolverOrInjector, injector, location, appRef, zone, elementReferenceKey) {
        this.resolverOrInjector = resolverOrInjector;
        this.injector = injector;
        this.location = location;
        this.appRef = appRef;
        this.zone = zone;
        this.elementReferenceKey = elementReferenceKey;
        this.elRefMap = new WeakMap();
        this.elEventsMap = new WeakMap();
    }
    attachViewToDom(container, component, params, cssClasses) {
        return this.zone.run(() => {
            return new Promise((resolve) => {
                const componentProps = Object.assign({}, params);
                /**
                 * Ionic Angular passes a reference to a modal
                 * or popover that can be accessed using a
                 * variable in the overlay component. If
                 * elementReferenceKey is defined, then we should
                 * pass a reference to the component using
                 * elementReferenceKey as the key.
                 */
                if (this.elementReferenceKey !== undefined) {
                    componentProps[this.elementReferenceKey] = container;
                }
                const el = attachView(this.zone, this.resolverOrInjector, this.injector, this.location, this.appRef, this.elRefMap, this.elEventsMap, container, component, componentProps, cssClasses);
                resolve(el);
            });
        });
    }
    removeViewFromDom(_container, component) {
        return this.zone.run(() => {
            return new Promise((resolve) => {
                const componentRef = this.elRefMap.get(component);
                if (componentRef) {
                    componentRef.destroy();
                    this.elRefMap.delete(component);
                    const unbindEvents = this.elEventsMap.get(component);
                    if (unbindEvents) {
                        unbindEvents();
                        this.elEventsMap.delete(component);
                    }
                }
                resolve();
            });
        });
    }
}
export const attachView = (zone, resolverOrInjector, injector, location, appRef, elRefMap, elEventsMap, container, component, params, cssClasses) => {
    let componentRef;
    const childInjector = Injector.create({
        providers: getProviders(params),
        parent: injector,
    });
    if (resolverOrInjector && isComponentFactoryResolver(resolverOrInjector)) {
        // Angular 13 and lower
        const factory = resolverOrInjector.resolveComponentFactory(component);
        componentRef = location
            ? location.createComponent(factory, location.length, childInjector)
            : factory.create(childInjector);
    }
    else if (location) {
        // Angular 14
        const environmentInjector = resolverOrInjector;
        componentRef = location.createComponent(component, {
            index: location.indexOf,
            injector: childInjector,
            environmentInjector,
        });
    }
    else {
        return null;
    }
    const instance = componentRef.instance;
    const hostElement = componentRef.location.nativeElement;
    if (params) {
        Object.assign(instance, params);
    }
    if (cssClasses) {
        for (const clazz of cssClasses) {
            hostElement.classList.add(clazz);
        }
    }
    const unbindEvents = bindLifecycleEvents(zone, instance, hostElement);
    container.appendChild(hostElement);
    if (!location) {
        appRef.attachView(componentRef.hostView);
    }
    componentRef.changeDetectorRef.reattach();
    elRefMap.set(hostElement, componentRef);
    elEventsMap.set(hostElement, unbindEvents);
    return hostElement;
};
const LIFECYCLES = [
    LIFECYCLE_WILL_ENTER,
    LIFECYCLE_DID_ENTER,
    LIFECYCLE_WILL_LEAVE,
    LIFECYCLE_DID_LEAVE,
    LIFECYCLE_WILL_UNLOAD,
];
export const bindLifecycleEvents = (zone, instance, element) => {
    return zone.run(() => {
        const unregisters = LIFECYCLES.filter((eventName) => typeof instance[eventName] === 'function').map((eventName) => {
            const handler = (ev) => instance[eventName](ev.detail);
            element.addEventListener(eventName, handler);
            return () => element.removeEventListener(eventName, handler);
        });
        return () => unregisters.forEach((fn) => fn());
    });
};
const NavParamsToken = new InjectionToken('NavParamsToken');
const getProviders = (params) => {
    return [
        {
            provide: NavParamsToken,
            useValue: params,
        },
        {
            provide: NavParams,
            useFactory: provideNavParamsInjectable,
            deps: [NavParamsToken],
        },
    ];
};
const provideNavParamsInjectable = (params) => {
    return new NavParams(params);
};
//# sourceMappingURL=data:application/json;base64,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