import { Component, ContentChild, EventEmitter, HostListener, Input, Output, ViewChild } from '@angular/core';
import { IonTabBar } from '../proxies';
import { IonRouterOutlet } from './ion-router-outlet';
import * as i0 from "@angular/core";
import * as i1 from "../../providers/nav-controller";
import * as i2 from "./ion-router-outlet";
// eslint-disable-next-line @angular-eslint/component-class-suffix
export class IonTabs {
    constructor(navCtrl) {
        this.navCtrl = navCtrl;
        this.ionTabsWillChange = new EventEmitter();
        this.ionTabsDidChange = new EventEmitter();
    }
    /**
     * @internal
     */
    onPageSelected(detail) {
        const stackId = detail.enteringView.stackId;
        if (detail.tabSwitch && stackId !== undefined) {
            this.ionTabsWillChange.emit({ tab: stackId });
            if (this.tabBar) {
                this.tabBar.selectedTab = stackId;
            }
            this.ionTabsDidChange.emit({ tab: stackId });
        }
    }
    /**
     * When a tab button is clicked, there are several scenarios:
     * 1. If the selected tab is currently active (the tab button has been clicked
     *    again), then it should go to the root view for that tab.
     *
     *   a. Get the saved root view from the router outlet. If the saved root view
     *      matches the tabRootUrl, set the route view to this view including the
     *      navigation extras.
     *   b. If the saved root view from the router outlet does
     *      not match, navigate to the tabRootUrl. No navigation extras are
     *      included.
     *
     * 2. If the current tab tab is not currently selected, get the last route
     *    view from the router outlet.
     *
     *   a. If the last route view exists, navigate to that view including any
     *      navigation extras
     *   b. If the last route view doesn't exist, then navigate
     *      to the default tabRootUrl
     */
    select(tabOrEvent) {
        const isTabString = typeof tabOrEvent === 'string';
        const tab = isTabString ? tabOrEvent : tabOrEvent.detail.tab;
        const alreadySelected = this.outlet.getActiveStackId() === tab;
        const tabRootUrl = `${this.outlet.tabsPrefix}/${tab}`;
        /**
         * If this is a nested tab, prevent the event
         * from bubbling otherwise the outer tabs
         * will respond to this event too, causing
         * the app to get directed to the wrong place.
         */
        if (!isTabString) {
            tabOrEvent.stopPropagation();
        }
        if (alreadySelected) {
            const activeStackId = this.outlet.getActiveStackId();
            const activeView = this.outlet.getLastRouteView(activeStackId);
            // If on root tab, do not navigate to root tab again
            if ((activeView === null || activeView === void 0 ? void 0 : activeView.url) === tabRootUrl) {
                return;
            }
            const rootView = this.outlet.getRootView(tab);
            const navigationExtras = rootView && tabRootUrl === rootView.url && rootView.savedExtras;
            return this.navCtrl.navigateRoot(tabRootUrl, Object.assign(Object.assign({}, navigationExtras), { animated: true, animationDirection: 'back' }));
        }
        else {
            const lastRoute = this.outlet.getLastRouteView(tab);
            /**
             * If there is a lastRoute, goto that, otherwise goto the fallback url of the
             * selected tab
             */
            const url = (lastRoute === null || lastRoute === void 0 ? void 0 : lastRoute.url) || tabRootUrl;
            const navigationExtras = lastRoute === null || lastRoute === void 0 ? void 0 : lastRoute.savedExtras;
            return this.navCtrl.navigateRoot(url, Object.assign(Object.assign({}, navigationExtras), { animated: true, animationDirection: 'back' }));
        }
    }
    getSelected() {
        return this.outlet.getActiveStackId();
    }
}
/** @nocollapse */ IonTabs.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonTabs, deps: [{ token: i1.NavController }], target: i0.ɵɵFactoryTarget.Component });
/** @nocollapse */ IonTabs.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "12.0.0", version: "12.2.10", type: IonTabs, selector: "ion-tabs", inputs: { environmentInjector: "environmentInjector" }, outputs: { ionTabsWillChange: "ionTabsWillChange", ionTabsDidChange: "ionTabsDidChange" }, host: { listeners: { "ionTabButtonClick": "select($event)" } }, queries: [{ propertyName: "tabBar", first: true, predicate: IonTabBar, descendants: true }], viewQueries: [{ propertyName: "outlet", first: true, predicate: ["outlet"], descendants: true, read: IonRouterOutlet }], ngImport: i0, template: ` <ng-content select="[slot=top]"></ng-content>
    <div class="tabs-inner">
      <ion-router-outlet
        #outlet
        tabs="true"
        [environmentInjector]="environmentInjector"
        (stackEvents)="onPageSelected($event)"
      ></ion-router-outlet>
    </div>
    <ng-content></ng-content>`, isInline: true, styles: ["\n      :host {\n        display: flex;\n        position: absolute;\n        top: 0;\n        left: 0;\n        right: 0;\n        bottom: 0;\n\n        flex-direction: column;\n\n        width: 100%;\n        height: 100%;\n\n        contain: layout size style;\n        z-index: $z-index-page-container;\n      }\n      .tabs-inner {\n        position: relative;\n\n        flex: 1;\n\n        contain: layout size style;\n      }\n    "], directives: [{ type: i2.IonRouterOutlet, selector: "ion-router-outlet", inputs: ["animated", "animation", "mode", "swipeGesture", "environmentInjector"], outputs: ["stackEvents", "activate", "deactivate"], exportAs: ["outlet"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonTabs, decorators: [{
            type: Component,
            args: [{
                    selector: 'ion-tabs',
                    template: ` <ng-content select="[slot=top]"></ng-content>
    <div class="tabs-inner">
      <ion-router-outlet
        #outlet
        tabs="true"
        [environmentInjector]="environmentInjector"
        (stackEvents)="onPageSelected($event)"
      ></ion-router-outlet>
    </div>
    <ng-content></ng-content>`,
                    styles: [
                        `
      :host {
        display: flex;
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;

        flex-direction: column;

        width: 100%;
        height: 100%;

        contain: layout size style;
        z-index: $z-index-page-container;
      }
      .tabs-inner {
        position: relative;

        flex: 1;

        contain: layout size style;
      }
    `,
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i1.NavController }]; }, propDecorators: { outlet: [{
                type: ViewChild,
                args: ['outlet', { read: IonRouterOutlet, static: false }]
            }], tabBar: [{
                type: ContentChild,
                args: [IonTabBar, { static: false }]
            }], environmentInjector: [{
                type: Input
            }], ionTabsWillChange: [{
                type: Output
            }], ionTabsDidChange: [{
                type: Output
            }], select: [{
                type: HostListener,
                args: ['ionTabButtonClick', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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