import { Directive, HostListener, Input, Optional } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "./ion-router-outlet";
import * as i2 from "../../providers/nav-controller";
import * as i3 from "../../providers/config";
export class IonBackButtonDelegateDirective {
    constructor(routerOutlet, navCtrl, config) {
        this.routerOutlet = routerOutlet;
        this.navCtrl = navCtrl;
        this.config = config;
    }
    /**
     * @internal
     */
    onClick(ev) {
        var _a;
        const defaultHref = this.defaultHref || this.config.get('backButtonDefaultHref');
        if ((_a = this.routerOutlet) === null || _a === void 0 ? void 0 : _a.canGoBack()) {
            this.navCtrl.setDirection('back', undefined, undefined, this.routerAnimation);
            this.routerOutlet.pop();
            ev.preventDefault();
        }
        else if (defaultHref != null) {
            this.navCtrl.navigateBack(defaultHref, { animation: this.routerAnimation });
            ev.preventDefault();
        }
    }
}
/** @nocollapse */ IonBackButtonDelegateDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonBackButtonDelegateDirective, deps: [{ token: i1.IonRouterOutlet, optional: true }, { token: i2.NavController }, { token: i3.Config }], target: i0.ɵɵFactoryTarget.Directive });
/** @nocollapse */ IonBackButtonDelegateDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "12.0.0", version: "12.2.10", type: IonBackButtonDelegateDirective, selector: "ion-back-button", inputs: { defaultHref: "defaultHref", routerAnimation: "routerAnimation" }, host: { listeners: { "click": "onClick($event)" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "12.2.10", ngImport: i0, type: IonBackButtonDelegateDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: 'ion-back-button',
                }]
        }], ctorParameters: function () { return [{ type: i1.IonRouterOutlet, decorators: [{
                    type: Optional
                }] }, { type: i2.NavController }, { type: i3.Config }]; }, propDecorators: { defaultHref: [{
                type: Input
            }], routerAnimation: [{
                type: Input
            }], onClick: [{
                type: HostListener,
                args: ['click', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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