import { setupConfig } from '@ionic/core';
import { applyPolyfills, defineCustomElements } from '@ionic/core/loader';
import { raf } from './util/util';
// TODO(FW-2827): types
export const appInitialize = (config, doc, zone) => {
    return () => {
        const win = doc.defaultView;
        if (win && typeof window !== 'undefined') {
            setupConfig(Object.assign(Object.assign({}, config), { _zoneGate: (h) => zone.run(h) }));
            const aelFn = '__zone_symbol__addEventListener' in doc.body ? '__zone_symbol__addEventListener' : 'addEventListener';
            return applyPolyfills().then(() => {
                return defineCustomElements(win, {
                    exclude: ['ion-tabs', 'ion-tab'],
                    syncQueue: true,
                    raf,
                    jmp: (h) => zone.runOutsideAngular(h),
                    ael(elm, eventName, cb, opts) {
                        elm[aelFn](eventName, cb, opts);
                    },
                    rel(elm, eventName, cb, opts) {
                        elm.removeEventListener(eventName, cb, opts);
                    },
                });
            });
        }
    };
};
//# sourceMappingURL=data:application/json;base64,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