import { Location } from '@angular/common';
import { ComponentFactoryResolver, ComponentRef, ElementRef, NgZone, OnDestroy, OnInit, ViewContainerRef, EventEmitter } from '@angular/core';
import { OutletContext, Router, ActivatedRoute, ChildrenOutletContexts } from '@angular/router';
import { EnvironmentInjector } from '../../di/r3_injector';
import { AnimationBuilder } from '../../ionic-core';
import { Config } from '../../providers/config';
import { NavController } from '../../providers/nav-controller';
import { RouteView } from './stack-utils';
import * as i0 from "@angular/core";
export declare class IonRouterOutlet implements OnDestroy, OnInit {
    private parentContexts;
    private location;
    private config;
    private navCtrl;
    private componentFactoryResolver;
    readonly parentOutlet?: IonRouterOutlet | undefined;
    nativeEl: HTMLIonRouterOutletElement;
    private activated;
    activatedView: RouteView | null;
    private _activatedRoute;
    private _swipeGesture?;
    private name;
    private stackCtrl;
    private proxyMap;
    private currentActivatedRoute$;
    tabsPrefix: string | undefined;
    /**
     * @experimental
     *
     * The `EnvironmentInjector` provider instance from the parent component.
     * Required for using standalone components with `ion-router-outlet`.
     *
     * Will be deprecated and removed when Angular 13 support is dropped.
     */
    environmentInjector: EnvironmentInjector;
    stackEvents: EventEmitter<any>;
    activateEvents: EventEmitter<any>;
    deactivateEvents: EventEmitter<any>;
    set animation(animation: AnimationBuilder);
    set animated(animated: boolean);
    set swipeGesture(swipe: boolean);
    constructor(parentContexts: ChildrenOutletContexts, location: ViewContainerRef, name: string, tabs: string, config: Config, navCtrl: NavController, componentFactoryResolver: ComponentFactoryResolver, commonLocation: Location, elementRef: ElementRef, router: Router, zone: NgZone, activatedRoute: ActivatedRoute, parentOutlet?: IonRouterOutlet | undefined);
    ngOnDestroy(): void;
    getContext(): OutletContext | null;
    ngOnInit(): void;
    get isActivated(): boolean;
    get component(): Record<string, unknown>;
    get activatedRoute(): ActivatedRoute;
    get activatedRouteData(): any;
    /**
     * Called when the `RouteReuseStrategy` instructs to detach the subtree
     */
    detach(): ComponentRef<any>;
    /**
     * Called when the `RouteReuseStrategy` instructs to re-attach a previously detached subtree
     */
    attach(_ref: ComponentRef<any>, _activatedRoute: ActivatedRoute): void;
    deactivate(): void;
    activateWith(activatedRoute: ActivatedRoute, resolverOrInjector?: ComponentFactoryResolver | EnvironmentInjector | null): void;
    /**
     * Returns `true` if there are pages in the stack to go back.
     */
    canGoBack(deep?: number, stackId?: string): boolean;
    /**
     * Resolves to `true` if it the outlet was able to sucessfully pop the last N pages.
     */
    pop(deep?: number, stackId?: string): Promise<boolean>;
    /**
     * Returns the URL of the active page of each stack.
     */
    getLastUrl(stackId?: string): string | undefined;
    /**
     * Returns the RouteView of the active page of each stack.
     * @internal
     */
    getLastRouteView(stackId?: string): RouteView | undefined;
    /**
     * Returns the root view in the tab stack.
     * @internal
     */
    getRootView(stackId?: string): RouteView | undefined;
    /**
     * Returns the active stack ID. In the context of ion-tabs, it means the active tab.
     */
    getActiveStackId(): string | undefined;
    /**
     * Since the activated route can change over the life time of a component in an ion router outlet, we create
     * a proxy so that we can update the values over time as a user navigates back to components already in the stack.
     */
    private createActivatedRouteProxy;
    /**
     * Create a wrapped observable that will switch to the latest activated route matched by the given component
     */
    private proxyObservable;
    /**
     * Updates the activated route proxy for the given component to the new incoming router state
     */
    private updateActivatedRouteProxy;
    static ɵfac: i0.ɵɵFactoryDeclaration<IonRouterOutlet, [null, null, { attribute: "name"; }, { attribute: "tabs"; optional: true; }, null, null, { optional: true; }, null, null, null, null, null, { optional: true; skipSelf: true; }]>;
    static ɵdir: i0.ɵɵDirectiveDeclaration<IonRouterOutlet, "ion-router-outlet", ["outlet"], { "animated": "animated"; "animation": "animation"; "mode": "mode"; "swipeGesture": "swipeGesture"; "environmentInjector": "environmentInjector"; }, { "stackEvents": "stackEvents"; "activateEvents": "activate"; "deactivateEvents": "deactivate"; }, never>;
}
