"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateToV15 = void 0;
const target_version_1 = require("../update-tool/target-version");
const upgrade_data_1 = require("./upgrade-data");
const devkit_migration_rule_1 = require("./devkit-migration-rule");
const cdkMigrations = [];
/** Entry point for the migration schematics with target of Angular CDK 15.0.0 */
function updateToV15() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V15, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV15 = updateToV15;
/** Function that will be called when the migration completed. */
function onMigrationComplete(context, targetVersion, hasFailures) {
    context.logger.info('');
    context.logger.info(`  ✓  Updated Angular CDK to ${targetVersion}`);
    context.logger.info('');
    if (hasFailures) {
        context.logger.warn('  ⚠  Some issues were detected but could not be fixed automatically. Please check the ' +
            'output above and fix these issues manually.');
    }
}
//# sourceMappingURL=data:application/json;base64,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