/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** An enum of non-text keys that can be used with the `sendKeys` method. */
// NOTE: This is a separate enum from `@angular/cdk/keycodes` because we don't necessarily want to
// support every possible keyCode. We also can't rely on Protractor's `Key` because we don't want a
// dependency on any particular testing framework here. Instead we'll just maintain this supported
// list of keys and let individual concrete `HarnessEnvironment` classes map them to whatever key
// representation is used in its respective testing framework.
// tslint:disable-next-line:prefer-const-enum Seems like this causes some issues with System.js
export var TestKey;
(function (TestKey) {
    TestKey[TestKey["BACKSPACE"] = 0] = "BACKSPACE";
    TestKey[TestKey["TAB"] = 1] = "TAB";
    TestKey[TestKey["ENTER"] = 2] = "ENTER";
    TestKey[TestKey["SHIFT"] = 3] = "SHIFT";
    TestKey[TestKey["CONTROL"] = 4] = "CONTROL";
    TestKey[TestKey["ALT"] = 5] = "ALT";
    TestKey[TestKey["ESCAPE"] = 6] = "ESCAPE";
    TestKey[TestKey["PAGE_UP"] = 7] = "PAGE_UP";
    TestKey[TestKey["PAGE_DOWN"] = 8] = "PAGE_DOWN";
    TestKey[TestKey["END"] = 9] = "END";
    TestKey[TestKey["HOME"] = 10] = "HOME";
    TestKey[TestKey["LEFT_ARROW"] = 11] = "LEFT_ARROW";
    TestKey[TestKey["UP_ARROW"] = 12] = "UP_ARROW";
    TestKey[TestKey["RIGHT_ARROW"] = 13] = "RIGHT_ARROW";
    TestKey[TestKey["DOWN_ARROW"] = 14] = "DOWN_ARROW";
    TestKey[TestKey["INSERT"] = 15] = "INSERT";
    TestKey[TestKey["DELETE"] = 16] = "DELETE";
    TestKey[TestKey["F1"] = 17] = "F1";
    TestKey[TestKey["F2"] = 18] = "F2";
    TestKey[TestKey["F3"] = 19] = "F3";
    TestKey[TestKey["F4"] = 20] = "F4";
    TestKey[TestKey["F5"] = 21] = "F5";
    TestKey[TestKey["F6"] = 22] = "F6";
    TestKey[TestKey["F7"] = 23] = "F7";
    TestKey[TestKey["F8"] = 24] = "F8";
    TestKey[TestKey["F9"] = 25] = "F9";
    TestKey[TestKey["F10"] = 26] = "F10";
    TestKey[TestKey["F11"] = 27] = "F11";
    TestKey[TestKey["F12"] = 28] = "F12";
    TestKey[TestKey["META"] = 29] = "META";
})(TestKey || (TestKey = {}));
//# sourceMappingURL=data:application/json;base64,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