"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDirectory = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
function createDirectory(directoryPath) {
    const parentPath = (0, path_1.dirname)(directoryPath);
    if (!directoryExists(parentPath)) {
        createDirectory(parentPath);
    }
    if (!directoryExists(directoryPath)) {
        (0, fs_1.mkdirSync)(directoryPath);
    }
}
exports.createDirectory = createDirectory;
function directoryExists(name) {
    try {
        return (0, fs_1.statSync)(name).isDirectory();
    }
    catch (_a) {
        return false;
    }
}
