"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const rxjs_1 = require("rxjs");
const operators_1 = require("rxjs/operators");
const src_1 = require("../src");
exports.default = (0, src_1.createBuilder)((options, context) => {
    const allRuns = [];
    context.reportProgress(0, (options.targets ? options.targets.length : 0) +
        (options.builders ? options.builders.length : 0));
    if (options.targets) {
        allRuns.push(...options.targets.map(({ target: targetStr, overrides }) => {
            const [project, target, configuration] = targetStr.split(/:/g, 3);
            return () => context.scheduleTarget({ project, target, configuration }, overrides || {});
        }));
    }
    if (options.builders) {
        allRuns.push(...options.builders.map(({ builder, options }) => {
            return () => context.scheduleBuilder(builder, options || {});
        }));
    }
    let stop = null;
    let i = 0;
    context.reportProgress(i++, allRuns.length);
    return (0, rxjs_1.from)(allRuns).pipe((0, operators_1.concatMap)((fn) => stop
        ? (0, rxjs_1.of)(null)
        : (0, rxjs_1.from)(fn()).pipe((0, operators_1.switchMap)((run) => (run === null ? (0, rxjs_1.of)(null) : run.output.pipe((0, operators_1.first)()))))), (0, operators_1.map)((output) => {
        context.reportProgress(i++, allRuns.length);
        if (output === null || stop !== null) {
            return stop || { success: false };
        }
        else if (output.success === false) {
            return (stop = output);
        }
        else {
            return output;
        }
    }), (0, operators_1.last)());
});
//# sourceMappingURL=data:application/json;base64,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