(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["default-src_app_components_components_module_ts"],{

/***/ 78555:
/*!***********************************************************************!*\
  !*** ./src/app/components/add-collection/add-collection.component.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddCollectionComponent": () => (/* binding */ AddCollectionComponent)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _add_collection_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./add-collection.component.html?ngResource */ 96917);
/* harmony import */ var _add_collection_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./add-collection.component.scss?ngResource */ 38319);
/* harmony import */ var _add_collection_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_add_collection_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/storage/storage.service */ 86578);
/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! uuid */ 62535);

var _class;







let AddCollectionComponent = (_class = class AddCollectionComponent {
  constructor(modalCtrl, storageService, loadingCtrl, toastCtrl) {
    this.modalCtrl = modalCtrl;
    this.storageService = storageService;
    this.loadingCtrl = loadingCtrl;
    this.toastCtrl = toastCtrl;
  }
  ngOnInit() {}
  ionViewWillEnter() {
    if (this.collection) {
      this.collectionName = this.collection.name;
      this.collectionDescription = this.collection.description;
    }
  }
  createCollection() {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this.collectionName) {
        const loading = yield _this.loadingCtrl.create({
          message: 'Creating collection...'
        });
        yield loading.present();
        // Get all collections to get the index
        const collections = yield _this.storageService.getCollections();
        // Create collection
        const collection = {
          id: (0,uuid__WEBPACK_IMPORTED_MODULE_4__["default"])(),
          name: _this.collectionName,
          description: _this.collectionDescription,
          feedList: [],
          index: collections.length
        };
        yield _this.storageService.addCollection(collection);
        yield loading.dismiss();
        // Close modal and return collection
        _this.modalCtrl.dismiss({
          collection: collection
        });
      } else {
        _this.showToast('Collection name cannot be empty');
      }
    })();
  }
  saveCollection() {
    var _this2 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      if (_this2.collectionName) {
        const loading = yield _this2.loadingCtrl.create({
          message: 'Saving collection...'
        });
        yield loading.present();
        // Update collection
        _this2.collection.name = _this2.collectionName;
        _this2.collection.description = _this2.collectionDescription;
        yield _this2.storageService.updateCollection(_this2.collection);
        yield loading.dismiss();
        // Close modal and return collection
        _this2.modalCtrl.dismiss({
          collection: _this2.collection
        });
      } else {
        _this2.showToast('Collection name cannot be empty');
      }
    })();
  }
  showToast(message) {
    var _this3 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const toast = yield _this3.toastCtrl.create({
        message: message,
        duration: 2000,
        position: 'bottom',
        buttons: [{
          text: 'OK',
          role: 'cancel'
        }]
      });
      yield toast.present();
    })();
  }
}, _class.ctorParameters = () => [{
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ModalController
}, {
  type: src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__.StorageService
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.LoadingController
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ToastController
}], _class.propDecorators = {
  collection: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
  }]
}, _class);
AddCollectionComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-add-collection',
  template: _add_collection_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_add_collection_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AddCollectionComponent);


/***/ }),

/***/ 21843:
/*!***********************************************************************!*\
  !*** ./src/app/components/add-feed-modal/add-feed-modal.component.ts ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddFeedModalComponent": () => (/* binding */ AddFeedModalComponent)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _add_feed_modal_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./add-feed-modal.component.html?ngResource */ 13157);
/* harmony import */ var _add_feed_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./add-feed-modal.component.scss?ngResource */ 60114);
/* harmony import */ var _add_feed_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_add_feed_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/storage/storage.service */ 86578);
/* harmony import */ var _add_collection_add_collection_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../add-collection/add-collection.component */ 78555);

var _class;







let AddFeedModalComponent = (_class = class AddFeedModalComponent {
  constructor(storageService, modalCtrl, toastCtrl) {
    this.storageService = storageService;
    this.modalCtrl = modalCtrl;
    this.toastCtrl = toastCtrl;
  }
  ionViewWillEnter() {
    this.loadCollections();
  }
  loadCollections() {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.collections = yield _this.storageService.getCollections();
    })();
  }
  addFeedToCollection(collection) {
    var _this2 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Check if feed is already in collection
      if (!collection.feedList.some(feed => feed.feedId === _this2.feedObject.feedId)) {
        _this2.feedObject.index = collection.feedList.length;
        collection.feedList.push(_this2.feedObject);
      }
      // Save collection
      yield _this2.storageService.updateCollection(collection);
      // Show toast
      _this2.showToast('Feed added to collection');
      // Close modal and return collection
      _this2.modalCtrl.dismiss({
        collection: collection
      });
    })();
  }
  createCollection() {
    var _this3 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const modal = yield _this3.modalCtrl.create({
        component: _add_collection_add_collection_component__WEBPACK_IMPORTED_MODULE_4__.AddCollectionComponent,
        cssClass: 'add-collection-modal'
      });
      modal.onDidDismiss().then(data => {
        console.log(data);
        if (data.data.collection) {
          _this3.collections.push(data.data.collection);
        }
      });
      yield modal.present();
    })();
  }
  showToast(message) {
    var _this4 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const toast = yield _this4.toastCtrl.create({
        message: message,
        duration: 2000,
        position: 'bottom',
        buttons: [{
          text: 'OK',
          role: 'cancel'
        }]
      });
      yield toast.present();
    })();
  }
}, _class.ctorParameters = () => [{
  type: src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__.StorageService
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ModalController
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ToastController
}], _class.propDecorators = {
  feedObject: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
  }]
}, _class);
AddFeedModalComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-add-feed-modal',
  template: _add_feed_modal_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_add_feed_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], AddFeedModalComponent);


/***/ }),

/***/ 13954:
/*!***************************************************************************************!*\
  !*** ./src/app/components/article-settings-modal/article-settings-modal.component.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ArticleSettingsModalComponent": () => (/* binding */ ArticleSettingsModalComponent)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _article_settings_modal_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./article-settings-modal.component.html?ngResource */ 56939);
/* harmony import */ var _article_settings_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./article-settings-modal.component.scss?ngResource */ 49707);
/* harmony import */ var _article_settings_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_article_settings_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/storage/storage.service */ 86578);

var _class;





let ArticleSettingsModalComponent = (_class = class ArticleSettingsModalComponent {
  constructor(storageService) {
    this.storageService = storageService;
  }
  ionViewWillEnter() {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this.settings = yield _this.storageService.getSettings();
      _this.articleSettings = _this.settings.articleSettings;
      if (!_this.articleSettings) _this.articleSettings = {
        fontSize: 12,
        brightness: 0,
        fontFamily: 'sans',
        background: 'default',
        useSystemBrowser: false
      };
    })();
  }
  setArticleTheme(theme) {
    var _this2 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this2.articleSettings.background = theme;
      _this2.settings.articleSettings = _this2.articleSettings;
      yield _this2.storageService.setSettings(_this2.settings);
    })();
  }
  saveSettings() {
    var _this3 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      _this3.settings.articleSettings = _this3.articleSettings;
      yield _this3.storageService.setSettings(_this3.settings);
    })();
  }
}, _class.ctorParameters = () => [{
  type: src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__.StorageService
}], _class);
ArticleSettingsModalComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_4__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Component)({
  selector: 'app-article-settings-modal',
  template: _article_settings_modal_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_article_settings_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], ArticleSettingsModalComponent);


/***/ }),

/***/ 97014:
/*!***************************************************************************************!*\
  !*** ./src/app/components/collection-feeds-modal/collection-feeds-modal.component.ts ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CollectionFeedsModalComponent": () => (/* binding */ CollectionFeedsModalComponent)
/* harmony export */ });
/* harmony import */ var _home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./node_modules/@babel/runtime/helpers/esm/asyncToGenerator.js */ 71670);
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _collection_feeds_modal_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./collection-feeds-modal.component.html?ngResource */ 67668);
/* harmony import */ var _collection_feeds_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./collection-feeds-modal.component.scss?ngResource */ 48467);
/* harmony import */ var _collection_feeds_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_collection_feeds_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 60124);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! src/app/services/storage/storage.service */ 86578);

var _class;







let CollectionFeedsModalComponent = (_class = class CollectionFeedsModalComponent {
  constructor(modalCtrl, storageService, alertCtrl, router) {
    this.modalCtrl = modalCtrl;
    this.storageService = storageService;
    this.alertCtrl = alertCtrl;
    this.router = router;
    this.reorder = false;
  }
  close() {
    this.modalCtrl.dismiss();
  }
  confirmDeleteFeed(feed) {
    var _this = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      const alert = yield _this.alertCtrl.create({
        header: 'Delete feed',
        message: `Are you sure you want to delete the feed "${feed.title}"?`,
        buttons: [{
          text: 'Cancel',
          role: 'cancel'
        }, {
          text: 'Delete',
          cssClass: 'alert-danger-button',
          handler: () => {
            _this.deleteFeed(feed);
          }
        }]
      });
      yield alert.present();
    })();
  }
  deleteFeed(feed) {
    var _this2 = this;
    return (0,_home_vagrant_build_com_aerotoad_thud_node_modules_babel_runtime_helpers_esm_asyncToGenerator_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function* () {
      // Cleanup feed cache
      yield _this2.storageService.deleteCacheByFeedId(feed.feedId);
      // Remove feed from collection
      _this2.collection.feedList = _this2.collection.feedList.filter(currentFeed => {
        if (currentFeed.feedId !== feed.feedId) return currentFeed;
      });
      // Fix feeds indexes
      _this2.collection.feedList = _this2.collection.feedList.map((currentFeed, index) => {
        currentFeed.index = index;
        return currentFeed;
      });
      // Update collection
      _this2.storageService.updateCollection(_this2.collection);
    })();
  }
  startReorder() {
    this.reorder = true;
  }
  endReorder() {
    this.reorder = false;
    this.collection.feedList = this.collection.feedList.map((feed, currentIndex) => {
      feed.index = currentIndex;
      return feed;
    });
    this.storageService.updateCollection(this.collection);
  }
  drop(event) {
    const itemMove = this.collection.feedList.splice(event.detail.from, 1)[0];
    this.collection.feedList.splice(event.detail.to, 0, itemMove);
    event.target.complete();
  }
  openSearch() {
    this.router.navigate(['/main/search'], {
      replaceUrl: true
    });
    this.modalCtrl.dismiss();
  }
}, _class.ctorParameters = () => [{
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ModalController
}, {
  type: src_app_services_storage_storage_service__WEBPACK_IMPORTED_MODULE_3__.StorageService
}, {
  type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.AlertController
}, {
  type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.Router
}], _class.propDecorators = {
  collection: [{
    type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.Input
  }]
}, _class);
CollectionFeedsModalComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_7__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
  selector: 'app-collection-feeds-modal',
  template: _collection_feeds_modal_component_html_ngResource__WEBPACK_IMPORTED_MODULE_1__,
  styles: [(_collection_feeds_modal_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_2___default())]
})], CollectionFeedsModalComponent);


/***/ }),

/***/ 45642:
/*!*************************************************!*\
  !*** ./src/app/components/components.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ComponentsModule": () => (/* binding */ ComponentsModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/common */ 94666);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/forms */ 2508);
/* harmony import */ var _add_feed_modal_add_feed_modal_component__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./add-feed-modal/add-feed-modal.component */ 21843);
/* harmony import */ var _add_collection_add_collection_component__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./add-collection/add-collection.component */ 78555);
/* harmony import */ var _article_settings_modal_article_settings_modal_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./article-settings-modal/article-settings-modal.component */ 13954);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _collection_feeds_modal_collection_feeds_modal_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./collection-feeds-modal/collection-feeds-modal.component */ 97014);
/* harmony import */ var _pipes_pipes_module__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../pipes/pipes.module */ 35503);










let ComponentsModule = class ComponentsModule {};
ComponentsModule = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_7__.CommonModule, _angular_forms__WEBPACK_IMPORTED_MODULE_8__.FormsModule, _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.IonicModule, _pipes_pipes_module__WEBPACK_IMPORTED_MODULE_4__.PipesModule],
  declarations: [_add_feed_modal_add_feed_modal_component__WEBPACK_IMPORTED_MODULE_0__.AddFeedModalComponent, _add_collection_add_collection_component__WEBPACK_IMPORTED_MODULE_1__.AddCollectionComponent, _article_settings_modal_article_settings_modal_component__WEBPACK_IMPORTED_MODULE_2__.ArticleSettingsModalComponent, _collection_feeds_modal_collection_feeds_modal_component__WEBPACK_IMPORTED_MODULE_3__.CollectionFeedsModalComponent]
})], ComponentsModule);


/***/ }),

/***/ 88:
/*!***********************************************************!*\
  !*** ./src/app/pipes/epoch-timeago/epoch-timeago.pipe.ts ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "EpochTimeagoPipe": () => (/* binding */ EpochTimeagoPipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! moment */ 56908);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_0__);



let EpochTimeagoPipe = class EpochTimeagoPipe {
  transform(value) {
    return moment__WEBPACK_IMPORTED_MODULE_0__(value).fromNow();
  }
};
EpochTimeagoPipe = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.Pipe)({
  name: 'epochTimeago'
})], EpochTimeagoPipe);


/***/ }),

/***/ 75994:
/*!*************************************************!*\
  !*** ./src/app/pipes/in-array/in-array.pipe.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "InArrayPipe": () => (/* binding */ InArrayPipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 22560);


let InArrayPipe = class InArrayPipe {
  transform(value, array) {
    if (array) {
      if (array.indexOf(value) > -1) {
        return true;
      }
      return false;
    } else {
      return false;
    }
  }
};
InArrayPipe = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Pipe)({
  name: 'inArray'
})], InArrayPipe);


/***/ }),

/***/ 39439:
/*!*************************************************************!*\
  !*** ./src/app/pipes/order-by-index/order-by-index.pipe.ts ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OrderByIndexPipe": () => (/* binding */ OrderByIndexPipe)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 22560);


let OrderByIndexPipe = class OrderByIndexPipe {
  transform(array) {
    if (array) {
      return array.sort((a, b) => a.index - b.index);
    } else {
      return [];
    }
  }
};
OrderByIndexPipe = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.Pipe)({
  name: 'orderByIndex'
})], OrderByIndexPipe);


/***/ }),

/***/ 35503:
/*!***************************************!*\
  !*** ./src/app/pipes/pipes.module.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PipesModule": () => (/* binding */ PipesModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 34929);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 22560);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 94666);
/* harmony import */ var _in_array_in_array_pipe__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./in-array/in-array.pipe */ 75994);
/* harmony import */ var _epoch_timeago_epoch_timeago_pipe__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./epoch-timeago/epoch-timeago.pipe */ 88);
/* harmony import */ var _order_by_index_order_by_index_pipe__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./order-by-index/order-by-index.pipe */ 39439);






let PipesModule = class PipesModule {};
PipesModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([(0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
  imports: [_angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule],
  declarations: [_in_array_in_array_pipe__WEBPACK_IMPORTED_MODULE_0__.InArrayPipe, _epoch_timeago_epoch_timeago_pipe__WEBPACK_IMPORTED_MODULE_1__.EpochTimeagoPipe, _order_by_index_order_by_index_pipe__WEBPACK_IMPORTED_MODULE_2__.OrderByIndexPipe],
  exports: [_in_array_in_array_pipe__WEBPACK_IMPORTED_MODULE_0__.InArrayPipe, _epoch_timeago_epoch_timeago_pipe__WEBPACK_IMPORTED_MODULE_1__.EpochTimeagoPipe, _order_by_index_order_by_index_pipe__WEBPACK_IMPORTED_MODULE_2__.OrderByIndexPipe]
})], PipesModule);


/***/ }),

/***/ 38319:
/*!************************************************************************************!*\
  !*** ./src/app/components/add-collection/add-collection.component.scss?ngResource ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, "ion-content::part(scroll) {\n  height: 100%;\n}\n\n.fix-bottom-button {\n  margin-bottom: -1px;\n}", "",{"version":3,"sources":["webpack://./src/app/components/add-collection/add-collection.component.scss"],"names":[],"mappings":"AACE;EACE,YAAA;AAAJ;;AAIA;EACE,mBAAA;AADF","sourcesContent":["ion-content{\n  &::part(scroll) {\n    height: 100%;\n  }\n}\n\n.fix-bottom-button {\n  margin-bottom: -1px;\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 60114:
/*!************************************************************************************!*\
  !*** ./src/app/components/add-feed-modal/add-feed-modal.component.scss?ngResource ***!
  \************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, "", "",{"version":3,"sources":[],"names":[],"mappings":"","sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 49707:
/*!****************************************************************************************************!*\
  !*** ./src/app/components/article-settings-modal/article-settings-modal.component.scss?ngResource ***!
  \****************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".article-color-palette.default {\n  background: #f9f9f9 !important;\n}\n.article-color-palette.lightbrown {\n  background: #d8cdbd !important;\n}\n.article-color-palette.lightgrey {\n  background: #bebebe !important;\n}\n.article-color-palette.mediumgrey {\n  background: #838383 !important;\n}\n.article-color-palette.darkgrey {\n  background: #303030 !important;\n}", "",{"version":3,"sources":["webpack://./src/app/components/article-settings-modal/article-settings-modal.component.scss"],"names":[],"mappings":"AACE;EACE,8BAAA;AAAJ;AAEE;EACE,8BAAA;AAAJ;AAEE;EACE,8BAAA;AAAJ;AAEE;EACE,8BAAA;AAAJ;AAEE;EACE,8BAAA;AAAJ","sourcesContent":[".article-color-palette {\n  &.default {\n    background: #f9f9f9 !important;\n  }\n  &.lightbrown {\n    background: #d8cdbd !important;\n  }\n  &.lightgrey {\n    background: #bebebe !important;\n  }\n  &.mediumgrey {\n    background: #838383 !important;\n  }\n  &.darkgrey {\n    background: #303030 !important;\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 48467:
/*!****************************************************************************************************!*\
  !*** ./src/app/components/collection-feeds-modal/collection-feeds-modal.component.scss?ngResource ***!
  \****************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_SOURCEMAP_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/sourceMaps.js */ 49579);
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../../../../node_modules/css-loader/dist/runtime/api.js */ 60931);
var ___CSS_LOADER_EXPORT___ = ___CSS_LOADER_API_IMPORT___(___CSS_LOADER_API_SOURCEMAP_IMPORT___);
// Module
___CSS_LOADER_EXPORT___.push([module.id, ".main-toolbar {\n  --background: var(--main-toolbar-background);\n}\n.main-toolbar ion-button {\n  color: var(--fixed-light);\n}", "",{"version":3,"sources":["webpack://./src/app/components/collection-feeds-modal/collection-feeds-modal.component.scss"],"names":[],"mappings":"AAAA;EACE,4CAAA;AACF;AAAE;EACE,yBAAA;AAEJ","sourcesContent":[".main-toolbar {\n  --background: var(--main-toolbar-background);\n  ion-button {\n    color: var(--fixed-light)\n  }\n}"],"sourceRoot":""}]);
// Exports
module.exports = ___CSS_LOADER_EXPORT___.toString();


/***/ }),

/***/ 96917:
/*!************************************************************************************!*\
  !*** ./src/app/components/add-collection/add-collection.component.html?ngResource ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header mode=\"ios\">\n  <ion-toolbar>\n    <ion-title>\n      <span *ngIf=\"!collection\">Create</span>\n      <span *ngIf=\"collection\">Edit</span>\n       collection\n    </ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <div class=\"relative w-full h-full\">\n    <div class=\"w-full h-16 px-5 pt-5\">\n      <input type=\"text\" class=\"bg-transparent w-full text-3xl font-semibold outline-none border-none\"\n        placeholder=\"Name your collection\" maxlength=\"25\" [(ngModel)]=\"collectionName\">\n    </div>\n    <div class=\"w-full h-fit my-2 pr-5 pl-1\">\n      <ion-item lines=\"none\">\n        <ion-label position=\"floating\">\n          <span class=\"text-gray-400\">Description</span>\n        </ion-label>\n        <ion-textarea class=\"text-base font-medium\" placeholder=\"Add a description\" maxlength=\"50\" [(ngModel)]=\"collectionDescription\" ngDefaultControl></ion-textarea>\n      </ion-item>\n    </div>\n    \n    <ion-button expand=\"full\" color=\"dark\" *ngIf=\"!collection\"\n      (click)=\"createCollection()\"\n      class=\"-mx-1 absolute bottom-0 left-0 right-0 h-14 normal-case fix-bottom-button\">\n      Create\n    </ion-button>\n    <ion-button expand=\"full\" color=\"dark\" *ngIf=\"collection\"\n      (click)=\"saveCollection()\"\n      class=\"-mx-1 absolute bottom-0 left-0 right-0 h-14 normal-case fix-bottom-button\">\n      Save\n    </ion-button>\n  </div>\n</ion-content>";

/***/ }),

/***/ 13157:
/*!************************************************************************************!*\
  !*** ./src/app/components/add-feed-modal/add-feed-modal.component.html?ngResource ***!
  \************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header mode=\"ios\">\n  <ion-toolbar class=\"h-12\">\n    <ion-title class=\"mt-1\">Add feed to collection</ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <ion-list-header mode=\"ios\" class=\"mt-2\">\n    Collections\n  </ion-list-header>\n\n  <div class=\"pt-1\" *ngIf=\"collections && collections.length > 0\">\n    <ion-list>\n      <ion-item *ngFor=\"let collection of collections\" lines=\"full\">\n        <ion-icon name=\"file-tray-full\" slot=\"start\"></ion-icon>\n        <ion-label>\n          <h2>{{ collection.name }}</h2>\n          <p>{{ collection.description }}</p>\n        </ion-label>\n        <ion-note slot=\"end\">\n          <ion-label>\n            <h2 class=\"!text-xs !font-bold\">{{collection.feedList.length}}/10</h2>\n            <p class=\"!text-xs\">Feeds</p>\n          </ion-label>\n        </ion-note>\n        <ion-button slot=\"end\" color=\"dark\" class=\"normal-case\" (click)=\"addFeedToCollection(collection)\" [disabled]=\"collection.feedList.length >= 10\">\n          <span class=\"py-1 px-3\">\n            Add\n          </span>\n        </ion-button>\n      </ion-item>\n    </ion-list>\n  </div>\n\n  <div class=\"mb-4 mt-8 px-6 text-center text-slate-600\" *ngIf=\"!collections || collections.length === 0\">\n    <h1 class=\"text-2xl font-semibold\">Oops!</h1>\n    <p class=\"text-base font-normal mb-5\">You don't have any collections</p>\n    <ion-button color=\"dark\" (click)=\"createCollection()\" class=\"normal-case\">\n      Create collection\n      <ion-icon name=\"add-circle\" slot=\"end\"></ion-icon>\n    </ion-button>\n  </div>\n</ion-content>\n";

/***/ }),

/***/ 56939:
/*!****************************************************************************************************!*\
  !*** ./src/app/components/article-settings-modal/article-settings-modal.component.html?ngResource ***!
  \****************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header mode=\"ios\">\n  <ion-toolbar class=\"h-12\"></ion-toolbar>\n</ion-header>\n\n<ion-content>\n  <div class=\"w-full\">\n    <ion-list>\n      <ion-item lines=\"none\">\n        <ion-icon name=\"color-palette-outline\" slot=\"start\"></ion-icon>\n        <ion-label>Background color</ion-label>\n      </ion-item>\n      <div class=\"w-full flex flex-row flex-nowrap mt-2\">\n        <div\n          class=\"article-color-palette default border-2 border-slate-100 w-1/5 aspect-square rounded-full mx-3 shadow-sm\"\n          [ngClass]=\"{'border-4 border-blue-500': articleSettings?.background === 'default' || !articleSettings?.background}\"\n          (click)=\"setArticleTheme('default')\"></div>\n  \n        <div\n          class=\"article-color-palette lightbrown border-2 border-slate-100 w-1/5 aspect-square rounded-full mx-3 shadow-sm\"\n          [ngClass]=\"{'border-4 border-blue-500': articleSettings?.background === 'lightbrown'}\"\n          (click)=\"setArticleTheme('lightbrown')\"></div>\n  \n        <div\n          class=\"article-color-palette lightgrey border-2 border-slate-100 w-1/5 aspect-square rounded-full mx-3 shadow-sm\"\n          [ngClass]=\"{'border-4 border-blue-500': articleSettings?.background === 'lightgrey'}\"\n          (click)=\"setArticleTheme('lightgrey')\"></div>\n  \n        <div\n          class=\"article-color-palette mediumgrey border-2 border-slate-100 w-1/5 aspect-square rounded-full mx-3 shadow-sm\"\n          [ngClass]=\"{'border-4 border-blue-500': articleSettings?.background === 'mediumgrey'}\"\n          (click)=\"setArticleTheme('mediumgrey')\"></div>\n  \n        <div\n          class=\"article-color-palette darkgrey border-2 border-slate-100 w-1/5 aspect-square rounded-full mx-3 shadow-sm\"\n          [ngClass]=\"{'border-4 border-blue-500': articleSettings?.background === 'darkgrey'}\"\n          (click)=\"setArticleTheme('darkgrey')\"></div>\n      </div>\n      <ion-item lines=\"full\"></ion-item>\n  \n      <ion-item lines=\"none\">\n        <ion-icon name=\"expand-outline\" slot=\"start\"></ion-icon>\n        <ion-label>\n          <h2>Font size</h2>\n        </ion-label>\n      </ion-item>\n      <ion-item lines=\"full\" *ngIf=\"articleSettings\">\n        <ion-range min=\"10\" max=\"15\" step=\"1\" snaps=\"true\" color=\"primary\" [pin]=\"true\" [debounce]=\"400\"\n          [(ngModel)]=\"articleSettings.fontSize\" (ionChange)=\"saveSettings()\">\n          <ion-label slot=\"start\">\n            <span class=\"text-xs font-bold\">A</span>\n          </ion-label>\n          <ion-label slot=\"end\">\n            <span class=\"text-2xl font-bold\">A</span>\n          </ion-label>\n        </ion-range>\n      </ion-item>\n  \n      <ion-item lines=\"none\">\n        <ion-icon slot=\"start\" name=\"text-outline\"></ion-icon>\n        <ion-label>Font family</ion-label>\n      </ion-item>\n      <div class=\"w-full px-3 py-2\" *ngIf=\"articleSettings\" (ionChange)=\"saveSettings()\">\n        <ion-segment mode=\"ios\" [(ngModel)]=\"articleSettings.fontFamily\">\n          <ion-segment-button value=\"serif\">\n            <span class=\"font-serif font-medium\">Serif</span>\n          </ion-segment-button>\n          <ion-segment-button value=\"sans\">\n            <span class=\"font-sans font-medium\">Sans-serif</span>\n          </ion-segment-button>\n          <ion-segment-button value=\"mono\">\n            <span class=\"font-mono font-medium\">\n              Monospace\n            </span>\n          </ion-segment-button>\n        </ion-segment>\n      </div>\n\n      <ion-item lines=\"full\"></ion-item>\n      <ion-item lines=\"none\" *ngIf=\"articleSettings\">\n        <ion-icon slot=\"start\" name=\"browsers-outline\"></ion-icon>\n        <ion-label class=\"\">\n          <h2>Use system browser</h2>\n          <p>Disable in-app browser for articles</p>\n        </ion-label>\n        <ion-toggle slot=\"end\" (ionChange)=\"saveSettings()\" [(ngModel)]=\"articleSettings.useSystemBrowser\"></ion-toggle>\n      </ion-item>\n  \n    </ion-list>\n  </div>\n</ion-content>\n";

/***/ }),

/***/ 67668:
/*!****************************************************************************************************!*\
  !*** ./src/app/components/collection-feeds-modal/collection-feeds-modal.component.html?ngResource ***!
  \****************************************************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header>\n  <ion-toolbar class=\"main-toolbar\">\n    <ion-buttons slot=\"start\">\n      <ion-button (click)=\"close()\">\n        <ion-icon name=\"close\" slot=\"icon-only\"></ion-icon>\n      </ion-button>\n    </ion-buttons>\n    <ion-title>\n      <span class=\"font-bold text-white drop-shadow-sm\">Manage collections</span>\n    </ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content>\n\n  <ion-list-header mode=\"ios\" class=\"mt-1\">\n    <ion-label>\n      Feeds\n    </ion-label>\n    <ion-button (click)=\"startReorder()\" *ngIf=\"!reorder && collection.feedList && collection.feedList.length > 1\">\n      Reorder\n    </ion-button>\n    <ion-button (click)=\"endReorder()\" *ngIf=\"reorder && collection.feedList && collection.feedList.length > 1\">\n      Save order\n    </ion-button>\n  </ion-list-header>\n\n  <ion-reorder-group [disabled]=\"!reorder\" class=\"pt-5 mb-20\" (ionItemReorder)=\"drop($event)\">\n    <ion-item *ngFor=\"let feed of (collection.feedList | orderByIndex)\" lines=\"full\">\n      <ion-reorder slot=\"start\"></ion-reorder>\n      <ion-thumbnail slot=\"start\">\n        <img [src]=\"feed.visualUrl ?? feed.iconUrl\" class=\"rounded-md\">\n      </ion-thumbnail>\n      <ion-label>\n        {{ feed.title }}\n      </ion-label>\n      <ion-button slot=\"end\" color=\"danger\" fill=\"clear\" (click)=\"confirmDeleteFeed(feed)\">\n        <ion-icon name=\"trash\"></ion-icon>\n      </ion-button>\n    </ion-item>\n  </ion-reorder-group>\n\n  <!-- Empty state -->\n  <div class=\"w-full\" *ngIf=\"collection.feedList && collection.feedList.length === 0\">\n    <div class=\"mt-20 px-6 w-full flex items-center justify-center\">\n      <div class=\"w-fit h-fit\">\n        <img src=\"assets/images/undraw_list.svg\" class=\"w-1/2 m-auto\">\n        <div class=\"text-center mt-10\">\n          <p class=\"text-2xl font-semibold\">No feeds in this collection</p>\n          <p>¿Why don’t you add some?</p>\n          <ion-button fill=\"outline\" color=\"primary\" class=\"mt-6\" (click)=\"openSearch()\">\n            Explore feeds\n            <ion-icon slot=\"end\" name=\"planet-outline\"></ion-icon>\n          </ion-button>\n        </div>\n      </div>\n    </div>\n  </div>\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=default-src_app_components_components_module_ts.js.map