// ignore_for_file: sort_constructors_first, constant_identifier_names

import 'package:flutter/material.dart';

import '../../icons.dart';

/// Binding name enumeration between [YaruIcons] and the Freedesktop Icon Naming Specification
/// Based on: https://specifications.freedesktop.org/icon-naming-spec/icon-naming-spec-latest.html
///
/// Usage:
/// ```
/// Icon(
///   YaruFreedesktopIcons.help_about.icon
///   // or
///   YaruFreedesktopIcons.all['help_about']!.icon
/// )
/// ```
enum YaruFreedesktopIcons {
  // Actions
  address_book_new._(YaruIcons.address_book_new),
  application_exit._(YaruIcons.window_close),
  appointment_new._(YaruIcons.calendar_new),
  call_start._(YaruIcons.call_start),
  call_stop._(YaruIcons.call_stop),
  contact_new._(YaruIcons.user_new),
  document_new._(YaruIcons.document_new),
  document_open._(YaruIcons.document_open),
  document_open_recent._(YaruIcons.document_history),
  document_page_setup._(YaruIcons.document_template),
  document_print._(YaruIcons.printer),
  document_print_preview._(YaruIcons.printer_preview),
  document_properties._(YaruIcons.gear),
  document_revert._(YaruIcons.revert),
  document_save._(YaruIcons.save),
  document_save_as._(YaruIcons.save_as),
  document_send._(YaruIcons.send),
  edit_clear._(YaruIcons.edit_clear),
  edit_copy._(YaruIcons.copy),
  edit_cut._(YaruIcons.cut),
  edit_delete._(YaruIcons.trash),
  edit_find._(YaruIcons.search),
  edit_find_replace._(YaruIcons.find_replace),
  edit_paste._(YaruIcons.paste),
  edit_redo._(YaruIcons.redo),
  edit_select_all._(YaruIcons.selection),
  edit_undo._(YaruIcons.undo),
  folder_new._(YaruIcons.folder_new),
  format_indent_less._(YaruIcons.indent_less),
  format_indent_more._(YaruIcons.indent_more),
  format_justify_center._(YaruIcons.justify_center),
  format_justify_fill._(YaruIcons.justify_fill),
  format_justify_left._(YaruIcons.justify_left),
  format_justify_right._(YaruIcons.justify_right),
  format_text_direction_ltr._(YaruIcons.text_direction_ltr),
  format_text_direction_rtl._(YaruIcons.text_direction_rtl),
  format_text_bold._(YaruIcons.bold),
  format_text_italic._(YaruIcons.italic),
  format_text_underline._(YaruIcons.underline),
  format_text_strikethrough._(YaruIcons.strikethrough),
  go_bottom._(YaruIcons.go_bottom),
  go_down._(YaruIcons.go_down),
  go_first._(YaruIcons.go_first),
  go_home._(YaruIcons.home),
  go_jump._(YaruIcons.go_jump),
  go_last._(YaruIcons.go_last),
  go_next._(YaruIcons.go_next),
  go_previous._(YaruIcons.go_previous),
  go_top._(YaruIcons.go_top),
  go_up._(YaruIcons.go_up),
  help_about._(YaruIcons.information),
  help_contents._(YaruIcons.question),
  help_faq._(YaruIcons.question),
  list_add._(YaruIcons.unordered_list_new),
  list_remove._(YaruIcons.unordered_list_remove),
  mail_forward._(YaruIcons.forward),
  mail_mark_important._(YaruIcons.important),
  mail_mark_junk._(YaruIcons.junk),
  mail_mark_notjunk._(YaruIcons.notjunk),
  mail_mark_read._(YaruIcons.mail_open),
  mail_mark_unread._(YaruIcons.mail_unread),
  mail_message_new._(YaruIcons.mail_new),
  mail_reply_all._(YaruIcons.reply_all),
  mail_reply_sender._(YaruIcons.reply),
  mail_send._(YaruIcons.send),
  mail_send_receive._(YaruIcons.send_receive),
  media_eject._(YaruIcons.eject),
  media_playback_pause._(YaruIcons.media_pause),
  media_playback_start._(YaruIcons.media_play),
  media_playback_stop._(YaruIcons.media_stop),
  media_playback_record._(YaruIcons.media_record),
  media_seek_backward._(YaruIcons.fast_backward),
  media_seek_forward._(YaruIcons.fast_forward),
  media_skip_backward._(YaruIcons.skip_backward),
  media_skip_forward._(YaruIcons.skip_forward),
  object_flip_horizontal._(YaruIcons.flip_horizontal),
  object_flip_vertical._(YaruIcons.flip_vertical),
  object_rotate_left._(YaruIcons.rotate_left),
  object_rotate_right._(YaruIcons.rotate_right),
  process_stop._(YaruIcons.stop),
  system_lock_screen._(YaruIcons.screen_lock),
  system_log_out._(YaruIcons.log_out),
  system_run._(YaruIcons.gears),
  system_search._(YaruIcons.search),
  system_reboot._(YaruIcons.reboot),
  system_shutdown._(YaruIcons.shutdown),
  tools_check_spelling._(YaruIcons.check_spelling),
  view_fullscreen._(YaruIcons.fullscreen),
  view_refresh._(YaruIcons.refresh),
  view_restore._(YaruIcons.fullscreen_exit),
  view_sort_ascending._(YaruIcons.sort_ascending),
  view_sort_descending._(YaruIcons.sort_descending),
  window_close._(YaruIcons.window_close),
  window_new._(YaruIcons.window_new),
  zoom_fit_best._(YaruIcons.zoom_fit_best),
  zoom_in._(YaruIcons.zoom_in),
  zoom_original._(YaruIcons.zoom_original),
  zoom_out._(YaruIcons.zoom_out),

  // Applications
  accessories_calculator._(YaruIcons.calculator),
  accessories_character_map._(YaruIcons.character_map),
  accessories_dictionary._(YaruIcons.dictionary),
  accessories_text_editor._(YaruIcons.text_editor),
  help_browser._(YaruIcons.question),
  multimedia_volume_control._(YaruIcons.music_note),
  preferences_desktop_accessibility._(YaruIcons.human),
  preferences_desktop_font._(YaruIcons.font),
  preferences_desktop_keyboard._(YaruIcons.keyboard),
  preferences_desktop_locale._(YaruIcons.localization),
  preferences_desktop_multimedia._(YaruIcons.multimedia),
  preferences_desktop_screensaver._(YaruIcons.screensaver),
  preferences_desktop_theme._(YaruIcons.desktop_appearance),
  preferences_desktop_wallpaper._(YaruIcons.wallpaper),
  system_file_manager._(YaruIcons.folder),
  system_software_install._(YaruIcons.package),
  system_software_update._(YaruIcons.update),
  utilities_system_monitor._(YaruIcons.monitor),
  utilities_terminal._(YaruIcons.terminal),

  // Categories
  applications_accessories._(YaruIcons.rule_and_pen),
  applications_development._(YaruIcons.trowel),
  applications_engineering._(YaruIcons.wrench),
  applications_games._(YaruIcons.games),
  applications_graphics._(YaruIcons.image),
  applications_internet._(YaruIcons.network),
  applications_multimedia._(YaruIcons.multimedia),
  applications_office._(YaruIcons.office),
  applications_other._(YaruIcons.app_grid),
  applications_science._(YaruIcons.beaker),
  applications_system._(YaruIcons.gear),
  applications_utilities._(YaruIcons.swiss_knife),
  preferences_desktop._(YaruIcons.desktop),
  preferences_desktop_peripherals._(YaruIcons.keyboard),
  preferences_desktop_personal._(YaruIcons.users),
  preferences_other._(YaruIcons.gear_dots),
  preferences_system._(YaruIcons.gear),
  preferences_system_network._(YaruIcons.network),
  system_help._(YaruIcons.question),

  // Devices
  audio_card._(YaruIcons.audio_card),
  audio_input_microphone._(YaruIcons.microphone),
  battery._(YaruIcons.battery),
  camera_photo._(YaruIcons.camera_photo),
  camera_video._(YaruIcons.camera_video),
  camera_web._(YaruIcons.camera_web),
  computer._(YaruIcons.computer),
  drive_harddisk._(YaruIcons.drive_harddisk),
  drive_optical._(YaruIcons.drive_optical),
  drive_removable_media._(YaruIcons.drive_removable_media),
  input_gaming._(YaruIcons.game_controller),
  input_keyboard._(YaruIcons.keyboard),
  input_mouse._(YaruIcons.mouse),
  input_tablet._(YaruIcons.graphic_tablet),
  media_flash._(YaruIcons.flash_card),
  media_floppy._(YaruIcons.floppy),
  media_optical._(YaruIcons.disk),
  media_tape._(YaruIcons.tape),
  modem._(YaruIcons.modem),
  multimedia_player._(YaruIcons.multimedia_player),
  network_wired._(YaruIcons.network_wired),
  network_wireless._(YaruIcons.network_wireless),
  pda._(YaruIcons.pda),
  phone._(YaruIcons.smartphone),
  printer._(YaruIcons.printer),
  scanner._(YaruIcons.scanner),
  video_display._(YaruIcons.screen),

  // Emblems
  emblem_default._(YaruIcons.ok),
  emblem_documents._(YaruIcons.document),
  emblem_downloads._(YaruIcons.download),
  emblem_favorite._(YaruIcons.heart_filled),
  emblem_important._(YaruIcons.important),
  emblem_mail._(YaruIcons.mail),
  emblem_photos._(YaruIcons.image),
  emblem_readonly._(YaruIcons.lock),
  emblem_shared._(YaruIcons.share),
  emblem_symbolic_link._(YaruIcons.sync),
  emblem_system._(YaruIcons.gear),
  emblem_unreadable._(YaruIcons.error),

  // Emotes
  emote_angel._(YaruIcons.emote_angel),
  emote_angry._(YaruIcons.emote_angry),
  emote_confused._(YaruIcons.emote_confused),
  emote_crying._(YaruIcons.emote_crying),
  emote_devilish._(YaruIcons.emote_devilish),
  emote_embarrassed._(YaruIcons.emote_embarrassed),
  emote_glasses._(YaruIcons.emote_glasses),
  emote_kiss._(YaruIcons.emote_kiss),
  emote_laugh._(YaruIcons.emote_laugh),
  emote_monkey._(YaruIcons.emote_monkey),
  emote_plain._(YaruIcons.emote_plain),
  emote_raspberry._(YaruIcons.emote_raspberry),
  emote_sad._(YaruIcons.emote_sad),
  emote_shutmouth._(YaruIcons.emote_shutmouth),
  emote_sick._(YaruIcons.emote_sick),
  emote_smile_big._(YaruIcons.emote_smile_big),
  emote_smile._(YaruIcons.emote_smile),
  emote_smirk._(YaruIcons.emote_smirk),
  emote_surprise._(YaruIcons.emote_surprise),
  emote_tired._(YaruIcons.emote_tired),
  emote_uncertain._(YaruIcons.emote_uncertain),
  emote_wink._(YaruIcons.emote_wink),
  emote_worried._(YaruIcons.emote_worried),
  emote_yawn._(YaruIcons.emote_yawn),

  // Mimetypes
  application_x_executable._(YaruIcons.gears),
  audio_x_generic._(YaruIcons.music_note),
  font_x_generic._(YaruIcons.font),
  image_x_generic._(YaruIcons.image),
  package_x_generic._(YaruIcons.package),
  text_html._(YaruIcons.html),
  text_x_generic._(YaruIcons.document),
  text_x_generic_template._(YaruIcons.document_template),
  text_x_script._(YaruIcons.script),
  video_x_generic._(YaruIcons.video),
  x_office_address_book._(YaruIcons.address_book),
  x_office_calendar._(YaruIcons.calendar),
  x_office_document._(YaruIcons.office),
  x_office_presentation._(YaruIcons.office_presentation),
  x_office_spreadsheet._(YaruIcons.office_spreadsheet),

  //Places
  folder._(YaruIcons.folder),
  folder_remote._(YaruIcons.folder_remote),
  network_server._(YaruIcons.server),
  network_workgroup._(YaruIcons.globe),
  start_here._(YaruIcons.ubuntu_logo),
  user_bookmarks._(YaruIcons.bookmark),
  user_desktop._(YaruIcons.desktop),
  user_trash._(YaruIcons.trash),

  // Status
  appointment_missed._(YaruIcons.calendar_important),
  appointment_soon._(YaruIcons.calendar_warning),
  audio_volume_high._(YaruIcons.speaker_high),
  audio_volume_low._(YaruIcons.speaker_low),
  audio_volume_medium._(YaruIcons.speaker_medium),
  audio_volume_muted._(YaruIcons.speaker_muted),
  battery_caution._(YaruIcons.battery_4),
  battery_low._(YaruIcons.battery_warning),
  dialog_error._(YaruIcons.error),
  dialog_information._(YaruIcons.information),
  dialog_password._(YaruIcons.key),
  dialog_question._(YaruIcons.question),
  dialog_warning._(YaruIcons.warning),
  folder_drag_accept._(YaruIcons.folder_drag_accept),
  folder_open._(YaruIcons.folder_open),
  folder_visiting._(YaruIcons.folder_simple),
  image_loading._(YaruIcons.image_loading),
  image_missing._(YaruIcons.image_missing),
  mail_attachment._(YaruIcons.paper_clip),
  mail_unread._(YaruIcons.mail_unread),
  mail_read._(YaruIcons.mail_open),
  mail_replied._(YaruIcons.mail_replied),
  mail_signed._(YaruIcons.mail_signed),
  mail_signed_verified._(YaruIcons.mail_ok),
  media_playlist_repeat._(YaruIcons.repeat),
  media_playlist_shuffle._(YaruIcons.shuffle),
  network_error._(YaruIcons.network_error),
  network_idle._(YaruIcons.network_idle),
  network_offline._(YaruIcons.network_offline),
  network_receive._(YaruIcons.network_receive),
  network_transmit._(YaruIcons.network_transmit),
  network_transmit_receive._(YaruIcons.network_transmit_receive),
  printer_error._(YaruIcons.printer_error),
  printer_printing._(YaruIcons.printer_printing),
  security_high._(YaruIcons.shield_filled),
  security_medium._(YaruIcons.shield),
  security_low._(YaruIcons.shield_warning),
  software_update_available._(YaruIcons.update_available),
  software_update_urgent._(YaruIcons.update_urgent),
  sync_error._(YaruIcons.sync_error),
  sync_synchronizing._(YaruIcons.sync),
  task_due._(YaruIcons.task_warning),
  task_past_due._(YaruIcons.task_error),
  user_available._(YaruIcons.chat_text),
  user_away._(YaruIcons.chat_away),
  user_idle._(YaruIcons.chat_idle),
  user_offline._(YaruIcons.chat_offline),
  user_trash_full._(YaruIcons.trash_full),
  weather_clear._(YaruIcons.sun),
  weather_clear_night._(YaruIcons.clear_night),
  weather_few_clouds._(YaruIcons.few_clouds),
  weather_few_clouds_night._(YaruIcons.few_clouds_night),
  weather_fog._(YaruIcons.fog),
  weather_overcast._(YaruIcons.overcast),
  weather_severe_alert._(YaruIcons.weather_alert),
  weather_showers._(YaruIcons.showers),
  weather_showers_scattered._(YaruIcons.rain),
  weather_snow._(YaruIcons.snow),
  weather_storm._(YaruIcons.storm);

  final IconData icon;
  const YaruFreedesktopIcons._(this.icon);

  /// Shortcut to get enum values as string map
  static Map<String, YaruFreedesktopIcons> get all => values.asNameMap();
}
