// Copyright (c) 2024, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'dart:developer';
import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart pkg/vm_service/test/issue_56911_test.dart
//
const LINE_A = 26;
const LINE_B = 30;
// AUTOGENERATED END

extension type ExtensionType._(String s) {
  ExtensionType(int i) : this._('$i');
  int get value => s.codeUnitAt(0);
}

void code() {
  final list = [ExtensionType(0)];
  debugger(); // LINE_A
  print(list.single.value);
  // ignore: avoid_function_literals_in_foreach_calls
  list.forEach((ExtensionType input) {
    debugger(); // LINE_B
    print(input.value);
  });
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_A),
  testExpressionEvaluationAndAvailableVariables('code', [
    'list',
  ], [
    ('() { return list.single.value; }()', '48'),
    ('list.single.value', '48'),
  ]),
  resumeIsolate,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  testExpressionEvaluationAndAvailableVariables('<anonymous closure>', [
    'input',
  ], [
    ('() { return input.value; }()', '48'),
    ('input.value', '48'),
  ]),
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'issue_56911_test.dart',
      testeeConcurrent: code,
      pauseOnStart: false,
      pauseOnExit: true,
    );
