# Power Extensions

This package contains useful extensions for the dart language core classes

## Features

### BigInt

The BigIntExtensionBase class contains the following methods:

- precision
- powerOfTen
- isPowerOfTen
- scale
- significandString
- significand
- significandLength

### String

The StringExtensionBase class contains the following methods:

- trimLeftChar
- trimRightChar
- cut
- cutAndAlign
- preserveOnlyChars
- splitInLines
- capitalizeAndLowercase
- capitalizeAndLowercaseAnyWord
- capitalizeRestUnchanged
- uncapitalizeRestUnchanged
- onlyContainsDigits
- onlyContainsAlpha
- isDartIdentifier
- getDartIdentifier
- startsAndEndsWith
- trimDelimiters
- trimStringDelimiters

## Getting started

  Simply import the package and use the power_extensions libray or area ones.

## Usage

```dart
BigInt.from(-1000000001).isPowerOfTen;
```

See the example folder for more examples

## Additional information

File issues on the [github repository](https://github.com/giorgiofran/power_extensions/issues)
