// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// webhook_listeners Version: 0.0.1.
///
/// Nextcloud webhook support.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i5;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i6;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i4;

part 'webhook_listeners.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $WebhooksClient webhooks = $WebhooksClient(this);
}

class $WebhooksClient {
  /// Creates a new `DynamiteClient` for webhooks requests.
  $WebhooksClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$index_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WebhooksIndexResponseApplicationJson, void> $index_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(WebhooksIndexResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// List registered webhooks.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [index] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [uri] The callback URI to filter by.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Webhook registrations returned
  ///
  /// See:
  ///  * [index] for a method executing this request and parsing the response.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $index_Request({
    String? uri,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __uri = _$jsonSerializers.serialize(uri, specifiedType: const FullType(String));
    _parameters['uri'] = __uri;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/webhook_listeners/api/v1/webhooks{?uri*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// List registered webhooks.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [uri] The callback URI to filter by.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Webhook registrations returned
  ///
  /// See:
  ///  * [$index_Request] for the request send by this method.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WebhooksIndexResponseApplicationJson, void>> index({
    String? uri,
    bool? oCSAPIRequest,
  }) async {
    final _request = $index_Request(
      uri: uri,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $index_Serializer();
    return _i1.ResponseConverter<WebhooksIndexResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$create_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WebhooksCreateResponseApplicationJson, void> $create_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(WebhooksCreateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Register a new webhook.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [create] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Webhook registration returned
  ///   * 400: Bad request
  ///   * 403: Insufficient permissions
  ///
  /// See:
  ///  * [create] for a method executing this request and parsing the response.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $create_Request({
    required WebhooksCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/webhook_listeners/api/v1/webhooks';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(WebhooksCreateRequestApplicationJson)),
    );
    return _request;
  }

  /// Register a new webhook.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Webhook registration returned
  ///   * 400: Bad request
  ///   * 403: Insufficient permissions
  ///
  /// See:
  ///  * [$create_Request] for the request send by this method.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WebhooksCreateResponseApplicationJson, void>> create({
    required WebhooksCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $create_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $create_Serializer();
    return _i1.ResponseConverter<WebhooksCreateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$$show_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WebhooksShowResponseApplicationJson, void> $$show_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(WebhooksShowResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get details on a registered webhook.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [$show] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] id of the webhook.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Webhook registration returned
  ///   * 404: Webhook not found
  ///
  /// See:
  ///  * [$show] for a method executing this request and parsing the response.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$show_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/webhook_listeners/api/v1/webhooks/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get details on a registered webhook.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] id of the webhook.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Webhook registration returned
  ///   * 404: Webhook not found
  ///
  /// See:
  ///  * [$$show_Request] for the request send by this method.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WebhooksShowResponseApplicationJson, void>> $show({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $$show_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$show_Serializer();
    return _i1.ResponseConverter<WebhooksShowResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$$update_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WebhooksUpdateResponseApplicationJson, void> $$update_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(WebhooksUpdateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update an existing webhook registration.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [$update] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] id of the webhook.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Webhook registration returned
  ///   * 400: Bad request
  ///   * 403: Insufficient permissions
  ///
  /// See:
  ///  * [$update] for a method executing this request and parsing the response.
  ///  * [$$update_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$update_Request({
    required int id,
    required WebhooksUpdateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/webhook_listeners/api/v1/webhooks/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(WebhooksUpdateRequestApplicationJson)),
    );
    return _request;
  }

  /// Update an existing webhook registration.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] id of the webhook.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Webhook registration returned
  ///   * 400: Bad request
  ///   * 403: Insufficient permissions
  ///
  /// See:
  ///  * [$$update_Request] for the request send by this method.
  ///  * [$$update_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WebhooksUpdateResponseApplicationJson, void>> $update({
    required int id,
    required WebhooksUpdateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $$update_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$update_Serializer();
    return _i1.ResponseConverter<WebhooksUpdateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$destroy_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WebhooksDestroyResponseApplicationJson, void> $destroy_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(WebhooksDestroyResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Remove an existing webhook registration.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [destroy] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] id of the webhook.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Boolean returned whether something was deleted
  ///   * 400: Bad request
  ///   * 403: Insufficient permissions
  ///
  /// See:
  ///  * [destroy] for a method executing this request and parsing the response.
  ///  * [$destroy_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $destroy_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/webhook_listeners/api/v1/webhooks/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove an existing webhook registration.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] id of the webhook.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Boolean returned whether something was deleted
  ///   * 400: Bad request
  ///   * 403: Insufficient permissions
  ///
  /// See:
  ///  * [$destroy_Request] for the request send by this method.
  ///  * [$destroy_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WebhooksDestroyResponseApplicationJson, void>> destroy({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $destroy_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $destroy_Serializer();
    return _i1.ResponseConverter<WebhooksDestroyResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteByAppId_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WebhooksDeleteByAppIdResponseApplicationJson, void> $deleteByAppId_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(WebhooksDeleteByAppIdResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Remove all existing webhook registration mapped to an AppAPI app id.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteByAppId] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appid] id of the app, as in the EX-APP-ID for creation.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Integer number of registrations deleted
  ///   * 400: Bad request
  ///   * 403: Insufficient permissions
  ///
  /// See:
  ///  * [deleteByAppId] for a method executing this request and parsing the response.
  ///  * [$deleteByAppId_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteByAppId_Request({
    required String appid,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __appid = _$jsonSerializers.serialize(appid, specifiedType: const FullType(String));
    _parameters['appid'] = __appid;

    final _path =
        _i4.UriTemplate('/ocs/v2.php/apps/webhook_listeners/api/v1/webhooks/byappid/{appid}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove all existing webhook registration mapped to an AppAPI app id.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appid] id of the app, as in the EX-APP-ID for creation.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Integer number of registrations deleted
  ///   * 400: Bad request
  ///   * 403: Insufficient permissions
  ///
  /// See:
  ///  * [$deleteByAppId_Request] for the request send by this method.
  ///  * [$deleteByAppId_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WebhooksDeleteByAppIdResponseApplicationJson, void>> deleteByAppId({
    required String appid,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteByAppId_Request(
      appid: appid,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteByAppId_Serializer();
    return _i1.ResponseConverter<WebhooksDeleteByAppIdResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhookInfoInterface {
  String get id;
  String get userId;
  String get httpMethod;
  String get uri;
  String? get event;
  BuiltMap<String, JsonObject>? get eventFilter;
  String? get userIdFilter;
  BuiltMap<String, String>? get headers;
  String get authMethod;
  BuiltMap<String, JsonObject>? get authData;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhookInfoInterfaceBuilder].
  $WebhookInfoInterface rebuild(void Function($WebhookInfoInterfaceBuilder) updates);

  /// Converts the instance to a builder [$WebhookInfoInterfaceBuilder].
  $WebhookInfoInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhookInfoInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhookInfoInterfaceBuilder b) {}
}

abstract class WebhookInfo implements $WebhookInfoInterface, Built<WebhookInfo, WebhookInfoBuilder> {
  /// Creates a new WebhookInfo object using the builder pattern.
  factory WebhookInfo([void Function(WebhookInfoBuilder)? b]) = _$WebhookInfo;

  // coverage:ignore-start
  const WebhookInfo._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhookInfo.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhookInfo.
  static Serializer<WebhookInfo> get serializer => _$webhookInfoSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhookInfoBuilder b) {
    $WebhookInfoInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhookInfoBuilder b) {
    $WebhookInfoInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksIndexResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<WebhookInfo> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksIndexResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksIndexResponseApplicationJson_OcsInterface rebuild(
    void Function($WebhooksIndexResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksIndexResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksIndexResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WebhooksIndexResponseApplicationJson_Ocs
    implements
        $WebhooksIndexResponseApplicationJson_OcsInterface,
        Built<WebhooksIndexResponseApplicationJson_Ocs, WebhooksIndexResponseApplicationJson_OcsBuilder> {
  /// Creates a new WebhooksIndexResponseApplicationJson_Ocs object using the builder pattern.
  factory WebhooksIndexResponseApplicationJson_Ocs([
    void Function(WebhooksIndexResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WebhooksIndexResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WebhooksIndexResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksIndexResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksIndexResponseApplicationJson_Ocs.
  static Serializer<WebhooksIndexResponseApplicationJson_Ocs> get serializer =>
      _$webhooksIndexResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksIndexResponseApplicationJson_OcsBuilder b) {
    $WebhooksIndexResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksIndexResponseApplicationJson_OcsBuilder b) {
    $WebhooksIndexResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksIndexResponseApplicationJsonInterface {
  WebhooksIndexResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksIndexResponseApplicationJsonInterfaceBuilder].
  $WebhooksIndexResponseApplicationJsonInterface rebuild(
    void Function($WebhooksIndexResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksIndexResponseApplicationJsonInterfaceBuilder].
  $WebhooksIndexResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksIndexResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksIndexResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WebhooksIndexResponseApplicationJson
    implements
        $WebhooksIndexResponseApplicationJsonInterface,
        Built<WebhooksIndexResponseApplicationJson, WebhooksIndexResponseApplicationJsonBuilder> {
  /// Creates a new WebhooksIndexResponseApplicationJson object using the builder pattern.
  factory WebhooksIndexResponseApplicationJson([void Function(WebhooksIndexResponseApplicationJsonBuilder)? b]) =
      _$WebhooksIndexResponseApplicationJson;

  // coverage:ignore-start
  const WebhooksIndexResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksIndexResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksIndexResponseApplicationJson.
  static Serializer<WebhooksIndexResponseApplicationJson> get serializer =>
      _$webhooksIndexResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksIndexResponseApplicationJsonBuilder b) {
    $WebhooksIndexResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksIndexResponseApplicationJsonBuilder b) {
    $WebhooksIndexResponseApplicationJsonInterface._validate(b);
  }
}

/// Authentication method to use.
class WebhooksCreateRequestApplicationJson_AuthMethod extends EnumClass {
  const WebhooksCreateRequestApplicationJson_AuthMethod._(super.name);

  /// `none`
  static const WebhooksCreateRequestApplicationJson_AuthMethod none =
      _$webhooksCreateRequestApplicationJsonAuthMethodNone;

  /// `headers`
  static const WebhooksCreateRequestApplicationJson_AuthMethod headers =
      _$webhooksCreateRequestApplicationJsonAuthMethodHeaders;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<WebhooksCreateRequestApplicationJson_AuthMethod> get values =>
      _$webhooksCreateRequestApplicationJsonAuthMethodValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static WebhooksCreateRequestApplicationJson_AuthMethod valueOf(String name) =>
      _$valueOfWebhooksCreateRequestApplicationJson_AuthMethod(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for WebhooksCreateRequestApplicationJson_AuthMethod.
  @BuiltValueSerializer(custom: true)
  static Serializer<WebhooksCreateRequestApplicationJson_AuthMethod> get serializer =>
      const _$WebhooksCreateRequestApplicationJson_AuthMethodSerializer();
}

class _$WebhooksCreateRequestApplicationJson_AuthMethodSerializer
    implements PrimitiveSerializer<WebhooksCreateRequestApplicationJson_AuthMethod> {
  const _$WebhooksCreateRequestApplicationJson_AuthMethodSerializer();

  static const Map<WebhooksCreateRequestApplicationJson_AuthMethod, Object> _toWire =
      <WebhooksCreateRequestApplicationJson_AuthMethod, Object>{
    WebhooksCreateRequestApplicationJson_AuthMethod.none: 'none',
    WebhooksCreateRequestApplicationJson_AuthMethod.headers: 'headers',
  };

  static const Map<Object, WebhooksCreateRequestApplicationJson_AuthMethod> _fromWire =
      <Object, WebhooksCreateRequestApplicationJson_AuthMethod>{
    'none': WebhooksCreateRequestApplicationJson_AuthMethod.none,
    'headers': WebhooksCreateRequestApplicationJson_AuthMethod.headers,
  };

  @override
  Iterable<Type> get types => const [WebhooksCreateRequestApplicationJson_AuthMethod];

  @override
  String get wireName => 'WebhooksCreateRequestApplicationJson_AuthMethod';

  @override
  Object serialize(
    Serializers serializers,
    WebhooksCreateRequestApplicationJson_AuthMethod object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  WebhooksCreateRequestApplicationJson_AuthMethod deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $WebhooksCreateRequestApplicationJsonInterface {
  /// HTTP method to use to contact the webhook.
  String get httpMethod;

  /// Webhook URI endpoint.
  String get uri;

  /// Event class name to listen to.
  String get event;

  /// Mongo filter to apply to the serialized data to decide if firing.
  BuiltMap<String, JsonObject>? get eventFilter;

  /// User id to filter on. The webhook will only be called by requests from this user. Empty or null means no filtering.
  String? get userIdFilter;

  /// Array of headers to send.
  BuiltMap<String, String>? get headers;

  /// Authentication method to use.
  WebhooksCreateRequestApplicationJson_AuthMethod? get authMethod;

  /// Array of data for authentication.
  BuiltMap<String, JsonObject>? get authData;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksCreateRequestApplicationJsonInterfaceBuilder].
  $WebhooksCreateRequestApplicationJsonInterface rebuild(
    void Function($WebhooksCreateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksCreateRequestApplicationJsonInterfaceBuilder].
  $WebhooksCreateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksCreateRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksCreateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class WebhooksCreateRequestApplicationJson
    implements
        $WebhooksCreateRequestApplicationJsonInterface,
        Built<WebhooksCreateRequestApplicationJson, WebhooksCreateRequestApplicationJsonBuilder> {
  /// Creates a new WebhooksCreateRequestApplicationJson object using the builder pattern.
  factory WebhooksCreateRequestApplicationJson([void Function(WebhooksCreateRequestApplicationJsonBuilder)? b]) =
      _$WebhooksCreateRequestApplicationJson;

  // coverage:ignore-start
  const WebhooksCreateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksCreateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksCreateRequestApplicationJson.
  static Serializer<WebhooksCreateRequestApplicationJson> get serializer =>
      _$webhooksCreateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksCreateRequestApplicationJsonBuilder b) {
    $WebhooksCreateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksCreateRequestApplicationJsonBuilder b) {
    $WebhooksCreateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksCreateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  WebhookInfo get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksCreateResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksCreateResponseApplicationJson_OcsInterface rebuild(
    void Function($WebhooksCreateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksCreateResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksCreateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WebhooksCreateResponseApplicationJson_Ocs
    implements
        $WebhooksCreateResponseApplicationJson_OcsInterface,
        Built<WebhooksCreateResponseApplicationJson_Ocs, WebhooksCreateResponseApplicationJson_OcsBuilder> {
  /// Creates a new WebhooksCreateResponseApplicationJson_Ocs object using the builder pattern.
  factory WebhooksCreateResponseApplicationJson_Ocs([
    void Function(WebhooksCreateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WebhooksCreateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WebhooksCreateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksCreateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksCreateResponseApplicationJson_Ocs.
  static Serializer<WebhooksCreateResponseApplicationJson_Ocs> get serializer =>
      _$webhooksCreateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksCreateResponseApplicationJson_OcsBuilder b) {
    $WebhooksCreateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksCreateResponseApplicationJson_OcsBuilder b) {
    $WebhooksCreateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksCreateResponseApplicationJsonInterface {
  WebhooksCreateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksCreateResponseApplicationJsonInterfaceBuilder].
  $WebhooksCreateResponseApplicationJsonInterface rebuild(
    void Function($WebhooksCreateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksCreateResponseApplicationJsonInterfaceBuilder].
  $WebhooksCreateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksCreateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksCreateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WebhooksCreateResponseApplicationJson
    implements
        $WebhooksCreateResponseApplicationJsonInterface,
        Built<WebhooksCreateResponseApplicationJson, WebhooksCreateResponseApplicationJsonBuilder> {
  /// Creates a new WebhooksCreateResponseApplicationJson object using the builder pattern.
  factory WebhooksCreateResponseApplicationJson([void Function(WebhooksCreateResponseApplicationJsonBuilder)? b]) =
      _$WebhooksCreateResponseApplicationJson;

  // coverage:ignore-start
  const WebhooksCreateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksCreateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksCreateResponseApplicationJson.
  static Serializer<WebhooksCreateResponseApplicationJson> get serializer =>
      _$webhooksCreateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksCreateResponseApplicationJsonBuilder b) {
    $WebhooksCreateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksCreateResponseApplicationJsonBuilder b) {
    $WebhooksCreateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksShowResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  WebhookInfo get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksShowResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksShowResponseApplicationJson_OcsInterface rebuild(
    void Function($WebhooksShowResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksShowResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksShowResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksShowResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksShowResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WebhooksShowResponseApplicationJson_Ocs
    implements
        $WebhooksShowResponseApplicationJson_OcsInterface,
        Built<WebhooksShowResponseApplicationJson_Ocs, WebhooksShowResponseApplicationJson_OcsBuilder> {
  /// Creates a new WebhooksShowResponseApplicationJson_Ocs object using the builder pattern.
  factory WebhooksShowResponseApplicationJson_Ocs([void Function(WebhooksShowResponseApplicationJson_OcsBuilder)? b]) =
      _$WebhooksShowResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WebhooksShowResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksShowResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksShowResponseApplicationJson_Ocs.
  static Serializer<WebhooksShowResponseApplicationJson_Ocs> get serializer =>
      _$webhooksShowResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksShowResponseApplicationJson_OcsBuilder b) {
    $WebhooksShowResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksShowResponseApplicationJson_OcsBuilder b) {
    $WebhooksShowResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksShowResponseApplicationJsonInterface {
  WebhooksShowResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksShowResponseApplicationJsonInterfaceBuilder].
  $WebhooksShowResponseApplicationJsonInterface rebuild(
    void Function($WebhooksShowResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksShowResponseApplicationJsonInterfaceBuilder].
  $WebhooksShowResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksShowResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksShowResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WebhooksShowResponseApplicationJson
    implements
        $WebhooksShowResponseApplicationJsonInterface,
        Built<WebhooksShowResponseApplicationJson, WebhooksShowResponseApplicationJsonBuilder> {
  /// Creates a new WebhooksShowResponseApplicationJson object using the builder pattern.
  factory WebhooksShowResponseApplicationJson([void Function(WebhooksShowResponseApplicationJsonBuilder)? b]) =
      _$WebhooksShowResponseApplicationJson;

  // coverage:ignore-start
  const WebhooksShowResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksShowResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksShowResponseApplicationJson.
  static Serializer<WebhooksShowResponseApplicationJson> get serializer =>
      _$webhooksShowResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksShowResponseApplicationJsonBuilder b) {
    $WebhooksShowResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksShowResponseApplicationJsonBuilder b) {
    $WebhooksShowResponseApplicationJsonInterface._validate(b);
  }
}

/// Authentication method to use.
class WebhooksUpdateRequestApplicationJson_AuthMethod extends EnumClass {
  const WebhooksUpdateRequestApplicationJson_AuthMethod._(super.name);

  /// `none`
  static const WebhooksUpdateRequestApplicationJson_AuthMethod none =
      _$webhooksUpdateRequestApplicationJsonAuthMethodNone;

  /// `headers`
  static const WebhooksUpdateRequestApplicationJson_AuthMethod headers =
      _$webhooksUpdateRequestApplicationJsonAuthMethodHeaders;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<WebhooksUpdateRequestApplicationJson_AuthMethod> get values =>
      _$webhooksUpdateRequestApplicationJsonAuthMethodValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static WebhooksUpdateRequestApplicationJson_AuthMethod valueOf(String name) =>
      _$valueOfWebhooksUpdateRequestApplicationJson_AuthMethod(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for WebhooksUpdateRequestApplicationJson_AuthMethod.
  @BuiltValueSerializer(custom: true)
  static Serializer<WebhooksUpdateRequestApplicationJson_AuthMethod> get serializer =>
      const _$WebhooksUpdateRequestApplicationJson_AuthMethodSerializer();
}

class _$WebhooksUpdateRequestApplicationJson_AuthMethodSerializer
    implements PrimitiveSerializer<WebhooksUpdateRequestApplicationJson_AuthMethod> {
  const _$WebhooksUpdateRequestApplicationJson_AuthMethodSerializer();

  static const Map<WebhooksUpdateRequestApplicationJson_AuthMethod, Object> _toWire =
      <WebhooksUpdateRequestApplicationJson_AuthMethod, Object>{
    WebhooksUpdateRequestApplicationJson_AuthMethod.none: 'none',
    WebhooksUpdateRequestApplicationJson_AuthMethod.headers: 'headers',
  };

  static const Map<Object, WebhooksUpdateRequestApplicationJson_AuthMethod> _fromWire =
      <Object, WebhooksUpdateRequestApplicationJson_AuthMethod>{
    'none': WebhooksUpdateRequestApplicationJson_AuthMethod.none,
    'headers': WebhooksUpdateRequestApplicationJson_AuthMethod.headers,
  };

  @override
  Iterable<Type> get types => const [WebhooksUpdateRequestApplicationJson_AuthMethod];

  @override
  String get wireName => 'WebhooksUpdateRequestApplicationJson_AuthMethod';

  @override
  Object serialize(
    Serializers serializers,
    WebhooksUpdateRequestApplicationJson_AuthMethod object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  WebhooksUpdateRequestApplicationJson_AuthMethod deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $WebhooksUpdateRequestApplicationJsonInterface {
  /// HTTP method to use to contact the webhook.
  String get httpMethod;

  /// Webhook URI endpoint.
  String get uri;

  /// Event class name to listen to.
  String get event;

  /// Mongo filter to apply to the serialized data to decide if firing.
  BuiltMap<String, JsonObject>? get eventFilter;

  /// User id to filter on. The webhook will only be called by requests from this user. Empty or null means no filtering.
  String? get userIdFilter;

  /// Array of headers to send.
  BuiltMap<String, String>? get headers;

  /// Authentication method to use.
  WebhooksUpdateRequestApplicationJson_AuthMethod? get authMethod;

  /// Array of data for authentication.
  BuiltMap<String, JsonObject>? get authData;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksUpdateRequestApplicationJsonInterfaceBuilder].
  $WebhooksUpdateRequestApplicationJsonInterface rebuild(
    void Function($WebhooksUpdateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksUpdateRequestApplicationJsonInterfaceBuilder].
  $WebhooksUpdateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksUpdateRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksUpdateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class WebhooksUpdateRequestApplicationJson
    implements
        $WebhooksUpdateRequestApplicationJsonInterface,
        Built<WebhooksUpdateRequestApplicationJson, WebhooksUpdateRequestApplicationJsonBuilder> {
  /// Creates a new WebhooksUpdateRequestApplicationJson object using the builder pattern.
  factory WebhooksUpdateRequestApplicationJson([void Function(WebhooksUpdateRequestApplicationJsonBuilder)? b]) =
      _$WebhooksUpdateRequestApplicationJson;

  // coverage:ignore-start
  const WebhooksUpdateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksUpdateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksUpdateRequestApplicationJson.
  static Serializer<WebhooksUpdateRequestApplicationJson> get serializer =>
      _$webhooksUpdateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksUpdateRequestApplicationJsonBuilder b) {
    $WebhooksUpdateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksUpdateRequestApplicationJsonBuilder b) {
    $WebhooksUpdateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksUpdateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  WebhookInfo get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksUpdateResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksUpdateResponseApplicationJson_OcsInterface rebuild(
    void Function($WebhooksUpdateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksUpdateResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksUpdateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksUpdateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksUpdateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WebhooksUpdateResponseApplicationJson_Ocs
    implements
        $WebhooksUpdateResponseApplicationJson_OcsInterface,
        Built<WebhooksUpdateResponseApplicationJson_Ocs, WebhooksUpdateResponseApplicationJson_OcsBuilder> {
  /// Creates a new WebhooksUpdateResponseApplicationJson_Ocs object using the builder pattern.
  factory WebhooksUpdateResponseApplicationJson_Ocs([
    void Function(WebhooksUpdateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WebhooksUpdateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WebhooksUpdateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksUpdateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksUpdateResponseApplicationJson_Ocs.
  static Serializer<WebhooksUpdateResponseApplicationJson_Ocs> get serializer =>
      _$webhooksUpdateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksUpdateResponseApplicationJson_OcsBuilder b) {
    $WebhooksUpdateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksUpdateResponseApplicationJson_OcsBuilder b) {
    $WebhooksUpdateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksUpdateResponseApplicationJsonInterface {
  WebhooksUpdateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksUpdateResponseApplicationJsonInterfaceBuilder].
  $WebhooksUpdateResponseApplicationJsonInterface rebuild(
    void Function($WebhooksUpdateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksUpdateResponseApplicationJsonInterfaceBuilder].
  $WebhooksUpdateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksUpdateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksUpdateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WebhooksUpdateResponseApplicationJson
    implements
        $WebhooksUpdateResponseApplicationJsonInterface,
        Built<WebhooksUpdateResponseApplicationJson, WebhooksUpdateResponseApplicationJsonBuilder> {
  /// Creates a new WebhooksUpdateResponseApplicationJson object using the builder pattern.
  factory WebhooksUpdateResponseApplicationJson([void Function(WebhooksUpdateResponseApplicationJsonBuilder)? b]) =
      _$WebhooksUpdateResponseApplicationJson;

  // coverage:ignore-start
  const WebhooksUpdateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksUpdateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksUpdateResponseApplicationJson.
  static Serializer<WebhooksUpdateResponseApplicationJson> get serializer =>
      _$webhooksUpdateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksUpdateResponseApplicationJsonBuilder b) {
    $WebhooksUpdateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksUpdateResponseApplicationJsonBuilder b) {
    $WebhooksUpdateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksDestroyResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  bool get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksDestroyResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksDestroyResponseApplicationJson_OcsInterface rebuild(
    void Function($WebhooksDestroyResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksDestroyResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksDestroyResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksDestroyResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksDestroyResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WebhooksDestroyResponseApplicationJson_Ocs
    implements
        $WebhooksDestroyResponseApplicationJson_OcsInterface,
        Built<WebhooksDestroyResponseApplicationJson_Ocs, WebhooksDestroyResponseApplicationJson_OcsBuilder> {
  /// Creates a new WebhooksDestroyResponseApplicationJson_Ocs object using the builder pattern.
  factory WebhooksDestroyResponseApplicationJson_Ocs([
    void Function(WebhooksDestroyResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WebhooksDestroyResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WebhooksDestroyResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksDestroyResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksDestroyResponseApplicationJson_Ocs.
  static Serializer<WebhooksDestroyResponseApplicationJson_Ocs> get serializer =>
      _$webhooksDestroyResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksDestroyResponseApplicationJson_OcsBuilder b) {
    $WebhooksDestroyResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksDestroyResponseApplicationJson_OcsBuilder b) {
    $WebhooksDestroyResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksDestroyResponseApplicationJsonInterface {
  WebhooksDestroyResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksDestroyResponseApplicationJsonInterfaceBuilder].
  $WebhooksDestroyResponseApplicationJsonInterface rebuild(
    void Function($WebhooksDestroyResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksDestroyResponseApplicationJsonInterfaceBuilder].
  $WebhooksDestroyResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksDestroyResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksDestroyResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WebhooksDestroyResponseApplicationJson
    implements
        $WebhooksDestroyResponseApplicationJsonInterface,
        Built<WebhooksDestroyResponseApplicationJson, WebhooksDestroyResponseApplicationJsonBuilder> {
  /// Creates a new WebhooksDestroyResponseApplicationJson object using the builder pattern.
  factory WebhooksDestroyResponseApplicationJson([void Function(WebhooksDestroyResponseApplicationJsonBuilder)? b]) =
      _$WebhooksDestroyResponseApplicationJson;

  // coverage:ignore-start
  const WebhooksDestroyResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksDestroyResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksDestroyResponseApplicationJson.
  static Serializer<WebhooksDestroyResponseApplicationJson> get serializer =>
      _$webhooksDestroyResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksDestroyResponseApplicationJsonBuilder b) {
    $WebhooksDestroyResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksDestroyResponseApplicationJsonBuilder b) {
    $WebhooksDestroyResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksDeleteByAppIdResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  int get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksDeleteByAppIdResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksDeleteByAppIdResponseApplicationJson_OcsInterface rebuild(
    void Function($WebhooksDeleteByAppIdResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksDeleteByAppIdResponseApplicationJson_OcsInterfaceBuilder].
  $WebhooksDeleteByAppIdResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksDeleteByAppIdResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksDeleteByAppIdResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WebhooksDeleteByAppIdResponseApplicationJson_Ocs
    implements
        $WebhooksDeleteByAppIdResponseApplicationJson_OcsInterface,
        Built<WebhooksDeleteByAppIdResponseApplicationJson_Ocs,
            WebhooksDeleteByAppIdResponseApplicationJson_OcsBuilder> {
  /// Creates a new WebhooksDeleteByAppIdResponseApplicationJson_Ocs object using the builder pattern.
  factory WebhooksDeleteByAppIdResponseApplicationJson_Ocs([
    void Function(WebhooksDeleteByAppIdResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WebhooksDeleteByAppIdResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WebhooksDeleteByAppIdResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksDeleteByAppIdResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksDeleteByAppIdResponseApplicationJson_Ocs.
  static Serializer<WebhooksDeleteByAppIdResponseApplicationJson_Ocs> get serializer =>
      _$webhooksDeleteByAppIdResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksDeleteByAppIdResponseApplicationJson_OcsBuilder b) {
    $WebhooksDeleteByAppIdResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksDeleteByAppIdResponseApplicationJson_OcsBuilder b) {
    $WebhooksDeleteByAppIdResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WebhooksDeleteByAppIdResponseApplicationJsonInterface {
  WebhooksDeleteByAppIdResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WebhooksDeleteByAppIdResponseApplicationJsonInterfaceBuilder].
  $WebhooksDeleteByAppIdResponseApplicationJsonInterface rebuild(
    void Function($WebhooksDeleteByAppIdResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WebhooksDeleteByAppIdResponseApplicationJsonInterfaceBuilder].
  $WebhooksDeleteByAppIdResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WebhooksDeleteByAppIdResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WebhooksDeleteByAppIdResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WebhooksDeleteByAppIdResponseApplicationJson
    implements
        $WebhooksDeleteByAppIdResponseApplicationJsonInterface,
        Built<WebhooksDeleteByAppIdResponseApplicationJson, WebhooksDeleteByAppIdResponseApplicationJsonBuilder> {
  /// Creates a new WebhooksDeleteByAppIdResponseApplicationJson object using the builder pattern.
  factory WebhooksDeleteByAppIdResponseApplicationJson([
    void Function(WebhooksDeleteByAppIdResponseApplicationJsonBuilder)? b,
  ]) = _$WebhooksDeleteByAppIdResponseApplicationJson;

  // coverage:ignore-start
  const WebhooksDeleteByAppIdResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WebhooksDeleteByAppIdResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WebhooksDeleteByAppIdResponseApplicationJson.
  static Serializer<WebhooksDeleteByAppIdResponseApplicationJson> get serializer =>
      _$webhooksDeleteByAppIdResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WebhooksDeleteByAppIdResponseApplicationJsonBuilder b) {
    $WebhooksDeleteByAppIdResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WebhooksDeleteByAppIdResponseApplicationJsonBuilder b) {
    $WebhooksDeleteByAppIdResponseApplicationJsonInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(
        const FullType(WebhooksIndexResponseApplicationJson),
        WebhooksIndexResponseApplicationJsonBuilder.new,
      )
      ..add(WebhooksIndexResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksIndexResponseApplicationJson_Ocs),
        WebhooksIndexResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WebhooksIndexResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(const FullType(WebhookInfo), WebhookInfoBuilder.new)
      ..add(WebhookInfo.serializer)
      ..addBuilderFactory(
        const FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
        MapBuilder<String, JsonObject>.new,
      )
      ..addBuilderFactory(
        const FullType(BuiltMap, [FullType(String), FullType(String)]),
        MapBuilder<String, String>.new,
      )
      ..addBuilderFactory(const FullType(BuiltList, [FullType(WebhookInfo)]), ListBuilder<WebhookInfo>.new)
      ..addBuilderFactory(
        const FullType(WebhooksCreateRequestApplicationJson),
        WebhooksCreateRequestApplicationJsonBuilder.new,
      )
      ..add(WebhooksCreateRequestApplicationJson.serializer)
      ..add(WebhooksCreateRequestApplicationJson_AuthMethod.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksCreateResponseApplicationJson),
        WebhooksCreateResponseApplicationJsonBuilder.new,
      )
      ..add(WebhooksCreateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksCreateResponseApplicationJson_Ocs),
        WebhooksCreateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WebhooksCreateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksShowResponseApplicationJson),
        WebhooksShowResponseApplicationJsonBuilder.new,
      )
      ..add(WebhooksShowResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksShowResponseApplicationJson_Ocs),
        WebhooksShowResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WebhooksShowResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksUpdateRequestApplicationJson),
        WebhooksUpdateRequestApplicationJsonBuilder.new,
      )
      ..add(WebhooksUpdateRequestApplicationJson.serializer)
      ..add(WebhooksUpdateRequestApplicationJson_AuthMethod.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksUpdateResponseApplicationJson),
        WebhooksUpdateResponseApplicationJsonBuilder.new,
      )
      ..add(WebhooksUpdateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksUpdateResponseApplicationJson_Ocs),
        WebhooksUpdateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WebhooksUpdateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksDestroyResponseApplicationJson),
        WebhooksDestroyResponseApplicationJsonBuilder.new,
      )
      ..add(WebhooksDestroyResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksDestroyResponseApplicationJson_Ocs),
        WebhooksDestroyResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WebhooksDestroyResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksDeleteByAppIdResponseApplicationJson),
        WebhooksDeleteByAppIdResponseApplicationJsonBuilder.new,
      )
      ..add(WebhooksDeleteByAppIdResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WebhooksDeleteByAppIdResponseApplicationJson_Ocs),
        WebhooksDeleteByAppIdResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WebhooksDeleteByAppIdResponseApplicationJson_Ocs.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(_i8.StandardJsonPlugin())
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
