// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// weather_status Version: 0.0.1.
///
/// Weather status in your dashboard.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i7;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i6;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i5;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;

part 'weather_status.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $WeatherStatusClient weatherStatus = $WeatherStatusClient(this);
}

class $WeatherStatusClient {
  /// Creates a new `DynamiteClient` for weather_status requests.
  $WeatherStatusClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$setMode_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WeatherStatusSetModeResponseApplicationJson, void> $setMode_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(WeatherStatusSetModeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Change the weather status mode. There are currently 2 modes: - ask the browser - use the user defined address.
  ///
  /// Returns a `DynamiteRequest` backing the [setMode] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Weather status mode updated
  ///
  /// See:
  ///  * [setMode] for a method executing this request and parsing the response.
  ///  * [$setMode_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setMode_Request({
    required WeatherStatusSetModeRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/weather_status/api/v1/mode';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(WeatherStatusSetModeRequestApplicationJson)),
    );
    return _request;
  }

  /// Change the weather status mode. There are currently 2 modes: - ask the browser - use the user defined address.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Weather status mode updated
  ///
  /// See:
  ///  * [$setMode_Request] for the request send by this method.
  ///  * [$setMode_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WeatherStatusSetModeResponseApplicationJson, void>> setMode({
    required WeatherStatusSetModeRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setMode_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setMode_Serializer();
    return _i1.ResponseConverter<WeatherStatusSetModeResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$usePersonalAddress_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WeatherStatusUsePersonalAddressResponseApplicationJson, void>
      $usePersonalAddress_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(WeatherStatusUsePersonalAddressResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Try to use the address set in user personal settings as weather location.
  ///
  /// Returns a `DynamiteRequest` backing the [usePersonalAddress] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Address updated
  ///
  /// See:
  ///  * [usePersonalAddress] for a method executing this request and parsing the response.
  ///  * [$usePersonalAddress_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $usePersonalAddress_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/weather_status/api/v1/use-personal';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Try to use the address set in user personal settings as weather location.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Address updated
  ///
  /// See:
  ///  * [$usePersonalAddress_Request] for the request send by this method.
  ///  * [$usePersonalAddress_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WeatherStatusUsePersonalAddressResponseApplicationJson, void>> usePersonalAddress({
    bool? oCSAPIRequest,
  }) async {
    final _request = $usePersonalAddress_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $usePersonalAddress_Serializer();
    return _i1.ResponseConverter<WeatherStatusUsePersonalAddressResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getLocation_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WeatherStatusGetLocationResponseApplicationJson, void> $getLocation_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(WeatherStatusGetLocationResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get stored user location.
  ///
  /// Returns a `DynamiteRequest` backing the [getLocation] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Location returned
  ///
  /// See:
  ///  * [getLocation] for a method executing this request and parsing the response.
  ///  * [$getLocation_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getLocation_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/weather_status/api/v1/location';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get stored user location.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Location returned
  ///
  /// See:
  ///  * [$getLocation_Request] for the request send by this method.
  ///  * [$getLocation_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WeatherStatusGetLocationResponseApplicationJson, void>> getLocation({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getLocation_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getLocation_Serializer();
    return _i1.ResponseConverter<WeatherStatusGetLocationResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setLocation_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WeatherStatusSetLocationResponseApplicationJson, void> $setLocation_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(WeatherStatusSetLocationResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set address and resolve it to get coordinates or directly set coordinates and get address with reverse geocoding.
  ///
  /// Returns a `DynamiteRequest` backing the [setLocation] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Location updated
  ///
  /// See:
  ///  * [setLocation] for a method executing this request and parsing the response.
  ///  * [$setLocation_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setLocation_Request({
    bool? oCSAPIRequest,
    WeatherStatusSetLocationRequestApplicationJson? $body,
  }) {
    const _path = '/ocs/v2.php/apps/weather_status/api/v1/location';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(WeatherStatusSetLocationRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              WeatherStatusSetLocationRequestApplicationJson(),
              specifiedType: const FullType(WeatherStatusSetLocationRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Set address and resolve it to get coordinates or directly set coordinates and get address with reverse geocoding.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Location updated
  ///
  /// See:
  ///  * [$setLocation_Request] for the request send by this method.
  ///  * [$setLocation_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WeatherStatusSetLocationResponseApplicationJson, void>> setLocation({
    bool? oCSAPIRequest,
    WeatherStatusSetLocationRequestApplicationJson? $body,
  }) async {
    final _request = $setLocation_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setLocation_Serializer();
    return _i1.ResponseConverter<WeatherStatusSetLocationResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getForecast_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WeatherStatusGetForecastResponseApplicationJson, void> $getForecast_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(WeatherStatusGetForecastResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get forecast for current location.
  ///
  /// Returns a `DynamiteRequest` backing the [getForecast] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Forecast returned
  ///   * 404: Forecast not found
  ///
  /// See:
  ///  * [getForecast] for a method executing this request and parsing the response.
  ///  * [$getForecast_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getForecast_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/weather_status/api/v1/forecast';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get forecast for current location.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Forecast returned
  ///   * 404: Forecast not found
  ///
  /// See:
  ///  * [$getForecast_Request] for the request send by this method.
  ///  * [$getForecast_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WeatherStatusGetForecastResponseApplicationJson, void>> getForecast({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getForecast_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getForecast_Serializer();
    return _i1.ResponseConverter<WeatherStatusGetForecastResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getFavorites_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WeatherStatusGetFavoritesResponseApplicationJson, void> $getFavorites_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(WeatherStatusGetFavoritesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get favorites list.
  ///
  /// Returns a `DynamiteRequest` backing the [getFavorites] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Favorites returned
  ///
  /// See:
  ///  * [getFavorites] for a method executing this request and parsing the response.
  ///  * [$getFavorites_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getFavorites_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/weather_status/api/v1/favorites';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get favorites list.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Favorites returned
  ///
  /// See:
  ///  * [$getFavorites_Request] for the request send by this method.
  ///  * [$getFavorites_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WeatherStatusGetFavoritesResponseApplicationJson, void>> getFavorites({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getFavorites_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getFavorites_Serializer();
    return _i1.ResponseConverter<WeatherStatusGetFavoritesResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setFavorites_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WeatherStatusSetFavoritesResponseApplicationJson, void> $setFavorites_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(WeatherStatusSetFavoritesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set favorites list.
  ///
  /// Returns a `DynamiteRequest` backing the [setFavorites] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Favorites updated
  ///
  /// See:
  ///  * [setFavorites] for a method executing this request and parsing the response.
  ///  * [$setFavorites_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setFavorites_Request({
    required WeatherStatusSetFavoritesRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/weather_status/api/v1/favorites';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(WeatherStatusSetFavoritesRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Set favorites list.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Favorites updated
  ///
  /// See:
  ///  * [$setFavorites_Request] for the request send by this method.
  ///  * [$setFavorites_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WeatherStatusSetFavoritesResponseApplicationJson, void>> setFavorites({
    required WeatherStatusSetFavoritesRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setFavorites_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setFavorites_Serializer();
    return _i1.ResponseConverter<WeatherStatusSetFavoritesResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetModeRequestApplicationJsonInterface {
  /// New mode.
  int get mode;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetModeRequestApplicationJsonInterfaceBuilder].
  $WeatherStatusSetModeRequestApplicationJsonInterface rebuild(
    void Function($WeatherStatusSetModeRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetModeRequestApplicationJsonInterfaceBuilder].
  $WeatherStatusSetModeRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetModeRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetModeRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusSetModeRequestApplicationJson
    implements
        $WeatherStatusSetModeRequestApplicationJsonInterface,
        Built<WeatherStatusSetModeRequestApplicationJson, WeatherStatusSetModeRequestApplicationJsonBuilder> {
  /// Creates a new WeatherStatusSetModeRequestApplicationJson object using the builder pattern.
  factory WeatherStatusSetModeRequestApplicationJson([
    void Function(WeatherStatusSetModeRequestApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusSetModeRequestApplicationJson;

  // coverage:ignore-start
  const WeatherStatusSetModeRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetModeRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetModeRequestApplicationJson.
  static Serializer<WeatherStatusSetModeRequestApplicationJson> get serializer =>
      _$weatherStatusSetModeRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetModeRequestApplicationJsonBuilder b) {
    $WeatherStatusSetModeRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetModeRequestApplicationJsonBuilder b) {
    $WeatherStatusSetModeRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SuccessInterface {
  bool get success;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SuccessInterfaceBuilder].
  $SuccessInterface rebuild(void Function($SuccessInterfaceBuilder) updates);

  /// Converts the instance to a builder [$SuccessInterfaceBuilder].
  $SuccessInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SuccessInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SuccessInterfaceBuilder b) {}
}

abstract class Success implements $SuccessInterface, Built<Success, SuccessBuilder> {
  /// Creates a new Success object using the builder pattern.
  factory Success([void Function(SuccessBuilder)? b]) = _$Success;

  // coverage:ignore-start
  const Success._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Success.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Success.
  static Serializer<Success> get serializer => _$successSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SuccessBuilder b) {
    $SuccessInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SuccessBuilder b) {
    $SuccessInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetModeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Success get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetModeResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusSetModeResponseApplicationJson_OcsInterface rebuild(
    void Function($WeatherStatusSetModeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetModeResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusSetModeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetModeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetModeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WeatherStatusSetModeResponseApplicationJson_Ocs
    implements
        $WeatherStatusSetModeResponseApplicationJson_OcsInterface,
        Built<WeatherStatusSetModeResponseApplicationJson_Ocs, WeatherStatusSetModeResponseApplicationJson_OcsBuilder> {
  /// Creates a new WeatherStatusSetModeResponseApplicationJson_Ocs object using the builder pattern.
  factory WeatherStatusSetModeResponseApplicationJson_Ocs([
    void Function(WeatherStatusSetModeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WeatherStatusSetModeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WeatherStatusSetModeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetModeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetModeResponseApplicationJson_Ocs.
  static Serializer<WeatherStatusSetModeResponseApplicationJson_Ocs> get serializer =>
      _$weatherStatusSetModeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetModeResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusSetModeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetModeResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusSetModeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetModeResponseApplicationJsonInterface {
  WeatherStatusSetModeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetModeResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusSetModeResponseApplicationJsonInterface rebuild(
    void Function($WeatherStatusSetModeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetModeResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusSetModeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetModeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetModeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusSetModeResponseApplicationJson
    implements
        $WeatherStatusSetModeResponseApplicationJsonInterface,
        Built<WeatherStatusSetModeResponseApplicationJson, WeatherStatusSetModeResponseApplicationJsonBuilder> {
  /// Creates a new WeatherStatusSetModeResponseApplicationJson object using the builder pattern.
  factory WeatherStatusSetModeResponseApplicationJson([
    void Function(WeatherStatusSetModeResponseApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusSetModeResponseApplicationJson;

  // coverage:ignore-start
  const WeatherStatusSetModeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetModeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetModeResponseApplicationJson.
  static Serializer<WeatherStatusSetModeResponseApplicationJson> get serializer =>
      _$weatherStatusSetModeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetModeResponseApplicationJsonBuilder b) {
    $WeatherStatusSetModeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetModeResponseApplicationJsonBuilder b) {
    $WeatherStatusSetModeResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LocationInterface {
  String? get lat;
  String? get lon;
  String? get address;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LocationInterfaceBuilder].
  $LocationInterface rebuild(void Function($LocationInterfaceBuilder) updates);

  /// Converts the instance to a builder [$LocationInterfaceBuilder].
  $LocationInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LocationInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LocationInterfaceBuilder b) {}
}

abstract class Location implements $LocationInterface, Built<Location, LocationBuilder> {
  /// Creates a new Location object using the builder pattern.
  factory Location([void Function(LocationBuilder)? b]) = _$Location;

  // coverage:ignore-start
  const Location._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Location.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Location.
  static Serializer<Location> get serializer => _$locationSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LocationBuilder b) {
    $LocationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LocationBuilder b) {
    $LocationInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LocationWithSuccessInterface implements $LocationInterface, $SuccessInterface {
  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LocationWithSuccessInterfaceBuilder].
  $LocationWithSuccessInterface rebuild(void Function($LocationWithSuccessInterfaceBuilder) updates);

  /// Converts the instance to a builder [$LocationWithSuccessInterfaceBuilder].
  $LocationWithSuccessInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LocationWithSuccessInterfaceBuilder b) {
    $LocationInterface._defaults(b);
    $SuccessInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LocationWithSuccessInterfaceBuilder b) {
    $LocationInterface._validate(b);
    $SuccessInterface._validate(b);
  }
}

abstract class LocationWithSuccess
    implements $LocationWithSuccessInterface, Built<LocationWithSuccess, LocationWithSuccessBuilder> {
  /// Creates a new LocationWithSuccess object using the builder pattern.
  factory LocationWithSuccess([void Function(LocationWithSuccessBuilder)? b]) = _$LocationWithSuccess;

  // coverage:ignore-start
  const LocationWithSuccess._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory LocationWithSuccess.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for LocationWithSuccess.
  static Serializer<LocationWithSuccess> get serializer => _$locationWithSuccessSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LocationWithSuccessBuilder b) {
    $LocationWithSuccessInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LocationWithSuccessBuilder b) {
    $LocationWithSuccessInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  LocationWithSuccess get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterface rebuild(
    void Function($WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs
    implements
        $WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterface,
        Built<WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs,
            WeatherStatusUsePersonalAddressResponseApplicationJson_OcsBuilder> {
  /// Creates a new WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs object using the builder pattern.
  factory WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs([
    void Function(WeatherStatusUsePersonalAddressResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs.
  static Serializer<WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs> get serializer =>
      _$weatherStatusUsePersonalAddressResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusUsePersonalAddressResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusUsePersonalAddressResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusUsePersonalAddressResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusUsePersonalAddressResponseApplicationJsonInterface {
  WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusUsePersonalAddressResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusUsePersonalAddressResponseApplicationJsonInterface rebuild(
    void Function($WeatherStatusUsePersonalAddressResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusUsePersonalAddressResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusUsePersonalAddressResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusUsePersonalAddressResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusUsePersonalAddressResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusUsePersonalAddressResponseApplicationJson
    implements
        $WeatherStatusUsePersonalAddressResponseApplicationJsonInterface,
        Built<WeatherStatusUsePersonalAddressResponseApplicationJson,
            WeatherStatusUsePersonalAddressResponseApplicationJsonBuilder> {
  /// Creates a new WeatherStatusUsePersonalAddressResponseApplicationJson object using the builder pattern.
  factory WeatherStatusUsePersonalAddressResponseApplicationJson([
    void Function(WeatherStatusUsePersonalAddressResponseApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusUsePersonalAddressResponseApplicationJson;

  // coverage:ignore-start
  const WeatherStatusUsePersonalAddressResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusUsePersonalAddressResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusUsePersonalAddressResponseApplicationJson.
  static Serializer<WeatherStatusUsePersonalAddressResponseApplicationJson> get serializer =>
      _$weatherStatusUsePersonalAddressResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusUsePersonalAddressResponseApplicationJsonBuilder b) {
    $WeatherStatusUsePersonalAddressResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusUsePersonalAddressResponseApplicationJsonBuilder b) {
    $WeatherStatusUsePersonalAddressResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ModeInterface {
  int get mode;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ModeInterfaceBuilder].
  $ModeInterface rebuild(void Function($ModeInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ModeInterfaceBuilder].
  $ModeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ModeInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ModeInterfaceBuilder b) {}
}

abstract class Mode implements $ModeInterface, Built<Mode, ModeBuilder> {
  /// Creates a new Mode object using the builder pattern.
  factory Mode([void Function(ModeBuilder)? b]) = _$Mode;

  // coverage:ignore-start
  const Mode._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Mode.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Mode.
  static Serializer<Mode> get serializer => _$modeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ModeBuilder b) {
    $ModeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ModeBuilder b) {
    $ModeInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LocationWithModeInterface implements $LocationInterface, $ModeInterface {
  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LocationWithModeInterfaceBuilder].
  $LocationWithModeInterface rebuild(void Function($LocationWithModeInterfaceBuilder) updates);

  /// Converts the instance to a builder [$LocationWithModeInterfaceBuilder].
  $LocationWithModeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LocationWithModeInterfaceBuilder b) {
    $LocationInterface._defaults(b);
    $ModeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LocationWithModeInterfaceBuilder b) {
    $LocationInterface._validate(b);
    $ModeInterface._validate(b);
  }
}

abstract class LocationWithMode
    implements $LocationWithModeInterface, Built<LocationWithMode, LocationWithModeBuilder> {
  /// Creates a new LocationWithMode object using the builder pattern.
  factory LocationWithMode([void Function(LocationWithModeBuilder)? b]) = _$LocationWithMode;

  // coverage:ignore-start
  const LocationWithMode._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory LocationWithMode.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for LocationWithMode.
  static Serializer<LocationWithMode> get serializer => _$locationWithModeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LocationWithModeBuilder b) {
    $LocationWithModeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LocationWithModeBuilder b) {
    $LocationWithModeInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusGetLocationResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  LocationWithMode get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusGetLocationResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusGetLocationResponseApplicationJson_OcsInterface rebuild(
    void Function($WeatherStatusGetLocationResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusGetLocationResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusGetLocationResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusGetLocationResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusGetLocationResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WeatherStatusGetLocationResponseApplicationJson_Ocs
    implements
        $WeatherStatusGetLocationResponseApplicationJson_OcsInterface,
        Built<WeatherStatusGetLocationResponseApplicationJson_Ocs,
            WeatherStatusGetLocationResponseApplicationJson_OcsBuilder> {
  /// Creates a new WeatherStatusGetLocationResponseApplicationJson_Ocs object using the builder pattern.
  factory WeatherStatusGetLocationResponseApplicationJson_Ocs([
    void Function(WeatherStatusGetLocationResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WeatherStatusGetLocationResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WeatherStatusGetLocationResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusGetLocationResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusGetLocationResponseApplicationJson_Ocs.
  static Serializer<WeatherStatusGetLocationResponseApplicationJson_Ocs> get serializer =>
      _$weatherStatusGetLocationResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusGetLocationResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusGetLocationResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusGetLocationResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusGetLocationResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusGetLocationResponseApplicationJsonInterface {
  WeatherStatusGetLocationResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusGetLocationResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusGetLocationResponseApplicationJsonInterface rebuild(
    void Function($WeatherStatusGetLocationResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusGetLocationResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusGetLocationResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusGetLocationResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusGetLocationResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusGetLocationResponseApplicationJson
    implements
        $WeatherStatusGetLocationResponseApplicationJsonInterface,
        Built<WeatherStatusGetLocationResponseApplicationJson, WeatherStatusGetLocationResponseApplicationJsonBuilder> {
  /// Creates a new WeatherStatusGetLocationResponseApplicationJson object using the builder pattern.
  factory WeatherStatusGetLocationResponseApplicationJson([
    void Function(WeatherStatusGetLocationResponseApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusGetLocationResponseApplicationJson;

  // coverage:ignore-start
  const WeatherStatusGetLocationResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusGetLocationResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusGetLocationResponseApplicationJson.
  static Serializer<WeatherStatusGetLocationResponseApplicationJson> get serializer =>
      _$weatherStatusGetLocationResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusGetLocationResponseApplicationJsonBuilder b) {
    $WeatherStatusGetLocationResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusGetLocationResponseApplicationJsonBuilder b) {
    $WeatherStatusGetLocationResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetLocationRequestApplicationJsonInterface {
  /// Any approximative or exact address.
  String? get address;

  /// Latitude in decimal degree format.
  double? get lat;

  /// Longitude in decimal degree format.
  double? get lon;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetLocationRequestApplicationJsonInterfaceBuilder].
  $WeatherStatusSetLocationRequestApplicationJsonInterface rebuild(
    void Function($WeatherStatusSetLocationRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetLocationRequestApplicationJsonInterfaceBuilder].
  $WeatherStatusSetLocationRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetLocationRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetLocationRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusSetLocationRequestApplicationJson
    implements
        $WeatherStatusSetLocationRequestApplicationJsonInterface,
        Built<WeatherStatusSetLocationRequestApplicationJson, WeatherStatusSetLocationRequestApplicationJsonBuilder> {
  /// Creates a new WeatherStatusSetLocationRequestApplicationJson object using the builder pattern.
  factory WeatherStatusSetLocationRequestApplicationJson([
    void Function(WeatherStatusSetLocationRequestApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusSetLocationRequestApplicationJson;

  // coverage:ignore-start
  const WeatherStatusSetLocationRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetLocationRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetLocationRequestApplicationJson.
  static Serializer<WeatherStatusSetLocationRequestApplicationJson> get serializer =>
      _$weatherStatusSetLocationRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetLocationRequestApplicationJsonBuilder b) {
    $WeatherStatusSetLocationRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetLocationRequestApplicationJsonBuilder b) {
    $WeatherStatusSetLocationRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetLocationResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  LocationWithSuccess get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetLocationResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusSetLocationResponseApplicationJson_OcsInterface rebuild(
    void Function($WeatherStatusSetLocationResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetLocationResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusSetLocationResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetLocationResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetLocationResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WeatherStatusSetLocationResponseApplicationJson_Ocs
    implements
        $WeatherStatusSetLocationResponseApplicationJson_OcsInterface,
        Built<WeatherStatusSetLocationResponseApplicationJson_Ocs,
            WeatherStatusSetLocationResponseApplicationJson_OcsBuilder> {
  /// Creates a new WeatherStatusSetLocationResponseApplicationJson_Ocs object using the builder pattern.
  factory WeatherStatusSetLocationResponseApplicationJson_Ocs([
    void Function(WeatherStatusSetLocationResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WeatherStatusSetLocationResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WeatherStatusSetLocationResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetLocationResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetLocationResponseApplicationJson_Ocs.
  static Serializer<WeatherStatusSetLocationResponseApplicationJson_Ocs> get serializer =>
      _$weatherStatusSetLocationResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetLocationResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusSetLocationResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetLocationResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusSetLocationResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetLocationResponseApplicationJsonInterface {
  WeatherStatusSetLocationResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetLocationResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusSetLocationResponseApplicationJsonInterface rebuild(
    void Function($WeatherStatusSetLocationResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetLocationResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusSetLocationResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetLocationResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetLocationResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusSetLocationResponseApplicationJson
    implements
        $WeatherStatusSetLocationResponseApplicationJsonInterface,
        Built<WeatherStatusSetLocationResponseApplicationJson, WeatherStatusSetLocationResponseApplicationJsonBuilder> {
  /// Creates a new WeatherStatusSetLocationResponseApplicationJson object using the builder pattern.
  factory WeatherStatusSetLocationResponseApplicationJson([
    void Function(WeatherStatusSetLocationResponseApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusSetLocationResponseApplicationJson;

  // coverage:ignore-start
  const WeatherStatusSetLocationResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetLocationResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetLocationResponseApplicationJson.
  static Serializer<WeatherStatusSetLocationResponseApplicationJson> get serializer =>
      _$weatherStatusSetLocationResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetLocationResponseApplicationJsonBuilder b) {
    $WeatherStatusSetLocationResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetLocationResponseApplicationJsonBuilder b) {
    $WeatherStatusSetLocationResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Instant_DetailsInterface {
  @BuiltValueField(wireName: 'air_pressure_at_sea_level')
  num get airPressureAtSeaLevel;
  @BuiltValueField(wireName: 'air_temperature')
  num get airTemperature;
  @BuiltValueField(wireName: 'cloud_area_fraction')
  num get cloudAreaFraction;
  @BuiltValueField(wireName: 'relative_humidity')
  num get relativeHumidity;
  @BuiltValueField(wireName: 'wind_from_direction')
  num get windFromDirection;
  @BuiltValueField(wireName: 'wind_speed')
  num get windSpeed;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Instant_DetailsInterfaceBuilder].
  $Forecast_Data_Instant_DetailsInterface rebuild(
    void Function($Forecast_Data_Instant_DetailsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Forecast_Data_Instant_DetailsInterfaceBuilder].
  $Forecast_Data_Instant_DetailsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Instant_DetailsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Instant_DetailsInterfaceBuilder b) {}
}

abstract class Forecast_Data_Instant_Details
    implements
        $Forecast_Data_Instant_DetailsInterface,
        Built<Forecast_Data_Instant_Details, Forecast_Data_Instant_DetailsBuilder> {
  /// Creates a new Forecast_Data_Instant_Details object using the builder pattern.
  factory Forecast_Data_Instant_Details([void Function(Forecast_Data_Instant_DetailsBuilder)? b]) =
      _$Forecast_Data_Instant_Details;

  // coverage:ignore-start
  const Forecast_Data_Instant_Details._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Instant_Details.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Instant_Details.
  static Serializer<Forecast_Data_Instant_Details> get serializer => _$forecastDataInstantDetailsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Instant_DetailsBuilder b) {
    $Forecast_Data_Instant_DetailsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Instant_DetailsBuilder b) {
    $Forecast_Data_Instant_DetailsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_InstantInterface {
  Forecast_Data_Instant_Details get details;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_InstantInterfaceBuilder].
  $Forecast_Data_InstantInterface rebuild(void Function($Forecast_Data_InstantInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Forecast_Data_InstantInterfaceBuilder].
  $Forecast_Data_InstantInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_InstantInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_InstantInterfaceBuilder b) {}
}

abstract class Forecast_Data_Instant
    implements $Forecast_Data_InstantInterface, Built<Forecast_Data_Instant, Forecast_Data_InstantBuilder> {
  /// Creates a new Forecast_Data_Instant object using the builder pattern.
  factory Forecast_Data_Instant([void Function(Forecast_Data_InstantBuilder)? b]) = _$Forecast_Data_Instant;

  // coverage:ignore-start
  const Forecast_Data_Instant._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Instant.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Instant.
  static Serializer<Forecast_Data_Instant> get serializer => _$forecastDataInstantSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_InstantBuilder b) {
    $Forecast_Data_InstantInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_InstantBuilder b) {
    $Forecast_Data_InstantInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next12Hours_SummaryInterface {
  @BuiltValueField(wireName: 'symbol_code')
  String get symbolCode;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next12Hours_SummaryInterfaceBuilder].
  $Forecast_Data_Next12Hours_SummaryInterface rebuild(
    void Function($Forecast_Data_Next12Hours_SummaryInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Forecast_Data_Next12Hours_SummaryInterfaceBuilder].
  $Forecast_Data_Next12Hours_SummaryInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next12Hours_SummaryInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next12Hours_SummaryInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next12Hours_Summary
    implements
        $Forecast_Data_Next12Hours_SummaryInterface,
        Built<Forecast_Data_Next12Hours_Summary, Forecast_Data_Next12Hours_SummaryBuilder> {
  /// Creates a new Forecast_Data_Next12Hours_Summary object using the builder pattern.
  factory Forecast_Data_Next12Hours_Summary([void Function(Forecast_Data_Next12Hours_SummaryBuilder)? b]) =
      _$Forecast_Data_Next12Hours_Summary;

  // coverage:ignore-start
  const Forecast_Data_Next12Hours_Summary._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next12Hours_Summary.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next12Hours_Summary.
  static Serializer<Forecast_Data_Next12Hours_Summary> get serializer => _$forecastDataNext12HoursSummarySerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next12Hours_SummaryBuilder b) {
    $Forecast_Data_Next12Hours_SummaryInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next12Hours_SummaryBuilder b) {
    $Forecast_Data_Next12Hours_SummaryInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next12Hours_DetailsInterface {
  @BuiltValueField(wireName: 'precipitation_amount')
  num? get precipitationAmount;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next12Hours_DetailsInterfaceBuilder].
  $Forecast_Data_Next12Hours_DetailsInterface rebuild(
    void Function($Forecast_Data_Next12Hours_DetailsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Forecast_Data_Next12Hours_DetailsInterfaceBuilder].
  $Forecast_Data_Next12Hours_DetailsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next12Hours_DetailsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next12Hours_DetailsInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next12Hours_Details
    implements
        $Forecast_Data_Next12Hours_DetailsInterface,
        Built<Forecast_Data_Next12Hours_Details, Forecast_Data_Next12Hours_DetailsBuilder> {
  /// Creates a new Forecast_Data_Next12Hours_Details object using the builder pattern.
  factory Forecast_Data_Next12Hours_Details([void Function(Forecast_Data_Next12Hours_DetailsBuilder)? b]) =
      _$Forecast_Data_Next12Hours_Details;

  // coverage:ignore-start
  const Forecast_Data_Next12Hours_Details._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next12Hours_Details.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next12Hours_Details.
  static Serializer<Forecast_Data_Next12Hours_Details> get serializer => _$forecastDataNext12HoursDetailsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next12Hours_DetailsBuilder b) {
    $Forecast_Data_Next12Hours_DetailsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next12Hours_DetailsBuilder b) {
    $Forecast_Data_Next12Hours_DetailsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next12HoursInterface {
  Forecast_Data_Next12Hours_Summary get summary;
  Forecast_Data_Next12Hours_Details get details;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next12HoursInterfaceBuilder].
  $Forecast_Data_Next12HoursInterface rebuild(void Function($Forecast_Data_Next12HoursInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Forecast_Data_Next12HoursInterfaceBuilder].
  $Forecast_Data_Next12HoursInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next12HoursInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next12HoursInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next12Hours
    implements $Forecast_Data_Next12HoursInterface, Built<Forecast_Data_Next12Hours, Forecast_Data_Next12HoursBuilder> {
  /// Creates a new Forecast_Data_Next12Hours object using the builder pattern.
  factory Forecast_Data_Next12Hours([void Function(Forecast_Data_Next12HoursBuilder)? b]) = _$Forecast_Data_Next12Hours;

  // coverage:ignore-start
  const Forecast_Data_Next12Hours._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next12Hours.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next12Hours.
  static Serializer<Forecast_Data_Next12Hours> get serializer => _$forecastDataNext12HoursSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next12HoursBuilder b) {
    $Forecast_Data_Next12HoursInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next12HoursBuilder b) {
    $Forecast_Data_Next12HoursInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next1Hours_SummaryInterface {
  @BuiltValueField(wireName: 'symbol_code')
  String get symbolCode;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next1Hours_SummaryInterfaceBuilder].
  $Forecast_Data_Next1Hours_SummaryInterface rebuild(
    void Function($Forecast_Data_Next1Hours_SummaryInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Forecast_Data_Next1Hours_SummaryInterfaceBuilder].
  $Forecast_Data_Next1Hours_SummaryInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next1Hours_SummaryInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next1Hours_SummaryInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next1Hours_Summary
    implements
        $Forecast_Data_Next1Hours_SummaryInterface,
        Built<Forecast_Data_Next1Hours_Summary, Forecast_Data_Next1Hours_SummaryBuilder> {
  /// Creates a new Forecast_Data_Next1Hours_Summary object using the builder pattern.
  factory Forecast_Data_Next1Hours_Summary([void Function(Forecast_Data_Next1Hours_SummaryBuilder)? b]) =
      _$Forecast_Data_Next1Hours_Summary;

  // coverage:ignore-start
  const Forecast_Data_Next1Hours_Summary._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next1Hours_Summary.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next1Hours_Summary.
  static Serializer<Forecast_Data_Next1Hours_Summary> get serializer => _$forecastDataNext1HoursSummarySerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next1Hours_SummaryBuilder b) {
    $Forecast_Data_Next1Hours_SummaryInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next1Hours_SummaryBuilder b) {
    $Forecast_Data_Next1Hours_SummaryInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next1Hours_DetailsInterface {
  @BuiltValueField(wireName: 'precipitation_amount')
  num? get precipitationAmount;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next1Hours_DetailsInterfaceBuilder].
  $Forecast_Data_Next1Hours_DetailsInterface rebuild(
    void Function($Forecast_Data_Next1Hours_DetailsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Forecast_Data_Next1Hours_DetailsInterfaceBuilder].
  $Forecast_Data_Next1Hours_DetailsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next1Hours_DetailsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next1Hours_DetailsInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next1Hours_Details
    implements
        $Forecast_Data_Next1Hours_DetailsInterface,
        Built<Forecast_Data_Next1Hours_Details, Forecast_Data_Next1Hours_DetailsBuilder> {
  /// Creates a new Forecast_Data_Next1Hours_Details object using the builder pattern.
  factory Forecast_Data_Next1Hours_Details([void Function(Forecast_Data_Next1Hours_DetailsBuilder)? b]) =
      _$Forecast_Data_Next1Hours_Details;

  // coverage:ignore-start
  const Forecast_Data_Next1Hours_Details._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next1Hours_Details.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next1Hours_Details.
  static Serializer<Forecast_Data_Next1Hours_Details> get serializer => _$forecastDataNext1HoursDetailsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next1Hours_DetailsBuilder b) {
    $Forecast_Data_Next1Hours_DetailsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next1Hours_DetailsBuilder b) {
    $Forecast_Data_Next1Hours_DetailsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next1HoursInterface {
  Forecast_Data_Next1Hours_Summary get summary;
  Forecast_Data_Next1Hours_Details get details;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next1HoursInterfaceBuilder].
  $Forecast_Data_Next1HoursInterface rebuild(void Function($Forecast_Data_Next1HoursInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Forecast_Data_Next1HoursInterfaceBuilder].
  $Forecast_Data_Next1HoursInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next1HoursInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next1HoursInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next1Hours
    implements $Forecast_Data_Next1HoursInterface, Built<Forecast_Data_Next1Hours, Forecast_Data_Next1HoursBuilder> {
  /// Creates a new Forecast_Data_Next1Hours object using the builder pattern.
  factory Forecast_Data_Next1Hours([void Function(Forecast_Data_Next1HoursBuilder)? b]) = _$Forecast_Data_Next1Hours;

  // coverage:ignore-start
  const Forecast_Data_Next1Hours._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next1Hours.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next1Hours.
  static Serializer<Forecast_Data_Next1Hours> get serializer => _$forecastDataNext1HoursSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next1HoursBuilder b) {
    $Forecast_Data_Next1HoursInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next1HoursBuilder b) {
    $Forecast_Data_Next1HoursInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next6Hours_SummaryInterface {
  @BuiltValueField(wireName: 'symbol_code')
  String get symbolCode;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next6Hours_SummaryInterfaceBuilder].
  $Forecast_Data_Next6Hours_SummaryInterface rebuild(
    void Function($Forecast_Data_Next6Hours_SummaryInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Forecast_Data_Next6Hours_SummaryInterfaceBuilder].
  $Forecast_Data_Next6Hours_SummaryInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next6Hours_SummaryInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next6Hours_SummaryInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next6Hours_Summary
    implements
        $Forecast_Data_Next6Hours_SummaryInterface,
        Built<Forecast_Data_Next6Hours_Summary, Forecast_Data_Next6Hours_SummaryBuilder> {
  /// Creates a new Forecast_Data_Next6Hours_Summary object using the builder pattern.
  factory Forecast_Data_Next6Hours_Summary([void Function(Forecast_Data_Next6Hours_SummaryBuilder)? b]) =
      _$Forecast_Data_Next6Hours_Summary;

  // coverage:ignore-start
  const Forecast_Data_Next6Hours_Summary._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next6Hours_Summary.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next6Hours_Summary.
  static Serializer<Forecast_Data_Next6Hours_Summary> get serializer => _$forecastDataNext6HoursSummarySerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next6Hours_SummaryBuilder b) {
    $Forecast_Data_Next6Hours_SummaryInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next6Hours_SummaryBuilder b) {
    $Forecast_Data_Next6Hours_SummaryInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next6Hours_DetailsInterface {
  @BuiltValueField(wireName: 'precipitation_amount')
  num? get precipitationAmount;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next6Hours_DetailsInterfaceBuilder].
  $Forecast_Data_Next6Hours_DetailsInterface rebuild(
    void Function($Forecast_Data_Next6Hours_DetailsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Forecast_Data_Next6Hours_DetailsInterfaceBuilder].
  $Forecast_Data_Next6Hours_DetailsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next6Hours_DetailsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next6Hours_DetailsInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next6Hours_Details
    implements
        $Forecast_Data_Next6Hours_DetailsInterface,
        Built<Forecast_Data_Next6Hours_Details, Forecast_Data_Next6Hours_DetailsBuilder> {
  /// Creates a new Forecast_Data_Next6Hours_Details object using the builder pattern.
  factory Forecast_Data_Next6Hours_Details([void Function(Forecast_Data_Next6Hours_DetailsBuilder)? b]) =
      _$Forecast_Data_Next6Hours_Details;

  // coverage:ignore-start
  const Forecast_Data_Next6Hours_Details._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next6Hours_Details.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next6Hours_Details.
  static Serializer<Forecast_Data_Next6Hours_Details> get serializer => _$forecastDataNext6HoursDetailsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next6Hours_DetailsBuilder b) {
    $Forecast_Data_Next6Hours_DetailsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next6Hours_DetailsBuilder b) {
    $Forecast_Data_Next6Hours_DetailsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_Data_Next6HoursInterface {
  Forecast_Data_Next6Hours_Summary get summary;
  Forecast_Data_Next6Hours_Details get details;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_Data_Next6HoursInterfaceBuilder].
  $Forecast_Data_Next6HoursInterface rebuild(void Function($Forecast_Data_Next6HoursInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Forecast_Data_Next6HoursInterfaceBuilder].
  $Forecast_Data_Next6HoursInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_Data_Next6HoursInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_Data_Next6HoursInterfaceBuilder b) {}
}

abstract class Forecast_Data_Next6Hours
    implements $Forecast_Data_Next6HoursInterface, Built<Forecast_Data_Next6Hours, Forecast_Data_Next6HoursBuilder> {
  /// Creates a new Forecast_Data_Next6Hours object using the builder pattern.
  factory Forecast_Data_Next6Hours([void Function(Forecast_Data_Next6HoursBuilder)? b]) = _$Forecast_Data_Next6Hours;

  // coverage:ignore-start
  const Forecast_Data_Next6Hours._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data_Next6Hours.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data_Next6Hours.
  static Serializer<Forecast_Data_Next6Hours> get serializer => _$forecastDataNext6HoursSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_Data_Next6HoursBuilder b) {
    $Forecast_Data_Next6HoursInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_Data_Next6HoursBuilder b) {
    $Forecast_Data_Next6HoursInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Forecast_DataInterface {
  Forecast_Data_Instant get instant;
  @BuiltValueField(wireName: 'next_12_hours')
  Forecast_Data_Next12Hours get next12Hours;
  @BuiltValueField(wireName: 'next_1_hours')
  Forecast_Data_Next1Hours get next1Hours;
  @BuiltValueField(wireName: 'next_6_hours')
  Forecast_Data_Next6Hours get next6Hours;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Forecast_DataInterfaceBuilder].
  $Forecast_DataInterface rebuild(void Function($Forecast_DataInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Forecast_DataInterfaceBuilder].
  $Forecast_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Forecast_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Forecast_DataInterfaceBuilder b) {}
}

abstract class Forecast_Data implements $Forecast_DataInterface, Built<Forecast_Data, Forecast_DataBuilder> {
  /// Creates a new Forecast_Data object using the builder pattern.
  factory Forecast_Data([void Function(Forecast_DataBuilder)? b]) = _$Forecast_Data;

  // coverage:ignore-start
  const Forecast_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast_Data.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast_Data.
  static Serializer<Forecast_Data> get serializer => _$forecastDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Forecast_DataBuilder b) {
    $Forecast_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Forecast_DataBuilder b) {
    $Forecast_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ForecastInterface {
  String get time;
  Forecast_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ForecastInterfaceBuilder].
  $ForecastInterface rebuild(void Function($ForecastInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ForecastInterfaceBuilder].
  $ForecastInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ForecastInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ForecastInterfaceBuilder b) {}
}

abstract class Forecast implements $ForecastInterface, Built<Forecast, ForecastBuilder> {
  /// Creates a new Forecast object using the builder pattern.
  factory Forecast([void Function(ForecastBuilder)? b]) = _$Forecast;

  // coverage:ignore-start
  const Forecast._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Forecast.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Forecast.
  static Serializer<Forecast> get serializer => _$forecastSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ForecastBuilder b) {
    $ForecastInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ForecastBuilder b) {
    $ForecastInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Interface {
  String get error;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1InterfaceBuilder].
  $WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Interface rebuild(
    void Function($WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1InterfaceBuilder].
  $WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1InterfaceBuilder b) {}
}

abstract class WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1
    implements
        $WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Interface,
        Built<WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1,
            WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Builder> {
  /// Creates a new WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1 object using the builder pattern.
  factory WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1([
    void Function(WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Builder)? b,
  ]) = _$WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1;

  // coverage:ignore-start
  const WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1.
  static Serializer<WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1> get serializer =>
      _$weatherStatusGetForecastResponseApplicationJsonOcsData1Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Builder b) {
    $WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Builder b) {
    $WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Interface._validate(b);
  }
}

typedef WeatherStatusGetForecastResponseApplicationJson_Ocs_Data = ({
  BuiltList<Forecast>? builtListForecast,
  WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1? weatherStatusGetForecastResponseApplicationJsonOcsData1
});

@BuiltValue(instantiable: false)
sealed class $WeatherStatusGetForecastResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  WeatherStatusGetForecastResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusGetForecastResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusGetForecastResponseApplicationJson_OcsInterface rebuild(
    void Function($WeatherStatusGetForecastResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusGetForecastResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusGetForecastResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusGetForecastResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusGetForecastResponseApplicationJson_OcsInterfaceBuilder b) {
    b.data?.validateOneOf();
  }
}

abstract class WeatherStatusGetForecastResponseApplicationJson_Ocs
    implements
        $WeatherStatusGetForecastResponseApplicationJson_OcsInterface,
        Built<WeatherStatusGetForecastResponseApplicationJson_Ocs,
            WeatherStatusGetForecastResponseApplicationJson_OcsBuilder> {
  /// Creates a new WeatherStatusGetForecastResponseApplicationJson_Ocs object using the builder pattern.
  factory WeatherStatusGetForecastResponseApplicationJson_Ocs([
    void Function(WeatherStatusGetForecastResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WeatherStatusGetForecastResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WeatherStatusGetForecastResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusGetForecastResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusGetForecastResponseApplicationJson_Ocs.
  static Serializer<WeatherStatusGetForecastResponseApplicationJson_Ocs> get serializer =>
      _$weatherStatusGetForecastResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusGetForecastResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusGetForecastResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusGetForecastResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusGetForecastResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusGetForecastResponseApplicationJsonInterface {
  WeatherStatusGetForecastResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusGetForecastResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusGetForecastResponseApplicationJsonInterface rebuild(
    void Function($WeatherStatusGetForecastResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusGetForecastResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusGetForecastResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusGetForecastResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusGetForecastResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusGetForecastResponseApplicationJson
    implements
        $WeatherStatusGetForecastResponseApplicationJsonInterface,
        Built<WeatherStatusGetForecastResponseApplicationJson, WeatherStatusGetForecastResponseApplicationJsonBuilder> {
  /// Creates a new WeatherStatusGetForecastResponseApplicationJson object using the builder pattern.
  factory WeatherStatusGetForecastResponseApplicationJson([
    void Function(WeatherStatusGetForecastResponseApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusGetForecastResponseApplicationJson;

  // coverage:ignore-start
  const WeatherStatusGetForecastResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusGetForecastResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusGetForecastResponseApplicationJson.
  static Serializer<WeatherStatusGetForecastResponseApplicationJson> get serializer =>
      _$weatherStatusGetForecastResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusGetForecastResponseApplicationJsonBuilder b) {
    $WeatherStatusGetForecastResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusGetForecastResponseApplicationJsonBuilder b) {
    $WeatherStatusGetForecastResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusGetFavoritesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<String> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusGetFavoritesResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusGetFavoritesResponseApplicationJson_OcsInterface rebuild(
    void Function($WeatherStatusGetFavoritesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusGetFavoritesResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusGetFavoritesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusGetFavoritesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusGetFavoritesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WeatherStatusGetFavoritesResponseApplicationJson_Ocs
    implements
        $WeatherStatusGetFavoritesResponseApplicationJson_OcsInterface,
        Built<WeatherStatusGetFavoritesResponseApplicationJson_Ocs,
            WeatherStatusGetFavoritesResponseApplicationJson_OcsBuilder> {
  /// Creates a new WeatherStatusGetFavoritesResponseApplicationJson_Ocs object using the builder pattern.
  factory WeatherStatusGetFavoritesResponseApplicationJson_Ocs([
    void Function(WeatherStatusGetFavoritesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WeatherStatusGetFavoritesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WeatherStatusGetFavoritesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusGetFavoritesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusGetFavoritesResponseApplicationJson_Ocs.
  static Serializer<WeatherStatusGetFavoritesResponseApplicationJson_Ocs> get serializer =>
      _$weatherStatusGetFavoritesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusGetFavoritesResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusGetFavoritesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusGetFavoritesResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusGetFavoritesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusGetFavoritesResponseApplicationJsonInterface {
  WeatherStatusGetFavoritesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusGetFavoritesResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusGetFavoritesResponseApplicationJsonInterface rebuild(
    void Function($WeatherStatusGetFavoritesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusGetFavoritesResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusGetFavoritesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusGetFavoritesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusGetFavoritesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusGetFavoritesResponseApplicationJson
    implements
        $WeatherStatusGetFavoritesResponseApplicationJsonInterface,
        Built<WeatherStatusGetFavoritesResponseApplicationJson,
            WeatherStatusGetFavoritesResponseApplicationJsonBuilder> {
  /// Creates a new WeatherStatusGetFavoritesResponseApplicationJson object using the builder pattern.
  factory WeatherStatusGetFavoritesResponseApplicationJson([
    void Function(WeatherStatusGetFavoritesResponseApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusGetFavoritesResponseApplicationJson;

  // coverage:ignore-start
  const WeatherStatusGetFavoritesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusGetFavoritesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusGetFavoritesResponseApplicationJson.
  static Serializer<WeatherStatusGetFavoritesResponseApplicationJson> get serializer =>
      _$weatherStatusGetFavoritesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusGetFavoritesResponseApplicationJsonBuilder b) {
    $WeatherStatusGetFavoritesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusGetFavoritesResponseApplicationJsonBuilder b) {
    $WeatherStatusGetFavoritesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetFavoritesRequestApplicationJsonInterface {
  /// Favorite addresses.
  BuiltList<String> get favorites;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetFavoritesRequestApplicationJsonInterfaceBuilder].
  $WeatherStatusSetFavoritesRequestApplicationJsonInterface rebuild(
    void Function($WeatherStatusSetFavoritesRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetFavoritesRequestApplicationJsonInterfaceBuilder].
  $WeatherStatusSetFavoritesRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetFavoritesRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetFavoritesRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusSetFavoritesRequestApplicationJson
    implements
        $WeatherStatusSetFavoritesRequestApplicationJsonInterface,
        Built<WeatherStatusSetFavoritesRequestApplicationJson, WeatherStatusSetFavoritesRequestApplicationJsonBuilder> {
  /// Creates a new WeatherStatusSetFavoritesRequestApplicationJson object using the builder pattern.
  factory WeatherStatusSetFavoritesRequestApplicationJson([
    void Function(WeatherStatusSetFavoritesRequestApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusSetFavoritesRequestApplicationJson;

  // coverage:ignore-start
  const WeatherStatusSetFavoritesRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetFavoritesRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetFavoritesRequestApplicationJson.
  static Serializer<WeatherStatusSetFavoritesRequestApplicationJson> get serializer =>
      _$weatherStatusSetFavoritesRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetFavoritesRequestApplicationJsonBuilder b) {
    $WeatherStatusSetFavoritesRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetFavoritesRequestApplicationJsonBuilder b) {
    $WeatherStatusSetFavoritesRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetFavoritesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Success get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetFavoritesResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusSetFavoritesResponseApplicationJson_OcsInterface rebuild(
    void Function($WeatherStatusSetFavoritesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetFavoritesResponseApplicationJson_OcsInterfaceBuilder].
  $WeatherStatusSetFavoritesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetFavoritesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetFavoritesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class WeatherStatusSetFavoritesResponseApplicationJson_Ocs
    implements
        $WeatherStatusSetFavoritesResponseApplicationJson_OcsInterface,
        Built<WeatherStatusSetFavoritesResponseApplicationJson_Ocs,
            WeatherStatusSetFavoritesResponseApplicationJson_OcsBuilder> {
  /// Creates a new WeatherStatusSetFavoritesResponseApplicationJson_Ocs object using the builder pattern.
  factory WeatherStatusSetFavoritesResponseApplicationJson_Ocs([
    void Function(WeatherStatusSetFavoritesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$WeatherStatusSetFavoritesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const WeatherStatusSetFavoritesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetFavoritesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetFavoritesResponseApplicationJson_Ocs.
  static Serializer<WeatherStatusSetFavoritesResponseApplicationJson_Ocs> get serializer =>
      _$weatherStatusSetFavoritesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetFavoritesResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusSetFavoritesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetFavoritesResponseApplicationJson_OcsBuilder b) {
    $WeatherStatusSetFavoritesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusSetFavoritesResponseApplicationJsonInterface {
  WeatherStatusSetFavoritesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusSetFavoritesResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusSetFavoritesResponseApplicationJsonInterface rebuild(
    void Function($WeatherStatusSetFavoritesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusSetFavoritesResponseApplicationJsonInterfaceBuilder].
  $WeatherStatusSetFavoritesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusSetFavoritesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusSetFavoritesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class WeatherStatusSetFavoritesResponseApplicationJson
    implements
        $WeatherStatusSetFavoritesResponseApplicationJsonInterface,
        Built<WeatherStatusSetFavoritesResponseApplicationJson,
            WeatherStatusSetFavoritesResponseApplicationJsonBuilder> {
  /// Creates a new WeatherStatusSetFavoritesResponseApplicationJson object using the builder pattern.
  factory WeatherStatusSetFavoritesResponseApplicationJson([
    void Function(WeatherStatusSetFavoritesResponseApplicationJsonBuilder)? b,
  ]) = _$WeatherStatusSetFavoritesResponseApplicationJson;

  // coverage:ignore-start
  const WeatherStatusSetFavoritesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusSetFavoritesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusSetFavoritesResponseApplicationJson.
  static Serializer<WeatherStatusSetFavoritesResponseApplicationJson> get serializer =>
      _$weatherStatusSetFavoritesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusSetFavoritesResponseApplicationJsonBuilder b) {
    $WeatherStatusSetFavoritesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusSetFavoritesResponseApplicationJsonBuilder b) {
    $WeatherStatusSetFavoritesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_WeatherStatusInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_WeatherStatusInterfaceBuilder].
  $Capabilities_WeatherStatusInterface rebuild(void Function($Capabilities_WeatherStatusInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Capabilities_WeatherStatusInterfaceBuilder].
  $Capabilities_WeatherStatusInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_WeatherStatusInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_WeatherStatusInterfaceBuilder b) {}
}

abstract class Capabilities_WeatherStatus
    implements
        $Capabilities_WeatherStatusInterface,
        Built<Capabilities_WeatherStatus, Capabilities_WeatherStatusBuilder> {
  /// Creates a new Capabilities_WeatherStatus object using the builder pattern.
  factory Capabilities_WeatherStatus([void Function(Capabilities_WeatherStatusBuilder)? b]) =
      _$Capabilities_WeatherStatus;

  // coverage:ignore-start
  const Capabilities_WeatherStatus._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_WeatherStatus.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_WeatherStatus.
  static Serializer<Capabilities_WeatherStatus> get serializer => _$capabilitiesWeatherStatusSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_WeatherStatusBuilder b) {
    $Capabilities_WeatherStatusInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_WeatherStatusBuilder b) {
    $Capabilities_WeatherStatusInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CapabilitiesInterface {
  @BuiltValueField(wireName: 'weather_status')
  Capabilities_WeatherStatus get weatherStatus;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterface rebuild(void Function($CapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CapabilitiesInterfaceBuilder b) {}
}

abstract class Capabilities implements $CapabilitiesInterface, Built<Capabilities, CapabilitiesBuilder> {
  /// Creates a new Capabilities object using the builder pattern.
  factory Capabilities([void Function(CapabilitiesBuilder)? b]) = _$Capabilities;

  // coverage:ignore-start
  const Capabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities.
  static Serializer<Capabilities> get serializer => _$capabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CapabilitiesBuilder b) {
    $CapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CapabilitiesBuilder b) {
    $CapabilitiesInterface._validate(b);
  }
}

/// Serialization extension for `WeatherStatusGetForecastResponseApplicationJson_Ocs_Data`.
extension $WeatherStatusGetForecastResponseApplicationJson_Ocs_DataExtension
    on WeatherStatusGetForecastResponseApplicationJson_Ocs_Data {
  /// Serializer for WeatherStatusGetForecastResponseApplicationJson_Ocs_Data.
  @BuiltValueSerializer(custom: true)
  static Serializer<WeatherStatusGetForecastResponseApplicationJson_Ocs_Data> get serializer =>
      $20fe3de793aed6fbf929c9b82b472b1aExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static WeatherStatusGetForecastResponseApplicationJson_Ocs_Data fromJson(Object? json) =>
      $20fe3de793aed6fbf929c9b82b472b1aExtension._fromJson(json);
}

typedef _$20fe3de793aed6fbf929c9b82b472b1a = ({
  BuiltList<Forecast>? builtListForecast,
  WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1? weatherStatusGetForecastResponseApplicationJsonOcsData1
});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $20fe3de793aed6fbf929c9b82b472b1aExtension on _$20fe3de793aed6fbf929c9b82b472b1a {
  List<dynamic> get _values => [builtListForecast, weatherStatusGetForecastResponseApplicationJsonOcsData1];
  List<String> get _names => const ['builtListForecast', 'weatherStatusGetForecastResponseApplicationJsonOcsData1'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$20fe3de793aed6fbf929c9b82b472b1a> get _serializer =>
      const _$20fe3de793aed6fbf929c9b82b472b1aSerializer();
  static _$20fe3de793aed6fbf929c9b82b472b1a _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$20fe3de793aed6fbf929c9b82b472b1aSerializer implements PrimitiveSerializer<_$20fe3de793aed6fbf929c9b82b472b1a> {
  const _$20fe3de793aed6fbf929c9b82b472b1aSerializer();

  @override
  Iterable<Type> get types => const [_$20fe3de793aed6fbf929c9b82b472b1a];

  @override
  String get wireName => r'_$20fe3de793aed6fbf929c9b82b472b1a';

  @override
  Object serialize(
    Serializers serializers,
    _$20fe3de793aed6fbf929c9b82b472b1a object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.builtListForecast;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(BuiltList, [FullType(Forecast)]))!;
    }
    value = object.weatherStatusGetForecastResponseApplicationJsonOcsData1;
    if (value != null) {
      return serializers.serialize(
        value,
        specifiedType: const FullType(WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1),
      )!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$20fe3de793aed6fbf929c9b82b472b1a deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    BuiltList<Forecast>? builtListForecast;
    try {
      builtListForecast = serializers.deserialize(
        data,
        specifiedType: const FullType(BuiltList, [FullType(Forecast)]),
      )! as BuiltList<Forecast>;
    } catch (_) {}
    WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1? weatherStatusGetForecastResponseApplicationJsonOcsData1;
    try {
      weatherStatusGetForecastResponseApplicationJsonOcsData1 = serializers.deserialize(
        data,
        specifiedType: const FullType(WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1),
      )! as WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1;
    } catch (_) {}
    return (
      builtListForecast: builtListForecast,
      weatherStatusGetForecastResponseApplicationJsonOcsData1: weatherStatusGetForecastResponseApplicationJsonOcsData1
    );
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(
        const FullType(WeatherStatusSetModeRequestApplicationJson),
        WeatherStatusSetModeRequestApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusSetModeRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusSetModeResponseApplicationJson),
        WeatherStatusSetModeResponseApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusSetModeResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusSetModeResponseApplicationJson_Ocs),
        WeatherStatusSetModeResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WeatherStatusSetModeResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(const FullType(Success), SuccessBuilder.new)
      ..add(Success.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusUsePersonalAddressResponseApplicationJson),
        WeatherStatusUsePersonalAddressResponseApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusUsePersonalAddressResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs),
        WeatherStatusUsePersonalAddressResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WeatherStatusUsePersonalAddressResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(LocationWithSuccess), LocationWithSuccessBuilder.new)
      ..add(LocationWithSuccess.serializer)
      ..addBuilderFactory(const FullType(Location), LocationBuilder.new)
      ..add(Location.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusGetLocationResponseApplicationJson),
        WeatherStatusGetLocationResponseApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusGetLocationResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusGetLocationResponseApplicationJson_Ocs),
        WeatherStatusGetLocationResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WeatherStatusGetLocationResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(LocationWithMode), LocationWithModeBuilder.new)
      ..add(LocationWithMode.serializer)
      ..addBuilderFactory(const FullType(Mode), ModeBuilder.new)
      ..add(Mode.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusSetLocationRequestApplicationJson),
        WeatherStatusSetLocationRequestApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusSetLocationRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusSetLocationResponseApplicationJson),
        WeatherStatusSetLocationResponseApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusSetLocationResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusSetLocationResponseApplicationJson_Ocs),
        WeatherStatusSetLocationResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WeatherStatusSetLocationResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusGetForecastResponseApplicationJson),
        WeatherStatusGetForecastResponseApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusGetForecastResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusGetForecastResponseApplicationJson_Ocs),
        WeatherStatusGetForecastResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WeatherStatusGetForecastResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Forecast), ForecastBuilder.new)
      ..add(Forecast.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data), Forecast_DataBuilder.new)
      ..add(Forecast_Data.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Instant), Forecast_Data_InstantBuilder.new)
      ..add(Forecast_Data_Instant.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Instant_Details), Forecast_Data_Instant_DetailsBuilder.new)
      ..add(Forecast_Data_Instant_Details.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Next12Hours), Forecast_Data_Next12HoursBuilder.new)
      ..add(Forecast_Data_Next12Hours.serializer)
      ..addBuilderFactory(
        const FullType(Forecast_Data_Next12Hours_Summary),
        Forecast_Data_Next12Hours_SummaryBuilder.new,
      )
      ..add(Forecast_Data_Next12Hours_Summary.serializer)
      ..addBuilderFactory(
        const FullType(Forecast_Data_Next12Hours_Details),
        Forecast_Data_Next12Hours_DetailsBuilder.new,
      )
      ..add(Forecast_Data_Next12Hours_Details.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Next1Hours), Forecast_Data_Next1HoursBuilder.new)
      ..add(Forecast_Data_Next1Hours.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Next1Hours_Summary), Forecast_Data_Next1Hours_SummaryBuilder.new)
      ..add(Forecast_Data_Next1Hours_Summary.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Next1Hours_Details), Forecast_Data_Next1Hours_DetailsBuilder.new)
      ..add(Forecast_Data_Next1Hours_Details.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Next6Hours), Forecast_Data_Next6HoursBuilder.new)
      ..add(Forecast_Data_Next6Hours.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Next6Hours_Summary), Forecast_Data_Next6Hours_SummaryBuilder.new)
      ..add(Forecast_Data_Next6Hours_Summary.serializer)
      ..addBuilderFactory(const FullType(Forecast_Data_Next6Hours_Details), Forecast_Data_Next6Hours_DetailsBuilder.new)
      ..add(Forecast_Data_Next6Hours_Details.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Forecast)]), ListBuilder<Forecast>.new)
      ..addBuilderFactory(
        const FullType(WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1),
        WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1Builder.new,
      )
      ..add(WeatherStatusGetForecastResponseApplicationJson_Ocs_Data1.serializer)
      ..add($20fe3de793aed6fbf929c9b82b472b1aExtension._serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusGetFavoritesResponseApplicationJson),
        WeatherStatusGetFavoritesResponseApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusGetFavoritesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusGetFavoritesResponseApplicationJson_Ocs),
        WeatherStatusGetFavoritesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WeatherStatusGetFavoritesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(String)]), ListBuilder<String>.new)
      ..addBuilderFactory(
        const FullType(WeatherStatusSetFavoritesRequestApplicationJson),
        WeatherStatusSetFavoritesRequestApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusSetFavoritesRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusSetFavoritesResponseApplicationJson),
        WeatherStatusSetFavoritesResponseApplicationJsonBuilder.new,
      )
      ..add(WeatherStatusSetFavoritesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(WeatherStatusSetFavoritesResponseApplicationJson_Ocs),
        WeatherStatusSetFavoritesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(WeatherStatusSetFavoritesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Capabilities), CapabilitiesBuilder.new)
      ..add(Capabilities.serializer)
      ..addBuilderFactory(const FullType(Capabilities_WeatherStatus), Capabilities_WeatherStatusBuilder.new)
      ..add(Capabilities_WeatherStatus.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i6.DynamiteDoubleSerializer())
      ..addPlugin(_i7.StandardJsonPlugin(typesToLeaveAsList: const {_$20fe3de793aed6fbf929c9b82b472b1a}))
      ..addPlugin(const _i6.HeaderPlugin())
      ..addPlugin(const _i6.ContentStringPlugin()))
    .build();
// coverage:ignore-end
