// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// user_status Version: 0.0.1.
///
/// User status.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i5;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i6;

part 'user_status.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $HeartbeatClient heartbeat = $HeartbeatClient(this);

  late final $PredefinedStatusClient predefinedStatus = $PredefinedStatusClient(this);

  late final $StatusesClient statuses = $StatusesClient(this);

  late final $UserStatusClient userStatus = $UserStatusClient(this);
}

class $HeartbeatClient {
  /// Creates a new `DynamiteClient` for heartbeat requests.
  $HeartbeatClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$heartbeat_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<HeartbeatHeartbeatResponseApplicationJson, void> $heartbeat_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(HeartbeatHeartbeatResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Keep the status alive.
  ///
  /// Returns a `DynamiteRequest` backing the [heartbeat] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Status successfully updated
  ///   * 400: Invalid status to update
  ///   * 500
  ///   * 204: User has no status to keep alive
  ///
  /// See:
  ///  * [heartbeat] for a method executing this request and parsing the response.
  ///  * [$heartbeat_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $heartbeat_Request({
    required HeartbeatHeartbeatRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/user_status/api/v1/heartbeat';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(HeartbeatHeartbeatRequestApplicationJson)),
    );
    return _request;
  }

  /// Keep the status alive.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Status successfully updated
  ///   * 400: Invalid status to update
  ///   * 500
  ///   * 204: User has no status to keep alive
  ///
  /// See:
  ///  * [$heartbeat_Request] for the request send by this method.
  ///  * [$heartbeat_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<HeartbeatHeartbeatResponseApplicationJson, void>> heartbeat({
    required HeartbeatHeartbeatRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $heartbeat_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $heartbeat_Serializer();
    return _i1.ResponseConverter<HeartbeatHeartbeatResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $PredefinedStatusClient {
  /// Creates a new `DynamiteClient` for predefined_status requests.
  $PredefinedStatusClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$findAll_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PredefinedStatusFindAllResponseApplicationJson, void> $findAll_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(PredefinedStatusFindAllResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all predefined messages.
  ///
  /// Returns a `DynamiteRequest` backing the [findAll] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Predefined statuses returned
  ///
  /// See:
  ///  * [findAll] for a method executing this request and parsing the response.
  ///  * [$findAll_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $findAll_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/user_status/api/v1/predefined_statuses';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get all predefined messages.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Predefined statuses returned
  ///
  /// See:
  ///  * [$findAll_Request] for the request send by this method.
  ///  * [$findAll_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PredefinedStatusFindAllResponseApplicationJson, void>> findAll({
    bool? oCSAPIRequest,
  }) async {
    final _request = $findAll_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $findAll_Serializer();
    return _i1.ResponseConverter<PredefinedStatusFindAllResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $StatusesClient {
  /// Creates a new `DynamiteClient` for statuses requests.
  $StatusesClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$findAll_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<StatusesFindAllResponseApplicationJson, void> $findAll_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(StatusesFindAllResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Find statuses of users.
  ///
  /// Returns a `DynamiteRequest` backing the [findAll] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [limit] Maximum number of statuses to find.
  ///   * [offset] Offset for finding statuses.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Statuses returned
  ///
  /// See:
  ///  * [findAll] for a method executing this request and parsing the response.
  ///  * [$findAll_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $findAll_Request({
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    final __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    _parameters['offset'] = __offset;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/user_status/api/v1/statuses{?limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Find statuses of users.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [limit] Maximum number of statuses to find.
  ///   * [offset] Offset for finding statuses.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Statuses returned
  ///
  /// See:
  ///  * [$findAll_Request] for the request send by this method.
  ///  * [$findAll_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<StatusesFindAllResponseApplicationJson, void>> findAll({
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) async {
    final _request = $findAll_Request(
      limit: limit,
      offset: offset,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $findAll_Serializer();
    return _i1.ResponseConverter<StatusesFindAllResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$find_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<StatusesFindResponseApplicationJson, void> $find_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(StatusesFindResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Find the status of a user.
  ///
  /// Returns a `DynamiteRequest` backing the [find] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Status returned
  ///   * 404: The user was not found
  ///
  /// See:
  ///  * [find] for a method executing this request and parsing the response.
  ///  * [$find_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $find_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/user_status/api/v1/statuses/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Find the status of a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Status returned
  ///   * 404: The user was not found
  ///
  /// See:
  ///  * [$find_Request] for the request send by this method.
  ///  * [$find_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<StatusesFindResponseApplicationJson, void>> find({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $find_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $find_Serializer();
    return _i1.ResponseConverter<StatusesFindResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $UserStatusClient {
  /// Creates a new `DynamiteClient` for user_status requests.
  $UserStatusClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getStatus_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UserStatusGetStatusResponseApplicationJson, void> $getStatus_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UserStatusGetStatusResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the status of the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [getStatus] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: The status was found successfully
  ///   * 404: The user was not found
  ///
  /// See:
  ///  * [getStatus] for a method executing this request and parsing the response.
  ///  * [$getStatus_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getStatus_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/user_status/api/v1/user_status';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the status of the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: The status was found successfully
  ///   * 404: The user was not found
  ///
  /// See:
  ///  * [$getStatus_Request] for the request send by this method.
  ///  * [$getStatus_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UserStatusGetStatusResponseApplicationJson, void>> getStatus({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getStatus_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getStatus_Serializer();
    return _i1.ResponseConverter<UserStatusGetStatusResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setStatus_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UserStatusSetStatusResponseApplicationJson, void> $setStatus_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UserStatusSetStatusResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update the status type of the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [setStatus] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: The status was updated successfully
  ///   * 400: The status type is invalid
  ///
  /// See:
  ///  * [setStatus] for a method executing this request and parsing the response.
  ///  * [$setStatus_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setStatus_Request({
    required UserStatusSetStatusRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/user_status/api/v1/user_status/status';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(UserStatusSetStatusRequestApplicationJson)),
    );
    return _request;
  }

  /// Update the status type of the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: The status was updated successfully
  ///   * 400: The status type is invalid
  ///
  /// See:
  ///  * [$setStatus_Request] for the request send by this method.
  ///  * [$setStatus_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UserStatusSetStatusResponseApplicationJson, void>> setStatus({
    required UserStatusSetStatusRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setStatus_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setStatus_Serializer();
    return _i1.ResponseConverter<UserStatusSetStatusResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setPredefinedMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UserStatusSetPredefinedMessageResponseApplicationJson, void>
      $setPredefinedMessage_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(UserStatusSetPredefinedMessageResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Set the message to a predefined message for the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [setPredefinedMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: The message was updated successfully
  ///   * 400: The clearAt or message-id is invalid
  ///
  /// See:
  ///  * [setPredefinedMessage] for a method executing this request and parsing the response.
  ///  * [$setPredefinedMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setPredefinedMessage_Request({
    required UserStatusSetPredefinedMessageRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/user_status/api/v1/user_status/message/predefined';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(UserStatusSetPredefinedMessageRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Set the message to a predefined message for the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: The message was updated successfully
  ///   * 400: The clearAt or message-id is invalid
  ///
  /// See:
  ///  * [$setPredefinedMessage_Request] for the request send by this method.
  ///  * [$setPredefinedMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UserStatusSetPredefinedMessageResponseApplicationJson, void>> setPredefinedMessage({
    required UserStatusSetPredefinedMessageRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setPredefinedMessage_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setPredefinedMessage_Serializer();
    return _i1.ResponseConverter<UserStatusSetPredefinedMessageResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setCustomMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UserStatusSetCustomMessageResponseApplicationJson, void> $setCustomMessage_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UserStatusSetCustomMessageResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set the message to a custom message for the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [setCustomMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: The message was updated successfully
  ///   * 400: The clearAt or icon is invalid or the message is too long
  ///
  /// See:
  ///  * [setCustomMessage] for a method executing this request and parsing the response.
  ///  * [$setCustomMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setCustomMessage_Request({
    bool? oCSAPIRequest,
    UserStatusSetCustomMessageRequestApplicationJson? $body,
  }) {
    const _path = '/ocs/v2.php/apps/user_status/api/v1/user_status/message/custom';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(UserStatusSetCustomMessageRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              UserStatusSetCustomMessageRequestApplicationJson(),
              specifiedType: const FullType(UserStatusSetCustomMessageRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Set the message to a custom message for the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: The message was updated successfully
  ///   * 400: The clearAt or icon is invalid or the message is too long
  ///
  /// See:
  ///  * [$setCustomMessage_Request] for the request send by this method.
  ///  * [$setCustomMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UserStatusSetCustomMessageResponseApplicationJson, void>> setCustomMessage({
    bool? oCSAPIRequest,
    UserStatusSetCustomMessageRequestApplicationJson? $body,
  }) async {
    final _request = $setCustomMessage_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setCustomMessage_Serializer();
    return _i1.ResponseConverter<UserStatusSetCustomMessageResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$clearMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UserStatusClearMessageResponseApplicationJson, void> $clearMessage_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UserStatusClearMessageResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Clear the message of the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [clearMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message cleared successfully
  ///
  /// See:
  ///  * [clearMessage] for a method executing this request and parsing the response.
  ///  * [$clearMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $clearMessage_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/user_status/api/v1/user_status/message';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Clear the message of the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message cleared successfully
  ///
  /// See:
  ///  * [$clearMessage_Request] for the request send by this method.
  ///  * [$clearMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UserStatusClearMessageResponseApplicationJson, void>> clearMessage({
    bool? oCSAPIRequest,
  }) async {
    final _request = $clearMessage_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $clearMessage_Serializer();
    return _i1.ResponseConverter<UserStatusClearMessageResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$revertStatus_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UserStatusRevertStatusResponseApplicationJson, void> $revertStatus_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UserStatusRevertStatusResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Revert the status to the previous status.
  ///
  /// Returns a `DynamiteRequest` backing the [revertStatus] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [messageId] ID of the message to delete.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Status reverted
  ///
  /// See:
  ///  * [revertStatus] for a method executing this request and parsing the response.
  ///  * [$revertStatus_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $revertStatus_Request({
    required String messageId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(String));
    _parameters['messageId'] = __messageId;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/apps/user_status/api/v1/user_status/revert/{messageId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Revert the status to the previous status.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [messageId] ID of the message to delete.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Status reverted
  ///
  /// See:
  ///  * [$revertStatus_Request] for the request send by this method.
  ///  * [$revertStatus_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UserStatusRevertStatusResponseApplicationJson, void>> revertStatus({
    required String messageId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $revertStatus_Request(
      messageId: messageId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $revertStatus_Serializer();
    return _i1.ResponseConverter<UserStatusRevertStatusResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $HeartbeatHeartbeatRequestApplicationJsonInterface {
  /// Only online, away.
  String get status;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$HeartbeatHeartbeatRequestApplicationJsonInterfaceBuilder].
  $HeartbeatHeartbeatRequestApplicationJsonInterface rebuild(
    void Function($HeartbeatHeartbeatRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$HeartbeatHeartbeatRequestApplicationJsonInterfaceBuilder].
  $HeartbeatHeartbeatRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($HeartbeatHeartbeatRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($HeartbeatHeartbeatRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class HeartbeatHeartbeatRequestApplicationJson
    implements
        $HeartbeatHeartbeatRequestApplicationJsonInterface,
        Built<HeartbeatHeartbeatRequestApplicationJson, HeartbeatHeartbeatRequestApplicationJsonBuilder> {
  /// Creates a new HeartbeatHeartbeatRequestApplicationJson object using the builder pattern.
  factory HeartbeatHeartbeatRequestApplicationJson([
    void Function(HeartbeatHeartbeatRequestApplicationJsonBuilder)? b,
  ]) = _$HeartbeatHeartbeatRequestApplicationJson;

  // coverage:ignore-start
  const HeartbeatHeartbeatRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory HeartbeatHeartbeatRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for HeartbeatHeartbeatRequestApplicationJson.
  static Serializer<HeartbeatHeartbeatRequestApplicationJson> get serializer =>
      _$heartbeatHeartbeatRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(HeartbeatHeartbeatRequestApplicationJsonBuilder b) {
    $HeartbeatHeartbeatRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(HeartbeatHeartbeatRequestApplicationJsonBuilder b) {
    $HeartbeatHeartbeatRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

class $Type extends EnumClass {
  const $Type._(super.name);

  /// `online`
  static const $Type online = _$$typeOnline;

  /// `away`
  static const $Type away = _$$typeAway;

  /// `dnd`
  static const $Type dnd = _$$typeDnd;

  /// `busy`
  static const $Type busy = _$$typeBusy;

  /// `offline`
  static const $Type offline = _$$typeOffline;

  /// `invisible`
  static const $Type invisible = _$$typeInvisible;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<$Type> get values => _$$typeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static $Type valueOf(String name) => _$valueOf$Type(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for $Type.
  @BuiltValueSerializer(custom: true)
  static Serializer<$Type> get serializer => const _$$TypeSerializer();
}

class _$$TypeSerializer implements PrimitiveSerializer<$Type> {
  const _$$TypeSerializer();

  static const Map<$Type, Object> _toWire = <$Type, Object>{
    $Type.online: 'online',
    $Type.away: 'away',
    $Type.dnd: 'dnd',
    $Type.busy: 'busy',
    $Type.offline: 'offline',
    $Type.invisible: 'invisible',
  };

  static const Map<Object, $Type> _fromWire = <Object, $Type>{
    'online': $Type.online,
    'away': $Type.away,
    'dnd': $Type.dnd,
    'busy': $Type.busy,
    'offline': $Type.offline,
    'invisible': $Type.invisible,
  };

  @override
  Iterable<Type> get types => const [$Type];

  @override
  String get wireName => r'$Type';

  @override
  Object serialize(
    Serializers serializers,
    $Type object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  $Type deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $PublicInterface {
  String get userId;
  String? get message;
  String? get icon;
  int? get clearAt;
  $Type get status;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PublicInterfaceBuilder].
  $PublicInterface rebuild(void Function($PublicInterfaceBuilder) updates);

  /// Converts the instance to a builder [$PublicInterfaceBuilder].
  $PublicInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PublicInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PublicInterfaceBuilder b) {}
}

abstract class Public implements $PublicInterface, Built<Public, PublicBuilder> {
  /// Creates a new Public object using the builder pattern.
  factory Public([void Function(PublicBuilder)? b]) = _$Public;

  // coverage:ignore-start
  const Public._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Public.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Public.
  static Serializer<Public> get serializer => _$publicSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PublicBuilder b) {
    $PublicInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PublicBuilder b) {
    $PublicInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PrivateInterface implements $PublicInterface {
  String? get messageId;
  bool get messageIsPredefined;
  bool get statusIsUserDefined;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PrivateInterfaceBuilder].
  @override
  $PrivateInterface rebuild(void Function($PrivateInterfaceBuilder) updates);

  /// Converts the instance to a builder [$PrivateInterfaceBuilder].
  @override
  $PrivateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PrivateInterfaceBuilder b) {
    $PublicInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PrivateInterfaceBuilder b) {
    $PublicInterface._validate(b);
  }
}

abstract class Private implements $PrivateInterface, Built<Private, PrivateBuilder> {
  /// Creates a new Private object using the builder pattern.
  factory Private([void Function(PrivateBuilder)? b]) = _$Private;

  // coverage:ignore-start
  const Private._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Private.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Private.
  static Serializer<Private> get serializer => _$privateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PrivateBuilder b) {
    $PrivateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PrivateBuilder b) {
    $PrivateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $HeartbeatHeartbeatResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Private get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$HeartbeatHeartbeatResponseApplicationJson_OcsInterfaceBuilder].
  $HeartbeatHeartbeatResponseApplicationJson_OcsInterface rebuild(
    void Function($HeartbeatHeartbeatResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$HeartbeatHeartbeatResponseApplicationJson_OcsInterfaceBuilder].
  $HeartbeatHeartbeatResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($HeartbeatHeartbeatResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($HeartbeatHeartbeatResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class HeartbeatHeartbeatResponseApplicationJson_Ocs
    implements
        $HeartbeatHeartbeatResponseApplicationJson_OcsInterface,
        Built<HeartbeatHeartbeatResponseApplicationJson_Ocs, HeartbeatHeartbeatResponseApplicationJson_OcsBuilder> {
  /// Creates a new HeartbeatHeartbeatResponseApplicationJson_Ocs object using the builder pattern.
  factory HeartbeatHeartbeatResponseApplicationJson_Ocs([
    void Function(HeartbeatHeartbeatResponseApplicationJson_OcsBuilder)? b,
  ]) = _$HeartbeatHeartbeatResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const HeartbeatHeartbeatResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory HeartbeatHeartbeatResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for HeartbeatHeartbeatResponseApplicationJson_Ocs.
  static Serializer<HeartbeatHeartbeatResponseApplicationJson_Ocs> get serializer =>
      _$heartbeatHeartbeatResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(HeartbeatHeartbeatResponseApplicationJson_OcsBuilder b) {
    $HeartbeatHeartbeatResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(HeartbeatHeartbeatResponseApplicationJson_OcsBuilder b) {
    $HeartbeatHeartbeatResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $HeartbeatHeartbeatResponseApplicationJsonInterface {
  HeartbeatHeartbeatResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$HeartbeatHeartbeatResponseApplicationJsonInterfaceBuilder].
  $HeartbeatHeartbeatResponseApplicationJsonInterface rebuild(
    void Function($HeartbeatHeartbeatResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$HeartbeatHeartbeatResponseApplicationJsonInterfaceBuilder].
  $HeartbeatHeartbeatResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($HeartbeatHeartbeatResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($HeartbeatHeartbeatResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class HeartbeatHeartbeatResponseApplicationJson
    implements
        $HeartbeatHeartbeatResponseApplicationJsonInterface,
        Built<HeartbeatHeartbeatResponseApplicationJson, HeartbeatHeartbeatResponseApplicationJsonBuilder> {
  /// Creates a new HeartbeatHeartbeatResponseApplicationJson object using the builder pattern.
  factory HeartbeatHeartbeatResponseApplicationJson([
    void Function(HeartbeatHeartbeatResponseApplicationJsonBuilder)? b,
  ]) = _$HeartbeatHeartbeatResponseApplicationJson;

  // coverage:ignore-start
  const HeartbeatHeartbeatResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory HeartbeatHeartbeatResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for HeartbeatHeartbeatResponseApplicationJson.
  static Serializer<HeartbeatHeartbeatResponseApplicationJson> get serializer =>
      _$heartbeatHeartbeatResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(HeartbeatHeartbeatResponseApplicationJsonBuilder b) {
    $HeartbeatHeartbeatResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(HeartbeatHeartbeatResponseApplicationJsonBuilder b) {
    $HeartbeatHeartbeatResponseApplicationJsonInterface._validate(b);
  }
}

class ClearAt_Type extends EnumClass {
  const ClearAt_Type._(super.name);

  /// `period`
  static const ClearAt_Type period = _$clearAtTypePeriod;

  /// `end-of`
  @BuiltValueEnumConst(wireName: 'end-of')
  static const ClearAt_Type endOf = _$clearAtTypeEndOf;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ClearAt_Type> get values => _$clearAtTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ClearAt_Type valueOf(String name) => _$valueOfClearAt_Type(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ClearAt_Type.
  @BuiltValueSerializer(custom: true)
  static Serializer<ClearAt_Type> get serializer => const _$ClearAt_TypeSerializer();
}

class _$ClearAt_TypeSerializer implements PrimitiveSerializer<ClearAt_Type> {
  const _$ClearAt_TypeSerializer();

  static const Map<ClearAt_Type, Object> _toWire = <ClearAt_Type, Object>{
    ClearAt_Type.period: 'period',
    ClearAt_Type.endOf: 'end-of',
  };

  static const Map<Object, ClearAt_Type> _fromWire = <Object, ClearAt_Type>{
    'period': ClearAt_Type.period,
    'end-of': ClearAt_Type.endOf,
  };

  @override
  Iterable<Type> get types => const [ClearAt_Type];

  @override
  String get wireName => 'ClearAt_Type';

  @override
  Object serialize(
    Serializers serializers,
    ClearAt_Type object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ClearAt_Type deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class ClearAtTimeType extends EnumClass {
  const ClearAtTimeType._(super.name);

  /// `day`
  static const ClearAtTimeType day = _$clearAtTimeTypeDay;

  /// `week`
  static const ClearAtTimeType week = _$clearAtTimeTypeWeek;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ClearAtTimeType> get values => _$clearAtTimeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ClearAtTimeType valueOf(String name) => _$valueOfClearAtTimeType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ClearAtTimeType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ClearAtTimeType> get serializer => const _$ClearAtTimeTypeSerializer();
}

class _$ClearAtTimeTypeSerializer implements PrimitiveSerializer<ClearAtTimeType> {
  const _$ClearAtTimeTypeSerializer();

  static const Map<ClearAtTimeType, Object> _toWire = <ClearAtTimeType, Object>{
    ClearAtTimeType.day: 'day',
    ClearAtTimeType.week: 'week',
  };

  static const Map<Object, ClearAtTimeType> _fromWire = <Object, ClearAtTimeType>{
    'day': ClearAtTimeType.day,
    'week': ClearAtTimeType.week,
  };

  @override
  Iterable<Type> get types => const [ClearAtTimeType];

  @override
  String get wireName => 'ClearAtTimeType';

  @override
  Object serialize(
    Serializers serializers,
    ClearAtTimeType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ClearAtTimeType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

typedef ClearAt_Time = ({ClearAtTimeType? clearAtTimeType, int? $int});

@BuiltValue(instantiable: false)
sealed class $ClearAtInterface {
  ClearAt_Type get type;
  ClearAt_Time get time;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ClearAtInterfaceBuilder].
  $ClearAtInterface rebuild(void Function($ClearAtInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ClearAtInterfaceBuilder].
  $ClearAtInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ClearAtInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ClearAtInterfaceBuilder b) {
    b.time?.validateAnyOf();
  }
}

abstract class ClearAt implements $ClearAtInterface, Built<ClearAt, ClearAtBuilder> {
  /// Creates a new ClearAt object using the builder pattern.
  factory ClearAt([void Function(ClearAtBuilder)? b]) = _$ClearAt;

  // coverage:ignore-start
  const ClearAt._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ClearAt.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ClearAt.
  static Serializer<ClearAt> get serializer => _$clearAtSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ClearAtBuilder b) {
    $ClearAtInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ClearAtBuilder b) {
    $ClearAtInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PredefinedInterface {
  String get id;
  String get icon;
  String get message;
  ClearAt? get clearAt;
  bool? get visible;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PredefinedInterfaceBuilder].
  $PredefinedInterface rebuild(void Function($PredefinedInterfaceBuilder) updates);

  /// Converts the instance to a builder [$PredefinedInterfaceBuilder].
  $PredefinedInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PredefinedInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PredefinedInterfaceBuilder b) {}
}

abstract class Predefined implements $PredefinedInterface, Built<Predefined, PredefinedBuilder> {
  /// Creates a new Predefined object using the builder pattern.
  factory Predefined([void Function(PredefinedBuilder)? b]) = _$Predefined;

  // coverage:ignore-start
  const Predefined._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Predefined.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Predefined.
  static Serializer<Predefined> get serializer => _$predefinedSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PredefinedBuilder b) {
    $PredefinedInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PredefinedBuilder b) {
    $PredefinedInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PredefinedStatusFindAllResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Predefined> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PredefinedStatusFindAllResponseApplicationJson_OcsInterfaceBuilder].
  $PredefinedStatusFindAllResponseApplicationJson_OcsInterface rebuild(
    void Function($PredefinedStatusFindAllResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PredefinedStatusFindAllResponseApplicationJson_OcsInterfaceBuilder].
  $PredefinedStatusFindAllResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PredefinedStatusFindAllResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PredefinedStatusFindAllResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class PredefinedStatusFindAllResponseApplicationJson_Ocs
    implements
        $PredefinedStatusFindAllResponseApplicationJson_OcsInterface,
        Built<PredefinedStatusFindAllResponseApplicationJson_Ocs,
            PredefinedStatusFindAllResponseApplicationJson_OcsBuilder> {
  /// Creates a new PredefinedStatusFindAllResponseApplicationJson_Ocs object using the builder pattern.
  factory PredefinedStatusFindAllResponseApplicationJson_Ocs([
    void Function(PredefinedStatusFindAllResponseApplicationJson_OcsBuilder)? b,
  ]) = _$PredefinedStatusFindAllResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const PredefinedStatusFindAllResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PredefinedStatusFindAllResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PredefinedStatusFindAllResponseApplicationJson_Ocs.
  static Serializer<PredefinedStatusFindAllResponseApplicationJson_Ocs> get serializer =>
      _$predefinedStatusFindAllResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PredefinedStatusFindAllResponseApplicationJson_OcsBuilder b) {
    $PredefinedStatusFindAllResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PredefinedStatusFindAllResponseApplicationJson_OcsBuilder b) {
    $PredefinedStatusFindAllResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PredefinedStatusFindAllResponseApplicationJsonInterface {
  PredefinedStatusFindAllResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PredefinedStatusFindAllResponseApplicationJsonInterfaceBuilder].
  $PredefinedStatusFindAllResponseApplicationJsonInterface rebuild(
    void Function($PredefinedStatusFindAllResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PredefinedStatusFindAllResponseApplicationJsonInterfaceBuilder].
  $PredefinedStatusFindAllResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PredefinedStatusFindAllResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PredefinedStatusFindAllResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class PredefinedStatusFindAllResponseApplicationJson
    implements
        $PredefinedStatusFindAllResponseApplicationJsonInterface,
        Built<PredefinedStatusFindAllResponseApplicationJson, PredefinedStatusFindAllResponseApplicationJsonBuilder> {
  /// Creates a new PredefinedStatusFindAllResponseApplicationJson object using the builder pattern.
  factory PredefinedStatusFindAllResponseApplicationJson([
    void Function(PredefinedStatusFindAllResponseApplicationJsonBuilder)? b,
  ]) = _$PredefinedStatusFindAllResponseApplicationJson;

  // coverage:ignore-start
  const PredefinedStatusFindAllResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PredefinedStatusFindAllResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PredefinedStatusFindAllResponseApplicationJson.
  static Serializer<PredefinedStatusFindAllResponseApplicationJson> get serializer =>
      _$predefinedStatusFindAllResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PredefinedStatusFindAllResponseApplicationJsonBuilder b) {
    $PredefinedStatusFindAllResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PredefinedStatusFindAllResponseApplicationJsonBuilder b) {
    $PredefinedStatusFindAllResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $StatusesFindAllResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Public> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$StatusesFindAllResponseApplicationJson_OcsInterfaceBuilder].
  $StatusesFindAllResponseApplicationJson_OcsInterface rebuild(
    void Function($StatusesFindAllResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$StatusesFindAllResponseApplicationJson_OcsInterfaceBuilder].
  $StatusesFindAllResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($StatusesFindAllResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($StatusesFindAllResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class StatusesFindAllResponseApplicationJson_Ocs
    implements
        $StatusesFindAllResponseApplicationJson_OcsInterface,
        Built<StatusesFindAllResponseApplicationJson_Ocs, StatusesFindAllResponseApplicationJson_OcsBuilder> {
  /// Creates a new StatusesFindAllResponseApplicationJson_Ocs object using the builder pattern.
  factory StatusesFindAllResponseApplicationJson_Ocs([
    void Function(StatusesFindAllResponseApplicationJson_OcsBuilder)? b,
  ]) = _$StatusesFindAllResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const StatusesFindAllResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory StatusesFindAllResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for StatusesFindAllResponseApplicationJson_Ocs.
  static Serializer<StatusesFindAllResponseApplicationJson_Ocs> get serializer =>
      _$statusesFindAllResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(StatusesFindAllResponseApplicationJson_OcsBuilder b) {
    $StatusesFindAllResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(StatusesFindAllResponseApplicationJson_OcsBuilder b) {
    $StatusesFindAllResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $StatusesFindAllResponseApplicationJsonInterface {
  StatusesFindAllResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$StatusesFindAllResponseApplicationJsonInterfaceBuilder].
  $StatusesFindAllResponseApplicationJsonInterface rebuild(
    void Function($StatusesFindAllResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$StatusesFindAllResponseApplicationJsonInterfaceBuilder].
  $StatusesFindAllResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($StatusesFindAllResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($StatusesFindAllResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class StatusesFindAllResponseApplicationJson
    implements
        $StatusesFindAllResponseApplicationJsonInterface,
        Built<StatusesFindAllResponseApplicationJson, StatusesFindAllResponseApplicationJsonBuilder> {
  /// Creates a new StatusesFindAllResponseApplicationJson object using the builder pattern.
  factory StatusesFindAllResponseApplicationJson([void Function(StatusesFindAllResponseApplicationJsonBuilder)? b]) =
      _$StatusesFindAllResponseApplicationJson;

  // coverage:ignore-start
  const StatusesFindAllResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory StatusesFindAllResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for StatusesFindAllResponseApplicationJson.
  static Serializer<StatusesFindAllResponseApplicationJson> get serializer =>
      _$statusesFindAllResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(StatusesFindAllResponseApplicationJsonBuilder b) {
    $StatusesFindAllResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(StatusesFindAllResponseApplicationJsonBuilder b) {
    $StatusesFindAllResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $StatusesFindResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Public get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$StatusesFindResponseApplicationJson_OcsInterfaceBuilder].
  $StatusesFindResponseApplicationJson_OcsInterface rebuild(
    void Function($StatusesFindResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$StatusesFindResponseApplicationJson_OcsInterfaceBuilder].
  $StatusesFindResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($StatusesFindResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($StatusesFindResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class StatusesFindResponseApplicationJson_Ocs
    implements
        $StatusesFindResponseApplicationJson_OcsInterface,
        Built<StatusesFindResponseApplicationJson_Ocs, StatusesFindResponseApplicationJson_OcsBuilder> {
  /// Creates a new StatusesFindResponseApplicationJson_Ocs object using the builder pattern.
  factory StatusesFindResponseApplicationJson_Ocs([void Function(StatusesFindResponseApplicationJson_OcsBuilder)? b]) =
      _$StatusesFindResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const StatusesFindResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory StatusesFindResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for StatusesFindResponseApplicationJson_Ocs.
  static Serializer<StatusesFindResponseApplicationJson_Ocs> get serializer =>
      _$statusesFindResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(StatusesFindResponseApplicationJson_OcsBuilder b) {
    $StatusesFindResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(StatusesFindResponseApplicationJson_OcsBuilder b) {
    $StatusesFindResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $StatusesFindResponseApplicationJsonInterface {
  StatusesFindResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$StatusesFindResponseApplicationJsonInterfaceBuilder].
  $StatusesFindResponseApplicationJsonInterface rebuild(
    void Function($StatusesFindResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$StatusesFindResponseApplicationJsonInterfaceBuilder].
  $StatusesFindResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($StatusesFindResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($StatusesFindResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class StatusesFindResponseApplicationJson
    implements
        $StatusesFindResponseApplicationJsonInterface,
        Built<StatusesFindResponseApplicationJson, StatusesFindResponseApplicationJsonBuilder> {
  /// Creates a new StatusesFindResponseApplicationJson object using the builder pattern.
  factory StatusesFindResponseApplicationJson([void Function(StatusesFindResponseApplicationJsonBuilder)? b]) =
      _$StatusesFindResponseApplicationJson;

  // coverage:ignore-start
  const StatusesFindResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory StatusesFindResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for StatusesFindResponseApplicationJson.
  static Serializer<StatusesFindResponseApplicationJson> get serializer =>
      _$statusesFindResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(StatusesFindResponseApplicationJsonBuilder b) {
    $StatusesFindResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(StatusesFindResponseApplicationJsonBuilder b) {
    $StatusesFindResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusGetStatusResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Private get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusGetStatusResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusGetStatusResponseApplicationJson_OcsInterface rebuild(
    void Function($UserStatusGetStatusResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusGetStatusResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusGetStatusResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusGetStatusResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusGetStatusResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UserStatusGetStatusResponseApplicationJson_Ocs
    implements
        $UserStatusGetStatusResponseApplicationJson_OcsInterface,
        Built<UserStatusGetStatusResponseApplicationJson_Ocs, UserStatusGetStatusResponseApplicationJson_OcsBuilder> {
  /// Creates a new UserStatusGetStatusResponseApplicationJson_Ocs object using the builder pattern.
  factory UserStatusGetStatusResponseApplicationJson_Ocs([
    void Function(UserStatusGetStatusResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UserStatusGetStatusResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UserStatusGetStatusResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusGetStatusResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusGetStatusResponseApplicationJson_Ocs.
  static Serializer<UserStatusGetStatusResponseApplicationJson_Ocs> get serializer =>
      _$userStatusGetStatusResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusGetStatusResponseApplicationJson_OcsBuilder b) {
    $UserStatusGetStatusResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusGetStatusResponseApplicationJson_OcsBuilder b) {
    $UserStatusGetStatusResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusGetStatusResponseApplicationJsonInterface {
  UserStatusGetStatusResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusGetStatusResponseApplicationJsonInterfaceBuilder].
  $UserStatusGetStatusResponseApplicationJsonInterface rebuild(
    void Function($UserStatusGetStatusResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusGetStatusResponseApplicationJsonInterfaceBuilder].
  $UserStatusGetStatusResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusGetStatusResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusGetStatusResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusGetStatusResponseApplicationJson
    implements
        $UserStatusGetStatusResponseApplicationJsonInterface,
        Built<UserStatusGetStatusResponseApplicationJson, UserStatusGetStatusResponseApplicationJsonBuilder> {
  /// Creates a new UserStatusGetStatusResponseApplicationJson object using the builder pattern.
  factory UserStatusGetStatusResponseApplicationJson([
    void Function(UserStatusGetStatusResponseApplicationJsonBuilder)? b,
  ]) = _$UserStatusGetStatusResponseApplicationJson;

  // coverage:ignore-start
  const UserStatusGetStatusResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusGetStatusResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusGetStatusResponseApplicationJson.
  static Serializer<UserStatusGetStatusResponseApplicationJson> get serializer =>
      _$userStatusGetStatusResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusGetStatusResponseApplicationJsonBuilder b) {
    $UserStatusGetStatusResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusGetStatusResponseApplicationJsonBuilder b) {
    $UserStatusGetStatusResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetStatusRequestApplicationJsonInterface {
  /// The new status type.
  String get statusType;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetStatusRequestApplicationJsonInterfaceBuilder].
  $UserStatusSetStatusRequestApplicationJsonInterface rebuild(
    void Function($UserStatusSetStatusRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetStatusRequestApplicationJsonInterfaceBuilder].
  $UserStatusSetStatusRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetStatusRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetStatusRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusSetStatusRequestApplicationJson
    implements
        $UserStatusSetStatusRequestApplicationJsonInterface,
        Built<UserStatusSetStatusRequestApplicationJson, UserStatusSetStatusRequestApplicationJsonBuilder> {
  /// Creates a new UserStatusSetStatusRequestApplicationJson object using the builder pattern.
  factory UserStatusSetStatusRequestApplicationJson([
    void Function(UserStatusSetStatusRequestApplicationJsonBuilder)? b,
  ]) = _$UserStatusSetStatusRequestApplicationJson;

  // coverage:ignore-start
  const UserStatusSetStatusRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetStatusRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetStatusRequestApplicationJson.
  static Serializer<UserStatusSetStatusRequestApplicationJson> get serializer =>
      _$userStatusSetStatusRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetStatusRequestApplicationJsonBuilder b) {
    $UserStatusSetStatusRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetStatusRequestApplicationJsonBuilder b) {
    $UserStatusSetStatusRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetStatusResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Private get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetStatusResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusSetStatusResponseApplicationJson_OcsInterface rebuild(
    void Function($UserStatusSetStatusResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetStatusResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusSetStatusResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetStatusResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetStatusResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UserStatusSetStatusResponseApplicationJson_Ocs
    implements
        $UserStatusSetStatusResponseApplicationJson_OcsInterface,
        Built<UserStatusSetStatusResponseApplicationJson_Ocs, UserStatusSetStatusResponseApplicationJson_OcsBuilder> {
  /// Creates a new UserStatusSetStatusResponseApplicationJson_Ocs object using the builder pattern.
  factory UserStatusSetStatusResponseApplicationJson_Ocs([
    void Function(UserStatusSetStatusResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UserStatusSetStatusResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UserStatusSetStatusResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetStatusResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetStatusResponseApplicationJson_Ocs.
  static Serializer<UserStatusSetStatusResponseApplicationJson_Ocs> get serializer =>
      _$userStatusSetStatusResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetStatusResponseApplicationJson_OcsBuilder b) {
    $UserStatusSetStatusResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetStatusResponseApplicationJson_OcsBuilder b) {
    $UserStatusSetStatusResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetStatusResponseApplicationJsonInterface {
  UserStatusSetStatusResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetStatusResponseApplicationJsonInterfaceBuilder].
  $UserStatusSetStatusResponseApplicationJsonInterface rebuild(
    void Function($UserStatusSetStatusResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetStatusResponseApplicationJsonInterfaceBuilder].
  $UserStatusSetStatusResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetStatusResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetStatusResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusSetStatusResponseApplicationJson
    implements
        $UserStatusSetStatusResponseApplicationJsonInterface,
        Built<UserStatusSetStatusResponseApplicationJson, UserStatusSetStatusResponseApplicationJsonBuilder> {
  /// Creates a new UserStatusSetStatusResponseApplicationJson object using the builder pattern.
  factory UserStatusSetStatusResponseApplicationJson([
    void Function(UserStatusSetStatusResponseApplicationJsonBuilder)? b,
  ]) = _$UserStatusSetStatusResponseApplicationJson;

  // coverage:ignore-start
  const UserStatusSetStatusResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetStatusResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetStatusResponseApplicationJson.
  static Serializer<UserStatusSetStatusResponseApplicationJson> get serializer =>
      _$userStatusSetStatusResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetStatusResponseApplicationJsonBuilder b) {
    $UserStatusSetStatusResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetStatusResponseApplicationJsonBuilder b) {
    $UserStatusSetStatusResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetPredefinedMessageRequestApplicationJsonInterface {
  /// ID of the predefined message.
  String get messageId;

  /// When the message should be cleared.
  int? get clearAt;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetPredefinedMessageRequestApplicationJsonInterfaceBuilder].
  $UserStatusSetPredefinedMessageRequestApplicationJsonInterface rebuild(
    void Function($UserStatusSetPredefinedMessageRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetPredefinedMessageRequestApplicationJsonInterfaceBuilder].
  $UserStatusSetPredefinedMessageRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetPredefinedMessageRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetPredefinedMessageRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusSetPredefinedMessageRequestApplicationJson
    implements
        $UserStatusSetPredefinedMessageRequestApplicationJsonInterface,
        Built<UserStatusSetPredefinedMessageRequestApplicationJson,
            UserStatusSetPredefinedMessageRequestApplicationJsonBuilder> {
  /// Creates a new UserStatusSetPredefinedMessageRequestApplicationJson object using the builder pattern.
  factory UserStatusSetPredefinedMessageRequestApplicationJson([
    void Function(UserStatusSetPredefinedMessageRequestApplicationJsonBuilder)? b,
  ]) = _$UserStatusSetPredefinedMessageRequestApplicationJson;

  // coverage:ignore-start
  const UserStatusSetPredefinedMessageRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetPredefinedMessageRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetPredefinedMessageRequestApplicationJson.
  static Serializer<UserStatusSetPredefinedMessageRequestApplicationJson> get serializer =>
      _$userStatusSetPredefinedMessageRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetPredefinedMessageRequestApplicationJsonBuilder b) {
    $UserStatusSetPredefinedMessageRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetPredefinedMessageRequestApplicationJsonBuilder b) {
    $UserStatusSetPredefinedMessageRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Private get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterface rebuild(
    void Function($UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UserStatusSetPredefinedMessageResponseApplicationJson_Ocs
    implements
        $UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterface,
        Built<UserStatusSetPredefinedMessageResponseApplicationJson_Ocs,
            UserStatusSetPredefinedMessageResponseApplicationJson_OcsBuilder> {
  /// Creates a new UserStatusSetPredefinedMessageResponseApplicationJson_Ocs object using the builder pattern.
  factory UserStatusSetPredefinedMessageResponseApplicationJson_Ocs([
    void Function(UserStatusSetPredefinedMessageResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UserStatusSetPredefinedMessageResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UserStatusSetPredefinedMessageResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetPredefinedMessageResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetPredefinedMessageResponseApplicationJson_Ocs.
  static Serializer<UserStatusSetPredefinedMessageResponseApplicationJson_Ocs> get serializer =>
      _$userStatusSetPredefinedMessageResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetPredefinedMessageResponseApplicationJson_OcsBuilder b) {
    $UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetPredefinedMessageResponseApplicationJson_OcsBuilder b) {
    $UserStatusSetPredefinedMessageResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetPredefinedMessageResponseApplicationJsonInterface {
  UserStatusSetPredefinedMessageResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetPredefinedMessageResponseApplicationJsonInterfaceBuilder].
  $UserStatusSetPredefinedMessageResponseApplicationJsonInterface rebuild(
    void Function($UserStatusSetPredefinedMessageResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetPredefinedMessageResponseApplicationJsonInterfaceBuilder].
  $UserStatusSetPredefinedMessageResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetPredefinedMessageResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetPredefinedMessageResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusSetPredefinedMessageResponseApplicationJson
    implements
        $UserStatusSetPredefinedMessageResponseApplicationJsonInterface,
        Built<UserStatusSetPredefinedMessageResponseApplicationJson,
            UserStatusSetPredefinedMessageResponseApplicationJsonBuilder> {
  /// Creates a new UserStatusSetPredefinedMessageResponseApplicationJson object using the builder pattern.
  factory UserStatusSetPredefinedMessageResponseApplicationJson([
    void Function(UserStatusSetPredefinedMessageResponseApplicationJsonBuilder)? b,
  ]) = _$UserStatusSetPredefinedMessageResponseApplicationJson;

  // coverage:ignore-start
  const UserStatusSetPredefinedMessageResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetPredefinedMessageResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetPredefinedMessageResponseApplicationJson.
  static Serializer<UserStatusSetPredefinedMessageResponseApplicationJson> get serializer =>
      _$userStatusSetPredefinedMessageResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetPredefinedMessageResponseApplicationJsonBuilder b) {
    $UserStatusSetPredefinedMessageResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetPredefinedMessageResponseApplicationJsonBuilder b) {
    $UserStatusSetPredefinedMessageResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetCustomMessageRequestApplicationJsonInterface {
  /// Icon of the status.
  String? get statusIcon;

  /// Message of the status.
  String? get message;

  /// When the message should be cleared.
  int? get clearAt;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetCustomMessageRequestApplicationJsonInterfaceBuilder].
  $UserStatusSetCustomMessageRequestApplicationJsonInterface rebuild(
    void Function($UserStatusSetCustomMessageRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetCustomMessageRequestApplicationJsonInterfaceBuilder].
  $UserStatusSetCustomMessageRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetCustomMessageRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetCustomMessageRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusSetCustomMessageRequestApplicationJson
    implements
        $UserStatusSetCustomMessageRequestApplicationJsonInterface,
        Built<UserStatusSetCustomMessageRequestApplicationJson,
            UserStatusSetCustomMessageRequestApplicationJsonBuilder> {
  /// Creates a new UserStatusSetCustomMessageRequestApplicationJson object using the builder pattern.
  factory UserStatusSetCustomMessageRequestApplicationJson([
    void Function(UserStatusSetCustomMessageRequestApplicationJsonBuilder)? b,
  ]) = _$UserStatusSetCustomMessageRequestApplicationJson;

  // coverage:ignore-start
  const UserStatusSetCustomMessageRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetCustomMessageRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetCustomMessageRequestApplicationJson.
  static Serializer<UserStatusSetCustomMessageRequestApplicationJson> get serializer =>
      _$userStatusSetCustomMessageRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetCustomMessageRequestApplicationJsonBuilder b) {
    $UserStatusSetCustomMessageRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetCustomMessageRequestApplicationJsonBuilder b) {
    $UserStatusSetCustomMessageRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetCustomMessageResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Private get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetCustomMessageResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusSetCustomMessageResponseApplicationJson_OcsInterface rebuild(
    void Function($UserStatusSetCustomMessageResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetCustomMessageResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusSetCustomMessageResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetCustomMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetCustomMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UserStatusSetCustomMessageResponseApplicationJson_Ocs
    implements
        $UserStatusSetCustomMessageResponseApplicationJson_OcsInterface,
        Built<UserStatusSetCustomMessageResponseApplicationJson_Ocs,
            UserStatusSetCustomMessageResponseApplicationJson_OcsBuilder> {
  /// Creates a new UserStatusSetCustomMessageResponseApplicationJson_Ocs object using the builder pattern.
  factory UserStatusSetCustomMessageResponseApplicationJson_Ocs([
    void Function(UserStatusSetCustomMessageResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UserStatusSetCustomMessageResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UserStatusSetCustomMessageResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetCustomMessageResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetCustomMessageResponseApplicationJson_Ocs.
  static Serializer<UserStatusSetCustomMessageResponseApplicationJson_Ocs> get serializer =>
      _$userStatusSetCustomMessageResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetCustomMessageResponseApplicationJson_OcsBuilder b) {
    $UserStatusSetCustomMessageResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetCustomMessageResponseApplicationJson_OcsBuilder b) {
    $UserStatusSetCustomMessageResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusSetCustomMessageResponseApplicationJsonInterface {
  UserStatusSetCustomMessageResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusSetCustomMessageResponseApplicationJsonInterfaceBuilder].
  $UserStatusSetCustomMessageResponseApplicationJsonInterface rebuild(
    void Function($UserStatusSetCustomMessageResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusSetCustomMessageResponseApplicationJsonInterfaceBuilder].
  $UserStatusSetCustomMessageResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusSetCustomMessageResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusSetCustomMessageResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusSetCustomMessageResponseApplicationJson
    implements
        $UserStatusSetCustomMessageResponseApplicationJsonInterface,
        Built<UserStatusSetCustomMessageResponseApplicationJson,
            UserStatusSetCustomMessageResponseApplicationJsonBuilder> {
  /// Creates a new UserStatusSetCustomMessageResponseApplicationJson object using the builder pattern.
  factory UserStatusSetCustomMessageResponseApplicationJson([
    void Function(UserStatusSetCustomMessageResponseApplicationJsonBuilder)? b,
  ]) = _$UserStatusSetCustomMessageResponseApplicationJson;

  // coverage:ignore-start
  const UserStatusSetCustomMessageResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusSetCustomMessageResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusSetCustomMessageResponseApplicationJson.
  static Serializer<UserStatusSetCustomMessageResponseApplicationJson> get serializer =>
      _$userStatusSetCustomMessageResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusSetCustomMessageResponseApplicationJsonBuilder b) {
    $UserStatusSetCustomMessageResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusSetCustomMessageResponseApplicationJsonBuilder b) {
    $UserStatusSetCustomMessageResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusClearMessageResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusClearMessageResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusClearMessageResponseApplicationJson_OcsInterface rebuild(
    void Function($UserStatusClearMessageResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusClearMessageResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusClearMessageResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusClearMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusClearMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UserStatusClearMessageResponseApplicationJson_Ocs
    implements
        $UserStatusClearMessageResponseApplicationJson_OcsInterface,
        Built<UserStatusClearMessageResponseApplicationJson_Ocs,
            UserStatusClearMessageResponseApplicationJson_OcsBuilder> {
  /// Creates a new UserStatusClearMessageResponseApplicationJson_Ocs object using the builder pattern.
  factory UserStatusClearMessageResponseApplicationJson_Ocs([
    void Function(UserStatusClearMessageResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UserStatusClearMessageResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UserStatusClearMessageResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusClearMessageResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusClearMessageResponseApplicationJson_Ocs.
  static Serializer<UserStatusClearMessageResponseApplicationJson_Ocs> get serializer =>
      _$userStatusClearMessageResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusClearMessageResponseApplicationJson_OcsBuilder b) {
    $UserStatusClearMessageResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusClearMessageResponseApplicationJson_OcsBuilder b) {
    $UserStatusClearMessageResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusClearMessageResponseApplicationJsonInterface {
  UserStatusClearMessageResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusClearMessageResponseApplicationJsonInterfaceBuilder].
  $UserStatusClearMessageResponseApplicationJsonInterface rebuild(
    void Function($UserStatusClearMessageResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusClearMessageResponseApplicationJsonInterfaceBuilder].
  $UserStatusClearMessageResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusClearMessageResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusClearMessageResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusClearMessageResponseApplicationJson
    implements
        $UserStatusClearMessageResponseApplicationJsonInterface,
        Built<UserStatusClearMessageResponseApplicationJson, UserStatusClearMessageResponseApplicationJsonBuilder> {
  /// Creates a new UserStatusClearMessageResponseApplicationJson object using the builder pattern.
  factory UserStatusClearMessageResponseApplicationJson([
    void Function(UserStatusClearMessageResponseApplicationJsonBuilder)? b,
  ]) = _$UserStatusClearMessageResponseApplicationJson;

  // coverage:ignore-start
  const UserStatusClearMessageResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusClearMessageResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusClearMessageResponseApplicationJson.
  static Serializer<UserStatusClearMessageResponseApplicationJson> get serializer =>
      _$userStatusClearMessageResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusClearMessageResponseApplicationJsonBuilder b) {
    $UserStatusClearMessageResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusClearMessageResponseApplicationJsonBuilder b) {
    $UserStatusClearMessageResponseApplicationJsonInterface._validate(b);
  }
}

typedef UserStatusRevertStatusResponseApplicationJson_Ocs_Data = ({BuiltList<Never>? builtListNever, Private? private});

@BuiltValue(instantiable: false)
sealed class $UserStatusRevertStatusResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UserStatusRevertStatusResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusRevertStatusResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusRevertStatusResponseApplicationJson_OcsInterface rebuild(
    void Function($UserStatusRevertStatusResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusRevertStatusResponseApplicationJson_OcsInterfaceBuilder].
  $UserStatusRevertStatusResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusRevertStatusResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusRevertStatusResponseApplicationJson_OcsInterfaceBuilder b) {
    b.data?.validateAnyOf();
  }
}

abstract class UserStatusRevertStatusResponseApplicationJson_Ocs
    implements
        $UserStatusRevertStatusResponseApplicationJson_OcsInterface,
        Built<UserStatusRevertStatusResponseApplicationJson_Ocs,
            UserStatusRevertStatusResponseApplicationJson_OcsBuilder> {
  /// Creates a new UserStatusRevertStatusResponseApplicationJson_Ocs object using the builder pattern.
  factory UserStatusRevertStatusResponseApplicationJson_Ocs([
    void Function(UserStatusRevertStatusResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UserStatusRevertStatusResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UserStatusRevertStatusResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusRevertStatusResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusRevertStatusResponseApplicationJson_Ocs.
  static Serializer<UserStatusRevertStatusResponseApplicationJson_Ocs> get serializer =>
      _$userStatusRevertStatusResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusRevertStatusResponseApplicationJson_OcsBuilder b) {
    $UserStatusRevertStatusResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusRevertStatusResponseApplicationJson_OcsBuilder b) {
    $UserStatusRevertStatusResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusRevertStatusResponseApplicationJsonInterface {
  UserStatusRevertStatusResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusRevertStatusResponseApplicationJsonInterfaceBuilder].
  $UserStatusRevertStatusResponseApplicationJsonInterface rebuild(
    void Function($UserStatusRevertStatusResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusRevertStatusResponseApplicationJsonInterfaceBuilder].
  $UserStatusRevertStatusResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusRevertStatusResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusRevertStatusResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UserStatusRevertStatusResponseApplicationJson
    implements
        $UserStatusRevertStatusResponseApplicationJsonInterface,
        Built<UserStatusRevertStatusResponseApplicationJson, UserStatusRevertStatusResponseApplicationJsonBuilder> {
  /// Creates a new UserStatusRevertStatusResponseApplicationJson object using the builder pattern.
  factory UserStatusRevertStatusResponseApplicationJson([
    void Function(UserStatusRevertStatusResponseApplicationJsonBuilder)? b,
  ]) = _$UserStatusRevertStatusResponseApplicationJson;

  // coverage:ignore-start
  const UserStatusRevertStatusResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusRevertStatusResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusRevertStatusResponseApplicationJson.
  static Serializer<UserStatusRevertStatusResponseApplicationJson> get serializer =>
      _$userStatusRevertStatusResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusRevertStatusResponseApplicationJsonBuilder b) {
    $UserStatusRevertStatusResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusRevertStatusResponseApplicationJsonBuilder b) {
    $UserStatusRevertStatusResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_UserStatusInterface {
  bool get enabled;
  bool get restore;
  @BuiltValueField(wireName: 'supports_emoji')
  bool get supportsEmoji;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_UserStatusInterfaceBuilder].
  $Capabilities_UserStatusInterface rebuild(void Function($Capabilities_UserStatusInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Capabilities_UserStatusInterfaceBuilder].
  $Capabilities_UserStatusInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_UserStatusInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_UserStatusInterfaceBuilder b) {}
}

abstract class Capabilities_UserStatus
    implements $Capabilities_UserStatusInterface, Built<Capabilities_UserStatus, Capabilities_UserStatusBuilder> {
  /// Creates a new Capabilities_UserStatus object using the builder pattern.
  factory Capabilities_UserStatus([void Function(Capabilities_UserStatusBuilder)? b]) = _$Capabilities_UserStatus;

  // coverage:ignore-start
  const Capabilities_UserStatus._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_UserStatus.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_UserStatus.
  static Serializer<Capabilities_UserStatus> get serializer => _$capabilitiesUserStatusSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_UserStatusBuilder b) {
    $Capabilities_UserStatusInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_UserStatusBuilder b) {
    $Capabilities_UserStatusInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CapabilitiesInterface {
  @BuiltValueField(wireName: 'user_status')
  Capabilities_UserStatus get userStatus;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterface rebuild(void Function($CapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CapabilitiesInterfaceBuilder b) {}
}

abstract class Capabilities implements $CapabilitiesInterface, Built<Capabilities, CapabilitiesBuilder> {
  /// Creates a new Capabilities object using the builder pattern.
  factory Capabilities([void Function(CapabilitiesBuilder)? b]) = _$Capabilities;

  // coverage:ignore-start
  const Capabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities.
  static Serializer<Capabilities> get serializer => _$capabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CapabilitiesBuilder b) {
    $CapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CapabilitiesBuilder b) {
    $CapabilitiesInterface._validate(b);
  }
}

/// Serialization extension for `ClearAt_Time`.
extension $ClearAt_TimeExtension on ClearAt_Time {
  /// Serializer for ClearAt_Time.
  @BuiltValueSerializer(custom: true)
  static Serializer<ClearAt_Time> get serializer => $557344b3ba734aacc7109e5420fcb6c5Extension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static ClearAt_Time fromJson(Object? json) => $557344b3ba734aacc7109e5420fcb6c5Extension._fromJson(json);
}

/// Serialization extension for `UserStatusRevertStatusResponseApplicationJson_Ocs_Data`.
extension $UserStatusRevertStatusResponseApplicationJson_Ocs_DataExtension
    on UserStatusRevertStatusResponseApplicationJson_Ocs_Data {
  /// Serializer for UserStatusRevertStatusResponseApplicationJson_Ocs_Data.
  @BuiltValueSerializer(custom: true)
  static Serializer<UserStatusRevertStatusResponseApplicationJson_Ocs_Data> get serializer =>
      $d77829de8b7590d2e16cdb714800f5beExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static UserStatusRevertStatusResponseApplicationJson_Ocs_Data fromJson(Object? json) =>
      $d77829de8b7590d2e16cdb714800f5beExtension._fromJson(json);
}

typedef _$557344b3ba734aacc7109e5420fcb6c5 = ({ClearAtTimeType? clearAtTimeType, int? $int});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $557344b3ba734aacc7109e5420fcb6c5Extension on _$557344b3ba734aacc7109e5420fcb6c5 {
  List<dynamic> get _values => [clearAtTimeType, $int];
  List<String> get _names => const ['clearAtTimeType', r'$int'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$557344b3ba734aacc7109e5420fcb6c5> get _serializer =>
      const _$557344b3ba734aacc7109e5420fcb6c5Serializer();
  static _$557344b3ba734aacc7109e5420fcb6c5 _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$557344b3ba734aacc7109e5420fcb6c5Serializer implements PrimitiveSerializer<_$557344b3ba734aacc7109e5420fcb6c5> {
  const _$557344b3ba734aacc7109e5420fcb6c5Serializer();

  @override
  Iterable<Type> get types => const [_$557344b3ba734aacc7109e5420fcb6c5];

  @override
  String get wireName => r'_$557344b3ba734aacc7109e5420fcb6c5';

  @override
  Object serialize(
    Serializers serializers,
    _$557344b3ba734aacc7109e5420fcb6c5 object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.clearAtTimeType;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(ClearAtTimeType))!;
    }
    value = object.$int;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(int))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$557344b3ba734aacc7109e5420fcb6c5 deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    ClearAtTimeType? clearAtTimeType;
    try {
      clearAtTimeType = serializers.deserialize(
        data,
        specifiedType: const FullType(ClearAtTimeType),
      )! as ClearAtTimeType;
    } catch (_) {}
    int? $int;
    try {
      $int = serializers.deserialize(
        data,
        specifiedType: const FullType(int),
      )! as int;
    } catch (_) {}
    return (clearAtTimeType: clearAtTimeType, $int: $int);
  }
}

typedef _$d77829de8b7590d2e16cdb714800f5be = ({BuiltList<Never>? builtListNever, Private? private});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $d77829de8b7590d2e16cdb714800f5beExtension on _$d77829de8b7590d2e16cdb714800f5be {
  List<dynamic> get _values => [builtListNever, private];
  List<String> get _names => const ['builtListNever', 'private'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$d77829de8b7590d2e16cdb714800f5be> get _serializer =>
      const _$d77829de8b7590d2e16cdb714800f5beSerializer();
  static _$d77829de8b7590d2e16cdb714800f5be _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$d77829de8b7590d2e16cdb714800f5beSerializer implements PrimitiveSerializer<_$d77829de8b7590d2e16cdb714800f5be> {
  const _$d77829de8b7590d2e16cdb714800f5beSerializer();

  @override
  Iterable<Type> get types => const [_$d77829de8b7590d2e16cdb714800f5be];

  @override
  String get wireName => r'_$d77829de8b7590d2e16cdb714800f5be';

  @override
  Object serialize(
    Serializers serializers,
    _$d77829de8b7590d2e16cdb714800f5be object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.builtListNever;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(BuiltList, [FullType(Never)]))!;
    }
    value = object.private;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(Private))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$d77829de8b7590d2e16cdb714800f5be deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    BuiltList<Never>? builtListNever;
    try {
      builtListNever = serializers.deserialize(
        data,
        specifiedType: const FullType(BuiltList, [FullType(Never)]),
      )! as BuiltList<Never>;
    } catch (_) {}
    Private? private;
    try {
      private = serializers.deserialize(
        data,
        specifiedType: const FullType(Private),
      )! as Private;
    } catch (_) {}
    return (builtListNever: builtListNever, private: private);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(
        const FullType(HeartbeatHeartbeatRequestApplicationJson),
        HeartbeatHeartbeatRequestApplicationJsonBuilder.new,
      )
      ..add(HeartbeatHeartbeatRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(HeartbeatHeartbeatResponseApplicationJson),
        HeartbeatHeartbeatResponseApplicationJsonBuilder.new,
      )
      ..add(HeartbeatHeartbeatResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(HeartbeatHeartbeatResponseApplicationJson_Ocs),
        HeartbeatHeartbeatResponseApplicationJson_OcsBuilder.new,
      )
      ..add(HeartbeatHeartbeatResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(const FullType(Private), PrivateBuilder.new)
      ..add(Private.serializer)
      ..addBuilderFactory(const FullType(Public), PublicBuilder.new)
      ..add(Public.serializer)
      ..add($Type.serializer)
      ..addBuilderFactory(
        const FullType(PredefinedStatusFindAllResponseApplicationJson),
        PredefinedStatusFindAllResponseApplicationJsonBuilder.new,
      )
      ..add(PredefinedStatusFindAllResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PredefinedStatusFindAllResponseApplicationJson_Ocs),
        PredefinedStatusFindAllResponseApplicationJson_OcsBuilder.new,
      )
      ..add(PredefinedStatusFindAllResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Predefined), PredefinedBuilder.new)
      ..add(Predefined.serializer)
      ..addBuilderFactory(const FullType(ClearAt), ClearAtBuilder.new)
      ..add(ClearAt.serializer)
      ..add(ClearAt_Type.serializer)
      ..add(ClearAtTimeType.serializer)
      ..add($557344b3ba734aacc7109e5420fcb6c5Extension._serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Predefined)]), ListBuilder<Predefined>.new)
      ..addBuilderFactory(
        const FullType(StatusesFindAllResponseApplicationJson),
        StatusesFindAllResponseApplicationJsonBuilder.new,
      )
      ..add(StatusesFindAllResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(StatusesFindAllResponseApplicationJson_Ocs),
        StatusesFindAllResponseApplicationJson_OcsBuilder.new,
      )
      ..add(StatusesFindAllResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Public)]), ListBuilder<Public>.new)
      ..addBuilderFactory(
        const FullType(StatusesFindResponseApplicationJson),
        StatusesFindResponseApplicationJsonBuilder.new,
      )
      ..add(StatusesFindResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(StatusesFindResponseApplicationJson_Ocs),
        StatusesFindResponseApplicationJson_OcsBuilder.new,
      )
      ..add(StatusesFindResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusGetStatusResponseApplicationJson),
        UserStatusGetStatusResponseApplicationJsonBuilder.new,
      )
      ..add(UserStatusGetStatusResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusGetStatusResponseApplicationJson_Ocs),
        UserStatusGetStatusResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UserStatusGetStatusResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetStatusRequestApplicationJson),
        UserStatusSetStatusRequestApplicationJsonBuilder.new,
      )
      ..add(UserStatusSetStatusRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetStatusResponseApplicationJson),
        UserStatusSetStatusResponseApplicationJsonBuilder.new,
      )
      ..add(UserStatusSetStatusResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetStatusResponseApplicationJson_Ocs),
        UserStatusSetStatusResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UserStatusSetStatusResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetPredefinedMessageRequestApplicationJson),
        UserStatusSetPredefinedMessageRequestApplicationJsonBuilder.new,
      )
      ..add(UserStatusSetPredefinedMessageRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetPredefinedMessageResponseApplicationJson),
        UserStatusSetPredefinedMessageResponseApplicationJsonBuilder.new,
      )
      ..add(UserStatusSetPredefinedMessageResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetPredefinedMessageResponseApplicationJson_Ocs),
        UserStatusSetPredefinedMessageResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UserStatusSetPredefinedMessageResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetCustomMessageRequestApplicationJson),
        UserStatusSetCustomMessageRequestApplicationJsonBuilder.new,
      )
      ..add(UserStatusSetCustomMessageRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetCustomMessageResponseApplicationJson),
        UserStatusSetCustomMessageResponseApplicationJsonBuilder.new,
      )
      ..add(UserStatusSetCustomMessageResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusSetCustomMessageResponseApplicationJson_Ocs),
        UserStatusSetCustomMessageResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UserStatusSetCustomMessageResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusClearMessageResponseApplicationJson),
        UserStatusClearMessageResponseApplicationJsonBuilder.new,
      )
      ..add(UserStatusClearMessageResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusClearMessageResponseApplicationJson_Ocs),
        UserStatusClearMessageResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UserStatusClearMessageResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusRevertStatusResponseApplicationJson),
        UserStatusRevertStatusResponseApplicationJsonBuilder.new,
      )
      ..add(UserStatusRevertStatusResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserStatusRevertStatusResponseApplicationJson_Ocs),
        UserStatusRevertStatusResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UserStatusRevertStatusResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Never)]), ListBuilder<Never>.new)
      ..add($d77829de8b7590d2e16cdb714800f5beExtension._serializer)
      ..addBuilderFactory(const FullType(Capabilities), CapabilitiesBuilder.new)
      ..add(Capabilities.serializer)
      ..addBuilderFactory(const FullType(Capabilities_UserStatus), Capabilities_UserStatusBuilder.new)
      ..add(Capabilities_UserStatus.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(
        _i8.StandardJsonPlugin(
          typesToLeaveAsList: const {
            _$557344b3ba734aacc7109e5420fcb6c5,
            _$d77829de8b7590d2e16cdb714800f5be,
          },
        ),
      )
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
