// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// user_ldap Version: 0.0.1.
///
/// This application enables administrators to connect Nextcloud to an LDAP-based user directory.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i5;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i6;

part 'user_ldap.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $ConfigapiClient configapi = $ConfigapiClient(this);
}

class $ConfigapiClient {
  /// Creates a new `DynamiteClient` for configapi requests.
  $ConfigapiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$create_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ConfigapiCreateResponseApplicationJson, void> $create_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ConfigapiCreateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a new (empty) configuration and return the resulting prefix.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [create] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Config created successfully
  ///
  /// See:
  ///  * [create] for a method executing this request and parsing the response.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $create_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/user_ldap/api/v1/config';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Create a new (empty) configuration and return the resulting prefix.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Config created successfully
  ///
  /// See:
  ///  * [$create_Request] for the request send by this method.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ConfigapiCreateResponseApplicationJson, void>> create({bool? oCSAPIRequest}) async {
    final _request = $create_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $create_Serializer();
    return _i1.ResponseConverter<ConfigapiCreateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$$show_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ConfigapiShowResponseApplicationJson, void> $$show_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ConfigapiShowResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a configuration.
  ///
  /// Output can look like this: &lt;?xml version="1.0"?&gt; &lt;ocs&gt; &lt;meta&gt; &lt;status&gt;ok&lt;/status&gt; &lt;statuscode&gt;200&lt;/statuscode&gt; &lt;message&gt;OK&lt;/message&gt; &lt;/meta&gt; &lt;data&gt; &lt;ldapHost&gt;ldaps://my.ldap.server&lt;/ldapHost&gt; &lt;ldapPort&gt;7770&lt;/ldapPort&gt; &lt;ldapBackupHost&gt;&lt;/ldapBackupHost&gt; &lt;ldapBackupPort&gt;&lt;/ldapBackupPort&gt; &lt;ldapBase&gt;ou=small,dc=my,dc=ldap,dc=server&lt;/ldapBase&gt; &lt;ldapBaseUsers&gt;ou=users,ou=small,dc=my,dc=ldap,dc=server&lt;/ldapBaseUsers&gt; &lt;ldapBaseGroups&gt;ou=small,dc=my,dc=ldap,dc=server&lt;/ldapBaseGroups&gt; &lt;ldapAgentName&gt;cn=root,dc=my,dc=ldap,dc=server&lt;/ldapAgentName&gt; &lt;ldapAgentPassword&gt;clearTextWithShowPassword=1&lt;/ldapAgentPassword&gt; &lt;ldapTLS&gt;1&lt;/ldapTLS&gt; &lt;turnOffCertCheck&gt;0&lt;/turnOffCertCheck&gt; &lt;ldapIgnoreNamingRules/&gt; &lt;ldapUserDisplayName&gt;displayname&lt;/ldapUserDisplayName&gt; &lt;ldapUserDisplayName2&gt;uid&lt;/ldapUserDisplayName2&gt; &lt;ldapUserFilterObjectclass&gt;inetOrgPerson&lt;/ldapUserFilterObjectclass&gt; &lt;ldapUserFilterGroups&gt;&lt;/ldapUserFilterGroups&gt; &lt;ldapUserFilter&gt;(&amp;(objectclass=nextcloudUser)(nextcloudEnabled=TRUE))&lt;/ldapUserFilter&gt; &lt;ldapUserFilterMode&gt;1&lt;/ldapUserFilterMode&gt; &lt;ldapGroupFilter&gt;(&amp;(|(objectclass=nextcloudGroup)))&lt;/ldapGroupFilter&gt; &lt;ldapGroupFilterMode&gt;0&lt;/ldapGroupFilterMode&gt; &lt;ldapGroupFilterObjectclass&gt;nextcloudGroup&lt;/ldapGroupFilterObjectclass&gt; &lt;ldapGroupFilterGroups&gt;&lt;/ldapGroupFilterGroups&gt; &lt;ldapGroupDisplayName&gt;cn&lt;/ldapGroupDisplayName&gt; &lt;ldapGroupMemberAssocAttr&gt;memberUid&lt;/ldapGroupMemberAssocAttr&gt; &lt;ldapLoginFilter&gt;(&amp;(|(objectclass=inetOrgPerson))(uid=%uid))&lt;/ldapLoginFilter&gt; &lt;ldapLoginFilterMode&gt;0&lt;/ldapLoginFilterMode&gt; &lt;ldapLoginFilterEmail&gt;0&lt;/ldapLoginFilterEmail&gt; &lt;ldapLoginFilterUsername&gt;1&lt;/ldapLoginFilterUsername&gt; &lt;ldapLoginFilterAttributes&gt;&lt;/ldapLoginFilterAttributes&gt; &lt;ldapQuotaAttribute&gt;&lt;/ldapQuotaAttribute&gt; &lt;ldapQuotaDefault&gt;&lt;/ldapQuotaDefault&gt; &lt;ldapEmailAttribute&gt;mail&lt;/ldapEmailAttribute&gt; &lt;ldapCacheTTL&gt;20&lt;/ldapCacheTTL&gt; &lt;ldapUuidUserAttribute&gt;auto&lt;/ldapUuidUserAttribute&gt; &lt;ldapUuidGroupAttribute&gt;auto&lt;/ldapUuidGroupAttribute&gt; &lt;ldapOverrideMainServer&gt;&lt;/ldapOverrideMainServer&gt; &lt;ldapConfigurationActive&gt;1&lt;/ldapConfigurationActive&gt; &lt;ldapAttributesForUserSearch&gt;uid;sn;givenname&lt;/ldapAttributesForUserSearch&gt; &lt;ldapAttributesForGroupSearch&gt;&lt;/ldapAttributesForGroupSearch&gt; &lt;ldapExperiencedAdmin&gt;0&lt;/ldapExperiencedAdmin&gt; &lt;homeFolderNamingRule&gt;&lt;/homeFolderNamingRule&gt; &lt;hasMemberOfFilterSupport&gt;&lt;/hasMemberOfFilterSupport&gt; &lt;useMemberOfToDetectMembership&gt;1&lt;/useMemberOfToDetectMembership&gt; &lt;ldapExpertUsernameAttr&gt;uid&lt;/ldapExpertUsernameAttr&gt; &lt;ldapExpertUUIDUserAttr&gt;uid&lt;/ldapExpertUUIDUserAttr&gt; &lt;ldapExpertUUIDGroupAttr&gt;&lt;/ldapExpertUUIDGroupAttr&gt; &lt;lastJpegPhotoLookup&gt;0&lt;/lastJpegPhotoLookup&gt; &lt;ldapNestedGroups&gt;0&lt;/ldapNestedGroups&gt; &lt;ldapPagingSize&gt;500&lt;/ldapPagingSize&gt; &lt;turnOnPasswordChange&gt;1&lt;/turnOnPasswordChange&gt; &lt;ldapDynamicGroupMemberURL&gt;&lt;/ldapDynamicGroupMemberURL&gt; &lt;/data&gt; &lt;/ocs&gt;.
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [$show] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [configID] ID of the config.
  ///   * [showPassword] Whether to show the password. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Config returned
  ///   * 404: Config not found
  ///
  /// See:
  ///  * [$show] for a method executing this request and parsing the response.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$show_Request({
    required String configID,
    ConfigapiShowShowPassword? showPassword,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __configID = _$jsonSerializers.serialize(configID, specifiedType: const FullType(String));
    _parameters['configID'] = __configID;

    var __showPassword =
        _$jsonSerializers.serialize(showPassword, specifiedType: const FullType(ConfigapiShowShowPassword));
    __showPassword ??= 0;
    _parameters['showPassword'] = __showPassword;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/apps/user_ldap/api/v1/config/{configID}{?showPassword*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a configuration.
  ///
  /// Output can look like this: &lt;?xml version="1.0"?&gt; &lt;ocs&gt; &lt;meta&gt; &lt;status&gt;ok&lt;/status&gt; &lt;statuscode&gt;200&lt;/statuscode&gt; &lt;message&gt;OK&lt;/message&gt; &lt;/meta&gt; &lt;data&gt; &lt;ldapHost&gt;ldaps://my.ldap.server&lt;/ldapHost&gt; &lt;ldapPort&gt;7770&lt;/ldapPort&gt; &lt;ldapBackupHost&gt;&lt;/ldapBackupHost&gt; &lt;ldapBackupPort&gt;&lt;/ldapBackupPort&gt; &lt;ldapBase&gt;ou=small,dc=my,dc=ldap,dc=server&lt;/ldapBase&gt; &lt;ldapBaseUsers&gt;ou=users,ou=small,dc=my,dc=ldap,dc=server&lt;/ldapBaseUsers&gt; &lt;ldapBaseGroups&gt;ou=small,dc=my,dc=ldap,dc=server&lt;/ldapBaseGroups&gt; &lt;ldapAgentName&gt;cn=root,dc=my,dc=ldap,dc=server&lt;/ldapAgentName&gt; &lt;ldapAgentPassword&gt;clearTextWithShowPassword=1&lt;/ldapAgentPassword&gt; &lt;ldapTLS&gt;1&lt;/ldapTLS&gt; &lt;turnOffCertCheck&gt;0&lt;/turnOffCertCheck&gt; &lt;ldapIgnoreNamingRules/&gt; &lt;ldapUserDisplayName&gt;displayname&lt;/ldapUserDisplayName&gt; &lt;ldapUserDisplayName2&gt;uid&lt;/ldapUserDisplayName2&gt; &lt;ldapUserFilterObjectclass&gt;inetOrgPerson&lt;/ldapUserFilterObjectclass&gt; &lt;ldapUserFilterGroups&gt;&lt;/ldapUserFilterGroups&gt; &lt;ldapUserFilter&gt;(&amp;(objectclass=nextcloudUser)(nextcloudEnabled=TRUE))&lt;/ldapUserFilter&gt; &lt;ldapUserFilterMode&gt;1&lt;/ldapUserFilterMode&gt; &lt;ldapGroupFilter&gt;(&amp;(|(objectclass=nextcloudGroup)))&lt;/ldapGroupFilter&gt; &lt;ldapGroupFilterMode&gt;0&lt;/ldapGroupFilterMode&gt; &lt;ldapGroupFilterObjectclass&gt;nextcloudGroup&lt;/ldapGroupFilterObjectclass&gt; &lt;ldapGroupFilterGroups&gt;&lt;/ldapGroupFilterGroups&gt; &lt;ldapGroupDisplayName&gt;cn&lt;/ldapGroupDisplayName&gt; &lt;ldapGroupMemberAssocAttr&gt;memberUid&lt;/ldapGroupMemberAssocAttr&gt; &lt;ldapLoginFilter&gt;(&amp;(|(objectclass=inetOrgPerson))(uid=%uid))&lt;/ldapLoginFilter&gt; &lt;ldapLoginFilterMode&gt;0&lt;/ldapLoginFilterMode&gt; &lt;ldapLoginFilterEmail&gt;0&lt;/ldapLoginFilterEmail&gt; &lt;ldapLoginFilterUsername&gt;1&lt;/ldapLoginFilterUsername&gt; &lt;ldapLoginFilterAttributes&gt;&lt;/ldapLoginFilterAttributes&gt; &lt;ldapQuotaAttribute&gt;&lt;/ldapQuotaAttribute&gt; &lt;ldapQuotaDefault&gt;&lt;/ldapQuotaDefault&gt; &lt;ldapEmailAttribute&gt;mail&lt;/ldapEmailAttribute&gt; &lt;ldapCacheTTL&gt;20&lt;/ldapCacheTTL&gt; &lt;ldapUuidUserAttribute&gt;auto&lt;/ldapUuidUserAttribute&gt; &lt;ldapUuidGroupAttribute&gt;auto&lt;/ldapUuidGroupAttribute&gt; &lt;ldapOverrideMainServer&gt;&lt;/ldapOverrideMainServer&gt; &lt;ldapConfigurationActive&gt;1&lt;/ldapConfigurationActive&gt; &lt;ldapAttributesForUserSearch&gt;uid;sn;givenname&lt;/ldapAttributesForUserSearch&gt; &lt;ldapAttributesForGroupSearch&gt;&lt;/ldapAttributesForGroupSearch&gt; &lt;ldapExperiencedAdmin&gt;0&lt;/ldapExperiencedAdmin&gt; &lt;homeFolderNamingRule&gt;&lt;/homeFolderNamingRule&gt; &lt;hasMemberOfFilterSupport&gt;&lt;/hasMemberOfFilterSupport&gt; &lt;useMemberOfToDetectMembership&gt;1&lt;/useMemberOfToDetectMembership&gt; &lt;ldapExpertUsernameAttr&gt;uid&lt;/ldapExpertUsernameAttr&gt; &lt;ldapExpertUUIDUserAttr&gt;uid&lt;/ldapExpertUUIDUserAttr&gt; &lt;ldapExpertUUIDGroupAttr&gt;&lt;/ldapExpertUUIDGroupAttr&gt; &lt;lastJpegPhotoLookup&gt;0&lt;/lastJpegPhotoLookup&gt; &lt;ldapNestedGroups&gt;0&lt;/ldapNestedGroups&gt; &lt;ldapPagingSize&gt;500&lt;/ldapPagingSize&gt; &lt;turnOnPasswordChange&gt;1&lt;/turnOnPasswordChange&gt; &lt;ldapDynamicGroupMemberURL&gt;&lt;/ldapDynamicGroupMemberURL&gt; &lt;/data&gt; &lt;/ocs&gt;.
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [configID] ID of the config.
  ///   * [showPassword] Whether to show the password. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Config returned
  ///   * 404: Config not found
  ///
  /// See:
  ///  * [$$show_Request] for the request send by this method.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ConfigapiShowResponseApplicationJson, void>> $show({
    required String configID,
    ConfigapiShowShowPassword? showPassword,
    bool? oCSAPIRequest,
  }) async {
    final _request = $$show_Request(
      configID: configID,
      showPassword: showPassword,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$show_Serializer();
    return _i1.ResponseConverter<ConfigapiShowResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$modify_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ConfigapiModifyResponseApplicationJson, void> $modify_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ConfigapiModifyResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400, 404},
      );

  /// Modify a configuration.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [modify] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [configID] ID of the config.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Config returned
  ///   * 400: Modifying config is not possible
  ///   * 404: Config not found
  ///
  /// See:
  ///  * [modify] for a method executing this request and parsing the response.
  ///  * [$modify_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $modify_Request({
    required String configID,
    required ConfigapiModifyRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __configID = _$jsonSerializers.serialize(configID, specifiedType: const FullType(String));
    _parameters['configID'] = __configID;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/user_ldap/api/v1/config/{configID}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ConfigapiModifyRequestApplicationJson)),
    );
    return _request;
  }

  /// Modify a configuration.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [configID] ID of the config.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Config returned
  ///   * 400: Modifying config is not possible
  ///   * 404: Config not found
  ///
  /// See:
  ///  * [$modify_Request] for the request send by this method.
  ///  * [$modify_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ConfigapiModifyResponseApplicationJson, void>> modify({
    required String configID,
    required ConfigapiModifyRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $modify_Request(
      configID: configID,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $modify_Serializer();
    return _i1.ResponseConverter<ConfigapiModifyResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$delete_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ConfigapiDeleteResponseApplicationJson, void> $delete_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ConfigapiDeleteResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Delete a LDAP configuration.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [delete] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [configID] ID of the config.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Config deleted successfully
  ///   * 404: Config not found
  ///
  /// See:
  ///  * [delete] for a method executing this request and parsing the response.
  ///  * [$delete_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $delete_Request({
    required String configID,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __configID = _$jsonSerializers.serialize(configID, specifiedType: const FullType(String));
    _parameters['configID'] = __configID;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/user_ldap/api/v1/config/{configID}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete a LDAP configuration.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [configID] ID of the config.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Config deleted successfully
  ///   * 404: Config not found
  ///
  /// See:
  ///  * [$delete_Request] for the request send by this method.
  ///  * [$delete_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ConfigapiDeleteResponseApplicationJson, void>> delete({
    required String configID,
    bool? oCSAPIRequest,
  }) async {
    final _request = $delete_Request(
      configID: configID,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $delete_Serializer();
    return _i1.ResponseConverter<ConfigapiDeleteResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiCreateResponseApplicationJson_Ocs_DataInterface {
  String get configID;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiCreateResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ConfigapiCreateResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ConfigapiCreateResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiCreateResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ConfigapiCreateResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiCreateResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiCreateResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ConfigapiCreateResponseApplicationJson_Ocs_Data
    implements
        $ConfigapiCreateResponseApplicationJson_Ocs_DataInterface,
        Built<ConfigapiCreateResponseApplicationJson_Ocs_Data, ConfigapiCreateResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ConfigapiCreateResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ConfigapiCreateResponseApplicationJson_Ocs_Data([
    void Function(ConfigapiCreateResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ConfigapiCreateResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ConfigapiCreateResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiCreateResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiCreateResponseApplicationJson_Ocs_Data.
  static Serializer<ConfigapiCreateResponseApplicationJson_Ocs_Data> get serializer =>
      _$configapiCreateResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiCreateResponseApplicationJson_Ocs_DataBuilder b) {
    $ConfigapiCreateResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiCreateResponseApplicationJson_Ocs_DataBuilder b) {
    $ConfigapiCreateResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiCreateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ConfigapiCreateResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiCreateResponseApplicationJson_OcsInterfaceBuilder].
  $ConfigapiCreateResponseApplicationJson_OcsInterface rebuild(
    void Function($ConfigapiCreateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiCreateResponseApplicationJson_OcsInterfaceBuilder].
  $ConfigapiCreateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ConfigapiCreateResponseApplicationJson_Ocs
    implements
        $ConfigapiCreateResponseApplicationJson_OcsInterface,
        Built<ConfigapiCreateResponseApplicationJson_Ocs, ConfigapiCreateResponseApplicationJson_OcsBuilder> {
  /// Creates a new ConfigapiCreateResponseApplicationJson_Ocs object using the builder pattern.
  factory ConfigapiCreateResponseApplicationJson_Ocs([
    void Function(ConfigapiCreateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ConfigapiCreateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ConfigapiCreateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiCreateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiCreateResponseApplicationJson_Ocs.
  static Serializer<ConfigapiCreateResponseApplicationJson_Ocs> get serializer =>
      _$configapiCreateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiCreateResponseApplicationJson_OcsBuilder b) {
    $ConfigapiCreateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiCreateResponseApplicationJson_OcsBuilder b) {
    $ConfigapiCreateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiCreateResponseApplicationJsonInterface {
  ConfigapiCreateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiCreateResponseApplicationJsonInterfaceBuilder].
  $ConfigapiCreateResponseApplicationJsonInterface rebuild(
    void Function($ConfigapiCreateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiCreateResponseApplicationJsonInterfaceBuilder].
  $ConfigapiCreateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiCreateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiCreateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ConfigapiCreateResponseApplicationJson
    implements
        $ConfigapiCreateResponseApplicationJsonInterface,
        Built<ConfigapiCreateResponseApplicationJson, ConfigapiCreateResponseApplicationJsonBuilder> {
  /// Creates a new ConfigapiCreateResponseApplicationJson object using the builder pattern.
  factory ConfigapiCreateResponseApplicationJson([void Function(ConfigapiCreateResponseApplicationJsonBuilder)? b]) =
      _$ConfigapiCreateResponseApplicationJson;

  // coverage:ignore-start
  const ConfigapiCreateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiCreateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiCreateResponseApplicationJson.
  static Serializer<ConfigapiCreateResponseApplicationJson> get serializer =>
      _$configapiCreateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiCreateResponseApplicationJsonBuilder b) {
    $ConfigapiCreateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiCreateResponseApplicationJsonBuilder b) {
    $ConfigapiCreateResponseApplicationJsonInterface._validate(b);
  }
}

class ConfigapiShowShowPassword extends EnumClass {
  const ConfigapiShowShowPassword._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ConfigapiShowShowPassword $0 = _$configapiShowShowPassword$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ConfigapiShowShowPassword $1 = _$configapiShowShowPassword$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ConfigapiShowShowPassword> get values => _$configapiShowShowPasswordValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ConfigapiShowShowPassword valueOf(String name) => _$valueOfConfigapiShowShowPassword(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ConfigapiShowShowPassword.
  @BuiltValueSerializer(custom: true)
  static Serializer<ConfigapiShowShowPassword> get serializer => const _$ConfigapiShowShowPasswordSerializer();
}

class _$ConfigapiShowShowPasswordSerializer implements PrimitiveSerializer<ConfigapiShowShowPassword> {
  const _$ConfigapiShowShowPasswordSerializer();

  static const Map<ConfigapiShowShowPassword, Object> _toWire = <ConfigapiShowShowPassword, Object>{
    ConfigapiShowShowPassword.$0: 0,
    ConfigapiShowShowPassword.$1: 1,
  };

  static const Map<Object, ConfigapiShowShowPassword> _fromWire = <Object, ConfigapiShowShowPassword>{
    0: ConfigapiShowShowPassword.$0,
    1: ConfigapiShowShowPassword.$1,
  };

  @override
  Iterable<Type> get types => const [ConfigapiShowShowPassword];

  @override
  String get wireName => 'ConfigapiShowShowPassword';

  @override
  Object serialize(
    Serializers serializers,
    ConfigapiShowShowPassword object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ConfigapiShowShowPassword deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiShowResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltMap<String, JsonObject> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiShowResponseApplicationJson_OcsInterfaceBuilder].
  $ConfigapiShowResponseApplicationJson_OcsInterface rebuild(
    void Function($ConfigapiShowResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiShowResponseApplicationJson_OcsInterfaceBuilder].
  $ConfigapiShowResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiShowResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiShowResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ConfigapiShowResponseApplicationJson_Ocs
    implements
        $ConfigapiShowResponseApplicationJson_OcsInterface,
        Built<ConfigapiShowResponseApplicationJson_Ocs, ConfigapiShowResponseApplicationJson_OcsBuilder> {
  /// Creates a new ConfigapiShowResponseApplicationJson_Ocs object using the builder pattern.
  factory ConfigapiShowResponseApplicationJson_Ocs([
    void Function(ConfigapiShowResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ConfigapiShowResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ConfigapiShowResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiShowResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiShowResponseApplicationJson_Ocs.
  static Serializer<ConfigapiShowResponseApplicationJson_Ocs> get serializer =>
      _$configapiShowResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiShowResponseApplicationJson_OcsBuilder b) {
    $ConfigapiShowResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiShowResponseApplicationJson_OcsBuilder b) {
    $ConfigapiShowResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiShowResponseApplicationJsonInterface {
  ConfigapiShowResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiShowResponseApplicationJsonInterfaceBuilder].
  $ConfigapiShowResponseApplicationJsonInterface rebuild(
    void Function($ConfigapiShowResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiShowResponseApplicationJsonInterfaceBuilder].
  $ConfigapiShowResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiShowResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiShowResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ConfigapiShowResponseApplicationJson
    implements
        $ConfigapiShowResponseApplicationJsonInterface,
        Built<ConfigapiShowResponseApplicationJson, ConfigapiShowResponseApplicationJsonBuilder> {
  /// Creates a new ConfigapiShowResponseApplicationJson object using the builder pattern.
  factory ConfigapiShowResponseApplicationJson([void Function(ConfigapiShowResponseApplicationJsonBuilder)? b]) =
      _$ConfigapiShowResponseApplicationJson;

  // coverage:ignore-start
  const ConfigapiShowResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiShowResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiShowResponseApplicationJson.
  static Serializer<ConfigapiShowResponseApplicationJson> get serializer =>
      _$configapiShowResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiShowResponseApplicationJsonBuilder b) {
    $ConfigapiShowResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiShowResponseApplicationJsonBuilder b) {
    $ConfigapiShowResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiModifyRequestApplicationJsonInterface {
  /// New config.
  BuiltMap<String, JsonObject> get configData;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiModifyRequestApplicationJsonInterfaceBuilder].
  $ConfigapiModifyRequestApplicationJsonInterface rebuild(
    void Function($ConfigapiModifyRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiModifyRequestApplicationJsonInterfaceBuilder].
  $ConfigapiModifyRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiModifyRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiModifyRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ConfigapiModifyRequestApplicationJson
    implements
        $ConfigapiModifyRequestApplicationJsonInterface,
        Built<ConfigapiModifyRequestApplicationJson, ConfigapiModifyRequestApplicationJsonBuilder> {
  /// Creates a new ConfigapiModifyRequestApplicationJson object using the builder pattern.
  factory ConfigapiModifyRequestApplicationJson([void Function(ConfigapiModifyRequestApplicationJsonBuilder)? b]) =
      _$ConfigapiModifyRequestApplicationJson;

  // coverage:ignore-start
  const ConfigapiModifyRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiModifyRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiModifyRequestApplicationJson.
  static Serializer<ConfigapiModifyRequestApplicationJson> get serializer =>
      _$configapiModifyRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiModifyRequestApplicationJsonBuilder b) {
    $ConfigapiModifyRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiModifyRequestApplicationJsonBuilder b) {
    $ConfigapiModifyRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiModifyResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiModifyResponseApplicationJson_OcsInterfaceBuilder].
  $ConfigapiModifyResponseApplicationJson_OcsInterface rebuild(
    void Function($ConfigapiModifyResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiModifyResponseApplicationJson_OcsInterfaceBuilder].
  $ConfigapiModifyResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiModifyResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiModifyResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ConfigapiModifyResponseApplicationJson_Ocs
    implements
        $ConfigapiModifyResponseApplicationJson_OcsInterface,
        Built<ConfigapiModifyResponseApplicationJson_Ocs, ConfigapiModifyResponseApplicationJson_OcsBuilder> {
  /// Creates a new ConfigapiModifyResponseApplicationJson_Ocs object using the builder pattern.
  factory ConfigapiModifyResponseApplicationJson_Ocs([
    void Function(ConfigapiModifyResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ConfigapiModifyResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ConfigapiModifyResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiModifyResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiModifyResponseApplicationJson_Ocs.
  static Serializer<ConfigapiModifyResponseApplicationJson_Ocs> get serializer =>
      _$configapiModifyResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiModifyResponseApplicationJson_OcsBuilder b) {
    $ConfigapiModifyResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiModifyResponseApplicationJson_OcsBuilder b) {
    $ConfigapiModifyResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiModifyResponseApplicationJsonInterface {
  ConfigapiModifyResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiModifyResponseApplicationJsonInterfaceBuilder].
  $ConfigapiModifyResponseApplicationJsonInterface rebuild(
    void Function($ConfigapiModifyResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiModifyResponseApplicationJsonInterfaceBuilder].
  $ConfigapiModifyResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiModifyResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiModifyResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ConfigapiModifyResponseApplicationJson
    implements
        $ConfigapiModifyResponseApplicationJsonInterface,
        Built<ConfigapiModifyResponseApplicationJson, ConfigapiModifyResponseApplicationJsonBuilder> {
  /// Creates a new ConfigapiModifyResponseApplicationJson object using the builder pattern.
  factory ConfigapiModifyResponseApplicationJson([void Function(ConfigapiModifyResponseApplicationJsonBuilder)? b]) =
      _$ConfigapiModifyResponseApplicationJson;

  // coverage:ignore-start
  const ConfigapiModifyResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiModifyResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiModifyResponseApplicationJson.
  static Serializer<ConfigapiModifyResponseApplicationJson> get serializer =>
      _$configapiModifyResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiModifyResponseApplicationJsonBuilder b) {
    $ConfigapiModifyResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiModifyResponseApplicationJsonBuilder b) {
    $ConfigapiModifyResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiDeleteResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiDeleteResponseApplicationJson_OcsInterfaceBuilder].
  $ConfigapiDeleteResponseApplicationJson_OcsInterface rebuild(
    void Function($ConfigapiDeleteResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiDeleteResponseApplicationJson_OcsInterfaceBuilder].
  $ConfigapiDeleteResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiDeleteResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiDeleteResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ConfigapiDeleteResponseApplicationJson_Ocs
    implements
        $ConfigapiDeleteResponseApplicationJson_OcsInterface,
        Built<ConfigapiDeleteResponseApplicationJson_Ocs, ConfigapiDeleteResponseApplicationJson_OcsBuilder> {
  /// Creates a new ConfigapiDeleteResponseApplicationJson_Ocs object using the builder pattern.
  factory ConfigapiDeleteResponseApplicationJson_Ocs([
    void Function(ConfigapiDeleteResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ConfigapiDeleteResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ConfigapiDeleteResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiDeleteResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiDeleteResponseApplicationJson_Ocs.
  static Serializer<ConfigapiDeleteResponseApplicationJson_Ocs> get serializer =>
      _$configapiDeleteResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiDeleteResponseApplicationJson_OcsBuilder b) {
    $ConfigapiDeleteResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiDeleteResponseApplicationJson_OcsBuilder b) {
    $ConfigapiDeleteResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ConfigapiDeleteResponseApplicationJsonInterface {
  ConfigapiDeleteResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigapiDeleteResponseApplicationJsonInterfaceBuilder].
  $ConfigapiDeleteResponseApplicationJsonInterface rebuild(
    void Function($ConfigapiDeleteResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ConfigapiDeleteResponseApplicationJsonInterfaceBuilder].
  $ConfigapiDeleteResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigapiDeleteResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigapiDeleteResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ConfigapiDeleteResponseApplicationJson
    implements
        $ConfigapiDeleteResponseApplicationJsonInterface,
        Built<ConfigapiDeleteResponseApplicationJson, ConfigapiDeleteResponseApplicationJsonBuilder> {
  /// Creates a new ConfigapiDeleteResponseApplicationJson object using the builder pattern.
  factory ConfigapiDeleteResponseApplicationJson([void Function(ConfigapiDeleteResponseApplicationJsonBuilder)? b]) =
      _$ConfigapiDeleteResponseApplicationJson;

  // coverage:ignore-start
  const ConfigapiDeleteResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ConfigapiDeleteResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ConfigapiDeleteResponseApplicationJson.
  static Serializer<ConfigapiDeleteResponseApplicationJson> get serializer =>
      _$configapiDeleteResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigapiDeleteResponseApplicationJsonBuilder b) {
    $ConfigapiDeleteResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigapiDeleteResponseApplicationJsonBuilder b) {
    $ConfigapiDeleteResponseApplicationJsonInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(
        const FullType(ConfigapiCreateResponseApplicationJson),
        ConfigapiCreateResponseApplicationJsonBuilder.new,
      )
      ..add(ConfigapiCreateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ConfigapiCreateResponseApplicationJson_Ocs),
        ConfigapiCreateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ConfigapiCreateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(
        const FullType(ConfigapiCreateResponseApplicationJson_Ocs_Data),
        ConfigapiCreateResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(ConfigapiCreateResponseApplicationJson_Ocs_Data.serializer)
      ..add(ConfigapiShowShowPassword.serializer)
      ..addBuilderFactory(
        const FullType(ConfigapiShowResponseApplicationJson),
        ConfigapiShowResponseApplicationJsonBuilder.new,
      )
      ..add(ConfigapiShowResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ConfigapiShowResponseApplicationJson_Ocs),
        ConfigapiShowResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ConfigapiShowResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
        MapBuilder<String, JsonObject>.new,
      )
      ..addBuilderFactory(
        const FullType(ConfigapiModifyRequestApplicationJson),
        ConfigapiModifyRequestApplicationJsonBuilder.new,
      )
      ..add(ConfigapiModifyRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ConfigapiModifyResponseApplicationJson),
        ConfigapiModifyResponseApplicationJsonBuilder.new,
      )
      ..add(ConfigapiModifyResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ConfigapiModifyResponseApplicationJson_Ocs),
        ConfigapiModifyResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ConfigapiModifyResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ConfigapiDeleteResponseApplicationJson),
        ConfigapiDeleteResponseApplicationJsonBuilder.new,
      )
      ..add(ConfigapiDeleteResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ConfigapiDeleteResponseApplicationJson_Ocs),
        ConfigapiDeleteResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ConfigapiDeleteResponseApplicationJson_Ocs.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(_i8.StandardJsonPlugin())
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
