// Use of this source code is governed by a agpl license.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// uppush Version: 1.4.0.
///
/// Use Nextcloud as a push provider for mobile phones' notifications.
///
/// Use of this source code is governed by a agpl license.
@_i2.experimental
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i7;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i6;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i5;

part 'uppush.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  /// Builds a serializer to parse the response of [$check_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CheckResponseApplicationJson, void> $check_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(CheckResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Check if the UnifiedPush provider is present.
  ///
  /// Returns a `DynamiteRequest` backing the [check] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [check] for a method executing this request and parsing the response.
  ///  * [$check_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $check_Request() {
    const _path = '/index.php/apps/uppush';
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Check if the UnifiedPush provider is present.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$check_Request] for the request send by this method.
  ///  * [$check_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CheckResponseApplicationJson, void>> check() async {
    final _request = $check_Request();
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $check_Serializer();
    return _i1.ResponseConverter<CheckResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setKeepalive_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SetKeepaliveResponseApplicationJson, void> $setKeepalive_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(SetKeepaliveResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set keepalive interval.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [setKeepalive] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [keepalive] Keep alive value in seconds.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [setKeepalive] for a method executing this request and parsing the response.
  ///  * [$setKeepalive_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setKeepalive_Request({required int keepalive}) {
    final _parameters = <String, Object?>{};
    final __keepalive = _$jsonSerializers.serialize(keepalive, specifiedType: const FullType(int));
    _parameters['keepalive'] = __keepalive;

    final _path = _i5.UriTemplate('/index.php/apps/uppush/keepalive{?keepalive*}').expand(_parameters);
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Set keepalive interval.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [keepalive] Keep alive value in seconds.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$setKeepalive_Request] for the request send by this method.
  ///  * [$setKeepalive_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SetKeepaliveResponseApplicationJson, void>> setKeepalive({required int keepalive}) async {
    final _request = $setKeepalive_Request(
      keepalive: keepalive,
    );
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setKeepalive_Serializer();
    return _i1.ResponseConverter<SetKeepaliveResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createDevice_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CreateDeviceResponseApplicationJson, void> $createDevice_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(CreateDeviceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Request to create a new deviceId.
  ///
  /// Returns a `DynamiteRequest` backing the [createDevice] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [deviceName] Name of the device.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [createDevice] for a method executing this request and parsing the response.
  ///  * [$createDevice_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createDevice_Request({required String deviceName}) {
    final _parameters = <String, Object?>{};
    final __deviceName = _$jsonSerializers.serialize(deviceName, specifiedType: const FullType(String));
    _parameters['deviceName'] = __deviceName;

    final _path = _i5.UriTemplate('/index.php/apps/uppush/device{?deviceName*}').expand(_parameters);
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Request to create a new deviceId.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [deviceName] Name of the device.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$createDevice_Request] for the request send by this method.
  ///  * [$createDevice_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CreateDeviceResponseApplicationJson, void>> createDevice({
    required String deviceName,
  }) async {
    final _request = $createDevice_Request(
      deviceName: deviceName,
    );
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createDevice_Serializer();
    return _i1.ResponseConverter<CreateDeviceResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$syncDevice_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SyncDeviceResponseApplicationJson, void> $syncDevice_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(SyncDeviceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {401},
      );

  /// Request to get push messages.
  ///
  /// This is a public page since it has to be handle by the non-connected app (NextPush app and not Nextcloud-app).
  ///
  /// Returns a `DynamiteRequest` backing the [syncDevice] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 401: Missing permissions to sync device
  ///
  /// See:
  ///  * [syncDevice] for a method executing this request and parsing the response.
  ///  * [$syncDevice_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $syncDevice_Request({required String deviceId}) {
    final _parameters = <String, Object?>{};
    final __deviceId = _$jsonSerializers.serialize(deviceId, specifiedType: const FullType(String));
    _parameters['deviceId'] = __deviceId;

    final _path = _i5.UriTemplate('/index.php/apps/uppush/device/{deviceId}').expand(_parameters);
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Request to get push messages.
  ///
  /// This is a public page since it has to be handle by the non-connected app (NextPush app and not Nextcloud-app).
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 401: Missing permissions to sync device
  ///
  /// See:
  ///  * [$syncDevice_Request] for the request send by this method.
  ///  * [$syncDevice_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SyncDeviceResponseApplicationJson, void>> syncDevice({required String deviceId}) async {
    final _request = $syncDevice_Request(
      deviceId: deviceId,
    );
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $syncDevice_Serializer();
    return _i1.ResponseConverter<SyncDeviceResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteDevice_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DeleteDeviceResponseApplicationJson, void> $deleteDevice_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(DeleteDeviceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a device.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteDevice] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Device deleted successfully
  ///
  /// See:
  ///  * [deleteDevice] for a method executing this request and parsing the response.
  ///  * [$deleteDevice_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteDevice_Request({required String deviceId}) {
    final _parameters = <String, Object?>{};
    final __deviceId = _$jsonSerializers.serialize(deviceId, specifiedType: const FullType(String));
    _parameters['deviceId'] = __deviceId;

    final _path = _i5.UriTemplate('/index.php/apps/uppush/device/{deviceId}').expand(_parameters);
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete a device.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Device deleted successfully
  ///
  /// See:
  ///  * [$deleteDevice_Request] for the request send by this method.
  ///  * [$deleteDevice_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DeleteDeviceResponseApplicationJson, void>> deleteDevice({
    required String deviceId,
  }) async {
    final _request = $deleteDevice_Request(
      deviceId: deviceId,
    );
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteDevice_Serializer();
    return _i1.ResponseConverter<DeleteDeviceResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createApp_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CreateAppResponseApplicationJson, void> $createApp_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(CreateAppResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create an authorization token for a new 3rd party service.
  ///
  /// Returns a `DynamiteRequest` backing the [createApp] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [deviceId] ID of the device.
  ///   * [appName] Name of the app.
  ///
  /// Status codes:
  ///   * 200: App created successfully
  ///
  /// See:
  ///  * [createApp] for a method executing this request and parsing the response.
  ///  * [$createApp_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createApp_Request({
    required String deviceId,
    required String appName,
  }) {
    final _parameters = <String, Object?>{};
    final __deviceId = _$jsonSerializers.serialize(deviceId, specifiedType: const FullType(String));
    _parameters['deviceId'] = __deviceId;

    final __appName = _$jsonSerializers.serialize(appName, specifiedType: const FullType(String));
    _parameters['appName'] = __appName;

    final _path = _i5.UriTemplate('/index.php/apps/uppush/app{?deviceId*,appName*}').expand(_parameters);
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Create an authorization token for a new 3rd party service.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [deviceId] ID of the device.
  ///   * [appName] Name of the app.
  ///
  /// Status codes:
  ///   * 200: App created successfully
  ///
  /// See:
  ///  * [$createApp_Request] for the request send by this method.
  ///  * [$createApp_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CreateAppResponseApplicationJson, void>> createApp({
    required String deviceId,
    required String appName,
  }) async {
    final _request = $createApp_Request(
      deviceId: deviceId,
      appName: appName,
    );
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createApp_Serializer();
    return _i1.ResponseConverter<CreateAppResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteApp_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DeleteAppResponseApplicationJson, void> $deleteApp_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(DeleteAppResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete an authorization token.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteApp] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: App deleted successfully
  ///
  /// See:
  ///  * [deleteApp] for a method executing this request and parsing the response.
  ///  * [$deleteApp_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteApp_Request({required String token}) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _parameters['token'] = __token;

    final _path = _i5.UriTemplate('/index.php/apps/uppush/app/{token}').expand(_parameters);
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete an authorization token.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: App deleted successfully
  ///
  /// See:
  ///  * [$deleteApp_Request] for the request send by this method.
  ///  * [$deleteApp_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DeleteAppResponseApplicationJson, void>> deleteApp({required String token}) async {
    final _request = $deleteApp_Request(
      token: token,
    );
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteApp_Serializer();
    return _i1.ResponseConverter<DeleteAppResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$unifiedpushDiscovery_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UnifiedpushDiscoveryResponseApplicationJson, void> $unifiedpushDiscovery_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UnifiedpushDiscoveryResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Unifiedpush discovery Following specifications.
  ///
  /// Returns a `DynamiteRequest` backing the [unifiedpushDiscovery] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [unifiedpushDiscovery] for a method executing this request and parsing the response.
  ///  * [$unifiedpushDiscovery_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $unifiedpushDiscovery_Request({required String token}) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _parameters['token'] = __token;

    final _path = _i5.UriTemplate('/index.php/apps/uppush/push/{token}').expand(_parameters);
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Unifiedpush discovery Following specifications.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$unifiedpushDiscovery_Request] for the request send by this method.
  ///  * [$unifiedpushDiscovery_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UnifiedpushDiscoveryResponseApplicationJson, void>> unifiedpushDiscovery({
    required String token,
  }) async {
    final _request = $unifiedpushDiscovery_Request(
      token: token,
    );
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $unifiedpushDiscovery_Serializer();
    return _i1.ResponseConverter<UnifiedpushDiscoveryResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$push_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PushResponseApplicationJson, void> $push_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(PushResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {201},
      );

  /// Receive notifications from 3rd parties.
  ///
  /// Returns a `DynamiteRequest` backing the [push] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 201: Notification pushed successfully
  ///
  /// See:
  ///  * [push] for a method executing this request and parsing the response.
  ///  * [$push_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $push_Request({required String token}) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _parameters['token'] = __token;

    final _path = _i5.UriTemplate('/index.php/apps/uppush/push/{token}').expand(_parameters);
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Receive notifications from 3rd parties.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 201: Notification pushed successfully
  ///
  /// See:
  ///  * [$push_Request] for the request send by this method.
  ///  * [$push_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PushResponseApplicationJson, void>> push({required String token}) async {
    final _request = $push_Request(
      token: token,
    );
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $push_Serializer();
    return _i1.ResponseConverter<PushResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$gatewayMatrixDiscovery_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<GatewayMatrixDiscoveryResponseApplicationJson, void> $gatewayMatrixDiscovery_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(GatewayMatrixDiscoveryResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Matrix Gateway discovery.
  ///
  /// Returns a `DynamiteRequest` backing the [gatewayMatrixDiscovery] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [gatewayMatrixDiscovery] for a method executing this request and parsing the response.
  ///  * [$gatewayMatrixDiscovery_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $gatewayMatrixDiscovery_Request() {
    const _path = '/index.php/apps/uppush/gateway/matrix';
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Matrix Gateway discovery.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$gatewayMatrixDiscovery_Request] for the request send by this method.
  ///  * [$gatewayMatrixDiscovery_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<GatewayMatrixDiscoveryResponseApplicationJson, void>> gatewayMatrixDiscovery() async {
    final _request = $gatewayMatrixDiscovery_Request();
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $gatewayMatrixDiscovery_Serializer();
    return _i1.ResponseConverter<GatewayMatrixDiscoveryResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$gatewayMatrix_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<GatewayMatrixResponseApplicationJson, void> $gatewayMatrix_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(GatewayMatrixResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Matrix Gateway.
  ///
  /// Returns a `DynamiteRequest` backing the [gatewayMatrix] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [gatewayMatrix] for a method executing this request and parsing the response.
  ///  * [$gatewayMatrix_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $gatewayMatrix_Request() {
    const _path = '/index.php/apps/uppush/gateway/matrix';
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Matrix Gateway.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$gatewayMatrix_Request] for the request send by this method.
  ///  * [$gatewayMatrix_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<GatewayMatrixResponseApplicationJson, void>> gatewayMatrix() async {
    final _request = $gatewayMatrix_Request();
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $gatewayMatrix_Serializer();
    return _i1.ResponseConverter<GatewayMatrixResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $CheckResponseApplicationJsonInterface {
  bool get success;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CheckResponseApplicationJsonInterfaceBuilder].
  $CheckResponseApplicationJsonInterface rebuild(void Function($CheckResponseApplicationJsonInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CheckResponseApplicationJsonInterfaceBuilder].
  $CheckResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CheckResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CheckResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CheckResponseApplicationJson
    implements
        $CheckResponseApplicationJsonInterface,
        Built<CheckResponseApplicationJson, CheckResponseApplicationJsonBuilder> {
  /// Creates a new CheckResponseApplicationJson object using the builder pattern.
  factory CheckResponseApplicationJson([void Function(CheckResponseApplicationJsonBuilder)? b]) =
      _$CheckResponseApplicationJson;

  // coverage:ignore-start
  const CheckResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CheckResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CheckResponseApplicationJson.
  static Serializer<CheckResponseApplicationJson> get serializer => _$checkResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CheckResponseApplicationJsonBuilder b) {
    $CheckResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CheckResponseApplicationJsonBuilder b) {
    $CheckResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SetKeepaliveResponseApplicationJsonInterface {
  bool get success;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SetKeepaliveResponseApplicationJsonInterfaceBuilder].
  $SetKeepaliveResponseApplicationJsonInterface rebuild(
    void Function($SetKeepaliveResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SetKeepaliveResponseApplicationJsonInterfaceBuilder].
  $SetKeepaliveResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SetKeepaliveResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SetKeepaliveResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class SetKeepaliveResponseApplicationJson
    implements
        $SetKeepaliveResponseApplicationJsonInterface,
        Built<SetKeepaliveResponseApplicationJson, SetKeepaliveResponseApplicationJsonBuilder> {
  /// Creates a new SetKeepaliveResponseApplicationJson object using the builder pattern.
  factory SetKeepaliveResponseApplicationJson([void Function(SetKeepaliveResponseApplicationJsonBuilder)? b]) =
      _$SetKeepaliveResponseApplicationJson;

  // coverage:ignore-start
  const SetKeepaliveResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SetKeepaliveResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SetKeepaliveResponseApplicationJson.
  static Serializer<SetKeepaliveResponseApplicationJson> get serializer =>
      _$setKeepaliveResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SetKeepaliveResponseApplicationJsonBuilder b) {
    $SetKeepaliveResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SetKeepaliveResponseApplicationJsonBuilder b) {
    $SetKeepaliveResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CreateDeviceResponseApplicationJsonInterface {
  bool get success;
  String get deviceId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CreateDeviceResponseApplicationJsonInterfaceBuilder].
  $CreateDeviceResponseApplicationJsonInterface rebuild(
    void Function($CreateDeviceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CreateDeviceResponseApplicationJsonInterfaceBuilder].
  $CreateDeviceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CreateDeviceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CreateDeviceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CreateDeviceResponseApplicationJson
    implements
        $CreateDeviceResponseApplicationJsonInterface,
        Built<CreateDeviceResponseApplicationJson, CreateDeviceResponseApplicationJsonBuilder> {
  /// Creates a new CreateDeviceResponseApplicationJson object using the builder pattern.
  factory CreateDeviceResponseApplicationJson([void Function(CreateDeviceResponseApplicationJsonBuilder)? b]) =
      _$CreateDeviceResponseApplicationJson;

  // coverage:ignore-start
  const CreateDeviceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CreateDeviceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CreateDeviceResponseApplicationJson.
  static Serializer<CreateDeviceResponseApplicationJson> get serializer =>
      _$createDeviceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CreateDeviceResponseApplicationJsonBuilder b) {
    $CreateDeviceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CreateDeviceResponseApplicationJsonBuilder b) {
    $CreateDeviceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SyncDeviceResponseApplicationJsonInterface {
  bool get success;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SyncDeviceResponseApplicationJsonInterfaceBuilder].
  $SyncDeviceResponseApplicationJsonInterface rebuild(
    void Function($SyncDeviceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SyncDeviceResponseApplicationJsonInterfaceBuilder].
  $SyncDeviceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SyncDeviceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SyncDeviceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class SyncDeviceResponseApplicationJson
    implements
        $SyncDeviceResponseApplicationJsonInterface,
        Built<SyncDeviceResponseApplicationJson, SyncDeviceResponseApplicationJsonBuilder> {
  /// Creates a new SyncDeviceResponseApplicationJson object using the builder pattern.
  factory SyncDeviceResponseApplicationJson([void Function(SyncDeviceResponseApplicationJsonBuilder)? b]) =
      _$SyncDeviceResponseApplicationJson;

  // coverage:ignore-start
  const SyncDeviceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SyncDeviceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SyncDeviceResponseApplicationJson.
  static Serializer<SyncDeviceResponseApplicationJson> get serializer => _$syncDeviceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SyncDeviceResponseApplicationJsonBuilder b) {
    $SyncDeviceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SyncDeviceResponseApplicationJsonBuilder b) {
    $SyncDeviceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DeleteDeviceResponseApplicationJsonInterface {
  bool get success;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DeleteDeviceResponseApplicationJsonInterfaceBuilder].
  $DeleteDeviceResponseApplicationJsonInterface rebuild(
    void Function($DeleteDeviceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DeleteDeviceResponseApplicationJsonInterfaceBuilder].
  $DeleteDeviceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DeleteDeviceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DeleteDeviceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DeleteDeviceResponseApplicationJson
    implements
        $DeleteDeviceResponseApplicationJsonInterface,
        Built<DeleteDeviceResponseApplicationJson, DeleteDeviceResponseApplicationJsonBuilder> {
  /// Creates a new DeleteDeviceResponseApplicationJson object using the builder pattern.
  factory DeleteDeviceResponseApplicationJson([void Function(DeleteDeviceResponseApplicationJsonBuilder)? b]) =
      _$DeleteDeviceResponseApplicationJson;

  // coverage:ignore-start
  const DeleteDeviceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DeleteDeviceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DeleteDeviceResponseApplicationJson.
  static Serializer<DeleteDeviceResponseApplicationJson> get serializer =>
      _$deleteDeviceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DeleteDeviceResponseApplicationJsonBuilder b) {
    $DeleteDeviceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DeleteDeviceResponseApplicationJsonBuilder b) {
    $DeleteDeviceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CreateAppResponseApplicationJsonInterface {
  bool get success;
  String get token;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CreateAppResponseApplicationJsonInterfaceBuilder].
  $CreateAppResponseApplicationJsonInterface rebuild(
    void Function($CreateAppResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CreateAppResponseApplicationJsonInterfaceBuilder].
  $CreateAppResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CreateAppResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CreateAppResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CreateAppResponseApplicationJson
    implements
        $CreateAppResponseApplicationJsonInterface,
        Built<CreateAppResponseApplicationJson, CreateAppResponseApplicationJsonBuilder> {
  /// Creates a new CreateAppResponseApplicationJson object using the builder pattern.
  factory CreateAppResponseApplicationJson([void Function(CreateAppResponseApplicationJsonBuilder)? b]) =
      _$CreateAppResponseApplicationJson;

  // coverage:ignore-start
  const CreateAppResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CreateAppResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CreateAppResponseApplicationJson.
  static Serializer<CreateAppResponseApplicationJson> get serializer => _$createAppResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CreateAppResponseApplicationJsonBuilder b) {
    $CreateAppResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CreateAppResponseApplicationJsonBuilder b) {
    $CreateAppResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DeleteAppResponseApplicationJsonInterface {
  bool get success;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DeleteAppResponseApplicationJsonInterfaceBuilder].
  $DeleteAppResponseApplicationJsonInterface rebuild(
    void Function($DeleteAppResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DeleteAppResponseApplicationJsonInterfaceBuilder].
  $DeleteAppResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DeleteAppResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DeleteAppResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DeleteAppResponseApplicationJson
    implements
        $DeleteAppResponseApplicationJsonInterface,
        Built<DeleteAppResponseApplicationJson, DeleteAppResponseApplicationJsonBuilder> {
  /// Creates a new DeleteAppResponseApplicationJson object using the builder pattern.
  factory DeleteAppResponseApplicationJson([void Function(DeleteAppResponseApplicationJsonBuilder)? b]) =
      _$DeleteAppResponseApplicationJson;

  // coverage:ignore-start
  const DeleteAppResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DeleteAppResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DeleteAppResponseApplicationJson.
  static Serializer<DeleteAppResponseApplicationJson> get serializer => _$deleteAppResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DeleteAppResponseApplicationJsonBuilder b) {
    $DeleteAppResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DeleteAppResponseApplicationJsonBuilder b) {
    $DeleteAppResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterface {
  int get version;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder].
  $UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterface rebuild(
    void Function($UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder].
  $UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder b) {}
}

abstract class UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush
    implements
        $UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterface,
        Built<UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush,
            UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushBuilder> {
  /// Creates a new UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush object using the builder pattern.
  factory UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush([
    void Function(UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushBuilder)? b,
  ]) = _$UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush;

  // coverage:ignore-start
  const UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush.
  static Serializer<UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush> get serializer =>
      _$unifiedpushDiscoveryResponseApplicationJsonUnifiedpushSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushBuilder b) {
    $UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushBuilder b) {
    $UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UnifiedpushDiscoveryResponseApplicationJsonInterface {
  UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush get unifiedpush;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UnifiedpushDiscoveryResponseApplicationJsonInterfaceBuilder].
  $UnifiedpushDiscoveryResponseApplicationJsonInterface rebuild(
    void Function($UnifiedpushDiscoveryResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UnifiedpushDiscoveryResponseApplicationJsonInterfaceBuilder].
  $UnifiedpushDiscoveryResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UnifiedpushDiscoveryResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UnifiedpushDiscoveryResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UnifiedpushDiscoveryResponseApplicationJson
    implements
        $UnifiedpushDiscoveryResponseApplicationJsonInterface,
        Built<UnifiedpushDiscoveryResponseApplicationJson, UnifiedpushDiscoveryResponseApplicationJsonBuilder> {
  /// Creates a new UnifiedpushDiscoveryResponseApplicationJson object using the builder pattern.
  factory UnifiedpushDiscoveryResponseApplicationJson([
    void Function(UnifiedpushDiscoveryResponseApplicationJsonBuilder)? b,
  ]) = _$UnifiedpushDiscoveryResponseApplicationJson;

  // coverage:ignore-start
  const UnifiedpushDiscoveryResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UnifiedpushDiscoveryResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UnifiedpushDiscoveryResponseApplicationJson.
  static Serializer<UnifiedpushDiscoveryResponseApplicationJson> get serializer =>
      _$unifiedpushDiscoveryResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UnifiedpushDiscoveryResponseApplicationJsonBuilder b) {
    $UnifiedpushDiscoveryResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UnifiedpushDiscoveryResponseApplicationJsonBuilder b) {
    $UnifiedpushDiscoveryResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PushResponseApplicationJsonInterface {
  bool get success;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PushResponseApplicationJsonInterfaceBuilder].
  $PushResponseApplicationJsonInterface rebuild(void Function($PushResponseApplicationJsonInterfaceBuilder) updates);

  /// Converts the instance to a builder [$PushResponseApplicationJsonInterfaceBuilder].
  $PushResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PushResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PushResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class PushResponseApplicationJson
    implements
        $PushResponseApplicationJsonInterface,
        Built<PushResponseApplicationJson, PushResponseApplicationJsonBuilder> {
  /// Creates a new PushResponseApplicationJson object using the builder pattern.
  factory PushResponseApplicationJson([void Function(PushResponseApplicationJsonBuilder)? b]) =
      _$PushResponseApplicationJson;

  // coverage:ignore-start
  const PushResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PushResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PushResponseApplicationJson.
  static Serializer<PushResponseApplicationJson> get serializer => _$pushResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PushResponseApplicationJsonBuilder b) {
    $PushResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PushResponseApplicationJsonBuilder b) {
    $PushResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterface {
  String get gateway;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder].
  $GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterface rebuild(
    void Function($GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder].
  $GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterfaceBuilder b) {}
}

abstract class GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush
    implements
        $GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterface,
        Built<GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush,
            GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushBuilder> {
  /// Creates a new GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush object using the builder pattern.
  factory GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush([
    void Function(GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushBuilder)? b,
  ]) = _$GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush;

  // coverage:ignore-start
  const GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush.
  static Serializer<GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush> get serializer =>
      _$gatewayMatrixDiscoveryResponseApplicationJsonUnifiedpushSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushBuilder b) {
    $GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushBuilder b) {
    $GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GatewayMatrixDiscoveryResponseApplicationJsonInterface {
  GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush get unifiedpush;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GatewayMatrixDiscoveryResponseApplicationJsonInterfaceBuilder].
  $GatewayMatrixDiscoveryResponseApplicationJsonInterface rebuild(
    void Function($GatewayMatrixDiscoveryResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GatewayMatrixDiscoveryResponseApplicationJsonInterfaceBuilder].
  $GatewayMatrixDiscoveryResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GatewayMatrixDiscoveryResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GatewayMatrixDiscoveryResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class GatewayMatrixDiscoveryResponseApplicationJson
    implements
        $GatewayMatrixDiscoveryResponseApplicationJsonInterface,
        Built<GatewayMatrixDiscoveryResponseApplicationJson, GatewayMatrixDiscoveryResponseApplicationJsonBuilder> {
  /// Creates a new GatewayMatrixDiscoveryResponseApplicationJson object using the builder pattern.
  factory GatewayMatrixDiscoveryResponseApplicationJson([
    void Function(GatewayMatrixDiscoveryResponseApplicationJsonBuilder)? b,
  ]) = _$GatewayMatrixDiscoveryResponseApplicationJson;

  // coverage:ignore-start
  const GatewayMatrixDiscoveryResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GatewayMatrixDiscoveryResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GatewayMatrixDiscoveryResponseApplicationJson.
  static Serializer<GatewayMatrixDiscoveryResponseApplicationJson> get serializer =>
      _$gatewayMatrixDiscoveryResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GatewayMatrixDiscoveryResponseApplicationJsonBuilder b) {
    $GatewayMatrixDiscoveryResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GatewayMatrixDiscoveryResponseApplicationJsonBuilder b) {
    $GatewayMatrixDiscoveryResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GatewayMatrixResponseApplicationJsonInterface {
  BuiltList<String> get rejected;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GatewayMatrixResponseApplicationJsonInterfaceBuilder].
  $GatewayMatrixResponseApplicationJsonInterface rebuild(
    void Function($GatewayMatrixResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GatewayMatrixResponseApplicationJsonInterfaceBuilder].
  $GatewayMatrixResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GatewayMatrixResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GatewayMatrixResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class GatewayMatrixResponseApplicationJson
    implements
        $GatewayMatrixResponseApplicationJsonInterface,
        Built<GatewayMatrixResponseApplicationJson, GatewayMatrixResponseApplicationJsonBuilder> {
  /// Creates a new GatewayMatrixResponseApplicationJson object using the builder pattern.
  factory GatewayMatrixResponseApplicationJson([void Function(GatewayMatrixResponseApplicationJsonBuilder)? b]) =
      _$GatewayMatrixResponseApplicationJson;

  // coverage:ignore-start
  const GatewayMatrixResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GatewayMatrixResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GatewayMatrixResponseApplicationJson.
  static Serializer<GatewayMatrixResponseApplicationJson> get serializer =>
      _$gatewayMatrixResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GatewayMatrixResponseApplicationJsonBuilder b) {
    $GatewayMatrixResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GatewayMatrixResponseApplicationJsonBuilder b) {
    $GatewayMatrixResponseApplicationJsonInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(const FullType(CheckResponseApplicationJson), CheckResponseApplicationJsonBuilder.new)
      ..add(CheckResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(SetKeepaliveResponseApplicationJson),
        SetKeepaliveResponseApplicationJsonBuilder.new,
      )
      ..add(SetKeepaliveResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(CreateDeviceResponseApplicationJson),
        CreateDeviceResponseApplicationJsonBuilder.new,
      )
      ..add(CreateDeviceResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(SyncDeviceResponseApplicationJson),
        SyncDeviceResponseApplicationJsonBuilder.new,
      )
      ..add(SyncDeviceResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DeleteDeviceResponseApplicationJson),
        DeleteDeviceResponseApplicationJsonBuilder.new,
      )
      ..add(DeleteDeviceResponseApplicationJson.serializer)
      ..addBuilderFactory(const FullType(CreateAppResponseApplicationJson), CreateAppResponseApplicationJsonBuilder.new)
      ..add(CreateAppResponseApplicationJson.serializer)
      ..addBuilderFactory(const FullType(DeleteAppResponseApplicationJson), DeleteAppResponseApplicationJsonBuilder.new)
      ..add(DeleteAppResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UnifiedpushDiscoveryResponseApplicationJson),
        UnifiedpushDiscoveryResponseApplicationJsonBuilder.new,
      )
      ..add(UnifiedpushDiscoveryResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush),
        UnifiedpushDiscoveryResponseApplicationJson_UnifiedpushBuilder.new,
      )
      ..add(UnifiedpushDiscoveryResponseApplicationJson_Unifiedpush.serializer)
      ..addBuilderFactory(const FullType(PushResponseApplicationJson), PushResponseApplicationJsonBuilder.new)
      ..add(PushResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(GatewayMatrixDiscoveryResponseApplicationJson),
        GatewayMatrixDiscoveryResponseApplicationJsonBuilder.new,
      )
      ..add(GatewayMatrixDiscoveryResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush),
        GatewayMatrixDiscoveryResponseApplicationJson_UnifiedpushBuilder.new,
      )
      ..add(GatewayMatrixDiscoveryResponseApplicationJson_Unifiedpush.serializer)
      ..addBuilderFactory(
        const FullType(GatewayMatrixResponseApplicationJson),
        GatewayMatrixResponseApplicationJsonBuilder.new,
      )
      ..add(GatewayMatrixResponseApplicationJson.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(String)]), ListBuilder<String>.new))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i6.DynamiteDoubleSerializer())
      ..addPlugin(_i7.StandardJsonPlugin())
      ..addPlugin(const _i6.HeaderPlugin())
      ..addPlugin(const _i6.ContentStringPlugin()))
    .build();
// coverage:ignore-end
