// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// theming Version: 0.0.1.
///
/// Adjust the Nextcloud theme.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:typed_data';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i5;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i6;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i4;

part 'theming.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $IconClient icon = $IconClient(this);

  /// Class ThemingController.
  /// handle ajax requests to update the theme.
  late final $ThemingClient theming = $ThemingClient(this);

  late final $UserThemeClient userTheme = $UserThemeClient(this);
}

class $IconClient {
  /// Creates a new `DynamiteClient` for icon requests.
  $IconClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getFavicon_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getFavicon_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Return a 32x32 favicon as png.
  ///
  /// Returns a `DynamiteRequest` backing the [getFavicon] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app. Defaults to `"core"`.
  ///
  /// Status codes:
  ///   * 200: Favicon returned
  ///   * 404: Favicon not found
  ///   * 500
  ///
  /// See:
  ///  * [getFavicon] for a method executing this request and parsing the response.
  ///  * [$getFavicon_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getFavicon_Request({String? app}) {
    final _parameters = <String, Object?>{};
    var __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    __app ??= 'core';
    _parameters['app'] = __app;

    final _path = _i4.UriTemplate('/index.php/apps/theming/favicon/{app}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'image/x-icon';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Return a 32x32 favicon as png.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app. Defaults to `"core"`.
  ///
  /// Status codes:
  ///   * 200: Favicon returned
  ///   * 404: Favicon not found
  ///   * 500
  ///
  /// See:
  ///  * [$getFavicon_Request] for the request send by this method.
  ///  * [$getFavicon_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getFavicon({String? app}) async {
    final _request = $getFavicon_Request(
      app: app,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getFavicon_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getTouchIcon_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getTouchIcon_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Return a 512x512 icon for touch devices.
  ///
  /// Returns a `DynamiteRequest` backing the [getTouchIcon] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app. Defaults to `"core"`.
  ///
  /// Status codes:
  ///   * 200: Touch icon returned
  ///   * 404: Touch icon not found
  ///   * 500
  ///
  /// See:
  ///  * [getTouchIcon] for a method executing this request and parsing the response.
  ///  * [$getTouchIcon_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getTouchIcon_Request({String? app}) {
    final _parameters = <String, Object?>{};
    var __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    __app ??= 'core';
    _parameters['app'] = __app;

    final _path = _i4.UriTemplate('/index.php/apps/theming/icon/{app}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'image/png';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Return a 512x512 icon for touch devices.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app. Defaults to `"core"`.
  ///
  /// Status codes:
  ///   * 200: Touch icon returned
  ///   * 404: Touch icon not found
  ///   * 500
  ///
  /// See:
  ///  * [$getTouchIcon_Request] for the request send by this method.
  ///  * [$getTouchIcon_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getTouchIcon({String? app}) async {
    final _request = $getTouchIcon_Request(
      app: app,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getTouchIcon_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getThemedIcon_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getThemedIcon_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a themed icon.
  ///
  /// Returns a `DynamiteRequest` backing the [getThemedIcon] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [image] image file name (svg required).
  ///
  /// Status codes:
  ///   * 200: Themed icon returned
  ///   * 404: Themed icon not found
  ///   * 500
  ///
  /// See:
  ///  * [getThemedIcon] for a method executing this request and parsing the response.
  ///  * [$getThemedIcon_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getThemedIcon_Request({
    required String app,
    required String image,
  }) {
    final _parameters = <String, Object?>{};
    final __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    _parameters['app'] = __app;

    final __image = _$jsonSerializers.serialize(image, specifiedType: const FullType(String));
    _i6.checkString(
      __image,
      'image',
      pattern: RegExp(r'^.+$'),
    );
    _parameters['image'] = __image;

    final _path = _i4.UriTemplate('/index.php/apps/theming/img/{app}/{image}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'image/svg+xml';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a themed icon.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [image] image file name (svg required).
  ///
  /// Status codes:
  ///   * 200: Themed icon returned
  ///   * 404: Themed icon not found
  ///   * 500
  ///
  /// See:
  ///  * [$getThemedIcon_Request] for the request send by this method.
  ///  * [$getThemedIcon_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getThemedIcon({
    required String app,
    required String image,
  }) async {
    final _request = $getThemedIcon_Request(
      app: app,
      image: image,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getThemedIcon_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }
}

/// Class ThemingController.
/// handle ajax requests to update the theme.
class $ThemingClient {
  /// Creates a new `DynamiteClient` for theming requests.
  $ThemingClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getThemeStylesheet_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<String, void> $getThemeStylesheet_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(String),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the CSS stylesheet for a theme.
  ///
  /// Returns a `DynamiteRequest` backing the [getThemeStylesheet] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [themeId] ID of the theme.
  ///   * [plain] Let the browser decide the CSS priority. Defaults to `0`.
  ///   * [withCustomCss] Include custom CSS. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Stylesheet returned
  ///   * 404: Theme not found
  ///
  /// See:
  ///  * [getThemeStylesheet] for a method executing this request and parsing the response.
  ///  * [$getThemeStylesheet_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getThemeStylesheet_Request({
    required String themeId,
    ThemingGetThemeStylesheetPlain? plain,
    ThemingGetThemeStylesheetWithCustomCss? withCustomCss,
  }) {
    final _parameters = <String, Object?>{};
    final __themeId = _$jsonSerializers.serialize(themeId, specifiedType: const FullType(String));
    _parameters['themeId'] = __themeId;

    var __plain = _$jsonSerializers.serialize(plain, specifiedType: const FullType(ThemingGetThemeStylesheetPlain));
    __plain ??= 0;
    _parameters['plain'] = __plain;

    var __withCustomCss = _$jsonSerializers.serialize(
      withCustomCss,
      specifiedType: const FullType(ThemingGetThemeStylesheetWithCustomCss),
    );
    __withCustomCss ??= 0;
    _parameters['withCustomCss'] = __withCustomCss;

    final _path =
        _i4.UriTemplate('/index.php/apps/theming/theme/{themeId}.css{?plain*,withCustomCss*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'text/css';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get the CSS stylesheet for a theme.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [themeId] ID of the theme.
  ///   * [plain] Let the browser decide the CSS priority. Defaults to `0`.
  ///   * [withCustomCss] Include custom CSS. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Stylesheet returned
  ///   * 404: Theme not found
  ///
  /// See:
  ///  * [$getThemeStylesheet_Request] for the request send by this method.
  ///  * [$getThemeStylesheet_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<String, void>> getThemeStylesheet({
    required String themeId,
    ThemingGetThemeStylesheetPlain? plain,
    ThemingGetThemeStylesheetWithCustomCss? withCustomCss,
  }) async {
    final _request = $getThemeStylesheet_Request(
      themeId: themeId,
      plain: plain,
      withCustomCss: withCustomCss,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getThemeStylesheet_Serializer();
    return _i1.ResponseConverter<String, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getImage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getImage_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get an image.
  ///
  /// Returns a `DynamiteRequest` backing the [getImage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [key] Key of the image.
  ///   * [useSvg] Return image as SVG. Defaults to `1`.
  ///
  /// Status codes:
  ///   * 200: Image returned
  ///   * 404: Image not found
  ///   * 500
  ///
  /// See:
  ///  * [getImage] for a method executing this request and parsing the response.
  ///  * [$getImage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getImage_Request({
    required String key,
    ThemingGetImageUseSvg? useSvg,
  }) {
    final _parameters = <String, Object?>{};
    final __key = _$jsonSerializers.serialize(key, specifiedType: const FullType(String));
    _parameters['key'] = __key;

    var __useSvg = _$jsonSerializers.serialize(useSvg, specifiedType: const FullType(ThemingGetImageUseSvg));
    __useSvg ??= 1;
    _parameters['useSvg'] = __useSvg;

    final _path = _i4.UriTemplate('/index.php/apps/theming/image/{key}{?useSvg*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get an image.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [key] Key of the image.
  ///   * [useSvg] Return image as SVG. Defaults to `1`.
  ///
  /// Status codes:
  ///   * 200: Image returned
  ///   * 404: Image not found
  ///   * 500
  ///
  /// See:
  ///  * [$getImage_Request] for the request send by this method.
  ///  * [$getImage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getImage({
    required String key,
    ThemingGetImageUseSvg? useSvg,
  }) async {
    final _request = $getImage_Request(
      key: key,
      useSvg: useSvg,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getImage_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getManifest_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ThemingGetManifestResponseApplicationJson, void> $getManifest_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ThemingGetManifestResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the manifest for an app.
  ///
  /// Returns a `DynamiteRequest` backing the [getManifest] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app. Defaults to `"core"`.
  ///
  /// Status codes:
  ///   * 200: Manifest returned
  ///   * 404: App not found
  ///
  /// See:
  ///  * [getManifest] for a method executing this request and parsing the response.
  ///  * [$getManifest_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getManifest_Request({String? app}) {
    final _parameters = <String, Object?>{};
    var __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    __app ??= 'core';
    _parameters['app'] = __app;

    final _path = _i4.UriTemplate('/index.php/apps/theming/manifest/{app}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get the manifest for an app.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app. Defaults to `"core"`.
  ///
  /// Status codes:
  ///   * 200: Manifest returned
  ///   * 404: App not found
  ///
  /// See:
  ///  * [$getManifest_Request] for the request send by this method.
  ///  * [$getManifest_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ThemingGetManifestResponseApplicationJson, void>> getManifest({String? app}) async {
    final _request = $getManifest_Request(
      app: app,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getManifest_Serializer();
    return _i1.ResponseConverter<ThemingGetManifestResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $UserThemeClient {
  /// Creates a new `DynamiteClient` for user_theme requests.
  $UserThemeClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getBackground_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getBackground_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the background image.
  ///
  /// Returns a `DynamiteRequest` backing the [getBackground] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Background image returned
  ///   * 404: Background image not found
  ///
  /// See:
  ///  * [getBackground] for a method executing this request and parsing the response.
  ///  * [$getBackground_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getBackground_Request() {
    const _path = '/index.php/apps/theming/background';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get the background image.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Background image returned
  ///   * 404: Background image not found
  ///
  /// See:
  ///  * [$getBackground_Request] for the request send by this method.
  ///  * [$getBackground_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getBackground() async {
    final _request = $getBackground_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getBackground_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$enableTheme_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UserThemeEnableThemeResponseApplicationJson, void> $enableTheme_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UserThemeEnableThemeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Enable theme.
  ///
  /// Returns a `DynamiteRequest` backing the [enableTheme] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [themeId] the theme ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Theme enabled successfully
  ///   * 400: Enabling theme is not possible
  ///   * 500
  ///
  /// See:
  ///  * [enableTheme] for a method executing this request and parsing the response.
  ///  * [$enableTheme_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $enableTheme_Request({
    required String themeId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __themeId = _$jsonSerializers.serialize(themeId, specifiedType: const FullType(String));
    _parameters['themeId'] = __themeId;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/theming/api/v1/theme/{themeId}/enable').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Enable theme.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [themeId] the theme ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Theme enabled successfully
  ///   * 400: Enabling theme is not possible
  ///   * 500
  ///
  /// See:
  ///  * [$enableTheme_Request] for the request send by this method.
  ///  * [$enableTheme_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UserThemeEnableThemeResponseApplicationJson, void>> enableTheme({
    required String themeId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $enableTheme_Request(
      themeId: themeId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $enableTheme_Serializer();
    return _i1.ResponseConverter<UserThemeEnableThemeResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$disableTheme_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UserThemeDisableThemeResponseApplicationJson, void> $disableTheme_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UserThemeDisableThemeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Disable theme.
  ///
  /// Returns a `DynamiteRequest` backing the [disableTheme] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [themeId] the theme ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Theme disabled successfully
  ///   * 400: Disabling theme is not possible
  ///   * 500
  ///
  /// See:
  ///  * [disableTheme] for a method executing this request and parsing the response.
  ///  * [$disableTheme_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $disableTheme_Request({
    required String themeId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __themeId = _$jsonSerializers.serialize(themeId, specifiedType: const FullType(String));
    _parameters['themeId'] = __themeId;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/theming/api/v1/theme/{themeId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Disable theme.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [themeId] the theme ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Theme disabled successfully
  ///   * 400: Disabling theme is not possible
  ///   * 500
  ///
  /// See:
  ///  * [$disableTheme_Request] for the request send by this method.
  ///  * [$disableTheme_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UserThemeDisableThemeResponseApplicationJson, void>> disableTheme({
    required String themeId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $disableTheme_Request(
      themeId: themeId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $disableTheme_Serializer();
    return _i1.ResponseConverter<UserThemeDisableThemeResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class ThemingGetThemeStylesheetPlain extends EnumClass {
  const ThemingGetThemeStylesheetPlain._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ThemingGetThemeStylesheetPlain $0 = _$themingGetThemeStylesheetPlain$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ThemingGetThemeStylesheetPlain $1 = _$themingGetThemeStylesheetPlain$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ThemingGetThemeStylesheetPlain> get values => _$themingGetThemeStylesheetPlainValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ThemingGetThemeStylesheetPlain valueOf(String name) => _$valueOfThemingGetThemeStylesheetPlain(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ThemingGetThemeStylesheetPlain.
  @BuiltValueSerializer(custom: true)
  static Serializer<ThemingGetThemeStylesheetPlain> get serializer =>
      const _$ThemingGetThemeStylesheetPlainSerializer();
}

class _$ThemingGetThemeStylesheetPlainSerializer implements PrimitiveSerializer<ThemingGetThemeStylesheetPlain> {
  const _$ThemingGetThemeStylesheetPlainSerializer();

  static const Map<ThemingGetThemeStylesheetPlain, Object> _toWire = <ThemingGetThemeStylesheetPlain, Object>{
    ThemingGetThemeStylesheetPlain.$0: 0,
    ThemingGetThemeStylesheetPlain.$1: 1,
  };

  static const Map<Object, ThemingGetThemeStylesheetPlain> _fromWire = <Object, ThemingGetThemeStylesheetPlain>{
    0: ThemingGetThemeStylesheetPlain.$0,
    1: ThemingGetThemeStylesheetPlain.$1,
  };

  @override
  Iterable<Type> get types => const [ThemingGetThemeStylesheetPlain];

  @override
  String get wireName => 'ThemingGetThemeStylesheetPlain';

  @override
  Object serialize(
    Serializers serializers,
    ThemingGetThemeStylesheetPlain object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ThemingGetThemeStylesheetPlain deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class ThemingGetThemeStylesheetWithCustomCss extends EnumClass {
  const ThemingGetThemeStylesheetWithCustomCss._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ThemingGetThemeStylesheetWithCustomCss $0 = _$themingGetThemeStylesheetWithCustomCss$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ThemingGetThemeStylesheetWithCustomCss $1 = _$themingGetThemeStylesheetWithCustomCss$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ThemingGetThemeStylesheetWithCustomCss> get values => _$themingGetThemeStylesheetWithCustomCssValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ThemingGetThemeStylesheetWithCustomCss valueOf(String name) =>
      _$valueOfThemingGetThemeStylesheetWithCustomCss(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ThemingGetThemeStylesheetWithCustomCss.
  @BuiltValueSerializer(custom: true)
  static Serializer<ThemingGetThemeStylesheetWithCustomCss> get serializer =>
      const _$ThemingGetThemeStylesheetWithCustomCssSerializer();
}

class _$ThemingGetThemeStylesheetWithCustomCssSerializer
    implements PrimitiveSerializer<ThemingGetThemeStylesheetWithCustomCss> {
  const _$ThemingGetThemeStylesheetWithCustomCssSerializer();

  static const Map<ThemingGetThemeStylesheetWithCustomCss, Object> _toWire =
      <ThemingGetThemeStylesheetWithCustomCss, Object>{
    ThemingGetThemeStylesheetWithCustomCss.$0: 0,
    ThemingGetThemeStylesheetWithCustomCss.$1: 1,
  };

  static const Map<Object, ThemingGetThemeStylesheetWithCustomCss> _fromWire =
      <Object, ThemingGetThemeStylesheetWithCustomCss>{
    0: ThemingGetThemeStylesheetWithCustomCss.$0,
    1: ThemingGetThemeStylesheetWithCustomCss.$1,
  };

  @override
  Iterable<Type> get types => const [ThemingGetThemeStylesheetWithCustomCss];

  @override
  String get wireName => 'ThemingGetThemeStylesheetWithCustomCss';

  @override
  Object serialize(
    Serializers serializers,
    ThemingGetThemeStylesheetWithCustomCss object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ThemingGetThemeStylesheetWithCustomCss deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class ThemingGetImageUseSvg extends EnumClass {
  const ThemingGetImageUseSvg._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ThemingGetImageUseSvg $0 = _$themingGetImageUseSvg$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ThemingGetImageUseSvg $1 = _$themingGetImageUseSvg$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ThemingGetImageUseSvg> get values => _$themingGetImageUseSvgValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ThemingGetImageUseSvg valueOf(String name) => _$valueOfThemingGetImageUseSvg(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ThemingGetImageUseSvg.
  @BuiltValueSerializer(custom: true)
  static Serializer<ThemingGetImageUseSvg> get serializer => const _$ThemingGetImageUseSvgSerializer();
}

class _$ThemingGetImageUseSvgSerializer implements PrimitiveSerializer<ThemingGetImageUseSvg> {
  const _$ThemingGetImageUseSvgSerializer();

  static const Map<ThemingGetImageUseSvg, Object> _toWire = <ThemingGetImageUseSvg, Object>{
    ThemingGetImageUseSvg.$0: 0,
    ThemingGetImageUseSvg.$1: 1,
  };

  static const Map<Object, ThemingGetImageUseSvg> _fromWire = <Object, ThemingGetImageUseSvg>{
    0: ThemingGetImageUseSvg.$0,
    1: ThemingGetImageUseSvg.$1,
  };

  @override
  Iterable<Type> get types => const [ThemingGetImageUseSvg];

  @override
  String get wireName => 'ThemingGetImageUseSvg';

  @override
  Object serialize(
    Serializers serializers,
    ThemingGetImageUseSvg object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ThemingGetImageUseSvg deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ThemingGetManifestResponseApplicationJson_IconsInterface {
  String get src;
  String get type;
  String get sizes;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ThemingGetManifestResponseApplicationJson_IconsInterfaceBuilder].
  $ThemingGetManifestResponseApplicationJson_IconsInterface rebuild(
    void Function($ThemingGetManifestResponseApplicationJson_IconsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ThemingGetManifestResponseApplicationJson_IconsInterfaceBuilder].
  $ThemingGetManifestResponseApplicationJson_IconsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ThemingGetManifestResponseApplicationJson_IconsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ThemingGetManifestResponseApplicationJson_IconsInterfaceBuilder b) {
    _i6.checkString(
      b.src,
      'src',
      minLength: 1,
    );
  }
}

abstract class ThemingGetManifestResponseApplicationJson_Icons
    implements
        $ThemingGetManifestResponseApplicationJson_IconsInterface,
        Built<ThemingGetManifestResponseApplicationJson_Icons, ThemingGetManifestResponseApplicationJson_IconsBuilder> {
  /// Creates a new ThemingGetManifestResponseApplicationJson_Icons object using the builder pattern.
  factory ThemingGetManifestResponseApplicationJson_Icons([
    void Function(ThemingGetManifestResponseApplicationJson_IconsBuilder)? b,
  ]) = _$ThemingGetManifestResponseApplicationJson_Icons;

  // coverage:ignore-start
  const ThemingGetManifestResponseApplicationJson_Icons._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ThemingGetManifestResponseApplicationJson_Icons.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ThemingGetManifestResponseApplicationJson_Icons.
  static Serializer<ThemingGetManifestResponseApplicationJson_Icons> get serializer =>
      _$themingGetManifestResponseApplicationJsonIconsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ThemingGetManifestResponseApplicationJson_IconsBuilder b) {
    $ThemingGetManifestResponseApplicationJson_IconsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ThemingGetManifestResponseApplicationJson_IconsBuilder b) {
    $ThemingGetManifestResponseApplicationJson_IconsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ThemingGetManifestResponseApplicationJsonInterface {
  String get name;
  @BuiltValueField(wireName: 'short_name')
  String get shortName;
  @BuiltValueField(wireName: 'start_url')
  String get startUrl;
  @BuiltValueField(wireName: 'theme_color')
  String get themeColor;
  @BuiltValueField(wireName: 'background_color')
  String get backgroundColor;
  String get description;
  BuiltList<ThemingGetManifestResponseApplicationJson_Icons> get icons;
  String get display;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ThemingGetManifestResponseApplicationJsonInterfaceBuilder].
  $ThemingGetManifestResponseApplicationJsonInterface rebuild(
    void Function($ThemingGetManifestResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ThemingGetManifestResponseApplicationJsonInterfaceBuilder].
  $ThemingGetManifestResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ThemingGetManifestResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ThemingGetManifestResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ThemingGetManifestResponseApplicationJson
    implements
        $ThemingGetManifestResponseApplicationJsonInterface,
        Built<ThemingGetManifestResponseApplicationJson, ThemingGetManifestResponseApplicationJsonBuilder> {
  /// Creates a new ThemingGetManifestResponseApplicationJson object using the builder pattern.
  factory ThemingGetManifestResponseApplicationJson([
    void Function(ThemingGetManifestResponseApplicationJsonBuilder)? b,
  ]) = _$ThemingGetManifestResponseApplicationJson;

  // coverage:ignore-start
  const ThemingGetManifestResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ThemingGetManifestResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ThemingGetManifestResponseApplicationJson.
  static Serializer<ThemingGetManifestResponseApplicationJson> get serializer =>
      _$themingGetManifestResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ThemingGetManifestResponseApplicationJsonBuilder b) {
    $ThemingGetManifestResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ThemingGetManifestResponseApplicationJsonBuilder b) {
    $ThemingGetManifestResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserThemeEnableThemeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserThemeEnableThemeResponseApplicationJson_OcsInterfaceBuilder].
  $UserThemeEnableThemeResponseApplicationJson_OcsInterface rebuild(
    void Function($UserThemeEnableThemeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserThemeEnableThemeResponseApplicationJson_OcsInterfaceBuilder].
  $UserThemeEnableThemeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserThemeEnableThemeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserThemeEnableThemeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UserThemeEnableThemeResponseApplicationJson_Ocs
    implements
        $UserThemeEnableThemeResponseApplicationJson_OcsInterface,
        Built<UserThemeEnableThemeResponseApplicationJson_Ocs, UserThemeEnableThemeResponseApplicationJson_OcsBuilder> {
  /// Creates a new UserThemeEnableThemeResponseApplicationJson_Ocs object using the builder pattern.
  factory UserThemeEnableThemeResponseApplicationJson_Ocs([
    void Function(UserThemeEnableThemeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UserThemeEnableThemeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UserThemeEnableThemeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserThemeEnableThemeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserThemeEnableThemeResponseApplicationJson_Ocs.
  static Serializer<UserThemeEnableThemeResponseApplicationJson_Ocs> get serializer =>
      _$userThemeEnableThemeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserThemeEnableThemeResponseApplicationJson_OcsBuilder b) {
    $UserThemeEnableThemeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserThemeEnableThemeResponseApplicationJson_OcsBuilder b) {
    $UserThemeEnableThemeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserThemeEnableThemeResponseApplicationJsonInterface {
  UserThemeEnableThemeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserThemeEnableThemeResponseApplicationJsonInterfaceBuilder].
  $UserThemeEnableThemeResponseApplicationJsonInterface rebuild(
    void Function($UserThemeEnableThemeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserThemeEnableThemeResponseApplicationJsonInterfaceBuilder].
  $UserThemeEnableThemeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserThemeEnableThemeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserThemeEnableThemeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UserThemeEnableThemeResponseApplicationJson
    implements
        $UserThemeEnableThemeResponseApplicationJsonInterface,
        Built<UserThemeEnableThemeResponseApplicationJson, UserThemeEnableThemeResponseApplicationJsonBuilder> {
  /// Creates a new UserThemeEnableThemeResponseApplicationJson object using the builder pattern.
  factory UserThemeEnableThemeResponseApplicationJson([
    void Function(UserThemeEnableThemeResponseApplicationJsonBuilder)? b,
  ]) = _$UserThemeEnableThemeResponseApplicationJson;

  // coverage:ignore-start
  const UserThemeEnableThemeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserThemeEnableThemeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserThemeEnableThemeResponseApplicationJson.
  static Serializer<UserThemeEnableThemeResponseApplicationJson> get serializer =>
      _$userThemeEnableThemeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserThemeEnableThemeResponseApplicationJsonBuilder b) {
    $UserThemeEnableThemeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserThemeEnableThemeResponseApplicationJsonBuilder b) {
    $UserThemeEnableThemeResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserThemeDisableThemeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserThemeDisableThemeResponseApplicationJson_OcsInterfaceBuilder].
  $UserThemeDisableThemeResponseApplicationJson_OcsInterface rebuild(
    void Function($UserThemeDisableThemeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserThemeDisableThemeResponseApplicationJson_OcsInterfaceBuilder].
  $UserThemeDisableThemeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserThemeDisableThemeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserThemeDisableThemeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UserThemeDisableThemeResponseApplicationJson_Ocs
    implements
        $UserThemeDisableThemeResponseApplicationJson_OcsInterface,
        Built<UserThemeDisableThemeResponseApplicationJson_Ocs,
            UserThemeDisableThemeResponseApplicationJson_OcsBuilder> {
  /// Creates a new UserThemeDisableThemeResponseApplicationJson_Ocs object using the builder pattern.
  factory UserThemeDisableThemeResponseApplicationJson_Ocs([
    void Function(UserThemeDisableThemeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UserThemeDisableThemeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UserThemeDisableThemeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserThemeDisableThemeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserThemeDisableThemeResponseApplicationJson_Ocs.
  static Serializer<UserThemeDisableThemeResponseApplicationJson_Ocs> get serializer =>
      _$userThemeDisableThemeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserThemeDisableThemeResponseApplicationJson_OcsBuilder b) {
    $UserThemeDisableThemeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserThemeDisableThemeResponseApplicationJson_OcsBuilder b) {
    $UserThemeDisableThemeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserThemeDisableThemeResponseApplicationJsonInterface {
  UserThemeDisableThemeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserThemeDisableThemeResponseApplicationJsonInterfaceBuilder].
  $UserThemeDisableThemeResponseApplicationJsonInterface rebuild(
    void Function($UserThemeDisableThemeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserThemeDisableThemeResponseApplicationJsonInterfaceBuilder].
  $UserThemeDisableThemeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserThemeDisableThemeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserThemeDisableThemeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UserThemeDisableThemeResponseApplicationJson
    implements
        $UserThemeDisableThemeResponseApplicationJsonInterface,
        Built<UserThemeDisableThemeResponseApplicationJson, UserThemeDisableThemeResponseApplicationJsonBuilder> {
  /// Creates a new UserThemeDisableThemeResponseApplicationJson object using the builder pattern.
  factory UserThemeDisableThemeResponseApplicationJson([
    void Function(UserThemeDisableThemeResponseApplicationJsonBuilder)? b,
  ]) = _$UserThemeDisableThemeResponseApplicationJson;

  // coverage:ignore-start
  const UserThemeDisableThemeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserThemeDisableThemeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserThemeDisableThemeResponseApplicationJson.
  static Serializer<UserThemeDisableThemeResponseApplicationJson> get serializer =>
      _$userThemeDisableThemeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserThemeDisableThemeResponseApplicationJsonBuilder b) {
    $UserThemeDisableThemeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserThemeDisableThemeResponseApplicationJsonBuilder b) {
    $UserThemeDisableThemeResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PublicCapabilities_ThemingInterface {
  String get name;
  String get url;
  String get slogan;
  String get color;
  @BuiltValueField(wireName: 'color-text')
  String get colorText;
  @BuiltValueField(wireName: 'color-element')
  String get colorElement;
  @BuiltValueField(wireName: 'color-element-bright')
  String get colorElementBright;
  @BuiltValueField(wireName: 'color-element-dark')
  String get colorElementDark;
  String get logo;
  String get background;
  @BuiltValueField(wireName: 'background-text')
  String? get backgroundText;
  @BuiltValueField(wireName: 'background-plain')
  bool get backgroundPlain;
  @BuiltValueField(wireName: 'background-default')
  bool get backgroundDefault;
  String get logoheader;
  String get favicon;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PublicCapabilities_ThemingInterfaceBuilder].
  $PublicCapabilities_ThemingInterface rebuild(void Function($PublicCapabilities_ThemingInterfaceBuilder) updates);

  /// Converts the instance to a builder [$PublicCapabilities_ThemingInterfaceBuilder].
  $PublicCapabilities_ThemingInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PublicCapabilities_ThemingInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PublicCapabilities_ThemingInterfaceBuilder b) {}
}

abstract class PublicCapabilities_Theming
    implements
        $PublicCapabilities_ThemingInterface,
        Built<PublicCapabilities_Theming, PublicCapabilities_ThemingBuilder> {
  /// Creates a new PublicCapabilities_Theming object using the builder pattern.
  factory PublicCapabilities_Theming([void Function(PublicCapabilities_ThemingBuilder)? b]) =
      _$PublicCapabilities_Theming;

  // coverage:ignore-start
  const PublicCapabilities_Theming._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PublicCapabilities_Theming.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PublicCapabilities_Theming.
  static Serializer<PublicCapabilities_Theming> get serializer => _$publicCapabilitiesThemingSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PublicCapabilities_ThemingBuilder b) {
    $PublicCapabilities_ThemingInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PublicCapabilities_ThemingBuilder b) {
    $PublicCapabilities_ThemingInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PublicCapabilitiesInterface {
  PublicCapabilities_Theming get theming;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PublicCapabilitiesInterfaceBuilder].
  $PublicCapabilitiesInterface rebuild(void Function($PublicCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$PublicCapabilitiesInterfaceBuilder].
  $PublicCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PublicCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PublicCapabilitiesInterfaceBuilder b) {}
}

abstract class PublicCapabilities
    implements $PublicCapabilitiesInterface, Built<PublicCapabilities, PublicCapabilitiesBuilder> {
  /// Creates a new PublicCapabilities object using the builder pattern.
  factory PublicCapabilities([void Function(PublicCapabilitiesBuilder)? b]) = _$PublicCapabilities;

  // coverage:ignore-start
  const PublicCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PublicCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PublicCapabilities.
  static Serializer<PublicCapabilities> get serializer => _$publicCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PublicCapabilitiesBuilder b) {
    $PublicCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PublicCapabilitiesBuilder b) {
    $PublicCapabilitiesInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..add(ThemingGetThemeStylesheetPlain.serializer)
      ..add(ThemingGetThemeStylesheetWithCustomCss.serializer)
      ..add(ThemingGetImageUseSvg.serializer)
      ..addBuilderFactory(
        const FullType(ThemingGetManifestResponseApplicationJson),
        ThemingGetManifestResponseApplicationJsonBuilder.new,
      )
      ..add(ThemingGetManifestResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ThemingGetManifestResponseApplicationJson_Icons),
        ThemingGetManifestResponseApplicationJson_IconsBuilder.new,
      )
      ..add(ThemingGetManifestResponseApplicationJson_Icons.serializer)
      ..addBuilderFactory(
        const FullType(BuiltList, [FullType(ThemingGetManifestResponseApplicationJson_Icons)]),
        ListBuilder<ThemingGetManifestResponseApplicationJson_Icons>.new,
      )
      ..addBuilderFactory(
        const FullType(UserThemeEnableThemeResponseApplicationJson),
        UserThemeEnableThemeResponseApplicationJsonBuilder.new,
      )
      ..add(UserThemeEnableThemeResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserThemeEnableThemeResponseApplicationJson_Ocs),
        UserThemeEnableThemeResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UserThemeEnableThemeResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(
        const FullType(UserThemeDisableThemeResponseApplicationJson),
        UserThemeDisableThemeResponseApplicationJsonBuilder.new,
      )
      ..add(UserThemeDisableThemeResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UserThemeDisableThemeResponseApplicationJson_Ocs),
        UserThemeDisableThemeResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UserThemeDisableThemeResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(PublicCapabilities), PublicCapabilitiesBuilder.new)
      ..add(PublicCapabilities.serializer)
      ..addBuilderFactory(const FullType(PublicCapabilities_Theming), PublicCapabilities_ThemingBuilder.new)
      ..add(PublicCapabilities_Theming.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(_i8.StandardJsonPlugin())
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
