// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// tables Version: 0.0.1.
///
/// Manage data the way you need it.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i6;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i5;

part 'tables.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $Api1Client api1 = $Api1Client(this);

  late final $ApiColumnsClient apiColumns = $ApiColumnsClient(this);

  late final $ApiFavoriteClient apiFavorite = $ApiFavoriteClient(this);

  late final $ApiGeneralClient apiGeneral = $ApiGeneralClient(this);

  late final $ApiTablesClient apiTables = $ApiTablesClient(this);

  late final $ContextClient context = $ContextClient(this);

  late final $RowocsClient rowocs = $RowocsClient(this);
}

class $Api1Client {
  /// Creates a new `DynamiteClient` for api1 requests.
  $Api1Client(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$index_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Table>, void> $index_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Table)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns all Tables.
  ///
  /// Returns a `DynamiteRequest` backing the [index] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [index] for a method executing this request and parsing the response.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $index_Request() {
    const _path = '/index.php/apps/tables/api/1/tables';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns all Tables.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [$index_Request] for the request send by this method.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Table>, void>> index() async {
    final _request = $index_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $index_Serializer();
    return _i1.ResponseConverter<BuiltList<Table>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createTable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Table, void> $createTable_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Table),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a new table and return it.
  ///
  /// Returns a `DynamiteRequest` backing the [createTable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [createTable] for a method executing this request and parsing the response.
  ///  * [$createTable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createTable_Request({required Api1CreateTableRequestApplicationJson $body}) {
    const _path = '/index.php/apps/tables/api/1/tables';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1CreateTableRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a new table and return it.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [$createTable_Request] for the request send by this method.
  ///  * [$createTable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Table, void>> createTable({required Api1CreateTableRequestApplicationJson $body}) async {
    final _request = $createTable_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createTable_Serializer();
    return _i1.ResponseConverter<Table, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getTable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Table, void> $getTable_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Table),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a table object.
  ///
  /// Returns a `DynamiteRequest` backing the [getTable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [getTable] for a method executing this request and parsing the response.
  ///  * [$getTable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getTable_Request({required int tableId}) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a table object.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$getTable_Request] for the request send by this method.
  ///  * [$getTable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Table, void>> getTable({required int tableId}) async {
    final _request = $getTable_Request(
      tableId: tableId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getTable_Serializer();
    return _i1.ResponseConverter<Table, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateTable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Table, void> $updateTable_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Table),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update tables properties.
  ///
  /// Returns a `DynamiteRequest` backing the [updateTable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [updateTable] for a method executing this request and parsing the response.
  ///  * [$updateTable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateTable_Request({
    required int tableId,
    Api1UpdateTableRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1UpdateTableRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              Api1UpdateTableRequestApplicationJson(),
              specifiedType: const FullType(Api1UpdateTableRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Update tables properties.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$updateTable_Request] for the request send by this method.
  ///  * [$updateTable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Table, void>> updateTable({
    required int tableId,
    Api1UpdateTableRequestApplicationJson? $body,
  }) async {
    final _request = $updateTable_Request(
      tableId: tableId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateTable_Serializer();
    return _i1.ResponseConverter<Table, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteTable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Table, void> $deleteTable_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Table),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a table.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteTable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Deleted table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [deleteTable] for a method executing this request and parsing the response.
  ///  * [$deleteTable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteTable_Request({required int tableId}) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Deleted table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$deleteTable_Request] for the request send by this method.
  ///  * [$deleteTable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Table, void>> deleteTable({required int tableId}) async {
    final _request = $deleteTable_Request(
      tableId: tableId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteTable_Serializer();
    return _i1.ResponseConverter<Table, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$showScheme_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Table, Api1Api1ShowSchemeHeaders> $showScheme_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Table),
        headersType: const FullType(Api1Api1ShowSchemeHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// returns table scheme.
  ///
  /// Returns a `DynamiteRequest` backing the [showScheme] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [showScheme] for a method executing this request and parsing the response.
  ///  * [$showScheme_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $showScheme_Request({required int tableId}) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/scheme').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// returns table scheme.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$showScheme_Request] for the request send by this method.
  ///  * [$showScheme_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Table, Api1Api1ShowSchemeHeaders>> showScheme({required int tableId}) async {
    final _request = $showScheme_Request(
      tableId: tableId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $showScheme_Serializer();
    return _i1.ResponseConverter<Table, Api1Api1ShowSchemeHeaders>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$indexViews_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<View>, void> $indexViews_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(View)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all views for a table.
  ///
  /// Returns a `DynamiteRequest` backing the [indexViews] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Views returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [indexViews] for a method executing this request and parsing the response.
  ///  * [$indexViews_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $indexViews_Request({required int tableId}) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/views').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all views for a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Views returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$indexViews_Request] for the request send by this method.
  ///  * [$indexViews_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<View>, void>> indexViews({required int tableId}) async {
    final _request = $indexViews_Request(
      tableId: tableId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $indexViews_Serializer();
    return _i1.ResponseConverter<BuiltList<View>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createView_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<View, void> $createView_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(View),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a new view for a table.
  ///
  /// Returns a `DynamiteRequest` backing the [createView] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID that will hold the view.
  ///
  /// Status codes:
  ///   * 200: View created
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createView] for a method executing this request and parsing the response.
  ///  * [$createView_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createView_Request({
    required int tableId,
    required Api1CreateViewRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/views').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1CreateViewRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a new view for a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID that will hold the view.
  ///
  /// Status codes:
  ///   * 200: View created
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createView_Request] for the request send by this method.
  ///  * [$createView_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<View, void>> createView({
    required int tableId,
    required Api1CreateViewRequestApplicationJson $body,
  }) async {
    final _request = $createView_Request(
      tableId: tableId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createView_Serializer();
    return _i1.ResponseConverter<View, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getView_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<View, void> $getView_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(View),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a view object.
  ///
  /// Returns a `DynamiteRequest` backing the [getView] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [getView] for a method executing this request and parsing the response.
  ///  * [$getView_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getView_Request({required int viewId}) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/views/{viewId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a view object.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$getView_Request] for the request send by this method.
  ///  * [$getView_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<View, void>> getView({required int viewId}) async {
    final _request = $getView_Request(
      viewId: viewId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getView_Serializer();
    return _i1.ResponseConverter<View, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateView_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<View, void> $updateView_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(View),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update a view via key-value sets.
  ///
  /// Returns a `DynamiteRequest` backing the [updateView] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View updated
  ///   * 403: No permissions
  ///   * 400: Invalid data
  ///   * 500
  ///
  /// See:
  ///  * [updateView] for a method executing this request and parsing the response.
  ///  * [$updateView_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateView_Request({
    required int viewId,
    required Api1UpdateViewRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/views/{viewId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1UpdateViewRequestApplicationJson)),
    );
    return _request;
  }

  /// Update a view via key-value sets.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View updated
  ///   * 403: No permissions
  ///   * 400: Invalid data
  ///   * 500
  ///
  /// See:
  ///  * [$updateView_Request] for the request send by this method.
  ///  * [$updateView_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<View, void>> updateView({
    required int viewId,
    required Api1UpdateViewRequestApplicationJson $body,
  }) async {
    final _request = $updateView_Request(
      viewId: viewId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateView_Serializer();
    return _i1.ResponseConverter<View, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteView_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<View, void> $deleteView_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(View),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a view.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteView] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [deleteView] for a method executing this request and parsing the response.
  ///  * [$deleteView_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteView_Request({required int viewId}) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/views/{viewId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete a view.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$deleteView_Request] for the request send by this method.
  ///  * [$deleteView_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<View, void>> deleteView({required int viewId}) async {
    final _request = $deleteView_Request(
      viewId: viewId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteView_Serializer();
    return _i1.ResponseConverter<View, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Share, void> $getShare_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Share),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a share object.
  ///
  /// Returns a `DynamiteRequest` backing the [getShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [shareId] Share ID.
  ///
  /// Status codes:
  ///   * 200: Share returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [getShare] for a method executing this request and parsing the response.
  ///  * [$getShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getShare_Request({required int shareId}) {
    final _parameters = <String, Object?>{};
    final __shareId = _$jsonSerializers.serialize(shareId, specifiedType: const FullType(int));
    _parameters['shareId'] = __shareId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/shares/{shareId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a share object.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [shareId] Share ID.
  ///
  /// Status codes:
  ///   * 200: Share returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$getShare_Request] for the request send by this method.
  ///  * [$getShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Share, void>> getShare({required int shareId}) async {
    final _request = $getShare_Request(
      shareId: shareId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getShare_Serializer();
    return _i1.ResponseConverter<Share, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateSharePermissions_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Share, void> $updateSharePermissions_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Share),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update a share permission.
  ///
  /// Returns a `DynamiteRequest` backing the [updateSharePermissions] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [shareId] Share ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [updateSharePermissions] for a method executing this request and parsing the response.
  ///  * [$updateSharePermissions_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateSharePermissions_Request({
    required int shareId,
    required Api1UpdateSharePermissionsRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __shareId = _$jsonSerializers.serialize(shareId, specifiedType: const FullType(int));
    _parameters['shareId'] = __shareId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/shares/{shareId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(Api1UpdateSharePermissionsRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update a share permission.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [shareId] Share ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$updateSharePermissions_Request] for the request send by this method.
  ///  * [$updateSharePermissions_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Share, void>> updateSharePermissions({
    required int shareId,
    required Api1UpdateSharePermissionsRequestApplicationJson $body,
  }) async {
    final _request = $updateSharePermissions_Request(
      shareId: shareId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateSharePermissions_Serializer();
    return _i1.ResponseConverter<Share, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Share, void> $deleteShare_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Share),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a share.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [shareId] Share ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [deleteShare] for a method executing this request and parsing the response.
  ///  * [$deleteShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteShare_Request({required int shareId}) {
    final _parameters = <String, Object?>{};
    final __shareId = _$jsonSerializers.serialize(shareId, specifiedType: const FullType(int));
    _parameters['shareId'] = __shareId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/shares/{shareId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete a share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [shareId] Share ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$deleteShare_Request] for the request send by this method.
  ///  * [$deleteShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Share, void>> deleteShare({required int shareId}) async {
    final _request = $deleteShare_Request(
      shareId: shareId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteShare_Serializer();
    return _i1.ResponseConverter<Share, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$indexViewShares_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Share>, void> $indexViewShares_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Share)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all shares for a view Will be empty if view does not exist.
  ///
  /// Returns a `DynamiteRequest` backing the [indexViewShares] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: Shares returned
  ///   * 500
  ///
  /// See:
  ///  * [indexViewShares] for a method executing this request and parsing the response.
  ///  * [$indexViewShares_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $indexViewShares_Request({required int viewId}) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/views/{viewId}/shares').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all shares for a view Will be empty if view does not exist.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: Shares returned
  ///   * 500
  ///
  /// See:
  ///  * [$indexViewShares_Request] for the request send by this method.
  ///  * [$indexViewShares_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Share>, void>> indexViewShares({required int viewId}) async {
    final _request = $indexViewShares_Request(
      viewId: viewId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $indexViewShares_Serializer();
    return _i1.ResponseConverter<BuiltList<Share>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$indexTableShares_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Share>, void> $indexTableShares_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Share)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all shares for a table Will be empty if table does not exist.
  ///
  /// Returns a `DynamiteRequest` backing the [indexTableShares] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Shares returned
  ///   * 500
  ///
  /// See:
  ///  * [indexTableShares] for a method executing this request and parsing the response.
  ///  * [$indexTableShares_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $indexTableShares_Request({required int tableId}) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/shares').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all shares for a table Will be empty if table does not exist.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Shares returned
  ///   * 500
  ///
  /// See:
  ///  * [$indexTableShares_Request] for the request send by this method.
  ///  * [$indexTableShares_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Share>, void>> indexTableShares({required int tableId}) async {
    final _request = $indexTableShares_Request(
      tableId: tableId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $indexTableShares_Serializer();
    return _i1.ResponseConverter<BuiltList<Share>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createTableShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Share, void> $createTableShare_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Share),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a share for a table.
  ///
  /// Returns a `DynamiteRequest` backing the [createTableShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createTableShare] for a method executing this request and parsing the response.
  ///  * [$createTableShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createTableShare_Request({
    required int tableId,
    required Api1CreateTableShareRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/shares').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1CreateTableShareRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a share for a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createTableShare_Request] for the request send by this method.
  ///  * [$createTableShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Share, void>> createTableShare({
    required int tableId,
    required Api1CreateTableShareRequestApplicationJson $body,
  }) async {
    final _request = $createTableShare_Request(
      tableId: tableId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createTableShare_Serializer();
    return _i1.ResponseConverter<Share, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Share, void> $createShare_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Share),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a new share.
  ///
  /// Returns a `DynamiteRequest` backing the [createShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Share returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createShare] for a method executing this request and parsing the response.
  ///  * [$createShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createShare_Request({required Api1CreateShareRequestApplicationJson $body}) {
    const _path = '/index.php/apps/tables/api/1/shares';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1CreateShareRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a new share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Share returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createShare_Request] for the request send by this method.
  ///  * [$createShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Share, void>> createShare({required Api1CreateShareRequestApplicationJson $body}) async {
    final _request = $createShare_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createShare_Serializer();
    return _i1.ResponseConverter<Share, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateShareDisplayMode_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ContextNavigation, void> $updateShareDisplayMode_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ContextNavigation),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Updates the display mode of a context share.
  ///
  /// Returns a `DynamiteRequest` backing the [updateShareDisplayMode] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [shareId] Share ID.
  ///
  /// Status codes:
  ///   * 200: Display mode updated
  ///   * 400: Invalid parameter
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [updateShareDisplayMode] for a method executing this request and parsing the response.
  ///  * [$updateShareDisplayMode_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateShareDisplayMode_Request({
    required int shareId,
    required Api1UpdateShareDisplayModeRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __shareId = _$jsonSerializers.serialize(shareId, specifiedType: const FullType(int));
    _parameters['shareId'] = __shareId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/shares/{shareId}/display-mode').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(Api1UpdateShareDisplayModeRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Updates the display mode of a context share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [shareId] Share ID.
  ///
  /// Status codes:
  ///   * 200: Display mode updated
  ///   * 400: Invalid parameter
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$updateShareDisplayMode_Request] for the request send by this method.
  ///  * [$updateShareDisplayMode_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ContextNavigation, void>> updateShareDisplayMode({
    required int shareId,
    required Api1UpdateShareDisplayModeRequestApplicationJson $body,
  }) async {
    final _request = $updateShareDisplayMode_Request(
      shareId: shareId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateShareDisplayMode_Serializer();
    return _i1.ResponseConverter<ContextNavigation, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$indexTableColumns_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Column>, void> $indexTableColumns_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Column)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all columns for a table or a underlying view Return an empty array if no columns were found.
  ///
  /// Returns a `DynamiteRequest` backing the [indexTableColumns] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [indexTableColumns] for a method executing this request and parsing the response.
  ///  * [$indexTableColumns_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $indexTableColumns_Request({
    required int tableId,
    int? viewId,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final _path =
        _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/columns{?viewId*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all columns for a table or a underlying view Return an empty array if no columns were found.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$indexTableColumns_Request] for the request send by this method.
  ///  * [$indexTableColumns_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Column>, void>> indexTableColumns({
    required int tableId,
    int? viewId,
  }) async {
    final _request = $indexTableColumns_Request(
      tableId: tableId,
      viewId: viewId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $indexTableColumns_Serializer();
    return _i1.ResponseConverter<BuiltList<Column>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createTableColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Column, void> $createTableColumn_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Column),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a new column for a table.
  ///
  /// Returns a `DynamiteRequest` backing the [createTableColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createTableColumn] for a method executing this request and parsing the response.
  ///  * [$createTableColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createTableColumn_Request({
    required int tableId,
    required Api1CreateTableColumnRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/columns').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1CreateTableColumnRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a new column for a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createTableColumn_Request] for the request send by this method.
  ///  * [$createTableColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Column, void>> createTableColumn({
    required int tableId,
    required Api1CreateTableColumnRequestApplicationJson $body,
  }) async {
    final _request = $createTableColumn_Request(
      tableId: tableId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createTableColumn_Serializer();
    return _i1.ResponseConverter<Column, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$indexViewColumns_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Column>, void> $indexViewColumns_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Column)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all columns for a view Return an empty array if no columns were found.
  ///
  /// Returns a `DynamiteRequest` backing the [indexViewColumns] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [indexViewColumns] for a method executing this request and parsing the response.
  ///  * [$indexViewColumns_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $indexViewColumns_Request({required int viewId}) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/views/{viewId}/columns').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all columns for a view Return an empty array if no columns were found.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$indexViewColumns_Request] for the request send by this method.
  ///  * [$indexViewColumns_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Column>, void>> indexViewColumns({required int viewId}) async {
    final _request = $indexViewColumns_Request(
      viewId: viewId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $indexViewColumns_Serializer();
    return _i1.ResponseConverter<BuiltList<Column>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Column, void> $createColumn_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Column),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a column.
  ///
  /// Returns a `DynamiteRequest` backing the [createColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createColumn] for a method executing this request and parsing the response.
  ///  * [$createColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createColumn_Request({required Api1CreateColumnRequestApplicationJson $body}) {
    const _path = '/index.php/apps/tables/api/1/columns';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1CreateColumnRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a column.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createColumn_Request] for the request send by this method.
  ///  * [$createColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Column, void>> createColumn({
    required Api1CreateColumnRequestApplicationJson $body,
  }) async {
    final _request = $createColumn_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createColumn_Serializer();
    return _i1.ResponseConverter<Column, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Column, void> $getColumn_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Column),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a column object.
  ///
  /// Returns a `DynamiteRequest` backing the [getColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [columnId] Wanted Column ID.
  ///
  /// Status codes:
  ///   * 200: Column returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [getColumn] for a method executing this request and parsing the response.
  ///  * [$getColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getColumn_Request({required int columnId}) {
    final _parameters = <String, Object?>{};
    final __columnId = _$jsonSerializers.serialize(columnId, specifiedType: const FullType(int));
    _parameters['columnId'] = __columnId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/columns/{columnId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a column object.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [columnId] Wanted Column ID.
  ///
  /// Status codes:
  ///   * 200: Column returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$getColumn_Request] for the request send by this method.
  ///  * [$getColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Column, void>> getColumn({required int columnId}) async {
    final _request = $getColumn_Request(
      columnId: columnId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getColumn_Serializer();
    return _i1.ResponseConverter<Column, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Column, void> $updateColumn_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Column),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update a column.
  ///
  /// Returns a `DynamiteRequest` backing the [updateColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [columnId] Column ID that will be updated.
  ///
  /// Status codes:
  ///   * 200: Updated column
  ///   * 500
  ///
  /// See:
  ///  * [updateColumn] for a method executing this request and parsing the response.
  ///  * [$updateColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateColumn_Request({
    required int columnId,
    required Api1UpdateColumnRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __columnId = _$jsonSerializers.serialize(columnId, specifiedType: const FullType(int));
    _parameters['columnId'] = __columnId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/columns/{columnId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1UpdateColumnRequestApplicationJson)),
    );
    return _request;
  }

  /// Update a column.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [columnId] Column ID that will be updated.
  ///
  /// Status codes:
  ///   * 200: Updated column
  ///   * 500
  ///
  /// See:
  ///  * [$updateColumn_Request] for the request send by this method.
  ///  * [$updateColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Column, void>> updateColumn({
    required int columnId,
    required Api1UpdateColumnRequestApplicationJson $body,
  }) async {
    final _request = $updateColumn_Request(
      columnId: columnId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateColumn_Serializer();
    return _i1.ResponseConverter<Column, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Column, void> $deleteColumn_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Column),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a column.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [columnId] Wanted Column ID.
  ///
  /// Status codes:
  ///   * 200: Deleted column returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [deleteColumn] for a method executing this request and parsing the response.
  ///  * [$deleteColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteColumn_Request({required int columnId}) {
    final _parameters = <String, Object?>{};
    final __columnId = _$jsonSerializers.serialize(columnId, specifiedType: const FullType(int));
    _parameters['columnId'] = __columnId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/columns/{columnId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete a column.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [columnId] Wanted Column ID.
  ///
  /// Status codes:
  ///   * 200: Deleted column returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$deleteColumn_Request] for the request send by this method.
  ///  * [$deleteColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Column, void>> deleteColumn({required int columnId}) async {
    final _request = $deleteColumn_Request(
      columnId: columnId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteColumn_Serializer();
    return _i1.ResponseConverter<Column, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$indexTableRowsSimple_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<String>, void> $indexTableRowsSimple_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(String)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// List all rows values for a table, first row are the column titles.
  ///
  /// Returns a `DynamiteRequest` backing the [indexTableRowsSimple] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///   * [limit] Limit.
  ///   * [offset] Offset.
  ///
  /// Status codes:
  ///   * 200: Row values returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [indexTableRowsSimple] for a method executing this request and parsing the response.
  ///  * [$indexTableRowsSimple_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $indexTableRowsSimple_Request({
    required int tableId,
    int? limit,
    int? offset,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    final __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    _parameters['offset'] = __offset;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/rows/simple{?limit*,offset*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// List all rows values for a table, first row are the column titles.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///   * [limit] Limit.
  ///   * [offset] Offset.
  ///
  /// Status codes:
  ///   * 200: Row values returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$indexTableRowsSimple_Request] for the request send by this method.
  ///  * [$indexTableRowsSimple_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<String>, void>> indexTableRowsSimple({
    required int tableId,
    int? limit,
    int? offset,
  }) async {
    final _request = $indexTableRowsSimple_Request(
      tableId: tableId,
      limit: limit,
      offset: offset,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $indexTableRowsSimple_Serializer();
    return _i1.ResponseConverter<BuiltList<String>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$indexTableRows_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Row>, void> $indexTableRows_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Row)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// List all rows for a table.
  ///
  /// Returns a `DynamiteRequest` backing the [indexTableRows] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///   * [limit] Limit.
  ///   * [offset] Offset.
  ///
  /// Status codes:
  ///   * 200: Rows returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [indexTableRows] for a method executing this request and parsing the response.
  ///  * [$indexTableRows_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $indexTableRows_Request({
    required int tableId,
    int? limit,
    int? offset,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    final __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    _parameters['offset'] = __offset;

    final _path =
        _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/rows{?limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// List all rows for a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///   * [limit] Limit.
  ///   * [offset] Offset.
  ///
  /// Status codes:
  ///   * 200: Rows returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$indexTableRows_Request] for the request send by this method.
  ///  * [$indexTableRows_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Row>, void>> indexTableRows({
    required int tableId,
    int? limit,
    int? offset,
  }) async {
    final _request = $indexTableRows_Request(
      tableId: tableId,
      limit: limit,
      offset: offset,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $indexTableRows_Serializer();
    return _i1.ResponseConverter<BuiltList<Row>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createRowInTable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Row, void> $createRowInTable_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Row),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a row within a table.
  ///
  /// Returns a `DynamiteRequest` backing the [createRowInTable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Row returned
  ///   * 403: No permissions
  ///   * 500
  ///
  /// See:
  ///  * [createRowInTable] for a method executing this request and parsing the response.
  ///  * [$createRowInTable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createRowInTable_Request({
    required int tableId,
    required Api1CreateRowInTableRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/tables/{tableId}/rows').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1CreateRowInTableRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a row within a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Row returned
  ///   * 403: No permissions
  ///   * 500
  ///
  /// See:
  ///  * [$createRowInTable_Request] for the request send by this method.
  ///  * [$createRowInTable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Row, void>> createRowInTable({
    required int tableId,
    required Api1CreateRowInTableRequestApplicationJson $body,
  }) async {
    final _request = $createRowInTable_Request(
      tableId: tableId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createRowInTable_Serializer();
    return _i1.ResponseConverter<Row, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$indexViewRows_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Row>, void> $indexViewRows_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Row)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// List all rows for a view.
  ///
  /// Returns a `DynamiteRequest` backing the [indexViewRows] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///   * [limit] Limit.
  ///   * [offset] Offset.
  ///
  /// Status codes:
  ///   * 200: Rows returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [indexViewRows] for a method executing this request and parsing the response.
  ///  * [$indexViewRows_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $indexViewRows_Request({
    required int viewId,
    int? limit,
    int? offset,
  }) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    final __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    _parameters['offset'] = __offset;

    final _path =
        _i5.UriTemplate('/index.php/apps/tables/api/1/views/{viewId}/rows{?limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// List all rows for a view.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///   * [limit] Limit.
  ///   * [offset] Offset.
  ///
  /// Status codes:
  ///   * 200: Rows returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$indexViewRows_Request] for the request send by this method.
  ///  * [$indexViewRows_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Row>, void>> indexViewRows({
    required int viewId,
    int? limit,
    int? offset,
  }) async {
    final _request = $indexViewRows_Request(
      viewId: viewId,
      limit: limit,
      offset: offset,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $indexViewRows_Serializer();
    return _i1.ResponseConverter<BuiltList<Row>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createRowInView_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Row, void> $createRowInView_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Row),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a row within a view.
  ///
  /// Returns a `DynamiteRequest` backing the [createRowInView] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: Row returned
  ///   * 403: No permissions
  ///   * 500
  ///
  /// See:
  ///  * [createRowInView] for a method executing this request and parsing the response.
  ///  * [$createRowInView_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createRowInView_Request({
    required int viewId,
    required Api1CreateRowInViewRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/views/{viewId}/rows').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1CreateRowInViewRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a row within a view.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: Row returned
  ///   * 403: No permissions
  ///   * 500
  ///
  /// See:
  ///  * [$createRowInView_Request] for the request send by this method.
  ///  * [$createRowInView_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Row, void>> createRowInView({
    required int viewId,
    required Api1CreateRowInViewRequestApplicationJson $body,
  }) async {
    final _request = $createRowInView_Request(
      viewId: viewId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createRowInView_Serializer();
    return _i1.ResponseConverter<Row, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getRow_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Row, void> $getRow_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Row),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a row.
  ///
  /// Returns a `DynamiteRequest` backing the [getRow] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [rowId] Row ID.
  ///
  /// Status codes:
  ///   * 200: Row returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [getRow] for a method executing this request and parsing the response.
  ///  * [$getRow_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getRow_Request({required int rowId}) {
    final _parameters = <String, Object?>{};
    final __rowId = _$jsonSerializers.serialize(rowId, specifiedType: const FullType(int));
    _parameters['rowId'] = __rowId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/rows/{rowId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a row.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [rowId] Row ID.
  ///
  /// Status codes:
  ///   * 200: Row returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$getRow_Request] for the request send by this method.
  ///  * [$getRow_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Row, void>> getRow({required int rowId}) async {
    final _request = $getRow_Request(
      rowId: rowId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getRow_Serializer();
    return _i1.ResponseConverter<Row, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateRow_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Row, void> $updateRow_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Row),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update a row.
  ///
  /// Returns a `DynamiteRequest` backing the [updateRow] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [rowId] Row ID.
  ///
  /// Status codes:
  ///   * 200: Updated row returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [updateRow] for a method executing this request and parsing the response.
  ///  * [$updateRow_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateRow_Request({
    required int rowId,
    required Api1UpdateRowRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __rowId = _$jsonSerializers.serialize(rowId, specifiedType: const FullType(int));
    _parameters['rowId'] = __rowId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/rows/{rowId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(Api1UpdateRowRequestApplicationJson)));
    return _request;
  }

  /// Update a row.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [rowId] Row ID.
  ///
  /// Status codes:
  ///   * 200: Updated row returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$updateRow_Request] for the request send by this method.
  ///  * [$updateRow_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Row, void>> updateRow({
    required int rowId,
    required Api1UpdateRowRequestApplicationJson $body,
  }) async {
    final _request = $updateRow_Request(
      rowId: rowId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateRow_Serializer();
    return _i1.ResponseConverter<Row, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteRow_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Row, void> $deleteRow_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Row),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a row.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteRow] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [rowId] Row ID.
  ///
  /// Status codes:
  ///   * 200: Deleted row returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [deleteRow] for a method executing this request and parsing the response.
  ///  * [$deleteRow_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteRow_Request({required int rowId}) {
    final _parameters = <String, Object?>{};
    final __rowId = _$jsonSerializers.serialize(rowId, specifiedType: const FullType(int));
    _parameters['rowId'] = __rowId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/rows/{rowId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete a row.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [rowId] Row ID.
  ///
  /// Status codes:
  ///   * 200: Deleted row returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$deleteRow_Request] for the request send by this method.
  ///  * [$deleteRow_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Row, void>> deleteRow({required int rowId}) async {
    final _request = $deleteRow_Request(
      rowId: rowId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteRow_Serializer();
    return _i1.ResponseConverter<Row, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteRowByView_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Row, void> $deleteRowByView_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Row),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a row within a view.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteRowByView] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///   * [rowId] Row ID.
  ///
  /// Status codes:
  ///   * 200: Deleted row returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [deleteRowByView] for a method executing this request and parsing the response.
  ///  * [$deleteRowByView_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteRowByView_Request({
    required int viewId,
    required int rowId,
  }) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final __rowId = _$jsonSerializers.serialize(rowId, specifiedType: const FullType(int));
    _parameters['rowId'] = __rowId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/views/{viewId}/rows/{rowId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete a row within a view.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///   * [rowId] Row ID.
  ///
  /// Status codes:
  ///   * 200: Deleted row returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$deleteRowByView_Request] for the request send by this method.
  ///  * [$deleteRowByView_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Row, void>> deleteRowByView({
    required int viewId,
    required int rowId,
  }) async {
    final _request = $deleteRowByView_Request(
      viewId: viewId,
      rowId: rowId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteRowByView_Serializer();
    return _i1.ResponseConverter<Row, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$importInTable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ImportState, void> $importInTable_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ImportState),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Import from file in to a table.
  ///
  /// Returns a `DynamiteRequest` backing the [importInTable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Import status returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [importInTable] for a method executing this request and parsing the response.
  ///  * [$importInTable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $importInTable_Request({
    required int tableId,
    required Api1ImportInTableRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __tableId = _$jsonSerializers.serialize(tableId, specifiedType: const FullType(int));
    _parameters['tableId'] = __tableId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/import/table/{tableId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1ImportInTableRequestApplicationJson)),
    );
    return _request;
  }

  /// Import from file in to a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [tableId] Table ID.
  ///
  /// Status codes:
  ///   * 200: Import status returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$importInTable_Request] for the request send by this method.
  ///  * [$importInTable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ImportState, void>> importInTable({
    required int tableId,
    required Api1ImportInTableRequestApplicationJson $body,
  }) async {
    final _request = $importInTable_Request(
      tableId: tableId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $importInTable_Serializer();
    return _i1.ResponseConverter<ImportState, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$importInView_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ImportState, void> $importInView_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ImportState),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Import from file in to a table.
  ///
  /// Returns a `DynamiteRequest` backing the [importInView] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: Import status returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [importInView] for a method executing this request and parsing the response.
  ///  * [$importInView_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $importInView_Request({
    required int viewId,
    required Api1ImportInViewRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __viewId = _$jsonSerializers.serialize(viewId, specifiedType: const FullType(int));
    _parameters['viewId'] = __viewId;

    final _path = _i5.UriTemplate('/index.php/apps/tables/api/1/import/views/{viewId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(Api1ImportInViewRequestApplicationJson)),
    );
    return _request;
  }

  /// Import from file in to a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [viewId] View ID.
  ///
  /// Status codes:
  ///   * 200: Import status returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$importInView_Request] for the request send by this method.
  ///  * [$importInView_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ImportState, void>> importInView({
    required int viewId,
    required Api1ImportInViewRequestApplicationJson $body,
  }) async {
    final _request = $importInView_Request(
      viewId: viewId,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $importInView_Serializer();
    return _i1.ResponseConverter<ImportState, void>(_serializer).convert(_response);
  }
}

class $ApiColumnsClient {
  /// Creates a new `DynamiteClient` for api_columns requests.
  $ApiColumnsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$index_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiColumnsIndexResponseApplicationJson, void> $index_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiColumnsIndexResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Get all columns for a table or a view.
  ///
  /// Return an empty array if no columns were found.
  ///
  /// Returns a `DynamiteRequest` backing the [index] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [nodeType] Node type.
  ///   * [nodeId] Node ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [index] for a method executing this request and parsing the response.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $index_Request({
    required ApiColumnsIndexNodeType nodeType,
    required int nodeId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __nodeType = _$jsonSerializers.serialize(nodeType, specifiedType: const FullType(ApiColumnsIndexNodeType));
    _parameters['nodeType'] = __nodeType;

    final __nodeId = _$jsonSerializers.serialize(nodeId, specifiedType: const FullType(int));
    _parameters['nodeId'] = __nodeId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/columns/{nodeType}/{nodeId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Get all columns for a table or a view.
  ///
  /// Return an empty array if no columns were found.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [nodeType] Node type.
  ///   * [nodeId] Node ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: View deleted
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$index_Request] for the request send by this method.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiColumnsIndexResponseApplicationJson, void>> index({
    required ApiColumnsIndexNodeType nodeType,
    required int nodeId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $index_Request(
      nodeType: nodeType,
      nodeId: nodeId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $index_Serializer();
    return _i1.ResponseConverter<ApiColumnsIndexResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$$show_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiColumnsShowResponseApplicationJson, void> $$show_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiColumnsShowResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Get a column object.
  ///
  /// Returns a `DynamiteRequest` backing the [$show] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Column ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$show] for a method executing this request and parsing the response.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$show_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/columns/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Get a column object.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Column ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$$show_Request] for the request send by this method.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiColumnsShowResponseApplicationJson, void>> $show({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $$show_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$show_Serializer();
    return _i1.ResponseConverter<ApiColumnsShowResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createNumberColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiColumnsCreateNumberColumnResponseApplicationJson, void> $createNumberColumn_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ApiColumnsCreateNumberColumnResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Create new numbered column.
  ///
  /// Specify a subtype to use any special numbered column.
  ///
  /// Returns a `DynamiteRequest` backing the [createNumberColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createNumberColumn] for a method executing this request and parsing the response.
  ///  * [$createNumberColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createNumberColumn_Request({
    required ApiColumnsCreateNumberColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/tables/api/2/columns/number';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ApiColumnsCreateNumberColumnRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// [api v2] Create new numbered column.
  ///
  /// Specify a subtype to use any special numbered column.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createNumberColumn_Request] for the request send by this method.
  ///  * [$createNumberColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiColumnsCreateNumberColumnResponseApplicationJson, void>> createNumberColumn({
    required ApiColumnsCreateNumberColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createNumberColumn_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createNumberColumn_Serializer();
    return _i1.ResponseConverter<ApiColumnsCreateNumberColumnResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$createTextColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiColumnsCreateTextColumnResponseApplicationJson, void> $createTextColumn_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ApiColumnsCreateTextColumnResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Create new text column.
  ///
  /// Specify a subtype to use any special text column.
  ///
  /// Returns a `DynamiteRequest` backing the [createTextColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createTextColumn] for a method executing this request and parsing the response.
  ///  * [$createTextColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createTextColumn_Request({
    required ApiColumnsCreateTextColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/tables/api/2/columns/text';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ApiColumnsCreateTextColumnRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// [api v2] Create new text column.
  ///
  /// Specify a subtype to use any special text column.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createTextColumn_Request] for the request send by this method.
  ///  * [$createTextColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiColumnsCreateTextColumnResponseApplicationJson, void>> createTextColumn({
    required ApiColumnsCreateTextColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createTextColumn_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createTextColumn_Serializer();
    return _i1.ResponseConverter<ApiColumnsCreateTextColumnResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$createSelectionColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiColumnsCreateSelectionColumnResponseApplicationJson, void>
      $createSelectionColumn_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ApiColumnsCreateSelectionColumnResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// [api v2] Create new selection column.
  ///
  /// Specify a subtype to use any special selection column.
  ///
  /// Returns a `DynamiteRequest` backing the [createSelectionColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createSelectionColumn] for a method executing this request and parsing the response.
  ///  * [$createSelectionColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createSelectionColumn_Request({
    required ApiColumnsCreateSelectionColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/tables/api/2/columns/selection';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ApiColumnsCreateSelectionColumnRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// [api v2] Create new selection column.
  ///
  /// Specify a subtype to use any special selection column.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createSelectionColumn_Request] for the request send by this method.
  ///  * [$createSelectionColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiColumnsCreateSelectionColumnResponseApplicationJson, void>> createSelectionColumn({
    required ApiColumnsCreateSelectionColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createSelectionColumn_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createSelectionColumn_Serializer();
    return _i1.ResponseConverter<ApiColumnsCreateSelectionColumnResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$createDatetimeColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiColumnsCreateDatetimeColumnResponseApplicationJson, void>
      $createDatetimeColumn_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ApiColumnsCreateDatetimeColumnResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// [api v2] Create new datetime column.
  ///
  /// Specify a subtype to use any special datetime column.
  ///
  /// Returns a `DynamiteRequest` backing the [createDatetimeColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createDatetimeColumn] for a method executing this request and parsing the response.
  ///  * [$createDatetimeColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createDatetimeColumn_Request({
    required ApiColumnsCreateDatetimeColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/tables/api/2/columns/datetime';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ApiColumnsCreateDatetimeColumnRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// [api v2] Create new datetime column.
  ///
  /// Specify a subtype to use any special datetime column.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createDatetimeColumn_Request] for the request send by this method.
  ///  * [$createDatetimeColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiColumnsCreateDatetimeColumnResponseApplicationJson, void>> createDatetimeColumn({
    required ApiColumnsCreateDatetimeColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createDatetimeColumn_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createDatetimeColumn_Serializer();
    return _i1.ResponseConverter<ApiColumnsCreateDatetimeColumnResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$createUsergroupColumn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiColumnsCreateUsergroupColumnResponseApplicationJson, void>
      $createUsergroupColumn_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ApiColumnsCreateUsergroupColumnResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// [api v2] Create new usergroup column.
  ///
  /// Returns a `DynamiteRequest` backing the [createUsergroupColumn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [createUsergroupColumn] for a method executing this request and parsing the response.
  ///  * [$createUsergroupColumn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createUsergroupColumn_Request({
    required ApiColumnsCreateUsergroupColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/tables/api/2/columns/usergroup';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ApiColumnsCreateUsergroupColumnRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// [api v2] Create new usergroup column.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Column created
  ///   * 403: No permission
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$createUsergroupColumn_Request] for the request send by this method.
  ///  * [$createUsergroupColumn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiColumnsCreateUsergroupColumnResponseApplicationJson, void>> createUsergroupColumn({
    required ApiColumnsCreateUsergroupColumnRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createUsergroupColumn_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createUsergroupColumn_Serializer();
    return _i1.ResponseConverter<ApiColumnsCreateUsergroupColumnResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $ApiFavoriteClient {
  /// Creates a new `DynamiteClient` for api_favorite requests.
  $ApiFavoriteClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$create_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiFavoriteCreateResponseApplicationJson, void> $create_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiFavoriteCreateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Add a node (table or view) to user favorites.
  ///
  /// Returns a `DynamiteRequest` backing the [create] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [nodeType] any Application::NODE_TYPE_* constant.
  ///   * [nodeId] identifier of the node.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [create] for a method executing this request and parsing the response.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $create_Request({
    required int nodeType,
    required int nodeId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __nodeType = _$jsonSerializers.serialize(nodeType, specifiedType: const FullType(int));
    _parameters['nodeType'] = __nodeType;

    final __nodeId = _$jsonSerializers.serialize(nodeId, specifiedType: const FullType(int));
    _parameters['nodeId'] = __nodeId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/favorites/{nodeType}/{nodeId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Add a node (table or view) to user favorites.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [nodeType] any Application::NODE_TYPE_* constant.
  ///   * [nodeId] identifier of the node.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$create_Request] for the request send by this method.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiFavoriteCreateResponseApplicationJson, void>> create({
    required int nodeType,
    required int nodeId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $create_Request(
      nodeType: nodeType,
      nodeId: nodeId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $create_Serializer();
    return _i1.ResponseConverter<ApiFavoriteCreateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$destroy_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiFavoriteDestroyResponseApplicationJson, void> $destroy_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ApiFavoriteDestroyResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Remove a node (table or view) to from favorites.
  ///
  /// Returns a `DynamiteRequest` backing the [destroy] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [nodeType] any Application::NODE_TYPE_* constant.
  ///   * [nodeId] identifier of the node.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Deleted table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [destroy] for a method executing this request and parsing the response.
  ///  * [$destroy_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $destroy_Request({
    required int nodeType,
    required int nodeId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __nodeType = _$jsonSerializers.serialize(nodeType, specifiedType: const FullType(int));
    _parameters['nodeType'] = __nodeType;

    final __nodeId = _$jsonSerializers.serialize(nodeId, specifiedType: const FullType(int));
    _parameters['nodeId'] = __nodeId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/favorites/{nodeType}/{nodeId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Remove a node (table or view) to from favorites.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [nodeType] any Application::NODE_TYPE_* constant.
  ///   * [nodeId] identifier of the node.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Deleted table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$destroy_Request] for the request send by this method.
  ///  * [$destroy_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiFavoriteDestroyResponseApplicationJson, void>> destroy({
    required int nodeType,
    required int nodeId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $destroy_Request(
      nodeType: nodeType,
      nodeId: nodeId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $destroy_Serializer();
    return _i1.ResponseConverter<ApiFavoriteDestroyResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $ApiGeneralClient {
  /// Creates a new `DynamiteClient` for api_general requests.
  $ApiGeneralClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$index_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiGeneralIndexResponseApplicationJson, void> $index_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiGeneralIndexResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Returns all main resources.
  ///
  /// Tables and views incl. shares.
  ///
  /// Returns a `DynamiteRequest` backing the [index] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Index returned
  ///   * 500
  ///
  /// See:
  ///  * [index] for a method executing this request and parsing the response.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $index_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/tables/api/2/init';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Returns all main resources.
  ///
  /// Tables and views incl. shares.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Index returned
  ///   * 500
  ///
  /// See:
  ///  * [$index_Request] for the request send by this method.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiGeneralIndexResponseApplicationJson, void>> index({bool? oCSAPIRequest}) async {
    final _request = $index_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $index_Serializer();
    return _i1.ResponseConverter<ApiGeneralIndexResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $ApiTablesClient {
  /// Creates a new `DynamiteClient` for api_tables requests.
  $ApiTablesClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$index_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiTablesIndexResponseApplicationJson, void> $index_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiTablesIndexResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Returns all Tables.
  ///
  /// Returns a `DynamiteRequest` backing the [index] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [index] for a method executing this request and parsing the response.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $index_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/tables/api/2/tables';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Returns all Tables.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [$index_Request] for the request send by this method.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiTablesIndexResponseApplicationJson, void>> index({bool? oCSAPIRequest}) async {
    final _request = $index_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $index_Serializer();
    return _i1.ResponseConverter<ApiTablesIndexResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$create_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiTablesCreateResponseApplicationJson, void> $create_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiTablesCreateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Create a new table and return it.
  ///
  /// Returns a `DynamiteRequest` backing the [create] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [create] for a method executing this request and parsing the response.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $create_Request({
    required ApiTablesCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/tables/api/2/tables';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ApiTablesCreateRequestApplicationJson)),
    );
    return _request;
  }

  /// [api v2] Create a new table and return it.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [$create_Request] for the request send by this method.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiTablesCreateResponseApplicationJson, void>> create({
    required ApiTablesCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $create_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $create_Serializer();
    return _i1.ResponseConverter<ApiTablesCreateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$$show_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiTablesShowResponseApplicationJson, void> $$show_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiTablesShowResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Get a table object.
  ///
  /// Returns a `DynamiteRequest` backing the [$show] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$show] for a method executing this request and parsing the response.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$show_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/tables/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Get a table object.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$$show_Request] for the request send by this method.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiTablesShowResponseApplicationJson, void>> $show({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $$show_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$show_Serializer();
    return _i1.ResponseConverter<ApiTablesShowResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$$update_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiTablesUpdateResponseApplicationJson, void> $$update_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiTablesUpdateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Update tables properties.
  ///
  /// Returns a `DynamiteRequest` backing the [$update] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$update] for a method executing this request and parsing the response.
  ///  * [$$update_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$update_Request({
    required int id,
    bool? oCSAPIRequest,
    ApiTablesUpdateRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/tables/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(ApiTablesUpdateRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              ApiTablesUpdateRequestApplicationJson(),
              specifiedType: const FullType(ApiTablesUpdateRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// [api v2] Update tables properties.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$$update_Request] for the request send by this method.
  ///  * [$$update_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiTablesUpdateResponseApplicationJson, void>> $update({
    required int id,
    bool? oCSAPIRequest,
    ApiTablesUpdateRequestApplicationJson? $body,
  }) async {
    final _request = $$update_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$update_Serializer();
    return _i1.ResponseConverter<ApiTablesUpdateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$destroy_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiTablesDestroyResponseApplicationJson, void> $destroy_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ApiTablesDestroyResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Delete a table.
  ///
  /// Returns a `DynamiteRequest` backing the [destroy] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Deleted table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [destroy] for a method executing this request and parsing the response.
  ///  * [$destroy_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $destroy_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/tables/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Delete a table.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Deleted table returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$destroy_Request] for the request send by this method.
  ///  * [$destroy_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiTablesDestroyResponseApplicationJson, void>> destroy({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $destroy_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $destroy_Serializer();
    return _i1.ResponseConverter<ApiTablesDestroyResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$showScheme_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiTablesShowSchemeResponseApplicationJson, void> $showScheme_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ApiTablesShowSchemeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Get a table Scheme.
  ///
  /// Returns a `DynamiteRequest` backing the [showScheme] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Scheme returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [showScheme] for a method executing this request and parsing the response.
  ///  * [$showScheme_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $showScheme_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/tables/scheme/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Get a table Scheme.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Scheme returned
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$showScheme_Request] for the request send by this method.
  ///  * [$showScheme_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiTablesShowSchemeResponseApplicationJson, void>> showScheme({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $showScheme_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $showScheme_Serializer();
    return _i1.ResponseConverter<ApiTablesShowSchemeResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createFromScheme_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiTablesCreateFromSchemeResponseApplicationJson, void> $createFromScheme_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ApiTablesCreateFromSchemeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// creates table from scheme.
  ///
  /// Returns a `DynamiteRequest` backing the [createFromScheme] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [createFromScheme] for a method executing this request and parsing the response.
  ///  * [$createFromScheme_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createFromScheme_Request({
    required ApiTablesCreateFromSchemeRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/tables/api/2/tables/scheme';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ApiTablesCreateFromSchemeRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// creates table from scheme.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tables returned
  ///   * 500
  ///
  /// See:
  ///  * [$createFromScheme_Request] for the request send by this method.
  ///  * [$createFromScheme_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiTablesCreateFromSchemeResponseApplicationJson, void>> createFromScheme({
    required ApiTablesCreateFromSchemeRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createFromScheme_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createFromScheme_Serializer();
    return _i1.ResponseConverter<ApiTablesCreateFromSchemeResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$transfer_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiTablesTransferResponseApplicationJson, void> $transfer_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ApiTablesTransferResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Transfer table.
  ///
  /// Transfer table from one user to another.
  ///
  /// Returns a `DynamiteRequest` backing the [transfer] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership changed
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [transfer] for a method executing this request and parsing the response.
  ///  * [$transfer_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $transfer_Request({
    required int id,
    required ApiTablesTransferRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/tables/{id}/transfer').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ApiTablesTransferRequestApplicationJson)),
    );
    return _request;
  }

  /// [api v2] Transfer table.
  ///
  /// Transfer table from one user to another.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] Table ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership changed
  ///   * 403: No permissions
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$transfer_Request] for the request send by this method.
  ///  * [$transfer_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiTablesTransferResponseApplicationJson, void>> transfer({
    required int id,
    required ApiTablesTransferRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $transfer_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $transfer_Serializer();
    return _i1.ResponseConverter<ApiTablesTransferResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $ContextClient {
  /// Creates a new `DynamiteClient` for context requests.
  $ContextClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$index_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ContextIndexResponseApplicationJson, void> $index_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ContextIndexResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Get all contexts available to the requesting person.
  ///
  /// Return an empty array if no contexts were found.
  ///
  /// Returns a `DynamiteRequest` backing the [index] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: reporting in available contexts
  ///   * 500
  ///
  /// See:
  ///  * [index] for a method executing this request and parsing the response.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $index_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/tables/api/2/contexts';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Get all contexts available to the requesting person.
  ///
  /// Return an empty array if no contexts were found.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: reporting in available contexts
  ///   * 500
  ///
  /// See:
  ///  * [$index_Request] for the request send by this method.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ContextIndexResponseApplicationJson, void>> index({bool? oCSAPIRequest}) async {
    final _request = $index_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $index_Serializer();
    return _i1.ResponseConverter<ContextIndexResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$create_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ContextCreateResponseApplicationJson, void> $create_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ContextCreateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Create a new context and return it.
  ///
  /// Returns a `DynamiteRequest` backing the [create] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: returning the full context information
  ///   * 500
  ///   * 400: invalid parameters were supplied
  ///   * 403: lacking permissions on a resource
  ///
  /// See:
  ///  * [create] for a method executing this request and parsing the response.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $create_Request({
    required ContextCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/tables/api/2/contexts';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(ContextCreateRequestApplicationJson)));
    return _request;
  }

  /// [api v2] Create a new context and return it.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: returning the full context information
  ///   * 500
  ///   * 400: invalid parameters were supplied
  ///   * 403: lacking permissions on a resource
  ///
  /// See:
  ///  * [$create_Request] for the request send by this method.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ContextCreateResponseApplicationJson, void>> create({
    required ContextCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $create_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $create_Serializer();
    return _i1.ResponseConverter<ContextCreateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$$show_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ContextShowResponseApplicationJson, void> $$show_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ContextShowResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Get information about the requests context.
  ///
  /// Returns a `DynamiteRequest` backing the [$show] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: returning the full context information
  ///   * 500
  ///   * 404: context not found or not available anymore
  ///
  /// See:
  ///  * [$show] for a method executing this request and parsing the response.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$show_Request({
    required int contextId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __contextId = _$jsonSerializers.serialize(contextId, specifiedType: const FullType(int));
    _parameters['contextId'] = __contextId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/contexts/{contextId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Get information about the requests context.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: returning the full context information
  ///   * 500
  ///   * 404: context not found or not available anymore
  ///
  /// See:
  ///  * [$$show_Request] for the request send by this method.
  ///  * [$$show_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ContextShowResponseApplicationJson, void>> $show({
    required int contextId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $$show_Request(
      contextId: contextId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$show_Serializer();
    return _i1.ResponseConverter<ContextShowResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$$update_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ContextUpdateResponseApplicationJson, void> $$update_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ContextUpdateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Update an existing context and return it.
  ///
  /// Returns a `DynamiteRequest` backing the [$update] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: returning the full context information
  ///   * 500
  ///   * 404: Not found
  ///   * 403: No permissions
  ///
  /// See:
  ///  * [$update] for a method executing this request and parsing the response.
  ///  * [$$update_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$update_Request({
    required int contextId,
    bool? oCSAPIRequest,
    ContextUpdateRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __contextId = _$jsonSerializers.serialize(contextId, specifiedType: const FullType(int));
    _parameters['contextId'] = __contextId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/contexts/{contextId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(ContextUpdateRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              ContextUpdateRequestApplicationJson(),
              specifiedType: const FullType(ContextUpdateRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// [api v2] Update an existing context and return it.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: returning the full context information
  ///   * 500
  ///   * 404: Not found
  ///   * 403: No permissions
  ///
  /// See:
  ///  * [$$update_Request] for the request send by this method.
  ///  * [$$update_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ContextUpdateResponseApplicationJson, void>> $update({
    required int contextId,
    bool? oCSAPIRequest,
    ContextUpdateRequestApplicationJson? $body,
  }) async {
    final _request = $$update_Request(
      contextId: contextId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$update_Serializer();
    return _i1.ResponseConverter<ContextUpdateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$destroy_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ContextDestroyResponseApplicationJson, void> $destroy_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ContextDestroyResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Delete an existing context and return it.
  ///
  /// Returns a `DynamiteRequest` backing the [destroy] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: returning the full context information
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [destroy] for a method executing this request and parsing the response.
  ///  * [$destroy_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $destroy_Request({
    required int contextId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __contextId = _$jsonSerializers.serialize(contextId, specifiedType: const FullType(int));
    _parameters['contextId'] = __contextId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/contexts/{contextId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// [api v2] Delete an existing context and return it.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: returning the full context information
  ///   * 500
  ///   * 404: Not found
  ///
  /// See:
  ///  * [$destroy_Request] for the request send by this method.
  ///  * [$destroy_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ContextDestroyResponseApplicationJson, void>> destroy({
    required int contextId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $destroy_Request(
      contextId: contextId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $destroy_Serializer();
    return _i1.ResponseConverter<ContextDestroyResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$transfer_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ContextTransferResponseApplicationJson, void> $transfer_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ContextTransferResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Transfer the ownership of a context and return it.
  ///
  /// Returns a `DynamiteRequest` backing the [transfer] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership transferred
  ///   * 500
  ///   * 404: Not found
  ///   * 400: Invalid request
  ///
  /// See:
  ///  * [transfer] for a method executing this request and parsing the response.
  ///  * [$transfer_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $transfer_Request({
    required int contextId,
    required ContextTransferRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __contextId = _$jsonSerializers.serialize(contextId, specifiedType: const FullType(int));
    _i6.checkNumber(
      __contextId,
      'contextId',
      minimum: 0,
    );
    _parameters['contextId'] = __contextId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/contexts/{contextId}/transfer').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ContextTransferRequestApplicationJson)),
    );
    return _request;
  }

  /// [api v2] Transfer the ownership of a context and return it.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership transferred
  ///   * 500
  ///   * 404: Not found
  ///   * 400: Invalid request
  ///
  /// See:
  ///  * [$transfer_Request] for the request send by this method.
  ///  * [$transfer_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ContextTransferResponseApplicationJson, void>> transfer({
    required int contextId,
    required ContextTransferRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $transfer_Request(
      contextId: contextId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $transfer_Serializer();
    return _i1.ResponseConverter<ContextTransferResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateContentOrder_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ContextUpdateContentOrderResponseApplicationJson, void> $updateContentOrder_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ContextUpdateContentOrderResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Update the order on a page of a context.
  ///
  /// Returns a `DynamiteRequest` backing the [updateContentOrder] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [pageId] ID of the page.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: content updated successfully
  ///   * 500
  ///   * 404: Not found
  ///   * 400: Invalid request
  ///
  /// See:
  ///  * [updateContentOrder] for a method executing this request and parsing the response.
  ///  * [$updateContentOrder_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateContentOrder_Request({
    required int contextId,
    required int pageId,
    required ContextUpdateContentOrderRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __contextId = _$jsonSerializers.serialize(contextId, specifiedType: const FullType(int));
    _parameters['contextId'] = __contextId;

    final __pageId = _$jsonSerializers.serialize(pageId, specifiedType: const FullType(int));
    _parameters['pageId'] = __pageId;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/contexts/{contextId}/pages/{pageId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ContextUpdateContentOrderRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// [api v2] Update the order on a page of a context.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [contextId] ID of the context.
  ///   * [pageId] ID of the page.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: content updated successfully
  ///   * 500
  ///   * 404: Not found
  ///   * 400: Invalid request
  ///
  /// See:
  ///  * [$updateContentOrder_Request] for the request send by this method.
  ///  * [$updateContentOrder_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ContextUpdateContentOrderResponseApplicationJson, void>> updateContentOrder({
    required int contextId,
    required int pageId,
    required ContextUpdateContentOrderRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $updateContentOrder_Request(
      contextId: contextId,
      pageId: pageId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateContentOrder_Serializer();
    return _i1.ResponseConverter<ContextUpdateContentOrderResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $RowocsClient {
  /// Creates a new `DynamiteClient` for rowocs requests.
  $RowocsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$createRow_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RowocsCreateRowResponseApplicationJson, void> $createRow_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RowocsCreateRowResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// [api v2] Create a new row in a table or a view.
  ///
  /// Returns a `DynamiteRequest` backing the [createRow] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [nodeCollection] Indicates whether to create a row on a table or view.
  ///   * [nodeId] The identifier of the targeted table or view.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Row returned
  ///   * 403: No permissions
  ///   * 400: Invalid request parameters
  ///   * 404: Not found
  ///   * 500: Internal error
  ///
  /// See:
  ///  * [createRow] for a method executing this request and parsing the response.
  ///  * [$createRow_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createRow_Request({
    required RowocsCreateRowNodeCollection nodeCollection,
    required int nodeId,
    required RowocsCreateRowRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __nodeCollection =
        _$jsonSerializers.serialize(nodeCollection, specifiedType: const FullType(RowocsCreateRowNodeCollection));
    _i6.checkString(
      __nodeCollection,
      'nodeCollection',
      pattern: RegExp(r'^(tables|views)$'),
    );
    _parameters['nodeCollection'] = __nodeCollection;

    final __nodeId = _$jsonSerializers.serialize(nodeId, specifiedType: const FullType(int));
    _parameters['nodeId'] = __nodeId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/tables/api/2/{nodeCollection}/{nodeId}/rows').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RowocsCreateRowRequestApplicationJson)),
    );
    return _request;
  }

  /// [api v2] Create a new row in a table or a view.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [nodeCollection] Indicates whether to create a row on a table or view.
  ///   * [nodeId] The identifier of the targeted table or view.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Row returned
  ///   * 403: No permissions
  ///   * 400: Invalid request parameters
  ///   * 404: Not found
  ///   * 500: Internal error
  ///
  /// See:
  ///  * [$createRow_Request] for the request send by this method.
  ///  * [$createRow_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RowocsCreateRowResponseApplicationJson, void>> createRow({
    required RowocsCreateRowNodeCollection nodeCollection,
    required int nodeId,
    required RowocsCreateRowRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createRow_Request(
      nodeCollection: nodeCollection,
      nodeId: nodeId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createRow_Serializer();
    return _i1.ResponseConverter<RowocsCreateRowResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $Table_OnSharePermissionsInterface {
  bool get read;
  bool get create;
  @BuiltValueField(wireName: 'update')
  bool get $update;
  bool get delete;
  bool get manage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Table_OnSharePermissionsInterfaceBuilder].
  $Table_OnSharePermissionsInterface rebuild(void Function($Table_OnSharePermissionsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Table_OnSharePermissionsInterfaceBuilder].
  $Table_OnSharePermissionsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Table_OnSharePermissionsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Table_OnSharePermissionsInterfaceBuilder b) {}
}

abstract class Table_OnSharePermissions
    implements $Table_OnSharePermissionsInterface, Built<Table_OnSharePermissions, Table_OnSharePermissionsBuilder> {
  /// Creates a new Table_OnSharePermissions object using the builder pattern.
  factory Table_OnSharePermissions([void Function(Table_OnSharePermissionsBuilder)? b]) = _$Table_OnSharePermissions;

  // coverage:ignore-start
  const Table_OnSharePermissions._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Table_OnSharePermissions.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Table_OnSharePermissions.
  static Serializer<Table_OnSharePermissions> get serializer => _$tableOnSharePermissionsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Table_OnSharePermissionsBuilder b) {
    $Table_OnSharePermissionsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Table_OnSharePermissionsBuilder b) {
    $Table_OnSharePermissionsInterface._validate(b);
  }
}

class View_Sort_Mode extends EnumClass {
  const View_Sort_Mode._(super.name);

  /// `ASC`
  @BuiltValueEnumConst(wireName: 'ASC')
  static const View_Sort_Mode aSC = _$viewSortModeASC;

  /// `DESC`
  @BuiltValueEnumConst(wireName: 'DESC')
  static const View_Sort_Mode dESC = _$viewSortModeDESC;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<View_Sort_Mode> get values => _$viewSortModeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static View_Sort_Mode valueOf(String name) => _$valueOfView_Sort_Mode(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for View_Sort_Mode.
  @BuiltValueSerializer(custom: true)
  static Serializer<View_Sort_Mode> get serializer => const _$View_Sort_ModeSerializer();
}

class _$View_Sort_ModeSerializer implements PrimitiveSerializer<View_Sort_Mode> {
  const _$View_Sort_ModeSerializer();

  static const Map<View_Sort_Mode, Object> _toWire = <View_Sort_Mode, Object>{
    View_Sort_Mode.aSC: 'ASC',
    View_Sort_Mode.dESC: 'DESC',
  };

  static const Map<Object, View_Sort_Mode> _fromWire = <Object, View_Sort_Mode>{
    'ASC': View_Sort_Mode.aSC,
    'DESC': View_Sort_Mode.dESC,
  };

  @override
  Iterable<Type> get types => const [View_Sort_Mode];

  @override
  String get wireName => 'View_Sort_Mode';

  @override
  Object serialize(
    Serializers serializers,
    View_Sort_Mode object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  View_Sort_Mode deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $View_SortInterface {
  int get columnId;
  View_Sort_Mode get mode;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$View_SortInterfaceBuilder].
  $View_SortInterface rebuild(void Function($View_SortInterfaceBuilder) updates);

  /// Converts the instance to a builder [$View_SortInterfaceBuilder].
  $View_SortInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($View_SortInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($View_SortInterfaceBuilder b) {}
}

abstract class View_Sort implements $View_SortInterface, Built<View_Sort, View_SortBuilder> {
  /// Creates a new View_Sort object using the builder pattern.
  factory View_Sort([void Function(View_SortBuilder)? b]) = _$View_Sort;

  // coverage:ignore-start
  const View_Sort._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory View_Sort.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for View_Sort.
  static Serializer<View_Sort> get serializer => _$viewSortSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(View_SortBuilder b) {
    $View_SortInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(View_SortBuilder b) {
    $View_SortInterface._validate(b);
  }
}

class View_Filter_Operator extends EnumClass {
  const View_Filter_Operator._(super.name);

  /// `begins-with`
  @BuiltValueEnumConst(wireName: 'begins-with')
  static const View_Filter_Operator beginsWith = _$viewFilterOperatorBeginsWith;

  /// `ends-with`
  @BuiltValueEnumConst(wireName: 'ends-with')
  static const View_Filter_Operator endsWith = _$viewFilterOperatorEndsWith;

  /// `contains`
  static const View_Filter_Operator contains = _$viewFilterOperatorContains;

  /// `is-equal`
  @BuiltValueEnumConst(wireName: 'is-equal')
  static const View_Filter_Operator isEqual = _$viewFilterOperatorIsEqual;

  /// `is-greater-than`
  @BuiltValueEnumConst(wireName: 'is-greater-than')
  static const View_Filter_Operator isGreaterThan = _$viewFilterOperatorIsGreaterThan;

  /// `is-greater-than-or-equal`
  @BuiltValueEnumConst(wireName: 'is-greater-than-or-equal')
  static const View_Filter_Operator isGreaterThanOrEqual = _$viewFilterOperatorIsGreaterThanOrEqual;

  /// `is-lower-than`
  @BuiltValueEnumConst(wireName: 'is-lower-than')
  static const View_Filter_Operator isLowerThan = _$viewFilterOperatorIsLowerThan;

  /// `is-lower-than-or-equal`
  @BuiltValueEnumConst(wireName: 'is-lower-than-or-equal')
  static const View_Filter_Operator isLowerThanOrEqual = _$viewFilterOperatorIsLowerThanOrEqual;

  /// `is-empty`
  @BuiltValueEnumConst(wireName: 'is-empty')
  static const View_Filter_Operator isEmpty = _$viewFilterOperatorIsEmpty;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<View_Filter_Operator> get values => _$viewFilterOperatorValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static View_Filter_Operator valueOf(String name) => _$valueOfView_Filter_Operator(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for View_Filter_Operator.
  @BuiltValueSerializer(custom: true)
  static Serializer<View_Filter_Operator> get serializer => const _$View_Filter_OperatorSerializer();
}

class _$View_Filter_OperatorSerializer implements PrimitiveSerializer<View_Filter_Operator> {
  const _$View_Filter_OperatorSerializer();

  static const Map<View_Filter_Operator, Object> _toWire = <View_Filter_Operator, Object>{
    View_Filter_Operator.beginsWith: 'begins-with',
    View_Filter_Operator.endsWith: 'ends-with',
    View_Filter_Operator.contains: 'contains',
    View_Filter_Operator.isEqual: 'is-equal',
    View_Filter_Operator.isGreaterThan: 'is-greater-than',
    View_Filter_Operator.isGreaterThanOrEqual: 'is-greater-than-or-equal',
    View_Filter_Operator.isLowerThan: 'is-lower-than',
    View_Filter_Operator.isLowerThanOrEqual: 'is-lower-than-or-equal',
    View_Filter_Operator.isEmpty: 'is-empty',
  };

  static const Map<Object, View_Filter_Operator> _fromWire = <Object, View_Filter_Operator>{
    'begins-with': View_Filter_Operator.beginsWith,
    'ends-with': View_Filter_Operator.endsWith,
    'contains': View_Filter_Operator.contains,
    'is-equal': View_Filter_Operator.isEqual,
    'is-greater-than': View_Filter_Operator.isGreaterThan,
    'is-greater-than-or-equal': View_Filter_Operator.isGreaterThanOrEqual,
    'is-lower-than': View_Filter_Operator.isLowerThan,
    'is-lower-than-or-equal': View_Filter_Operator.isLowerThanOrEqual,
    'is-empty': View_Filter_Operator.isEmpty,
  };

  @override
  Iterable<Type> get types => const [View_Filter_Operator];

  @override
  String get wireName => 'View_Filter_Operator';

  @override
  Object serialize(
    Serializers serializers,
    View_Filter_Operator object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  View_Filter_Operator deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

typedef View_Filter_Value = ({num? $num, String? string});

@BuiltValue(instantiable: false)
sealed class $View_FilterInterface {
  int get columnId;
  @BuiltValueField(wireName: 'operator')
  View_Filter_Operator get $operator;
  View_Filter_Value get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$View_FilterInterfaceBuilder].
  $View_FilterInterface rebuild(void Function($View_FilterInterfaceBuilder) updates);

  /// Converts the instance to a builder [$View_FilterInterfaceBuilder].
  $View_FilterInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($View_FilterInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($View_FilterInterfaceBuilder b) {
    b.value?.validateAnyOf();
  }
}

abstract class View_Filter implements $View_FilterInterface, Built<View_Filter, View_FilterBuilder> {
  /// Creates a new View_Filter object using the builder pattern.
  factory View_Filter([void Function(View_FilterBuilder)? b]) = _$View_Filter;

  // coverage:ignore-start
  const View_Filter._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory View_Filter.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for View_Filter.
  static Serializer<View_Filter> get serializer => _$viewFilterSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(View_FilterBuilder b) {
    $View_FilterInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(View_FilterBuilder b) {
    $View_FilterInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $View_OnSharePermissionsInterface {
  bool get read;
  bool get create;
  @BuiltValueField(wireName: 'update')
  bool get $update;
  bool get delete;
  bool get manage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$View_OnSharePermissionsInterfaceBuilder].
  $View_OnSharePermissionsInterface rebuild(void Function($View_OnSharePermissionsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$View_OnSharePermissionsInterfaceBuilder].
  $View_OnSharePermissionsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($View_OnSharePermissionsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($View_OnSharePermissionsInterfaceBuilder b) {}
}

abstract class View_OnSharePermissions
    implements $View_OnSharePermissionsInterface, Built<View_OnSharePermissions, View_OnSharePermissionsBuilder> {
  /// Creates a new View_OnSharePermissions object using the builder pattern.
  factory View_OnSharePermissions([void Function(View_OnSharePermissionsBuilder)? b]) = _$View_OnSharePermissions;

  // coverage:ignore-start
  const View_OnSharePermissions._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory View_OnSharePermissions.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for View_OnSharePermissions.
  static Serializer<View_OnSharePermissions> get serializer => _$viewOnSharePermissionsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(View_OnSharePermissionsBuilder b) {
    $View_OnSharePermissionsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(View_OnSharePermissionsBuilder b) {
    $View_OnSharePermissionsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ViewInterface {
  int get id;
  String get title;
  String? get emoji;
  int get tableId;
  String get ownership;
  String? get ownerDisplayName;
  String get createdBy;
  String get createdAt;
  String get lastEditBy;
  String get lastEditAt;
  String? get description;
  BuiltList<int> get columns;
  BuiltList<View_Sort> get sort;
  BuiltList<BuiltList<View_Filter>> get filter;
  bool get isShared;
  bool get favorite;
  View_OnSharePermissions? get onSharePermissions;
  bool get hasShares;
  int get rowsCount;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ViewInterfaceBuilder].
  $ViewInterface rebuild(void Function($ViewInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ViewInterfaceBuilder].
  $ViewInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ViewInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ViewInterfaceBuilder b) {}
}

abstract class View implements $ViewInterface, Built<View, ViewBuilder> {
  /// Creates a new View object using the builder pattern.
  factory View([void Function(ViewBuilder)? b]) = _$View;

  // coverage:ignore-start
  const View._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory View.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for View.
  static Serializer<View> get serializer => _$viewSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ViewBuilder b) {
    $ViewInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ViewBuilder b) {
    $ViewInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TableInterface {
  int get id;
  String get title;
  String? get emoji;
  String get ownership;
  String? get ownerDisplayName;
  String get createdBy;
  String get createdAt;
  String get lastEditBy;
  String get lastEditAt;
  bool? get archived;
  bool? get favorite;
  bool get isShared;
  Table_OnSharePermissions? get onSharePermissions;
  bool get hasShares;
  int get rowsCount;
  BuiltList<View> get views;
  int get columnsCount;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TableInterfaceBuilder].
  $TableInterface rebuild(void Function($TableInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TableInterfaceBuilder].
  $TableInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TableInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TableInterfaceBuilder b) {}
}

abstract class Table implements $TableInterface, Built<Table, TableBuilder> {
  /// Creates a new Table object using the builder pattern.
  factory Table([void Function(TableBuilder)? b]) = _$Table;

  // coverage:ignore-start
  const Table._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Table.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Table.
  static Serializer<Table> get serializer => _$tableSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TableBuilder b) {
    $TableInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TableBuilder b) {
    $TableInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1CreateTableRequestApplicationJsonInterface {
  static final _$template = _$jsonSerializers.deserialize(
    'custom',
    specifiedType: const FullType(String),
  )! as String;

  /// Title of the table.
  String get title;

  /// Emoji for the table.
  String? get emoji;

  /// Template to use if wanted.
  String get template;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1CreateTableRequestApplicationJsonInterfaceBuilder].
  $Api1CreateTableRequestApplicationJsonInterface rebuild(
    void Function($Api1CreateTableRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1CreateTableRequestApplicationJsonInterfaceBuilder].
  $Api1CreateTableRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1CreateTableRequestApplicationJsonInterfaceBuilder b) {
    b.template = _$template;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1CreateTableRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1CreateTableRequestApplicationJson
    implements
        $Api1CreateTableRequestApplicationJsonInterface,
        Built<Api1CreateTableRequestApplicationJson, Api1CreateTableRequestApplicationJsonBuilder> {
  /// Creates a new Api1CreateTableRequestApplicationJson object using the builder pattern.
  factory Api1CreateTableRequestApplicationJson([void Function(Api1CreateTableRequestApplicationJsonBuilder)? b]) =
      _$Api1CreateTableRequestApplicationJson;

  // coverage:ignore-start
  const Api1CreateTableRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1CreateTableRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1CreateTableRequestApplicationJson.
  static Serializer<Api1CreateTableRequestApplicationJson> get serializer =>
      _$api1CreateTableRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1CreateTableRequestApplicationJsonBuilder b) {
    $Api1CreateTableRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1CreateTableRequestApplicationJsonBuilder b) {
    $Api1CreateTableRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateTableRequestApplicationJsonInterface {
  static final _$archived = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  /// New table title.
  String? get title;

  /// New table emoji.
  String? get emoji;

  /// Whether the table is archived.
  bool get archived;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateTableRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateTableRequestApplicationJsonInterface rebuild(
    void Function($Api1UpdateTableRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateTableRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateTableRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateTableRequestApplicationJsonInterfaceBuilder b) {
    b.archived = _$archived;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateTableRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1UpdateTableRequestApplicationJson
    implements
        $Api1UpdateTableRequestApplicationJsonInterface,
        Built<Api1UpdateTableRequestApplicationJson, Api1UpdateTableRequestApplicationJsonBuilder> {
  /// Creates a new Api1UpdateTableRequestApplicationJson object using the builder pattern.
  factory Api1UpdateTableRequestApplicationJson([void Function(Api1UpdateTableRequestApplicationJsonBuilder)? b]) =
      _$Api1UpdateTableRequestApplicationJson;

  // coverage:ignore-start
  const Api1UpdateTableRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateTableRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateTableRequestApplicationJson.
  static Serializer<Api1UpdateTableRequestApplicationJson> get serializer =>
      _$api1UpdateTableRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateTableRequestApplicationJsonBuilder b) {
    $Api1UpdateTableRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateTableRequestApplicationJsonBuilder b) {
    $Api1UpdateTableRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1Api1ShowSchemeHeadersInterface {
  @BuiltValueField(wireName: 'content-disposition')
  String? get contentDisposition;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1Api1ShowSchemeHeadersInterfaceBuilder].
  $Api1Api1ShowSchemeHeadersInterface rebuild(void Function($Api1Api1ShowSchemeHeadersInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Api1Api1ShowSchemeHeadersInterfaceBuilder].
  $Api1Api1ShowSchemeHeadersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1Api1ShowSchemeHeadersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1Api1ShowSchemeHeadersInterfaceBuilder b) {}
}

abstract class Api1Api1ShowSchemeHeaders
    implements $Api1Api1ShowSchemeHeadersInterface, Built<Api1Api1ShowSchemeHeaders, Api1Api1ShowSchemeHeadersBuilder> {
  /// Creates a new Api1Api1ShowSchemeHeaders object using the builder pattern.
  factory Api1Api1ShowSchemeHeaders([void Function(Api1Api1ShowSchemeHeadersBuilder)? b]) = _$Api1Api1ShowSchemeHeaders;

  // coverage:ignore-start
  const Api1Api1ShowSchemeHeaders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1Api1ShowSchemeHeaders.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1Api1ShowSchemeHeaders.
  static Serializer<Api1Api1ShowSchemeHeaders> get serializer => _$api1Api1ShowSchemeHeadersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1Api1ShowSchemeHeadersBuilder b) {
    $Api1Api1ShowSchemeHeadersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1Api1ShowSchemeHeadersBuilder b) {
    $Api1Api1ShowSchemeHeadersInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1CreateViewRequestApplicationJsonInterface {
  /// Title for the view.
  String get title;

  /// Emoji for the view.
  String? get emoji;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1CreateViewRequestApplicationJsonInterfaceBuilder].
  $Api1CreateViewRequestApplicationJsonInterface rebuild(
    void Function($Api1CreateViewRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1CreateViewRequestApplicationJsonInterfaceBuilder].
  $Api1CreateViewRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1CreateViewRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1CreateViewRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1CreateViewRequestApplicationJson
    implements
        $Api1CreateViewRequestApplicationJsonInterface,
        Built<Api1CreateViewRequestApplicationJson, Api1CreateViewRequestApplicationJsonBuilder> {
  /// Creates a new Api1CreateViewRequestApplicationJson object using the builder pattern.
  factory Api1CreateViewRequestApplicationJson([void Function(Api1CreateViewRequestApplicationJsonBuilder)? b]) =
      _$Api1CreateViewRequestApplicationJson;

  // coverage:ignore-start
  const Api1CreateViewRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1CreateViewRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1CreateViewRequestApplicationJson.
  static Serializer<Api1CreateViewRequestApplicationJson> get serializer =>
      _$api1CreateViewRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1CreateViewRequestApplicationJsonBuilder b) {
    $Api1CreateViewRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1CreateViewRequestApplicationJsonBuilder b) {
    $Api1CreateViewRequestApplicationJsonInterface._validate(b);
  }
}

class Api1UpdateViewRequestApplicationJson_Data0_Key extends EnumClass {
  const Api1UpdateViewRequestApplicationJson_Data0_Key._(super.name);

  /// `title`
  static const Api1UpdateViewRequestApplicationJson_Data0_Key title =
      _$api1UpdateViewRequestApplicationJsonData0KeyTitle;

  /// `emoji`
  static const Api1UpdateViewRequestApplicationJson_Data0_Key emoji =
      _$api1UpdateViewRequestApplicationJsonData0KeyEmoji;

  /// `description`
  static const Api1UpdateViewRequestApplicationJson_Data0_Key description =
      _$api1UpdateViewRequestApplicationJsonData0KeyDescription;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1UpdateViewRequestApplicationJson_Data0_Key> get values =>
      _$api1UpdateViewRequestApplicationJsonData0KeyValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1UpdateViewRequestApplicationJson_Data0_Key valueOf(String name) =>
      _$valueOfApi1UpdateViewRequestApplicationJson_Data0_Key(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data0_Key.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateViewRequestApplicationJson_Data0_Key> get serializer =>
      const _$Api1UpdateViewRequestApplicationJson_Data0_KeySerializer();
}

class _$Api1UpdateViewRequestApplicationJson_Data0_KeySerializer
    implements PrimitiveSerializer<Api1UpdateViewRequestApplicationJson_Data0_Key> {
  const _$Api1UpdateViewRequestApplicationJson_Data0_KeySerializer();

  static const Map<Api1UpdateViewRequestApplicationJson_Data0_Key, Object> _toWire =
      <Api1UpdateViewRequestApplicationJson_Data0_Key, Object>{
    Api1UpdateViewRequestApplicationJson_Data0_Key.title: 'title',
    Api1UpdateViewRequestApplicationJson_Data0_Key.emoji: 'emoji',
    Api1UpdateViewRequestApplicationJson_Data0_Key.description: 'description',
  };

  static const Map<Object, Api1UpdateViewRequestApplicationJson_Data0_Key> _fromWire =
      <Object, Api1UpdateViewRequestApplicationJson_Data0_Key>{
    'title': Api1UpdateViewRequestApplicationJson_Data0_Key.title,
    'emoji': Api1UpdateViewRequestApplicationJson_Data0_Key.emoji,
    'description': Api1UpdateViewRequestApplicationJson_Data0_Key.description,
  };

  @override
  Iterable<Type> get types => const [Api1UpdateViewRequestApplicationJson_Data0_Key];

  @override
  String get wireName => 'Api1UpdateViewRequestApplicationJson_Data0_Key';

  @override
  Object serialize(
    Serializers serializers,
    Api1UpdateViewRequestApplicationJson_Data0_Key object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1UpdateViewRequestApplicationJson_Data0_Key deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateViewRequestApplicationJson_Data0Interface {
  Api1UpdateViewRequestApplicationJson_Data0_Key get key;
  String get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateViewRequestApplicationJson_Data0InterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data0Interface rebuild(
    void Function($Api1UpdateViewRequestApplicationJson_Data0InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateViewRequestApplicationJson_Data0InterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data0InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateViewRequestApplicationJson_Data0InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateViewRequestApplicationJson_Data0InterfaceBuilder b) {}
}

abstract class Api1UpdateViewRequestApplicationJson_Data0
    implements
        $Api1UpdateViewRequestApplicationJson_Data0Interface,
        Built<Api1UpdateViewRequestApplicationJson_Data0, Api1UpdateViewRequestApplicationJson_Data0Builder> {
  /// Creates a new Api1UpdateViewRequestApplicationJson_Data0 object using the builder pattern.
  factory Api1UpdateViewRequestApplicationJson_Data0([
    void Function(Api1UpdateViewRequestApplicationJson_Data0Builder)? b,
  ]) = _$Api1UpdateViewRequestApplicationJson_Data0;

  // coverage:ignore-start
  const Api1UpdateViewRequestApplicationJson_Data0._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateViewRequestApplicationJson_Data0.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data0.
  static Serializer<Api1UpdateViewRequestApplicationJson_Data0> get serializer =>
      _$api1UpdateViewRequestApplicationJsonData0Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateViewRequestApplicationJson_Data0Builder b) {
    $Api1UpdateViewRequestApplicationJson_Data0Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateViewRequestApplicationJson_Data0Builder b) {
    $Api1UpdateViewRequestApplicationJson_Data0Interface._validate(b);
  }
}

class Api1UpdateViewRequestApplicationJson_Data1_Key extends EnumClass {
  const Api1UpdateViewRequestApplicationJson_Data1_Key._(super.name);

  /// `columns`
  static const Api1UpdateViewRequestApplicationJson_Data1_Key columns =
      _$api1UpdateViewRequestApplicationJsonData1KeyColumns;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1UpdateViewRequestApplicationJson_Data1_Key> get values =>
      _$api1UpdateViewRequestApplicationJsonData1KeyValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1UpdateViewRequestApplicationJson_Data1_Key valueOf(String name) =>
      _$valueOfApi1UpdateViewRequestApplicationJson_Data1_Key(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data1_Key.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateViewRequestApplicationJson_Data1_Key> get serializer =>
      const _$Api1UpdateViewRequestApplicationJson_Data1_KeySerializer();
}

class _$Api1UpdateViewRequestApplicationJson_Data1_KeySerializer
    implements PrimitiveSerializer<Api1UpdateViewRequestApplicationJson_Data1_Key> {
  const _$Api1UpdateViewRequestApplicationJson_Data1_KeySerializer();

  static const Map<Api1UpdateViewRequestApplicationJson_Data1_Key, Object> _toWire =
      <Api1UpdateViewRequestApplicationJson_Data1_Key, Object>{
    Api1UpdateViewRequestApplicationJson_Data1_Key.columns: 'columns',
  };

  static const Map<Object, Api1UpdateViewRequestApplicationJson_Data1_Key> _fromWire =
      <Object, Api1UpdateViewRequestApplicationJson_Data1_Key>{
    'columns': Api1UpdateViewRequestApplicationJson_Data1_Key.columns,
  };

  @override
  Iterable<Type> get types => const [Api1UpdateViewRequestApplicationJson_Data1_Key];

  @override
  String get wireName => 'Api1UpdateViewRequestApplicationJson_Data1_Key';

  @override
  Object serialize(
    Serializers serializers,
    Api1UpdateViewRequestApplicationJson_Data1_Key object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1UpdateViewRequestApplicationJson_Data1_Key deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateViewRequestApplicationJson_Data1Interface {
  Api1UpdateViewRequestApplicationJson_Data1_Key get key;
  BuiltList<int> get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateViewRequestApplicationJson_Data1InterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data1Interface rebuild(
    void Function($Api1UpdateViewRequestApplicationJson_Data1InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateViewRequestApplicationJson_Data1InterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data1InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateViewRequestApplicationJson_Data1InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateViewRequestApplicationJson_Data1InterfaceBuilder b) {}
}

abstract class Api1UpdateViewRequestApplicationJson_Data1
    implements
        $Api1UpdateViewRequestApplicationJson_Data1Interface,
        Built<Api1UpdateViewRequestApplicationJson_Data1, Api1UpdateViewRequestApplicationJson_Data1Builder> {
  /// Creates a new Api1UpdateViewRequestApplicationJson_Data1 object using the builder pattern.
  factory Api1UpdateViewRequestApplicationJson_Data1([
    void Function(Api1UpdateViewRequestApplicationJson_Data1Builder)? b,
  ]) = _$Api1UpdateViewRequestApplicationJson_Data1;

  // coverage:ignore-start
  const Api1UpdateViewRequestApplicationJson_Data1._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateViewRequestApplicationJson_Data1.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data1.
  static Serializer<Api1UpdateViewRequestApplicationJson_Data1> get serializer =>
      _$api1UpdateViewRequestApplicationJsonData1Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateViewRequestApplicationJson_Data1Builder b) {
    $Api1UpdateViewRequestApplicationJson_Data1Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateViewRequestApplicationJson_Data1Builder b) {
    $Api1UpdateViewRequestApplicationJson_Data1Interface._validate(b);
  }
}

class Api1UpdateViewRequestApplicationJson_Data2_Key extends EnumClass {
  const Api1UpdateViewRequestApplicationJson_Data2_Key._(super.name);

  /// `sort`
  static const Api1UpdateViewRequestApplicationJson_Data2_Key sort = _$api1UpdateViewRequestApplicationJsonData2KeySort;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1UpdateViewRequestApplicationJson_Data2_Key> get values =>
      _$api1UpdateViewRequestApplicationJsonData2KeyValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1UpdateViewRequestApplicationJson_Data2_Key valueOf(String name) =>
      _$valueOfApi1UpdateViewRequestApplicationJson_Data2_Key(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data2_Key.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateViewRequestApplicationJson_Data2_Key> get serializer =>
      const _$Api1UpdateViewRequestApplicationJson_Data2_KeySerializer();
}

class _$Api1UpdateViewRequestApplicationJson_Data2_KeySerializer
    implements PrimitiveSerializer<Api1UpdateViewRequestApplicationJson_Data2_Key> {
  const _$Api1UpdateViewRequestApplicationJson_Data2_KeySerializer();

  static const Map<Api1UpdateViewRequestApplicationJson_Data2_Key, Object> _toWire =
      <Api1UpdateViewRequestApplicationJson_Data2_Key, Object>{
    Api1UpdateViewRequestApplicationJson_Data2_Key.sort: 'sort',
  };

  static const Map<Object, Api1UpdateViewRequestApplicationJson_Data2_Key> _fromWire =
      <Object, Api1UpdateViewRequestApplicationJson_Data2_Key>{
    'sort': Api1UpdateViewRequestApplicationJson_Data2_Key.sort,
  };

  @override
  Iterable<Type> get types => const [Api1UpdateViewRequestApplicationJson_Data2_Key];

  @override
  String get wireName => 'Api1UpdateViewRequestApplicationJson_Data2_Key';

  @override
  Object serialize(
    Serializers serializers,
    Api1UpdateViewRequestApplicationJson_Data2_Key object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1UpdateViewRequestApplicationJson_Data2_Key deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class Api1UpdateViewRequestApplicationJson_Data2_Value_Mode extends EnumClass {
  const Api1UpdateViewRequestApplicationJson_Data2_Value_Mode._(super.name);

  /// `ASC`
  @BuiltValueEnumConst(wireName: 'ASC')
  static const Api1UpdateViewRequestApplicationJson_Data2_Value_Mode aSC =
      _$api1UpdateViewRequestApplicationJsonData2ValueModeASC;

  /// `DESC`
  @BuiltValueEnumConst(wireName: 'DESC')
  static const Api1UpdateViewRequestApplicationJson_Data2_Value_Mode dESC =
      _$api1UpdateViewRequestApplicationJsonData2ValueModeDESC;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1UpdateViewRequestApplicationJson_Data2_Value_Mode> get values =>
      _$api1UpdateViewRequestApplicationJsonData2ValueModeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1UpdateViewRequestApplicationJson_Data2_Value_Mode valueOf(String name) =>
      _$valueOfApi1UpdateViewRequestApplicationJson_Data2_Value_Mode(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data2_Value_Mode.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateViewRequestApplicationJson_Data2_Value_Mode> get serializer =>
      const _$Api1UpdateViewRequestApplicationJson_Data2_Value_ModeSerializer();
}

class _$Api1UpdateViewRequestApplicationJson_Data2_Value_ModeSerializer
    implements PrimitiveSerializer<Api1UpdateViewRequestApplicationJson_Data2_Value_Mode> {
  const _$Api1UpdateViewRequestApplicationJson_Data2_Value_ModeSerializer();

  static const Map<Api1UpdateViewRequestApplicationJson_Data2_Value_Mode, Object> _toWire =
      <Api1UpdateViewRequestApplicationJson_Data2_Value_Mode, Object>{
    Api1UpdateViewRequestApplicationJson_Data2_Value_Mode.aSC: 'ASC',
    Api1UpdateViewRequestApplicationJson_Data2_Value_Mode.dESC: 'DESC',
  };

  static const Map<Object, Api1UpdateViewRequestApplicationJson_Data2_Value_Mode> _fromWire =
      <Object, Api1UpdateViewRequestApplicationJson_Data2_Value_Mode>{
    'ASC': Api1UpdateViewRequestApplicationJson_Data2_Value_Mode.aSC,
    'DESC': Api1UpdateViewRequestApplicationJson_Data2_Value_Mode.dESC,
  };

  @override
  Iterable<Type> get types => const [Api1UpdateViewRequestApplicationJson_Data2_Value_Mode];

  @override
  String get wireName => 'Api1UpdateViewRequestApplicationJson_Data2_Value_Mode';

  @override
  Object serialize(
    Serializers serializers,
    Api1UpdateViewRequestApplicationJson_Data2_Value_Mode object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1UpdateViewRequestApplicationJson_Data2_Value_Mode deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateViewRequestApplicationJson_Data2_ValueInterface {
  int get columnId;
  Api1UpdateViewRequestApplicationJson_Data2_Value_Mode get mode;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateViewRequestApplicationJson_Data2_ValueInterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data2_ValueInterface rebuild(
    void Function($Api1UpdateViewRequestApplicationJson_Data2_ValueInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateViewRequestApplicationJson_Data2_ValueInterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data2_ValueInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateViewRequestApplicationJson_Data2_ValueInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateViewRequestApplicationJson_Data2_ValueInterfaceBuilder b) {}
}

abstract class Api1UpdateViewRequestApplicationJson_Data2_Value
    implements
        $Api1UpdateViewRequestApplicationJson_Data2_ValueInterface,
        Built<Api1UpdateViewRequestApplicationJson_Data2_Value,
            Api1UpdateViewRequestApplicationJson_Data2_ValueBuilder> {
  /// Creates a new Api1UpdateViewRequestApplicationJson_Data2_Value object using the builder pattern.
  factory Api1UpdateViewRequestApplicationJson_Data2_Value([
    void Function(Api1UpdateViewRequestApplicationJson_Data2_ValueBuilder)? b,
  ]) = _$Api1UpdateViewRequestApplicationJson_Data2_Value;

  // coverage:ignore-start
  const Api1UpdateViewRequestApplicationJson_Data2_Value._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateViewRequestApplicationJson_Data2_Value.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data2_Value.
  static Serializer<Api1UpdateViewRequestApplicationJson_Data2_Value> get serializer =>
      _$api1UpdateViewRequestApplicationJsonData2ValueSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateViewRequestApplicationJson_Data2_ValueBuilder b) {
    $Api1UpdateViewRequestApplicationJson_Data2_ValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateViewRequestApplicationJson_Data2_ValueBuilder b) {
    $Api1UpdateViewRequestApplicationJson_Data2_ValueInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateViewRequestApplicationJson_Data2Interface {
  Api1UpdateViewRequestApplicationJson_Data2_Key get key;
  Api1UpdateViewRequestApplicationJson_Data2_Value get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateViewRequestApplicationJson_Data2InterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data2Interface rebuild(
    void Function($Api1UpdateViewRequestApplicationJson_Data2InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateViewRequestApplicationJson_Data2InterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data2InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateViewRequestApplicationJson_Data2InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateViewRequestApplicationJson_Data2InterfaceBuilder b) {}
}

abstract class Api1UpdateViewRequestApplicationJson_Data2
    implements
        $Api1UpdateViewRequestApplicationJson_Data2Interface,
        Built<Api1UpdateViewRequestApplicationJson_Data2, Api1UpdateViewRequestApplicationJson_Data2Builder> {
  /// Creates a new Api1UpdateViewRequestApplicationJson_Data2 object using the builder pattern.
  factory Api1UpdateViewRequestApplicationJson_Data2([
    void Function(Api1UpdateViewRequestApplicationJson_Data2Builder)? b,
  ]) = _$Api1UpdateViewRequestApplicationJson_Data2;

  // coverage:ignore-start
  const Api1UpdateViewRequestApplicationJson_Data2._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateViewRequestApplicationJson_Data2.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data2.
  static Serializer<Api1UpdateViewRequestApplicationJson_Data2> get serializer =>
      _$api1UpdateViewRequestApplicationJsonData2Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateViewRequestApplicationJson_Data2Builder b) {
    $Api1UpdateViewRequestApplicationJson_Data2Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateViewRequestApplicationJson_Data2Builder b) {
    $Api1UpdateViewRequestApplicationJson_Data2Interface._validate(b);
  }
}

class Api1UpdateViewRequestApplicationJson_Data3_Key extends EnumClass {
  const Api1UpdateViewRequestApplicationJson_Data3_Key._(super.name);

  /// `filter`
  static const Api1UpdateViewRequestApplicationJson_Data3_Key filter =
      _$api1UpdateViewRequestApplicationJsonData3KeyFilter;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1UpdateViewRequestApplicationJson_Data3_Key> get values =>
      _$api1UpdateViewRequestApplicationJsonData3KeyValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1UpdateViewRequestApplicationJson_Data3_Key valueOf(String name) =>
      _$valueOfApi1UpdateViewRequestApplicationJson_Data3_Key(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data3_Key.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateViewRequestApplicationJson_Data3_Key> get serializer =>
      const _$Api1UpdateViewRequestApplicationJson_Data3_KeySerializer();
}

class _$Api1UpdateViewRequestApplicationJson_Data3_KeySerializer
    implements PrimitiveSerializer<Api1UpdateViewRequestApplicationJson_Data3_Key> {
  const _$Api1UpdateViewRequestApplicationJson_Data3_KeySerializer();

  static const Map<Api1UpdateViewRequestApplicationJson_Data3_Key, Object> _toWire =
      <Api1UpdateViewRequestApplicationJson_Data3_Key, Object>{
    Api1UpdateViewRequestApplicationJson_Data3_Key.filter: 'filter',
  };

  static const Map<Object, Api1UpdateViewRequestApplicationJson_Data3_Key> _fromWire =
      <Object, Api1UpdateViewRequestApplicationJson_Data3_Key>{
    'filter': Api1UpdateViewRequestApplicationJson_Data3_Key.filter,
  };

  @override
  Iterable<Type> get types => const [Api1UpdateViewRequestApplicationJson_Data3_Key];

  @override
  String get wireName => 'Api1UpdateViewRequestApplicationJson_Data3_Key';

  @override
  Object serialize(
    Serializers serializers,
    Api1UpdateViewRequestApplicationJson_Data3_Key object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1UpdateViewRequestApplicationJson_Data3_Key deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class Api1UpdateViewRequestApplicationJson_Data3_Value_Operator extends EnumClass {
  const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator._(super.name);

  /// `begins-with`
  @BuiltValueEnumConst(wireName: 'begins-with')
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator beginsWith =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorBeginsWith;

  /// `ends-with`
  @BuiltValueEnumConst(wireName: 'ends-with')
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator endsWith =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorEndsWith;

  /// `contains`
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator contains =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorContains;

  /// `is-equal`
  @BuiltValueEnumConst(wireName: 'is-equal')
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator isEqual =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorIsEqual;

  /// `is-greater-than`
  @BuiltValueEnumConst(wireName: 'is-greater-than')
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator isGreaterThan =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorIsGreaterThan;

  /// `is-greater-than-or-equal`
  @BuiltValueEnumConst(wireName: 'is-greater-than-or-equal')
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator isGreaterThanOrEqual =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorIsGreaterThanOrEqual;

  /// `is-lower-than`
  @BuiltValueEnumConst(wireName: 'is-lower-than')
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator isLowerThan =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorIsLowerThan;

  /// `is-lower-than-or-equal`
  @BuiltValueEnumConst(wireName: 'is-lower-than-or-equal')
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator isLowerThanOrEqual =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorIsLowerThanOrEqual;

  /// `is-empty`
  @BuiltValueEnumConst(wireName: 'is-empty')
  static const Api1UpdateViewRequestApplicationJson_Data3_Value_Operator isEmpty =
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorIsEmpty;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1UpdateViewRequestApplicationJson_Data3_Value_Operator> get values =>
      _$api1UpdateViewRequestApplicationJsonData3ValueOperatorValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1UpdateViewRequestApplicationJson_Data3_Value_Operator valueOf(String name) =>
      _$valueOfApi1UpdateViewRequestApplicationJson_Data3_Value_Operator(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateViewRequestApplicationJson_Data3_Value_Operator> get serializer =>
      const _$Api1UpdateViewRequestApplicationJson_Data3_Value_OperatorSerializer();
}

class _$Api1UpdateViewRequestApplicationJson_Data3_Value_OperatorSerializer
    implements PrimitiveSerializer<Api1UpdateViewRequestApplicationJson_Data3_Value_Operator> {
  const _$Api1UpdateViewRequestApplicationJson_Data3_Value_OperatorSerializer();

  static const Map<Api1UpdateViewRequestApplicationJson_Data3_Value_Operator, Object> _toWire =
      <Api1UpdateViewRequestApplicationJson_Data3_Value_Operator, Object>{
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.beginsWith: 'begins-with',
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.endsWith: 'ends-with',
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.contains: 'contains',
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isEqual: 'is-equal',
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isGreaterThan: 'is-greater-than',
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isGreaterThanOrEqual: 'is-greater-than-or-equal',
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isLowerThan: 'is-lower-than',
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isLowerThanOrEqual: 'is-lower-than-or-equal',
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isEmpty: 'is-empty',
  };

  static const Map<Object, Api1UpdateViewRequestApplicationJson_Data3_Value_Operator> _fromWire =
      <Object, Api1UpdateViewRequestApplicationJson_Data3_Value_Operator>{
    'begins-with': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.beginsWith,
    'ends-with': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.endsWith,
    'contains': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.contains,
    'is-equal': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isEqual,
    'is-greater-than': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isGreaterThan,
    'is-greater-than-or-equal': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isGreaterThanOrEqual,
    'is-lower-than': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isLowerThan,
    'is-lower-than-or-equal': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isLowerThanOrEqual,
    'is-empty': Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.isEmpty,
  };

  @override
  Iterable<Type> get types => const [Api1UpdateViewRequestApplicationJson_Data3_Value_Operator];

  @override
  String get wireName => 'Api1UpdateViewRequestApplicationJson_Data3_Value_Operator';

  @override
  Object serialize(
    Serializers serializers,
    Api1UpdateViewRequestApplicationJson_Data3_Value_Operator object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1UpdateViewRequestApplicationJson_Data3_Value_Operator deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

typedef Api1UpdateViewRequestApplicationJson_Data3_Value_Value = ({num? $num, String? string});

@BuiltValue(instantiable: false)
sealed class $Api1UpdateViewRequestApplicationJson_Data3_ValueInterface {
  int get columnId;
  @BuiltValueField(wireName: 'operator')
  Api1UpdateViewRequestApplicationJson_Data3_Value_Operator get $operator;
  Api1UpdateViewRequestApplicationJson_Data3_Value_Value get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateViewRequestApplicationJson_Data3_ValueInterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data3_ValueInterface rebuild(
    void Function($Api1UpdateViewRequestApplicationJson_Data3_ValueInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateViewRequestApplicationJson_Data3_ValueInterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data3_ValueInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateViewRequestApplicationJson_Data3_ValueInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateViewRequestApplicationJson_Data3_ValueInterfaceBuilder b) {
    b.value?.validateAnyOf();
  }
}

abstract class Api1UpdateViewRequestApplicationJson_Data3_Value
    implements
        $Api1UpdateViewRequestApplicationJson_Data3_ValueInterface,
        Built<Api1UpdateViewRequestApplicationJson_Data3_Value,
            Api1UpdateViewRequestApplicationJson_Data3_ValueBuilder> {
  /// Creates a new Api1UpdateViewRequestApplicationJson_Data3_Value object using the builder pattern.
  factory Api1UpdateViewRequestApplicationJson_Data3_Value([
    void Function(Api1UpdateViewRequestApplicationJson_Data3_ValueBuilder)? b,
  ]) = _$Api1UpdateViewRequestApplicationJson_Data3_Value;

  // coverage:ignore-start
  const Api1UpdateViewRequestApplicationJson_Data3_Value._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateViewRequestApplicationJson_Data3_Value.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data3_Value.
  static Serializer<Api1UpdateViewRequestApplicationJson_Data3_Value> get serializer =>
      _$api1UpdateViewRequestApplicationJsonData3ValueSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateViewRequestApplicationJson_Data3_ValueBuilder b) {
    $Api1UpdateViewRequestApplicationJson_Data3_ValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateViewRequestApplicationJson_Data3_ValueBuilder b) {
    $Api1UpdateViewRequestApplicationJson_Data3_ValueInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateViewRequestApplicationJson_Data3Interface {
  Api1UpdateViewRequestApplicationJson_Data3_Key get key;
  Api1UpdateViewRequestApplicationJson_Data3_Value get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateViewRequestApplicationJson_Data3InterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data3Interface rebuild(
    void Function($Api1UpdateViewRequestApplicationJson_Data3InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateViewRequestApplicationJson_Data3InterfaceBuilder].
  $Api1UpdateViewRequestApplicationJson_Data3InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateViewRequestApplicationJson_Data3InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateViewRequestApplicationJson_Data3InterfaceBuilder b) {}
}

abstract class Api1UpdateViewRequestApplicationJson_Data3
    implements
        $Api1UpdateViewRequestApplicationJson_Data3Interface,
        Built<Api1UpdateViewRequestApplicationJson_Data3, Api1UpdateViewRequestApplicationJson_Data3Builder> {
  /// Creates a new Api1UpdateViewRequestApplicationJson_Data3 object using the builder pattern.
  factory Api1UpdateViewRequestApplicationJson_Data3([
    void Function(Api1UpdateViewRequestApplicationJson_Data3Builder)? b,
  ]) = _$Api1UpdateViewRequestApplicationJson_Data3;

  // coverage:ignore-start
  const Api1UpdateViewRequestApplicationJson_Data3._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateViewRequestApplicationJson_Data3.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateViewRequestApplicationJson_Data3.
  static Serializer<Api1UpdateViewRequestApplicationJson_Data3> get serializer =>
      _$api1UpdateViewRequestApplicationJsonData3Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateViewRequestApplicationJson_Data3Builder b) {
    $Api1UpdateViewRequestApplicationJson_Data3Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateViewRequestApplicationJson_Data3Builder b) {
    $Api1UpdateViewRequestApplicationJson_Data3Interface._validate(b);
  }
}

/// key-value pairs.
typedef Api1UpdateViewRequestApplicationJson_Data = ({
  Api1UpdateViewRequestApplicationJson_Data0? api1UpdateViewRequestApplicationJsonData0,
  Api1UpdateViewRequestApplicationJson_Data1? api1UpdateViewRequestApplicationJsonData1,
  Api1UpdateViewRequestApplicationJson_Data2? api1UpdateViewRequestApplicationJsonData2,
  Api1UpdateViewRequestApplicationJson_Data3? api1UpdateViewRequestApplicationJsonData3
});

@BuiltValue(instantiable: false)
sealed class $Api1UpdateViewRequestApplicationJsonInterface {
  /// key-value pairs.
  Api1UpdateViewRequestApplicationJson_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateViewRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateViewRequestApplicationJsonInterface rebuild(
    void Function($Api1UpdateViewRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateViewRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateViewRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateViewRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateViewRequestApplicationJsonInterfaceBuilder b) {
    b.data?.validateAnyOf();
  }
}

abstract class Api1UpdateViewRequestApplicationJson
    implements
        $Api1UpdateViewRequestApplicationJsonInterface,
        Built<Api1UpdateViewRequestApplicationJson, Api1UpdateViewRequestApplicationJsonBuilder> {
  /// Creates a new Api1UpdateViewRequestApplicationJson object using the builder pattern.
  factory Api1UpdateViewRequestApplicationJson([void Function(Api1UpdateViewRequestApplicationJsonBuilder)? b]) =
      _$Api1UpdateViewRequestApplicationJson;

  // coverage:ignore-start
  const Api1UpdateViewRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateViewRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateViewRequestApplicationJson.
  static Serializer<Api1UpdateViewRequestApplicationJson> get serializer =>
      _$api1UpdateViewRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateViewRequestApplicationJsonBuilder b) {
    $Api1UpdateViewRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateViewRequestApplicationJsonBuilder b) {
    $Api1UpdateViewRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareInterface {
  int get id;
  String get sender;
  String get receiver;
  String get receiverDisplayName;
  String get receiverType;
  int get nodeId;
  String get nodeType;
  bool get permissionRead;
  bool get permissionCreate;
  bool get permissionUpdate;
  bool get permissionDelete;
  bool get permissionManage;
  String get createdAt;
  String get createdBy;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareInterfaceBuilder].
  $ShareInterface rebuild(void Function($ShareInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareInterfaceBuilder].
  $ShareInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareInterfaceBuilder b) {}
}

abstract class Share implements $ShareInterface, Built<Share, ShareBuilder> {
  /// Creates a new Share object using the builder pattern.
  factory Share([void Function(ShareBuilder)? b]) = _$Share;

  // coverage:ignore-start
  const Share._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Share.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Share.
  static Serializer<Share> get serializer => _$shareSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareBuilder b) {
    $ShareInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareBuilder b) {
    $ShareInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateSharePermissionsRequestApplicationJsonInterface {
  /// Permission type that should be changed.
  String get permissionType;

  /// New permission value.
  bool get permissionValue;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateSharePermissionsRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateSharePermissionsRequestApplicationJsonInterface rebuild(
    void Function($Api1UpdateSharePermissionsRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateSharePermissionsRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateSharePermissionsRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateSharePermissionsRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateSharePermissionsRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1UpdateSharePermissionsRequestApplicationJson
    implements
        $Api1UpdateSharePermissionsRequestApplicationJsonInterface,
        Built<Api1UpdateSharePermissionsRequestApplicationJson,
            Api1UpdateSharePermissionsRequestApplicationJsonBuilder> {
  /// Creates a new Api1UpdateSharePermissionsRequestApplicationJson object using the builder pattern.
  factory Api1UpdateSharePermissionsRequestApplicationJson([
    void Function(Api1UpdateSharePermissionsRequestApplicationJsonBuilder)? b,
  ]) = _$Api1UpdateSharePermissionsRequestApplicationJson;

  // coverage:ignore-start
  const Api1UpdateSharePermissionsRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateSharePermissionsRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateSharePermissionsRequestApplicationJson.
  static Serializer<Api1UpdateSharePermissionsRequestApplicationJson> get serializer =>
      _$api1UpdateSharePermissionsRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateSharePermissionsRequestApplicationJsonBuilder b) {
    $Api1UpdateSharePermissionsRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateSharePermissionsRequestApplicationJsonBuilder b) {
    $Api1UpdateSharePermissionsRequestApplicationJsonInterface._validate(b);
  }
}

/// Receiver type.
class Api1CreateTableShareRequestApplicationJson_ReceiverType extends EnumClass {
  const Api1CreateTableShareRequestApplicationJson_ReceiverType._(super.name);

  /// `user`
  static const Api1CreateTableShareRequestApplicationJson_ReceiverType user =
      _$api1CreateTableShareRequestApplicationJsonReceiverTypeUser;

  /// `group`
  static const Api1CreateTableShareRequestApplicationJson_ReceiverType group =
      _$api1CreateTableShareRequestApplicationJsonReceiverTypeGroup;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1CreateTableShareRequestApplicationJson_ReceiverType> get values =>
      _$api1CreateTableShareRequestApplicationJsonReceiverTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1CreateTableShareRequestApplicationJson_ReceiverType valueOf(String name) =>
      _$valueOfApi1CreateTableShareRequestApplicationJson_ReceiverType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1CreateTableShareRequestApplicationJson_ReceiverType.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1CreateTableShareRequestApplicationJson_ReceiverType> get serializer =>
      const _$Api1CreateTableShareRequestApplicationJson_ReceiverTypeSerializer();
}

class _$Api1CreateTableShareRequestApplicationJson_ReceiverTypeSerializer
    implements PrimitiveSerializer<Api1CreateTableShareRequestApplicationJson_ReceiverType> {
  const _$Api1CreateTableShareRequestApplicationJson_ReceiverTypeSerializer();

  static const Map<Api1CreateTableShareRequestApplicationJson_ReceiverType, Object> _toWire =
      <Api1CreateTableShareRequestApplicationJson_ReceiverType, Object>{
    Api1CreateTableShareRequestApplicationJson_ReceiverType.user: 'user',
    Api1CreateTableShareRequestApplicationJson_ReceiverType.group: 'group',
  };

  static const Map<Object, Api1CreateTableShareRequestApplicationJson_ReceiverType> _fromWire =
      <Object, Api1CreateTableShareRequestApplicationJson_ReceiverType>{
    'user': Api1CreateTableShareRequestApplicationJson_ReceiverType.user,
    'group': Api1CreateTableShareRequestApplicationJson_ReceiverType.group,
  };

  @override
  Iterable<Type> get types => const [Api1CreateTableShareRequestApplicationJson_ReceiverType];

  @override
  String get wireName => 'Api1CreateTableShareRequestApplicationJson_ReceiverType';

  @override
  Object serialize(
    Serializers serializers,
    Api1CreateTableShareRequestApplicationJson_ReceiverType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1CreateTableShareRequestApplicationJson_ReceiverType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Api1CreateTableShareRequestApplicationJsonInterface {
  /// Receiver ID.
  String get receiver;

  /// Receiver type.
  Api1CreateTableShareRequestApplicationJson_ReceiverType get receiverType;

  /// Permission if receiver can read data.
  bool get permissionRead;

  /// Permission if receiver can create data.
  bool get permissionCreate;

  /// Permission if receiver can update data.
  bool get permissionUpdate;

  /// Permission if receiver can delete data.
  bool get permissionDelete;

  /// Permission if receiver can manage table.
  bool get permissionManage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1CreateTableShareRequestApplicationJsonInterfaceBuilder].
  $Api1CreateTableShareRequestApplicationJsonInterface rebuild(
    void Function($Api1CreateTableShareRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1CreateTableShareRequestApplicationJsonInterfaceBuilder].
  $Api1CreateTableShareRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1CreateTableShareRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1CreateTableShareRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1CreateTableShareRequestApplicationJson
    implements
        $Api1CreateTableShareRequestApplicationJsonInterface,
        Built<Api1CreateTableShareRequestApplicationJson, Api1CreateTableShareRequestApplicationJsonBuilder> {
  /// Creates a new Api1CreateTableShareRequestApplicationJson object using the builder pattern.
  factory Api1CreateTableShareRequestApplicationJson([
    void Function(Api1CreateTableShareRequestApplicationJsonBuilder)? b,
  ]) = _$Api1CreateTableShareRequestApplicationJson;

  // coverage:ignore-start
  const Api1CreateTableShareRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1CreateTableShareRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1CreateTableShareRequestApplicationJson.
  static Serializer<Api1CreateTableShareRequestApplicationJson> get serializer =>
      _$api1CreateTableShareRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1CreateTableShareRequestApplicationJsonBuilder b) {
    $Api1CreateTableShareRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1CreateTableShareRequestApplicationJsonBuilder b) {
    $Api1CreateTableShareRequestApplicationJsonInterface._validate(b);
  }
}

/// Node type.
class Api1CreateShareRequestApplicationJson_NodeType extends EnumClass {
  const Api1CreateShareRequestApplicationJson_NodeType._(super.name);

  /// `table`
  static const Api1CreateShareRequestApplicationJson_NodeType table =
      _$api1CreateShareRequestApplicationJsonNodeTypeTable;

  /// `view`
  static const Api1CreateShareRequestApplicationJson_NodeType view =
      _$api1CreateShareRequestApplicationJsonNodeTypeView;

  /// `context`
  static const Api1CreateShareRequestApplicationJson_NodeType context =
      _$api1CreateShareRequestApplicationJsonNodeTypeContext;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1CreateShareRequestApplicationJson_NodeType> get values =>
      _$api1CreateShareRequestApplicationJsonNodeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1CreateShareRequestApplicationJson_NodeType valueOf(String name) =>
      _$valueOfApi1CreateShareRequestApplicationJson_NodeType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1CreateShareRequestApplicationJson_NodeType.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1CreateShareRequestApplicationJson_NodeType> get serializer =>
      const _$Api1CreateShareRequestApplicationJson_NodeTypeSerializer();
}

class _$Api1CreateShareRequestApplicationJson_NodeTypeSerializer
    implements PrimitiveSerializer<Api1CreateShareRequestApplicationJson_NodeType> {
  const _$Api1CreateShareRequestApplicationJson_NodeTypeSerializer();

  static const Map<Api1CreateShareRequestApplicationJson_NodeType, Object> _toWire =
      <Api1CreateShareRequestApplicationJson_NodeType, Object>{
    Api1CreateShareRequestApplicationJson_NodeType.table: 'table',
    Api1CreateShareRequestApplicationJson_NodeType.view: 'view',
    Api1CreateShareRequestApplicationJson_NodeType.context: 'context',
  };

  static const Map<Object, Api1CreateShareRequestApplicationJson_NodeType> _fromWire =
      <Object, Api1CreateShareRequestApplicationJson_NodeType>{
    'table': Api1CreateShareRequestApplicationJson_NodeType.table,
    'view': Api1CreateShareRequestApplicationJson_NodeType.view,
    'context': Api1CreateShareRequestApplicationJson_NodeType.context,
  };

  @override
  Iterable<Type> get types => const [Api1CreateShareRequestApplicationJson_NodeType];

  @override
  String get wireName => 'Api1CreateShareRequestApplicationJson_NodeType';

  @override
  Object serialize(
    Serializers serializers,
    Api1CreateShareRequestApplicationJson_NodeType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1CreateShareRequestApplicationJson_NodeType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// Receiver type.
class Api1CreateShareRequestApplicationJson_ReceiverType extends EnumClass {
  const Api1CreateShareRequestApplicationJson_ReceiverType._(super.name);

  /// `user`
  static const Api1CreateShareRequestApplicationJson_ReceiverType user =
      _$api1CreateShareRequestApplicationJsonReceiverTypeUser;

  /// `group`
  static const Api1CreateShareRequestApplicationJson_ReceiverType group =
      _$api1CreateShareRequestApplicationJsonReceiverTypeGroup;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1CreateShareRequestApplicationJson_ReceiverType> get values =>
      _$api1CreateShareRequestApplicationJsonReceiverTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1CreateShareRequestApplicationJson_ReceiverType valueOf(String name) =>
      _$valueOfApi1CreateShareRequestApplicationJson_ReceiverType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1CreateShareRequestApplicationJson_ReceiverType.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1CreateShareRequestApplicationJson_ReceiverType> get serializer =>
      const _$Api1CreateShareRequestApplicationJson_ReceiverTypeSerializer();
}

class _$Api1CreateShareRequestApplicationJson_ReceiverTypeSerializer
    implements PrimitiveSerializer<Api1CreateShareRequestApplicationJson_ReceiverType> {
  const _$Api1CreateShareRequestApplicationJson_ReceiverTypeSerializer();

  static const Map<Api1CreateShareRequestApplicationJson_ReceiverType, Object> _toWire =
      <Api1CreateShareRequestApplicationJson_ReceiverType, Object>{
    Api1CreateShareRequestApplicationJson_ReceiverType.user: 'user',
    Api1CreateShareRequestApplicationJson_ReceiverType.group: 'group',
  };

  static const Map<Object, Api1CreateShareRequestApplicationJson_ReceiverType> _fromWire =
      <Object, Api1CreateShareRequestApplicationJson_ReceiverType>{
    'user': Api1CreateShareRequestApplicationJson_ReceiverType.user,
    'group': Api1CreateShareRequestApplicationJson_ReceiverType.group,
  };

  @override
  Iterable<Type> get types => const [Api1CreateShareRequestApplicationJson_ReceiverType];

  @override
  String get wireName => 'Api1CreateShareRequestApplicationJson_ReceiverType';

  @override
  Object serialize(
    Serializers serializers,
    Api1CreateShareRequestApplicationJson_ReceiverType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1CreateShareRequestApplicationJson_ReceiverType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Api1CreateShareRequestApplicationJsonInterface {
  static final _$permissionRead = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$permissionCreate = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$permissionUpdate = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$permissionDelete = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$permissionManage = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$displayMode = _$jsonSerializers.deserialize(
    0,
    specifiedType: const FullType(int),
  )! as int;

  /// Node ID.
  int get nodeId;

  /// Node type.
  Api1CreateShareRequestApplicationJson_NodeType get nodeType;

  /// Receiver ID.
  String get receiver;

  /// Receiver type.
  Api1CreateShareRequestApplicationJson_ReceiverType get receiverType;

  /// Permission if receiver can read data.
  bool get permissionRead;

  /// Permission if receiver can create data.
  bool get permissionCreate;

  /// Permission if receiver can update data.
  bool get permissionUpdate;

  /// Permission if receiver can delete data.
  bool get permissionDelete;

  /// Permission if receiver can manage node.
  bool get permissionManage;

  /// context shares only, whether it should appear in nav bar. 0: no, 1: recipients, 2: all.
  int get displayMode;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1CreateShareRequestApplicationJsonInterfaceBuilder].
  $Api1CreateShareRequestApplicationJsonInterface rebuild(
    void Function($Api1CreateShareRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1CreateShareRequestApplicationJsonInterfaceBuilder].
  $Api1CreateShareRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1CreateShareRequestApplicationJsonInterfaceBuilder b) {
    b.permissionRead = _$permissionRead;
    b.permissionCreate = _$permissionCreate;
    b.permissionUpdate = _$permissionUpdate;
    b.permissionDelete = _$permissionDelete;
    b.permissionManage = _$permissionManage;
    b.displayMode = _$displayMode;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1CreateShareRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1CreateShareRequestApplicationJson
    implements
        $Api1CreateShareRequestApplicationJsonInterface,
        Built<Api1CreateShareRequestApplicationJson, Api1CreateShareRequestApplicationJsonBuilder> {
  /// Creates a new Api1CreateShareRequestApplicationJson object using the builder pattern.
  factory Api1CreateShareRequestApplicationJson([void Function(Api1CreateShareRequestApplicationJsonBuilder)? b]) =
      _$Api1CreateShareRequestApplicationJson;

  // coverage:ignore-start
  const Api1CreateShareRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1CreateShareRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1CreateShareRequestApplicationJson.
  static Serializer<Api1CreateShareRequestApplicationJson> get serializer =>
      _$api1CreateShareRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1CreateShareRequestApplicationJsonBuilder b) {
    $Api1CreateShareRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1CreateShareRequestApplicationJsonBuilder b) {
    $Api1CreateShareRequestApplicationJsonInterface._validate(b);
  }
}

/// "default" to set the default, "self" to set an override for the authenticated user.
class Api1UpdateShareDisplayModeRequestApplicationJson_Target extends EnumClass {
  const Api1UpdateShareDisplayModeRequestApplicationJson_Target._(super.name);

  /// `default`
  @BuiltValueEnumConst(wireName: 'default')
  static const Api1UpdateShareDisplayModeRequestApplicationJson_Target $default =
      _$api1UpdateShareDisplayModeRequestApplicationJsonTarget$default;

  /// `self`
  static const Api1UpdateShareDisplayModeRequestApplicationJson_Target self =
      _$api1UpdateShareDisplayModeRequestApplicationJsonTargetSelf;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1UpdateShareDisplayModeRequestApplicationJson_Target> get values =>
      _$api1UpdateShareDisplayModeRequestApplicationJsonTargetValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1UpdateShareDisplayModeRequestApplicationJson_Target valueOf(String name) =>
      _$valueOfApi1UpdateShareDisplayModeRequestApplicationJson_Target(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1UpdateShareDisplayModeRequestApplicationJson_Target.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateShareDisplayModeRequestApplicationJson_Target> get serializer =>
      const _$Api1UpdateShareDisplayModeRequestApplicationJson_TargetSerializer();
}

class _$Api1UpdateShareDisplayModeRequestApplicationJson_TargetSerializer
    implements PrimitiveSerializer<Api1UpdateShareDisplayModeRequestApplicationJson_Target> {
  const _$Api1UpdateShareDisplayModeRequestApplicationJson_TargetSerializer();

  static const Map<Api1UpdateShareDisplayModeRequestApplicationJson_Target, Object> _toWire =
      <Api1UpdateShareDisplayModeRequestApplicationJson_Target, Object>{
    Api1UpdateShareDisplayModeRequestApplicationJson_Target.$default: 'default',
    Api1UpdateShareDisplayModeRequestApplicationJson_Target.self: 'self',
  };

  static const Map<Object, Api1UpdateShareDisplayModeRequestApplicationJson_Target> _fromWire =
      <Object, Api1UpdateShareDisplayModeRequestApplicationJson_Target>{
    'default': Api1UpdateShareDisplayModeRequestApplicationJson_Target.$default,
    'self': Api1UpdateShareDisplayModeRequestApplicationJson_Target.self,
  };

  @override
  Iterable<Type> get types => const [Api1UpdateShareDisplayModeRequestApplicationJson_Target];

  @override
  String get wireName => 'Api1UpdateShareDisplayModeRequestApplicationJson_Target';

  @override
  Object serialize(
    Serializers serializers,
    Api1UpdateShareDisplayModeRequestApplicationJson_Target object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1UpdateShareDisplayModeRequestApplicationJson_Target deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateShareDisplayModeRequestApplicationJsonInterface {
  static final _$target = _$jsonSerializers.deserialize(
    'default',
    specifiedType: const FullType(Api1UpdateShareDisplayModeRequestApplicationJson_Target),
  )! as Api1UpdateShareDisplayModeRequestApplicationJson_Target;

  /// The new value for the display mode of the nav bar icon. 0: hidden, 1: visible for recipients, 2: visible for all.
  int get displayMode;

  /// "default" to set the default, "self" to set an override for the authenticated user.
  Api1UpdateShareDisplayModeRequestApplicationJson_Target get target;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateShareDisplayModeRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateShareDisplayModeRequestApplicationJsonInterface rebuild(
    void Function($Api1UpdateShareDisplayModeRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateShareDisplayModeRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateShareDisplayModeRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateShareDisplayModeRequestApplicationJsonInterfaceBuilder b) {
    b.target = _$target;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateShareDisplayModeRequestApplicationJsonInterfaceBuilder b) {
    _i6.checkNumber(
      b.displayMode,
      'displayMode',
      maximum: 2,
      minimum: 0,
    );
  }
}

abstract class Api1UpdateShareDisplayModeRequestApplicationJson
    implements
        $Api1UpdateShareDisplayModeRequestApplicationJsonInterface,
        Built<Api1UpdateShareDisplayModeRequestApplicationJson,
            Api1UpdateShareDisplayModeRequestApplicationJsonBuilder> {
  /// Creates a new Api1UpdateShareDisplayModeRequestApplicationJson object using the builder pattern.
  factory Api1UpdateShareDisplayModeRequestApplicationJson([
    void Function(Api1UpdateShareDisplayModeRequestApplicationJsonBuilder)? b,
  ]) = _$Api1UpdateShareDisplayModeRequestApplicationJson;

  // coverage:ignore-start
  const Api1UpdateShareDisplayModeRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateShareDisplayModeRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateShareDisplayModeRequestApplicationJson.
  static Serializer<Api1UpdateShareDisplayModeRequestApplicationJson> get serializer =>
      _$api1UpdateShareDisplayModeRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateShareDisplayModeRequestApplicationJsonBuilder b) {
    $Api1UpdateShareDisplayModeRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateShareDisplayModeRequestApplicationJsonBuilder b) {
    $Api1UpdateShareDisplayModeRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextNavigationInterface {
  int get id;
  int get shareId;
  int get displayMode;
  String get userId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextNavigationInterfaceBuilder].
  $ContextNavigationInterface rebuild(void Function($ContextNavigationInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ContextNavigationInterfaceBuilder].
  $ContextNavigationInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextNavigationInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextNavigationInterfaceBuilder b) {}
}

abstract class ContextNavigation
    implements $ContextNavigationInterface, Built<ContextNavigation, ContextNavigationBuilder> {
  /// Creates a new ContextNavigation object using the builder pattern.
  factory ContextNavigation([void Function(ContextNavigationBuilder)? b]) = _$ContextNavigation;

  // coverage:ignore-start
  const ContextNavigation._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextNavigation.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextNavigation.
  static Serializer<ContextNavigation> get serializer => _$contextNavigationSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextNavigationBuilder b) {
    $ContextNavigationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextNavigationBuilder b) {
    $ContextNavigationInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ColumnInterface {
  int get id;
  String get title;
  int get tableId;
  String get createdBy;
  String get createdAt;
  String get lastEditBy;
  String get lastEditAt;
  String get type;
  String get subtype;
  bool get mandatory;
  String get description;
  int get orderWeight;
  double get numberDefault;
  double get numberMin;
  double get numberMax;
  int get numberDecimals;
  String get numberPrefix;
  String get numberSuffix;
  String get textDefault;
  String get textAllowedPattern;
  int get textMaxLength;
  String get selectionOptions;
  String get selectionDefault;
  String get datetimeDefault;
  String get usergroupDefault;
  bool get usergroupMultipleItems;
  bool get usergroupSelectUsers;
  bool get usergroupSelectGroups;
  bool get showUserStatus;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ColumnInterfaceBuilder].
  $ColumnInterface rebuild(void Function($ColumnInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ColumnInterfaceBuilder].
  $ColumnInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ColumnInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ColumnInterfaceBuilder b) {}
}

abstract class Column implements $ColumnInterface, Built<Column, ColumnBuilder> {
  /// Creates a new Column object using the builder pattern.
  factory Column([void Function(ColumnBuilder)? b]) = _$Column;

  // coverage:ignore-start
  const Column._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Column.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Column.
  static Serializer<Column> get serializer => _$columnSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ColumnBuilder b) {
    $ColumnInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ColumnBuilder b) {
    $ColumnInterface._validate(b);
  }
}

/// Column main type.
class Api1CreateTableColumnRequestApplicationJson_Type extends EnumClass {
  const Api1CreateTableColumnRequestApplicationJson_Type._(super.name);

  /// `text`
  static const Api1CreateTableColumnRequestApplicationJson_Type text =
      _$api1CreateTableColumnRequestApplicationJsonTypeText;

  /// `number`
  static const Api1CreateTableColumnRequestApplicationJson_Type number =
      _$api1CreateTableColumnRequestApplicationJsonTypeNumber;

  /// `datetime`
  static const Api1CreateTableColumnRequestApplicationJson_Type datetime =
      _$api1CreateTableColumnRequestApplicationJsonTypeDatetime;

  /// `select`
  static const Api1CreateTableColumnRequestApplicationJson_Type select =
      _$api1CreateTableColumnRequestApplicationJsonTypeSelect;

  /// `usergroup`
  static const Api1CreateTableColumnRequestApplicationJson_Type usergroup =
      _$api1CreateTableColumnRequestApplicationJsonTypeUsergroup;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1CreateTableColumnRequestApplicationJson_Type> get values =>
      _$api1CreateTableColumnRequestApplicationJsonTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1CreateTableColumnRequestApplicationJson_Type valueOf(String name) =>
      _$valueOfApi1CreateTableColumnRequestApplicationJson_Type(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1CreateTableColumnRequestApplicationJson_Type.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1CreateTableColumnRequestApplicationJson_Type> get serializer =>
      const _$Api1CreateTableColumnRequestApplicationJson_TypeSerializer();
}

class _$Api1CreateTableColumnRequestApplicationJson_TypeSerializer
    implements PrimitiveSerializer<Api1CreateTableColumnRequestApplicationJson_Type> {
  const _$Api1CreateTableColumnRequestApplicationJson_TypeSerializer();

  static const Map<Api1CreateTableColumnRequestApplicationJson_Type, Object> _toWire =
      <Api1CreateTableColumnRequestApplicationJson_Type, Object>{
    Api1CreateTableColumnRequestApplicationJson_Type.text: 'text',
    Api1CreateTableColumnRequestApplicationJson_Type.number: 'number',
    Api1CreateTableColumnRequestApplicationJson_Type.datetime: 'datetime',
    Api1CreateTableColumnRequestApplicationJson_Type.select: 'select',
    Api1CreateTableColumnRequestApplicationJson_Type.usergroup: 'usergroup',
  };

  static const Map<Object, Api1CreateTableColumnRequestApplicationJson_Type> _fromWire =
      <Object, Api1CreateTableColumnRequestApplicationJson_Type>{
    'text': Api1CreateTableColumnRequestApplicationJson_Type.text,
    'number': Api1CreateTableColumnRequestApplicationJson_Type.number,
    'datetime': Api1CreateTableColumnRequestApplicationJson_Type.datetime,
    'select': Api1CreateTableColumnRequestApplicationJson_Type.select,
    'usergroup': Api1CreateTableColumnRequestApplicationJson_Type.usergroup,
  };

  @override
  Iterable<Type> get types => const [Api1CreateTableColumnRequestApplicationJson_Type];

  @override
  String get wireName => 'Api1CreateTableColumnRequestApplicationJson_Type';

  @override
  Object serialize(
    Serializers serializers,
    Api1CreateTableColumnRequestApplicationJson_Type object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1CreateTableColumnRequestApplicationJson_Type deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Api1CreateTableColumnRequestApplicationJsonInterface {
  static final _$selectionOptions = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$selectionDefault = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$datetimeDefault = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$usergroupDefault = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$selectedViewIds = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(int)]),
  )! as BuiltList<int>;

  /// Title.
  String get title;

  /// Column main type.
  Api1CreateTableColumnRequestApplicationJson_Type get type;

  /// Column sub type.
  String? get subtype;

  /// Is the column mandatory.
  bool get mandatory;

  /// Description.
  String? get description;

  /// Prefix if the column is a number field.
  String? get numberPrefix;

  /// Suffix if the column is a number field.
  String? get numberSuffix;

  /// Default number, if column is a number.
  double? get numberDefault;

  /// Min value, if column is a number.
  double? get numberMin;

  /// Max number, if column is a number.
  double? get numberMax;

  /// Number of decimals, if column is a number.
  int? get numberDecimals;

  /// Default text, if column is a text.
  String? get textDefault;

  /// Allowed pattern (regex) for text columns (not yet implemented).
  String? get textAllowedPattern;

  /// Max length, if column is a text.
  int? get textMaxLength;

  /// Options for a selection (json array{id: int, label: string}).
  String? get selectionOptions;

  /// Default option IDs for a selection (json int[]).
  String? get selectionDefault;

  /// Default value, if column is datetime.
  String? get datetimeDefault;

  /// Default value, if column is usergroup.
  String? get usergroupDefault;

  /// Can select multiple users or/and groups, if column is usergroup.
  bool? get usergroupMultipleItems;

  /// Can select users, if column type is usergroup.
  bool? get usergroupSelectUsers;

  /// Can select groups, if column type is usergroup.
  bool? get usergroupSelectGroups;

  /// Whether to show the user's status, if column type is usergroup.
  bool? get usergroupShowUserStatus;

  /// View IDs where this column should be added to be presented.
  BuiltList<int>? get selectedViewIds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1CreateTableColumnRequestApplicationJsonInterfaceBuilder].
  $Api1CreateTableColumnRequestApplicationJsonInterface rebuild(
    void Function($Api1CreateTableColumnRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1CreateTableColumnRequestApplicationJsonInterfaceBuilder].
  $Api1CreateTableColumnRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1CreateTableColumnRequestApplicationJsonInterfaceBuilder b) {
    b.selectionOptions = _$selectionOptions;
    b.selectionDefault = _$selectionDefault;
    b.datetimeDefault = _$datetimeDefault;
    b.usergroupDefault = _$usergroupDefault;
    b.selectedViewIds.replace(_$selectedViewIds);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1CreateTableColumnRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1CreateTableColumnRequestApplicationJson
    implements
        $Api1CreateTableColumnRequestApplicationJsonInterface,
        Built<Api1CreateTableColumnRequestApplicationJson, Api1CreateTableColumnRequestApplicationJsonBuilder> {
  /// Creates a new Api1CreateTableColumnRequestApplicationJson object using the builder pattern.
  factory Api1CreateTableColumnRequestApplicationJson([
    void Function(Api1CreateTableColumnRequestApplicationJsonBuilder)? b,
  ]) = _$Api1CreateTableColumnRequestApplicationJson;

  // coverage:ignore-start
  const Api1CreateTableColumnRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1CreateTableColumnRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1CreateTableColumnRequestApplicationJson.
  static Serializer<Api1CreateTableColumnRequestApplicationJson> get serializer =>
      _$api1CreateTableColumnRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1CreateTableColumnRequestApplicationJsonBuilder b) {
    $Api1CreateTableColumnRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1CreateTableColumnRequestApplicationJsonBuilder b) {
    $Api1CreateTableColumnRequestApplicationJsonInterface._validate(b);
  }
}

/// Column main type.
class Api1CreateColumnRequestApplicationJson_Type extends EnumClass {
  const Api1CreateColumnRequestApplicationJson_Type._(super.name);

  /// `text`
  static const Api1CreateColumnRequestApplicationJson_Type text = _$api1CreateColumnRequestApplicationJsonTypeText;

  /// `number`
  static const Api1CreateColumnRequestApplicationJson_Type number = _$api1CreateColumnRequestApplicationJsonTypeNumber;

  /// `datetime`
  static const Api1CreateColumnRequestApplicationJson_Type datetime =
      _$api1CreateColumnRequestApplicationJsonTypeDatetime;

  /// `select`
  static const Api1CreateColumnRequestApplicationJson_Type select = _$api1CreateColumnRequestApplicationJsonTypeSelect;

  /// `usergroup`
  static const Api1CreateColumnRequestApplicationJson_Type usergroup =
      _$api1CreateColumnRequestApplicationJsonTypeUsergroup;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Api1CreateColumnRequestApplicationJson_Type> get values =>
      _$api1CreateColumnRequestApplicationJsonTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Api1CreateColumnRequestApplicationJson_Type valueOf(String name) =>
      _$valueOfApi1CreateColumnRequestApplicationJson_Type(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Api1CreateColumnRequestApplicationJson_Type.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1CreateColumnRequestApplicationJson_Type> get serializer =>
      const _$Api1CreateColumnRequestApplicationJson_TypeSerializer();
}

class _$Api1CreateColumnRequestApplicationJson_TypeSerializer
    implements PrimitiveSerializer<Api1CreateColumnRequestApplicationJson_Type> {
  const _$Api1CreateColumnRequestApplicationJson_TypeSerializer();

  static const Map<Api1CreateColumnRequestApplicationJson_Type, Object> _toWire =
      <Api1CreateColumnRequestApplicationJson_Type, Object>{
    Api1CreateColumnRequestApplicationJson_Type.text: 'text',
    Api1CreateColumnRequestApplicationJson_Type.number: 'number',
    Api1CreateColumnRequestApplicationJson_Type.datetime: 'datetime',
    Api1CreateColumnRequestApplicationJson_Type.select: 'select',
    Api1CreateColumnRequestApplicationJson_Type.usergroup: 'usergroup',
  };

  static const Map<Object, Api1CreateColumnRequestApplicationJson_Type> _fromWire =
      <Object, Api1CreateColumnRequestApplicationJson_Type>{
    'text': Api1CreateColumnRequestApplicationJson_Type.text,
    'number': Api1CreateColumnRequestApplicationJson_Type.number,
    'datetime': Api1CreateColumnRequestApplicationJson_Type.datetime,
    'select': Api1CreateColumnRequestApplicationJson_Type.select,
    'usergroup': Api1CreateColumnRequestApplicationJson_Type.usergroup,
  };

  @override
  Iterable<Type> get types => const [Api1CreateColumnRequestApplicationJson_Type];

  @override
  String get wireName => 'Api1CreateColumnRequestApplicationJson_Type';

  @override
  Object serialize(
    Serializers serializers,
    Api1CreateColumnRequestApplicationJson_Type object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Api1CreateColumnRequestApplicationJson_Type deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Api1CreateColumnRequestApplicationJsonInterface {
  static final _$selectionOptions = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$selectionDefault = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$datetimeDefault = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$usergroupDefault = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$selectedViewIds = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(int)]),
  )! as BuiltList<int>;

  /// Table ID.
  int? get tableId;

  /// View ID.
  int? get viewId;

  /// Title.
  String get title;

  /// Column main type.
  Api1CreateColumnRequestApplicationJson_Type get type;

  /// Column sub type.
  String? get subtype;

  /// Is the column mandatory.
  bool get mandatory;

  /// Description.
  String? get description;

  /// Prefix if the column is a number field.
  String? get numberPrefix;

  /// Suffix if the column is a number field.
  String? get numberSuffix;

  /// Default number, if column is a number.
  double? get numberDefault;

  /// Min value, if column is a number.
  double? get numberMin;

  /// Max number, if column is a number.
  double? get numberMax;

  /// Number of decimals, if column is a number.
  int? get numberDecimals;

  /// Default text, if column is a text.
  String? get textDefault;

  /// Allowed pattern (regex) for text columns (not yet implemented).
  String? get textAllowedPattern;

  /// Max length, if column is a text.
  int? get textMaxLength;

  /// Options for a selection (json array{id: int, label: string}).
  String? get selectionOptions;

  /// Default option IDs for a selection (json int[]).
  String? get selectionDefault;

  /// Default value, if column is datetime.
  String? get datetimeDefault;

  /// Default value, if column is usergroup (json array{id: string, type: int}).
  String? get usergroupDefault;

  /// Can select multiple users or/and groups, if column is usergroup.
  bool? get usergroupMultipleItems;

  /// Can select users, if column type is usergroup.
  bool? get usergroupSelectUsers;

  /// Can select groups, if column type is usergroup.
  bool? get usergroupSelectGroups;

  /// Whether to show the user's status, if column type is usergroup.
  bool? get usergroupShowUserStatus;

  /// View IDs where this column should be added to be presented.
  BuiltList<int>? get selectedViewIds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1CreateColumnRequestApplicationJsonInterfaceBuilder].
  $Api1CreateColumnRequestApplicationJsonInterface rebuild(
    void Function($Api1CreateColumnRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1CreateColumnRequestApplicationJsonInterfaceBuilder].
  $Api1CreateColumnRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1CreateColumnRequestApplicationJsonInterfaceBuilder b) {
    b.selectionOptions = _$selectionOptions;
    b.selectionDefault = _$selectionDefault;
    b.datetimeDefault = _$datetimeDefault;
    b.usergroupDefault = _$usergroupDefault;
    b.selectedViewIds.replace(_$selectedViewIds);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1CreateColumnRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1CreateColumnRequestApplicationJson
    implements
        $Api1CreateColumnRequestApplicationJsonInterface,
        Built<Api1CreateColumnRequestApplicationJson, Api1CreateColumnRequestApplicationJsonBuilder> {
  /// Creates a new Api1CreateColumnRequestApplicationJson object using the builder pattern.
  factory Api1CreateColumnRequestApplicationJson([void Function(Api1CreateColumnRequestApplicationJsonBuilder)? b]) =
      _$Api1CreateColumnRequestApplicationJson;

  // coverage:ignore-start
  const Api1CreateColumnRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1CreateColumnRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1CreateColumnRequestApplicationJson.
  static Serializer<Api1CreateColumnRequestApplicationJson> get serializer =>
      _$api1CreateColumnRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1CreateColumnRequestApplicationJsonBuilder b) {
    $Api1CreateColumnRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1CreateColumnRequestApplicationJsonBuilder b) {
    $Api1CreateColumnRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1UpdateColumnRequestApplicationJsonInterface {
  /// Title.
  String? get title;

  /// Column sub type.
  String? get subtype;

  /// Is the column mandatory.
  bool get mandatory;

  /// Description.
  String? get description;

  /// Prefix if the column is a number field.
  String? get numberPrefix;

  /// Suffix if the column is a number field.
  String? get numberSuffix;

  /// Default number, if column is a number.
  double? get numberDefault;

  /// Min value, if column is a number.
  double? get numberMin;

  /// Max number, if column is a number.
  double? get numberMax;

  /// Number of decimals, if column is a number.
  int? get numberDecimals;

  /// Default text, if column is a text.
  String? get textDefault;

  /// Allowed pattern (regex) for text columns (not yet implemented).
  String? get textAllowedPattern;

  /// Max length, if column is a text.
  int? get textMaxLength;

  /// Options for a selection (json array{id: int, label: string}).
  String? get selectionOptions;

  /// Default option IDs for a selection (json int[]).
  String? get selectionDefault;

  /// Default value, if column is datetime.
  String? get datetimeDefault;

  /// Default value, if column is usergroup.
  String? get usergroupDefault;

  /// Can select multiple users or/and groups, if column is usergroup.
  bool? get usergroupMultipleItems;

  /// Can select users, if column type is usergroup.
  bool? get usergroupSelectUsers;

  /// Can select groups, if column type is usergroup.
  bool? get usergroupSelectGroups;

  /// Whether to show the user's status, if column type is usergroup.
  bool? get usergroupShowUserStatus;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateColumnRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateColumnRequestApplicationJsonInterface rebuild(
    void Function($Api1UpdateColumnRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateColumnRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateColumnRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateColumnRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateColumnRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1UpdateColumnRequestApplicationJson
    implements
        $Api1UpdateColumnRequestApplicationJsonInterface,
        Built<Api1UpdateColumnRequestApplicationJson, Api1UpdateColumnRequestApplicationJsonBuilder> {
  /// Creates a new Api1UpdateColumnRequestApplicationJson object using the builder pattern.
  factory Api1UpdateColumnRequestApplicationJson([void Function(Api1UpdateColumnRequestApplicationJsonBuilder)? b]) =
      _$Api1UpdateColumnRequestApplicationJson;

  // coverage:ignore-start
  const Api1UpdateColumnRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateColumnRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateColumnRequestApplicationJson.
  static Serializer<Api1UpdateColumnRequestApplicationJson> get serializer =>
      _$api1UpdateColumnRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateColumnRequestApplicationJsonBuilder b) {
    $Api1UpdateColumnRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateColumnRequestApplicationJsonBuilder b) {
    $Api1UpdateColumnRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Row_DataInterface {
  int get columnId;
  JsonObject get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Row_DataInterfaceBuilder].
  $Row_DataInterface rebuild(void Function($Row_DataInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Row_DataInterfaceBuilder].
  $Row_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Row_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Row_DataInterfaceBuilder b) {}
}

abstract class Row_Data implements $Row_DataInterface, Built<Row_Data, Row_DataBuilder> {
  /// Creates a new Row_Data object using the builder pattern.
  factory Row_Data([void Function(Row_DataBuilder)? b]) = _$Row_Data;

  // coverage:ignore-start
  const Row_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Row_Data.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Row_Data.
  static Serializer<Row_Data> get serializer => _$rowDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Row_DataBuilder b) {
    $Row_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Row_DataBuilder b) {
    $Row_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RowInterface {
  int get id;
  int get tableId;
  String get createdBy;
  String get createdAt;
  String get lastEditBy;
  String get lastEditAt;
  Row_Data? get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RowInterfaceBuilder].
  $RowInterface rebuild(void Function($RowInterfaceBuilder) updates);

  /// Converts the instance to a builder [$RowInterfaceBuilder].
  $RowInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RowInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RowInterfaceBuilder b) {}
}

abstract class Row implements $RowInterface, Built<Row, RowBuilder> {
  /// Creates a new Row object using the builder pattern.
  factory Row([void Function(RowBuilder)? b]) = _$Row;

  // coverage:ignore-start
  const Row._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Row.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Row.
  static Serializer<Row> get serializer => _$rowSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RowBuilder b) {
    $RowInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RowBuilder b) {
    $RowInterface._validate(b);
  }
}

/// Data as key - value store.
typedef Api1CreateRowInTableRequestApplicationJson_Data = ({
  BuiltMap<String, JsonObject>? builtMapStringJsonObject,
  String? string
});

@BuiltValue(instantiable: false)
sealed class $Api1CreateRowInTableRequestApplicationJsonInterface {
  /// Data as key - value store.
  Api1CreateRowInTableRequestApplicationJson_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1CreateRowInTableRequestApplicationJsonInterfaceBuilder].
  $Api1CreateRowInTableRequestApplicationJsonInterface rebuild(
    void Function($Api1CreateRowInTableRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1CreateRowInTableRequestApplicationJsonInterfaceBuilder].
  $Api1CreateRowInTableRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1CreateRowInTableRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1CreateRowInTableRequestApplicationJsonInterfaceBuilder b) {
    b.data?.validateOneOf();
  }
}

abstract class Api1CreateRowInTableRequestApplicationJson
    implements
        $Api1CreateRowInTableRequestApplicationJsonInterface,
        Built<Api1CreateRowInTableRequestApplicationJson, Api1CreateRowInTableRequestApplicationJsonBuilder> {
  /// Creates a new Api1CreateRowInTableRequestApplicationJson object using the builder pattern.
  factory Api1CreateRowInTableRequestApplicationJson([
    void Function(Api1CreateRowInTableRequestApplicationJsonBuilder)? b,
  ]) = _$Api1CreateRowInTableRequestApplicationJson;

  // coverage:ignore-start
  const Api1CreateRowInTableRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1CreateRowInTableRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1CreateRowInTableRequestApplicationJson.
  static Serializer<Api1CreateRowInTableRequestApplicationJson> get serializer =>
      _$api1CreateRowInTableRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1CreateRowInTableRequestApplicationJsonBuilder b) {
    $Api1CreateRowInTableRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1CreateRowInTableRequestApplicationJsonBuilder b) {
    $Api1CreateRowInTableRequestApplicationJsonInterface._validate(b);
  }
}

/// Data as key - value store.
typedef Api1CreateRowInViewRequestApplicationJson_Data = ({
  BuiltMap<String, JsonObject>? builtMapStringJsonObject,
  String? string
});

@BuiltValue(instantiable: false)
sealed class $Api1CreateRowInViewRequestApplicationJsonInterface {
  /// Data as key - value store.
  Api1CreateRowInViewRequestApplicationJson_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1CreateRowInViewRequestApplicationJsonInterfaceBuilder].
  $Api1CreateRowInViewRequestApplicationJsonInterface rebuild(
    void Function($Api1CreateRowInViewRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1CreateRowInViewRequestApplicationJsonInterfaceBuilder].
  $Api1CreateRowInViewRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1CreateRowInViewRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1CreateRowInViewRequestApplicationJsonInterfaceBuilder b) {
    b.data?.validateOneOf();
  }
}

abstract class Api1CreateRowInViewRequestApplicationJson
    implements
        $Api1CreateRowInViewRequestApplicationJsonInterface,
        Built<Api1CreateRowInViewRequestApplicationJson, Api1CreateRowInViewRequestApplicationJsonBuilder> {
  /// Creates a new Api1CreateRowInViewRequestApplicationJson object using the builder pattern.
  factory Api1CreateRowInViewRequestApplicationJson([
    void Function(Api1CreateRowInViewRequestApplicationJsonBuilder)? b,
  ]) = _$Api1CreateRowInViewRequestApplicationJson;

  // coverage:ignore-start
  const Api1CreateRowInViewRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1CreateRowInViewRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1CreateRowInViewRequestApplicationJson.
  static Serializer<Api1CreateRowInViewRequestApplicationJson> get serializer =>
      _$api1CreateRowInViewRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1CreateRowInViewRequestApplicationJsonBuilder b) {
    $Api1CreateRowInViewRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1CreateRowInViewRequestApplicationJsonBuilder b) {
    $Api1CreateRowInViewRequestApplicationJsonInterface._validate(b);
  }
}

/// Data as key - value store.
typedef Api1UpdateRowRequestApplicationJson_Data = ({
  BuiltMap<String, JsonObject>? builtMapStringJsonObject,
  String? string
});

@BuiltValue(instantiable: false)
sealed class $Api1UpdateRowRequestApplicationJsonInterface {
  /// View ID.
  int? get viewId;

  /// Data as key - value store.
  Api1UpdateRowRequestApplicationJson_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1UpdateRowRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateRowRequestApplicationJsonInterface rebuild(
    void Function($Api1UpdateRowRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1UpdateRowRequestApplicationJsonInterfaceBuilder].
  $Api1UpdateRowRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1UpdateRowRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1UpdateRowRequestApplicationJsonInterfaceBuilder b) {
    b.data?.validateOneOf();
  }
}

abstract class Api1UpdateRowRequestApplicationJson
    implements
        $Api1UpdateRowRequestApplicationJsonInterface,
        Built<Api1UpdateRowRequestApplicationJson, Api1UpdateRowRequestApplicationJsonBuilder> {
  /// Creates a new Api1UpdateRowRequestApplicationJson object using the builder pattern.
  factory Api1UpdateRowRequestApplicationJson([void Function(Api1UpdateRowRequestApplicationJsonBuilder)? b]) =
      _$Api1UpdateRowRequestApplicationJson;

  // coverage:ignore-start
  const Api1UpdateRowRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1UpdateRowRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1UpdateRowRequestApplicationJson.
  static Serializer<Api1UpdateRowRequestApplicationJson> get serializer =>
      _$api1UpdateRowRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1UpdateRowRequestApplicationJsonBuilder b) {
    $Api1UpdateRowRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1UpdateRowRequestApplicationJsonBuilder b) {
    $Api1UpdateRowRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1ImportInTableRequestApplicationJsonInterface {
  static final _$createMissingColumns = _$jsonSerializers.deserialize(
    true,
    specifiedType: const FullType(bool),
  )! as bool;

  /// Path to file.
  String get path;

  /// Create missing columns.
  bool get createMissingColumns;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1ImportInTableRequestApplicationJsonInterfaceBuilder].
  $Api1ImportInTableRequestApplicationJsonInterface rebuild(
    void Function($Api1ImportInTableRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1ImportInTableRequestApplicationJsonInterfaceBuilder].
  $Api1ImportInTableRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1ImportInTableRequestApplicationJsonInterfaceBuilder b) {
    b.createMissingColumns = _$createMissingColumns;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1ImportInTableRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1ImportInTableRequestApplicationJson
    implements
        $Api1ImportInTableRequestApplicationJsonInterface,
        Built<Api1ImportInTableRequestApplicationJson, Api1ImportInTableRequestApplicationJsonBuilder> {
  /// Creates a new Api1ImportInTableRequestApplicationJson object using the builder pattern.
  factory Api1ImportInTableRequestApplicationJson([void Function(Api1ImportInTableRequestApplicationJsonBuilder)? b]) =
      _$Api1ImportInTableRequestApplicationJson;

  // coverage:ignore-start
  const Api1ImportInTableRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1ImportInTableRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1ImportInTableRequestApplicationJson.
  static Serializer<Api1ImportInTableRequestApplicationJson> get serializer =>
      _$api1ImportInTableRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1ImportInTableRequestApplicationJsonBuilder b) {
    $Api1ImportInTableRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1ImportInTableRequestApplicationJsonBuilder b) {
    $Api1ImportInTableRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ImportStateInterface {
  @BuiltValueField(wireName: 'found_columns_count')
  int get foundColumnsCount;
  @BuiltValueField(wireName: 'matching_columns_count')
  int get matchingColumnsCount;
  @BuiltValueField(wireName: 'created_columns_count')
  int get createdColumnsCount;
  @BuiltValueField(wireName: 'inserted_rows_count')
  int get insertedRowsCount;
  @BuiltValueField(wireName: 'errors_parsing_count')
  int get errorsParsingCount;
  @BuiltValueField(wireName: 'errors_count')
  int get errorsCount;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ImportStateInterfaceBuilder].
  $ImportStateInterface rebuild(void Function($ImportStateInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ImportStateInterfaceBuilder].
  $ImportStateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ImportStateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ImportStateInterfaceBuilder b) {}
}

abstract class ImportState implements $ImportStateInterface, Built<ImportState, ImportStateBuilder> {
  /// Creates a new ImportState object using the builder pattern.
  factory ImportState([void Function(ImportStateBuilder)? b]) = _$ImportState;

  // coverage:ignore-start
  const ImportState._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ImportState.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ImportState.
  static Serializer<ImportState> get serializer => _$importStateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ImportStateBuilder b) {
    $ImportStateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ImportStateBuilder b) {
    $ImportStateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Api1ImportInViewRequestApplicationJsonInterface {
  static final _$createMissingColumns = _$jsonSerializers.deserialize(
    true,
    specifiedType: const FullType(bool),
  )! as bool;

  /// Path to file.
  String get path;

  /// Create missing columns.
  bool get createMissingColumns;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Api1ImportInViewRequestApplicationJsonInterfaceBuilder].
  $Api1ImportInViewRequestApplicationJsonInterface rebuild(
    void Function($Api1ImportInViewRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Api1ImportInViewRequestApplicationJsonInterfaceBuilder].
  $Api1ImportInViewRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Api1ImportInViewRequestApplicationJsonInterfaceBuilder b) {
    b.createMissingColumns = _$createMissingColumns;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Api1ImportInViewRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class Api1ImportInViewRequestApplicationJson
    implements
        $Api1ImportInViewRequestApplicationJsonInterface,
        Built<Api1ImportInViewRequestApplicationJson, Api1ImportInViewRequestApplicationJsonBuilder> {
  /// Creates a new Api1ImportInViewRequestApplicationJson object using the builder pattern.
  factory Api1ImportInViewRequestApplicationJson([void Function(Api1ImportInViewRequestApplicationJsonBuilder)? b]) =
      _$Api1ImportInViewRequestApplicationJson;

  // coverage:ignore-start
  const Api1ImportInViewRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Api1ImportInViewRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Api1ImportInViewRequestApplicationJson.
  static Serializer<Api1ImportInViewRequestApplicationJson> get serializer =>
      _$api1ImportInViewRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Api1ImportInViewRequestApplicationJsonBuilder b) {
    $Api1ImportInViewRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Api1ImportInViewRequestApplicationJsonBuilder b) {
    $Api1ImportInViewRequestApplicationJsonInterface._validate(b);
  }
}

class ApiColumnsIndexNodeType extends EnumClass {
  const ApiColumnsIndexNodeType._(super.name);

  /// `table`
  static const ApiColumnsIndexNodeType table = _$apiColumnsIndexNodeTypeTable;

  /// `view`
  static const ApiColumnsIndexNodeType view = _$apiColumnsIndexNodeTypeView;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsIndexNodeType> get values => _$apiColumnsIndexNodeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsIndexNodeType valueOf(String name) => _$valueOfApiColumnsIndexNodeType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsIndexNodeType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsIndexNodeType> get serializer => const _$ApiColumnsIndexNodeTypeSerializer();
}

class _$ApiColumnsIndexNodeTypeSerializer implements PrimitiveSerializer<ApiColumnsIndexNodeType> {
  const _$ApiColumnsIndexNodeTypeSerializer();

  static const Map<ApiColumnsIndexNodeType, Object> _toWire = <ApiColumnsIndexNodeType, Object>{
    ApiColumnsIndexNodeType.table: 'table',
    ApiColumnsIndexNodeType.view: 'view',
  };

  static const Map<Object, ApiColumnsIndexNodeType> _fromWire = <Object, ApiColumnsIndexNodeType>{
    'table': ApiColumnsIndexNodeType.table,
    'view': ApiColumnsIndexNodeType.view,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsIndexNodeType];

  @override
  String get wireName => 'ApiColumnsIndexNodeType';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsIndexNodeType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsIndexNodeType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsIndexResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Column> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsIndexResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsIndexResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiColumnsIndexResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsIndexResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsIndexResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiColumnsIndexResponseApplicationJson_Ocs
    implements
        $ApiColumnsIndexResponseApplicationJson_OcsInterface,
        Built<ApiColumnsIndexResponseApplicationJson_Ocs, ApiColumnsIndexResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiColumnsIndexResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiColumnsIndexResponseApplicationJson_Ocs([
    void Function(ApiColumnsIndexResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiColumnsIndexResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiColumnsIndexResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsIndexResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsIndexResponseApplicationJson_Ocs.
  static Serializer<ApiColumnsIndexResponseApplicationJson_Ocs> get serializer =>
      _$apiColumnsIndexResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsIndexResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsIndexResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsIndexResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsIndexResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsIndexResponseApplicationJsonInterface {
  ApiColumnsIndexResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsIndexResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsIndexResponseApplicationJsonInterface rebuild(
    void Function($ApiColumnsIndexResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsIndexResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsIndexResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsIndexResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsIndexResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsIndexResponseApplicationJson
    implements
        $ApiColumnsIndexResponseApplicationJsonInterface,
        Built<ApiColumnsIndexResponseApplicationJson, ApiColumnsIndexResponseApplicationJsonBuilder> {
  /// Creates a new ApiColumnsIndexResponseApplicationJson object using the builder pattern.
  factory ApiColumnsIndexResponseApplicationJson([void Function(ApiColumnsIndexResponseApplicationJsonBuilder)? b]) =
      _$ApiColumnsIndexResponseApplicationJson;

  // coverage:ignore-start
  const ApiColumnsIndexResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsIndexResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsIndexResponseApplicationJson.
  static Serializer<ApiColumnsIndexResponseApplicationJson> get serializer =>
      _$apiColumnsIndexResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsIndexResponseApplicationJsonBuilder b) {
    $ApiColumnsIndexResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsIndexResponseApplicationJsonBuilder b) {
    $ApiColumnsIndexResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsShowResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Column get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsShowResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsShowResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiColumnsShowResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsShowResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsShowResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsShowResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsShowResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiColumnsShowResponseApplicationJson_Ocs
    implements
        $ApiColumnsShowResponseApplicationJson_OcsInterface,
        Built<ApiColumnsShowResponseApplicationJson_Ocs, ApiColumnsShowResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiColumnsShowResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiColumnsShowResponseApplicationJson_Ocs([
    void Function(ApiColumnsShowResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiColumnsShowResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiColumnsShowResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsShowResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsShowResponseApplicationJson_Ocs.
  static Serializer<ApiColumnsShowResponseApplicationJson_Ocs> get serializer =>
      _$apiColumnsShowResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsShowResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsShowResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsShowResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsShowResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsShowResponseApplicationJsonInterface {
  ApiColumnsShowResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsShowResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsShowResponseApplicationJsonInterface rebuild(
    void Function($ApiColumnsShowResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsShowResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsShowResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsShowResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsShowResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsShowResponseApplicationJson
    implements
        $ApiColumnsShowResponseApplicationJsonInterface,
        Built<ApiColumnsShowResponseApplicationJson, ApiColumnsShowResponseApplicationJsonBuilder> {
  /// Creates a new ApiColumnsShowResponseApplicationJson object using the builder pattern.
  factory ApiColumnsShowResponseApplicationJson([void Function(ApiColumnsShowResponseApplicationJsonBuilder)? b]) =
      _$ApiColumnsShowResponseApplicationJson;

  // coverage:ignore-start
  const ApiColumnsShowResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsShowResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsShowResponseApplicationJson.
  static Serializer<ApiColumnsShowResponseApplicationJson> get serializer =>
      _$apiColumnsShowResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsShowResponseApplicationJsonBuilder b) {
    $ApiColumnsShowResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsShowResponseApplicationJsonBuilder b) {
    $ApiColumnsShowResponseApplicationJsonInterface._validate(b);
  }
}

/// Subtype for the new column.
class ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype extends EnumClass {
  const ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype._(super.name);

  /// `progress`
  static const ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype progress =
      _$apiColumnsCreateNumberColumnRequestApplicationJsonSubtypeProgress;

  /// `stars`
  static const ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype stars =
      _$apiColumnsCreateNumberColumnRequestApplicationJsonSubtypeStars;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype> get values =>
      _$apiColumnsCreateNumberColumnRequestApplicationJsonSubtypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype valueOf(String name) =>
      _$valueOfApiColumnsCreateNumberColumnRequestApplicationJson_Subtype(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype> get serializer =>
      const _$ApiColumnsCreateNumberColumnRequestApplicationJson_SubtypeSerializer();
}

class _$ApiColumnsCreateNumberColumnRequestApplicationJson_SubtypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype> {
  const _$ApiColumnsCreateNumberColumnRequestApplicationJson_SubtypeSerializer();

  static const Map<ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype, Object> _toWire =
      <ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype, Object>{
    ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype.progress: 'progress',
    ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype.stars: 'stars',
  };

  static const Map<Object, ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype> _fromWire =
      <Object, ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype>{
    'progress': ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype.progress,
    'stars': ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype.stars,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype];

  @override
  String get wireName => 'ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// Context type of the column creation.
class ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType extends EnumClass {
  const ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType._(super.name);

  /// `table`
  static const ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType table =
      _$apiColumnsCreateNumberColumnRequestApplicationJsonBaseNodeTypeTable;

  /// `view`
  static const ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType view =
      _$apiColumnsCreateNumberColumnRequestApplicationJsonBaseNodeTypeView;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType> get values =>
      _$apiColumnsCreateNumberColumnRequestApplicationJsonBaseNodeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType valueOf(String name) =>
      _$valueOfApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType> get serializer =>
      const _$ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeTypeSerializer();
}

class _$ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeTypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType> {
  const _$ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeTypeSerializer();

  static const Map<ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType, Object> _toWire =
      <ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType, Object>{
    ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType.table: 'table',
    ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType.view: 'view',
  };

  static const Map<Object, ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType> _fromWire =
      <Object, ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType>{
    'table': ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType.table,
    'view': ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType.view,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType];

  @override
  String get wireName => 'ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateNumberColumnRequestApplicationJsonInterface {
  static final _$selectedViewIds = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(int)]),
  )! as BuiltList<int>;

  static final _$mandatory = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$baseNodeType = _$jsonSerializers.deserialize(
    'table',
    specifiedType: const FullType(ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType),
  )! as ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType;

  /// Context of the column creation.
  int get baseNodeId;

  /// Title.
  String get title;

  /// Default value for new rows.
  double? get numberDefault;

  /// Decimals.
  int? get numberDecimals;

  /// Prefix.
  String? get numberPrefix;

  /// Suffix.
  String? get numberSuffix;

  /// Min.
  double? get numberMin;

  /// Max.
  double? get numberMax;

  /// Subtype for the new column.
  ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype? get subtype;

  /// Description.
  String? get description;

  /// View IDs where this columns should be added.
  BuiltList<int>? get selectedViewIds;

  /// Is mandatory.
  bool get mandatory;

  /// Context type of the column creation.
  ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType get baseNodeType;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateNumberColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateNumberColumnRequestApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateNumberColumnRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateNumberColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateNumberColumnRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateNumberColumnRequestApplicationJsonInterfaceBuilder b) {
    b.selectedViewIds.replace(_$selectedViewIds);
    b.mandatory = _$mandatory;
    b.baseNodeType = _$baseNodeType;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateNumberColumnRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateNumberColumnRequestApplicationJson
    implements
        $ApiColumnsCreateNumberColumnRequestApplicationJsonInterface,
        Built<ApiColumnsCreateNumberColumnRequestApplicationJson,
            ApiColumnsCreateNumberColumnRequestApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateNumberColumnRequestApplicationJson object using the builder pattern.
  factory ApiColumnsCreateNumberColumnRequestApplicationJson([
    void Function(ApiColumnsCreateNumberColumnRequestApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateNumberColumnRequestApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateNumberColumnRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateNumberColumnRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateNumberColumnRequestApplicationJson.
  static Serializer<ApiColumnsCreateNumberColumnRequestApplicationJson> get serializer =>
      _$apiColumnsCreateNumberColumnRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateNumberColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateNumberColumnRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateNumberColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateNumberColumnRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Column get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs
    implements
        $ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterface,
        Built<ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs,
            ApiColumnsCreateNumberColumnResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs([
    void Function(ApiColumnsCreateNumberColumnResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs.
  static Serializer<ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs> get serializer =>
      _$apiColumnsCreateNumberColumnResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateNumberColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateNumberColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateNumberColumnResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateNumberColumnResponseApplicationJsonInterface {
  ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateNumberColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateNumberColumnResponseApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateNumberColumnResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateNumberColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateNumberColumnResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateNumberColumnResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateNumberColumnResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateNumberColumnResponseApplicationJson
    implements
        $ApiColumnsCreateNumberColumnResponseApplicationJsonInterface,
        Built<ApiColumnsCreateNumberColumnResponseApplicationJson,
            ApiColumnsCreateNumberColumnResponseApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateNumberColumnResponseApplicationJson object using the builder pattern.
  factory ApiColumnsCreateNumberColumnResponseApplicationJson([
    void Function(ApiColumnsCreateNumberColumnResponseApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateNumberColumnResponseApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateNumberColumnResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateNumberColumnResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateNumberColumnResponseApplicationJson.
  static Serializer<ApiColumnsCreateNumberColumnResponseApplicationJson> get serializer =>
      _$apiColumnsCreateNumberColumnResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateNumberColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateNumberColumnResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateNumberColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateNumberColumnResponseApplicationJsonInterface._validate(b);
  }
}

/// Subtype for the new column.
class ApiColumnsCreateTextColumnRequestApplicationJson_Subtype extends EnumClass {
  const ApiColumnsCreateTextColumnRequestApplicationJson_Subtype._(super.name);

  /// `progress`
  static const ApiColumnsCreateTextColumnRequestApplicationJson_Subtype progress =
      _$apiColumnsCreateTextColumnRequestApplicationJsonSubtypeProgress;

  /// `stars`
  static const ApiColumnsCreateTextColumnRequestApplicationJson_Subtype stars =
      _$apiColumnsCreateTextColumnRequestApplicationJsonSubtypeStars;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateTextColumnRequestApplicationJson_Subtype> get values =>
      _$apiColumnsCreateTextColumnRequestApplicationJsonSubtypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateTextColumnRequestApplicationJson_Subtype valueOf(String name) =>
      _$valueOfApiColumnsCreateTextColumnRequestApplicationJson_Subtype(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateTextColumnRequestApplicationJson_Subtype.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateTextColumnRequestApplicationJson_Subtype> get serializer =>
      const _$ApiColumnsCreateTextColumnRequestApplicationJson_SubtypeSerializer();
}

class _$ApiColumnsCreateTextColumnRequestApplicationJson_SubtypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateTextColumnRequestApplicationJson_Subtype> {
  const _$ApiColumnsCreateTextColumnRequestApplicationJson_SubtypeSerializer();

  static const Map<ApiColumnsCreateTextColumnRequestApplicationJson_Subtype, Object> _toWire =
      <ApiColumnsCreateTextColumnRequestApplicationJson_Subtype, Object>{
    ApiColumnsCreateTextColumnRequestApplicationJson_Subtype.progress: 'progress',
    ApiColumnsCreateTextColumnRequestApplicationJson_Subtype.stars: 'stars',
  };

  static const Map<Object, ApiColumnsCreateTextColumnRequestApplicationJson_Subtype> _fromWire =
      <Object, ApiColumnsCreateTextColumnRequestApplicationJson_Subtype>{
    'progress': ApiColumnsCreateTextColumnRequestApplicationJson_Subtype.progress,
    'stars': ApiColumnsCreateTextColumnRequestApplicationJson_Subtype.stars,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateTextColumnRequestApplicationJson_Subtype];

  @override
  String get wireName => 'ApiColumnsCreateTextColumnRequestApplicationJson_Subtype';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateTextColumnRequestApplicationJson_Subtype object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateTextColumnRequestApplicationJson_Subtype deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// Context type of the column creation.
class ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType extends EnumClass {
  const ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType._(super.name);

  /// `table`
  static const ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType table =
      _$apiColumnsCreateTextColumnRequestApplicationJsonBaseNodeTypeTable;

  /// `view`
  static const ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType view =
      _$apiColumnsCreateTextColumnRequestApplicationJsonBaseNodeTypeView;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType> get values =>
      _$apiColumnsCreateTextColumnRequestApplicationJsonBaseNodeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType valueOf(String name) =>
      _$valueOfApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType> get serializer =>
      const _$ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeTypeSerializer();
}

class _$ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeTypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType> {
  const _$ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeTypeSerializer();

  static const Map<ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType, Object> _toWire =
      <ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType, Object>{
    ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType.table: 'table',
    ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType.view: 'view',
  };

  static const Map<Object, ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType> _fromWire =
      <Object, ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType>{
    'table': ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType.table,
    'view': ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType.view,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType];

  @override
  String get wireName => 'ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateTextColumnRequestApplicationJsonInterface {
  static final _$selectedViewIds = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(int)]),
  )! as BuiltList<int>;

  static final _$mandatory = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$baseNodeType = _$jsonSerializers.deserialize(
    'table',
    specifiedType: const FullType(ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType),
  )! as ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType;

  /// Context of the column creation.
  int get baseNodeId;

  /// Title.
  String get title;

  /// Default.
  String? get textDefault;

  /// Allowed regex pattern.
  String? get textAllowedPattern;

  /// Max raw text length.
  int? get textMaxLength;

  /// Subtype for the new column.
  ApiColumnsCreateTextColumnRequestApplicationJson_Subtype? get subtype;

  /// Description.
  String? get description;

  /// View IDs where this columns should be added.
  BuiltList<int>? get selectedViewIds;

  /// Is mandatory.
  bool get mandatory;

  /// Context type of the column creation.
  ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType get baseNodeType;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateTextColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateTextColumnRequestApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateTextColumnRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateTextColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateTextColumnRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateTextColumnRequestApplicationJsonInterfaceBuilder b) {
    b.selectedViewIds.replace(_$selectedViewIds);
    b.mandatory = _$mandatory;
    b.baseNodeType = _$baseNodeType;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateTextColumnRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateTextColumnRequestApplicationJson
    implements
        $ApiColumnsCreateTextColumnRequestApplicationJsonInterface,
        Built<ApiColumnsCreateTextColumnRequestApplicationJson,
            ApiColumnsCreateTextColumnRequestApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateTextColumnRequestApplicationJson object using the builder pattern.
  factory ApiColumnsCreateTextColumnRequestApplicationJson([
    void Function(ApiColumnsCreateTextColumnRequestApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateTextColumnRequestApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateTextColumnRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateTextColumnRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateTextColumnRequestApplicationJson.
  static Serializer<ApiColumnsCreateTextColumnRequestApplicationJson> get serializer =>
      _$apiColumnsCreateTextColumnRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateTextColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateTextColumnRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateTextColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateTextColumnRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Column get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateTextColumnResponseApplicationJson_Ocs
    implements
        $ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterface,
        Built<ApiColumnsCreateTextColumnResponseApplicationJson_Ocs,
            ApiColumnsCreateTextColumnResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiColumnsCreateTextColumnResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiColumnsCreateTextColumnResponseApplicationJson_Ocs([
    void Function(ApiColumnsCreateTextColumnResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiColumnsCreateTextColumnResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiColumnsCreateTextColumnResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateTextColumnResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateTextColumnResponseApplicationJson_Ocs.
  static Serializer<ApiColumnsCreateTextColumnResponseApplicationJson_Ocs> get serializer =>
      _$apiColumnsCreateTextColumnResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateTextColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateTextColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateTextColumnResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateTextColumnResponseApplicationJsonInterface {
  ApiColumnsCreateTextColumnResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateTextColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateTextColumnResponseApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateTextColumnResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateTextColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateTextColumnResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateTextColumnResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateTextColumnResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateTextColumnResponseApplicationJson
    implements
        $ApiColumnsCreateTextColumnResponseApplicationJsonInterface,
        Built<ApiColumnsCreateTextColumnResponseApplicationJson,
            ApiColumnsCreateTextColumnResponseApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateTextColumnResponseApplicationJson object using the builder pattern.
  factory ApiColumnsCreateTextColumnResponseApplicationJson([
    void Function(ApiColumnsCreateTextColumnResponseApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateTextColumnResponseApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateTextColumnResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateTextColumnResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateTextColumnResponseApplicationJson.
  static Serializer<ApiColumnsCreateTextColumnResponseApplicationJson> get serializer =>
      _$apiColumnsCreateTextColumnResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateTextColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateTextColumnResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateTextColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateTextColumnResponseApplicationJsonInterface._validate(b);
  }
}

/// Subtype for the new column.
class ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype extends EnumClass {
  const ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype._(super.name);

  /// `progress`
  static const ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype progress =
      _$apiColumnsCreateSelectionColumnRequestApplicationJsonSubtypeProgress;

  /// `stars`
  static const ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype stars =
      _$apiColumnsCreateSelectionColumnRequestApplicationJsonSubtypeStars;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype> get values =>
      _$apiColumnsCreateSelectionColumnRequestApplicationJsonSubtypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype valueOf(String name) =>
      _$valueOfApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype> get serializer =>
      const _$ApiColumnsCreateSelectionColumnRequestApplicationJson_SubtypeSerializer();
}

class _$ApiColumnsCreateSelectionColumnRequestApplicationJson_SubtypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype> {
  const _$ApiColumnsCreateSelectionColumnRequestApplicationJson_SubtypeSerializer();

  static const Map<ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype, Object> _toWire =
      <ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype, Object>{
    ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype.progress: 'progress',
    ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype.stars: 'stars',
  };

  static const Map<Object, ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype> _fromWire =
      <Object, ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype>{
    'progress': ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype.progress,
    'stars': ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype.stars,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype];

  @override
  String get wireName => 'ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// Context type of the column creation.
class ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType extends EnumClass {
  const ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType._(super.name);

  /// `table`
  static const ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType table =
      _$apiColumnsCreateSelectionColumnRequestApplicationJsonBaseNodeTypeTable;

  /// `view`
  static const ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType view =
      _$apiColumnsCreateSelectionColumnRequestApplicationJsonBaseNodeTypeView;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType> get values =>
      _$apiColumnsCreateSelectionColumnRequestApplicationJsonBaseNodeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType valueOf(String name) =>
      _$valueOfApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType> get serializer =>
      const _$ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeTypeSerializer();
}

class _$ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeTypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType> {
  const _$ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeTypeSerializer();

  static const Map<ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType, Object> _toWire =
      <ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType, Object>{
    ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType.table: 'table',
    ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType.view: 'view',
  };

  static const Map<Object, ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType> _fromWire =
      <Object, ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType>{
    'table': ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType.table,
    'view': ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType.view,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType];

  @override
  String get wireName => 'ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateSelectionColumnRequestApplicationJsonInterface {
  static final _$selectedViewIds = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(int)]),
  )! as BuiltList<int>;

  static final _$mandatory = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$baseNodeType = _$jsonSerializers.deserialize(
    'table',
    specifiedType: const FullType(ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType),
  )! as ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType;

  /// Context of the column creation.
  int get baseNodeId;

  /// Title.
  String get title;

  /// Json array{id: int, label: string} with options that can be selected, eg [{"id": 1, "label": "first"},{"id": 2, "label": "second"}].
  String get selectionOptions;

  /// Json int|int[] for default selected option(s), eg 5 or ["1", "8"].
  String? get selectionDefault;

  /// Subtype for the new column.
  ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype? get subtype;

  /// Description.
  String? get description;

  /// View IDs where this columns should be added.
  BuiltList<int>? get selectedViewIds;

  /// Is mandatory.
  bool get mandatory;

  /// Context type of the column creation.
  ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType get baseNodeType;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateSelectionColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateSelectionColumnRequestApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateSelectionColumnRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateSelectionColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateSelectionColumnRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateSelectionColumnRequestApplicationJsonInterfaceBuilder b) {
    b.selectedViewIds.replace(_$selectedViewIds);
    b.mandatory = _$mandatory;
    b.baseNodeType = _$baseNodeType;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateSelectionColumnRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateSelectionColumnRequestApplicationJson
    implements
        $ApiColumnsCreateSelectionColumnRequestApplicationJsonInterface,
        Built<ApiColumnsCreateSelectionColumnRequestApplicationJson,
            ApiColumnsCreateSelectionColumnRequestApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateSelectionColumnRequestApplicationJson object using the builder pattern.
  factory ApiColumnsCreateSelectionColumnRequestApplicationJson([
    void Function(ApiColumnsCreateSelectionColumnRequestApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateSelectionColumnRequestApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateSelectionColumnRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateSelectionColumnRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateSelectionColumnRequestApplicationJson.
  static Serializer<ApiColumnsCreateSelectionColumnRequestApplicationJson> get serializer =>
      _$apiColumnsCreateSelectionColumnRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateSelectionColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateSelectionColumnRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateSelectionColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateSelectionColumnRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Column get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs
    implements
        $ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterface,
        Built<ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs,
            ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs([
    void Function(ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs.
  static Serializer<ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs> get serializer =>
      _$apiColumnsCreateSelectionColumnResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateSelectionColumnResponseApplicationJsonInterface {
  ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateSelectionColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateSelectionColumnResponseApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateSelectionColumnResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateSelectionColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateSelectionColumnResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateSelectionColumnResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateSelectionColumnResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateSelectionColumnResponseApplicationJson
    implements
        $ApiColumnsCreateSelectionColumnResponseApplicationJsonInterface,
        Built<ApiColumnsCreateSelectionColumnResponseApplicationJson,
            ApiColumnsCreateSelectionColumnResponseApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateSelectionColumnResponseApplicationJson object using the builder pattern.
  factory ApiColumnsCreateSelectionColumnResponseApplicationJson([
    void Function(ApiColumnsCreateSelectionColumnResponseApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateSelectionColumnResponseApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateSelectionColumnResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateSelectionColumnResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateSelectionColumnResponseApplicationJson.
  static Serializer<ApiColumnsCreateSelectionColumnResponseApplicationJson> get serializer =>
      _$apiColumnsCreateSelectionColumnResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateSelectionColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateSelectionColumnResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateSelectionColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateSelectionColumnResponseApplicationJsonInterface._validate(b);
  }
}

/// For a subtype 'date' you can set 'today'. For a main type or subtype 'time' you can set to 'now'.
class ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault extends EnumClass {
  const ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault._(super.name);

  /// `today`
  static const ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault today =
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonDatetimeDefaultToday;

  /// `now`
  static const ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault now =
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonDatetimeDefaultNow;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault> get values =>
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonDatetimeDefaultValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault valueOf(String name) =>
      _$valueOfApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault> get serializer =>
      const _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefaultSerializer();
}

class _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefaultSerializer
    implements PrimitiveSerializer<ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault> {
  const _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefaultSerializer();

  static const Map<ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault, Object> _toWire =
      <ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault, Object>{
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault.today: 'today',
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault.now: 'now',
  };

  static const Map<Object, ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault> _fromWire =
      <Object, ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault>{
    'today': ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault.today,
    'now': ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault.now,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault];

  @override
  String get wireName => 'ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// Subtype for the new column.
class ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype extends EnumClass {
  const ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype._(super.name);

  /// `progress`
  static const ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype progress =
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonSubtypeProgress;

  /// `stars`
  static const ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype stars =
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonSubtypeStars;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype> get values =>
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonSubtypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype valueOf(String name) =>
      _$valueOfApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype> get serializer =>
      const _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_SubtypeSerializer();
}

class _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_SubtypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype> {
  const _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_SubtypeSerializer();

  static const Map<ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype, Object> _toWire =
      <ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype, Object>{
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype.progress: 'progress',
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype.stars: 'stars',
  };

  static const Map<Object, ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype> _fromWire =
      <Object, ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype>{
    'progress': ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype.progress,
    'stars': ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype.stars,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype];

  @override
  String get wireName => 'ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// Context type of the column creation.
class ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType extends EnumClass {
  const ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType._(super.name);

  /// `table`
  static const ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType table =
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonBaseNodeTypeTable;

  /// `view`
  static const ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType view =
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonBaseNodeTypeView;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType> get values =>
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonBaseNodeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType valueOf(String name) =>
      _$valueOfApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType> get serializer =>
      const _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeTypeSerializer();
}

class _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeTypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType> {
  const _$ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeTypeSerializer();

  static const Map<ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType, Object> _toWire =
      <ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType, Object>{
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType.table: 'table',
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType.view: 'view',
  };

  static const Map<Object, ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType> _fromWire =
      <Object, ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType>{
    'table': ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType.table,
    'view': ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType.view,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType];

  @override
  String get wireName => 'ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterface {
  static final _$selectedViewIds = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(int)]),
  )! as BuiltList<int>;

  static final _$mandatory = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$baseNodeType = _$jsonSerializers.deserialize(
    'table',
    specifiedType: const FullType(ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType),
  )! as ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType;

  /// Context of the column creation.
  int get baseNodeId;

  /// Title.
  String get title;

  /// For a subtype 'date' you can set 'today'. For a main type or subtype 'time' you can set to 'now'.
  ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault? get datetimeDefault;

  /// Subtype for the new column.
  ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype? get subtype;

  /// Description.
  String? get description;

  /// View IDs where this columns should be added.
  BuiltList<int>? get selectedViewIds;

  /// Is mandatory.
  bool get mandatory;

  /// Context type of the column creation.
  ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType get baseNodeType;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterfaceBuilder b) {
    b.selectedViewIds.replace(_$selectedViewIds);
    b.mandatory = _$mandatory;
    b.baseNodeType = _$baseNodeType;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateDatetimeColumnRequestApplicationJson
    implements
        $ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterface,
        Built<ApiColumnsCreateDatetimeColumnRequestApplicationJson,
            ApiColumnsCreateDatetimeColumnRequestApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateDatetimeColumnRequestApplicationJson object using the builder pattern.
  factory ApiColumnsCreateDatetimeColumnRequestApplicationJson([
    void Function(ApiColumnsCreateDatetimeColumnRequestApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateDatetimeColumnRequestApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateDatetimeColumnRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateDatetimeColumnRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateDatetimeColumnRequestApplicationJson.
  static Serializer<ApiColumnsCreateDatetimeColumnRequestApplicationJson> get serializer =>
      _$apiColumnsCreateDatetimeColumnRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateDatetimeColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateDatetimeColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateDatetimeColumnRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Column get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs
    implements
        $ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterface,
        Built<ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs,
            ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs([
    void Function(ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs.
  static Serializer<ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs> get serializer =>
      _$apiColumnsCreateDatetimeColumnResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterface {
  ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateDatetimeColumnResponseApplicationJson
    implements
        $ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterface,
        Built<ApiColumnsCreateDatetimeColumnResponseApplicationJson,
            ApiColumnsCreateDatetimeColumnResponseApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateDatetimeColumnResponseApplicationJson object using the builder pattern.
  factory ApiColumnsCreateDatetimeColumnResponseApplicationJson([
    void Function(ApiColumnsCreateDatetimeColumnResponseApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateDatetimeColumnResponseApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateDatetimeColumnResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateDatetimeColumnResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateDatetimeColumnResponseApplicationJson.
  static Serializer<ApiColumnsCreateDatetimeColumnResponseApplicationJson> get serializer =>
      _$apiColumnsCreateDatetimeColumnResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateDatetimeColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateDatetimeColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateDatetimeColumnResponseApplicationJsonInterface._validate(b);
  }
}

/// Context type of the column creation.
class ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType extends EnumClass {
  const ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType._(super.name);

  /// `table`
  static const ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType table =
      _$apiColumnsCreateUsergroupColumnRequestApplicationJsonBaseNodeTypeTable;

  /// `view`
  static const ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType view =
      _$apiColumnsCreateUsergroupColumnRequestApplicationJsonBaseNodeTypeView;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType> get values =>
      _$apiColumnsCreateUsergroupColumnRequestApplicationJsonBaseNodeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType valueOf(String name) =>
      _$valueOfApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType> get serializer =>
      const _$ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeTypeSerializer();
}

class _$ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeTypeSerializer
    implements PrimitiveSerializer<ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType> {
  const _$ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeTypeSerializer();

  static const Map<ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType, Object> _toWire =
      <ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType, Object>{
    ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType.table: 'table',
    ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType.view: 'view',
  };

  static const Map<Object, ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType> _fromWire =
      <Object, ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType>{
    'table': ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType.table,
    'view': ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType.view,
  };

  @override
  Iterable<Type> get types => const [ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType];

  @override
  String get wireName => 'ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType';

  @override
  Object serialize(
    Serializers serializers,
    ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterface {
  static final _$selectedViewIds = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(int)]),
  )! as BuiltList<int>;

  static final _$mandatory = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$baseNodeType = _$jsonSerializers.deserialize(
    'table',
    specifiedType: const FullType(ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType),
  )! as ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType;

  /// Context of the column creation.
  int get baseNodeId;

  /// Title.
  String get title;

  /// Json array{id: string, type: int}, eg [{"id": "admin", "type": 0}, {"id": "user1", "type": 0}].
  String? get usergroupDefault;

  /// Whether you can select multiple users or/and groups.
  bool? get usergroupMultipleItems;

  /// Whether you can select users.
  bool? get usergroupSelectUsers;

  /// Whether you can select groups.
  bool? get usergroupSelectGroups;

  /// Whether to show the user's status.
  bool? get showUserStatus;

  /// Description.
  String? get description;

  /// View IDs where this columns should be added.
  BuiltList<int>? get selectedViewIds;

  /// Is mandatory.
  bool get mandatory;

  /// Context type of the column creation.
  ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType get baseNodeType;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterfaceBuilder b) {
    b.selectedViewIds.replace(_$selectedViewIds);
    b.mandatory = _$mandatory;
    b.baseNodeType = _$baseNodeType;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateUsergroupColumnRequestApplicationJson
    implements
        $ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterface,
        Built<ApiColumnsCreateUsergroupColumnRequestApplicationJson,
            ApiColumnsCreateUsergroupColumnRequestApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateUsergroupColumnRequestApplicationJson object using the builder pattern.
  factory ApiColumnsCreateUsergroupColumnRequestApplicationJson([
    void Function(ApiColumnsCreateUsergroupColumnRequestApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateUsergroupColumnRequestApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateUsergroupColumnRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateUsergroupColumnRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateUsergroupColumnRequestApplicationJson.
  static Serializer<ApiColumnsCreateUsergroupColumnRequestApplicationJson> get serializer =>
      _$apiColumnsCreateUsergroupColumnRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateUsergroupColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateUsergroupColumnRequestApplicationJsonBuilder b) {
    $ApiColumnsCreateUsergroupColumnRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Column get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterfaceBuilder].
  $ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs
    implements
        $ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterface,
        Built<ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs,
            ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs([
    void Function(ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs.
  static Serializer<ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs> get serializer =>
      _$apiColumnsCreateUsergroupColumnResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsBuilder b) {
    $ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterface {
  ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterface rebuild(
    void Function($ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterfaceBuilder].
  $ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiColumnsCreateUsergroupColumnResponseApplicationJson
    implements
        $ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterface,
        Built<ApiColumnsCreateUsergroupColumnResponseApplicationJson,
            ApiColumnsCreateUsergroupColumnResponseApplicationJsonBuilder> {
  /// Creates a new ApiColumnsCreateUsergroupColumnResponseApplicationJson object using the builder pattern.
  factory ApiColumnsCreateUsergroupColumnResponseApplicationJson([
    void Function(ApiColumnsCreateUsergroupColumnResponseApplicationJsonBuilder)? b,
  ]) = _$ApiColumnsCreateUsergroupColumnResponseApplicationJson;

  // coverage:ignore-start
  const ApiColumnsCreateUsergroupColumnResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiColumnsCreateUsergroupColumnResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiColumnsCreateUsergroupColumnResponseApplicationJson.
  static Serializer<ApiColumnsCreateUsergroupColumnResponseApplicationJson> get serializer =>
      _$apiColumnsCreateUsergroupColumnResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiColumnsCreateUsergroupColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiColumnsCreateUsergroupColumnResponseApplicationJsonBuilder b) {
    $ApiColumnsCreateUsergroupColumnResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiFavoriteCreateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiFavoriteCreateResponseApplicationJson_OcsInterfaceBuilder].
  $ApiFavoriteCreateResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiFavoriteCreateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiFavoriteCreateResponseApplicationJson_OcsInterfaceBuilder].
  $ApiFavoriteCreateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiFavoriteCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiFavoriteCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiFavoriteCreateResponseApplicationJson_Ocs
    implements
        $ApiFavoriteCreateResponseApplicationJson_OcsInterface,
        Built<ApiFavoriteCreateResponseApplicationJson_Ocs, ApiFavoriteCreateResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiFavoriteCreateResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiFavoriteCreateResponseApplicationJson_Ocs([
    void Function(ApiFavoriteCreateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiFavoriteCreateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiFavoriteCreateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiFavoriteCreateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiFavoriteCreateResponseApplicationJson_Ocs.
  static Serializer<ApiFavoriteCreateResponseApplicationJson_Ocs> get serializer =>
      _$apiFavoriteCreateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiFavoriteCreateResponseApplicationJson_OcsBuilder b) {
    $ApiFavoriteCreateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiFavoriteCreateResponseApplicationJson_OcsBuilder b) {
    $ApiFavoriteCreateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiFavoriteCreateResponseApplicationJsonInterface {
  ApiFavoriteCreateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiFavoriteCreateResponseApplicationJsonInterfaceBuilder].
  $ApiFavoriteCreateResponseApplicationJsonInterface rebuild(
    void Function($ApiFavoriteCreateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiFavoriteCreateResponseApplicationJsonInterfaceBuilder].
  $ApiFavoriteCreateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiFavoriteCreateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiFavoriteCreateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiFavoriteCreateResponseApplicationJson
    implements
        $ApiFavoriteCreateResponseApplicationJsonInterface,
        Built<ApiFavoriteCreateResponseApplicationJson, ApiFavoriteCreateResponseApplicationJsonBuilder> {
  /// Creates a new ApiFavoriteCreateResponseApplicationJson object using the builder pattern.
  factory ApiFavoriteCreateResponseApplicationJson([
    void Function(ApiFavoriteCreateResponseApplicationJsonBuilder)? b,
  ]) = _$ApiFavoriteCreateResponseApplicationJson;

  // coverage:ignore-start
  const ApiFavoriteCreateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiFavoriteCreateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiFavoriteCreateResponseApplicationJson.
  static Serializer<ApiFavoriteCreateResponseApplicationJson> get serializer =>
      _$apiFavoriteCreateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiFavoriteCreateResponseApplicationJsonBuilder b) {
    $ApiFavoriteCreateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiFavoriteCreateResponseApplicationJsonBuilder b) {
    $ApiFavoriteCreateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiFavoriteDestroyResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiFavoriteDestroyResponseApplicationJson_OcsInterfaceBuilder].
  $ApiFavoriteDestroyResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiFavoriteDestroyResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiFavoriteDestroyResponseApplicationJson_OcsInterfaceBuilder].
  $ApiFavoriteDestroyResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiFavoriteDestroyResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiFavoriteDestroyResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiFavoriteDestroyResponseApplicationJson_Ocs
    implements
        $ApiFavoriteDestroyResponseApplicationJson_OcsInterface,
        Built<ApiFavoriteDestroyResponseApplicationJson_Ocs, ApiFavoriteDestroyResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiFavoriteDestroyResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiFavoriteDestroyResponseApplicationJson_Ocs([
    void Function(ApiFavoriteDestroyResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiFavoriteDestroyResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiFavoriteDestroyResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiFavoriteDestroyResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiFavoriteDestroyResponseApplicationJson_Ocs.
  static Serializer<ApiFavoriteDestroyResponseApplicationJson_Ocs> get serializer =>
      _$apiFavoriteDestroyResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiFavoriteDestroyResponseApplicationJson_OcsBuilder b) {
    $ApiFavoriteDestroyResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiFavoriteDestroyResponseApplicationJson_OcsBuilder b) {
    $ApiFavoriteDestroyResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiFavoriteDestroyResponseApplicationJsonInterface {
  ApiFavoriteDestroyResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiFavoriteDestroyResponseApplicationJsonInterfaceBuilder].
  $ApiFavoriteDestroyResponseApplicationJsonInterface rebuild(
    void Function($ApiFavoriteDestroyResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiFavoriteDestroyResponseApplicationJsonInterfaceBuilder].
  $ApiFavoriteDestroyResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiFavoriteDestroyResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiFavoriteDestroyResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiFavoriteDestroyResponseApplicationJson
    implements
        $ApiFavoriteDestroyResponseApplicationJsonInterface,
        Built<ApiFavoriteDestroyResponseApplicationJson, ApiFavoriteDestroyResponseApplicationJsonBuilder> {
  /// Creates a new ApiFavoriteDestroyResponseApplicationJson object using the builder pattern.
  factory ApiFavoriteDestroyResponseApplicationJson([
    void Function(ApiFavoriteDestroyResponseApplicationJsonBuilder)? b,
  ]) = _$ApiFavoriteDestroyResponseApplicationJson;

  // coverage:ignore-start
  const ApiFavoriteDestroyResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiFavoriteDestroyResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiFavoriteDestroyResponseApplicationJson.
  static Serializer<ApiFavoriteDestroyResponseApplicationJson> get serializer =>
      _$apiFavoriteDestroyResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiFavoriteDestroyResponseApplicationJsonBuilder b) {
    $ApiFavoriteDestroyResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiFavoriteDestroyResponseApplicationJsonBuilder b) {
    $ApiFavoriteDestroyResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $IndexInterface {
  BuiltList<Table> get tables;
  BuiltList<View> get views;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$IndexInterfaceBuilder].
  $IndexInterface rebuild(void Function($IndexInterfaceBuilder) updates);

  /// Converts the instance to a builder [$IndexInterfaceBuilder].
  $IndexInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($IndexInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($IndexInterfaceBuilder b) {}
}

abstract class Index implements $IndexInterface, Built<Index, IndexBuilder> {
  /// Creates a new Index object using the builder pattern.
  factory Index([void Function(IndexBuilder)? b]) = _$Index;

  // coverage:ignore-start
  const Index._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Index.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Index.
  static Serializer<Index> get serializer => _$indexSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(IndexBuilder b) {
    $IndexInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(IndexBuilder b) {
    $IndexInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiGeneralIndexResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Index get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGeneralIndexResponseApplicationJson_OcsInterfaceBuilder].
  $ApiGeneralIndexResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiGeneralIndexResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGeneralIndexResponseApplicationJson_OcsInterfaceBuilder].
  $ApiGeneralIndexResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGeneralIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGeneralIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiGeneralIndexResponseApplicationJson_Ocs
    implements
        $ApiGeneralIndexResponseApplicationJson_OcsInterface,
        Built<ApiGeneralIndexResponseApplicationJson_Ocs, ApiGeneralIndexResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiGeneralIndexResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiGeneralIndexResponseApplicationJson_Ocs([
    void Function(ApiGeneralIndexResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiGeneralIndexResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiGeneralIndexResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGeneralIndexResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGeneralIndexResponseApplicationJson_Ocs.
  static Serializer<ApiGeneralIndexResponseApplicationJson_Ocs> get serializer =>
      _$apiGeneralIndexResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGeneralIndexResponseApplicationJson_OcsBuilder b) {
    $ApiGeneralIndexResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGeneralIndexResponseApplicationJson_OcsBuilder b) {
    $ApiGeneralIndexResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiGeneralIndexResponseApplicationJsonInterface {
  ApiGeneralIndexResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGeneralIndexResponseApplicationJsonInterfaceBuilder].
  $ApiGeneralIndexResponseApplicationJsonInterface rebuild(
    void Function($ApiGeneralIndexResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGeneralIndexResponseApplicationJsonInterfaceBuilder].
  $ApiGeneralIndexResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGeneralIndexResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGeneralIndexResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiGeneralIndexResponseApplicationJson
    implements
        $ApiGeneralIndexResponseApplicationJsonInterface,
        Built<ApiGeneralIndexResponseApplicationJson, ApiGeneralIndexResponseApplicationJsonBuilder> {
  /// Creates a new ApiGeneralIndexResponseApplicationJson object using the builder pattern.
  factory ApiGeneralIndexResponseApplicationJson([void Function(ApiGeneralIndexResponseApplicationJsonBuilder)? b]) =
      _$ApiGeneralIndexResponseApplicationJson;

  // coverage:ignore-start
  const ApiGeneralIndexResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGeneralIndexResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGeneralIndexResponseApplicationJson.
  static Serializer<ApiGeneralIndexResponseApplicationJson> get serializer =>
      _$apiGeneralIndexResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGeneralIndexResponseApplicationJsonBuilder b) {
    $ApiGeneralIndexResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGeneralIndexResponseApplicationJsonBuilder b) {
    $ApiGeneralIndexResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesIndexResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Table> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesIndexResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesIndexResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiTablesIndexResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesIndexResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesIndexResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiTablesIndexResponseApplicationJson_Ocs
    implements
        $ApiTablesIndexResponseApplicationJson_OcsInterface,
        Built<ApiTablesIndexResponseApplicationJson_Ocs, ApiTablesIndexResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiTablesIndexResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiTablesIndexResponseApplicationJson_Ocs([
    void Function(ApiTablesIndexResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiTablesIndexResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiTablesIndexResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesIndexResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesIndexResponseApplicationJson_Ocs.
  static Serializer<ApiTablesIndexResponseApplicationJson_Ocs> get serializer =>
      _$apiTablesIndexResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesIndexResponseApplicationJson_OcsBuilder b) {
    $ApiTablesIndexResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesIndexResponseApplicationJson_OcsBuilder b) {
    $ApiTablesIndexResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesIndexResponseApplicationJsonInterface {
  ApiTablesIndexResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesIndexResponseApplicationJsonInterfaceBuilder].
  $ApiTablesIndexResponseApplicationJsonInterface rebuild(
    void Function($ApiTablesIndexResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesIndexResponseApplicationJsonInterfaceBuilder].
  $ApiTablesIndexResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesIndexResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesIndexResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesIndexResponseApplicationJson
    implements
        $ApiTablesIndexResponseApplicationJsonInterface,
        Built<ApiTablesIndexResponseApplicationJson, ApiTablesIndexResponseApplicationJsonBuilder> {
  /// Creates a new ApiTablesIndexResponseApplicationJson object using the builder pattern.
  factory ApiTablesIndexResponseApplicationJson([void Function(ApiTablesIndexResponseApplicationJsonBuilder)? b]) =
      _$ApiTablesIndexResponseApplicationJson;

  // coverage:ignore-start
  const ApiTablesIndexResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesIndexResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesIndexResponseApplicationJson.
  static Serializer<ApiTablesIndexResponseApplicationJson> get serializer =>
      _$apiTablesIndexResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesIndexResponseApplicationJsonBuilder b) {
    $ApiTablesIndexResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesIndexResponseApplicationJsonBuilder b) {
    $ApiTablesIndexResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesCreateRequestApplicationJsonInterface {
  static final _$template = _$jsonSerializers.deserialize(
    'custom',
    specifiedType: const FullType(String),
  )! as String;

  /// Title of the table.
  String get title;

  /// Emoji for the table.
  String? get emoji;

  /// Description for the table.
  String? get description;

  /// Template to use if wanted.
  String get template;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesCreateRequestApplicationJsonInterfaceBuilder].
  $ApiTablesCreateRequestApplicationJsonInterface rebuild(
    void Function($ApiTablesCreateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesCreateRequestApplicationJsonInterfaceBuilder].
  $ApiTablesCreateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesCreateRequestApplicationJsonInterfaceBuilder b) {
    b.template = _$template;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesCreateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesCreateRequestApplicationJson
    implements
        $ApiTablesCreateRequestApplicationJsonInterface,
        Built<ApiTablesCreateRequestApplicationJson, ApiTablesCreateRequestApplicationJsonBuilder> {
  /// Creates a new ApiTablesCreateRequestApplicationJson object using the builder pattern.
  factory ApiTablesCreateRequestApplicationJson([void Function(ApiTablesCreateRequestApplicationJsonBuilder)? b]) =
      _$ApiTablesCreateRequestApplicationJson;

  // coverage:ignore-start
  const ApiTablesCreateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesCreateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesCreateRequestApplicationJson.
  static Serializer<ApiTablesCreateRequestApplicationJson> get serializer =>
      _$apiTablesCreateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesCreateRequestApplicationJsonBuilder b) {
    $ApiTablesCreateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesCreateRequestApplicationJsonBuilder b) {
    $ApiTablesCreateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesCreateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Table get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesCreateResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesCreateResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiTablesCreateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesCreateResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesCreateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiTablesCreateResponseApplicationJson_Ocs
    implements
        $ApiTablesCreateResponseApplicationJson_OcsInterface,
        Built<ApiTablesCreateResponseApplicationJson_Ocs, ApiTablesCreateResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiTablesCreateResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiTablesCreateResponseApplicationJson_Ocs([
    void Function(ApiTablesCreateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiTablesCreateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiTablesCreateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesCreateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesCreateResponseApplicationJson_Ocs.
  static Serializer<ApiTablesCreateResponseApplicationJson_Ocs> get serializer =>
      _$apiTablesCreateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesCreateResponseApplicationJson_OcsBuilder b) {
    $ApiTablesCreateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesCreateResponseApplicationJson_OcsBuilder b) {
    $ApiTablesCreateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesCreateResponseApplicationJsonInterface {
  ApiTablesCreateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesCreateResponseApplicationJsonInterfaceBuilder].
  $ApiTablesCreateResponseApplicationJsonInterface rebuild(
    void Function($ApiTablesCreateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesCreateResponseApplicationJsonInterfaceBuilder].
  $ApiTablesCreateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesCreateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesCreateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesCreateResponseApplicationJson
    implements
        $ApiTablesCreateResponseApplicationJsonInterface,
        Built<ApiTablesCreateResponseApplicationJson, ApiTablesCreateResponseApplicationJsonBuilder> {
  /// Creates a new ApiTablesCreateResponseApplicationJson object using the builder pattern.
  factory ApiTablesCreateResponseApplicationJson([void Function(ApiTablesCreateResponseApplicationJsonBuilder)? b]) =
      _$ApiTablesCreateResponseApplicationJson;

  // coverage:ignore-start
  const ApiTablesCreateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesCreateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesCreateResponseApplicationJson.
  static Serializer<ApiTablesCreateResponseApplicationJson> get serializer =>
      _$apiTablesCreateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesCreateResponseApplicationJsonBuilder b) {
    $ApiTablesCreateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesCreateResponseApplicationJsonBuilder b) {
    $ApiTablesCreateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesShowResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Table get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesShowResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesShowResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiTablesShowResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesShowResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesShowResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesShowResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesShowResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiTablesShowResponseApplicationJson_Ocs
    implements
        $ApiTablesShowResponseApplicationJson_OcsInterface,
        Built<ApiTablesShowResponseApplicationJson_Ocs, ApiTablesShowResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiTablesShowResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiTablesShowResponseApplicationJson_Ocs([
    void Function(ApiTablesShowResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiTablesShowResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiTablesShowResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesShowResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesShowResponseApplicationJson_Ocs.
  static Serializer<ApiTablesShowResponseApplicationJson_Ocs> get serializer =>
      _$apiTablesShowResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesShowResponseApplicationJson_OcsBuilder b) {
    $ApiTablesShowResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesShowResponseApplicationJson_OcsBuilder b) {
    $ApiTablesShowResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesShowResponseApplicationJsonInterface {
  ApiTablesShowResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesShowResponseApplicationJsonInterfaceBuilder].
  $ApiTablesShowResponseApplicationJsonInterface rebuild(
    void Function($ApiTablesShowResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesShowResponseApplicationJsonInterfaceBuilder].
  $ApiTablesShowResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesShowResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesShowResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesShowResponseApplicationJson
    implements
        $ApiTablesShowResponseApplicationJsonInterface,
        Built<ApiTablesShowResponseApplicationJson, ApiTablesShowResponseApplicationJsonBuilder> {
  /// Creates a new ApiTablesShowResponseApplicationJson object using the builder pattern.
  factory ApiTablesShowResponseApplicationJson([void Function(ApiTablesShowResponseApplicationJsonBuilder)? b]) =
      _$ApiTablesShowResponseApplicationJson;

  // coverage:ignore-start
  const ApiTablesShowResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesShowResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesShowResponseApplicationJson.
  static Serializer<ApiTablesShowResponseApplicationJson> get serializer =>
      _$apiTablesShowResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesShowResponseApplicationJsonBuilder b) {
    $ApiTablesShowResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesShowResponseApplicationJsonBuilder b) {
    $ApiTablesShowResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesUpdateRequestApplicationJsonInterface {
  /// New table title.
  String? get title;

  /// New table emoji.
  String? get emoji;

  /// the tables description.
  String? get description;

  /// whether the table is archived.
  bool? get archived;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesUpdateRequestApplicationJsonInterfaceBuilder].
  $ApiTablesUpdateRequestApplicationJsonInterface rebuild(
    void Function($ApiTablesUpdateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesUpdateRequestApplicationJsonInterfaceBuilder].
  $ApiTablesUpdateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesUpdateRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesUpdateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesUpdateRequestApplicationJson
    implements
        $ApiTablesUpdateRequestApplicationJsonInterface,
        Built<ApiTablesUpdateRequestApplicationJson, ApiTablesUpdateRequestApplicationJsonBuilder> {
  /// Creates a new ApiTablesUpdateRequestApplicationJson object using the builder pattern.
  factory ApiTablesUpdateRequestApplicationJson([void Function(ApiTablesUpdateRequestApplicationJsonBuilder)? b]) =
      _$ApiTablesUpdateRequestApplicationJson;

  // coverage:ignore-start
  const ApiTablesUpdateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesUpdateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesUpdateRequestApplicationJson.
  static Serializer<ApiTablesUpdateRequestApplicationJson> get serializer =>
      _$apiTablesUpdateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesUpdateRequestApplicationJsonBuilder b) {
    $ApiTablesUpdateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesUpdateRequestApplicationJsonBuilder b) {
    $ApiTablesUpdateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesUpdateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Table get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesUpdateResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesUpdateResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiTablesUpdateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesUpdateResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesUpdateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesUpdateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesUpdateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiTablesUpdateResponseApplicationJson_Ocs
    implements
        $ApiTablesUpdateResponseApplicationJson_OcsInterface,
        Built<ApiTablesUpdateResponseApplicationJson_Ocs, ApiTablesUpdateResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiTablesUpdateResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiTablesUpdateResponseApplicationJson_Ocs([
    void Function(ApiTablesUpdateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiTablesUpdateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiTablesUpdateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesUpdateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesUpdateResponseApplicationJson_Ocs.
  static Serializer<ApiTablesUpdateResponseApplicationJson_Ocs> get serializer =>
      _$apiTablesUpdateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesUpdateResponseApplicationJson_OcsBuilder b) {
    $ApiTablesUpdateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesUpdateResponseApplicationJson_OcsBuilder b) {
    $ApiTablesUpdateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesUpdateResponseApplicationJsonInterface {
  ApiTablesUpdateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesUpdateResponseApplicationJsonInterfaceBuilder].
  $ApiTablesUpdateResponseApplicationJsonInterface rebuild(
    void Function($ApiTablesUpdateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesUpdateResponseApplicationJsonInterfaceBuilder].
  $ApiTablesUpdateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesUpdateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesUpdateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesUpdateResponseApplicationJson
    implements
        $ApiTablesUpdateResponseApplicationJsonInterface,
        Built<ApiTablesUpdateResponseApplicationJson, ApiTablesUpdateResponseApplicationJsonBuilder> {
  /// Creates a new ApiTablesUpdateResponseApplicationJson object using the builder pattern.
  factory ApiTablesUpdateResponseApplicationJson([void Function(ApiTablesUpdateResponseApplicationJsonBuilder)? b]) =
      _$ApiTablesUpdateResponseApplicationJson;

  // coverage:ignore-start
  const ApiTablesUpdateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesUpdateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesUpdateResponseApplicationJson.
  static Serializer<ApiTablesUpdateResponseApplicationJson> get serializer =>
      _$apiTablesUpdateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesUpdateResponseApplicationJsonBuilder b) {
    $ApiTablesUpdateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesUpdateResponseApplicationJsonBuilder b) {
    $ApiTablesUpdateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesDestroyResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Table get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesDestroyResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesDestroyResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiTablesDestroyResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesDestroyResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesDestroyResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesDestroyResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesDestroyResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiTablesDestroyResponseApplicationJson_Ocs
    implements
        $ApiTablesDestroyResponseApplicationJson_OcsInterface,
        Built<ApiTablesDestroyResponseApplicationJson_Ocs, ApiTablesDestroyResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiTablesDestroyResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiTablesDestroyResponseApplicationJson_Ocs([
    void Function(ApiTablesDestroyResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiTablesDestroyResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiTablesDestroyResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesDestroyResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesDestroyResponseApplicationJson_Ocs.
  static Serializer<ApiTablesDestroyResponseApplicationJson_Ocs> get serializer =>
      _$apiTablesDestroyResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesDestroyResponseApplicationJson_OcsBuilder b) {
    $ApiTablesDestroyResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesDestroyResponseApplicationJson_OcsBuilder b) {
    $ApiTablesDestroyResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesDestroyResponseApplicationJsonInterface {
  ApiTablesDestroyResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesDestroyResponseApplicationJsonInterfaceBuilder].
  $ApiTablesDestroyResponseApplicationJsonInterface rebuild(
    void Function($ApiTablesDestroyResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesDestroyResponseApplicationJsonInterfaceBuilder].
  $ApiTablesDestroyResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesDestroyResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesDestroyResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesDestroyResponseApplicationJson
    implements
        $ApiTablesDestroyResponseApplicationJsonInterface,
        Built<ApiTablesDestroyResponseApplicationJson, ApiTablesDestroyResponseApplicationJsonBuilder> {
  /// Creates a new ApiTablesDestroyResponseApplicationJson object using the builder pattern.
  factory ApiTablesDestroyResponseApplicationJson([void Function(ApiTablesDestroyResponseApplicationJsonBuilder)? b]) =
      _$ApiTablesDestroyResponseApplicationJson;

  // coverage:ignore-start
  const ApiTablesDestroyResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesDestroyResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesDestroyResponseApplicationJson.
  static Serializer<ApiTablesDestroyResponseApplicationJson> get serializer =>
      _$apiTablesDestroyResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesDestroyResponseApplicationJsonBuilder b) {
    $ApiTablesDestroyResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesDestroyResponseApplicationJsonBuilder b) {
    $ApiTablesDestroyResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesShowSchemeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Table get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesShowSchemeResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesShowSchemeResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiTablesShowSchemeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesShowSchemeResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesShowSchemeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesShowSchemeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesShowSchemeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiTablesShowSchemeResponseApplicationJson_Ocs
    implements
        $ApiTablesShowSchemeResponseApplicationJson_OcsInterface,
        Built<ApiTablesShowSchemeResponseApplicationJson_Ocs, ApiTablesShowSchemeResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiTablesShowSchemeResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiTablesShowSchemeResponseApplicationJson_Ocs([
    void Function(ApiTablesShowSchemeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiTablesShowSchemeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiTablesShowSchemeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesShowSchemeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesShowSchemeResponseApplicationJson_Ocs.
  static Serializer<ApiTablesShowSchemeResponseApplicationJson_Ocs> get serializer =>
      _$apiTablesShowSchemeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesShowSchemeResponseApplicationJson_OcsBuilder b) {
    $ApiTablesShowSchemeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesShowSchemeResponseApplicationJson_OcsBuilder b) {
    $ApiTablesShowSchemeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesShowSchemeResponseApplicationJsonInterface {
  ApiTablesShowSchemeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesShowSchemeResponseApplicationJsonInterfaceBuilder].
  $ApiTablesShowSchemeResponseApplicationJsonInterface rebuild(
    void Function($ApiTablesShowSchemeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesShowSchemeResponseApplicationJsonInterfaceBuilder].
  $ApiTablesShowSchemeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesShowSchemeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesShowSchemeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesShowSchemeResponseApplicationJson
    implements
        $ApiTablesShowSchemeResponseApplicationJsonInterface,
        Built<ApiTablesShowSchemeResponseApplicationJson, ApiTablesShowSchemeResponseApplicationJsonBuilder> {
  /// Creates a new ApiTablesShowSchemeResponseApplicationJson object using the builder pattern.
  factory ApiTablesShowSchemeResponseApplicationJson([
    void Function(ApiTablesShowSchemeResponseApplicationJsonBuilder)? b,
  ]) = _$ApiTablesShowSchemeResponseApplicationJson;

  // coverage:ignore-start
  const ApiTablesShowSchemeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesShowSchemeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesShowSchemeResponseApplicationJson.
  static Serializer<ApiTablesShowSchemeResponseApplicationJson> get serializer =>
      _$apiTablesShowSchemeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesShowSchemeResponseApplicationJsonBuilder b) {
    $ApiTablesShowSchemeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesShowSchemeResponseApplicationJsonBuilder b) {
    $ApiTablesShowSchemeResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesCreateFromSchemeRequestApplicationJsonInterface {
  /// title of new table.
  String get title;

  /// emoji.
  String get emoji;

  /// description.
  String get description;

  /// columns.
  BuiltList<Column> get columns;

  /// views.
  BuiltList<View> get views;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesCreateFromSchemeRequestApplicationJsonInterfaceBuilder].
  $ApiTablesCreateFromSchemeRequestApplicationJsonInterface rebuild(
    void Function($ApiTablesCreateFromSchemeRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesCreateFromSchemeRequestApplicationJsonInterfaceBuilder].
  $ApiTablesCreateFromSchemeRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesCreateFromSchemeRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesCreateFromSchemeRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesCreateFromSchemeRequestApplicationJson
    implements
        $ApiTablesCreateFromSchemeRequestApplicationJsonInterface,
        Built<ApiTablesCreateFromSchemeRequestApplicationJson, ApiTablesCreateFromSchemeRequestApplicationJsonBuilder> {
  /// Creates a new ApiTablesCreateFromSchemeRequestApplicationJson object using the builder pattern.
  factory ApiTablesCreateFromSchemeRequestApplicationJson([
    void Function(ApiTablesCreateFromSchemeRequestApplicationJsonBuilder)? b,
  ]) = _$ApiTablesCreateFromSchemeRequestApplicationJson;

  // coverage:ignore-start
  const ApiTablesCreateFromSchemeRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesCreateFromSchemeRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesCreateFromSchemeRequestApplicationJson.
  static Serializer<ApiTablesCreateFromSchemeRequestApplicationJson> get serializer =>
      _$apiTablesCreateFromSchemeRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesCreateFromSchemeRequestApplicationJsonBuilder b) {
    $ApiTablesCreateFromSchemeRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesCreateFromSchemeRequestApplicationJsonBuilder b) {
    $ApiTablesCreateFromSchemeRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Table get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiTablesCreateFromSchemeResponseApplicationJson_Ocs
    implements
        $ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterface,
        Built<ApiTablesCreateFromSchemeResponseApplicationJson_Ocs,
            ApiTablesCreateFromSchemeResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiTablesCreateFromSchemeResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiTablesCreateFromSchemeResponseApplicationJson_Ocs([
    void Function(ApiTablesCreateFromSchemeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiTablesCreateFromSchemeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiTablesCreateFromSchemeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesCreateFromSchemeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesCreateFromSchemeResponseApplicationJson_Ocs.
  static Serializer<ApiTablesCreateFromSchemeResponseApplicationJson_Ocs> get serializer =>
      _$apiTablesCreateFromSchemeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesCreateFromSchemeResponseApplicationJson_OcsBuilder b) {
    $ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesCreateFromSchemeResponseApplicationJson_OcsBuilder b) {
    $ApiTablesCreateFromSchemeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesCreateFromSchemeResponseApplicationJsonInterface {
  ApiTablesCreateFromSchemeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesCreateFromSchemeResponseApplicationJsonInterfaceBuilder].
  $ApiTablesCreateFromSchemeResponseApplicationJsonInterface rebuild(
    void Function($ApiTablesCreateFromSchemeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesCreateFromSchemeResponseApplicationJsonInterfaceBuilder].
  $ApiTablesCreateFromSchemeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesCreateFromSchemeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesCreateFromSchemeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesCreateFromSchemeResponseApplicationJson
    implements
        $ApiTablesCreateFromSchemeResponseApplicationJsonInterface,
        Built<ApiTablesCreateFromSchemeResponseApplicationJson,
            ApiTablesCreateFromSchemeResponseApplicationJsonBuilder> {
  /// Creates a new ApiTablesCreateFromSchemeResponseApplicationJson object using the builder pattern.
  factory ApiTablesCreateFromSchemeResponseApplicationJson([
    void Function(ApiTablesCreateFromSchemeResponseApplicationJsonBuilder)? b,
  ]) = _$ApiTablesCreateFromSchemeResponseApplicationJson;

  // coverage:ignore-start
  const ApiTablesCreateFromSchemeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesCreateFromSchemeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesCreateFromSchemeResponseApplicationJson.
  static Serializer<ApiTablesCreateFromSchemeResponseApplicationJson> get serializer =>
      _$apiTablesCreateFromSchemeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesCreateFromSchemeResponseApplicationJsonBuilder b) {
    $ApiTablesCreateFromSchemeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesCreateFromSchemeResponseApplicationJsonBuilder b) {
    $ApiTablesCreateFromSchemeResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesTransferRequestApplicationJsonInterface {
  /// New user ID.
  String get newOwnerUserId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesTransferRequestApplicationJsonInterfaceBuilder].
  $ApiTablesTransferRequestApplicationJsonInterface rebuild(
    void Function($ApiTablesTransferRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesTransferRequestApplicationJsonInterfaceBuilder].
  $ApiTablesTransferRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesTransferRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesTransferRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesTransferRequestApplicationJson
    implements
        $ApiTablesTransferRequestApplicationJsonInterface,
        Built<ApiTablesTransferRequestApplicationJson, ApiTablesTransferRequestApplicationJsonBuilder> {
  /// Creates a new ApiTablesTransferRequestApplicationJson object using the builder pattern.
  factory ApiTablesTransferRequestApplicationJson([void Function(ApiTablesTransferRequestApplicationJsonBuilder)? b]) =
      _$ApiTablesTransferRequestApplicationJson;

  // coverage:ignore-start
  const ApiTablesTransferRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesTransferRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesTransferRequestApplicationJson.
  static Serializer<ApiTablesTransferRequestApplicationJson> get serializer =>
      _$apiTablesTransferRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesTransferRequestApplicationJsonBuilder b) {
    $ApiTablesTransferRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesTransferRequestApplicationJsonBuilder b) {
    $ApiTablesTransferRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesTransferResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Table get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesTransferResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesTransferResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiTablesTransferResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesTransferResponseApplicationJson_OcsInterfaceBuilder].
  $ApiTablesTransferResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesTransferResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesTransferResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiTablesTransferResponseApplicationJson_Ocs
    implements
        $ApiTablesTransferResponseApplicationJson_OcsInterface,
        Built<ApiTablesTransferResponseApplicationJson_Ocs, ApiTablesTransferResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiTablesTransferResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiTablesTransferResponseApplicationJson_Ocs([
    void Function(ApiTablesTransferResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiTablesTransferResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiTablesTransferResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesTransferResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesTransferResponseApplicationJson_Ocs.
  static Serializer<ApiTablesTransferResponseApplicationJson_Ocs> get serializer =>
      _$apiTablesTransferResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesTransferResponseApplicationJson_OcsBuilder b) {
    $ApiTablesTransferResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesTransferResponseApplicationJson_OcsBuilder b) {
    $ApiTablesTransferResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiTablesTransferResponseApplicationJsonInterface {
  ApiTablesTransferResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiTablesTransferResponseApplicationJsonInterfaceBuilder].
  $ApiTablesTransferResponseApplicationJsonInterface rebuild(
    void Function($ApiTablesTransferResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiTablesTransferResponseApplicationJsonInterfaceBuilder].
  $ApiTablesTransferResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiTablesTransferResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiTablesTransferResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiTablesTransferResponseApplicationJson
    implements
        $ApiTablesTransferResponseApplicationJsonInterface,
        Built<ApiTablesTransferResponseApplicationJson, ApiTablesTransferResponseApplicationJsonBuilder> {
  /// Creates a new ApiTablesTransferResponseApplicationJson object using the builder pattern.
  factory ApiTablesTransferResponseApplicationJson([
    void Function(ApiTablesTransferResponseApplicationJsonBuilder)? b,
  ]) = _$ApiTablesTransferResponseApplicationJson;

  // coverage:ignore-start
  const ApiTablesTransferResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiTablesTransferResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiTablesTransferResponseApplicationJson.
  static Serializer<ApiTablesTransferResponseApplicationJson> get serializer =>
      _$apiTablesTransferResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiTablesTransferResponseApplicationJsonBuilder b) {
    $ApiTablesTransferResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiTablesTransferResponseApplicationJsonBuilder b) {
    $ApiTablesTransferResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextInterface {
  int get id;
  String get name;
  String get iconName;
  String get description;
  String get owner;
  int get ownerType;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextInterfaceBuilder].
  $ContextInterface rebuild(void Function($ContextInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ContextInterfaceBuilder].
  $ContextInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextInterfaceBuilder b) {}
}

abstract class Context implements $ContextInterface, Built<Context, ContextBuilder> {
  /// Creates a new Context object using the builder pattern.
  factory Context([void Function(ContextBuilder)? b]) = _$Context;

  // coverage:ignore-start
  const Context._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Context.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Context.
  static Serializer<Context> get serializer => _$contextSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextBuilder b) {
    $ContextInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextBuilder b) {
    $ContextInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextIndexResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Context> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextIndexResponseApplicationJson_OcsInterfaceBuilder].
  $ContextIndexResponseApplicationJson_OcsInterface rebuild(
    void Function($ContextIndexResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextIndexResponseApplicationJson_OcsInterfaceBuilder].
  $ContextIndexResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ContextIndexResponseApplicationJson_Ocs
    implements
        $ContextIndexResponseApplicationJson_OcsInterface,
        Built<ContextIndexResponseApplicationJson_Ocs, ContextIndexResponseApplicationJson_OcsBuilder> {
  /// Creates a new ContextIndexResponseApplicationJson_Ocs object using the builder pattern.
  factory ContextIndexResponseApplicationJson_Ocs([void Function(ContextIndexResponseApplicationJson_OcsBuilder)? b]) =
      _$ContextIndexResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ContextIndexResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextIndexResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextIndexResponseApplicationJson_Ocs.
  static Serializer<ContextIndexResponseApplicationJson_Ocs> get serializer =>
      _$contextIndexResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextIndexResponseApplicationJson_OcsBuilder b) {
    $ContextIndexResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextIndexResponseApplicationJson_OcsBuilder b) {
    $ContextIndexResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextIndexResponseApplicationJsonInterface {
  ContextIndexResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextIndexResponseApplicationJsonInterfaceBuilder].
  $ContextIndexResponseApplicationJsonInterface rebuild(
    void Function($ContextIndexResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextIndexResponseApplicationJsonInterfaceBuilder].
  $ContextIndexResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextIndexResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextIndexResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextIndexResponseApplicationJson
    implements
        $ContextIndexResponseApplicationJsonInterface,
        Built<ContextIndexResponseApplicationJson, ContextIndexResponseApplicationJsonBuilder> {
  /// Creates a new ContextIndexResponseApplicationJson object using the builder pattern.
  factory ContextIndexResponseApplicationJson([void Function(ContextIndexResponseApplicationJsonBuilder)? b]) =
      _$ContextIndexResponseApplicationJson;

  // coverage:ignore-start
  const ContextIndexResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextIndexResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextIndexResponseApplicationJson.
  static Serializer<ContextIndexResponseApplicationJson> get serializer =>
      _$contextIndexResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextIndexResponseApplicationJsonBuilder b) {
    $ContextIndexResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextIndexResponseApplicationJsonBuilder b) {
    $ContextIndexResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextCreateRequestApplicationJson_NodesInterface {
  int get id;
  int get type;
  int? get permissions;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextCreateRequestApplicationJson_NodesInterfaceBuilder].
  $ContextCreateRequestApplicationJson_NodesInterface rebuild(
    void Function($ContextCreateRequestApplicationJson_NodesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextCreateRequestApplicationJson_NodesInterfaceBuilder].
  $ContextCreateRequestApplicationJson_NodesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextCreateRequestApplicationJson_NodesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextCreateRequestApplicationJson_NodesInterfaceBuilder b) {}
}

abstract class ContextCreateRequestApplicationJson_Nodes
    implements
        $ContextCreateRequestApplicationJson_NodesInterface,
        Built<ContextCreateRequestApplicationJson_Nodes, ContextCreateRequestApplicationJson_NodesBuilder> {
  /// Creates a new ContextCreateRequestApplicationJson_Nodes object using the builder pattern.
  factory ContextCreateRequestApplicationJson_Nodes([
    void Function(ContextCreateRequestApplicationJson_NodesBuilder)? b,
  ]) = _$ContextCreateRequestApplicationJson_Nodes;

  // coverage:ignore-start
  const ContextCreateRequestApplicationJson_Nodes._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextCreateRequestApplicationJson_Nodes.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextCreateRequestApplicationJson_Nodes.
  static Serializer<ContextCreateRequestApplicationJson_Nodes> get serializer =>
      _$contextCreateRequestApplicationJsonNodesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextCreateRequestApplicationJson_NodesBuilder b) {
    $ContextCreateRequestApplicationJson_NodesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextCreateRequestApplicationJson_NodesBuilder b) {
    $ContextCreateRequestApplicationJson_NodesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextCreateRequestApplicationJsonInterface {
  static final _$description = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$nodes = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(ContextCreateRequestApplicationJson_Nodes)]),
  )! as BuiltList<ContextCreateRequestApplicationJson_Nodes>;

  /// Name of the context.
  String get name;

  /// Material design icon name of the context.
  String get iconName;

  /// Descriptive text of the context.
  String get description;

  /// optional nodes to be connected to this context.
  BuiltList<ContextCreateRequestApplicationJson_Nodes> get nodes;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextCreateRequestApplicationJsonInterfaceBuilder].
  $ContextCreateRequestApplicationJsonInterface rebuild(
    void Function($ContextCreateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextCreateRequestApplicationJsonInterfaceBuilder].
  $ContextCreateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextCreateRequestApplicationJsonInterfaceBuilder b) {
    b.description = _$description;
    b.nodes.replace(_$nodes);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextCreateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextCreateRequestApplicationJson
    implements
        $ContextCreateRequestApplicationJsonInterface,
        Built<ContextCreateRequestApplicationJson, ContextCreateRequestApplicationJsonBuilder> {
  /// Creates a new ContextCreateRequestApplicationJson object using the builder pattern.
  factory ContextCreateRequestApplicationJson([void Function(ContextCreateRequestApplicationJsonBuilder)? b]) =
      _$ContextCreateRequestApplicationJson;

  // coverage:ignore-start
  const ContextCreateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextCreateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextCreateRequestApplicationJson.
  static Serializer<ContextCreateRequestApplicationJson> get serializer =>
      _$contextCreateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextCreateRequestApplicationJsonBuilder b) {
    $ContextCreateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextCreateRequestApplicationJsonBuilder b) {
    $ContextCreateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextCreateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Context get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextCreateResponseApplicationJson_OcsInterfaceBuilder].
  $ContextCreateResponseApplicationJson_OcsInterface rebuild(
    void Function($ContextCreateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextCreateResponseApplicationJson_OcsInterfaceBuilder].
  $ContextCreateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ContextCreateResponseApplicationJson_Ocs
    implements
        $ContextCreateResponseApplicationJson_OcsInterface,
        Built<ContextCreateResponseApplicationJson_Ocs, ContextCreateResponseApplicationJson_OcsBuilder> {
  /// Creates a new ContextCreateResponseApplicationJson_Ocs object using the builder pattern.
  factory ContextCreateResponseApplicationJson_Ocs([
    void Function(ContextCreateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ContextCreateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ContextCreateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextCreateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextCreateResponseApplicationJson_Ocs.
  static Serializer<ContextCreateResponseApplicationJson_Ocs> get serializer =>
      _$contextCreateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextCreateResponseApplicationJson_OcsBuilder b) {
    $ContextCreateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextCreateResponseApplicationJson_OcsBuilder b) {
    $ContextCreateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextCreateResponseApplicationJsonInterface {
  ContextCreateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextCreateResponseApplicationJsonInterfaceBuilder].
  $ContextCreateResponseApplicationJsonInterface rebuild(
    void Function($ContextCreateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextCreateResponseApplicationJsonInterfaceBuilder].
  $ContextCreateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextCreateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextCreateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextCreateResponseApplicationJson
    implements
        $ContextCreateResponseApplicationJsonInterface,
        Built<ContextCreateResponseApplicationJson, ContextCreateResponseApplicationJsonBuilder> {
  /// Creates a new ContextCreateResponseApplicationJson object using the builder pattern.
  factory ContextCreateResponseApplicationJson([void Function(ContextCreateResponseApplicationJsonBuilder)? b]) =
      _$ContextCreateResponseApplicationJson;

  // coverage:ignore-start
  const ContextCreateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextCreateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextCreateResponseApplicationJson.
  static Serializer<ContextCreateResponseApplicationJson> get serializer =>
      _$contextCreateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextCreateResponseApplicationJsonBuilder b) {
    $ContextCreateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextCreateResponseApplicationJsonBuilder b) {
    $ContextCreateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextShowResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Context get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextShowResponseApplicationJson_OcsInterfaceBuilder].
  $ContextShowResponseApplicationJson_OcsInterface rebuild(
    void Function($ContextShowResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextShowResponseApplicationJson_OcsInterfaceBuilder].
  $ContextShowResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextShowResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextShowResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ContextShowResponseApplicationJson_Ocs
    implements
        $ContextShowResponseApplicationJson_OcsInterface,
        Built<ContextShowResponseApplicationJson_Ocs, ContextShowResponseApplicationJson_OcsBuilder> {
  /// Creates a new ContextShowResponseApplicationJson_Ocs object using the builder pattern.
  factory ContextShowResponseApplicationJson_Ocs([void Function(ContextShowResponseApplicationJson_OcsBuilder)? b]) =
      _$ContextShowResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ContextShowResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextShowResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextShowResponseApplicationJson_Ocs.
  static Serializer<ContextShowResponseApplicationJson_Ocs> get serializer =>
      _$contextShowResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextShowResponseApplicationJson_OcsBuilder b) {
    $ContextShowResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextShowResponseApplicationJson_OcsBuilder b) {
    $ContextShowResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextShowResponseApplicationJsonInterface {
  ContextShowResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextShowResponseApplicationJsonInterfaceBuilder].
  $ContextShowResponseApplicationJsonInterface rebuild(
    void Function($ContextShowResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextShowResponseApplicationJsonInterfaceBuilder].
  $ContextShowResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextShowResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextShowResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextShowResponseApplicationJson
    implements
        $ContextShowResponseApplicationJsonInterface,
        Built<ContextShowResponseApplicationJson, ContextShowResponseApplicationJsonBuilder> {
  /// Creates a new ContextShowResponseApplicationJson object using the builder pattern.
  factory ContextShowResponseApplicationJson([void Function(ContextShowResponseApplicationJsonBuilder)? b]) =
      _$ContextShowResponseApplicationJson;

  // coverage:ignore-start
  const ContextShowResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextShowResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextShowResponseApplicationJson.
  static Serializer<ContextShowResponseApplicationJson> get serializer =>
      _$contextShowResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextShowResponseApplicationJsonBuilder b) {
    $ContextShowResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextShowResponseApplicationJsonBuilder b) {
    $ContextShowResponseApplicationJsonInterface._validate(b);
  }
}

/// provide this parameter to set a new list of nodes.
@BuiltValue(instantiable: false)
sealed class $ContextUpdateRequestApplicationJson_NodesInterface {
  int get id;
  int get type;
  int get permissions;
  int get order;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextUpdateRequestApplicationJson_NodesInterfaceBuilder].
  $ContextUpdateRequestApplicationJson_NodesInterface rebuild(
    void Function($ContextUpdateRequestApplicationJson_NodesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextUpdateRequestApplicationJson_NodesInterfaceBuilder].
  $ContextUpdateRequestApplicationJson_NodesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextUpdateRequestApplicationJson_NodesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextUpdateRequestApplicationJson_NodesInterfaceBuilder b) {}
}

/// provide this parameter to set a new list of nodes.
abstract class ContextUpdateRequestApplicationJson_Nodes
    implements
        $ContextUpdateRequestApplicationJson_NodesInterface,
        Built<ContextUpdateRequestApplicationJson_Nodes, ContextUpdateRequestApplicationJson_NodesBuilder> {
  /// Creates a new ContextUpdateRequestApplicationJson_Nodes object using the builder pattern.
  factory ContextUpdateRequestApplicationJson_Nodes([
    void Function(ContextUpdateRequestApplicationJson_NodesBuilder)? b,
  ]) = _$ContextUpdateRequestApplicationJson_Nodes;

  // coverage:ignore-start
  const ContextUpdateRequestApplicationJson_Nodes._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextUpdateRequestApplicationJson_Nodes.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextUpdateRequestApplicationJson_Nodes.
  static Serializer<ContextUpdateRequestApplicationJson_Nodes> get serializer =>
      _$contextUpdateRequestApplicationJsonNodesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextUpdateRequestApplicationJson_NodesBuilder b) {
    $ContextUpdateRequestApplicationJson_NodesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextUpdateRequestApplicationJson_NodesBuilder b) {
    $ContextUpdateRequestApplicationJson_NodesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextUpdateRequestApplicationJsonInterface {
  /// provide this parameter to set a new name.
  String? get name;

  /// provide this parameter to set a new icon.
  String? get iconName;

  /// provide this parameter to set a new description.
  String? get description;

  /// provide this parameter to set a new list of nodes.
  ContextUpdateRequestApplicationJson_Nodes? get nodes;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextUpdateRequestApplicationJsonInterfaceBuilder].
  $ContextUpdateRequestApplicationJsonInterface rebuild(
    void Function($ContextUpdateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextUpdateRequestApplicationJsonInterfaceBuilder].
  $ContextUpdateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextUpdateRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextUpdateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextUpdateRequestApplicationJson
    implements
        $ContextUpdateRequestApplicationJsonInterface,
        Built<ContextUpdateRequestApplicationJson, ContextUpdateRequestApplicationJsonBuilder> {
  /// Creates a new ContextUpdateRequestApplicationJson object using the builder pattern.
  factory ContextUpdateRequestApplicationJson([void Function(ContextUpdateRequestApplicationJsonBuilder)? b]) =
      _$ContextUpdateRequestApplicationJson;

  // coverage:ignore-start
  const ContextUpdateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextUpdateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextUpdateRequestApplicationJson.
  static Serializer<ContextUpdateRequestApplicationJson> get serializer =>
      _$contextUpdateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextUpdateRequestApplicationJsonBuilder b) {
    $ContextUpdateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextUpdateRequestApplicationJsonBuilder b) {
    $ContextUpdateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextUpdateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Context get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextUpdateResponseApplicationJson_OcsInterfaceBuilder].
  $ContextUpdateResponseApplicationJson_OcsInterface rebuild(
    void Function($ContextUpdateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextUpdateResponseApplicationJson_OcsInterfaceBuilder].
  $ContextUpdateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextUpdateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextUpdateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ContextUpdateResponseApplicationJson_Ocs
    implements
        $ContextUpdateResponseApplicationJson_OcsInterface,
        Built<ContextUpdateResponseApplicationJson_Ocs, ContextUpdateResponseApplicationJson_OcsBuilder> {
  /// Creates a new ContextUpdateResponseApplicationJson_Ocs object using the builder pattern.
  factory ContextUpdateResponseApplicationJson_Ocs([
    void Function(ContextUpdateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ContextUpdateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ContextUpdateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextUpdateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextUpdateResponseApplicationJson_Ocs.
  static Serializer<ContextUpdateResponseApplicationJson_Ocs> get serializer =>
      _$contextUpdateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextUpdateResponseApplicationJson_OcsBuilder b) {
    $ContextUpdateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextUpdateResponseApplicationJson_OcsBuilder b) {
    $ContextUpdateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextUpdateResponseApplicationJsonInterface {
  ContextUpdateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextUpdateResponseApplicationJsonInterfaceBuilder].
  $ContextUpdateResponseApplicationJsonInterface rebuild(
    void Function($ContextUpdateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextUpdateResponseApplicationJsonInterfaceBuilder].
  $ContextUpdateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextUpdateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextUpdateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextUpdateResponseApplicationJson
    implements
        $ContextUpdateResponseApplicationJsonInterface,
        Built<ContextUpdateResponseApplicationJson, ContextUpdateResponseApplicationJsonBuilder> {
  /// Creates a new ContextUpdateResponseApplicationJson object using the builder pattern.
  factory ContextUpdateResponseApplicationJson([void Function(ContextUpdateResponseApplicationJsonBuilder)? b]) =
      _$ContextUpdateResponseApplicationJson;

  // coverage:ignore-start
  const ContextUpdateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextUpdateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextUpdateResponseApplicationJson.
  static Serializer<ContextUpdateResponseApplicationJson> get serializer =>
      _$contextUpdateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextUpdateResponseApplicationJsonBuilder b) {
    $ContextUpdateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextUpdateResponseApplicationJsonBuilder b) {
    $ContextUpdateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextDestroyResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Context get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextDestroyResponseApplicationJson_OcsInterfaceBuilder].
  $ContextDestroyResponseApplicationJson_OcsInterface rebuild(
    void Function($ContextDestroyResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextDestroyResponseApplicationJson_OcsInterfaceBuilder].
  $ContextDestroyResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextDestroyResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextDestroyResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ContextDestroyResponseApplicationJson_Ocs
    implements
        $ContextDestroyResponseApplicationJson_OcsInterface,
        Built<ContextDestroyResponseApplicationJson_Ocs, ContextDestroyResponseApplicationJson_OcsBuilder> {
  /// Creates a new ContextDestroyResponseApplicationJson_Ocs object using the builder pattern.
  factory ContextDestroyResponseApplicationJson_Ocs([
    void Function(ContextDestroyResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ContextDestroyResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ContextDestroyResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextDestroyResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextDestroyResponseApplicationJson_Ocs.
  static Serializer<ContextDestroyResponseApplicationJson_Ocs> get serializer =>
      _$contextDestroyResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextDestroyResponseApplicationJson_OcsBuilder b) {
    $ContextDestroyResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextDestroyResponseApplicationJson_OcsBuilder b) {
    $ContextDestroyResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextDestroyResponseApplicationJsonInterface {
  ContextDestroyResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextDestroyResponseApplicationJsonInterfaceBuilder].
  $ContextDestroyResponseApplicationJsonInterface rebuild(
    void Function($ContextDestroyResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextDestroyResponseApplicationJsonInterfaceBuilder].
  $ContextDestroyResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextDestroyResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextDestroyResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextDestroyResponseApplicationJson
    implements
        $ContextDestroyResponseApplicationJsonInterface,
        Built<ContextDestroyResponseApplicationJson, ContextDestroyResponseApplicationJsonBuilder> {
  /// Creates a new ContextDestroyResponseApplicationJson object using the builder pattern.
  factory ContextDestroyResponseApplicationJson([void Function(ContextDestroyResponseApplicationJsonBuilder)? b]) =
      _$ContextDestroyResponseApplicationJson;

  // coverage:ignore-start
  const ContextDestroyResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextDestroyResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextDestroyResponseApplicationJson.
  static Serializer<ContextDestroyResponseApplicationJson> get serializer =>
      _$contextDestroyResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextDestroyResponseApplicationJsonBuilder b) {
    $ContextDestroyResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextDestroyResponseApplicationJsonBuilder b) {
    $ContextDestroyResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextTransferRequestApplicationJsonInterface {
  static final _$newOwnerType = _$jsonSerializers.deserialize(
    0,
    specifiedType: const FullType(int),
  )! as int;

  /// ID of the new owner.
  String get newOwnerId;

  /// any Application::OWNER_TYPE_* constant.
  int get newOwnerType;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextTransferRequestApplicationJsonInterfaceBuilder].
  $ContextTransferRequestApplicationJsonInterface rebuild(
    void Function($ContextTransferRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextTransferRequestApplicationJsonInterfaceBuilder].
  $ContextTransferRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextTransferRequestApplicationJsonInterfaceBuilder b) {
    b.newOwnerType = _$newOwnerType;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextTransferRequestApplicationJsonInterfaceBuilder b) {
    _i6.checkNumber(
      b.newOwnerType,
      'newOwnerType',
      maximum: 0,
      minimum: 0,
    );
  }
}

abstract class ContextTransferRequestApplicationJson
    implements
        $ContextTransferRequestApplicationJsonInterface,
        Built<ContextTransferRequestApplicationJson, ContextTransferRequestApplicationJsonBuilder> {
  /// Creates a new ContextTransferRequestApplicationJson object using the builder pattern.
  factory ContextTransferRequestApplicationJson([void Function(ContextTransferRequestApplicationJsonBuilder)? b]) =
      _$ContextTransferRequestApplicationJson;

  // coverage:ignore-start
  const ContextTransferRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextTransferRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextTransferRequestApplicationJson.
  static Serializer<ContextTransferRequestApplicationJson> get serializer =>
      _$contextTransferRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextTransferRequestApplicationJsonBuilder b) {
    $ContextTransferRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextTransferRequestApplicationJsonBuilder b) {
    $ContextTransferRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextTransferResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Context get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextTransferResponseApplicationJson_OcsInterfaceBuilder].
  $ContextTransferResponseApplicationJson_OcsInterface rebuild(
    void Function($ContextTransferResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextTransferResponseApplicationJson_OcsInterfaceBuilder].
  $ContextTransferResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextTransferResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextTransferResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ContextTransferResponseApplicationJson_Ocs
    implements
        $ContextTransferResponseApplicationJson_OcsInterface,
        Built<ContextTransferResponseApplicationJson_Ocs, ContextTransferResponseApplicationJson_OcsBuilder> {
  /// Creates a new ContextTransferResponseApplicationJson_Ocs object using the builder pattern.
  factory ContextTransferResponseApplicationJson_Ocs([
    void Function(ContextTransferResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ContextTransferResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ContextTransferResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextTransferResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextTransferResponseApplicationJson_Ocs.
  static Serializer<ContextTransferResponseApplicationJson_Ocs> get serializer =>
      _$contextTransferResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextTransferResponseApplicationJson_OcsBuilder b) {
    $ContextTransferResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextTransferResponseApplicationJson_OcsBuilder b) {
    $ContextTransferResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextTransferResponseApplicationJsonInterface {
  ContextTransferResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextTransferResponseApplicationJsonInterfaceBuilder].
  $ContextTransferResponseApplicationJsonInterface rebuild(
    void Function($ContextTransferResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextTransferResponseApplicationJsonInterfaceBuilder].
  $ContextTransferResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextTransferResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextTransferResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextTransferResponseApplicationJson
    implements
        $ContextTransferResponseApplicationJsonInterface,
        Built<ContextTransferResponseApplicationJson, ContextTransferResponseApplicationJsonBuilder> {
  /// Creates a new ContextTransferResponseApplicationJson object using the builder pattern.
  factory ContextTransferResponseApplicationJson([void Function(ContextTransferResponseApplicationJsonBuilder)? b]) =
      _$ContextTransferResponseApplicationJson;

  // coverage:ignore-start
  const ContextTransferResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextTransferResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextTransferResponseApplicationJson.
  static Serializer<ContextTransferResponseApplicationJson> get serializer =>
      _$contextTransferResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextTransferResponseApplicationJsonBuilder b) {
    $ContextTransferResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextTransferResponseApplicationJsonBuilder b) {
    $ContextTransferResponseApplicationJsonInterface._validate(b);
  }
}

/// content items with it and order values.
@BuiltValue(instantiable: false)
sealed class $ContextUpdateContentOrderRequestApplicationJson_ContentInterface {
  int get id;
  int get order;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextUpdateContentOrderRequestApplicationJson_ContentInterfaceBuilder].
  $ContextUpdateContentOrderRequestApplicationJson_ContentInterface rebuild(
    void Function($ContextUpdateContentOrderRequestApplicationJson_ContentInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextUpdateContentOrderRequestApplicationJson_ContentInterfaceBuilder].
  $ContextUpdateContentOrderRequestApplicationJson_ContentInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextUpdateContentOrderRequestApplicationJson_ContentInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextUpdateContentOrderRequestApplicationJson_ContentInterfaceBuilder b) {}
}

/// content items with it and order values.
abstract class ContextUpdateContentOrderRequestApplicationJson_Content
    implements
        $ContextUpdateContentOrderRequestApplicationJson_ContentInterface,
        Built<ContextUpdateContentOrderRequestApplicationJson_Content,
            ContextUpdateContentOrderRequestApplicationJson_ContentBuilder> {
  /// Creates a new ContextUpdateContentOrderRequestApplicationJson_Content object using the builder pattern.
  factory ContextUpdateContentOrderRequestApplicationJson_Content([
    void Function(ContextUpdateContentOrderRequestApplicationJson_ContentBuilder)? b,
  ]) = _$ContextUpdateContentOrderRequestApplicationJson_Content;

  // coverage:ignore-start
  const ContextUpdateContentOrderRequestApplicationJson_Content._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextUpdateContentOrderRequestApplicationJson_Content.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextUpdateContentOrderRequestApplicationJson_Content.
  static Serializer<ContextUpdateContentOrderRequestApplicationJson_Content> get serializer =>
      _$contextUpdateContentOrderRequestApplicationJsonContentSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextUpdateContentOrderRequestApplicationJson_ContentBuilder b) {
    $ContextUpdateContentOrderRequestApplicationJson_ContentInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextUpdateContentOrderRequestApplicationJson_ContentBuilder b) {
    $ContextUpdateContentOrderRequestApplicationJson_ContentInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextUpdateContentOrderRequestApplicationJsonInterface {
  /// content items with it and order values.
  ContextUpdateContentOrderRequestApplicationJson_Content get content;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextUpdateContentOrderRequestApplicationJsonInterfaceBuilder].
  $ContextUpdateContentOrderRequestApplicationJsonInterface rebuild(
    void Function($ContextUpdateContentOrderRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextUpdateContentOrderRequestApplicationJsonInterfaceBuilder].
  $ContextUpdateContentOrderRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextUpdateContentOrderRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextUpdateContentOrderRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextUpdateContentOrderRequestApplicationJson
    implements
        $ContextUpdateContentOrderRequestApplicationJsonInterface,
        Built<ContextUpdateContentOrderRequestApplicationJson, ContextUpdateContentOrderRequestApplicationJsonBuilder> {
  /// Creates a new ContextUpdateContentOrderRequestApplicationJson object using the builder pattern.
  factory ContextUpdateContentOrderRequestApplicationJson([
    void Function(ContextUpdateContentOrderRequestApplicationJsonBuilder)? b,
  ]) = _$ContextUpdateContentOrderRequestApplicationJson;

  // coverage:ignore-start
  const ContextUpdateContentOrderRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextUpdateContentOrderRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextUpdateContentOrderRequestApplicationJson.
  static Serializer<ContextUpdateContentOrderRequestApplicationJson> get serializer =>
      _$contextUpdateContentOrderRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextUpdateContentOrderRequestApplicationJsonBuilder b) {
    $ContextUpdateContentOrderRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextUpdateContentOrderRequestApplicationJsonBuilder b) {
    $ContextUpdateContentOrderRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextUpdateContentOrderResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Context get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextUpdateContentOrderResponseApplicationJson_OcsInterfaceBuilder].
  $ContextUpdateContentOrderResponseApplicationJson_OcsInterface rebuild(
    void Function($ContextUpdateContentOrderResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextUpdateContentOrderResponseApplicationJson_OcsInterfaceBuilder].
  $ContextUpdateContentOrderResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextUpdateContentOrderResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextUpdateContentOrderResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ContextUpdateContentOrderResponseApplicationJson_Ocs
    implements
        $ContextUpdateContentOrderResponseApplicationJson_OcsInterface,
        Built<ContextUpdateContentOrderResponseApplicationJson_Ocs,
            ContextUpdateContentOrderResponseApplicationJson_OcsBuilder> {
  /// Creates a new ContextUpdateContentOrderResponseApplicationJson_Ocs object using the builder pattern.
  factory ContextUpdateContentOrderResponseApplicationJson_Ocs([
    void Function(ContextUpdateContentOrderResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ContextUpdateContentOrderResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ContextUpdateContentOrderResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextUpdateContentOrderResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextUpdateContentOrderResponseApplicationJson_Ocs.
  static Serializer<ContextUpdateContentOrderResponseApplicationJson_Ocs> get serializer =>
      _$contextUpdateContentOrderResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextUpdateContentOrderResponseApplicationJson_OcsBuilder b) {
    $ContextUpdateContentOrderResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextUpdateContentOrderResponseApplicationJson_OcsBuilder b) {
    $ContextUpdateContentOrderResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContextUpdateContentOrderResponseApplicationJsonInterface {
  ContextUpdateContentOrderResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContextUpdateContentOrderResponseApplicationJsonInterfaceBuilder].
  $ContextUpdateContentOrderResponseApplicationJsonInterface rebuild(
    void Function($ContextUpdateContentOrderResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ContextUpdateContentOrderResponseApplicationJsonInterfaceBuilder].
  $ContextUpdateContentOrderResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContextUpdateContentOrderResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContextUpdateContentOrderResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ContextUpdateContentOrderResponseApplicationJson
    implements
        $ContextUpdateContentOrderResponseApplicationJsonInterface,
        Built<ContextUpdateContentOrderResponseApplicationJson,
            ContextUpdateContentOrderResponseApplicationJsonBuilder> {
  /// Creates a new ContextUpdateContentOrderResponseApplicationJson object using the builder pattern.
  factory ContextUpdateContentOrderResponseApplicationJson([
    void Function(ContextUpdateContentOrderResponseApplicationJsonBuilder)? b,
  ]) = _$ContextUpdateContentOrderResponseApplicationJson;

  // coverage:ignore-start
  const ContextUpdateContentOrderResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContextUpdateContentOrderResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContextUpdateContentOrderResponseApplicationJson.
  static Serializer<ContextUpdateContentOrderResponseApplicationJson> get serializer =>
      _$contextUpdateContentOrderResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContextUpdateContentOrderResponseApplicationJsonBuilder b) {
    $ContextUpdateContentOrderResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContextUpdateContentOrderResponseApplicationJsonBuilder b) {
    $ContextUpdateContentOrderResponseApplicationJsonInterface._validate(b);
  }
}

class RowocsCreateRowNodeCollection extends EnumClass {
  const RowocsCreateRowNodeCollection._(super.name);

  /// `tables`
  static const RowocsCreateRowNodeCollection tables = _$rowocsCreateRowNodeCollectionTables;

  /// `views`
  static const RowocsCreateRowNodeCollection views = _$rowocsCreateRowNodeCollectionViews;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<RowocsCreateRowNodeCollection> get values => _$rowocsCreateRowNodeCollectionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static RowocsCreateRowNodeCollection valueOf(String name) => _$valueOfRowocsCreateRowNodeCollection(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for RowocsCreateRowNodeCollection.
  @BuiltValueSerializer(custom: true)
  static Serializer<RowocsCreateRowNodeCollection> get serializer => const _$RowocsCreateRowNodeCollectionSerializer();
}

class _$RowocsCreateRowNodeCollectionSerializer implements PrimitiveSerializer<RowocsCreateRowNodeCollection> {
  const _$RowocsCreateRowNodeCollectionSerializer();

  static const Map<RowocsCreateRowNodeCollection, Object> _toWire = <RowocsCreateRowNodeCollection, Object>{
    RowocsCreateRowNodeCollection.tables: 'tables',
    RowocsCreateRowNodeCollection.views: 'views',
  };

  static const Map<Object, RowocsCreateRowNodeCollection> _fromWire = <Object, RowocsCreateRowNodeCollection>{
    'tables': RowocsCreateRowNodeCollection.tables,
    'views': RowocsCreateRowNodeCollection.views,
  };

  @override
  Iterable<Type> get types => const [RowocsCreateRowNodeCollection];

  @override
  String get wireName => 'RowocsCreateRowNodeCollection';

  @override
  Object serialize(
    Serializers serializers,
    RowocsCreateRowNodeCollection object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  RowocsCreateRowNodeCollection deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// An array containing the column identifiers and their values.
typedef RowocsCreateRowRequestApplicationJson_Data = ({
  BuiltMap<String, JsonObject>? builtMapStringJsonObject,
  String? string
});

@BuiltValue(instantiable: false)
sealed class $RowocsCreateRowRequestApplicationJsonInterface {
  /// An array containing the column identifiers and their values.
  RowocsCreateRowRequestApplicationJson_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RowocsCreateRowRequestApplicationJsonInterfaceBuilder].
  $RowocsCreateRowRequestApplicationJsonInterface rebuild(
    void Function($RowocsCreateRowRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RowocsCreateRowRequestApplicationJsonInterfaceBuilder].
  $RowocsCreateRowRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RowocsCreateRowRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RowocsCreateRowRequestApplicationJsonInterfaceBuilder b) {
    b.data?.validateOneOf();
  }
}

abstract class RowocsCreateRowRequestApplicationJson
    implements
        $RowocsCreateRowRequestApplicationJsonInterface,
        Built<RowocsCreateRowRequestApplicationJson, RowocsCreateRowRequestApplicationJsonBuilder> {
  /// Creates a new RowocsCreateRowRequestApplicationJson object using the builder pattern.
  factory RowocsCreateRowRequestApplicationJson([void Function(RowocsCreateRowRequestApplicationJsonBuilder)? b]) =
      _$RowocsCreateRowRequestApplicationJson;

  // coverage:ignore-start
  const RowocsCreateRowRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RowocsCreateRowRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RowocsCreateRowRequestApplicationJson.
  static Serializer<RowocsCreateRowRequestApplicationJson> get serializer =>
      _$rowocsCreateRowRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RowocsCreateRowRequestApplicationJsonBuilder b) {
    $RowocsCreateRowRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RowocsCreateRowRequestApplicationJsonBuilder b) {
    $RowocsCreateRowRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RowocsCreateRowResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Row get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RowocsCreateRowResponseApplicationJson_OcsInterfaceBuilder].
  $RowocsCreateRowResponseApplicationJson_OcsInterface rebuild(
    void Function($RowocsCreateRowResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RowocsCreateRowResponseApplicationJson_OcsInterfaceBuilder].
  $RowocsCreateRowResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RowocsCreateRowResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RowocsCreateRowResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class RowocsCreateRowResponseApplicationJson_Ocs
    implements
        $RowocsCreateRowResponseApplicationJson_OcsInterface,
        Built<RowocsCreateRowResponseApplicationJson_Ocs, RowocsCreateRowResponseApplicationJson_OcsBuilder> {
  /// Creates a new RowocsCreateRowResponseApplicationJson_Ocs object using the builder pattern.
  factory RowocsCreateRowResponseApplicationJson_Ocs([
    void Function(RowocsCreateRowResponseApplicationJson_OcsBuilder)? b,
  ]) = _$RowocsCreateRowResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const RowocsCreateRowResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RowocsCreateRowResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RowocsCreateRowResponseApplicationJson_Ocs.
  static Serializer<RowocsCreateRowResponseApplicationJson_Ocs> get serializer =>
      _$rowocsCreateRowResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RowocsCreateRowResponseApplicationJson_OcsBuilder b) {
    $RowocsCreateRowResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RowocsCreateRowResponseApplicationJson_OcsBuilder b) {
    $RowocsCreateRowResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RowocsCreateRowResponseApplicationJsonInterface {
  RowocsCreateRowResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RowocsCreateRowResponseApplicationJsonInterfaceBuilder].
  $RowocsCreateRowResponseApplicationJsonInterface rebuild(
    void Function($RowocsCreateRowResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RowocsCreateRowResponseApplicationJsonInterfaceBuilder].
  $RowocsCreateRowResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RowocsCreateRowResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RowocsCreateRowResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class RowocsCreateRowResponseApplicationJson
    implements
        $RowocsCreateRowResponseApplicationJsonInterface,
        Built<RowocsCreateRowResponseApplicationJson, RowocsCreateRowResponseApplicationJsonBuilder> {
  /// Creates a new RowocsCreateRowResponseApplicationJson object using the builder pattern.
  factory RowocsCreateRowResponseApplicationJson([void Function(RowocsCreateRowResponseApplicationJsonBuilder)? b]) =
      _$RowocsCreateRowResponseApplicationJson;

  // coverage:ignore-start
  const RowocsCreateRowResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RowocsCreateRowResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RowocsCreateRowResponseApplicationJson.
  static Serializer<RowocsCreateRowResponseApplicationJson> get serializer =>
      _$rowocsCreateRowResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RowocsCreateRowResponseApplicationJsonBuilder b) {
    $RowocsCreateRowResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RowocsCreateRowResponseApplicationJsonBuilder b) {
    $RowocsCreateRowResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_TablesInterface {
  bool get enabled;
  String get version;
  BuiltList<String> get apiVersions;
  BuiltList<String> get features;
  @BuiltValueField(wireName: 'column_types')
  BuiltList<String> get columnTypes;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_TablesInterfaceBuilder].
  $Capabilities_TablesInterface rebuild(void Function($Capabilities_TablesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Capabilities_TablesInterfaceBuilder].
  $Capabilities_TablesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_TablesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_TablesInterfaceBuilder b) {}
}

abstract class Capabilities_Tables
    implements $Capabilities_TablesInterface, Built<Capabilities_Tables, Capabilities_TablesBuilder> {
  /// Creates a new Capabilities_Tables object using the builder pattern.
  factory Capabilities_Tables([void Function(Capabilities_TablesBuilder)? b]) = _$Capabilities_Tables;

  // coverage:ignore-start
  const Capabilities_Tables._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_Tables.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_Tables.
  static Serializer<Capabilities_Tables> get serializer => _$capabilitiesTablesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_TablesBuilder b) {
    $Capabilities_TablesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_TablesBuilder b) {
    $Capabilities_TablesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CapabilitiesInterface {
  Capabilities_Tables get tables;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterface rebuild(void Function($CapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CapabilitiesInterfaceBuilder b) {}
}

abstract class Capabilities implements $CapabilitiesInterface, Built<Capabilities, CapabilitiesBuilder> {
  /// Creates a new Capabilities object using the builder pattern.
  factory Capabilities([void Function(CapabilitiesBuilder)? b]) = _$Capabilities;

  // coverage:ignore-start
  const Capabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities.
  static Serializer<Capabilities> get serializer => _$capabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CapabilitiesBuilder b) {
    $CapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CapabilitiesBuilder b) {
    $CapabilitiesInterface._validate(b);
  }
}

/// Serialization extension for `View_Filter_Value`.
extension $View_Filter_ValueExtension on View_Filter_Value {
  /// Serializer for View_Filter_Value.
  @BuiltValueSerializer(custom: true)
  static Serializer<View_Filter_Value> get serializer => $b6d67dc2a96424d2f407f8e51557f3deExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static View_Filter_Value fromJson(Object? json) => $b6d67dc2a96424d2f407f8e51557f3deExtension._fromJson(json);
}

/// Serialization extension for `Api1UpdateViewRequestApplicationJson_Data3_Value_Value`.
extension $Api1UpdateViewRequestApplicationJson_Data3_Value_ValueExtension
    on Api1UpdateViewRequestApplicationJson_Data3_Value_Value {
  /// Serializer for Api1UpdateViewRequestApplicationJson_Data3_Value_Value.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateViewRequestApplicationJson_Data3_Value_Value> get serializer =>
      $b6d67dc2a96424d2f407f8e51557f3deExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static Api1UpdateViewRequestApplicationJson_Data3_Value_Value fromJson(Object? json) =>
      $b6d67dc2a96424d2f407f8e51557f3deExtension._fromJson(json);
}

/// Serialization extension for `Api1UpdateViewRequestApplicationJson_Data`.
extension $Api1UpdateViewRequestApplicationJson_DataExtension on Api1UpdateViewRequestApplicationJson_Data {
  /// Serializer for Api1UpdateViewRequestApplicationJson_Data.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateViewRequestApplicationJson_Data> get serializer =>
      $8518b50581163640f148d1e5a6a7db2cExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static Api1UpdateViewRequestApplicationJson_Data fromJson(Object? json) =>
      $8518b50581163640f148d1e5a6a7db2cExtension._fromJson(json);
}

/// Serialization extension for `Api1CreateRowInTableRequestApplicationJson_Data`.
extension $Api1CreateRowInTableRequestApplicationJson_DataExtension on Api1CreateRowInTableRequestApplicationJson_Data {
  /// Serializer for Api1CreateRowInTableRequestApplicationJson_Data.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1CreateRowInTableRequestApplicationJson_Data> get serializer =>
      $3f5057013fe375112018fdacdf7c966aExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static Api1CreateRowInTableRequestApplicationJson_Data fromJson(Object? json) =>
      $3f5057013fe375112018fdacdf7c966aExtension._fromJson(json);
}

/// Serialization extension for `Api1CreateRowInViewRequestApplicationJson_Data`.
extension $Api1CreateRowInViewRequestApplicationJson_DataExtension on Api1CreateRowInViewRequestApplicationJson_Data {
  /// Serializer for Api1CreateRowInViewRequestApplicationJson_Data.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1CreateRowInViewRequestApplicationJson_Data> get serializer =>
      $3f5057013fe375112018fdacdf7c966aExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static Api1CreateRowInViewRequestApplicationJson_Data fromJson(Object? json) =>
      $3f5057013fe375112018fdacdf7c966aExtension._fromJson(json);
}

/// Serialization extension for `Api1UpdateRowRequestApplicationJson_Data`.
extension $Api1UpdateRowRequestApplicationJson_DataExtension on Api1UpdateRowRequestApplicationJson_Data {
  /// Serializer for Api1UpdateRowRequestApplicationJson_Data.
  @BuiltValueSerializer(custom: true)
  static Serializer<Api1UpdateRowRequestApplicationJson_Data> get serializer =>
      $3f5057013fe375112018fdacdf7c966aExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static Api1UpdateRowRequestApplicationJson_Data fromJson(Object? json) =>
      $3f5057013fe375112018fdacdf7c966aExtension._fromJson(json);
}

/// Serialization extension for `RowocsCreateRowRequestApplicationJson_Data`.
extension $RowocsCreateRowRequestApplicationJson_DataExtension on RowocsCreateRowRequestApplicationJson_Data {
  /// Serializer for RowocsCreateRowRequestApplicationJson_Data.
  @BuiltValueSerializer(custom: true)
  static Serializer<RowocsCreateRowRequestApplicationJson_Data> get serializer =>
      $3f5057013fe375112018fdacdf7c966aExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static RowocsCreateRowRequestApplicationJson_Data fromJson(Object? json) =>
      $3f5057013fe375112018fdacdf7c966aExtension._fromJson(json);
}

typedef _$b6d67dc2a96424d2f407f8e51557f3de = ({num? $num, String? string});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $b6d67dc2a96424d2f407f8e51557f3deExtension on _$b6d67dc2a96424d2f407f8e51557f3de {
  List<dynamic> get _values => [$num, string];
  List<String> get _names => const [r'$num', 'string'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i6.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i6.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$b6d67dc2a96424d2f407f8e51557f3de> get _serializer =>
      const _$b6d67dc2a96424d2f407f8e51557f3deSerializer();
  static _$b6d67dc2a96424d2f407f8e51557f3de _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$b6d67dc2a96424d2f407f8e51557f3deSerializer implements PrimitiveSerializer<_$b6d67dc2a96424d2f407f8e51557f3de> {
  const _$b6d67dc2a96424d2f407f8e51557f3deSerializer();

  @override
  Iterable<Type> get types => const [_$b6d67dc2a96424d2f407f8e51557f3de];

  @override
  String get wireName => r'_$b6d67dc2a96424d2f407f8e51557f3de';

  @override
  Object serialize(
    Serializers serializers,
    _$b6d67dc2a96424d2f407f8e51557f3de object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.$num;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(num))!;
    }
    value = object.string;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(String))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$b6d67dc2a96424d2f407f8e51557f3de deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    num? $num;
    try {
      $num = serializers.deserialize(
        data,
        specifiedType: const FullType(num),
      )! as num;
    } catch (_) {}
    String? string;
    try {
      string = serializers.deserialize(
        data,
        specifiedType: const FullType(String),
      )! as String;
    } catch (_) {}
    return ($num: $num, string: string);
  }
}

typedef _$8518b50581163640f148d1e5a6a7db2c = ({
  Api1UpdateViewRequestApplicationJson_Data0? api1UpdateViewRequestApplicationJsonData0,
  Api1UpdateViewRequestApplicationJson_Data1? api1UpdateViewRequestApplicationJsonData1,
  Api1UpdateViewRequestApplicationJson_Data2? api1UpdateViewRequestApplicationJsonData2,
  Api1UpdateViewRequestApplicationJson_Data3? api1UpdateViewRequestApplicationJsonData3
});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $8518b50581163640f148d1e5a6a7db2cExtension on _$8518b50581163640f148d1e5a6a7db2c {
  List<dynamic> get _values => [
        api1UpdateViewRequestApplicationJsonData0,
        api1UpdateViewRequestApplicationJsonData1,
        api1UpdateViewRequestApplicationJsonData2,
        api1UpdateViewRequestApplicationJsonData3,
      ];
  List<String> get _names => const [
        'api1UpdateViewRequestApplicationJsonData0',
        'api1UpdateViewRequestApplicationJsonData1',
        'api1UpdateViewRequestApplicationJsonData2',
        'api1UpdateViewRequestApplicationJsonData3',
      ];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i6.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i6.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$8518b50581163640f148d1e5a6a7db2c> get _serializer =>
      const _$8518b50581163640f148d1e5a6a7db2cSerializer();
  static _$8518b50581163640f148d1e5a6a7db2c _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$8518b50581163640f148d1e5a6a7db2cSerializer implements PrimitiveSerializer<_$8518b50581163640f148d1e5a6a7db2c> {
  const _$8518b50581163640f148d1e5a6a7db2cSerializer();

  @override
  Iterable<Type> get types => const [_$8518b50581163640f148d1e5a6a7db2c];

  @override
  String get wireName => r'_$8518b50581163640f148d1e5a6a7db2c';

  @override
  Object serialize(
    Serializers serializers,
    _$8518b50581163640f148d1e5a6a7db2c object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.api1UpdateViewRequestApplicationJsonData0;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(Api1UpdateViewRequestApplicationJson_Data0))!;
    }
    value = object.api1UpdateViewRequestApplicationJsonData1;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(Api1UpdateViewRequestApplicationJson_Data1))!;
    }
    value = object.api1UpdateViewRequestApplicationJsonData2;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(Api1UpdateViewRequestApplicationJson_Data2))!;
    }
    value = object.api1UpdateViewRequestApplicationJsonData3;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(Api1UpdateViewRequestApplicationJson_Data3))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$8518b50581163640f148d1e5a6a7db2c deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    Api1UpdateViewRequestApplicationJson_Data0? api1UpdateViewRequestApplicationJsonData0;
    try {
      api1UpdateViewRequestApplicationJsonData0 = serializers.deserialize(
        data,
        specifiedType: const FullType(Api1UpdateViewRequestApplicationJson_Data0),
      )! as Api1UpdateViewRequestApplicationJson_Data0;
    } catch (_) {}
    Api1UpdateViewRequestApplicationJson_Data1? api1UpdateViewRequestApplicationJsonData1;
    try {
      api1UpdateViewRequestApplicationJsonData1 = serializers.deserialize(
        data,
        specifiedType: const FullType(Api1UpdateViewRequestApplicationJson_Data1),
      )! as Api1UpdateViewRequestApplicationJson_Data1;
    } catch (_) {}
    Api1UpdateViewRequestApplicationJson_Data2? api1UpdateViewRequestApplicationJsonData2;
    try {
      api1UpdateViewRequestApplicationJsonData2 = serializers.deserialize(
        data,
        specifiedType: const FullType(Api1UpdateViewRequestApplicationJson_Data2),
      )! as Api1UpdateViewRequestApplicationJson_Data2;
    } catch (_) {}
    Api1UpdateViewRequestApplicationJson_Data3? api1UpdateViewRequestApplicationJsonData3;
    try {
      api1UpdateViewRequestApplicationJsonData3 = serializers.deserialize(
        data,
        specifiedType: const FullType(Api1UpdateViewRequestApplicationJson_Data3),
      )! as Api1UpdateViewRequestApplicationJson_Data3;
    } catch (_) {}
    return (
      api1UpdateViewRequestApplicationJsonData0: api1UpdateViewRequestApplicationJsonData0,
      api1UpdateViewRequestApplicationJsonData1: api1UpdateViewRequestApplicationJsonData1,
      api1UpdateViewRequestApplicationJsonData2: api1UpdateViewRequestApplicationJsonData2,
      api1UpdateViewRequestApplicationJsonData3: api1UpdateViewRequestApplicationJsonData3
    );
  }
}

typedef _$3f5057013fe375112018fdacdf7c966a = ({BuiltMap<String, JsonObject>? builtMapStringJsonObject, String? string});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $3f5057013fe375112018fdacdf7c966aExtension on _$3f5057013fe375112018fdacdf7c966a {
  List<dynamic> get _values => [builtMapStringJsonObject, string];
  List<String> get _names => const ['builtMapStringJsonObject', 'string'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i6.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i6.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$3f5057013fe375112018fdacdf7c966a> get _serializer =>
      const _$3f5057013fe375112018fdacdf7c966aSerializer();
  static _$3f5057013fe375112018fdacdf7c966a _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$3f5057013fe375112018fdacdf7c966aSerializer implements PrimitiveSerializer<_$3f5057013fe375112018fdacdf7c966a> {
  const _$3f5057013fe375112018fdacdf7c966aSerializer();

  @override
  Iterable<Type> get types => const [_$3f5057013fe375112018fdacdf7c966a];

  @override
  String get wireName => r'_$3f5057013fe375112018fdacdf7c966a';

  @override
  Object serialize(
    Serializers serializers,
    _$3f5057013fe375112018fdacdf7c966a object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.builtMapStringJsonObject;
    if (value != null) {
      return serializers.serialize(
        value,
        specifiedType: const FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
      )!;
    }
    value = object.string;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(String))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$3f5057013fe375112018fdacdf7c966a deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    BuiltMap<String, JsonObject>? builtMapStringJsonObject;
    try {
      builtMapStringJsonObject = serializers.deserialize(
        data,
        specifiedType: const FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
      )! as BuiltMap<String, JsonObject>;
    } catch (_) {}
    String? string;
    try {
      string = serializers.deserialize(
        data,
        specifiedType: const FullType(String),
      )! as String;
    } catch (_) {}
    return (builtMapStringJsonObject: builtMapStringJsonObject, string: string);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(const FullType(Table), TableBuilder.new)
      ..add(Table.serializer)
      ..addBuilderFactory(const FullType(Table_OnSharePermissions), Table_OnSharePermissionsBuilder.new)
      ..add(Table_OnSharePermissions.serializer)
      ..addBuilderFactory(const FullType(View), ViewBuilder.new)
      ..add(View.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(int)]), ListBuilder<int>.new)
      ..addBuilderFactory(const FullType(View_Sort), View_SortBuilder.new)
      ..add(View_Sort.serializer)
      ..add(View_Sort_Mode.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(View_Sort)]), ListBuilder<View_Sort>.new)
      ..addBuilderFactory(const FullType(View_Filter), View_FilterBuilder.new)
      ..add(View_Filter.serializer)
      ..add(View_Filter_Operator.serializer)
      ..add($b6d67dc2a96424d2f407f8e51557f3deExtension._serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(View_Filter)]), ListBuilder<View_Filter>.new)
      ..addBuilderFactory(
        const FullType(BuiltList, [
          FullType(BuiltList, [FullType(View_Filter)]),
        ]),
        ListBuilder<BuiltList<View_Filter>>.new,
      )
      ..addBuilderFactory(const FullType(View_OnSharePermissions), View_OnSharePermissionsBuilder.new)
      ..add(View_OnSharePermissions.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(View)]), ListBuilder<View>.new)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Table)]), ListBuilder<Table>.new)
      ..addBuilderFactory(
        const FullType(Api1CreateTableRequestApplicationJson),
        Api1CreateTableRequestApplicationJsonBuilder.new,
      )
      ..add(Api1CreateTableRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateTableRequestApplicationJson),
        Api1UpdateTableRequestApplicationJsonBuilder.new,
      )
      ..add(Api1UpdateTableRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(Api1Api1ShowSchemeHeaders), Api1Api1ShowSchemeHeadersBuilder.new)
      ..add(Api1Api1ShowSchemeHeaders.serializer)
      ..addBuilderFactory(
        const FullType(Api1CreateViewRequestApplicationJson),
        Api1CreateViewRequestApplicationJsonBuilder.new,
      )
      ..add(Api1CreateViewRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateViewRequestApplicationJson),
        Api1UpdateViewRequestApplicationJsonBuilder.new,
      )
      ..add(Api1UpdateViewRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateViewRequestApplicationJson_Data0),
        Api1UpdateViewRequestApplicationJson_Data0Builder.new,
      )
      ..add(Api1UpdateViewRequestApplicationJson_Data0.serializer)
      ..add(Api1UpdateViewRequestApplicationJson_Data0_Key.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateViewRequestApplicationJson_Data1),
        Api1UpdateViewRequestApplicationJson_Data1Builder.new,
      )
      ..add(Api1UpdateViewRequestApplicationJson_Data1.serializer)
      ..add(Api1UpdateViewRequestApplicationJson_Data1_Key.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateViewRequestApplicationJson_Data2),
        Api1UpdateViewRequestApplicationJson_Data2Builder.new,
      )
      ..add(Api1UpdateViewRequestApplicationJson_Data2.serializer)
      ..add(Api1UpdateViewRequestApplicationJson_Data2_Key.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateViewRequestApplicationJson_Data2_Value),
        Api1UpdateViewRequestApplicationJson_Data2_ValueBuilder.new,
      )
      ..add(Api1UpdateViewRequestApplicationJson_Data2_Value.serializer)
      ..add(Api1UpdateViewRequestApplicationJson_Data2_Value_Mode.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateViewRequestApplicationJson_Data3),
        Api1UpdateViewRequestApplicationJson_Data3Builder.new,
      )
      ..add(Api1UpdateViewRequestApplicationJson_Data3.serializer)
      ..add(Api1UpdateViewRequestApplicationJson_Data3_Key.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateViewRequestApplicationJson_Data3_Value),
        Api1UpdateViewRequestApplicationJson_Data3_ValueBuilder.new,
      )
      ..add(Api1UpdateViewRequestApplicationJson_Data3_Value.serializer)
      ..add(Api1UpdateViewRequestApplicationJson_Data3_Value_Operator.serializer)
      ..add($8518b50581163640f148d1e5a6a7db2cExtension._serializer)
      ..addBuilderFactory(const FullType(Share), ShareBuilder.new)
      ..add(Share.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateSharePermissionsRequestApplicationJson),
        Api1UpdateSharePermissionsRequestApplicationJsonBuilder.new,
      )
      ..add(Api1UpdateSharePermissionsRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Share)]), ListBuilder<Share>.new)
      ..addBuilderFactory(
        const FullType(Api1CreateTableShareRequestApplicationJson),
        Api1CreateTableShareRequestApplicationJsonBuilder.new,
      )
      ..add(Api1CreateTableShareRequestApplicationJson.serializer)
      ..add(Api1CreateTableShareRequestApplicationJson_ReceiverType.serializer)
      ..addBuilderFactory(
        const FullType(Api1CreateShareRequestApplicationJson),
        Api1CreateShareRequestApplicationJsonBuilder.new,
      )
      ..add(Api1CreateShareRequestApplicationJson.serializer)
      ..add(Api1CreateShareRequestApplicationJson_NodeType.serializer)
      ..add(Api1CreateShareRequestApplicationJson_ReceiverType.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateShareDisplayModeRequestApplicationJson),
        Api1UpdateShareDisplayModeRequestApplicationJsonBuilder.new,
      )
      ..add(Api1UpdateShareDisplayModeRequestApplicationJson.serializer)
      ..add(Api1UpdateShareDisplayModeRequestApplicationJson_Target.serializer)
      ..addBuilderFactory(const FullType(ContextNavigation), ContextNavigationBuilder.new)
      ..add(ContextNavigation.serializer)
      ..addBuilderFactory(const FullType(Column), ColumnBuilder.new)
      ..add(Column.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Column)]), ListBuilder<Column>.new)
      ..addBuilderFactory(
        const FullType(Api1CreateTableColumnRequestApplicationJson),
        Api1CreateTableColumnRequestApplicationJsonBuilder.new,
      )
      ..add(Api1CreateTableColumnRequestApplicationJson.serializer)
      ..add(Api1CreateTableColumnRequestApplicationJson_Type.serializer)
      ..addBuilderFactory(
        const FullType(Api1CreateColumnRequestApplicationJson),
        Api1CreateColumnRequestApplicationJsonBuilder.new,
      )
      ..add(Api1CreateColumnRequestApplicationJson.serializer)
      ..add(Api1CreateColumnRequestApplicationJson_Type.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateColumnRequestApplicationJson),
        Api1UpdateColumnRequestApplicationJsonBuilder.new,
      )
      ..add(Api1UpdateColumnRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(String)]), ListBuilder<String>.new)
      ..addBuilderFactory(const FullType(Row), RowBuilder.new)
      ..add(Row.serializer)
      ..addBuilderFactory(const FullType(Row_Data), Row_DataBuilder.new)
      ..add(Row_Data.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Row)]), ListBuilder<Row>.new)
      ..addBuilderFactory(
        const FullType(Api1CreateRowInTableRequestApplicationJson),
        Api1CreateRowInTableRequestApplicationJsonBuilder.new,
      )
      ..add(Api1CreateRowInTableRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
        MapBuilder<String, JsonObject>.new,
      )
      ..add($3f5057013fe375112018fdacdf7c966aExtension._serializer)
      ..addBuilderFactory(
        const FullType(Api1CreateRowInViewRequestApplicationJson),
        Api1CreateRowInViewRequestApplicationJsonBuilder.new,
      )
      ..add(Api1CreateRowInViewRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(Api1UpdateRowRequestApplicationJson),
        Api1UpdateRowRequestApplicationJsonBuilder.new,
      )
      ..add(Api1UpdateRowRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(Api1ImportInTableRequestApplicationJson),
        Api1ImportInTableRequestApplicationJsonBuilder.new,
      )
      ..add(Api1ImportInTableRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(ImportState), ImportStateBuilder.new)
      ..add(ImportState.serializer)
      ..addBuilderFactory(
        const FullType(Api1ImportInViewRequestApplicationJson),
        Api1ImportInViewRequestApplicationJsonBuilder.new,
      )
      ..add(Api1ImportInViewRequestApplicationJson.serializer)
      ..add(ApiColumnsIndexNodeType.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsIndexResponseApplicationJson),
        ApiColumnsIndexResponseApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsIndexResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsIndexResponseApplicationJson_Ocs),
        ApiColumnsIndexResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiColumnsIndexResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsShowResponseApplicationJson),
        ApiColumnsShowResponseApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsShowResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsShowResponseApplicationJson_Ocs),
        ApiColumnsShowResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiColumnsShowResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateNumberColumnRequestApplicationJson),
        ApiColumnsCreateNumberColumnRequestApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateNumberColumnRequestApplicationJson.serializer)
      ..add(ApiColumnsCreateNumberColumnRequestApplicationJson_Subtype.serializer)
      ..add(ApiColumnsCreateNumberColumnRequestApplicationJson_BaseNodeType.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateNumberColumnResponseApplicationJson),
        ApiColumnsCreateNumberColumnResponseApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateNumberColumnResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs),
        ApiColumnsCreateNumberColumnResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiColumnsCreateNumberColumnResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateTextColumnRequestApplicationJson),
        ApiColumnsCreateTextColumnRequestApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateTextColumnRequestApplicationJson.serializer)
      ..add(ApiColumnsCreateTextColumnRequestApplicationJson_Subtype.serializer)
      ..add(ApiColumnsCreateTextColumnRequestApplicationJson_BaseNodeType.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateTextColumnResponseApplicationJson),
        ApiColumnsCreateTextColumnResponseApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateTextColumnResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateTextColumnResponseApplicationJson_Ocs),
        ApiColumnsCreateTextColumnResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiColumnsCreateTextColumnResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateSelectionColumnRequestApplicationJson),
        ApiColumnsCreateSelectionColumnRequestApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateSelectionColumnRequestApplicationJson.serializer)
      ..add(ApiColumnsCreateSelectionColumnRequestApplicationJson_Subtype.serializer)
      ..add(ApiColumnsCreateSelectionColumnRequestApplicationJson_BaseNodeType.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateSelectionColumnResponseApplicationJson),
        ApiColumnsCreateSelectionColumnResponseApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateSelectionColumnResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs),
        ApiColumnsCreateSelectionColumnResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiColumnsCreateSelectionColumnResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateDatetimeColumnRequestApplicationJson),
        ApiColumnsCreateDatetimeColumnRequestApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateDatetimeColumnRequestApplicationJson.serializer)
      ..add(ApiColumnsCreateDatetimeColumnRequestApplicationJson_DatetimeDefault.serializer)
      ..add(ApiColumnsCreateDatetimeColumnRequestApplicationJson_Subtype.serializer)
      ..add(ApiColumnsCreateDatetimeColumnRequestApplicationJson_BaseNodeType.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateDatetimeColumnResponseApplicationJson),
        ApiColumnsCreateDatetimeColumnResponseApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateDatetimeColumnResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs),
        ApiColumnsCreateDatetimeColumnResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiColumnsCreateDatetimeColumnResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateUsergroupColumnRequestApplicationJson),
        ApiColumnsCreateUsergroupColumnRequestApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateUsergroupColumnRequestApplicationJson.serializer)
      ..add(ApiColumnsCreateUsergroupColumnRequestApplicationJson_BaseNodeType.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateUsergroupColumnResponseApplicationJson),
        ApiColumnsCreateUsergroupColumnResponseApplicationJsonBuilder.new,
      )
      ..add(ApiColumnsCreateUsergroupColumnResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs),
        ApiColumnsCreateUsergroupColumnResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiColumnsCreateUsergroupColumnResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiFavoriteCreateResponseApplicationJson),
        ApiFavoriteCreateResponseApplicationJsonBuilder.new,
      )
      ..add(ApiFavoriteCreateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiFavoriteCreateResponseApplicationJson_Ocs),
        ApiFavoriteCreateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiFavoriteCreateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiFavoriteDestroyResponseApplicationJson),
        ApiFavoriteDestroyResponseApplicationJsonBuilder.new,
      )
      ..add(ApiFavoriteDestroyResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiFavoriteDestroyResponseApplicationJson_Ocs),
        ApiFavoriteDestroyResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiFavoriteDestroyResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiGeneralIndexResponseApplicationJson),
        ApiGeneralIndexResponseApplicationJsonBuilder.new,
      )
      ..add(ApiGeneralIndexResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiGeneralIndexResponseApplicationJson_Ocs),
        ApiGeneralIndexResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiGeneralIndexResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Index), IndexBuilder.new)
      ..add(Index.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesIndexResponseApplicationJson),
        ApiTablesIndexResponseApplicationJsonBuilder.new,
      )
      ..add(ApiTablesIndexResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesIndexResponseApplicationJson_Ocs),
        ApiTablesIndexResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiTablesIndexResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesCreateRequestApplicationJson),
        ApiTablesCreateRequestApplicationJsonBuilder.new,
      )
      ..add(ApiTablesCreateRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesCreateResponseApplicationJson),
        ApiTablesCreateResponseApplicationJsonBuilder.new,
      )
      ..add(ApiTablesCreateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesCreateResponseApplicationJson_Ocs),
        ApiTablesCreateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiTablesCreateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesShowResponseApplicationJson),
        ApiTablesShowResponseApplicationJsonBuilder.new,
      )
      ..add(ApiTablesShowResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesShowResponseApplicationJson_Ocs),
        ApiTablesShowResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiTablesShowResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesUpdateRequestApplicationJson),
        ApiTablesUpdateRequestApplicationJsonBuilder.new,
      )
      ..add(ApiTablesUpdateRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesUpdateResponseApplicationJson),
        ApiTablesUpdateResponseApplicationJsonBuilder.new,
      )
      ..add(ApiTablesUpdateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesUpdateResponseApplicationJson_Ocs),
        ApiTablesUpdateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiTablesUpdateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesDestroyResponseApplicationJson),
        ApiTablesDestroyResponseApplicationJsonBuilder.new,
      )
      ..add(ApiTablesDestroyResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesDestroyResponseApplicationJson_Ocs),
        ApiTablesDestroyResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiTablesDestroyResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesShowSchemeResponseApplicationJson),
        ApiTablesShowSchemeResponseApplicationJsonBuilder.new,
      )
      ..add(ApiTablesShowSchemeResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesShowSchemeResponseApplicationJson_Ocs),
        ApiTablesShowSchemeResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiTablesShowSchemeResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesCreateFromSchemeRequestApplicationJson),
        ApiTablesCreateFromSchemeRequestApplicationJsonBuilder.new,
      )
      ..add(ApiTablesCreateFromSchemeRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesCreateFromSchemeResponseApplicationJson),
        ApiTablesCreateFromSchemeResponseApplicationJsonBuilder.new,
      )
      ..add(ApiTablesCreateFromSchemeResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesCreateFromSchemeResponseApplicationJson_Ocs),
        ApiTablesCreateFromSchemeResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiTablesCreateFromSchemeResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesTransferRequestApplicationJson),
        ApiTablesTransferRequestApplicationJsonBuilder.new,
      )
      ..add(ApiTablesTransferRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesTransferResponseApplicationJson),
        ApiTablesTransferResponseApplicationJsonBuilder.new,
      )
      ..add(ApiTablesTransferResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiTablesTransferResponseApplicationJson_Ocs),
        ApiTablesTransferResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiTablesTransferResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ContextIndexResponseApplicationJson),
        ContextIndexResponseApplicationJsonBuilder.new,
      )
      ..add(ContextIndexResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextIndexResponseApplicationJson_Ocs),
        ContextIndexResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ContextIndexResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Context), ContextBuilder.new)
      ..add(Context.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Context)]), ListBuilder<Context>.new)
      ..addBuilderFactory(
        const FullType(ContextCreateRequestApplicationJson),
        ContextCreateRequestApplicationJsonBuilder.new,
      )
      ..add(ContextCreateRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextCreateRequestApplicationJson_Nodes),
        ContextCreateRequestApplicationJson_NodesBuilder.new,
      )
      ..add(ContextCreateRequestApplicationJson_Nodes.serializer)
      ..addBuilderFactory(
        const FullType(BuiltList, [FullType(ContextCreateRequestApplicationJson_Nodes)]),
        ListBuilder<ContextCreateRequestApplicationJson_Nodes>.new,
      )
      ..addBuilderFactory(
        const FullType(ContextCreateResponseApplicationJson),
        ContextCreateResponseApplicationJsonBuilder.new,
      )
      ..add(ContextCreateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextCreateResponseApplicationJson_Ocs),
        ContextCreateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ContextCreateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ContextShowResponseApplicationJson),
        ContextShowResponseApplicationJsonBuilder.new,
      )
      ..add(ContextShowResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextShowResponseApplicationJson_Ocs),
        ContextShowResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ContextShowResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ContextUpdateRequestApplicationJson),
        ContextUpdateRequestApplicationJsonBuilder.new,
      )
      ..add(ContextUpdateRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextUpdateRequestApplicationJson_Nodes),
        ContextUpdateRequestApplicationJson_NodesBuilder.new,
      )
      ..add(ContextUpdateRequestApplicationJson_Nodes.serializer)
      ..addBuilderFactory(
        const FullType(ContextUpdateResponseApplicationJson),
        ContextUpdateResponseApplicationJsonBuilder.new,
      )
      ..add(ContextUpdateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextUpdateResponseApplicationJson_Ocs),
        ContextUpdateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ContextUpdateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ContextDestroyResponseApplicationJson),
        ContextDestroyResponseApplicationJsonBuilder.new,
      )
      ..add(ContextDestroyResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextDestroyResponseApplicationJson_Ocs),
        ContextDestroyResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ContextDestroyResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ContextTransferRequestApplicationJson),
        ContextTransferRequestApplicationJsonBuilder.new,
      )
      ..add(ContextTransferRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextTransferResponseApplicationJson),
        ContextTransferResponseApplicationJsonBuilder.new,
      )
      ..add(ContextTransferResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextTransferResponseApplicationJson_Ocs),
        ContextTransferResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ContextTransferResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ContextUpdateContentOrderRequestApplicationJson),
        ContextUpdateContentOrderRequestApplicationJsonBuilder.new,
      )
      ..add(ContextUpdateContentOrderRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextUpdateContentOrderRequestApplicationJson_Content),
        ContextUpdateContentOrderRequestApplicationJson_ContentBuilder.new,
      )
      ..add(ContextUpdateContentOrderRequestApplicationJson_Content.serializer)
      ..addBuilderFactory(
        const FullType(ContextUpdateContentOrderResponseApplicationJson),
        ContextUpdateContentOrderResponseApplicationJsonBuilder.new,
      )
      ..add(ContextUpdateContentOrderResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ContextUpdateContentOrderResponseApplicationJson_Ocs),
        ContextUpdateContentOrderResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ContextUpdateContentOrderResponseApplicationJson_Ocs.serializer)
      ..add(RowocsCreateRowNodeCollection.serializer)
      ..addBuilderFactory(
        const FullType(RowocsCreateRowRequestApplicationJson),
        RowocsCreateRowRequestApplicationJsonBuilder.new,
      )
      ..add(RowocsCreateRowRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(RowocsCreateRowResponseApplicationJson),
        RowocsCreateRowResponseApplicationJsonBuilder.new,
      )
      ..add(RowocsCreateRowResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(RowocsCreateRowResponseApplicationJson_Ocs),
        RowocsCreateRowResponseApplicationJson_OcsBuilder.new,
      )
      ..add(RowocsCreateRowResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Capabilities), CapabilitiesBuilder.new)
      ..add(Capabilities.serializer)
      ..addBuilderFactory(const FullType(Capabilities_Tables), Capabilities_TablesBuilder.new)
      ..add(Capabilities_Tables.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(
        _i8.StandardJsonPlugin(
          typesToLeaveAsList: const {
            _$b6d67dc2a96424d2f407f8e51557f3de,
            _$8518b50581163640f148d1e5a6a7db2c,
            _$3f5057013fe375112018fdacdf7c966a,
          },
        ),
      )
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
