// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// spreed Version: 0.0.1.
///
/// Chat, video & audio-conferencing using WebRTC.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';
import 'dart:typed_data';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i6;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/models.dart';
import 'package:dynamite_runtime/utils.dart' as _i4;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i5;

part 'spreed.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $AvatarClient avatar = $AvatarClient(this);

  late final $BanClient ban = $BanClient(this);

  late final $BotClient bot = $BotClient(this);

  late final $BreakoutRoomClient breakoutRoom = $BreakoutRoomClient(this);

  late final $CallClient call = $CallClient(this);

  late final $ChatClient chat = $ChatClient(this);

  late final $ExternalSignalingClient externalSignaling = $ExternalSignalingClient(this);

  late final $FederationClient federation = $FederationClient(this);

  late final $FilesIntegrationClient filesIntegration = $FilesIntegrationClient(this);

  late final $GuestClient guest = $GuestClient(this);

  late final $HostedSignalingServerClient hostedSignalingServer = $HostedSignalingServerClient(this);

  late final $InternalSignalingClient internalSignaling = $InternalSignalingClient(this);

  late final $MatterbridgeClient matterbridge = $MatterbridgeClient(this);

  late final $PollClient poll = $PollClient(this);

  late final $ReactionClient reaction = $ReactionClient(this);

  late final $RecordingClient recording = $RecordingClient(this);

  late final $RoomClient room = $RoomClient(this);

  late final $SettingsClient settings = $SettingsClient(this);

  late final $SignalingClient signaling = $SignalingClient(this);

  late final $UserAvatarClient userAvatar = $UserAvatarClient(this);
}

class $AvatarClient {
  /// Creates a new `DynamiteClient` for avatar requests.
  $AvatarClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getAvatar_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the avatar of a room.
  ///
  /// Returns a `DynamiteRequest` backing the [getAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [darkTheme] Theme used for background. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room avatar returned
  ///
  /// See:
  ///  * [getAvatar] for a method executing this request and parsing the response.
  ///  * [$getAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAvatar_Request({
    required String token,
    AvatarGetAvatarApiVersion? apiVersion,
    AvatarGetAvatarDarkTheme? darkTheme,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(AvatarGetAvatarApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    var __darkTheme = _$jsonSerializers.serialize(darkTheme, specifiedType: const FullType(AvatarGetAvatarDarkTheme));
    __darkTheme ??= 0;
    _parameters['darkTheme'] = __darkTheme;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/avatar{?darkTheme*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the avatar of a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [darkTheme] Theme used for background. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room avatar returned
  ///
  /// See:
  ///  * [$getAvatar_Request] for the request send by this method.
  ///  * [$getAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getAvatar({
    required String token,
    AvatarGetAvatarApiVersion? apiVersion,
    AvatarGetAvatarDarkTheme? darkTheme,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getAvatar_Request(
      token: token,
      apiVersion: apiVersion,
      darkTheme: darkTheme,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAvatar_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$uploadAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AvatarUploadAvatarResponseApplicationJson, void> $uploadAvatar_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(AvatarUploadAvatarResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Upload an avatar for a room.
  ///
  /// Returns a `DynamiteRequest` backing the [uploadAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar uploaded successfully
  ///   * 400: Avatar invalid
  ///
  /// See:
  ///  * [uploadAvatar] for a method executing this request and parsing the response.
  ///  * [$uploadAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $uploadAvatar_Request({
    required String token,
    AvatarUploadAvatarApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(AvatarUploadAvatarApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/avatar').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Upload an avatar for a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar uploaded successfully
  ///   * 400: Avatar invalid
  ///
  /// See:
  ///  * [$uploadAvatar_Request] for the request send by this method.
  ///  * [$uploadAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AvatarUploadAvatarResponseApplicationJson, void>> uploadAvatar({
    required String token,
    AvatarUploadAvatarApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $uploadAvatar_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $uploadAvatar_Serializer();
    return _i1.ResponseConverter<AvatarUploadAvatarResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AvatarDeleteAvatarResponseApplicationJson, void> $deleteAvatar_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(AvatarDeleteAvatarResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete the avatar of a room.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar removed successfully
  ///
  /// See:
  ///  * [deleteAvatar] for a method executing this request and parsing the response.
  ///  * [$deleteAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteAvatar_Request({
    required String token,
    AvatarDeleteAvatarApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(AvatarDeleteAvatarApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/avatar').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete the avatar of a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar removed successfully
  ///
  /// See:
  ///  * [$deleteAvatar_Request] for the request send by this method.
  ///  * [$deleteAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AvatarDeleteAvatarResponseApplicationJson, void>> deleteAvatar({
    required String token,
    AvatarDeleteAvatarApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteAvatar_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteAvatar_Serializer();
    return _i1.ResponseConverter<AvatarDeleteAvatarResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$emojiAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AvatarEmojiAvatarResponseApplicationJson, void> $emojiAvatar_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(AvatarEmojiAvatarResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set an emoji as avatar.
  ///
  /// Returns a `DynamiteRequest` backing the [emojiAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar set successfully
  ///   * 400: Setting emoji avatar is not possible
  ///
  /// See:
  ///  * [emojiAvatar] for a method executing this request and parsing the response.
  ///  * [$emojiAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $emojiAvatar_Request({
    required String token,
    required AvatarEmojiAvatarRequestApplicationJson $body,
    AvatarEmojiAvatarApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(AvatarEmojiAvatarApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/avatar/emoji').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(AvatarEmojiAvatarRequestApplicationJson)),
    );
    return _request;
  }

  /// Set an emoji as avatar.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar set successfully
  ///   * 400: Setting emoji avatar is not possible
  ///
  /// See:
  ///  * [$emojiAvatar_Request] for the request send by this method.
  ///  * [$emojiAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AvatarEmojiAvatarResponseApplicationJson, void>> emojiAvatar({
    required String token,
    required AvatarEmojiAvatarRequestApplicationJson $body,
    AvatarEmojiAvatarApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $emojiAvatar_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $emojiAvatar_Serializer();
    return _i1.ResponseConverter<AvatarEmojiAvatarResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getAvatarDark_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getAvatarDark_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the dark mode avatar of a room.
  ///
  /// Returns a `DynamiteRequest` backing the [getAvatarDark] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room avatar returned
  ///
  /// See:
  ///  * [getAvatarDark] for a method executing this request and parsing the response.
  ///  * [$getAvatarDark_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAvatarDark_Request({
    required String token,
    AvatarGetAvatarDarkApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(AvatarGetAvatarDarkApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/avatar/dark').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the dark mode avatar of a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room avatar returned
  ///
  /// See:
  ///  * [$getAvatarDark_Request] for the request send by this method.
  ///  * [$getAvatarDark_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getAvatarDark({
    required String token,
    AvatarGetAvatarDarkApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getAvatarDark_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAvatarDark_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUserProxyAvatarWithoutRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getUserProxyAvatarWithoutRoom_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the avatar of a cloudId user when inviting users while creating a conversation.
  ///
  /// Returns a `DynamiteRequest` backing the [getUserProxyAvatarWithoutRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [size] Avatar size.
  ///   * [cloudId] Federation CloudID to get the avatar for.
  ///   * [darkTheme] Theme used for background. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User avatar returned
  ///
  /// See:
  ///  * [getUserProxyAvatarWithoutRoom] for a method executing this request and parsing the response.
  ///  * [$getUserProxyAvatarWithoutRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUserProxyAvatarWithoutRoom_Request({
    required AvatarGetUserProxyAvatarWithoutRoomSize size,
    required String cloudId,
    AvatarGetUserProxyAvatarWithoutRoomApiVersion? apiVersion,
    AvatarGetUserProxyAvatarWithoutRoomDarkTheme? darkTheme,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __size =
        _$jsonSerializers.serialize(size, specifiedType: const FullType(AvatarGetUserProxyAvatarWithoutRoomSize));
    _parameters['size'] = __size;

    final __cloudId = _$jsonSerializers.serialize(cloudId, specifiedType: const FullType(String));
    _parameters['cloudId'] = __cloudId;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(AvatarGetUserProxyAvatarWithoutRoomApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    var __darkTheme = _$jsonSerializers.serialize(
      darkTheme,
      specifiedType: const FullType(AvatarGetUserProxyAvatarWithoutRoomDarkTheme),
    );
    __darkTheme ??= 0;
    _parameters['darkTheme'] = __darkTheme;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/proxy/new/user-avatar/{size}{?cloudId*,darkTheme*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the avatar of a cloudId user when inviting users while creating a conversation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [size] Avatar size.
  ///   * [cloudId] Federation CloudID to get the avatar for.
  ///   * [darkTheme] Theme used for background. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User avatar returned
  ///
  /// See:
  ///  * [$getUserProxyAvatarWithoutRoom_Request] for the request send by this method.
  ///  * [$getUserProxyAvatarWithoutRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getUserProxyAvatarWithoutRoom({
    required AvatarGetUserProxyAvatarWithoutRoomSize size,
    required String cloudId,
    AvatarGetUserProxyAvatarWithoutRoomApiVersion? apiVersion,
    AvatarGetUserProxyAvatarWithoutRoomDarkTheme? darkTheme,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUserProxyAvatarWithoutRoom_Request(
      size: size,
      cloudId: cloudId,
      apiVersion: apiVersion,
      darkTheme: darkTheme,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUserProxyAvatarWithoutRoom_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUserProxyAvatarDarkWithoutRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getUserProxyAvatarDarkWithoutRoom_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the dark mode avatar of a cloudId user when inviting users while creating a conversation.
  ///
  /// Returns a `DynamiteRequest` backing the [getUserProxyAvatarDarkWithoutRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [size] Avatar size.
  ///   * [cloudId] Federation CloudID to get the avatar for.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User avatar returned
  ///
  /// See:
  ///  * [getUserProxyAvatarDarkWithoutRoom] for a method executing this request and parsing the response.
  ///  * [$getUserProxyAvatarDarkWithoutRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUserProxyAvatarDarkWithoutRoom_Request({
    required AvatarGetUserProxyAvatarDarkWithoutRoomSize size,
    required String cloudId,
    AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __size =
        _$jsonSerializers.serialize(size, specifiedType: const FullType(AvatarGetUserProxyAvatarDarkWithoutRoomSize));
    _parameters['size'] = __size;

    final __cloudId = _$jsonSerializers.serialize(cloudId, specifiedType: const FullType(String));
    _parameters['cloudId'] = __cloudId;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/proxy/new/user-avatar/{size}/dark{?cloudId*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the dark mode avatar of a cloudId user when inviting users while creating a conversation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [size] Avatar size.
  ///   * [cloudId] Federation CloudID to get the avatar for.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User avatar returned
  ///
  /// See:
  ///  * [$getUserProxyAvatarDarkWithoutRoom_Request] for the request send by this method.
  ///  * [$getUserProxyAvatarDarkWithoutRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getUserProxyAvatarDarkWithoutRoom({
    required AvatarGetUserProxyAvatarDarkWithoutRoomSize size,
    required String cloudId,
    AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUserProxyAvatarDarkWithoutRoom_Request(
      size: size,
      cloudId: cloudId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUserProxyAvatarDarkWithoutRoom_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUserProxyAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getUserProxyAvatar_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the avatar of a cloudId user.
  ///
  /// Returns a `DynamiteRequest` backing the [getUserProxyAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [size] Avatar size.
  ///   * [cloudId] Federation CloudID to get the avatar for.
  ///   * [darkTheme] Theme used for background. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User avatar returned
  ///
  /// See:
  ///  * [getUserProxyAvatar] for a method executing this request and parsing the response.
  ///  * [$getUserProxyAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUserProxyAvatar_Request({
    required String token,
    required AvatarGetUserProxyAvatarSize size,
    required String cloudId,
    AvatarGetUserProxyAvatarApiVersion? apiVersion,
    AvatarGetUserProxyAvatarDarkTheme? darkTheme,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __size = _$jsonSerializers.serialize(size, specifiedType: const FullType(AvatarGetUserProxyAvatarSize));
    _parameters['size'] = __size;

    final __cloudId = _$jsonSerializers.serialize(cloudId, specifiedType: const FullType(String));
    _parameters['cloudId'] = __cloudId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(AvatarGetUserProxyAvatarApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    var __darkTheme =
        _$jsonSerializers.serialize(darkTheme, specifiedType: const FullType(AvatarGetUserProxyAvatarDarkTheme));
    __darkTheme ??= 0;
    _parameters['darkTheme'] = __darkTheme;

    final _path = _i5.UriTemplate(
      '/ocs/v2.php/apps/spreed/api/{apiVersion}/proxy/{token}/user-avatar/{size}{?cloudId*,darkTheme*}',
    ).expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the avatar of a cloudId user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [size] Avatar size.
  ///   * [cloudId] Federation CloudID to get the avatar for.
  ///   * [darkTheme] Theme used for background. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User avatar returned
  ///
  /// See:
  ///  * [$getUserProxyAvatar_Request] for the request send by this method.
  ///  * [$getUserProxyAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getUserProxyAvatar({
    required String token,
    required AvatarGetUserProxyAvatarSize size,
    required String cloudId,
    AvatarGetUserProxyAvatarApiVersion? apiVersion,
    AvatarGetUserProxyAvatarDarkTheme? darkTheme,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUserProxyAvatar_Request(
      token: token,
      size: size,
      cloudId: cloudId,
      apiVersion: apiVersion,
      darkTheme: darkTheme,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUserProxyAvatar_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUserProxyAvatarDark_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getUserProxyAvatarDark_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the dark mode avatar of a cloudId user.
  ///
  /// Returns a `DynamiteRequest` backing the [getUserProxyAvatarDark] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [size] Avatar size.
  ///   * [cloudId] Federation CloudID to get the avatar for.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User avatar returned
  ///
  /// See:
  ///  * [getUserProxyAvatarDark] for a method executing this request and parsing the response.
  ///  * [$getUserProxyAvatarDark_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUserProxyAvatarDark_Request({
    required String token,
    required AvatarGetUserProxyAvatarDarkSize size,
    required String cloudId,
    AvatarGetUserProxyAvatarDarkApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __size = _$jsonSerializers.serialize(size, specifiedType: const FullType(AvatarGetUserProxyAvatarDarkSize));
    _parameters['size'] = __size;

    final __cloudId = _$jsonSerializers.serialize(cloudId, specifiedType: const FullType(String));
    _parameters['cloudId'] = __cloudId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(AvatarGetUserProxyAvatarDarkApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/proxy/{token}/user-avatar/{size}/dark{?cloudId*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the dark mode avatar of a cloudId user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [size] Avatar size.
  ///   * [cloudId] Federation CloudID to get the avatar for.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User avatar returned
  ///
  /// See:
  ///  * [$getUserProxyAvatarDark_Request] for the request send by this method.
  ///  * [$getUserProxyAvatarDark_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getUserProxyAvatarDark({
    required String token,
    required AvatarGetUserProxyAvatarDarkSize size,
    required String cloudId,
    AvatarGetUserProxyAvatarDarkApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUserProxyAvatarDark_Request(
      token: token,
      size: size,
      cloudId: cloudId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUserProxyAvatarDark_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }
}

class $BanClient {
  /// Creates a new `DynamiteClient` for ban requests.
  $BanClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listBans_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BanListBansResponseApplicationJson, void> $listBans_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BanListBansResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// List the bans of a conversation.
  ///
  /// Required capability: `ban-v1`.
  ///
  /// Returns a `DynamiteRequest` backing the [listBans] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List all bans
  ///
  /// See:
  ///  * [listBans] for a method executing this request and parsing the response.
  ///  * [$listBans_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listBans_Request({
    required String token,
    BanListBansApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BanListBansApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/ban/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// List the bans of a conversation.
  ///
  /// Required capability: `ban-v1`.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List all bans
  ///
  /// See:
  ///  * [$listBans_Request] for the request send by this method.
  ///  * [$listBans_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BanListBansResponseApplicationJson, void>> listBans({
    required String token,
    BanListBansApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listBans_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listBans_Serializer();
    return _i1.ResponseConverter<BanListBansResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$banActor_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BanBanActorResponseApplicationJson, void> $banActor_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BanBanActorResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Ban an actor or IP address.
  ///
  /// Required capability: `ban-v1`.
  ///
  /// Returns a `DynamiteRequest` backing the [banActor] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ban successfully
  ///   * 400: Actor information is invalid
  ///
  /// See:
  ///  * [banActor] for a method executing this request and parsing the response.
  ///  * [$banActor_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $banActor_Request({
    required String token,
    required BanBanActorRequestApplicationJson $body,
    BanBanActorApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BanBanActorApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/ban/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(BanBanActorRequestApplicationJson)));
    return _request;
  }

  /// Ban an actor or IP address.
  ///
  /// Required capability: `ban-v1`.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ban successfully
  ///   * 400: Actor information is invalid
  ///
  /// See:
  ///  * [$banActor_Request] for the request send by this method.
  ///  * [$banActor_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BanBanActorResponseApplicationJson, void>> banActor({
    required String token,
    required BanBanActorRequestApplicationJson $body,
    BanBanActorApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $banActor_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $banActor_Serializer();
    return _i1.ResponseConverter<BanBanActorResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$unbanActor_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BanUnbanActorResponseApplicationJson, void> $unbanActor_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BanUnbanActorResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Unban an actor or IP address.
  ///
  /// Required capability: `ban-v1`.
  ///
  /// Returns a `DynamiteRequest` backing the [unbanActor] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [banId] ID of the ban to be removed.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Unban successfully or not found
  ///
  /// See:
  ///  * [unbanActor] for a method executing this request and parsing the response.
  ///  * [$unbanActor_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $unbanActor_Request({
    required String token,
    required int banId,
    BanUnbanActorApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __banId = _$jsonSerializers.serialize(banId, specifiedType: const FullType(int));
    _parameters['banId'] = __banId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BanUnbanActorApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/ban/{token}/{banId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Unban an actor or IP address.
  ///
  /// Required capability: `ban-v1`.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [banId] ID of the ban to be removed.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Unban successfully or not found
  ///
  /// See:
  ///  * [$unbanActor_Request] for the request send by this method.
  ///  * [$unbanActor_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BanUnbanActorResponseApplicationJson, void>> unbanActor({
    required String token,
    required int banId,
    BanUnbanActorApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $unbanActor_Request(
      token: token,
      banId: banId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $unbanActor_Serializer();
    return _i1.ResponseConverter<BanUnbanActorResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $BotClient {
  /// Creates a new `DynamiteClient` for bot requests.
  $BotClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listBots_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BotListBotsResponseApplicationJson, void> $listBots_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BotListBotsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// List bots.
  ///
  /// Returns a `DynamiteRequest` backing the [listBots] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bot list returned
  ///
  /// See:
  ///  * [listBots] for a method executing this request and parsing the response.
  ///  * [$listBots_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listBots_Request({
    required String token,
    BotListBotsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BotListBotsApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bot/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// List bots.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bot list returned
  ///
  /// See:
  ///  * [$listBots_Request] for the request send by this method.
  ///  * [$listBots_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BotListBotsResponseApplicationJson, void>> listBots({
    required String token,
    BotListBotsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listBots_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listBots_Serializer();
    return _i1.ResponseConverter<BotListBotsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$enableBot_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BotEnableBotResponseApplicationJson, void> $enableBot_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BotEnableBotResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201},
      );

  /// Enables a bot.
  ///
  /// Returns a `DynamiteRequest` backing the [enableBot] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [botId] ID of the bot.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bot already enabled
  ///   * 201: Bot enabled successfully
  ///   * 400: Enabling bot errored
  ///
  /// See:
  ///  * [enableBot] for a method executing this request and parsing the response.
  ///  * [$enableBot_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $enableBot_Request({
    required String token,
    required int botId,
    BotEnableBotApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __botId = _$jsonSerializers.serialize(botId, specifiedType: const FullType(int));
    _parameters['botId'] = __botId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BotEnableBotApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bot/{token}/{botId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Enables a bot.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [botId] ID of the bot.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bot already enabled
  ///   * 201: Bot enabled successfully
  ///   * 400: Enabling bot errored
  ///
  /// See:
  ///  * [$enableBot_Request] for the request send by this method.
  ///  * [$enableBot_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BotEnableBotResponseApplicationJson, void>> enableBot({
    required String token,
    required int botId,
    BotEnableBotApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $enableBot_Request(
      token: token,
      botId: botId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $enableBot_Serializer();
    return _i1.ResponseConverter<BotEnableBotResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$disableBot_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BotDisableBotResponseApplicationJson, void> $disableBot_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BotDisableBotResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Disables a bot.
  ///
  /// Returns a `DynamiteRequest` backing the [disableBot] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [botId] ID of the bot.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bot disabled successfully
  ///   * 400: Disabling bot errored
  ///
  /// See:
  ///  * [disableBot] for a method executing this request and parsing the response.
  ///  * [$disableBot_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $disableBot_Request({
    required String token,
    required int botId,
    BotDisableBotApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __botId = _$jsonSerializers.serialize(botId, specifiedType: const FullType(int));
    _parameters['botId'] = __botId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BotDisableBotApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bot/{token}/{botId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Disables a bot.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [botId] ID of the bot.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bot disabled successfully
  ///   * 400: Disabling bot errored
  ///
  /// See:
  ///  * [$disableBot_Request] for the request send by this method.
  ///  * [$disableBot_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BotDisableBotResponseApplicationJson, void>> disableBot({
    required String token,
    required int botId,
    BotDisableBotApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $disableBot_Request(
      token: token,
      botId: botId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $disableBot_Serializer();
    return _i1.ResponseConverter<BotDisableBotResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$sendMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BotSendMessageResponseApplicationJson, void> $sendMessage_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(BotSendMessageResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {201, 400, 401, 413},
      );

  /// Sends a new chat message to the given room.
  ///
  /// The author and timestamp are automatically set to the current user/guest and time.
  ///
  /// Returns a `DynamiteRequest` backing the [sendMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token] Conversation token.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Message sent successfully
  ///   * 400: When the replyTo is invalid or message is empty
  ///   * 401: Sending message is not allowed
  ///   * 413: Message too long
  ///
  /// See:
  ///  * [sendMessage] for a method executing this request and parsing the response.
  ///  * [$sendMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $sendMessage_Request({
    required String token,
    required BotSendMessageRequestApplicationJson $body,
    BotSendMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BotSendMessageApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bot/{token}/message').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(BotSendMessageRequestApplicationJson)),
    );
    return _request;
  }

  /// Sends a new chat message to the given room.
  ///
  /// The author and timestamp are automatically set to the current user/guest and time.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token] Conversation token.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Message sent successfully
  ///   * 400: When the replyTo is invalid or message is empty
  ///   * 401: Sending message is not allowed
  ///   * 413: Message too long
  ///
  /// See:
  ///  * [$sendMessage_Request] for the request send by this method.
  ///  * [$sendMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BotSendMessageResponseApplicationJson, void>> sendMessage({
    required String token,
    required BotSendMessageRequestApplicationJson $body,
    BotSendMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $sendMessage_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $sendMessage_Serializer();
    return _i1.ResponseConverter<BotSendMessageResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$react_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BotReactResponseApplicationJson, void> $react_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BotReactResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201, 400, 401, 404},
      );

  /// Adds a reaction to a chat message.
  ///
  /// Returns a `DynamiteRequest` backing the [react] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token] Conversation token.
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reaction already exists
  ///   * 201: Reacted successfully
  ///   * 400: Reacting is not possible
  ///   * 401: Reacting is not allowed
  ///   * 404: Reaction not found
  ///
  /// See:
  ///  * [react] for a method executing this request and parsing the response.
  ///  * [$react_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $react_Request({
    required String token,
    required int messageId,
    required BotReactRequestApplicationJson $body,
    BotReactApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _parameters['messageId'] = __messageId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BotReactApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bot/{token}/reaction/{messageId}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body =
        json.encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(BotReactRequestApplicationJson)));
    return _request;
  }

  /// Adds a reaction to a chat message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token] Conversation token.
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reaction already exists
  ///   * 201: Reacted successfully
  ///   * 400: Reacting is not possible
  ///   * 401: Reacting is not allowed
  ///   * 404: Reaction not found
  ///
  /// See:
  ///  * [$react_Request] for the request send by this method.
  ///  * [$react_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BotReactResponseApplicationJson, void>> react({
    required String token,
    required int messageId,
    required BotReactRequestApplicationJson $body,
    BotReactApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $react_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $react_Serializer();
    return _i1.ResponseConverter<BotReactResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteReaction_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BotDeleteReactionResponseApplicationJson, void> $deleteReaction_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(BotDeleteReactionResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400, 404, 401},
      );

  /// Deletes a reaction from a chat message.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteReaction] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token] Conversation token.
  ///   * [messageId] ID of the message.
  ///   * [reaction] Reaction to delete.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reaction deleted successfully
  ///   * 400: Reacting is not possible
  ///   * 404: Reaction not found
  ///   * 401: Reacting is not allowed
  ///
  /// See:
  ///  * [deleteReaction] for a method executing this request and parsing the response.
  ///  * [$deleteReaction_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteReaction_Request({
    required String token,
    required int messageId,
    required String reaction,
    BotDeleteReactionApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _parameters['messageId'] = __messageId;

    final __reaction = _$jsonSerializers.serialize(reaction, specifiedType: const FullType(String));
    _parameters['reaction'] = __reaction;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BotDeleteReactionApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bot/{token}/reaction/{messageId}{?reaction*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Deletes a reaction from a chat message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token] Conversation token.
  ///   * [messageId] ID of the message.
  ///   * [reaction] Reaction to delete.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reaction deleted successfully
  ///   * 400: Reacting is not possible
  ///   * 404: Reaction not found
  ///   * 401: Reacting is not allowed
  ///
  /// See:
  ///  * [$deleteReaction_Request] for the request send by this method.
  ///  * [$deleteReaction_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BotDeleteReactionResponseApplicationJson, void>> deleteReaction({
    required String token,
    required int messageId,
    required String reaction,
    BotDeleteReactionApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteReaction_Request(
      token: token,
      messageId: messageId,
      reaction: reaction,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteReaction_Serializer();
    return _i1.ResponseConverter<BotDeleteReactionResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $BreakoutRoomClient {
  /// Creates a new `DynamiteClient` for breakout_room requests.
  $BreakoutRoomClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$configureBreakoutRooms_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson, void>
      $configureBreakoutRooms_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Configure the breakout rooms.
  ///
  /// Returns a `DynamiteRequest` backing the [configureBreakoutRooms] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms configured successfully
  ///   * 400: Configuring breakout rooms errored
  ///
  /// See:
  ///  * [configureBreakoutRooms] for a method executing this request and parsing the response.
  ///  * [$configureBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $configureBreakoutRooms_Request({
    required String token,
    required BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson $body,
    BreakoutRoomConfigureBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(BreakoutRoomConfigureBreakoutRoomsApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Configure the breakout rooms.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms configured successfully
  ///   * 400: Configuring breakout rooms errored
  ///
  /// See:
  ///  * [$configureBreakoutRooms_Request] for the request send by this method.
  ///  * [$configureBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson, void>> configureBreakoutRooms({
    required String token,
    required BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson $body,
    BreakoutRoomConfigureBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $configureBreakoutRooms_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $configureBreakoutRooms_Serializer();
    return _i1.ResponseConverter<BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$removeBreakoutRooms_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson, void>
      $removeBreakoutRooms_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Remove the breakout rooms.
  ///
  /// Returns a `DynamiteRequest` backing the [removeBreakoutRooms] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms removed successfully
  ///
  /// See:
  ///  * [removeBreakoutRooms] for a method executing this request and parsing the response.
  ///  * [$removeBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $removeBreakoutRooms_Request({
    required String token,
    BreakoutRoomRemoveBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(BreakoutRoomRemoveBreakoutRoomsApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove the breakout rooms.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms removed successfully
  ///
  /// See:
  ///  * [$removeBreakoutRooms_Request] for the request send by this method.
  ///  * [$removeBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson, void>> removeBreakoutRooms({
    required String token,
    BreakoutRoomRemoveBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $removeBreakoutRooms_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $removeBreakoutRooms_Serializer();
    return _i1.ResponseConverter<BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$broadcastChatMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomBroadcastChatMessageResponseApplicationJson, void>
      $broadcastChatMessage_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(BreakoutRoomBroadcastChatMessageResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {201},
          );

  /// Broadcast a chat message to all breakout rooms.
  ///
  /// Returns a `DynamiteRequest` backing the [broadcastChatMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Chat message broadcasted successfully
  ///   * 400: Broadcasting chat message is not possible
  ///   * 413: Chat message too long
  ///
  /// See:
  ///  * [broadcastChatMessage] for a method executing this request and parsing the response.
  ///  * [$broadcastChatMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $broadcastChatMessage_Request({
    required String token,
    required BreakoutRoomBroadcastChatMessageRequestApplicationJson $body,
    BreakoutRoomBroadcastChatMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(BreakoutRoomBroadcastChatMessageApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}/broadcast')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(BreakoutRoomBroadcastChatMessageRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Broadcast a chat message to all breakout rooms.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Chat message broadcasted successfully
  ///   * 400: Broadcasting chat message is not possible
  ///   * 413: Chat message too long
  ///
  /// See:
  ///  * [$broadcastChatMessage_Request] for the request send by this method.
  ///  * [$broadcastChatMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomBroadcastChatMessageResponseApplicationJson, void>> broadcastChatMessage({
    required String token,
    required BreakoutRoomBroadcastChatMessageRequestApplicationJson $body,
    BreakoutRoomBroadcastChatMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $broadcastChatMessage_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $broadcastChatMessage_Serializer();
    return _i1.ResponseConverter<BreakoutRoomBroadcastChatMessageResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$applyAttendeeMap_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomApplyAttendeeMapResponseApplicationJson, void> $applyAttendeeMap_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(BreakoutRoomApplyAttendeeMapResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Apply an attendee map to the breakout rooms.
  ///
  /// Returns a `DynamiteRequest` backing the [applyAttendeeMap] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee map applied successfully
  ///   * 400: Applying attendee map is not possible
  ///
  /// See:
  ///  * [applyAttendeeMap] for a method executing this request and parsing the response.
  ///  * [$applyAttendeeMap_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $applyAttendeeMap_Request({
    required String token,
    required BreakoutRoomApplyAttendeeMapRequestApplicationJson $body,
    BreakoutRoomApplyAttendeeMapApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BreakoutRoomApplyAttendeeMapApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}/attendees')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(BreakoutRoomApplyAttendeeMapRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Apply an attendee map to the breakout rooms.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee map applied successfully
  ///   * 400: Applying attendee map is not possible
  ///
  /// See:
  ///  * [$applyAttendeeMap_Request] for the request send by this method.
  ///  * [$applyAttendeeMap_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomApplyAttendeeMapResponseApplicationJson, void>> applyAttendeeMap({
    required String token,
    required BreakoutRoomApplyAttendeeMapRequestApplicationJson $body,
    BreakoutRoomApplyAttendeeMapApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $applyAttendeeMap_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $applyAttendeeMap_Serializer();
    return _i1.ResponseConverter<BreakoutRoomApplyAttendeeMapResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$requestAssistance_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomRequestAssistanceResponseApplicationJson, void> $requestAssistance_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(BreakoutRoomRequestAssistanceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Request assistance.
  ///
  /// Returns a `DynamiteRequest` backing the [requestAssistance] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Assistance requested successfully
  ///   * 400: Requesting assistance is not possible
  ///
  /// See:
  ///  * [requestAssistance] for a method executing this request and parsing the response.
  ///  * [$requestAssistance_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $requestAssistance_Request({
    required String token,
    BreakoutRoomRequestAssistanceApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BreakoutRoomRequestAssistanceApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}/request-assistance')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Request assistance.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Assistance requested successfully
  ///   * 400: Requesting assistance is not possible
  ///
  /// See:
  ///  * [$requestAssistance_Request] for the request send by this method.
  ///  * [$requestAssistance_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomRequestAssistanceResponseApplicationJson, void>> requestAssistance({
    required String token,
    BreakoutRoomRequestAssistanceApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $requestAssistance_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $requestAssistance_Serializer();
    return _i1.ResponseConverter<BreakoutRoomRequestAssistanceResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$resetRequestForAssistance_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomResetRequestForAssistanceResponseApplicationJson, void>
      $resetRequestForAssistance_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(BreakoutRoomResetRequestForAssistanceResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Reset the request for assistance.
  ///
  /// Returns a `DynamiteRequest` backing the [resetRequestForAssistance] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Request for assistance reset successfully
  ///   * 400: Resetting the request for assistance is not possible
  ///
  /// See:
  ///  * [resetRequestForAssistance] for a method executing this request and parsing the response.
  ///  * [$resetRequestForAssistance_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $resetRequestForAssistance_Request({
    required String token,
    BreakoutRoomResetRequestForAssistanceApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(BreakoutRoomResetRequestForAssistanceApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}/request-assistance')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Reset the request for assistance.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Request for assistance reset successfully
  ///   * 400: Resetting the request for assistance is not possible
  ///
  /// See:
  ///  * [$resetRequestForAssistance_Request] for the request send by this method.
  ///  * [$resetRequestForAssistance_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomResetRequestForAssistanceResponseApplicationJson, void>>
      resetRequestForAssistance({
    required String token,
    BreakoutRoomResetRequestForAssistanceApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $resetRequestForAssistance_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $resetRequestForAssistance_Serializer();
    return _i1.ResponseConverter<BreakoutRoomResetRequestForAssistanceResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$startBreakoutRooms_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomStartBreakoutRoomsResponseApplicationJson, void>
      $startBreakoutRooms_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(BreakoutRoomStartBreakoutRoomsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Start the breakout rooms.
  ///
  /// Returns a `DynamiteRequest` backing the [startBreakoutRooms] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms started successfully
  ///   * 400: Starting breakout rooms is not possible
  ///
  /// See:
  ///  * [startBreakoutRooms] for a method executing this request and parsing the response.
  ///  * [$startBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $startBreakoutRooms_Request({
    required String token,
    BreakoutRoomStartBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(BreakoutRoomStartBreakoutRoomsApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}/rooms').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Start the breakout rooms.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms started successfully
  ///   * 400: Starting breakout rooms is not possible
  ///
  /// See:
  ///  * [$startBreakoutRooms_Request] for the request send by this method.
  ///  * [$startBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomStartBreakoutRoomsResponseApplicationJson, void>> startBreakoutRooms({
    required String token,
    BreakoutRoomStartBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $startBreakoutRooms_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $startBreakoutRooms_Serializer();
    return _i1.ResponseConverter<BreakoutRoomStartBreakoutRoomsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$stopBreakoutRooms_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomStopBreakoutRoomsResponseApplicationJson, void> $stopBreakoutRooms_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(BreakoutRoomStopBreakoutRoomsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Stop the breakout rooms.
  ///
  /// Returns a `DynamiteRequest` backing the [stopBreakoutRooms] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms stopped successfully
  ///   * 400: Stopping breakout rooms is not possible
  ///
  /// See:
  ///  * [stopBreakoutRooms] for a method executing this request and parsing the response.
  ///  * [$stopBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $stopBreakoutRooms_Request({
    required String token,
    BreakoutRoomStopBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BreakoutRoomStopBreakoutRoomsApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}/rooms').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Stop the breakout rooms.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms stopped successfully
  ///   * 400: Stopping breakout rooms is not possible
  ///
  /// See:
  ///  * [$stopBreakoutRooms_Request] for the request send by this method.
  ///  * [$stopBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomStopBreakoutRoomsResponseApplicationJson, void>> stopBreakoutRooms({
    required String token,
    BreakoutRoomStopBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $stopBreakoutRooms_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $stopBreakoutRooms_Serializer();
    return _i1.ResponseConverter<BreakoutRoomStopBreakoutRoomsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$switchBreakoutRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BreakoutRoomSwitchBreakoutRoomResponseApplicationJson, void>
      $switchBreakoutRoom_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(BreakoutRoomSwitchBreakoutRoomResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Switch to another breakout room.
  ///
  /// Returns a `DynamiteRequest` backing the [switchBreakoutRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Switched to breakout room successfully
  ///   * 400: Switching to breakout room is not possible
  ///
  /// See:
  ///  * [switchBreakoutRoom] for a method executing this request and parsing the response.
  ///  * [$switchBreakoutRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $switchBreakoutRoom_Request({
    required String token,
    required BreakoutRoomSwitchBreakoutRoomRequestApplicationJson $body,
    BreakoutRoomSwitchBreakoutRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(BreakoutRoomSwitchBreakoutRoomApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/breakout-rooms/{token}/switch').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(BreakoutRoomSwitchBreakoutRoomRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Switch to another breakout room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Switched to breakout room successfully
  ///   * 400: Switching to breakout room is not possible
  ///
  /// See:
  ///  * [$switchBreakoutRoom_Request] for the request send by this method.
  ///  * [$switchBreakoutRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BreakoutRoomSwitchBreakoutRoomResponseApplicationJson, void>> switchBreakoutRoom({
    required String token,
    required BreakoutRoomSwitchBreakoutRoomRequestApplicationJson $body,
    BreakoutRoomSwitchBreakoutRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $switchBreakoutRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $switchBreakoutRoom_Serializer();
    return _i1.ResponseConverter<BreakoutRoomSwitchBreakoutRoomResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $CallClient {
  /// Creates a new `DynamiteClient` for call requests.
  $CallClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getPeersForCall_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallGetPeersForCallResponseApplicationJson, void> $getPeersForCall_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(CallGetPeersForCallResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the peers for a call.
  ///
  /// Returns a `DynamiteRequest` backing the [getPeersForCall] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List of peers in the call returned
  ///
  /// See:
  ///  * [getPeersForCall] for a method executing this request and parsing the response.
  ///  * [$getPeersForCall_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getPeersForCall_Request({
    required String token,
    CallGetPeersForCallApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallGetPeersForCallApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the peers for a call.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List of peers in the call returned
  ///
  /// See:
  ///  * [$getPeersForCall_Request] for the request send by this method.
  ///  * [$getPeersForCall_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallGetPeersForCallResponseApplicationJson, void>> getPeersForCall({
    required String token,
    CallGetPeersForCallApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getPeersForCall_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getPeersForCall_Serializer();
    return _i1.ResponseConverter<CallGetPeersForCallResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateCallFlags_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallUpdateCallFlagsResponseApplicationJson, void> $updateCallFlags_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(CallUpdateCallFlagsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400, 404},
      );

  /// Update the in-call flags.
  ///
  /// Returns a `DynamiteRequest` backing the [updateCallFlags] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: In-call flags updated successfully
  ///   * 400: Updating in-call flags is not possible
  ///   * 404: Call session not found
  ///
  /// See:
  ///  * [updateCallFlags] for a method executing this request and parsing the response.
  ///  * [$updateCallFlags_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateCallFlags_Request({
    required String token,
    required CallUpdateCallFlagsRequestApplicationJson $body,
    CallUpdateCallFlagsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallUpdateCallFlagsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(CallUpdateCallFlagsRequestApplicationJson)),
    );
    return _request;
  }

  /// Update the in-call flags.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: In-call flags updated successfully
  ///   * 400: Updating in-call flags is not possible
  ///   * 404: Call session not found
  ///
  /// See:
  ///  * [$updateCallFlags_Request] for the request send by this method.
  ///  * [$updateCallFlags_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallUpdateCallFlagsResponseApplicationJson, void>> updateCallFlags({
    required String token,
    required CallUpdateCallFlagsRequestApplicationJson $body,
    CallUpdateCallFlagsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $updateCallFlags_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateCallFlags_Serializer();
    return _i1.ResponseConverter<CallUpdateCallFlagsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$joinCall_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallJoinCallResponseApplicationJson, void> $joinCall_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(CallJoinCallResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Join a call.
  ///
  /// Returns a `DynamiteRequest` backing the [joinCall] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call joined successfully
  ///   * 404: Call not found
  ///   * 400: No recording consent was given
  ///
  /// See:
  ///  * [joinCall] for a method executing this request and parsing the response.
  ///  * [$joinCall_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $joinCall_Request({
    required String token,
    CallJoinCallApiVersion? apiVersion,
    bool? oCSAPIRequest,
    CallJoinCallRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallJoinCallApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(CallJoinCallRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              CallJoinCallRequestApplicationJson(),
              specifiedType: const FullType(CallJoinCallRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Join a call.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call joined successfully
  ///   * 404: Call not found
  ///   * 400: No recording consent was given
  ///
  /// See:
  ///  * [$joinCall_Request] for the request send by this method.
  ///  * [$joinCall_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallJoinCallResponseApplicationJson, void>> joinCall({
    required String token,
    CallJoinCallApiVersion? apiVersion,
    bool? oCSAPIRequest,
    CallJoinCallRequestApplicationJson? $body,
  }) async {
    final _request = $joinCall_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $joinCall_Serializer();
    return _i1.ResponseConverter<CallJoinCallResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$leaveCall_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallLeaveCallResponseApplicationJson, void> $leaveCall_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(CallLeaveCallResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Leave a call.
  ///
  /// Returns a `DynamiteRequest` backing the [leaveCall] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [all] whether to also terminate the call for all participants. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call left successfully
  ///   * 404: Call session not found
  ///
  /// See:
  ///  * [leaveCall] for a method executing this request and parsing the response.
  ///  * [$leaveCall_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $leaveCall_Request({
    required String token,
    CallLeaveCallApiVersion? apiVersion,
    CallLeaveCallAll? all,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallLeaveCallApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    var __all = _$jsonSerializers.serialize(all, specifiedType: const FullType(CallLeaveCallAll));
    __all ??= 0;
    _parameters['all'] = __all;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}{?all*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Leave a call.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [all] whether to also terminate the call for all participants. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call left successfully
  ///   * 404: Call session not found
  ///
  /// See:
  ///  * [$leaveCall_Request] for the request send by this method.
  ///  * [$leaveCall_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallLeaveCallResponseApplicationJson, void>> leaveCall({
    required String token,
    CallLeaveCallApiVersion? apiVersion,
    CallLeaveCallAll? all,
    bool? oCSAPIRequest,
  }) async {
    final _request = $leaveCall_Request(
      token: token,
      apiVersion: apiVersion,
      all: all,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $leaveCall_Serializer();
    return _i1.ResponseConverter<CallLeaveCallResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateFederatedCallFlags_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallUpdateFederatedCallFlagsResponseApplicationJson, void>
      $updateFederatedCallFlags_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(CallUpdateFederatedCallFlagsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200, 400},
          );

  /// Update the in-call flags on the host server using the session id of the federated user.
  ///
  /// Returns a `DynamiteRequest` backing the [updateFederatedCallFlags] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: In-call flags updated successfully
  ///   * 400: Updating in-call flags is not possible
  ///   * 404: Call session not found
  ///
  /// See:
  ///  * [updateFederatedCallFlags] for a method executing this request and parsing the response.
  ///  * [$updateFederatedCallFlags_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateFederatedCallFlags_Request({
    required String token,
    required CallUpdateFederatedCallFlagsRequestApplicationJson $body,
    CallUpdateFederatedCallFlagsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallUpdateFederatedCallFlagsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}/federation').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(CallUpdateFederatedCallFlagsRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update the in-call flags on the host server using the session id of the federated user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: In-call flags updated successfully
  ///   * 400: Updating in-call flags is not possible
  ///   * 404: Call session not found
  ///
  /// See:
  ///  * [$updateFederatedCallFlags_Request] for the request send by this method.
  ///  * [$updateFederatedCallFlags_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallUpdateFederatedCallFlagsResponseApplicationJson, void>> updateFederatedCallFlags({
    required String token,
    required CallUpdateFederatedCallFlagsRequestApplicationJson $body,
    CallUpdateFederatedCallFlagsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $updateFederatedCallFlags_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateFederatedCallFlags_Serializer();
    return _i1.ResponseConverter<CallUpdateFederatedCallFlagsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$joinFederatedCall_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallJoinFederatedCallResponseApplicationJson, void> $joinFederatedCall_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(CallJoinFederatedCallResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Join call on the host server using the session id of the federated user.
  ///
  /// Returns a `DynamiteRequest` backing the [joinFederatedCall] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call joined successfully
  ///   * 400: Conditions to join not met
  ///   * 404: Call not found
  ///
  /// See:
  ///  * [joinFederatedCall] for a method executing this request and parsing the response.
  ///  * [$joinFederatedCall_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $joinFederatedCall_Request({
    required String token,
    required CallJoinFederatedCallRequestApplicationJson $body,
    CallJoinFederatedCallApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallJoinFederatedCallApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}/federation').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(CallJoinFederatedCallRequestApplicationJson)),
    );
    return _request;
  }

  /// Join call on the host server using the session id of the federated user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call joined successfully
  ///   * 400: Conditions to join not met
  ///   * 404: Call not found
  ///
  /// See:
  ///  * [$joinFederatedCall_Request] for the request send by this method.
  ///  * [$joinFederatedCall_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallJoinFederatedCallResponseApplicationJson, void>> joinFederatedCall({
    required String token,
    required CallJoinFederatedCallRequestApplicationJson $body,
    CallJoinFederatedCallApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $joinFederatedCall_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $joinFederatedCall_Serializer();
    return _i1.ResponseConverter<CallJoinFederatedCallResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$leaveFederatedCall_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallLeaveFederatedCallResponseApplicationJson, void> $leaveFederatedCall_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(CallLeaveFederatedCallResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Leave a call on the host server using the session id of the federated user.
  ///
  /// Returns a `DynamiteRequest` backing the [leaveFederatedCall] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [sessionId] Federated session id to leave with.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call left successfully
  ///   * 404: Call session not found
  ///
  /// See:
  ///  * [leaveFederatedCall] for a method executing this request and parsing the response.
  ///  * [$leaveFederatedCall_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $leaveFederatedCall_Request({
    required String token,
    required String sessionId,
    CallLeaveFederatedCallApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __sessionId = _$jsonSerializers.serialize(sessionId, specifiedType: const FullType(String));
    _parameters['sessionId'] = __sessionId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallLeaveFederatedCallApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}/federation{?sessionId*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Leave a call on the host server using the session id of the federated user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [sessionId] Federated session id to leave with.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call left successfully
  ///   * 404: Call session not found
  ///
  /// See:
  ///  * [$leaveFederatedCall_Request] for the request send by this method.
  ///  * [$leaveFederatedCall_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallLeaveFederatedCallResponseApplicationJson, void>> leaveFederatedCall({
    required String token,
    required String sessionId,
    CallLeaveFederatedCallApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $leaveFederatedCall_Request(
      token: token,
      sessionId: sessionId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $leaveFederatedCall_Serializer();
    return _i1.ResponseConverter<CallLeaveFederatedCallResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$ringAttendee_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallRingAttendeeResponseApplicationJson, void> $ringAttendee_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(CallRingAttendeeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Ring an attendee.
  ///
  /// Returns a `DynamiteRequest` backing the [ringAttendee] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [attendeeId] ID of the attendee to ring.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee rang successfully
  ///   * 404: Attendee could not be found
  ///   * 400: Ringing attendee is not possible
  ///
  /// See:
  ///  * [ringAttendee] for a method executing this request and parsing the response.
  ///  * [$ringAttendee_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $ringAttendee_Request({
    required String token,
    required int attendeeId,
    CallRingAttendeeApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __attendeeId = _$jsonSerializers.serialize(attendeeId, specifiedType: const FullType(int));
    _parameters['attendeeId'] = __attendeeId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallRingAttendeeApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}/ring/{attendeeId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Ring an attendee.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [attendeeId] ID of the attendee to ring.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee rang successfully
  ///   * 404: Attendee could not be found
  ///   * 400: Ringing attendee is not possible
  ///
  /// See:
  ///  * [$ringAttendee_Request] for the request send by this method.
  ///  * [$ringAttendee_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallRingAttendeeResponseApplicationJson, void>> ringAttendee({
    required String token,
    required int attendeeId,
    CallRingAttendeeApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $ringAttendee_Request(
      token: token,
      attendeeId: attendeeId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $ringAttendee_Serializer();
    return _i1.ResponseConverter<CallRingAttendeeResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$sipDialOut_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CallSipDialOutResponseApplicationJson, void> $sipDialOut_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(CallSipDialOutResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {201, 400, 404, 501},
      );

  /// Call a SIP dial-out attendee.
  ///
  /// Returns a `DynamiteRequest` backing the [sipDialOut] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [attendeeId] ID of the attendee to call.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Dial-out initiated successfully
  ///   * 400: SIP dial-out not possible
  ///   * 404: Participant could not be found or is a wrong type
  ///   * 501: SIP dial-out is not configured on the server
  ///
  /// See:
  ///  * [sipDialOut] for a method executing this request and parsing the response.
  ///  * [$sipDialOut_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $sipDialOut_Request({
    required String token,
    required int attendeeId,
    CallSipDialOutApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __attendeeId = _$jsonSerializers.serialize(attendeeId, specifiedType: const FullType(int));
    _parameters['attendeeId'] = __attendeeId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(CallSipDialOutApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/call/{token}/dialout/{attendeeId}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Call a SIP dial-out attendee.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [attendeeId] ID of the attendee to call.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Dial-out initiated successfully
  ///   * 400: SIP dial-out not possible
  ///   * 404: Participant could not be found or is a wrong type
  ///   * 501: SIP dial-out is not configured on the server
  ///
  /// See:
  ///  * [$sipDialOut_Request] for the request send by this method.
  ///  * [$sipDialOut_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CallSipDialOutResponseApplicationJson, void>> sipDialOut({
    required String token,
    required int attendeeId,
    CallSipDialOutApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $sipDialOut_Request(
      token: token,
      attendeeId: attendeeId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $sipDialOut_Serializer();
    return _i1.ResponseConverter<CallSipDialOutResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $ChatClient {
  /// Creates a new `DynamiteClient` for chat requests.
  $ChatClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$receiveMessages_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatReceiveMessagesResponseApplicationJson, ChatChatReceiveMessagesHeaders>
      $receiveMessages_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatReceiveMessagesResponseApplicationJson),
            headersType: const FullType(ChatChatReceiveMessagesHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Receives chat messages from the given room.
  ///
  /// - Receiving the history ($lookIntoFuture=0): The next $limit messages after $lastKnownMessageId will be returned. The new $lastKnownMessageId for the follow up query is available as `X-Chat-Last-Given` header.
  /// - Looking into the future ($lookIntoFuture=1): If there are currently no messages the response will not be sent immediately. Instead, HTTP connection will be kept open waiting for new messages to arrive and, when they do, then the response will be sent. The connection will not be kept open indefinitely, though; the number of seconds to wait for new messages to arrive can be set using the timeout parameter; the default timeout is 30 seconds, maximum timeout is 60 seconds. If the timeout ends a successful but empty response will be sent. If messages have been returned (status=200) the new $lastKnownMessageId for the follow up query is available as `X-Chat-Last-Given` header.
  /// The limit specifies the maximum number of messages that will be returned, although the actual number of returned messages could be lower if some messages are not visible to the participant. Note that if none of the messages are visible to the participant the returned number of messages will be 0, yet the status will still be 200. Also note that `X-Chat-Last-Given` may reference a message not visible and thus not returned, but it should be used nevertheless as the $lastKnownMessageId for the follow-up query.
  ///
  /// Returns a `DynamiteRequest` backing the [receiveMessages] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [lookIntoFuture] Polling for new messages (1) or getting the history of the chat (0).
  ///   * [limit] Number of chat messages to receive (100 by default, 200 at most). Defaults to `100`.
  ///   * [lastKnownMessageId] The last known message (serves as offset). Defaults to `0`.
  ///   * [lastCommonReadId] The last known common read message (so the response is 200 instead of 304 when it changes even when there are no messages). Defaults to `0`.
  ///   * [timeout] Number of seconds to wait for new messages (30 by default, 30 at most). Defaults to `30`.
  ///   * [setReadMarker] Automatically set the last read marker when 1, if your client does this itself via chat/{token}/read set to 0. Defaults to `1`.
  ///   * [includeLastKnown] Include the $lastKnownMessageId in the messages when 1 (default 0). Defaults to `0`.
  ///   * [noStatusUpdate] When the user status should not be automatically set to online set to 1 (default 0). Defaults to `0`.
  ///   * [markNotificationsAsRead] Set to 0 when notifications should not be marked as read (default 1). Defaults to `1`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Messages returned
  ///   * 304: No messages
  ///
  /// See:
  ///  * [receiveMessages] for a method executing this request and parsing the response.
  ///  * [$receiveMessages_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $receiveMessages_Request({
    required String token,
    required ChatReceiveMessagesLookIntoFuture lookIntoFuture,
    ChatReceiveMessagesApiVersion? apiVersion,
    int? limit,
    int? lastKnownMessageId,
    int? lastCommonReadId,
    int? timeout,
    ChatReceiveMessagesSetReadMarker? setReadMarker,
    ChatReceiveMessagesIncludeLastKnown? includeLastKnown,
    ChatReceiveMessagesNoStatusUpdate? noStatusUpdate,
    ChatReceiveMessagesMarkNotificationsAsRead? markNotificationsAsRead,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __lookIntoFuture =
        _$jsonSerializers.serialize(lookIntoFuture, specifiedType: const FullType(ChatReceiveMessagesLookIntoFuture));
    _parameters['lookIntoFuture'] = __lookIntoFuture;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatReceiveMessagesApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    var __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    __limit ??= 100;
    _parameters['limit'] = __limit;

    var __lastKnownMessageId = _$jsonSerializers.serialize(lastKnownMessageId, specifiedType: const FullType(int));
    __lastKnownMessageId ??= 0;
    _i4.checkNumber(
      __lastKnownMessageId,
      'lastKnownMessageId',
      minimum: 0,
    );
    _parameters['lastKnownMessageId'] = __lastKnownMessageId;

    var __lastCommonReadId = _$jsonSerializers.serialize(lastCommonReadId, specifiedType: const FullType(int));
    __lastCommonReadId ??= 0;
    _i4.checkNumber(
      __lastCommonReadId,
      'lastCommonReadId',
      minimum: 0,
    );
    _parameters['lastCommonReadId'] = __lastCommonReadId;

    var __timeout = _$jsonSerializers.serialize(timeout, specifiedType: const FullType(int));
    __timeout ??= 30;
    _i4.checkNumber(
      __timeout,
      'timeout',
      maximum: 30,
      minimum: 0,
    );
    _parameters['timeout'] = __timeout;

    var __setReadMarker =
        _$jsonSerializers.serialize(setReadMarker, specifiedType: const FullType(ChatReceiveMessagesSetReadMarker));
    __setReadMarker ??= 1;
    _parameters['setReadMarker'] = __setReadMarker;

    var __includeLastKnown = _$jsonSerializers.serialize(
      includeLastKnown,
      specifiedType: const FullType(ChatReceiveMessagesIncludeLastKnown),
    );
    __includeLastKnown ??= 0;
    _parameters['includeLastKnown'] = __includeLastKnown;

    var __noStatusUpdate =
        _$jsonSerializers.serialize(noStatusUpdate, specifiedType: const FullType(ChatReceiveMessagesNoStatusUpdate));
    __noStatusUpdate ??= 0;
    _parameters['noStatusUpdate'] = __noStatusUpdate;

    var __markNotificationsAsRead = _$jsonSerializers.serialize(
      markNotificationsAsRead,
      specifiedType: const FullType(ChatReceiveMessagesMarkNotificationsAsRead),
    );
    __markNotificationsAsRead ??= 1;
    _parameters['markNotificationsAsRead'] = __markNotificationsAsRead;

    final _path = _i5.UriTemplate(
      '/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}{?lookIntoFuture*,limit*,lastKnownMessageId*,lastCommonReadId*,timeout*,setReadMarker*,includeLastKnown*,noStatusUpdate*,markNotificationsAsRead*}',
    ).expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Receives chat messages from the given room.
  ///
  /// - Receiving the history ($lookIntoFuture=0): The next $limit messages after $lastKnownMessageId will be returned. The new $lastKnownMessageId for the follow up query is available as `X-Chat-Last-Given` header.
  /// - Looking into the future ($lookIntoFuture=1): If there are currently no messages the response will not be sent immediately. Instead, HTTP connection will be kept open waiting for new messages to arrive and, when they do, then the response will be sent. The connection will not be kept open indefinitely, though; the number of seconds to wait for new messages to arrive can be set using the timeout parameter; the default timeout is 30 seconds, maximum timeout is 60 seconds. If the timeout ends a successful but empty response will be sent. If messages have been returned (status=200) the new $lastKnownMessageId for the follow up query is available as `X-Chat-Last-Given` header.
  /// The limit specifies the maximum number of messages that will be returned, although the actual number of returned messages could be lower if some messages are not visible to the participant. Note that if none of the messages are visible to the participant the returned number of messages will be 0, yet the status will still be 200. Also note that `X-Chat-Last-Given` may reference a message not visible and thus not returned, but it should be used nevertheless as the $lastKnownMessageId for the follow-up query.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [lookIntoFuture] Polling for new messages (1) or getting the history of the chat (0).
  ///   * [limit] Number of chat messages to receive (100 by default, 200 at most). Defaults to `100`.
  ///   * [lastKnownMessageId] The last known message (serves as offset). Defaults to `0`.
  ///   * [lastCommonReadId] The last known common read message (so the response is 200 instead of 304 when it changes even when there are no messages). Defaults to `0`.
  ///   * [timeout] Number of seconds to wait for new messages (30 by default, 30 at most). Defaults to `30`.
  ///   * [setReadMarker] Automatically set the last read marker when 1, if your client does this itself via chat/{token}/read set to 0. Defaults to `1`.
  ///   * [includeLastKnown] Include the $lastKnownMessageId in the messages when 1 (default 0). Defaults to `0`.
  ///   * [noStatusUpdate] When the user status should not be automatically set to online set to 1 (default 0). Defaults to `0`.
  ///   * [markNotificationsAsRead] Set to 0 when notifications should not be marked as read (default 1). Defaults to `1`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Messages returned
  ///   * 304: No messages
  ///
  /// See:
  ///  * [$receiveMessages_Request] for the request send by this method.
  ///  * [$receiveMessages_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatReceiveMessagesResponseApplicationJson, ChatChatReceiveMessagesHeaders>>
      receiveMessages({
    required String token,
    required ChatReceiveMessagesLookIntoFuture lookIntoFuture,
    ChatReceiveMessagesApiVersion? apiVersion,
    int? limit,
    int? lastKnownMessageId,
    int? lastCommonReadId,
    int? timeout,
    ChatReceiveMessagesSetReadMarker? setReadMarker,
    ChatReceiveMessagesIncludeLastKnown? includeLastKnown,
    ChatReceiveMessagesNoStatusUpdate? noStatusUpdate,
    ChatReceiveMessagesMarkNotificationsAsRead? markNotificationsAsRead,
    bool? oCSAPIRequest,
  }) async {
    final _request = $receiveMessages_Request(
      token: token,
      lookIntoFuture: lookIntoFuture,
      apiVersion: apiVersion,
      limit: limit,
      lastKnownMessageId: lastKnownMessageId,
      lastCommonReadId: lastCommonReadId,
      timeout: timeout,
      setReadMarker: setReadMarker,
      includeLastKnown: includeLastKnown,
      noStatusUpdate: noStatusUpdate,
      markNotificationsAsRead: markNotificationsAsRead,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $receiveMessages_Serializer();
    return _i1.ResponseConverter<ChatReceiveMessagesResponseApplicationJson, ChatChatReceiveMessagesHeaders>(
      _serializer,
    ).convert(_response);
  }

  /// Builds a serializer to parse the response of [$sendMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatSendMessageResponseApplicationJson, ChatChatSendMessageHeaders>
      $sendMessage_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatSendMessageResponseApplicationJson),
            headersType: const FullType(ChatChatSendMessageHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {201},
          );

  /// Sends a new chat message to the given room.
  ///
  /// The author and timestamp are automatically set to the current user/guest and time.
  ///
  /// Returns a `DynamiteRequest` backing the [sendMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Message sent successfully
  ///   * 400: Sending message is not possible
  ///   * 404: Actor not found
  ///   * 413: Message too long
  ///   * 429: Mention rate limit exceeded (guests only)
  ///
  /// See:
  ///  * [sendMessage] for a method executing this request and parsing the response.
  ///  * [$sendMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $sendMessage_Request({
    required String token,
    required ChatSendMessageRequestApplicationJson $body,
    ChatSendMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatSendMessageApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ChatSendMessageRequestApplicationJson)),
    );
    return _request;
  }

  /// Sends a new chat message to the given room.
  ///
  /// The author and timestamp are automatically set to the current user/guest and time.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Message sent successfully
  ///   * 400: Sending message is not possible
  ///   * 404: Actor not found
  ///   * 413: Message too long
  ///   * 429: Mention rate limit exceeded (guests only)
  ///
  /// See:
  ///  * [$sendMessage_Request] for the request send by this method.
  ///  * [$sendMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatSendMessageResponseApplicationJson, ChatChatSendMessageHeaders>> sendMessage({
    required String token,
    required ChatSendMessageRequestApplicationJson $body,
    ChatSendMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $sendMessage_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $sendMessage_Serializer();
    return _i1.ResponseConverter<ChatSendMessageResponseApplicationJson, ChatChatSendMessageHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$clearHistory_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatClearHistoryResponseApplicationJson, ChatChatClearHistoryHeaders>
      $clearHistory_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatClearHistoryResponseApplicationJson),
            headersType: const FullType(ChatChatClearHistoryHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200, 202},
          );

  /// Clear the chat history.
  ///
  /// Returns a `DynamiteRequest` backing the [clearHistory] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: History cleared successfully
  ///   * 202: History cleared successfully, but Matterbridge is configured, so the information can be replicated elsewhere
  ///   * 403: Missing permissions to clear history
  ///
  /// See:
  ///  * [clearHistory] for a method executing this request and parsing the response.
  ///  * [$clearHistory_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $clearHistory_Request({
    required String token,
    ChatClearHistoryApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatClearHistoryApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Clear the chat history.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: History cleared successfully
  ///   * 202: History cleared successfully, but Matterbridge is configured, so the information can be replicated elsewhere
  ///   * 403: Missing permissions to clear history
  ///
  /// See:
  ///  * [$clearHistory_Request] for the request send by this method.
  ///  * [$clearHistory_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatClearHistoryResponseApplicationJson, ChatChatClearHistoryHeaders>> clearHistory({
    required String token,
    ChatClearHistoryApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $clearHistory_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $clearHistory_Serializer();
    return _i1.ResponseConverter<ChatClearHistoryResponseApplicationJson, ChatChatClearHistoryHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$editMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatEditMessageResponseApplicationJson, ChatChatEditMessageHeaders>
      $editMessage_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatEditMessageResponseApplicationJson),
            headersType: const FullType(ChatChatEditMessageHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200, 202},
          );

  /// Edit a chat message.
  ///
  /// Returns a `DynamiteRequest` backing the [editMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message edited successfully
  ///   * 202: Message edited successfully, but a bot or Matterbridge is configured, so the information can be replicated to other services
  ///   * 400: Editing message is not possible, e.g. when the new message is empty or the message is too old
  ///   * 403: Missing permissions to edit message
  ///   * 404: Message not found
  ///   * 405: Editing this message type is not allowed
  ///   * 413: Message too long
  ///
  /// See:
  ///  * [editMessage] for a method executing this request and parsing the response.
  ///  * [$editMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $editMessage_Request({
    required String token,
    required int messageId,
    required ChatEditMessageRequestApplicationJson $body,
    ChatEditMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatEditMessageApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/{messageId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ChatEditMessageRequestApplicationJson)),
    );
    return _request;
  }

  /// Edit a chat message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message edited successfully
  ///   * 202: Message edited successfully, but a bot or Matterbridge is configured, so the information can be replicated to other services
  ///   * 400: Editing message is not possible, e.g. when the new message is empty or the message is too old
  ///   * 403: Missing permissions to edit message
  ///   * 404: Message not found
  ///   * 405: Editing this message type is not allowed
  ///   * 413: Message too long
  ///
  /// See:
  ///  * [$editMessage_Request] for the request send by this method.
  ///  * [$editMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatEditMessageResponseApplicationJson, ChatChatEditMessageHeaders>> editMessage({
    required String token,
    required int messageId,
    required ChatEditMessageRequestApplicationJson $body,
    ChatEditMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $editMessage_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $editMessage_Serializer();
    return _i1.ResponseConverter<ChatEditMessageResponseApplicationJson, ChatChatEditMessageHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatDeleteMessageResponseApplicationJson, ChatChatDeleteMessageHeaders>
      $deleteMessage_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatDeleteMessageResponseApplicationJson),
            headersType: const FullType(ChatChatDeleteMessageHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200, 202},
          );

  /// Delete a chat message.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message deleted successfully
  ///   * 202: Message deleted successfully, but a bot or Matterbridge is configured, so the information can be replicated elsewhere
  ///   * 400: Deleting message is not possible
  ///   * 403: Missing permissions to delete message
  ///   * 404: Message not found
  ///   * 405: Deleting this message type is not allowed
  ///
  /// See:
  ///  * [deleteMessage] for a method executing this request and parsing the response.
  ///  * [$deleteMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteMessage_Request({
    required String token,
    required int messageId,
    ChatDeleteMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatDeleteMessageApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/{messageId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete a chat message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message deleted successfully
  ///   * 202: Message deleted successfully, but a bot or Matterbridge is configured, so the information can be replicated elsewhere
  ///   * 400: Deleting message is not possible
  ///   * 403: Missing permissions to delete message
  ///   * 404: Message not found
  ///   * 405: Deleting this message type is not allowed
  ///
  /// See:
  ///  * [$deleteMessage_Request] for the request send by this method.
  ///  * [$deleteMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatDeleteMessageResponseApplicationJson, ChatChatDeleteMessageHeaders>> deleteMessage({
    required String token,
    required int messageId,
    ChatDeleteMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteMessage_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteMessage_Serializer();
    return _i1.ResponseConverter<ChatDeleteMessageResponseApplicationJson, ChatChatDeleteMessageHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getMessageContext_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatGetMessageContextResponseApplicationJson, ChatChatGetMessageContextHeaders>
      $getMessageContext_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatGetMessageContextResponseApplicationJson),
            headersType: const FullType(ChatChatGetMessageContextHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the context of a message.
  ///
  /// Returns a `DynamiteRequest` backing the [getMessageContext] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] The focused message which should be in the "middle" of the returned context.
  ///   * [limit] Number of chat messages to receive in both directions (50 by default, 100 at most, might return 201 messages). Defaults to `50`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message context returned
  ///   * 304: No messages
  ///
  /// See:
  ///  * [getMessageContext] for a method executing this request and parsing the response.
  ///  * [$getMessageContext_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getMessageContext_Request({
    required String token,
    required int messageId,
    ChatGetMessageContextApiVersion? apiVersion,
    int? limit,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatGetMessageContextApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    var __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    __limit ??= 50;
    _i4.checkNumber(
      __limit,
      'limit',
      maximum: 100,
      minimum: 1,
    );
    _parameters['limit'] = __limit;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/{messageId}/context{?limit*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the context of a message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] The focused message which should be in the "middle" of the returned context.
  ///   * [limit] Number of chat messages to receive in both directions (50 by default, 100 at most, might return 201 messages). Defaults to `50`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message context returned
  ///   * 304: No messages
  ///
  /// See:
  ///  * [$getMessageContext_Request] for the request send by this method.
  ///  * [$getMessageContext_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatGetMessageContextResponseApplicationJson, ChatChatGetMessageContextHeaders>>
      getMessageContext({
    required String token,
    required int messageId,
    ChatGetMessageContextApiVersion? apiVersion,
    int? limit,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getMessageContext_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      limit: limit,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getMessageContext_Serializer();
    return _i1.ResponseConverter<ChatGetMessageContextResponseApplicationJson, ChatChatGetMessageContextHeaders>(
      _serializer,
    ).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getReminder_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatGetReminderResponseApplicationJson, void> $getReminder_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ChatGetReminderResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the reminder for a chat message.
  ///
  /// Returns a `DynamiteRequest` backing the [getReminder] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reminder returned
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [getReminder] for a method executing this request and parsing the response.
  ///  * [$getReminder_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getReminder_Request({
    required String token,
    required int messageId,
    ChatGetReminderApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatGetReminderApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/{messageId}/reminder')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the reminder for a chat message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reminder returned
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [$getReminder_Request] for the request send by this method.
  ///  * [$getReminder_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatGetReminderResponseApplicationJson, void>> getReminder({
    required String token,
    required int messageId,
    ChatGetReminderApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getReminder_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getReminder_Serializer();
    return _i1.ResponseConverter<ChatGetReminderResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setReminder_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatSetReminderResponseApplicationJson, void> $setReminder_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ChatSetReminderResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {201},
      );

  /// Set a reminder for a chat message.
  ///
  /// Returns a `DynamiteRequest` backing the [setReminder] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Reminder created successfully
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [setReminder] for a method executing this request and parsing the response.
  ///  * [$setReminder_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setReminder_Request({
    required String token,
    required int messageId,
    required ChatSetReminderRequestApplicationJson $body,
    ChatSetReminderApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatSetReminderApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/{messageId}/reminder')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ChatSetReminderRequestApplicationJson)),
    );
    return _request;
  }

  /// Set a reminder for a chat message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Reminder created successfully
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [$setReminder_Request] for the request send by this method.
  ///  * [$setReminder_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatSetReminderResponseApplicationJson, void>> setReminder({
    required String token,
    required int messageId,
    required ChatSetReminderRequestApplicationJson $body,
    ChatSetReminderApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setReminder_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setReminder_Serializer();
    return _i1.ResponseConverter<ChatSetReminderResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteReminder_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatDeleteReminderResponseApplicationJson, void> $deleteReminder_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ChatDeleteReminderResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Delete a chat reminder.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteReminder] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reminder deleted successfully
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [deleteReminder] for a method executing this request and parsing the response.
  ///  * [$deleteReminder_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteReminder_Request({
    required String token,
    required int messageId,
    ChatDeleteReminderApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatDeleteReminderApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/{messageId}/reminder')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete a chat reminder.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reminder deleted successfully
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [$deleteReminder_Request] for the request send by this method.
  ///  * [$deleteReminder_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatDeleteReminderResponseApplicationJson, void>> deleteReminder({
    required String token,
    required int messageId,
    ChatDeleteReminderApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteReminder_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteReminder_Serializer();
    return _i1.ResponseConverter<ChatDeleteReminderResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setReadMarker_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatSetReadMarkerResponseApplicationJson, ChatChatSetReadMarkerHeaders>
      $setReadMarker_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatSetReadMarkerResponseApplicationJson),
            headersType: const FullType(ChatChatSetReadMarkerHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Set the read marker to a specific message.
  ///
  /// Returns a `DynamiteRequest` backing the [setReadMarker] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Read marker set successfully
  ///
  /// See:
  ///  * [setReadMarker] for a method executing this request and parsing the response.
  ///  * [$setReadMarker_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setReadMarker_Request({
    required String token,
    ChatSetReadMarkerApiVersion? apiVersion,
    bool? oCSAPIRequest,
    ChatSetReadMarkerRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatSetReadMarkerApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/read').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(ChatSetReadMarkerRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              ChatSetReadMarkerRequestApplicationJson(),
              specifiedType: const FullType(ChatSetReadMarkerRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Set the read marker to a specific message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Read marker set successfully
  ///
  /// See:
  ///  * [$setReadMarker_Request] for the request send by this method.
  ///  * [$setReadMarker_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatSetReadMarkerResponseApplicationJson, ChatChatSetReadMarkerHeaders>> setReadMarker({
    required String token,
    ChatSetReadMarkerApiVersion? apiVersion,
    bool? oCSAPIRequest,
    ChatSetReadMarkerRequestApplicationJson? $body,
  }) async {
    final _request = $setReadMarker_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setReadMarker_Serializer();
    return _i1.ResponseConverter<ChatSetReadMarkerResponseApplicationJson, ChatChatSetReadMarkerHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$markUnread_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatMarkUnreadResponseApplicationJson, ChatChatMarkUnreadHeaders> $markUnread_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ChatMarkUnreadResponseApplicationJson),
        headersType: const FullType(ChatChatMarkUnreadHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Mark a chat as unread.
  ///
  /// Returns a `DynamiteRequest` backing the [markUnread] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Read marker set successfully
  ///
  /// See:
  ///  * [markUnread] for a method executing this request and parsing the response.
  ///  * [$markUnread_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $markUnread_Request({
    required String token,
    ChatMarkUnreadApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatMarkUnreadApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/read').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Mark a chat as unread.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Read marker set successfully
  ///
  /// See:
  ///  * [$markUnread_Request] for the request send by this method.
  ///  * [$markUnread_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatMarkUnreadResponseApplicationJson, ChatChatMarkUnreadHeaders>> markUnread({
    required String token,
    ChatMarkUnreadApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $markUnread_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $markUnread_Serializer();
    return _i1.ResponseConverter<ChatMarkUnreadResponseApplicationJson, ChatChatMarkUnreadHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$mentions_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatMentionsResponseApplicationJson, void> $mentions_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ChatMentionsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Search for mentions.
  ///
  /// Returns a `DynamiteRequest` backing the [mentions] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [search] Text to search for.
  ///   * [limit] Maximum number of results. Defaults to `20`.
  ///   * [includeStatus] Include the user statuses. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List of mention suggestions returned
  ///
  /// See:
  ///  * [mentions] for a method executing this request and parsing the response.
  ///  * [$mentions_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $mentions_Request({
    required String token,
    required String search,
    ChatMentionsApiVersion? apiVersion,
    int? limit,
    ChatMentionsIncludeStatus? includeStatus,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    _parameters['search'] = __search;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatMentionsApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    var __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    __limit ??= 20;
    _parameters['limit'] = __limit;

    var __includeStatus =
        _$jsonSerializers.serialize(includeStatus, specifiedType: const FullType(ChatMentionsIncludeStatus));
    __includeStatus ??= 0;
    _parameters['includeStatus'] = __includeStatus;

    final _path = _i5.UriTemplate(
      '/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/mentions{?search*,limit*,includeStatus*}',
    ).expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Search for mentions.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [search] Text to search for.
  ///   * [limit] Maximum number of results. Defaults to `20`.
  ///   * [includeStatus] Include the user statuses. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List of mention suggestions returned
  ///
  /// See:
  ///  * [$mentions_Request] for the request send by this method.
  ///  * [$mentions_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatMentionsResponseApplicationJson, void>> mentions({
    required String token,
    required String search,
    ChatMentionsApiVersion? apiVersion,
    int? limit,
    ChatMentionsIncludeStatus? includeStatus,
    bool? oCSAPIRequest,
  }) async {
    final _request = $mentions_Request(
      token: token,
      search: search,
      apiVersion: apiVersion,
      limit: limit,
      includeStatus: includeStatus,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $mentions_Serializer();
    return _i1.ResponseConverter<ChatMentionsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getObjectsSharedInRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatGetObjectsSharedInRoomResponseApplicationJson, ChatChatGetObjectsSharedInRoomHeaders>
      $getObjectsSharedInRoom_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatGetObjectsSharedInRoomResponseApplicationJson),
            headersType: const FullType(ChatChatGetObjectsSharedInRoomHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get objects that are shared in the room.
  ///
  /// Returns a `DynamiteRequest` backing the [getObjectsSharedInRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [objectType] Type of the objects.
  ///   * [lastKnownMessageId] ID of the last known message. Defaults to `0`.
  ///   * [limit] Maximum number of objects. Defaults to `100`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List of shared objects messages returned
  ///
  /// See:
  ///  * [getObjectsSharedInRoom] for a method executing this request and parsing the response.
  ///  * [$getObjectsSharedInRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getObjectsSharedInRoom_Request({
    required String token,
    required String objectType,
    ChatGetObjectsSharedInRoomApiVersion? apiVersion,
    int? lastKnownMessageId,
    int? limit,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __objectType = _$jsonSerializers.serialize(objectType, specifiedType: const FullType(String));
    _parameters['objectType'] = __objectType;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatGetObjectsSharedInRoomApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    var __lastKnownMessageId = _$jsonSerializers.serialize(lastKnownMessageId, specifiedType: const FullType(int));
    __lastKnownMessageId ??= 0;
    _i4.checkNumber(
      __lastKnownMessageId,
      'lastKnownMessageId',
      minimum: 0,
    );
    _parameters['lastKnownMessageId'] = __lastKnownMessageId;

    var __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    __limit ??= 100;
    _i4.checkNumber(
      __limit,
      'limit',
      maximum: 200,
      minimum: 1,
    );
    _parameters['limit'] = __limit;

    final _path = _i5.UriTemplate(
      '/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/share{?objectType*,lastKnownMessageId*,limit*}',
    ).expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get objects that are shared in the room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [objectType] Type of the objects.
  ///   * [lastKnownMessageId] ID of the last known message. Defaults to `0`.
  ///   * [limit] Maximum number of objects. Defaults to `100`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List of shared objects messages returned
  ///
  /// See:
  ///  * [$getObjectsSharedInRoom_Request] for the request send by this method.
  ///  * [$getObjectsSharedInRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatGetObjectsSharedInRoomResponseApplicationJson, ChatChatGetObjectsSharedInRoomHeaders>>
      getObjectsSharedInRoom({
    required String token,
    required String objectType,
    ChatGetObjectsSharedInRoomApiVersion? apiVersion,
    int? lastKnownMessageId,
    int? limit,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getObjectsSharedInRoom_Request(
      token: token,
      objectType: objectType,
      apiVersion: apiVersion,
      lastKnownMessageId: lastKnownMessageId,
      limit: limit,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getObjectsSharedInRoom_Serializer();
    return _i1.ResponseConverter<ChatGetObjectsSharedInRoomResponseApplicationJson,
            ChatChatGetObjectsSharedInRoomHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$shareObjectToChat_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatShareObjectToChatResponseApplicationJson, ChatChatShareObjectToChatHeaders>
      $shareObjectToChat_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatShareObjectToChatResponseApplicationJson),
            headersType: const FullType(ChatChatShareObjectToChatHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {201},
          );

  /// Sends a rich-object to the given room.
  ///
  /// The author and timestamp are automatically set to the current user/guest and time.
  ///
  /// Returns a `DynamiteRequest` backing the [shareObjectToChat] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Object shared successfully
  ///   * 400: Sharing object is not possible
  ///   * 404: Actor not found
  ///   * 413: Message too long
  ///
  /// See:
  ///  * [shareObjectToChat] for a method executing this request and parsing the response.
  ///  * [$shareObjectToChat_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $shareObjectToChat_Request({
    required String token,
    required ChatShareObjectToChatRequestApplicationJson $body,
    ChatShareObjectToChatApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ChatShareObjectToChatApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/share').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ChatShareObjectToChatRequestApplicationJson)),
    );
    return _request;
  }

  /// Sends a rich-object to the given room.
  ///
  /// The author and timestamp are automatically set to the current user/guest and time.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Object shared successfully
  ///   * 400: Sharing object is not possible
  ///   * 404: Actor not found
  ///   * 413: Message too long
  ///
  /// See:
  ///  * [$shareObjectToChat_Request] for the request send by this method.
  ///  * [$shareObjectToChat_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatShareObjectToChatResponseApplicationJson, ChatChatShareObjectToChatHeaders>>
      shareObjectToChat({
    required String token,
    required ChatShareObjectToChatRequestApplicationJson $body,
    ChatShareObjectToChatApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $shareObjectToChat_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $shareObjectToChat_Serializer();
    return _i1.ResponseConverter<ChatShareObjectToChatResponseApplicationJson, ChatChatShareObjectToChatHeaders>(
      _serializer,
    ).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getObjectsSharedInRoomOverview_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ChatGetObjectsSharedInRoomOverviewResponseApplicationJson, void>
      $getObjectsSharedInRoomOverview_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ChatGetObjectsSharedInRoomOverviewResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get objects that are shared in the room overview.
  ///
  /// Returns a `DynamiteRequest` backing the [getObjectsSharedInRoomOverview] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [limit] Maximum number of objects. Defaults to `7`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List of shared objects messages of each type returned
  ///
  /// See:
  ///  * [getObjectsSharedInRoomOverview] for a method executing this request and parsing the response.
  ///  * [$getObjectsSharedInRoomOverview_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getObjectsSharedInRoomOverview_Request({
    required String token,
    ChatGetObjectsSharedInRoomOverviewApiVersion? apiVersion,
    int? limit,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(ChatGetObjectsSharedInRoomOverviewApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    var __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    __limit ??= 7;
    _i4.checkNumber(
      __limit,
      'limit',
      maximum: 20,
      minimum: 1,
    );
    _parameters['limit'] = __limit;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/chat/{token}/share/overview{?limit*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get objects that are shared in the room overview.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [limit] Maximum number of objects. Defaults to `7`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: List of shared objects messages of each type returned
  ///
  /// See:
  ///  * [$getObjectsSharedInRoomOverview_Request] for the request send by this method.
  ///  * [$getObjectsSharedInRoomOverview_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ChatGetObjectsSharedInRoomOverviewResponseApplicationJson, void>>
      getObjectsSharedInRoomOverview({
    required String token,
    ChatGetObjectsSharedInRoomOverviewApiVersion? apiVersion,
    int? limit,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getObjectsSharedInRoomOverview_Request(
      token: token,
      apiVersion: apiVersion,
      limit: limit,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getObjectsSharedInRoomOverview_Serializer();
    return _i1.ResponseConverter<ChatGetObjectsSharedInRoomOverviewResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $ExternalSignalingClient {
  /// Creates a new `DynamiteClient` for external_signaling requests.
  $ExternalSignalingClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$signalingGetSettings_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SignalingGetSettingsResponseApplicationJson, void> $signalingGetSettings_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(SignalingGetSettingsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the signaling settings.
  ///
  /// Returns a `DynamiteRequest` backing the [signalingGetSettings] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [token] Token of the room. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Signaling settings returned
  ///   * 401: Recording request invalid
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [signalingGetSettings] for a method executing this request and parsing the response.
  ///  * [$signalingGetSettings_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $signalingGetSettings_Request({
    SignalingGetSettingsApiVersion? apiVersion,
    String? token,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SignalingGetSettingsApiVersion));
    __apiVersion ??= 'v3';
    _parameters['apiVersion'] = __apiVersion;

    var __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    __token ??= '';
    _parameters['token'] = __token;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/signaling/settings{?token*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the signaling settings.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [token] Token of the room. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Signaling settings returned
  ///   * 401: Recording request invalid
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [$signalingGetSettings_Request] for the request send by this method.
  ///  * [$signalingGetSettings_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SignalingGetSettingsResponseApplicationJson, void>> signalingGetSettings({
    SignalingGetSettingsApiVersion? apiVersion,
    String? token,
    bool? oCSAPIRequest,
  }) async {
    final _request = $signalingGetSettings_Request(
      apiVersion: apiVersion,
      token: token,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $signalingGetSettings_Serializer();
    return _i1.ResponseConverter<SignalingGetSettingsResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $FederationClient {
  /// Creates a new `DynamiteClient` for federation requests.
  $FederationClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$acceptShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<FederationAcceptShareResponseApplicationJson, void> $acceptShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(FederationAcceptShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Accept a federation invites.
  ///
  /// 🚧 Draft: Still work in progress.
  ///
  /// Returns a `DynamiteRequest` backing the [acceptShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Invite accepted successfully
  ///   * 400: Invite can not be accepted (maybe it was accepted already)
  ///   * 410: Remote server could not be reached to notify about the acceptance
  ///   * 404: Invite can not be found
  ///
  /// See:
  ///  * [acceptShare] for a method executing this request and parsing the response.
  ///  * [$acceptShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $acceptShare_Request({
    required int id,
    FederationAcceptShareApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _i4.checkNumber(
      __id,
      'id',
      minimum: 0,
    );
    _parameters['id'] = __id;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(FederationAcceptShareApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/federation/invitation/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Accept a federation invites.
  ///
  /// 🚧 Draft: Still work in progress.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Invite accepted successfully
  ///   * 400: Invite can not be accepted (maybe it was accepted already)
  ///   * 410: Remote server could not be reached to notify about the acceptance
  ///   * 404: Invite can not be found
  ///
  /// See:
  ///  * [$acceptShare_Request] for the request send by this method.
  ///  * [$acceptShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<FederationAcceptShareResponseApplicationJson, void>> acceptShare({
    required int id,
    FederationAcceptShareApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $acceptShare_Request(
      id: id,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $acceptShare_Serializer();
    return _i1.ResponseConverter<FederationAcceptShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$rejectShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<FederationRejectShareResponseApplicationJson, void> $rejectShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(FederationRejectShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Decline a federation invites.
  ///
  /// 🚧 Draft: Still work in progress.
  ///
  /// Returns a `DynamiteRequest` backing the [rejectShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Invite declined successfully
  ///   * 404: Invite can not be found
  ///   * 400: Invite was already accepted, use the "Remove the current user from a room" endpoint instead
  ///
  /// See:
  ///  * [rejectShare] for a method executing this request and parsing the response.
  ///  * [$rejectShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $rejectShare_Request({
    required int id,
    FederationRejectShareApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _i4.checkNumber(
      __id,
      'id',
      minimum: 0,
    );
    _parameters['id'] = __id;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(FederationRejectShareApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/federation/invitation/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Decline a federation invites.
  ///
  /// 🚧 Draft: Still work in progress.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Invite declined successfully
  ///   * 404: Invite can not be found
  ///   * 400: Invite was already accepted, use the "Remove the current user from a room" endpoint instead
  ///
  /// See:
  ///  * [$rejectShare_Request] for the request send by this method.
  ///  * [$rejectShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<FederationRejectShareResponseApplicationJson, void>> rejectShare({
    required int id,
    FederationRejectShareApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $rejectShare_Request(
      id: id,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $rejectShare_Serializer();
    return _i1.ResponseConverter<FederationRejectShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getShares_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<FederationGetSharesResponseApplicationJson, void> $getShares_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(FederationGetSharesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of federation invites.
  ///
  /// 🚧 Draft: Still work in progress.
  ///
  /// Returns a `DynamiteRequest` backing the [getShares] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Get list of received federation invites successfully
  ///
  /// See:
  ///  * [getShares] for a method executing this request and parsing the response.
  ///  * [$getShares_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getShares_Request({
    FederationGetSharesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(FederationGetSharesApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/federation/invitation').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of federation invites.
  ///
  /// 🚧 Draft: Still work in progress.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Get list of received federation invites successfully
  ///
  /// See:
  ///  * [$getShares_Request] for the request send by this method.
  ///  * [$getShares_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<FederationGetSharesResponseApplicationJson, void>> getShares({
    FederationGetSharesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getShares_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getShares_Serializer();
    return _i1.ResponseConverter<FederationGetSharesResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $FilesIntegrationClient {
  /// Creates a new `DynamiteClient` for files_integration requests.
  $FilesIntegrationClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getRoomByFileId_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<FilesIntegrationGetRoomByFileIdResponseApplicationJson, void> $getRoomByFileId_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(FilesIntegrationGetRoomByFileIdResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the token of the room associated to the given file id.
  ///
  /// This is the counterpart of self::getRoomByShareToken() for file ids instead of share tokens, although both return the same room token if the given file id and share token refer to the same file.
  /// If there is no room associated to the given file id a new room is created; the new room is a public room associated with a "file" object with the given file id. Unlike normal rooms in which the owner is the user that created the room these are special rooms without owner (although self joined users with direct access to the file become persistent participants automatically when they join until they explicitly leave or no longer have access to the file).
  /// In any case, to create or even get the token of the room, the file must be shared and the user must be the owner of a public share of the file (like a link share, for example) or have direct access to that file; an error is returned otherwise. A user has direct access to a file if she has access to it (or to an ancestor) through a user, group, circle or room share (but not through a link share, for example), or if she is the owner of such a file.
  ///
  /// Returns a `DynamiteRequest` backing the [getRoomByFileId] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [fileId] ID of the file.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room token returned
  ///   * 400: Rooms not allowed for shares
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [getRoomByFileId] for a method executing this request and parsing the response.
  ///  * [$getRoomByFileId_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getRoomByFileId_Request({
    required String fileId,
    FilesIntegrationGetRoomByFileIdApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __fileId = _$jsonSerializers.serialize(fileId, specifiedType: const FullType(String));
    _i4.checkString(
      __fileId,
      'fileId',
      pattern: RegExp(r'^.+$'),
    );
    _parameters['fileId'] = __fileId;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(FilesIntegrationGetRoomByFileIdApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/file/{fileId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the token of the room associated to the given file id.
  ///
  /// This is the counterpart of self::getRoomByShareToken() for file ids instead of share tokens, although both return the same room token if the given file id and share token refer to the same file.
  /// If there is no room associated to the given file id a new room is created; the new room is a public room associated with a "file" object with the given file id. Unlike normal rooms in which the owner is the user that created the room these are special rooms without owner (although self joined users with direct access to the file become persistent participants automatically when they join until they explicitly leave or no longer have access to the file).
  /// In any case, to create or even get the token of the room, the file must be shared and the user must be the owner of a public share of the file (like a link share, for example) or have direct access to that file; an error is returned otherwise. A user has direct access to a file if she has access to it (or to an ancestor) through a user, group, circle or room share (but not through a link share, for example), or if she is the owner of such a file.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [fileId] ID of the file.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room token returned
  ///   * 400: Rooms not allowed for shares
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$getRoomByFileId_Request] for the request send by this method.
  ///  * [$getRoomByFileId_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<FilesIntegrationGetRoomByFileIdResponseApplicationJson, void>> getRoomByFileId({
    required String fileId,
    FilesIntegrationGetRoomByFileIdApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getRoomByFileId_Request(
      fileId: fileId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getRoomByFileId_Serializer();
    return _i1.ResponseConverter<FilesIntegrationGetRoomByFileIdResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getRoomByShareToken_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<FilesIntegrationGetRoomByShareTokenResponseApplicationJson, void>
      $getRoomByShareToken_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(FilesIntegrationGetRoomByShareTokenResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Returns the token of the room associated to the file of the given share token.
  ///
  /// This is the counterpart of self::getRoomByFileId() for share tokens instead of file ids, although both return the same room token if the given file id and share token refer to the same file.
  /// If there is no room associated to the file id of the given share token a new room is created; the new room is a public room associated with a "file" object with the file id of the given share token. Unlike normal rooms in which the owner is the user that created the room these are special rooms without owner (although self joined users with direct access to the file become persistent participants automatically when they join until they explicitly leave or no longer have access to the file).
  /// In any case, to create or even get the token of the room, the file must be publicly shared (like a link share, for example); an error is returned otherwise.
  /// Besides the token of the room this also returns the current user ID and display name, if any; this is needed by the Talk sidebar to know the actual current user, as the public share page uses the incognito mode and thus logged-in users as seen as guests.
  ///
  /// Returns a `DynamiteRequest` backing the [getRoomByShareToken] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [shareToken] Token of the file share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room token and user info returned
  ///   * 400: Rooms not allowed for shares
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [getRoomByShareToken] for a method executing this request and parsing the response.
  ///  * [$getRoomByShareToken_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getRoomByShareToken_Request({
    required String shareToken,
    FilesIntegrationGetRoomByShareTokenApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __shareToken = _$jsonSerializers.serialize(shareToken, specifiedType: const FullType(String));
    _i4.checkString(
      __shareToken,
      'shareToken',
      pattern: RegExp(r'^.+$'),
    );
    _parameters['shareToken'] = __shareToken;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(FilesIntegrationGetRoomByShareTokenApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/publicshare/{shareToken}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Returns the token of the room associated to the file of the given share token.
  ///
  /// This is the counterpart of self::getRoomByFileId() for share tokens instead of file ids, although both return the same room token if the given file id and share token refer to the same file.
  /// If there is no room associated to the file id of the given share token a new room is created; the new room is a public room associated with a "file" object with the file id of the given share token. Unlike normal rooms in which the owner is the user that created the room these are special rooms without owner (although self joined users with direct access to the file become persistent participants automatically when they join until they explicitly leave or no longer have access to the file).
  /// In any case, to create or even get the token of the room, the file must be publicly shared (like a link share, for example); an error is returned otherwise.
  /// Besides the token of the room this also returns the current user ID and display name, if any; this is needed by the Talk sidebar to know the actual current user, as the public share page uses the incognito mode and thus logged-in users as seen as guests.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [shareToken] Token of the file share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room token and user info returned
  ///   * 400: Rooms not allowed for shares
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$getRoomByShareToken_Request] for the request send by this method.
  ///  * [$getRoomByShareToken_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<FilesIntegrationGetRoomByShareTokenResponseApplicationJson, void>> getRoomByShareToken({
    required String shareToken,
    FilesIntegrationGetRoomByShareTokenApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getRoomByShareToken_Request(
      shareToken: shareToken,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getRoomByShareToken_Serializer();
    return _i1.ResponseConverter<FilesIntegrationGetRoomByShareTokenResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$publicShareAuthCreateRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PublicShareAuthCreateRoomResponseApplicationJson, void>
      $publicShareAuthCreateRoom_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(PublicShareAuthCreateRoomResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {201},
          );

  /// Creates a new room for video verification (requesting the password of a share).
  ///
  /// The new room is a public room associated with a "share:password" object with the ID of the share token. Unlike normal rooms in which the owner is the user that created the room these are special rooms always created by a guest or user on behalf of a registered user, the sharer, who will be the owner of the room.
  /// The share must have "send password by Talk" enabled; an error is returned otherwise.
  ///
  /// Returns a `DynamiteRequest` backing the [publicShareAuthCreateRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Room created successfully
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [publicShareAuthCreateRoom] for a method executing this request and parsing the response.
  ///  * [$publicShareAuthCreateRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $publicShareAuthCreateRoom_Request({
    required PublicShareAuthCreateRoomRequestApplicationJson $body,
    PublicShareAuthCreateRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(PublicShareAuthCreateRoomApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/publicshareauth').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(PublicShareAuthCreateRoomRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Creates a new room for video verification (requesting the password of a share).
  ///
  /// The new room is a public room associated with a "share:password" object with the ID of the share token. Unlike normal rooms in which the owner is the user that created the room these are special rooms always created by a guest or user on behalf of a registered user, the sharer, who will be the owner of the room.
  /// The share must have "send password by Talk" enabled; an error is returned otherwise.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Room created successfully
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$publicShareAuthCreateRoom_Request] for the request send by this method.
  ///  * [$publicShareAuthCreateRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PublicShareAuthCreateRoomResponseApplicationJson, void>> publicShareAuthCreateRoom({
    required PublicShareAuthCreateRoomRequestApplicationJson $body,
    PublicShareAuthCreateRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $publicShareAuthCreateRoom_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $publicShareAuthCreateRoom_Serializer();
    return _i1.ResponseConverter<PublicShareAuthCreateRoomResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $GuestClient {
  /// Creates a new `DynamiteClient` for guest requests.
  $GuestClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$setDisplayName_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<GuestSetDisplayNameResponseApplicationJson, void> $setDisplayName_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(GuestSetDisplayNameResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 403, 404},
      );

  /// Set the display name as a guest.
  ///
  /// Returns a `DynamiteRequest` backing the [setDisplayName] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Display name updated successfully
  ///   * 403: Not a guest
  ///   * 404: Not a participant
  ///
  /// See:
  ///  * [setDisplayName] for a method executing this request and parsing the response.
  ///  * [$setDisplayName_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setDisplayName_Request({
    required String token,
    required GuestSetDisplayNameRequestApplicationJson $body,
    GuestSetDisplayNameApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(GuestSetDisplayNameApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/guest/{token}/name').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(GuestSetDisplayNameRequestApplicationJson)),
    );
    return _request;
  }

  /// Set the display name as a guest.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Display name updated successfully
  ///   * 403: Not a guest
  ///   * 404: Not a participant
  ///
  /// See:
  ///  * [$setDisplayName_Request] for the request send by this method.
  ///  * [$setDisplayName_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<GuestSetDisplayNameResponseApplicationJson, void>> setDisplayName({
    required String token,
    required GuestSetDisplayNameRequestApplicationJson $body,
    GuestSetDisplayNameApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setDisplayName_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setDisplayName_Serializer();
    return _i1.ResponseConverter<GuestSetDisplayNameResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $HostedSignalingServerClient {
  /// Creates a new `DynamiteClient` for hosted_signaling_server requests.
  $HostedSignalingServerClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$requestTrial_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<HostedSignalingServerRequestTrialResponseApplicationJson, void> $requestTrial_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(HostedSignalingServerRequestTrialResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Request a trial account.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [requestTrial] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Trial requested successfully
  ///   * 400: Requesting trial is not possible
  ///   * 500
  ///
  /// See:
  ///  * [requestTrial] for a method executing this request and parsing the response.
  ///  * [$requestTrial_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $requestTrial_Request({
    required HostedSignalingServerRequestTrialRequestApplicationJson $body,
    HostedSignalingServerRequestTrialApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(HostedSignalingServerRequestTrialApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/hostedsignalingserver/requesttrial')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(HostedSignalingServerRequestTrialRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Request a trial account.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Trial requested successfully
  ///   * 400: Requesting trial is not possible
  ///   * 500
  ///
  /// See:
  ///  * [$requestTrial_Request] for the request send by this method.
  ///  * [$requestTrial_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<HostedSignalingServerRequestTrialResponseApplicationJson, void>> requestTrial({
    required HostedSignalingServerRequestTrialRequestApplicationJson $body,
    HostedSignalingServerRequestTrialApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $requestTrial_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $requestTrial_Serializer();
    return _i1.ResponseConverter<HostedSignalingServerRequestTrialResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteAccount_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $deleteAccount_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {204},
      );

  /// Delete the account.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteAccount] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 204: Account deleted successfully
  ///   * 400: Deleting account is not possible
  ///   * 500
  ///
  /// See:
  ///  * [deleteAccount] for a method executing this request and parsing the response.
  ///  * [$deleteAccount_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteAccount_Request({
    HostedSignalingServerDeleteAccountApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(HostedSignalingServerDeleteAccountApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/hostedsignalingserver/delete').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete the account.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 204: Account deleted successfully
  ///   * 400: Deleting account is not possible
  ///   * 500
  ///
  /// See:
  ///  * [$deleteAccount_Request] for the request send by this method.
  ///  * [$deleteAccount_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> deleteAccount({
    HostedSignalingServerDeleteAccountApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteAccount_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteAccount_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }
}

class $InternalSignalingClient {
  /// Creates a new `DynamiteClient` for internal_signaling requests.
  $InternalSignalingClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$signalingGetSettings_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SignalingGetSettingsResponseApplicationJson, void> $signalingGetSettings_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(SignalingGetSettingsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the signaling settings.
  ///
  /// Returns a `DynamiteRequest` backing the [signalingGetSettings] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [token] Token of the room. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Signaling settings returned
  ///   * 401: Recording request invalid
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [signalingGetSettings] for a method executing this request and parsing the response.
  ///  * [$signalingGetSettings_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $signalingGetSettings_Request({
    SignalingGetSettingsApiVersion? apiVersion,
    String? token,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SignalingGetSettingsApiVersion));
    __apiVersion ??= 'v3';
    _parameters['apiVersion'] = __apiVersion;

    var __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    __token ??= '';
    _parameters['token'] = __token;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/signaling/settings{?token*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the signaling settings.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [token] Token of the room. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Signaling settings returned
  ///   * 401: Recording request invalid
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [$signalingGetSettings_Request] for the request send by this method.
  ///  * [$signalingGetSettings_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SignalingGetSettingsResponseApplicationJson, void>> signalingGetSettings({
    SignalingGetSettingsApiVersion? apiVersion,
    String? token,
    bool? oCSAPIRequest,
  }) async {
    final _request = $signalingGetSettings_Request(
      apiVersion: apiVersion,
      token: token,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $signalingGetSettings_Serializer();
    return _i1.ResponseConverter<SignalingGetSettingsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$signalingPullMessages_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SignalingPullMessagesResponseApplicationJson, void> $signalingPullMessages_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(SignalingPullMessagesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404, 409},
      );

  /// Get signaling messages.
  ///
  /// Returns a `DynamiteRequest` backing the [signalingPullMessages] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Signaling messages returned
  ///   * 404: Session, room or participant not found
  ///   * 409: Session killed
  ///   * 400: Getting signaling messages is not possible
  ///
  /// See:
  ///  * [signalingPullMessages] for a method executing this request and parsing the response.
  ///  * [$signalingPullMessages_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $signalingPullMessages_Request({
    required String token,
    SignalingPullMessagesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SignalingPullMessagesApiVersion));
    __apiVersion ??= 'v3';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/signaling/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get signaling messages.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Signaling messages returned
  ///   * 404: Session, room or participant not found
  ///   * 409: Session killed
  ///   * 400: Getting signaling messages is not possible
  ///
  /// See:
  ///  * [$signalingPullMessages_Request] for the request send by this method.
  ///  * [$signalingPullMessages_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SignalingPullMessagesResponseApplicationJson, void>> signalingPullMessages({
    required String token,
    SignalingPullMessagesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $signalingPullMessages_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $signalingPullMessages_Serializer();
    return _i1.ResponseConverter<SignalingPullMessagesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$signalingSendMessages_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SignalingSendMessagesResponseApplicationJson, void> $signalingSendMessages_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(SignalingSendMessagesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Send signaling messages.
  ///
  /// Returns a `DynamiteRequest` backing the [signalingSendMessages] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Signaling message sent successfully
  ///   * 400: Sending signaling message is not possible
  ///
  /// See:
  ///  * [signalingSendMessages] for a method executing this request and parsing the response.
  ///  * [$signalingSendMessages_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $signalingSendMessages_Request({
    required String token,
    required SignalingSendMessagesRequestApplicationJson $body,
    SignalingSendMessagesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SignalingSendMessagesApiVersion));
    __apiVersion ??= 'v3';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/signaling/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(SignalingSendMessagesRequestApplicationJson)),
    );
    return _request;
  }

  /// Send signaling messages.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Signaling message sent successfully
  ///   * 400: Sending signaling message is not possible
  ///
  /// See:
  ///  * [$signalingSendMessages_Request] for the request send by this method.
  ///  * [$signalingSendMessages_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SignalingSendMessagesResponseApplicationJson, void>> signalingSendMessages({
    required String token,
    required SignalingSendMessagesRequestApplicationJson $body,
    SignalingSendMessagesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $signalingSendMessages_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $signalingSendMessages_Serializer();
    return _i1.ResponseConverter<SignalingSendMessagesResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $MatterbridgeClient {
  /// Creates a new `DynamiteClient` for matterbridge requests.
  $MatterbridgeClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getBridgeOfRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<MatterbridgeGetBridgeOfRoomResponseApplicationJson, void> $getBridgeOfRoom_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(MatterbridgeGetBridgeOfRoomResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get bridge information of one room.
  ///
  /// Returns a `DynamiteRequest` backing the [getBridgeOfRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Return list of configured bridges
  ///
  /// See:
  ///  * [getBridgeOfRoom] for a method executing this request and parsing the response.
  ///  * [$getBridgeOfRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getBridgeOfRoom_Request({
    required String token,
    MatterbridgeGetBridgeOfRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(MatterbridgeGetBridgeOfRoomApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bridge/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get bridge information of one room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Return list of configured bridges
  ///
  /// See:
  ///  * [$getBridgeOfRoom_Request] for the request send by this method.
  ///  * [$getBridgeOfRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<MatterbridgeGetBridgeOfRoomResponseApplicationJson, void>> getBridgeOfRoom({
    required String token,
    MatterbridgeGetBridgeOfRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getBridgeOfRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getBridgeOfRoom_Serializer();
    return _i1.ResponseConverter<MatterbridgeGetBridgeOfRoomResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$editBridgeOfRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<MatterbridgeEditBridgeOfRoomResponseApplicationJson, void> $editBridgeOfRoom_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(MatterbridgeEditBridgeOfRoomResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Edit bridge information of one room.
  ///
  /// Returns a `DynamiteRequest` backing the [editBridgeOfRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bridge edited successfully
  ///   * 406: Editing bridge is not possible
  ///
  /// See:
  ///  * [editBridgeOfRoom] for a method executing this request and parsing the response.
  ///  * [$editBridgeOfRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $editBridgeOfRoom_Request({
    required String token,
    required MatterbridgeEditBridgeOfRoomRequestApplicationJson $body,
    MatterbridgeEditBridgeOfRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(MatterbridgeEditBridgeOfRoomApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bridge/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(MatterbridgeEditBridgeOfRoomRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Edit bridge information of one room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bridge edited successfully
  ///   * 406: Editing bridge is not possible
  ///
  /// See:
  ///  * [$editBridgeOfRoom_Request] for the request send by this method.
  ///  * [$editBridgeOfRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<MatterbridgeEditBridgeOfRoomResponseApplicationJson, void>> editBridgeOfRoom({
    required String token,
    required MatterbridgeEditBridgeOfRoomRequestApplicationJson $body,
    MatterbridgeEditBridgeOfRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $editBridgeOfRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $editBridgeOfRoom_Serializer();
    return _i1.ResponseConverter<MatterbridgeEditBridgeOfRoomResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteBridgeOfRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<MatterbridgeDeleteBridgeOfRoomResponseApplicationJson, void>
      $deleteBridgeOfRoom_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(MatterbridgeDeleteBridgeOfRoomResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Delete bridge of one room.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteBridgeOfRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bridge deleted successfully
  ///   * 406: Deleting bridge is not possible
  ///
  /// See:
  ///  * [deleteBridgeOfRoom] for a method executing this request and parsing the response.
  ///  * [$deleteBridgeOfRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteBridgeOfRoom_Request({
    required String token,
    MatterbridgeDeleteBridgeOfRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(MatterbridgeDeleteBridgeOfRoomApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bridge/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete bridge of one room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bridge deleted successfully
  ///   * 406: Deleting bridge is not possible
  ///
  /// See:
  ///  * [$deleteBridgeOfRoom_Request] for the request send by this method.
  ///  * [$deleteBridgeOfRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<MatterbridgeDeleteBridgeOfRoomResponseApplicationJson, void>> deleteBridgeOfRoom({
    required String token,
    MatterbridgeDeleteBridgeOfRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteBridgeOfRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteBridgeOfRoom_Serializer();
    return _i1.ResponseConverter<MatterbridgeDeleteBridgeOfRoomResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getBridgeProcessState_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<MatterbridgeGetBridgeProcessStateResponseApplicationJson, void>
      $getBridgeProcessState_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(MatterbridgeGetBridgeProcessStateResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get bridge process information.
  ///
  /// Returns a `DynamiteRequest` backing the [getBridgeProcessState] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Return list of running processes
  ///
  /// See:
  ///  * [getBridgeProcessState] for a method executing this request and parsing the response.
  ///  * [$getBridgeProcessState_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getBridgeProcessState_Request({
    required String token,
    MatterbridgeGetBridgeProcessStateApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(MatterbridgeGetBridgeProcessStateApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bridge/{token}/process').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get bridge process information.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Return list of running processes
  ///
  /// See:
  ///  * [$getBridgeProcessState_Request] for the request send by this method.
  ///  * [$getBridgeProcessState_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<MatterbridgeGetBridgeProcessStateResponseApplicationJson, void>> getBridgeProcessState({
    required String token,
    MatterbridgeGetBridgeProcessStateApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getBridgeProcessState_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getBridgeProcessState_Serializer();
    return _i1.ResponseConverter<MatterbridgeGetBridgeProcessStateResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$matterbridgeSettingsStopAllBridges_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<MatterbridgeSettingsStopAllBridgesResponseApplicationJson, void>
      $matterbridgeSettingsStopAllBridges_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(MatterbridgeSettingsStopAllBridgesResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Stop all bridges.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [matterbridgeSettingsStopAllBridges] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: All bridges stopped successfully
  ///   * 406: Stopping all bridges is not possible
  ///
  /// See:
  ///  * [matterbridgeSettingsStopAllBridges] for a method executing this request and parsing the response.
  ///  * [$matterbridgeSettingsStopAllBridges_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $matterbridgeSettingsStopAllBridges_Request({
    MatterbridgeSettingsStopAllBridgesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(MatterbridgeSettingsStopAllBridgesApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bridge').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Stop all bridges.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: All bridges stopped successfully
  ///   * 406: Stopping all bridges is not possible
  ///
  /// See:
  ///  * [$matterbridgeSettingsStopAllBridges_Request] for the request send by this method.
  ///  * [$matterbridgeSettingsStopAllBridges_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<MatterbridgeSettingsStopAllBridgesResponseApplicationJson, void>>
      matterbridgeSettingsStopAllBridges({
    MatterbridgeSettingsStopAllBridgesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $matterbridgeSettingsStopAllBridges_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $matterbridgeSettingsStopAllBridges_Serializer();
    return _i1.ResponseConverter<MatterbridgeSettingsStopAllBridgesResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$matterbridgeSettingsGetMatterbridgeVersion_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<MatterbridgeSettingsGetMatterbridgeVersionResponseApplicationJson, void>
      $matterbridgeSettingsGetMatterbridgeVersion_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(MatterbridgeSettingsGetMatterbridgeVersionResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get Matterbridge version.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [matterbridgeSettingsGetMatterbridgeVersion] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bridge version returned
  ///   * 400: Getting bridge version is not possible
  ///
  /// See:
  ///  * [matterbridgeSettingsGetMatterbridgeVersion] for a method executing this request and parsing the response.
  ///  * [$matterbridgeSettingsGetMatterbridgeVersion_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $matterbridgeSettingsGetMatterbridgeVersion_Request({
    MatterbridgeSettingsGetMatterbridgeVersionApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(MatterbridgeSettingsGetMatterbridgeVersionApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bridge/version').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get Matterbridge version.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bridge version returned
  ///   * 400: Getting bridge version is not possible
  ///
  /// See:
  ///  * [$matterbridgeSettingsGetMatterbridgeVersion_Request] for the request send by this method.
  ///  * [$matterbridgeSettingsGetMatterbridgeVersion_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<MatterbridgeSettingsGetMatterbridgeVersionResponseApplicationJson, void>>
      matterbridgeSettingsGetMatterbridgeVersion({
    MatterbridgeSettingsGetMatterbridgeVersionApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $matterbridgeSettingsGetMatterbridgeVersion_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $matterbridgeSettingsGetMatterbridgeVersion_Serializer();
    return _i1.ResponseConverter<MatterbridgeSettingsGetMatterbridgeVersionResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $PollClient {
  /// Creates a new `DynamiteClient` for poll requests.
  $PollClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$createPoll_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PollCreatePollResponseApplicationJson, void> $createPoll_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(PollCreatePollResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {201},
      );

  /// Create a poll.
  ///
  /// Returns a `DynamiteRequest` backing the [createPoll] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Poll created successfully
  ///   * 400: Creating poll is not possible
  ///
  /// See:
  ///  * [createPoll] for a method executing this request and parsing the response.
  ///  * [$createPoll_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createPoll_Request({
    required String token,
    required PollCreatePollRequestApplicationJson $body,
    PollCreatePollApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(PollCreatePollApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/poll/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(PollCreatePollRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a poll.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: Poll created successfully
  ///   * 400: Creating poll is not possible
  ///
  /// See:
  ///  * [$createPoll_Request] for the request send by this method.
  ///  * [$createPoll_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PollCreatePollResponseApplicationJson, void>> createPoll({
    required String token,
    required PollCreatePollRequestApplicationJson $body,
    PollCreatePollApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createPoll_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createPoll_Serializer();
    return _i1.ResponseConverter<PollCreatePollResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$showPoll_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PollShowPollResponseApplicationJson, void> $showPoll_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(PollShowPollResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a poll.
  ///
  /// Returns a `DynamiteRequest` backing the [showPoll] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [pollId] ID of the poll.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Poll returned
  ///   * 404: Poll not found
  ///
  /// See:
  ///  * [showPoll] for a method executing this request and parsing the response.
  ///  * [$showPoll_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $showPoll_Request({
    required String token,
    required int pollId,
    PollShowPollApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __pollId = _$jsonSerializers.serialize(pollId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __pollId,
      'pollId',
      minimum: 0,
    );
    _parameters['pollId'] = __pollId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(PollShowPollApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/poll/{token}/{pollId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a poll.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [pollId] ID of the poll.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Poll returned
  ///   * 404: Poll not found
  ///
  /// See:
  ///  * [$showPoll_Request] for the request send by this method.
  ///  * [$showPoll_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PollShowPollResponseApplicationJson, void>> showPoll({
    required String token,
    required int pollId,
    PollShowPollApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $showPoll_Request(
      token: token,
      pollId: pollId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $showPoll_Serializer();
    return _i1.ResponseConverter<PollShowPollResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$votePoll_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PollVotePollResponseApplicationJson, void> $votePoll_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(PollVotePollResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Vote on a poll.
  ///
  /// Returns a `DynamiteRequest` backing the [votePoll] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [pollId] ID of the poll.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Voted successfully
  ///   * 400: Voting is not possible
  ///   * 404: Poll not found
  ///
  /// See:
  ///  * [votePoll] for a method executing this request and parsing the response.
  ///  * [$votePoll_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $votePoll_Request({
    required String token,
    required int pollId,
    PollVotePollApiVersion? apiVersion,
    bool? oCSAPIRequest,
    PollVotePollRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __pollId = _$jsonSerializers.serialize(pollId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __pollId,
      'pollId',
      minimum: 0,
    );
    _parameters['pollId'] = __pollId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(PollVotePollApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/poll/{token}/{pollId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(PollVotePollRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              PollVotePollRequestApplicationJson(),
              specifiedType: const FullType(PollVotePollRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Vote on a poll.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [pollId] ID of the poll.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Voted successfully
  ///   * 400: Voting is not possible
  ///   * 404: Poll not found
  ///
  /// See:
  ///  * [$votePoll_Request] for the request send by this method.
  ///  * [$votePoll_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PollVotePollResponseApplicationJson, void>> votePoll({
    required String token,
    required int pollId,
    PollVotePollApiVersion? apiVersion,
    bool? oCSAPIRequest,
    PollVotePollRequestApplicationJson? $body,
  }) async {
    final _request = $votePoll_Request(
      token: token,
      pollId: pollId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $votePoll_Serializer();
    return _i1.ResponseConverter<PollVotePollResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$closePoll_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PollClosePollResponseApplicationJson, void> $closePoll_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(PollClosePollResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Close a poll.
  ///
  /// Returns a `DynamiteRequest` backing the [closePoll] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [pollId] ID of the poll.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Poll closed successfully
  ///   * 400: Poll already closed
  ///   * 403: Missing permissions to close poll
  ///   * 404: Poll not found
  ///   * 500
  ///
  /// See:
  ///  * [closePoll] for a method executing this request and parsing the response.
  ///  * [$closePoll_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $closePoll_Request({
    required String token,
    required int pollId,
    PollClosePollApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __pollId = _$jsonSerializers.serialize(pollId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __pollId,
      'pollId',
      minimum: 0,
    );
    _parameters['pollId'] = __pollId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(PollClosePollApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/poll/{token}/{pollId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Close a poll.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [pollId] ID of the poll.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Poll closed successfully
  ///   * 400: Poll already closed
  ///   * 403: Missing permissions to close poll
  ///   * 404: Poll not found
  ///   * 500
  ///
  /// See:
  ///  * [$closePoll_Request] for the request send by this method.
  ///  * [$closePoll_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PollClosePollResponseApplicationJson, void>> closePoll({
    required String token,
    required int pollId,
    PollClosePollApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $closePoll_Request(
      token: token,
      pollId: pollId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $closePoll_Serializer();
    return _i1.ResponseConverter<PollClosePollResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $ReactionClient {
  /// Creates a new `DynamiteClient` for reaction requests.
  $ReactionClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getReactions_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReactionGetReactionsResponseApplicationJson, void> $getReactions_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReactionGetReactionsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of reactions for a message.
  ///
  /// Returns a `DynamiteRequest` backing the [getReactions] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [reaction] Emoji to filter.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reactions returned
  ///   * 404: Message or reaction not found
  ///
  /// See:
  ///  * [getReactions] for a method executing this request and parsing the response.
  ///  * [$getReactions_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getReactions_Request({
    required String token,
    required int messageId,
    ReactionGetReactionsApiVersion? apiVersion,
    String? reaction,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ReactionGetReactionsApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final __reaction = _$jsonSerializers.serialize(reaction, specifiedType: const FullType(String));
    _parameters['reaction'] = __reaction;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/reaction/{token}/{messageId}{?reaction*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of reactions for a message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [reaction] Emoji to filter.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reactions returned
  ///   * 404: Message or reaction not found
  ///
  /// See:
  ///  * [$getReactions_Request] for the request send by this method.
  ///  * [$getReactions_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReactionGetReactionsResponseApplicationJson, void>> getReactions({
    required String token,
    required int messageId,
    ReactionGetReactionsApiVersion? apiVersion,
    String? reaction,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getReactions_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      reaction: reaction,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getReactions_Serializer();
    return _i1.ResponseConverter<ReactionGetReactionsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$react_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReactionReactResponseApplicationJson, void> $react_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ReactionReactResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201},
      );

  /// Add a reaction to a message.
  ///
  /// Returns a `DynamiteRequest` backing the [react] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reaction already existed
  ///   * 201: Reaction added successfully
  ///   * 400: Adding reaction is not possible
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [react] for a method executing this request and parsing the response.
  ///  * [$react_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $react_Request({
    required String token,
    required int messageId,
    required ReactionReactRequestApplicationJson $body,
    ReactionReactApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ReactionReactApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/reaction/{token}/{messageId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(ReactionReactRequestApplicationJson)));
    return _request;
  }

  /// Add a reaction to a message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reaction already existed
  ///   * 201: Reaction added successfully
  ///   * 400: Adding reaction is not possible
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [$react_Request] for the request send by this method.
  ///  * [$react_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReactionReactResponseApplicationJson, void>> react({
    required String token,
    required int messageId,
    required ReactionReactRequestApplicationJson $body,
    ReactionReactApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $react_Request(
      token: token,
      messageId: messageId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $react_Serializer();
    return _i1.ResponseConverter<ReactionReactResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$delete_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReactionDeleteResponseApplicationJson, void> $delete_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ReactionDeleteResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a reaction from a message.
  ///
  /// Returns a `DynamiteRequest` backing the [delete] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [reaction] Emoji to remove.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reaction deleted successfully
  ///   * 400: Deleting reaction is not possible
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [delete] for a method executing this request and parsing the response.
  ///  * [$delete_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $delete_Request({
    required String token,
    required int messageId,
    required String reaction,
    ReactionDeleteApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __messageId = _$jsonSerializers.serialize(messageId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __messageId,
      'messageId',
      minimum: 0,
    );
    _parameters['messageId'] = __messageId;

    final __reaction = _$jsonSerializers.serialize(reaction, specifiedType: const FullType(String));
    _parameters['reaction'] = __reaction;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ReactionDeleteApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/reaction/{token}/{messageId}{?reaction*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete a reaction from a message.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [messageId] ID of the message.
  ///   * [reaction] Emoji to remove.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reaction deleted successfully
  ///   * 400: Deleting reaction is not possible
  ///   * 404: Message not found
  ///
  /// See:
  ///  * [$delete_Request] for the request send by this method.
  ///  * [$delete_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReactionDeleteResponseApplicationJson, void>> delete({
    required String token,
    required int messageId,
    required String reaction,
    ReactionDeleteApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $delete_Request(
      token: token,
      messageId: messageId,
      reaction: reaction,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $delete_Serializer();
    return _i1.ResponseConverter<ReactionDeleteResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $RecordingClient {
  /// Creates a new `DynamiteClient` for recording requests.
  $RecordingClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$start_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RecordingStartResponseApplicationJson, void> $start_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(RecordingStartResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Start the recording.
  ///
  /// Returns a `DynamiteRequest` backing the [start] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording started successfully
  ///   * 400: Starting recording is not possible
  ///
  /// See:
  ///  * [start] for a method executing this request and parsing the response.
  ///  * [$start_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $start_Request({
    required String token,
    required RecordingStartRequestApplicationJson $body,
    RecordingStartApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RecordingStartApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/recording/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RecordingStartRequestApplicationJson)),
    );
    return _request;
  }

  /// Start the recording.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording started successfully
  ///   * 400: Starting recording is not possible
  ///
  /// See:
  ///  * [$start_Request] for the request send by this method.
  ///  * [$start_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RecordingStartResponseApplicationJson, void>> start({
    required String token,
    required RecordingStartRequestApplicationJson $body,
    RecordingStartApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $start_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $start_Serializer();
    return _i1.ResponseConverter<RecordingStartResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$stop_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RecordingStopResponseApplicationJson, void> $stop_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(RecordingStopResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Stop the recording.
  ///
  /// Returns a `DynamiteRequest` backing the [stop] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording stopped successfully
  ///   * 400: Stopping recording is not possible
  ///
  /// See:
  ///  * [stop] for a method executing this request and parsing the response.
  ///  * [$stop_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $stop_Request({
    required String token,
    RecordingStopApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RecordingStopApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/recording/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Stop the recording.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording stopped successfully
  ///   * 400: Stopping recording is not possible
  ///
  /// See:
  ///  * [$stop_Request] for the request send by this method.
  ///  * [$stop_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RecordingStopResponseApplicationJson, void>> stop({
    required String token,
    RecordingStopApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $stop_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $stop_Serializer();
    return _i1.ResponseConverter<RecordingStopResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$notificationDismiss_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RecordingNotificationDismissResponseApplicationJson, void> $notificationDismiss_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RecordingNotificationDismissResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Dismiss the store call recording notification.
  ///
  /// Returns a `DynamiteRequest` backing the [notificationDismiss] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [timestamp] Timestamp of the notification to be dismissed.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification dismissed successfully
  ///   * 400: Dismissing notification is not possible
  ///
  /// See:
  ///  * [notificationDismiss] for a method executing this request and parsing the response.
  ///  * [$notificationDismiss_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $notificationDismiss_Request({
    required String token,
    required int timestamp,
    RecordingNotificationDismissApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __timestamp = _$jsonSerializers.serialize(timestamp, specifiedType: const FullType(int));
    _i4.checkNumber(
      __timestamp,
      'timestamp',
      minimum: 0,
    );
    _parameters['timestamp'] = __timestamp;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RecordingNotificationDismissApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/recording/{token}/notification{?timestamp*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Dismiss the store call recording notification.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [timestamp] Timestamp of the notification to be dismissed.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification dismissed successfully
  ///   * 400: Dismissing notification is not possible
  ///
  /// See:
  ///  * [$notificationDismiss_Request] for the request send by this method.
  ///  * [$notificationDismiss_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RecordingNotificationDismissResponseApplicationJson, void>> notificationDismiss({
    required String token,
    required int timestamp,
    RecordingNotificationDismissApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $notificationDismiss_Request(
      token: token,
      timestamp: timestamp,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $notificationDismiss_Serializer();
    return _i1.ResponseConverter<RecordingNotificationDismissResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$shareToChat_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RecordingShareToChatResponseApplicationJson, void> $shareToChat_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RecordingShareToChatResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Share the recorded file to the chat.
  ///
  /// Returns a `DynamiteRequest` backing the [shareToChat] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording shared to chat successfully
  ///   * 400: Sharing recording to chat is not possible
  ///
  /// See:
  ///  * [shareToChat] for a method executing this request and parsing the response.
  ///  * [$shareToChat_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $shareToChat_Request({
    required String token,
    required RecordingShareToChatRequestApplicationJson $body,
    RecordingShareToChatApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RecordingShareToChatApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/recording/{token}/share-chat').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RecordingShareToChatRequestApplicationJson)),
    );
    return _request;
  }

  /// Share the recorded file to the chat.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording shared to chat successfully
  ///   * 400: Sharing recording to chat is not possible
  ///
  /// See:
  ///  * [$shareToChat_Request] for the request send by this method.
  ///  * [$shareToChat_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RecordingShareToChatResponseApplicationJson, void>> shareToChat({
    required String token,
    required RecordingShareToChatRequestApplicationJson $body,
    RecordingShareToChatApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $shareToChat_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $shareToChat_Serializer();
    return _i1.ResponseConverter<RecordingShareToChatResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$backend_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RecordingBackendResponseApplicationJson, void> $backend_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(RecordingBackendResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update the recording status as a backend.
  ///
  /// Returns a `DynamiteRequest` backing the [backend] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording status updated successfully
  ///   * 400: Updating recording status is not possible
  ///   * 403: Missing permissions to update recording status
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [backend] for a method executing this request and parsing the response.
  ///  * [$backend_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $backend_Request({
    RecordingBackendApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RecordingBackendApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/recording/backend').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Update the recording status as a backend.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording status updated successfully
  ///   * 400: Updating recording status is not possible
  ///   * 403: Missing permissions to update recording status
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [$backend_Request] for the request send by this method.
  ///  * [$backend_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RecordingBackendResponseApplicationJson, void>> backend({
    RecordingBackendApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $backend_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $backend_Serializer();
    return _i1.ResponseConverter<RecordingBackendResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$store_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RecordingStoreResponseApplicationJson, void> $store_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(RecordingStoreResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Store the recording.
  ///
  /// Returns a `DynamiteRequest` backing the [store] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording stored successfully
  ///   * 400: Storing recording is not possible
  ///   * 401: Missing permissions to store recording
  ///
  /// See:
  ///  * [store] for a method executing this request and parsing the response.
  ///  * [$store_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $store_Request({
    required String token,
    RecordingStoreApiVersion? apiVersion,
    bool? oCSAPIRequest,
    RecordingStoreRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RecordingStoreApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/recording/{token}/store').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(RecordingStoreRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              RecordingStoreRequestApplicationJson(),
              specifiedType: const FullType(RecordingStoreRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Store the recording.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording stored successfully
  ///   * 400: Storing recording is not possible
  ///   * 401: Missing permissions to store recording
  ///
  /// See:
  ///  * [$store_Request] for the request send by this method.
  ///  * [$store_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RecordingStoreResponseApplicationJson, void>> store({
    required String token,
    RecordingStoreApiVersion? apiVersion,
    bool? oCSAPIRequest,
    RecordingStoreRequestApplicationJson? $body,
  }) async {
    final _request = $store_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $store_Serializer();
    return _i1.ResponseConverter<RecordingStoreResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $RoomClient {
  /// Creates a new `DynamiteClient` for room requests.
  $RoomClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getRooms_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomGetRoomsResponseApplicationJson, RoomRoomGetRoomsHeaders> $getRooms_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomGetRoomsResponseApplicationJson),
        headersType: const FullType(RoomRoomGetRoomsHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all currently existent rooms which the user has joined.
  ///
  /// Returns a `DynamiteRequest` backing the [getRooms] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [noStatusUpdate] When the user status should not be automatically set to online set to 1 (default 0). Defaults to `0`.
  ///   * [includeStatus] Include the user status. Defaults to `0`.
  ///   * [modifiedSince] Filter rooms modified after a timestamp. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Return list of rooms
  ///
  /// See:
  ///  * [getRooms] for a method executing this request and parsing the response.
  ///  * [$getRooms_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getRooms_Request({
    RoomGetRoomsApiVersion? apiVersion,
    RoomGetRoomsNoStatusUpdate? noStatusUpdate,
    RoomGetRoomsIncludeStatus? includeStatus,
    int? modifiedSince,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomGetRoomsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    var __noStatusUpdate =
        _$jsonSerializers.serialize(noStatusUpdate, specifiedType: const FullType(RoomGetRoomsNoStatusUpdate));
    __noStatusUpdate ??= 0;
    _parameters['noStatusUpdate'] = __noStatusUpdate;

    var __includeStatus =
        _$jsonSerializers.serialize(includeStatus, specifiedType: const FullType(RoomGetRoomsIncludeStatus));
    __includeStatus ??= 0;
    _parameters['includeStatus'] = __includeStatus;

    var __modifiedSince = _$jsonSerializers.serialize(modifiedSince, specifiedType: const FullType(int));
    __modifiedSince ??= 0;
    _i4.checkNumber(
      __modifiedSince,
      'modifiedSince',
      minimum: 0,
    );
    _parameters['modifiedSince'] = __modifiedSince;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room{?noStatusUpdate*,includeStatus*,modifiedSince*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get all currently existent rooms which the user has joined.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [noStatusUpdate] When the user status should not be automatically set to online set to 1 (default 0). Defaults to `0`.
  ///   * [includeStatus] Include the user status. Defaults to `0`.
  ///   * [modifiedSince] Filter rooms modified after a timestamp. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Return list of rooms
  ///
  /// See:
  ///  * [$getRooms_Request] for the request send by this method.
  ///  * [$getRooms_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomGetRoomsResponseApplicationJson, RoomRoomGetRoomsHeaders>> getRooms({
    RoomGetRoomsApiVersion? apiVersion,
    RoomGetRoomsNoStatusUpdate? noStatusUpdate,
    RoomGetRoomsIncludeStatus? includeStatus,
    int? modifiedSince,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getRooms_Request(
      apiVersion: apiVersion,
      noStatusUpdate: noStatusUpdate,
      includeStatus: includeStatus,
      modifiedSince: modifiedSince,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getRooms_Serializer();
    return _i1.ResponseConverter<RoomGetRoomsResponseApplicationJson, RoomRoomGetRoomsHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$createRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomCreateRoomResponseApplicationJson, void> $createRoom_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomCreateRoomResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201},
      );

  /// Create a room with a user, a group or a circle.
  ///
  /// Returns a `DynamiteRequest` backing the [createRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room already existed
  ///   * 201: Room created successfully
  ///   * 400: Room type invalid
  ///   * 403: Missing permissions to create room
  ///   * 404: User, group or other target to invite was not found
  ///
  /// See:
  ///  * [createRoom] for a method executing this request and parsing the response.
  ///  * [$createRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createRoom_Request({
    required RoomCreateRoomRequestApplicationJson $body,
    RoomCreateRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomCreateRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomCreateRoomRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a room with a user, a group or a circle.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room already existed
  ///   * 201: Room created successfully
  ///   * 400: Room type invalid
  ///   * 403: Missing permissions to create room
  ///   * 404: User, group or other target to invite was not found
  ///
  /// See:
  ///  * [$createRoom_Request] for the request send by this method.
  ///  * [$createRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomCreateRoomResponseApplicationJson, void>> createRoom({
    required RoomCreateRoomRequestApplicationJson $body,
    RoomCreateRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createRoom_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createRoom_Serializer();
    return _i1.ResponseConverter<RoomCreateRoomResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getListedRooms_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomGetListedRoomsResponseApplicationJson, void> $getListedRooms_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomGetListedRoomsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get listed rooms with optional search term.
  ///
  /// Returns a `DynamiteRequest` backing the [getListedRooms] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [searchTerm] search term. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Return list of matching rooms
  ///
  /// See:
  ///  * [getListedRooms] for a method executing this request and parsing the response.
  ///  * [$getListedRooms_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getListedRooms_Request({
    RoomGetListedRoomsApiVersion? apiVersion,
    String? searchTerm,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomGetListedRoomsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    var __searchTerm = _$jsonSerializers.serialize(searchTerm, specifiedType: const FullType(String));
    __searchTerm ??= '';
    _parameters['searchTerm'] = __searchTerm;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/listed-room{?searchTerm*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get listed rooms with optional search term.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [searchTerm] search term. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Return list of matching rooms
  ///
  /// See:
  ///  * [$getListedRooms_Request] for the request send by this method.
  ///  * [$getListedRooms_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomGetListedRoomsResponseApplicationJson, void>> getListedRooms({
    RoomGetListedRoomsApiVersion? apiVersion,
    String? searchTerm,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getListedRooms_Request(
      apiVersion: apiVersion,
      searchTerm: searchTerm,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getListedRooms_Serializer();
    return _i1.ResponseConverter<RoomGetListedRoomsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getNoteToSelfConversation_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomGetNoteToSelfConversationResponseApplicationJson, RoomRoomGetNoteToSelfConversationHeaders>
      $getNoteToSelfConversation_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomGetNoteToSelfConversationResponseApplicationJson),
            headersType: const FullType(RoomRoomGetNoteToSelfConversationHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the "Note to self" conversation for the user.
  ///
  /// It will be automatically created when it is currently missing.
  ///
  /// Returns a `DynamiteRequest` backing the [getNoteToSelfConversation] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room returned successfully
  ///
  /// See:
  ///  * [getNoteToSelfConversation] for a method executing this request and parsing the response.
  ///  * [$getNoteToSelfConversation_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getNoteToSelfConversation_Request({
    RoomGetNoteToSelfConversationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomGetNoteToSelfConversationApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/note-to-self').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the "Note to self" conversation for the user.
  ///
  /// It will be automatically created when it is currently missing.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room returned successfully
  ///
  /// See:
  ///  * [$getNoteToSelfConversation_Request] for the request send by this method.
  ///  * [$getNoteToSelfConversation_Serializer] for a converter to parse the `Response` from an executed request.
  Future<
      _i1.DynamiteResponse<RoomGetNoteToSelfConversationResponseApplicationJson,
          RoomRoomGetNoteToSelfConversationHeaders>> getNoteToSelfConversation({
    RoomGetNoteToSelfConversationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getNoteToSelfConversation_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getNoteToSelfConversation_Serializer();
    return _i1.ResponseConverter<RoomGetNoteToSelfConversationResponseApplicationJson,
            RoomRoomGetNoteToSelfConversationHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getSingleRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomGetSingleRoomResponseApplicationJson, RoomRoomGetSingleRoomHeaders>
      $getSingleRoom_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomGetSingleRoomResponseApplicationJson),
            headersType: const FullType(RoomRoomGetSingleRoomHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get a room.
  ///
  /// Returns a `DynamiteRequest` backing the [getSingleRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room returned
  ///   * 401: SIP request invalid
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [getSingleRoom] for a method executing this request and parsing the response.
  ///  * [$getSingleRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getSingleRoom_Request({
    required String token,
    RoomGetSingleRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomGetSingleRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room returned
  ///   * 401: SIP request invalid
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [$getSingleRoom_Request] for the request send by this method.
  ///  * [$getSingleRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomGetSingleRoomResponseApplicationJson, RoomRoomGetSingleRoomHeaders>> getSingleRoom({
    required String token,
    RoomGetSingleRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getSingleRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getSingleRoom_Serializer();
    return _i1.ResponseConverter<RoomGetSingleRoomResponseApplicationJson, RoomRoomGetSingleRoomHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getBreakoutRooms_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomGetBreakoutRoomsResponseApplicationJson, void> $getBreakoutRooms_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomGetBreakoutRoomsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get breakout rooms.
  ///
  /// All for moderators and in case of "free selection", or the assigned breakout room for other participants.
  ///
  /// Returns a `DynamiteRequest` backing the [getBreakoutRooms] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms returned
  ///   * 400: Getting breakout rooms is not possible
  ///
  /// See:
  ///  * [getBreakoutRooms] for a method executing this request and parsing the response.
  ///  * [$getBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getBreakoutRooms_Request({
    required String token,
    RoomGetBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomGetBreakoutRoomsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/breakout-rooms').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get breakout rooms.
  ///
  /// All for moderators and in case of "free selection", or the assigned breakout room for other participants.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout rooms returned
  ///   * 400: Getting breakout rooms is not possible
  ///
  /// See:
  ///  * [$getBreakoutRooms_Request] for the request send by this method.
  ///  * [$getBreakoutRooms_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomGetBreakoutRoomsResponseApplicationJson, void>> getBreakoutRooms({
    required String token,
    RoomGetBreakoutRoomsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getBreakoutRooms_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getBreakoutRooms_Serializer();
    return _i1.ResponseConverter<RoomGetBreakoutRoomsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$makePublic_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomMakePublicResponseApplicationJson, void> $makePublic_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomMakePublicResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Allowed guests to join conversation.
  ///
  /// Returns a `DynamiteRequest` backing the [makePublic] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Allowed guests successfully
  ///   * 400: Allowing guests is not possible
  ///
  /// See:
  ///  * [makePublic] for a method executing this request and parsing the response.
  ///  * [$makePublic_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $makePublic_Request({
    required String token,
    RoomMakePublicApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomMakePublicApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/public').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Allowed guests to join conversation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Allowed guests successfully
  ///   * 400: Allowing guests is not possible
  ///
  /// See:
  ///  * [$makePublic_Request] for the request send by this method.
  ///  * [$makePublic_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomMakePublicResponseApplicationJson, void>> makePublic({
    required String token,
    RoomMakePublicApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $makePublic_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $makePublic_Serializer();
    return _i1.ResponseConverter<RoomMakePublicResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$makePrivate_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomMakePrivateResponseApplicationJson, void> $makePrivate_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomMakePrivateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Disallowed guests to join conversation.
  ///
  /// Returns a `DynamiteRequest` backing the [makePrivate] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room unpublished Disallowing guests successfully
  ///   * 400: Disallowing guests is not possible
  ///
  /// See:
  ///  * [makePrivate] for a method executing this request and parsing the response.
  ///  * [$makePrivate_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $makePrivate_Request({
    required String token,
    RoomMakePrivateApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomMakePrivateApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/public').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Disallowed guests to join conversation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room unpublished Disallowing guests successfully
  ///   * 400: Disallowing guests is not possible
  ///
  /// See:
  ///  * [$makePrivate_Request] for the request send by this method.
  ///  * [$makePrivate_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomMakePrivateResponseApplicationJson, void>> makePrivate({
    required String token,
    RoomMakePrivateApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $makePrivate_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $makePrivate_Serializer();
    return _i1.ResponseConverter<RoomMakePrivateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setDescription_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetDescriptionResponseApplicationJson, void> $setDescription_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetDescriptionResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update the description of a room.
  ///
  /// Returns a `DynamiteRequest` backing the [setDescription] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Description updated successfully
  ///   * 400: Updating description is not possible
  ///
  /// See:
  ///  * [setDescription] for a method executing this request and parsing the response.
  ///  * [$setDescription_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setDescription_Request({
    required String token,
    required RoomSetDescriptionRequestApplicationJson $body,
    RoomSetDescriptionApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetDescriptionApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/description').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomSetDescriptionRequestApplicationJson)),
    );
    return _request;
  }

  /// Update the description of a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Description updated successfully
  ///   * 400: Updating description is not possible
  ///
  /// See:
  ///  * [$setDescription_Request] for the request send by this method.
  ///  * [$setDescription_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetDescriptionResponseApplicationJson, void>> setDescription({
    required String token,
    required RoomSetDescriptionRequestApplicationJson $body,
    RoomSetDescriptionApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setDescription_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setDescription_Serializer();
    return _i1.ResponseConverter<RoomSetDescriptionResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setReadOnly_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetReadOnlyResponseApplicationJson, void> $setReadOnly_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetReadOnlyResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set read-only state of a room.
  ///
  /// Returns a `DynamiteRequest` backing the [setReadOnly] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Read-only state updated successfully
  ///   * 400: Updating read-only state is not possible
  ///
  /// See:
  ///  * [setReadOnly] for a method executing this request and parsing the response.
  ///  * [$setReadOnly_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setReadOnly_Request({
    required String token,
    required RoomSetReadOnlyRequestApplicationJson $body,
    RoomSetReadOnlyApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetReadOnlyApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/read-only').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomSetReadOnlyRequestApplicationJson)),
    );
    return _request;
  }

  /// Set read-only state of a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Read-only state updated successfully
  ///   * 400: Updating read-only state is not possible
  ///
  /// See:
  ///  * [$setReadOnly_Request] for the request send by this method.
  ///  * [$setReadOnly_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetReadOnlyResponseApplicationJson, void>> setReadOnly({
    required String token,
    required RoomSetReadOnlyRequestApplicationJson $body,
    RoomSetReadOnlyApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setReadOnly_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setReadOnly_Serializer();
    return _i1.ResponseConverter<RoomSetReadOnlyResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setListable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetListableResponseApplicationJson, void> $setListable_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetListableResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Make a room listable.
  ///
  /// Returns a `DynamiteRequest` backing the [setListable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Made room listable successfully
  ///   * 400: Making room listable is not possible
  ///
  /// See:
  ///  * [setListable] for a method executing this request and parsing the response.
  ///  * [$setListable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setListable_Request({
    required String token,
    required RoomSetListableRequestApplicationJson $body,
    RoomSetListableApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetListableApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/listable').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomSetListableRequestApplicationJson)),
    );
    return _request;
  }

  /// Make a room listable.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Made room listable successfully
  ///   * 400: Making room listable is not possible
  ///
  /// See:
  ///  * [$setListable_Request] for the request send by this method.
  ///  * [$setListable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetListableResponseApplicationJson, void>> setListable({
    required String token,
    required RoomSetListableRequestApplicationJson $body,
    RoomSetListableApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setListable_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setListable_Serializer();
    return _i1.ResponseConverter<RoomSetListableResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setPassword_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetPasswordResponseApplicationJson, void> $setPassword_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetPasswordResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set a password for a room.
  ///
  /// Returns a `DynamiteRequest` backing the [setPassword] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Password set successfully
  ///   * 400: Setting password is not possible
  ///
  /// See:
  ///  * [setPassword] for a method executing this request and parsing the response.
  ///  * [$setPassword_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setPassword_Request({
    required String token,
    required RoomSetPasswordRequestApplicationJson $body,
    RoomSetPasswordApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetPasswordApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/password').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomSetPasswordRequestApplicationJson)),
    );
    return _request;
  }

  /// Set a password for a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Password set successfully
  ///   * 400: Setting password is not possible
  ///
  /// See:
  ///  * [$setPassword_Request] for the request send by this method.
  ///  * [$setPassword_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetPasswordResponseApplicationJson, void>> setPassword({
    required String token,
    required RoomSetPasswordRequestApplicationJson $body,
    RoomSetPasswordApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setPassword_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setPassword_Serializer();
    return _i1.ResponseConverter<RoomSetPasswordResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setPermissions_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetPermissionsResponseApplicationJson, void> $setPermissions_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetPermissionsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update the permissions of a room.
  ///
  /// Returns a `DynamiteRequest` backing the [setPermissions] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [mode] Level of the permissions ('call' (removed in Talk 20), 'default').
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Permissions updated successfully
  ///   * 400: Updating permissions is not possible
  ///
  /// See:
  ///  * [setPermissions] for a method executing this request and parsing the response.
  ///  * [$setPermissions_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setPermissions_Request({
    required String token,
    required RoomSetPermissionsMode mode,
    required RoomSetPermissionsRequestApplicationJson $body,
    RoomSetPermissionsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __mode = _$jsonSerializers.serialize(mode, specifiedType: const FullType(RoomSetPermissionsMode));
    _i4.checkString(
      __mode,
      'mode',
      pattern: RegExp(r'^(call|default)$'),
    );
    _parameters['mode'] = __mode;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetPermissionsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/permissions/{mode}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomSetPermissionsRequestApplicationJson)),
    );
    return _request;
  }

  /// Update the permissions of a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [mode] Level of the permissions ('call' (removed in Talk 20), 'default').
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Permissions updated successfully
  ///   * 400: Updating permissions is not possible
  ///
  /// See:
  ///  * [$setPermissions_Request] for the request send by this method.
  ///  * [$setPermissions_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetPermissionsResponseApplicationJson, void>> setPermissions({
    required String token,
    required RoomSetPermissionsMode mode,
    required RoomSetPermissionsRequestApplicationJson $body,
    RoomSetPermissionsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setPermissions_Request(
      token: token,
      mode: mode,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setPermissions_Serializer();
    return _i1.ResponseConverter<RoomSetPermissionsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getParticipants_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomGetParticipantsResponseApplicationJson, RoomRoomGetParticipantsHeaders>
      $getParticipants_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomGetParticipantsResponseApplicationJson),
            headersType: const FullType(RoomRoomGetParticipantsHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get a list of participants for a room.
  ///
  /// Returns a `DynamiteRequest` backing the [getParticipants] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [includeStatus] Include the user statuses. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participants returned
  ///   * 403: Missing permissions for getting participants
  ///
  /// See:
  ///  * [getParticipants] for a method executing this request and parsing the response.
  ///  * [$getParticipants_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getParticipants_Request({
    required String token,
    RoomGetParticipantsApiVersion? apiVersion,
    RoomGetParticipantsIncludeStatus? includeStatus,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomGetParticipantsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    var __includeStatus =
        _$jsonSerializers.serialize(includeStatus, specifiedType: const FullType(RoomGetParticipantsIncludeStatus));
    __includeStatus ??= 0;
    _parameters['includeStatus'] = __includeStatus;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/participants{?includeStatus*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of participants for a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [includeStatus] Include the user statuses. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participants returned
  ///   * 403: Missing permissions for getting participants
  ///
  /// See:
  ///  * [$getParticipants_Request] for the request send by this method.
  ///  * [$getParticipants_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomGetParticipantsResponseApplicationJson, RoomRoomGetParticipantsHeaders>>
      getParticipants({
    required String token,
    RoomGetParticipantsApiVersion? apiVersion,
    RoomGetParticipantsIncludeStatus? includeStatus,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getParticipants_Request(
      token: token,
      apiVersion: apiVersion,
      includeStatus: includeStatus,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getParticipants_Serializer();
    return _i1.ResponseConverter<RoomGetParticipantsResponseApplicationJson, RoomRoomGetParticipantsHeaders>(
      _serializer,
    ).convert(_response);
  }

  /// Builds a serializer to parse the response of [$addParticipantToRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomAddParticipantToRoomResponseApplicationJson, void> $addParticipantToRoom_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomAddParticipantToRoomResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Add a participant to a room.
  ///
  /// Returns a `DynamiteRequest` backing the [addParticipantToRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant successfully added
  ///   * 404: User, group or other target to invite was not found
  ///   * 501: SIP dial-out is not configured
  ///   * 400: Adding participant is not possible, e.g. when the user is banned (check error attribute of response for detail key)
  ///
  /// See:
  ///  * [addParticipantToRoom] for a method executing this request and parsing the response.
  ///  * [$addParticipantToRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $addParticipantToRoom_Request({
    required String token,
    required RoomAddParticipantToRoomRequestApplicationJson $body,
    RoomAddParticipantToRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomAddParticipantToRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/participants').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomAddParticipantToRoomRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Add a participant to a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant successfully added
  ///   * 404: User, group or other target to invite was not found
  ///   * 501: SIP dial-out is not configured
  ///   * 400: Adding participant is not possible, e.g. when the user is banned (check error attribute of response for detail key)
  ///
  /// See:
  ///  * [$addParticipantToRoom_Request] for the request send by this method.
  ///  * [$addParticipantToRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomAddParticipantToRoomResponseApplicationJson, void>> addParticipantToRoom({
    required String token,
    required RoomAddParticipantToRoomRequestApplicationJson $body,
    RoomAddParticipantToRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $addParticipantToRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $addParticipantToRoom_Serializer();
    return _i1.ResponseConverter<RoomAddParticipantToRoomResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getBreakoutRoomParticipants_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<
          RoomGetBreakoutRoomParticipantsResponseApplicationJson, RoomRoomGetBreakoutRoomParticipantsHeaders>
      $getBreakoutRoomParticipants_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomGetBreakoutRoomParticipantsResponseApplicationJson),
            headersType: const FullType(RoomRoomGetBreakoutRoomParticipantsHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the breakout room participants for a room.
  ///
  /// Returns a `DynamiteRequest` backing the [getBreakoutRoomParticipants] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [includeStatus] Include the user statuses. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout room participants returned
  ///   * 400: Getting breakout room participants is not possible
  ///   * 403: Missing permissions to get breakout room participants
  ///
  /// See:
  ///  * [getBreakoutRoomParticipants] for a method executing this request and parsing the response.
  ///  * [$getBreakoutRoomParticipants_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getBreakoutRoomParticipants_Request({
    required String token,
    RoomGetBreakoutRoomParticipantsApiVersion? apiVersion,
    RoomGetBreakoutRoomParticipantsIncludeStatus? includeStatus,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(RoomGetBreakoutRoomParticipantsApiVersion),
    );
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    var __includeStatus = _$jsonSerializers.serialize(
      includeStatus,
      specifiedType: const FullType(RoomGetBreakoutRoomParticipantsIncludeStatus),
    );
    __includeStatus ??= 0;
    _parameters['includeStatus'] = __includeStatus;

    final _path = _i5.UriTemplate(
      '/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/breakout-rooms/participants{?includeStatus*}',
    ).expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the breakout room participants for a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [includeStatus] Include the user statuses. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Breakout room participants returned
  ///   * 400: Getting breakout room participants is not possible
  ///   * 403: Missing permissions to get breakout room participants
  ///
  /// See:
  ///  * [$getBreakoutRoomParticipants_Request] for the request send by this method.
  ///  * [$getBreakoutRoomParticipants_Serializer] for a converter to parse the `Response` from an executed request.
  Future<
      _i1.DynamiteResponse<RoomGetBreakoutRoomParticipantsResponseApplicationJson,
          RoomRoomGetBreakoutRoomParticipantsHeaders>> getBreakoutRoomParticipants({
    required String token,
    RoomGetBreakoutRoomParticipantsApiVersion? apiVersion,
    RoomGetBreakoutRoomParticipantsIncludeStatus? includeStatus,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getBreakoutRoomParticipants_Request(
      token: token,
      apiVersion: apiVersion,
      includeStatus: includeStatus,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getBreakoutRoomParticipants_Serializer();
    return _i1.ResponseConverter<RoomGetBreakoutRoomParticipantsResponseApplicationJson,
            RoomRoomGetBreakoutRoomParticipantsHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$removeSelfFromRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomRemoveSelfFromRoomResponseApplicationJson, void> $removeSelfFromRoom_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomRemoveSelfFromRoomResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400, 404},
      );

  /// Remove the current user from a room.
  ///
  /// Returns a `DynamiteRequest` backing the [removeSelfFromRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant removed successfully
  ///   * 400: Removing participant is not possible
  ///   * 404: Participant not found
  ///
  /// See:
  ///  * [removeSelfFromRoom] for a method executing this request and parsing the response.
  ///  * [$removeSelfFromRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $removeSelfFromRoom_Request({
    required String token,
    RoomRemoveSelfFromRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomRemoveSelfFromRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/participants/self').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove the current user from a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant removed successfully
  ///   * 400: Removing participant is not possible
  ///   * 404: Participant not found
  ///
  /// See:
  ///  * [$removeSelfFromRoom_Request] for the request send by this method.
  ///  * [$removeSelfFromRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomRemoveSelfFromRoomResponseApplicationJson, void>> removeSelfFromRoom({
    required String token,
    RoomRemoveSelfFromRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $removeSelfFromRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $removeSelfFromRoom_Serializer();
    return _i1.ResponseConverter<RoomRemoveSelfFromRoomResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$removeAttendeeFromRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomRemoveAttendeeFromRoomResponseApplicationJson, void>
      $removeAttendeeFromRoom_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomRemoveAttendeeFromRoomResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200, 400, 403, 404},
          );

  /// Remove an attendee from a room.
  ///
  /// Returns a `DynamiteRequest` backing the [removeAttendeeFromRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [attendeeId] ID of the attendee.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee removed successfully
  ///   * 400: Removing attendee is not possible
  ///   * 403: Removing attendee is not allowed
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [removeAttendeeFromRoom] for a method executing this request and parsing the response.
  ///  * [$removeAttendeeFromRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $removeAttendeeFromRoom_Request({
    required String token,
    required int attendeeId,
    RoomRemoveAttendeeFromRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __attendeeId = _$jsonSerializers.serialize(attendeeId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __attendeeId,
      'attendeeId',
      minimum: 0,
    );
    _parameters['attendeeId'] = __attendeeId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomRemoveAttendeeFromRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/attendees{?attendeeId*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove an attendee from a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [attendeeId] ID of the attendee.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee removed successfully
  ///   * 400: Removing attendee is not possible
  ///   * 403: Removing attendee is not allowed
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [$removeAttendeeFromRoom_Request] for the request send by this method.
  ///  * [$removeAttendeeFromRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomRemoveAttendeeFromRoomResponseApplicationJson, void>> removeAttendeeFromRoom({
    required String token,
    required int attendeeId,
    RoomRemoveAttendeeFromRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $removeAttendeeFromRoom_Request(
      token: token,
      attendeeId: attendeeId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $removeAttendeeFromRoom_Serializer();
    return _i1.ResponseConverter<RoomRemoveAttendeeFromRoomResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setAttendeePermissions_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetAttendeePermissionsResponseApplicationJson, void>
      $setAttendeePermissions_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomSetAttendeePermissionsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200, 400, 403, 404},
          );

  /// Update the permissions of an attendee.
  ///
  /// Returns a `DynamiteRequest` backing the [setAttendeePermissions] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Permissions updated successfully
  ///   * 400: Updating permissions is not possible
  ///   * 403: Missing permissions to update permissions
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [setAttendeePermissions] for a method executing this request and parsing the response.
  ///  * [$setAttendeePermissions_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setAttendeePermissions_Request({
    required String token,
    required RoomSetAttendeePermissionsRequestApplicationJson $body,
    RoomSetAttendeePermissionsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetAttendeePermissionsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/attendees/permissions')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomSetAttendeePermissionsRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update the permissions of an attendee.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Permissions updated successfully
  ///   * 400: Updating permissions is not possible
  ///   * 403: Missing permissions to update permissions
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [$setAttendeePermissions_Request] for the request send by this method.
  ///  * [$setAttendeePermissions_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetAttendeePermissionsResponseApplicationJson, void>> setAttendeePermissions({
    required String token,
    required RoomSetAttendeePermissionsRequestApplicationJson $body,
    RoomSetAttendeePermissionsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setAttendeePermissions_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setAttendeePermissions_Serializer();
    return _i1.ResponseConverter<RoomSetAttendeePermissionsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setAllAttendeesPermissions_Request].
  @_i2.experimental
  @Deprecated('')
  _i1.DynamiteSerializer<RoomSetAllAttendeesPermissionsResponseApplicationJson, void>
      $setAllAttendeesPermissions_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomSetAllAttendeesPermissionsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Update the permissions of all attendees.
  ///
  /// Returns a `DynamiteRequest` backing the [setAllAttendeesPermissions] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Permissions updated successfully
  ///   * 400: Updating permissions is not possible
  ///
  /// See:
  ///  * [setAllAttendeesPermissions] for a method executing this request and parsing the response.
  ///  * [$setAllAttendeesPermissions_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  @Deprecated('')
  _i3.Request $setAllAttendeesPermissions_Request({
    required String token,
    required RoomSetAllAttendeesPermissionsRequestApplicationJson $body,
    RoomSetAllAttendeesPermissionsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(RoomSetAllAttendeesPermissionsApiVersion),
    );
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/attendees/permissions/all')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomSetAllAttendeesPermissionsRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update the permissions of all attendees.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Permissions updated successfully
  ///   * 400: Updating permissions is not possible
  ///
  /// See:
  ///  * [$setAllAttendeesPermissions_Request] for the request send by this method.
  ///  * [$setAllAttendeesPermissions_Serializer] for a converter to parse the `Response` from an executed request.
  @Deprecated('')
  Future<_i1.DynamiteResponse<RoomSetAllAttendeesPermissionsResponseApplicationJson, void>> setAllAttendeesPermissions({
    required String token,
    required RoomSetAllAttendeesPermissionsRequestApplicationJson $body,
    RoomSetAllAttendeesPermissionsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setAllAttendeesPermissions_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setAllAttendeesPermissions_Serializer();
    return _i1.ResponseConverter<RoomSetAllAttendeesPermissionsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$joinRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomJoinRoomResponseApplicationJson, RoomRoomJoinRoomHeaders> $joinRoom_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomJoinRoomResponseApplicationJson),
        headersType: const FullType(RoomRoomJoinRoomHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Join a room.
  ///
  /// Returns a `DynamiteRequest` backing the [joinRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room joined successfully
  ///   * 403: Joining room is not allowed
  ///   * 404: Room not found
  ///   * 409: Session already exists
  ///
  /// See:
  ///  * [joinRoom] for a method executing this request and parsing the response.
  ///  * [$joinRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $joinRoom_Request({
    required String token,
    RoomJoinRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
    RoomJoinRoomRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomJoinRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/participants/active')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomJoinRoomRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              RoomJoinRoomRequestApplicationJson(),
              specifiedType: const FullType(RoomJoinRoomRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Join a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Room joined successfully
  ///   * 403: Joining room is not allowed
  ///   * 404: Room not found
  ///   * 409: Session already exists
  ///
  /// See:
  ///  * [$joinRoom_Request] for the request send by this method.
  ///  * [$joinRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomJoinRoomResponseApplicationJson, RoomRoomJoinRoomHeaders>> joinRoom({
    required String token,
    RoomJoinRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
    RoomJoinRoomRequestApplicationJson? $body,
  }) async {
    final _request = $joinRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $joinRoom_Serializer();
    return _i1.ResponseConverter<RoomJoinRoomResponseApplicationJson, RoomRoomJoinRoomHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$leaveRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomLeaveRoomResponseApplicationJson, void> $leaveRoom_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(RoomLeaveRoomResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Leave a room.
  ///
  /// Returns a `DynamiteRequest` backing the [leaveRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully left the room
  ///
  /// See:
  ///  * [leaveRoom] for a method executing this request and parsing the response.
  ///  * [$leaveRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $leaveRoom_Request({
    required String token,
    RoomLeaveRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomLeaveRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/participants/active')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Leave a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully left the room
  ///
  /// See:
  ///  * [$leaveRoom_Request] for the request send by this method.
  ///  * [$leaveRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomLeaveRoomResponseApplicationJson, void>> leaveRoom({
    required String token,
    RoomLeaveRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $leaveRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $leaveRoom_Serializer();
    return _i1.ResponseConverter<RoomLeaveRoomResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$resendInvitations_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomResendInvitationsResponseApplicationJson, void> $resendInvitations_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomResendInvitationsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Resend invitations.
  ///
  /// Returns a `DynamiteRequest` backing the [resendInvitations] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Invitation resent successfully
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [resendInvitations] for a method executing this request and parsing the response.
  ///  * [$resendInvitations_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $resendInvitations_Request({
    required String token,
    RoomResendInvitationsApiVersion? apiVersion,
    bool? oCSAPIRequest,
    RoomResendInvitationsRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomResendInvitationsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/participants/resend-invitations')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(RoomResendInvitationsRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              RoomResendInvitationsRequestApplicationJson(),
              specifiedType: const FullType(RoomResendInvitationsRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Resend invitations.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Invitation resent successfully
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [$resendInvitations_Request] for the request send by this method.
  ///  * [$resendInvitations_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomResendInvitationsResponseApplicationJson, void>> resendInvitations({
    required String token,
    RoomResendInvitationsApiVersion? apiVersion,
    bool? oCSAPIRequest,
    RoomResendInvitationsRequestApplicationJson? $body,
  }) async {
    final _request = $resendInvitations_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $resendInvitations_Serializer();
    return _i1.ResponseConverter<RoomResendInvitationsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setSessionState_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetSessionStateResponseApplicationJson, void> $setSessionState_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetSessionStateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set active state for a session.
  ///
  /// Returns a `DynamiteRequest` backing the [setSessionState] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Session state set successfully
  ///   * 400: The provided new state was invalid
  ///   * 404: The participant did not have a session
  ///
  /// See:
  ///  * [setSessionState] for a method executing this request and parsing the response.
  ///  * [$setSessionState_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setSessionState_Request({
    required String token,
    required RoomSetSessionStateRequestApplicationJson $body,
    RoomSetSessionStateApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetSessionStateApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/participants/state').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomSetSessionStateRequestApplicationJson)),
    );
    return _request;
  }

  /// Set active state for a session.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Session state set successfully
  ///   * 400: The provided new state was invalid
  ///   * 404: The participant did not have a session
  ///
  /// See:
  ///  * [$setSessionState_Request] for the request send by this method.
  ///  * [$setSessionState_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetSessionStateResponseApplicationJson, void>> setSessionState({
    required String token,
    required RoomSetSessionStateRequestApplicationJson $body,
    RoomSetSessionStateApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setSessionState_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setSessionState_Serializer();
    return _i1.ResponseConverter<RoomSetSessionStateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$promoteModerator_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomPromoteModeratorResponseApplicationJson, void> $promoteModerator_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomPromoteModeratorResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400, 403, 404},
      );

  /// Promote an attendee to moderator.
  ///
  /// Returns a `DynamiteRequest` backing the [promoteModerator] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee promoted to moderator successfully
  ///   * 400: Promoting attendee to moderator is not possible
  ///   * 403: Promoting attendee to moderator is not allowed
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [promoteModerator] for a method executing this request and parsing the response.
  ///  * [$promoteModerator_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $promoteModerator_Request({
    required String token,
    required RoomPromoteModeratorRequestApplicationJson $body,
    RoomPromoteModeratorApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomPromoteModeratorApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/moderators').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomPromoteModeratorRequestApplicationJson)),
    );
    return _request;
  }

  /// Promote an attendee to moderator.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee promoted to moderator successfully
  ///   * 400: Promoting attendee to moderator is not possible
  ///   * 403: Promoting attendee to moderator is not allowed
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [$promoteModerator_Request] for the request send by this method.
  ///  * [$promoteModerator_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomPromoteModeratorResponseApplicationJson, void>> promoteModerator({
    required String token,
    required RoomPromoteModeratorRequestApplicationJson $body,
    RoomPromoteModeratorApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $promoteModerator_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $promoteModerator_Serializer();
    return _i1.ResponseConverter<RoomPromoteModeratorResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$demoteModerator_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomDemoteModeratorResponseApplicationJson, void> $demoteModerator_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomDemoteModeratorResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400, 403, 404},
      );

  /// Demote an attendee from moderator.
  ///
  /// Returns a `DynamiteRequest` backing the [demoteModerator] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [attendeeId] ID of the attendee.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee demoted from moderator successfully
  ///   * 400: Demoting attendee from moderator is not possible
  ///   * 403: Demoting attendee from moderator is not allowed
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [demoteModerator] for a method executing this request and parsing the response.
  ///  * [$demoteModerator_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $demoteModerator_Request({
    required String token,
    required int attendeeId,
    RoomDemoteModeratorApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __attendeeId = _$jsonSerializers.serialize(attendeeId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __attendeeId,
      'attendeeId',
      minimum: 0,
    );
    _parameters['attendeeId'] = __attendeeId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomDemoteModeratorApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/moderators{?attendeeId*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Demote an attendee from moderator.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [attendeeId] ID of the attendee.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Attendee demoted from moderator successfully
  ///   * 400: Demoting attendee from moderator is not possible
  ///   * 403: Demoting attendee from moderator is not allowed
  ///   * 404: Attendee not found
  ///
  /// See:
  ///  * [$demoteModerator_Request] for the request send by this method.
  ///  * [$demoteModerator_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomDemoteModeratorResponseApplicationJson, void>> demoteModerator({
    required String token,
    required int attendeeId,
    RoomDemoteModeratorApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $demoteModerator_Request(
      token: token,
      attendeeId: attendeeId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $demoteModerator_Serializer();
    return _i1.ResponseConverter<RoomDemoteModeratorResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$addToFavorites_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomAddToFavoritesResponseApplicationJson, void> $addToFavorites_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomAddToFavoritesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Add a room to the favorites.
  ///
  /// Returns a `DynamiteRequest` backing the [addToFavorites] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully added room to favorites
  ///
  /// See:
  ///  * [addToFavorites] for a method executing this request and parsing the response.
  ///  * [$addToFavorites_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $addToFavorites_Request({
    required String token,
    RoomAddToFavoritesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomAddToFavoritesApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/favorite').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Add a room to the favorites.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully added room to favorites
  ///
  /// See:
  ///  * [$addToFavorites_Request] for the request send by this method.
  ///  * [$addToFavorites_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomAddToFavoritesResponseApplicationJson, void>> addToFavorites({
    required String token,
    RoomAddToFavoritesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $addToFavorites_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $addToFavorites_Serializer();
    return _i1.ResponseConverter<RoomAddToFavoritesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$removeFromFavorites_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomRemoveFromFavoritesResponseApplicationJson, void> $removeFromFavorites_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomRemoveFromFavoritesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Remove a room from the favorites.
  ///
  /// Returns a `DynamiteRequest` backing the [removeFromFavorites] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully removed room from favorites
  ///
  /// See:
  ///  * [removeFromFavorites] for a method executing this request and parsing the response.
  ///  * [$removeFromFavorites_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $removeFromFavorites_Request({
    required String token,
    RoomRemoveFromFavoritesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomRemoveFromFavoritesApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/favorite').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove a room from the favorites.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully removed room from favorites
  ///
  /// See:
  ///  * [$removeFromFavorites_Request] for the request send by this method.
  ///  * [$removeFromFavorites_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomRemoveFromFavoritesResponseApplicationJson, void>> removeFromFavorites({
    required String token,
    RoomRemoveFromFavoritesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $removeFromFavorites_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $removeFromFavorites_Serializer();
    return _i1.ResponseConverter<RoomRemoveFromFavoritesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setNotificationLevel_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetNotificationLevelResponseApplicationJson, void> $setNotificationLevel_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetNotificationLevelResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Update the notification level for a room.
  ///
  /// Returns a `DynamiteRequest` backing the [setNotificationLevel] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification level updated successfully
  ///   * 400: Updating notification level is not possible
  ///
  /// See:
  ///  * [setNotificationLevel] for a method executing this request and parsing the response.
  ///  * [$setNotificationLevel_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setNotificationLevel_Request({
    required String token,
    required RoomSetNotificationLevelRequestApplicationJson $body,
    RoomSetNotificationLevelApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetNotificationLevelApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/notify').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomSetNotificationLevelRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update the notification level for a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification level updated successfully
  ///   * 400: Updating notification level is not possible
  ///
  /// See:
  ///  * [$setNotificationLevel_Request] for the request send by this method.
  ///  * [$setNotificationLevel_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetNotificationLevelResponseApplicationJson, void>> setNotificationLevel({
    required String token,
    required RoomSetNotificationLevelRequestApplicationJson $body,
    RoomSetNotificationLevelApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setNotificationLevel_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setNotificationLevel_Serializer();
    return _i1.ResponseConverter<RoomSetNotificationLevelResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setNotificationCalls_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetNotificationCallsResponseApplicationJson, void> $setNotificationCalls_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetNotificationCallsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Update call notifications.
  ///
  /// Returns a `DynamiteRequest` backing the [setNotificationCalls] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call notification level updated successfully
  ///   * 400: Updating call notification level is not possible
  ///
  /// See:
  ///  * [setNotificationCalls] for a method executing this request and parsing the response.
  ///  * [$setNotificationCalls_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setNotificationCalls_Request({
    required String token,
    required RoomSetNotificationCallsRequestApplicationJson $body,
    RoomSetNotificationCallsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetNotificationCallsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/notify-calls').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomSetNotificationCallsRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update call notifications.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call notification level updated successfully
  ///   * 400: Updating call notification level is not possible
  ///
  /// See:
  ///  * [$setNotificationCalls_Request] for the request send by this method.
  ///  * [$setNotificationCalls_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetNotificationCallsResponseApplicationJson, void>> setNotificationCalls({
    required String token,
    required RoomSetNotificationCallsRequestApplicationJson $body,
    RoomSetNotificationCallsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setNotificationCalls_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setNotificationCalls_Serializer();
    return _i1.ResponseConverter<RoomSetNotificationCallsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setLobby_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetLobbyResponseApplicationJson, void> $setLobby_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetLobbyResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update the lobby state for a room.
  ///
  /// Returns a `DynamiteRequest` backing the [setLobby] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Lobby state updated successfully
  ///   * 400: Updating lobby state is not possible
  ///
  /// See:
  ///  * [setLobby] for a method executing this request and parsing the response.
  ///  * [$setLobby_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setLobby_Request({
    required String token,
    required RoomSetLobbyRequestApplicationJson $body,
    RoomSetLobbyApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetLobbyApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/webinar/lobby').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(RoomSetLobbyRequestApplicationJson)));
    return _request;
  }

  /// Update the lobby state for a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Lobby state updated successfully
  ///   * 400: Updating lobby state is not possible
  ///
  /// See:
  ///  * [$setLobby_Request] for the request send by this method.
  ///  * [$setLobby_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetLobbyResponseApplicationJson, void>> setLobby({
    required String token,
    required RoomSetLobbyRequestApplicationJson $body,
    RoomSetLobbyApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setLobby_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setLobby_Serializer();
    return _i1.ResponseConverter<RoomSetLobbyResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setsipEnabled_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetsipEnabledResponseApplicationJson, void> $setsipEnabled_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetsipEnabledResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update SIP enabled state.
  ///
  /// Returns a `DynamiteRequest` backing the [setsipEnabled] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: SIP enabled state updated successfully
  ///   * 401: User not found
  ///   * 403: Missing permissions to update SIP enabled state
  ///   * 412: SIP not configured
  ///   * 400: Updating SIP enabled state is not possible
  ///
  /// See:
  ///  * [setsipEnabled] for a method executing this request and parsing the response.
  ///  * [$setsipEnabled_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setsipEnabled_Request({
    required String token,
    required RoomSetsipEnabledRequestApplicationJson $body,
    RoomSetsipEnabledApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetsipEnabledApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/webinar/sip').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomSetsipEnabledRequestApplicationJson)),
    );
    return _request;
  }

  /// Update SIP enabled state.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: SIP enabled state updated successfully
  ///   * 401: User not found
  ///   * 403: Missing permissions to update SIP enabled state
  ///   * 412: SIP not configured
  ///   * 400: Updating SIP enabled state is not possible
  ///
  /// See:
  ///  * [$setsipEnabled_Request] for the request send by this method.
  ///  * [$setsipEnabled_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetsipEnabledResponseApplicationJson, void>> setsipEnabled({
    required String token,
    required RoomSetsipEnabledRequestApplicationJson $body,
    RoomSetsipEnabledApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setsipEnabled_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setsipEnabled_Serializer();
    return _i1.ResponseConverter<RoomSetsipEnabledResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setRecordingConsent_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetRecordingConsentResponseApplicationJson, void> $setRecordingConsent_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetRecordingConsentResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set recording consent requirement for this conversation.
  ///
  /// Returns a `DynamiteRequest` backing the [setRecordingConsent] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording consent requirement set successfully
  ///   * 400: Setting recording consent requirement is not possible
  ///   * 412: No recording server is configured
  ///
  /// See:
  ///  * [setRecordingConsent] for a method executing this request and parsing the response.
  ///  * [$setRecordingConsent_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setRecordingConsent_Request({
    required String token,
    required RoomSetRecordingConsentRequestApplicationJson $body,
    RoomSetRecordingConsentApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetRecordingConsentApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/recording-consent').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomSetRecordingConsentRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Set recording consent requirement for this conversation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recording consent requirement set successfully
  ///   * 400: Setting recording consent requirement is not possible
  ///   * 412: No recording server is configured
  ///
  /// See:
  ///  * [$setRecordingConsent_Request] for the request send by this method.
  ///  * [$setRecordingConsent_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetRecordingConsentResponseApplicationJson, void>> setRecordingConsent({
    required String token,
    required RoomSetRecordingConsentRequestApplicationJson $body,
    RoomSetRecordingConsentApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setRecordingConsent_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setRecordingConsent_Serializer();
    return _i1.ResponseConverter<RoomSetRecordingConsentResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setMessageExpiration_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetMessageExpirationResponseApplicationJson, void> $setMessageExpiration_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetMessageExpirationResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update message expiration time.
  ///
  /// Returns a `DynamiteRequest` backing the [setMessageExpiration] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message expiration time updated successfully
  ///   * 400: Updating message expiration time is not possible
  ///
  /// See:
  ///  * [setMessageExpiration] for a method executing this request and parsing the response.
  ///  * [$setMessageExpiration_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setMessageExpiration_Request({
    required String token,
    required RoomSetMessageExpirationRequestApplicationJson $body,
    RoomSetMessageExpirationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetMessageExpirationApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/message-expiration').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomSetMessageExpirationRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update message expiration time.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Message expiration time updated successfully
  ///   * 400: Updating message expiration time is not possible
  ///
  /// See:
  ///  * [$setMessageExpiration_Request] for the request send by this method.
  ///  * [$setMessageExpiration_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetMessageExpirationResponseApplicationJson, void>> setMessageExpiration({
    required String token,
    required RoomSetMessageExpirationRequestApplicationJson $body,
    RoomSetMessageExpirationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setMessageExpiration_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setMessageExpiration_Serializer();
    return _i1.ResponseConverter<RoomSetMessageExpirationResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getCapabilities_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomGetCapabilitiesResponseApplicationJson, RoomRoomGetCapabilitiesHeaders>
      $getCapabilities_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomGetCapabilitiesResponseApplicationJson),
            headersType: const FullType(RoomRoomGetCapabilitiesHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get capabilities for a room.
  ///
  /// See "Capability handling in federated conversations" in https://github.com/nextcloud/spreed/issues/10680 to learn which capabilities should be considered from the local server or from the remote server.
  ///
  /// Returns a `DynamiteRequest` backing the [getCapabilities] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Get capabilities successfully
  ///
  /// See:
  ///  * [getCapabilities] for a method executing this request and parsing the response.
  ///  * [$getCapabilities_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getCapabilities_Request({
    required String token,
    RoomGetCapabilitiesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomGetCapabilitiesApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/capabilities').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get capabilities for a room.
  ///
  /// See "Capability handling in federated conversations" in https://github.com/nextcloud/spreed/issues/10680 to learn which capabilities should be considered from the local server or from the remote server.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Get capabilities successfully
  ///
  /// See:
  ///  * [$getCapabilities_Request] for the request send by this method.
  ///  * [$getCapabilities_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomGetCapabilitiesResponseApplicationJson, RoomRoomGetCapabilitiesHeaders>>
      getCapabilities({
    required String token,
    RoomGetCapabilitiesApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getCapabilities_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getCapabilities_Serializer();
    return _i1.ResponseConverter<RoomGetCapabilitiesResponseApplicationJson, RoomRoomGetCapabilitiesHeaders>(
      _serializer,
    ).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setMentionPermissions_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomSetMentionPermissionsResponseApplicationJson, void> $setMentionPermissions_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomSetMentionPermissionsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update the mention permissions for a room.
  ///
  /// Returns a `DynamiteRequest` backing the [setMentionPermissions] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Permissions updated successfully
  ///   * 400: Updating permissions is not possible
  ///
  /// See:
  ///  * [setMentionPermissions] for a method executing this request and parsing the response.
  ///  * [$setMentionPermissions_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setMentionPermissions_Request({
    required String token,
    required RoomSetMentionPermissionsRequestApplicationJson $body,
    RoomSetMentionPermissionsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomSetMentionPermissionsApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/mention-permissions')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomSetMentionPermissionsRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update the mention permissions for a room.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Permissions updated successfully
  ///   * 400: Updating permissions is not possible
  ///
  /// See:
  ///  * [$setMentionPermissions_Request] for the request send by this method.
  ///  * [$setMentionPermissions_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomSetMentionPermissionsResponseApplicationJson, void>> setMentionPermissions({
    required String token,
    required RoomSetMentionPermissionsRequestApplicationJson $body,
    RoomSetMentionPermissionsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setMentionPermissions_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setMentionPermissions_Serializer();
    return _i1.ResponseConverter<RoomSetMentionPermissionsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$joinFederatedRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomJoinFederatedRoomResponseApplicationJson, RoomRoomJoinFederatedRoomHeaders>
      $joinFederatedRoom_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomJoinFederatedRoomResponseApplicationJson),
            headersType: const FullType(RoomRoomJoinFederatedRoomHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Join room on the host server using the session id of the federated user.
  ///
  /// The session id can be null only for requests from Talk < 20.
  ///
  /// Returns a `DynamiteRequest` backing the [joinFederatedRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Federated user joined the room
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [joinFederatedRoom] for a method executing this request and parsing the response.
  ///  * [$joinFederatedRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $joinFederatedRoom_Request({
    required String token,
    RoomJoinFederatedRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
    RoomJoinFederatedRoomRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomJoinFederatedRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/federation/active').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(RoomJoinFederatedRoomRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              RoomJoinFederatedRoomRequestApplicationJson(),
              specifiedType: const FullType(RoomJoinFederatedRoomRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Join room on the host server using the session id of the federated user.
  ///
  /// The session id can be null only for requests from Talk < 20.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Federated user joined the room
  ///   * 404: Room not found
  ///
  /// See:
  ///  * [$joinFederatedRoom_Request] for the request send by this method.
  ///  * [$joinFederatedRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomJoinFederatedRoomResponseApplicationJson, RoomRoomJoinFederatedRoomHeaders>>
      joinFederatedRoom({
    required String token,
    RoomJoinFederatedRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
    RoomJoinFederatedRoomRequestApplicationJson? $body,
  }) async {
    final _request = $joinFederatedRoom_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $joinFederatedRoom_Serializer();
    return _i1.ResponseConverter<RoomJoinFederatedRoomResponseApplicationJson, RoomRoomJoinFederatedRoomHeaders>(
      _serializer,
    ).convert(_response);
  }

  /// Builds a serializer to parse the response of [$leaveFederatedRoom_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomLeaveFederatedRoomResponseApplicationJson, void> $leaveFederatedRoom_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomLeaveFederatedRoomResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Leave room on the host server using the session id of the federated user.
  ///
  /// Returns a `DynamiteRequest` backing the [leaveFederatedRoom] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [sessionId] Federated session id to leave with.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully left the room
  ///   * 404: Room not found (non-federation request)
  ///
  /// See:
  ///  * [leaveFederatedRoom] for a method executing this request and parsing the response.
  ///  * [$leaveFederatedRoom_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $leaveFederatedRoom_Request({
    required String token,
    required String sessionId,
    RoomLeaveFederatedRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __sessionId = _$jsonSerializers.serialize(sessionId, specifiedType: const FullType(String));
    _parameters['sessionId'] = __sessionId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomLeaveFederatedRoomApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/federation/active{?sessionId*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Leave room on the host server using the session id of the federated user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token] Token of the room.
  ///   * [sessionId] Federated session id to leave with.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully left the room
  ///   * 404: Room not found (non-federation request)
  ///
  /// See:
  ///  * [$leaveFederatedRoom_Request] for the request send by this method.
  ///  * [$leaveFederatedRoom_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomLeaveFederatedRoomResponseApplicationJson, void>> leaveFederatedRoom({
    required String token,
    required String sessionId,
    RoomLeaveFederatedRoomApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $leaveFederatedRoom_Request(
      token: token,
      sessionId: sessionId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $leaveFederatedRoom_Serializer();
    return _i1.ResponseConverter<RoomLeaveFederatedRoomResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$verifyDialInPinDeprecated_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomVerifyDialInPinDeprecatedResponseApplicationJson, void>
      $verifyDialInPinDeprecated_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomVerifyDialInPinDeprecatedResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Verify a dial-in PIN (SIP bridge).
  ///
  /// Returns a `DynamiteRequest` backing the [verifyDialInPinDeprecated] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [pin] PIN the participant used to dial-in.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant returned
  ///   * 401: SIP request invalid
  ///   * 404: Participant not found
  ///   * 501: SIP dial-in is not configured
  ///
  /// See:
  ///  * [verifyDialInPinDeprecated] for a method executing this request and parsing the response.
  ///  * [$verifyDialInPinDeprecated_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $verifyDialInPinDeprecated_Request({
    required String token,
    required String pin,
    RoomVerifyDialInPinDeprecatedApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __pin = _$jsonSerializers.serialize(pin, specifiedType: const FullType(String));
    _i4.checkString(
      __pin,
      'pin',
      pattern: RegExp(r'^\d{7,32}$'),
    );
    _parameters['pin'] = __pin;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomVerifyDialInPinDeprecatedApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/pin/{pin}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Verify a dial-in PIN (SIP bridge).
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [pin] PIN the participant used to dial-in.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant returned
  ///   * 401: SIP request invalid
  ///   * 404: Participant not found
  ///   * 501: SIP dial-in is not configured
  ///
  /// See:
  ///  * [$verifyDialInPinDeprecated_Request] for the request send by this method.
  ///  * [$verifyDialInPinDeprecated_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomVerifyDialInPinDeprecatedResponseApplicationJson, void>> verifyDialInPinDeprecated({
    required String token,
    required String pin,
    RoomVerifyDialInPinDeprecatedApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $verifyDialInPinDeprecated_Request(
      token: token,
      pin: pin,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $verifyDialInPinDeprecated_Serializer();
    return _i1.ResponseConverter<RoomVerifyDialInPinDeprecatedResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$verifyDialInPin_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomVerifyDialInPinResponseApplicationJson, void> $verifyDialInPin_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomVerifyDialInPinResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Verify a dial-in PIN (SIP bridge).
  ///
  /// Returns a `DynamiteRequest` backing the [verifyDialInPin] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant returned
  ///   * 401: SIP request invalid
  ///   * 404: Participant not found
  ///   * 501: SIP dial-in is not configured
  ///
  /// See:
  ///  * [verifyDialInPin] for a method executing this request and parsing the response.
  ///  * [$verifyDialInPin_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $verifyDialInPin_Request({
    required String token,
    required RoomVerifyDialInPinRequestApplicationJson $body,
    RoomVerifyDialInPinApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomVerifyDialInPinApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/verify-dialin').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RoomVerifyDialInPinRequestApplicationJson)),
    );
    return _request;
  }

  /// Verify a dial-in PIN (SIP bridge).
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant returned
  ///   * 401: SIP request invalid
  ///   * 404: Participant not found
  ///   * 501: SIP dial-in is not configured
  ///
  /// See:
  ///  * [$verifyDialInPin_Request] for the request send by this method.
  ///  * [$verifyDialInPin_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomVerifyDialInPinResponseApplicationJson, void>> verifyDialInPin({
    required String token,
    required RoomVerifyDialInPinRequestApplicationJson $body,
    RoomVerifyDialInPinApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $verifyDialInPin_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $verifyDialInPin_Serializer();
    return _i1.ResponseConverter<RoomVerifyDialInPinResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$verifyDialOutNumber_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomVerifyDialOutNumberResponseApplicationJson, void> $verifyDialOutNumber_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomVerifyDialOutNumberResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Verify a dial-out number (SIP bridge).
  ///
  /// Returns a `DynamiteRequest` backing the [verifyDialOutNumber] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant created successfully
  ///   * 400: Phone number and details could not be confirmed
  ///   * 401: SIP request invalid
  ///   * 404: Phone number is not invited as a participant
  ///   * 501: SIP dial-out is not configured
  ///
  /// See:
  ///  * [verifyDialOutNumber] for a method executing this request and parsing the response.
  ///  * [$verifyDialOutNumber_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $verifyDialOutNumber_Request({
    required String token,
    required RoomVerifyDialOutNumberRequestApplicationJson $body,
    RoomVerifyDialOutNumberApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomVerifyDialOutNumberApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/verify-dialout').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(RoomVerifyDialOutNumberRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Verify a dial-out number (SIP bridge).
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant created successfully
  ///   * 400: Phone number and details could not be confirmed
  ///   * 401: SIP request invalid
  ///   * 404: Phone number is not invited as a participant
  ///   * 501: SIP dial-out is not configured
  ///
  /// See:
  ///  * [$verifyDialOutNumber_Request] for the request send by this method.
  ///  * [$verifyDialOutNumber_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomVerifyDialOutNumberResponseApplicationJson, void>> verifyDialOutNumber({
    required String token,
    required RoomVerifyDialOutNumberRequestApplicationJson $body,
    RoomVerifyDialOutNumberApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $verifyDialOutNumber_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $verifyDialOutNumber_Serializer();
    return _i1.ResponseConverter<RoomVerifyDialOutNumberResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createGuestByDialIn_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomCreateGuestByDialInResponseApplicationJson, void> $createGuestByDialIn_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RoomCreateGuestByDialInResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a guest by their dial-in.
  ///
  /// Returns a `DynamiteRequest` backing the [createGuestByDialIn] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant created successfully
  ///   * 400: SIP not enabled
  ///   * 401: SIP request invalid
  ///
  /// See:
  ///  * [createGuestByDialIn] for a method executing this request and parsing the response.
  ///  * [$createGuestByDialIn_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createGuestByDialIn_Request({
    required String token,
    RoomCreateGuestByDialInApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomCreateGuestByDialInApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/open-dial-in').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Create a guest by their dial-in.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Participant created successfully
  ///   * 400: SIP not enabled
  ///   * 401: SIP request invalid
  ///
  /// See:
  ///  * [$createGuestByDialIn_Request] for the request send by this method.
  ///  * [$createGuestByDialIn_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomCreateGuestByDialInResponseApplicationJson, void>> createGuestByDialIn({
    required String token,
    RoomCreateGuestByDialInApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createGuestByDialIn_Request(
      token: token,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createGuestByDialIn_Serializer();
    return _i1.ResponseConverter<RoomCreateGuestByDialInResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$rejectedDialOutRequest_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RoomRejectedDialOutRequestResponseApplicationJson, void>
      $rejectedDialOutRequest_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RoomRejectedDialOutRequestResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200, 400, 401, 404, 501},
          );

  /// Reset call ID of a dial-out participant when the SIP gateway rejected it.
  ///
  /// Returns a `DynamiteRequest` backing the [rejectedDialOutRequest] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [callId] The call ID provided by the SIP bridge earlier to uniquely identify the call to terminate.
  ///   * [options] Additional details to verify the validity of the request.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call ID reset
  ///   * 400: Call ID mismatch or attendeeId not found in $options
  ///   * 401: SIP request invalid
  ///   * 404: Participant was not found
  ///   * 501: SIP dial-out is not configured
  ///
  /// See:
  ///  * [rejectedDialOutRequest] for a method executing this request and parsing the response.
  ///  * [$rejectedDialOutRequest_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $rejectedDialOutRequest_Request({
    required String token,
    required String callId,
    RoomRejectedDialOutRequestApiVersion? apiVersion,
    String? options,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _i4.checkString(
      __token,
      'token',
      pattern: RegExp(r'^[a-z0-9]{4,30}$'),
    );
    _parameters['token'] = __token;

    final __callId = _$jsonSerializers.serialize(callId, specifiedType: const FullType(String));
    _parameters['callId'] = __callId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RoomRejectedDialOutRequestApiVersion));
    __apiVersion ??= 'v4';
    _parameters['apiVersion'] = __apiVersion;

    final __options = _$jsonSerializers.serialize(options, specifiedType: const FullType(String));
    _parameters['options'] = __options;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/room/{token}/rejected-dialout{?callId*,options*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Reset call ID of a dial-out participant when the SIP gateway rejected it.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v4"`.
  ///   * [token]
  ///   * [callId] The call ID provided by the SIP bridge earlier to uniquely identify the call to terminate.
  ///   * [options] Additional details to verify the validity of the request.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Call ID reset
  ///   * 400: Call ID mismatch or attendeeId not found in $options
  ///   * 401: SIP request invalid
  ///   * 404: Participant was not found
  ///   * 501: SIP dial-out is not configured
  ///
  /// See:
  ///  * [$rejectedDialOutRequest_Request] for the request send by this method.
  ///  * [$rejectedDialOutRequest_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RoomRejectedDialOutRequestResponseApplicationJson, void>> rejectedDialOutRequest({
    required String token,
    required String callId,
    RoomRejectedDialOutRequestApiVersion? apiVersion,
    String? options,
    bool? oCSAPIRequest,
  }) async {
    final _request = $rejectedDialOutRequest_Request(
      token: token,
      callId: callId,
      apiVersion: apiVersion,
      options: options,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $rejectedDialOutRequest_Serializer();
    return _i1.ResponseConverter<RoomRejectedDialOutRequestResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $SettingsClient {
  /// Creates a new `DynamiteClient` for settings requests.
  $SettingsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$setUserSetting_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SettingsSetUserSettingResponseApplicationJson, void> $setUserSetting_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(SettingsSetUserSettingResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Update user setting.
  ///
  /// Returns a `DynamiteRequest` backing the [setUserSetting] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User setting updated successfully
  ///   * 400: Updating user setting is not possible
  ///
  /// See:
  ///  * [setUserSetting] for a method executing this request and parsing the response.
  ///  * [$setUserSetting_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setUserSetting_Request({
    required SettingsSetUserSettingRequestApplicationJson $body,
    SettingsSetUserSettingApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SettingsSetUserSettingApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/settings/user').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(SettingsSetUserSettingRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update user setting.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User setting updated successfully
  ///   * 400: Updating user setting is not possible
  ///
  /// See:
  ///  * [$setUserSetting_Request] for the request send by this method.
  ///  * [$setUserSetting_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SettingsSetUserSettingResponseApplicationJson, void>> setUserSetting({
    required SettingsSetUserSettingRequestApplicationJson $body,
    SettingsSetUserSettingApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setUserSetting_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setUserSetting_Serializer();
    return _i1.ResponseConverter<SettingsSetUserSettingResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$botAdminListBots_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BotAdminListBotsResponseApplicationJson, void> $botAdminListBots_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(BotAdminListBotsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// List admin bots.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [botAdminListBots] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bot list returned
  ///
  /// See:
  ///  * [botAdminListBots] for a method executing this request and parsing the response.
  ///  * [$botAdminListBots_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $botAdminListBots_Request({
    BotAdminListBotsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(BotAdminListBotsApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/bot/admin').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// List admin bots.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Bot list returned
  ///
  /// See:
  ///  * [$botAdminListBots_Request] for the request send by this method.
  ///  * [$botAdminListBots_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BotAdminListBotsResponseApplicationJson, void>> botAdminListBots({
    BotAdminListBotsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $botAdminListBots_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $botAdminListBots_Serializer();
    return _i1.ResponseConverter<BotAdminListBotsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$certificateGetCertificateExpiration_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CertificateGetCertificateExpirationResponseApplicationJson, void>
      $certificateGetCertificateExpiration_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(CertificateGetCertificateExpirationResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the certificate expiration for a host.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [certificateGetCertificateExpiration] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [host] Host to check.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Certificate expiration returned
  ///   * 400: Getting certificate expiration is not possible
  ///
  /// See:
  ///  * [certificateGetCertificateExpiration] for a method executing this request and parsing the response.
  ///  * [$certificateGetCertificateExpiration_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $certificateGetCertificateExpiration_Request({
    required String host,
    CertificateGetCertificateExpirationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __host = _$jsonSerializers.serialize(host, specifiedType: const FullType(String));
    _parameters['host'] = __host;

    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(CertificateGetCertificateExpirationApiVersion),
    );
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/certificate/expiration{?host*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the certificate expiration for a host.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [host] Host to check.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Certificate expiration returned
  ///   * 400: Getting certificate expiration is not possible
  ///
  /// See:
  ///  * [$certificateGetCertificateExpiration_Request] for the request send by this method.
  ///  * [$certificateGetCertificateExpiration_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CertificateGetCertificateExpirationResponseApplicationJson, void>>
      certificateGetCertificateExpiration({
    required String host,
    CertificateGetCertificateExpirationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $certificateGetCertificateExpiration_Request(
      host: host,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $certificateGetCertificateExpiration_Serializer();
    return _i1.ResponseConverter<CertificateGetCertificateExpirationResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$recordingGetWelcomeMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RecordingGetWelcomeMessageResponseApplicationJson, void>
      $recordingGetWelcomeMessage_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(RecordingGetWelcomeMessageResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the welcome message of a recording server.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [recordingGetWelcomeMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [serverId] ID of the server.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Welcome message returned
  ///   * 404: Recording server not found or not configured
  ///   * 500
  ///
  /// See:
  ///  * [recordingGetWelcomeMessage] for a method executing this request and parsing the response.
  ///  * [$recordingGetWelcomeMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $recordingGetWelcomeMessage_Request({
    required int serverId,
    RecordingGetWelcomeMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __serverId = _$jsonSerializers.serialize(serverId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __serverId,
      'serverId',
      minimum: 0,
    );
    _parameters['serverId'] = __serverId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(RecordingGetWelcomeMessageApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/recording/welcome/{serverId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the welcome message of a recording server.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [serverId] ID of the server.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Welcome message returned
  ///   * 404: Recording server not found or not configured
  ///   * 500
  ///
  /// See:
  ///  * [$recordingGetWelcomeMessage_Request] for the request send by this method.
  ///  * [$recordingGetWelcomeMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RecordingGetWelcomeMessageResponseApplicationJson, void>> recordingGetWelcomeMessage({
    required int serverId,
    RecordingGetWelcomeMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $recordingGetWelcomeMessage_Request(
      serverId: serverId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $recordingGetWelcomeMessage_Serializer();
    return _i1.ResponseConverter<RecordingGetWelcomeMessageResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setsipSettings_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SettingsSetsipSettingsResponseApplicationJson, void> $setsipSettings_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(SettingsSetsipSettingsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update SIP bridge settings.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [setsipSettings] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully set new SIP settings
  ///
  /// See:
  ///  * [setsipSettings] for a method executing this request and parsing the response.
  ///  * [$setsipSettings_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setsipSettings_Request({
    SettingsSetsipSettingsApiVersion? apiVersion,
    bool? oCSAPIRequest,
    SettingsSetsipSettingsRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SettingsSetsipSettingsApiVersion));
    __apiVersion ??= 'v1';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/settings/sip').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(SettingsSetsipSettingsRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              SettingsSetsipSettingsRequestApplicationJson(),
              specifiedType: const FullType(SettingsSetsipSettingsRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Update SIP bridge settings.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v1"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Successfully set new SIP settings
  ///
  /// See:
  ///  * [$setsipSettings_Request] for the request send by this method.
  ///  * [$setsipSettings_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SettingsSetsipSettingsResponseApplicationJson, void>> setsipSettings({
    SettingsSetsipSettingsApiVersion? apiVersion,
    bool? oCSAPIRequest,
    SettingsSetsipSettingsRequestApplicationJson? $body,
  }) async {
    final _request = $setsipSettings_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setsipSettings_Serializer();
    return _i1.ResponseConverter<SettingsSetsipSettingsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$signalingGetWelcomeMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SignalingGetWelcomeMessageResponseApplicationJson, void>
      $signalingGetWelcomeMessage_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(SignalingGetWelcomeMessageResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the welcome message from a signaling server.
  ///
  /// Only available for logged-in users because guests can not use the apps right now.
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [signalingGetWelcomeMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [serverId] ID of the signaling server.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Welcome message returned
  ///   * 404: Signaling server not found
  ///   * 500
  ///
  /// See:
  ///  * [signalingGetWelcomeMessage] for a method executing this request and parsing the response.
  ///  * [$signalingGetWelcomeMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $signalingGetWelcomeMessage_Request({
    required int serverId,
    SignalingGetWelcomeMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __serverId = _$jsonSerializers.serialize(serverId, specifiedType: const FullType(int));
    _i4.checkNumber(
      __serverId,
      'serverId',
      minimum: 0,
    );
    _parameters['serverId'] = __serverId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SignalingGetWelcomeMessageApiVersion));
    __apiVersion ??= 'v3';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/signaling/welcome/{serverId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the welcome message from a signaling server.
  ///
  /// Only available for logged-in users because guests can not use the apps right now.
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [serverId] ID of the signaling server.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Welcome message returned
  ///   * 404: Signaling server not found
  ///   * 500
  ///
  /// See:
  ///  * [$signalingGetWelcomeMessage_Request] for the request send by this method.
  ///  * [$signalingGetWelcomeMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SignalingGetWelcomeMessageResponseApplicationJson, void>> signalingGetWelcomeMessage({
    required int serverId,
    SignalingGetWelcomeMessageApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $signalingGetWelcomeMessage_Request(
      serverId: serverId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $signalingGetWelcomeMessage_Serializer();
    return _i1.ResponseConverter<SignalingGetWelcomeMessageResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $SignalingClient {
  /// Creates a new `DynamiteClient` for signaling requests.
  $SignalingClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$backend_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SignalingBackendResponseApplicationJson, void> $backend_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(SignalingBackendResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Backend API to query information required for standalone signaling servers.
  ///
  /// See sections "Backend validation" in https://nextcloud-spreed-signaling.readthedocs.io/en/latest/standalone-signaling-api-v1/#backend-requests.
  ///
  /// Returns a `DynamiteRequest` backing the [backend] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Always, sorry about that
  ///
  /// See:
  ///  * [backend] for a method executing this request and parsing the response.
  ///  * [$backend_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $backend_Request({
    SignalingBackendApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SignalingBackendApiVersion));
    __apiVersion ??= 'v3';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/spreed/api/{apiVersion}/signaling/backend').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Backend API to query information required for standalone signaling servers.
  ///
  /// See sections "Backend validation" in https://nextcloud-spreed-signaling.readthedocs.io/en/latest/standalone-signaling-api-v1/#backend-requests.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v3"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Always, sorry about that
  ///
  /// See:
  ///  * [$backend_Request] for the request send by this method.
  ///  * [$backend_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SignalingBackendResponseApplicationJson, void>> backend({
    SignalingBackendApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $backend_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $backend_Serializer();
    return _i1.ResponseConverter<SignalingBackendResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $UserAvatarClient {
  /// Creates a new `DynamiteClient` for user_avatar requests.
  $UserAvatarClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$tempAvatarPostAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TempAvatarPostAvatarResponseApplicationJson, void> $tempAvatarPostAvatar_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TempAvatarPostAvatarResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Upload your avatar as a user.
  ///
  /// Returns a `DynamiteRequest` backing the [tempAvatarPostAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar uploaded successfully
  ///   * 400: Uploading avatar is not possible
  ///
  /// See:
  ///  * [tempAvatarPostAvatar] for a method executing this request and parsing the response.
  ///  * [$tempAvatarPostAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $tempAvatarPostAvatar_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/spreed/temp-user-avatar';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Upload your avatar as a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar uploaded successfully
  ///   * 400: Uploading avatar is not possible
  ///
  /// See:
  ///  * [$tempAvatarPostAvatar_Request] for the request send by this method.
  ///  * [$tempAvatarPostAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TempAvatarPostAvatarResponseApplicationJson, void>> tempAvatarPostAvatar({
    bool? oCSAPIRequest,
  }) async {
    final _request = $tempAvatarPostAvatar_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $tempAvatarPostAvatar_Serializer();
    return _i1.ResponseConverter<TempAvatarPostAvatarResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$tempAvatarDeleteAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TempAvatarDeleteAvatarResponseApplicationJson, void> $tempAvatarDeleteAvatar_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TempAvatarDeleteAvatarResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Delete your avatar as a user.
  ///
  /// Returns a `DynamiteRequest` backing the [tempAvatarDeleteAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar deleted successfully
  ///   * 400: Deleting avatar is not possible
  ///
  /// See:
  ///  * [tempAvatarDeleteAvatar] for a method executing this request and parsing the response.
  ///  * [$tempAvatarDeleteAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $tempAvatarDeleteAvatar_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/spreed/temp-user-avatar';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete your avatar as a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Avatar deleted successfully
  ///   * 400: Deleting avatar is not possible
  ///
  /// See:
  ///  * [$tempAvatarDeleteAvatar_Request] for the request send by this method.
  ///  * [$tempAvatarDeleteAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TempAvatarDeleteAvatarResponseApplicationJson, void>> tempAvatarDeleteAvatar({
    bool? oCSAPIRequest,
  }) async {
    final _request = $tempAvatarDeleteAvatar_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $tempAvatarDeleteAvatar_Serializer();
    return _i1.ResponseConverter<TempAvatarDeleteAvatarResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

typedef ChatProxyMessage = BaseMessage;

class AvatarGetAvatarApiVersion extends EnumClass {
  const AvatarGetAvatarApiVersion._(super.name);

  /// `v1`
  static const AvatarGetAvatarApiVersion v1 = _$avatarGetAvatarApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetAvatarApiVersion> get values => _$avatarGetAvatarApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetAvatarApiVersion valueOf(String name) => _$valueOfAvatarGetAvatarApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarGetAvatarApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetAvatarApiVersion> get serializer => const _$AvatarGetAvatarApiVersionSerializer();
}

class _$AvatarGetAvatarApiVersionSerializer implements PrimitiveSerializer<AvatarGetAvatarApiVersion> {
  const _$AvatarGetAvatarApiVersionSerializer();

  static const Map<AvatarGetAvatarApiVersion, Object> _toWire = <AvatarGetAvatarApiVersion, Object>{
    AvatarGetAvatarApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarGetAvatarApiVersion> _fromWire = <Object, AvatarGetAvatarApiVersion>{
    'v1': AvatarGetAvatarApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetAvatarApiVersion];

  @override
  String get wireName => 'AvatarGetAvatarApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetAvatarApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetAvatarApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetAvatarDarkTheme extends EnumClass {
  const AvatarGetAvatarDarkTheme._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const AvatarGetAvatarDarkTheme $0 = _$avatarGetAvatarDarkTheme$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const AvatarGetAvatarDarkTheme $1 = _$avatarGetAvatarDarkTheme$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetAvatarDarkTheme> get values => _$avatarGetAvatarDarkThemeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetAvatarDarkTheme valueOf(String name) => _$valueOfAvatarGetAvatarDarkTheme(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetAvatarDarkTheme.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetAvatarDarkTheme> get serializer => const _$AvatarGetAvatarDarkThemeSerializer();
}

class _$AvatarGetAvatarDarkThemeSerializer implements PrimitiveSerializer<AvatarGetAvatarDarkTheme> {
  const _$AvatarGetAvatarDarkThemeSerializer();

  static const Map<AvatarGetAvatarDarkTheme, Object> _toWire = <AvatarGetAvatarDarkTheme, Object>{
    AvatarGetAvatarDarkTheme.$0: 0,
    AvatarGetAvatarDarkTheme.$1: 1,
  };

  static const Map<Object, AvatarGetAvatarDarkTheme> _fromWire = <Object, AvatarGetAvatarDarkTheme>{
    0: AvatarGetAvatarDarkTheme.$0,
    1: AvatarGetAvatarDarkTheme.$1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetAvatarDarkTheme];

  @override
  String get wireName => 'AvatarGetAvatarDarkTheme';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetAvatarDarkTheme object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetAvatarDarkTheme deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarUploadAvatarApiVersion extends EnumClass {
  const AvatarUploadAvatarApiVersion._(super.name);

  /// `v1`
  static const AvatarUploadAvatarApiVersion v1 = _$avatarUploadAvatarApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarUploadAvatarApiVersion> get values => _$avatarUploadAvatarApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarUploadAvatarApiVersion valueOf(String name) => _$valueOfAvatarUploadAvatarApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarUploadAvatarApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarUploadAvatarApiVersion> get serializer => const _$AvatarUploadAvatarApiVersionSerializer();
}

class _$AvatarUploadAvatarApiVersionSerializer implements PrimitiveSerializer<AvatarUploadAvatarApiVersion> {
  const _$AvatarUploadAvatarApiVersionSerializer();

  static const Map<AvatarUploadAvatarApiVersion, Object> _toWire = <AvatarUploadAvatarApiVersion, Object>{
    AvatarUploadAvatarApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarUploadAvatarApiVersion> _fromWire = <Object, AvatarUploadAvatarApiVersion>{
    'v1': AvatarUploadAvatarApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarUploadAvatarApiVersion];

  @override
  String get wireName => 'AvatarUploadAvatarApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarUploadAvatarApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarUploadAvatarApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

class ActorType extends EnumClass {
  const ActorType._(super.name);

  /// `users`
  static const ActorType users = _$actorTypeUsers;

  /// `groups`
  static const ActorType groups = _$actorTypeGroups;

  /// `guests`
  static const ActorType guests = _$actorTypeGuests;

  /// `emails`
  static const ActorType emails = _$actorTypeEmails;

  /// `circles`
  static const ActorType circles = _$actorTypeCircles;

  /// `bridged`
  static const ActorType bridged = _$actorTypeBridged;

  /// `bots`
  static const ActorType bots = _$actorTypeBots;

  /// `federated_users`
  @BuiltValueEnumConst(wireName: 'federated_users')
  static const ActorType federatedUsers = _$actorTypeFederatedUsers;

  /// `phones`
  static const ActorType phones = _$actorTypePhones;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ActorType> get values => _$actorTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ActorType valueOf(String name) => _$valueOfActorType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ActorType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ActorType> get serializer => const _$ActorTypeSerializer();
}

class _$ActorTypeSerializer implements PrimitiveSerializer<ActorType> {
  const _$ActorTypeSerializer();

  static const Map<ActorType, Object> _toWire = <ActorType, Object>{
    ActorType.users: 'users',
    ActorType.groups: 'groups',
    ActorType.guests: 'guests',
    ActorType.emails: 'emails',
    ActorType.circles: 'circles',
    ActorType.bridged: 'bridged',
    ActorType.bots: 'bots',
    ActorType.federatedUsers: 'federated_users',
    ActorType.phones: 'phones',
  };

  static const Map<Object, ActorType> _fromWire = <Object, ActorType>{
    'users': ActorType.users,
    'groups': ActorType.groups,
    'guests': ActorType.guests,
    'emails': ActorType.emails,
    'circles': ActorType.circles,
    'bridged': ActorType.bridged,
    'bots': ActorType.bots,
    'federated_users': ActorType.federatedUsers,
    'phones': ActorType.phones,
  };

  @override
  Iterable<Type> get types => const [ActorType];

  @override
  String get wireName => 'ActorType';

  @override
  Object serialize(
    Serializers serializers,
    ActorType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ActorType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class MessageType extends EnumClass {
  const MessageType._(super.name);

  /// `comment`
  static const MessageType comment = _$messageTypeComment;

  /// `system`
  static const MessageType system = _$messageTypeSystem;

  /// `object_shared`
  @BuiltValueEnumConst(wireName: 'object_shared')
  static const MessageType objectShared = _$messageTypeObjectShared;

  /// `command`
  static const MessageType command = _$messageTypeCommand;

  /// `comment_deleted`
  @BuiltValueEnumConst(wireName: 'comment_deleted')
  static const MessageType commentDeleted = _$messageTypeCommentDeleted;

  /// `reaction`
  static const MessageType reaction = _$messageTypeReaction;

  /// `reaction_deleted`
  @BuiltValueEnumConst(wireName: 'reaction_deleted')
  static const MessageType reactionDeleted = _$messageTypeReactionDeleted;

  /// `voice-message`
  @BuiltValueEnumConst(wireName: 'voice-message')
  static const MessageType voiceMessage = _$messageTypeVoiceMessage;

  /// `record-audio`
  @BuiltValueEnumConst(wireName: 'record-audio')
  static const MessageType recordAudio = _$messageTypeRecordAudio;

  /// `record-video`
  @BuiltValueEnumConst(wireName: 'record-video')
  static const MessageType recordVideo = _$messageTypeRecordVideo;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<MessageType> get values => _$messageTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static MessageType valueOf(String name) => _$valueOfMessageType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for MessageType.
  @BuiltValueSerializer(custom: true)
  static Serializer<MessageType> get serializer => const _$MessageTypeSerializer();
}

class _$MessageTypeSerializer implements PrimitiveSerializer<MessageType> {
  const _$MessageTypeSerializer();

  static const Map<MessageType, Object> _toWire = <MessageType, Object>{
    MessageType.comment: 'comment',
    MessageType.system: 'system',
    MessageType.objectShared: 'object_shared',
    MessageType.command: 'command',
    MessageType.commentDeleted: 'comment_deleted',
    MessageType.reaction: 'reaction',
    MessageType.reactionDeleted: 'reaction_deleted',
    MessageType.voiceMessage: 'voice-message',
    MessageType.recordAudio: 'record-audio',
    MessageType.recordVideo: 'record-video',
  };

  static const Map<Object, MessageType> _fromWire = <Object, MessageType>{
    'comment': MessageType.comment,
    'system': MessageType.system,
    'object_shared': MessageType.objectShared,
    'command': MessageType.command,
    'comment_deleted': MessageType.commentDeleted,
    'reaction': MessageType.reaction,
    'reaction_deleted': MessageType.reactionDeleted,
    'voice-message': MessageType.voiceMessage,
    'record-audio': MessageType.recordAudio,
    'record-video': MessageType.recordVideo,
  };

  @override
  Iterable<Type> get types => const [MessageType];

  @override
  String get wireName => 'MessageType';

  @override
  Object serialize(
    Serializers serializers,
    MessageType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  MessageType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BaseMessageInterface {
  String get actorDisplayName;
  String get actorId;
  ActorType get actorType;
  int get expirationTimestamp;
  String get message;
  BuiltMap<String, BuiltMap<String, JsonObject>> get messageParameters;
  MessageType get messageType;
  String get systemMessage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BaseMessageInterfaceBuilder].
  $BaseMessageInterface rebuild(void Function($BaseMessageInterfaceBuilder) updates);

  /// Converts the instance to a builder [$BaseMessageInterfaceBuilder].
  $BaseMessageInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BaseMessageInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BaseMessageInterfaceBuilder b) {}
}

abstract class BaseMessage implements $BaseMessageInterface, Built<BaseMessage, BaseMessageBuilder> {
  /// Creates a new BaseMessage object using the builder pattern.
  factory BaseMessage([void Function(BaseMessageBuilder)? b]) = _$BaseMessage;

  // coverage:ignore-start
  const BaseMessage._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BaseMessage.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BaseMessage.
  static Serializer<BaseMessage> get serializer => _$baseMessageSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BaseMessageBuilder b) {
    $BaseMessageInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BaseMessageBuilder b) {
    $BaseMessageInterface._validate(b);
  }
}

class ChatMessage_Deleted extends EnumClass {
  const ChatMessage_Deleted._(super.name);

  /// `true`
  @BuiltValueEnumConst(wireName: 'true')
  static const ChatMessage_Deleted $true = _$chatMessageDeleted$true;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ChatMessage_Deleted> get values => _$chatMessageDeletedValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ChatMessage_Deleted valueOf(String name) => _$valueOfChatMessage_Deleted(name);

  /// Returns the serialized value of this enum value.
  bool get value => _$jsonSerializers.serializeWith(serializer, this)! as bool;

  /// Serializer for ChatMessage_Deleted.
  @BuiltValueSerializer(custom: true)
  static Serializer<ChatMessage_Deleted> get serializer => const _$ChatMessage_DeletedSerializer();
}

class _$ChatMessage_DeletedSerializer implements PrimitiveSerializer<ChatMessage_Deleted> {
  const _$ChatMessage_DeletedSerializer();

  static const Map<ChatMessage_Deleted, Object> _toWire = <ChatMessage_Deleted, Object>{
    ChatMessage_Deleted.$true: true,
  };

  static const Map<Object, ChatMessage_Deleted> _fromWire = <Object, ChatMessage_Deleted>{
    true: ChatMessage_Deleted.$true,
  };

  @override
  Iterable<Type> get types => const [ChatMessage_Deleted];

  @override
  String get wireName => 'ChatMessage_Deleted';

  @override
  Object serialize(
    Serializers serializers,
    ChatMessage_Deleted object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ChatMessage_Deleted deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ChatMessageInterface implements $BaseMessageInterface {
  ChatMessage_Deleted? get deleted;
  int get id;
  bool get isReplyable;
  bool get markdown;
  BuiltMap<String, int> get reactions;
  BuiltList<String>? get reactionsSelf;
  String get referenceId;
  int get timestamp;
  String get token;
  String? get lastEditActorDisplayName;
  String? get lastEditActorId;
  ActorType? get lastEditActorType;
  int? get lastEditTimestamp;
  bool? get silent;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ChatMessageInterfaceBuilder].
  @override
  $ChatMessageInterface rebuild(void Function($ChatMessageInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ChatMessageInterfaceBuilder].
  @override
  $ChatMessageInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ChatMessageInterfaceBuilder b) {
    $BaseMessageInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ChatMessageInterfaceBuilder b) {
    $BaseMessageInterface._validate(b);
  }
}

abstract class ChatMessage implements $ChatMessageInterface, Built<ChatMessage, ChatMessageBuilder> {
  /// Creates a new ChatMessage object using the builder pattern.
  factory ChatMessage([void Function(ChatMessageBuilder)? b]) = _$ChatMessage;

  // coverage:ignore-start
  const ChatMessage._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ChatMessage.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ChatMessage.
  static Serializer<ChatMessage> get serializer => _$chatMessageSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ChatMessageBuilder b) {
    $ChatMessageInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ChatMessageBuilder b) {
    $ChatMessageInterface._validate(b);
  }
}

typedef RoomLastMessage = ({BaseMessage? baseMessage, ChatMessage? chatMessage});
typedef Room_LastMessage = ({BaseMessage? baseMessage, BuiltList<Never>? builtListNever, ChatMessage? chatMessage});

@BuiltValue(instantiable: false)
sealed class $RoomInterface {
  String get actorId;
  ActorType get actorType;
  int get attendeeId;
  int get attendeePermissions;
  String? get attendeePin;
  String get avatarVersion;
  int get breakoutRoomMode;
  int get breakoutRoomStatus;
  int get callFlag;
  int get callPermissions;
  int get callRecording;
  int get callStartTime;
  bool get canDeleteConversation;
  bool get canEnableSIP;
  bool get canLeaveConversation;
  bool get canStartCall;
  int get defaultPermissions;
  String get description;
  String get displayName;
  bool get hasCall;
  bool get hasPassword;
  int get id;
  bool get isCustomAvatar;
  bool get isFavorite;
  int get lastActivity;
  int get lastCommonReadMessage;
  Room_LastMessage get lastMessage;
  int get lastPing;
  int get lastReadMessage;
  int get listable;
  int get lobbyState;
  int get lobbyTimer;
  int? get mentionPermissions;
  int get messageExpiration;
  String get name;
  int get notificationCalls;
  int get notificationLevel;
  String get objectId;
  String get objectType;
  int get participantFlags;
  int get participantType;
  int get permissions;
  int get readOnly;
  int get recordingConsent;
  String? get remoteServer;
  String? get remoteToken;
  String get sessionId;
  int get sipEnabled;
  String? get status;
  int? get statusClearAt;
  String? get statusIcon;
  String? get statusMessage;
  String get token;
  int get type;
  bool get unreadMention;
  bool get unreadMentionDirect;
  int get unreadMessages;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RoomInterfaceBuilder].
  $RoomInterface rebuild(void Function($RoomInterfaceBuilder) updates);

  /// Converts the instance to a builder [$RoomInterfaceBuilder].
  $RoomInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RoomInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RoomInterfaceBuilder b) {
    b.lastMessage?.validateAnyOf();
  }
}

abstract class Room implements $RoomInterface, Built<Room, RoomBuilder> {
  /// Creates a new Room object using the builder pattern.
  factory Room([void Function(RoomBuilder)? b]) = _$Room;

  // coverage:ignore-start
  const Room._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Room.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Room.
  static Serializer<Room> get serializer => _$roomSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RoomBuilder b) {
    $RoomInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RoomBuilder b) {
    $RoomInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AvatarUploadAvatarResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Room get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarUploadAvatarResponseApplicationJson_OcsInterfaceBuilder].
  $AvatarUploadAvatarResponseApplicationJson_OcsInterface rebuild(
    void Function($AvatarUploadAvatarResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AvatarUploadAvatarResponseApplicationJson_OcsInterfaceBuilder].
  $AvatarUploadAvatarResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarUploadAvatarResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarUploadAvatarResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AvatarUploadAvatarResponseApplicationJson_Ocs
    implements
        $AvatarUploadAvatarResponseApplicationJson_OcsInterface,
        Built<AvatarUploadAvatarResponseApplicationJson_Ocs, AvatarUploadAvatarResponseApplicationJson_OcsBuilder> {
  /// Creates a new AvatarUploadAvatarResponseApplicationJson_Ocs object using the builder pattern.
  factory AvatarUploadAvatarResponseApplicationJson_Ocs([
    void Function(AvatarUploadAvatarResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AvatarUploadAvatarResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AvatarUploadAvatarResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarUploadAvatarResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarUploadAvatarResponseApplicationJson_Ocs.
  static Serializer<AvatarUploadAvatarResponseApplicationJson_Ocs> get serializer =>
      _$avatarUploadAvatarResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarUploadAvatarResponseApplicationJson_OcsBuilder b) {
    $AvatarUploadAvatarResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarUploadAvatarResponseApplicationJson_OcsBuilder b) {
    $AvatarUploadAvatarResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AvatarUploadAvatarResponseApplicationJsonInterface {
  AvatarUploadAvatarResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarUploadAvatarResponseApplicationJsonInterfaceBuilder].
  $AvatarUploadAvatarResponseApplicationJsonInterface rebuild(
    void Function($AvatarUploadAvatarResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AvatarUploadAvatarResponseApplicationJsonInterfaceBuilder].
  $AvatarUploadAvatarResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarUploadAvatarResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarUploadAvatarResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AvatarUploadAvatarResponseApplicationJson
    implements
        $AvatarUploadAvatarResponseApplicationJsonInterface,
        Built<AvatarUploadAvatarResponseApplicationJson, AvatarUploadAvatarResponseApplicationJsonBuilder> {
  /// Creates a new AvatarUploadAvatarResponseApplicationJson object using the builder pattern.
  factory AvatarUploadAvatarResponseApplicationJson([
    void Function(AvatarUploadAvatarResponseApplicationJsonBuilder)? b,
  ]) = _$AvatarUploadAvatarResponseApplicationJson;

  // coverage:ignore-start
  const AvatarUploadAvatarResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarUploadAvatarResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarUploadAvatarResponseApplicationJson.
  static Serializer<AvatarUploadAvatarResponseApplicationJson> get serializer =>
      _$avatarUploadAvatarResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarUploadAvatarResponseApplicationJsonBuilder b) {
    $AvatarUploadAvatarResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarUploadAvatarResponseApplicationJsonBuilder b) {
    $AvatarUploadAvatarResponseApplicationJsonInterface._validate(b);
  }
}

class AvatarDeleteAvatarApiVersion extends EnumClass {
  const AvatarDeleteAvatarApiVersion._(super.name);

  /// `v1`
  static const AvatarDeleteAvatarApiVersion v1 = _$avatarDeleteAvatarApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarDeleteAvatarApiVersion> get values => _$avatarDeleteAvatarApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarDeleteAvatarApiVersion valueOf(String name) => _$valueOfAvatarDeleteAvatarApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarDeleteAvatarApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarDeleteAvatarApiVersion> get serializer => const _$AvatarDeleteAvatarApiVersionSerializer();
}

class _$AvatarDeleteAvatarApiVersionSerializer implements PrimitiveSerializer<AvatarDeleteAvatarApiVersion> {
  const _$AvatarDeleteAvatarApiVersionSerializer();

  static const Map<AvatarDeleteAvatarApiVersion, Object> _toWire = <AvatarDeleteAvatarApiVersion, Object>{
    AvatarDeleteAvatarApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarDeleteAvatarApiVersion> _fromWire = <Object, AvatarDeleteAvatarApiVersion>{
    'v1': AvatarDeleteAvatarApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarDeleteAvatarApiVersion];

  @override
  String get wireName => 'AvatarDeleteAvatarApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarDeleteAvatarApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarDeleteAvatarApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $AvatarDeleteAvatarResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Room get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarDeleteAvatarResponseApplicationJson_OcsInterfaceBuilder].
  $AvatarDeleteAvatarResponseApplicationJson_OcsInterface rebuild(
    void Function($AvatarDeleteAvatarResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AvatarDeleteAvatarResponseApplicationJson_OcsInterfaceBuilder].
  $AvatarDeleteAvatarResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarDeleteAvatarResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarDeleteAvatarResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AvatarDeleteAvatarResponseApplicationJson_Ocs
    implements
        $AvatarDeleteAvatarResponseApplicationJson_OcsInterface,
        Built<AvatarDeleteAvatarResponseApplicationJson_Ocs, AvatarDeleteAvatarResponseApplicationJson_OcsBuilder> {
  /// Creates a new AvatarDeleteAvatarResponseApplicationJson_Ocs object using the builder pattern.
  factory AvatarDeleteAvatarResponseApplicationJson_Ocs([
    void Function(AvatarDeleteAvatarResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AvatarDeleteAvatarResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AvatarDeleteAvatarResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarDeleteAvatarResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarDeleteAvatarResponseApplicationJson_Ocs.
  static Serializer<AvatarDeleteAvatarResponseApplicationJson_Ocs> get serializer =>
      _$avatarDeleteAvatarResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarDeleteAvatarResponseApplicationJson_OcsBuilder b) {
    $AvatarDeleteAvatarResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarDeleteAvatarResponseApplicationJson_OcsBuilder b) {
    $AvatarDeleteAvatarResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AvatarDeleteAvatarResponseApplicationJsonInterface {
  AvatarDeleteAvatarResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarDeleteAvatarResponseApplicationJsonInterfaceBuilder].
  $AvatarDeleteAvatarResponseApplicationJsonInterface rebuild(
    void Function($AvatarDeleteAvatarResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AvatarDeleteAvatarResponseApplicationJsonInterfaceBuilder].
  $AvatarDeleteAvatarResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarDeleteAvatarResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarDeleteAvatarResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AvatarDeleteAvatarResponseApplicationJson
    implements
        $AvatarDeleteAvatarResponseApplicationJsonInterface,
        Built<AvatarDeleteAvatarResponseApplicationJson, AvatarDeleteAvatarResponseApplicationJsonBuilder> {
  /// Creates a new AvatarDeleteAvatarResponseApplicationJson object using the builder pattern.
  factory AvatarDeleteAvatarResponseApplicationJson([
    void Function(AvatarDeleteAvatarResponseApplicationJsonBuilder)? b,
  ]) = _$AvatarDeleteAvatarResponseApplicationJson;

  // coverage:ignore-start
  const AvatarDeleteAvatarResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarDeleteAvatarResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarDeleteAvatarResponseApplicationJson.
  static Serializer<AvatarDeleteAvatarResponseApplicationJson> get serializer =>
      _$avatarDeleteAvatarResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarDeleteAvatarResponseApplicationJsonBuilder b) {
    $AvatarDeleteAvatarResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarDeleteAvatarResponseApplicationJsonBuilder b) {
    $AvatarDeleteAvatarResponseApplicationJsonInterface._validate(b);
  }
}

class AvatarEmojiAvatarApiVersion extends EnumClass {
  const AvatarEmojiAvatarApiVersion._(super.name);

  /// `v1`
  static const AvatarEmojiAvatarApiVersion v1 = _$avatarEmojiAvatarApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarEmojiAvatarApiVersion> get values => _$avatarEmojiAvatarApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarEmojiAvatarApiVersion valueOf(String name) => _$valueOfAvatarEmojiAvatarApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarEmojiAvatarApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarEmojiAvatarApiVersion> get serializer => const _$AvatarEmojiAvatarApiVersionSerializer();
}

class _$AvatarEmojiAvatarApiVersionSerializer implements PrimitiveSerializer<AvatarEmojiAvatarApiVersion> {
  const _$AvatarEmojiAvatarApiVersionSerializer();

  static const Map<AvatarEmojiAvatarApiVersion, Object> _toWire = <AvatarEmojiAvatarApiVersion, Object>{
    AvatarEmojiAvatarApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarEmojiAvatarApiVersion> _fromWire = <Object, AvatarEmojiAvatarApiVersion>{
    'v1': AvatarEmojiAvatarApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarEmojiAvatarApiVersion];

  @override
  String get wireName => 'AvatarEmojiAvatarApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarEmojiAvatarApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarEmojiAvatarApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $AvatarEmojiAvatarRequestApplicationJsonInterface {
  /// Emoji.
  String get emoji;

  /// Color of the emoji.
  String? get color;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarEmojiAvatarRequestApplicationJsonInterfaceBuilder].
  $AvatarEmojiAvatarRequestApplicationJsonInterface rebuild(
    void Function($AvatarEmojiAvatarRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AvatarEmojiAvatarRequestApplicationJsonInterfaceBuilder].
  $AvatarEmojiAvatarRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarEmojiAvatarRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarEmojiAvatarRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class AvatarEmojiAvatarRequestApplicationJson
    implements
        $AvatarEmojiAvatarRequestApplicationJsonInterface,
        Built<AvatarEmojiAvatarRequestApplicationJson, AvatarEmojiAvatarRequestApplicationJsonBuilder> {
  /// Creates a new AvatarEmojiAvatarRequestApplicationJson object using the builder pattern.
  factory AvatarEmojiAvatarRequestApplicationJson([void Function(AvatarEmojiAvatarRequestApplicationJsonBuilder)? b]) =
      _$AvatarEmojiAvatarRequestApplicationJson;

  // coverage:ignore-start
  const AvatarEmojiAvatarRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarEmojiAvatarRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarEmojiAvatarRequestApplicationJson.
  static Serializer<AvatarEmojiAvatarRequestApplicationJson> get serializer =>
      _$avatarEmojiAvatarRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarEmojiAvatarRequestApplicationJsonBuilder b) {
    $AvatarEmojiAvatarRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarEmojiAvatarRequestApplicationJsonBuilder b) {
    $AvatarEmojiAvatarRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AvatarEmojiAvatarResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Room get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarEmojiAvatarResponseApplicationJson_OcsInterfaceBuilder].
  $AvatarEmojiAvatarResponseApplicationJson_OcsInterface rebuild(
    void Function($AvatarEmojiAvatarResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AvatarEmojiAvatarResponseApplicationJson_OcsInterfaceBuilder].
  $AvatarEmojiAvatarResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarEmojiAvatarResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarEmojiAvatarResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AvatarEmojiAvatarResponseApplicationJson_Ocs
    implements
        $AvatarEmojiAvatarResponseApplicationJson_OcsInterface,
        Built<AvatarEmojiAvatarResponseApplicationJson_Ocs, AvatarEmojiAvatarResponseApplicationJson_OcsBuilder> {
  /// Creates a new AvatarEmojiAvatarResponseApplicationJson_Ocs object using the builder pattern.
  factory AvatarEmojiAvatarResponseApplicationJson_Ocs([
    void Function(AvatarEmojiAvatarResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AvatarEmojiAvatarResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AvatarEmojiAvatarResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarEmojiAvatarResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarEmojiAvatarResponseApplicationJson_Ocs.
  static Serializer<AvatarEmojiAvatarResponseApplicationJson_Ocs> get serializer =>
      _$avatarEmojiAvatarResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarEmojiAvatarResponseApplicationJson_OcsBuilder b) {
    $AvatarEmojiAvatarResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarEmojiAvatarResponseApplicationJson_OcsBuilder b) {
    $AvatarEmojiAvatarResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AvatarEmojiAvatarResponseApplicationJsonInterface {
  AvatarEmojiAvatarResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarEmojiAvatarResponseApplicationJsonInterfaceBuilder].
  $AvatarEmojiAvatarResponseApplicationJsonInterface rebuild(
    void Function($AvatarEmojiAvatarResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AvatarEmojiAvatarResponseApplicationJsonInterfaceBuilder].
  $AvatarEmojiAvatarResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarEmojiAvatarResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarEmojiAvatarResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AvatarEmojiAvatarResponseApplicationJson
    implements
        $AvatarEmojiAvatarResponseApplicationJsonInterface,
        Built<AvatarEmojiAvatarResponseApplicationJson, AvatarEmojiAvatarResponseApplicationJsonBuilder> {
  /// Creates a new AvatarEmojiAvatarResponseApplicationJson object using the builder pattern.
  factory AvatarEmojiAvatarResponseApplicationJson([
    void Function(AvatarEmojiAvatarResponseApplicationJsonBuilder)? b,
  ]) = _$AvatarEmojiAvatarResponseApplicationJson;

  // coverage:ignore-start
  const AvatarEmojiAvatarResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarEmojiAvatarResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarEmojiAvatarResponseApplicationJson.
  static Serializer<AvatarEmojiAvatarResponseApplicationJson> get serializer =>
      _$avatarEmojiAvatarResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarEmojiAvatarResponseApplicationJsonBuilder b) {
    $AvatarEmojiAvatarResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarEmojiAvatarResponseApplicationJsonBuilder b) {
    $AvatarEmojiAvatarResponseApplicationJsonInterface._validate(b);
  }
}

class AvatarGetAvatarDarkApiVersion extends EnumClass {
  const AvatarGetAvatarDarkApiVersion._(super.name);

  /// `v1`
  static const AvatarGetAvatarDarkApiVersion v1 = _$avatarGetAvatarDarkApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetAvatarDarkApiVersion> get values => _$avatarGetAvatarDarkApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetAvatarDarkApiVersion valueOf(String name) => _$valueOfAvatarGetAvatarDarkApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarGetAvatarDarkApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetAvatarDarkApiVersion> get serializer => const _$AvatarGetAvatarDarkApiVersionSerializer();
}

class _$AvatarGetAvatarDarkApiVersionSerializer implements PrimitiveSerializer<AvatarGetAvatarDarkApiVersion> {
  const _$AvatarGetAvatarDarkApiVersionSerializer();

  static const Map<AvatarGetAvatarDarkApiVersion, Object> _toWire = <AvatarGetAvatarDarkApiVersion, Object>{
    AvatarGetAvatarDarkApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarGetAvatarDarkApiVersion> _fromWire = <Object, AvatarGetAvatarDarkApiVersion>{
    'v1': AvatarGetAvatarDarkApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetAvatarDarkApiVersion];

  @override
  String get wireName => 'AvatarGetAvatarDarkApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetAvatarDarkApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetAvatarDarkApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarWithoutRoomSize extends EnumClass {
  const AvatarGetUserProxyAvatarWithoutRoomSize._(super.name);

  /// `64`
  @BuiltValueEnumConst(wireName: '64')
  static const AvatarGetUserProxyAvatarWithoutRoomSize $64 = _$avatarGetUserProxyAvatarWithoutRoomSize$64;

  /// `512`
  @BuiltValueEnumConst(wireName: '512')
  static const AvatarGetUserProxyAvatarWithoutRoomSize $512 = _$avatarGetUserProxyAvatarWithoutRoomSize$512;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarWithoutRoomSize> get values =>
      _$avatarGetUserProxyAvatarWithoutRoomSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarWithoutRoomSize valueOf(String name) =>
      _$valueOfAvatarGetUserProxyAvatarWithoutRoomSize(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetUserProxyAvatarWithoutRoomSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarWithoutRoomSize> get serializer =>
      const _$AvatarGetUserProxyAvatarWithoutRoomSizeSerializer();
}

class _$AvatarGetUserProxyAvatarWithoutRoomSizeSerializer
    implements PrimitiveSerializer<AvatarGetUserProxyAvatarWithoutRoomSize> {
  const _$AvatarGetUserProxyAvatarWithoutRoomSizeSerializer();

  static const Map<AvatarGetUserProxyAvatarWithoutRoomSize, Object> _toWire =
      <AvatarGetUserProxyAvatarWithoutRoomSize, Object>{
    AvatarGetUserProxyAvatarWithoutRoomSize.$64: 64,
    AvatarGetUserProxyAvatarWithoutRoomSize.$512: 512,
  };

  static const Map<Object, AvatarGetUserProxyAvatarWithoutRoomSize> _fromWire =
      <Object, AvatarGetUserProxyAvatarWithoutRoomSize>{
    64: AvatarGetUserProxyAvatarWithoutRoomSize.$64,
    512: AvatarGetUserProxyAvatarWithoutRoomSize.$512,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarWithoutRoomSize];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarWithoutRoomSize';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarWithoutRoomSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarWithoutRoomSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarWithoutRoomApiVersion extends EnumClass {
  const AvatarGetUserProxyAvatarWithoutRoomApiVersion._(super.name);

  /// `v1`
  static const AvatarGetUserProxyAvatarWithoutRoomApiVersion v1 = _$avatarGetUserProxyAvatarWithoutRoomApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarWithoutRoomApiVersion> get values =>
      _$avatarGetUserProxyAvatarWithoutRoomApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarWithoutRoomApiVersion valueOf(String name) =>
      _$valueOfAvatarGetUserProxyAvatarWithoutRoomApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarGetUserProxyAvatarWithoutRoomApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarWithoutRoomApiVersion> get serializer =>
      const _$AvatarGetUserProxyAvatarWithoutRoomApiVersionSerializer();
}

class _$AvatarGetUserProxyAvatarWithoutRoomApiVersionSerializer
    implements PrimitiveSerializer<AvatarGetUserProxyAvatarWithoutRoomApiVersion> {
  const _$AvatarGetUserProxyAvatarWithoutRoomApiVersionSerializer();

  static const Map<AvatarGetUserProxyAvatarWithoutRoomApiVersion, Object> _toWire =
      <AvatarGetUserProxyAvatarWithoutRoomApiVersion, Object>{
    AvatarGetUserProxyAvatarWithoutRoomApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarGetUserProxyAvatarWithoutRoomApiVersion> _fromWire =
      <Object, AvatarGetUserProxyAvatarWithoutRoomApiVersion>{
    'v1': AvatarGetUserProxyAvatarWithoutRoomApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarWithoutRoomApiVersion];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarWithoutRoomApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarWithoutRoomApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarWithoutRoomApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarWithoutRoomDarkTheme extends EnumClass {
  const AvatarGetUserProxyAvatarWithoutRoomDarkTheme._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const AvatarGetUserProxyAvatarWithoutRoomDarkTheme $0 = _$avatarGetUserProxyAvatarWithoutRoomDarkTheme$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const AvatarGetUserProxyAvatarWithoutRoomDarkTheme $1 = _$avatarGetUserProxyAvatarWithoutRoomDarkTheme$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarWithoutRoomDarkTheme> get values =>
      _$avatarGetUserProxyAvatarWithoutRoomDarkThemeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarWithoutRoomDarkTheme valueOf(String name) =>
      _$valueOfAvatarGetUserProxyAvatarWithoutRoomDarkTheme(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetUserProxyAvatarWithoutRoomDarkTheme.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarWithoutRoomDarkTheme> get serializer =>
      const _$AvatarGetUserProxyAvatarWithoutRoomDarkThemeSerializer();
}

class _$AvatarGetUserProxyAvatarWithoutRoomDarkThemeSerializer
    implements PrimitiveSerializer<AvatarGetUserProxyAvatarWithoutRoomDarkTheme> {
  const _$AvatarGetUserProxyAvatarWithoutRoomDarkThemeSerializer();

  static const Map<AvatarGetUserProxyAvatarWithoutRoomDarkTheme, Object> _toWire =
      <AvatarGetUserProxyAvatarWithoutRoomDarkTheme, Object>{
    AvatarGetUserProxyAvatarWithoutRoomDarkTheme.$0: 0,
    AvatarGetUserProxyAvatarWithoutRoomDarkTheme.$1: 1,
  };

  static const Map<Object, AvatarGetUserProxyAvatarWithoutRoomDarkTheme> _fromWire =
      <Object, AvatarGetUserProxyAvatarWithoutRoomDarkTheme>{
    0: AvatarGetUserProxyAvatarWithoutRoomDarkTheme.$0,
    1: AvatarGetUserProxyAvatarWithoutRoomDarkTheme.$1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarWithoutRoomDarkTheme];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarWithoutRoomDarkTheme';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarWithoutRoomDarkTheme object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarWithoutRoomDarkTheme deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarDarkWithoutRoomSize extends EnumClass {
  const AvatarGetUserProxyAvatarDarkWithoutRoomSize._(super.name);

  /// `64`
  @BuiltValueEnumConst(wireName: '64')
  static const AvatarGetUserProxyAvatarDarkWithoutRoomSize $64 = _$avatarGetUserProxyAvatarDarkWithoutRoomSize$64;

  /// `512`
  @BuiltValueEnumConst(wireName: '512')
  static const AvatarGetUserProxyAvatarDarkWithoutRoomSize $512 = _$avatarGetUserProxyAvatarDarkWithoutRoomSize$512;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarDarkWithoutRoomSize> get values =>
      _$avatarGetUserProxyAvatarDarkWithoutRoomSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarDarkWithoutRoomSize valueOf(String name) =>
      _$valueOfAvatarGetUserProxyAvatarDarkWithoutRoomSize(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetUserProxyAvatarDarkWithoutRoomSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarDarkWithoutRoomSize> get serializer =>
      const _$AvatarGetUserProxyAvatarDarkWithoutRoomSizeSerializer();
}

class _$AvatarGetUserProxyAvatarDarkWithoutRoomSizeSerializer
    implements PrimitiveSerializer<AvatarGetUserProxyAvatarDarkWithoutRoomSize> {
  const _$AvatarGetUserProxyAvatarDarkWithoutRoomSizeSerializer();

  static const Map<AvatarGetUserProxyAvatarDarkWithoutRoomSize, Object> _toWire =
      <AvatarGetUserProxyAvatarDarkWithoutRoomSize, Object>{
    AvatarGetUserProxyAvatarDarkWithoutRoomSize.$64: 64,
    AvatarGetUserProxyAvatarDarkWithoutRoomSize.$512: 512,
  };

  static const Map<Object, AvatarGetUserProxyAvatarDarkWithoutRoomSize> _fromWire =
      <Object, AvatarGetUserProxyAvatarDarkWithoutRoomSize>{
    64: AvatarGetUserProxyAvatarDarkWithoutRoomSize.$64,
    512: AvatarGetUserProxyAvatarDarkWithoutRoomSize.$512,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarDarkWithoutRoomSize];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarDarkWithoutRoomSize';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarDarkWithoutRoomSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarDarkWithoutRoomSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion extends EnumClass {
  const AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion._(super.name);

  /// `v1`
  static const AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion v1 =
      _$avatarGetUserProxyAvatarDarkWithoutRoomApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion> get values =>
      _$avatarGetUserProxyAvatarDarkWithoutRoomApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion valueOf(String name) =>
      _$valueOfAvatarGetUserProxyAvatarDarkWithoutRoomApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion> get serializer =>
      const _$AvatarGetUserProxyAvatarDarkWithoutRoomApiVersionSerializer();
}

class _$AvatarGetUserProxyAvatarDarkWithoutRoomApiVersionSerializer
    implements PrimitiveSerializer<AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion> {
  const _$AvatarGetUserProxyAvatarDarkWithoutRoomApiVersionSerializer();

  static const Map<AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion, Object> _toWire =
      <AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion, Object>{
    AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion> _fromWire =
      <Object, AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion>{
    'v1': AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarDarkWithoutRoomApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarSize extends EnumClass {
  const AvatarGetUserProxyAvatarSize._(super.name);

  /// `64`
  @BuiltValueEnumConst(wireName: '64')
  static const AvatarGetUserProxyAvatarSize $64 = _$avatarGetUserProxyAvatarSize$64;

  /// `512`
  @BuiltValueEnumConst(wireName: '512')
  static const AvatarGetUserProxyAvatarSize $512 = _$avatarGetUserProxyAvatarSize$512;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarSize> get values => _$avatarGetUserProxyAvatarSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarSize valueOf(String name) => _$valueOfAvatarGetUserProxyAvatarSize(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetUserProxyAvatarSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarSize> get serializer => const _$AvatarGetUserProxyAvatarSizeSerializer();
}

class _$AvatarGetUserProxyAvatarSizeSerializer implements PrimitiveSerializer<AvatarGetUserProxyAvatarSize> {
  const _$AvatarGetUserProxyAvatarSizeSerializer();

  static const Map<AvatarGetUserProxyAvatarSize, Object> _toWire = <AvatarGetUserProxyAvatarSize, Object>{
    AvatarGetUserProxyAvatarSize.$64: 64,
    AvatarGetUserProxyAvatarSize.$512: 512,
  };

  static const Map<Object, AvatarGetUserProxyAvatarSize> _fromWire = <Object, AvatarGetUserProxyAvatarSize>{
    64: AvatarGetUserProxyAvatarSize.$64,
    512: AvatarGetUserProxyAvatarSize.$512,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarSize];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarSize';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarApiVersion extends EnumClass {
  const AvatarGetUserProxyAvatarApiVersion._(super.name);

  /// `v1`
  static const AvatarGetUserProxyAvatarApiVersion v1 = _$avatarGetUserProxyAvatarApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarApiVersion> get values => _$avatarGetUserProxyAvatarApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarApiVersion valueOf(String name) => _$valueOfAvatarGetUserProxyAvatarApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarGetUserProxyAvatarApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarApiVersion> get serializer =>
      const _$AvatarGetUserProxyAvatarApiVersionSerializer();
}

class _$AvatarGetUserProxyAvatarApiVersionSerializer
    implements PrimitiveSerializer<AvatarGetUserProxyAvatarApiVersion> {
  const _$AvatarGetUserProxyAvatarApiVersionSerializer();

  static const Map<AvatarGetUserProxyAvatarApiVersion, Object> _toWire = <AvatarGetUserProxyAvatarApiVersion, Object>{
    AvatarGetUserProxyAvatarApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarGetUserProxyAvatarApiVersion> _fromWire = <Object, AvatarGetUserProxyAvatarApiVersion>{
    'v1': AvatarGetUserProxyAvatarApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarApiVersion];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarDarkTheme extends EnumClass {
  const AvatarGetUserProxyAvatarDarkTheme._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const AvatarGetUserProxyAvatarDarkTheme $0 = _$avatarGetUserProxyAvatarDarkTheme$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const AvatarGetUserProxyAvatarDarkTheme $1 = _$avatarGetUserProxyAvatarDarkTheme$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarDarkTheme> get values => _$avatarGetUserProxyAvatarDarkThemeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarDarkTheme valueOf(String name) => _$valueOfAvatarGetUserProxyAvatarDarkTheme(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetUserProxyAvatarDarkTheme.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarDarkTheme> get serializer =>
      const _$AvatarGetUserProxyAvatarDarkThemeSerializer();
}

class _$AvatarGetUserProxyAvatarDarkThemeSerializer implements PrimitiveSerializer<AvatarGetUserProxyAvatarDarkTheme> {
  const _$AvatarGetUserProxyAvatarDarkThemeSerializer();

  static const Map<AvatarGetUserProxyAvatarDarkTheme, Object> _toWire = <AvatarGetUserProxyAvatarDarkTheme, Object>{
    AvatarGetUserProxyAvatarDarkTheme.$0: 0,
    AvatarGetUserProxyAvatarDarkTheme.$1: 1,
  };

  static const Map<Object, AvatarGetUserProxyAvatarDarkTheme> _fromWire = <Object, AvatarGetUserProxyAvatarDarkTheme>{
    0: AvatarGetUserProxyAvatarDarkTheme.$0,
    1: AvatarGetUserProxyAvatarDarkTheme.$1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarDarkTheme];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarDarkTheme';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarDarkTheme object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarDarkTheme deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarDarkSize extends EnumClass {
  const AvatarGetUserProxyAvatarDarkSize._(super.name);

  /// `64`
  @BuiltValueEnumConst(wireName: '64')
  static const AvatarGetUserProxyAvatarDarkSize $64 = _$avatarGetUserProxyAvatarDarkSize$64;

  /// `512`
  @BuiltValueEnumConst(wireName: '512')
  static const AvatarGetUserProxyAvatarDarkSize $512 = _$avatarGetUserProxyAvatarDarkSize$512;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarDarkSize> get values => _$avatarGetUserProxyAvatarDarkSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarDarkSize valueOf(String name) => _$valueOfAvatarGetUserProxyAvatarDarkSize(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetUserProxyAvatarDarkSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarDarkSize> get serializer =>
      const _$AvatarGetUserProxyAvatarDarkSizeSerializer();
}

class _$AvatarGetUserProxyAvatarDarkSizeSerializer implements PrimitiveSerializer<AvatarGetUserProxyAvatarDarkSize> {
  const _$AvatarGetUserProxyAvatarDarkSizeSerializer();

  static const Map<AvatarGetUserProxyAvatarDarkSize, Object> _toWire = <AvatarGetUserProxyAvatarDarkSize, Object>{
    AvatarGetUserProxyAvatarDarkSize.$64: 64,
    AvatarGetUserProxyAvatarDarkSize.$512: 512,
  };

  static const Map<Object, AvatarGetUserProxyAvatarDarkSize> _fromWire = <Object, AvatarGetUserProxyAvatarDarkSize>{
    64: AvatarGetUserProxyAvatarDarkSize.$64,
    512: AvatarGetUserProxyAvatarDarkSize.$512,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarDarkSize];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarDarkSize';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarDarkSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarDarkSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetUserProxyAvatarDarkApiVersion extends EnumClass {
  const AvatarGetUserProxyAvatarDarkApiVersion._(super.name);

  /// `v1`
  static const AvatarGetUserProxyAvatarDarkApiVersion v1 = _$avatarGetUserProxyAvatarDarkApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetUserProxyAvatarDarkApiVersion> get values => _$avatarGetUserProxyAvatarDarkApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetUserProxyAvatarDarkApiVersion valueOf(String name) =>
      _$valueOfAvatarGetUserProxyAvatarDarkApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for AvatarGetUserProxyAvatarDarkApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetUserProxyAvatarDarkApiVersion> get serializer =>
      const _$AvatarGetUserProxyAvatarDarkApiVersionSerializer();
}

class _$AvatarGetUserProxyAvatarDarkApiVersionSerializer
    implements PrimitiveSerializer<AvatarGetUserProxyAvatarDarkApiVersion> {
  const _$AvatarGetUserProxyAvatarDarkApiVersionSerializer();

  static const Map<AvatarGetUserProxyAvatarDarkApiVersion, Object> _toWire =
      <AvatarGetUserProxyAvatarDarkApiVersion, Object>{
    AvatarGetUserProxyAvatarDarkApiVersion.v1: 'v1',
  };

  static const Map<Object, AvatarGetUserProxyAvatarDarkApiVersion> _fromWire =
      <Object, AvatarGetUserProxyAvatarDarkApiVersion>{
    'v1': AvatarGetUserProxyAvatarDarkApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetUserProxyAvatarDarkApiVersion];

  @override
  String get wireName => 'AvatarGetUserProxyAvatarDarkApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetUserProxyAvatarDarkApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetUserProxyAvatarDarkApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class BanListBansApiVersion extends EnumClass {
  const BanListBansApiVersion._(super.name);

  /// `v1`
  static const BanListBansApiVersion v1 = _$banListBansApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BanListBansApiVersion> get values => _$banListBansApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BanListBansApiVersion valueOf(String name) => _$valueOfBanListBansApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BanListBansApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BanListBansApiVersion> get serializer => const _$BanListBansApiVersionSerializer();
}

class _$BanListBansApiVersionSerializer implements PrimitiveSerializer<BanListBansApiVersion> {
  const _$BanListBansApiVersionSerializer();

  static const Map<BanListBansApiVersion, Object> _toWire = <BanListBansApiVersion, Object>{
    BanListBansApiVersion.v1: 'v1',
  };

  static const Map<Object, BanListBansApiVersion> _fromWire = <Object, BanListBansApiVersion>{
    'v1': BanListBansApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BanListBansApiVersion];

  @override
  String get wireName => 'BanListBansApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BanListBansApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BanListBansApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BanInterface {
  int get id;
  String get moderatorActorType;
  String get moderatorActorId;
  String get moderatorDisplayName;
  String get bannedActorType;
  String get bannedActorId;
  String get bannedDisplayName;
  int get bannedTime;
  String get internalNote;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BanInterfaceBuilder].
  $BanInterface rebuild(void Function($BanInterfaceBuilder) updates);

  /// Converts the instance to a builder [$BanInterfaceBuilder].
  $BanInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BanInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BanInterfaceBuilder b) {}
}

abstract class Ban implements $BanInterface, Built<Ban, BanBuilder> {
  /// Creates a new Ban object using the builder pattern.
  factory Ban([void Function(BanBuilder)? b]) = _$Ban;

  // coverage:ignore-start
  const Ban._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Ban.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Ban.
  static Serializer<Ban> get serializer => _$banSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BanBuilder b) {
    $BanInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BanBuilder b) {
    $BanInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BanListBansResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Ban> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BanListBansResponseApplicationJson_OcsInterfaceBuilder].
  $BanListBansResponseApplicationJson_OcsInterface rebuild(
    void Function($BanListBansResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BanListBansResponseApplicationJson_OcsInterfaceBuilder].
  $BanListBansResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BanListBansResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BanListBansResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BanListBansResponseApplicationJson_Ocs
    implements
        $BanListBansResponseApplicationJson_OcsInterface,
        Built<BanListBansResponseApplicationJson_Ocs, BanListBansResponseApplicationJson_OcsBuilder> {
  /// Creates a new BanListBansResponseApplicationJson_Ocs object using the builder pattern.
  factory BanListBansResponseApplicationJson_Ocs([void Function(BanListBansResponseApplicationJson_OcsBuilder)? b]) =
      _$BanListBansResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BanListBansResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BanListBansResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BanListBansResponseApplicationJson_Ocs.
  static Serializer<BanListBansResponseApplicationJson_Ocs> get serializer =>
      _$banListBansResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BanListBansResponseApplicationJson_OcsBuilder b) {
    $BanListBansResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BanListBansResponseApplicationJson_OcsBuilder b) {
    $BanListBansResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BanListBansResponseApplicationJsonInterface {
  BanListBansResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BanListBansResponseApplicationJsonInterfaceBuilder].
  $BanListBansResponseApplicationJsonInterface rebuild(
    void Function($BanListBansResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BanListBansResponseApplicationJsonInterfaceBuilder].
  $BanListBansResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BanListBansResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BanListBansResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BanListBansResponseApplicationJson
    implements
        $BanListBansResponseApplicationJsonInterface,
        Built<BanListBansResponseApplicationJson, BanListBansResponseApplicationJsonBuilder> {
  /// Creates a new BanListBansResponseApplicationJson object using the builder pattern.
  factory BanListBansResponseApplicationJson([void Function(BanListBansResponseApplicationJsonBuilder)? b]) =
      _$BanListBansResponseApplicationJson;

  // coverage:ignore-start
  const BanListBansResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BanListBansResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BanListBansResponseApplicationJson.
  static Serializer<BanListBansResponseApplicationJson> get serializer =>
      _$banListBansResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BanListBansResponseApplicationJsonBuilder b) {
    $BanListBansResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BanListBansResponseApplicationJsonBuilder b) {
    $BanListBansResponseApplicationJsonInterface._validate(b);
  }
}

class BanBanActorApiVersion extends EnumClass {
  const BanBanActorApiVersion._(super.name);

  /// `v1`
  static const BanBanActorApiVersion v1 = _$banBanActorApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BanBanActorApiVersion> get values => _$banBanActorApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BanBanActorApiVersion valueOf(String name) => _$valueOfBanBanActorApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BanBanActorApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BanBanActorApiVersion> get serializer => const _$BanBanActorApiVersionSerializer();
}

class _$BanBanActorApiVersionSerializer implements PrimitiveSerializer<BanBanActorApiVersion> {
  const _$BanBanActorApiVersionSerializer();

  static const Map<BanBanActorApiVersion, Object> _toWire = <BanBanActorApiVersion, Object>{
    BanBanActorApiVersion.v1: 'v1',
  };

  static const Map<Object, BanBanActorApiVersion> _fromWire = <Object, BanBanActorApiVersion>{
    'v1': BanBanActorApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BanBanActorApiVersion];

  @override
  String get wireName => 'BanBanActorApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BanBanActorApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BanBanActorApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// Type of actor to ban, or `ip` when banning a clients remote address.
class BanBanActorRequestApplicationJson_ActorType extends EnumClass {
  const BanBanActorRequestApplicationJson_ActorType._(super.name);

  /// `users`
  static const BanBanActorRequestApplicationJson_ActorType users = _$banBanActorRequestApplicationJsonActorTypeUsers;

  /// `guests`
  static const BanBanActorRequestApplicationJson_ActorType guests = _$banBanActorRequestApplicationJsonActorTypeGuests;

  /// `ip`
  static const BanBanActorRequestApplicationJson_ActorType ip = _$banBanActorRequestApplicationJsonActorTypeIp;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BanBanActorRequestApplicationJson_ActorType> get values =>
      _$banBanActorRequestApplicationJsonActorTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BanBanActorRequestApplicationJson_ActorType valueOf(String name) =>
      _$valueOfBanBanActorRequestApplicationJson_ActorType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BanBanActorRequestApplicationJson_ActorType.
  @BuiltValueSerializer(custom: true)
  static Serializer<BanBanActorRequestApplicationJson_ActorType> get serializer =>
      const _$BanBanActorRequestApplicationJson_ActorTypeSerializer();
}

class _$BanBanActorRequestApplicationJson_ActorTypeSerializer
    implements PrimitiveSerializer<BanBanActorRequestApplicationJson_ActorType> {
  const _$BanBanActorRequestApplicationJson_ActorTypeSerializer();

  static const Map<BanBanActorRequestApplicationJson_ActorType, Object> _toWire =
      <BanBanActorRequestApplicationJson_ActorType, Object>{
    BanBanActorRequestApplicationJson_ActorType.users: 'users',
    BanBanActorRequestApplicationJson_ActorType.guests: 'guests',
    BanBanActorRequestApplicationJson_ActorType.ip: 'ip',
  };

  static const Map<Object, BanBanActorRequestApplicationJson_ActorType> _fromWire =
      <Object, BanBanActorRequestApplicationJson_ActorType>{
    'users': BanBanActorRequestApplicationJson_ActorType.users,
    'guests': BanBanActorRequestApplicationJson_ActorType.guests,
    'ip': BanBanActorRequestApplicationJson_ActorType.ip,
  };

  @override
  Iterable<Type> get types => const [BanBanActorRequestApplicationJson_ActorType];

  @override
  String get wireName => 'BanBanActorRequestApplicationJson_ActorType';

  @override
  Object serialize(
    Serializers serializers,
    BanBanActorRequestApplicationJson_ActorType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BanBanActorRequestApplicationJson_ActorType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BanBanActorRequestApplicationJsonInterface {
  static final _$internalNote = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// Type of actor to ban, or `ip` when banning a clients remote address.
  BanBanActorRequestApplicationJson_ActorType get actorType;

  /// Actor ID or the IP address or range in case of type `ip`.
  String get actorId;

  /// Optional internal note (max. 4000 characters).
  String get internalNote;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BanBanActorRequestApplicationJsonInterfaceBuilder].
  $BanBanActorRequestApplicationJsonInterface rebuild(
    void Function($BanBanActorRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BanBanActorRequestApplicationJsonInterfaceBuilder].
  $BanBanActorRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BanBanActorRequestApplicationJsonInterfaceBuilder b) {
    b.internalNote = _$internalNote;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BanBanActorRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class BanBanActorRequestApplicationJson
    implements
        $BanBanActorRequestApplicationJsonInterface,
        Built<BanBanActorRequestApplicationJson, BanBanActorRequestApplicationJsonBuilder> {
  /// Creates a new BanBanActorRequestApplicationJson object using the builder pattern.
  factory BanBanActorRequestApplicationJson([void Function(BanBanActorRequestApplicationJsonBuilder)? b]) =
      _$BanBanActorRequestApplicationJson;

  // coverage:ignore-start
  const BanBanActorRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BanBanActorRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BanBanActorRequestApplicationJson.
  static Serializer<BanBanActorRequestApplicationJson> get serializer => _$banBanActorRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BanBanActorRequestApplicationJsonBuilder b) {
    $BanBanActorRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BanBanActorRequestApplicationJsonBuilder b) {
    $BanBanActorRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BanBanActorResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Ban get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BanBanActorResponseApplicationJson_OcsInterfaceBuilder].
  $BanBanActorResponseApplicationJson_OcsInterface rebuild(
    void Function($BanBanActorResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BanBanActorResponseApplicationJson_OcsInterfaceBuilder].
  $BanBanActorResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BanBanActorResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BanBanActorResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BanBanActorResponseApplicationJson_Ocs
    implements
        $BanBanActorResponseApplicationJson_OcsInterface,
        Built<BanBanActorResponseApplicationJson_Ocs, BanBanActorResponseApplicationJson_OcsBuilder> {
  /// Creates a new BanBanActorResponseApplicationJson_Ocs object using the builder pattern.
  factory BanBanActorResponseApplicationJson_Ocs([void Function(BanBanActorResponseApplicationJson_OcsBuilder)? b]) =
      _$BanBanActorResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BanBanActorResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BanBanActorResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BanBanActorResponseApplicationJson_Ocs.
  static Serializer<BanBanActorResponseApplicationJson_Ocs> get serializer =>
      _$banBanActorResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BanBanActorResponseApplicationJson_OcsBuilder b) {
    $BanBanActorResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BanBanActorResponseApplicationJson_OcsBuilder b) {
    $BanBanActorResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BanBanActorResponseApplicationJsonInterface {
  BanBanActorResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BanBanActorResponseApplicationJsonInterfaceBuilder].
  $BanBanActorResponseApplicationJsonInterface rebuild(
    void Function($BanBanActorResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BanBanActorResponseApplicationJsonInterfaceBuilder].
  $BanBanActorResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BanBanActorResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BanBanActorResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BanBanActorResponseApplicationJson
    implements
        $BanBanActorResponseApplicationJsonInterface,
        Built<BanBanActorResponseApplicationJson, BanBanActorResponseApplicationJsonBuilder> {
  /// Creates a new BanBanActorResponseApplicationJson object using the builder pattern.
  factory BanBanActorResponseApplicationJson([void Function(BanBanActorResponseApplicationJsonBuilder)? b]) =
      _$BanBanActorResponseApplicationJson;

  // coverage:ignore-start
  const BanBanActorResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BanBanActorResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BanBanActorResponseApplicationJson.
  static Serializer<BanBanActorResponseApplicationJson> get serializer =>
      _$banBanActorResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BanBanActorResponseApplicationJsonBuilder b) {
    $BanBanActorResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BanBanActorResponseApplicationJsonBuilder b) {
    $BanBanActorResponseApplicationJsonInterface._validate(b);
  }
}

class BanUnbanActorApiVersion extends EnumClass {
  const BanUnbanActorApiVersion._(super.name);

  /// `v1`
  static const BanUnbanActorApiVersion v1 = _$banUnbanActorApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BanUnbanActorApiVersion> get values => _$banUnbanActorApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BanUnbanActorApiVersion valueOf(String name) => _$valueOfBanUnbanActorApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BanUnbanActorApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BanUnbanActorApiVersion> get serializer => const _$BanUnbanActorApiVersionSerializer();
}

class _$BanUnbanActorApiVersionSerializer implements PrimitiveSerializer<BanUnbanActorApiVersion> {
  const _$BanUnbanActorApiVersionSerializer();

  static const Map<BanUnbanActorApiVersion, Object> _toWire = <BanUnbanActorApiVersion, Object>{
    BanUnbanActorApiVersion.v1: 'v1',
  };

  static const Map<Object, BanUnbanActorApiVersion> _fromWire = <Object, BanUnbanActorApiVersion>{
    'v1': BanUnbanActorApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BanUnbanActorApiVersion];

  @override
  String get wireName => 'BanUnbanActorApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BanUnbanActorApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BanUnbanActorApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BanUnbanActorResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BanUnbanActorResponseApplicationJson_OcsInterfaceBuilder].
  $BanUnbanActorResponseApplicationJson_OcsInterface rebuild(
    void Function($BanUnbanActorResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BanUnbanActorResponseApplicationJson_OcsInterfaceBuilder].
  $BanUnbanActorResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BanUnbanActorResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BanUnbanActorResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BanUnbanActorResponseApplicationJson_Ocs
    implements
        $BanUnbanActorResponseApplicationJson_OcsInterface,
        Built<BanUnbanActorResponseApplicationJson_Ocs, BanUnbanActorResponseApplicationJson_OcsBuilder> {
  /// Creates a new BanUnbanActorResponseApplicationJson_Ocs object using the builder pattern.
  factory BanUnbanActorResponseApplicationJson_Ocs([
    void Function(BanUnbanActorResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BanUnbanActorResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BanUnbanActorResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BanUnbanActorResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BanUnbanActorResponseApplicationJson_Ocs.
  static Serializer<BanUnbanActorResponseApplicationJson_Ocs> get serializer =>
      _$banUnbanActorResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BanUnbanActorResponseApplicationJson_OcsBuilder b) {
    $BanUnbanActorResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BanUnbanActorResponseApplicationJson_OcsBuilder b) {
    $BanUnbanActorResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BanUnbanActorResponseApplicationJsonInterface {
  BanUnbanActorResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BanUnbanActorResponseApplicationJsonInterfaceBuilder].
  $BanUnbanActorResponseApplicationJsonInterface rebuild(
    void Function($BanUnbanActorResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BanUnbanActorResponseApplicationJsonInterfaceBuilder].
  $BanUnbanActorResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BanUnbanActorResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BanUnbanActorResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BanUnbanActorResponseApplicationJson
    implements
        $BanUnbanActorResponseApplicationJsonInterface,
        Built<BanUnbanActorResponseApplicationJson, BanUnbanActorResponseApplicationJsonBuilder> {
  /// Creates a new BanUnbanActorResponseApplicationJson object using the builder pattern.
  factory BanUnbanActorResponseApplicationJson([void Function(BanUnbanActorResponseApplicationJsonBuilder)? b]) =
      _$BanUnbanActorResponseApplicationJson;

  // coverage:ignore-start
  const BanUnbanActorResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BanUnbanActorResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BanUnbanActorResponseApplicationJson.
  static Serializer<BanUnbanActorResponseApplicationJson> get serializer =>
      _$banUnbanActorResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BanUnbanActorResponseApplicationJsonBuilder b) {
    $BanUnbanActorResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BanUnbanActorResponseApplicationJsonBuilder b) {
    $BanUnbanActorResponseApplicationJsonInterface._validate(b);
  }
}

class BotListBotsApiVersion extends EnumClass {
  const BotListBotsApiVersion._(super.name);

  /// `v1`
  static const BotListBotsApiVersion v1 = _$botListBotsApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BotListBotsApiVersion> get values => _$botListBotsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BotListBotsApiVersion valueOf(String name) => _$valueOfBotListBotsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BotListBotsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BotListBotsApiVersion> get serializer => const _$BotListBotsApiVersionSerializer();
}

class _$BotListBotsApiVersionSerializer implements PrimitiveSerializer<BotListBotsApiVersion> {
  const _$BotListBotsApiVersionSerializer();

  static const Map<BotListBotsApiVersion, Object> _toWire = <BotListBotsApiVersion, Object>{
    BotListBotsApiVersion.v1: 'v1',
  };

  static const Map<Object, BotListBotsApiVersion> _fromWire = <Object, BotListBotsApiVersion>{
    'v1': BotListBotsApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BotListBotsApiVersion];

  @override
  String get wireName => 'BotListBotsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BotListBotsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BotListBotsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BotInterface {
  String? get description;
  int get id;
  String get name;
  int get state;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotInterfaceBuilder].
  $BotInterface rebuild(void Function($BotInterfaceBuilder) updates);

  /// Converts the instance to a builder [$BotInterfaceBuilder].
  $BotInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotInterfaceBuilder b) {}
}

abstract class Bot implements $BotInterface, Built<Bot, BotBuilder> {
  /// Creates a new Bot object using the builder pattern.
  factory Bot([void Function(BotBuilder)? b]) = _$Bot;

  // coverage:ignore-start
  const Bot._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Bot.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Bot.
  static Serializer<Bot> get serializer => _$botSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotBuilder b) {
    $BotInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotBuilder b) {
    $BotInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotListBotsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Bot> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotListBotsResponseApplicationJson_OcsInterfaceBuilder].
  $BotListBotsResponseApplicationJson_OcsInterface rebuild(
    void Function($BotListBotsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotListBotsResponseApplicationJson_OcsInterfaceBuilder].
  $BotListBotsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotListBotsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotListBotsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BotListBotsResponseApplicationJson_Ocs
    implements
        $BotListBotsResponseApplicationJson_OcsInterface,
        Built<BotListBotsResponseApplicationJson_Ocs, BotListBotsResponseApplicationJson_OcsBuilder> {
  /// Creates a new BotListBotsResponseApplicationJson_Ocs object using the builder pattern.
  factory BotListBotsResponseApplicationJson_Ocs([void Function(BotListBotsResponseApplicationJson_OcsBuilder)? b]) =
      _$BotListBotsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BotListBotsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotListBotsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotListBotsResponseApplicationJson_Ocs.
  static Serializer<BotListBotsResponseApplicationJson_Ocs> get serializer =>
      _$botListBotsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotListBotsResponseApplicationJson_OcsBuilder b) {
    $BotListBotsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotListBotsResponseApplicationJson_OcsBuilder b) {
    $BotListBotsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotListBotsResponseApplicationJsonInterface {
  BotListBotsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotListBotsResponseApplicationJsonInterfaceBuilder].
  $BotListBotsResponseApplicationJsonInterface rebuild(
    void Function($BotListBotsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotListBotsResponseApplicationJsonInterfaceBuilder].
  $BotListBotsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotListBotsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotListBotsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BotListBotsResponseApplicationJson
    implements
        $BotListBotsResponseApplicationJsonInterface,
        Built<BotListBotsResponseApplicationJson, BotListBotsResponseApplicationJsonBuilder> {
  /// Creates a new BotListBotsResponseApplicationJson object using the builder pattern.
  factory BotListBotsResponseApplicationJson([void Function(BotListBotsResponseApplicationJsonBuilder)? b]) =
      _$BotListBotsResponseApplicationJson;

  // coverage:ignore-start
  const BotListBotsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotListBotsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotListBotsResponseApplicationJson.
  static Serializer<BotListBotsResponseApplicationJson> get serializer =>
      _$botListBotsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotListBotsResponseApplicationJsonBuilder b) {
    $BotListBotsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotListBotsResponseApplicationJsonBuilder b) {
    $BotListBotsResponseApplicationJsonInterface._validate(b);
  }
}

class BotEnableBotApiVersion extends EnumClass {
  const BotEnableBotApiVersion._(super.name);

  /// `v1`
  static const BotEnableBotApiVersion v1 = _$botEnableBotApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BotEnableBotApiVersion> get values => _$botEnableBotApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BotEnableBotApiVersion valueOf(String name) => _$valueOfBotEnableBotApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BotEnableBotApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BotEnableBotApiVersion> get serializer => const _$BotEnableBotApiVersionSerializer();
}

class _$BotEnableBotApiVersionSerializer implements PrimitiveSerializer<BotEnableBotApiVersion> {
  const _$BotEnableBotApiVersionSerializer();

  static const Map<BotEnableBotApiVersion, Object> _toWire = <BotEnableBotApiVersion, Object>{
    BotEnableBotApiVersion.v1: 'v1',
  };

  static const Map<Object, BotEnableBotApiVersion> _fromWire = <Object, BotEnableBotApiVersion>{
    'v1': BotEnableBotApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BotEnableBotApiVersion];

  @override
  String get wireName => 'BotEnableBotApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BotEnableBotApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BotEnableBotApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BotEnableBotResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Bot? get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotEnableBotResponseApplicationJson_OcsInterfaceBuilder].
  $BotEnableBotResponseApplicationJson_OcsInterface rebuild(
    void Function($BotEnableBotResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotEnableBotResponseApplicationJson_OcsInterfaceBuilder].
  $BotEnableBotResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotEnableBotResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotEnableBotResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BotEnableBotResponseApplicationJson_Ocs
    implements
        $BotEnableBotResponseApplicationJson_OcsInterface,
        Built<BotEnableBotResponseApplicationJson_Ocs, BotEnableBotResponseApplicationJson_OcsBuilder> {
  /// Creates a new BotEnableBotResponseApplicationJson_Ocs object using the builder pattern.
  factory BotEnableBotResponseApplicationJson_Ocs([void Function(BotEnableBotResponseApplicationJson_OcsBuilder)? b]) =
      _$BotEnableBotResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BotEnableBotResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotEnableBotResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotEnableBotResponseApplicationJson_Ocs.
  static Serializer<BotEnableBotResponseApplicationJson_Ocs> get serializer =>
      _$botEnableBotResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotEnableBotResponseApplicationJson_OcsBuilder b) {
    $BotEnableBotResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotEnableBotResponseApplicationJson_OcsBuilder b) {
    $BotEnableBotResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotEnableBotResponseApplicationJsonInterface {
  BotEnableBotResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotEnableBotResponseApplicationJsonInterfaceBuilder].
  $BotEnableBotResponseApplicationJsonInterface rebuild(
    void Function($BotEnableBotResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotEnableBotResponseApplicationJsonInterfaceBuilder].
  $BotEnableBotResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotEnableBotResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotEnableBotResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BotEnableBotResponseApplicationJson
    implements
        $BotEnableBotResponseApplicationJsonInterface,
        Built<BotEnableBotResponseApplicationJson, BotEnableBotResponseApplicationJsonBuilder> {
  /// Creates a new BotEnableBotResponseApplicationJson object using the builder pattern.
  factory BotEnableBotResponseApplicationJson([void Function(BotEnableBotResponseApplicationJsonBuilder)? b]) =
      _$BotEnableBotResponseApplicationJson;

  // coverage:ignore-start
  const BotEnableBotResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotEnableBotResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotEnableBotResponseApplicationJson.
  static Serializer<BotEnableBotResponseApplicationJson> get serializer =>
      _$botEnableBotResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotEnableBotResponseApplicationJsonBuilder b) {
    $BotEnableBotResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotEnableBotResponseApplicationJsonBuilder b) {
    $BotEnableBotResponseApplicationJsonInterface._validate(b);
  }
}

class BotDisableBotApiVersion extends EnumClass {
  const BotDisableBotApiVersion._(super.name);

  /// `v1`
  static const BotDisableBotApiVersion v1 = _$botDisableBotApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BotDisableBotApiVersion> get values => _$botDisableBotApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BotDisableBotApiVersion valueOf(String name) => _$valueOfBotDisableBotApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BotDisableBotApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BotDisableBotApiVersion> get serializer => const _$BotDisableBotApiVersionSerializer();
}

class _$BotDisableBotApiVersionSerializer implements PrimitiveSerializer<BotDisableBotApiVersion> {
  const _$BotDisableBotApiVersionSerializer();

  static const Map<BotDisableBotApiVersion, Object> _toWire = <BotDisableBotApiVersion, Object>{
    BotDisableBotApiVersion.v1: 'v1',
  };

  static const Map<Object, BotDisableBotApiVersion> _fromWire = <Object, BotDisableBotApiVersion>{
    'v1': BotDisableBotApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BotDisableBotApiVersion];

  @override
  String get wireName => 'BotDisableBotApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BotDisableBotApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BotDisableBotApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BotDisableBotResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Bot? get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotDisableBotResponseApplicationJson_OcsInterfaceBuilder].
  $BotDisableBotResponseApplicationJson_OcsInterface rebuild(
    void Function($BotDisableBotResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotDisableBotResponseApplicationJson_OcsInterfaceBuilder].
  $BotDisableBotResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotDisableBotResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotDisableBotResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BotDisableBotResponseApplicationJson_Ocs
    implements
        $BotDisableBotResponseApplicationJson_OcsInterface,
        Built<BotDisableBotResponseApplicationJson_Ocs, BotDisableBotResponseApplicationJson_OcsBuilder> {
  /// Creates a new BotDisableBotResponseApplicationJson_Ocs object using the builder pattern.
  factory BotDisableBotResponseApplicationJson_Ocs([
    void Function(BotDisableBotResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BotDisableBotResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BotDisableBotResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotDisableBotResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotDisableBotResponseApplicationJson_Ocs.
  static Serializer<BotDisableBotResponseApplicationJson_Ocs> get serializer =>
      _$botDisableBotResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotDisableBotResponseApplicationJson_OcsBuilder b) {
    $BotDisableBotResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotDisableBotResponseApplicationJson_OcsBuilder b) {
    $BotDisableBotResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotDisableBotResponseApplicationJsonInterface {
  BotDisableBotResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotDisableBotResponseApplicationJsonInterfaceBuilder].
  $BotDisableBotResponseApplicationJsonInterface rebuild(
    void Function($BotDisableBotResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotDisableBotResponseApplicationJsonInterfaceBuilder].
  $BotDisableBotResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotDisableBotResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotDisableBotResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BotDisableBotResponseApplicationJson
    implements
        $BotDisableBotResponseApplicationJsonInterface,
        Built<BotDisableBotResponseApplicationJson, BotDisableBotResponseApplicationJsonBuilder> {
  /// Creates a new BotDisableBotResponseApplicationJson object using the builder pattern.
  factory BotDisableBotResponseApplicationJson([void Function(BotDisableBotResponseApplicationJsonBuilder)? b]) =
      _$BotDisableBotResponseApplicationJson;

  // coverage:ignore-start
  const BotDisableBotResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotDisableBotResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotDisableBotResponseApplicationJson.
  static Serializer<BotDisableBotResponseApplicationJson> get serializer =>
      _$botDisableBotResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotDisableBotResponseApplicationJsonBuilder b) {
    $BotDisableBotResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotDisableBotResponseApplicationJsonBuilder b) {
    $BotDisableBotResponseApplicationJsonInterface._validate(b);
  }
}

class BotSendMessageApiVersion extends EnumClass {
  const BotSendMessageApiVersion._(super.name);

  /// `v1`
  static const BotSendMessageApiVersion v1 = _$botSendMessageApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BotSendMessageApiVersion> get values => _$botSendMessageApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BotSendMessageApiVersion valueOf(String name) => _$valueOfBotSendMessageApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BotSendMessageApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BotSendMessageApiVersion> get serializer => const _$BotSendMessageApiVersionSerializer();
}

class _$BotSendMessageApiVersionSerializer implements PrimitiveSerializer<BotSendMessageApiVersion> {
  const _$BotSendMessageApiVersionSerializer();

  static const Map<BotSendMessageApiVersion, Object> _toWire = <BotSendMessageApiVersion, Object>{
    BotSendMessageApiVersion.v1: 'v1',
  };

  static const Map<Object, BotSendMessageApiVersion> _fromWire = <Object, BotSendMessageApiVersion>{
    'v1': BotSendMessageApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BotSendMessageApiVersion];

  @override
  String get wireName => 'BotSendMessageApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BotSendMessageApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BotSendMessageApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BotSendMessageRequestApplicationJsonInterface {
  static final _$referenceId = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$replyTo = _$jsonSerializers.deserialize(
    0,
    specifiedType: const FullType(int),
  )! as int;

  static final _$silent = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  /// The message to send.
  String get message;

  /// For the message to be able to later identify it again.
  String get referenceId;

  /// Parent id which this message is a reply to.
  int get replyTo;

  /// If sent silent the chat message will not create any notifications.
  bool get silent;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotSendMessageRequestApplicationJsonInterfaceBuilder].
  $BotSendMessageRequestApplicationJsonInterface rebuild(
    void Function($BotSendMessageRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotSendMessageRequestApplicationJsonInterfaceBuilder].
  $BotSendMessageRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotSendMessageRequestApplicationJsonInterfaceBuilder b) {
    b.referenceId = _$referenceId;
    b.replyTo = _$replyTo;
    b.silent = _$silent;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotSendMessageRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class BotSendMessageRequestApplicationJson
    implements
        $BotSendMessageRequestApplicationJsonInterface,
        Built<BotSendMessageRequestApplicationJson, BotSendMessageRequestApplicationJsonBuilder> {
  /// Creates a new BotSendMessageRequestApplicationJson object using the builder pattern.
  factory BotSendMessageRequestApplicationJson([void Function(BotSendMessageRequestApplicationJsonBuilder)? b]) =
      _$BotSendMessageRequestApplicationJson;

  // coverage:ignore-start
  const BotSendMessageRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotSendMessageRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotSendMessageRequestApplicationJson.
  static Serializer<BotSendMessageRequestApplicationJson> get serializer =>
      _$botSendMessageRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotSendMessageRequestApplicationJsonBuilder b) {
    $BotSendMessageRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotSendMessageRequestApplicationJsonBuilder b) {
    $BotSendMessageRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotSendMessageResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotSendMessageResponseApplicationJson_OcsInterfaceBuilder].
  $BotSendMessageResponseApplicationJson_OcsInterface rebuild(
    void Function($BotSendMessageResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotSendMessageResponseApplicationJson_OcsInterfaceBuilder].
  $BotSendMessageResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotSendMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotSendMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BotSendMessageResponseApplicationJson_Ocs
    implements
        $BotSendMessageResponseApplicationJson_OcsInterface,
        Built<BotSendMessageResponseApplicationJson_Ocs, BotSendMessageResponseApplicationJson_OcsBuilder> {
  /// Creates a new BotSendMessageResponseApplicationJson_Ocs object using the builder pattern.
  factory BotSendMessageResponseApplicationJson_Ocs([
    void Function(BotSendMessageResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BotSendMessageResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BotSendMessageResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotSendMessageResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotSendMessageResponseApplicationJson_Ocs.
  static Serializer<BotSendMessageResponseApplicationJson_Ocs> get serializer =>
      _$botSendMessageResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotSendMessageResponseApplicationJson_OcsBuilder b) {
    $BotSendMessageResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotSendMessageResponseApplicationJson_OcsBuilder b) {
    $BotSendMessageResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotSendMessageResponseApplicationJsonInterface {
  BotSendMessageResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotSendMessageResponseApplicationJsonInterfaceBuilder].
  $BotSendMessageResponseApplicationJsonInterface rebuild(
    void Function($BotSendMessageResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotSendMessageResponseApplicationJsonInterfaceBuilder].
  $BotSendMessageResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotSendMessageResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotSendMessageResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BotSendMessageResponseApplicationJson
    implements
        $BotSendMessageResponseApplicationJsonInterface,
        Built<BotSendMessageResponseApplicationJson, BotSendMessageResponseApplicationJsonBuilder> {
  /// Creates a new BotSendMessageResponseApplicationJson object using the builder pattern.
  factory BotSendMessageResponseApplicationJson([void Function(BotSendMessageResponseApplicationJsonBuilder)? b]) =
      _$BotSendMessageResponseApplicationJson;

  // coverage:ignore-start
  const BotSendMessageResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotSendMessageResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotSendMessageResponseApplicationJson.
  static Serializer<BotSendMessageResponseApplicationJson> get serializer =>
      _$botSendMessageResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotSendMessageResponseApplicationJsonBuilder b) {
    $BotSendMessageResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotSendMessageResponseApplicationJsonBuilder b) {
    $BotSendMessageResponseApplicationJsonInterface._validate(b);
  }
}

class BotReactApiVersion extends EnumClass {
  const BotReactApiVersion._(super.name);

  /// `v1`
  static const BotReactApiVersion v1 = _$botReactApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BotReactApiVersion> get values => _$botReactApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BotReactApiVersion valueOf(String name) => _$valueOfBotReactApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BotReactApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BotReactApiVersion> get serializer => const _$BotReactApiVersionSerializer();
}

class _$BotReactApiVersionSerializer implements PrimitiveSerializer<BotReactApiVersion> {
  const _$BotReactApiVersionSerializer();

  static const Map<BotReactApiVersion, Object> _toWire = <BotReactApiVersion, Object>{
    BotReactApiVersion.v1: 'v1',
  };

  static const Map<Object, BotReactApiVersion> _fromWire = <Object, BotReactApiVersion>{
    'v1': BotReactApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BotReactApiVersion];

  @override
  String get wireName => 'BotReactApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BotReactApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BotReactApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BotReactRequestApplicationJsonInterface {
  /// Reaction to add.
  String get reaction;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotReactRequestApplicationJsonInterfaceBuilder].
  $BotReactRequestApplicationJsonInterface rebuild(
    void Function($BotReactRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotReactRequestApplicationJsonInterfaceBuilder].
  $BotReactRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotReactRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotReactRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class BotReactRequestApplicationJson
    implements
        $BotReactRequestApplicationJsonInterface,
        Built<BotReactRequestApplicationJson, BotReactRequestApplicationJsonBuilder> {
  /// Creates a new BotReactRequestApplicationJson object using the builder pattern.
  factory BotReactRequestApplicationJson([void Function(BotReactRequestApplicationJsonBuilder)? b]) =
      _$BotReactRequestApplicationJson;

  // coverage:ignore-start
  const BotReactRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotReactRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotReactRequestApplicationJson.
  static Serializer<BotReactRequestApplicationJson> get serializer => _$botReactRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotReactRequestApplicationJsonBuilder b) {
    $BotReactRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotReactRequestApplicationJsonBuilder b) {
    $BotReactRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotReactResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotReactResponseApplicationJson_OcsInterfaceBuilder].
  $BotReactResponseApplicationJson_OcsInterface rebuild(
    void Function($BotReactResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotReactResponseApplicationJson_OcsInterfaceBuilder].
  $BotReactResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotReactResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotReactResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BotReactResponseApplicationJson_Ocs
    implements
        $BotReactResponseApplicationJson_OcsInterface,
        Built<BotReactResponseApplicationJson_Ocs, BotReactResponseApplicationJson_OcsBuilder> {
  /// Creates a new BotReactResponseApplicationJson_Ocs object using the builder pattern.
  factory BotReactResponseApplicationJson_Ocs([void Function(BotReactResponseApplicationJson_OcsBuilder)? b]) =
      _$BotReactResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BotReactResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotReactResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotReactResponseApplicationJson_Ocs.
  static Serializer<BotReactResponseApplicationJson_Ocs> get serializer =>
      _$botReactResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotReactResponseApplicationJson_OcsBuilder b) {
    $BotReactResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotReactResponseApplicationJson_OcsBuilder b) {
    $BotReactResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotReactResponseApplicationJsonInterface {
  BotReactResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotReactResponseApplicationJsonInterfaceBuilder].
  $BotReactResponseApplicationJsonInterface rebuild(
    void Function($BotReactResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotReactResponseApplicationJsonInterfaceBuilder].
  $BotReactResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotReactResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotReactResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BotReactResponseApplicationJson
    implements
        $BotReactResponseApplicationJsonInterface,
        Built<BotReactResponseApplicationJson, BotReactResponseApplicationJsonBuilder> {
  /// Creates a new BotReactResponseApplicationJson object using the builder pattern.
  factory BotReactResponseApplicationJson([void Function(BotReactResponseApplicationJsonBuilder)? b]) =
      _$BotReactResponseApplicationJson;

  // coverage:ignore-start
  const BotReactResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotReactResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotReactResponseApplicationJson.
  static Serializer<BotReactResponseApplicationJson> get serializer => _$botReactResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotReactResponseApplicationJsonBuilder b) {
    $BotReactResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotReactResponseApplicationJsonBuilder b) {
    $BotReactResponseApplicationJsonInterface._validate(b);
  }
}

class BotDeleteReactionApiVersion extends EnumClass {
  const BotDeleteReactionApiVersion._(super.name);

  /// `v1`
  static const BotDeleteReactionApiVersion v1 = _$botDeleteReactionApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BotDeleteReactionApiVersion> get values => _$botDeleteReactionApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BotDeleteReactionApiVersion valueOf(String name) => _$valueOfBotDeleteReactionApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BotDeleteReactionApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BotDeleteReactionApiVersion> get serializer => const _$BotDeleteReactionApiVersionSerializer();
}

class _$BotDeleteReactionApiVersionSerializer implements PrimitiveSerializer<BotDeleteReactionApiVersion> {
  const _$BotDeleteReactionApiVersionSerializer();

  static const Map<BotDeleteReactionApiVersion, Object> _toWire = <BotDeleteReactionApiVersion, Object>{
    BotDeleteReactionApiVersion.v1: 'v1',
  };

  static const Map<Object, BotDeleteReactionApiVersion> _fromWire = <Object, BotDeleteReactionApiVersion>{
    'v1': BotDeleteReactionApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BotDeleteReactionApiVersion];

  @override
  String get wireName => 'BotDeleteReactionApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BotDeleteReactionApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BotDeleteReactionApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BotDeleteReactionResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotDeleteReactionResponseApplicationJson_OcsInterfaceBuilder].
  $BotDeleteReactionResponseApplicationJson_OcsInterface rebuild(
    void Function($BotDeleteReactionResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotDeleteReactionResponseApplicationJson_OcsInterfaceBuilder].
  $BotDeleteReactionResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotDeleteReactionResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotDeleteReactionResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BotDeleteReactionResponseApplicationJson_Ocs
    implements
        $BotDeleteReactionResponseApplicationJson_OcsInterface,
        Built<BotDeleteReactionResponseApplicationJson_Ocs, BotDeleteReactionResponseApplicationJson_OcsBuilder> {
  /// Creates a new BotDeleteReactionResponseApplicationJson_Ocs object using the builder pattern.
  factory BotDeleteReactionResponseApplicationJson_Ocs([
    void Function(BotDeleteReactionResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BotDeleteReactionResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BotDeleteReactionResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotDeleteReactionResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotDeleteReactionResponseApplicationJson_Ocs.
  static Serializer<BotDeleteReactionResponseApplicationJson_Ocs> get serializer =>
      _$botDeleteReactionResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotDeleteReactionResponseApplicationJson_OcsBuilder b) {
    $BotDeleteReactionResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotDeleteReactionResponseApplicationJson_OcsBuilder b) {
    $BotDeleteReactionResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BotDeleteReactionResponseApplicationJsonInterface {
  BotDeleteReactionResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BotDeleteReactionResponseApplicationJsonInterfaceBuilder].
  $BotDeleteReactionResponseApplicationJsonInterface rebuild(
    void Function($BotDeleteReactionResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BotDeleteReactionResponseApplicationJsonInterfaceBuilder].
  $BotDeleteReactionResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BotDeleteReactionResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BotDeleteReactionResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BotDeleteReactionResponseApplicationJson
    implements
        $BotDeleteReactionResponseApplicationJsonInterface,
        Built<BotDeleteReactionResponseApplicationJson, BotDeleteReactionResponseApplicationJsonBuilder> {
  /// Creates a new BotDeleteReactionResponseApplicationJson object using the builder pattern.
  factory BotDeleteReactionResponseApplicationJson([
    void Function(BotDeleteReactionResponseApplicationJsonBuilder)? b,
  ]) = _$BotDeleteReactionResponseApplicationJson;

  // coverage:ignore-start
  const BotDeleteReactionResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BotDeleteReactionResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BotDeleteReactionResponseApplicationJson.
  static Serializer<BotDeleteReactionResponseApplicationJson> get serializer =>
      _$botDeleteReactionResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BotDeleteReactionResponseApplicationJsonBuilder b) {
    $BotDeleteReactionResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BotDeleteReactionResponseApplicationJsonBuilder b) {
    $BotDeleteReactionResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomConfigureBreakoutRoomsApiVersion extends EnumClass {
  const BreakoutRoomConfigureBreakoutRoomsApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomConfigureBreakoutRoomsApiVersion v1 = _$breakoutRoomConfigureBreakoutRoomsApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomConfigureBreakoutRoomsApiVersion> get values =>
      _$breakoutRoomConfigureBreakoutRoomsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomConfigureBreakoutRoomsApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomConfigureBreakoutRoomsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomConfigureBreakoutRoomsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomConfigureBreakoutRoomsApiVersion> get serializer =>
      const _$BreakoutRoomConfigureBreakoutRoomsApiVersionSerializer();
}

class _$BreakoutRoomConfigureBreakoutRoomsApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomConfigureBreakoutRoomsApiVersion> {
  const _$BreakoutRoomConfigureBreakoutRoomsApiVersionSerializer();

  static const Map<BreakoutRoomConfigureBreakoutRoomsApiVersion, Object> _toWire =
      <BreakoutRoomConfigureBreakoutRoomsApiVersion, Object>{
    BreakoutRoomConfigureBreakoutRoomsApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomConfigureBreakoutRoomsApiVersion> _fromWire =
      <Object, BreakoutRoomConfigureBreakoutRoomsApiVersion>{
    'v1': BreakoutRoomConfigureBreakoutRoomsApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomConfigureBreakoutRoomsApiVersion];

  @override
  String get wireName => 'BreakoutRoomConfigureBreakoutRoomsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomConfigureBreakoutRoomsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomConfigureBreakoutRoomsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// Mode of the breakout rooms.
class BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode extends EnumClass {
  const BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode $0 =
      _$breakoutRoomConfigureBreakoutRoomsRequestApplicationJsonMode$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode $1 =
      _$breakoutRoomConfigureBreakoutRoomsRequestApplicationJsonMode$1;

  /// `2`
  @BuiltValueEnumConst(wireName: '2')
  static const BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode $2 =
      _$breakoutRoomConfigureBreakoutRoomsRequestApplicationJsonMode$2;

  /// `3`
  @BuiltValueEnumConst(wireName: '3')
  static const BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode $3 =
      _$breakoutRoomConfigureBreakoutRoomsRequestApplicationJsonMode$3;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode> get values =>
      _$breakoutRoomConfigureBreakoutRoomsRequestApplicationJsonModeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode valueOf(String name) =>
      _$valueOfBreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode> get serializer =>
      const _$BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_ModeSerializer();
}

class _$BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_ModeSerializer
    implements PrimitiveSerializer<BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode> {
  const _$BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_ModeSerializer();

  static const Map<BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode, Object> _toWire =
      <BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode, Object>{
    BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.$0: 0,
    BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.$1: 1,
    BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.$2: 2,
    BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.$3: 3,
  };

  static const Map<Object, BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode> _fromWire =
      <Object, BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode>{
    0: BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.$0,
    1: BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.$1,
    2: BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.$2,
    3: BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode.$3,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode];

  @override
  String get wireName => 'BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterface {
  static final _$attendeeMap = _$jsonSerializers.deserialize(
    '[]',
    specifiedType: const FullType(String),
  )! as String;

  /// Mode of the breakout rooms.
  BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson_Mode get mode;

  /// Number of breakout rooms - Constants {@see BreakoutRoom::MINIMUM_ROOM_AMOUNT} and {@see BreakoutRoom::MAXIMUM_ROOM_AMOUNT}.
  int get amount;

  /// Mapping of the attendees to breakout rooms.
  String get attendeeMap;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterfaceBuilder].
  $BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterface rebuild(
    void Function($BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterfaceBuilder].
  $BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterfaceBuilder b) {
    b.attendeeMap = _$attendeeMap;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterfaceBuilder b) {
    _i4.checkNumber(
      b.amount,
      'amount',
      maximum: 20,
      minimum: 1,
    );
  }
}

abstract class BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson
    implements
        $BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterface,
        Built<BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson,
            BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson object using the builder pattern.
  factory BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson([
    void Function(BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson.
  static Serializer<BreakoutRoomConfigureBreakoutRoomsRequestApplicationJson> get serializer =>
      _$breakoutRoomConfigureBreakoutRoomsRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonBuilder b) {
    $BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonBuilder b) {
    $BreakoutRoomConfigureBreakoutRoomsRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Room> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs
    implements
        $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs,
            BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs([
    void Function(BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomConfigureBreakoutRoomsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterface {
  BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson
    implements
        $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterface,
        Built<BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson,
            BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson([
    void Function(BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson.
  static Serializer<BreakoutRoomConfigureBreakoutRoomsResponseApplicationJson> get serializer =>
      _$breakoutRoomConfigureBreakoutRoomsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonBuilder b) {
    $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonBuilder b) {
    $BreakoutRoomConfigureBreakoutRoomsResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomRemoveBreakoutRoomsApiVersion extends EnumClass {
  const BreakoutRoomRemoveBreakoutRoomsApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomRemoveBreakoutRoomsApiVersion v1 = _$breakoutRoomRemoveBreakoutRoomsApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomRemoveBreakoutRoomsApiVersion> get values =>
      _$breakoutRoomRemoveBreakoutRoomsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomRemoveBreakoutRoomsApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomRemoveBreakoutRoomsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomRemoveBreakoutRoomsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomRemoveBreakoutRoomsApiVersion> get serializer =>
      const _$BreakoutRoomRemoveBreakoutRoomsApiVersionSerializer();
}

class _$BreakoutRoomRemoveBreakoutRoomsApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomRemoveBreakoutRoomsApiVersion> {
  const _$BreakoutRoomRemoveBreakoutRoomsApiVersionSerializer();

  static const Map<BreakoutRoomRemoveBreakoutRoomsApiVersion, Object> _toWire =
      <BreakoutRoomRemoveBreakoutRoomsApiVersion, Object>{
    BreakoutRoomRemoveBreakoutRoomsApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomRemoveBreakoutRoomsApiVersion> _fromWire =
      <Object, BreakoutRoomRemoveBreakoutRoomsApiVersion>{
    'v1': BreakoutRoomRemoveBreakoutRoomsApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomRemoveBreakoutRoomsApiVersion];

  @override
  String get wireName => 'BreakoutRoomRemoveBreakoutRoomsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomRemoveBreakoutRoomsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomRemoveBreakoutRoomsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Room get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs
    implements
        $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs,
            BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs([
    void Function(BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomRemoveBreakoutRoomsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterface {
  BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson
    implements
        $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterface,
        Built<BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson,
            BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson([
    void Function(BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson.
  static Serializer<BreakoutRoomRemoveBreakoutRoomsResponseApplicationJson> get serializer =>
      _$breakoutRoomRemoveBreakoutRoomsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonBuilder b) {
    $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonBuilder b) {
    $BreakoutRoomRemoveBreakoutRoomsResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomBroadcastChatMessageApiVersion extends EnumClass {
  const BreakoutRoomBroadcastChatMessageApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomBroadcastChatMessageApiVersion v1 = _$breakoutRoomBroadcastChatMessageApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomBroadcastChatMessageApiVersion> get values =>
      _$breakoutRoomBroadcastChatMessageApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomBroadcastChatMessageApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomBroadcastChatMessageApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomBroadcastChatMessageApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomBroadcastChatMessageApiVersion> get serializer =>
      const _$BreakoutRoomBroadcastChatMessageApiVersionSerializer();
}

class _$BreakoutRoomBroadcastChatMessageApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomBroadcastChatMessageApiVersion> {
  const _$BreakoutRoomBroadcastChatMessageApiVersionSerializer();

  static const Map<BreakoutRoomBroadcastChatMessageApiVersion, Object> _toWire =
      <BreakoutRoomBroadcastChatMessageApiVersion, Object>{
    BreakoutRoomBroadcastChatMessageApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomBroadcastChatMessageApiVersion> _fromWire =
      <Object, BreakoutRoomBroadcastChatMessageApiVersion>{
    'v1': BreakoutRoomBroadcastChatMessageApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomBroadcastChatMessageApiVersion];

  @override
  String get wireName => 'BreakoutRoomBroadcastChatMessageApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomBroadcastChatMessageApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomBroadcastChatMessageApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterface {
  /// Message to broadcast.
  String get message;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterfaceBuilder].
  $BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterface rebuild(
    void Function($BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterfaceBuilder].
  $BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomBroadcastChatMessageRequestApplicationJson
    implements
        $BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterface,
        Built<BreakoutRoomBroadcastChatMessageRequestApplicationJson,
            BreakoutRoomBroadcastChatMessageRequestApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomBroadcastChatMessageRequestApplicationJson object using the builder pattern.
  factory BreakoutRoomBroadcastChatMessageRequestApplicationJson([
    void Function(BreakoutRoomBroadcastChatMessageRequestApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomBroadcastChatMessageRequestApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomBroadcastChatMessageRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomBroadcastChatMessageRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomBroadcastChatMessageRequestApplicationJson.
  static Serializer<BreakoutRoomBroadcastChatMessageRequestApplicationJson> get serializer =>
      _$breakoutRoomBroadcastChatMessageRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomBroadcastChatMessageRequestApplicationJsonBuilder b) {
    $BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomBroadcastChatMessageRequestApplicationJsonBuilder b) {
    $BreakoutRoomBroadcastChatMessageRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Room> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs
    implements
        $BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs,
            BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs([
    void Function(BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomBroadcastChatMessageResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomBroadcastChatMessageResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterface {
  BreakoutRoomBroadcastChatMessageResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomBroadcastChatMessageResponseApplicationJson
    implements
        $BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterface,
        Built<BreakoutRoomBroadcastChatMessageResponseApplicationJson,
            BreakoutRoomBroadcastChatMessageResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomBroadcastChatMessageResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomBroadcastChatMessageResponseApplicationJson([
    void Function(BreakoutRoomBroadcastChatMessageResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomBroadcastChatMessageResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomBroadcastChatMessageResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomBroadcastChatMessageResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomBroadcastChatMessageResponseApplicationJson.
  static Serializer<BreakoutRoomBroadcastChatMessageResponseApplicationJson> get serializer =>
      _$breakoutRoomBroadcastChatMessageResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomBroadcastChatMessageResponseApplicationJsonBuilder b) {
    $BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomBroadcastChatMessageResponseApplicationJsonBuilder b) {
    $BreakoutRoomBroadcastChatMessageResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomApplyAttendeeMapApiVersion extends EnumClass {
  const BreakoutRoomApplyAttendeeMapApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomApplyAttendeeMapApiVersion v1 = _$breakoutRoomApplyAttendeeMapApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomApplyAttendeeMapApiVersion> get values => _$breakoutRoomApplyAttendeeMapApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomApplyAttendeeMapApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomApplyAttendeeMapApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomApplyAttendeeMapApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomApplyAttendeeMapApiVersion> get serializer =>
      const _$BreakoutRoomApplyAttendeeMapApiVersionSerializer();
}

class _$BreakoutRoomApplyAttendeeMapApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomApplyAttendeeMapApiVersion> {
  const _$BreakoutRoomApplyAttendeeMapApiVersionSerializer();

  static const Map<BreakoutRoomApplyAttendeeMapApiVersion, Object> _toWire =
      <BreakoutRoomApplyAttendeeMapApiVersion, Object>{
    BreakoutRoomApplyAttendeeMapApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomApplyAttendeeMapApiVersion> _fromWire =
      <Object, BreakoutRoomApplyAttendeeMapApiVersion>{
    'v1': BreakoutRoomApplyAttendeeMapApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomApplyAttendeeMapApiVersion];

  @override
  String get wireName => 'BreakoutRoomApplyAttendeeMapApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomApplyAttendeeMapApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomApplyAttendeeMapApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterface {
  /// JSON encoded mapping of the attendees to breakout rooms `array<int, int>`.
  String get attendeeMap;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterfaceBuilder].
  $BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterface rebuild(
    void Function($BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterfaceBuilder].
  $BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomApplyAttendeeMapRequestApplicationJson
    implements
        $BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterface,
        Built<BreakoutRoomApplyAttendeeMapRequestApplicationJson,
            BreakoutRoomApplyAttendeeMapRequestApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomApplyAttendeeMapRequestApplicationJson object using the builder pattern.
  factory BreakoutRoomApplyAttendeeMapRequestApplicationJson([
    void Function(BreakoutRoomApplyAttendeeMapRequestApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomApplyAttendeeMapRequestApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomApplyAttendeeMapRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomApplyAttendeeMapRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomApplyAttendeeMapRequestApplicationJson.
  static Serializer<BreakoutRoomApplyAttendeeMapRequestApplicationJson> get serializer =>
      _$breakoutRoomApplyAttendeeMapRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomApplyAttendeeMapRequestApplicationJsonBuilder b) {
    $BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomApplyAttendeeMapRequestApplicationJsonBuilder b) {
    $BreakoutRoomApplyAttendeeMapRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Room> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs
    implements
        $BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs,
            BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs([
    void Function(BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomApplyAttendeeMapResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomApplyAttendeeMapResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterface {
  BreakoutRoomApplyAttendeeMapResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomApplyAttendeeMapResponseApplicationJson
    implements
        $BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterface,
        Built<BreakoutRoomApplyAttendeeMapResponseApplicationJson,
            BreakoutRoomApplyAttendeeMapResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomApplyAttendeeMapResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomApplyAttendeeMapResponseApplicationJson([
    void Function(BreakoutRoomApplyAttendeeMapResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomApplyAttendeeMapResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomApplyAttendeeMapResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomApplyAttendeeMapResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomApplyAttendeeMapResponseApplicationJson.
  static Serializer<BreakoutRoomApplyAttendeeMapResponseApplicationJson> get serializer =>
      _$breakoutRoomApplyAttendeeMapResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomApplyAttendeeMapResponseApplicationJsonBuilder b) {
    $BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomApplyAttendeeMapResponseApplicationJsonBuilder b) {
    $BreakoutRoomApplyAttendeeMapResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomRequestAssistanceApiVersion extends EnumClass {
  const BreakoutRoomRequestAssistanceApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomRequestAssistanceApiVersion v1 = _$breakoutRoomRequestAssistanceApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomRequestAssistanceApiVersion> get values =>
      _$breakoutRoomRequestAssistanceApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomRequestAssistanceApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomRequestAssistanceApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomRequestAssistanceApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomRequestAssistanceApiVersion> get serializer =>
      const _$BreakoutRoomRequestAssistanceApiVersionSerializer();
}

class _$BreakoutRoomRequestAssistanceApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomRequestAssistanceApiVersion> {
  const _$BreakoutRoomRequestAssistanceApiVersionSerializer();

  static const Map<BreakoutRoomRequestAssistanceApiVersion, Object> _toWire =
      <BreakoutRoomRequestAssistanceApiVersion, Object>{
    BreakoutRoomRequestAssistanceApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomRequestAssistanceApiVersion> _fromWire =
      <Object, BreakoutRoomRequestAssistanceApiVersion>{
    'v1': BreakoutRoomRequestAssistanceApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomRequestAssistanceApiVersion];

  @override
  String get wireName => 'BreakoutRoomRequestAssistanceApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomRequestAssistanceApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomRequestAssistanceApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Room get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs
    implements
        $BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs,
            BreakoutRoomRequestAssistanceResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs([
    void Function(BreakoutRoomRequestAssistanceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomRequestAssistanceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomRequestAssistanceResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomRequestAssistanceResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomRequestAssistanceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomRequestAssistanceResponseApplicationJsonInterface {
  BreakoutRoomRequestAssistanceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomRequestAssistanceResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomRequestAssistanceResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomRequestAssistanceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomRequestAssistanceResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomRequestAssistanceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomRequestAssistanceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomRequestAssistanceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomRequestAssistanceResponseApplicationJson
    implements
        $BreakoutRoomRequestAssistanceResponseApplicationJsonInterface,
        Built<BreakoutRoomRequestAssistanceResponseApplicationJson,
            BreakoutRoomRequestAssistanceResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomRequestAssistanceResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomRequestAssistanceResponseApplicationJson([
    void Function(BreakoutRoomRequestAssistanceResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomRequestAssistanceResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomRequestAssistanceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomRequestAssistanceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomRequestAssistanceResponseApplicationJson.
  static Serializer<BreakoutRoomRequestAssistanceResponseApplicationJson> get serializer =>
      _$breakoutRoomRequestAssistanceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomRequestAssistanceResponseApplicationJsonBuilder b) {
    $BreakoutRoomRequestAssistanceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomRequestAssistanceResponseApplicationJsonBuilder b) {
    $BreakoutRoomRequestAssistanceResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomResetRequestForAssistanceApiVersion extends EnumClass {
  const BreakoutRoomResetRequestForAssistanceApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomResetRequestForAssistanceApiVersion v1 = _$breakoutRoomResetRequestForAssistanceApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomResetRequestForAssistanceApiVersion> get values =>
      _$breakoutRoomResetRequestForAssistanceApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomResetRequestForAssistanceApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomResetRequestForAssistanceApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomResetRequestForAssistanceApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomResetRequestForAssistanceApiVersion> get serializer =>
      const _$BreakoutRoomResetRequestForAssistanceApiVersionSerializer();
}

class _$BreakoutRoomResetRequestForAssistanceApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomResetRequestForAssistanceApiVersion> {
  const _$BreakoutRoomResetRequestForAssistanceApiVersionSerializer();

  static const Map<BreakoutRoomResetRequestForAssistanceApiVersion, Object> _toWire =
      <BreakoutRoomResetRequestForAssistanceApiVersion, Object>{
    BreakoutRoomResetRequestForAssistanceApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomResetRequestForAssistanceApiVersion> _fromWire =
      <Object, BreakoutRoomResetRequestForAssistanceApiVersion>{
    'v1': BreakoutRoomResetRequestForAssistanceApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomResetRequestForAssistanceApiVersion];

  @override
  String get wireName => 'BreakoutRoomResetRequestForAssistanceApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomResetRequestForAssistanceApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomResetRequestForAssistanceApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Room get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs
    implements
        $BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs,
            BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs([
    void Function(BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomResetRequestForAssistanceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomResetRequestForAssistanceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterface {
  BreakoutRoomResetRequestForAssistanceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomResetRequestForAssistanceResponseApplicationJson
    implements
        $BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterface,
        Built<BreakoutRoomResetRequestForAssistanceResponseApplicationJson,
            BreakoutRoomResetRequestForAssistanceResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomResetRequestForAssistanceResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomResetRequestForAssistanceResponseApplicationJson([
    void Function(BreakoutRoomResetRequestForAssistanceResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomResetRequestForAssistanceResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomResetRequestForAssistanceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomResetRequestForAssistanceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomResetRequestForAssistanceResponseApplicationJson.
  static Serializer<BreakoutRoomResetRequestForAssistanceResponseApplicationJson> get serializer =>
      _$breakoutRoomResetRequestForAssistanceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomResetRequestForAssistanceResponseApplicationJsonBuilder b) {
    $BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomResetRequestForAssistanceResponseApplicationJsonBuilder b) {
    $BreakoutRoomResetRequestForAssistanceResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomStartBreakoutRoomsApiVersion extends EnumClass {
  const BreakoutRoomStartBreakoutRoomsApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomStartBreakoutRoomsApiVersion v1 = _$breakoutRoomStartBreakoutRoomsApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomStartBreakoutRoomsApiVersion> get values =>
      _$breakoutRoomStartBreakoutRoomsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomStartBreakoutRoomsApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomStartBreakoutRoomsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomStartBreakoutRoomsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomStartBreakoutRoomsApiVersion> get serializer =>
      const _$BreakoutRoomStartBreakoutRoomsApiVersionSerializer();
}

class _$BreakoutRoomStartBreakoutRoomsApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomStartBreakoutRoomsApiVersion> {
  const _$BreakoutRoomStartBreakoutRoomsApiVersionSerializer();

  static const Map<BreakoutRoomStartBreakoutRoomsApiVersion, Object> _toWire =
      <BreakoutRoomStartBreakoutRoomsApiVersion, Object>{
    BreakoutRoomStartBreakoutRoomsApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomStartBreakoutRoomsApiVersion> _fromWire =
      <Object, BreakoutRoomStartBreakoutRoomsApiVersion>{
    'v1': BreakoutRoomStartBreakoutRoomsApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomStartBreakoutRoomsApiVersion];

  @override
  String get wireName => 'BreakoutRoomStartBreakoutRoomsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomStartBreakoutRoomsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomStartBreakoutRoomsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Room> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs
    implements
        $BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs,
            BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs([
    void Function(BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomStartBreakoutRoomsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomStartBreakoutRoomsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterface {
  BreakoutRoomStartBreakoutRoomsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomStartBreakoutRoomsResponseApplicationJson
    implements
        $BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterface,
        Built<BreakoutRoomStartBreakoutRoomsResponseApplicationJson,
            BreakoutRoomStartBreakoutRoomsResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomStartBreakoutRoomsResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomStartBreakoutRoomsResponseApplicationJson([
    void Function(BreakoutRoomStartBreakoutRoomsResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomStartBreakoutRoomsResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomStartBreakoutRoomsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomStartBreakoutRoomsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomStartBreakoutRoomsResponseApplicationJson.
  static Serializer<BreakoutRoomStartBreakoutRoomsResponseApplicationJson> get serializer =>
      _$breakoutRoomStartBreakoutRoomsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomStartBreakoutRoomsResponseApplicationJsonBuilder b) {
    $BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomStartBreakoutRoomsResponseApplicationJsonBuilder b) {
    $BreakoutRoomStartBreakoutRoomsResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomStopBreakoutRoomsApiVersion extends EnumClass {
  const BreakoutRoomStopBreakoutRoomsApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomStopBreakoutRoomsApiVersion v1 = _$breakoutRoomStopBreakoutRoomsApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomStopBreakoutRoomsApiVersion> get values =>
      _$breakoutRoomStopBreakoutRoomsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomStopBreakoutRoomsApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomStopBreakoutRoomsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomStopBreakoutRoomsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomStopBreakoutRoomsApiVersion> get serializer =>
      const _$BreakoutRoomStopBreakoutRoomsApiVersionSerializer();
}

class _$BreakoutRoomStopBreakoutRoomsApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomStopBreakoutRoomsApiVersion> {
  const _$BreakoutRoomStopBreakoutRoomsApiVersionSerializer();

  static const Map<BreakoutRoomStopBreakoutRoomsApiVersion, Object> _toWire =
      <BreakoutRoomStopBreakoutRoomsApiVersion, Object>{
    BreakoutRoomStopBreakoutRoomsApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomStopBreakoutRoomsApiVersion> _fromWire =
      <Object, BreakoutRoomStopBreakoutRoomsApiVersion>{
    'v1': BreakoutRoomStopBreakoutRoomsApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomStopBreakoutRoomsApiVersion];

  @override
  String get wireName => 'BreakoutRoomStopBreakoutRoomsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomStopBreakoutRoomsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomStopBreakoutRoomsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Room> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs
    implements
        $BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs,
            BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs([
    void Function(BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomStopBreakoutRoomsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomStopBreakoutRoomsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterface {
  BreakoutRoomStopBreakoutRoomsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomStopBreakoutRoomsResponseApplicationJson
    implements
        $BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterface,
        Built<BreakoutRoomStopBreakoutRoomsResponseApplicationJson,
            BreakoutRoomStopBreakoutRoomsResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomStopBreakoutRoomsResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomStopBreakoutRoomsResponseApplicationJson([
    void Function(BreakoutRoomStopBreakoutRoomsResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomStopBreakoutRoomsResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomStopBreakoutRoomsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomStopBreakoutRoomsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomStopBreakoutRoomsResponseApplicationJson.
  static Serializer<BreakoutRoomStopBreakoutRoomsResponseApplicationJson> get serializer =>
      _$breakoutRoomStopBreakoutRoomsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomStopBreakoutRoomsResponseApplicationJsonBuilder b) {
    $BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomStopBreakoutRoomsResponseApplicationJsonBuilder b) {
    $BreakoutRoomStopBreakoutRoomsResponseApplicationJsonInterface._validate(b);
  }
}

class BreakoutRoomSwitchBreakoutRoomApiVersion extends EnumClass {
  const BreakoutRoomSwitchBreakoutRoomApiVersion._(super.name);

  /// `v1`
  static const BreakoutRoomSwitchBreakoutRoomApiVersion v1 = _$breakoutRoomSwitchBreakoutRoomApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<BreakoutRoomSwitchBreakoutRoomApiVersion> get values =>
      _$breakoutRoomSwitchBreakoutRoomApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static BreakoutRoomSwitchBreakoutRoomApiVersion valueOf(String name) =>
      _$valueOfBreakoutRoomSwitchBreakoutRoomApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for BreakoutRoomSwitchBreakoutRoomApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<BreakoutRoomSwitchBreakoutRoomApiVersion> get serializer =>
      const _$BreakoutRoomSwitchBreakoutRoomApiVersionSerializer();
}

class _$BreakoutRoomSwitchBreakoutRoomApiVersionSerializer
    implements PrimitiveSerializer<BreakoutRoomSwitchBreakoutRoomApiVersion> {
  const _$BreakoutRoomSwitchBreakoutRoomApiVersionSerializer();

  static const Map<BreakoutRoomSwitchBreakoutRoomApiVersion, Object> _toWire =
      <BreakoutRoomSwitchBreakoutRoomApiVersion, Object>{
    BreakoutRoomSwitchBreakoutRoomApiVersion.v1: 'v1',
  };

  static const Map<Object, BreakoutRoomSwitchBreakoutRoomApiVersion> _fromWire =
      <Object, BreakoutRoomSwitchBreakoutRoomApiVersion>{
    'v1': BreakoutRoomSwitchBreakoutRoomApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [BreakoutRoomSwitchBreakoutRoomApiVersion];

  @override
  String get wireName => 'BreakoutRoomSwitchBreakoutRoomApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    BreakoutRoomSwitchBreakoutRoomApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  BreakoutRoomSwitchBreakoutRoomApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterface {
  /// Target breakout room.
  String get target;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterfaceBuilder].
  $BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterface rebuild(
    void Function($BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterfaceBuilder].
  $BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomSwitchBreakoutRoomRequestApplicationJson
    implements
        $BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterface,
        Built<BreakoutRoomSwitchBreakoutRoomRequestApplicationJson,
            BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomSwitchBreakoutRoomRequestApplicationJson object using the builder pattern.
  factory BreakoutRoomSwitchBreakoutRoomRequestApplicationJson([
    void Function(BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomSwitchBreakoutRoomRequestApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomSwitchBreakoutRoomRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomSwitchBreakoutRoomRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomSwitchBreakoutRoomRequestApplicationJson.
  static Serializer<BreakoutRoomSwitchBreakoutRoomRequestApplicationJson> get serializer =>
      _$breakoutRoomSwitchBreakoutRoomRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonBuilder b) {
    $BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonBuilder b) {
    $BreakoutRoomSwitchBreakoutRoomRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Room get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterface rebuild(
    void Function($BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterfaceBuilder].
  $BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs
    implements
        $BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterface,
        Built<BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs,
            BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsBuilder> {
  /// Creates a new BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs object using the builder pattern.
  factory BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs([
    void Function(BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsBuilder)? b,
  ]) = _$BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs.
  static Serializer<BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs> get serializer =>
      _$breakoutRoomSwitchBreakoutRoomResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsBuilder b) {
    $BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterface {
  BreakoutRoomSwitchBreakoutRoomResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterface rebuild(
    void Function($BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterfaceBuilder].
  $BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class BreakoutRoomSwitchBreakoutRoomResponseApplicationJson
    implements
        $BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterface,
        Built<BreakoutRoomSwitchBreakoutRoomResponseApplicationJson,
            BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonBuilder> {
  /// Creates a new BreakoutRoomSwitchBreakoutRoomResponseApplicationJson object using the builder pattern.
  factory BreakoutRoomSwitchBreakoutRoomResponseApplicationJson([
    void Function(BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonBuilder)? b,
  ]) = _$BreakoutRoomSwitchBreakoutRoomResponseApplicationJson;

  // coverage:ignore-start
  const BreakoutRoomSwitchBreakoutRoomResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory BreakoutRoomSwitchBreakoutRoomResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for BreakoutRoomSwitchBreakoutRoomResponseApplicationJson.
  static Serializer<BreakoutRoomSwitchBreakoutRoomResponseApplicationJson> get serializer =>
      _$breakoutRoomSwitchBreakoutRoomResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonBuilder b) {
    $BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonBuilder b) {
    $BreakoutRoomSwitchBreakoutRoomResponseApplicationJsonInterface._validate(b);
  }
}

class CallGetPeersForCallApiVersion extends EnumClass {
  const CallGetPeersForCallApiVersion._(super.name);

  /// `v4`
  static const CallGetPeersForCallApiVersion v4 = _$callGetPeersForCallApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallGetPeersForCallApiVersion> get values => _$callGetPeersForCallApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallGetPeersForCallApiVersion valueOf(String name) => _$valueOfCallGetPeersForCallApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallGetPeersForCallApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallGetPeersForCallApiVersion> get serializer => const _$CallGetPeersForCallApiVersionSerializer();
}

class _$CallGetPeersForCallApiVersionSerializer implements PrimitiveSerializer<CallGetPeersForCallApiVersion> {
  const _$CallGetPeersForCallApiVersionSerializer();

  static const Map<CallGetPeersForCallApiVersion, Object> _toWire = <CallGetPeersForCallApiVersion, Object>{
    CallGetPeersForCallApiVersion.v4: 'v4',
  };

  static const Map<Object, CallGetPeersForCallApiVersion> _fromWire = <Object, CallGetPeersForCallApiVersion>{
    'v4': CallGetPeersForCallApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallGetPeersForCallApiVersion];

  @override
  String get wireName => 'CallGetPeersForCallApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallGetPeersForCallApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallGetPeersForCallApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallPeerInterface {
  String get actorId;
  ActorType get actorType;
  String get displayName;
  int get lastPing;
  String get sessionId;
  String get token;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallPeerInterfaceBuilder].
  $CallPeerInterface rebuild(void Function($CallPeerInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CallPeerInterfaceBuilder].
  $CallPeerInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallPeerInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallPeerInterfaceBuilder b) {}
}

abstract class CallPeer implements $CallPeerInterface, Built<CallPeer, CallPeerBuilder> {
  /// Creates a new CallPeer object using the builder pattern.
  factory CallPeer([void Function(CallPeerBuilder)? b]) = _$CallPeer;

  // coverage:ignore-start
  const CallPeer._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallPeer.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallPeer.
  static Serializer<CallPeer> get serializer => _$callPeerSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallPeerBuilder b) {
    $CallPeerInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallPeerBuilder b) {
    $CallPeerInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallGetPeersForCallResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<CallPeer> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallGetPeersForCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallGetPeersForCallResponseApplicationJson_OcsInterface rebuild(
    void Function($CallGetPeersForCallResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallGetPeersForCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallGetPeersForCallResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallGetPeersForCallResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallGetPeersForCallResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallGetPeersForCallResponseApplicationJson_Ocs
    implements
        $CallGetPeersForCallResponseApplicationJson_OcsInterface,
        Built<CallGetPeersForCallResponseApplicationJson_Ocs, CallGetPeersForCallResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallGetPeersForCallResponseApplicationJson_Ocs object using the builder pattern.
  factory CallGetPeersForCallResponseApplicationJson_Ocs([
    void Function(CallGetPeersForCallResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CallGetPeersForCallResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallGetPeersForCallResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallGetPeersForCallResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallGetPeersForCallResponseApplicationJson_Ocs.
  static Serializer<CallGetPeersForCallResponseApplicationJson_Ocs> get serializer =>
      _$callGetPeersForCallResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallGetPeersForCallResponseApplicationJson_OcsBuilder b) {
    $CallGetPeersForCallResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallGetPeersForCallResponseApplicationJson_OcsBuilder b) {
    $CallGetPeersForCallResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallGetPeersForCallResponseApplicationJsonInterface {
  CallGetPeersForCallResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallGetPeersForCallResponseApplicationJsonInterfaceBuilder].
  $CallGetPeersForCallResponseApplicationJsonInterface rebuild(
    void Function($CallGetPeersForCallResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallGetPeersForCallResponseApplicationJsonInterfaceBuilder].
  $CallGetPeersForCallResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallGetPeersForCallResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallGetPeersForCallResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallGetPeersForCallResponseApplicationJson
    implements
        $CallGetPeersForCallResponseApplicationJsonInterface,
        Built<CallGetPeersForCallResponseApplicationJson, CallGetPeersForCallResponseApplicationJsonBuilder> {
  /// Creates a new CallGetPeersForCallResponseApplicationJson object using the builder pattern.
  factory CallGetPeersForCallResponseApplicationJson([
    void Function(CallGetPeersForCallResponseApplicationJsonBuilder)? b,
  ]) = _$CallGetPeersForCallResponseApplicationJson;

  // coverage:ignore-start
  const CallGetPeersForCallResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallGetPeersForCallResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallGetPeersForCallResponseApplicationJson.
  static Serializer<CallGetPeersForCallResponseApplicationJson> get serializer =>
      _$callGetPeersForCallResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallGetPeersForCallResponseApplicationJsonBuilder b) {
    $CallGetPeersForCallResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallGetPeersForCallResponseApplicationJsonBuilder b) {
    $CallGetPeersForCallResponseApplicationJsonInterface._validate(b);
  }
}

class CallUpdateCallFlagsApiVersion extends EnumClass {
  const CallUpdateCallFlagsApiVersion._(super.name);

  /// `v4`
  static const CallUpdateCallFlagsApiVersion v4 = _$callUpdateCallFlagsApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallUpdateCallFlagsApiVersion> get values => _$callUpdateCallFlagsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallUpdateCallFlagsApiVersion valueOf(String name) => _$valueOfCallUpdateCallFlagsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallUpdateCallFlagsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallUpdateCallFlagsApiVersion> get serializer => const _$CallUpdateCallFlagsApiVersionSerializer();
}

class _$CallUpdateCallFlagsApiVersionSerializer implements PrimitiveSerializer<CallUpdateCallFlagsApiVersion> {
  const _$CallUpdateCallFlagsApiVersionSerializer();

  static const Map<CallUpdateCallFlagsApiVersion, Object> _toWire = <CallUpdateCallFlagsApiVersion, Object>{
    CallUpdateCallFlagsApiVersion.v4: 'v4',
  };

  static const Map<Object, CallUpdateCallFlagsApiVersion> _fromWire = <Object, CallUpdateCallFlagsApiVersion>{
    'v4': CallUpdateCallFlagsApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallUpdateCallFlagsApiVersion];

  @override
  String get wireName => 'CallUpdateCallFlagsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallUpdateCallFlagsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallUpdateCallFlagsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallUpdateCallFlagsRequestApplicationJsonInterface {
  /// New flags.
  int get flags;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallUpdateCallFlagsRequestApplicationJsonInterfaceBuilder].
  $CallUpdateCallFlagsRequestApplicationJsonInterface rebuild(
    void Function($CallUpdateCallFlagsRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallUpdateCallFlagsRequestApplicationJsonInterfaceBuilder].
  $CallUpdateCallFlagsRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallUpdateCallFlagsRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallUpdateCallFlagsRequestApplicationJsonInterfaceBuilder b) {
    _i4.checkNumber(
      b.flags,
      'flags',
      maximum: 15,
      minimum: 0,
    );
  }
}

abstract class CallUpdateCallFlagsRequestApplicationJson
    implements
        $CallUpdateCallFlagsRequestApplicationJsonInterface,
        Built<CallUpdateCallFlagsRequestApplicationJson, CallUpdateCallFlagsRequestApplicationJsonBuilder> {
  /// Creates a new CallUpdateCallFlagsRequestApplicationJson object using the builder pattern.
  factory CallUpdateCallFlagsRequestApplicationJson([
    void Function(CallUpdateCallFlagsRequestApplicationJsonBuilder)? b,
  ]) = _$CallUpdateCallFlagsRequestApplicationJson;

  // coverage:ignore-start
  const CallUpdateCallFlagsRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallUpdateCallFlagsRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallUpdateCallFlagsRequestApplicationJson.
  static Serializer<CallUpdateCallFlagsRequestApplicationJson> get serializer =>
      _$callUpdateCallFlagsRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallUpdateCallFlagsRequestApplicationJsonBuilder b) {
    $CallUpdateCallFlagsRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallUpdateCallFlagsRequestApplicationJsonBuilder b) {
    $CallUpdateCallFlagsRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallUpdateCallFlagsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallUpdateCallFlagsResponseApplicationJson_OcsInterfaceBuilder].
  $CallUpdateCallFlagsResponseApplicationJson_OcsInterface rebuild(
    void Function($CallUpdateCallFlagsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallUpdateCallFlagsResponseApplicationJson_OcsInterfaceBuilder].
  $CallUpdateCallFlagsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallUpdateCallFlagsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallUpdateCallFlagsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallUpdateCallFlagsResponseApplicationJson_Ocs
    implements
        $CallUpdateCallFlagsResponseApplicationJson_OcsInterface,
        Built<CallUpdateCallFlagsResponseApplicationJson_Ocs, CallUpdateCallFlagsResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallUpdateCallFlagsResponseApplicationJson_Ocs object using the builder pattern.
  factory CallUpdateCallFlagsResponseApplicationJson_Ocs([
    void Function(CallUpdateCallFlagsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CallUpdateCallFlagsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallUpdateCallFlagsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallUpdateCallFlagsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallUpdateCallFlagsResponseApplicationJson_Ocs.
  static Serializer<CallUpdateCallFlagsResponseApplicationJson_Ocs> get serializer =>
      _$callUpdateCallFlagsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallUpdateCallFlagsResponseApplicationJson_OcsBuilder b) {
    $CallUpdateCallFlagsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallUpdateCallFlagsResponseApplicationJson_OcsBuilder b) {
    $CallUpdateCallFlagsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallUpdateCallFlagsResponseApplicationJsonInterface {
  CallUpdateCallFlagsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallUpdateCallFlagsResponseApplicationJsonInterfaceBuilder].
  $CallUpdateCallFlagsResponseApplicationJsonInterface rebuild(
    void Function($CallUpdateCallFlagsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallUpdateCallFlagsResponseApplicationJsonInterfaceBuilder].
  $CallUpdateCallFlagsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallUpdateCallFlagsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallUpdateCallFlagsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallUpdateCallFlagsResponseApplicationJson
    implements
        $CallUpdateCallFlagsResponseApplicationJsonInterface,
        Built<CallUpdateCallFlagsResponseApplicationJson, CallUpdateCallFlagsResponseApplicationJsonBuilder> {
  /// Creates a new CallUpdateCallFlagsResponseApplicationJson object using the builder pattern.
  factory CallUpdateCallFlagsResponseApplicationJson([
    void Function(CallUpdateCallFlagsResponseApplicationJsonBuilder)? b,
  ]) = _$CallUpdateCallFlagsResponseApplicationJson;

  // coverage:ignore-start
  const CallUpdateCallFlagsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallUpdateCallFlagsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallUpdateCallFlagsResponseApplicationJson.
  static Serializer<CallUpdateCallFlagsResponseApplicationJson> get serializer =>
      _$callUpdateCallFlagsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallUpdateCallFlagsResponseApplicationJsonBuilder b) {
    $CallUpdateCallFlagsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallUpdateCallFlagsResponseApplicationJsonBuilder b) {
    $CallUpdateCallFlagsResponseApplicationJsonInterface._validate(b);
  }
}

class CallJoinCallApiVersion extends EnumClass {
  const CallJoinCallApiVersion._(super.name);

  /// `v4`
  static const CallJoinCallApiVersion v4 = _$callJoinCallApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallJoinCallApiVersion> get values => _$callJoinCallApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallJoinCallApiVersion valueOf(String name) => _$valueOfCallJoinCallApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallJoinCallApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallJoinCallApiVersion> get serializer => const _$CallJoinCallApiVersionSerializer();
}

class _$CallJoinCallApiVersionSerializer implements PrimitiveSerializer<CallJoinCallApiVersion> {
  const _$CallJoinCallApiVersionSerializer();

  static const Map<CallJoinCallApiVersion, Object> _toWire = <CallJoinCallApiVersion, Object>{
    CallJoinCallApiVersion.v4: 'v4',
  };

  static const Map<Object, CallJoinCallApiVersion> _fromWire = <Object, CallJoinCallApiVersion>{
    'v4': CallJoinCallApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallJoinCallApiVersion];

  @override
  String get wireName => 'CallJoinCallApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallJoinCallApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallJoinCallApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallJoinCallRequestApplicationJsonInterface {
  static final _$silent = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$recordingConsent = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  /// In-Call flags.
  int? get flags;

  /// Join the call silently.
  bool get silent;

  /// When the user ticked a checkbox and agreed with being recorded (Only needed when the `config => call => recording-consent` capability is set to {@see RecordingService::CONSENT_REQUIRED_YES} or the capability is {@see RecordingService::CONSENT_REQUIRED_OPTIONAL} and the conversation `recordingConsent` value is {@see RecordingService::CONSENT_REQUIRED_YES} ).
  bool get recordingConsent;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallJoinCallRequestApplicationJsonInterfaceBuilder].
  $CallJoinCallRequestApplicationJsonInterface rebuild(
    void Function($CallJoinCallRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallJoinCallRequestApplicationJsonInterfaceBuilder].
  $CallJoinCallRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallJoinCallRequestApplicationJsonInterfaceBuilder b) {
    b.silent = _$silent;
    b.recordingConsent = _$recordingConsent;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallJoinCallRequestApplicationJsonInterfaceBuilder b) {
    _i4.checkNumber(
      b.flags,
      'flags',
      maximum: 15,
      minimum: 0,
    );
  }
}

abstract class CallJoinCallRequestApplicationJson
    implements
        $CallJoinCallRequestApplicationJsonInterface,
        Built<CallJoinCallRequestApplicationJson, CallJoinCallRequestApplicationJsonBuilder> {
  /// Creates a new CallJoinCallRequestApplicationJson object using the builder pattern.
  factory CallJoinCallRequestApplicationJson([void Function(CallJoinCallRequestApplicationJsonBuilder)? b]) =
      _$CallJoinCallRequestApplicationJson;

  // coverage:ignore-start
  const CallJoinCallRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallJoinCallRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallJoinCallRequestApplicationJson.
  static Serializer<CallJoinCallRequestApplicationJson> get serializer =>
      _$callJoinCallRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallJoinCallRequestApplicationJsonBuilder b) {
    $CallJoinCallRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallJoinCallRequestApplicationJsonBuilder b) {
    $CallJoinCallRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallJoinCallResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallJoinCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallJoinCallResponseApplicationJson_OcsInterface rebuild(
    void Function($CallJoinCallResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallJoinCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallJoinCallResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallJoinCallResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallJoinCallResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallJoinCallResponseApplicationJson_Ocs
    implements
        $CallJoinCallResponseApplicationJson_OcsInterface,
        Built<CallJoinCallResponseApplicationJson_Ocs, CallJoinCallResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallJoinCallResponseApplicationJson_Ocs object using the builder pattern.
  factory CallJoinCallResponseApplicationJson_Ocs([void Function(CallJoinCallResponseApplicationJson_OcsBuilder)? b]) =
      _$CallJoinCallResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallJoinCallResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallJoinCallResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallJoinCallResponseApplicationJson_Ocs.
  static Serializer<CallJoinCallResponseApplicationJson_Ocs> get serializer =>
      _$callJoinCallResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallJoinCallResponseApplicationJson_OcsBuilder b) {
    $CallJoinCallResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallJoinCallResponseApplicationJson_OcsBuilder b) {
    $CallJoinCallResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallJoinCallResponseApplicationJsonInterface {
  CallJoinCallResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallJoinCallResponseApplicationJsonInterfaceBuilder].
  $CallJoinCallResponseApplicationJsonInterface rebuild(
    void Function($CallJoinCallResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallJoinCallResponseApplicationJsonInterfaceBuilder].
  $CallJoinCallResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallJoinCallResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallJoinCallResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallJoinCallResponseApplicationJson
    implements
        $CallJoinCallResponseApplicationJsonInterface,
        Built<CallJoinCallResponseApplicationJson, CallJoinCallResponseApplicationJsonBuilder> {
  /// Creates a new CallJoinCallResponseApplicationJson object using the builder pattern.
  factory CallJoinCallResponseApplicationJson([void Function(CallJoinCallResponseApplicationJsonBuilder)? b]) =
      _$CallJoinCallResponseApplicationJson;

  // coverage:ignore-start
  const CallJoinCallResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallJoinCallResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallJoinCallResponseApplicationJson.
  static Serializer<CallJoinCallResponseApplicationJson> get serializer =>
      _$callJoinCallResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallJoinCallResponseApplicationJsonBuilder b) {
    $CallJoinCallResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallJoinCallResponseApplicationJsonBuilder b) {
    $CallJoinCallResponseApplicationJsonInterface._validate(b);
  }
}

class CallLeaveCallApiVersion extends EnumClass {
  const CallLeaveCallApiVersion._(super.name);

  /// `v4`
  static const CallLeaveCallApiVersion v4 = _$callLeaveCallApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallLeaveCallApiVersion> get values => _$callLeaveCallApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallLeaveCallApiVersion valueOf(String name) => _$valueOfCallLeaveCallApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallLeaveCallApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallLeaveCallApiVersion> get serializer => const _$CallLeaveCallApiVersionSerializer();
}

class _$CallLeaveCallApiVersionSerializer implements PrimitiveSerializer<CallLeaveCallApiVersion> {
  const _$CallLeaveCallApiVersionSerializer();

  static const Map<CallLeaveCallApiVersion, Object> _toWire = <CallLeaveCallApiVersion, Object>{
    CallLeaveCallApiVersion.v4: 'v4',
  };

  static const Map<Object, CallLeaveCallApiVersion> _fromWire = <Object, CallLeaveCallApiVersion>{
    'v4': CallLeaveCallApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallLeaveCallApiVersion];

  @override
  String get wireName => 'CallLeaveCallApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallLeaveCallApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallLeaveCallApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class CallLeaveCallAll extends EnumClass {
  const CallLeaveCallAll._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const CallLeaveCallAll $0 = _$callLeaveCallAll$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const CallLeaveCallAll $1 = _$callLeaveCallAll$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallLeaveCallAll> get values => _$callLeaveCallAllValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallLeaveCallAll valueOf(String name) => _$valueOfCallLeaveCallAll(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for CallLeaveCallAll.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallLeaveCallAll> get serializer => const _$CallLeaveCallAllSerializer();
}

class _$CallLeaveCallAllSerializer implements PrimitiveSerializer<CallLeaveCallAll> {
  const _$CallLeaveCallAllSerializer();

  static const Map<CallLeaveCallAll, Object> _toWire = <CallLeaveCallAll, Object>{
    CallLeaveCallAll.$0: 0,
    CallLeaveCallAll.$1: 1,
  };

  static const Map<Object, CallLeaveCallAll> _fromWire = <Object, CallLeaveCallAll>{
    0: CallLeaveCallAll.$0,
    1: CallLeaveCallAll.$1,
  };

  @override
  Iterable<Type> get types => const [CallLeaveCallAll];

  @override
  String get wireName => 'CallLeaveCallAll';

  @override
  Object serialize(
    Serializers serializers,
    CallLeaveCallAll object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallLeaveCallAll deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallLeaveCallResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallLeaveCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallLeaveCallResponseApplicationJson_OcsInterface rebuild(
    void Function($CallLeaveCallResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallLeaveCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallLeaveCallResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallLeaveCallResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallLeaveCallResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallLeaveCallResponseApplicationJson_Ocs
    implements
        $CallLeaveCallResponseApplicationJson_OcsInterface,
        Built<CallLeaveCallResponseApplicationJson_Ocs, CallLeaveCallResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallLeaveCallResponseApplicationJson_Ocs object using the builder pattern.
  factory CallLeaveCallResponseApplicationJson_Ocs([
    void Function(CallLeaveCallResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CallLeaveCallResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallLeaveCallResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallLeaveCallResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallLeaveCallResponseApplicationJson_Ocs.
  static Serializer<CallLeaveCallResponseApplicationJson_Ocs> get serializer =>
      _$callLeaveCallResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallLeaveCallResponseApplicationJson_OcsBuilder b) {
    $CallLeaveCallResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallLeaveCallResponseApplicationJson_OcsBuilder b) {
    $CallLeaveCallResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallLeaveCallResponseApplicationJsonInterface {
  CallLeaveCallResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallLeaveCallResponseApplicationJsonInterfaceBuilder].
  $CallLeaveCallResponseApplicationJsonInterface rebuild(
    void Function($CallLeaveCallResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallLeaveCallResponseApplicationJsonInterfaceBuilder].
  $CallLeaveCallResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallLeaveCallResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallLeaveCallResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallLeaveCallResponseApplicationJson
    implements
        $CallLeaveCallResponseApplicationJsonInterface,
        Built<CallLeaveCallResponseApplicationJson, CallLeaveCallResponseApplicationJsonBuilder> {
  /// Creates a new CallLeaveCallResponseApplicationJson object using the builder pattern.
  factory CallLeaveCallResponseApplicationJson([void Function(CallLeaveCallResponseApplicationJsonBuilder)? b]) =
      _$CallLeaveCallResponseApplicationJson;

  // coverage:ignore-start
  const CallLeaveCallResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallLeaveCallResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallLeaveCallResponseApplicationJson.
  static Serializer<CallLeaveCallResponseApplicationJson> get serializer =>
      _$callLeaveCallResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallLeaveCallResponseApplicationJsonBuilder b) {
    $CallLeaveCallResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallLeaveCallResponseApplicationJsonBuilder b) {
    $CallLeaveCallResponseApplicationJsonInterface._validate(b);
  }
}

class CallUpdateFederatedCallFlagsApiVersion extends EnumClass {
  const CallUpdateFederatedCallFlagsApiVersion._(super.name);

  /// `v4`
  static const CallUpdateFederatedCallFlagsApiVersion v4 = _$callUpdateFederatedCallFlagsApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallUpdateFederatedCallFlagsApiVersion> get values => _$callUpdateFederatedCallFlagsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallUpdateFederatedCallFlagsApiVersion valueOf(String name) =>
      _$valueOfCallUpdateFederatedCallFlagsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallUpdateFederatedCallFlagsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallUpdateFederatedCallFlagsApiVersion> get serializer =>
      const _$CallUpdateFederatedCallFlagsApiVersionSerializer();
}

class _$CallUpdateFederatedCallFlagsApiVersionSerializer
    implements PrimitiveSerializer<CallUpdateFederatedCallFlagsApiVersion> {
  const _$CallUpdateFederatedCallFlagsApiVersionSerializer();

  static const Map<CallUpdateFederatedCallFlagsApiVersion, Object> _toWire =
      <CallUpdateFederatedCallFlagsApiVersion, Object>{
    CallUpdateFederatedCallFlagsApiVersion.v4: 'v4',
  };

  static const Map<Object, CallUpdateFederatedCallFlagsApiVersion> _fromWire =
      <Object, CallUpdateFederatedCallFlagsApiVersion>{
    'v4': CallUpdateFederatedCallFlagsApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallUpdateFederatedCallFlagsApiVersion];

  @override
  String get wireName => 'CallUpdateFederatedCallFlagsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallUpdateFederatedCallFlagsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallUpdateFederatedCallFlagsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallUpdateFederatedCallFlagsRequestApplicationJsonInterface {
  /// Federated session id to update the flags with.
  String get sessionId;

  /// New flags.
  int get flags;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallUpdateFederatedCallFlagsRequestApplicationJsonInterfaceBuilder].
  $CallUpdateFederatedCallFlagsRequestApplicationJsonInterface rebuild(
    void Function($CallUpdateFederatedCallFlagsRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallUpdateFederatedCallFlagsRequestApplicationJsonInterfaceBuilder].
  $CallUpdateFederatedCallFlagsRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallUpdateFederatedCallFlagsRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallUpdateFederatedCallFlagsRequestApplicationJsonInterfaceBuilder b) {
    _i4.checkNumber(
      b.flags,
      'flags',
      maximum: 15,
      minimum: 0,
    );
  }
}

abstract class CallUpdateFederatedCallFlagsRequestApplicationJson
    implements
        $CallUpdateFederatedCallFlagsRequestApplicationJsonInterface,
        Built<CallUpdateFederatedCallFlagsRequestApplicationJson,
            CallUpdateFederatedCallFlagsRequestApplicationJsonBuilder> {
  /// Creates a new CallUpdateFederatedCallFlagsRequestApplicationJson object using the builder pattern.
  factory CallUpdateFederatedCallFlagsRequestApplicationJson([
    void Function(CallUpdateFederatedCallFlagsRequestApplicationJsonBuilder)? b,
  ]) = _$CallUpdateFederatedCallFlagsRequestApplicationJson;

  // coverage:ignore-start
  const CallUpdateFederatedCallFlagsRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallUpdateFederatedCallFlagsRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallUpdateFederatedCallFlagsRequestApplicationJson.
  static Serializer<CallUpdateFederatedCallFlagsRequestApplicationJson> get serializer =>
      _$callUpdateFederatedCallFlagsRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallUpdateFederatedCallFlagsRequestApplicationJsonBuilder b) {
    $CallUpdateFederatedCallFlagsRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallUpdateFederatedCallFlagsRequestApplicationJsonBuilder b) {
    $CallUpdateFederatedCallFlagsRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterfaceBuilder].
  $CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterface rebuild(
    void Function($CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterfaceBuilder].
  $CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs
    implements
        $CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterface,
        Built<CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs,
            CallUpdateFederatedCallFlagsResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs object using the builder pattern.
  factory CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs([
    void Function(CallUpdateFederatedCallFlagsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs.
  static Serializer<CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs> get serializer =>
      _$callUpdateFederatedCallFlagsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallUpdateFederatedCallFlagsResponseApplicationJson_OcsBuilder b) {
    $CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallUpdateFederatedCallFlagsResponseApplicationJson_OcsBuilder b) {
    $CallUpdateFederatedCallFlagsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallUpdateFederatedCallFlagsResponseApplicationJsonInterface {
  CallUpdateFederatedCallFlagsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallUpdateFederatedCallFlagsResponseApplicationJsonInterfaceBuilder].
  $CallUpdateFederatedCallFlagsResponseApplicationJsonInterface rebuild(
    void Function($CallUpdateFederatedCallFlagsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallUpdateFederatedCallFlagsResponseApplicationJsonInterfaceBuilder].
  $CallUpdateFederatedCallFlagsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallUpdateFederatedCallFlagsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallUpdateFederatedCallFlagsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallUpdateFederatedCallFlagsResponseApplicationJson
    implements
        $CallUpdateFederatedCallFlagsResponseApplicationJsonInterface,
        Built<CallUpdateFederatedCallFlagsResponseApplicationJson,
            CallUpdateFederatedCallFlagsResponseApplicationJsonBuilder> {
  /// Creates a new CallUpdateFederatedCallFlagsResponseApplicationJson object using the builder pattern.
  factory CallUpdateFederatedCallFlagsResponseApplicationJson([
    void Function(CallUpdateFederatedCallFlagsResponseApplicationJsonBuilder)? b,
  ]) = _$CallUpdateFederatedCallFlagsResponseApplicationJson;

  // coverage:ignore-start
  const CallUpdateFederatedCallFlagsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallUpdateFederatedCallFlagsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallUpdateFederatedCallFlagsResponseApplicationJson.
  static Serializer<CallUpdateFederatedCallFlagsResponseApplicationJson> get serializer =>
      _$callUpdateFederatedCallFlagsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallUpdateFederatedCallFlagsResponseApplicationJsonBuilder b) {
    $CallUpdateFederatedCallFlagsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallUpdateFederatedCallFlagsResponseApplicationJsonBuilder b) {
    $CallUpdateFederatedCallFlagsResponseApplicationJsonInterface._validate(b);
  }
}

class CallJoinFederatedCallApiVersion extends EnumClass {
  const CallJoinFederatedCallApiVersion._(super.name);

  /// `v4`
  static const CallJoinFederatedCallApiVersion v4 = _$callJoinFederatedCallApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallJoinFederatedCallApiVersion> get values => _$callJoinFederatedCallApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallJoinFederatedCallApiVersion valueOf(String name) => _$valueOfCallJoinFederatedCallApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallJoinFederatedCallApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallJoinFederatedCallApiVersion> get serializer =>
      const _$CallJoinFederatedCallApiVersionSerializer();
}

class _$CallJoinFederatedCallApiVersionSerializer implements PrimitiveSerializer<CallJoinFederatedCallApiVersion> {
  const _$CallJoinFederatedCallApiVersionSerializer();

  static const Map<CallJoinFederatedCallApiVersion, Object> _toWire = <CallJoinFederatedCallApiVersion, Object>{
    CallJoinFederatedCallApiVersion.v4: 'v4',
  };

  static const Map<Object, CallJoinFederatedCallApiVersion> _fromWire = <Object, CallJoinFederatedCallApiVersion>{
    'v4': CallJoinFederatedCallApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallJoinFederatedCallApiVersion];

  @override
  String get wireName => 'CallJoinFederatedCallApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallJoinFederatedCallApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallJoinFederatedCallApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallJoinFederatedCallRequestApplicationJsonInterface {
  static final _$silent = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$recordingConsent = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  /// Federated session id to join with.
  String get sessionId;

  /// In-Call flags.
  int? get flags;

  /// Join the call silently.
  bool get silent;

  /// Agreement to be recorded.
  bool get recordingConsent;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallJoinFederatedCallRequestApplicationJsonInterfaceBuilder].
  $CallJoinFederatedCallRequestApplicationJsonInterface rebuild(
    void Function($CallJoinFederatedCallRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallJoinFederatedCallRequestApplicationJsonInterfaceBuilder].
  $CallJoinFederatedCallRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallJoinFederatedCallRequestApplicationJsonInterfaceBuilder b) {
    b.silent = _$silent;
    b.recordingConsent = _$recordingConsent;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallJoinFederatedCallRequestApplicationJsonInterfaceBuilder b) {
    _i4.checkNumber(
      b.flags,
      'flags',
      maximum: 15,
      minimum: 0,
    );
  }
}

abstract class CallJoinFederatedCallRequestApplicationJson
    implements
        $CallJoinFederatedCallRequestApplicationJsonInterface,
        Built<CallJoinFederatedCallRequestApplicationJson, CallJoinFederatedCallRequestApplicationJsonBuilder> {
  /// Creates a new CallJoinFederatedCallRequestApplicationJson object using the builder pattern.
  factory CallJoinFederatedCallRequestApplicationJson([
    void Function(CallJoinFederatedCallRequestApplicationJsonBuilder)? b,
  ]) = _$CallJoinFederatedCallRequestApplicationJson;

  // coverage:ignore-start
  const CallJoinFederatedCallRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallJoinFederatedCallRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallJoinFederatedCallRequestApplicationJson.
  static Serializer<CallJoinFederatedCallRequestApplicationJson> get serializer =>
      _$callJoinFederatedCallRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallJoinFederatedCallRequestApplicationJsonBuilder b) {
    $CallJoinFederatedCallRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallJoinFederatedCallRequestApplicationJsonBuilder b) {
    $CallJoinFederatedCallRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallJoinFederatedCallResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallJoinFederatedCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallJoinFederatedCallResponseApplicationJson_OcsInterface rebuild(
    void Function($CallJoinFederatedCallResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallJoinFederatedCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallJoinFederatedCallResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallJoinFederatedCallResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallJoinFederatedCallResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallJoinFederatedCallResponseApplicationJson_Ocs
    implements
        $CallJoinFederatedCallResponseApplicationJson_OcsInterface,
        Built<CallJoinFederatedCallResponseApplicationJson_Ocs,
            CallJoinFederatedCallResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallJoinFederatedCallResponseApplicationJson_Ocs object using the builder pattern.
  factory CallJoinFederatedCallResponseApplicationJson_Ocs([
    void Function(CallJoinFederatedCallResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CallJoinFederatedCallResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallJoinFederatedCallResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallJoinFederatedCallResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallJoinFederatedCallResponseApplicationJson_Ocs.
  static Serializer<CallJoinFederatedCallResponseApplicationJson_Ocs> get serializer =>
      _$callJoinFederatedCallResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallJoinFederatedCallResponseApplicationJson_OcsBuilder b) {
    $CallJoinFederatedCallResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallJoinFederatedCallResponseApplicationJson_OcsBuilder b) {
    $CallJoinFederatedCallResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallJoinFederatedCallResponseApplicationJsonInterface {
  CallJoinFederatedCallResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallJoinFederatedCallResponseApplicationJsonInterfaceBuilder].
  $CallJoinFederatedCallResponseApplicationJsonInterface rebuild(
    void Function($CallJoinFederatedCallResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallJoinFederatedCallResponseApplicationJsonInterfaceBuilder].
  $CallJoinFederatedCallResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallJoinFederatedCallResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallJoinFederatedCallResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallJoinFederatedCallResponseApplicationJson
    implements
        $CallJoinFederatedCallResponseApplicationJsonInterface,
        Built<CallJoinFederatedCallResponseApplicationJson, CallJoinFederatedCallResponseApplicationJsonBuilder> {
  /// Creates a new CallJoinFederatedCallResponseApplicationJson object using the builder pattern.
  factory CallJoinFederatedCallResponseApplicationJson([
    void Function(CallJoinFederatedCallResponseApplicationJsonBuilder)? b,
  ]) = _$CallJoinFederatedCallResponseApplicationJson;

  // coverage:ignore-start
  const CallJoinFederatedCallResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallJoinFederatedCallResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallJoinFederatedCallResponseApplicationJson.
  static Serializer<CallJoinFederatedCallResponseApplicationJson> get serializer =>
      _$callJoinFederatedCallResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallJoinFederatedCallResponseApplicationJsonBuilder b) {
    $CallJoinFederatedCallResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallJoinFederatedCallResponseApplicationJsonBuilder b) {
    $CallJoinFederatedCallResponseApplicationJsonInterface._validate(b);
  }
}

class CallLeaveFederatedCallApiVersion extends EnumClass {
  const CallLeaveFederatedCallApiVersion._(super.name);

  /// `v4`
  static const CallLeaveFederatedCallApiVersion v4 = _$callLeaveFederatedCallApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallLeaveFederatedCallApiVersion> get values => _$callLeaveFederatedCallApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallLeaveFederatedCallApiVersion valueOf(String name) => _$valueOfCallLeaveFederatedCallApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallLeaveFederatedCallApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallLeaveFederatedCallApiVersion> get serializer =>
      const _$CallLeaveFederatedCallApiVersionSerializer();
}

class _$CallLeaveFederatedCallApiVersionSerializer implements PrimitiveSerializer<CallLeaveFederatedCallApiVersion> {
  const _$CallLeaveFederatedCallApiVersionSerializer();

  static const Map<CallLeaveFederatedCallApiVersion, Object> _toWire = <CallLeaveFederatedCallApiVersion, Object>{
    CallLeaveFederatedCallApiVersion.v4: 'v4',
  };

  static const Map<Object, CallLeaveFederatedCallApiVersion> _fromWire = <Object, CallLeaveFederatedCallApiVersion>{
    'v4': CallLeaveFederatedCallApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallLeaveFederatedCallApiVersion];

  @override
  String get wireName => 'CallLeaveFederatedCallApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallLeaveFederatedCallApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallLeaveFederatedCallApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallLeaveFederatedCallResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallLeaveFederatedCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallLeaveFederatedCallResponseApplicationJson_OcsInterface rebuild(
    void Function($CallLeaveFederatedCallResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallLeaveFederatedCallResponseApplicationJson_OcsInterfaceBuilder].
  $CallLeaveFederatedCallResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallLeaveFederatedCallResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallLeaveFederatedCallResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallLeaveFederatedCallResponseApplicationJson_Ocs
    implements
        $CallLeaveFederatedCallResponseApplicationJson_OcsInterface,
        Built<CallLeaveFederatedCallResponseApplicationJson_Ocs,
            CallLeaveFederatedCallResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallLeaveFederatedCallResponseApplicationJson_Ocs object using the builder pattern.
  factory CallLeaveFederatedCallResponseApplicationJson_Ocs([
    void Function(CallLeaveFederatedCallResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CallLeaveFederatedCallResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallLeaveFederatedCallResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallLeaveFederatedCallResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallLeaveFederatedCallResponseApplicationJson_Ocs.
  static Serializer<CallLeaveFederatedCallResponseApplicationJson_Ocs> get serializer =>
      _$callLeaveFederatedCallResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallLeaveFederatedCallResponseApplicationJson_OcsBuilder b) {
    $CallLeaveFederatedCallResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallLeaveFederatedCallResponseApplicationJson_OcsBuilder b) {
    $CallLeaveFederatedCallResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallLeaveFederatedCallResponseApplicationJsonInterface {
  CallLeaveFederatedCallResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallLeaveFederatedCallResponseApplicationJsonInterfaceBuilder].
  $CallLeaveFederatedCallResponseApplicationJsonInterface rebuild(
    void Function($CallLeaveFederatedCallResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallLeaveFederatedCallResponseApplicationJsonInterfaceBuilder].
  $CallLeaveFederatedCallResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallLeaveFederatedCallResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallLeaveFederatedCallResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallLeaveFederatedCallResponseApplicationJson
    implements
        $CallLeaveFederatedCallResponseApplicationJsonInterface,
        Built<CallLeaveFederatedCallResponseApplicationJson, CallLeaveFederatedCallResponseApplicationJsonBuilder> {
  /// Creates a new CallLeaveFederatedCallResponseApplicationJson object using the builder pattern.
  factory CallLeaveFederatedCallResponseApplicationJson([
    void Function(CallLeaveFederatedCallResponseApplicationJsonBuilder)? b,
  ]) = _$CallLeaveFederatedCallResponseApplicationJson;

  // coverage:ignore-start
  const CallLeaveFederatedCallResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallLeaveFederatedCallResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallLeaveFederatedCallResponseApplicationJson.
  static Serializer<CallLeaveFederatedCallResponseApplicationJson> get serializer =>
      _$callLeaveFederatedCallResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallLeaveFederatedCallResponseApplicationJsonBuilder b) {
    $CallLeaveFederatedCallResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallLeaveFederatedCallResponseApplicationJsonBuilder b) {
    $CallLeaveFederatedCallResponseApplicationJsonInterface._validate(b);
  }
}

class CallRingAttendeeApiVersion extends EnumClass {
  const CallRingAttendeeApiVersion._(super.name);

  /// `v4`
  static const CallRingAttendeeApiVersion v4 = _$callRingAttendeeApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallRingAttendeeApiVersion> get values => _$callRingAttendeeApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallRingAttendeeApiVersion valueOf(String name) => _$valueOfCallRingAttendeeApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallRingAttendeeApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallRingAttendeeApiVersion> get serializer => const _$CallRingAttendeeApiVersionSerializer();
}

class _$CallRingAttendeeApiVersionSerializer implements PrimitiveSerializer<CallRingAttendeeApiVersion> {
  const _$CallRingAttendeeApiVersionSerializer();

  static const Map<CallRingAttendeeApiVersion, Object> _toWire = <CallRingAttendeeApiVersion, Object>{
    CallRingAttendeeApiVersion.v4: 'v4',
  };

  static const Map<Object, CallRingAttendeeApiVersion> _fromWire = <Object, CallRingAttendeeApiVersion>{
    'v4': CallRingAttendeeApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallRingAttendeeApiVersion];

  @override
  String get wireName => 'CallRingAttendeeApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallRingAttendeeApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallRingAttendeeApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallRingAttendeeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallRingAttendeeResponseApplicationJson_OcsInterfaceBuilder].
  $CallRingAttendeeResponseApplicationJson_OcsInterface rebuild(
    void Function($CallRingAttendeeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallRingAttendeeResponseApplicationJson_OcsInterfaceBuilder].
  $CallRingAttendeeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallRingAttendeeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallRingAttendeeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallRingAttendeeResponseApplicationJson_Ocs
    implements
        $CallRingAttendeeResponseApplicationJson_OcsInterface,
        Built<CallRingAttendeeResponseApplicationJson_Ocs, CallRingAttendeeResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallRingAttendeeResponseApplicationJson_Ocs object using the builder pattern.
  factory CallRingAttendeeResponseApplicationJson_Ocs([
    void Function(CallRingAttendeeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CallRingAttendeeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallRingAttendeeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallRingAttendeeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallRingAttendeeResponseApplicationJson_Ocs.
  static Serializer<CallRingAttendeeResponseApplicationJson_Ocs> get serializer =>
      _$callRingAttendeeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallRingAttendeeResponseApplicationJson_OcsBuilder b) {
    $CallRingAttendeeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallRingAttendeeResponseApplicationJson_OcsBuilder b) {
    $CallRingAttendeeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallRingAttendeeResponseApplicationJsonInterface {
  CallRingAttendeeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallRingAttendeeResponseApplicationJsonInterfaceBuilder].
  $CallRingAttendeeResponseApplicationJsonInterface rebuild(
    void Function($CallRingAttendeeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallRingAttendeeResponseApplicationJsonInterfaceBuilder].
  $CallRingAttendeeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallRingAttendeeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallRingAttendeeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallRingAttendeeResponseApplicationJson
    implements
        $CallRingAttendeeResponseApplicationJsonInterface,
        Built<CallRingAttendeeResponseApplicationJson, CallRingAttendeeResponseApplicationJsonBuilder> {
  /// Creates a new CallRingAttendeeResponseApplicationJson object using the builder pattern.
  factory CallRingAttendeeResponseApplicationJson([void Function(CallRingAttendeeResponseApplicationJsonBuilder)? b]) =
      _$CallRingAttendeeResponseApplicationJson;

  // coverage:ignore-start
  const CallRingAttendeeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallRingAttendeeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallRingAttendeeResponseApplicationJson.
  static Serializer<CallRingAttendeeResponseApplicationJson> get serializer =>
      _$callRingAttendeeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallRingAttendeeResponseApplicationJsonBuilder b) {
    $CallRingAttendeeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallRingAttendeeResponseApplicationJsonBuilder b) {
    $CallRingAttendeeResponseApplicationJsonInterface._validate(b);
  }
}

class CallSipDialOutApiVersion extends EnumClass {
  const CallSipDialOutApiVersion._(super.name);

  /// `v4`
  static const CallSipDialOutApiVersion v4 = _$callSipDialOutApiVersionV4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<CallSipDialOutApiVersion> get values => _$callSipDialOutApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static CallSipDialOutApiVersion valueOf(String name) => _$valueOfCallSipDialOutApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for CallSipDialOutApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<CallSipDialOutApiVersion> get serializer => const _$CallSipDialOutApiVersionSerializer();
}

class _$CallSipDialOutApiVersionSerializer implements PrimitiveSerializer<CallSipDialOutApiVersion> {
  const _$CallSipDialOutApiVersionSerializer();

  static const Map<CallSipDialOutApiVersion, Object> _toWire = <CallSipDialOutApiVersion, Object>{
    CallSipDialOutApiVersion.v4: 'v4',
  };

  static const Map<Object, CallSipDialOutApiVersion> _fromWire = <Object, CallSipDialOutApiVersion>{
    'v4': CallSipDialOutApiVersion.v4,
  };

  @override
  Iterable<Type> get types => const [CallSipDialOutApiVersion];

  @override
  String get wireName => 'CallSipDialOutApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    CallSipDialOutApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  CallSipDialOutApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $CallSipDialOutResponseApplicationJson_Ocs_DataInterface {
  String? get error;
  String? get message;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallSipDialOutResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $CallSipDialOutResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($CallSipDialOutResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallSipDialOutResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $CallSipDialOutResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallSipDialOutResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallSipDialOutResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class CallSipDialOutResponseApplicationJson_Ocs_Data
    implements
        $CallSipDialOutResponseApplicationJson_Ocs_DataInterface,
        Built<CallSipDialOutResponseApplicationJson_Ocs_Data, CallSipDialOutResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new CallSipDialOutResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory CallSipDialOutResponseApplicationJson_Ocs_Data([
    void Function(CallSipDialOutResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$CallSipDialOutResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const CallSipDialOutResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallSipDialOutResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallSipDialOutResponseApplicationJson_Ocs_Data.
  static Serializer<CallSipDialOutResponseApplicationJson_Ocs_Data> get serializer =>
      _$callSipDialOutResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallSipDialOutResponseApplicationJson_Ocs_DataBuilder b) {
    $CallSipDialOutResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallSipDialOutResponseApplicationJson_Ocs_DataBuilder b) {
    $CallSipDialOutResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallSipDialOutResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  CallSipDialOutResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallSipDialOutResponseApplicationJson_OcsInterfaceBuilder].
  $CallSipDialOutResponseApplicationJson_OcsInterface rebuild(
    void Function($CallSipDialOutResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallSipDialOutResponseApplicationJson_OcsInterfaceBuilder].
  $CallSipDialOutResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallSipDialOutResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallSipDialOutResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CallSipDialOutResponseApplicationJson_Ocs
    implements
        $CallSipDialOutResponseApplicationJson_OcsInterface,
        Built<CallSipDialOutResponseApplicationJson_Ocs, CallSipDialOutResponseApplicationJson_OcsBuilder> {
  /// Creates a new CallSipDialOutResponseApplicationJson_Ocs object using the builder pattern.
  factory CallSipDialOutResponseApplicationJson_Ocs([
    void Function(CallSipDialOutResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CallSipDialOutResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CallSipDialOutResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallSipDialOutResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallSipDialOutResponseApplicationJson_Ocs.
  static Serializer<CallSipDialOutResponseApplicationJson_Ocs> get serializer =>
      _$callSipDialOutResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallSipDialOutResponseApplicationJson_OcsBuilder b) {
    $CallSipDialOutResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallSipDialOutResponseApplicationJson_OcsBuilder b) {
    $CallSipDialOutResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CallSipDialOutResponseApplicationJsonInterface {
  CallSipDialOutResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CallSipDialOutResponseApplicationJsonInterfaceBuilder].
  $CallSipDialOutResponseApplicationJsonInterface rebuild(
    void Function($CallSipDialOutResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CallSipDialOutResponseApplicationJsonInterfaceBuilder].
  $CallSipDialOutResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CallSipDialOutResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CallSipDialOutResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CallSipDialOutResponseApplicationJson
    implements
        $CallSipDialOutResponseApplicationJsonInterface,
        Built<CallSipDialOutResponseApplicationJson, CallSipDialOutResponseApplicationJsonBuilder> {
  /// Creates a new CallSipDialOutResponseApplicationJson object using the builder pattern.
  factory CallSipDialOutResponseApplicationJson([void Function(CallSipDialOutResponseApplicationJsonBuilder)? b]) =
      _$CallSipDialOutResponseApplicationJson;

  // coverage:ignore-start
  const CallSipDialOutResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CallSipDialOutResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CallSipDialOutResponseApplicationJson.
  static Serializer<CallSipDialOutResponseApplicationJson> get serializer =>
      _$callSipDialOutResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CallSipDialOutResponseApplicationJsonBuilder b) {
    $CallSipDialOutResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CallSipDialOutResponseApplicationJsonBuilder b) {
    $CallSipDialOutResponseApplicationJsonInterface._validate(b);
  }
}

class ChatReceiveMessagesLookIntoFuture extends EnumClass {
  const ChatReceiveMessagesLookIntoFuture._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ChatReceiveMessagesLookIntoFuture $0 = _$chatReceiveMessagesLookIntoFuture$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ChatReceiveMessagesLookIntoFuture $1 = _$chatReceiveMessagesLookIntoFuture$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ChatReceiveMessagesLookIntoFuture> get values => _$chatReceiveMessagesLookIntoFutureValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ChatReceiveMessagesLookIntoFuture valueOf(String name) => _$valueOfChatReceiveMessagesLookIntoFuture(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ChatReceiveMessagesLookIntoFuture.
  @BuiltValueSerializer(custom: true)
  static Serializer<ChatReceiveMessagesLookIntoFuture> get serializer =>
      const _$ChatReceiveMessagesLookIntoFutureSerializer();
}

class _$ChatReceiveMessagesLookIntoFutureSerializer implements PrimitiveSerializer<ChatReceiveMessagesLookIntoFuture> {
  const _$ChatReceiveMessagesLookIntoFutureSerializer();

  static const Map<ChatReceiveMessagesLookIntoFuture, Object> _toWire = <ChatReceiveMessagesLookIntoFuture, Object>{
    ChatReceiveMessagesLookIntoFuture.$0: 0,
    ChatReceiveMessagesLookIntoFuture.$1: 1,
  };

  static const Map<Object, ChatReceiveMessagesLookIntoFuture> _fromWire = <Object, ChatReceiveMessagesLookIntoFuture>{
    0: ChatReceiveMessagesLookIntoFuture.$0,
    1: ChatReceiveMessagesLookIntoFuture.$1,
  };

  @override
  Iterable<Type> get types => const [ChatReceiveMessagesLookIntoFuture];

  @override
  String get wireName => 'ChatReceiveMessagesLookIntoFuture';

  @override
  Object serialize(
    Serializers serializers,
    ChatReceiveMessagesLookIntoFuture object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ChatReceiveMessagesLookIntoFuture deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class ChatReceiveMessagesApiVersion extends EnumClass {
  const ChatReceiveMessagesApiVersion._(super.name);

  /// `v1`
  static const ChatReceiveMessagesApiVersion v1 = _$chatReceiveMessagesApiVersionV1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ChatReceiveMessagesApiVersion> get values => _$chatReceiveMessagesApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ChatReceiveMessagesApiVersion valueOf(String name) => _$valueOfChatReceiveMessagesApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ChatReceiveMessagesApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<ChatReceiveMessagesApiVersion> get serializer => const _$ChatReceiveMessagesApiVersionSerializer();
}

class _$ChatReceiveMessagesApiVersionSerializer implements PrimitiveSerializer<ChatReceiveMessagesApiVersion> {
  const _$ChatReceiveMessagesApiVersionSerializer();

  static const Map<ChatReceiveMessagesApiVersion, Object> _toWire = <ChatReceiveMessagesApiVersion, Object>{
    ChatReceiveMessagesApiVersion.v1: 'v1',
  };

  static const Map<Object, ChatReceiveMessagesApiVersion> _fromWire = <Object, ChatReceiveMessagesApiVersion>{
    'v1': ChatReceiveMessagesApiVersion.v1,
  };

  @override
  Iterable<Type> get types => const [ChatReceiveMessagesApiVersion];

  @override
  String get wireName => 'ChatReceiveMessagesApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    ChatReceiveMessagesApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ChatReceiveMessagesApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class ChatReceiveMessagesSetReadMarker extends EnumClass {
  const ChatReceiveMessagesSetReadMarker._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ChatReceiveMessagesSetReadMarker $0 = _$chatReceiveMessagesSetReadMarker$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ChatReceiveMessagesSetReadMarker $1 = _$chatReceiveMessagesSetReadMarker$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ChatReceiveMessagesSetReadMarker> get values => _$chatReceiveMessagesSetReadMarkerValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ChatReceiveMessagesSetReadMarker valueOf(String name) => _$valueOfChatReceiveMessagesSetReadMarker(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ChatReceiveMessagesSetReadMarker.
  @BuiltValueSerializer(custom: true)
  static Serializer<ChatReceiveMessagesSetReadMarker> get serializer =>
      const _$ChatReceiveMessagesSetReadMarkerSerializer();
}

class _$ChatReceiveMessagesSetReadMarkerSerializer implements PrimitiveSerializer<ChatReceiveMessagesSetReadMarker> {
  const _$ChatReceiveMessagesSetReadMarkerSerializer();

  static const Map<ChatReceiveMessagesSetReadMarker, Object> _toWire = <ChatReceiveMessagesSetReadMarker, Object>{
    ChatReceiveMessagesSetReadMarker.$0: 0,
    ChatReceiveMessagesSetReadMarker.$1: 1,
  };

  static const Map<Object, ChatReceiveMessagesSetReadMarker> _fromWire = <Object, ChatReceiveMessagesSetReadMarker>{
    0: ChatReceiveMessagesSetReadMarker.$0,
    1: ChatReceiveMessagesSetReadMarker.$1,
  };

  @override
  Iterable<Type> get types => const [ChatReceiveMessagesSetReadMarker];

  @override
  String get wireName => 'ChatReceiveMessagesSetReadMarker';

  @override
  Object serialize(
    Serializers serializers,
    ChatReceiveMessagesSetReadMarker object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ChatReceiveMessagesSetReadMarker deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class ChatReceiveMessagesIncludeLastKnown extends EnumClass {
  const ChatReceiveMessagesIncludeLastKnown._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ChatReceiveMessagesIncludeLastKnown $0 = _$chatReceiveMessagesIncludeLastKnown$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ChatReceiveMessagesIncludeLastKnown $1 = _$chatReceiveMessagesIncludeLastKnown$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ChatReceiveMessagesIncludeLastKnown> get values => _$chatReceiveMessagesIncludeLastKnownValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ChatReceiveMessagesIncludeLastKnown valueOf(String name) => _$valueOfChatReceiveMessagesIncludeLastKnown(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ChatReceiveMessagesIncludeLastKnown.
  @BuiltValueSerializer(custom: true)
  static Serializer<ChatReceiveMessagesIncludeLastKnown> get serializer =>
      const _$ChatReceiveMessagesIncludeLastKnownSerializer();
}

class _$ChatReceiveMessagesIncludeLastKnownSerializer
    implements PrimitiveSerializer<ChatReceiveMessagesIncludeLastKnown> {
  const _$ChatReceiveMessagesIncludeLastKnownSerializer();

  static const Map<ChatReceiveMessagesIncludeLastKnown, Object> _toWire = <ChatReceiveMessagesIncludeLastKnown, Object>{
    ChatReceiveMessagesIncludeLastKnown.$0: 0,
    ChatReceiveMessagesIncludeLastKnown.$1: 1,
  };

  static const Map<Object, ChatReceiveMessagesIncludeLastKnown> _fromWire =
      <Object, ChatReceiveMessagesIncludeLastKnown>{
    0: ChatReceiveMessagesIncludeLastKnown.$0,
    1: ChatReceiveMessagesIncludeLastKnown.$1,
  };

  @override
  Iterable<Type> get types => const [ChatReceiveMessagesIncludeLastKnown];

  @override
  String get wireName => 'ChatReceiveMessagesIncludeLastKnown';

  @override
  Object serialize(
    Serializers serializers,
    ChatReceiveMessagesIncludeLastKnown object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ChatReceiveMessagesIncludeLastKnown deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class ChatReceiveMessagesNoStatusUpdate extends EnumClass {
  const ChatReceiveMessagesNoStatusUpdate._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ChatReceiveMessagesNoStatusUpdate $0 = _$chatReceiveMessagesNoStatusUpdate$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ChatReceiveMessagesNoStatusUpdate $1 = _$chatReceiveMessagesNoStatusUpdate$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ChatReceiveMessagesNoStatusUpdate> get values => _$chatReceiveMessagesNoStatusUpdateValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ChatReceiveMessagesNoStatusUpdate valueOf(String name) => _$valueOfChatReceiveMessagesNoStatusUpdate(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ChatReceiveMessagesNoStatusUpdate.
  @BuiltValueSerializer(custom: true)
  static Serializer<ChatReceiveMessagesNoStatusUpdate> get serializer =>
      const _$ChatReceiveMessagesNoStatusUpdateSerializer();
}

class _$ChatReceiveMessagesNoStatusUpdateSerializer implements PrimitiveSerializer<ChatReceiveMessagesNoStatusUpdate> {
  const _$ChatReceiveMessagesNoStatusUpdateSerializer();

  static const Map<ChatReceiveMessagesNoStatusUpdate, Object> _toWire = <ChatReceiveMessagesNoStatusUpdate, Object>{
    ChatReceiveMessagesNoStatusUpdate.$0: 0,
    ChatReceiveMessagesNoStatusUpdate.$1: 1,
  };

  static const Map<Object, ChatReceiveMessagesNoStatusUpdate> _fromWire = <Object, ChatReceiveMessagesNoStatusUpdate>{
    0: ChatReceiveMessagesNoStatusUpdate.$0,
    1: ChatReceiveMessagesNoStatusUpdate.$1,
  };

  @override
  Iterable<Type> get types => const [ChatReceiveMessagesNoStatusUpdate];

  @override
  String get wireName => 'ChatReceiveMessagesNoStatusUpdate';

  @override
  Object serialize(
    Serializers serializers,
    ChatReceiveMessagesNoStatusUpdate object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ChatReceiveMessagesNoStatusUpdate deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class ChatReceiveMessagesMarkNotificationsAsRead extends EnumClass {
  const ChatReceiveMessagesMarkNotificationsAsRead._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ChatReceiveMessagesMarkNotificationsAsRead $0 = _$chatReceiveMessagesMarkNotificationsAsRead$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ChatReceiveMessagesMarkNotificationsAsRead $1 = _$chatReceiveMessagesMarkNotificationsAsRead$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ChatReceiveMessagesMarkNotificationsAsRead> get values =>
      _$chatReceiveMessagesMarkNotificationsAsReadValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ChatReceiveMessagesMarkNotificationsAsRead valueOf(String name) =>
      _$valueOfChatReceiveMessagesMarkNotificationsAsRead(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ChatReceiveMessagesMarkNotificationsAsRead.
  @BuiltValueSerializer(custom: true)
  static Serializer<ChatReceiveMessagesMarkNotificationsAsRead> get serializer =>
      const _$ChatReceiveMessagesMarkNotificationsAsReadSerializer();
}

class _$ChatReceiveMessagesMarkNotificationsAsReadSerializer
    implements PrimitiveSerializer<ChatReceiveMessagesMarkNotificationsAsRead> {
  const _$ChatReceiveMessagesMarkNotificationsAsReadSerializer();

  static const Map<ChatReceiveMessagesMarkNotificationsAsRead, Object> _toWire =
      <ChatReceiveMessagesMarkNotificationsAsRead, Object>{
    ChatReceiveMessagesMarkNotificationsAsRead.$0: 0,
    ChatReceiveMessagesMarkNotificationsAsRead.$1: 1,
  };

  static const Map<Object, ChatReceiveMessagesMarkNotificationsAsRead> _fromWire =
      <Object, ChatReceiveMessagesMarkNotificationsAsRead>{
    0: ChatReceiveMessagesMarkNotificationsAsRead.$0,
    1: ChatReceiveMessagesMarkNotificationsAsRead.$1,
  };

  @override
  Iterable<Type> get types => const [ChatReceiveMessagesMarkNotificationsAsRead];

  @override
  String get wireName => 'ChatReceiveMessagesMarkNotificationsAsRead';

  @override
  Object serialize(
    Serializers serializers,
    ChatReceiveMessagesMarkNotificationsAsRead object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ChatReceiveMessagesMarkNotificationsAsRead deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class DeletedChatMessage_Deleted extends EnumClass {
  const DeletedChatMessage_Deleted._(super.name);

  /// `true`
  @BuiltValueEnumConst(wireName: 'true')
  static const DeletedChatMessage_Deleted $true = _$deletedChatMessageDeleted$true;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<DeletedChatMessage_Deleted> get values => _$deletedChatMessageDeletedValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static DeletedChatMessage_Deleted valueOf(String name) => _$valueOfDeletedChatMessage_Deleted(name);

  /// Returns the serialized value of this enum value.
  bool get value => _$jsonSerializers.serializeWith(serializer, this)! as bool;

  /// Serializer for DeletedChatMessage_Deleted.
  @BuiltValueSerializer(custom: true)
  static Serializer<DeletedChatMessage_Deleted> get serializer => const _$DeletedChatMessage_DeletedSerializer();
}

class _$DeletedChatMessage_DeletedSerializer implements PrimitiveSerializer<DeletedChatMessage_Deleted> {
  const _$DeletedChatMessage_DeletedSerializer();

  static const Map<DeletedChatMessage_Deleted, Object> _toWire = <DeletedChatMessage_Deleted, Object>{
    DeletedChatMessage_Deleted.$true: true,
  };

  static const Map<Object, DeletedChatMessage_Deleted> _fromWire = <Object, DeletedChatMessage_Deleted>{
    true: DeletedChatMessage_Deleted.$true,
  };

  @override
  Iterable<Type> get types => const [DeletedChatMessage_Deleted];

  @override
  String get wireName => 'DeletedChatMessage_Deleted';

  @override
  Object serialize(
    Serializers serializers,
    DeletedChatMessage_Deleted object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  DeletedChatMessage_Deleted deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $DeletedChatMessageInterface {
  int get id;
  DeletedChatMessage_Deleted get deleted;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DeletedChatMessageInterfaceBuilder].
  $DeletedChatMessageInterface rebuild(void Function($DeletedChatMessageInterfaceBuilder) updates);

  /// Converts the instance to a builder [$DeletedChatMessageInterfaceBuilder].
  $DeletedChatMessageInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DeletedChatMessageInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DeletedChatMessageInterfaceBuilder b) {}
}

abstract class DeletedChatMessage
    implements $DeletedChatMessageInterface, Built<DeletedChatMessage, DeletedChatMessageBuilder> {
  /// Creates a new DeletedChatMessage object using the builder pattern.
  factory DeletedChatMessage([void Function(DeletedChatMessageBuilder)? b]) = _$DeletedChatMessage;

  // coverage:ignore-start
  const DeletedChatMessage._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DeletedChatMessage.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DeletedChatMessage.
  static Serializer<DeletedChatMessage> get serializer => _$deletedChatMessageSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DeletedChatMessageBuilder b) {
    $DeletedChatMessageInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DeletedChatMessageBuilder b) {
    $DeletedChatMessageInterface._validate(b);
  }
}

typedef ChatMessageWithParent_Parent = ({ChatMessage? chatMessage, DeletedChatMessage? deletedChatMessage});

@BuiltValue(instantiable: false)
sealed class $ChatMessageWithParentInterface implements $ChatMessageInterface {
  ChatMessageWithParent_Parent? get parent;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ChatMessageWithParentInterfaceBuilder].
 