// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// provisioning_api Version: 0.0.1.
///
/// This application enables a set of APIs that external systems can use to manage accounts, groups and apps.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i5;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i6;

part 'provisioning_api.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $AppConfigClient appConfig = $AppConfigClient(this);

  late final $AppsClient apps = $AppsClient(this);

  late final $GroupsClient groups = $GroupsClient(this);

  late final $PreferencesClient preferences = $PreferencesClient(this);

  late final $UsersClient users = $UsersClient(this);
}

class $AppConfigClient {
  /// Creates a new `DynamiteClient` for app_config requests.
  $AppConfigClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getApps_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppConfigGetAppsResponseApplicationJson, void> $getApps_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(AppConfigGetAppsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of apps.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getApps] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Apps returned
  ///
  /// See:
  ///  * [getApps] for a method executing this request and parsing the response.
  ///  * [$getApps_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getApps_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/provisioning_api/api/v1/config/apps';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of apps.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Apps returned
  ///
  /// See:
  ///  * [$getApps_Request] for the request send by this method.
  ///  * [$getApps_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppConfigGetAppsResponseApplicationJson, void>> getApps({bool? oCSAPIRequest}) async {
    final _request = $getApps_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getApps_Serializer();
    return _i1.ResponseConverter<AppConfigGetAppsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getKeys_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppConfigGetKeysResponseApplicationJson, void> $getKeys_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(AppConfigGetKeysResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the config keys of an app.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getKeys] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Keys returned
  ///   * 403: App is not allowed
  ///
  /// See:
  ///  * [getKeys] for a method executing this request and parsing the response.
  ///  * [$getKeys_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getKeys_Request({
    required String app,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    _parameters['app'] = __app;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/provisioning_api/api/v1/config/apps/{app}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the config keys of an app.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Keys returned
  ///   * 403: App is not allowed
  ///
  /// See:
  ///  * [$getKeys_Request] for the request send by this method.
  ///  * [$getKeys_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppConfigGetKeysResponseApplicationJson, void>> getKeys({
    required String app,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getKeys_Request(
      app: app,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getKeys_Serializer();
    return _i1.ResponseConverter<AppConfigGetKeysResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setValue_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppConfigSetValueResponseApplicationJson, void> $setValue_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(AppConfigSetValueResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update the config value of an app.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [setValue] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [key] Key to update.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Value updated successfully
  ///   * 403: App or key is not allowed
  ///
  /// See:
  ///  * [setValue] for a method executing this request and parsing the response.
  ///  * [$setValue_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setValue_Request({
    required String app,
    required String key,
    required AppConfigSetValueRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    _parameters['app'] = __app;

    final __key = _$jsonSerializers.serialize(key, specifiedType: const FullType(String));
    _parameters['key'] = __key;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/apps/provisioning_api/api/v1/config/apps/{app}/{key}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(AppConfigSetValueRequestApplicationJson)),
    );
    return _request;
  }

  /// Update the config value of an app.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [key] Key to update.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Value updated successfully
  ///   * 403: App or key is not allowed
  ///
  /// See:
  ///  * [$setValue_Request] for the request send by this method.
  ///  * [$setValue_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppConfigSetValueResponseApplicationJson, void>> setValue({
    required String app,
    required String key,
    required AppConfigSetValueRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setValue_Request(
      app: app,
      key: key,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setValue_Serializer();
    return _i1.ResponseConverter<AppConfigSetValueResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $AppsClient {
  /// Creates a new `DynamiteClient` for apps requests.
  $AppsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getApps_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppsGetAppsResponseApplicationJson, void> $getApps_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(AppsGetAppsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of installed apps.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getApps] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [filter] Filter for enabled or disabled apps.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Installed apps returned
  ///
  /// See:
  ///  * [getApps] for a method executing this request and parsing the response.
  ///  * [$getApps_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getApps_Request({
    String? filter,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __filter = _$jsonSerializers.serialize(filter, specifiedType: const FullType(String));
    _parameters['filter'] = __filter;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/apps{?filter*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of installed apps.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [filter] Filter for enabled or disabled apps.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Installed apps returned
  ///
  /// See:
  ///  * [$getApps_Request] for the request send by this method.
  ///  * [$getApps_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppsGetAppsResponseApplicationJson, void>> getApps({
    String? filter,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getApps_Request(
      filter: filter,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getApps_Serializer();
    return _i1.ResponseConverter<AppsGetAppsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getAppInfo_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppsGetAppInfoResponseApplicationJson, void> $getAppInfo_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(AppsGetAppInfoResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the app info for an app.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getAppInfo] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App info returned
  ///
  /// See:
  ///  * [getAppInfo] for a method executing this request and parsing the response.
  ///  * [$getAppInfo_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAppInfo_Request({
    required String app,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    _parameters['app'] = __app;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/apps/{app}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the app info for an app.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App info returned
  ///
  /// See:
  ///  * [$getAppInfo_Request] for the request send by this method.
  ///  * [$getAppInfo_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppsGetAppInfoResponseApplicationJson, void>> getAppInfo({
    required String app,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getAppInfo_Request(
      app: app,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAppInfo_Serializer();
    return _i1.ResponseConverter<AppsGetAppInfoResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$enable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppsEnableResponseApplicationJson, void> $enable_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(AppsEnableResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Enable an app.
  ///
  /// This endpoint requires admin access.
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [enable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App enabled successfully
  ///
  /// See:
  ///  * [enable] for a method executing this request and parsing the response.
  ///  * [$enable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $enable_Request({
    required String app,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    _parameters['app'] = __app;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/apps/{app}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Enable an app.
  ///
  /// This endpoint requires admin access.
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App enabled successfully
  ///
  /// See:
  ///  * [$enable_Request] for the request send by this method.
  ///  * [$enable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppsEnableResponseApplicationJson, void>> enable({
    required String app,
    bool? oCSAPIRequest,
  }) async {
    final _request = $enable_Request(
      app: app,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $enable_Serializer();
    return _i1.ResponseConverter<AppsEnableResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$disable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppsDisableResponseApplicationJson, void> $disable_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(AppsDisableResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Disable an app.
  ///
  /// This endpoint requires admin access.
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [disable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App disabled successfully
  ///
  /// See:
  ///  * [disable] for a method executing this request and parsing the response.
  ///  * [$disable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $disable_Request({
    required String app,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __app = _$jsonSerializers.serialize(app, specifiedType: const FullType(String));
    _parameters['app'] = __app;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/apps/{app}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Disable an app.
  ///
  /// This endpoint requires admin access.
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [app] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App disabled successfully
  ///
  /// See:
  ///  * [$disable_Request] for the request send by this method.
  ///  * [$disable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppsDisableResponseApplicationJson, void>> disable({
    required String app,
    bool? oCSAPIRequest,
  }) async {
    final _request = $disable_Request(
      app: app,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $disable_Serializer();
    return _i1.ResponseConverter<AppsDisableResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $GroupsClient {
  /// Creates a new `DynamiteClient` for groups requests.
  $GroupsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getSubAdminsOfGroup_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<GroupsGetSubAdminsOfGroupResponseApplicationJson, void> $getSubAdminsOfGroup_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(GroupsGetSubAdminsOfGroupResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the list of user IDs that are a subadmin of the group.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getSubAdminsOfGroup] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [groupId] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Sub admins returned
  ///
  /// See:
  ///  * [getSubAdminsOfGroup] for a method executing this request and parsing the response.
  ///  * [$getSubAdminsOfGroup_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getSubAdminsOfGroup_Request({
    required String groupId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __groupId = _$jsonSerializers.serialize(groupId, specifiedType: const FullType(String));
    _i5.checkString(
      __groupId,
      'groupId',
      pattern: RegExp(r'^.+$'),
    );
    _parameters['groupId'] = __groupId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/groups/{groupId}/subadmins').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the list of user IDs that are a subadmin of the group.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [groupId] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Sub admins returned
  ///
  /// See:
  ///  * [$getSubAdminsOfGroup_Request] for the request send by this method.
  ///  * [$getSubAdminsOfGroup_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<GroupsGetSubAdminsOfGroupResponseApplicationJson, void>> getSubAdminsOfGroup({
    required String groupId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getSubAdminsOfGroup_Request(
      groupId: groupId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getSubAdminsOfGroup_Serializer();
    return _i1.ResponseConverter<GroupsGetSubAdminsOfGroupResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getGroups_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<GroupsGetGroupsResponseApplicationJson, void> $getGroups_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(GroupsGetGroupsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of groups.
  ///
  /// Returns a `DynamiteRequest` backing the [getGroups] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Groups returned
  ///
  /// See:
  ///  * [getGroups] for a method executing this request and parsing the response.
  ///  * [$getGroups_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getGroups_Request({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    __search ??= '';
    _parameters['search'] = __search;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    var __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    __offset ??= 0;
    _parameters['offset'] = __offset;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/groups{?search*,limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of groups.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Groups returned
  ///
  /// See:
  ///  * [$getGroups_Request] for the request send by this method.
  ///  * [$getGroups_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<GroupsGetGroupsResponseApplicationJson, void>> getGroups({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getGroups_Request(
      search: search,
      limit: limit,
      offset: offset,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getGroups_Serializer();
    return _i1.ResponseConverter<GroupsGetGroupsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getGroup_Request].
  @_i2.experimental
  @Deprecated('')
  _i1.DynamiteSerializer<GroupsGetGroupResponseApplicationJson, void> $getGroup_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(GroupsGetGroupResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of users in the specified group.
  ///
  /// Returns a `DynamiteRequest` backing the [getGroup] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [groupId] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Group users returned
  ///
  /// See:
  ///  * [getGroup] for a method executing this request and parsing the response.
  ///  * [$getGroup_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  @Deprecated('')
  _i3.Request $getGroup_Request({
    required String groupId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __groupId = _$jsonSerializers.serialize(groupId, specifiedType: const FullType(String));
    _i5.checkString(
      __groupId,
      'groupId',
      pattern: RegExp(r'^.+$'),
    );
    _parameters['groupId'] = __groupId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/groups/{groupId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of users in the specified group.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [groupId] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Group users returned
  ///
  /// See:
  ///  * [$getGroup_Request] for the request send by this method.
  ///  * [$getGroup_Serializer] for a converter to parse the `Response` from an executed request.
  @Deprecated('')
  Future<_i1.DynamiteResponse<GroupsGetGroupResponseApplicationJson, void>> getGroup({
    required String groupId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getGroup_Request(
      groupId: groupId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getGroup_Serializer();
    return _i1.ResponseConverter<GroupsGetGroupResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getGroupsDetails_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<GroupsGetGroupsDetailsResponseApplicationJson, void> $getGroupsDetails_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(GroupsGetGroupsDetailsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of groups details.
  ///
  /// Returns a `DynamiteRequest` backing the [getGroupsDetails] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Groups details returned
  ///
  /// See:
  ///  * [getGroupsDetails] for a method executing this request and parsing the response.
  ///  * [$getGroupsDetails_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getGroupsDetails_Request({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    __search ??= '';
    _parameters['search'] = __search;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    var __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    __offset ??= 0;
    _parameters['offset'] = __offset;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/groups/details{?search*,limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of groups details.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Groups details returned
  ///
  /// See:
  ///  * [$getGroupsDetails_Request] for the request send by this method.
  ///  * [$getGroupsDetails_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<GroupsGetGroupsDetailsResponseApplicationJson, void>> getGroupsDetails({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getGroupsDetails_Request(
      search: search,
      limit: limit,
      offset: offset,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getGroupsDetails_Serializer();
    return _i1.ResponseConverter<GroupsGetGroupsDetailsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getGroupUsers_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<GroupsGetGroupUsersResponseApplicationJson, void> $getGroupUsers_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(GroupsGetGroupUsersResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of users in the specified group.
  ///
  /// Returns a `DynamiteRequest` backing the [getGroupUsers] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [groupId] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User IDs returned
  ///   * 404: Group not found
  ///   * 403: Missing permissions to get users in the group
  ///
  /// See:
  ///  * [getGroupUsers] for a method executing this request and parsing the response.
  ///  * [$getGroupUsers_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getGroupUsers_Request({
    required String groupId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __groupId = _$jsonSerializers.serialize(groupId, specifiedType: const FullType(String));
    _i5.checkString(
      __groupId,
      'groupId',
      pattern: RegExp(r'^.+$'),
    );
    _parameters['groupId'] = __groupId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/groups/{groupId}/users').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of users in the specified group.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [groupId] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User IDs returned
  ///   * 404: Group not found
  ///   * 403: Missing permissions to get users in the group
  ///
  /// See:
  ///  * [$getGroupUsers_Request] for the request send by this method.
  ///  * [$getGroupUsers_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<GroupsGetGroupUsersResponseApplicationJson, void>> getGroupUsers({
    required String groupId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getGroupUsers_Request(
      groupId: groupId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getGroupUsers_Serializer();
    return _i1.ResponseConverter<GroupsGetGroupUsersResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getGroupUsersDetails_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<GroupsGetGroupUsersDetailsResponseApplicationJson, void> $getGroupUsersDetails_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(GroupsGetGroupUsersDetailsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of users details in the specified group.
  ///
  /// Returns a `DynamiteRequest` backing the [getGroupUsersDetails] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [groupId] ID of the group.
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Group users details returned
  ///
  /// See:
  ///  * [getGroupUsersDetails] for a method executing this request and parsing the response.
  ///  * [$getGroupUsersDetails_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getGroupUsersDetails_Request({
    required String groupId,
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __groupId = _$jsonSerializers.serialize(groupId, specifiedType: const FullType(String));
    _i5.checkString(
      __groupId,
      'groupId',
      pattern: RegExp(r'^.+$'),
    );
    _parameters['groupId'] = __groupId;

    var __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    __search ??= '';
    _parameters['search'] = __search;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    var __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    __offset ??= 0;
    _parameters['offset'] = __offset;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/groups/{groupId}/users/details{?search*,limit*,offset*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of users details in the specified group.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [groupId] ID of the group.
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Group users details returned
  ///
  /// See:
  ///  * [$getGroupUsersDetails_Request] for the request send by this method.
  ///  * [$getGroupUsersDetails_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<GroupsGetGroupUsersDetailsResponseApplicationJson, void>> getGroupUsersDetails({
    required String groupId,
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getGroupUsersDetails_Request(
      groupId: groupId,
      search: search,
      limit: limit,
      offset: offset,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getGroupUsersDetails_Serializer();
    return _i1.ResponseConverter<GroupsGetGroupUsersDetailsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $PreferencesClient {
  /// Creates a new `DynamiteClient` for preferences requests.
  $PreferencesClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$setPreference_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PreferencesSetPreferenceResponseApplicationJson, void> $setPreference_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(PreferencesSetPreferenceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Update a preference value of an app.
  ///
  /// Returns a `DynamiteRequest` backing the [setPreference] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [configKey] Key of the preference.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Preference updated successfully
  ///   * 400: Preference invalid
  ///
  /// See:
  ///  * [setPreference] for a method executing this request and parsing the response.
  ///  * [$setPreference_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setPreference_Request({
    required String appId,
    required String configKey,
    required PreferencesSetPreferenceRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __appId = _$jsonSerializers.serialize(appId, specifiedType: const FullType(String));
    _parameters['appId'] = __appId;

    final __configKey = _$jsonSerializers.serialize(configKey, specifiedType: const FullType(String));
    _parameters['configKey'] = __configKey;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/provisioning_api/api/v1/config/users/{appId}/{configKey}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(PreferencesSetPreferenceRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update a preference value of an app.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [configKey] Key of the preference.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Preference updated successfully
  ///   * 400: Preference invalid
  ///
  /// See:
  ///  * [$setPreference_Request] for the request send by this method.
  ///  * [$setPreference_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PreferencesSetPreferenceResponseApplicationJson, void>> setPreference({
    required String appId,
    required String configKey,
    required PreferencesSetPreferenceRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setPreference_Request(
      appId: appId,
      configKey: configKey,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setPreference_Serializer();
    return _i1.ResponseConverter<PreferencesSetPreferenceResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deletePreference_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PreferencesDeletePreferenceResponseApplicationJson, void> $deletePreference_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(PreferencesDeletePreferenceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Delete a preference for an app.
  ///
  /// Returns a `DynamiteRequest` backing the [deletePreference] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [configKey] Key to delete.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Preference deleted successfully
  ///   * 400: Preference invalid
  ///
  /// See:
  ///  * [deletePreference] for a method executing this request and parsing the response.
  ///  * [$deletePreference_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deletePreference_Request({
    required String appId,
    required String configKey,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __appId = _$jsonSerializers.serialize(appId, specifiedType: const FullType(String));
    _parameters['appId'] = __appId;

    final __configKey = _$jsonSerializers.serialize(configKey, specifiedType: const FullType(String));
    _parameters['configKey'] = __configKey;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/provisioning_api/api/v1/config/users/{appId}/{configKey}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete a preference for an app.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [configKey] Key to delete.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Preference deleted successfully
  ///   * 400: Preference invalid
  ///
  /// See:
  ///  * [$deletePreference_Request] for the request send by this method.
  ///  * [$deletePreference_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PreferencesDeletePreferenceResponseApplicationJson, void>> deletePreference({
    required String appId,
    required String configKey,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deletePreference_Request(
      appId: appId,
      configKey: configKey,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deletePreference_Serializer();
    return _i1.ResponseConverter<PreferencesDeletePreferenceResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setMultiplePreferences_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PreferencesSetMultiplePreferencesResponseApplicationJson, void>
      $setMultiplePreferences_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(PreferencesSetMultiplePreferencesResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200, 400},
          );

  /// Update multiple preference values of an app.
  ///
  /// Returns a `DynamiteRequest` backing the [setMultiplePreferences] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Preferences updated successfully
  ///   * 400: Preference invalid
  ///
  /// See:
  ///  * [setMultiplePreferences] for a method executing this request and parsing the response.
  ///  * [$setMultiplePreferences_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setMultiplePreferences_Request({
    required String appId,
    required PreferencesSetMultiplePreferencesRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __appId = _$jsonSerializers.serialize(appId, specifiedType: const FullType(String));
    _parameters['appId'] = __appId;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/provisioning_api/api/v1/config/users/{appId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(PreferencesSetMultiplePreferencesRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update multiple preference values of an app.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Preferences updated successfully
  ///   * 400: Preference invalid
  ///
  /// See:
  ///  * [$setMultiplePreferences_Request] for the request send by this method.
  ///  * [$setMultiplePreferences_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PreferencesSetMultiplePreferencesResponseApplicationJson, void>> setMultiplePreferences({
    required String appId,
    required PreferencesSetMultiplePreferencesRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setMultiplePreferences_Request(
      appId: appId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setMultiplePreferences_Serializer();
    return _i1.ResponseConverter<PreferencesSetMultiplePreferencesResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteMultiplePreference_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PreferencesDeleteMultiplePreferenceResponseApplicationJson, void>
      $deleteMultiplePreference_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(PreferencesDeleteMultiplePreferenceResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200, 400},
          );

  /// Delete multiple preferences for an app.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteMultiplePreference] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [configKeys] Keys to delete.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Preferences deleted successfully
  ///   * 400: Preference invalid
  ///
  /// See:
  ///  * [deleteMultiplePreference] for a method executing this request and parsing the response.
  ///  * [$deleteMultiplePreference_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteMultiplePreference_Request({
    required String appId,
    required BuiltList<String> configKeys,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __appId = _$jsonSerializers.serialize(appId, specifiedType: const FullType(String));
    _parameters['appId'] = __appId;

    final __configKeys =
        _$jsonSerializers.serialize(configKeys, specifiedType: const FullType(BuiltList, [FullType(String)]));
    _parameters['configKeys%5B%5D'] = __configKeys;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/provisioning_api/api/v1/config/users/{appId}{?configKeys%5B%5D*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete multiple preferences for an app.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [configKeys] Keys to delete.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Preferences deleted successfully
  ///   * 400: Preference invalid
  ///
  /// See:
  ///  * [$deleteMultiplePreference_Request] for the request send by this method.
  ///  * [$deleteMultiplePreference_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PreferencesDeleteMultiplePreferenceResponseApplicationJson, void>>
      deleteMultiplePreference({
    required String appId,
    required BuiltList<String> configKeys,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteMultiplePreference_Request(
      appId: appId,
      configKeys: configKeys,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteMultiplePreference_Serializer();
    return _i1.ResponseConverter<PreferencesDeleteMultiplePreferenceResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $UsersClient {
  /// Creates a new `DynamiteClient` for users requests.
  $UsersClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getLastLoggedInUsers_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetLastLoggedInUsersResponseApplicationJson, void> $getLastLoggedInUsers_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersGetLastLoggedInUsersResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Gets the list of users sorted by lastLogin, from most recent to least recent.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getLastLoggedInUsers] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of users returned.
  ///   * [offset] Offset. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users details returned based on last logged in information
  ///
  /// See:
  ///  * [getLastLoggedInUsers] for a method executing this request and parsing the response.
  ///  * [$getLastLoggedInUsers_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getLastLoggedInUsers_Request({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    __search ??= '';
    _parameters['search'] = __search;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    var __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    __offset ??= 0;
    _parameters['offset'] = __offset;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/recent{?search*,limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Gets the list of users sorted by lastLogin, from most recent to least recent.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of users returned.
  ///   * [offset] Offset. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users details returned based on last logged in information
  ///
  /// See:
  ///  * [$getLastLoggedInUsers_Request] for the request send by this method.
  ///  * [$getLastLoggedInUsers_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetLastLoggedInUsersResponseApplicationJson, void>> getLastLoggedInUsers({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getLastLoggedInUsers_Request(
      search: search,
      limit: limit,
      offset: offset,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getLastLoggedInUsers_Serializer();
    return _i1.ResponseConverter<UsersGetLastLoggedInUsersResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUserSubAdminGroups_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetUserSubAdminGroupsResponseApplicationJson, void> $getUserSubAdminGroups_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersGetUserSubAdminGroupsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the groups a user is a subadmin of.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getUserSubAdminGroups] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID if the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User subadmin groups returned
  ///
  /// See:
  ///  * [getUserSubAdminGroups] for a method executing this request and parsing the response.
  ///  * [$getUserSubAdminGroups_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUserSubAdminGroups_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/subadmins').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the groups a user is a subadmin of.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID if the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User subadmin groups returned
  ///
  /// See:
  ///  * [$getUserSubAdminGroups_Request] for the request send by this method.
  ///  * [$getUserSubAdminGroups_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetUserSubAdminGroupsResponseApplicationJson, void>> getUserSubAdminGroups({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUserSubAdminGroups_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUserSubAdminGroups_Serializer();
    return _i1.ResponseConverter<UsersGetUserSubAdminGroupsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$addSubAdmin_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersAddSubAdminResponseApplicationJson, void> $addSubAdmin_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersAddSubAdminResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Make a user a subadmin of a group.
  ///
  /// This endpoint requires admin access.
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [addSubAdmin] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User added as group subadmin successfully
  ///
  /// See:
  ///  * [addSubAdmin] for a method executing this request and parsing the response.
  ///  * [$addSubAdmin_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $addSubAdmin_Request({
    required String userId,
    required UsersAddSubAdminRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/subadmins').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(UsersAddSubAdminRequestApplicationJson)),
    );
    return _request;
  }

  /// Make a user a subadmin of a group.
  ///
  /// This endpoint requires admin access.
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User added as group subadmin successfully
  ///
  /// See:
  ///  * [$addSubAdmin_Request] for the request send by this method.
  ///  * [$addSubAdmin_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersAddSubAdminResponseApplicationJson, void>> addSubAdmin({
    required String userId,
    required UsersAddSubAdminRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $addSubAdmin_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $addSubAdmin_Serializer();
    return _i1.ResponseConverter<UsersAddSubAdminResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$removeSubAdmin_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersRemoveSubAdminResponseApplicationJson, void> $removeSubAdmin_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersRemoveSubAdminResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Remove a user from the subadmins of a group.
  ///
  /// This endpoint requires admin access.
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [removeSubAdmin] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [groupid] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User removed as group subadmin successfully
  ///
  /// See:
  ///  * [removeSubAdmin] for a method executing this request and parsing the response.
  ///  * [$removeSubAdmin_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $removeSubAdmin_Request({
    required String userId,
    required String groupid,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final __groupid = _$jsonSerializers.serialize(groupid, specifiedType: const FullType(String));
    _parameters['groupid'] = __groupid;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/subadmins{?groupid*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove a user from the subadmins of a group.
  ///
  /// This endpoint requires admin access.
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [groupid] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User removed as group subadmin successfully
  ///
  /// See:
  ///  * [$removeSubAdmin_Request] for the request send by this method.
  ///  * [$removeSubAdmin_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersRemoveSubAdminResponseApplicationJson, void>> removeSubAdmin({
    required String userId,
    required String groupid,
    bool? oCSAPIRequest,
  }) async {
    final _request = $removeSubAdmin_Request(
      userId: userId,
      groupid: groupid,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $removeSubAdmin_Serializer();
    return _i1.ResponseConverter<UsersRemoveSubAdminResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUsers_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetUsersResponseApplicationJson, void> $getUsers_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(UsersGetUsersResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of users.
  ///
  /// Returns a `DynamiteRequest` backing the [getUsers] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users returned
  ///
  /// See:
  ///  * [getUsers] for a method executing this request and parsing the response.
  ///  * [$getUsers_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUsers_Request({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    __search ??= '';
    _parameters['search'] = __search;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    var __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    __offset ??= 0;
    _parameters['offset'] = __offset;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users{?search*,limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of users.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users returned
  ///
  /// See:
  ///  * [$getUsers_Request] for the request send by this method.
  ///  * [$getUsers_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetUsersResponseApplicationJson, void>> getUsers({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUsers_Request(
      search: search,
      limit: limit,
      offset: offset,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUsers_Serializer();
    return _i1.ResponseConverter<UsersGetUsersResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$addUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersAddUserResponseApplicationJson, void> $addUser_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(UsersAddUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a new user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [addUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User added successfully
  ///   * 403: Missing permissions to make user subadmin
  ///
  /// See:
  ///  * [addUser] for a method executing this request and parsing the response.
  ///  * [$addUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $addUser_Request({
    required UsersAddUserRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/cloud/users';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(UsersAddUserRequestApplicationJson)));
    return _request;
  }

  /// Create a new user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User added successfully
  ///   * 403: Missing permissions to make user subadmin
  ///
  /// See:
  ///  * [$addUser_Request] for the request send by this method.
  ///  * [$addUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersAddUserResponseApplicationJson, void>> addUser({
    required UsersAddUserRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $addUser_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $addUser_Serializer();
    return _i1.ResponseConverter<UsersAddUserResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUsersDetails_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetUsersDetailsResponseApplicationJson, void> $getUsersDetails_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersGetUsersDetailsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of users and their details.
  ///
  /// Returns a `DynamiteRequest` backing the [getUsersDetails] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users details returned
  ///
  /// See:
  ///  * [getUsersDetails] for a method executing this request and parsing the response.
  ///  * [$getUsersDetails_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUsersDetails_Request({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    __search ??= '';
    _parameters['search'] = __search;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    var __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    __offset ??= 0;
    _parameters['offset'] = __offset;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/details{?search*,limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of users and their details.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of groups returned.
  ///   * [offset] Offset for searching for groups. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users details returned
  ///
  /// See:
  ///  * [$getUsersDetails_Request] for the request send by this method.
  ///  * [$getUsersDetails_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetUsersDetailsResponseApplicationJson, void>> getUsersDetails({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUsersDetails_Request(
      search: search,
      limit: limit,
      offset: offset,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUsersDetails_Serializer();
    return _i1.ResponseConverter<UsersGetUsersDetailsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getDisabledUsersDetails_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetDisabledUsersDetailsResponseApplicationJson, void>
      $getDisabledUsersDetails_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(UsersGetDisabledUsersDetailsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the list of disabled users and their details.
  ///
  /// Returns a `DynamiteRequest` backing the [getDisabledUsersDetails] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of users returned.
  ///   * [offset] Offset. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Disabled users details returned
  ///
  /// See:
  ///  * [getDisabledUsersDetails] for a method executing this request and parsing the response.
  ///  * [$getDisabledUsersDetails_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getDisabledUsersDetails_Request({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    __search ??= '';
    _parameters['search'] = __search;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    var __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    __offset ??= 0;
    _parameters['offset'] = __offset;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/disabled{?search*,limit*,offset*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the list of disabled users and their details.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [limit] Limit the amount of users returned.
  ///   * [offset] Offset. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Disabled users details returned
  ///
  /// See:
  ///  * [$getDisabledUsersDetails_Request] for the request send by this method.
  ///  * [$getDisabledUsersDetails_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetDisabledUsersDetailsResponseApplicationJson, void>> getDisabledUsersDetails({
    String? search,
    int? limit,
    int? offset,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getDisabledUsersDetails_Request(
      search: search,
      limit: limit,
      offset: offset,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getDisabledUsersDetails_Serializer();
    return _i1.ResponseConverter<UsersGetDisabledUsersDetailsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$searchByPhoneNumbers_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersSearchByPhoneNumbersResponseApplicationJson, void> $searchByPhoneNumbers_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersSearchByPhoneNumbersResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Search users by their phone numbers.
  ///
  /// Returns a `DynamiteRequest` backing the [searchByPhoneNumbers] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users returned
  ///   * 400: Invalid location
  ///
  /// See:
  ///  * [searchByPhoneNumbers] for a method executing this request and parsing the response.
  ///  * [$searchByPhoneNumbers_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $searchByPhoneNumbers_Request({
    required UsersSearchByPhoneNumbersRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/cloud/users/search/by-phone';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(UsersSearchByPhoneNumbersRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Search users by their phone numbers.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users returned
  ///   * 400: Invalid location
  ///
  /// See:
  ///  * [$searchByPhoneNumbers_Request] for the request send by this method.
  ///  * [$searchByPhoneNumbers_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersSearchByPhoneNumbersResponseApplicationJson, void>> searchByPhoneNumbers({
    required UsersSearchByPhoneNumbersRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $searchByPhoneNumbers_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $searchByPhoneNumbers_Serializer();
    return _i1.ResponseConverter<UsersSearchByPhoneNumbersResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetUserResponseApplicationJson, void> $getUser_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(UsersGetUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the details of a user.
  ///
  /// Returns a `DynamiteRequest` backing the [getUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User returned
  ///
  /// See:
  ///  * [getUser] for a method executing this request and parsing the response.
  ///  * [$getUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUser_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the details of a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User returned
  ///
  /// See:
  ///  * [$getUser_Request] for the request send by this method.
  ///  * [$getUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetUserResponseApplicationJson, void>> getUser({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUser_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUser_Serializer();
    return _i1.ResponseConverter<UsersGetUserResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$editUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersEditUserResponseApplicationJson, void> $editUser_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(UsersEditUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update a value of the user's details.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [editUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User value edited successfully
  ///
  /// See:
  ///  * [editUser] for a method executing this request and parsing the response.
  ///  * [$editUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $editUser_Request({
    required String userId,
    required UsersEditUserRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(UsersEditUserRequestApplicationJson)));
    return _request;
  }

  /// Update a value of the user's details.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User value edited successfully
  ///
  /// See:
  ///  * [$editUser_Request] for the request send by this method.
  ///  * [$editUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersEditUserResponseApplicationJson, void>> editUser({
    required String userId,
    required UsersEditUserRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $editUser_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $editUser_Serializer();
    return _i1.ResponseConverter<UsersEditUserResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersDeleteUserResponseApplicationJson, void> $deleteUser_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersDeleteUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User deleted successfully
  ///
  /// See:
  ///  * [deleteUser] for a method executing this request and parsing the response.
  ///  * [$deleteUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteUser_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete a user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User deleted successfully
  ///
  /// See:
  ///  * [$deleteUser_Request] for the request send by this method.
  ///  * [$deleteUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersDeleteUserResponseApplicationJson, void>> deleteUser({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteUser_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteUser_Serializer();
    return _i1.ResponseConverter<UsersDeleteUserResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getCurrentUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetCurrentUserResponseApplicationJson, void> $getCurrentUser_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersGetCurrentUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the details of the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [getCurrentUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Current user returned
  ///
  /// See:
  ///  * [getCurrentUser] for a method executing this request and parsing the response.
  ///  * [$getCurrentUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getCurrentUser_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/cloud/user';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the details of the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Current user returned
  ///
  /// See:
  ///  * [$getCurrentUser_Request] for the request send by this method.
  ///  * [$getCurrentUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetCurrentUserResponseApplicationJson, void>> getCurrentUser({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getCurrentUser_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getCurrentUser_Serializer();
    return _i1.ResponseConverter<UsersGetCurrentUserResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getEditableFields_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetEditableFieldsResponseApplicationJson, void> $getEditableFields_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersGetEditableFieldsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of fields that are editable for the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [getEditableFields] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Editable fields returned
  ///
  /// See:
  ///  * [getEditableFields] for a method executing this request and parsing the response.
  ///  * [$getEditableFields_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getEditableFields_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/cloud/user/fields';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of fields that are editable for the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Editable fields returned
  ///
  /// See:
  ///  * [$getEditableFields_Request] for the request send by this method.
  ///  * [$getEditableFields_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetEditableFieldsResponseApplicationJson, void>> getEditableFields({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getEditableFields_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getEditableFields_Serializer();
    return _i1.ResponseConverter<UsersGetEditableFieldsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getEditableFieldsForUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetEditableFieldsForUserResponseApplicationJson, void>
      $getEditableFieldsForUser_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(UsersGetEditableFieldsForUserResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get a list of fields that are editable for a user.
  ///
  /// Returns a `DynamiteRequest` backing the [getEditableFieldsForUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Editable fields for user returned
  ///
  /// See:
  ///  * [getEditableFieldsForUser] for a method executing this request and parsing the response.
  ///  * [$getEditableFieldsForUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getEditableFieldsForUser_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/user/fields/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of fields that are editable for a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Editable fields for user returned
  ///
  /// See:
  ///  * [$getEditableFieldsForUser_Request] for the request send by this method.
  ///  * [$getEditableFieldsForUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetEditableFieldsForUserResponseApplicationJson, void>> getEditableFieldsForUser({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getEditableFieldsForUser_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getEditableFieldsForUser_Serializer();
    return _i1.ResponseConverter<UsersGetEditableFieldsForUserResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$editUserMultiValue_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersEditUserMultiValueResponseApplicationJson, void> $editUserMultiValue_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersEditUserMultiValueResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update multiple values of the user's details.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [editUserMultiValue] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [collectionName] Collection to update.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User values edited successfully
  ///
  /// See:
  ///  * [editUserMultiValue] for a method executing this request and parsing the response.
  ///  * [$editUserMultiValue_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $editUserMultiValue_Request({
    required String userId,
    required String collectionName,
    required UsersEditUserMultiValueRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final __collectionName = _$jsonSerializers.serialize(collectionName, specifiedType: const FullType(String));
    _i5.checkString(
      __collectionName,
      'collectionName',
      pattern: RegExp(r'^(?!enable$|disable$)[a-zA-Z0-9_]*$'),
    );
    _parameters['collectionName'] = __collectionName;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/{collectionName}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(UsersEditUserMultiValueRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update multiple values of the user's details.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [collectionName] Collection to update.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User values edited successfully
  ///
  /// See:
  ///  * [$editUserMultiValue_Request] for the request send by this method.
  ///  * [$editUserMultiValue_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersEditUserMultiValueResponseApplicationJson, void>> editUserMultiValue({
    required String userId,
    required String collectionName,
    required UsersEditUserMultiValueRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $editUserMultiValue_Request(
      userId: userId,
      collectionName: collectionName,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $editUserMultiValue_Serializer();
    return _i1.ResponseConverter<UsersEditUserMultiValueResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$wipeUserDevices_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersWipeUserDevicesResponseApplicationJson, void> $wipeUserDevices_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersWipeUserDevicesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Wipe all devices of a user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [wipeUserDevices] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Wiped all user devices successfully
  ///
  /// See:
  ///  * [wipeUserDevices] for a method executing this request and parsing the response.
  ///  * [$wipeUserDevices_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $wipeUserDevices_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/wipe').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Wipe all devices of a user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Wiped all user devices successfully
  ///
  /// See:
  ///  * [$wipeUserDevices_Request] for the request send by this method.
  ///  * [$wipeUserDevices_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersWipeUserDevicesResponseApplicationJson, void>> wipeUserDevices({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $wipeUserDevices_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $wipeUserDevices_Serializer();
    return _i1.ResponseConverter<UsersWipeUserDevicesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$enableUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersEnableUserResponseApplicationJson, void> $enableUser_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersEnableUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Enable a user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [enableUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User enabled successfully
  ///
  /// See:
  ///  * [enableUser] for a method executing this request and parsing the response.
  ///  * [$enableUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $enableUser_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/enable').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Enable a user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User enabled successfully
  ///
  /// See:
  ///  * [$enableUser_Request] for the request send by this method.
  ///  * [$enableUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersEnableUserResponseApplicationJson, void>> enableUser({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $enableUser_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $enableUser_Serializer();
    return _i1.ResponseConverter<UsersEnableUserResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$disableUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersDisableUserResponseApplicationJson, void> $disableUser_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersDisableUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Disable a user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [disableUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User disabled successfully
  ///
  /// See:
  ///  * [disableUser] for a method executing this request and parsing the response.
  ///  * [$disableUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $disableUser_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/disable').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Disable a user.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User disabled successfully
  ///
  /// See:
  ///  * [$disableUser_Request] for the request send by this method.
  ///  * [$disableUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersDisableUserResponseApplicationJson, void>> disableUser({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $disableUser_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $disableUser_Serializer();
    return _i1.ResponseConverter<UsersDisableUserResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getUsersGroups_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersGetUsersGroupsResponseApplicationJson, void> $getUsersGroups_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersGetUsersGroupsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of groups the user belongs to.
  ///
  /// Returns a `DynamiteRequest` backing the [getUsersGroups] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users groups returned
  ///
  /// See:
  ///  * [getUsersGroups] for a method executing this request and parsing the response.
  ///  * [$getUsersGroups_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUsersGroups_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/groups').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of groups the user belongs to.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Users groups returned
  ///
  /// See:
  ///  * [$getUsersGroups_Request] for the request send by this method.
  ///  * [$getUsersGroups_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersGetUsersGroupsResponseApplicationJson, void>> getUsersGroups({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUsersGroups_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUsersGroups_Serializer();
    return _i1.ResponseConverter<UsersGetUsersGroupsResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$addToGroup_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersAddToGroupResponseApplicationJson, void> $addToGroup_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersAddToGroupResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Add a user to a group.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [addToGroup] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User added to group successfully
  ///
  /// See:
  ///  * [addToGroup] for a method executing this request and parsing the response.
  ///  * [$addToGroup_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $addToGroup_Request({
    required String userId,
    bool? oCSAPIRequest,
    UsersAddToGroupRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/groups').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(UsersAddToGroupRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              UsersAddToGroupRequestApplicationJson(),
              specifiedType: const FullType(UsersAddToGroupRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Add a user to a group.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User added to group successfully
  ///
  /// See:
  ///  * [$addToGroup_Request] for the request send by this method.
  ///  * [$addToGroup_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersAddToGroupResponseApplicationJson, void>> addToGroup({
    required String userId,
    bool? oCSAPIRequest,
    UsersAddToGroupRequestApplicationJson? $body,
  }) async {
    final _request = $addToGroup_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $addToGroup_Serializer();
    return _i1.ResponseConverter<UsersAddToGroupResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$removeFromGroup_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersRemoveFromGroupResponseApplicationJson, void> $removeFromGroup_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersRemoveFromGroupResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Remove a user from a group.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [removeFromGroup] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [groupid] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User removed from group successfully
  ///
  /// See:
  ///  * [removeFromGroup] for a method executing this request and parsing the response.
  ///  * [$removeFromGroup_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $removeFromGroup_Request({
    required String userId,
    required String groupid,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final __groupid = _$jsonSerializers.serialize(groupid, specifiedType: const FullType(String));
    _parameters['groupid'] = __groupid;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/groups{?groupid*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove a user from a group.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [groupid] ID of the group.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: User removed from group successfully
  ///
  /// See:
  ///  * [$removeFromGroup_Request] for the request send by this method.
  ///  * [$removeFromGroup_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersRemoveFromGroupResponseApplicationJson, void>> removeFromGroup({
    required String userId,
    required String groupid,
    bool? oCSAPIRequest,
  }) async {
    final _request = $removeFromGroup_Request(
      userId: userId,
      groupid: groupid,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $removeFromGroup_Serializer();
    return _i1.ResponseConverter<UsersRemoveFromGroupResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$resendWelcomeMessage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UsersResendWelcomeMessageResponseApplicationJson, void> $resendWelcomeMessage_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UsersResendWelcomeMessageResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Resend the welcome message.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [resendWelcomeMessage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID if the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Resent welcome message successfully
  ///
  /// See:
  ///  * [resendWelcomeMessage] for a method executing this request and parsing the response.
  ///  * [$resendWelcomeMessage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $resendWelcomeMessage_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/cloud/users/{userId}/welcome').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Resend the welcome message.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID if the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Resent welcome message successfully
  ///
  /// See:
  ///  * [$resendWelcomeMessage_Request] for the request send by this method.
  ///  * [$resendWelcomeMessage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UsersResendWelcomeMessageResponseApplicationJson, void>> resendWelcomeMessage({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $resendWelcomeMessage_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $resendWelcomeMessage_Serializer();
    return _i1.ResponseConverter<UsersResendWelcomeMessageResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigGetAppsResponseApplicationJson_Ocs_DataInterface {
  BuiltList<String> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppConfigGetAppsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($AppConfigGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppConfigGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class AppConfigGetAppsResponseApplicationJson_Ocs_Data
    implements
        $AppConfigGetAppsResponseApplicationJson_Ocs_DataInterface,
        Built<AppConfigGetAppsResponseApplicationJson_Ocs_Data,
            AppConfigGetAppsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new AppConfigGetAppsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory AppConfigGetAppsResponseApplicationJson_Ocs_Data([
    void Function(AppConfigGetAppsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$AppConfigGetAppsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const AppConfigGetAppsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigGetAppsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigGetAppsResponseApplicationJson_Ocs_Data.
  static Serializer<AppConfigGetAppsResponseApplicationJson_Ocs_Data> get serializer =>
      _$appConfigGetAppsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigGetAppsResponseApplicationJson_Ocs_DataBuilder b) {
    $AppConfigGetAppsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigGetAppsResponseApplicationJson_Ocs_DataBuilder b) {
    $AppConfigGetAppsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigGetAppsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  AppConfigGetAppsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigGetAppsResponseApplicationJson_OcsInterfaceBuilder].
  $AppConfigGetAppsResponseApplicationJson_OcsInterface rebuild(
    void Function($AppConfigGetAppsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigGetAppsResponseApplicationJson_OcsInterfaceBuilder].
  $AppConfigGetAppsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigGetAppsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigGetAppsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppConfigGetAppsResponseApplicationJson_Ocs
    implements
        $AppConfigGetAppsResponseApplicationJson_OcsInterface,
        Built<AppConfigGetAppsResponseApplicationJson_Ocs, AppConfigGetAppsResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppConfigGetAppsResponseApplicationJson_Ocs object using the builder pattern.
  factory AppConfigGetAppsResponseApplicationJson_Ocs([
    void Function(AppConfigGetAppsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AppConfigGetAppsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppConfigGetAppsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigGetAppsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigGetAppsResponseApplicationJson_Ocs.
  static Serializer<AppConfigGetAppsResponseApplicationJson_Ocs> get serializer =>
      _$appConfigGetAppsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigGetAppsResponseApplicationJson_OcsBuilder b) {
    $AppConfigGetAppsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigGetAppsResponseApplicationJson_OcsBuilder b) {
    $AppConfigGetAppsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigGetAppsResponseApplicationJsonInterface {
  AppConfigGetAppsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigGetAppsResponseApplicationJsonInterfaceBuilder].
  $AppConfigGetAppsResponseApplicationJsonInterface rebuild(
    void Function($AppConfigGetAppsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigGetAppsResponseApplicationJsonInterfaceBuilder].
  $AppConfigGetAppsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigGetAppsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigGetAppsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppConfigGetAppsResponseApplicationJson
    implements
        $AppConfigGetAppsResponseApplicationJsonInterface,
        Built<AppConfigGetAppsResponseApplicationJson, AppConfigGetAppsResponseApplicationJsonBuilder> {
  /// Creates a new AppConfigGetAppsResponseApplicationJson object using the builder pattern.
  factory AppConfigGetAppsResponseApplicationJson([void Function(AppConfigGetAppsResponseApplicationJsonBuilder)? b]) =
      _$AppConfigGetAppsResponseApplicationJson;

  // coverage:ignore-start
  const AppConfigGetAppsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigGetAppsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigGetAppsResponseApplicationJson.
  static Serializer<AppConfigGetAppsResponseApplicationJson> get serializer =>
      _$appConfigGetAppsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigGetAppsResponseApplicationJsonBuilder b) {
    $AppConfigGetAppsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigGetAppsResponseApplicationJsonBuilder b) {
    $AppConfigGetAppsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigGetKeysResponseApplicationJson_Ocs_DataInterface {
  BuiltList<String> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigGetKeysResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppConfigGetKeysResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($AppConfigGetKeysResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigGetKeysResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppConfigGetKeysResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigGetKeysResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigGetKeysResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class AppConfigGetKeysResponseApplicationJson_Ocs_Data
    implements
        $AppConfigGetKeysResponseApplicationJson_Ocs_DataInterface,
        Built<AppConfigGetKeysResponseApplicationJson_Ocs_Data,
            AppConfigGetKeysResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new AppConfigGetKeysResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory AppConfigGetKeysResponseApplicationJson_Ocs_Data([
    void Function(AppConfigGetKeysResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$AppConfigGetKeysResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const AppConfigGetKeysResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigGetKeysResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigGetKeysResponseApplicationJson_Ocs_Data.
  static Serializer<AppConfigGetKeysResponseApplicationJson_Ocs_Data> get serializer =>
      _$appConfigGetKeysResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigGetKeysResponseApplicationJson_Ocs_DataBuilder b) {
    $AppConfigGetKeysResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigGetKeysResponseApplicationJson_Ocs_DataBuilder b) {
    $AppConfigGetKeysResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigGetKeysResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  AppConfigGetKeysResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigGetKeysResponseApplicationJson_OcsInterfaceBuilder].
  $AppConfigGetKeysResponseApplicationJson_OcsInterface rebuild(
    void Function($AppConfigGetKeysResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigGetKeysResponseApplicationJson_OcsInterfaceBuilder].
  $AppConfigGetKeysResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigGetKeysResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigGetKeysResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppConfigGetKeysResponseApplicationJson_Ocs
    implements
        $AppConfigGetKeysResponseApplicationJson_OcsInterface,
        Built<AppConfigGetKeysResponseApplicationJson_Ocs, AppConfigGetKeysResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppConfigGetKeysResponseApplicationJson_Ocs object using the builder pattern.
  factory AppConfigGetKeysResponseApplicationJson_Ocs([
    void Function(AppConfigGetKeysResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AppConfigGetKeysResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppConfigGetKeysResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigGetKeysResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigGetKeysResponseApplicationJson_Ocs.
  static Serializer<AppConfigGetKeysResponseApplicationJson_Ocs> get serializer =>
      _$appConfigGetKeysResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigGetKeysResponseApplicationJson_OcsBuilder b) {
    $AppConfigGetKeysResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigGetKeysResponseApplicationJson_OcsBuilder b) {
    $AppConfigGetKeysResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigGetKeysResponseApplicationJsonInterface {
  AppConfigGetKeysResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigGetKeysResponseApplicationJsonInterfaceBuilder].
  $AppConfigGetKeysResponseApplicationJsonInterface rebuild(
    void Function($AppConfigGetKeysResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigGetKeysResponseApplicationJsonInterfaceBuilder].
  $AppConfigGetKeysResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigGetKeysResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigGetKeysResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppConfigGetKeysResponseApplicationJson
    implements
        $AppConfigGetKeysResponseApplicationJsonInterface,
        Built<AppConfigGetKeysResponseApplicationJson, AppConfigGetKeysResponseApplicationJsonBuilder> {
  /// Creates a new AppConfigGetKeysResponseApplicationJson object using the builder pattern.
  factory AppConfigGetKeysResponseApplicationJson([void Function(AppConfigGetKeysResponseApplicationJsonBuilder)? b]) =
      _$AppConfigGetKeysResponseApplicationJson;

  // coverage:ignore-start
  const AppConfigGetKeysResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigGetKeysResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigGetKeysResponseApplicationJson.
  static Serializer<AppConfigGetKeysResponseApplicationJson> get serializer =>
      _$appConfigGetKeysResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigGetKeysResponseApplicationJsonBuilder b) {
    $AppConfigGetKeysResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigGetKeysResponseApplicationJsonBuilder b) {
    $AppConfigGetKeysResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigSetValueRequestApplicationJsonInterface {
  /// New value for the key.
  String get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigSetValueRequestApplicationJsonInterfaceBuilder].
  $AppConfigSetValueRequestApplicationJsonInterface rebuild(
    void Function($AppConfigSetValueRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigSetValueRequestApplicationJsonInterfaceBuilder].
  $AppConfigSetValueRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigSetValueRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigSetValueRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class AppConfigSetValueRequestApplicationJson
    implements
        $AppConfigSetValueRequestApplicationJsonInterface,
        Built<AppConfigSetValueRequestApplicationJson, AppConfigSetValueRequestApplicationJsonBuilder> {
  /// Creates a new AppConfigSetValueRequestApplicationJson object using the builder pattern.
  factory AppConfigSetValueRequestApplicationJson([void Function(AppConfigSetValueRequestApplicationJsonBuilder)? b]) =
      _$AppConfigSetValueRequestApplicationJson;

  // coverage:ignore-start
  const AppConfigSetValueRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigSetValueRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigSetValueRequestApplicationJson.
  static Serializer<AppConfigSetValueRequestApplicationJson> get serializer =>
      _$appConfigSetValueRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigSetValueRequestApplicationJsonBuilder b) {
    $AppConfigSetValueRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigSetValueRequestApplicationJsonBuilder b) {
    $AppConfigSetValueRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigSetValueResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigSetValueResponseApplicationJson_OcsInterfaceBuilder].
  $AppConfigSetValueResponseApplicationJson_OcsInterface rebuild(
    void Function($AppConfigSetValueResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigSetValueResponseApplicationJson_OcsInterfaceBuilder].
  $AppConfigSetValueResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigSetValueResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigSetValueResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppConfigSetValueResponseApplicationJson_Ocs
    implements
        $AppConfigSetValueResponseApplicationJson_OcsInterface,
        Built<AppConfigSetValueResponseApplicationJson_Ocs, AppConfigSetValueResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppConfigSetValueResponseApplicationJson_Ocs object using the builder pattern.
  factory AppConfigSetValueResponseApplicationJson_Ocs([
    void Function(AppConfigSetValueResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AppConfigSetValueResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppConfigSetValueResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigSetValueResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigSetValueResponseApplicationJson_Ocs.
  static Serializer<AppConfigSetValueResponseApplicationJson_Ocs> get serializer =>
      _$appConfigSetValueResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigSetValueResponseApplicationJson_OcsBuilder b) {
    $AppConfigSetValueResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigSetValueResponseApplicationJson_OcsBuilder b) {
    $AppConfigSetValueResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppConfigSetValueResponseApplicationJsonInterface {
  AppConfigSetValueResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppConfigSetValueResponseApplicationJsonInterfaceBuilder].
  $AppConfigSetValueResponseApplicationJsonInterface rebuild(
    void Function($AppConfigSetValueResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppConfigSetValueResponseApplicationJsonInterfaceBuilder].
  $AppConfigSetValueResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppConfigSetValueResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppConfigSetValueResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppConfigSetValueResponseApplicationJson
    implements
        $AppConfigSetValueResponseApplicationJsonInterface,
        Built<AppConfigSetValueResponseApplicationJson, AppConfigSetValueResponseApplicationJsonBuilder> {
  /// Creates a new AppConfigSetValueResponseApplicationJson object using the builder pattern.
  factory AppConfigSetValueResponseApplicationJson([
    void Function(AppConfigSetValueResponseApplicationJsonBuilder)? b,
  ]) = _$AppConfigSetValueResponseApplicationJson;

  // coverage:ignore-start
  const AppConfigSetValueResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppConfigSetValueResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppConfigSetValueResponseApplicationJson.
  static Serializer<AppConfigSetValueResponseApplicationJson> get serializer =>
      _$appConfigSetValueResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppConfigSetValueResponseApplicationJsonBuilder b) {
    $AppConfigSetValueResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppConfigSetValueResponseApplicationJsonBuilder b) {
    $AppConfigSetValueResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsGetAppsResponseApplicationJson_Ocs_DataInterface {
  BuiltList<String> get apps;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppsGetAppsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($AppsGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppsGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsGetAppsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class AppsGetAppsResponseApplicationJson_Ocs_Data
    implements
        $AppsGetAppsResponseApplicationJson_Ocs_DataInterface,
        Built<AppsGetAppsResponseApplicationJson_Ocs_Data, AppsGetAppsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new AppsGetAppsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory AppsGetAppsResponseApplicationJson_Ocs_Data([
    void Function(AppsGetAppsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$AppsGetAppsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const AppsGetAppsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsGetAppsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsGetAppsResponseApplicationJson_Ocs_Data.
  static Serializer<AppsGetAppsResponseApplicationJson_Ocs_Data> get serializer =>
      _$appsGetAppsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsGetAppsResponseApplicationJson_Ocs_DataBuilder b) {
    $AppsGetAppsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsGetAppsResponseApplicationJson_Ocs_DataBuilder b) {
    $AppsGetAppsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsGetAppsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  AppsGetAppsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsGetAppsResponseApplicationJson_OcsInterfaceBuilder].
  $AppsGetAppsResponseApplicationJson_OcsInterface rebuild(
    void Function($AppsGetAppsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsGetAppsResponseApplicationJson_OcsInterfaceBuilder].
  $AppsGetAppsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsGetAppsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsGetAppsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppsGetAppsResponseApplicationJson_Ocs
    implements
        $AppsGetAppsResponseApplicationJson_OcsInterface,
        Built<AppsGetAppsResponseApplicationJson_Ocs, AppsGetAppsResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppsGetAppsResponseApplicationJson_Ocs object using the builder pattern.
  factory AppsGetAppsResponseApplicationJson_Ocs([void Function(AppsGetAppsResponseApplicationJson_OcsBuilder)? b]) =
      _$AppsGetAppsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppsGetAppsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsGetAppsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsGetAppsResponseApplicationJson_Ocs.
  static Serializer<AppsGetAppsResponseApplicationJson_Ocs> get serializer =>
      _$appsGetAppsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsGetAppsResponseApplicationJson_OcsBuilder b) {
    $AppsGetAppsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsGetAppsResponseApplicationJson_OcsBuilder b) {
    $AppsGetAppsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsGetAppsResponseApplicationJsonInterface {
  AppsGetAppsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsGetAppsResponseApplicationJsonInterfaceBuilder].
  $AppsGetAppsResponseApplicationJsonInterface rebuild(
    void Function($AppsGetAppsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsGetAppsResponseApplicationJsonInterfaceBuilder].
  $AppsGetAppsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsGetAppsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsGetAppsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppsGetAppsResponseApplicationJson
    implements
        $AppsGetAppsResponseApplicationJsonInterface,
        Built<AppsGetAppsResponseApplicationJson, AppsGetAppsResponseApplicationJsonBuilder> {
  /// Creates a new AppsGetAppsResponseApplicationJson object using the builder pattern.
  factory AppsGetAppsResponseApplicationJson([void Function(AppsGetAppsResponseApplicationJsonBuilder)? b]) =
      _$AppsGetAppsResponseApplicationJson;

  // coverage:ignore-start
  const AppsGetAppsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsGetAppsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsGetAppsResponseApplicationJson.
  static Serializer<AppsGetAppsResponseApplicationJson> get serializer =>
      _$appsGetAppsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsGetAppsResponseApplicationJsonBuilder b) {
    $AppsGetAppsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsGetAppsResponseApplicationJsonBuilder b) {
    $AppsGetAppsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsGetAppInfoResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltMap<String, JsonObject?> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsGetAppInfoResponseApplicationJson_OcsInterfaceBuilder].
  $AppsGetAppInfoResponseApplicationJson_OcsInterface rebuild(
    void Function($AppsGetAppInfoResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsGetAppInfoResponseApplicationJson_OcsInterfaceBuilder].
  $AppsGetAppInfoResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsGetAppInfoResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsGetAppInfoResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppsGetAppInfoResponseApplicationJson_Ocs
    implements
        $AppsGetAppInfoResponseApplicationJson_OcsInterface,
        Built<AppsGetAppInfoResponseApplicationJson_Ocs, AppsGetAppInfoResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppsGetAppInfoResponseApplicationJson_Ocs object using the builder pattern.
  factory AppsGetAppInfoResponseApplicationJson_Ocs([
    void Function(AppsGetAppInfoResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AppsGetAppInfoResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppsGetAppInfoResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsGetAppInfoResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsGetAppInfoResponseApplicationJson_Ocs.
  static Serializer<AppsGetAppInfoResponseApplicationJson_Ocs> get serializer =>
      _$appsGetAppInfoResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsGetAppInfoResponseApplicationJson_OcsBuilder b) {
    $AppsGetAppInfoResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsGetAppInfoResponseApplicationJson_OcsBuilder b) {
    $AppsGetAppInfoResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsGetAppInfoResponseApplicationJsonInterface {
  AppsGetAppInfoResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsGetAppInfoResponseApplicationJsonInterfaceBuilder].
  $AppsGetAppInfoResponseApplicationJsonInterface rebuild(
    void Function($AppsGetAppInfoResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsGetAppInfoResponseApplicationJsonInterfaceBuilder].
  $AppsGetAppInfoResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsGetAppInfoResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsGetAppInfoResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppsGetAppInfoResponseApplicationJson
    implements
        $AppsGetAppInfoResponseApplicationJsonInterface,
        Built<AppsGetAppInfoResponseApplicationJson, AppsGetAppInfoResponseApplicationJsonBuilder> {
  /// Creates a new AppsGetAppInfoResponseApplicationJson object using the builder pattern.
  factory AppsGetAppInfoResponseApplicationJson([void Function(AppsGetAppInfoResponseApplicationJsonBuilder)? b]) =
      _$AppsGetAppInfoResponseApplicationJson;

  // coverage:ignore-start
  const AppsGetAppInfoResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsGetAppInfoResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsGetAppInfoResponseApplicationJson.
  static Serializer<AppsGetAppInfoResponseApplicationJson> get serializer =>
      _$appsGetAppInfoResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsGetAppInfoResponseApplicationJsonBuilder b) {
    $AppsGetAppInfoResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsGetAppInfoResponseApplicationJsonBuilder b) {
    $AppsGetAppInfoResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsEnableResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsEnableResponseApplicationJson_OcsInterfaceBuilder].
  $AppsEnableResponseApplicationJson_OcsInterface rebuild(
    void Function($AppsEnableResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsEnableResponseApplicationJson_OcsInterfaceBuilder].
  $AppsEnableResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsEnableResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsEnableResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppsEnableResponseApplicationJson_Ocs
    implements
        $AppsEnableResponseApplicationJson_OcsInterface,
        Built<AppsEnableResponseApplicationJson_Ocs, AppsEnableResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppsEnableResponseApplicationJson_Ocs object using the builder pattern.
  factory AppsEnableResponseApplicationJson_Ocs([void Function(AppsEnableResponseApplicationJson_OcsBuilder)? b]) =
      _$AppsEnableResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppsEnableResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsEnableResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsEnableResponseApplicationJson_Ocs.
  static Serializer<AppsEnableResponseApplicationJson_Ocs> get serializer =>
      _$appsEnableResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsEnableResponseApplicationJson_OcsBuilder b) {
    $AppsEnableResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsEnableResponseApplicationJson_OcsBuilder b) {
    $AppsEnableResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsEnableResponseApplicationJsonInterface {
  AppsEnableResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsEnableResponseApplicationJsonInterfaceBuilder].
  $AppsEnableResponseApplicationJsonInterface rebuild(
    void Function($AppsEnableResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsEnableResponseApplicationJsonInterfaceBuilder].
  $AppsEnableResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsEnableResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsEnableResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppsEnableResponseApplicationJson
    implements
        $AppsEnableResponseApplicationJsonInterface,
        Built<AppsEnableResponseApplicationJson, AppsEnableResponseApplicationJsonBuilder> {
  /// Creates a new AppsEnableResponseApplicationJson object using the builder pattern.
  factory AppsEnableResponseApplicationJson([void Function(AppsEnableResponseApplicationJsonBuilder)? b]) =
      _$AppsEnableResponseApplicationJson;

  // coverage:ignore-start
  const AppsEnableResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsEnableResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsEnableResponseApplicationJson.
  static Serializer<AppsEnableResponseApplicationJson> get serializer => _$appsEnableResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsEnableResponseApplicationJsonBuilder b) {
    $AppsEnableResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsEnableResponseApplicationJsonBuilder b) {
    $AppsEnableResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsDisableResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsDisableResponseApplicationJson_OcsInterfaceBuilder].
  $AppsDisableResponseApplicationJson_OcsInterface rebuild(
    void Function($AppsDisableResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsDisableResponseApplicationJson_OcsInterfaceBuilder].
  $AppsDisableResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsDisableResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsDisableResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppsDisableResponseApplicationJson_Ocs
    implements
        $AppsDisableResponseApplicationJson_OcsInterface,
        Built<AppsDisableResponseApplicationJson_Ocs, AppsDisableResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppsDisableResponseApplicationJson_Ocs object using the builder pattern.
  factory AppsDisableResponseApplicationJson_Ocs([void Function(AppsDisableResponseApplicationJson_OcsBuilder)? b]) =
      _$AppsDisableResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppsDisableResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsDisableResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsDisableResponseApplicationJson_Ocs.
  static Serializer<AppsDisableResponseApplicationJson_Ocs> get serializer =>
      _$appsDisableResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsDisableResponseApplicationJson_OcsBuilder b) {
    $AppsDisableResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsDisableResponseApplicationJson_OcsBuilder b) {
    $AppsDisableResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppsDisableResponseApplicationJsonInterface {
  AppsDisableResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppsDisableResponseApplicationJsonInterfaceBuilder].
  $AppsDisableResponseApplicationJsonInterface rebuild(
    void Function($AppsDisableResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppsDisableResponseApplicationJsonInterfaceBuilder].
  $AppsDisableResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppsDisableResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppsDisableResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppsDisableResponseApplicationJson
    implements
        $AppsDisableResponseApplicationJsonInterface,
        Built<AppsDisableResponseApplicationJson, AppsDisableResponseApplicationJsonBuilder> {
  /// Creates a new AppsDisableResponseApplicationJson object using the builder pattern.
  factory AppsDisableResponseApplicationJson([void Function(AppsDisableResponseApplicationJsonBuilder)? b]) =
      _$AppsDisableResponseApplicationJson;

  // coverage:ignore-start
  const AppsDisableResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppsDisableResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppsDisableResponseApplicationJson.
  static Serializer<AppsDisableResponseApplicationJson> get serializer =>
      _$appsDisableResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppsDisableResponseApplicationJsonBuilder b) {
    $AppsDisableResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppsDisableResponseApplicationJsonBuilder b) {
    $AppsDisableResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<String> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterface rebuild(
    void Function($GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs
    implements
        $GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterface,
        Built<GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs,
            GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsBuilder> {
  /// Creates a new GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs object using the builder pattern.
  factory GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs([
    void Function(GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsBuilder)? b,
  ]) = _$GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs.
  static Serializer<GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs> get serializer =>
      _$groupsGetSubAdminsOfGroupResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsBuilder b) {
    $GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsBuilder b) {
    $GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetSubAdminsOfGroupResponseApplicationJsonInterface {
  GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetSubAdminsOfGroupResponseApplicationJsonInterfaceBuilder].
  $GroupsGetSubAdminsOfGroupResponseApplicationJsonInterface rebuild(
    void Function($GroupsGetSubAdminsOfGroupResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetSubAdminsOfGroupResponseApplicationJsonInterfaceBuilder].
  $GroupsGetSubAdminsOfGroupResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetSubAdminsOfGroupResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetSubAdminsOfGroupResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class GroupsGetSubAdminsOfGroupResponseApplicationJson
    implements
        $GroupsGetSubAdminsOfGroupResponseApplicationJsonInterface,
        Built<GroupsGetSubAdminsOfGroupResponseApplicationJson,
            GroupsGetSubAdminsOfGroupResponseApplicationJsonBuilder> {
  /// Creates a new GroupsGetSubAdminsOfGroupResponseApplicationJson object using the builder pattern.
  factory GroupsGetSubAdminsOfGroupResponseApplicationJson([
    void Function(GroupsGetSubAdminsOfGroupResponseApplicationJsonBuilder)? b,
  ]) = _$GroupsGetSubAdminsOfGroupResponseApplicationJson;

  // coverage:ignore-start
  const GroupsGetSubAdminsOfGroupResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetSubAdminsOfGroupResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetSubAdminsOfGroupResponseApplicationJson.
  static Serializer<GroupsGetSubAdminsOfGroupResponseApplicationJson> get serializer =>
      _$groupsGetSubAdminsOfGroupResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetSubAdminsOfGroupResponseApplicationJsonBuilder b) {
    $GroupsGetSubAdminsOfGroupResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetSubAdminsOfGroupResponseApplicationJsonBuilder b) {
    $GroupsGetSubAdminsOfGroupResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupsResponseApplicationJson_Ocs_DataInterface {
  BuiltList<String> get groups;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($GroupsGetGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class GroupsGetGroupsResponseApplicationJson_Ocs_Data
    implements
        $GroupsGetGroupsResponseApplicationJson_Ocs_DataInterface,
        Built<GroupsGetGroupsResponseApplicationJson_Ocs_Data, GroupsGetGroupsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new GroupsGetGroupsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory GroupsGetGroupsResponseApplicationJson_Ocs_Data([
    void Function(GroupsGetGroupsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$GroupsGetGroupsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const GroupsGetGroupsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupsResponseApplicationJson_Ocs_Data.
  static Serializer<GroupsGetGroupsResponseApplicationJson_Ocs_Data> get serializer =>
      _$groupsGetGroupsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupsResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupsResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  GroupsGetGroupsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupsResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupsResponseApplicationJson_OcsInterface rebuild(
    void Function($GroupsGetGroupsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupsResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class GroupsGetGroupsResponseApplicationJson_Ocs
    implements
        $GroupsGetGroupsResponseApplicationJson_OcsInterface,
        Built<GroupsGetGroupsResponseApplicationJson_Ocs, GroupsGetGroupsResponseApplicationJson_OcsBuilder> {
  /// Creates a new GroupsGetGroupsResponseApplicationJson_Ocs object using the builder pattern.
  factory GroupsGetGroupsResponseApplicationJson_Ocs([
    void Function(GroupsGetGroupsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$GroupsGetGroupsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const GroupsGetGroupsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupsResponseApplicationJson_Ocs.
  static Serializer<GroupsGetGroupsResponseApplicationJson_Ocs> get serializer =>
      _$groupsGetGroupsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupsResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupsResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupsResponseApplicationJsonInterface {
  GroupsGetGroupsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupsResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupsResponseApplicationJsonInterface rebuild(
    void Function($GroupsGetGroupsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupsResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class GroupsGetGroupsResponseApplicationJson
    implements
        $GroupsGetGroupsResponseApplicationJsonInterface,
        Built<GroupsGetGroupsResponseApplicationJson, GroupsGetGroupsResponseApplicationJsonBuilder> {
  /// Creates a new GroupsGetGroupsResponseApplicationJson object using the builder pattern.
  factory GroupsGetGroupsResponseApplicationJson([void Function(GroupsGetGroupsResponseApplicationJsonBuilder)? b]) =
      _$GroupsGetGroupsResponseApplicationJson;

  // coverage:ignore-start
  const GroupsGetGroupsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupsResponseApplicationJson.
  static Serializer<GroupsGetGroupsResponseApplicationJson> get serializer =>
      _$groupsGetGroupsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupsResponseApplicationJsonBuilder b) {
    $GroupsGetGroupsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupsResponseApplicationJsonBuilder b) {
    $GroupsGetGroupsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupResponseApplicationJson_Ocs_DataInterface {
  BuiltList<String> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($GroupsGetGroupResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class GroupsGetGroupResponseApplicationJson_Ocs_Data
    implements
        $GroupsGetGroupResponseApplicationJson_Ocs_DataInterface,
        Built<GroupsGetGroupResponseApplicationJson_Ocs_Data, GroupsGetGroupResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new GroupsGetGroupResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory GroupsGetGroupResponseApplicationJson_Ocs_Data([
    void Function(GroupsGetGroupResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$GroupsGetGroupResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const GroupsGetGroupResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupResponseApplicationJson_Ocs_Data.
  static Serializer<GroupsGetGroupResponseApplicationJson_Ocs_Data> get serializer =>
      _$groupsGetGroupResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  GroupsGetGroupResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupResponseApplicationJson_OcsInterface rebuild(
    void Function($GroupsGetGroupResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class GroupsGetGroupResponseApplicationJson_Ocs
    implements
        $GroupsGetGroupResponseApplicationJson_OcsInterface,
        Built<GroupsGetGroupResponseApplicationJson_Ocs, GroupsGetGroupResponseApplicationJson_OcsBuilder> {
  /// Creates a new GroupsGetGroupResponseApplicationJson_Ocs object using the builder pattern.
  factory GroupsGetGroupResponseApplicationJson_Ocs([
    void Function(GroupsGetGroupResponseApplicationJson_OcsBuilder)? b,
  ]) = _$GroupsGetGroupResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const GroupsGetGroupResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupResponseApplicationJson_Ocs.
  static Serializer<GroupsGetGroupResponseApplicationJson_Ocs> get serializer =>
      _$groupsGetGroupResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupResponseApplicationJsonInterface {
  GroupsGetGroupResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupResponseApplicationJsonInterface rebuild(
    void Function($GroupsGetGroupResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class GroupsGetGroupResponseApplicationJson
    implements
        $GroupsGetGroupResponseApplicationJsonInterface,
        Built<GroupsGetGroupResponseApplicationJson, GroupsGetGroupResponseApplicationJsonBuilder> {
  /// Creates a new GroupsGetGroupResponseApplicationJson object using the builder pattern.
  factory GroupsGetGroupResponseApplicationJson([void Function(GroupsGetGroupResponseApplicationJsonBuilder)? b]) =
      _$GroupsGetGroupResponseApplicationJson;

  // coverage:ignore-start
  const GroupsGetGroupResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupResponseApplicationJson.
  static Serializer<GroupsGetGroupResponseApplicationJson> get serializer =>
      _$groupsGetGroupResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupResponseApplicationJsonBuilder b) {
    $GroupsGetGroupResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupResponseApplicationJsonBuilder b) {
    $GroupsGetGroupResponseApplicationJsonInterface._validate(b);
  }
}

typedef GroupDetails_Usercount = ({bool? $bool, int? $int});
typedef GroupDetails_Disabled = ({bool? $bool, int? $int});

@BuiltValue(instantiable: false)
sealed class $GroupDetailsInterface {
  String get id;
  String get displayname;
  GroupDetails_Usercount get usercount;
  GroupDetails_Disabled get disabled;
  bool get canAdd;
  bool get canRemove;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupDetailsInterfaceBuilder].
  $GroupDetailsInterface rebuild(void Function($GroupDetailsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$GroupDetailsInterfaceBuilder].
  $GroupDetailsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupDetailsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupDetailsInterfaceBuilder b) {
    b.usercount?.validateOneOf();
    b.disabled?.validateOneOf();
  }
}

abstract class GroupDetails implements $GroupDetailsInterface, Built<GroupDetails, GroupDetailsBuilder> {
  /// Creates a new GroupDetails object using the builder pattern.
  factory GroupDetails([void Function(GroupDetailsBuilder)? b]) = _$GroupDetails;

  // coverage:ignore-start
  const GroupDetails._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupDetails.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupDetails.
  static Serializer<GroupDetails> get serializer => _$groupDetailsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupDetailsBuilder b) {
    $GroupDetailsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupDetailsBuilder b) {
    $GroupDetailsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterface {
  BuiltList<GroupDetails> get groups;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data
    implements
        $GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterface,
        Built<GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data,
            GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data([
    void Function(GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data.
  static Serializer<GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data> get serializer =>
      _$groupsGetGroupsDetailsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupsDetailsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupsDetailsResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupsDetailsResponseApplicationJson_OcsInterface rebuild(
    void Function($GroupsGetGroupsDetailsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupsDetailsResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupsDetailsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupsDetailsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupsDetailsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class GroupsGetGroupsDetailsResponseApplicationJson_Ocs
    implements
        $GroupsGetGroupsDetailsResponseApplicationJson_OcsInterface,
        Built<GroupsGetGroupsDetailsResponseApplicationJson_Ocs,
            GroupsGetGroupsDetailsResponseApplicationJson_OcsBuilder> {
  /// Creates a new GroupsGetGroupsDetailsResponseApplicationJson_Ocs object using the builder pattern.
  factory GroupsGetGroupsDetailsResponseApplicationJson_Ocs([
    void Function(GroupsGetGroupsDetailsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$GroupsGetGroupsDetailsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const GroupsGetGroupsDetailsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupsDetailsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupsDetailsResponseApplicationJson_Ocs.
  static Serializer<GroupsGetGroupsDetailsResponseApplicationJson_Ocs> get serializer =>
      _$groupsGetGroupsDetailsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupsDetailsResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupsDetailsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupsDetailsResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupsDetailsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupsDetailsResponseApplicationJsonInterface {
  GroupsGetGroupsDetailsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupsDetailsResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupsDetailsResponseApplicationJsonInterface rebuild(
    void Function($GroupsGetGroupsDetailsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupsDetailsResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupsDetailsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupsDetailsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupsDetailsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class GroupsGetGroupsDetailsResponseApplicationJson
    implements
        $GroupsGetGroupsDetailsResponseApplicationJsonInterface,
        Built<GroupsGetGroupsDetailsResponseApplicationJson, GroupsGetGroupsDetailsResponseApplicationJsonBuilder> {
  /// Creates a new GroupsGetGroupsDetailsResponseApplicationJson object using the builder pattern.
  factory GroupsGetGroupsDetailsResponseApplicationJson([
    void Function(GroupsGetGroupsDetailsResponseApplicationJsonBuilder)? b,
  ]) = _$GroupsGetGroupsDetailsResponseApplicationJson;

  // coverage:ignore-start
  const GroupsGetGroupsDetailsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupsDetailsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupsDetailsResponseApplicationJson.
  static Serializer<GroupsGetGroupsDetailsResponseApplicationJson> get serializer =>
      _$groupsGetGroupsDetailsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupsDetailsResponseApplicationJsonBuilder b) {
    $GroupsGetGroupsDetailsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupsDetailsResponseApplicationJsonBuilder b) {
    $GroupsGetGroupsDetailsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterface {
  BuiltList<String> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class GroupsGetGroupUsersResponseApplicationJson_Ocs_Data
    implements
        $GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterface,
        Built<GroupsGetGroupUsersResponseApplicationJson_Ocs_Data,
            GroupsGetGroupUsersResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new GroupsGetGroupUsersResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory GroupsGetGroupUsersResponseApplicationJson_Ocs_Data([
    void Function(GroupsGetGroupUsersResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$GroupsGetGroupUsersResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const GroupsGetGroupUsersResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupUsersResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupUsersResponseApplicationJson_Ocs_Data.
  static Serializer<GroupsGetGroupUsersResponseApplicationJson_Ocs_Data> get serializer =>
      _$groupsGetGroupUsersResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupUsersResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupUsersResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupUsersResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupUsersResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  GroupsGetGroupUsersResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupUsersResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupUsersResponseApplicationJson_OcsInterface rebuild(
    void Function($GroupsGetGroupUsersResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupUsersResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupUsersResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupUsersResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupUsersResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class GroupsGetGroupUsersResponseApplicationJson_Ocs
    implements
        $GroupsGetGroupUsersResponseApplicationJson_OcsInterface,
        Built<GroupsGetGroupUsersResponseApplicationJson_Ocs, GroupsGetGroupUsersResponseApplicationJson_OcsBuilder> {
  /// Creates a new GroupsGetGroupUsersResponseApplicationJson_Ocs object using the builder pattern.
  factory GroupsGetGroupUsersResponseApplicationJson_Ocs([
    void Function(GroupsGetGroupUsersResponseApplicationJson_OcsBuilder)? b,
  ]) = _$GroupsGetGroupUsersResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const GroupsGetGroupUsersResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupUsersResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupUsersResponseApplicationJson_Ocs.
  static Serializer<GroupsGetGroupUsersResponseApplicationJson_Ocs> get serializer =>
      _$groupsGetGroupUsersResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupUsersResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupUsersResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupUsersResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupUsersResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupUsersResponseApplicationJsonInterface {
  GroupsGetGroupUsersResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupUsersResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupUsersResponseApplicationJsonInterface rebuild(
    void Function($GroupsGetGroupUsersResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupUsersResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupUsersResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupUsersResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupUsersResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class GroupsGetGroupUsersResponseApplicationJson
    implements
        $GroupsGetGroupUsersResponseApplicationJsonInterface,
        Built<GroupsGetGroupUsersResponseApplicationJson, GroupsGetGroupUsersResponseApplicationJsonBuilder> {
  /// Creates a new GroupsGetGroupUsersResponseApplicationJson object using the builder pattern.
  factory GroupsGetGroupUsersResponseApplicationJson([
    void Function(GroupsGetGroupUsersResponseApplicationJsonBuilder)? b,
  ]) = _$GroupsGetGroupUsersResponseApplicationJson;

  // coverage:ignore-start
  const GroupsGetGroupUsersResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupUsersResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupUsersResponseApplicationJson.
  static Serializer<GroupsGetGroupUsersResponseApplicationJson> get serializer =>
      _$groupsGetGroupUsersResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupUsersResponseApplicationJsonBuilder b) {
    $GroupsGetGroupUsersResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupUsersResponseApplicationJsonBuilder b) {
    $GroupsGetGroupUsersResponseApplicationJsonInterface._validate(b);
  }
}

class UserDetailsScope extends EnumClass {
  const UserDetailsScope._(super.name);

  /// `v2-private`
  @BuiltValueEnumConst(wireName: 'v2-private')
  static const UserDetailsScope v2Private = _$userDetailsScopeV2Private;

  /// `v2-local`
  @BuiltValueEnumConst(wireName: 'v2-local')
  static const UserDetailsScope v2Local = _$userDetailsScopeV2Local;

  /// `v2-federated`
  @BuiltValueEnumConst(wireName: 'v2-federated')
  static const UserDetailsScope v2Federated = _$userDetailsScopeV2Federated;

  /// `v2-published`
  @BuiltValueEnumConst(wireName: 'v2-published')
  static const UserDetailsScope v2Published = _$userDetailsScopeV2Published;

  /// `private`
  static const UserDetailsScope private = _$userDetailsScopePrivate;

  /// `contacts`
  static const UserDetailsScope contacts = _$userDetailsScopeContacts;

  /// `public`
  static const UserDetailsScope public = _$userDetailsScopePublic;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<UserDetailsScope> get values => _$userDetailsScopeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static UserDetailsScope valueOf(String name) => _$valueOfUserDetailsScope(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for UserDetailsScope.
  @BuiltValueSerializer(custom: true)
  static Serializer<UserDetailsScope> get serializer => const _$UserDetailsScopeSerializer();
}

class _$UserDetailsScopeSerializer implements PrimitiveSerializer<UserDetailsScope> {
  const _$UserDetailsScopeSerializer();

  static const Map<UserDetailsScope, Object> _toWire = <UserDetailsScope, Object>{
    UserDetailsScope.v2Private: 'v2-private',
    UserDetailsScope.v2Local: 'v2-local',
    UserDetailsScope.v2Federated: 'v2-federated',
    UserDetailsScope.v2Published: 'v2-published',
    UserDetailsScope.private: 'private',
    UserDetailsScope.contacts: 'contacts',
    UserDetailsScope.public: 'public',
  };

  static const Map<Object, UserDetailsScope> _fromWire = <Object, UserDetailsScope>{
    'v2-private': UserDetailsScope.v2Private,
    'v2-local': UserDetailsScope.v2Local,
    'v2-federated': UserDetailsScope.v2Federated,
    'v2-published': UserDetailsScope.v2Published,
    'private': UserDetailsScope.private,
    'contacts': UserDetailsScope.contacts,
    'public': UserDetailsScope.public,
  };

  @override
  Iterable<Type> get types => const [UserDetailsScope];

  @override
  String get wireName => 'UserDetailsScope';

  @override
  Object serialize(
    Serializers serializers,
    UserDetailsScope object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  UserDetailsScope deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $UserDetails_BackendCapabilitiesInterface {
  bool get setDisplayName;
  bool get setPassword;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserDetails_BackendCapabilitiesInterfaceBuilder].
  $UserDetails_BackendCapabilitiesInterface rebuild(
    void Function($UserDetails_BackendCapabilitiesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserDetails_BackendCapabilitiesInterfaceBuilder].
  $UserDetails_BackendCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserDetails_BackendCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserDetails_BackendCapabilitiesInterfaceBuilder b) {}
}

abstract class UserDetails_BackendCapabilities
    implements
        $UserDetails_BackendCapabilitiesInterface,
        Built<UserDetails_BackendCapabilities, UserDetails_BackendCapabilitiesBuilder> {
  /// Creates a new UserDetails_BackendCapabilities object using the builder pattern.
  factory UserDetails_BackendCapabilities([void Function(UserDetails_BackendCapabilitiesBuilder)? b]) =
      _$UserDetails_BackendCapabilities;

  // coverage:ignore-start
  const UserDetails_BackendCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserDetails_BackendCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserDetails_BackendCapabilities.
  static Serializer<UserDetails_BackendCapabilities> get serializer => _$userDetailsBackendCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserDetails_BackendCapabilitiesBuilder b) {
    $UserDetails_BackendCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserDetails_BackendCapabilitiesBuilder b) {
    $UserDetails_BackendCapabilitiesInterface._validate(b);
  }
}

typedef UserDetailsQuota_Quota = ({num? $num, String? string});

@BuiltValue(instantiable: false)
sealed class $UserDetailsQuotaInterface {
  num get free;
  UserDetailsQuota_Quota? get quota;
  num get relative;
  num get total;
  num get used;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserDetailsQuotaInterfaceBuilder].
  $UserDetailsQuotaInterface rebuild(void Function($UserDetailsQuotaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$UserDetailsQuotaInterfaceBuilder].
  $UserDetailsQuotaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserDetailsQuotaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserDetailsQuotaInterfaceBuilder b) {
    b.quota?.validateAnyOf();
  }
}

abstract class UserDetailsQuota
    implements $UserDetailsQuotaInterface, Built<UserDetailsQuota, UserDetailsQuotaBuilder> {
  /// Creates a new UserDetailsQuota object using the builder pattern.
  factory UserDetailsQuota([void Function(UserDetailsQuotaBuilder)? b]) = _$UserDetailsQuota;

  // coverage:ignore-start
  const UserDetailsQuota._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserDetailsQuota.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserDetailsQuota.
  static Serializer<UserDetailsQuota> get serializer => _$userDetailsQuotaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserDetailsQuotaBuilder b) {
    $UserDetailsQuotaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserDetailsQuotaBuilder b) {
    $UserDetailsQuotaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserDetailsInterface {
  @BuiltValueField(wireName: 'additional_mail')
  BuiltList<String> get additionalMail;
  @BuiltValueField(wireName: 'additional_mailScope')
  BuiltList<UserDetailsScope>? get additionalMailScope;
  String get address;
  UserDetailsScope? get addressScope;
  UserDetailsScope? get avatarScope;
  String get backend;
  UserDetails_BackendCapabilities get backendCapabilities;
  String get biography;
  UserDetailsScope? get biographyScope;
  @BuiltValueField(wireName: 'display-name')
  String get displayName;
  String get displayname;
  UserDetailsScope? get displaynameScope;
  String? get email;
  UserDetailsScope? get emailScope;
  bool? get enabled;
  String get fediverse;
  UserDetailsScope? get fediverseScope;
  BuiltList<String> get groups;
  String get headline;
  UserDetailsScope? get headlineScope;
  String get id;
  String get language;
  int get lastLogin;
  String get locale;
  String get manager;
  @BuiltValueField(wireName: 'notify_email')
  String? get notifyEmail;
  String get organisation;
  UserDetailsScope? get organisationScope;
  String get phone;
  UserDetailsScope? get phoneScope;
  @BuiltValueField(wireName: 'profile_enabled')
  String get profileEnabled;
  @BuiltValueField(wireName: 'profile_enabledScope')
  UserDetailsScope? get profileEnabledScope;
  UserDetailsQuota get quota;
  String get role;
  UserDetailsScope? get roleScope;
  String? get storageLocation;
  BuiltList<String> get subadmin;
  String get twitter;
  UserDetailsScope? get twitterScope;
  String get website;
  UserDetailsScope? get websiteScope;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserDetailsInterfaceBuilder].
  $UserDetailsInterface rebuild(void Function($UserDetailsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$UserDetailsInterfaceBuilder].
  $UserDetailsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserDetailsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserDetailsInterfaceBuilder b) {}
}

abstract class UserDetails implements $UserDetailsInterface, Built<UserDetails, UserDetailsBuilder> {
  /// Creates a new UserDetails object using the builder pattern.
  factory UserDetails([void Function(UserDetailsBuilder)? b]) = _$UserDetails;

  // coverage:ignore-start
  const UserDetails._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserDetails.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserDetails.
  static Serializer<UserDetails> get serializer => _$userDetailsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserDetailsBuilder b) {
    $UserDetailsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserDetailsBuilder b) {
    $UserDetailsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface {
  String get id;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder].
  $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface rebuild(
    void Function($GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder].
  $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder b) {}
}

abstract class GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1
    implements
        $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface,
        Built<GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1,
            GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder> {
  /// Creates a new GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1 object using the builder pattern.
  factory GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1([
    void Function(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder)? b,
  ]) = _$GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1;

  // coverage:ignore-start
  const GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1.
  static Serializer<GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1> get serializer =>
      _$groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder b) {
    $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder b) {
    $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface._validate(b);
  }
}

typedef GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users = ({
  GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1? groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1,
  UserDetails? userDetails
});

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data
    implements
        $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterface,
        Built<GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data,
            GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data([
    void Function(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data.
  static Serializer<GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data> get serializer =>
      _$groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataBuilder b) {
    $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterface rebuild(
    void Function($GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterfaceBuilder].
  $GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs
    implements
        $GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterface,
        Built<GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs,
            GroupsGetGroupUsersDetailsResponseApplicationJson_OcsBuilder> {
  /// Creates a new GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs object using the builder pattern.
  factory GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs([
    void Function(GroupsGetGroupUsersDetailsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs.
  static Serializer<GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs> get serializer =>
      _$groupsGetGroupUsersDetailsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupUsersDetailsResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupUsersDetailsResponseApplicationJson_OcsBuilder b) {
    $GroupsGetGroupUsersDetailsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $GroupsGetGroupUsersDetailsResponseApplicationJsonInterface {
  GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GroupsGetGroupUsersDetailsResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupUsersDetailsResponseApplicationJsonInterface rebuild(
    void Function($GroupsGetGroupUsersDetailsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GroupsGetGroupUsersDetailsResponseApplicationJsonInterfaceBuilder].
  $GroupsGetGroupUsersDetailsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GroupsGetGroupUsersDetailsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GroupsGetGroupUsersDetailsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class GroupsGetGroupUsersDetailsResponseApplicationJson
    implements
        $GroupsGetGroupUsersDetailsResponseApplicationJsonInterface,
        Built<GroupsGetGroupUsersDetailsResponseApplicationJson,
            GroupsGetGroupUsersDetailsResponseApplicationJsonBuilder> {
  /// Creates a new GroupsGetGroupUsersDetailsResponseApplicationJson object using the builder pattern.
  factory GroupsGetGroupUsersDetailsResponseApplicationJson([
    void Function(GroupsGetGroupUsersDetailsResponseApplicationJsonBuilder)? b,
  ]) = _$GroupsGetGroupUsersDetailsResponseApplicationJson;

  // coverage:ignore-start
  const GroupsGetGroupUsersDetailsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GroupsGetGroupUsersDetailsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GroupsGetGroupUsersDetailsResponseApplicationJson.
  static Serializer<GroupsGetGroupUsersDetailsResponseApplicationJson> get serializer =>
      _$groupsGetGroupUsersDetailsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GroupsGetGroupUsersDetailsResponseApplicationJsonBuilder b) {
    $GroupsGetGroupUsersDetailsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GroupsGetGroupUsersDetailsResponseApplicationJsonBuilder b) {
    $GroupsGetGroupUsersDetailsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesSetPreferenceRequestApplicationJsonInterface {
  /// New value.
  String get configValue;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesSetPreferenceRequestApplicationJsonInterfaceBuilder].
  $PreferencesSetPreferenceRequestApplicationJsonInterface rebuild(
    void Function($PreferencesSetPreferenceRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesSetPreferenceRequestApplicationJsonInterfaceBuilder].
  $PreferencesSetPreferenceRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesSetPreferenceRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesSetPreferenceRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class PreferencesSetPreferenceRequestApplicationJson
    implements
        $PreferencesSetPreferenceRequestApplicationJsonInterface,
        Built<PreferencesSetPreferenceRequestApplicationJson, PreferencesSetPreferenceRequestApplicationJsonBuilder> {
  /// Creates a new PreferencesSetPreferenceRequestApplicationJson object using the builder pattern.
  factory PreferencesSetPreferenceRequestApplicationJson([
    void Function(PreferencesSetPreferenceRequestApplicationJsonBuilder)? b,
  ]) = _$PreferencesSetPreferenceRequestApplicationJson;

  // coverage:ignore-start
  const PreferencesSetPreferenceRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesSetPreferenceRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesSetPreferenceRequestApplicationJson.
  static Serializer<PreferencesSetPreferenceRequestApplicationJson> get serializer =>
      _$preferencesSetPreferenceRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesSetPreferenceRequestApplicationJsonBuilder b) {
    $PreferencesSetPreferenceRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesSetPreferenceRequestApplicationJsonBuilder b) {
    $PreferencesSetPreferenceRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesSetPreferenceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesSetPreferenceResponseApplicationJson_OcsInterfaceBuilder].
  $PreferencesSetPreferenceResponseApplicationJson_OcsInterface rebuild(
    void Function($PreferencesSetPreferenceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesSetPreferenceResponseApplicationJson_OcsInterfaceBuilder].
  $PreferencesSetPreferenceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesSetPreferenceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesSetPreferenceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class PreferencesSetPreferenceResponseApplicationJson_Ocs
    implements
        $PreferencesSetPreferenceResponseApplicationJson_OcsInterface,
        Built<PreferencesSetPreferenceResponseApplicationJson_Ocs,
            PreferencesSetPreferenceResponseApplicationJson_OcsBuilder> {
  /// Creates a new PreferencesSetPreferenceResponseApplicationJson_Ocs object using the builder pattern.
  factory PreferencesSetPreferenceResponseApplicationJson_Ocs([
    void Function(PreferencesSetPreferenceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$PreferencesSetPreferenceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const PreferencesSetPreferenceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesSetPreferenceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesSetPreferenceResponseApplicationJson_Ocs.
  static Serializer<PreferencesSetPreferenceResponseApplicationJson_Ocs> get serializer =>
      _$preferencesSetPreferenceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesSetPreferenceResponseApplicationJson_OcsBuilder b) {
    $PreferencesSetPreferenceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesSetPreferenceResponseApplicationJson_OcsBuilder b) {
    $PreferencesSetPreferenceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesSetPreferenceResponseApplicationJsonInterface {
  PreferencesSetPreferenceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesSetPreferenceResponseApplicationJsonInterfaceBuilder].
  $PreferencesSetPreferenceResponseApplicationJsonInterface rebuild(
    void Function($PreferencesSetPreferenceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesSetPreferenceResponseApplicationJsonInterfaceBuilder].
  $PreferencesSetPreferenceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesSetPreferenceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesSetPreferenceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class PreferencesSetPreferenceResponseApplicationJson
    implements
        $PreferencesSetPreferenceResponseApplicationJsonInterface,
        Built<PreferencesSetPreferenceResponseApplicationJson, PreferencesSetPreferenceResponseApplicationJsonBuilder> {
  /// Creates a new PreferencesSetPreferenceResponseApplicationJson object using the builder pattern.
  factory PreferencesSetPreferenceResponseApplicationJson([
    void Function(PreferencesSetPreferenceResponseApplicationJsonBuilder)? b,
  ]) = _$PreferencesSetPreferenceResponseApplicationJson;

  // coverage:ignore-start
  const PreferencesSetPreferenceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesSetPreferenceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesSetPreferenceResponseApplicationJson.
  static Serializer<PreferencesSetPreferenceResponseApplicationJson> get serializer =>
      _$preferencesSetPreferenceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesSetPreferenceResponseApplicationJsonBuilder b) {
    $PreferencesSetPreferenceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesSetPreferenceResponseApplicationJsonBuilder b) {
    $PreferencesSetPreferenceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesDeletePreferenceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesDeletePreferenceResponseApplicationJson_OcsInterfaceBuilder].
  $PreferencesDeletePreferenceResponseApplicationJson_OcsInterface rebuild(
    void Function($PreferencesDeletePreferenceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesDeletePreferenceResponseApplicationJson_OcsInterfaceBuilder].
  $PreferencesDeletePreferenceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesDeletePreferenceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesDeletePreferenceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class PreferencesDeletePreferenceResponseApplicationJson_Ocs
    implements
        $PreferencesDeletePreferenceResponseApplicationJson_OcsInterface,
        Built<PreferencesDeletePreferenceResponseApplicationJson_Ocs,
            PreferencesDeletePreferenceResponseApplicationJson_OcsBuilder> {
  /// Creates a new PreferencesDeletePreferenceResponseApplicationJson_Ocs object using the builder pattern.
  factory PreferencesDeletePreferenceResponseApplicationJson_Ocs([
    void Function(PreferencesDeletePreferenceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$PreferencesDeletePreferenceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const PreferencesDeletePreferenceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesDeletePreferenceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesDeletePreferenceResponseApplicationJson_Ocs.
  static Serializer<PreferencesDeletePreferenceResponseApplicationJson_Ocs> get serializer =>
      _$preferencesDeletePreferenceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesDeletePreferenceResponseApplicationJson_OcsBuilder b) {
    $PreferencesDeletePreferenceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesDeletePreferenceResponseApplicationJson_OcsBuilder b) {
    $PreferencesDeletePreferenceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesDeletePreferenceResponseApplicationJsonInterface {
  PreferencesDeletePreferenceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesDeletePreferenceResponseApplicationJsonInterfaceBuilder].
  $PreferencesDeletePreferenceResponseApplicationJsonInterface rebuild(
    void Function($PreferencesDeletePreferenceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesDeletePreferenceResponseApplicationJsonInterfaceBuilder].
  $PreferencesDeletePreferenceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesDeletePreferenceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesDeletePreferenceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class PreferencesDeletePreferenceResponseApplicationJson
    implements
        $PreferencesDeletePreferenceResponseApplicationJsonInterface,
        Built<PreferencesDeletePreferenceResponseApplicationJson,
            PreferencesDeletePreferenceResponseApplicationJsonBuilder> {
  /// Creates a new PreferencesDeletePreferenceResponseApplicationJson object using the builder pattern.
  factory PreferencesDeletePreferenceResponseApplicationJson([
    void Function(PreferencesDeletePreferenceResponseApplicationJsonBuilder)? b,
  ]) = _$PreferencesDeletePreferenceResponseApplicationJson;

  // coverage:ignore-start
  const PreferencesDeletePreferenceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesDeletePreferenceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesDeletePreferenceResponseApplicationJson.
  static Serializer<PreferencesDeletePreferenceResponseApplicationJson> get serializer =>
      _$preferencesDeletePreferenceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesDeletePreferenceResponseApplicationJsonBuilder b) {
    $PreferencesDeletePreferenceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesDeletePreferenceResponseApplicationJsonBuilder b) {
    $PreferencesDeletePreferenceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesSetMultiplePreferencesRequestApplicationJsonInterface {
  /// Key-value pairs of the preferences.
  BuiltMap<String, String> get configs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesSetMultiplePreferencesRequestApplicationJsonInterfaceBuilder].
  $PreferencesSetMultiplePreferencesRequestApplicationJsonInterface rebuild(
    void Function($PreferencesSetMultiplePreferencesRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesSetMultiplePreferencesRequestApplicationJsonInterfaceBuilder].
  $PreferencesSetMultiplePreferencesRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesSetMultiplePreferencesRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesSetMultiplePreferencesRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class PreferencesSetMultiplePreferencesRequestApplicationJson
    implements
        $PreferencesSetMultiplePreferencesRequestApplicationJsonInterface,
        Built<PreferencesSetMultiplePreferencesRequestApplicationJson,
            PreferencesSetMultiplePreferencesRequestApplicationJsonBuilder> {
  /// Creates a new PreferencesSetMultiplePreferencesRequestApplicationJson object using the builder pattern.
  factory PreferencesSetMultiplePreferencesRequestApplicationJson([
    void Function(PreferencesSetMultiplePreferencesRequestApplicationJsonBuilder)? b,
  ]) = _$PreferencesSetMultiplePreferencesRequestApplicationJson;

  // coverage:ignore-start
  const PreferencesSetMultiplePreferencesRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesSetMultiplePreferencesRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesSetMultiplePreferencesRequestApplicationJson.
  static Serializer<PreferencesSetMultiplePreferencesRequestApplicationJson> get serializer =>
      _$preferencesSetMultiplePreferencesRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesSetMultiplePreferencesRequestApplicationJsonBuilder b) {
    $PreferencesSetMultiplePreferencesRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesSetMultiplePreferencesRequestApplicationJsonBuilder b) {
    $PreferencesSetMultiplePreferencesRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterfaceBuilder].
  $PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterface rebuild(
    void Function($PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterfaceBuilder].
  $PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs
    implements
        $PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterface,
        Built<PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs,
            PreferencesSetMultiplePreferencesResponseApplicationJson_OcsBuilder> {
  /// Creates a new PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs object using the builder pattern.
  factory PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs([
    void Function(PreferencesSetMultiplePreferencesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs.
  static Serializer<PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs> get serializer =>
      _$preferencesSetMultiplePreferencesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesSetMultiplePreferencesResponseApplicationJson_OcsBuilder b) {
    $PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesSetMultiplePreferencesResponseApplicationJson_OcsBuilder b) {
    $PreferencesSetMultiplePreferencesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesSetMultiplePreferencesResponseApplicationJsonInterface {
  PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesSetMultiplePreferencesResponseApplicationJsonInterfaceBuilder].
  $PreferencesSetMultiplePreferencesResponseApplicationJsonInterface rebuild(
    void Function($PreferencesSetMultiplePreferencesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesSetMultiplePreferencesResponseApplicationJsonInterfaceBuilder].
  $PreferencesSetMultiplePreferencesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesSetMultiplePreferencesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesSetMultiplePreferencesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class PreferencesSetMultiplePreferencesResponseApplicationJson
    implements
        $PreferencesSetMultiplePreferencesResponseApplicationJsonInterface,
        Built<PreferencesSetMultiplePreferencesResponseApplicationJson,
            PreferencesSetMultiplePreferencesResponseApplicationJsonBuilder> {
  /// Creates a new PreferencesSetMultiplePreferencesResponseApplicationJson object using the builder pattern.
  factory PreferencesSetMultiplePreferencesResponseApplicationJson([
    void Function(PreferencesSetMultiplePreferencesResponseApplicationJsonBuilder)? b,
  ]) = _$PreferencesSetMultiplePreferencesResponseApplicationJson;

  // coverage:ignore-start
  const PreferencesSetMultiplePreferencesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesSetMultiplePreferencesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesSetMultiplePreferencesResponseApplicationJson.
  static Serializer<PreferencesSetMultiplePreferencesResponseApplicationJson> get serializer =>
      _$preferencesSetMultiplePreferencesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesSetMultiplePreferencesResponseApplicationJsonBuilder b) {
    $PreferencesSetMultiplePreferencesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesSetMultiplePreferencesResponseApplicationJsonBuilder b) {
    $PreferencesSetMultiplePreferencesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterfaceBuilder].
  $PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterface rebuild(
    void Function($PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterfaceBuilder].
  $PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs
    implements
        $PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterface,
        Built<PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs,
            PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsBuilder> {
  /// Creates a new PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs object using the builder pattern.
  factory PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs([
    void Function(PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs.
  static Serializer<PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs> get serializer =>
      _$preferencesDeleteMultiplePreferenceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsBuilder b) {
    $PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsBuilder b) {
    $PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterface {
  PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterfaceBuilder].
  $PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterface rebuild(
    void Function($PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterfaceBuilder].
  $PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class PreferencesDeleteMultiplePreferenceResponseApplicationJson
    implements
        $PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterface,
        Built<PreferencesDeleteMultiplePreferenceResponseApplicationJson,
            PreferencesDeleteMultiplePreferenceResponseApplicationJsonBuilder> {
  /// Creates a new PreferencesDeleteMultiplePreferenceResponseApplicationJson object using the builder pattern.
  factory PreferencesDeleteMultiplePreferenceResponseApplicationJson([
    void Function(PreferencesDeleteMultiplePreferenceResponseApplicationJsonBuilder)? b,
  ]) = _$PreferencesDeleteMultiplePreferenceResponseApplicationJson;

  // coverage:ignore-start
  const PreferencesDeleteMultiplePreferenceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PreferencesDeleteMultiplePreferenceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PreferencesDeleteMultiplePreferenceResponseApplicationJson.
  static Serializer<PreferencesDeleteMultiplePreferenceResponseApplicationJson> get serializer =>
      _$preferencesDeleteMultiplePreferenceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PreferencesDeleteMultiplePreferenceResponseApplicationJsonBuilder b) {
    $PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PreferencesDeleteMultiplePreferenceResponseApplicationJsonBuilder b) {
    $PreferencesDeleteMultiplePreferenceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Interface {
  String get id;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder].
  $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Interface rebuild(
    void Function($UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder].
  $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder b) {}
}

abstract class UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1
    implements
        $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Interface,
        Built<UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1,
            UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Builder> {
  /// Creates a new UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1 object using the builder pattern.
  factory UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1([
    void Function(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Builder)? b,
  ]) = _$UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1;

  // coverage:ignore-start
  const UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1.
  static Serializer<UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1> get serializer =>
      _$usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Builder b) {
    $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Builder b) {
    $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Interface._validate(b);
  }
}

typedef UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users = ({
  UserDetails? userDetails,
  UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1? usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1
});

@BuiltValue(instantiable: false)
sealed class $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data
    implements
        $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterface,
        Built<UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data,
            UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data([
    void Function(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data.
  static Serializer<UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data> get serializer =>
      _$usersGetLastLoggedInUsersResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetLastLoggedInUsersResponseApplicationJson_Ocs
    implements
        $UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterface,
        Built<UsersGetLastLoggedInUsersResponseApplicationJson_Ocs,
            UsersGetLastLoggedInUsersResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetLastLoggedInUsersResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetLastLoggedInUsersResponseApplicationJson_Ocs([
    void Function(UsersGetLastLoggedInUsersResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetLastLoggedInUsersResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetLastLoggedInUsersResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetLastLoggedInUsersResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetLastLoggedInUsersResponseApplicationJson_Ocs.
  static Serializer<UsersGetLastLoggedInUsersResponseApplicationJson_Ocs> get serializer =>
      _$usersGetLastLoggedInUsersResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetLastLoggedInUsersResponseApplicationJson_OcsBuilder b) {
    $UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetLastLoggedInUsersResponseApplicationJson_OcsBuilder b) {
    $UsersGetLastLoggedInUsersResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetLastLoggedInUsersResponseApplicationJsonInterface {
  UsersGetLastLoggedInUsersResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetLastLoggedInUsersResponseApplicationJsonInterfaceBuilder].
  $UsersGetLastLoggedInUsersResponseApplicationJsonInterface rebuild(
    void Function($UsersGetLastLoggedInUsersResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetLastLoggedInUsersResponseApplicationJsonInterfaceBuilder].
  $UsersGetLastLoggedInUsersResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetLastLoggedInUsersResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetLastLoggedInUsersResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetLastLoggedInUsersResponseApplicationJson
    implements
        $UsersGetLastLoggedInUsersResponseApplicationJsonInterface,
        Built<UsersGetLastLoggedInUsersResponseApplicationJson,
            UsersGetLastLoggedInUsersResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetLastLoggedInUsersResponseApplicationJson object using the builder pattern.
  factory UsersGetLastLoggedInUsersResponseApplicationJson([
    void Function(UsersGetLastLoggedInUsersResponseApplicationJsonBuilder)? b,
  ]) = _$UsersGetLastLoggedInUsersResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetLastLoggedInUsersResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetLastLoggedInUsersResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetLastLoggedInUsersResponseApplicationJson.
  static Serializer<UsersGetLastLoggedInUsersResponseApplicationJson> get serializer =>
      _$usersGetLastLoggedInUsersResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetLastLoggedInUsersResponseApplicationJsonBuilder b) {
    $UsersGetLastLoggedInUsersResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetLastLoggedInUsersResponseApplicationJsonBuilder b) {
    $UsersGetLastLoggedInUsersResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<String> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs
    implements
        $UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterface,
        Built<UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs,
            UsersGetUserSubAdminGroupsResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs([
    void Function(UsersGetUserSubAdminGroupsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs.
  static Serializer<UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs> get serializer =>
      _$usersGetUserSubAdminGroupsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUserSubAdminGroupsResponseApplicationJson_OcsBuilder b) {
    $UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUserSubAdminGroupsResponseApplicationJson_OcsBuilder b) {
    $UsersGetUserSubAdminGroupsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUserSubAdminGroupsResponseApplicationJsonInterface {
  UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUserSubAdminGroupsResponseApplicationJsonInterfaceBuilder].
  $UsersGetUserSubAdminGroupsResponseApplicationJsonInterface rebuild(
    void Function($UsersGetUserSubAdminGroupsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUserSubAdminGroupsResponseApplicationJsonInterfaceBuilder].
  $UsersGetUserSubAdminGroupsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUserSubAdminGroupsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUserSubAdminGroupsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetUserSubAdminGroupsResponseApplicationJson
    implements
        $UsersGetUserSubAdminGroupsResponseApplicationJsonInterface,
        Built<UsersGetUserSubAdminGroupsResponseApplicationJson,
            UsersGetUserSubAdminGroupsResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetUserSubAdminGroupsResponseApplicationJson object using the builder pattern.
  factory UsersGetUserSubAdminGroupsResponseApplicationJson([
    void Function(UsersGetUserSubAdminGroupsResponseApplicationJsonBuilder)? b,
  ]) = _$UsersGetUserSubAdminGroupsResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetUserSubAdminGroupsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUserSubAdminGroupsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUserSubAdminGroupsResponseApplicationJson.
  static Serializer<UsersGetUserSubAdminGroupsResponseApplicationJson> get serializer =>
      _$usersGetUserSubAdminGroupsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUserSubAdminGroupsResponseApplicationJsonBuilder b) {
    $UsersGetUserSubAdminGroupsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUserSubAdminGroupsResponseApplicationJsonBuilder b) {
    $UsersGetUserSubAdminGroupsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddSubAdminRequestApplicationJsonInterface {
  /// ID of the group.
  String get groupid;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddSubAdminRequestApplicationJsonInterfaceBuilder].
  $UsersAddSubAdminRequestApplicationJsonInterface rebuild(
    void Function($UsersAddSubAdminRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddSubAdminRequestApplicationJsonInterfaceBuilder].
  $UsersAddSubAdminRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddSubAdminRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddSubAdminRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersAddSubAdminRequestApplicationJson
    implements
        $UsersAddSubAdminRequestApplicationJsonInterface,
        Built<UsersAddSubAdminRequestApplicationJson, UsersAddSubAdminRequestApplicationJsonBuilder> {
  /// Creates a new UsersAddSubAdminRequestApplicationJson object using the builder pattern.
  factory UsersAddSubAdminRequestApplicationJson([void Function(UsersAddSubAdminRequestApplicationJsonBuilder)? b]) =
      _$UsersAddSubAdminRequestApplicationJson;

  // coverage:ignore-start
  const UsersAddSubAdminRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddSubAdminRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddSubAdminRequestApplicationJson.
  static Serializer<UsersAddSubAdminRequestApplicationJson> get serializer =>
      _$usersAddSubAdminRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddSubAdminRequestApplicationJsonBuilder b) {
    $UsersAddSubAdminRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddSubAdminRequestApplicationJsonBuilder b) {
    $UsersAddSubAdminRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddSubAdminResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddSubAdminResponseApplicationJson_OcsInterfaceBuilder].
  $UsersAddSubAdminResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersAddSubAdminResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddSubAdminResponseApplicationJson_OcsInterfaceBuilder].
  $UsersAddSubAdminResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddSubAdminResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddSubAdminResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersAddSubAdminResponseApplicationJson_Ocs
    implements
        $UsersAddSubAdminResponseApplicationJson_OcsInterface,
        Built<UsersAddSubAdminResponseApplicationJson_Ocs, UsersAddSubAdminResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersAddSubAdminResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersAddSubAdminResponseApplicationJson_Ocs([
    void Function(UsersAddSubAdminResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersAddSubAdminResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersAddSubAdminResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddSubAdminResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddSubAdminResponseApplicationJson_Ocs.
  static Serializer<UsersAddSubAdminResponseApplicationJson_Ocs> get serializer =>
      _$usersAddSubAdminResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddSubAdminResponseApplicationJson_OcsBuilder b) {
    $UsersAddSubAdminResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddSubAdminResponseApplicationJson_OcsBuilder b) {
    $UsersAddSubAdminResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddSubAdminResponseApplicationJsonInterface {
  UsersAddSubAdminResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddSubAdminResponseApplicationJsonInterfaceBuilder].
  $UsersAddSubAdminResponseApplicationJsonInterface rebuild(
    void Function($UsersAddSubAdminResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddSubAdminResponseApplicationJsonInterfaceBuilder].
  $UsersAddSubAdminResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddSubAdminResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddSubAdminResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersAddSubAdminResponseApplicationJson
    implements
        $UsersAddSubAdminResponseApplicationJsonInterface,
        Built<UsersAddSubAdminResponseApplicationJson, UsersAddSubAdminResponseApplicationJsonBuilder> {
  /// Creates a new UsersAddSubAdminResponseApplicationJson object using the builder pattern.
  factory UsersAddSubAdminResponseApplicationJson([void Function(UsersAddSubAdminResponseApplicationJsonBuilder)? b]) =
      _$UsersAddSubAdminResponseApplicationJson;

  // coverage:ignore-start
  const UsersAddSubAdminResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddSubAdminResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddSubAdminResponseApplicationJson.
  static Serializer<UsersAddSubAdminResponseApplicationJson> get serializer =>
      _$usersAddSubAdminResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddSubAdminResponseApplicationJsonBuilder b) {
    $UsersAddSubAdminResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddSubAdminResponseApplicationJsonBuilder b) {
    $UsersAddSubAdminResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersRemoveSubAdminResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersRemoveSubAdminResponseApplicationJson_OcsInterfaceBuilder].
  $UsersRemoveSubAdminResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersRemoveSubAdminResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersRemoveSubAdminResponseApplicationJson_OcsInterfaceBuilder].
  $UsersRemoveSubAdminResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersRemoveSubAdminResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersRemoveSubAdminResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersRemoveSubAdminResponseApplicationJson_Ocs
    implements
        $UsersRemoveSubAdminResponseApplicationJson_OcsInterface,
        Built<UsersRemoveSubAdminResponseApplicationJson_Ocs, UsersRemoveSubAdminResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersRemoveSubAdminResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersRemoveSubAdminResponseApplicationJson_Ocs([
    void Function(UsersRemoveSubAdminResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersRemoveSubAdminResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersRemoveSubAdminResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersRemoveSubAdminResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersRemoveSubAdminResponseApplicationJson_Ocs.
  static Serializer<UsersRemoveSubAdminResponseApplicationJson_Ocs> get serializer =>
      _$usersRemoveSubAdminResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersRemoveSubAdminResponseApplicationJson_OcsBuilder b) {
    $UsersRemoveSubAdminResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersRemoveSubAdminResponseApplicationJson_OcsBuilder b) {
    $UsersRemoveSubAdminResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersRemoveSubAdminResponseApplicationJsonInterface {
  UsersRemoveSubAdminResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersRemoveSubAdminResponseApplicationJsonInterfaceBuilder].
  $UsersRemoveSubAdminResponseApplicationJsonInterface rebuild(
    void Function($UsersRemoveSubAdminResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersRemoveSubAdminResponseApplicationJsonInterfaceBuilder].
  $UsersRemoveSubAdminResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersRemoveSubAdminResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersRemoveSubAdminResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersRemoveSubAdminResponseApplicationJson
    implements
        $UsersRemoveSubAdminResponseApplicationJsonInterface,
        Built<UsersRemoveSubAdminResponseApplicationJson, UsersRemoveSubAdminResponseApplicationJsonBuilder> {
  /// Creates a new UsersRemoveSubAdminResponseApplicationJson object using the builder pattern.
  factory UsersRemoveSubAdminResponseApplicationJson([
    void Function(UsersRemoveSubAdminResponseApplicationJsonBuilder)? b,
  ]) = _$UsersRemoveSubAdminResponseApplicationJson;

  // coverage:ignore-start
  const UsersRemoveSubAdminResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersRemoveSubAdminResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersRemoveSubAdminResponseApplicationJson.
  static Serializer<UsersRemoveSubAdminResponseApplicationJson> get serializer =>
      _$usersRemoveSubAdminResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersRemoveSubAdminResponseApplicationJsonBuilder b) {
    $UsersRemoveSubAdminResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersRemoveSubAdminResponseApplicationJsonBuilder b) {
    $UsersRemoveSubAdminResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersResponseApplicationJson_Ocs_DataInterface {
  BuiltList<String> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetUsersResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($UsersGetUsersResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetUsersResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class UsersGetUsersResponseApplicationJson_Ocs_Data
    implements
        $UsersGetUsersResponseApplicationJson_Ocs_DataInterface,
        Built<UsersGetUsersResponseApplicationJson_Ocs_Data, UsersGetUsersResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new UsersGetUsersResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory UsersGetUsersResponseApplicationJson_Ocs_Data([
    void Function(UsersGetUsersResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$UsersGetUsersResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const UsersGetUsersResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersResponseApplicationJson_Ocs_Data.
  static Serializer<UsersGetUsersResponseApplicationJson_Ocs_Data> get serializer =>
      _$usersGetUsersResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetUsersResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetUsersResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UsersGetUsersResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUsersResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetUsersResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUsersResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetUsersResponseApplicationJson_Ocs
    implements
        $UsersGetUsersResponseApplicationJson_OcsInterface,
        Built<UsersGetUsersResponseApplicationJson_Ocs, UsersGetUsersResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetUsersResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetUsersResponseApplicationJson_Ocs([
    void Function(UsersGetUsersResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetUsersResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetUsersResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersResponseApplicationJson_Ocs.
  static Serializer<UsersGetUsersResponseApplicationJson_Ocs> get serializer =>
      _$usersGetUsersResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersResponseApplicationJson_OcsBuilder b) {
    $UsersGetUsersResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersResponseApplicationJson_OcsBuilder b) {
    $UsersGetUsersResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersResponseApplicationJsonInterface {
  UsersGetUsersResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersResponseApplicationJsonInterfaceBuilder].
  $UsersGetUsersResponseApplicationJsonInterface rebuild(
    void Function($UsersGetUsersResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersResponseApplicationJsonInterfaceBuilder].
  $UsersGetUsersResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetUsersResponseApplicationJson
    implements
        $UsersGetUsersResponseApplicationJsonInterface,
        Built<UsersGetUsersResponseApplicationJson, UsersGetUsersResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetUsersResponseApplicationJson object using the builder pattern.
  factory UsersGetUsersResponseApplicationJson([void Function(UsersGetUsersResponseApplicationJsonBuilder)? b]) =
      _$UsersGetUsersResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetUsersResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersResponseApplicationJson.
  static Serializer<UsersGetUsersResponseApplicationJson> get serializer =>
      _$usersGetUsersResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersResponseApplicationJsonBuilder b) {
    $UsersGetUsersResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersResponseApplicationJsonBuilder b) {
    $UsersGetUsersResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddUserRequestApplicationJsonInterface {
  static final _$password = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$displayName = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$email = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$groups = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(String)]),
  )! as BuiltList<String>;

  static final _$subadmin = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(String)]),
  )! as BuiltList<String>;

  static final _$quota = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$language = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// ID of the user.
  String get userid;

  /// Password of the user.
  String get password;

  /// Display name of the user.
  String get displayName;

  /// Email of the user.
  String get email;

  /// Groups of the user.
  BuiltList<String> get groups;

  /// Groups where the user is subadmin.
  BuiltList<String> get subadmin;

  /// Quota of the user.
  String get quota;

  /// Language of the user.
  String get language;

  /// Manager of the user.
  String? get manager;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddUserRequestApplicationJsonInterfaceBuilder].
  $UsersAddUserRequestApplicationJsonInterface rebuild(
    void Function($UsersAddUserRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddUserRequestApplicationJsonInterfaceBuilder].
  $UsersAddUserRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddUserRequestApplicationJsonInterfaceBuilder b) {
    b.password = _$password;
    b.displayName = _$displayName;
    b.email = _$email;
    b.groups.replace(_$groups);
    b.subadmin.replace(_$subadmin);
    b.quota = _$quota;
    b.language = _$language;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddUserRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersAddUserRequestApplicationJson
    implements
        $UsersAddUserRequestApplicationJsonInterface,
        Built<UsersAddUserRequestApplicationJson, UsersAddUserRequestApplicationJsonBuilder> {
  /// Creates a new UsersAddUserRequestApplicationJson object using the builder pattern.
  factory UsersAddUserRequestApplicationJson([void Function(UsersAddUserRequestApplicationJsonBuilder)? b]) =
      _$UsersAddUserRequestApplicationJson;

  // coverage:ignore-start
  const UsersAddUserRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddUserRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddUserRequestApplicationJson.
  static Serializer<UsersAddUserRequestApplicationJson> get serializer =>
      _$usersAddUserRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddUserRequestApplicationJsonBuilder b) {
    $UsersAddUserRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddUserRequestApplicationJsonBuilder b) {
    $UsersAddUserRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddUserResponseApplicationJson_Ocs_DataInterface {
  String get id;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddUserResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersAddUserResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($UsersAddUserResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddUserResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersAddUserResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddUserResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddUserResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class UsersAddUserResponseApplicationJson_Ocs_Data
    implements
        $UsersAddUserResponseApplicationJson_Ocs_DataInterface,
        Built<UsersAddUserResponseApplicationJson_Ocs_Data, UsersAddUserResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new UsersAddUserResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory UsersAddUserResponseApplicationJson_Ocs_Data([
    void Function(UsersAddUserResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$UsersAddUserResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const UsersAddUserResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddUserResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddUserResponseApplicationJson_Ocs_Data.
  static Serializer<UsersAddUserResponseApplicationJson_Ocs_Data> get serializer =>
      _$usersAddUserResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddUserResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersAddUserResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddUserResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersAddUserResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UsersAddUserResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersAddUserResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersAddUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersAddUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersAddUserResponseApplicationJson_Ocs
    implements
        $UsersAddUserResponseApplicationJson_OcsInterface,
        Built<UsersAddUserResponseApplicationJson_Ocs, UsersAddUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersAddUserResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersAddUserResponseApplicationJson_Ocs([void Function(UsersAddUserResponseApplicationJson_OcsBuilder)? b]) =
      _$UsersAddUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersAddUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddUserResponseApplicationJson_Ocs.
  static Serializer<UsersAddUserResponseApplicationJson_Ocs> get serializer =>
      _$usersAddUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddUserResponseApplicationJson_OcsBuilder b) {
    $UsersAddUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddUserResponseApplicationJson_OcsBuilder b) {
    $UsersAddUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddUserResponseApplicationJsonInterface {
  UsersAddUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddUserResponseApplicationJsonInterfaceBuilder].
  $UsersAddUserResponseApplicationJsonInterface rebuild(
    void Function($UsersAddUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddUserResponseApplicationJsonInterfaceBuilder].
  $UsersAddUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersAddUserResponseApplicationJson
    implements
        $UsersAddUserResponseApplicationJsonInterface,
        Built<UsersAddUserResponseApplicationJson, UsersAddUserResponseApplicationJsonBuilder> {
  /// Creates a new UsersAddUserResponseApplicationJson object using the builder pattern.
  factory UsersAddUserResponseApplicationJson([void Function(UsersAddUserResponseApplicationJsonBuilder)? b]) =
      _$UsersAddUserResponseApplicationJson;

  // coverage:ignore-start
  const UsersAddUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddUserResponseApplicationJson.
  static Serializer<UsersAddUserResponseApplicationJson> get serializer =>
      _$usersAddUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddUserResponseApplicationJsonBuilder b) {
    $UsersAddUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddUserResponseApplicationJsonBuilder b) {
    $UsersAddUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface {
  String get id;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder].
  $UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface rebuild(
    void Function($UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder].
  $UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder b) {}
}

abstract class UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1
    implements
        $UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface,
        Built<UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1,
            UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder> {
  /// Creates a new UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1 object using the builder pattern.
  factory UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1([
    void Function(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder)? b,
  ]) = _$UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1;

  // coverage:ignore-start
  const UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1.
  static Serializer<UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1> get serializer =>
      _$usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder b) {
    $UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder b) {
    $UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface._validate(b);
  }
}

typedef UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users = ({
  UserDetails? userDetails,
  UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1? usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1
});

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class UsersGetUsersDetailsResponseApplicationJson_Ocs_Data
    implements
        $UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterface,
        Built<UsersGetUsersDetailsResponseApplicationJson_Ocs_Data,
            UsersGetUsersDetailsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new UsersGetUsersDetailsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory UsersGetUsersDetailsResponseApplicationJson_Ocs_Data([
    void Function(UsersGetUsersDetailsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$UsersGetUsersDetailsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const UsersGetUsersDetailsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersDetailsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersDetailsResponseApplicationJson_Ocs_Data.
  static Serializer<UsersGetUsersDetailsResponseApplicationJson_Ocs_Data> get serializer =>
      _$usersGetUsersDetailsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersDetailsResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersDetailsResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetUsersDetailsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersDetailsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UsersGetUsersDetailsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersDetailsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUsersDetailsResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetUsersDetailsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersDetailsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUsersDetailsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersDetailsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersDetailsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetUsersDetailsResponseApplicationJson_Ocs
    implements
        $UsersGetUsersDetailsResponseApplicationJson_OcsInterface,
        Built<UsersGetUsersDetailsResponseApplicationJson_Ocs, UsersGetUsersDetailsResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetUsersDetailsResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetUsersDetailsResponseApplicationJson_Ocs([
    void Function(UsersGetUsersDetailsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetUsersDetailsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetUsersDetailsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersDetailsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersDetailsResponseApplicationJson_Ocs.
  static Serializer<UsersGetUsersDetailsResponseApplicationJson_Ocs> get serializer =>
      _$usersGetUsersDetailsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersDetailsResponseApplicationJson_OcsBuilder b) {
    $UsersGetUsersDetailsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersDetailsResponseApplicationJson_OcsBuilder b) {
    $UsersGetUsersDetailsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersDetailsResponseApplicationJsonInterface {
  UsersGetUsersDetailsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersDetailsResponseApplicationJsonInterfaceBuilder].
  $UsersGetUsersDetailsResponseApplicationJsonInterface rebuild(
    void Function($UsersGetUsersDetailsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersDetailsResponseApplicationJsonInterfaceBuilder].
  $UsersGetUsersDetailsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersDetailsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersDetailsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetUsersDetailsResponseApplicationJson
    implements
        $UsersGetUsersDetailsResponseApplicationJsonInterface,
        Built<UsersGetUsersDetailsResponseApplicationJson, UsersGetUsersDetailsResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetUsersDetailsResponseApplicationJson object using the builder pattern.
  factory UsersGetUsersDetailsResponseApplicationJson([
    void Function(UsersGetUsersDetailsResponseApplicationJsonBuilder)? b,
  ]) = _$UsersGetUsersDetailsResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetUsersDetailsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersDetailsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersDetailsResponseApplicationJson.
  static Serializer<UsersGetUsersDetailsResponseApplicationJson> get serializer =>
      _$usersGetUsersDetailsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersDetailsResponseApplicationJsonBuilder b) {
    $UsersGetUsersDetailsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersDetailsResponseApplicationJsonBuilder b) {
    $UsersGetUsersDetailsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface {
  String get id;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder].
  $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface rebuild(
    void Function($UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder].
  $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1InterfaceBuilder b) {}
}

abstract class UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1
    implements
        $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface,
        Built<UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1,
            UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder> {
  /// Creates a new UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1 object using the builder pattern.
  factory UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1([
    void Function(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder)? b,
  ]) = _$UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1;

  // coverage:ignore-start
  const UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1.
  static Serializer<UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1> get serializer =>
      _$usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder b) {
    $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder b) {
    $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Interface._validate(b);
  }
}

typedef UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users = ({
  UserDetails? userDetails,
  UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1? usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1
});

@BuiltValue(instantiable: false)
sealed class $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data
    implements
        $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterface,
        Built<UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data,
            UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data([
    void Function(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data.
  static Serializer<UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data> get serializer =>
      _$usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs
    implements
        $UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterface,
        Built<UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs,
            UsersGetDisabledUsersDetailsResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs([
    void Function(UsersGetDisabledUsersDetailsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs.
  static Serializer<UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs> get serializer =>
      _$usersGetDisabledUsersDetailsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetDisabledUsersDetailsResponseApplicationJson_OcsBuilder b) {
    $UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetDisabledUsersDetailsResponseApplicationJson_OcsBuilder b) {
    $UsersGetDisabledUsersDetailsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetDisabledUsersDetailsResponseApplicationJsonInterface {
  UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetDisabledUsersDetailsResponseApplicationJsonInterfaceBuilder].
  $UsersGetDisabledUsersDetailsResponseApplicationJsonInterface rebuild(
    void Function($UsersGetDisabledUsersDetailsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetDisabledUsersDetailsResponseApplicationJsonInterfaceBuilder].
  $UsersGetDisabledUsersDetailsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetDisabledUsersDetailsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetDisabledUsersDetailsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetDisabledUsersDetailsResponseApplicationJson
    implements
        $UsersGetDisabledUsersDetailsResponseApplicationJsonInterface,
        Built<UsersGetDisabledUsersDetailsResponseApplicationJson,
            UsersGetDisabledUsersDetailsResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetDisabledUsersDetailsResponseApplicationJson object using the builder pattern.
  factory UsersGetDisabledUsersDetailsResponseApplicationJson([
    void Function(UsersGetDisabledUsersDetailsResponseApplicationJsonBuilder)? b,
  ]) = _$UsersGetDisabledUsersDetailsResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetDisabledUsersDetailsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetDisabledUsersDetailsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetDisabledUsersDetailsResponseApplicationJson.
  static Serializer<UsersGetDisabledUsersDetailsResponseApplicationJson> get serializer =>
      _$usersGetDisabledUsersDetailsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetDisabledUsersDetailsResponseApplicationJsonBuilder b) {
    $UsersGetDisabledUsersDetailsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetDisabledUsersDetailsResponseApplicationJsonBuilder b) {
    $UsersGetDisabledUsersDetailsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersSearchByPhoneNumbersRequestApplicationJsonInterface {
  /// Location of the phone number (for country code).
  String get location;

  /// Phone numbers to search for.
  BuiltMap<String, BuiltList<String>> get search;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersSearchByPhoneNumbersRequestApplicationJsonInterfaceBuilder].
  $UsersSearchByPhoneNumbersRequestApplicationJsonInterface rebuild(
    void Function($UsersSearchByPhoneNumbersRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersSearchByPhoneNumbersRequestApplicationJsonInterfaceBuilder].
  $UsersSearchByPhoneNumbersRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersSearchByPhoneNumbersRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersSearchByPhoneNumbersRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersSearchByPhoneNumbersRequestApplicationJson
    implements
        $UsersSearchByPhoneNumbersRequestApplicationJsonInterface,
        Built<UsersSearchByPhoneNumbersRequestApplicationJson, UsersSearchByPhoneNumbersRequestApplicationJsonBuilder> {
  /// Creates a new UsersSearchByPhoneNumbersRequestApplicationJson object using the builder pattern.
  factory UsersSearchByPhoneNumbersRequestApplicationJson([
    void Function(UsersSearchByPhoneNumbersRequestApplicationJsonBuilder)? b,
  ]) = _$UsersSearchByPhoneNumbersRequestApplicationJson;

  // coverage:ignore-start
  const UsersSearchByPhoneNumbersRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersSearchByPhoneNumbersRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersSearchByPhoneNumbersRequestApplicationJson.
  static Serializer<UsersSearchByPhoneNumbersRequestApplicationJson> get serializer =>
      _$usersSearchByPhoneNumbersRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersSearchByPhoneNumbersRequestApplicationJsonBuilder b) {
    $UsersSearchByPhoneNumbersRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersSearchByPhoneNumbersRequestApplicationJsonBuilder b) {
    $UsersSearchByPhoneNumbersRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltMap<String, String> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterfaceBuilder].
  $UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterfaceBuilder].
  $UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersSearchByPhoneNumbersResponseApplicationJson_Ocs
    implements
        $UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterface,
        Built<UsersSearchByPhoneNumbersResponseApplicationJson_Ocs,
            UsersSearchByPhoneNumbersResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersSearchByPhoneNumbersResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersSearchByPhoneNumbersResponseApplicationJson_Ocs([
    void Function(UsersSearchByPhoneNumbersResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersSearchByPhoneNumbersResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersSearchByPhoneNumbersResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersSearchByPhoneNumbersResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersSearchByPhoneNumbersResponseApplicationJson_Ocs.
  static Serializer<UsersSearchByPhoneNumbersResponseApplicationJson_Ocs> get serializer =>
      _$usersSearchByPhoneNumbersResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersSearchByPhoneNumbersResponseApplicationJson_OcsBuilder b) {
    $UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersSearchByPhoneNumbersResponseApplicationJson_OcsBuilder b) {
    $UsersSearchByPhoneNumbersResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersSearchByPhoneNumbersResponseApplicationJsonInterface {
  UsersSearchByPhoneNumbersResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersSearchByPhoneNumbersResponseApplicationJsonInterfaceBuilder].
  $UsersSearchByPhoneNumbersResponseApplicationJsonInterface rebuild(
    void Function($UsersSearchByPhoneNumbersResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersSearchByPhoneNumbersResponseApplicationJsonInterfaceBuilder].
  $UsersSearchByPhoneNumbersResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersSearchByPhoneNumbersResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersSearchByPhoneNumbersResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersSearchByPhoneNumbersResponseApplicationJson
    implements
        $UsersSearchByPhoneNumbersResponseApplicationJsonInterface,
        Built<UsersSearchByPhoneNumbersResponseApplicationJson,
            UsersSearchByPhoneNumbersResponseApplicationJsonBuilder> {
  /// Creates a new UsersSearchByPhoneNumbersResponseApplicationJson object using the builder pattern.
  factory UsersSearchByPhoneNumbersResponseApplicationJson([
    void Function(UsersSearchByPhoneNumbersResponseApplicationJsonBuilder)? b,
  ]) = _$UsersSearchByPhoneNumbersResponseApplicationJson;

  // coverage:ignore-start
  const UsersSearchByPhoneNumbersResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersSearchByPhoneNumbersResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersSearchByPhoneNumbersResponseApplicationJson.
  static Serializer<UsersSearchByPhoneNumbersResponseApplicationJson> get serializer =>
      _$usersSearchByPhoneNumbersResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersSearchByPhoneNumbersResponseApplicationJsonBuilder b) {
    $UsersSearchByPhoneNumbersResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersSearchByPhoneNumbersResponseApplicationJsonBuilder b) {
    $UsersSearchByPhoneNumbersResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UserDetails get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUserResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetUserResponseApplicationJson_Ocs
    implements
        $UsersGetUserResponseApplicationJson_OcsInterface,
        Built<UsersGetUserResponseApplicationJson_Ocs, UsersGetUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetUserResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetUserResponseApplicationJson_Ocs([void Function(UsersGetUserResponseApplicationJson_OcsBuilder)? b]) =
      _$UsersGetUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUserResponseApplicationJson_Ocs.
  static Serializer<UsersGetUserResponseApplicationJson_Ocs> get serializer =>
      _$usersGetUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUserResponseApplicationJson_OcsBuilder b) {
    $UsersGetUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUserResponseApplicationJson_OcsBuilder b) {
    $UsersGetUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUserResponseApplicationJsonInterface {
  UsersGetUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUserResponseApplicationJsonInterfaceBuilder].
  $UsersGetUserResponseApplicationJsonInterface rebuild(
    void Function($UsersGetUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUserResponseApplicationJsonInterfaceBuilder].
  $UsersGetUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetUserResponseApplicationJson
    implements
        $UsersGetUserResponseApplicationJsonInterface,
        Built<UsersGetUserResponseApplicationJson, UsersGetUserResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetUserResponseApplicationJson object using the builder pattern.
  factory UsersGetUserResponseApplicationJson([void Function(UsersGetUserResponseApplicationJsonBuilder)? b]) =
      _$UsersGetUserResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUserResponseApplicationJson.
  static Serializer<UsersGetUserResponseApplicationJson> get serializer =>
      _$usersGetUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUserResponseApplicationJsonBuilder b) {
    $UsersGetUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUserResponseApplicationJsonBuilder b) {
    $UsersGetUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersEditUserRequestApplicationJsonInterface {
  /// Key that will be updated.
  String get key;

  /// New value for the key.
  String get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersEditUserRequestApplicationJsonInterfaceBuilder].
  $UsersEditUserRequestApplicationJsonInterface rebuild(
    void Function($UsersEditUserRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersEditUserRequestApplicationJsonInterfaceBuilder].
  $UsersEditUserRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersEditUserRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersEditUserRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersEditUserRequestApplicationJson
    implements
        $UsersEditUserRequestApplicationJsonInterface,
        Built<UsersEditUserRequestApplicationJson, UsersEditUserRequestApplicationJsonBuilder> {
  /// Creates a new UsersEditUserRequestApplicationJson object using the builder pattern.
  factory UsersEditUserRequestApplicationJson([void Function(UsersEditUserRequestApplicationJsonBuilder)? b]) =
      _$UsersEditUserRequestApplicationJson;

  // coverage:ignore-start
  const UsersEditUserRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersEditUserRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersEditUserRequestApplicationJson.
  static Serializer<UsersEditUserRequestApplicationJson> get serializer =>
      _$usersEditUserRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersEditUserRequestApplicationJsonBuilder b) {
    $UsersEditUserRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersEditUserRequestApplicationJsonBuilder b) {
    $UsersEditUserRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersEditUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersEditUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersEditUserResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersEditUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersEditUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersEditUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersEditUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersEditUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersEditUserResponseApplicationJson_Ocs
    implements
        $UsersEditUserResponseApplicationJson_OcsInterface,
        Built<UsersEditUserResponseApplicationJson_Ocs, UsersEditUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersEditUserResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersEditUserResponseApplicationJson_Ocs([
    void Function(UsersEditUserResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersEditUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersEditUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersEditUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersEditUserResponseApplicationJson_Ocs.
  static Serializer<UsersEditUserResponseApplicationJson_Ocs> get serializer =>
      _$usersEditUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersEditUserResponseApplicationJson_OcsBuilder b) {
    $UsersEditUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersEditUserResponseApplicationJson_OcsBuilder b) {
    $UsersEditUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersEditUserResponseApplicationJsonInterface {
  UsersEditUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersEditUserResponseApplicationJsonInterfaceBuilder].
  $UsersEditUserResponseApplicationJsonInterface rebuild(
    void Function($UsersEditUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersEditUserResponseApplicationJsonInterfaceBuilder].
  $UsersEditUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersEditUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersEditUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersEditUserResponseApplicationJson
    implements
        $UsersEditUserResponseApplicationJsonInterface,
        Built<UsersEditUserResponseApplicationJson, UsersEditUserResponseApplicationJsonBuilder> {
  /// Creates a new UsersEditUserResponseApplicationJson object using the builder pattern.
  factory UsersEditUserResponseApplicationJson([void Function(UsersEditUserResponseApplicationJsonBuilder)? b]) =
      _$UsersEditUserResponseApplicationJson;

  // coverage:ignore-start
  const UsersEditUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersEditUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersEditUserResponseApplicationJson.
  static Serializer<UsersEditUserResponseApplicationJson> get serializer =>
      _$usersEditUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersEditUserResponseApplicationJsonBuilder b) {
    $UsersEditUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersEditUserResponseApplicationJsonBuilder b) {
    $UsersEditUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersDeleteUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersDeleteUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersDeleteUserResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersDeleteUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersDeleteUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersDeleteUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersDeleteUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersDeleteUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersDeleteUserResponseApplicationJson_Ocs
    implements
        $UsersDeleteUserResponseApplicationJson_OcsInterface,
        Built<UsersDeleteUserResponseApplicationJson_Ocs, UsersDeleteUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersDeleteUserResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersDeleteUserResponseApplicationJson_Ocs([
    void Function(UsersDeleteUserResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersDeleteUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersDeleteUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersDeleteUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersDeleteUserResponseApplicationJson_Ocs.
  static Serializer<UsersDeleteUserResponseApplicationJson_Ocs> get serializer =>
      _$usersDeleteUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersDeleteUserResponseApplicationJson_OcsBuilder b) {
    $UsersDeleteUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersDeleteUserResponseApplicationJson_OcsBuilder b) {
    $UsersDeleteUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersDeleteUserResponseApplicationJsonInterface {
  UsersDeleteUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersDeleteUserResponseApplicationJsonInterfaceBuilder].
  $UsersDeleteUserResponseApplicationJsonInterface rebuild(
    void Function($UsersDeleteUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersDeleteUserResponseApplicationJsonInterfaceBuilder].
  $UsersDeleteUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersDeleteUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersDeleteUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersDeleteUserResponseApplicationJson
    implements
        $UsersDeleteUserResponseApplicationJsonInterface,
        Built<UsersDeleteUserResponseApplicationJson, UsersDeleteUserResponseApplicationJsonBuilder> {
  /// Creates a new UsersDeleteUserResponseApplicationJson object using the builder pattern.
  factory UsersDeleteUserResponseApplicationJson([void Function(UsersDeleteUserResponseApplicationJsonBuilder)? b]) =
      _$UsersDeleteUserResponseApplicationJson;

  // coverage:ignore-start
  const UsersDeleteUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersDeleteUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersDeleteUserResponseApplicationJson.
  static Serializer<UsersDeleteUserResponseApplicationJson> get serializer =>
      _$usersDeleteUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersDeleteUserResponseApplicationJsonBuilder b) {
    $UsersDeleteUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersDeleteUserResponseApplicationJsonBuilder b) {
    $UsersDeleteUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetCurrentUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UserDetails get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetCurrentUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetCurrentUserResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetCurrentUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetCurrentUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetCurrentUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetCurrentUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetCurrentUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetCurrentUserResponseApplicationJson_Ocs
    implements
        $UsersGetCurrentUserResponseApplicationJson_OcsInterface,
        Built<UsersGetCurrentUserResponseApplicationJson_Ocs, UsersGetCurrentUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetCurrentUserResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetCurrentUserResponseApplicationJson_Ocs([
    void Function(UsersGetCurrentUserResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetCurrentUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetCurrentUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetCurrentUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetCurrentUserResponseApplicationJson_Ocs.
  static Serializer<UsersGetCurrentUserResponseApplicationJson_Ocs> get serializer =>
      _$usersGetCurrentUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetCurrentUserResponseApplicationJson_OcsBuilder b) {
    $UsersGetCurrentUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetCurrentUserResponseApplicationJson_OcsBuilder b) {
    $UsersGetCurrentUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetCurrentUserResponseApplicationJsonInterface {
  UsersGetCurrentUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetCurrentUserResponseApplicationJsonInterfaceBuilder].
  $UsersGetCurrentUserResponseApplicationJsonInterface rebuild(
    void Function($UsersGetCurrentUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetCurrentUserResponseApplicationJsonInterfaceBuilder].
  $UsersGetCurrentUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetCurrentUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetCurrentUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetCurrentUserResponseApplicationJson
    implements
        $UsersGetCurrentUserResponseApplicationJsonInterface,
        Built<UsersGetCurrentUserResponseApplicationJson, UsersGetCurrentUserResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetCurrentUserResponseApplicationJson object using the builder pattern.
  factory UsersGetCurrentUserResponseApplicationJson([
    void Function(UsersGetCurrentUserResponseApplicationJsonBuilder)? b,
  ]) = _$UsersGetCurrentUserResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetCurrentUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetCurrentUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetCurrentUserResponseApplicationJson.
  static Serializer<UsersGetCurrentUserResponseApplicationJson> get serializer =>
      _$usersGetCurrentUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetCurrentUserResponseApplicationJsonBuilder b) {
    $UsersGetCurrentUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetCurrentUserResponseApplicationJsonBuilder b) {
    $UsersGetCurrentUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetEditableFieldsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<String> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetEditableFieldsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetEditableFieldsResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetEditableFieldsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetEditableFieldsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetEditableFieldsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetEditableFieldsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetEditableFieldsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetEditableFieldsResponseApplicationJson_Ocs
    implements
        $UsersGetEditableFieldsResponseApplicationJson_OcsInterface,
        Built<UsersGetEditableFieldsResponseApplicationJson_Ocs,
            UsersGetEditableFieldsResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetEditableFieldsResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetEditableFieldsResponseApplicationJson_Ocs([
    void Function(UsersGetEditableFieldsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetEditableFieldsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetEditableFieldsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetEditableFieldsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetEditableFieldsResponseApplicationJson_Ocs.
  static Serializer<UsersGetEditableFieldsResponseApplicationJson_Ocs> get serializer =>
      _$usersGetEditableFieldsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetEditableFieldsResponseApplicationJson_OcsBuilder b) {
    $UsersGetEditableFieldsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetEditableFieldsResponseApplicationJson_OcsBuilder b) {
    $UsersGetEditableFieldsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetEditableFieldsResponseApplicationJsonInterface {
  UsersGetEditableFieldsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetEditableFieldsResponseApplicationJsonInterfaceBuilder].
  $UsersGetEditableFieldsResponseApplicationJsonInterface rebuild(
    void Function($UsersGetEditableFieldsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetEditableFieldsResponseApplicationJsonInterfaceBuilder].
  $UsersGetEditableFieldsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetEditableFieldsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetEditableFieldsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetEditableFieldsResponseApplicationJson
    implements
        $UsersGetEditableFieldsResponseApplicationJsonInterface,
        Built<UsersGetEditableFieldsResponseApplicationJson, UsersGetEditableFieldsResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetEditableFieldsResponseApplicationJson object using the builder pattern.
  factory UsersGetEditableFieldsResponseApplicationJson([
    void Function(UsersGetEditableFieldsResponseApplicationJsonBuilder)? b,
  ]) = _$UsersGetEditableFieldsResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetEditableFieldsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetEditableFieldsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetEditableFieldsResponseApplicationJson.
  static Serializer<UsersGetEditableFieldsResponseApplicationJson> get serializer =>
      _$usersGetEditableFieldsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetEditableFieldsResponseApplicationJsonBuilder b) {
    $UsersGetEditableFieldsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetEditableFieldsResponseApplicationJsonBuilder b) {
    $UsersGetEditableFieldsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<String> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetEditableFieldsForUserResponseApplicationJson_Ocs
    implements
        $UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterface,
        Built<UsersGetEditableFieldsForUserResponseApplicationJson_Ocs,
            UsersGetEditableFieldsForUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetEditableFieldsForUserResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetEditableFieldsForUserResponseApplicationJson_Ocs([
    void Function(UsersGetEditableFieldsForUserResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetEditableFieldsForUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetEditableFieldsForUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetEditableFieldsForUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetEditableFieldsForUserResponseApplicationJson_Ocs.
  static Serializer<UsersGetEditableFieldsForUserResponseApplicationJson_Ocs> get serializer =>
      _$usersGetEditableFieldsForUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetEditableFieldsForUserResponseApplicationJson_OcsBuilder b) {
    $UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetEditableFieldsForUserResponseApplicationJson_OcsBuilder b) {
    $UsersGetEditableFieldsForUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetEditableFieldsForUserResponseApplicationJsonInterface {
  UsersGetEditableFieldsForUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetEditableFieldsForUserResponseApplicationJsonInterfaceBuilder].
  $UsersGetEditableFieldsForUserResponseApplicationJsonInterface rebuild(
    void Function($UsersGetEditableFieldsForUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetEditableFieldsForUserResponseApplicationJsonInterfaceBuilder].
  $UsersGetEditableFieldsForUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetEditableFieldsForUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetEditableFieldsForUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetEditableFieldsForUserResponseApplicationJson
    implements
        $UsersGetEditableFieldsForUserResponseApplicationJsonInterface,
        Built<UsersGetEditableFieldsForUserResponseApplicationJson,
            UsersGetEditableFieldsForUserResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetEditableFieldsForUserResponseApplicationJson object using the builder pattern.
  factory UsersGetEditableFieldsForUserResponseApplicationJson([
    void Function(UsersGetEditableFieldsForUserResponseApplicationJsonBuilder)? b,
  ]) = _$UsersGetEditableFieldsForUserResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetEditableFieldsForUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetEditableFieldsForUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetEditableFieldsForUserResponseApplicationJson.
  static Serializer<UsersGetEditableFieldsForUserResponseApplicationJson> get serializer =>
      _$usersGetEditableFieldsForUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetEditableFieldsForUserResponseApplicationJsonBuilder b) {
    $UsersGetEditableFieldsForUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetEditableFieldsForUserResponseApplicationJsonBuilder b) {
    $UsersGetEditableFieldsForUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersEditUserMultiValueRequestApplicationJsonInterface {
  /// Key that will be updated.
  String get key;

  /// New value for the key.
  String get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersEditUserMultiValueRequestApplicationJsonInterfaceBuilder].
  $UsersEditUserMultiValueRequestApplicationJsonInterface rebuild(
    void Function($UsersEditUserMultiValueRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersEditUserMultiValueRequestApplicationJsonInterfaceBuilder].
  $UsersEditUserMultiValueRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersEditUserMultiValueRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersEditUserMultiValueRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersEditUserMultiValueRequestApplicationJson
    implements
        $UsersEditUserMultiValueRequestApplicationJsonInterface,
        Built<UsersEditUserMultiValueRequestApplicationJson, UsersEditUserMultiValueRequestApplicationJsonBuilder> {
  /// Creates a new UsersEditUserMultiValueRequestApplicationJson object using the builder pattern.
  factory UsersEditUserMultiValueRequestApplicationJson([
    void Function(UsersEditUserMultiValueRequestApplicationJsonBuilder)? b,
  ]) = _$UsersEditUserMultiValueRequestApplicationJson;

  // coverage:ignore-start
  const UsersEditUserMultiValueRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersEditUserMultiValueRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersEditUserMultiValueRequestApplicationJson.
  static Serializer<UsersEditUserMultiValueRequestApplicationJson> get serializer =>
      _$usersEditUserMultiValueRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersEditUserMultiValueRequestApplicationJsonBuilder b) {
    $UsersEditUserMultiValueRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersEditUserMultiValueRequestApplicationJsonBuilder b) {
    $UsersEditUserMultiValueRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersEditUserMultiValueResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersEditUserMultiValueResponseApplicationJson_OcsInterfaceBuilder].
  $UsersEditUserMultiValueResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersEditUserMultiValueResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersEditUserMultiValueResponseApplicationJson_OcsInterfaceBuilder].
  $UsersEditUserMultiValueResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersEditUserMultiValueResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersEditUserMultiValueResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersEditUserMultiValueResponseApplicationJson_Ocs
    implements
        $UsersEditUserMultiValueResponseApplicationJson_OcsInterface,
        Built<UsersEditUserMultiValueResponseApplicationJson_Ocs,
            UsersEditUserMultiValueResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersEditUserMultiValueResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersEditUserMultiValueResponseApplicationJson_Ocs([
    void Function(UsersEditUserMultiValueResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersEditUserMultiValueResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersEditUserMultiValueResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersEditUserMultiValueResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersEditUserMultiValueResponseApplicationJson_Ocs.
  static Serializer<UsersEditUserMultiValueResponseApplicationJson_Ocs> get serializer =>
      _$usersEditUserMultiValueResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersEditUserMultiValueResponseApplicationJson_OcsBuilder b) {
    $UsersEditUserMultiValueResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersEditUserMultiValueResponseApplicationJson_OcsBuilder b) {
    $UsersEditUserMultiValueResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersEditUserMultiValueResponseApplicationJsonInterface {
  UsersEditUserMultiValueResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersEditUserMultiValueResponseApplicationJsonInterfaceBuilder].
  $UsersEditUserMultiValueResponseApplicationJsonInterface rebuild(
    void Function($UsersEditUserMultiValueResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersEditUserMultiValueResponseApplicationJsonInterfaceBuilder].
  $UsersEditUserMultiValueResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersEditUserMultiValueResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersEditUserMultiValueResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersEditUserMultiValueResponseApplicationJson
    implements
        $UsersEditUserMultiValueResponseApplicationJsonInterface,
        Built<UsersEditUserMultiValueResponseApplicationJson, UsersEditUserMultiValueResponseApplicationJsonBuilder> {
  /// Creates a new UsersEditUserMultiValueResponseApplicationJson object using the builder pattern.
  factory UsersEditUserMultiValueResponseApplicationJson([
    void Function(UsersEditUserMultiValueResponseApplicationJsonBuilder)? b,
  ]) = _$UsersEditUserMultiValueResponseApplicationJson;

  // coverage:ignore-start
  const UsersEditUserMultiValueResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersEditUserMultiValueResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersEditUserMultiValueResponseApplicationJson.
  static Serializer<UsersEditUserMultiValueResponseApplicationJson> get serializer =>
      _$usersEditUserMultiValueResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersEditUserMultiValueResponseApplicationJsonBuilder b) {
    $UsersEditUserMultiValueResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersEditUserMultiValueResponseApplicationJsonBuilder b) {
    $UsersEditUserMultiValueResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersWipeUserDevicesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersWipeUserDevicesResponseApplicationJson_OcsInterfaceBuilder].
  $UsersWipeUserDevicesResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersWipeUserDevicesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersWipeUserDevicesResponseApplicationJson_OcsInterfaceBuilder].
  $UsersWipeUserDevicesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersWipeUserDevicesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersWipeUserDevicesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersWipeUserDevicesResponseApplicationJson_Ocs
    implements
        $UsersWipeUserDevicesResponseApplicationJson_OcsInterface,
        Built<UsersWipeUserDevicesResponseApplicationJson_Ocs, UsersWipeUserDevicesResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersWipeUserDevicesResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersWipeUserDevicesResponseApplicationJson_Ocs([
    void Function(UsersWipeUserDevicesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersWipeUserDevicesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersWipeUserDevicesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersWipeUserDevicesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersWipeUserDevicesResponseApplicationJson_Ocs.
  static Serializer<UsersWipeUserDevicesResponseApplicationJson_Ocs> get serializer =>
      _$usersWipeUserDevicesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersWipeUserDevicesResponseApplicationJson_OcsBuilder b) {
    $UsersWipeUserDevicesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersWipeUserDevicesResponseApplicationJson_OcsBuilder b) {
    $UsersWipeUserDevicesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersWipeUserDevicesResponseApplicationJsonInterface {
  UsersWipeUserDevicesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersWipeUserDevicesResponseApplicationJsonInterfaceBuilder].
  $UsersWipeUserDevicesResponseApplicationJsonInterface rebuild(
    void Function($UsersWipeUserDevicesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersWipeUserDevicesResponseApplicationJsonInterfaceBuilder].
  $UsersWipeUserDevicesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersWipeUserDevicesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersWipeUserDevicesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersWipeUserDevicesResponseApplicationJson
    implements
        $UsersWipeUserDevicesResponseApplicationJsonInterface,
        Built<UsersWipeUserDevicesResponseApplicationJson, UsersWipeUserDevicesResponseApplicationJsonBuilder> {
  /// Creates a new UsersWipeUserDevicesResponseApplicationJson object using the builder pattern.
  factory UsersWipeUserDevicesResponseApplicationJson([
    void Function(UsersWipeUserDevicesResponseApplicationJsonBuilder)? b,
  ]) = _$UsersWipeUserDevicesResponseApplicationJson;

  // coverage:ignore-start
  const UsersWipeUserDevicesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersWipeUserDevicesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersWipeUserDevicesResponseApplicationJson.
  static Serializer<UsersWipeUserDevicesResponseApplicationJson> get serializer =>
      _$usersWipeUserDevicesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersWipeUserDevicesResponseApplicationJsonBuilder b) {
    $UsersWipeUserDevicesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersWipeUserDevicesResponseApplicationJsonBuilder b) {
    $UsersWipeUserDevicesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersEnableUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersEnableUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersEnableUserResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersEnableUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersEnableUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersEnableUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersEnableUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersEnableUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersEnableUserResponseApplicationJson_Ocs
    implements
        $UsersEnableUserResponseApplicationJson_OcsInterface,
        Built<UsersEnableUserResponseApplicationJson_Ocs, UsersEnableUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersEnableUserResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersEnableUserResponseApplicationJson_Ocs([
    void Function(UsersEnableUserResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersEnableUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersEnableUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersEnableUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersEnableUserResponseApplicationJson_Ocs.
  static Serializer<UsersEnableUserResponseApplicationJson_Ocs> get serializer =>
      _$usersEnableUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersEnableUserResponseApplicationJson_OcsBuilder b) {
    $UsersEnableUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersEnableUserResponseApplicationJson_OcsBuilder b) {
    $UsersEnableUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersEnableUserResponseApplicationJsonInterface {
  UsersEnableUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersEnableUserResponseApplicationJsonInterfaceBuilder].
  $UsersEnableUserResponseApplicationJsonInterface rebuild(
    void Function($UsersEnableUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersEnableUserResponseApplicationJsonInterfaceBuilder].
  $UsersEnableUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersEnableUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersEnableUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersEnableUserResponseApplicationJson
    implements
        $UsersEnableUserResponseApplicationJsonInterface,
        Built<UsersEnableUserResponseApplicationJson, UsersEnableUserResponseApplicationJsonBuilder> {
  /// Creates a new UsersEnableUserResponseApplicationJson object using the builder pattern.
  factory UsersEnableUserResponseApplicationJson([void Function(UsersEnableUserResponseApplicationJsonBuilder)? b]) =
      _$UsersEnableUserResponseApplicationJson;

  // coverage:ignore-start
  const UsersEnableUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersEnableUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersEnableUserResponseApplicationJson.
  static Serializer<UsersEnableUserResponseApplicationJson> get serializer =>
      _$usersEnableUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersEnableUserResponseApplicationJsonBuilder b) {
    $UsersEnableUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersEnableUserResponseApplicationJsonBuilder b) {
    $UsersEnableUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersDisableUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersDisableUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersDisableUserResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersDisableUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersDisableUserResponseApplicationJson_OcsInterfaceBuilder].
  $UsersDisableUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersDisableUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersDisableUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersDisableUserResponseApplicationJson_Ocs
    implements
        $UsersDisableUserResponseApplicationJson_OcsInterface,
        Built<UsersDisableUserResponseApplicationJson_Ocs, UsersDisableUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersDisableUserResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersDisableUserResponseApplicationJson_Ocs([
    void Function(UsersDisableUserResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersDisableUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersDisableUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersDisableUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersDisableUserResponseApplicationJson_Ocs.
  static Serializer<UsersDisableUserResponseApplicationJson_Ocs> get serializer =>
      _$usersDisableUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersDisableUserResponseApplicationJson_OcsBuilder b) {
    $UsersDisableUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersDisableUserResponseApplicationJson_OcsBuilder b) {
    $UsersDisableUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersDisableUserResponseApplicationJsonInterface {
  UsersDisableUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersDisableUserResponseApplicationJsonInterfaceBuilder].
  $UsersDisableUserResponseApplicationJsonInterface rebuild(
    void Function($UsersDisableUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersDisableUserResponseApplicationJsonInterfaceBuilder].
  $UsersDisableUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersDisableUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersDisableUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersDisableUserResponseApplicationJson
    implements
        $UsersDisableUserResponseApplicationJsonInterface,
        Built<UsersDisableUserResponseApplicationJson, UsersDisableUserResponseApplicationJsonBuilder> {
  /// Creates a new UsersDisableUserResponseApplicationJson object using the builder pattern.
  factory UsersDisableUserResponseApplicationJson([void Function(UsersDisableUserResponseApplicationJsonBuilder)? b]) =
      _$UsersDisableUserResponseApplicationJson;

  // coverage:ignore-start
  const UsersDisableUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersDisableUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersDisableUserResponseApplicationJson.
  static Serializer<UsersDisableUserResponseApplicationJson> get serializer =>
      _$usersDisableUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersDisableUserResponseApplicationJsonBuilder b) {
    $UsersDisableUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersDisableUserResponseApplicationJsonBuilder b) {
    $UsersDisableUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterface {
  BuiltList<String> get groups;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class UsersGetUsersGroupsResponseApplicationJson_Ocs_Data
    implements
        $UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterface,
        Built<UsersGetUsersGroupsResponseApplicationJson_Ocs_Data,
            UsersGetUsersGroupsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new UsersGetUsersGroupsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory UsersGetUsersGroupsResponseApplicationJson_Ocs_Data([
    void Function(UsersGetUsersGroupsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$UsersGetUsersGroupsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const UsersGetUsersGroupsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersGroupsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersGroupsResponseApplicationJson_Ocs_Data.
  static Serializer<UsersGetUsersGroupsResponseApplicationJson_Ocs_Data> get serializer =>
      _$usersGetUsersGroupsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersGroupsResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersGroupsResponseApplicationJson_Ocs_DataBuilder b) {
    $UsersGetUsersGroupsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersGroupsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UsersGetUsersGroupsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersGroupsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUsersGroupsResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersGetUsersGroupsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersGroupsResponseApplicationJson_OcsInterfaceBuilder].
  $UsersGetUsersGroupsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersGroupsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersGroupsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersGetUsersGroupsResponseApplicationJson_Ocs
    implements
        $UsersGetUsersGroupsResponseApplicationJson_OcsInterface,
        Built<UsersGetUsersGroupsResponseApplicationJson_Ocs, UsersGetUsersGroupsResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersGetUsersGroupsResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersGetUsersGroupsResponseApplicationJson_Ocs([
    void Function(UsersGetUsersGroupsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersGetUsersGroupsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersGetUsersGroupsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersGroupsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersGroupsResponseApplicationJson_Ocs.
  static Serializer<UsersGetUsersGroupsResponseApplicationJson_Ocs> get serializer =>
      _$usersGetUsersGroupsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersGroupsResponseApplicationJson_OcsBuilder b) {
    $UsersGetUsersGroupsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersGroupsResponseApplicationJson_OcsBuilder b) {
    $UsersGetUsersGroupsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersGetUsersGroupsResponseApplicationJsonInterface {
  UsersGetUsersGroupsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersGetUsersGroupsResponseApplicationJsonInterfaceBuilder].
  $UsersGetUsersGroupsResponseApplicationJsonInterface rebuild(
    void Function($UsersGetUsersGroupsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersGetUsersGroupsResponseApplicationJsonInterfaceBuilder].
  $UsersGetUsersGroupsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersGetUsersGroupsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersGetUsersGroupsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersGetUsersGroupsResponseApplicationJson
    implements
        $UsersGetUsersGroupsResponseApplicationJsonInterface,
        Built<UsersGetUsersGroupsResponseApplicationJson, UsersGetUsersGroupsResponseApplicationJsonBuilder> {
  /// Creates a new UsersGetUsersGroupsResponseApplicationJson object using the builder pattern.
  factory UsersGetUsersGroupsResponseApplicationJson([
    void Function(UsersGetUsersGroupsResponseApplicationJsonBuilder)? b,
  ]) = _$UsersGetUsersGroupsResponseApplicationJson;

  // coverage:ignore-start
  const UsersGetUsersGroupsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersGetUsersGroupsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersGetUsersGroupsResponseApplicationJson.
  static Serializer<UsersGetUsersGroupsResponseApplicationJson> get serializer =>
      _$usersGetUsersGroupsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersGetUsersGroupsResponseApplicationJsonBuilder b) {
    $UsersGetUsersGroupsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersGetUsersGroupsResponseApplicationJsonBuilder b) {
    $UsersGetUsersGroupsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddToGroupRequestApplicationJsonInterface {
  static final _$groupid = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// ID of the group.
  String get groupid;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddToGroupRequestApplicationJsonInterfaceBuilder].
  $UsersAddToGroupRequestApplicationJsonInterface rebuild(
    void Function($UsersAddToGroupRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddToGroupRequestApplicationJsonInterfaceBuilder].
  $UsersAddToGroupRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddToGroupRequestApplicationJsonInterfaceBuilder b) {
    b.groupid = _$groupid;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddToGroupRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersAddToGroupRequestApplicationJson
    implements
        $UsersAddToGroupRequestApplicationJsonInterface,
        Built<UsersAddToGroupRequestApplicationJson, UsersAddToGroupRequestApplicationJsonBuilder> {
  /// Creates a new UsersAddToGroupRequestApplicationJson object using the builder pattern.
  factory UsersAddToGroupRequestApplicationJson([void Function(UsersAddToGroupRequestApplicationJsonBuilder)? b]) =
      _$UsersAddToGroupRequestApplicationJson;

  // coverage:ignore-start
  const UsersAddToGroupRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddToGroupRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddToGroupRequestApplicationJson.
  static Serializer<UsersAddToGroupRequestApplicationJson> get serializer =>
      _$usersAddToGroupRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddToGroupRequestApplicationJsonBuilder b) {
    $UsersAddToGroupRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddToGroupRequestApplicationJsonBuilder b) {
    $UsersAddToGroupRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddToGroupResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddToGroupResponseApplicationJson_OcsInterfaceBuilder].
  $UsersAddToGroupResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersAddToGroupResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddToGroupResponseApplicationJson_OcsInterfaceBuilder].
  $UsersAddToGroupResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddToGroupResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddToGroupResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersAddToGroupResponseApplicationJson_Ocs
    implements
        $UsersAddToGroupResponseApplicationJson_OcsInterface,
        Built<UsersAddToGroupResponseApplicationJson_Ocs, UsersAddToGroupResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersAddToGroupResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersAddToGroupResponseApplicationJson_Ocs([
    void Function(UsersAddToGroupResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersAddToGroupResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersAddToGroupResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddToGroupResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddToGroupResponseApplicationJson_Ocs.
  static Serializer<UsersAddToGroupResponseApplicationJson_Ocs> get serializer =>
      _$usersAddToGroupResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddToGroupResponseApplicationJson_OcsBuilder b) {
    $UsersAddToGroupResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddToGroupResponseApplicationJson_OcsBuilder b) {
    $UsersAddToGroupResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersAddToGroupResponseApplicationJsonInterface {
  UsersAddToGroupResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersAddToGroupResponseApplicationJsonInterfaceBuilder].
  $UsersAddToGroupResponseApplicationJsonInterface rebuild(
    void Function($UsersAddToGroupResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersAddToGroupResponseApplicationJsonInterfaceBuilder].
  $UsersAddToGroupResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersAddToGroupResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersAddToGroupResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersAddToGroupResponseApplicationJson
    implements
        $UsersAddToGroupResponseApplicationJsonInterface,
        Built<UsersAddToGroupResponseApplicationJson, UsersAddToGroupResponseApplicationJsonBuilder> {
  /// Creates a new UsersAddToGroupResponseApplicationJson object using the builder pattern.
  factory UsersAddToGroupResponseApplicationJson([void Function(UsersAddToGroupResponseApplicationJsonBuilder)? b]) =
      _$UsersAddToGroupResponseApplicationJson;

  // coverage:ignore-start
  const UsersAddToGroupResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersAddToGroupResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersAddToGroupResponseApplicationJson.
  static Serializer<UsersAddToGroupResponseApplicationJson> get serializer =>
      _$usersAddToGroupResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersAddToGroupResponseApplicationJsonBuilder b) {
    $UsersAddToGroupResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersAddToGroupResponseApplicationJsonBuilder b) {
    $UsersAddToGroupResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersRemoveFromGroupResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersRemoveFromGroupResponseApplicationJson_OcsInterfaceBuilder].
  $UsersRemoveFromGroupResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersRemoveFromGroupResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersRemoveFromGroupResponseApplicationJson_OcsInterfaceBuilder].
  $UsersRemoveFromGroupResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersRemoveFromGroupResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersRemoveFromGroupResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersRemoveFromGroupResponseApplicationJson_Ocs
    implements
        $UsersRemoveFromGroupResponseApplicationJson_OcsInterface,
        Built<UsersRemoveFromGroupResponseApplicationJson_Ocs, UsersRemoveFromGroupResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersRemoveFromGroupResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersRemoveFromGroupResponseApplicationJson_Ocs([
    void Function(UsersRemoveFromGroupResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersRemoveFromGroupResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersRemoveFromGroupResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersRemoveFromGroupResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersRemoveFromGroupResponseApplicationJson_Ocs.
  static Serializer<UsersRemoveFromGroupResponseApplicationJson_Ocs> get serializer =>
      _$usersRemoveFromGroupResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersRemoveFromGroupResponseApplicationJson_OcsBuilder b) {
    $UsersRemoveFromGroupResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersRemoveFromGroupResponseApplicationJson_OcsBuilder b) {
    $UsersRemoveFromGroupResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersRemoveFromGroupResponseApplicationJsonInterface {
  UsersRemoveFromGroupResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersRemoveFromGroupResponseApplicationJsonInterfaceBuilder].
  $UsersRemoveFromGroupResponseApplicationJsonInterface rebuild(
    void Function($UsersRemoveFromGroupResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersRemoveFromGroupResponseApplicationJsonInterfaceBuilder].
  $UsersRemoveFromGroupResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersRemoveFromGroupResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersRemoveFromGroupResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersRemoveFromGroupResponseApplicationJson
    implements
        $UsersRemoveFromGroupResponseApplicationJsonInterface,
        Built<UsersRemoveFromGroupResponseApplicationJson, UsersRemoveFromGroupResponseApplicationJsonBuilder> {
  /// Creates a new UsersRemoveFromGroupResponseApplicationJson object using the builder pattern.
  factory UsersRemoveFromGroupResponseApplicationJson([
    void Function(UsersRemoveFromGroupResponseApplicationJsonBuilder)? b,
  ]) = _$UsersRemoveFromGroupResponseApplicationJson;

  // coverage:ignore-start
  const UsersRemoveFromGroupResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersRemoveFromGroupResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersRemoveFromGroupResponseApplicationJson.
  static Serializer<UsersRemoveFromGroupResponseApplicationJson> get serializer =>
      _$usersRemoveFromGroupResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersRemoveFromGroupResponseApplicationJsonBuilder b) {
    $UsersRemoveFromGroupResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersRemoveFromGroupResponseApplicationJsonBuilder b) {
    $UsersRemoveFromGroupResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersResendWelcomeMessageResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersResendWelcomeMessageResponseApplicationJson_OcsInterfaceBuilder].
  $UsersResendWelcomeMessageResponseApplicationJson_OcsInterface rebuild(
    void Function($UsersResendWelcomeMessageResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersResendWelcomeMessageResponseApplicationJson_OcsInterfaceBuilder].
  $UsersResendWelcomeMessageResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersResendWelcomeMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersResendWelcomeMessageResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UsersResendWelcomeMessageResponseApplicationJson_Ocs
    implements
        $UsersResendWelcomeMessageResponseApplicationJson_OcsInterface,
        Built<UsersResendWelcomeMessageResponseApplicationJson_Ocs,
            UsersResendWelcomeMessageResponseApplicationJson_OcsBuilder> {
  /// Creates a new UsersResendWelcomeMessageResponseApplicationJson_Ocs object using the builder pattern.
  factory UsersResendWelcomeMessageResponseApplicationJson_Ocs([
    void Function(UsersResendWelcomeMessageResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UsersResendWelcomeMessageResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UsersResendWelcomeMessageResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersResendWelcomeMessageResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersResendWelcomeMessageResponseApplicationJson_Ocs.
  static Serializer<UsersResendWelcomeMessageResponseApplicationJson_Ocs> get serializer =>
      _$usersResendWelcomeMessageResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersResendWelcomeMessageResponseApplicationJson_OcsBuilder b) {
    $UsersResendWelcomeMessageResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersResendWelcomeMessageResponseApplicationJson_OcsBuilder b) {
    $UsersResendWelcomeMessageResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UsersResendWelcomeMessageResponseApplicationJsonInterface {
  UsersResendWelcomeMessageResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UsersResendWelcomeMessageResponseApplicationJsonInterfaceBuilder].
  $UsersResendWelcomeMessageResponseApplicationJsonInterface rebuild(
    void Function($UsersResendWelcomeMessageResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UsersResendWelcomeMessageResponseApplicationJsonInterfaceBuilder].
  $UsersResendWelcomeMessageResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UsersResendWelcomeMessageResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UsersResendWelcomeMessageResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UsersResendWelcomeMessageResponseApplicationJson
    implements
        $UsersResendWelcomeMessageResponseApplicationJsonInterface,
        Built<UsersResendWelcomeMessageResponseApplicationJson,
            UsersResendWelcomeMessageResponseApplicationJsonBuilder> {
  /// Creates a new UsersResendWelcomeMessageResponseApplicationJson object using the builder pattern.
  factory UsersResendWelcomeMessageResponseApplicationJson([
    void Function(UsersResendWelcomeMessageResponseApplicationJsonBuilder)? b,
  ]) = _$UsersResendWelcomeMessageResponseApplicationJson;

  // coverage:ignore-start
  const UsersResendWelcomeMessageResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UsersResendWelcomeMessageResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UsersResendWelcomeMessageResponseApplicationJson.
  static Serializer<UsersResendWelcomeMessageResponseApplicationJson> get serializer =>
      _$usersResendWelcomeMessageResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UsersResendWelcomeMessageResponseApplicationJsonBuilder b) {
    $UsersResendWelcomeMessageResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UsersResendWelcomeMessageResponseApplicationJsonBuilder b) {
    $UsersResendWelcomeMessageResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_ProvisioningApiInterface {
  String get version;
  @BuiltValueField(wireName: 'AccountPropertyScopesVersion')
  int get accountPropertyScopesVersion;
  @BuiltValueField(wireName: 'AccountPropertyScopesFederatedEnabled')
  bool get accountPropertyScopesFederatedEnabled;
  @BuiltValueField(wireName: 'AccountPropertyScopesPublishedEnabled')
  bool get accountPropertyScopesPublishedEnabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_ProvisioningApiInterfaceBuilder].
  $Capabilities_ProvisioningApiInterface rebuild(void Function($Capabilities_ProvisioningApiInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Capabilities_ProvisioningApiInterfaceBuilder].
  $Capabilities_ProvisioningApiInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_ProvisioningApiInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_ProvisioningApiInterfaceBuilder b) {}
}

abstract class Capabilities_ProvisioningApi
    implements
        $Capabilities_ProvisioningApiInterface,
        Built<Capabilities_ProvisioningApi, Capabilities_ProvisioningApiBuilder> {
  /// Creates a new Capabilities_ProvisioningApi object using the builder pattern.
  factory Capabilities_ProvisioningApi([void Function(Capabilities_ProvisioningApiBuilder)? b]) =
      _$Capabilities_ProvisioningApi;

  // coverage:ignore-start
  const Capabilities_ProvisioningApi._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_ProvisioningApi.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_ProvisioningApi.
  static Serializer<Capabilities_ProvisioningApi> get serializer => _$capabilitiesProvisioningApiSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_ProvisioningApiBuilder b) {
    $Capabilities_ProvisioningApiInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_ProvisioningApiBuilder b) {
    $Capabilities_ProvisioningApiInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CapabilitiesInterface {
  @BuiltValueField(wireName: 'provisioning_api')
  Capabilities_ProvisioningApi get provisioningApi;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterface rebuild(void Function($CapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CapabilitiesInterfaceBuilder b) {}
}

abstract class Capabilities implements $CapabilitiesInterface, Built<Capabilities, CapabilitiesBuilder> {
  /// Creates a new Capabilities object using the builder pattern.
  factory Capabilities([void Function(CapabilitiesBuilder)? b]) = _$Capabilities;

  // coverage:ignore-start
  const Capabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities.
  static Serializer<Capabilities> get serializer => _$capabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CapabilitiesBuilder b) {
    $CapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CapabilitiesBuilder b) {
    $CapabilitiesInterface._validate(b);
  }
}

/// Serialization extension for `GroupDetails_Usercount`.
extension $GroupDetails_UsercountExtension on GroupDetails_Usercount {
  /// Serializer for GroupDetails_Usercount.
  @BuiltValueSerializer(custom: true)
  static Serializer<GroupDetails_Usercount> get serializer => $c4bc4131e74e61dae681408e87e2e2bdExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static GroupDetails_Usercount fromJson(Object? json) => $c4bc4131e74e61dae681408e87e2e2bdExtension._fromJson(json);
}

/// Serialization extension for `GroupDetails_Disabled`.
extension $GroupDetails_DisabledExtension on GroupDetails_Disabled {
  /// Serializer for GroupDetails_Disabled.
  @BuiltValueSerializer(custom: true)
  static Serializer<GroupDetails_Disabled> get serializer => $c4bc4131e74e61dae681408e87e2e2bdExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static GroupDetails_Disabled fromJson(Object? json) => $c4bc4131e74e61dae681408e87e2e2bdExtension._fromJson(json);
}

/// Serialization extension for `UserDetailsQuota_Quota`.
extension $UserDetailsQuota_QuotaExtension on UserDetailsQuota_Quota {
  /// Serializer for UserDetailsQuota_Quota.
  @BuiltValueSerializer(custom: true)
  static Serializer<UserDetailsQuota_Quota> get serializer => $b6d67dc2a96424d2f407f8e51557f3deExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static UserDetailsQuota_Quota fromJson(Object? json) => $b6d67dc2a96424d2f407f8e51557f3deExtension._fromJson(json);
}

/// Serialization extension for `GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users`.
extension $GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_UsersExtension
    on GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users {
  /// Serializer for GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users.
  @BuiltValueSerializer(custom: true)
  static Serializer<GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users> get serializer =>
      $b20d370ea28764b414e70ac5df151f1bExtension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users fromJson(Object? json) =>
      $b20d370ea28764b414e70ac5df151f1bExtension._fromJson(json);
}

/// Serialization extension for `UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users`.
extension $UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_UsersExtension
    on UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users {
  /// Serializer for UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users.
  @BuiltValueSerializer(custom: true)
  static Serializer<UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users> get serializer =>
      $23fff76a4c828b7eda989f1236fdc6a4Extension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users fromJson(Object? json) =>
      $23fff76a4c828b7eda989f1236fdc6a4Extension._fromJson(json);
}

/// Serialization extension for `UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users`.
extension $UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_UsersExtension
    on UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users {
  /// Serializer for UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users.
  @BuiltValueSerializer(custom: true)
  static Serializer<UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users> get serializer =>
      $1e1cd5e43e0a1022a23a294e58225d74Extension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users fromJson(Object? json) =>
      $1e1cd5e43e0a1022a23a294e58225d74Extension._fromJson(json);
}

/// Serialization extension for `UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users`.
extension $UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_UsersExtension
    on UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users {
  /// Serializer for UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users.
  @BuiltValueSerializer(custom: true)
  static Serializer<UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users> get serializer =>
      $f9d75e948689049b3f3e23e024d4be73Extension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users fromJson(Object? json) =>
      $f9d75e948689049b3f3e23e024d4be73Extension._fromJson(json);
}

typedef _$c4bc4131e74e61dae681408e87e2e2bd = ({bool? $bool, int? $int});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $c4bc4131e74e61dae681408e87e2e2bdExtension on _$c4bc4131e74e61dae681408e87e2e2bd {
  List<dynamic> get _values => [$bool, $int];
  List<String> get _names => const [r'$bool', r'$int'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$c4bc4131e74e61dae681408e87e2e2bd> get _serializer =>
      const _$c4bc4131e74e61dae681408e87e2e2bdSerializer();
  static _$c4bc4131e74e61dae681408e87e2e2bd _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$c4bc4131e74e61dae681408e87e2e2bdSerializer implements PrimitiveSerializer<_$c4bc4131e74e61dae681408e87e2e2bd> {
  const _$c4bc4131e74e61dae681408e87e2e2bdSerializer();

  @override
  Iterable<Type> get types => const [_$c4bc4131e74e61dae681408e87e2e2bd];

  @override
  String get wireName => r'_$c4bc4131e74e61dae681408e87e2e2bd';

  @override
  Object serialize(
    Serializers serializers,
    _$c4bc4131e74e61dae681408e87e2e2bd object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.$bool;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(bool))!;
    }
    value = object.$int;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(int))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$c4bc4131e74e61dae681408e87e2e2bd deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    bool? $bool;
    try {
      $bool = serializers.deserialize(
        data,
        specifiedType: const FullType(bool),
      )! as bool;
    } catch (_) {}
    int? $int;
    try {
      $int = serializers.deserialize(
        data,
        specifiedType: const FullType(int),
      )! as int;
    } catch (_) {}
    return ($bool: $bool, $int: $int);
  }
}

typedef _$b6d67dc2a96424d2f407f8e51557f3de = ({num? $num, String? string});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $b6d67dc2a96424d2f407f8e51557f3deExtension on _$b6d67dc2a96424d2f407f8e51557f3de {
  List<dynamic> get _values => [$num, string];
  List<String> get _names => const [r'$num', 'string'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$b6d67dc2a96424d2f407f8e51557f3de> get _serializer =>
      const _$b6d67dc2a96424d2f407f8e51557f3deSerializer();
  static _$b6d67dc2a96424d2f407f8e51557f3de _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$b6d67dc2a96424d2f407f8e51557f3deSerializer implements PrimitiveSerializer<_$b6d67dc2a96424d2f407f8e51557f3de> {
  const _$b6d67dc2a96424d2f407f8e51557f3deSerializer();

  @override
  Iterable<Type> get types => const [_$b6d67dc2a96424d2f407f8e51557f3de];

  @override
  String get wireName => r'_$b6d67dc2a96424d2f407f8e51557f3de';

  @override
  Object serialize(
    Serializers serializers,
    _$b6d67dc2a96424d2f407f8e51557f3de object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.$num;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(num))!;
    }
    value = object.string;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(String))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$b6d67dc2a96424d2f407f8e51557f3de deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    num? $num;
    try {
      $num = serializers.deserialize(
        data,
        specifiedType: const FullType(num),
      )! as num;
    } catch (_) {}
    String? string;
    try {
      string = serializers.deserialize(
        data,
        specifiedType: const FullType(String),
      )! as String;
    } catch (_) {}
    return ($num: $num, string: string);
  }
}

typedef _$b20d370ea28764b414e70ac5df151f1b = ({
  GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1? groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1,
  UserDetails? userDetails
});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $b20d370ea28764b414e70ac5df151f1bExtension on _$b20d370ea28764b414e70ac5df151f1b {
  List<dynamic> get _values => [groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1, userDetails];
  List<String> get _names => const ['groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1', 'userDetails'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$b20d370ea28764b414e70ac5df151f1b> get _serializer =>
      const _$b20d370ea28764b414e70ac5df151f1bSerializer();
  static _$b20d370ea28764b414e70ac5df151f1b _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$b20d370ea28764b414e70ac5df151f1bSerializer implements PrimitiveSerializer<_$b20d370ea28764b414e70ac5df151f1b> {
  const _$b20d370ea28764b414e70ac5df151f1bSerializer();

  @override
  Iterable<Type> get types => const [_$b20d370ea28764b414e70ac5df151f1b];

  @override
  String get wireName => r'_$b20d370ea28764b414e70ac5df151f1b';

  @override
  Object serialize(
    Serializers serializers,
    _$b20d370ea28764b414e70ac5df151f1b object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1;
    if (value != null) {
      return serializers.serialize(
        value,
        specifiedType: const FullType(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
      )!;
    }
    value = object.userDetails;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(UserDetails))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$b20d370ea28764b414e70ac5df151f1b deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1?
        groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1;
    try {
      groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1 = serializers.deserialize(
        data,
        specifiedType: const FullType(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
      )! as GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1;
    } catch (_) {}
    UserDetails? userDetails;
    try {
      userDetails = serializers.deserialize(
        data,
        specifiedType: const FullType(UserDetails),
      )! as UserDetails;
    } catch (_) {}
    return (
      groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1:
          groupsGetGroupUsersDetailsResponseApplicationJsonOcsDataUsers1,
      userDetails: userDetails
    );
  }
}

typedef _$23fff76a4c828b7eda989f1236fdc6a4 = ({
  UserDetails? userDetails,
  UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1? usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1
});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $23fff76a4c828b7eda989f1236fdc6a4Extension on _$23fff76a4c828b7eda989f1236fdc6a4 {
  List<dynamic> get _values => [userDetails, usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1];
  List<String> get _names => const ['userDetails', 'usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$23fff76a4c828b7eda989f1236fdc6a4> get _serializer =>
      const _$23fff76a4c828b7eda989f1236fdc6a4Serializer();
  static _$23fff76a4c828b7eda989f1236fdc6a4 _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$23fff76a4c828b7eda989f1236fdc6a4Serializer implements PrimitiveSerializer<_$23fff76a4c828b7eda989f1236fdc6a4> {
  const _$23fff76a4c828b7eda989f1236fdc6a4Serializer();

  @override
  Iterable<Type> get types => const [_$23fff76a4c828b7eda989f1236fdc6a4];

  @override
  String get wireName => r'_$23fff76a4c828b7eda989f1236fdc6a4';

  @override
  Object serialize(
    Serializers serializers,
    _$23fff76a4c828b7eda989f1236fdc6a4 object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.userDetails;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(UserDetails))!;
    }
    value = object.usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1;
    if (value != null) {
      return serializers.serialize(
        value,
        specifiedType: const FullType(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1),
      )!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$23fff76a4c828b7eda989f1236fdc6a4 deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    UserDetails? userDetails;
    try {
      userDetails = serializers.deserialize(
        data,
        specifiedType: const FullType(UserDetails),
      )! as UserDetails;
    } catch (_) {}
    UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1?
        usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1;
    try {
      usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1 = serializers.deserialize(
        data,
        specifiedType: const FullType(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1),
      )! as UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1;
    } catch (_) {}
    return (
      userDetails: userDetails,
      usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1:
          usersGetLastLoggedInUsersResponseApplicationJsonOcsDataUsers1
    );
  }
}

typedef _$1e1cd5e43e0a1022a23a294e58225d74 = ({
  UserDetails? userDetails,
  UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1? usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1
});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $1e1cd5e43e0a1022a23a294e58225d74Extension on _$1e1cd5e43e0a1022a23a294e58225d74 {
  List<dynamic> get _values => [userDetails, usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1];
  List<String> get _names => const ['userDetails', 'usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$1e1cd5e43e0a1022a23a294e58225d74> get _serializer =>
      const _$1e1cd5e43e0a1022a23a294e58225d74Serializer();
  static _$1e1cd5e43e0a1022a23a294e58225d74 _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$1e1cd5e43e0a1022a23a294e58225d74Serializer implements PrimitiveSerializer<_$1e1cd5e43e0a1022a23a294e58225d74> {
  const _$1e1cd5e43e0a1022a23a294e58225d74Serializer();

  @override
  Iterable<Type> get types => const [_$1e1cd5e43e0a1022a23a294e58225d74];

  @override
  String get wireName => r'_$1e1cd5e43e0a1022a23a294e58225d74';

  @override
  Object serialize(
    Serializers serializers,
    _$1e1cd5e43e0a1022a23a294e58225d74 object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.userDetails;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(UserDetails))!;
    }
    value = object.usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1;
    if (value != null) {
      return serializers.serialize(
        value,
        specifiedType: const FullType(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
      )!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$1e1cd5e43e0a1022a23a294e58225d74 deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    UserDetails? userDetails;
    try {
      userDetails = serializers.deserialize(
        data,
        specifiedType: const FullType(UserDetails),
      )! as UserDetails;
    } catch (_) {}
    UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1?
        usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1;
    try {
      usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1 = serializers.deserialize(
        data,
        specifiedType: const FullType(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
      )! as UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1;
    } catch (_) {}
    return (
      userDetails: userDetails,
      usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1: usersGetUsersDetailsResponseApplicationJsonOcsDataUsers1
    );
  }
}

typedef _$f9d75e948689049b3f3e23e024d4be73 = ({
  UserDetails? userDetails,
  UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1? usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1
});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $f9d75e948689049b3f3e23e024d4be73Extension on _$f9d75e948689049b3f3e23e024d4be73 {
  List<dynamic> get _values => [userDetails, usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1];
  List<String> get _names => const ['userDetails', 'usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$f9d75e948689049b3f3e23e024d4be73> get _serializer =>
      const _$f9d75e948689049b3f3e23e024d4be73Serializer();
  static _$f9d75e948689049b3f3e23e024d4be73 _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$f9d75e948689049b3f3e23e024d4be73Serializer implements PrimitiveSerializer<_$f9d75e948689049b3f3e23e024d4be73> {
  const _$f9d75e948689049b3f3e23e024d4be73Serializer();

  @override
  Iterable<Type> get types => const [_$f9d75e948689049b3f3e23e024d4be73];

  @override
  String get wireName => r'_$f9d75e948689049b3f3e23e024d4be73';

  @override
  Object serialize(
    Serializers serializers,
    _$f9d75e948689049b3f3e23e024d4be73 object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.userDetails;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(UserDetails))!;
    }
    value = object.usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1;
    if (value != null) {
      return serializers.serialize(
        value,
        specifiedType: const FullType(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
      )!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$f9d75e948689049b3f3e23e024d4be73 deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    UserDetails? userDetails;
    try {
      userDetails = serializers.deserialize(
        data,
        specifiedType: const FullType(UserDetails),
      )! as UserDetails;
    } catch (_) {}
    UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1?
        usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1;
    try {
      usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1 = serializers.deserialize(
        data,
        specifiedType: const FullType(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
      )! as UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1;
    } catch (_) {}
    return (
      userDetails: userDetails,
      usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1:
          usersGetDisabledUsersDetailsResponseApplicationJsonOcsDataUsers1
    );
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(
        const FullType(AppConfigGetAppsResponseApplicationJson),
        AppConfigGetAppsResponseApplicationJsonBuilder.new,
      )
      ..add(AppConfigGetAppsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(AppConfigGetAppsResponseApplicationJson_Ocs),
        AppConfigGetAppsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(AppConfigGetAppsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(
        const FullType(AppConfigGetAppsResponseApplicationJson_Ocs_Data),
        AppConfigGetAppsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(AppConfigGetAppsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(String)]), ListBuilder<String>.new)
      ..addBuilderFactory(
        const FullType(AppConfigGetKeysResponseApplicationJson),
        AppConfigGetKeysResponseApplicationJsonBuilder.new,
      )
      ..add(AppConfigGetKeysResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(AppConfigGetKeysResponseApplicationJson_Ocs),
        AppConfigGetKeysResponseApplicationJson_OcsBuilder.new,
      )
      ..add(AppConfigGetKeysResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(AppConfigGetKeysResponseApplicationJson_Ocs_Data),
        AppConfigGetKeysResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(AppConfigGetKeysResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(AppConfigSetValueRequestApplicationJson),
        AppConfigSetValueRequestApplicationJsonBuilder.new,
      )
      ..add(AppConfigSetValueRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(AppConfigSetValueResponseApplicationJson),
        AppConfigSetValueResponseApplicationJsonBuilder.new,
      )
      ..add(AppConfigSetValueResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(AppConfigSetValueResponseApplicationJson_Ocs),
        AppConfigSetValueResponseApplicationJson_OcsBuilder.new,
      )
      ..add(AppConfigSetValueResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(AppsGetAppsResponseApplicationJson),
        AppsGetAppsResponseApplicationJsonBuilder.new,
      )
      ..add(AppsGetAppsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(AppsGetAppsResponseApplicationJson_Ocs),
        AppsGetAppsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(AppsGetAppsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(AppsGetAppsResponseApplicationJson_Ocs_Data),
        AppsGetAppsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(AppsGetAppsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(AppsGetAppInfoResponseApplicationJson),
        AppsGetAppInfoResponseApplicationJsonBuilder.new,
      )
      ..add(AppsGetAppInfoResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(AppsGetAppInfoResponseApplicationJson_Ocs),
        AppsGetAppInfoResponseApplicationJson_OcsBuilder.new,
      )
      ..add(AppsGetAppInfoResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(BuiltMap, [FullType(String), FullType.nullable(JsonObject)]),
        MapBuilder<String, JsonObject?>.new,
      )
      ..addBuilderFactory(
        const FullType(AppsEnableResponseApplicationJson),
        AppsEnableResponseApplicationJsonBuilder.new,
      )
      ..add(AppsEnableResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(AppsEnableResponseApplicationJson_Ocs),
        AppsEnableResponseApplicationJson_OcsBuilder.new,
      )
      ..add(AppsEnableResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(AppsDisableResponseApplicationJson),
        AppsDisableResponseApplicationJsonBuilder.new,
      )
      ..add(AppsDisableResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(AppsDisableResponseApplicationJson_Ocs),
        AppsDisableResponseApplicationJson_OcsBuilder.new,
      )
      ..add(AppsDisableResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetSubAdminsOfGroupResponseApplicationJson),
        GroupsGetSubAdminsOfGroupResponseApplicationJsonBuilder.new,
      )
      ..add(GroupsGetSubAdminsOfGroupResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs),
        GroupsGetSubAdminsOfGroupResponseApplicationJson_OcsBuilder.new,
      )
      ..add(GroupsGetSubAdminsOfGroupResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupsResponseApplicationJson),
        GroupsGetGroupsResponseApplicationJsonBuilder.new,
      )
      ..add(GroupsGetGroupsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupsResponseApplicationJson_Ocs),
        GroupsGetGroupsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(GroupsGetGroupsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupsResponseApplicationJson_Ocs_Data),
        GroupsGetGroupsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(GroupsGetGroupsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupResponseApplicationJson),
        GroupsGetGroupResponseApplicationJsonBuilder.new,
      )
      ..add(GroupsGetGroupResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupResponseApplicationJson_Ocs),
        GroupsGetGroupResponseApplicationJson_OcsBuilder.new,
      )
      ..add(GroupsGetGroupResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupResponseApplicationJson_Ocs_Data),
        GroupsGetGroupResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(GroupsGetGroupResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupsDetailsResponseApplicationJson),
        GroupsGetGroupsDetailsResponseApplicationJsonBuilder.new,
      )
      ..add(GroupsGetGroupsDetailsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupsDetailsResponseApplicationJson_Ocs),
        GroupsGetGroupsDetailsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(GroupsGetGroupsDetailsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data),
        GroupsGetGroupsDetailsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(GroupsGetGroupsDetailsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(const FullType(GroupDetails), GroupDetailsBuilder.new)
      ..add(GroupDetails.serializer)
      ..add($c4bc4131e74e61dae681408e87e2e2bdExtension._serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(GroupDetails)]), ListBuilder<GroupDetails>.new)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupUsersResponseApplicationJson),
        GroupsGetGroupUsersResponseApplicationJsonBuilder.new,
      )
      ..add(GroupsGetGroupUsersResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupUsersResponseApplicationJson_Ocs),
        GroupsGetGroupUsersResponseApplicationJson_OcsBuilder.new,
      )
      ..add(GroupsGetGroupUsersResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupUsersResponseApplicationJson_Ocs_Data),
        GroupsGetGroupUsersResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(GroupsGetGroupUsersResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupUsersDetailsResponseApplicationJson),
        GroupsGetGroupUsersDetailsResponseApplicationJsonBuilder.new,
      )
      ..add(GroupsGetGroupUsersDetailsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs),
        GroupsGetGroupUsersDetailsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data),
        GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(const FullType(UserDetails), UserDetailsBuilder.new)
      ..add(UserDetails.serializer)
      ..add(UserDetailsScope.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(UserDetailsScope)]), ListBuilder<UserDetailsScope>.new)
      ..addBuilderFactory(const FullType(UserDetails_BackendCapabilities), UserDetails_BackendCapabilitiesBuilder.new)
      ..add(UserDetails_BackendCapabilities.serializer)
      ..addBuilderFactory(const FullType(UserDetailsQuota), UserDetailsQuotaBuilder.new)
      ..add(UserDetailsQuota.serializer)
      ..add($b6d67dc2a96424d2f407f8e51557f3deExtension._serializer)
      ..addBuilderFactory(
        const FullType(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
        GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder.new,
      )
      ..add(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users1.serializer)
      ..add($b20d370ea28764b414e70ac5df151f1bExtension._serializer)
      ..addBuilderFactory(
        const FullType(
          BuiltMap,
          [FullType(String), FullType(GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users)],
        ),
        MapBuilder<String, GroupsGetGroupUsersDetailsResponseApplicationJson_Ocs_Data_Users>.new,
      )
      ..addBuilderFactory(
        const FullType(PreferencesSetPreferenceRequestApplicationJson),
        PreferencesSetPreferenceRequestApplicationJsonBuilder.new,
      )
      ..add(PreferencesSetPreferenceRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PreferencesSetPreferenceResponseApplicationJson),
        PreferencesSetPreferenceResponseApplicationJsonBuilder.new,
      )
      ..add(PreferencesSetPreferenceResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PreferencesSetPreferenceResponseApplicationJson_Ocs),
        PreferencesSetPreferenceResponseApplicationJson_OcsBuilder.new,
      )
      ..add(PreferencesSetPreferenceResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(PreferencesDeletePreferenceResponseApplicationJson),
        PreferencesDeletePreferenceResponseApplicationJsonBuilder.new,
      )
      ..add(PreferencesDeletePreferenceResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PreferencesDeletePreferenceResponseApplicationJson_Ocs),
        PreferencesDeletePreferenceResponseApplicationJson_OcsBuilder.new,
      )
      ..add(PreferencesDeletePreferenceResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(PreferencesSetMultiplePreferencesRequestApplicationJson),
        PreferencesSetMultiplePreferencesRequestApplicationJsonBuilder.new,
      )
      ..add(PreferencesSetMultiplePreferencesRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(BuiltMap, [FullType(String), FullType(String)]),
        MapBuilder<String, String>.new,
      )
      ..addBuilderFactory(
        const FullType(PreferencesSetMultiplePreferencesResponseApplicationJson),
        PreferencesSetMultiplePreferencesResponseApplicationJsonBuilder.new,
      )
      ..add(PreferencesSetMultiplePreferencesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs),
        PreferencesSetMultiplePreferencesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(PreferencesSetMultiplePreferencesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(PreferencesDeleteMultiplePreferenceResponseApplicationJson),
        PreferencesDeleteMultiplePreferenceResponseApplicationJsonBuilder.new,
      )
      ..add(PreferencesDeleteMultiplePreferenceResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs),
        PreferencesDeleteMultiplePreferenceResponseApplicationJson_OcsBuilder.new,
      )
      ..add(PreferencesDeleteMultiplePreferenceResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetLastLoggedInUsersResponseApplicationJson),
        UsersGetLastLoggedInUsersResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetLastLoggedInUsersResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs),
        UsersGetLastLoggedInUsersResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data),
        UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1),
        UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1Builder.new,
      )
      ..add(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users1.serializer)
      ..add($23fff76a4c828b7eda989f1236fdc6a4Extension._serializer)
      ..addBuilderFactory(
        const FullType(
          BuiltMap,
          [FullType(String), FullType(UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users)],
        ),
        MapBuilder<String, UsersGetLastLoggedInUsersResponseApplicationJson_Ocs_Data_Users>.new,
      )
      ..addBuilderFactory(
        const FullType(UsersGetUserSubAdminGroupsResponseApplicationJson),
        UsersGetUserSubAdminGroupsResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetUserSubAdminGroupsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs),
        UsersGetUserSubAdminGroupsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetUserSubAdminGroupsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddSubAdminRequestApplicationJson),
        UsersAddSubAdminRequestApplicationJsonBuilder.new,
      )
      ..add(UsersAddSubAdminRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddSubAdminResponseApplicationJson),
        UsersAddSubAdminResponseApplicationJsonBuilder.new,
      )
      ..add(UsersAddSubAdminResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddSubAdminResponseApplicationJson_Ocs),
        UsersAddSubAdminResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersAddSubAdminResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersRemoveSubAdminResponseApplicationJson),
        UsersRemoveSubAdminResponseApplicationJsonBuilder.new,
      )
      ..add(UsersRemoveSubAdminResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersRemoveSubAdminResponseApplicationJson_Ocs),
        UsersRemoveSubAdminResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersRemoveSubAdminResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersResponseApplicationJson),
        UsersGetUsersResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetUsersResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersResponseApplicationJson_Ocs),
        UsersGetUsersResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetUsersResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersResponseApplicationJson_Ocs_Data),
        UsersGetUsersResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(UsersGetUsersResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddUserRequestApplicationJson),
        UsersAddUserRequestApplicationJsonBuilder.new,
      )
      ..add(UsersAddUserRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddUserResponseApplicationJson),
        UsersAddUserResponseApplicationJsonBuilder.new,
      )
      ..add(UsersAddUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddUserResponseApplicationJson_Ocs),
        UsersAddUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersAddUserResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddUserResponseApplicationJson_Ocs_Data),
        UsersAddUserResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(UsersAddUserResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersDetailsResponseApplicationJson),
        UsersGetUsersDetailsResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetUsersDetailsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersDetailsResponseApplicationJson_Ocs),
        UsersGetUsersDetailsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetUsersDetailsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data),
        UsersGetUsersDetailsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
        UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder.new,
      )
      ..add(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users1.serializer)
      ..add($1e1cd5e43e0a1022a23a294e58225d74Extension._serializer)
      ..addBuilderFactory(
        const FullType(
          BuiltMap,
          [FullType(String), FullType(UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users)],
        ),
        MapBuilder<String, UsersGetUsersDetailsResponseApplicationJson_Ocs_Data_Users>.new,
      )
      ..addBuilderFactory(
        const FullType(UsersGetDisabledUsersDetailsResponseApplicationJson),
        UsersGetDisabledUsersDetailsResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetDisabledUsersDetailsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs),
        UsersGetDisabledUsersDetailsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data),
        UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1),
        UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1Builder.new,
      )
      ..add(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users1.serializer)
      ..add($f9d75e948689049b3f3e23e024d4be73Extension._serializer)
      ..addBuilderFactory(
        const FullType(
          BuiltMap,
          [FullType(String), FullType(UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users)],
        ),
        MapBuilder<String, UsersGetDisabledUsersDetailsResponseApplicationJson_Ocs_Data_Users>.new,
      )
      ..addBuilderFactory(
        const FullType(UsersSearchByPhoneNumbersRequestApplicationJson),
        UsersSearchByPhoneNumbersRequestApplicationJsonBuilder.new,
      )
      ..add(UsersSearchByPhoneNumbersRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(BuiltMap, [
          FullType(String),
          FullType(BuiltList, [FullType(String)]),
        ]),
        MapBuilder<String, BuiltList<String>>.new,
      )
      ..addBuilderFactory(
        const FullType(UsersSearchByPhoneNumbersResponseApplicationJson),
        UsersSearchByPhoneNumbersResponseApplicationJsonBuilder.new,
      )
      ..add(UsersSearchByPhoneNumbersResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersSearchByPhoneNumbersResponseApplicationJson_Ocs),
        UsersSearchByPhoneNumbersResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersSearchByPhoneNumbersResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUserResponseApplicationJson),
        UsersGetUserResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUserResponseApplicationJson_Ocs),
        UsersGetUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetUserResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersEditUserRequestApplicationJson),
        UsersEditUserRequestApplicationJsonBuilder.new,
      )
      ..add(UsersEditUserRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersEditUserResponseApplicationJson),
        UsersEditUserResponseApplicationJsonBuilder.new,
      )
      ..add(UsersEditUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersEditUserResponseApplicationJson_Ocs),
        UsersEditUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersEditUserResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersDeleteUserResponseApplicationJson),
        UsersDeleteUserResponseApplicationJsonBuilder.new,
      )
      ..add(UsersDeleteUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersDeleteUserResponseApplicationJson_Ocs),
        UsersDeleteUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersDeleteUserResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetCurrentUserResponseApplicationJson),
        UsersGetCurrentUserResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetCurrentUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetCurrentUserResponseApplicationJson_Ocs),
        UsersGetCurrentUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetCurrentUserResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetEditableFieldsResponseApplicationJson),
        UsersGetEditableFieldsResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetEditableFieldsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetEditableFieldsResponseApplicationJson_Ocs),
        UsersGetEditableFieldsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetEditableFieldsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetEditableFieldsForUserResponseApplicationJson),
        UsersGetEditableFieldsForUserResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetEditableFieldsForUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetEditableFieldsForUserResponseApplicationJson_Ocs),
        UsersGetEditableFieldsForUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetEditableFieldsForUserResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersEditUserMultiValueRequestApplicationJson),
        UsersEditUserMultiValueRequestApplicationJsonBuilder.new,
      )
      ..add(UsersEditUserMultiValueRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersEditUserMultiValueResponseApplicationJson),
        UsersEditUserMultiValueResponseApplicationJsonBuilder.new,
      )
      ..add(UsersEditUserMultiValueResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersEditUserMultiValueResponseApplicationJson_Ocs),
        UsersEditUserMultiValueResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersEditUserMultiValueResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersWipeUserDevicesResponseApplicationJson),
        UsersWipeUserDevicesResponseApplicationJsonBuilder.new,
      )
      ..add(UsersWipeUserDevicesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersWipeUserDevicesResponseApplicationJson_Ocs),
        UsersWipeUserDevicesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersWipeUserDevicesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersEnableUserResponseApplicationJson),
        UsersEnableUserResponseApplicationJsonBuilder.new,
      )
      ..add(UsersEnableUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersEnableUserResponseApplicationJson_Ocs),
        UsersEnableUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersEnableUserResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersDisableUserResponseApplicationJson),
        UsersDisableUserResponseApplicationJsonBuilder.new,
      )
      ..add(UsersDisableUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersDisableUserResponseApplicationJson_Ocs),
        UsersDisableUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersDisableUserResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersGroupsResponseApplicationJson),
        UsersGetUsersGroupsResponseApplicationJsonBuilder.new,
      )
      ..add(UsersGetUsersGroupsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersGroupsResponseApplicationJson_Ocs),
        UsersGetUsersGroupsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersGetUsersGroupsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersGetUsersGroupsResponseApplicationJson_Ocs_Data),
        UsersGetUsersGroupsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(UsersGetUsersGroupsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddToGroupRequestApplicationJson),
        UsersAddToGroupRequestApplicationJsonBuilder.new,
      )
      ..add(UsersAddToGroupRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddToGroupResponseApplicationJson),
        UsersAddToGroupResponseApplicationJsonBuilder.new,
      )
      ..add(UsersAddToGroupResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersAddToGroupResponseApplicationJson_Ocs),
        UsersAddToGroupResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersAddToGroupResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersRemoveFromGroupResponseApplicationJson),
        UsersRemoveFromGroupResponseApplicationJsonBuilder.new,
      )
      ..add(UsersRemoveFromGroupResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersRemoveFromGroupResponseApplicationJson_Ocs),
        UsersRemoveFromGroupResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersRemoveFromGroupResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UsersResendWelcomeMessageResponseApplicationJson),
        UsersResendWelcomeMessageResponseApplicationJsonBuilder.new,
      )
      ..add(UsersResendWelcomeMessageResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UsersResendWelcomeMessageResponseApplicationJson_Ocs),
        UsersResendWelcomeMessageResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UsersResendWelcomeMessageResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Capabilities), CapabilitiesBuilder.new)
      ..add(Capabilities.serializer)
      ..addBuilderFactory(const FullType(Capabilities_ProvisioningApi), Capabilities_ProvisioningApiBuilder.new)
      ..add(Capabilities_ProvisioningApi.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(
        _i8.StandardJsonPlugin(
          typesToLeaveAsList: const {
            _$c4bc4131e74e61dae681408e87e2e2bd,
            _$b6d67dc2a96424d2f407f8e51557f3de,
            _$b20d370ea28764b414e70ac5df151f1b,
            _$23fff76a4c828b7eda989f1236fdc6a4,
            _$1e1cd5e43e0a1022a23a294e58225d74,
            _$f9d75e948689049b3f3e23e024d4be73,
          },
        ),
      )
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
