// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// notifications Version: 0.0.1.
///
/// This app provides a backend and frontend for the notification API available in Nextcloud.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i5;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i6;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i4;

part 'notifications.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $ApiClient api = $ApiClient(this);

  late final $EndpointClient endpoint = $EndpointClient(this);

  late final $PushClient push = $PushClient(this);

  late final $SettingsClient settings = $SettingsClient(this);
}

class $ApiClient {
  /// Creates a new `DynamiteClient` for api requests.
  $ApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$generateNotification_Request].
  @_i2.experimental
  @Deprecated('')
  _i1.DynamiteSerializer<ApiGenerateNotificationResponseApplicationJson, void> $generateNotification_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ApiGenerateNotificationResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Generate a notification for a user (deprecated, use v3 instead).
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [generateNotification] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification generated successfully
  ///   * 400: Generating notification is not possible
  ///   * 404: User not found
  ///   * 500
  ///
  /// See:
  ///  * [generateNotification] for a method executing this request and parsing the response.
  ///  * [$generateNotification_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  @Deprecated('')
  _i3.Request $generateNotification_Request({
    required String userId,
    required ApiGenerateNotificationRequestApplicationJson $body,
    ApiGenerateNotificationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(ApiGenerateNotificationApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/admin_notifications/{userId}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ApiGenerateNotificationRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Generate a notification for a user (deprecated, use v3 instead).
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification generated successfully
  ///   * 400: Generating notification is not possible
  ///   * 404: User not found
  ///   * 500
  ///
  /// See:
  ///  * [$generateNotification_Request] for the request send by this method.
  ///  * [$generateNotification_Serializer] for a converter to parse the `Response` from an executed request.
  @Deprecated('')
  Future<_i1.DynamiteResponse<ApiGenerateNotificationResponseApplicationJson, void>> generateNotification({
    required String userId,
    required ApiGenerateNotificationRequestApplicationJson $body,
    ApiGenerateNotificationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $generateNotification_Request(
      userId: userId,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $generateNotification_Serializer();
    return _i1.ResponseConverter<ApiGenerateNotificationResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$generateNotificationV3_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ApiGenerateNotificationV3ResponseApplicationJson, void> $generateNotificationV3_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ApiGenerateNotificationV3ResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Generate a notification with rich object parameters for a user.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [generateNotificationV3] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion3]
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification generated successfully, returned id is the notification ID for future delete requests
  ///   * 400: Provided data was invalid, check error field of the response of log file for details
  ///
  /// See:
  ///  * [generateNotificationV3] for a method executing this request and parsing the response.
  ///  * [$generateNotificationV3_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $generateNotificationV3_Request({
    required String apiVersion3,
    required String userId,
    bool? oCSAPIRequest,
    ApiGenerateNotificationV3RequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __apiVersion3 = _$jsonSerializers.serialize(apiVersion3, specifiedType: const FullType(String));
    _i6.checkString(
      __apiVersion3,
      'apiVersion3',
      pattern: RegExp(r'^(v3)$'),
    );
    _parameters['apiVersion3'] = __apiVersion3;

    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion3}/admin_notifications/{userId}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(ApiGenerateNotificationV3RequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              ApiGenerateNotificationV3RequestApplicationJson(),
              specifiedType: const FullType(ApiGenerateNotificationV3RequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Generate a notification with rich object parameters for a user.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion3]
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification generated successfully, returned id is the notification ID for future delete requests
  ///   * 400: Provided data was invalid, check error field of the response of log file for details
  ///
  /// See:
  ///  * [$generateNotificationV3_Request] for the request send by this method.
  ///  * [$generateNotificationV3_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ApiGenerateNotificationV3ResponseApplicationJson, void>> generateNotificationV3({
    required String apiVersion3,
    required String userId,
    bool? oCSAPIRequest,
    ApiGenerateNotificationV3RequestApplicationJson? $body,
  }) async {
    final _request = $generateNotificationV3_Request(
      apiVersion3: apiVersion3,
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $generateNotificationV3_Serializer();
    return _i1.ResponseConverter<ApiGenerateNotificationV3ResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $EndpointClient {
  /// Creates a new `DynamiteClient` for endpoint requests.
  $EndpointClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listNotifications_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<EndpointListNotificationsResponseApplicationJson, EndpointEndpointListNotificationsHeaders>
      $listNotifications_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(EndpointListNotificationsResponseApplicationJson),
            headersType: const FullType(EndpointEndpointListNotificationsHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get all notifications.
  ///
  /// Returns a `DynamiteRequest` backing the [listNotifications] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Version of the API to use. Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notifications returned
  ///   * 204: No app uses notifications
  ///
  /// See:
  ///  * [listNotifications] for a method executing this request and parsing the response.
  ///  * [$listNotifications_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listNotifications_Request({
    EndpointListNotificationsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(EndpointListNotificationsApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/notifications').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get all notifications.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Version of the API to use. Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notifications returned
  ///   * 204: No app uses notifications
  ///
  /// See:
  ///  * [$listNotifications_Request] for the request send by this method.
  ///  * [$listNotifications_Serializer] for a converter to parse the `Response` from an executed request.
  Future<
          _i1
          .DynamiteResponse<EndpointListNotificationsResponseApplicationJson, EndpointEndpointListNotificationsHeaders>>
      listNotifications({
    EndpointListNotificationsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listNotifications_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listNotifications_Serializer();
    return _i1.ResponseConverter<EndpointListNotificationsResponseApplicationJson,
            EndpointEndpointListNotificationsHeaders>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteAllNotifications_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<EndpointDeleteAllNotificationsResponseApplicationJson, void>
      $deleteAllNotifications_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(EndpointDeleteAllNotificationsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Delete all notifications.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteAllNotifications] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: All notifications deleted successfully
  ///   * 403: Deleting notification for impersonated user is not allowed
  ///
  /// See:
  ///  * [deleteAllNotifications] for a method executing this request and parsing the response.
  ///  * [$deleteAllNotifications_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteAllNotifications_Request({
    EndpointDeleteAllNotificationsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion = _$jsonSerializers.serialize(
      apiVersion,
      specifiedType: const FullType(EndpointDeleteAllNotificationsApiVersion),
    );
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/notifications').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete all notifications.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: All notifications deleted successfully
  ///   * 403: Deleting notification for impersonated user is not allowed
  ///
  /// See:
  ///  * [$deleteAllNotifications_Request] for the request send by this method.
  ///  * [$deleteAllNotifications_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<EndpointDeleteAllNotificationsResponseApplicationJson, void>> deleteAllNotifications({
    EndpointDeleteAllNotificationsApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteAllNotifications_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteAllNotifications_Serializer();
    return _i1.ResponseConverter<EndpointDeleteAllNotificationsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getNotification_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<EndpointGetNotificationResponseApplicationJson, void> $getNotification_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(EndpointGetNotificationResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a notification.
  ///
  /// Returns a `DynamiteRequest` backing the [getNotification] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Version of the API to use. Defaults to `"v2"`.
  ///   * [id] ID of the notification.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification returned
  ///   * 404: Notification not found
  ///
  /// See:
  ///  * [getNotification] for a method executing this request and parsing the response.
  ///  * [$getNotification_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getNotification_Request({
    required int id,
    EndpointGetNotificationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(EndpointGetNotificationApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/notifications/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a notification.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Version of the API to use. Defaults to `"v2"`.
  ///   * [id] ID of the notification.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification returned
  ///   * 404: Notification not found
  ///
  /// See:
  ///  * [$getNotification_Request] for the request send by this method.
  ///  * [$getNotification_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<EndpointGetNotificationResponseApplicationJson, void>> getNotification({
    required int id,
    EndpointGetNotificationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getNotification_Request(
      id: id,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getNotification_Serializer();
    return _i1.ResponseConverter<EndpointGetNotificationResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteNotification_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<EndpointDeleteNotificationResponseApplicationJson, void> $deleteNotification_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(EndpointDeleteNotificationResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete a notification.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteNotification] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [id] ID of the notification.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification deleted successfully
  ///   * 403: Deleting notification for impersonated user is not allowed
  ///   * 404: Notification not found
  ///
  /// See:
  ///  * [deleteNotification] for a method executing this request and parsing the response.
  ///  * [$deleteNotification_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteNotification_Request({
    required int id,
    EndpointDeleteNotificationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(EndpointDeleteNotificationApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/notifications/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete a notification.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [id] ID of the notification.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Notification deleted successfully
  ///   * 403: Deleting notification for impersonated user is not allowed
  ///   * 404: Notification not found
  ///
  /// See:
  ///  * [$deleteNotification_Request] for the request send by this method.
  ///  * [$deleteNotification_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<EndpointDeleteNotificationResponseApplicationJson, void>> deleteNotification({
    required int id,
    EndpointDeleteNotificationApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteNotification_Request(
      id: id,
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteNotification_Serializer();
    return _i1.ResponseConverter<EndpointDeleteNotificationResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$confirmIdsForUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<EndpointConfirmIdsForUserResponseApplicationJson, void> $confirmIdsForUser_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(EndpointConfirmIdsForUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400},
      );

  /// Check if notification IDs exist.
  ///
  /// Returns a `DynamiteRequest` backing the [confirmIdsForUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Version of the API to use. Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Existing notification IDs returned
  ///   * 400: Too many notification IDs requested
  ///
  /// See:
  ///  * [confirmIdsForUser] for a method executing this request and parsing the response.
  ///  * [$confirmIdsForUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $confirmIdsForUser_Request({
    required EndpointConfirmIdsForUserRequestApplicationJson $body,
    EndpointConfirmIdsForUserApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(EndpointConfirmIdsForUserApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path =
        _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/notifications/exists').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(EndpointConfirmIdsForUserRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Check if notification IDs exist.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Version of the API to use. Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Existing notification IDs returned
  ///   * 400: Too many notification IDs requested
  ///
  /// See:
  ///  * [$confirmIdsForUser_Request] for the request send by this method.
  ///  * [$confirmIdsForUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<EndpointConfirmIdsForUserResponseApplicationJson, void>> confirmIdsForUser({
    required EndpointConfirmIdsForUserRequestApplicationJson $body,
    EndpointConfirmIdsForUserApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $confirmIdsForUser_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $confirmIdsForUser_Serializer();
    return _i1.ResponseConverter<EndpointConfirmIdsForUserResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $PushClient {
  /// Creates a new `DynamiteClient` for push requests.
  $PushClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$registerDevice_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PushRegisterDeviceResponseApplicationJson, void> $registerDevice_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(PushRegisterDeviceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201},
      );

  /// Register device for push notifications.
  ///
  /// Returns a `DynamiteRequest` backing the [registerDevice] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Device was already registered
  ///   * 201: Device registered successfully
  ///   * 400: Registering device is not possible
  ///   * 401: Missing permissions to register device
  ///
  /// See:
  ///  * [registerDevice] for a method executing this request and parsing the response.
  ///  * [$registerDevice_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $registerDevice_Request({
    required PushRegisterDeviceRequestApplicationJson $body,
    PushRegisterDeviceApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(PushRegisterDeviceApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/push').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(PushRegisterDeviceRequestApplicationJson)),
    );
    return _request;
  }

  /// Register device for push notifications.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Device was already registered
  ///   * 201: Device registered successfully
  ///   * 400: Registering device is not possible
  ///   * 401: Missing permissions to register device
  ///
  /// See:
  ///  * [$registerDevice_Request] for the request send by this method.
  ///  * [$registerDevice_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PushRegisterDeviceResponseApplicationJson, void>> registerDevice({
    required PushRegisterDeviceRequestApplicationJson $body,
    PushRegisterDeviceApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $registerDevice_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $registerDevice_Serializer();
    return _i1.ResponseConverter<PushRegisterDeviceResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$removeDevice_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<PushRemoveDeviceResponseApplicationJson, void> $removeDevice_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(PushRemoveDeviceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 202, 401},
      );

  /// Remove a device from push notifications.
  ///
  /// Returns a `DynamiteRequest` backing the [removeDevice] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: No device registered
  ///   * 202: Device removed successfully
  ///   * 401: Missing permissions to remove device
  ///   * 400: Removing device is not possible
  ///
  /// See:
  ///  * [removeDevice] for a method executing this request and parsing the response.
  ///  * [$removeDevice_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $removeDevice_Request({
    PushRemoveDeviceApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(PushRemoveDeviceApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/push').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove a device from push notifications.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: No device registered
  ///   * 202: Device removed successfully
  ///   * 401: Missing permissions to remove device
  ///   * 400: Removing device is not possible
  ///
  /// See:
  ///  * [$removeDevice_Request] for the request send by this method.
  ///  * [$removeDevice_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<PushRemoveDeviceResponseApplicationJson, void>> removeDevice({
    PushRemoveDeviceApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $removeDevice_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $removeDevice_Serializer();
    return _i1.ResponseConverter<PushRemoveDeviceResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $SettingsClient {
  /// Creates a new `DynamiteClient` for settings requests.
  $SettingsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$personal_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SettingsPersonalResponseApplicationJson, void> $personal_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(SettingsPersonalResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update personal notification settings.
  ///
  /// Returns a `DynamiteRequest` backing the [personal] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Personal settings updated
  ///
  /// See:
  ///  * [personal] for a method executing this request and parsing the response.
  ///  * [$personal_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $personal_Request({
    required SettingsPersonalRequestApplicationJson $body,
    SettingsPersonalApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion =
        _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SettingsPersonalApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/settings').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(SettingsPersonalRequestApplicationJson)),
    );
    return _request;
  }

  /// Update personal notification settings.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Personal settings updated
  ///
  /// See:
  ///  * [$personal_Request] for the request send by this method.
  ///  * [$personal_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SettingsPersonalResponseApplicationJson, void>> personal({
    required SettingsPersonalRequestApplicationJson $body,
    SettingsPersonalApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $personal_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $personal_Serializer();
    return _i1.ResponseConverter<SettingsPersonalResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$admin_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SettingsAdminResponseApplicationJson, void> $admin_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(SettingsAdminResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update default notification settings for new users.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [admin] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Admin settings updated
  ///
  /// See:
  ///  * [admin] for a method executing this request and parsing the response.
  ///  * [$admin_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $admin_Request({
    required SettingsAdminRequestApplicationJson $body,
    SettingsAdminApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __apiVersion = _$jsonSerializers.serialize(apiVersion, specifiedType: const FullType(SettingsAdminApiVersion));
    __apiVersion ??= 'v2';
    _parameters['apiVersion'] = __apiVersion;

    final _path = _i4.UriTemplate('/ocs/v2.php/apps/notifications/api/{apiVersion}/settings/admin').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i5.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i6.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(SettingsAdminRequestApplicationJson)));
    return _request;
  }

  /// Update default notification settings for new users.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [apiVersion] Defaults to `"v2"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Admin settings updated
  ///
  /// See:
  ///  * [$admin_Request] for the request send by this method.
  ///  * [$admin_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SettingsAdminResponseApplicationJson, void>> admin({
    required SettingsAdminRequestApplicationJson $body,
    SettingsAdminApiVersion? apiVersion,
    bool? oCSAPIRequest,
  }) async {
    final _request = $admin_Request(
      apiVersion: apiVersion,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $admin_Serializer();
    return _i1.ResponseConverter<SettingsAdminResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class ApiGenerateNotificationApiVersion extends EnumClass {
  const ApiGenerateNotificationApiVersion._(super.name);

  /// `v1`
  static const ApiGenerateNotificationApiVersion v1 = _$apiGenerateNotificationApiVersionV1;

  /// `v2`
  static const ApiGenerateNotificationApiVersion v2 = _$apiGenerateNotificationApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ApiGenerateNotificationApiVersion> get values => _$apiGenerateNotificationApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ApiGenerateNotificationApiVersion valueOf(String name) => _$valueOfApiGenerateNotificationApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ApiGenerateNotificationApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<ApiGenerateNotificationApiVersion> get serializer =>
      const _$ApiGenerateNotificationApiVersionSerializer();
}

class _$ApiGenerateNotificationApiVersionSerializer implements PrimitiveSerializer<ApiGenerateNotificationApiVersion> {
  const _$ApiGenerateNotificationApiVersionSerializer();

  static const Map<ApiGenerateNotificationApiVersion, Object> _toWire = <ApiGenerateNotificationApiVersion, Object>{
    ApiGenerateNotificationApiVersion.v1: 'v1',
    ApiGenerateNotificationApiVersion.v2: 'v2',
  };

  static const Map<Object, ApiGenerateNotificationApiVersion> _fromWire = <Object, ApiGenerateNotificationApiVersion>{
    'v1': ApiGenerateNotificationApiVersion.v1,
    'v2': ApiGenerateNotificationApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [ApiGenerateNotificationApiVersion];

  @override
  String get wireName => 'ApiGenerateNotificationApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    ApiGenerateNotificationApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ApiGenerateNotificationApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ApiGenerateNotificationRequestApplicationJsonInterface {
  static final _$longMessage = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// Subject of the notification.
  String get shortMessage;

  /// Message of the notification.
  String get longMessage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGenerateNotificationRequestApplicationJsonInterfaceBuilder].
  $ApiGenerateNotificationRequestApplicationJsonInterface rebuild(
    void Function($ApiGenerateNotificationRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGenerateNotificationRequestApplicationJsonInterfaceBuilder].
  $ApiGenerateNotificationRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGenerateNotificationRequestApplicationJsonInterfaceBuilder b) {
    b.longMessage = _$longMessage;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGenerateNotificationRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiGenerateNotificationRequestApplicationJson
    implements
        $ApiGenerateNotificationRequestApplicationJsonInterface,
        Built<ApiGenerateNotificationRequestApplicationJson, ApiGenerateNotificationRequestApplicationJsonBuilder> {
  /// Creates a new ApiGenerateNotificationRequestApplicationJson object using the builder pattern.
  factory ApiGenerateNotificationRequestApplicationJson([
    void Function(ApiGenerateNotificationRequestApplicationJsonBuilder)? b,
  ]) = _$ApiGenerateNotificationRequestApplicationJson;

  // coverage:ignore-start
  const ApiGenerateNotificationRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGenerateNotificationRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGenerateNotificationRequestApplicationJson.
  static Serializer<ApiGenerateNotificationRequestApplicationJson> get serializer =>
      _$apiGenerateNotificationRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGenerateNotificationRequestApplicationJsonBuilder b) {
    $ApiGenerateNotificationRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGenerateNotificationRequestApplicationJsonBuilder b) {
    $ApiGenerateNotificationRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiGenerateNotificationResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGenerateNotificationResponseApplicationJson_OcsInterfaceBuilder].
  $ApiGenerateNotificationResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiGenerateNotificationResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGenerateNotificationResponseApplicationJson_OcsInterfaceBuilder].
  $ApiGenerateNotificationResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGenerateNotificationResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGenerateNotificationResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiGenerateNotificationResponseApplicationJson_Ocs
    implements
        $ApiGenerateNotificationResponseApplicationJson_OcsInterface,
        Built<ApiGenerateNotificationResponseApplicationJson_Ocs,
            ApiGenerateNotificationResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiGenerateNotificationResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiGenerateNotificationResponseApplicationJson_Ocs([
    void Function(ApiGenerateNotificationResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiGenerateNotificationResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiGenerateNotificationResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGenerateNotificationResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGenerateNotificationResponseApplicationJson_Ocs.
  static Serializer<ApiGenerateNotificationResponseApplicationJson_Ocs> get serializer =>
      _$apiGenerateNotificationResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGenerateNotificationResponseApplicationJson_OcsBuilder b) {
    $ApiGenerateNotificationResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGenerateNotificationResponseApplicationJson_OcsBuilder b) {
    $ApiGenerateNotificationResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiGenerateNotificationResponseApplicationJsonInterface {
  ApiGenerateNotificationResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGenerateNotificationResponseApplicationJsonInterfaceBuilder].
  $ApiGenerateNotificationResponseApplicationJsonInterface rebuild(
    void Function($ApiGenerateNotificationResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGenerateNotificationResponseApplicationJsonInterfaceBuilder].
  $ApiGenerateNotificationResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGenerateNotificationResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGenerateNotificationResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiGenerateNotificationResponseApplicationJson
    implements
        $ApiGenerateNotificationResponseApplicationJsonInterface,
        Built<ApiGenerateNotificationResponseApplicationJson, ApiGenerateNotificationResponseApplicationJsonBuilder> {
  /// Creates a new ApiGenerateNotificationResponseApplicationJson object using the builder pattern.
  factory ApiGenerateNotificationResponseApplicationJson([
    void Function(ApiGenerateNotificationResponseApplicationJsonBuilder)? b,
  ]) = _$ApiGenerateNotificationResponseApplicationJson;

  // coverage:ignore-start
  const ApiGenerateNotificationResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGenerateNotificationResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGenerateNotificationResponseApplicationJson.
  static Serializer<ApiGenerateNotificationResponseApplicationJson> get serializer =>
      _$apiGenerateNotificationResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGenerateNotificationResponseApplicationJsonBuilder b) {
    $ApiGenerateNotificationResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGenerateNotificationResponseApplicationJsonBuilder b) {
    $ApiGenerateNotificationResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiGenerateNotificationV3RequestApplicationJsonInterface {
  static final _$subject = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$message = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$subjectParameters = _$jsonSerializers.deserialize(
    const {},
    specifiedType: const FullType(BuiltMap, [
      FullType(String),
      FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
    ]),
  )! as BuiltMap<String, BuiltMap<String, JsonObject>>;

  static final _$messageParameters = _$jsonSerializers.deserialize(
    const {},
    specifiedType: const FullType(BuiltMap, [
      FullType(String),
      FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
    ]),
  )! as BuiltMap<String, BuiltMap<String, JsonObject>>;

  /// Subject of the notification.
  String get subject;

  /// Message of the notification.
  String get message;

  /// Rich objects to fill the subject placeholders, {@see \OCP\RichObjectStrings\Definitions}.
  BuiltMap<String, BuiltMap<String, JsonObject>> get subjectParameters;

  /// Rich objects to fill the message placeholders, {@see \OCP\RichObjectStrings\Definitions}.
  BuiltMap<String, BuiltMap<String, JsonObject>> get messageParameters;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGenerateNotificationV3RequestApplicationJsonInterfaceBuilder].
  $ApiGenerateNotificationV3RequestApplicationJsonInterface rebuild(
    void Function($ApiGenerateNotificationV3RequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGenerateNotificationV3RequestApplicationJsonInterfaceBuilder].
  $ApiGenerateNotificationV3RequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGenerateNotificationV3RequestApplicationJsonInterfaceBuilder b) {
    b.subject = _$subject;
    b.message = _$message;
    b.subjectParameters.replace(_$subjectParameters);
    b.messageParameters.replace(_$messageParameters);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGenerateNotificationV3RequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiGenerateNotificationV3RequestApplicationJson
    implements
        $ApiGenerateNotificationV3RequestApplicationJsonInterface,
        Built<ApiGenerateNotificationV3RequestApplicationJson, ApiGenerateNotificationV3RequestApplicationJsonBuilder> {
  /// Creates a new ApiGenerateNotificationV3RequestApplicationJson object using the builder pattern.
  factory ApiGenerateNotificationV3RequestApplicationJson([
    void Function(ApiGenerateNotificationV3RequestApplicationJsonBuilder)? b,
  ]) = _$ApiGenerateNotificationV3RequestApplicationJson;

  // coverage:ignore-start
  const ApiGenerateNotificationV3RequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGenerateNotificationV3RequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGenerateNotificationV3RequestApplicationJson.
  static Serializer<ApiGenerateNotificationV3RequestApplicationJson> get serializer =>
      _$apiGenerateNotificationV3RequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGenerateNotificationV3RequestApplicationJsonBuilder b) {
    $ApiGenerateNotificationV3RequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGenerateNotificationV3RequestApplicationJsonBuilder b) {
    $ApiGenerateNotificationV3RequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterface {
  int get id;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data
    implements
        $ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterface,
        Built<ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data,
            ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data([
    void Function(ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data.
  static Serializer<ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data> get serializer =>
      _$apiGenerateNotificationV3ResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataBuilder b) {
    $ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataBuilder b) {
    $ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiGenerateNotificationV3ResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGenerateNotificationV3ResponseApplicationJson_OcsInterfaceBuilder].
  $ApiGenerateNotificationV3ResponseApplicationJson_OcsInterface rebuild(
    void Function($ApiGenerateNotificationV3ResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGenerateNotificationV3ResponseApplicationJson_OcsInterfaceBuilder].
  $ApiGenerateNotificationV3ResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGenerateNotificationV3ResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGenerateNotificationV3ResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ApiGenerateNotificationV3ResponseApplicationJson_Ocs
    implements
        $ApiGenerateNotificationV3ResponseApplicationJson_OcsInterface,
        Built<ApiGenerateNotificationV3ResponseApplicationJson_Ocs,
            ApiGenerateNotificationV3ResponseApplicationJson_OcsBuilder> {
  /// Creates a new ApiGenerateNotificationV3ResponseApplicationJson_Ocs object using the builder pattern.
  factory ApiGenerateNotificationV3ResponseApplicationJson_Ocs([
    void Function(ApiGenerateNotificationV3ResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ApiGenerateNotificationV3ResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ApiGenerateNotificationV3ResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGenerateNotificationV3ResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGenerateNotificationV3ResponseApplicationJson_Ocs.
  static Serializer<ApiGenerateNotificationV3ResponseApplicationJson_Ocs> get serializer =>
      _$apiGenerateNotificationV3ResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGenerateNotificationV3ResponseApplicationJson_OcsBuilder b) {
    $ApiGenerateNotificationV3ResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGenerateNotificationV3ResponseApplicationJson_OcsBuilder b) {
    $ApiGenerateNotificationV3ResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ApiGenerateNotificationV3ResponseApplicationJsonInterface {
  ApiGenerateNotificationV3ResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ApiGenerateNotificationV3ResponseApplicationJsonInterfaceBuilder].
  $ApiGenerateNotificationV3ResponseApplicationJsonInterface rebuild(
    void Function($ApiGenerateNotificationV3ResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ApiGenerateNotificationV3ResponseApplicationJsonInterfaceBuilder].
  $ApiGenerateNotificationV3ResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ApiGenerateNotificationV3ResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ApiGenerateNotificationV3ResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ApiGenerateNotificationV3ResponseApplicationJson
    implements
        $ApiGenerateNotificationV3ResponseApplicationJsonInterface,
        Built<ApiGenerateNotificationV3ResponseApplicationJson,
            ApiGenerateNotificationV3ResponseApplicationJsonBuilder> {
  /// Creates a new ApiGenerateNotificationV3ResponseApplicationJson object using the builder pattern.
  factory ApiGenerateNotificationV3ResponseApplicationJson([
    void Function(ApiGenerateNotificationV3ResponseApplicationJsonBuilder)? b,
  ]) = _$ApiGenerateNotificationV3ResponseApplicationJson;

  // coverage:ignore-start
  const ApiGenerateNotificationV3ResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ApiGenerateNotificationV3ResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ApiGenerateNotificationV3ResponseApplicationJson.
  static Serializer<ApiGenerateNotificationV3ResponseApplicationJson> get serializer =>
      _$apiGenerateNotificationV3ResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ApiGenerateNotificationV3ResponseApplicationJsonBuilder b) {
    $ApiGenerateNotificationV3ResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ApiGenerateNotificationV3ResponseApplicationJsonBuilder b) {
    $ApiGenerateNotificationV3ResponseApplicationJsonInterface._validate(b);
  }
}

class EndpointListNotificationsApiVersion extends EnumClass {
  const EndpointListNotificationsApiVersion._(super.name);

  /// `v1`
  static const EndpointListNotificationsApiVersion v1 = _$endpointListNotificationsApiVersionV1;

  /// `v2`
  static const EndpointListNotificationsApiVersion v2 = _$endpointListNotificationsApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<EndpointListNotificationsApiVersion> get values => _$endpointListNotificationsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static EndpointListNotificationsApiVersion valueOf(String name) => _$valueOfEndpointListNotificationsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for EndpointListNotificationsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<EndpointListNotificationsApiVersion> get serializer =>
      const _$EndpointListNotificationsApiVersionSerializer();
}

class _$EndpointListNotificationsApiVersionSerializer
    implements PrimitiveSerializer<EndpointListNotificationsApiVersion> {
  const _$EndpointListNotificationsApiVersionSerializer();

  static const Map<EndpointListNotificationsApiVersion, Object> _toWire = <EndpointListNotificationsApiVersion, Object>{
    EndpointListNotificationsApiVersion.v1: 'v1',
    EndpointListNotificationsApiVersion.v2: 'v2',
  };

  static const Map<Object, EndpointListNotificationsApiVersion> _fromWire =
      <Object, EndpointListNotificationsApiVersion>{
    'v1': EndpointListNotificationsApiVersion.v1,
    'v2': EndpointListNotificationsApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [EndpointListNotificationsApiVersion];

  @override
  String get wireName => 'EndpointListNotificationsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    EndpointListNotificationsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  EndpointListNotificationsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $NotificationActionInterface {
  String get label;
  String get link;
  String get type;
  bool get primary;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NotificationActionInterfaceBuilder].
  $NotificationActionInterface rebuild(void Function($NotificationActionInterfaceBuilder) updates);

  /// Converts the instance to a builder [$NotificationActionInterfaceBuilder].
  $NotificationActionInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NotificationActionInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NotificationActionInterfaceBuilder b) {}
}

abstract class NotificationAction
    implements $NotificationActionInterface, Built<NotificationAction, NotificationActionBuilder> {
  /// Creates a new NotificationAction object using the builder pattern.
  factory NotificationAction([void Function(NotificationActionBuilder)? b]) = _$NotificationAction;

  // coverage:ignore-start
  const NotificationAction._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NotificationAction.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NotificationAction.
  static Serializer<NotificationAction> get serializer => _$notificationActionSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NotificationActionBuilder b) {
    $NotificationActionInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NotificationActionBuilder b) {
    $NotificationActionInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NotificationInterface {
  @BuiltValueField(wireName: 'notification_id')
  int get notificationId;
  String get app;
  String get user;
  String get datetime;
  @BuiltValueField(wireName: 'object_type')
  String get objectType;
  @BuiltValueField(wireName: 'object_id')
  String get objectId;
  String get subject;
  String get message;
  String get link;
  BuiltList<NotificationAction> get actions;
  String? get subjectRich;
  BuiltMap<String, BuiltMap<String, JsonObject>>? get subjectRichParameters;
  String? get messageRich;
  BuiltMap<String, BuiltMap<String, JsonObject>>? get messageRichParameters;
  String? get icon;
  bool? get shouldNotify;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NotificationInterfaceBuilder].
  $NotificationInterface rebuild(void Function($NotificationInterfaceBuilder) updates);

  /// Converts the instance to a builder [$NotificationInterfaceBuilder].
  $NotificationInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NotificationInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NotificationInterfaceBuilder b) {}
}

abstract class Notification implements $NotificationInterface, Built<Notification, NotificationBuilder> {
  /// Creates a new Notification object using the builder pattern.
  factory Notification([void Function(NotificationBuilder)? b]) = _$Notification;

  // coverage:ignore-start
  const Notification._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Notification.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Notification.
  static Serializer<Notification> get serializer => _$notificationSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NotificationBuilder b) {
    $NotificationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NotificationBuilder b) {
    $NotificationInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EndpointListNotificationsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Notification> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointListNotificationsResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointListNotificationsResponseApplicationJson_OcsInterface rebuild(
    void Function($EndpointListNotificationsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointListNotificationsResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointListNotificationsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointListNotificationsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointListNotificationsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class EndpointListNotificationsResponseApplicationJson_Ocs
    implements
        $EndpointListNotificationsResponseApplicationJson_OcsInterface,
        Built<EndpointListNotificationsResponseApplicationJson_Ocs,
            EndpointListNotificationsResponseApplicationJson_OcsBuilder> {
  /// Creates a new EndpointListNotificationsResponseApplicationJson_Ocs object using the builder pattern.
  factory EndpointListNotificationsResponseApplicationJson_Ocs([
    void Function(EndpointListNotificationsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$EndpointListNotificationsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const EndpointListNotificationsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointListNotificationsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointListNotificationsResponseApplicationJson_Ocs.
  static Serializer<EndpointListNotificationsResponseApplicationJson_Ocs> get serializer =>
      _$endpointListNotificationsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointListNotificationsResponseApplicationJson_OcsBuilder b) {
    $EndpointListNotificationsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointListNotificationsResponseApplicationJson_OcsBuilder b) {
    $EndpointListNotificationsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EndpointListNotificationsResponseApplicationJsonInterface {
  EndpointListNotificationsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointListNotificationsResponseApplicationJsonInterfaceBuilder].
  $EndpointListNotificationsResponseApplicationJsonInterface rebuild(
    void Function($EndpointListNotificationsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointListNotificationsResponseApplicationJsonInterfaceBuilder].
  $EndpointListNotificationsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointListNotificationsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointListNotificationsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class EndpointListNotificationsResponseApplicationJson
    implements
        $EndpointListNotificationsResponseApplicationJsonInterface,
        Built<EndpointListNotificationsResponseApplicationJson,
            EndpointListNotificationsResponseApplicationJsonBuilder> {
  /// Creates a new EndpointListNotificationsResponseApplicationJson object using the builder pattern.
  factory EndpointListNotificationsResponseApplicationJson([
    void Function(EndpointListNotificationsResponseApplicationJsonBuilder)? b,
  ]) = _$EndpointListNotificationsResponseApplicationJson;

  // coverage:ignore-start
  const EndpointListNotificationsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointListNotificationsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointListNotificationsResponseApplicationJson.
  static Serializer<EndpointListNotificationsResponseApplicationJson> get serializer =>
      _$endpointListNotificationsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointListNotificationsResponseApplicationJsonBuilder b) {
    $EndpointListNotificationsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointListNotificationsResponseApplicationJsonBuilder b) {
    $EndpointListNotificationsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EndpointEndpointListNotificationsHeadersInterface {
  @BuiltValueField(wireName: 'x-nextcloud-user-status')
  String? get xNextcloudUserStatus;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointEndpointListNotificationsHeadersInterfaceBuilder].
  $EndpointEndpointListNotificationsHeadersInterface rebuild(
    void Function($EndpointEndpointListNotificationsHeadersInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointEndpointListNotificationsHeadersInterfaceBuilder].
  $EndpointEndpointListNotificationsHeadersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointEndpointListNotificationsHeadersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointEndpointListNotificationsHeadersInterfaceBuilder b) {}
}

abstract class EndpointEndpointListNotificationsHeaders
    implements
        $EndpointEndpointListNotificationsHeadersInterface,
        Built<EndpointEndpointListNotificationsHeaders, EndpointEndpointListNotificationsHeadersBuilder> {
  /// Creates a new EndpointEndpointListNotificationsHeaders object using the builder pattern.
  factory EndpointEndpointListNotificationsHeaders([
    void Function(EndpointEndpointListNotificationsHeadersBuilder)? b,
  ]) = _$EndpointEndpointListNotificationsHeaders;

  // coverage:ignore-start
  const EndpointEndpointListNotificationsHeaders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointEndpointListNotificationsHeaders.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointEndpointListNotificationsHeaders.
  static Serializer<EndpointEndpointListNotificationsHeaders> get serializer =>
      _$endpointEndpointListNotificationsHeadersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointEndpointListNotificationsHeadersBuilder b) {
    $EndpointEndpointListNotificationsHeadersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointEndpointListNotificationsHeadersBuilder b) {
    $EndpointEndpointListNotificationsHeadersInterface._validate(b);
  }
}

class EndpointDeleteAllNotificationsApiVersion extends EnumClass {
  const EndpointDeleteAllNotificationsApiVersion._(super.name);

  /// `v1`
  static const EndpointDeleteAllNotificationsApiVersion v1 = _$endpointDeleteAllNotificationsApiVersionV1;

  /// `v2`
  static const EndpointDeleteAllNotificationsApiVersion v2 = _$endpointDeleteAllNotificationsApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<EndpointDeleteAllNotificationsApiVersion> get values =>
      _$endpointDeleteAllNotificationsApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static EndpointDeleteAllNotificationsApiVersion valueOf(String name) =>
      _$valueOfEndpointDeleteAllNotificationsApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for EndpointDeleteAllNotificationsApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<EndpointDeleteAllNotificationsApiVersion> get serializer =>
      const _$EndpointDeleteAllNotificationsApiVersionSerializer();
}

class _$EndpointDeleteAllNotificationsApiVersionSerializer
    implements PrimitiveSerializer<EndpointDeleteAllNotificationsApiVersion> {
  const _$EndpointDeleteAllNotificationsApiVersionSerializer();

  static const Map<EndpointDeleteAllNotificationsApiVersion, Object> _toWire =
      <EndpointDeleteAllNotificationsApiVersion, Object>{
    EndpointDeleteAllNotificationsApiVersion.v1: 'v1',
    EndpointDeleteAllNotificationsApiVersion.v2: 'v2',
  };

  static const Map<Object, EndpointDeleteAllNotificationsApiVersion> _fromWire =
      <Object, EndpointDeleteAllNotificationsApiVersion>{
    'v1': EndpointDeleteAllNotificationsApiVersion.v1,
    'v2': EndpointDeleteAllNotificationsApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [EndpointDeleteAllNotificationsApiVersion];

  @override
  String get wireName => 'EndpointDeleteAllNotificationsApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    EndpointDeleteAllNotificationsApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  EndpointDeleteAllNotificationsApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterface rebuild(
    void Function($EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class EndpointDeleteAllNotificationsResponseApplicationJson_Ocs
    implements
        $EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterface,
        Built<EndpointDeleteAllNotificationsResponseApplicationJson_Ocs,
            EndpointDeleteAllNotificationsResponseApplicationJson_OcsBuilder> {
  /// Creates a new EndpointDeleteAllNotificationsResponseApplicationJson_Ocs object using the builder pattern.
  factory EndpointDeleteAllNotificationsResponseApplicationJson_Ocs([
    void Function(EndpointDeleteAllNotificationsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$EndpointDeleteAllNotificationsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const EndpointDeleteAllNotificationsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointDeleteAllNotificationsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointDeleteAllNotificationsResponseApplicationJson_Ocs.
  static Serializer<EndpointDeleteAllNotificationsResponseApplicationJson_Ocs> get serializer =>
      _$endpointDeleteAllNotificationsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointDeleteAllNotificationsResponseApplicationJson_OcsBuilder b) {
    $EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointDeleteAllNotificationsResponseApplicationJson_OcsBuilder b) {
    $EndpointDeleteAllNotificationsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EndpointDeleteAllNotificationsResponseApplicationJsonInterface {
  EndpointDeleteAllNotificationsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointDeleteAllNotificationsResponseApplicationJsonInterfaceBuilder].
  $EndpointDeleteAllNotificationsResponseApplicationJsonInterface rebuild(
    void Function($EndpointDeleteAllNotificationsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointDeleteAllNotificationsResponseApplicationJsonInterfaceBuilder].
  $EndpointDeleteAllNotificationsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointDeleteAllNotificationsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointDeleteAllNotificationsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class EndpointDeleteAllNotificationsResponseApplicationJson
    implements
        $EndpointDeleteAllNotificationsResponseApplicationJsonInterface,
        Built<EndpointDeleteAllNotificationsResponseApplicationJson,
            EndpointDeleteAllNotificationsResponseApplicationJsonBuilder> {
  /// Creates a new EndpointDeleteAllNotificationsResponseApplicationJson object using the builder pattern.
  factory EndpointDeleteAllNotificationsResponseApplicationJson([
    void Function(EndpointDeleteAllNotificationsResponseApplicationJsonBuilder)? b,
  ]) = _$EndpointDeleteAllNotificationsResponseApplicationJson;

  // coverage:ignore-start
  const EndpointDeleteAllNotificationsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointDeleteAllNotificationsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointDeleteAllNotificationsResponseApplicationJson.
  static Serializer<EndpointDeleteAllNotificationsResponseApplicationJson> get serializer =>
      _$endpointDeleteAllNotificationsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointDeleteAllNotificationsResponseApplicationJsonBuilder b) {
    $EndpointDeleteAllNotificationsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointDeleteAllNotificationsResponseApplicationJsonBuilder b) {
    $EndpointDeleteAllNotificationsResponseApplicationJsonInterface._validate(b);
  }
}

class EndpointGetNotificationApiVersion extends EnumClass {
  const EndpointGetNotificationApiVersion._(super.name);

  /// `v1`
  static const EndpointGetNotificationApiVersion v1 = _$endpointGetNotificationApiVersionV1;

  /// `v2`
  static const EndpointGetNotificationApiVersion v2 = _$endpointGetNotificationApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<EndpointGetNotificationApiVersion> get values => _$endpointGetNotificationApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static EndpointGetNotificationApiVersion valueOf(String name) => _$valueOfEndpointGetNotificationApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for EndpointGetNotificationApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<EndpointGetNotificationApiVersion> get serializer =>
      const _$EndpointGetNotificationApiVersionSerializer();
}

class _$EndpointGetNotificationApiVersionSerializer implements PrimitiveSerializer<EndpointGetNotificationApiVersion> {
  const _$EndpointGetNotificationApiVersionSerializer();

  static const Map<EndpointGetNotificationApiVersion, Object> _toWire = <EndpointGetNotificationApiVersion, Object>{
    EndpointGetNotificationApiVersion.v1: 'v1',
    EndpointGetNotificationApiVersion.v2: 'v2',
  };

  static const Map<Object, EndpointGetNotificationApiVersion> _fromWire = <Object, EndpointGetNotificationApiVersion>{
    'v1': EndpointGetNotificationApiVersion.v1,
    'v2': EndpointGetNotificationApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [EndpointGetNotificationApiVersion];

  @override
  String get wireName => 'EndpointGetNotificationApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    EndpointGetNotificationApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  EndpointGetNotificationApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $EndpointGetNotificationResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Notification get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointGetNotificationResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointGetNotificationResponseApplicationJson_OcsInterface rebuild(
    void Function($EndpointGetNotificationResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointGetNotificationResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointGetNotificationResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointGetNotificationResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointGetNotificationResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class EndpointGetNotificationResponseApplicationJson_Ocs
    implements
        $EndpointGetNotificationResponseApplicationJson_OcsInterface,
        Built<EndpointGetNotificationResponseApplicationJson_Ocs,
            EndpointGetNotificationResponseApplicationJson_OcsBuilder> {
  /// Creates a new EndpointGetNotificationResponseApplicationJson_Ocs object using the builder pattern.
  factory EndpointGetNotificationResponseApplicationJson_Ocs([
    void Function(EndpointGetNotificationResponseApplicationJson_OcsBuilder)? b,
  ]) = _$EndpointGetNotificationResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const EndpointGetNotificationResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointGetNotificationResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointGetNotificationResponseApplicationJson_Ocs.
  static Serializer<EndpointGetNotificationResponseApplicationJson_Ocs> get serializer =>
      _$endpointGetNotificationResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointGetNotificationResponseApplicationJson_OcsBuilder b) {
    $EndpointGetNotificationResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointGetNotificationResponseApplicationJson_OcsBuilder b) {
    $EndpointGetNotificationResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EndpointGetNotificationResponseApplicationJsonInterface {
  EndpointGetNotificationResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointGetNotificationResponseApplicationJsonInterfaceBuilder].
  $EndpointGetNotificationResponseApplicationJsonInterface rebuild(
    void Function($EndpointGetNotificationResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointGetNotificationResponseApplicationJsonInterfaceBuilder].
  $EndpointGetNotificationResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointGetNotificationResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointGetNotificationResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class EndpointGetNotificationResponseApplicationJson
    implements
        $EndpointGetNotificationResponseApplicationJsonInterface,
        Built<EndpointGetNotificationResponseApplicationJson, EndpointGetNotificationResponseApplicationJsonBuilder> {
  /// Creates a new EndpointGetNotificationResponseApplicationJson object using the builder pattern.
  factory EndpointGetNotificationResponseApplicationJson([
    void Function(EndpointGetNotificationResponseApplicationJsonBuilder)? b,
  ]) = _$EndpointGetNotificationResponseApplicationJson;

  // coverage:ignore-start
  const EndpointGetNotificationResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointGetNotificationResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointGetNotificationResponseApplicationJson.
  static Serializer<EndpointGetNotificationResponseApplicationJson> get serializer =>
      _$endpointGetNotificationResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointGetNotificationResponseApplicationJsonBuilder b) {
    $EndpointGetNotificationResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointGetNotificationResponseApplicationJsonBuilder b) {
    $EndpointGetNotificationResponseApplicationJsonInterface._validate(b);
  }
}

class EndpointDeleteNotificationApiVersion extends EnumClass {
  const EndpointDeleteNotificationApiVersion._(super.name);

  /// `v1`
  static const EndpointDeleteNotificationApiVersion v1 = _$endpointDeleteNotificationApiVersionV1;

  /// `v2`
  static const EndpointDeleteNotificationApiVersion v2 = _$endpointDeleteNotificationApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<EndpointDeleteNotificationApiVersion> get values => _$endpointDeleteNotificationApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static EndpointDeleteNotificationApiVersion valueOf(String name) =>
      _$valueOfEndpointDeleteNotificationApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for EndpointDeleteNotificationApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<EndpointDeleteNotificationApiVersion> get serializer =>
      const _$EndpointDeleteNotificationApiVersionSerializer();
}

class _$EndpointDeleteNotificationApiVersionSerializer
    implements PrimitiveSerializer<EndpointDeleteNotificationApiVersion> {
  const _$EndpointDeleteNotificationApiVersionSerializer();

  static const Map<EndpointDeleteNotificationApiVersion, Object> _toWire =
      <EndpointDeleteNotificationApiVersion, Object>{
    EndpointDeleteNotificationApiVersion.v1: 'v1',
    EndpointDeleteNotificationApiVersion.v2: 'v2',
  };

  static const Map<Object, EndpointDeleteNotificationApiVersion> _fromWire =
      <Object, EndpointDeleteNotificationApiVersion>{
    'v1': EndpointDeleteNotificationApiVersion.v1,
    'v2': EndpointDeleteNotificationApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [EndpointDeleteNotificationApiVersion];

  @override
  String get wireName => 'EndpointDeleteNotificationApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    EndpointDeleteNotificationApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  EndpointDeleteNotificationApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $EndpointDeleteNotificationResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointDeleteNotificationResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointDeleteNotificationResponseApplicationJson_OcsInterface rebuild(
    void Function($EndpointDeleteNotificationResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointDeleteNotificationResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointDeleteNotificationResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointDeleteNotificationResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointDeleteNotificationResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class EndpointDeleteNotificationResponseApplicationJson_Ocs
    implements
        $EndpointDeleteNotificationResponseApplicationJson_OcsInterface,
        Built<EndpointDeleteNotificationResponseApplicationJson_Ocs,
            EndpointDeleteNotificationResponseApplicationJson_OcsBuilder> {
  /// Creates a new EndpointDeleteNotificationResponseApplicationJson_Ocs object using the builder pattern.
  factory EndpointDeleteNotificationResponseApplicationJson_Ocs([
    void Function(EndpointDeleteNotificationResponseApplicationJson_OcsBuilder)? b,
  ]) = _$EndpointDeleteNotificationResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const EndpointDeleteNotificationResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointDeleteNotificationResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointDeleteNotificationResponseApplicationJson_Ocs.
  static Serializer<EndpointDeleteNotificationResponseApplicationJson_Ocs> get serializer =>
      _$endpointDeleteNotificationResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointDeleteNotificationResponseApplicationJson_OcsBuilder b) {
    $EndpointDeleteNotificationResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointDeleteNotificationResponseApplicationJson_OcsBuilder b) {
    $EndpointDeleteNotificationResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EndpointDeleteNotificationResponseApplicationJsonInterface {
  EndpointDeleteNotificationResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointDeleteNotificationResponseApplicationJsonInterfaceBuilder].
  $EndpointDeleteNotificationResponseApplicationJsonInterface rebuild(
    void Function($EndpointDeleteNotificationResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointDeleteNotificationResponseApplicationJsonInterfaceBuilder].
  $EndpointDeleteNotificationResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointDeleteNotificationResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointDeleteNotificationResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class EndpointDeleteNotificationResponseApplicationJson
    implements
        $EndpointDeleteNotificationResponseApplicationJsonInterface,
        Built<EndpointDeleteNotificationResponseApplicationJson,
            EndpointDeleteNotificationResponseApplicationJsonBuilder> {
  /// Creates a new EndpointDeleteNotificationResponseApplicationJson object using the builder pattern.
  factory EndpointDeleteNotificationResponseApplicationJson([
    void Function(EndpointDeleteNotificationResponseApplicationJsonBuilder)? b,
  ]) = _$EndpointDeleteNotificationResponseApplicationJson;

  // coverage:ignore-start
  const EndpointDeleteNotificationResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointDeleteNotificationResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointDeleteNotificationResponseApplicationJson.
  static Serializer<EndpointDeleteNotificationResponseApplicationJson> get serializer =>
      _$endpointDeleteNotificationResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointDeleteNotificationResponseApplicationJsonBuilder b) {
    $EndpointDeleteNotificationResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointDeleteNotificationResponseApplicationJsonBuilder b) {
    $EndpointDeleteNotificationResponseApplicationJsonInterface._validate(b);
  }
}

class EndpointConfirmIdsForUserApiVersion extends EnumClass {
  const EndpointConfirmIdsForUserApiVersion._(super.name);

  /// `v1`
  static const EndpointConfirmIdsForUserApiVersion v1 = _$endpointConfirmIdsForUserApiVersionV1;

  /// `v2`
  static const EndpointConfirmIdsForUserApiVersion v2 = _$endpointConfirmIdsForUserApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<EndpointConfirmIdsForUserApiVersion> get values => _$endpointConfirmIdsForUserApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static EndpointConfirmIdsForUserApiVersion valueOf(String name) => _$valueOfEndpointConfirmIdsForUserApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for EndpointConfirmIdsForUserApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<EndpointConfirmIdsForUserApiVersion> get serializer =>
      const _$EndpointConfirmIdsForUserApiVersionSerializer();
}

class _$EndpointConfirmIdsForUserApiVersionSerializer
    implements PrimitiveSerializer<EndpointConfirmIdsForUserApiVersion> {
  const _$EndpointConfirmIdsForUserApiVersionSerializer();

  static const Map<EndpointConfirmIdsForUserApiVersion, Object> _toWire = <EndpointConfirmIdsForUserApiVersion, Object>{
    EndpointConfirmIdsForUserApiVersion.v1: 'v1',
    EndpointConfirmIdsForUserApiVersion.v2: 'v2',
  };

  static const Map<Object, EndpointConfirmIdsForUserApiVersion> _fromWire =
      <Object, EndpointConfirmIdsForUserApiVersion>{
    'v1': EndpointConfirmIdsForUserApiVersion.v1,
    'v2': EndpointConfirmIdsForUserApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [EndpointConfirmIdsForUserApiVersion];

  @override
  String get wireName => 'EndpointConfirmIdsForUserApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    EndpointConfirmIdsForUserApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  EndpointConfirmIdsForUserApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $EndpointConfirmIdsForUserRequestApplicationJsonInterface {
  /// IDs of the notifications to check.
  BuiltList<int> get ids;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointConfirmIdsForUserRequestApplicationJsonInterfaceBuilder].
  $EndpointConfirmIdsForUserRequestApplicationJsonInterface rebuild(
    void Function($EndpointConfirmIdsForUserRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointConfirmIdsForUserRequestApplicationJsonInterfaceBuilder].
  $EndpointConfirmIdsForUserRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointConfirmIdsForUserRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointConfirmIdsForUserRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class EndpointConfirmIdsForUserRequestApplicationJson
    implements
        $EndpointConfirmIdsForUserRequestApplicationJsonInterface,
        Built<EndpointConfirmIdsForUserRequestApplicationJson, EndpointConfirmIdsForUserRequestApplicationJsonBuilder> {
  /// Creates a new EndpointConfirmIdsForUserRequestApplicationJson object using the builder pattern.
  factory EndpointConfirmIdsForUserRequestApplicationJson([
    void Function(EndpointConfirmIdsForUserRequestApplicationJsonBuilder)? b,
  ]) = _$EndpointConfirmIdsForUserRequestApplicationJson;

  // coverage:ignore-start
  const EndpointConfirmIdsForUserRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointConfirmIdsForUserRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointConfirmIdsForUserRequestApplicationJson.
  static Serializer<EndpointConfirmIdsForUserRequestApplicationJson> get serializer =>
      _$endpointConfirmIdsForUserRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointConfirmIdsForUserRequestApplicationJsonBuilder b) {
    $EndpointConfirmIdsForUserRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointConfirmIdsForUserRequestApplicationJsonBuilder b) {
    $EndpointConfirmIdsForUserRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EndpointConfirmIdsForUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<int> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointConfirmIdsForUserResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointConfirmIdsForUserResponseApplicationJson_OcsInterface rebuild(
    void Function($EndpointConfirmIdsForUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointConfirmIdsForUserResponseApplicationJson_OcsInterfaceBuilder].
  $EndpointConfirmIdsForUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointConfirmIdsForUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointConfirmIdsForUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class EndpointConfirmIdsForUserResponseApplicationJson_Ocs
    implements
        $EndpointConfirmIdsForUserResponseApplicationJson_OcsInterface,
        Built<EndpointConfirmIdsForUserResponseApplicationJson_Ocs,
            EndpointConfirmIdsForUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new EndpointConfirmIdsForUserResponseApplicationJson_Ocs object using the builder pattern.
  factory EndpointConfirmIdsForUserResponseApplicationJson_Ocs([
    void Function(EndpointConfirmIdsForUserResponseApplicationJson_OcsBuilder)? b,
  ]) = _$EndpointConfirmIdsForUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const EndpointConfirmIdsForUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointConfirmIdsForUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointConfirmIdsForUserResponseApplicationJson_Ocs.
  static Serializer<EndpointConfirmIdsForUserResponseApplicationJson_Ocs> get serializer =>
      _$endpointConfirmIdsForUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointConfirmIdsForUserResponseApplicationJson_OcsBuilder b) {
    $EndpointConfirmIdsForUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointConfirmIdsForUserResponseApplicationJson_OcsBuilder b) {
    $EndpointConfirmIdsForUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EndpointConfirmIdsForUserResponseApplicationJsonInterface {
  EndpointConfirmIdsForUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EndpointConfirmIdsForUserResponseApplicationJsonInterfaceBuilder].
  $EndpointConfirmIdsForUserResponseApplicationJsonInterface rebuild(
    void Function($EndpointConfirmIdsForUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$EndpointConfirmIdsForUserResponseApplicationJsonInterfaceBuilder].
  $EndpointConfirmIdsForUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EndpointConfirmIdsForUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EndpointConfirmIdsForUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class EndpointConfirmIdsForUserResponseApplicationJson
    implements
        $EndpointConfirmIdsForUserResponseApplicationJsonInterface,
        Built<EndpointConfirmIdsForUserResponseApplicationJson,
            EndpointConfirmIdsForUserResponseApplicationJsonBuilder> {
  /// Creates a new EndpointConfirmIdsForUserResponseApplicationJson object using the builder pattern.
  factory EndpointConfirmIdsForUserResponseApplicationJson([
    void Function(EndpointConfirmIdsForUserResponseApplicationJsonBuilder)? b,
  ]) = _$EndpointConfirmIdsForUserResponseApplicationJson;

  // coverage:ignore-start
  const EndpointConfirmIdsForUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EndpointConfirmIdsForUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EndpointConfirmIdsForUserResponseApplicationJson.
  static Serializer<EndpointConfirmIdsForUserResponseApplicationJson> get serializer =>
      _$endpointConfirmIdsForUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EndpointConfirmIdsForUserResponseApplicationJsonBuilder b) {
    $EndpointConfirmIdsForUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EndpointConfirmIdsForUserResponseApplicationJsonBuilder b) {
    $EndpointConfirmIdsForUserResponseApplicationJsonInterface._validate(b);
  }
}

class PushRegisterDeviceApiVersion extends EnumClass {
  const PushRegisterDeviceApiVersion._(super.name);

  /// `v2`
  static const PushRegisterDeviceApiVersion v2 = _$pushRegisterDeviceApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PushRegisterDeviceApiVersion> get values => _$pushRegisterDeviceApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PushRegisterDeviceApiVersion valueOf(String name) => _$valueOfPushRegisterDeviceApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for PushRegisterDeviceApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<PushRegisterDeviceApiVersion> get serializer => const _$PushRegisterDeviceApiVersionSerializer();
}

class _$PushRegisterDeviceApiVersionSerializer implements PrimitiveSerializer<PushRegisterDeviceApiVersion> {
  const _$PushRegisterDeviceApiVersionSerializer();

  static const Map<PushRegisterDeviceApiVersion, Object> _toWire = <PushRegisterDeviceApiVersion, Object>{
    PushRegisterDeviceApiVersion.v2: 'v2',
  };

  static const Map<Object, PushRegisterDeviceApiVersion> _fromWire = <Object, PushRegisterDeviceApiVersion>{
    'v2': PushRegisterDeviceApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [PushRegisterDeviceApiVersion];

  @override
  String get wireName => 'PushRegisterDeviceApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    PushRegisterDeviceApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PushRegisterDeviceApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $PushRegisterDeviceRequestApplicationJsonInterface {
  /// Hash of the push token.
  String get pushTokenHash;

  /// Public key of the device.
  String get devicePublicKey;

  /// Proxy server to be used.
  String get proxyServer;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PushRegisterDeviceRequestApplicationJsonInterfaceBuilder].
  $PushRegisterDeviceRequestApplicationJsonInterface rebuild(
    void Function($PushRegisterDeviceRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PushRegisterDeviceRequestApplicationJsonInterfaceBuilder].
  $PushRegisterDeviceRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PushRegisterDeviceRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PushRegisterDeviceRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class PushRegisterDeviceRequestApplicationJson
    implements
        $PushRegisterDeviceRequestApplicationJsonInterface,
        Built<PushRegisterDeviceRequestApplicationJson, PushRegisterDeviceRequestApplicationJsonBuilder> {
  /// Creates a new PushRegisterDeviceRequestApplicationJson object using the builder pattern.
  factory PushRegisterDeviceRequestApplicationJson([
    void Function(PushRegisterDeviceRequestApplicationJsonBuilder)? b,
  ]) = _$PushRegisterDeviceRequestApplicationJson;

  // coverage:ignore-start
  const PushRegisterDeviceRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PushRegisterDeviceRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PushRegisterDeviceRequestApplicationJson.
  static Serializer<PushRegisterDeviceRequestApplicationJson> get serializer =>
      _$pushRegisterDeviceRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PushRegisterDeviceRequestApplicationJsonBuilder b) {
    $PushRegisterDeviceRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PushRegisterDeviceRequestApplicationJsonBuilder b) {
    $PushRegisterDeviceRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PushDeviceInterface {
  String get publicKey;
  String get deviceIdentifier;
  String get signature;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PushDeviceInterfaceBuilder].
  $PushDeviceInterface rebuild(void Function($PushDeviceInterfaceBuilder) updates);

  /// Converts the instance to a builder [$PushDeviceInterfaceBuilder].
  $PushDeviceInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PushDeviceInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PushDeviceInterfaceBuilder b) {}
}

abstract class PushDevice implements $PushDeviceInterface, Built<PushDevice, PushDeviceBuilder> {
  /// Creates a new PushDevice object using the builder pattern.
  factory PushDevice([void Function(PushDeviceBuilder)? b]) = _$PushDevice;

  // coverage:ignore-start
  const PushDevice._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PushDevice.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PushDevice.
  static Serializer<PushDevice> get serializer => _$pushDeviceSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PushDeviceBuilder b) {
    $PushDeviceInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PushDeviceBuilder b) {
    $PushDeviceInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PushRegisterDeviceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  PushDevice get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PushRegisterDeviceResponseApplicationJson_OcsInterfaceBuilder].
  $PushRegisterDeviceResponseApplicationJson_OcsInterface rebuild(
    void Function($PushRegisterDeviceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PushRegisterDeviceResponseApplicationJson_OcsInterfaceBuilder].
  $PushRegisterDeviceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PushRegisterDeviceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PushRegisterDeviceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class PushRegisterDeviceResponseApplicationJson_Ocs
    implements
        $PushRegisterDeviceResponseApplicationJson_OcsInterface,
        Built<PushRegisterDeviceResponseApplicationJson_Ocs, PushRegisterDeviceResponseApplicationJson_OcsBuilder> {
  /// Creates a new PushRegisterDeviceResponseApplicationJson_Ocs object using the builder pattern.
  factory PushRegisterDeviceResponseApplicationJson_Ocs([
    void Function(PushRegisterDeviceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$PushRegisterDeviceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const PushRegisterDeviceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PushRegisterDeviceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PushRegisterDeviceResponseApplicationJson_Ocs.
  static Serializer<PushRegisterDeviceResponseApplicationJson_Ocs> get serializer =>
      _$pushRegisterDeviceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PushRegisterDeviceResponseApplicationJson_OcsBuilder b) {
    $PushRegisterDeviceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PushRegisterDeviceResponseApplicationJson_OcsBuilder b) {
    $PushRegisterDeviceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PushRegisterDeviceResponseApplicationJsonInterface {
  PushRegisterDeviceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PushRegisterDeviceResponseApplicationJsonInterfaceBuilder].
  $PushRegisterDeviceResponseApplicationJsonInterface rebuild(
    void Function($PushRegisterDeviceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PushRegisterDeviceResponseApplicationJsonInterfaceBuilder].
  $PushRegisterDeviceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PushRegisterDeviceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PushRegisterDeviceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class PushRegisterDeviceResponseApplicationJson
    implements
        $PushRegisterDeviceResponseApplicationJsonInterface,
        Built<PushRegisterDeviceResponseApplicationJson, PushRegisterDeviceResponseApplicationJsonBuilder> {
  /// Creates a new PushRegisterDeviceResponseApplicationJson object using the builder pattern.
  factory PushRegisterDeviceResponseApplicationJson([
    void Function(PushRegisterDeviceResponseApplicationJsonBuilder)? b,
  ]) = _$PushRegisterDeviceResponseApplicationJson;

  // coverage:ignore-start
  const PushRegisterDeviceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PushRegisterDeviceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PushRegisterDeviceResponseApplicationJson.
  static Serializer<PushRegisterDeviceResponseApplicationJson> get serializer =>
      _$pushRegisterDeviceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PushRegisterDeviceResponseApplicationJsonBuilder b) {
    $PushRegisterDeviceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PushRegisterDeviceResponseApplicationJsonBuilder b) {
    $PushRegisterDeviceResponseApplicationJsonInterface._validate(b);
  }
}

class PushRemoveDeviceApiVersion extends EnumClass {
  const PushRemoveDeviceApiVersion._(super.name);

  /// `v2`
  static const PushRemoveDeviceApiVersion v2 = _$pushRemoveDeviceApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PushRemoveDeviceApiVersion> get values => _$pushRemoveDeviceApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PushRemoveDeviceApiVersion valueOf(String name) => _$valueOfPushRemoveDeviceApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for PushRemoveDeviceApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<PushRemoveDeviceApiVersion> get serializer => const _$PushRemoveDeviceApiVersionSerializer();
}

class _$PushRemoveDeviceApiVersionSerializer implements PrimitiveSerializer<PushRemoveDeviceApiVersion> {
  const _$PushRemoveDeviceApiVersionSerializer();

  static const Map<PushRemoveDeviceApiVersion, Object> _toWire = <PushRemoveDeviceApiVersion, Object>{
    PushRemoveDeviceApiVersion.v2: 'v2',
  };

  static const Map<Object, PushRemoveDeviceApiVersion> _fromWire = <Object, PushRemoveDeviceApiVersion>{
    'v2': PushRemoveDeviceApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [PushRemoveDeviceApiVersion];

  @override
  String get wireName => 'PushRemoveDeviceApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    PushRemoveDeviceApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PushRemoveDeviceApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $PushRemoveDeviceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PushRemoveDeviceResponseApplicationJson_OcsInterfaceBuilder].
  $PushRemoveDeviceResponseApplicationJson_OcsInterface rebuild(
    void Function($PushRemoveDeviceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PushRemoveDeviceResponseApplicationJson_OcsInterfaceBuilder].
  $PushRemoveDeviceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PushRemoveDeviceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PushRemoveDeviceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class PushRemoveDeviceResponseApplicationJson_Ocs
    implements
        $PushRemoveDeviceResponseApplicationJson_OcsInterface,
        Built<PushRemoveDeviceResponseApplicationJson_Ocs, PushRemoveDeviceResponseApplicationJson_OcsBuilder> {
  /// Creates a new PushRemoveDeviceResponseApplicationJson_Ocs object using the builder pattern.
  factory PushRemoveDeviceResponseApplicationJson_Ocs([
    void Function(PushRemoveDeviceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$PushRemoveDeviceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const PushRemoveDeviceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PushRemoveDeviceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PushRemoveDeviceResponseApplicationJson_Ocs.
  static Serializer<PushRemoveDeviceResponseApplicationJson_Ocs> get serializer =>
      _$pushRemoveDeviceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PushRemoveDeviceResponseApplicationJson_OcsBuilder b) {
    $PushRemoveDeviceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PushRemoveDeviceResponseApplicationJson_OcsBuilder b) {
    $PushRemoveDeviceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $PushRemoveDeviceResponseApplicationJsonInterface {
  PushRemoveDeviceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$PushRemoveDeviceResponseApplicationJsonInterfaceBuilder].
  $PushRemoveDeviceResponseApplicationJsonInterface rebuild(
    void Function($PushRemoveDeviceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$PushRemoveDeviceResponseApplicationJsonInterfaceBuilder].
  $PushRemoveDeviceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($PushRemoveDeviceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($PushRemoveDeviceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class PushRemoveDeviceResponseApplicationJson
    implements
        $PushRemoveDeviceResponseApplicationJsonInterface,
        Built<PushRemoveDeviceResponseApplicationJson, PushRemoveDeviceResponseApplicationJsonBuilder> {
  /// Creates a new PushRemoveDeviceResponseApplicationJson object using the builder pattern.
  factory PushRemoveDeviceResponseApplicationJson([void Function(PushRemoveDeviceResponseApplicationJsonBuilder)? b]) =
      _$PushRemoveDeviceResponseApplicationJson;

  // coverage:ignore-start
  const PushRemoveDeviceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory PushRemoveDeviceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for PushRemoveDeviceResponseApplicationJson.
  static Serializer<PushRemoveDeviceResponseApplicationJson> get serializer =>
      _$pushRemoveDeviceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(PushRemoveDeviceResponseApplicationJsonBuilder b) {
    $PushRemoveDeviceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(PushRemoveDeviceResponseApplicationJsonBuilder b) {
    $PushRemoveDeviceResponseApplicationJsonInterface._validate(b);
  }
}

class SettingsPersonalApiVersion extends EnumClass {
  const SettingsPersonalApiVersion._(super.name);

  /// `v2`
  static const SettingsPersonalApiVersion v2 = _$settingsPersonalApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<SettingsPersonalApiVersion> get values => _$settingsPersonalApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static SettingsPersonalApiVersion valueOf(String name) => _$valueOfSettingsPersonalApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for SettingsPersonalApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<SettingsPersonalApiVersion> get serializer => const _$SettingsPersonalApiVersionSerializer();
}

class _$SettingsPersonalApiVersionSerializer implements PrimitiveSerializer<SettingsPersonalApiVersion> {
  const _$SettingsPersonalApiVersionSerializer();

  static const Map<SettingsPersonalApiVersion, Object> _toWire = <SettingsPersonalApiVersion, Object>{
    SettingsPersonalApiVersion.v2: 'v2',
  };

  static const Map<Object, SettingsPersonalApiVersion> _fromWire = <Object, SettingsPersonalApiVersion>{
    'v2': SettingsPersonalApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [SettingsPersonalApiVersion];

  @override
  String get wireName => 'SettingsPersonalApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    SettingsPersonalApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  SettingsPersonalApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $SettingsPersonalRequestApplicationJsonInterface {
  /// How often E-mails about missed notifications should be sent (hourly: 1; every three hours: 2; daily: 3; weekly: 4).
  int get batchSetting;

  /// Enable sound for notifications ('yes' or 'no').
  String get soundNotification;

  /// Enable sound for Talk notifications ('yes' or 'no').
  String get soundTalk;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SettingsPersonalRequestApplicationJsonInterfaceBuilder].
  $SettingsPersonalRequestApplicationJsonInterface rebuild(
    void Function($SettingsPersonalRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SettingsPersonalRequestApplicationJsonInterfaceBuilder].
  $SettingsPersonalRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SettingsPersonalRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SettingsPersonalRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class SettingsPersonalRequestApplicationJson
    implements
        $SettingsPersonalRequestApplicationJsonInterface,
        Built<SettingsPersonalRequestApplicationJson, SettingsPersonalRequestApplicationJsonBuilder> {
  /// Creates a new SettingsPersonalRequestApplicationJson object using the builder pattern.
  factory SettingsPersonalRequestApplicationJson([void Function(SettingsPersonalRequestApplicationJsonBuilder)? b]) =
      _$SettingsPersonalRequestApplicationJson;

  // coverage:ignore-start
  const SettingsPersonalRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SettingsPersonalRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SettingsPersonalRequestApplicationJson.
  static Serializer<SettingsPersonalRequestApplicationJson> get serializer =>
      _$settingsPersonalRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SettingsPersonalRequestApplicationJsonBuilder b) {
    $SettingsPersonalRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SettingsPersonalRequestApplicationJsonBuilder b) {
    $SettingsPersonalRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SettingsPersonalResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SettingsPersonalResponseApplicationJson_OcsInterfaceBuilder].
  $SettingsPersonalResponseApplicationJson_OcsInterface rebuild(
    void Function($SettingsPersonalResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SettingsPersonalResponseApplicationJson_OcsInterfaceBuilder].
  $SettingsPersonalResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SettingsPersonalResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SettingsPersonalResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class SettingsPersonalResponseApplicationJson_Ocs
    implements
        $SettingsPersonalResponseApplicationJson_OcsInterface,
        Built<SettingsPersonalResponseApplicationJson_Ocs, SettingsPersonalResponseApplicationJson_OcsBuilder> {
  /// Creates a new SettingsPersonalResponseApplicationJson_Ocs object using the builder pattern.
  factory SettingsPersonalResponseApplicationJson_Ocs([
    void Function(SettingsPersonalResponseApplicationJson_OcsBuilder)? b,
  ]) = _$SettingsPersonalResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const SettingsPersonalResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SettingsPersonalResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SettingsPersonalResponseApplicationJson_Ocs.
  static Serializer<SettingsPersonalResponseApplicationJson_Ocs> get serializer =>
      _$settingsPersonalResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SettingsPersonalResponseApplicationJson_OcsBuilder b) {
    $SettingsPersonalResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SettingsPersonalResponseApplicationJson_OcsBuilder b) {
    $SettingsPersonalResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SettingsPersonalResponseApplicationJsonInterface {
  SettingsPersonalResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SettingsPersonalResponseApplicationJsonInterfaceBuilder].
  $SettingsPersonalResponseApplicationJsonInterface rebuild(
    void Function($SettingsPersonalResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SettingsPersonalResponseApplicationJsonInterfaceBuilder].
  $SettingsPersonalResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SettingsPersonalResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SettingsPersonalResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class SettingsPersonalResponseApplicationJson
    implements
        $SettingsPersonalResponseApplicationJsonInterface,
        Built<SettingsPersonalResponseApplicationJson, SettingsPersonalResponseApplicationJsonBuilder> {
  /// Creates a new SettingsPersonalResponseApplicationJson object using the builder pattern.
  factory SettingsPersonalResponseApplicationJson([void Function(SettingsPersonalResponseApplicationJsonBuilder)? b]) =
      _$SettingsPersonalResponseApplicationJson;

  // coverage:ignore-start
  const SettingsPersonalResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SettingsPersonalResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SettingsPersonalResponseApplicationJson.
  static Serializer<SettingsPersonalResponseApplicationJson> get serializer =>
      _$settingsPersonalResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SettingsPersonalResponseApplicationJsonBuilder b) {
    $SettingsPersonalResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SettingsPersonalResponseApplicationJsonBuilder b) {
    $SettingsPersonalResponseApplicationJsonInterface._validate(b);
  }
}

class SettingsAdminApiVersion extends EnumClass {
  const SettingsAdminApiVersion._(super.name);

  /// `v2`
  static const SettingsAdminApiVersion v2 = _$settingsAdminApiVersionV2;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<SettingsAdminApiVersion> get values => _$settingsAdminApiVersionValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static SettingsAdminApiVersion valueOf(String name) => _$valueOfSettingsAdminApiVersion(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for SettingsAdminApiVersion.
  @BuiltValueSerializer(custom: true)
  static Serializer<SettingsAdminApiVersion> get serializer => const _$SettingsAdminApiVersionSerializer();
}

class _$SettingsAdminApiVersionSerializer implements PrimitiveSerializer<SettingsAdminApiVersion> {
  const _$SettingsAdminApiVersionSerializer();

  static const Map<SettingsAdminApiVersion, Object> _toWire = <SettingsAdminApiVersion, Object>{
    SettingsAdminApiVersion.v2: 'v2',
  };

  static const Map<Object, SettingsAdminApiVersion> _fromWire = <Object, SettingsAdminApiVersion>{
    'v2': SettingsAdminApiVersion.v2,
  };

  @override
  Iterable<Type> get types => const [SettingsAdminApiVersion];

  @override
  String get wireName => 'SettingsAdminApiVersion';

  @override
  Object serialize(
    Serializers serializers,
    SettingsAdminApiVersion object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  SettingsAdminApiVersion deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $SettingsAdminRequestApplicationJsonInterface {
  /// How often E-mails about missed notifications should be sent (hourly: 1; every three hours: 2; daily: 3; weekly: 4).
  int get batchSetting;

  /// Enable sound for notifications ('yes' or 'no').
  String get soundNotification;

  /// Enable sound for Talk notifications ('yes' or 'no').
  String get soundTalk;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SettingsAdminRequestApplicationJsonInterfaceBuilder].
  $SettingsAdminRequestApplicationJsonInterface rebuild(
    void Function($SettingsAdminRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SettingsAdminRequestApplicationJsonInterfaceBuilder].
  $SettingsAdminRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SettingsAdminRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SettingsAdminRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class SettingsAdminRequestApplicationJson
    implements
        $SettingsAdminRequestApplicationJsonInterface,
        Built<SettingsAdminRequestApplicationJson, SettingsAdminRequestApplicationJsonBuilder> {
  /// Creates a new SettingsAdminRequestApplicationJson object using the builder pattern.
  factory SettingsAdminRequestApplicationJson([void Function(SettingsAdminRequestApplicationJsonBuilder)? b]) =
      _$SettingsAdminRequestApplicationJson;

  // coverage:ignore-start
  const SettingsAdminRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SettingsAdminRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SettingsAdminRequestApplicationJson.
  static Serializer<SettingsAdminRequestApplicationJson> get serializer =>
      _$settingsAdminRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SettingsAdminRequestApplicationJsonBuilder b) {
    $SettingsAdminRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SettingsAdminRequestApplicationJsonBuilder b) {
    $SettingsAdminRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SettingsAdminResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SettingsAdminResponseApplicationJson_OcsInterfaceBuilder].
  $SettingsAdminResponseApplicationJson_OcsInterface rebuild(
    void Function($SettingsAdminResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SettingsAdminResponseApplicationJson_OcsInterfaceBuilder].
  $SettingsAdminResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SettingsAdminResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SettingsAdminResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class SettingsAdminResponseApplicationJson_Ocs
    implements
        $SettingsAdminResponseApplicationJson_OcsInterface,
        Built<SettingsAdminResponseApplicationJson_Ocs, SettingsAdminResponseApplicationJson_OcsBuilder> {
  /// Creates a new SettingsAdminResponseApplicationJson_Ocs object using the builder pattern.
  factory SettingsAdminResponseApplicationJson_Ocs([
    void Function(SettingsAdminResponseApplicationJson_OcsBuilder)? b,
  ]) = _$SettingsAdminResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const SettingsAdminResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SettingsAdminResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SettingsAdminResponseApplicationJson_Ocs.
  static Serializer<SettingsAdminResponseApplicationJson_Ocs> get serializer =>
      _$settingsAdminResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SettingsAdminResponseApplicationJson_OcsBuilder b) {
    $SettingsAdminResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SettingsAdminResponseApplicationJson_OcsBuilder b) {
    $SettingsAdminResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SettingsAdminResponseApplicationJsonInterface {
  SettingsAdminResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SettingsAdminResponseApplicationJsonInterfaceBuilder].
  $SettingsAdminResponseApplicationJsonInterface rebuild(
    void Function($SettingsAdminResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SettingsAdminResponseApplicationJsonInterfaceBuilder].
  $SettingsAdminResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SettingsAdminResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SettingsAdminResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class SettingsAdminResponseApplicationJson
    implements
        $SettingsAdminResponseApplicationJsonInterface,
        Built<SettingsAdminResponseApplicationJson, SettingsAdminResponseApplicationJsonBuilder> {
  /// Creates a new SettingsAdminResponseApplicationJson object using the builder pattern.
  factory SettingsAdminResponseApplicationJson([void Function(SettingsAdminResponseApplicationJsonBuilder)? b]) =
      _$SettingsAdminResponseApplicationJson;

  // coverage:ignore-start
  const SettingsAdminResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SettingsAdminResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SettingsAdminResponseApplicationJson.
  static Serializer<SettingsAdminResponseApplicationJson> get serializer =>
      _$settingsAdminResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SettingsAdminResponseApplicationJsonBuilder b) {
    $SettingsAdminResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SettingsAdminResponseApplicationJsonBuilder b) {
    $SettingsAdminResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_NotificationsInterface {
  @BuiltValueField(wireName: 'ocs-endpoints')
  BuiltList<String> get ocsEndpoints;
  BuiltList<String> get push;
  @BuiltValueField(wireName: 'admin-notifications')
  BuiltList<String> get adminNotifications;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_NotificationsInterfaceBuilder].
  $Capabilities_NotificationsInterface rebuild(void Function($Capabilities_NotificationsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Capabilities_NotificationsInterfaceBuilder].
  $Capabilities_NotificationsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_NotificationsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_NotificationsInterfaceBuilder b) {}
}

abstract class Capabilities_Notifications
    implements
        $Capabilities_NotificationsInterface,
        Built<Capabilities_Notifications, Capabilities_NotificationsBuilder> {
  /// Creates a new Capabilities_Notifications object using the builder pattern.
  factory Capabilities_Notifications([void Function(Capabilities_NotificationsBuilder)? b]) =
      _$Capabilities_Notifications;

  // coverage:ignore-start
  const Capabilities_Notifications._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_Notifications.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_Notifications.
  static Serializer<Capabilities_Notifications> get serializer => _$capabilitiesNotificationsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_NotificationsBuilder b) {
    $Capabilities_NotificationsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_NotificationsBuilder b) {
    $Capabilities_NotificationsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CapabilitiesInterface {
  Capabilities_Notifications get notifications;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterface rebuild(void Function($CapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CapabilitiesInterfaceBuilder b) {}
}

abstract class Capabilities implements $CapabilitiesInterface, Built<Capabilities, CapabilitiesBuilder> {
  /// Creates a new Capabilities object using the builder pattern.
  factory Capabilities([void Function(CapabilitiesBuilder)? b]) = _$Capabilities;

  // coverage:ignore-start
  const Capabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities.
  static Serializer<Capabilities> get serializer => _$capabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CapabilitiesBuilder b) {
    $CapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CapabilitiesBuilder b) {
    $CapabilitiesInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..add(ApiGenerateNotificationApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(ApiGenerateNotificationRequestApplicationJson),
        ApiGenerateNotificationRequestApplicationJsonBuilder.new,
      )
      ..add(ApiGenerateNotificationRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiGenerateNotificationResponseApplicationJson),
        ApiGenerateNotificationResponseApplicationJsonBuilder.new,
      )
      ..add(ApiGenerateNotificationResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiGenerateNotificationResponseApplicationJson_Ocs),
        ApiGenerateNotificationResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiGenerateNotificationResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(
        const FullType(ApiGenerateNotificationV3RequestApplicationJson),
        ApiGenerateNotificationV3RequestApplicationJsonBuilder.new,
      )
      ..add(ApiGenerateNotificationV3RequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
        MapBuilder<String, JsonObject>.new,
      )
      ..addBuilderFactory(
        const FullType(BuiltMap, [
          FullType(String),
          FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
        ]),
        MapBuilder<String, BuiltMap<String, JsonObject>>.new,
      )
      ..addBuilderFactory(
        const FullType(ApiGenerateNotificationV3ResponseApplicationJson),
        ApiGenerateNotificationV3ResponseApplicationJsonBuilder.new,
      )
      ..add(ApiGenerateNotificationV3ResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ApiGenerateNotificationV3ResponseApplicationJson_Ocs),
        ApiGenerateNotificationV3ResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ApiGenerateNotificationV3ResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data),
        ApiGenerateNotificationV3ResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(ApiGenerateNotificationV3ResponseApplicationJson_Ocs_Data.serializer)
      ..add(EndpointListNotificationsApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(EndpointListNotificationsResponseApplicationJson),
        EndpointListNotificationsResponseApplicationJsonBuilder.new,
      )
      ..add(EndpointListNotificationsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(EndpointListNotificationsResponseApplicationJson_Ocs),
        EndpointListNotificationsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(EndpointListNotificationsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Notification), NotificationBuilder.new)
      ..add(Notification.serializer)
      ..addBuilderFactory(const FullType(NotificationAction), NotificationActionBuilder.new)
      ..add(NotificationAction.serializer)
      ..addBuilderFactory(
        const FullType(BuiltList, [FullType(NotificationAction)]),
        ListBuilder<NotificationAction>.new,
      )
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Notification)]), ListBuilder<Notification>.new)
      ..addBuilderFactory(
        const FullType(EndpointEndpointListNotificationsHeaders),
        EndpointEndpointListNotificationsHeadersBuilder.new,
      )
      ..add(EndpointEndpointListNotificationsHeaders.serializer)
      ..add(EndpointDeleteAllNotificationsApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(EndpointDeleteAllNotificationsResponseApplicationJson),
        EndpointDeleteAllNotificationsResponseApplicationJsonBuilder.new,
      )
      ..add(EndpointDeleteAllNotificationsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(EndpointDeleteAllNotificationsResponseApplicationJson_Ocs),
        EndpointDeleteAllNotificationsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(EndpointDeleteAllNotificationsResponseApplicationJson_Ocs.serializer)
      ..add(EndpointGetNotificationApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(EndpointGetNotificationResponseApplicationJson),
        EndpointGetNotificationResponseApplicationJsonBuilder.new,
      )
      ..add(EndpointGetNotificationResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(EndpointGetNotificationResponseApplicationJson_Ocs),
        EndpointGetNotificationResponseApplicationJson_OcsBuilder.new,
      )
      ..add(EndpointGetNotificationResponseApplicationJson_Ocs.serializer)
      ..add(EndpointDeleteNotificationApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(EndpointDeleteNotificationResponseApplicationJson),
        EndpointDeleteNotificationResponseApplicationJsonBuilder.new,
      )
      ..add(EndpointDeleteNotificationResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(EndpointDeleteNotificationResponseApplicationJson_Ocs),
        EndpointDeleteNotificationResponseApplicationJson_OcsBuilder.new,
      )
      ..add(EndpointDeleteNotificationResponseApplicationJson_Ocs.serializer)
      ..add(EndpointConfirmIdsForUserApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(EndpointConfirmIdsForUserRequestApplicationJson),
        EndpointConfirmIdsForUserRequestApplicationJsonBuilder.new,
      )
      ..add(EndpointConfirmIdsForUserRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(int)]), ListBuilder<int>.new)
      ..addBuilderFactory(
        const FullType(EndpointConfirmIdsForUserResponseApplicationJson),
        EndpointConfirmIdsForUserResponseApplicationJsonBuilder.new,
      )
      ..add(EndpointConfirmIdsForUserResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(EndpointConfirmIdsForUserResponseApplicationJson_Ocs),
        EndpointConfirmIdsForUserResponseApplicationJson_OcsBuilder.new,
      )
      ..add(EndpointConfirmIdsForUserResponseApplicationJson_Ocs.serializer)
      ..add(PushRegisterDeviceApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(PushRegisterDeviceRequestApplicationJson),
        PushRegisterDeviceRequestApplicationJsonBuilder.new,
      )
      ..add(PushRegisterDeviceRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PushRegisterDeviceResponseApplicationJson),
        PushRegisterDeviceResponseApplicationJsonBuilder.new,
      )
      ..add(PushRegisterDeviceResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PushRegisterDeviceResponseApplicationJson_Ocs),
        PushRegisterDeviceResponseApplicationJson_OcsBuilder.new,
      )
      ..add(PushRegisterDeviceResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(PushDevice), PushDeviceBuilder.new)
      ..add(PushDevice.serializer)
      ..add(PushRemoveDeviceApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(PushRemoveDeviceResponseApplicationJson),
        PushRemoveDeviceResponseApplicationJsonBuilder.new,
      )
      ..add(PushRemoveDeviceResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(PushRemoveDeviceResponseApplicationJson_Ocs),
        PushRemoveDeviceResponseApplicationJson_OcsBuilder.new,
      )
      ..add(PushRemoveDeviceResponseApplicationJson_Ocs.serializer)
      ..add(SettingsPersonalApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(SettingsPersonalRequestApplicationJson),
        SettingsPersonalRequestApplicationJsonBuilder.new,
      )
      ..add(SettingsPersonalRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(SettingsPersonalResponseApplicationJson),
        SettingsPersonalResponseApplicationJsonBuilder.new,
      )
      ..add(SettingsPersonalResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(SettingsPersonalResponseApplicationJson_Ocs),
        SettingsPersonalResponseApplicationJson_OcsBuilder.new,
      )
      ..add(SettingsPersonalResponseApplicationJson_Ocs.serializer)
      ..add(SettingsAdminApiVersion.serializer)
      ..addBuilderFactory(
        const FullType(SettingsAdminRequestApplicationJson),
        SettingsAdminRequestApplicationJsonBuilder.new,
      )
      ..add(SettingsAdminRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(SettingsAdminResponseApplicationJson),
        SettingsAdminResponseApplicationJsonBuilder.new,
      )
      ..add(SettingsAdminResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(SettingsAdminResponseApplicationJson_Ocs),
        SettingsAdminResponseApplicationJson_OcsBuilder.new,
      )
      ..add(SettingsAdminResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Capabilities), CapabilitiesBuilder.new)
      ..add(Capabilities.serializer)
      ..addBuilderFactory(const FullType(Capabilities_Notifications), Capabilities_NotificationsBuilder.new)
      ..add(Capabilities_Notifications.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(String)]), ListBuilder<String>.new))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(_i8.StandardJsonPlugin())
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
