// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// news Version: 21.2.0.
///
/// An RSS/Atom feed reader.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0.html`.
@_i2.experimental
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i7;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i6;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i5;

part 'news.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $FeedsClient feeds = $FeedsClient(this);

  late final $FoldersClient folders = $FoldersClient(this);

  late final $ItemsClient items = $ItemsClient(this);

  /// Builds a serializer to parse the response of [$getSupportedApiVersions_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<SupportedAPIVersions, void> $getSupportedApiVersions_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(SupportedAPIVersions),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [getSupportedApiVersions] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [getSupportedApiVersions] for a method executing this request and parsing the response.
  ///  * [$getSupportedApiVersions_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getSupportedApiVersions_Request() {
    const _path = '/index.php/apps/news/api';
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$getSupportedApiVersions_Request] for the request send by this method.
  ///  * [$getSupportedApiVersions_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<SupportedAPIVersions, void>> getSupportedApiVersions() async {
    final _request = $getSupportedApiVersions_Request();
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getSupportedApiVersions_Serializer();
    return _i1.ResponseConverter<SupportedAPIVersions, void>(_serializer).convert(_response);
  }
}

class $FeedsClient {
  /// Creates a new `DynamiteClient` for feeds requests.
  $FeedsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listFeeds_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ListFeeds, void> $listFeeds_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ListFeeds),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [listFeeds] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [listFeeds] for a method executing this request and parsing the response.
  ///  * [$listFeeds_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listFeeds_Request() {
    const _path = '/index.php/apps/news/api/v1-3/feeds';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$listFeeds_Request] for the request send by this method.
  ///  * [$listFeeds_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ListFeeds, void>> listFeeds() async {
    final _request = $listFeeds_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listFeeds_Serializer();
    return _i1.ResponseConverter<ListFeeds, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$addFeed_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ListFeeds, void> $addFeed_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ListFeeds),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [addFeed] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [url]
  ///   * [folderId]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [addFeed] for a method executing this request and parsing the response.
  ///  * [$addFeed_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $addFeed_Request({
    required String url,
    int? folderId,
  }) {
    final _parameters = <String, Object?>{};
    final __url = _$jsonSerializers.serialize(url, specifiedType: const FullType(String));
    _parameters['url'] = __url;

    final __folderId = _$jsonSerializers.serialize(folderId, specifiedType: const FullType(int));
    _parameters['folderId'] = __folderId;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/feeds{?url*,folderId*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [url]
  ///   * [folderId]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$addFeed_Request] for the request send by this method.
  ///  * [$addFeed_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ListFeeds, void>> addFeed({
    required String url,
    int? folderId,
  }) async {
    final _request = $addFeed_Request(
      url: url,
      folderId: folderId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $addFeed_Serializer();
    return _i1.ResponseConverter<ListFeeds, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteFeed_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $deleteFeed_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [deleteFeed] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [deleteFeed] for a method executing this request and parsing the response.
  ///  * [$deleteFeed_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteFeed_Request({required int feedId}) {
    final _parameters = <String, Object?>{};
    final __feedId = _$jsonSerializers.serialize(feedId, specifiedType: const FullType(int));
    _parameters['feedId'] = __feedId;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/feeds/{feedId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$deleteFeed_Request] for the request send by this method.
  ///  * [$deleteFeed_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> deleteFeed({required int feedId}) async {
    final _request = $deleteFeed_Request(
      feedId: feedId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteFeed_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$moveFeed_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $moveFeed_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [moveFeed] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [folderId]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [moveFeed] for a method executing this request and parsing the response.
  ///  * [$moveFeed_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $moveFeed_Request({
    required int feedId,
    int? folderId,
  }) {
    final _parameters = <String, Object?>{};
    final __feedId = _$jsonSerializers.serialize(feedId, specifiedType: const FullType(int));
    _parameters['feedId'] = __feedId;

    final __folderId = _$jsonSerializers.serialize(folderId, specifiedType: const FullType(int));
    _parameters['folderId'] = __folderId;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/feeds/{feedId}/move{?folderId*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [folderId]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$moveFeed_Request] for the request send by this method.
  ///  * [$moveFeed_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> moveFeed({
    required int feedId,
    int? folderId,
  }) async {
    final _request = $moveFeed_Request(
      feedId: feedId,
      folderId: folderId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $moveFeed_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$renameFeed_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $renameFeed_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [renameFeed] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [feedTitle]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [renameFeed] for a method executing this request and parsing the response.
  ///  * [$renameFeed_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $renameFeed_Request({
    required int feedId,
    required String feedTitle,
  }) {
    final _parameters = <String, Object?>{};
    final __feedId = _$jsonSerializers.serialize(feedId, specifiedType: const FullType(int));
    _parameters['feedId'] = __feedId;

    final __feedTitle = _$jsonSerializers.serialize(feedTitle, specifiedType: const FullType(String));
    _parameters['feedTitle'] = __feedTitle;

    final _path =
        _i5.UriTemplate('/index.php/apps/news/api/v1-3/feeds/{feedId}/rename{?feedTitle*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [feedTitle]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$renameFeed_Request] for the request send by this method.
  ///  * [$renameFeed_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> renameFeed({
    required int feedId,
    required String feedTitle,
  }) async {
    final _request = $renameFeed_Request(
      feedId: feedId,
      feedTitle: feedTitle,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $renameFeed_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$markFeedAsRead_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $markFeedAsRead_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [markFeedAsRead] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [newestItemId]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [markFeedAsRead] for a method executing this request and parsing the response.
  ///  * [$markFeedAsRead_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $markFeedAsRead_Request({
    required int feedId,
    required int newestItemId,
  }) {
    final _parameters = <String, Object?>{};
    final __feedId = _$jsonSerializers.serialize(feedId, specifiedType: const FullType(int));
    _parameters['feedId'] = __feedId;

    final __newestItemId = _$jsonSerializers.serialize(newestItemId, specifiedType: const FullType(int));
    _parameters['newestItemId'] = __newestItemId;

    final _path =
        _i5.UriTemplate('/index.php/apps/news/api/v1-3/feeds/{feedId}/read{?newestItemId*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [newestItemId]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$markFeedAsRead_Request] for the request send by this method.
  ///  * [$markFeedAsRead_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> markFeedAsRead({
    required int feedId,
    required int newestItemId,
  }) async {
    final _request = $markFeedAsRead_Request(
      feedId: feedId,
      newestItemId: newestItemId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $markFeedAsRead_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }
}

class $FoldersClient {
  /// Creates a new `DynamiteClient` for folders requests.
  $FoldersClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listFolders_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ListFolders, void> $listFolders_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ListFolders),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [listFolders] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [listFolders] for a method executing this request and parsing the response.
  ///  * [$listFolders_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listFolders_Request() {
    const _path = '/index.php/apps/news/api/v1-3/folders';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$listFolders_Request] for the request send by this method.
  ///  * [$listFolders_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ListFolders, void>> listFolders() async {
    final _request = $listFolders_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listFolders_Serializer();
    return _i1.ResponseConverter<ListFolders, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createFolder_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ListFolders, void> $createFolder_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ListFolders),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [createFolder] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [name]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [createFolder] for a method executing this request and parsing the response.
  ///  * [$createFolder_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createFolder_Request({required String name}) {
    final _parameters = <String, Object?>{};
    final __name = _$jsonSerializers.serialize(name, specifiedType: const FullType(String));
    _parameters['name'] = __name;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/folders{?name*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [name]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$createFolder_Request] for the request send by this method.
  ///  * [$createFolder_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ListFolders, void>> createFolder({required String name}) async {
    final _request = $createFolder_Request(
      name: name,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createFolder_Serializer();
    return _i1.ResponseConverter<ListFolders, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$renameFolder_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $renameFolder_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [renameFolder] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [name]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [renameFolder] for a method executing this request and parsing the response.
  ///  * [$renameFolder_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $renameFolder_Request({
    required int folderId,
    required String name,
  }) {
    final _parameters = <String, Object?>{};
    final __folderId = _$jsonSerializers.serialize(folderId, specifiedType: const FullType(int));
    _parameters['folderId'] = __folderId;

    final __name = _$jsonSerializers.serialize(name, specifiedType: const FullType(String));
    _parameters['name'] = __name;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/folders/{folderId}{?name*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [name]
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$renameFolder_Request] for the request send by this method.
  ///  * [$renameFolder_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> renameFolder({
    required int folderId,
    required String name,
  }) async {
    final _request = $renameFolder_Request(
      folderId: folderId,
      name: name,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $renameFolder_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteFolder_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $deleteFolder_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [deleteFolder] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [deleteFolder] for a method executing this request and parsing the response.
  ///  * [$deleteFolder_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteFolder_Request({required int folderId}) {
    final _parameters = <String, Object?>{};
    final __folderId = _$jsonSerializers.serialize(folderId, specifiedType: const FullType(int));
    _parameters['folderId'] = __folderId;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/folders/{folderId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$deleteFolder_Request] for the request send by this method.
  ///  * [$deleteFolder_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> deleteFolder({required int folderId}) async {
    final _request = $deleteFolder_Request(
      folderId: folderId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteFolder_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$markFolderAsRead_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $markFolderAsRead_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [markFolderAsRead] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [newestItemId] The newest read item.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [markFolderAsRead] for a method executing this request and parsing the response.
  ///  * [$markFolderAsRead_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $markFolderAsRead_Request({
    required int folderId,
    required int newestItemId,
  }) {
    final _parameters = <String, Object?>{};
    final __folderId = _$jsonSerializers.serialize(folderId, specifiedType: const FullType(int));
    _parameters['folderId'] = __folderId;

    final __newestItemId = _$jsonSerializers.serialize(newestItemId, specifiedType: const FullType(int));
    _parameters['newestItemId'] = __newestItemId;

    final _path =
        _i5.UriTemplate('/index.php/apps/news/api/v1-3/folders/{folderId}/read{?newestItemId*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [newestItemId] The newest read item.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$markFolderAsRead_Request] for the request send by this method.
  ///  * [$markFolderAsRead_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> markFolderAsRead({
    required int folderId,
    required int newestItemId,
  }) async {
    final _request = $markFolderAsRead_Request(
      folderId: folderId,
      newestItemId: newestItemId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $markFolderAsRead_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }
}

class $ItemsClient {
  /// Creates a new `DynamiteClient` for items requests.
  $ItemsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listArticles_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ListArticles, void> $listArticles_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ListArticles),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [listArticles] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [type] Defaults to `3`.
  ///   * [id] Defaults to `0`.
  ///   * [getRead] Defaults to `1`.
  ///   * [batchSize] Defaults to `-1`.
  ///   * [offset] Defaults to `0`.
  ///   * [oldestFirst] Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [listArticles] for a method executing this request and parsing the response.
  ///  * [$listArticles_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listArticles_Request({
    int? type,
    int? id,
    int? getRead,
    int? batchSize,
    int? offset,
    int? oldestFirst,
  }) {
    final _parameters = <String, Object?>{};
    var __type = _$jsonSerializers.serialize(type, specifiedType: const FullType(int));
    __type ??= 3;
    _parameters['type'] = __type;

    var __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    __id ??= 0;
    _parameters['id'] = __id;

    var __getRead = _$jsonSerializers.serialize(getRead, specifiedType: const FullType(int));
    __getRead ??= 1;
    _parameters['getRead'] = __getRead;

    var __batchSize = _$jsonSerializers.serialize(batchSize, specifiedType: const FullType(int));
    __batchSize ??= -1;
    _parameters['batchSize'] = __batchSize;

    var __offset = _$jsonSerializers.serialize(offset, specifiedType: const FullType(int));
    __offset ??= 0;
    _parameters['offset'] = __offset;

    var __oldestFirst = _$jsonSerializers.serialize(oldestFirst, specifiedType: const FullType(int));
    __oldestFirst ??= 0;
    _parameters['oldestFirst'] = __oldestFirst;

    final _path =
        _i5.UriTemplate('/index.php/apps/news/api/v1-3/items{?type*,id*,getRead*,batchSize*,offset*,oldestFirst*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [type] Defaults to `3`.
  ///   * [id] Defaults to `0`.
  ///   * [getRead] Defaults to `1`.
  ///   * [batchSize] Defaults to `-1`.
  ///   * [offset] Defaults to `0`.
  ///   * [oldestFirst] Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$listArticles_Request] for the request send by this method.
  ///  * [$listArticles_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ListArticles, void>> listArticles({
    int? type,
    int? id,
    int? getRead,
    int? batchSize,
    int? offset,
    int? oldestFirst,
  }) async {
    final _request = $listArticles_Request(
      type: type,
      id: id,
      getRead: getRead,
      batchSize: batchSize,
      offset: offset,
      oldestFirst: oldestFirst,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listArticles_Serializer();
    return _i1.ResponseConverter<ListArticles, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$listUpdatedArticles_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ListArticles, void> $listUpdatedArticles_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ListArticles),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [listUpdatedArticles] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [type] Defaults to `3`.
  ///   * [id] Defaults to `0`.
  ///   * [lastModified] Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [listUpdatedArticles] for a method executing this request and parsing the response.
  ///  * [$listUpdatedArticles_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listUpdatedArticles_Request({
    int? type,
    int? id,
    int? lastModified,
  }) {
    final _parameters = <String, Object?>{};
    var __type = _$jsonSerializers.serialize(type, specifiedType: const FullType(int));
    __type ??= 3;
    _parameters['type'] = __type;

    var __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    __id ??= 0;
    _parameters['id'] = __id;

    var __lastModified = _$jsonSerializers.serialize(lastModified, specifiedType: const FullType(int));
    __lastModified ??= 0;
    _parameters['lastModified'] = __lastModified;

    final _path =
        _i5.UriTemplate('/index.php/apps/news/api/v1-3/items/updated{?type*,id*,lastModified*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [type] Defaults to `3`.
  ///   * [id] Defaults to `0`.
  ///   * [lastModified] Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$listUpdatedArticles_Request] for the request send by this method.
  ///  * [$listUpdatedArticles_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ListArticles, void>> listUpdatedArticles({
    int? type,
    int? id,
    int? lastModified,
  }) async {
    final _request = $listUpdatedArticles_Request(
      type: type,
      id: id,
      lastModified: lastModified,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listUpdatedArticles_Serializer();
    return _i1.ResponseConverter<ListArticles, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$markArticleAsRead_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $markArticleAsRead_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [markArticleAsRead] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [markArticleAsRead] for a method executing this request and parsing the response.
  ///  * [$markArticleAsRead_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $markArticleAsRead_Request({required int itemId}) {
    final _parameters = <String, Object?>{};
    final __itemId = _$jsonSerializers.serialize(itemId, specifiedType: const FullType(int));
    _parameters['itemId'] = __itemId;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/items/{itemId}/read').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$markArticleAsRead_Request] for the request send by this method.
  ///  * [$markArticleAsRead_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> markArticleAsRead({required int itemId}) async {
    final _request = $markArticleAsRead_Request(
      itemId: itemId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $markArticleAsRead_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$markArticleAsUnread_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $markArticleAsUnread_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [markArticleAsUnread] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [markArticleAsUnread] for a method executing this request and parsing the response.
  ///  * [$markArticleAsUnread_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $markArticleAsUnread_Request({required int itemId}) {
    final _parameters = <String, Object?>{};
    final __itemId = _$jsonSerializers.serialize(itemId, specifiedType: const FullType(int));
    _parameters['itemId'] = __itemId;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/items/{itemId}/unread').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$markArticleAsUnread_Request] for the request send by this method.
  ///  * [$markArticleAsUnread_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> markArticleAsUnread({required int itemId}) async {
    final _request = $markArticleAsUnread_Request(
      itemId: itemId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $markArticleAsUnread_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$readMultipleArticles_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $readMultipleArticles_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [readMultipleArticles] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [readMultipleArticles] for a method executing this request and parsing the response.
  ///  * [$readMultipleArticles_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $readMultipleArticles_Request({required ReadMultipleArticlesRequestApplicationJson $body}) {
    const _path = '/index.php/apps/news/api/v1-3/items/read/multiple';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ReadMultipleArticlesRequestApplicationJson)),
    );
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$readMultipleArticles_Request] for the request send by this method.
  ///  * [$readMultipleArticles_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> readMultipleArticles({
    required ReadMultipleArticlesRequestApplicationJson $body,
  }) async {
    final _request = $readMultipleArticles_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $readMultipleArticles_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$unreadMultipleArticles_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $unreadMultipleArticles_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [unreadMultipleArticles] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [unreadMultipleArticles] for a method executing this request and parsing the response.
  ///  * [$unreadMultipleArticles_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $unreadMultipleArticles_Request({required UnreadMultipleArticlesRequestApplicationJson $body}) {
    const _path = '/index.php/apps/news/api/v1-3/items/unread/multiple';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(UnreadMultipleArticlesRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$unreadMultipleArticles_Request] for the request send by this method.
  ///  * [$unreadMultipleArticles_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> unreadMultipleArticles({
    required UnreadMultipleArticlesRequestApplicationJson $body,
  }) async {
    final _request = $unreadMultipleArticles_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $unreadMultipleArticles_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$starArticle_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $starArticle_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [starArticle] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [starArticle] for a method executing this request and parsing the response.
  ///  * [$starArticle_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $starArticle_Request({required int itemId}) {
    final _parameters = <String, Object?>{};
    final __itemId = _$jsonSerializers.serialize(itemId, specifiedType: const FullType(int));
    _parameters['itemId'] = __itemId;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/items/{itemId}/star').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$starArticle_Request] for the request send by this method.
  ///  * [$starArticle_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> starArticle({required int itemId}) async {
    final _request = $starArticle_Request(
      itemId: itemId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $starArticle_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$unstarArticle_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $unstarArticle_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [unstarArticle] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [unstarArticle] for a method executing this request and parsing the response.
  ///  * [$unstarArticle_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $unstarArticle_Request({required int itemId}) {
    final _parameters = <String, Object?>{};
    final __itemId = _$jsonSerializers.serialize(itemId, specifiedType: const FullType(int));
    _parameters['itemId'] = __itemId;

    final _path = _i5.UriTemplate('/index.php/apps/news/api/v1-3/items/{itemId}/unstar').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$unstarArticle_Request] for the request send by this method.
  ///  * [$unstarArticle_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> unstarArticle({required int itemId}) async {
    final _request = $unstarArticle_Request(
      itemId: itemId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $unstarArticle_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$starMultipleArticles_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $starMultipleArticles_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [starMultipleArticles] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [starMultipleArticles] for a method executing this request and parsing the response.
  ///  * [$starMultipleArticles_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $starMultipleArticles_Request({required StarMultipleArticlesRequestApplicationJson $body}) {
    const _path = '/index.php/apps/news/api/v1-3/items/star/multiple';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(StarMultipleArticlesRequestApplicationJson)),
    );
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$starMultipleArticles_Request] for the request send by this method.
  ///  * [$starMultipleArticles_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> starMultipleArticles({
    required StarMultipleArticlesRequestApplicationJson $body,
  }) async {
    final _request = $starMultipleArticles_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $starMultipleArticles_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$unstarMultipleArticles_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<void, void> $unstarMultipleArticles_Serializer() => _i1.DynamiteSerializer(
        bodyType: null,
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [unstarMultipleArticles] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [unstarMultipleArticles] for a method executing this request and parsing the response.
  ///  * [$unstarMultipleArticles_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $unstarMultipleArticles_Request({required UnstarMultipleArticlesRequestApplicationJson $body}) {
    const _path = '/index.php/apps/news/api/v1-3/items/unstar/multiple';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(UnstarMultipleArticlesRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200
  ///
  /// See:
  ///  * [$unstarMultipleArticles_Request] for the request send by this method.
  ///  * [$unstarMultipleArticles_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<void, void>> unstarMultipleArticles({
    required UnstarMultipleArticlesRequestApplicationJson $body,
  }) async {
    final _request = $unstarMultipleArticles_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $unstarMultipleArticles_Serializer();
    return _i1.ResponseConverter<void, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $SupportedAPIVersionsInterface {
  BuiltList<String>? get apiLevels;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SupportedAPIVersionsInterfaceBuilder].
  $SupportedAPIVersionsInterface rebuild(void Function($SupportedAPIVersionsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$SupportedAPIVersionsInterfaceBuilder].
  $SupportedAPIVersionsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SupportedAPIVersionsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SupportedAPIVersionsInterfaceBuilder b) {}
}

abstract class SupportedAPIVersions
    implements $SupportedAPIVersionsInterface, Built<SupportedAPIVersions, SupportedAPIVersionsBuilder> {
  /// Creates a new SupportedAPIVersions object using the builder pattern.
  factory SupportedAPIVersions([void Function(SupportedAPIVersionsBuilder)? b]) = _$SupportedAPIVersions;

  // coverage:ignore-start
  const SupportedAPIVersions._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SupportedAPIVersions.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SupportedAPIVersions.
  static Serializer<SupportedAPIVersions> get serializer => _$supportedAPIVersionsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SupportedAPIVersionsBuilder b) {
    $SupportedAPIVersionsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SupportedAPIVersionsBuilder b) {
    $SupportedAPIVersionsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ArticleInterface {
  int get id;
  String get guid;
  String get guidHash;
  String? get url;
  String get title;
  String? get author;
  int get pubDate;
  int? get updatedDate;
  String get body;
  String? get enclosureMime;
  String? get enclosureLink;
  String? get mediaThumbnail;
  String? get mediaDescription;
  int get feedId;
  bool get unread;
  bool get starred;
  int get lastModified;
  bool get rtl;
  String get fingerprint;
  String get contentHash;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ArticleInterfaceBuilder].
  $ArticleInterface rebuild(void Function($ArticleInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ArticleInterfaceBuilder].
  $ArticleInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ArticleInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ArticleInterfaceBuilder b) {}
}

abstract class Article implements $ArticleInterface, Built<Article, ArticleBuilder> {
  /// Creates a new Article object using the builder pattern.
  factory Article([void Function(ArticleBuilder)? b]) = _$Article;

  // coverage:ignore-start
  const Article._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Article.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Article.
  static Serializer<Article> get serializer => _$articleSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ArticleBuilder b) {
    $ArticleInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ArticleBuilder b) {
    $ArticleInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FeedInterface {
  int get id;
  String get url;
  String get title;
  String? get faviconLink;
  int get added;
  int? get folderId;
  int? get unreadCount;
  int get ordering;
  String? get link;
  bool get pinned;
  int get updateErrorCount;
  String? get lastUpdateError;
  BuiltList<Article> get items;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FeedInterfaceBuilder].
  $FeedInterface rebuild(void Function($FeedInterfaceBuilder) updates);

  /// Converts the instance to a builder [$FeedInterfaceBuilder].
  $FeedInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FeedInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FeedInterfaceBuilder b) {}
}

abstract class Feed implements $FeedInterface, Built<Feed, FeedBuilder> {
  /// Creates a new Feed object using the builder pattern.
  factory Feed([void Function(FeedBuilder)? b]) = _$Feed;

  // coverage:ignore-start
  const Feed._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Feed.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Feed.
  static Serializer<Feed> get serializer => _$feedSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FeedBuilder b) {
    $FeedInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FeedBuilder b) {
    $FeedInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ListFeedsInterface {
  int? get starredCount;
  int? get newestItemId;
  BuiltList<Feed> get feeds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ListFeedsInterfaceBuilder].
  $ListFeedsInterface rebuild(void Function($ListFeedsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ListFeedsInterfaceBuilder].
  $ListFeedsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ListFeedsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ListFeedsInterfaceBuilder b) {}
}

abstract class ListFeeds implements $ListFeedsInterface, Built<ListFeeds, ListFeedsBuilder> {
  /// Creates a new ListFeeds object using the builder pattern.
  factory ListFeeds([void Function(ListFeedsBuilder)? b]) = _$ListFeeds;

  // coverage:ignore-start
  const ListFeeds._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ListFeeds.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ListFeeds.
  static Serializer<ListFeeds> get serializer => _$listFeedsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ListFeedsBuilder b) {
    $ListFeedsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ListFeedsBuilder b) {
    $ListFeedsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FolderInterface {
  int get id;
  String get name;
  bool get opened;

  /// This seems to be broken. In testing it is always empty.
  @Deprecated('')
  BuiltList<Feed> get feeds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FolderInterfaceBuilder].
  $FolderInterface rebuild(void Function($FolderInterfaceBuilder) updates);

  /// Converts the instance to a builder [$FolderInterfaceBuilder].
  $FolderInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FolderInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FolderInterfaceBuilder b) {}
}

abstract class Folder implements $FolderInterface, Built<Folder, FolderBuilder> {
  /// Creates a new Folder object using the builder pattern.
  factory Folder([void Function(FolderBuilder)? b]) = _$Folder;

  // coverage:ignore-start
  const Folder._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Folder.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Folder.
  static Serializer<Folder> get serializer => _$folderSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FolderBuilder b) {
    $FolderInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FolderBuilder b) {
    $FolderInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ListFoldersInterface {
  BuiltList<Folder> get folders;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ListFoldersInterfaceBuilder].
  $ListFoldersInterface rebuild(void Function($ListFoldersInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ListFoldersInterfaceBuilder].
  $ListFoldersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ListFoldersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ListFoldersInterfaceBuilder b) {}
}

abstract class ListFolders implements $ListFoldersInterface, Built<ListFolders, ListFoldersBuilder> {
  /// Creates a new ListFolders object using the builder pattern.
  factory ListFolders([void Function(ListFoldersBuilder)? b]) = _$ListFolders;

  // coverage:ignore-start
  const ListFolders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ListFolders.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ListFolders.
  static Serializer<ListFolders> get serializer => _$listFoldersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ListFoldersBuilder b) {
    $ListFoldersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ListFoldersBuilder b) {
    $ListFoldersInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ListArticlesInterface {
  BuiltList<Article> get items;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ListArticlesInterfaceBuilder].
  $ListArticlesInterface rebuild(void Function($ListArticlesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ListArticlesInterfaceBuilder].
  $ListArticlesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ListArticlesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ListArticlesInterfaceBuilder b) {}
}

abstract class ListArticles implements $ListArticlesInterface, Built<ListArticles, ListArticlesBuilder> {
  /// Creates a new ListArticles object using the builder pattern.
  factory ListArticles([void Function(ListArticlesBuilder)? b]) = _$ListArticles;

  // coverage:ignore-start
  const ListArticles._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ListArticles.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ListArticles.
  static Serializer<ListArticles> get serializer => _$listArticlesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ListArticlesBuilder b) {
    $ListArticlesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ListArticlesBuilder b) {
    $ListArticlesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReadMultipleArticlesRequestApplicationJsonInterface {
  BuiltList<int> get itemIds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReadMultipleArticlesRequestApplicationJsonInterfaceBuilder].
  $ReadMultipleArticlesRequestApplicationJsonInterface rebuild(
    void Function($ReadMultipleArticlesRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReadMultipleArticlesRequestApplicationJsonInterfaceBuilder].
  $ReadMultipleArticlesRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReadMultipleArticlesRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReadMultipleArticlesRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ReadMultipleArticlesRequestApplicationJson
    implements
        $ReadMultipleArticlesRequestApplicationJsonInterface,
        Built<ReadMultipleArticlesRequestApplicationJson, ReadMultipleArticlesRequestApplicationJsonBuilder> {
  /// Creates a new ReadMultipleArticlesRequestApplicationJson object using the builder pattern.
  factory ReadMultipleArticlesRequestApplicationJson([
    void Function(ReadMultipleArticlesRequestApplicationJsonBuilder)? b,
  ]) = _$ReadMultipleArticlesRequestApplicationJson;

  // coverage:ignore-start
  const ReadMultipleArticlesRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReadMultipleArticlesRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReadMultipleArticlesRequestApplicationJson.
  static Serializer<ReadMultipleArticlesRequestApplicationJson> get serializer =>
      _$readMultipleArticlesRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReadMultipleArticlesRequestApplicationJsonBuilder b) {
    $ReadMultipleArticlesRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReadMultipleArticlesRequestApplicationJsonBuilder b) {
    $ReadMultipleArticlesRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UnreadMultipleArticlesRequestApplicationJsonInterface {
  BuiltList<int> get itemIds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UnreadMultipleArticlesRequestApplicationJsonInterfaceBuilder].
  $UnreadMultipleArticlesRequestApplicationJsonInterface rebuild(
    void Function($UnreadMultipleArticlesRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UnreadMultipleArticlesRequestApplicationJsonInterfaceBuilder].
  $UnreadMultipleArticlesRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UnreadMultipleArticlesRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UnreadMultipleArticlesRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UnreadMultipleArticlesRequestApplicationJson
    implements
        $UnreadMultipleArticlesRequestApplicationJsonInterface,
        Built<UnreadMultipleArticlesRequestApplicationJson, UnreadMultipleArticlesRequestApplicationJsonBuilder> {
  /// Creates a new UnreadMultipleArticlesRequestApplicationJson object using the builder pattern.
  factory UnreadMultipleArticlesRequestApplicationJson([
    void Function(UnreadMultipleArticlesRequestApplicationJsonBuilder)? b,
  ]) = _$UnreadMultipleArticlesRequestApplicationJson;

  // coverage:ignore-start
  const UnreadMultipleArticlesRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UnreadMultipleArticlesRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UnreadMultipleArticlesRequestApplicationJson.
  static Serializer<UnreadMultipleArticlesRequestApplicationJson> get serializer =>
      _$unreadMultipleArticlesRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UnreadMultipleArticlesRequestApplicationJsonBuilder b) {
    $UnreadMultipleArticlesRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UnreadMultipleArticlesRequestApplicationJsonBuilder b) {
    $UnreadMultipleArticlesRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $StarMultipleArticlesRequestApplicationJsonInterface {
  BuiltList<int> get itemIds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$StarMultipleArticlesRequestApplicationJsonInterfaceBuilder].
  $StarMultipleArticlesRequestApplicationJsonInterface rebuild(
    void Function($StarMultipleArticlesRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$StarMultipleArticlesRequestApplicationJsonInterfaceBuilder].
  $StarMultipleArticlesRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($StarMultipleArticlesRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($StarMultipleArticlesRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class StarMultipleArticlesRequestApplicationJson
    implements
        $StarMultipleArticlesRequestApplicationJsonInterface,
        Built<StarMultipleArticlesRequestApplicationJson, StarMultipleArticlesRequestApplicationJsonBuilder> {
  /// Creates a new StarMultipleArticlesRequestApplicationJson object using the builder pattern.
  factory StarMultipleArticlesRequestApplicationJson([
    void Function(StarMultipleArticlesRequestApplicationJsonBuilder)? b,
  ]) = _$StarMultipleArticlesRequestApplicationJson;

  // coverage:ignore-start
  const StarMultipleArticlesRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory StarMultipleArticlesRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for StarMultipleArticlesRequestApplicationJson.
  static Serializer<StarMultipleArticlesRequestApplicationJson> get serializer =>
      _$starMultipleArticlesRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(StarMultipleArticlesRequestApplicationJsonBuilder b) {
    $StarMultipleArticlesRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(StarMultipleArticlesRequestApplicationJsonBuilder b) {
    $StarMultipleArticlesRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UnstarMultipleArticlesRequestApplicationJsonInterface {
  BuiltList<int> get itemIds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UnstarMultipleArticlesRequestApplicationJsonInterfaceBuilder].
  $UnstarMultipleArticlesRequestApplicationJsonInterface rebuild(
    void Function($UnstarMultipleArticlesRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UnstarMultipleArticlesRequestApplicationJsonInterfaceBuilder].
  $UnstarMultipleArticlesRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UnstarMultipleArticlesRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UnstarMultipleArticlesRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class UnstarMultipleArticlesRequestApplicationJson
    implements
        $UnstarMultipleArticlesRequestApplicationJsonInterface,
        Built<UnstarMultipleArticlesRequestApplicationJson, UnstarMultipleArticlesRequestApplicationJsonBuilder> {
  /// Creates a new UnstarMultipleArticlesRequestApplicationJson object using the builder pattern.
  factory UnstarMultipleArticlesRequestApplicationJson([
    void Function(UnstarMultipleArticlesRequestApplicationJsonBuilder)? b,
  ]) = _$UnstarMultipleArticlesRequestApplicationJson;

  // coverage:ignore-start
  const UnstarMultipleArticlesRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UnstarMultipleArticlesRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UnstarMultipleArticlesRequestApplicationJson.
  static Serializer<UnstarMultipleArticlesRequestApplicationJson> get serializer =>
      _$unstarMultipleArticlesRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UnstarMultipleArticlesRequestApplicationJsonBuilder b) {
    $UnstarMultipleArticlesRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UnstarMultipleArticlesRequestApplicationJsonBuilder b) {
    $UnstarMultipleArticlesRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EmptyOCS_OcsInterface {
  OCSMeta get meta;
  BuiltList<JsonObject> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EmptyOCS_OcsInterfaceBuilder].
  $EmptyOCS_OcsInterface rebuild(void Function($EmptyOCS_OcsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$EmptyOCS_OcsInterfaceBuilder].
  $EmptyOCS_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EmptyOCS_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EmptyOCS_OcsInterfaceBuilder b) {}
}

abstract class EmptyOCS_Ocs implements $EmptyOCS_OcsInterface, Built<EmptyOCS_Ocs, EmptyOCS_OcsBuilder> {
  /// Creates a new EmptyOCS_Ocs object using the builder pattern.
  factory EmptyOCS_Ocs([void Function(EmptyOCS_OcsBuilder)? b]) = _$EmptyOCS_Ocs;

  // coverage:ignore-start
  const EmptyOCS_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EmptyOCS_Ocs.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EmptyOCS_Ocs.
  static Serializer<EmptyOCS_Ocs> get serializer => _$emptyOCSOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EmptyOCS_OcsBuilder b) {
    $EmptyOCS_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EmptyOCS_OcsBuilder b) {
    $EmptyOCS_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $EmptyOCSInterface {
  EmptyOCS_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$EmptyOCSInterfaceBuilder].
  $EmptyOCSInterface rebuild(void Function($EmptyOCSInterfaceBuilder) updates);

  /// Converts the instance to a builder [$EmptyOCSInterfaceBuilder].
  $EmptyOCSInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($EmptyOCSInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($EmptyOCSInterfaceBuilder b) {}
}

abstract class EmptyOCS implements $EmptyOCSInterface, Built<EmptyOCS, EmptyOCSBuilder> {
  /// Creates a new EmptyOCS object using the builder pattern.
  factory EmptyOCS([void Function(EmptyOCSBuilder)? b]) = _$EmptyOCS;

  // coverage:ignore-start
  const EmptyOCS._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory EmptyOCS.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for EmptyOCS.
  static Serializer<EmptyOCS> get serializer => _$emptyOCSSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(EmptyOCSBuilder b) {
    $EmptyOCSInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(EmptyOCSBuilder b) {
    $EmptyOCSInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(const FullType(SupportedAPIVersions), SupportedAPIVersionsBuilder.new)
      ..add(SupportedAPIVersions.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(String)]), ListBuilder<String>.new)
      ..addBuilderFactory(const FullType(ListFeeds), ListFeedsBuilder.new)
      ..add(ListFeeds.serializer)
      ..addBuilderFactory(const FullType(Feed), FeedBuilder.new)
      ..add(Feed.serializer)
      ..addBuilderFactory(const FullType(Article), ArticleBuilder.new)
      ..add(Article.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Article)]), ListBuilder<Article>.new)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Feed)]), ListBuilder<Feed>.new)
      ..addBuilderFactory(const FullType(ListFolders), ListFoldersBuilder.new)
      ..add(ListFolders.serializer)
      ..addBuilderFactory(const FullType(Folder), FolderBuilder.new)
      ..add(Folder.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Folder)]), ListBuilder<Folder>.new)
      ..addBuilderFactory(const FullType(ListArticles), ListArticlesBuilder.new)
      ..add(ListArticles.serializer)
      ..addBuilderFactory(
        const FullType(ReadMultipleArticlesRequestApplicationJson),
        ReadMultipleArticlesRequestApplicationJsonBuilder.new,
      )
      ..add(ReadMultipleArticlesRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(int)]), ListBuilder<int>.new)
      ..addBuilderFactory(
        const FullType(UnreadMultipleArticlesRequestApplicationJson),
        UnreadMultipleArticlesRequestApplicationJsonBuilder.new,
      )
      ..add(UnreadMultipleArticlesRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(StarMultipleArticlesRequestApplicationJson),
        StarMultipleArticlesRequestApplicationJsonBuilder.new,
      )
      ..add(StarMultipleArticlesRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UnstarMultipleArticlesRequestApplicationJson),
        UnstarMultipleArticlesRequestApplicationJsonBuilder.new,
      )
      ..add(UnstarMultipleArticlesRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(const FullType(EmptyOCS), EmptyOCSBuilder.new)
      ..add(EmptyOCS.serializer)
      ..addBuilderFactory(const FullType(EmptyOCS_Ocs), EmptyOCS_OcsBuilder.new)
      ..add(EmptyOCS_Ocs.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(JsonObject)]), ListBuilder<JsonObject>.new))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i6.DynamiteDoubleSerializer())
      ..addPlugin(_i7.StandardJsonPlugin())
      ..addPlugin(const _i6.HeaderPlugin())
      ..addPlugin(const _i6.ContentStringPlugin()))
    .build();
// coverage:ignore-end
