// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// files_sharing Version: 0.0.1.
///
/// File sharing.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';
import 'dart:typed_data';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i5;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i6;

part 'files_sharing.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $DeletedShareapiClient deletedShareapi = $DeletedShareapiClient(this);

  late final $PublicPreviewClient publicPreview = $PublicPreviewClient(this);

  late final $RemoteClient remote = $RemoteClient(this);

  late final $ShareInfoClient shareInfo = $ShareInfoClient(this);

  late final $ShareapiClient shareapi = $ShareapiClient(this);

  late final $ShareesapiClient shareesapi = $ShareesapiClient(this);
}

class $DeletedShareapiClient {
  /// Creates a new `DynamiteClient` for deleted_shareapi requests.
  $DeletedShareapiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$index_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DeletedShareapiIndexResponseApplicationJson, void> $index_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(DeletedShareapiIndexResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of all deleted shares.
  ///
  /// Returns a `DynamiteRequest` backing the [index] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Deleted shares returned
  ///
  /// See:
  ///  * [index] for a method executing this request and parsing the response.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $index_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/files_sharing/api/v1/deletedshares';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of all deleted shares.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Deleted shares returned
  ///
  /// See:
  ///  * [$index_Request] for the request send by this method.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DeletedShareapiIndexResponseApplicationJson, void>> index({bool? oCSAPIRequest}) async {
    final _request = $index_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $index_Serializer();
    return _i1.ResponseConverter<DeletedShareapiIndexResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$undelete_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DeletedShareapiUndeleteResponseApplicationJson, void> $undelete_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(DeletedShareapiUndeleteResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Undelete a deleted share.
  ///
  /// Returns a `DynamiteRequest` backing the [undelete] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share undeleted successfully
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [undelete] for a method executing this request and parsing the response.
  ///  * [$undelete_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $undelete_Request({
    required String id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/deletedshares/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Undelete a deleted share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share undeleted successfully
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$undelete_Request] for the request send by this method.
  ///  * [$undelete_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DeletedShareapiUndeleteResponseApplicationJson, void>> undelete({
    required String id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $undelete_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $undelete_Serializer();
    return _i1.ResponseConverter<DeletedShareapiUndeleteResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $PublicPreviewClient {
  /// Creates a new `DynamiteClient` for public_preview requests.
  $PublicPreviewClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$directLink_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $directLink_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a direct link preview for a shared file.
  ///
  /// Returns a `DynamiteRequest` backing the [directLink] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [token] Token of the share.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 400: Getting preview is not possible
  ///   * 403: Getting preview is not allowed
  ///   * 404: Share or preview not found
  ///
  /// See:
  ///  * [directLink] for a method executing this request and parsing the response.
  ///  * [$directLink_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $directLink_Request({required String token}) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _parameters['token'] = __token;

    final _path = _i6.UriTemplate('/index.php/s/{token}/preview').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a direct link preview for a shared file.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [token] Token of the share.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 400: Getting preview is not possible
  ///   * 403: Getting preview is not allowed
  ///   * 404: Share or preview not found
  ///
  /// See:
  ///  * [$directLink_Request] for the request send by this method.
  ///  * [$directLink_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> directLink({required String token}) async {
    final _request = $directLink_Request(
      token: token,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $directLink_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getPreview_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getPreview_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a preview for a shared file.
  ///
  /// Returns a `DynamiteRequest` backing the [getPreview] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [token] Token of the share.
  ///   * [file] File in the share. Defaults to `""`.
  ///   * [x] Width of the preview. Defaults to `32`.
  ///   * [y] Height of the preview. Defaults to `32`.
  ///   * [a] Whether to not crop the preview. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 400: Getting preview is not possible
  ///   * 403: Getting preview is not allowed
  ///   * 404: Share or preview not found
  ///
  /// See:
  ///  * [getPreview] for a method executing this request and parsing the response.
  ///  * [$getPreview_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getPreview_Request({
    required String token,
    String? file,
    int? x,
    int? y,
    PublicPreviewGetPreviewA? a,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _parameters['token'] = __token;

    var __file = _$jsonSerializers.serialize(file, specifiedType: const FullType(String));
    __file ??= '';
    _parameters['file'] = __file;

    var __x = _$jsonSerializers.serialize(x, specifiedType: const FullType(int));
    __x ??= 32;
    _parameters['x'] = __x;

    var __y = _$jsonSerializers.serialize(y, specifiedType: const FullType(int));
    __y ??= 32;
    _parameters['y'] = __y;

    var __a = _$jsonSerializers.serialize(a, specifiedType: const FullType(PublicPreviewGetPreviewA));
    __a ??= 0;
    _parameters['a'] = __a;

    final _path =
        _i6.UriTemplate('/index.php/apps/files_sharing/publicpreview/{token}{?file*,x*,y*,a*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a preview for a shared file.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [token] Token of the share.
  ///   * [file] File in the share. Defaults to `""`.
  ///   * [x] Width of the preview. Defaults to `32`.
  ///   * [y] Height of the preview. Defaults to `32`.
  ///   * [a] Whether to not crop the preview. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 400: Getting preview is not possible
  ///   * 403: Getting preview is not allowed
  ///   * 404: Share or preview not found
  ///
  /// See:
  ///  * [$getPreview_Request] for the request send by this method.
  ///  * [$getPreview_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getPreview({
    required String token,
    String? file,
    int? x,
    int? y,
    PublicPreviewGetPreviewA? a,
  }) async {
    final _request = $getPreview_Request(
      token: token,
      file: file,
      x: x,
      y: y,
      a: a,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getPreview_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }
}

class $RemoteClient {
  /// Creates a new `DynamiteClient` for remote requests.
  $RemoteClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getShares_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RemoteGetSharesResponseApplicationJson, void> $getShares_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RemoteGetSharesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a list of accepted remote shares.
  ///
  /// Returns a `DynamiteRequest` backing the [getShares] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Accepted remote shares returned
  ///
  /// See:
  ///  * [getShares] for a method executing this request and parsing the response.
  ///  * [$getShares_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getShares_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/files_sharing/api/v1/remote_shares';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a list of accepted remote shares.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Accepted remote shares returned
  ///
  /// See:
  ///  * [$getShares_Request] for the request send by this method.
  ///  * [$getShares_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RemoteGetSharesResponseApplicationJson, void>> getShares({bool? oCSAPIRequest}) async {
    final _request = $getShares_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getShares_Serializer();
    return _i1.ResponseConverter<RemoteGetSharesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getOpenShares_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RemoteGetOpenSharesResponseApplicationJson, void> $getOpenShares_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RemoteGetOpenSharesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get list of pending remote shares.
  ///
  /// Returns a `DynamiteRequest` backing the [getOpenShares] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Pending remote shares returned
  ///
  /// See:
  ///  * [getOpenShares] for a method executing this request and parsing the response.
  ///  * [$getOpenShares_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getOpenShares_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/files_sharing/api/v1/remote_shares/pending';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get list of pending remote shares.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Pending remote shares returned
  ///
  /// See:
  ///  * [$getOpenShares_Request] for the request send by this method.
  ///  * [$getOpenShares_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RemoteGetOpenSharesResponseApplicationJson, void>> getOpenShares({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getOpenShares_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getOpenShares_Serializer();
    return _i1.ResponseConverter<RemoteGetOpenSharesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$acceptShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RemoteAcceptShareResponseApplicationJson, void> $acceptShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RemoteAcceptShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Accept a remote share.
  ///
  /// Returns a `DynamiteRequest` backing the [acceptShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share accepted successfully
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [acceptShare] for a method executing this request and parsing the response.
  ///  * [$acceptShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $acceptShare_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/remote_shares/pending/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Accept a remote share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share accepted successfully
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$acceptShare_Request] for the request send by this method.
  ///  * [$acceptShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RemoteAcceptShareResponseApplicationJson, void>> acceptShare({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $acceptShare_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $acceptShare_Serializer();
    return _i1.ResponseConverter<RemoteAcceptShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$declineShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RemoteDeclineShareResponseApplicationJson, void> $declineShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(RemoteDeclineShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Decline a remote share.
  ///
  /// Returns a `DynamiteRequest` backing the [declineShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share declined successfully
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [declineShare] for a method executing this request and parsing the response.
  ///  * [$declineShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $declineShare_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/remote_shares/pending/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Decline a remote share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share declined successfully
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$declineShare_Request] for the request send by this method.
  ///  * [$declineShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RemoteDeclineShareResponseApplicationJson, void>> declineShare({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $declineShare_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $declineShare_Serializer();
    return _i1.ResponseConverter<RemoteDeclineShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RemoteGetShareResponseApplicationJson, void> $getShare_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(RemoteGetShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get info of a remote share.
  ///
  /// Returns a `DynamiteRequest` backing the [getShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share returned
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [getShare] for a method executing this request and parsing the response.
  ///  * [$getShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getShare_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/remote_shares/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get info of a remote share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share returned
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$getShare_Request] for the request send by this method.
  ///  * [$getShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RemoteGetShareResponseApplicationJson, void>> getShare({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getShare_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getShare_Serializer();
    return _i1.ResponseConverter<RemoteGetShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$unshare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<RemoteUnshareResponseApplicationJson, void> $unshare_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(RemoteUnshareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404, 403},
      );

  /// Unshare a remote share.
  ///
  /// Returns a `DynamiteRequest` backing the [unshare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share unshared successfully
  ///   * 404: Share not found
  ///   * 403: Unsharing is not possible
  ///
  /// See:
  ///  * [unshare] for a method executing this request and parsing the response.
  ///  * [$unshare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $unshare_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/remote_shares/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Unshare a remote share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share unshared successfully
  ///   * 404: Share not found
  ///   * 403: Unsharing is not possible
  ///
  /// See:
  ///  * [$unshare_Request] for the request send by this method.
  ///  * [$unshare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<RemoteUnshareResponseApplicationJson, void>> unshare({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $unshare_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $unshare_Serializer();
    return _i1.ResponseConverter<RemoteUnshareResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $ShareInfoClient {
  /// Creates a new `DynamiteClient` for share_info requests.
  $ShareInfoClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$info_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareInfo, void> $info_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(ShareInfo),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the info about a share.
  ///
  /// Returns a `DynamiteRequest` backing the [info] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Share info returned
  ///   * 403: Getting share info is not allowed
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [info] for a method executing this request and parsing the response.
  ///  * [$info_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $info_Request({required ShareInfoInfoRequestApplicationJson $body}) {
    const _path = '/index.php/apps/files_sharing/shareinfo';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(ShareInfoInfoRequestApplicationJson)));
    return _request;
  }

  /// Get the info about a share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Share info returned
  ///   * 403: Getting share info is not allowed
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$info_Request] for the request send by this method.
  ///  * [$info_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareInfo, void>> info({required ShareInfoInfoRequestApplicationJson $body}) async {
    final _request = $info_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $info_Serializer();
    return _i1.ResponseConverter<ShareInfo, void>(_serializer).convert(_response);
  }
}

class $ShareapiClient {
  /// Creates a new `DynamiteClient` for shareapi requests.
  $ShareapiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getShares_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiGetSharesResponseApplicationJson, void> $getShares_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiGetSharesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get shares of the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [getShares] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [sharedWithMe] Only get shares with the current user. Defaults to `"false"`.
  ///   * [reshares] Only get shares by the current user and reshares. Defaults to `"false"`.
  ///   * [subfiles] Only get all shares in a folder. Defaults to `"false"`.
  ///   * [path] Get shares for a specific path. Defaults to `""`.
  ///   * [includeTags] Include tags in the share. Defaults to `"false"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Shares returned
  ///   * 404: The folder was not found or is inaccessible
  ///
  /// See:
  ///  * [getShares] for a method executing this request and parsing the response.
  ///  * [$getShares_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getShares_Request({
    String? sharedWithMe,
    String? reshares,
    String? subfiles,
    String? path,
    String? includeTags,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __sharedWithMe = _$jsonSerializers.serialize(sharedWithMe, specifiedType: const FullType(String));
    __sharedWithMe ??= 'false';
    _parameters['shared_with_me'] = __sharedWithMe;

    var __reshares = _$jsonSerializers.serialize(reshares, specifiedType: const FullType(String));
    __reshares ??= 'false';
    _parameters['reshares'] = __reshares;

    var __subfiles = _$jsonSerializers.serialize(subfiles, specifiedType: const FullType(String));
    __subfiles ??= 'false';
    _parameters['subfiles'] = __subfiles;

    var __path = _$jsonSerializers.serialize(path, specifiedType: const FullType(String));
    __path ??= '';
    _parameters['path'] = __path;

    var __includeTags = _$jsonSerializers.serialize(includeTags, specifiedType: const FullType(String));
    __includeTags ??= 'false';
    _parameters['include_tags'] = __includeTags;

    final _path = _i6.UriTemplate(
      '/ocs/v2.php/apps/files_sharing/api/v1/shares{?shared_with_me*,reshares*,subfiles*,path*,include_tags*}',
    ).expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get shares of the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [sharedWithMe] Only get shares with the current user. Defaults to `"false"`.
  ///   * [reshares] Only get shares by the current user and reshares. Defaults to `"false"`.
  ///   * [subfiles] Only get all shares in a folder. Defaults to `"false"`.
  ///   * [path] Get shares for a specific path. Defaults to `""`.
  ///   * [includeTags] Include tags in the share. Defaults to `"false"`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Shares returned
  ///   * 404: The folder was not found or is inaccessible
  ///
  /// See:
  ///  * [$getShares_Request] for the request send by this method.
  ///  * [$getShares_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiGetSharesResponseApplicationJson, void>> getShares({
    String? sharedWithMe,
    String? reshares,
    String? subfiles,
    String? path,
    String? includeTags,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getShares_Request(
      sharedWithMe: sharedWithMe,
      reshares: reshares,
      subfiles: subfiles,
      path: path,
      includeTags: includeTags,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getShares_Serializer();
    return _i1.ResponseConverter<ShareapiGetSharesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiCreateShareResponseApplicationJson, void> $createShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiCreateShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a share.
  ///
  /// Returns a `DynamiteRequest` backing the [createShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share created
  ///   * 400: Unknown share type
  ///   * 403: Creating the share is not allowed
  ///   * 404: Creating the share failed
  ///
  /// See:
  ///  * [createShare] for a method executing this request and parsing the response.
  ///  * [$createShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createShare_Request({
    bool? oCSAPIRequest,
    ShareapiCreateShareRequestApplicationJson? $body,
  }) {
    const _path = '/ocs/v2.php/apps/files_sharing/api/v1/shares';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(ShareapiCreateShareRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              ShareapiCreateShareRequestApplicationJson(),
              specifiedType: const FullType(ShareapiCreateShareRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Create a share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share created
  ///   * 400: Unknown share type
  ///   * 403: Creating the share is not allowed
  ///   * 404: Creating the share failed
  ///
  /// See:
  ///  * [$createShare_Request] for the request send by this method.
  ///  * [$createShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiCreateShareResponseApplicationJson, void>> createShare({
    bool? oCSAPIRequest,
    ShareapiCreateShareRequestApplicationJson? $body,
  }) async {
    final _request = $createShare_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createShare_Serializer();
    return _i1.ResponseConverter<ShareapiCreateShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getInheritedShares_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiGetInheritedSharesResponseApplicationJson, void> $getInheritedShares_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiGetInheritedSharesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all shares relative to a file, including parent folders shares rights.
  ///
  /// Returns a `DynamiteRequest` backing the [getInheritedShares] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [path] Path all shares will be relative to.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Shares returned
  ///   * 500
  ///   * 404: The given path is invalid
  ///
  /// See:
  ///  * [getInheritedShares] for a method executing this request and parsing the response.
  ///  * [$getInheritedShares_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getInheritedShares_Request({
    required String path,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __path = _$jsonSerializers.serialize(path, specifiedType: const FullType(String));
    _parameters['path'] = __path;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/shares/inherited{?path*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get all shares relative to a file, including parent folders shares rights.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [path] Path all shares will be relative to.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Shares returned
  ///   * 500
  ///   * 404: The given path is invalid
  ///
  /// See:
  ///  * [$getInheritedShares_Request] for the request send by this method.
  ///  * [$getInheritedShares_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiGetInheritedSharesResponseApplicationJson, void>> getInheritedShares({
    required String path,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getInheritedShares_Request(
      path: path,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getInheritedShares_Serializer();
    return _i1.ResponseConverter<ShareapiGetInheritedSharesResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$pendingShares_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiPendingSharesResponseApplicationJson, void> $pendingShares_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiPendingSharesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all shares that are still pending.
  ///
  /// Returns a `DynamiteRequest` backing the [pendingShares] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Pending shares returned
  ///
  /// See:
  ///  * [pendingShares] for a method executing this request and parsing the response.
  ///  * [$pendingShares_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $pendingShares_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/files_sharing/api/v1/shares/pending';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get all shares that are still pending.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Pending shares returned
  ///
  /// See:
  ///  * [$pendingShares_Request] for the request send by this method.
  ///  * [$pendingShares_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiPendingSharesResponseApplicationJson, void>> pendingShares({
    bool? oCSAPIRequest,
  }) async {
    final _request = $pendingShares_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $pendingShares_Serializer();
    return _i1.ResponseConverter<ShareapiPendingSharesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiGetShareResponseApplicationJson, void> $getShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiGetShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a specific share by id.
  ///
  /// Returns a `DynamiteRequest` backing the [getShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [includeTags] Include tags in the share. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share returned
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [getShare] for a method executing this request and parsing the response.
  ///  * [$getShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getShare_Request({
    required String id,
    ShareapiGetShareIncludeTags? includeTags,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    var __includeTags =
        _$jsonSerializers.serialize(includeTags, specifiedType: const FullType(ShareapiGetShareIncludeTags));
    __includeTags ??= 0;
    _parameters['include_tags'] = __includeTags;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/shares/{id}{?include_tags*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a specific share by id.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [includeTags] Include tags in the share. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share returned
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$getShare_Request] for the request send by this method.
  ///  * [$getShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiGetShareResponseApplicationJson, void>> getShare({
    required String id,
    ShareapiGetShareIncludeTags? includeTags,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getShare_Request(
      id: id,
      includeTags: includeTags,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getShare_Serializer();
    return _i1.ResponseConverter<ShareapiGetShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiUpdateShareResponseApplicationJson, void> $updateShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiUpdateShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update a share.
  ///
  /// Returns a `DynamiteRequest` backing the [updateShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share updated successfully
  ///   * 400: Share could not be updated because the requested changes are invalid
  ///   * 403: Missing permissions to update the share
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [updateShare] for a method executing this request and parsing the response.
  ///  * [$updateShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateShare_Request({
    required String id,
    bool? oCSAPIRequest,
    ShareapiUpdateShareRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/shares/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(ShareapiUpdateShareRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              ShareapiUpdateShareRequestApplicationJson(),
              specifiedType: const FullType(ShareapiUpdateShareRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Update a share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share updated successfully
  ///   * 400: Share could not be updated because the requested changes are invalid
  ///   * 403: Missing permissions to update the share
  ///   * 404: Share not found
  ///
  /// See:
  ///  * [$updateShare_Request] for the request send by this method.
  ///  * [$updateShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiUpdateShareResponseApplicationJson, void>> updateShare({
    required String id,
    bool? oCSAPIRequest,
    ShareapiUpdateShareRequestApplicationJson? $body,
  }) async {
    final _request = $updateShare_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateShare_Serializer();
    return _i1.ResponseConverter<ShareapiUpdateShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiDeleteShareResponseApplicationJson, void> $deleteShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiDeleteShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404, 403},
      );

  /// Delete a share.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share deleted successfully
  ///   * 404: Share not found
  ///   * 403: Missing permissions to delete the share
  ///
  /// See:
  ///  * [deleteShare] for a method executing this request and parsing the response.
  ///  * [$deleteShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteShare_Request({
    required String id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/shares/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete a share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share deleted successfully
  ///   * 404: Share not found
  ///   * 403: Missing permissions to delete the share
  ///
  /// See:
  ///  * [$deleteShare_Request] for the request send by this method.
  ///  * [$deleteShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiDeleteShareResponseApplicationJson, void>> deleteShare({
    required String id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteShare_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteShare_Serializer();
    return _i1.ResponseConverter<ShareapiDeleteShareResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$sendShareEmail_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiSendShareEmailResponseApplicationJson, void> $sendShareEmail_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiSendShareEmailResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {404, 403, 400, 200},
      );

  /// Send a mail notification again for a share. The mail_send option must be enabled for the given share.
  ///
  /// Returns a `DynamiteRequest` backing the [sendShareEmail] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] the share ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 404: Share not found
  ///   * 403: You are not allowed to send mail notifications
  ///   * 400: Invalid request or wrong password
  ///   * 200: The email notification was sent successfully
  ///
  /// See:
  ///  * [sendShareEmail] for a method executing this request and parsing the response.
  ///  * [$sendShareEmail_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $sendShareEmail_Request({
    required String id,
    bool? oCSAPIRequest,
    ShareapiSendShareEmailRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/shares/{id}/send-email').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(ShareapiSendShareEmailRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              ShareapiSendShareEmailRequestApplicationJson(),
              specifiedType: const FullType(ShareapiSendShareEmailRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Send a mail notification again for a share. The mail_send option must be enabled for the given share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] the share ID.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 404: Share not found
  ///   * 403: You are not allowed to send mail notifications
  ///   * 400: Invalid request or wrong password
  ///   * 200: The email notification was sent successfully
  ///
  /// See:
  ///  * [$sendShareEmail_Request] for the request send by this method.
  ///  * [$sendShareEmail_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiSendShareEmailResponseApplicationJson, void>> sendShareEmail({
    required String id,
    bool? oCSAPIRequest,
    ShareapiSendShareEmailRequestApplicationJson? $body,
  }) async {
    final _request = $sendShareEmail_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $sendShareEmail_Serializer();
    return _i1.ResponseConverter<ShareapiSendShareEmailResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$acceptShare_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareapiAcceptShareResponseApplicationJson, void> $acceptShare_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareapiAcceptShareResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404, 400},
      );

  /// Accept a share.
  ///
  /// Returns a `DynamiteRequest` backing the [acceptShare] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share accepted successfully
  ///   * 404: Share not found
  ///   * 400: Share could not be accepted
  ///
  /// See:
  ///  * [acceptShare] for a method executing this request and parsing the response.
  ///  * [$acceptShare_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $acceptShare_Request({
    required String id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/shares/pending/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Accept a share.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Share accepted successfully
  ///   * 404: Share not found
  ///   * 400: Share could not be accepted
  ///
  /// See:
  ///  * [$acceptShare_Request] for the request send by this method.
  ///  * [$acceptShare_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareapiAcceptShareResponseApplicationJson, void>> acceptShare({
    required String id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $acceptShare_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $acceptShare_Serializer();
    return _i1.ResponseConverter<ShareapiAcceptShareResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $ShareesapiClient {
  /// Creates a new `DynamiteClient` for shareesapi requests.
  $ShareesapiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$search_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareesapiSearchResponseApplicationJson, ShareesapiShareesapiSearchHeaders>
      $search_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(ShareesapiSearchResponseApplicationJson),
            headersType: const FullType(ShareesapiShareesapiSearchHeaders),
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Search for sharees.
  ///
  /// Returns a `DynamiteRequest` backing the [search] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [itemType] Limit to specific item types.
  ///   * [page] Page offset for searching. Defaults to `1`.
  ///   * [perPage] Limit amount of search results per page. Defaults to `200`.
  ///   * [shareType] Limit to specific share types.
  ///   * [lookup] If a global lookup should be performed too. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Sharees search result returned
  ///   * 400: Invalid search parameters
  ///
  /// See:
  ///  * [search] for a method executing this request and parsing the response.
  ///  * [$search_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $search_Request({
    String? search,
    String? itemType,
    int? page,
    int? perPage,
    ShareesapiSearchShareType? shareType,
    ShareesapiSearchLookup? lookup,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    __search ??= '';
    _parameters['search'] = __search;

    final __itemType = _$jsonSerializers.serialize(itemType, specifiedType: const FullType(String));
    _parameters['itemType'] = __itemType;

    var __page = _$jsonSerializers.serialize(page, specifiedType: const FullType(int));
    __page ??= 1;
    _parameters['page'] = __page;

    var __perPage = _$jsonSerializers.serialize(perPage, specifiedType: const FullType(int));
    __perPage ??= 200;
    _parameters['perPage'] = __perPage;

    final __shareType =
        _$jsonSerializers.serialize(shareType, specifiedType: const FullType(ShareesapiSearchShareType));
    _parameters['shareType'] = __shareType;

    var __lookup = _$jsonSerializers.serialize(lookup, specifiedType: const FullType(ShareesapiSearchLookup));
    __lookup ??= 0;
    _parameters['lookup'] = __lookup;

    final _path = _i6.UriTemplate(
      '/ocs/v2.php/apps/files_sharing/api/v1/sharees{?search*,itemType*,page*,perPage*,shareType*,lookup*}',
    ).expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Search for sharees.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for. Defaults to `""`.
  ///   * [itemType] Limit to specific item types.
  ///   * [page] Page offset for searching. Defaults to `1`.
  ///   * [perPage] Limit amount of search results per page. Defaults to `200`.
  ///   * [shareType] Limit to specific share types.
  ///   * [lookup] If a global lookup should be performed too. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Sharees search result returned
  ///   * 400: Invalid search parameters
  ///
  /// See:
  ///  * [$search_Request] for the request send by this method.
  ///  * [$search_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareesapiSearchResponseApplicationJson, ShareesapiShareesapiSearchHeaders>> search({
    String? search,
    String? itemType,
    int? page,
    int? perPage,
    ShareesapiSearchShareType? shareType,
    ShareesapiSearchLookup? lookup,
    bool? oCSAPIRequest,
  }) async {
    final _request = $search_Request(
      search: search,
      itemType: itemType,
      page: page,
      perPage: perPage,
      shareType: shareType,
      lookup: lookup,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $search_Serializer();
    return _i1.ResponseConverter<ShareesapiSearchResponseApplicationJson, ShareesapiShareesapiSearchHeaders>(
      _serializer,
    ).convert(_response);
  }

  /// Builds a serializer to parse the response of [$findRecommended_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ShareesapiFindRecommendedResponseApplicationJson, void> $findRecommended_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ShareesapiFindRecommendedResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Find recommended sharees.
  ///
  /// Returns a `DynamiteRequest` backing the [findRecommended] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [itemType] Limit to specific item types.
  ///   * [shareType] Limit to specific share types.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recommended sharees returned
  ///
  /// See:
  ///  * [findRecommended] for a method executing this request and parsing the response.
  ///  * [$findRecommended_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $findRecommended_Request({
    required String itemType,
    ShareesapiFindRecommendedShareType? shareType,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __itemType = _$jsonSerializers.serialize(itemType, specifiedType: const FullType(String));
    _parameters['itemType'] = __itemType;

    final __shareType =
        _$jsonSerializers.serialize(shareType, specifiedType: const FullType(ShareesapiFindRecommendedShareType));
    _parameters['shareType'] = __shareType;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/files_sharing/api/v1/sharees_recommended{?itemType*,shareType*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Find recommended sharees.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [itemType] Limit to specific item types.
  ///   * [shareType] Limit to specific share types.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Recommended sharees returned
  ///
  /// See:
  ///  * [$findRecommended_Request] for the request send by this method.
  ///  * [$findRecommended_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ShareesapiFindRecommendedResponseApplicationJson, void>> findRecommended({
    required String itemType,
    ShareesapiFindRecommendedShareType? shareType,
    bool? oCSAPIRequest,
  }) async {
    final _request = $findRecommended_Request(
      itemType: itemType,
      shareType: shareType,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $findRecommended_Serializer();
    return _i1.ResponseConverter<ShareesapiFindRecommendedResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DeletedShareInterface {
  String get id;
  @BuiltValueField(wireName: 'share_type')
  int get shareType;
  @BuiltValueField(wireName: 'uid_owner')
  String get uidOwner;
  @BuiltValueField(wireName: 'displayname_owner')
  String get displaynameOwner;
  int get permissions;
  int get stime;
  @BuiltValueField(wireName: 'uid_file_owner')
  String get uidFileOwner;
  @BuiltValueField(wireName: 'displayname_file_owner')
  String get displaynameFileOwner;
  String get path;
  @BuiltValueField(wireName: 'item_type')
  String get itemType;
  String get mimetype;
  int get storage;
  @BuiltValueField(wireName: 'item_source')
  int get itemSource;
  @BuiltValueField(wireName: 'file_source')
  int get fileSource;
  @BuiltValueField(wireName: 'file_parent')
  int get fileParent;
  @BuiltValueField(wireName: 'file_target')
  int get fileTarget;
  String? get expiration;
  @BuiltValueField(wireName: 'share_with')
  String? get shareWith;
  @BuiltValueField(wireName: 'share_with_displayname')
  String? get shareWithDisplayname;
  @BuiltValueField(wireName: 'share_with_link')
  String? get shareWithLink;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DeletedShareInterfaceBuilder].
  $DeletedShareInterface rebuild(void Function($DeletedShareInterfaceBuilder) updates);

  /// Converts the instance to a builder [$DeletedShareInterfaceBuilder].
  $DeletedShareInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DeletedShareInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DeletedShareInterfaceBuilder b) {}
}

abstract class DeletedShare implements $DeletedShareInterface, Built<DeletedShare, DeletedShareBuilder> {
  /// Creates a new DeletedShare object using the builder pattern.
  factory DeletedShare([void Function(DeletedShareBuilder)? b]) = _$DeletedShare;

  // coverage:ignore-start
  const DeletedShare._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DeletedShare.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DeletedShare.
  static Serializer<DeletedShare> get serializer => _$deletedShareSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DeletedShareBuilder b) {
    $DeletedShareInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DeletedShareBuilder b) {
    $DeletedShareInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DeletedShareapiIndexResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<DeletedShare> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DeletedShareapiIndexResponseApplicationJson_OcsInterfaceBuilder].
  $DeletedShareapiIndexResponseApplicationJson_OcsInterface rebuild(
    void Function($DeletedShareapiIndexResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DeletedShareapiIndexResponseApplicationJson_OcsInterfaceBuilder].
  $DeletedShareapiIndexResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DeletedShareapiIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DeletedShareapiIndexResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class DeletedShareapiIndexResponseApplicationJson_Ocs
    implements
        $DeletedShareapiIndexResponseApplicationJson_OcsInterface,
        Built<DeletedShareapiIndexResponseApplicationJson_Ocs, DeletedShareapiIndexResponseApplicationJson_OcsBuilder> {
  /// Creates a new DeletedShareapiIndexResponseApplicationJson_Ocs object using the builder pattern.
  factory DeletedShareapiIndexResponseApplicationJson_Ocs([
    void Function(DeletedShareapiIndexResponseApplicationJson_OcsBuilder)? b,
  ]) = _$DeletedShareapiIndexResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const DeletedShareapiIndexResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DeletedShareapiIndexResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DeletedShareapiIndexResponseApplicationJson_Ocs.
  static Serializer<DeletedShareapiIndexResponseApplicationJson_Ocs> get serializer =>
      _$deletedShareapiIndexResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DeletedShareapiIndexResponseApplicationJson_OcsBuilder b) {
    $DeletedShareapiIndexResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DeletedShareapiIndexResponseApplicationJson_OcsBuilder b) {
    $DeletedShareapiIndexResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DeletedShareapiIndexResponseApplicationJsonInterface {
  DeletedShareapiIndexResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DeletedShareapiIndexResponseApplicationJsonInterfaceBuilder].
  $DeletedShareapiIndexResponseApplicationJsonInterface rebuild(
    void Function($DeletedShareapiIndexResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DeletedShareapiIndexResponseApplicationJsonInterfaceBuilder].
  $DeletedShareapiIndexResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DeletedShareapiIndexResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DeletedShareapiIndexResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DeletedShareapiIndexResponseApplicationJson
    implements
        $DeletedShareapiIndexResponseApplicationJsonInterface,
        Built<DeletedShareapiIndexResponseApplicationJson, DeletedShareapiIndexResponseApplicationJsonBuilder> {
  /// Creates a new DeletedShareapiIndexResponseApplicationJson object using the builder pattern.
  factory DeletedShareapiIndexResponseApplicationJson([
    void Function(DeletedShareapiIndexResponseApplicationJsonBuilder)? b,
  ]) = _$DeletedShareapiIndexResponseApplicationJson;

  // coverage:ignore-start
  const DeletedShareapiIndexResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DeletedShareapiIndexResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DeletedShareapiIndexResponseApplicationJson.
  static Serializer<DeletedShareapiIndexResponseApplicationJson> get serializer =>
      _$deletedShareapiIndexResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DeletedShareapiIndexResponseApplicationJsonBuilder b) {
    $DeletedShareapiIndexResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DeletedShareapiIndexResponseApplicationJsonBuilder b) {
    $DeletedShareapiIndexResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DeletedShareapiUndeleteResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DeletedShareapiUndeleteResponseApplicationJson_OcsInterfaceBuilder].
  $DeletedShareapiUndeleteResponseApplicationJson_OcsInterface rebuild(
    void Function($DeletedShareapiUndeleteResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DeletedShareapiUndeleteResponseApplicationJson_OcsInterfaceBuilder].
  $DeletedShareapiUndeleteResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DeletedShareapiUndeleteResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DeletedShareapiUndeleteResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class DeletedShareapiUndeleteResponseApplicationJson_Ocs
    implements
        $DeletedShareapiUndeleteResponseApplicationJson_OcsInterface,
        Built<DeletedShareapiUndeleteResponseApplicationJson_Ocs,
            DeletedShareapiUndeleteResponseApplicationJson_OcsBuilder> {
  /// Creates a new DeletedShareapiUndeleteResponseApplicationJson_Ocs object using the builder pattern.
  factory DeletedShareapiUndeleteResponseApplicationJson_Ocs([
    void Function(DeletedShareapiUndeleteResponseApplicationJson_OcsBuilder)? b,
  ]) = _$DeletedShareapiUndeleteResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const DeletedShareapiUndeleteResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DeletedShareapiUndeleteResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DeletedShareapiUndeleteResponseApplicationJson_Ocs.
  static Serializer<DeletedShareapiUndeleteResponseApplicationJson_Ocs> get serializer =>
      _$deletedShareapiUndeleteResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DeletedShareapiUndeleteResponseApplicationJson_OcsBuilder b) {
    $DeletedShareapiUndeleteResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DeletedShareapiUndeleteResponseApplicationJson_OcsBuilder b) {
    $DeletedShareapiUndeleteResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DeletedShareapiUndeleteResponseApplicationJsonInterface {
  DeletedShareapiUndeleteResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DeletedShareapiUndeleteResponseApplicationJsonInterfaceBuilder].
  $DeletedShareapiUndeleteResponseApplicationJsonInterface rebuild(
    void Function($DeletedShareapiUndeleteResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DeletedShareapiUndeleteResponseApplicationJsonInterfaceBuilder].
  $DeletedShareapiUndeleteResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DeletedShareapiUndeleteResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DeletedShareapiUndeleteResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DeletedShareapiUndeleteResponseApplicationJson
    implements
        $DeletedShareapiUndeleteResponseApplicationJsonInterface,
        Built<DeletedShareapiUndeleteResponseApplicationJson, DeletedShareapiUndeleteResponseApplicationJsonBuilder> {
  /// Creates a new DeletedShareapiUndeleteResponseApplicationJson object using the builder pattern.
  factory DeletedShareapiUndeleteResponseApplicationJson([
    void Function(DeletedShareapiUndeleteResponseApplicationJsonBuilder)? b,
  ]) = _$DeletedShareapiUndeleteResponseApplicationJson;

  // coverage:ignore-start
  const DeletedShareapiUndeleteResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DeletedShareapiUndeleteResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DeletedShareapiUndeleteResponseApplicationJson.
  static Serializer<DeletedShareapiUndeleteResponseApplicationJson> get serializer =>
      _$deletedShareapiUndeleteResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DeletedShareapiUndeleteResponseApplicationJsonBuilder b) {
    $DeletedShareapiUndeleteResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DeletedShareapiUndeleteResponseApplicationJsonBuilder b) {
    $DeletedShareapiUndeleteResponseApplicationJsonInterface._validate(b);
  }
}

class PublicPreviewGetPreviewA extends EnumClass {
  const PublicPreviewGetPreviewA._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const PublicPreviewGetPreviewA $0 = _$publicPreviewGetPreviewA$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const PublicPreviewGetPreviewA $1 = _$publicPreviewGetPreviewA$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PublicPreviewGetPreviewA> get values => _$publicPreviewGetPreviewAValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PublicPreviewGetPreviewA valueOf(String name) => _$valueOfPublicPreviewGetPreviewA(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for PublicPreviewGetPreviewA.
  @BuiltValueSerializer(custom: true)
  static Serializer<PublicPreviewGetPreviewA> get serializer => const _$PublicPreviewGetPreviewASerializer();
}

class _$PublicPreviewGetPreviewASerializer implements PrimitiveSerializer<PublicPreviewGetPreviewA> {
  const _$PublicPreviewGetPreviewASerializer();

  static const Map<PublicPreviewGetPreviewA, Object> _toWire = <PublicPreviewGetPreviewA, Object>{
    PublicPreviewGetPreviewA.$0: 0,
    PublicPreviewGetPreviewA.$1: 1,
  };

  static const Map<Object, PublicPreviewGetPreviewA> _fromWire = <Object, PublicPreviewGetPreviewA>{
    0: PublicPreviewGetPreviewA.$0,
    1: PublicPreviewGetPreviewA.$1,
  };

  @override
  Iterable<Type> get types => const [PublicPreviewGetPreviewA];

  @override
  String get wireName => 'PublicPreviewGetPreviewA';

  @override
  Object serialize(
    Serializers serializers,
    PublicPreviewGetPreviewA object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PublicPreviewGetPreviewA deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $RemoteShareInterface {
  bool get accepted;
  @BuiltValueField(wireName: 'file_id')
  int? get fileId;
  int get id;
  String? get mimetype;
  String get mountpoint;
  int? get mtime;
  String get name;
  String get owner;
  int? get parent;
  int? get permissions;
  String get remote;
  @BuiltValueField(wireName: 'remote_id')
  String get remoteId;
  @BuiltValueField(wireName: 'share_token')
  String get shareToken;
  @BuiltValueField(wireName: 'share_type')
  int get shareType;
  String? get type;
  String get user;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteShareInterfaceBuilder].
  $RemoteShareInterface rebuild(void Function($RemoteShareInterfaceBuilder) updates);

  /// Converts the instance to a builder [$RemoteShareInterfaceBuilder].
  $RemoteShareInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteShareInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteShareInterfaceBuilder b) {}
}

abstract class RemoteShare implements $RemoteShareInterface, Built<RemoteShare, RemoteShareBuilder> {
  /// Creates a new RemoteShare object using the builder pattern.
  factory RemoteShare([void Function(RemoteShareBuilder)? b]) = _$RemoteShare;

  // coverage:ignore-start
  const RemoteShare._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteShare.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteShare.
  static Serializer<RemoteShare> get serializer => _$remoteShareSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteShareBuilder b) {
    $RemoteShareInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteShareBuilder b) {
    $RemoteShareInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteGetSharesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<RemoteShare> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteGetSharesResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteGetSharesResponseApplicationJson_OcsInterface rebuild(
    void Function($RemoteGetSharesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteGetSharesResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteGetSharesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteGetSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteGetSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class RemoteGetSharesResponseApplicationJson_Ocs
    implements
        $RemoteGetSharesResponseApplicationJson_OcsInterface,
        Built<RemoteGetSharesResponseApplicationJson_Ocs, RemoteGetSharesResponseApplicationJson_OcsBuilder> {
  /// Creates a new RemoteGetSharesResponseApplicationJson_Ocs object using the builder pattern.
  factory RemoteGetSharesResponseApplicationJson_Ocs([
    void Function(RemoteGetSharesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$RemoteGetSharesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const RemoteGetSharesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteGetSharesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteGetSharesResponseApplicationJson_Ocs.
  static Serializer<RemoteGetSharesResponseApplicationJson_Ocs> get serializer =>
      _$remoteGetSharesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteGetSharesResponseApplicationJson_OcsBuilder b) {
    $RemoteGetSharesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteGetSharesResponseApplicationJson_OcsBuilder b) {
    $RemoteGetSharesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteGetSharesResponseApplicationJsonInterface {
  RemoteGetSharesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteGetSharesResponseApplicationJsonInterfaceBuilder].
  $RemoteGetSharesResponseApplicationJsonInterface rebuild(
    void Function($RemoteGetSharesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteGetSharesResponseApplicationJsonInterfaceBuilder].
  $RemoteGetSharesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteGetSharesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteGetSharesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class RemoteGetSharesResponseApplicationJson
    implements
        $RemoteGetSharesResponseApplicationJsonInterface,
        Built<RemoteGetSharesResponseApplicationJson, RemoteGetSharesResponseApplicationJsonBuilder> {
  /// Creates a new RemoteGetSharesResponseApplicationJson object using the builder pattern.
  factory RemoteGetSharesResponseApplicationJson([void Function(RemoteGetSharesResponseApplicationJsonBuilder)? b]) =
      _$RemoteGetSharesResponseApplicationJson;

  // coverage:ignore-start
  const RemoteGetSharesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteGetSharesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteGetSharesResponseApplicationJson.
  static Serializer<RemoteGetSharesResponseApplicationJson> get serializer =>
      _$remoteGetSharesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteGetSharesResponseApplicationJsonBuilder b) {
    $RemoteGetSharesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteGetSharesResponseApplicationJsonBuilder b) {
    $RemoteGetSharesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteGetOpenSharesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<RemoteShare> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteGetOpenSharesResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteGetOpenSharesResponseApplicationJson_OcsInterface rebuild(
    void Function($RemoteGetOpenSharesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteGetOpenSharesResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteGetOpenSharesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteGetOpenSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteGetOpenSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class RemoteGetOpenSharesResponseApplicationJson_Ocs
    implements
        $RemoteGetOpenSharesResponseApplicationJson_OcsInterface,
        Built<RemoteGetOpenSharesResponseApplicationJson_Ocs, RemoteGetOpenSharesResponseApplicationJson_OcsBuilder> {
  /// Creates a new RemoteGetOpenSharesResponseApplicationJson_Ocs object using the builder pattern.
  factory RemoteGetOpenSharesResponseApplicationJson_Ocs([
    void Function(RemoteGetOpenSharesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$RemoteGetOpenSharesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const RemoteGetOpenSharesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteGetOpenSharesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteGetOpenSharesResponseApplicationJson_Ocs.
  static Serializer<RemoteGetOpenSharesResponseApplicationJson_Ocs> get serializer =>
      _$remoteGetOpenSharesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteGetOpenSharesResponseApplicationJson_OcsBuilder b) {
    $RemoteGetOpenSharesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteGetOpenSharesResponseApplicationJson_OcsBuilder b) {
    $RemoteGetOpenSharesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteGetOpenSharesResponseApplicationJsonInterface {
  RemoteGetOpenSharesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteGetOpenSharesResponseApplicationJsonInterfaceBuilder].
  $RemoteGetOpenSharesResponseApplicationJsonInterface rebuild(
    void Function($RemoteGetOpenSharesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteGetOpenSharesResponseApplicationJsonInterfaceBuilder].
  $RemoteGetOpenSharesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteGetOpenSharesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteGetOpenSharesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class RemoteGetOpenSharesResponseApplicationJson
    implements
        $RemoteGetOpenSharesResponseApplicationJsonInterface,
        Built<RemoteGetOpenSharesResponseApplicationJson, RemoteGetOpenSharesResponseApplicationJsonBuilder> {
  /// Creates a new RemoteGetOpenSharesResponseApplicationJson object using the builder pattern.
  factory RemoteGetOpenSharesResponseApplicationJson([
    void Function(RemoteGetOpenSharesResponseApplicationJsonBuilder)? b,
  ]) = _$RemoteGetOpenSharesResponseApplicationJson;

  // coverage:ignore-start
  const RemoteGetOpenSharesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteGetOpenSharesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteGetOpenSharesResponseApplicationJson.
  static Serializer<RemoteGetOpenSharesResponseApplicationJson> get serializer =>
      _$remoteGetOpenSharesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteGetOpenSharesResponseApplicationJsonBuilder b) {
    $RemoteGetOpenSharesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteGetOpenSharesResponseApplicationJsonBuilder b) {
    $RemoteGetOpenSharesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteAcceptShareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteAcceptShareResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteAcceptShareResponseApplicationJson_OcsInterface rebuild(
    void Function($RemoteAcceptShareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteAcceptShareResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteAcceptShareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteAcceptShareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteAcceptShareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class RemoteAcceptShareResponseApplicationJson_Ocs
    implements
        $RemoteAcceptShareResponseApplicationJson_OcsInterface,
        Built<RemoteAcceptShareResponseApplicationJson_Ocs, RemoteAcceptShareResponseApplicationJson_OcsBuilder> {
  /// Creates a new RemoteAcceptShareResponseApplicationJson_Ocs object using the builder pattern.
  factory RemoteAcceptShareResponseApplicationJson_Ocs([
    void Function(RemoteAcceptShareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$RemoteAcceptShareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const RemoteAcceptShareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteAcceptShareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteAcceptShareResponseApplicationJson_Ocs.
  static Serializer<RemoteAcceptShareResponseApplicationJson_Ocs> get serializer =>
      _$remoteAcceptShareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteAcceptShareResponseApplicationJson_OcsBuilder b) {
    $RemoteAcceptShareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteAcceptShareResponseApplicationJson_OcsBuilder b) {
    $RemoteAcceptShareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteAcceptShareResponseApplicationJsonInterface {
  RemoteAcceptShareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteAcceptShareResponseApplicationJsonInterfaceBuilder].
  $RemoteAcceptShareResponseApplicationJsonInterface rebuild(
    void Function($RemoteAcceptShareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteAcceptShareResponseApplicationJsonInterfaceBuilder].
  $RemoteAcceptShareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteAcceptShareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteAcceptShareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class RemoteAcceptShareResponseApplicationJson
    implements
        $RemoteAcceptShareResponseApplicationJsonInterface,
        Built<RemoteAcceptShareResponseApplicationJson, RemoteAcceptShareResponseApplicationJsonBuilder> {
  /// Creates a new RemoteAcceptShareResponseApplicationJson object using the builder pattern.
  factory RemoteAcceptShareResponseApplicationJson([
    void Function(RemoteAcceptShareResponseApplicationJsonBuilder)? b,
  ]) = _$RemoteAcceptShareResponseApplicationJson;

  // coverage:ignore-start
  const RemoteAcceptShareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteAcceptShareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteAcceptShareResponseApplicationJson.
  static Serializer<RemoteAcceptShareResponseApplicationJson> get serializer =>
      _$remoteAcceptShareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteAcceptShareResponseApplicationJsonBuilder b) {
    $RemoteAcceptShareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteAcceptShareResponseApplicationJsonBuilder b) {
    $RemoteAcceptShareResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteDeclineShareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteDeclineShareResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteDeclineShareResponseApplicationJson_OcsInterface rebuild(
    void Function($RemoteDeclineShareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteDeclineShareResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteDeclineShareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteDeclineShareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteDeclineShareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class RemoteDeclineShareResponseApplicationJson_Ocs
    implements
        $RemoteDeclineShareResponseApplicationJson_OcsInterface,
        Built<RemoteDeclineShareResponseApplicationJson_Ocs, RemoteDeclineShareResponseApplicationJson_OcsBuilder> {
  /// Creates a new RemoteDeclineShareResponseApplicationJson_Ocs object using the builder pattern.
  factory RemoteDeclineShareResponseApplicationJson_Ocs([
    void Function(RemoteDeclineShareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$RemoteDeclineShareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const RemoteDeclineShareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteDeclineShareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteDeclineShareResponseApplicationJson_Ocs.
  static Serializer<RemoteDeclineShareResponseApplicationJson_Ocs> get serializer =>
      _$remoteDeclineShareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteDeclineShareResponseApplicationJson_OcsBuilder b) {
    $RemoteDeclineShareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteDeclineShareResponseApplicationJson_OcsBuilder b) {
    $RemoteDeclineShareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteDeclineShareResponseApplicationJsonInterface {
  RemoteDeclineShareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteDeclineShareResponseApplicationJsonInterfaceBuilder].
  $RemoteDeclineShareResponseApplicationJsonInterface rebuild(
    void Function($RemoteDeclineShareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteDeclineShareResponseApplicationJsonInterfaceBuilder].
  $RemoteDeclineShareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteDeclineShareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteDeclineShareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class RemoteDeclineShareResponseApplicationJson
    implements
        $RemoteDeclineShareResponseApplicationJsonInterface,
        Built<RemoteDeclineShareResponseApplicationJson, RemoteDeclineShareResponseApplicationJsonBuilder> {
  /// Creates a new RemoteDeclineShareResponseApplicationJson object using the builder pattern.
  factory RemoteDeclineShareResponseApplicationJson([
    void Function(RemoteDeclineShareResponseApplicationJsonBuilder)? b,
  ]) = _$RemoteDeclineShareResponseApplicationJson;

  // coverage:ignore-start
  const RemoteDeclineShareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteDeclineShareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteDeclineShareResponseApplicationJson.
  static Serializer<RemoteDeclineShareResponseApplicationJson> get serializer =>
      _$remoteDeclineShareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteDeclineShareResponseApplicationJsonBuilder b) {
    $RemoteDeclineShareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteDeclineShareResponseApplicationJsonBuilder b) {
    $RemoteDeclineShareResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteGetShareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  RemoteShare get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteGetShareResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteGetShareResponseApplicationJson_OcsInterface rebuild(
    void Function($RemoteGetShareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteGetShareResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteGetShareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteGetShareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteGetShareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class RemoteGetShareResponseApplicationJson_Ocs
    implements
        $RemoteGetShareResponseApplicationJson_OcsInterface,
        Built<RemoteGetShareResponseApplicationJson_Ocs, RemoteGetShareResponseApplicationJson_OcsBuilder> {
  /// Creates a new RemoteGetShareResponseApplicationJson_Ocs object using the builder pattern.
  factory RemoteGetShareResponseApplicationJson_Ocs([
    void Function(RemoteGetShareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$RemoteGetShareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const RemoteGetShareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteGetShareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteGetShareResponseApplicationJson_Ocs.
  static Serializer<RemoteGetShareResponseApplicationJson_Ocs> get serializer =>
      _$remoteGetShareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteGetShareResponseApplicationJson_OcsBuilder b) {
    $RemoteGetShareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteGetShareResponseApplicationJson_OcsBuilder b) {
    $RemoteGetShareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteGetShareResponseApplicationJsonInterface {
  RemoteGetShareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteGetShareResponseApplicationJsonInterfaceBuilder].
  $RemoteGetShareResponseApplicationJsonInterface rebuild(
    void Function($RemoteGetShareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteGetShareResponseApplicationJsonInterfaceBuilder].
  $RemoteGetShareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteGetShareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteGetShareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class RemoteGetShareResponseApplicationJson
    implements
        $RemoteGetShareResponseApplicationJsonInterface,
        Built<RemoteGetShareResponseApplicationJson, RemoteGetShareResponseApplicationJsonBuilder> {
  /// Creates a new RemoteGetShareResponseApplicationJson object using the builder pattern.
  factory RemoteGetShareResponseApplicationJson([void Function(RemoteGetShareResponseApplicationJsonBuilder)? b]) =
      _$RemoteGetShareResponseApplicationJson;

  // coverage:ignore-start
  const RemoteGetShareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteGetShareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteGetShareResponseApplicationJson.
  static Serializer<RemoteGetShareResponseApplicationJson> get serializer =>
      _$remoteGetShareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteGetShareResponseApplicationJsonBuilder b) {
    $RemoteGetShareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteGetShareResponseApplicationJsonBuilder b) {
    $RemoteGetShareResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteUnshareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteUnshareResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteUnshareResponseApplicationJson_OcsInterface rebuild(
    void Function($RemoteUnshareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteUnshareResponseApplicationJson_OcsInterfaceBuilder].
  $RemoteUnshareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteUnshareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteUnshareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class RemoteUnshareResponseApplicationJson_Ocs
    implements
        $RemoteUnshareResponseApplicationJson_OcsInterface,
        Built<RemoteUnshareResponseApplicationJson_Ocs, RemoteUnshareResponseApplicationJson_OcsBuilder> {
  /// Creates a new RemoteUnshareResponseApplicationJson_Ocs object using the builder pattern.
  factory RemoteUnshareResponseApplicationJson_Ocs([
    void Function(RemoteUnshareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$RemoteUnshareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const RemoteUnshareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteUnshareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteUnshareResponseApplicationJson_Ocs.
  static Serializer<RemoteUnshareResponseApplicationJson_Ocs> get serializer =>
      _$remoteUnshareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteUnshareResponseApplicationJson_OcsBuilder b) {
    $RemoteUnshareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteUnshareResponseApplicationJson_OcsBuilder b) {
    $RemoteUnshareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RemoteUnshareResponseApplicationJsonInterface {
  RemoteUnshareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RemoteUnshareResponseApplicationJsonInterfaceBuilder].
  $RemoteUnshareResponseApplicationJsonInterface rebuild(
    void Function($RemoteUnshareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RemoteUnshareResponseApplicationJsonInterfaceBuilder].
  $RemoteUnshareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RemoteUnshareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RemoteUnshareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class RemoteUnshareResponseApplicationJson
    implements
        $RemoteUnshareResponseApplicationJsonInterface,
        Built<RemoteUnshareResponseApplicationJson, RemoteUnshareResponseApplicationJsonBuilder> {
  /// Creates a new RemoteUnshareResponseApplicationJson object using the builder pattern.
  factory RemoteUnshareResponseApplicationJson([void Function(RemoteUnshareResponseApplicationJsonBuilder)? b]) =
      _$RemoteUnshareResponseApplicationJson;

  // coverage:ignore-start
  const RemoteUnshareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RemoteUnshareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RemoteUnshareResponseApplicationJson.
  static Serializer<RemoteUnshareResponseApplicationJson> get serializer =>
      _$remoteUnshareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RemoteUnshareResponseApplicationJsonBuilder b) {
    $RemoteUnshareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RemoteUnshareResponseApplicationJsonBuilder b) {
    $RemoteUnshareResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareInfoInfoRequestApplicationJsonInterface {
  static final _$depth = _$jsonSerializers.deserialize(
    -1,
    specifiedType: const FullType(int),
  )! as int;

  /// Token of the share.
  String get t;

  /// Password of the share.
  String? get password;

  /// Subdirectory to get info about.
  String? get dir;

  /// Maximum depth to get info about.
  int get depth;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareInfoInfoRequestApplicationJsonInterfaceBuilder].
  $ShareInfoInfoRequestApplicationJsonInterface rebuild(
    void Function($ShareInfoInfoRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareInfoInfoRequestApplicationJsonInterfaceBuilder].
  $ShareInfoInfoRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareInfoInfoRequestApplicationJsonInterfaceBuilder b) {
    b.depth = _$depth;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareInfoInfoRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareInfoInfoRequestApplicationJson
    implements
        $ShareInfoInfoRequestApplicationJsonInterface,
        Built<ShareInfoInfoRequestApplicationJson, ShareInfoInfoRequestApplicationJsonBuilder> {
  /// Creates a new ShareInfoInfoRequestApplicationJson object using the builder pattern.
  factory ShareInfoInfoRequestApplicationJson([void Function(ShareInfoInfoRequestApplicationJsonBuilder)? b]) =
      _$ShareInfoInfoRequestApplicationJson;

  // coverage:ignore-start
  const ShareInfoInfoRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareInfoInfoRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareInfoInfoRequestApplicationJson.
  static Serializer<ShareInfoInfoRequestApplicationJson> get serializer =>
      _$shareInfoInfoRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareInfoInfoRequestApplicationJsonBuilder b) {
    $ShareInfoInfoRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareInfoInfoRequestApplicationJsonBuilder b) {
    $ShareInfoInfoRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareInfoInterface {
  int get id;
  int get parentId;
  int get mtime;
  String get name;
  int get permissions;
  String get mimetype;
  num get size;
  String get type;
  String get etag;
  BuiltList<BuiltMap<String, JsonObject>>? get children;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareInfoInterfaceBuilder].
  $ShareInfoInterface rebuild(void Function($ShareInfoInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareInfoInterfaceBuilder].
  $ShareInfoInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareInfoInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareInfoInterfaceBuilder b) {}
}

abstract class ShareInfo implements $ShareInfoInterface, Built<ShareInfo, ShareInfoBuilder> {
  /// Creates a new ShareInfo object using the builder pattern.
  factory ShareInfo([void Function(ShareInfoBuilder)? b]) = _$ShareInfo;

  // coverage:ignore-start
  const ShareInfo._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareInfo.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareInfo.
  static Serializer<ShareInfo> get serializer => _$shareInfoSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareInfoBuilder b) {
    $ShareInfoInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareInfoBuilder b) {
    $ShareInfoInterface._validate(b);
  }
}

class Share_HideDownload extends EnumClass {
  const Share_HideDownload._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const Share_HideDownload $0 = _$shareHideDownload$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const Share_HideDownload $1 = _$shareHideDownload$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Share_HideDownload> get values => _$shareHideDownloadValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Share_HideDownload valueOf(String name) => _$valueOfShare_HideDownload(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for Share_HideDownload.
  @BuiltValueSerializer(custom: true)
  static Serializer<Share_HideDownload> get serializer => const _$Share_HideDownloadSerializer();
}

class _$Share_HideDownloadSerializer implements PrimitiveSerializer<Share_HideDownload> {
  const _$Share_HideDownloadSerializer();

  static const Map<Share_HideDownload, Object> _toWire = <Share_HideDownload, Object>{
    Share_HideDownload.$0: 0,
    Share_HideDownload.$1: 1,
  };

  static const Map<Object, Share_HideDownload> _fromWire = <Object, Share_HideDownload>{
    0: Share_HideDownload.$0,
    1: Share_HideDownload.$1,
  };

  @override
  Iterable<Type> get types => const [Share_HideDownload];

  @override
  String get wireName => 'Share_HideDownload';

  @override
  Object serialize(
    Serializers serializers,
    Share_HideDownload object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Share_HideDownload deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class Share_ItemType extends EnumClass {
  const Share_ItemType._(super.name);

  /// `file`
  static const Share_ItemType file = _$shareItemTypeFile;

  /// `folder`
  static const Share_ItemType folder = _$shareItemTypeFolder;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Share_ItemType> get values => _$shareItemTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Share_ItemType valueOf(String name) => _$valueOfShare_ItemType(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for Share_ItemType.
  @BuiltValueSerializer(custom: true)
  static Serializer<Share_ItemType> get serializer => const _$Share_ItemTypeSerializer();
}

class _$Share_ItemTypeSerializer implements PrimitiveSerializer<Share_ItemType> {
  const _$Share_ItemTypeSerializer();

  static const Map<Share_ItemType, Object> _toWire = <Share_ItemType, Object>{
    Share_ItemType.file: 'file',
    Share_ItemType.folder: 'folder',
  };

  static const Map<Object, Share_ItemType> _fromWire = <Object, Share_ItemType>{
    'file': Share_ItemType.file,
    'folder': Share_ItemType.folder,
  };

  @override
  Iterable<Type> get types => const [Share_ItemType];

  @override
  String get wireName => 'Share_ItemType';

  @override
  Object serialize(
    Serializers serializers,
    Share_ItemType object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Share_ItemType deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class Share_MailSend extends EnumClass {
  const Share_MailSend._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const Share_MailSend $0 = _$shareMailSend$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const Share_MailSend $1 = _$shareMailSend$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<Share_MailSend> get values => _$shareMailSendValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static Share_MailSend valueOf(String name) => _$valueOfShare_MailSend(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for Share_MailSend.
  @BuiltValueSerializer(custom: true)
  static Serializer<Share_MailSend> get serializer => const _$Share_MailSendSerializer();
}

class _$Share_MailSendSerializer implements PrimitiveSerializer<Share_MailSend> {
  const _$Share_MailSendSerializer();

  static const Map<Share_MailSend, Object> _toWire = <Share_MailSend, Object>{
    Share_MailSend.$0: 0,
    Share_MailSend.$1: 1,
  };

  static const Map<Object, Share_MailSend> _fromWire = <Object, Share_MailSend>{
    0: Share_MailSend.$0,
    1: Share_MailSend.$1,
  };

  @override
  Iterable<Type> get types => const [Share_MailSend];

  @override
  String get wireName => 'Share_MailSend';

  @override
  Object serialize(
    Serializers serializers,
    Share_MailSend object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  Share_MailSend deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $Share_StatusInterface {
  int? get clearAt;
  String? get icon;
  String? get message;
  String get status;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Share_StatusInterfaceBuilder].
  $Share_StatusInterface rebuild(void Function($Share_StatusInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Share_StatusInterfaceBuilder].
  $Share_StatusInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Share_StatusInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Share_StatusInterfaceBuilder b) {}
}

abstract class Share_Status implements $Share_StatusInterface, Built<Share_Status, Share_StatusBuilder> {
  /// Creates a new Share_Status object using the builder pattern.
  factory Share_Status([void Function(Share_StatusBuilder)? b]) = _$Share_Status;

  // coverage:ignore-start
  const Share_Status._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Share_Status.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Share_Status.
  static Serializer<Share_Status> get serializer => _$shareStatusSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Share_StatusBuilder b) {
    $Share_StatusInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Share_StatusBuilder b) {
    $Share_StatusInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareInterface {
  String? get attributes;
  @BuiltValueField(wireName: 'can_delete')
  bool get canDelete;
  @BuiltValueField(wireName: 'can_edit')
  bool get canEdit;
  @BuiltValueField(wireName: 'displayname_file_owner')
  String get displaynameFileOwner;
  @BuiltValueField(wireName: 'displayname_owner')
  String get displaynameOwner;
  String? get expiration;
  @BuiltValueField(wireName: 'file_parent')
  int get fileParent;
  @BuiltValueField(wireName: 'file_source')
  int get fileSource;
  @BuiltValueField(wireName: 'file_target')
  String get fileTarget;
  @BuiltValueField(wireName: 'has_preview')
  bool get hasPreview;
  @BuiltValueField(wireName: 'hide_download')
  Share_HideDownload get hideDownload;
  String get id;
  @BuiltValueField(wireName: 'item_mtime')
  int get itemMtime;
  @BuiltValueField(wireName: 'item_permissions')
  int? get itemPermissions;
  @BuiltValueField(wireName: 'item_size')
  num get itemSize;
  @BuiltValueField(wireName: 'item_source')
  int get itemSource;
  @BuiltValueField(wireName: 'item_type')
  Share_ItemType get itemType;
  String? get label;
  @BuiltValueField(wireName: 'mail_send')
  Share_MailSend get mailSend;
  String get mimetype;
  String get note;
  JsonObject? get parent;
  String? get password;
  @BuiltValueField(wireName: 'password_expiration_time')
  String? get passwordExpirationTime;
  String? get path;
  int get permissions;
  @BuiltValueField(wireName: 'send_password_by_talk')
  bool? get sendPasswordByTalk;
  @BuiltValueField(wireName: 'share_type')
  int get shareType;
  @BuiltValueField(wireName: 'share_with')
  String? get shareWith;
  @BuiltValueField(wireName: 'share_with_avatar')
  String? get shareWithAvatar;
  @BuiltValueField(wireName: 'share_with_displayname')
  String? get shareWithDisplayname;
  @BuiltValueField(wireName: 'share_with_displayname_unique')
  String? get shareWithDisplaynameUnique;
  @BuiltValueField(wireName: 'share_with_link')
  String? get shareWithLink;
  Share_Status? get status;
  int get stime;
  int get storage;
  @BuiltValueField(wireName: 'storage_id')
  String get storageId;
  String? get token;
  @BuiltValueField(wireName: 'uid_file_owner')
  String get uidFileOwner;
  @BuiltValueField(wireName: 'uid_owner')
  String get uidOwner;
  String? get url;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareInterfaceBuilder].
  $ShareInterface rebuild(void Function($ShareInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareInterfaceBuilder].
  $ShareInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareInterfaceBuilder b) {}
}

abstract class Share implements $ShareInterface, Built<Share, ShareBuilder> {
  /// Creates a new Share object using the builder pattern.
  factory Share([void Function(ShareBuilder)? b]) = _$Share;

  // coverage:ignore-start
  const Share._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Share.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Share.
  static Serializer<Share> get serializer => _$shareSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareBuilder b) {
    $ShareInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareBuilder b) {
    $ShareInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiGetSharesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Share> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiGetSharesResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiGetSharesResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiGetSharesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiGetSharesResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiGetSharesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiGetSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiGetSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiGetSharesResponseApplicationJson_Ocs
    implements
        $ShareapiGetSharesResponseApplicationJson_OcsInterface,
        Built<ShareapiGetSharesResponseApplicationJson_Ocs, ShareapiGetSharesResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiGetSharesResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiGetSharesResponseApplicationJson_Ocs([
    void Function(ShareapiGetSharesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiGetSharesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiGetSharesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiGetSharesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiGetSharesResponseApplicationJson_Ocs.
  static Serializer<ShareapiGetSharesResponseApplicationJson_Ocs> get serializer =>
      _$shareapiGetSharesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiGetSharesResponseApplicationJson_OcsBuilder b) {
    $ShareapiGetSharesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiGetSharesResponseApplicationJson_OcsBuilder b) {
    $ShareapiGetSharesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiGetSharesResponseApplicationJsonInterface {
  ShareapiGetSharesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiGetSharesResponseApplicationJsonInterfaceBuilder].
  $ShareapiGetSharesResponseApplicationJsonInterface rebuild(
    void Function($ShareapiGetSharesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiGetSharesResponseApplicationJsonInterfaceBuilder].
  $ShareapiGetSharesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiGetSharesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiGetSharesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiGetSharesResponseApplicationJson
    implements
        $ShareapiGetSharesResponseApplicationJsonInterface,
        Built<ShareapiGetSharesResponseApplicationJson, ShareapiGetSharesResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiGetSharesResponseApplicationJson object using the builder pattern.
  factory ShareapiGetSharesResponseApplicationJson([
    void Function(ShareapiGetSharesResponseApplicationJsonBuilder)? b,
  ]) = _$ShareapiGetSharesResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiGetSharesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiGetSharesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiGetSharesResponseApplicationJson.
  static Serializer<ShareapiGetSharesResponseApplicationJson> get serializer =>
      _$shareapiGetSharesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiGetSharesResponseApplicationJsonBuilder b) {
    $ShareapiGetSharesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiGetSharesResponseApplicationJsonBuilder b) {
    $ShareapiGetSharesResponseApplicationJsonInterface._validate(b);
  }
}

/// Send a mail to the recipient.
class ShareapiCreateShareRequestApplicationJson_SendMail extends EnumClass {
  const ShareapiCreateShareRequestApplicationJson_SendMail._(super.name);

  /// `false`
  @BuiltValueEnumConst(wireName: 'false')
  static const ShareapiCreateShareRequestApplicationJson_SendMail $false =
      _$shareapiCreateShareRequestApplicationJsonSendMail$false;

  /// `true`
  @BuiltValueEnumConst(wireName: 'true')
  static const ShareapiCreateShareRequestApplicationJson_SendMail $true =
      _$shareapiCreateShareRequestApplicationJsonSendMail$true;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ShareapiCreateShareRequestApplicationJson_SendMail> get values =>
      _$shareapiCreateShareRequestApplicationJsonSendMailValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ShareapiCreateShareRequestApplicationJson_SendMail valueOf(String name) =>
      _$valueOfShareapiCreateShareRequestApplicationJson_SendMail(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for ShareapiCreateShareRequestApplicationJson_SendMail.
  @BuiltValueSerializer(custom: true)
  static Serializer<ShareapiCreateShareRequestApplicationJson_SendMail> get serializer =>
      const _$ShareapiCreateShareRequestApplicationJson_SendMailSerializer();
}

class _$ShareapiCreateShareRequestApplicationJson_SendMailSerializer
    implements PrimitiveSerializer<ShareapiCreateShareRequestApplicationJson_SendMail> {
  const _$ShareapiCreateShareRequestApplicationJson_SendMailSerializer();

  static const Map<ShareapiCreateShareRequestApplicationJson_SendMail, Object> _toWire =
      <ShareapiCreateShareRequestApplicationJson_SendMail, Object>{
    ShareapiCreateShareRequestApplicationJson_SendMail.$false: 'false',
    ShareapiCreateShareRequestApplicationJson_SendMail.$true: 'true',
  };

  static const Map<Object, ShareapiCreateShareRequestApplicationJson_SendMail> _fromWire =
      <Object, ShareapiCreateShareRequestApplicationJson_SendMail>{
    'false': ShareapiCreateShareRequestApplicationJson_SendMail.$false,
    'true': ShareapiCreateShareRequestApplicationJson_SendMail.$true,
  };

  @override
  Iterable<Type> get types => const [ShareapiCreateShareRequestApplicationJson_SendMail];

  @override
  String get wireName => 'ShareapiCreateShareRequestApplicationJson_SendMail';

  @override
  Object serialize(
    Serializers serializers,
    ShareapiCreateShareRequestApplicationJson_SendMail object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ShareapiCreateShareRequestApplicationJson_SendMail deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ShareapiCreateShareRequestApplicationJsonInterface {
  static final _$shareType = _$jsonSerializers.deserialize(
    -1,
    specifiedType: const FullType(int),
  )! as int;

  static final _$publicUpload = _$jsonSerializers.deserialize(
    'false',
    specifiedType: const FullType(String),
  )! as String;

  static final _$password = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$note = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$label = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// Path of the share.
  String? get path;

  /// Permissions for the share.
  int? get permissions;

  /// Type of the share.
  int get shareType;

  /// The entity this should be shared with.
  String? get shareWith;

  /// If public uploading is allowed.
  String get publicUpload;

  /// Password for the share.
  String get password;

  /// Send the password for the share over Talk.
  String? get sendPasswordByTalk;

  /// The expiry date of the share in the user's timezone at 00:00. If $expireDate is not supplied or set to `null`, the system default will be used.
  String? get expireDate;

  /// Note for the share.
  String get note;

  /// Label for the share (only used in link and email).
  String get label;

  /// Additional attributes for the share.
  String? get attributes;

  /// Send a mail to the recipient.
  ShareapiCreateShareRequestApplicationJson_SendMail? get sendMail;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiCreateShareRequestApplicationJsonInterfaceBuilder].
  $ShareapiCreateShareRequestApplicationJsonInterface rebuild(
    void Function($ShareapiCreateShareRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiCreateShareRequestApplicationJsonInterfaceBuilder].
  $ShareapiCreateShareRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiCreateShareRequestApplicationJsonInterfaceBuilder b) {
    b.shareType = _$shareType;
    b.publicUpload = _$publicUpload;
    b.password = _$password;
    b.note = _$note;
    b.label = _$label;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiCreateShareRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiCreateShareRequestApplicationJson
    implements
        $ShareapiCreateShareRequestApplicationJsonInterface,
        Built<ShareapiCreateShareRequestApplicationJson, ShareapiCreateShareRequestApplicationJsonBuilder> {
  /// Creates a new ShareapiCreateShareRequestApplicationJson object using the builder pattern.
  factory ShareapiCreateShareRequestApplicationJson([
    void Function(ShareapiCreateShareRequestApplicationJsonBuilder)? b,
  ]) = _$ShareapiCreateShareRequestApplicationJson;

  // coverage:ignore-start
  const ShareapiCreateShareRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiCreateShareRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiCreateShareRequestApplicationJson.
  static Serializer<ShareapiCreateShareRequestApplicationJson> get serializer =>
      _$shareapiCreateShareRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiCreateShareRequestApplicationJsonBuilder b) {
    $ShareapiCreateShareRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiCreateShareRequestApplicationJsonBuilder b) {
    $ShareapiCreateShareRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiCreateShareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Share get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiCreateShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiCreateShareResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiCreateShareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiCreateShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiCreateShareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiCreateShareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiCreateShareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiCreateShareResponseApplicationJson_Ocs
    implements
        $ShareapiCreateShareResponseApplicationJson_OcsInterface,
        Built<ShareapiCreateShareResponseApplicationJson_Ocs, ShareapiCreateShareResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiCreateShareResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiCreateShareResponseApplicationJson_Ocs([
    void Function(ShareapiCreateShareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiCreateShareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiCreateShareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiCreateShareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiCreateShareResponseApplicationJson_Ocs.
  static Serializer<ShareapiCreateShareResponseApplicationJson_Ocs> get serializer =>
      _$shareapiCreateShareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiCreateShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiCreateShareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiCreateShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiCreateShareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiCreateShareResponseApplicationJsonInterface {
  ShareapiCreateShareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiCreateShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiCreateShareResponseApplicationJsonInterface rebuild(
    void Function($ShareapiCreateShareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiCreateShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiCreateShareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiCreateShareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiCreateShareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiCreateShareResponseApplicationJson
    implements
        $ShareapiCreateShareResponseApplicationJsonInterface,
        Built<ShareapiCreateShareResponseApplicationJson, ShareapiCreateShareResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiCreateShareResponseApplicationJson object using the builder pattern.
  factory ShareapiCreateShareResponseApplicationJson([
    void Function(ShareapiCreateShareResponseApplicationJsonBuilder)? b,
  ]) = _$ShareapiCreateShareResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiCreateShareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiCreateShareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiCreateShareResponseApplicationJson.
  static Serializer<ShareapiCreateShareResponseApplicationJson> get serializer =>
      _$shareapiCreateShareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiCreateShareResponseApplicationJsonBuilder b) {
    $ShareapiCreateShareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiCreateShareResponseApplicationJsonBuilder b) {
    $ShareapiCreateShareResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiGetInheritedSharesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Share> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiGetInheritedSharesResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiGetInheritedSharesResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiGetInheritedSharesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiGetInheritedSharesResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiGetInheritedSharesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiGetInheritedSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiGetInheritedSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiGetInheritedSharesResponseApplicationJson_Ocs
    implements
        $ShareapiGetInheritedSharesResponseApplicationJson_OcsInterface,
        Built<ShareapiGetInheritedSharesResponseApplicationJson_Ocs,
            ShareapiGetInheritedSharesResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiGetInheritedSharesResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiGetInheritedSharesResponseApplicationJson_Ocs([
    void Function(ShareapiGetInheritedSharesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiGetInheritedSharesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiGetInheritedSharesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiGetInheritedSharesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiGetInheritedSharesResponseApplicationJson_Ocs.
  static Serializer<ShareapiGetInheritedSharesResponseApplicationJson_Ocs> get serializer =>
      _$shareapiGetInheritedSharesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiGetInheritedSharesResponseApplicationJson_OcsBuilder b) {
    $ShareapiGetInheritedSharesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiGetInheritedSharesResponseApplicationJson_OcsBuilder b) {
    $ShareapiGetInheritedSharesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiGetInheritedSharesResponseApplicationJsonInterface {
  ShareapiGetInheritedSharesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiGetInheritedSharesResponseApplicationJsonInterfaceBuilder].
  $ShareapiGetInheritedSharesResponseApplicationJsonInterface rebuild(
    void Function($ShareapiGetInheritedSharesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiGetInheritedSharesResponseApplicationJsonInterfaceBuilder].
  $ShareapiGetInheritedSharesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiGetInheritedSharesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiGetInheritedSharesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiGetInheritedSharesResponseApplicationJson
    implements
        $ShareapiGetInheritedSharesResponseApplicationJsonInterface,
        Built<ShareapiGetInheritedSharesResponseApplicationJson,
            ShareapiGetInheritedSharesResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiGetInheritedSharesResponseApplicationJson object using the builder pattern.
  factory ShareapiGetInheritedSharesResponseApplicationJson([
    void Function(ShareapiGetInheritedSharesResponseApplicationJsonBuilder)? b,
  ]) = _$ShareapiGetInheritedSharesResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiGetInheritedSharesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiGetInheritedSharesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiGetInheritedSharesResponseApplicationJson.
  static Serializer<ShareapiGetInheritedSharesResponseApplicationJson> get serializer =>
      _$shareapiGetInheritedSharesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiGetInheritedSharesResponseApplicationJsonBuilder b) {
    $ShareapiGetInheritedSharesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiGetInheritedSharesResponseApplicationJsonBuilder b) {
    $ShareapiGetInheritedSharesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiPendingSharesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Share> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiPendingSharesResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiPendingSharesResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiPendingSharesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiPendingSharesResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiPendingSharesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiPendingSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiPendingSharesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiPendingSharesResponseApplicationJson_Ocs
    implements
        $ShareapiPendingSharesResponseApplicationJson_OcsInterface,
        Built<ShareapiPendingSharesResponseApplicationJson_Ocs,
            ShareapiPendingSharesResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiPendingSharesResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiPendingSharesResponseApplicationJson_Ocs([
    void Function(ShareapiPendingSharesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiPendingSharesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiPendingSharesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiPendingSharesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiPendingSharesResponseApplicationJson_Ocs.
  static Serializer<ShareapiPendingSharesResponseApplicationJson_Ocs> get serializer =>
      _$shareapiPendingSharesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiPendingSharesResponseApplicationJson_OcsBuilder b) {
    $ShareapiPendingSharesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiPendingSharesResponseApplicationJson_OcsBuilder b) {
    $ShareapiPendingSharesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiPendingSharesResponseApplicationJsonInterface {
  ShareapiPendingSharesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiPendingSharesResponseApplicationJsonInterfaceBuilder].
  $ShareapiPendingSharesResponseApplicationJsonInterface rebuild(
    void Function($ShareapiPendingSharesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiPendingSharesResponseApplicationJsonInterfaceBuilder].
  $ShareapiPendingSharesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiPendingSharesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiPendingSharesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiPendingSharesResponseApplicationJson
    implements
        $ShareapiPendingSharesResponseApplicationJsonInterface,
        Built<ShareapiPendingSharesResponseApplicationJson, ShareapiPendingSharesResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiPendingSharesResponseApplicationJson object using the builder pattern.
  factory ShareapiPendingSharesResponseApplicationJson([
    void Function(ShareapiPendingSharesResponseApplicationJsonBuilder)? b,
  ]) = _$ShareapiPendingSharesResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiPendingSharesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiPendingSharesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiPendingSharesResponseApplicationJson.
  static Serializer<ShareapiPendingSharesResponseApplicationJson> get serializer =>
      _$shareapiPendingSharesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiPendingSharesResponseApplicationJsonBuilder b) {
    $ShareapiPendingSharesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiPendingSharesResponseApplicationJsonBuilder b) {
    $ShareapiPendingSharesResponseApplicationJsonInterface._validate(b);
  }
}

class ShareapiGetShareIncludeTags extends EnumClass {
  const ShareapiGetShareIncludeTags._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ShareapiGetShareIncludeTags $0 = _$shareapiGetShareIncludeTags$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ShareapiGetShareIncludeTags $1 = _$shareapiGetShareIncludeTags$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ShareapiGetShareIncludeTags> get values => _$shareapiGetShareIncludeTagsValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ShareapiGetShareIncludeTags valueOf(String name) => _$valueOfShareapiGetShareIncludeTags(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ShareapiGetShareIncludeTags.
  @BuiltValueSerializer(custom: true)
  static Serializer<ShareapiGetShareIncludeTags> get serializer => const _$ShareapiGetShareIncludeTagsSerializer();
}

class _$ShareapiGetShareIncludeTagsSerializer implements PrimitiveSerializer<ShareapiGetShareIncludeTags> {
  const _$ShareapiGetShareIncludeTagsSerializer();

  static const Map<ShareapiGetShareIncludeTags, Object> _toWire = <ShareapiGetShareIncludeTags, Object>{
    ShareapiGetShareIncludeTags.$0: 0,
    ShareapiGetShareIncludeTags.$1: 1,
  };

  static const Map<Object, ShareapiGetShareIncludeTags> _fromWire = <Object, ShareapiGetShareIncludeTags>{
    0: ShareapiGetShareIncludeTags.$0,
    1: ShareapiGetShareIncludeTags.$1,
  };

  @override
  Iterable<Type> get types => const [ShareapiGetShareIncludeTags];

  @override
  String get wireName => 'ShareapiGetShareIncludeTags';

  @override
  Object serialize(
    Serializers serializers,
    ShareapiGetShareIncludeTags object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ShareapiGetShareIncludeTags deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ShareapiGetShareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Share get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiGetShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiGetShareResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiGetShareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiGetShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiGetShareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiGetShareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiGetShareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiGetShareResponseApplicationJson_Ocs
    implements
        $ShareapiGetShareResponseApplicationJson_OcsInterface,
        Built<ShareapiGetShareResponseApplicationJson_Ocs, ShareapiGetShareResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiGetShareResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiGetShareResponseApplicationJson_Ocs([
    void Function(ShareapiGetShareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiGetShareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiGetShareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiGetShareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiGetShareResponseApplicationJson_Ocs.
  static Serializer<ShareapiGetShareResponseApplicationJson_Ocs> get serializer =>
      _$shareapiGetShareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiGetShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiGetShareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiGetShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiGetShareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiGetShareResponseApplicationJsonInterface {
  ShareapiGetShareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiGetShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiGetShareResponseApplicationJsonInterface rebuild(
    void Function($ShareapiGetShareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiGetShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiGetShareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiGetShareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiGetShareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiGetShareResponseApplicationJson
    implements
        $ShareapiGetShareResponseApplicationJsonInterface,
        Built<ShareapiGetShareResponseApplicationJson, ShareapiGetShareResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiGetShareResponseApplicationJson object using the builder pattern.
  factory ShareapiGetShareResponseApplicationJson([void Function(ShareapiGetShareResponseApplicationJsonBuilder)? b]) =
      _$ShareapiGetShareResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiGetShareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiGetShareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiGetShareResponseApplicationJson.
  static Serializer<ShareapiGetShareResponseApplicationJson> get serializer =>
      _$shareapiGetShareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiGetShareResponseApplicationJsonBuilder b) {
    $ShareapiGetShareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiGetShareResponseApplicationJsonBuilder b) {
    $ShareapiGetShareResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiUpdateShareRequestApplicationJsonInterface {
  /// New permissions.
  int? get permissions;

  /// New password.
  String? get password;

  /// New condition if the password should be send over Talk.
  String? get sendPasswordByTalk;

  /// New condition if public uploading is allowed.
  String? get publicUpload;

  /// New expiry date.
  String? get expireDate;

  /// New note.
  String? get note;

  /// New label.
  String? get label;

  /// New condition if the download should be hidden.
  String? get hideDownload;

  /// New additional attributes.
  String? get attributes;

  /// if the share should be send by mail. Considering the share already exists, no mail will be send after the share is updated. You will have to use the sendMail action to send the mail.
  String? get sendMail;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiUpdateShareRequestApplicationJsonInterfaceBuilder].
  $ShareapiUpdateShareRequestApplicationJsonInterface rebuild(
    void Function($ShareapiUpdateShareRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiUpdateShareRequestApplicationJsonInterfaceBuilder].
  $ShareapiUpdateShareRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiUpdateShareRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiUpdateShareRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiUpdateShareRequestApplicationJson
    implements
        $ShareapiUpdateShareRequestApplicationJsonInterface,
        Built<ShareapiUpdateShareRequestApplicationJson, ShareapiUpdateShareRequestApplicationJsonBuilder> {
  /// Creates a new ShareapiUpdateShareRequestApplicationJson object using the builder pattern.
  factory ShareapiUpdateShareRequestApplicationJson([
    void Function(ShareapiUpdateShareRequestApplicationJsonBuilder)? b,
  ]) = _$ShareapiUpdateShareRequestApplicationJson;

  // coverage:ignore-start
  const ShareapiUpdateShareRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiUpdateShareRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiUpdateShareRequestApplicationJson.
  static Serializer<ShareapiUpdateShareRequestApplicationJson> get serializer =>
      _$shareapiUpdateShareRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiUpdateShareRequestApplicationJsonBuilder b) {
    $ShareapiUpdateShareRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiUpdateShareRequestApplicationJsonBuilder b) {
    $ShareapiUpdateShareRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiUpdateShareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Share get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiUpdateShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiUpdateShareResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiUpdateShareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiUpdateShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiUpdateShareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiUpdateShareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiUpdateShareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiUpdateShareResponseApplicationJson_Ocs
    implements
        $ShareapiUpdateShareResponseApplicationJson_OcsInterface,
        Built<ShareapiUpdateShareResponseApplicationJson_Ocs, ShareapiUpdateShareResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiUpdateShareResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiUpdateShareResponseApplicationJson_Ocs([
    void Function(ShareapiUpdateShareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiUpdateShareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiUpdateShareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiUpdateShareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiUpdateShareResponseApplicationJson_Ocs.
  static Serializer<ShareapiUpdateShareResponseApplicationJson_Ocs> get serializer =>
      _$shareapiUpdateShareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiUpdateShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiUpdateShareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiUpdateShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiUpdateShareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiUpdateShareResponseApplicationJsonInterface {
  ShareapiUpdateShareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiUpdateShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiUpdateShareResponseApplicationJsonInterface rebuild(
    void Function($ShareapiUpdateShareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiUpdateShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiUpdateShareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiUpdateShareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiUpdateShareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiUpdateShareResponseApplicationJson
    implements
        $ShareapiUpdateShareResponseApplicationJsonInterface,
        Built<ShareapiUpdateShareResponseApplicationJson, ShareapiUpdateShareResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiUpdateShareResponseApplicationJson object using the builder pattern.
  factory ShareapiUpdateShareResponseApplicationJson([
    void Function(ShareapiUpdateShareResponseApplicationJsonBuilder)? b,
  ]) = _$ShareapiUpdateShareResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiUpdateShareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiUpdateShareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiUpdateShareResponseApplicationJson.
  static Serializer<ShareapiUpdateShareResponseApplicationJson> get serializer =>
      _$shareapiUpdateShareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiUpdateShareResponseApplicationJsonBuilder b) {
    $ShareapiUpdateShareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiUpdateShareResponseApplicationJsonBuilder b) {
    $ShareapiUpdateShareResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiDeleteShareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiDeleteShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiDeleteShareResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiDeleteShareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiDeleteShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiDeleteShareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiDeleteShareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiDeleteShareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiDeleteShareResponseApplicationJson_Ocs
    implements
        $ShareapiDeleteShareResponseApplicationJson_OcsInterface,
        Built<ShareapiDeleteShareResponseApplicationJson_Ocs, ShareapiDeleteShareResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiDeleteShareResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiDeleteShareResponseApplicationJson_Ocs([
    void Function(ShareapiDeleteShareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiDeleteShareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiDeleteShareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiDeleteShareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiDeleteShareResponseApplicationJson_Ocs.
  static Serializer<ShareapiDeleteShareResponseApplicationJson_Ocs> get serializer =>
      _$shareapiDeleteShareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiDeleteShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiDeleteShareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiDeleteShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiDeleteShareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiDeleteShareResponseApplicationJsonInterface {
  ShareapiDeleteShareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiDeleteShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiDeleteShareResponseApplicationJsonInterface rebuild(
    void Function($ShareapiDeleteShareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiDeleteShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiDeleteShareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiDeleteShareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiDeleteShareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiDeleteShareResponseApplicationJson
    implements
        $ShareapiDeleteShareResponseApplicationJsonInterface,
        Built<ShareapiDeleteShareResponseApplicationJson, ShareapiDeleteShareResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiDeleteShareResponseApplicationJson object using the builder pattern.
  factory ShareapiDeleteShareResponseApplicationJson([
    void Function(ShareapiDeleteShareResponseApplicationJsonBuilder)? b,
  ]) = _$ShareapiDeleteShareResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiDeleteShareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiDeleteShareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiDeleteShareResponseApplicationJson.
  static Serializer<ShareapiDeleteShareResponseApplicationJson> get serializer =>
      _$shareapiDeleteShareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiDeleteShareResponseApplicationJsonBuilder b) {
    $ShareapiDeleteShareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiDeleteShareResponseApplicationJsonBuilder b) {
    $ShareapiDeleteShareResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiSendShareEmailRequestApplicationJsonInterface {
  static final _$password = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// the password to check against. Necessary for password protected shares.
  String get password;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiSendShareEmailRequestApplicationJsonInterfaceBuilder].
  $ShareapiSendShareEmailRequestApplicationJsonInterface rebuild(
    void Function($ShareapiSendShareEmailRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiSendShareEmailRequestApplicationJsonInterfaceBuilder].
  $ShareapiSendShareEmailRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiSendShareEmailRequestApplicationJsonInterfaceBuilder b) {
    b.password = _$password;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiSendShareEmailRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiSendShareEmailRequestApplicationJson
    implements
        $ShareapiSendShareEmailRequestApplicationJsonInterface,
        Built<ShareapiSendShareEmailRequestApplicationJson, ShareapiSendShareEmailRequestApplicationJsonBuilder> {
  /// Creates a new ShareapiSendShareEmailRequestApplicationJson object using the builder pattern.
  factory ShareapiSendShareEmailRequestApplicationJson([
    void Function(ShareapiSendShareEmailRequestApplicationJsonBuilder)? b,
  ]) = _$ShareapiSendShareEmailRequestApplicationJson;

  // coverage:ignore-start
  const ShareapiSendShareEmailRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiSendShareEmailRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiSendShareEmailRequestApplicationJson.
  static Serializer<ShareapiSendShareEmailRequestApplicationJson> get serializer =>
      _$shareapiSendShareEmailRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiSendShareEmailRequestApplicationJsonBuilder b) {
    $ShareapiSendShareEmailRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiSendShareEmailRequestApplicationJsonBuilder b) {
    $ShareapiSendShareEmailRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiSendShareEmailResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiSendShareEmailResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiSendShareEmailResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiSendShareEmailResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiSendShareEmailResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiSendShareEmailResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiSendShareEmailResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiSendShareEmailResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiSendShareEmailResponseApplicationJson_Ocs
    implements
        $ShareapiSendShareEmailResponseApplicationJson_OcsInterface,
        Built<ShareapiSendShareEmailResponseApplicationJson_Ocs,
            ShareapiSendShareEmailResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiSendShareEmailResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiSendShareEmailResponseApplicationJson_Ocs([
    void Function(ShareapiSendShareEmailResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiSendShareEmailResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiSendShareEmailResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiSendShareEmailResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiSendShareEmailResponseApplicationJson_Ocs.
  static Serializer<ShareapiSendShareEmailResponseApplicationJson_Ocs> get serializer =>
      _$shareapiSendShareEmailResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiSendShareEmailResponseApplicationJson_OcsBuilder b) {
    $ShareapiSendShareEmailResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiSendShareEmailResponseApplicationJson_OcsBuilder b) {
    $ShareapiSendShareEmailResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiSendShareEmailResponseApplicationJsonInterface {
  ShareapiSendShareEmailResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiSendShareEmailResponseApplicationJsonInterfaceBuilder].
  $ShareapiSendShareEmailResponseApplicationJsonInterface rebuild(
    void Function($ShareapiSendShareEmailResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiSendShareEmailResponseApplicationJsonInterfaceBuilder].
  $ShareapiSendShareEmailResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiSendShareEmailResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiSendShareEmailResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiSendShareEmailResponseApplicationJson
    implements
        $ShareapiSendShareEmailResponseApplicationJsonInterface,
        Built<ShareapiSendShareEmailResponseApplicationJson, ShareapiSendShareEmailResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiSendShareEmailResponseApplicationJson object using the builder pattern.
  factory ShareapiSendShareEmailResponseApplicationJson([
    void Function(ShareapiSendShareEmailResponseApplicationJsonBuilder)? b,
  ]) = _$ShareapiSendShareEmailResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiSendShareEmailResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiSendShareEmailResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiSendShareEmailResponseApplicationJson.
  static Serializer<ShareapiSendShareEmailResponseApplicationJson> get serializer =>
      _$shareapiSendShareEmailResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiSendShareEmailResponseApplicationJsonBuilder b) {
    $ShareapiSendShareEmailResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiSendShareEmailResponseApplicationJsonBuilder b) {
    $ShareapiSendShareEmailResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiAcceptShareResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiAcceptShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiAcceptShareResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareapiAcceptShareResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiAcceptShareResponseApplicationJson_OcsInterfaceBuilder].
  $ShareapiAcceptShareResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiAcceptShareResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiAcceptShareResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareapiAcceptShareResponseApplicationJson_Ocs
    implements
        $ShareapiAcceptShareResponseApplicationJson_OcsInterface,
        Built<ShareapiAcceptShareResponseApplicationJson_Ocs, ShareapiAcceptShareResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareapiAcceptShareResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareapiAcceptShareResponseApplicationJson_Ocs([
    void Function(ShareapiAcceptShareResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareapiAcceptShareResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareapiAcceptShareResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiAcceptShareResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiAcceptShareResponseApplicationJson_Ocs.
  static Serializer<ShareapiAcceptShareResponseApplicationJson_Ocs> get serializer =>
      _$shareapiAcceptShareResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiAcceptShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiAcceptShareResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiAcceptShareResponseApplicationJson_OcsBuilder b) {
    $ShareapiAcceptShareResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareapiAcceptShareResponseApplicationJsonInterface {
  ShareapiAcceptShareResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareapiAcceptShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiAcceptShareResponseApplicationJsonInterface rebuild(
    void Function($ShareapiAcceptShareResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareapiAcceptShareResponseApplicationJsonInterfaceBuilder].
  $ShareapiAcceptShareResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareapiAcceptShareResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareapiAcceptShareResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareapiAcceptShareResponseApplicationJson
    implements
        $ShareapiAcceptShareResponseApplicationJsonInterface,
        Built<ShareapiAcceptShareResponseApplicationJson, ShareapiAcceptShareResponseApplicationJsonBuilder> {
  /// Creates a new ShareapiAcceptShareResponseApplicationJson object using the builder pattern.
  factory ShareapiAcceptShareResponseApplicationJson([
    void Function(ShareapiAcceptShareResponseApplicationJsonBuilder)? b,
  ]) = _$ShareapiAcceptShareResponseApplicationJson;

  // coverage:ignore-start
  const ShareapiAcceptShareResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareapiAcceptShareResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareapiAcceptShareResponseApplicationJson.
  static Serializer<ShareapiAcceptShareResponseApplicationJson> get serializer =>
      _$shareapiAcceptShareResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareapiAcceptShareResponseApplicationJsonBuilder b) {
    $ShareapiAcceptShareResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareapiAcceptShareResponseApplicationJsonBuilder b) {
    $ShareapiAcceptShareResponseApplicationJsonInterface._validate(b);
  }
}

typedef ShareesapiSearchShareType = ({BuiltList<int>? builtListInt, int? $int});

class ShareesapiSearchLookup extends EnumClass {
  const ShareesapiSearchLookup._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const ShareesapiSearchLookup $0 = _$shareesapiSearchLookup$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const ShareesapiSearchLookup $1 = _$shareesapiSearchLookup$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<ShareesapiSearchLookup> get values => _$shareesapiSearchLookupValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static ShareesapiSearchLookup valueOf(String name) => _$valueOfShareesapiSearchLookup(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for ShareesapiSearchLookup.
  @BuiltValueSerializer(custom: true)
  static Serializer<ShareesapiSearchLookup> get serializer => const _$ShareesapiSearchLookupSerializer();
}

class _$ShareesapiSearchLookupSerializer implements PrimitiveSerializer<ShareesapiSearchLookup> {
  const _$ShareesapiSearchLookupSerializer();

  static const Map<ShareesapiSearchLookup, Object> _toWire = <ShareesapiSearchLookup, Object>{
    ShareesapiSearchLookup.$0: 0,
    ShareesapiSearchLookup.$1: 1,
  };

  static const Map<Object, ShareesapiSearchLookup> _fromWire = <Object, ShareesapiSearchLookup>{
    0: ShareesapiSearchLookup.$0,
    1: ShareesapiSearchLookup.$1,
  };

  @override
  Iterable<Type> get types => const [ShareesapiSearchLookup];

  @override
  String get wireName => 'ShareesapiSearchLookup';

  @override
  Object serialize(
    Serializers serializers,
    ShareesapiSearchLookup object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  ShareesapiSearchLookup deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ShareeInterface {
  int? get count;
  String get label;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeInterfaceBuilder].
  $ShareeInterface rebuild(void Function($ShareeInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeInterfaceBuilder].
  $ShareeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeInterfaceBuilder b) {}
}

abstract class Sharee implements $ShareeInterface, Built<Sharee, ShareeBuilder> {
  /// Creates a new Sharee object using the builder pattern.
  factory Sharee([void Function(ShareeBuilder)? b]) = _$Sharee;

  // coverage:ignore-start
  const Sharee._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Sharee.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Sharee.
  static Serializer<Sharee> get serializer => _$shareeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeBuilder b) {
    $ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeBuilder b) {
    $ShareeInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeValueInterface {
  int get shareType;
  String get shareWith;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeValueInterfaceBuilder].
  $ShareeValueInterface rebuild(void Function($ShareeValueInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeValueInterfaceBuilder].
  $ShareeValueInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeValueInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeValueInterfaceBuilder b) {}
}

abstract class ShareeValue implements $ShareeValueInterface, Built<ShareeValue, ShareeValueBuilder> {
  /// Creates a new ShareeValue object using the builder pattern.
  factory ShareeValue([void Function(ShareeValueBuilder)? b]) = _$ShareeValue;

  // coverage:ignore-start
  const ShareeValue._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeValue.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeValue.
  static Serializer<ShareeValue> get serializer => _$shareeValueSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeValueBuilder b) {
    $ShareeValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeValueBuilder b) {
    $ShareeValueInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeCircle_ValueInterface implements $ShareeValueInterface {
  String get circle;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeCircle_ValueInterfaceBuilder].
  @override
  $ShareeCircle_ValueInterface rebuild(void Function($ShareeCircle_ValueInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeCircle_ValueInterfaceBuilder].
  @override
  $ShareeCircle_ValueInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeCircle_ValueInterfaceBuilder b) {
    $ShareeValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeCircle_ValueInterfaceBuilder b) {
    $ShareeValueInterface._validate(b);
  }
}

abstract class ShareeCircle_Value
    implements $ShareeCircle_ValueInterface, Built<ShareeCircle_Value, ShareeCircle_ValueBuilder> {
  /// Creates a new ShareeCircle_Value object using the builder pattern.
  factory ShareeCircle_Value([void Function(ShareeCircle_ValueBuilder)? b]) = _$ShareeCircle_Value;

  // coverage:ignore-start
  const ShareeCircle_Value._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeCircle_Value.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeCircle_Value.
  static Serializer<ShareeCircle_Value> get serializer => _$shareeCircleValueSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeCircle_ValueBuilder b) {
    $ShareeCircle_ValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeCircle_ValueBuilder b) {
    $ShareeCircle_ValueInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeCircleInterface implements $ShareeInterface {
  String get shareWithDescription;
  ShareeCircle_Value get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeCircleInterfaceBuilder].
  @override
  $ShareeCircleInterface rebuild(void Function($ShareeCircleInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeCircleInterfaceBuilder].
  @override
  $ShareeCircleInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeCircleInterfaceBuilder b) {
    $ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeCircleInterfaceBuilder b) {
    $ShareeInterface._validate(b);
  }
}

abstract class ShareeCircle implements $ShareeCircleInterface, Built<ShareeCircle, ShareeCircleBuilder> {
  /// Creates a new ShareeCircle object using the builder pattern.
  factory ShareeCircle([void Function(ShareeCircleBuilder)? b]) = _$ShareeCircle;

  // coverage:ignore-start
  const ShareeCircle._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeCircle.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeCircle.
  static Serializer<ShareeCircle> get serializer => _$shareeCircleSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeCircleBuilder b) {
    $ShareeCircleInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeCircleBuilder b) {
    $ShareeCircleInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeEmailInterface implements $ShareeInterface {
  String get uuid;
  String get name;
  String get type;
  String get shareWithDisplayNameUnique;
  ShareeValue get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeEmailInterfaceBuilder].
  @override
  $ShareeEmailInterface rebuild(void Function($ShareeEmailInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeEmailInterfaceBuilder].
  @override
  $ShareeEmailInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeEmailInterfaceBuilder b) {
    $ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeEmailInterfaceBuilder b) {
    $ShareeInterface._validate(b);
  }
}

abstract class ShareeEmail implements $ShareeEmailInterface, Built<ShareeEmail, ShareeEmailBuilder> {
  /// Creates a new ShareeEmail object using the builder pattern.
  factory ShareeEmail([void Function(ShareeEmailBuilder)? b]) = _$ShareeEmail;

  // coverage:ignore-start
  const ShareeEmail._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeEmail.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeEmail.
  static Serializer<ShareeEmail> get serializer => _$shareeEmailSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeEmailBuilder b) {
    $ShareeEmailInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeEmailBuilder b) {
    $ShareeEmailInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeRemoteGroup_ValueInterface implements $ShareeValueInterface {
  String get server;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeRemoteGroup_ValueInterfaceBuilder].
  @override
  $ShareeRemoteGroup_ValueInterface rebuild(void Function($ShareeRemoteGroup_ValueInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeRemoteGroup_ValueInterfaceBuilder].
  @override
  $ShareeRemoteGroup_ValueInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeRemoteGroup_ValueInterfaceBuilder b) {
    $ShareeValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeRemoteGroup_ValueInterfaceBuilder b) {
    $ShareeValueInterface._validate(b);
  }
}

abstract class ShareeRemoteGroup_Value
    implements $ShareeRemoteGroup_ValueInterface, Built<ShareeRemoteGroup_Value, ShareeRemoteGroup_ValueBuilder> {
  /// Creates a new ShareeRemoteGroup_Value object using the builder pattern.
  factory ShareeRemoteGroup_Value([void Function(ShareeRemoteGroup_ValueBuilder)? b]) = _$ShareeRemoteGroup_Value;

  // coverage:ignore-start
  const ShareeRemoteGroup_Value._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeRemoteGroup_Value.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeRemoteGroup_Value.
  static Serializer<ShareeRemoteGroup_Value> get serializer => _$shareeRemoteGroupValueSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeRemoteGroup_ValueBuilder b) {
    $ShareeRemoteGroup_ValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeRemoteGroup_ValueBuilder b) {
    $ShareeRemoteGroup_ValueInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeRemoteGroupInterface implements $ShareeInterface {
  String get guid;
  String get name;
  ShareeRemoteGroup_Value get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeRemoteGroupInterfaceBuilder].
  @override
  $ShareeRemoteGroupInterface rebuild(void Function($ShareeRemoteGroupInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeRemoteGroupInterfaceBuilder].
  @override
  $ShareeRemoteGroupInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeRemoteGroupInterfaceBuilder b) {
    $ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeRemoteGroupInterfaceBuilder b) {
    $ShareeInterface._validate(b);
  }
}

abstract class ShareeRemoteGroup
    implements $ShareeRemoteGroupInterface, Built<ShareeRemoteGroup, ShareeRemoteGroupBuilder> {
  /// Creates a new ShareeRemoteGroup object using the builder pattern.
  factory ShareeRemoteGroup([void Function(ShareeRemoteGroupBuilder)? b]) = _$ShareeRemoteGroup;

  // coverage:ignore-start
  const ShareeRemoteGroup._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeRemoteGroup.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeRemoteGroup.
  static Serializer<ShareeRemoteGroup> get serializer => _$shareeRemoteGroupSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeRemoteGroupBuilder b) {
    $ShareeRemoteGroupInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeRemoteGroupBuilder b) {
    $ShareeRemoteGroupInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeRemote_ValueInterface implements $ShareeValueInterface {
  String get server;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeRemote_ValueInterfaceBuilder].
  @override
  $ShareeRemote_ValueInterface rebuild(void Function($ShareeRemote_ValueInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeRemote_ValueInterfaceBuilder].
  @override
  $ShareeRemote_ValueInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeRemote_ValueInterfaceBuilder b) {
    $ShareeValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeRemote_ValueInterfaceBuilder b) {
    $ShareeValueInterface._validate(b);
  }
}

abstract class ShareeRemote_Value
    implements $ShareeRemote_ValueInterface, Built<ShareeRemote_Value, ShareeRemote_ValueBuilder> {
  /// Creates a new ShareeRemote_Value object using the builder pattern.
  factory ShareeRemote_Value([void Function(ShareeRemote_ValueBuilder)? b]) = _$ShareeRemote_Value;

  // coverage:ignore-start
  const ShareeRemote_Value._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeRemote_Value.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeRemote_Value.
  static Serializer<ShareeRemote_Value> get serializer => _$shareeRemoteValueSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeRemote_ValueBuilder b) {
    $ShareeRemote_ValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeRemote_ValueBuilder b) {
    $ShareeRemote_ValueInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeRemoteInterface implements $ShareeInterface {
  String get uuid;
  String get name;
  String get type;
  ShareeRemote_Value get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeRemoteInterfaceBuilder].
  @override
  $ShareeRemoteInterface rebuild(void Function($ShareeRemoteInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeRemoteInterfaceBuilder].
  @override
  $ShareeRemoteInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeRemoteInterfaceBuilder b) {
    $ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeRemoteInterfaceBuilder b) {
    $ShareeInterface._validate(b);
  }
}

abstract class ShareeRemote implements $ShareeRemoteInterface, Built<ShareeRemote, ShareeRemoteBuilder> {
  /// Creates a new ShareeRemote object using the builder pattern.
  factory ShareeRemote([void Function(ShareeRemoteBuilder)? b]) = _$ShareeRemote;

  // coverage:ignore-start
  const ShareeRemote._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeRemote.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeRemote.
  static Serializer<ShareeRemote> get serializer => _$shareeRemoteSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeRemoteBuilder b) {
    $ShareeRemoteInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeRemoteBuilder b) {
    $ShareeRemoteInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeUser_StatusInterface {
  String get status;
  String get message;
  String get icon;
  int? get clearAt;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeUser_StatusInterfaceBuilder].
  $ShareeUser_StatusInterface rebuild(void Function($ShareeUser_StatusInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeUser_StatusInterfaceBuilder].
  $ShareeUser_StatusInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeUser_StatusInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeUser_StatusInterfaceBuilder b) {}
}

abstract class ShareeUser_Status
    implements $ShareeUser_StatusInterface, Built<ShareeUser_Status, ShareeUser_StatusBuilder> {
  /// Creates a new ShareeUser_Status object using the builder pattern.
  factory ShareeUser_Status([void Function(ShareeUser_StatusBuilder)? b]) = _$ShareeUser_Status;

  // coverage:ignore-start
  const ShareeUser_Status._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeUser_Status.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeUser_Status.
  static Serializer<ShareeUser_Status> get serializer => _$shareeUserStatusSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeUser_StatusBuilder b) {
    $ShareeUser_StatusInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeUser_StatusBuilder b) {
    $ShareeUser_StatusInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeUserInterface implements $ShareeInterface {
  String get subline;
  String get icon;
  String get shareWithDisplayNameUnique;
  ShareeUser_Status get status;
  ShareeValue get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeUserInterfaceBuilder].
  @override
  $ShareeUserInterface rebuild(void Function($ShareeUserInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeUserInterfaceBuilder].
  @override
  $ShareeUserInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeUserInterfaceBuilder b) {
    $ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeUserInterfaceBuilder b) {
    $ShareeInterface._validate(b);
  }
}

abstract class ShareeUser implements $ShareeUserInterface, Built<ShareeUser, ShareeUserBuilder> {
  /// Creates a new ShareeUser object using the builder pattern.
  factory ShareeUser([void Function(ShareeUserBuilder)? b]) = _$ShareeUser;

  // coverage:ignore-start
  const ShareeUser._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeUser.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeUser.
  static Serializer<ShareeUser> get serializer => _$shareeUserSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeUserBuilder b) {
    $ShareeUserInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeUserBuilder b) {
    $ShareeUserInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareesSearchResult_ExactInterface {
  BuiltList<ShareeCircle> get circles;
  BuiltList<ShareeEmail> get emails;
  BuiltList<Sharee> get groups;
  @BuiltValueField(wireName: 'remote_groups')
  BuiltList<ShareeRemoteGroup> get remoteGroups;
  BuiltList<ShareeRemote> get remotes;
  BuiltList<Sharee> get rooms;
  BuiltList<ShareeUser> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesSearchResult_ExactInterfaceBuilder].
  $ShareesSearchResult_ExactInterface rebuild(void Function($ShareesSearchResult_ExactInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareesSearchResult_ExactInterfaceBuilder].
  $ShareesSearchResult_ExactInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesSearchResult_ExactInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesSearchResult_ExactInterfaceBuilder b) {}
}

abstract class ShareesSearchResult_Exact
    implements $ShareesSearchResult_ExactInterface, Built<ShareesSearchResult_Exact, ShareesSearchResult_ExactBuilder> {
  /// Creates a new ShareesSearchResult_Exact object using the builder pattern.
  factory ShareesSearchResult_Exact([void Function(ShareesSearchResult_ExactBuilder)? b]) = _$ShareesSearchResult_Exact;

  // coverage:ignore-start
  const ShareesSearchResult_Exact._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesSearchResult_Exact.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesSearchResult_Exact.
  static Serializer<ShareesSearchResult_Exact> get serializer => _$shareesSearchResultExactSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesSearchResult_ExactBuilder b) {
    $ShareesSearchResult_ExactInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesSearchResult_ExactBuilder b) {
    $ShareesSearchResult_ExactInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LookupInterface {
  String get value;
  int get verified;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LookupInterfaceBuilder].
  $LookupInterface rebuild(void Function($LookupInterfaceBuilder) updates);

  /// Converts the instance to a builder [$LookupInterfaceBuilder].
  $LookupInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LookupInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LookupInterfaceBuilder b) {}
}

abstract class Lookup implements $LookupInterface, Built<Lookup, LookupBuilder> {
  /// Creates a new Lookup object using the builder pattern.
  factory Lookup([void Function(LookupBuilder)? b]) = _$Lookup;

  // coverage:ignore-start
  const Lookup._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Lookup.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Lookup.
  static Serializer<Lookup> get serializer => _$lookupSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LookupBuilder b) {
    $LookupInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LookupBuilder b) {
    $LookupInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeLookup_ExtraInterface {
  String get federationId;
  Lookup? get name;
  Lookup? get email;
  Lookup? get address;
  Lookup? get website;
  Lookup? get twitter;
  Lookup? get phone;
  @BuiltValueField(wireName: 'twitter_signature')
  Lookup? get twitterSignature;
  @BuiltValueField(wireName: 'website_signature')
  Lookup? get websiteSignature;
  Lookup? get userid;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeLookup_ExtraInterfaceBuilder].
  $ShareeLookup_ExtraInterface rebuild(void Function($ShareeLookup_ExtraInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeLookup_ExtraInterfaceBuilder].
  $ShareeLookup_ExtraInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeLookup_ExtraInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeLookup_ExtraInterfaceBuilder b) {}
}

abstract class ShareeLookup_Extra
    implements $ShareeLookup_ExtraInterface, Built<ShareeLookup_Extra, ShareeLookup_ExtraBuilder> {
  /// Creates a new ShareeLookup_Extra object using the builder pattern.
  factory ShareeLookup_Extra([void Function(ShareeLookup_ExtraBuilder)? b]) = _$ShareeLookup_Extra;

  // coverage:ignore-start
  const ShareeLookup_Extra._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeLookup_Extra.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeLookup_Extra.
  static Serializer<ShareeLookup_Extra> get serializer => _$shareeLookupExtraSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeLookup_ExtraBuilder b) {
    $ShareeLookup_ExtraInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeLookup_ExtraBuilder b) {
    $ShareeLookup_ExtraInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeLookup_ValueInterface implements $ShareeValueInterface {
  bool get globalScale;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeLookup_ValueInterfaceBuilder].
  @override
  $ShareeLookup_ValueInterface rebuild(void Function($ShareeLookup_ValueInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeLookup_ValueInterfaceBuilder].
  @override
  $ShareeLookup_ValueInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeLookup_ValueInterfaceBuilder b) {
    $ShareeValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeLookup_ValueInterfaceBuilder b) {
    $ShareeValueInterface._validate(b);
  }
}

abstract class ShareeLookup_Value
    implements $ShareeLookup_ValueInterface, Built<ShareeLookup_Value, ShareeLookup_ValueBuilder> {
  /// Creates a new ShareeLookup_Value object using the builder pattern.
  factory ShareeLookup_Value([void Function(ShareeLookup_ValueBuilder)? b]) = _$ShareeLookup_Value;

  // coverage:ignore-start
  const ShareeLookup_Value._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeLookup_Value.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeLookup_Value.
  static Serializer<ShareeLookup_Value> get serializer => _$shareeLookupValueSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeLookup_ValueBuilder b) {
    $ShareeLookup_ValueInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeLookup_ValueBuilder b) {
    $ShareeLookup_ValueInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareeLookupInterface implements $ShareeInterface {
  ShareeLookup_Extra get extra;
  ShareeLookup_Value get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareeLookupInterfaceBuilder].
  @override
  $ShareeLookupInterface rebuild(void Function($ShareeLookupInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareeLookupInterfaceBuilder].
  @override
  $ShareeLookupInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareeLookupInterfaceBuilder b) {
    $ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareeLookupInterfaceBuilder b) {
    $ShareeInterface._validate(b);
  }
}

abstract class ShareeLookup implements $ShareeLookupInterface, Built<ShareeLookup, ShareeLookupBuilder> {
  /// Creates a new ShareeLookup object using the builder pattern.
  factory ShareeLookup([void Function(ShareeLookupBuilder)? b]) = _$ShareeLookup;

  // coverage:ignore-start
  const ShareeLookup._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareeLookup.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareeLookup.
  static Serializer<ShareeLookup> get serializer => _$shareeLookupSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareeLookupBuilder b) {
    $ShareeLookupInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareeLookupBuilder b) {
    $ShareeLookupInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareesSearchResultInterface {
  ShareesSearchResult_Exact get exact;
  BuiltList<ShareeCircle> get circles;
  BuiltList<ShareeEmail> get emails;
  BuiltList<Sharee> get groups;
  BuiltList<ShareeLookup> get lookup;
  @BuiltValueField(wireName: 'remote_groups')
  BuiltList<ShareeRemoteGroup> get remoteGroups;
  BuiltList<ShareeRemote> get remotes;
  BuiltList<Sharee> get rooms;
  BuiltList<ShareeUser> get users;
  bool get lookupEnabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesSearchResultInterfaceBuilder].
  $ShareesSearchResultInterface rebuild(void Function($ShareesSearchResultInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareesSearchResultInterfaceBuilder].
  $ShareesSearchResultInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesSearchResultInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesSearchResultInterfaceBuilder b) {}
}

abstract class ShareesSearchResult
    implements $ShareesSearchResultInterface, Built<ShareesSearchResult, ShareesSearchResultBuilder> {
  /// Creates a new ShareesSearchResult object using the builder pattern.
  factory ShareesSearchResult([void Function(ShareesSearchResultBuilder)? b]) = _$ShareesSearchResult;

  // coverage:ignore-start
  const ShareesSearchResult._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesSearchResult.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesSearchResult.
  static Serializer<ShareesSearchResult> get serializer => _$shareesSearchResultSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesSearchResultBuilder b) {
    $ShareesSearchResultInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesSearchResultBuilder b) {
    $ShareesSearchResultInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareesapiSearchResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ShareesSearchResult get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesapiSearchResponseApplicationJson_OcsInterfaceBuilder].
  $ShareesapiSearchResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareesapiSearchResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareesapiSearchResponseApplicationJson_OcsInterfaceBuilder].
  $ShareesapiSearchResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesapiSearchResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesapiSearchResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareesapiSearchResponseApplicationJson_Ocs
    implements
        $ShareesapiSearchResponseApplicationJson_OcsInterface,
        Built<ShareesapiSearchResponseApplicationJson_Ocs, ShareesapiSearchResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareesapiSearchResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareesapiSearchResponseApplicationJson_Ocs([
    void Function(ShareesapiSearchResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareesapiSearchResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareesapiSearchResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesapiSearchResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesapiSearchResponseApplicationJson_Ocs.
  static Serializer<ShareesapiSearchResponseApplicationJson_Ocs> get serializer =>
      _$shareesapiSearchResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesapiSearchResponseApplicationJson_OcsBuilder b) {
    $ShareesapiSearchResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesapiSearchResponseApplicationJson_OcsBuilder b) {
    $ShareesapiSearchResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareesapiSearchResponseApplicationJsonInterface {
  ShareesapiSearchResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesapiSearchResponseApplicationJsonInterfaceBuilder].
  $ShareesapiSearchResponseApplicationJsonInterface rebuild(
    void Function($ShareesapiSearchResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareesapiSearchResponseApplicationJsonInterfaceBuilder].
  $ShareesapiSearchResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesapiSearchResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesapiSearchResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareesapiSearchResponseApplicationJson
    implements
        $ShareesapiSearchResponseApplicationJsonInterface,
        Built<ShareesapiSearchResponseApplicationJson, ShareesapiSearchResponseApplicationJsonBuilder> {
  /// Creates a new ShareesapiSearchResponseApplicationJson object using the builder pattern.
  factory ShareesapiSearchResponseApplicationJson([void Function(ShareesapiSearchResponseApplicationJsonBuilder)? b]) =
      _$ShareesapiSearchResponseApplicationJson;

  // coverage:ignore-start
  const ShareesapiSearchResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesapiSearchResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesapiSearchResponseApplicationJson.
  static Serializer<ShareesapiSearchResponseApplicationJson> get serializer =>
      _$shareesapiSearchResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesapiSearchResponseApplicationJsonBuilder b) {
    $ShareesapiSearchResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesapiSearchResponseApplicationJsonBuilder b) {
    $ShareesapiSearchResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareesapiShareesapiSearchHeadersInterface {
  String? get link;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesapiShareesapiSearchHeadersInterfaceBuilder].
  $ShareesapiShareesapiSearchHeadersInterface rebuild(
    void Function($ShareesapiShareesapiSearchHeadersInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareesapiShareesapiSearchHeadersInterfaceBuilder].
  $ShareesapiShareesapiSearchHeadersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesapiShareesapiSearchHeadersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesapiShareesapiSearchHeadersInterfaceBuilder b) {}
}

abstract class ShareesapiShareesapiSearchHeaders
    implements
        $ShareesapiShareesapiSearchHeadersInterface,
        Built<ShareesapiShareesapiSearchHeaders, ShareesapiShareesapiSearchHeadersBuilder> {
  /// Creates a new ShareesapiShareesapiSearchHeaders object using the builder pattern.
  factory ShareesapiShareesapiSearchHeaders([void Function(ShareesapiShareesapiSearchHeadersBuilder)? b]) =
      _$ShareesapiShareesapiSearchHeaders;

  // coverage:ignore-start
  const ShareesapiShareesapiSearchHeaders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesapiShareesapiSearchHeaders.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesapiShareesapiSearchHeaders.
  static Serializer<ShareesapiShareesapiSearchHeaders> get serializer => _$shareesapiShareesapiSearchHeadersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesapiShareesapiSearchHeadersBuilder b) {
    $ShareesapiShareesapiSearchHeadersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesapiShareesapiSearchHeadersBuilder b) {
    $ShareesapiShareesapiSearchHeadersInterface._validate(b);
  }
}

typedef ShareesapiFindRecommendedShareType = ({BuiltList<int>? builtListInt, int? $int});

@BuiltValue(instantiable: false)
sealed class $ShareesRecommendedResult_ExactInterface {
  BuiltList<ShareeEmail> get emails;
  BuiltList<Sharee> get groups;
  @BuiltValueField(wireName: 'remote_groups')
  BuiltList<ShareeRemoteGroup> get remoteGroups;
  BuiltList<ShareeRemote> get remotes;
  BuiltList<ShareeUser> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesRecommendedResult_ExactInterfaceBuilder].
  $ShareesRecommendedResult_ExactInterface rebuild(
    void Function($ShareesRecommendedResult_ExactInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareesRecommendedResult_ExactInterfaceBuilder].
  $ShareesRecommendedResult_ExactInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesRecommendedResult_ExactInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesRecommendedResult_ExactInterfaceBuilder b) {}
}

abstract class ShareesRecommendedResult_Exact
    implements
        $ShareesRecommendedResult_ExactInterface,
        Built<ShareesRecommendedResult_Exact, ShareesRecommendedResult_ExactBuilder> {
  /// Creates a new ShareesRecommendedResult_Exact object using the builder pattern.
  factory ShareesRecommendedResult_Exact([void Function(ShareesRecommendedResult_ExactBuilder)? b]) =
      _$ShareesRecommendedResult_Exact;

  // coverage:ignore-start
  const ShareesRecommendedResult_Exact._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesRecommendedResult_Exact.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesRecommendedResult_Exact.
  static Serializer<ShareesRecommendedResult_Exact> get serializer => _$shareesRecommendedResultExactSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesRecommendedResult_ExactBuilder b) {
    $ShareesRecommendedResult_ExactInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesRecommendedResult_ExactBuilder b) {
    $ShareesRecommendedResult_ExactInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareesRecommendedResultInterface {
  ShareesRecommendedResult_Exact get exact;
  BuiltList<ShareeEmail> get emails;
  BuiltList<Sharee> get groups;
  @BuiltValueField(wireName: 'remote_groups')
  BuiltList<ShareeRemoteGroup> get remoteGroups;
  BuiltList<ShareeRemote> get remotes;
  BuiltList<ShareeUser> get users;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesRecommendedResultInterfaceBuilder].
  $ShareesRecommendedResultInterface rebuild(void Function($ShareesRecommendedResultInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ShareesRecommendedResultInterfaceBuilder].
  $ShareesRecommendedResultInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesRecommendedResultInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesRecommendedResultInterfaceBuilder b) {}
}

abstract class ShareesRecommendedResult
    implements $ShareesRecommendedResultInterface, Built<ShareesRecommendedResult, ShareesRecommendedResultBuilder> {
  /// Creates a new ShareesRecommendedResult object using the builder pattern.
  factory ShareesRecommendedResult([void Function(ShareesRecommendedResultBuilder)? b]) = _$ShareesRecommendedResult;

  // coverage:ignore-start
  const ShareesRecommendedResult._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesRecommendedResult.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesRecommendedResult.
  static Serializer<ShareesRecommendedResult> get serializer => _$shareesRecommendedResultSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesRecommendedResultBuilder b) {
    $ShareesRecommendedResultInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesRecommendedResultBuilder b) {
    $ShareesRecommendedResultInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareesapiFindRecommendedResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ShareesRecommendedResult get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesapiFindRecommendedResponseApplicationJson_OcsInterfaceBuilder].
  $ShareesapiFindRecommendedResponseApplicationJson_OcsInterface rebuild(
    void Function($ShareesapiFindRecommendedResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareesapiFindRecommendedResponseApplicationJson_OcsInterfaceBuilder].
  $ShareesapiFindRecommendedResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesapiFindRecommendedResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesapiFindRecommendedResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ShareesapiFindRecommendedResponseApplicationJson_Ocs
    implements
        $ShareesapiFindRecommendedResponseApplicationJson_OcsInterface,
        Built<ShareesapiFindRecommendedResponseApplicationJson_Ocs,
            ShareesapiFindRecommendedResponseApplicationJson_OcsBuilder> {
  /// Creates a new ShareesapiFindRecommendedResponseApplicationJson_Ocs object using the builder pattern.
  factory ShareesapiFindRecommendedResponseApplicationJson_Ocs([
    void Function(ShareesapiFindRecommendedResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ShareesapiFindRecommendedResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ShareesapiFindRecommendedResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesapiFindRecommendedResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesapiFindRecommendedResponseApplicationJson_Ocs.
  static Serializer<ShareesapiFindRecommendedResponseApplicationJson_Ocs> get serializer =>
      _$shareesapiFindRecommendedResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesapiFindRecommendedResponseApplicationJson_OcsBuilder b) {
    $ShareesapiFindRecommendedResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesapiFindRecommendedResponseApplicationJson_OcsBuilder b) {
    $ShareesapiFindRecommendedResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ShareesapiFindRecommendedResponseApplicationJsonInterface {
  ShareesapiFindRecommendedResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ShareesapiFindRecommendedResponseApplicationJsonInterfaceBuilder].
  $ShareesapiFindRecommendedResponseApplicationJsonInterface rebuild(
    void Function($ShareesapiFindRecommendedResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ShareesapiFindRecommendedResponseApplicationJsonInterfaceBuilder].
  $ShareesapiFindRecommendedResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ShareesapiFindRecommendedResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ShareesapiFindRecommendedResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ShareesapiFindRecommendedResponseApplicationJson
    implements
        $ShareesapiFindRecommendedResponseApplicationJsonInterface,
        Built<ShareesapiFindRecommendedResponseApplicationJson,
            ShareesapiFindRecommendedResponseApplicationJsonBuilder> {
  /// Creates a new ShareesapiFindRecommendedResponseApplicationJson object using the builder pattern.
  factory ShareesapiFindRecommendedResponseApplicationJson([
    void Function(ShareesapiFindRecommendedResponseApplicationJsonBuilder)? b,
  ]) = _$ShareesapiFindRecommendedResponseApplicationJson;

  // coverage:ignore-start
  const ShareesapiFindRecommendedResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ShareesapiFindRecommendedResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ShareesapiFindRecommendedResponseApplicationJson.
  static Serializer<ShareesapiFindRecommendedResponseApplicationJson> get serializer =>
      _$shareesapiFindRecommendedResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ShareesapiFindRecommendedResponseApplicationJsonBuilder b) {
    $ShareesapiFindRecommendedResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ShareesapiFindRecommendedResponseApplicationJsonBuilder b) {
    $ShareesapiFindRecommendedResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_Public_PasswordInterface {
  bool get enforced;
  bool get askForOptionalPassword;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_Public_PasswordInterfaceBuilder].
  $Capabilities_FilesSharing_Public_PasswordInterface rebuild(
    void Function($Capabilities_FilesSharing_Public_PasswordInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_Public_PasswordInterfaceBuilder].
  $Capabilities_FilesSharing_Public_PasswordInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_Public_PasswordInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_Public_PasswordInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Public_Password
    implements
        $Capabilities_FilesSharing_Public_PasswordInterface,
        Built<Capabilities_FilesSharing_Public_Password, Capabilities_FilesSharing_Public_PasswordBuilder> {
  /// Creates a new Capabilities_FilesSharing_Public_Password object using the builder pattern.
  factory Capabilities_FilesSharing_Public_Password([
    void Function(Capabilities_FilesSharing_Public_PasswordBuilder)? b,
  ]) = _$Capabilities_FilesSharing_Public_Password;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Public_Password._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Public_Password.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Public_Password.
  static Serializer<Capabilities_FilesSharing_Public_Password> get serializer =>
      _$capabilitiesFilesSharingPublicPasswordSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_Public_PasswordBuilder b) {
    $Capabilities_FilesSharing_Public_PasswordInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_Public_PasswordBuilder b) {
    $Capabilities_FilesSharing_Public_PasswordInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_Public_ExpireDateInterface {
  bool get enabled;
  int? get days;
  bool? get enforced;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_Public_ExpireDateInterfaceBuilder].
  $Capabilities_FilesSharing_Public_ExpireDateInterface rebuild(
    void Function($Capabilities_FilesSharing_Public_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_Public_ExpireDateInterfaceBuilder].
  $Capabilities_FilesSharing_Public_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_Public_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_Public_ExpireDateInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Public_ExpireDate
    implements
        $Capabilities_FilesSharing_Public_ExpireDateInterface,
        Built<Capabilities_FilesSharing_Public_ExpireDate, Capabilities_FilesSharing_Public_ExpireDateBuilder> {
  /// Creates a new Capabilities_FilesSharing_Public_ExpireDate object using the builder pattern.
  factory Capabilities_FilesSharing_Public_ExpireDate([
    void Function(Capabilities_FilesSharing_Public_ExpireDateBuilder)? b,
  ]) = _$Capabilities_FilesSharing_Public_ExpireDate;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Public_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Public_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Public_ExpireDate.
  static Serializer<Capabilities_FilesSharing_Public_ExpireDate> get serializer =>
      _$capabilitiesFilesSharingPublicExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_Public_ExpireDateBuilder b) {
    $Capabilities_FilesSharing_Public_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_Public_ExpireDateBuilder b) {
    $Capabilities_FilesSharing_Public_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_Public_ExpireDateInternalInterface {
  bool get enabled;
  int? get days;
  bool? get enforced;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder].
  $Capabilities_FilesSharing_Public_ExpireDateInternalInterface rebuild(
    void Function($Capabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder].
  $Capabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Public_ExpireDateInternal
    implements
        $Capabilities_FilesSharing_Public_ExpireDateInternalInterface,
        Built<Capabilities_FilesSharing_Public_ExpireDateInternal,
            Capabilities_FilesSharing_Public_ExpireDateInternalBuilder> {
  /// Creates a new Capabilities_FilesSharing_Public_ExpireDateInternal object using the builder pattern.
  factory Capabilities_FilesSharing_Public_ExpireDateInternal([
    void Function(Capabilities_FilesSharing_Public_ExpireDateInternalBuilder)? b,
  ]) = _$Capabilities_FilesSharing_Public_ExpireDateInternal;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Public_ExpireDateInternal._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Public_ExpireDateInternal.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Public_ExpireDateInternal.
  static Serializer<Capabilities_FilesSharing_Public_ExpireDateInternal> get serializer =>
      _$capabilitiesFilesSharingPublicExpireDateInternalSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_Public_ExpireDateInternalBuilder b) {
    $Capabilities_FilesSharing_Public_ExpireDateInternalInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_Public_ExpireDateInternalBuilder b) {
    $Capabilities_FilesSharing_Public_ExpireDateInternalInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_Public_ExpireDateRemoteInterface {
  bool get enabled;
  int? get days;
  bool? get enforced;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder].
  $Capabilities_FilesSharing_Public_ExpireDateRemoteInterface rebuild(
    void Function($Capabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder].
  $Capabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Public_ExpireDateRemote
    implements
        $Capabilities_FilesSharing_Public_ExpireDateRemoteInterface,
        Built<Capabilities_FilesSharing_Public_ExpireDateRemote,
            Capabilities_FilesSharing_Public_ExpireDateRemoteBuilder> {
  /// Creates a new Capabilities_FilesSharing_Public_ExpireDateRemote object using the builder pattern.
  factory Capabilities_FilesSharing_Public_ExpireDateRemote([
    void Function(Capabilities_FilesSharing_Public_ExpireDateRemoteBuilder)? b,
  ]) = _$Capabilities_FilesSharing_Public_ExpireDateRemote;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Public_ExpireDateRemote._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Public_ExpireDateRemote.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Public_ExpireDateRemote.
  static Serializer<Capabilities_FilesSharing_Public_ExpireDateRemote> get serializer =>
      _$capabilitiesFilesSharingPublicExpireDateRemoteSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_Public_ExpireDateRemoteBuilder b) {
    $Capabilities_FilesSharing_Public_ExpireDateRemoteInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_Public_ExpireDateRemoteBuilder b) {
    $Capabilities_FilesSharing_Public_ExpireDateRemoteInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_PublicInterface {
  bool get enabled;
  Capabilities_FilesSharing_Public_Password? get password;
  @BuiltValueField(wireName: 'multiple_links')
  bool? get multipleLinks;
  @BuiltValueField(wireName: 'expire_date')
  Capabilities_FilesSharing_Public_ExpireDate? get expireDate;
  @BuiltValueField(wireName: 'expire_date_internal')
  Capabilities_FilesSharing_Public_ExpireDateInternal? get expireDateInternal;
  @BuiltValueField(wireName: 'expire_date_remote')
  Capabilities_FilesSharing_Public_ExpireDateRemote? get expireDateRemote;
  @BuiltValueField(wireName: 'send_mail')
  bool? get sendMail;
  bool? get upload;
  @BuiltValueField(wireName: 'upload_files_drop')
  bool? get uploadFilesDrop;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_PublicInterfaceBuilder].
  $Capabilities_FilesSharing_PublicInterface rebuild(
    void Function($Capabilities_FilesSharing_PublicInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_PublicInterfaceBuilder].
  $Capabilities_FilesSharing_PublicInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_PublicInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_PublicInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Public
    implements
        $Capabilities_FilesSharing_PublicInterface,
        Built<Capabilities_FilesSharing_Public, Capabilities_FilesSharing_PublicBuilder> {
  /// Creates a new Capabilities_FilesSharing_Public object using the builder pattern.
  factory Capabilities_FilesSharing_Public([void Function(Capabilities_FilesSharing_PublicBuilder)? b]) =
      _$Capabilities_FilesSharing_Public;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Public._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Public.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Public.
  static Serializer<Capabilities_FilesSharing_Public> get serializer => _$capabilitiesFilesSharingPublicSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_PublicBuilder b) {
    $Capabilities_FilesSharing_PublicInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_PublicBuilder b) {
    $Capabilities_FilesSharing_PublicInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_User_ExpireDateInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_User_ExpireDateInterfaceBuilder].
  $Capabilities_FilesSharing_User_ExpireDateInterface rebuild(
    void Function($Capabilities_FilesSharing_User_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_User_ExpireDateInterfaceBuilder].
  $Capabilities_FilesSharing_User_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_User_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_User_ExpireDateInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_User_ExpireDate
    implements
        $Capabilities_FilesSharing_User_ExpireDateInterface,
        Built<Capabilities_FilesSharing_User_ExpireDate, Capabilities_FilesSharing_User_ExpireDateBuilder> {
  /// Creates a new Capabilities_FilesSharing_User_ExpireDate object using the builder pattern.
  factory Capabilities_FilesSharing_User_ExpireDate([
    void Function(Capabilities_FilesSharing_User_ExpireDateBuilder)? b,
  ]) = _$Capabilities_FilesSharing_User_ExpireDate;

  // coverage:ignore-start
  const Capabilities_FilesSharing_User_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_User_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_User_ExpireDate.
  static Serializer<Capabilities_FilesSharing_User_ExpireDate> get serializer =>
      _$capabilitiesFilesSharingUserExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_User_ExpireDateBuilder b) {
    $Capabilities_FilesSharing_User_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_User_ExpireDateBuilder b) {
    $Capabilities_FilesSharing_User_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_UserInterface {
  @BuiltValueField(wireName: 'send_mail')
  bool get sendMail;
  @BuiltValueField(wireName: 'expire_date')
  Capabilities_FilesSharing_User_ExpireDate? get expireDate;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_UserInterfaceBuilder].
  $Capabilities_FilesSharing_UserInterface rebuild(
    void Function($Capabilities_FilesSharing_UserInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_UserInterfaceBuilder].
  $Capabilities_FilesSharing_UserInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_UserInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_UserInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_User
    implements
        $Capabilities_FilesSharing_UserInterface,
        Built<Capabilities_FilesSharing_User, Capabilities_FilesSharing_UserBuilder> {
  /// Creates a new Capabilities_FilesSharing_User object using the builder pattern.
  factory Capabilities_FilesSharing_User([void Function(Capabilities_FilesSharing_UserBuilder)? b]) =
      _$Capabilities_FilesSharing_User;

  // coverage:ignore-start
  const Capabilities_FilesSharing_User._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_User.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_User.
  static Serializer<Capabilities_FilesSharing_User> get serializer => _$capabilitiesFilesSharingUserSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_UserBuilder b) {
    $Capabilities_FilesSharing_UserInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_UserBuilder b) {
    $Capabilities_FilesSharing_UserInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_Group_ExpireDateInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_Group_ExpireDateInterfaceBuilder].
  $Capabilities_FilesSharing_Group_ExpireDateInterface rebuild(
    void Function($Capabilities_FilesSharing_Group_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_Group_ExpireDateInterfaceBuilder].
  $Capabilities_FilesSharing_Group_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_Group_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_Group_ExpireDateInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Group_ExpireDate
    implements
        $Capabilities_FilesSharing_Group_ExpireDateInterface,
        Built<Capabilities_FilesSharing_Group_ExpireDate, Capabilities_FilesSharing_Group_ExpireDateBuilder> {
  /// Creates a new Capabilities_FilesSharing_Group_ExpireDate object using the builder pattern.
  factory Capabilities_FilesSharing_Group_ExpireDate([
    void Function(Capabilities_FilesSharing_Group_ExpireDateBuilder)? b,
  ]) = _$Capabilities_FilesSharing_Group_ExpireDate;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Group_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Group_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Group_ExpireDate.
  static Serializer<Capabilities_FilesSharing_Group_ExpireDate> get serializer =>
      _$capabilitiesFilesSharingGroupExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_Group_ExpireDateBuilder b) {
    $Capabilities_FilesSharing_Group_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_Group_ExpireDateBuilder b) {
    $Capabilities_FilesSharing_Group_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_GroupInterface {
  bool get enabled;
  @BuiltValueField(wireName: 'expire_date')
  Capabilities_FilesSharing_Group_ExpireDate? get expireDate;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_GroupInterfaceBuilder].
  $Capabilities_FilesSharing_GroupInterface rebuild(
    void Function($Capabilities_FilesSharing_GroupInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_GroupInterfaceBuilder].
  $Capabilities_FilesSharing_GroupInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_GroupInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_GroupInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Group
    implements
        $Capabilities_FilesSharing_GroupInterface,
        Built<Capabilities_FilesSharing_Group, Capabilities_FilesSharing_GroupBuilder> {
  /// Creates a new Capabilities_FilesSharing_Group object using the builder pattern.
  factory Capabilities_FilesSharing_Group([void Function(Capabilities_FilesSharing_GroupBuilder)? b]) =
      _$Capabilities_FilesSharing_Group;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Group._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Group.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Group.
  static Serializer<Capabilities_FilesSharing_Group> get serializer => _$capabilitiesFilesSharingGroupSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_GroupBuilder b) {
    $Capabilities_FilesSharing_GroupInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_GroupBuilder b) {
    $Capabilities_FilesSharing_GroupInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_Federation_ExpireDateInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder].
  $Capabilities_FilesSharing_Federation_ExpireDateInterface rebuild(
    void Function($Capabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder].
  $Capabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Federation_ExpireDate
    implements
        $Capabilities_FilesSharing_Federation_ExpireDateInterface,
        Built<Capabilities_FilesSharing_Federation_ExpireDate, Capabilities_FilesSharing_Federation_ExpireDateBuilder> {
  /// Creates a new Capabilities_FilesSharing_Federation_ExpireDate object using the builder pattern.
  factory Capabilities_FilesSharing_Federation_ExpireDate([
    void Function(Capabilities_FilesSharing_Federation_ExpireDateBuilder)? b,
  ]) = _$Capabilities_FilesSharing_Federation_ExpireDate;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Federation_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Federation_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Federation_ExpireDate.
  static Serializer<Capabilities_FilesSharing_Federation_ExpireDate> get serializer =>
      _$capabilitiesFilesSharingFederationExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_Federation_ExpireDateBuilder b) {
    $Capabilities_FilesSharing_Federation_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_Federation_ExpireDateBuilder b) {
    $Capabilities_FilesSharing_Federation_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_Federation_ExpireDateSupportedInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder].
  $Capabilities_FilesSharing_Federation_ExpireDateSupportedInterface rebuild(
    void Function($Capabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder].
  $Capabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Federation_ExpireDateSupported
    implements
        $Capabilities_FilesSharing_Federation_ExpireDateSupportedInterface,
        Built<Capabilities_FilesSharing_Federation_ExpireDateSupported,
            Capabilities_FilesSharing_Federation_ExpireDateSupportedBuilder> {
  /// Creates a new Capabilities_FilesSharing_Federation_ExpireDateSupported object using the builder pattern.
  factory Capabilities_FilesSharing_Federation_ExpireDateSupported([
    void Function(Capabilities_FilesSharing_Federation_ExpireDateSupportedBuilder)? b,
  ]) = _$Capabilities_FilesSharing_Federation_ExpireDateSupported;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Federation_ExpireDateSupported._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Federation_ExpireDateSupported.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Federation_ExpireDateSupported.
  static Serializer<Capabilities_FilesSharing_Federation_ExpireDateSupported> get serializer =>
      _$capabilitiesFilesSharingFederationExpireDateSupportedSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_Federation_ExpireDateSupportedBuilder b) {
    $Capabilities_FilesSharing_Federation_ExpireDateSupportedInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_Federation_ExpireDateSupportedBuilder b) {
    $Capabilities_FilesSharing_Federation_ExpireDateSupportedInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_FederationInterface {
  bool get outgoing;
  bool get incoming;
  @BuiltValueField(wireName: 'expire_date')
  Capabilities_FilesSharing_Federation_ExpireDate get expireDate;
  @BuiltValueField(wireName: 'expire_date_supported')
  Capabilities_FilesSharing_Federation_ExpireDateSupported get expireDateSupported;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_FederationInterfaceBuilder].
  $Capabilities_FilesSharing_FederationInterface rebuild(
    void Function($Capabilities_FilesSharing_FederationInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_FederationInterfaceBuilder].
  $Capabilities_FilesSharing_FederationInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_FederationInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_FederationInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Federation
    implements
        $Capabilities_FilesSharing_FederationInterface,
        Built<Capabilities_FilesSharing_Federation, Capabilities_FilesSharing_FederationBuilder> {
  /// Creates a new Capabilities_FilesSharing_Federation object using the builder pattern.
  factory Capabilities_FilesSharing_Federation([void Function(Capabilities_FilesSharing_FederationBuilder)? b]) =
      _$Capabilities_FilesSharing_Federation;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Federation._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Federation.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Federation.
  static Serializer<Capabilities_FilesSharing_Federation> get serializer =>
      _$capabilitiesFilesSharingFederationSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_FederationBuilder b) {
    $Capabilities_FilesSharing_FederationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_FederationBuilder b) {
    $Capabilities_FilesSharing_FederationInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharing_ShareeInterface {
  @BuiltValueField(wireName: 'query_lookup_default')
  bool get queryLookupDefault;
  @BuiltValueField(wireName: 'always_show_unique')
  bool get alwaysShowUnique;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharing_ShareeInterfaceBuilder].
  $Capabilities_FilesSharing_ShareeInterface rebuild(
    void Function($Capabilities_FilesSharing_ShareeInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_FilesSharing_ShareeInterfaceBuilder].
  $Capabilities_FilesSharing_ShareeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharing_ShareeInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharing_ShareeInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing_Sharee
    implements
        $Capabilities_FilesSharing_ShareeInterface,
        Built<Capabilities_FilesSharing_Sharee, Capabilities_FilesSharing_ShareeBuilder> {
  /// Creates a new Capabilities_FilesSharing_Sharee object using the builder pattern.
  factory Capabilities_FilesSharing_Sharee([void Function(Capabilities_FilesSharing_ShareeBuilder)? b]) =
      _$Capabilities_FilesSharing_Sharee;

  // coverage:ignore-start
  const Capabilities_FilesSharing_Sharee._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing_Sharee.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing_Sharee.
  static Serializer<Capabilities_FilesSharing_Sharee> get serializer => _$capabilitiesFilesSharingShareeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharing_ShareeBuilder b) {
    $Capabilities_FilesSharing_ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharing_ShareeBuilder b) {
    $Capabilities_FilesSharing_ShareeInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesSharingInterface {
  @BuiltValueField(wireName: 'api_enabled')
  bool get apiEnabled;
  Capabilities_FilesSharing_Public get public;
  Capabilities_FilesSharing_User get user;
  bool get resharing;
  @BuiltValueField(wireName: 'group_sharing')
  bool? get groupSharing;
  Capabilities_FilesSharing_Group? get group;
  @BuiltValueField(wireName: 'default_permissions')
  int? get defaultPermissions;
  Capabilities_FilesSharing_Federation get federation;
  Capabilities_FilesSharing_Sharee get sharee;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesSharingInterfaceBuilder].
  $Capabilities_FilesSharingInterface rebuild(void Function($Capabilities_FilesSharingInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Capabilities_FilesSharingInterfaceBuilder].
  $Capabilities_FilesSharingInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesSharingInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesSharingInterfaceBuilder b) {}
}

abstract class Capabilities_FilesSharing
    implements $Capabilities_FilesSharingInterface, Built<Capabilities_FilesSharing, Capabilities_FilesSharingBuilder> {
  /// Creates a new Capabilities_FilesSharing object using the builder pattern.
  factory Capabilities_FilesSharing([void Function(Capabilities_FilesSharingBuilder)? b]) = _$Capabilities_FilesSharing;

  // coverage:ignore-start
  const Capabilities_FilesSharing._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_FilesSharing.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_FilesSharing.
  static Serializer<Capabilities_FilesSharing> get serializer => _$capabilitiesFilesSharingSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesSharingBuilder b) {
    $Capabilities_FilesSharingInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesSharingBuilder b) {
    $Capabilities_FilesSharingInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CapabilitiesInterface {
  @BuiltValueField(wireName: 'files_sharing')
  Capabilities_FilesSharing get filesSharing;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterface rebuild(void Function($CapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CapabilitiesInterfaceBuilder b) {}
}

abstract class Capabilities implements $CapabilitiesInterface, Built<Capabilities, CapabilitiesBuilder> {
  /// Creates a new Capabilities object using the builder pattern.
  factory Capabilities([void Function(CapabilitiesBuilder)? b]) = _$Capabilities;

  // coverage:ignore-start
  const Capabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities.
  static Serializer<Capabilities> get serializer => _$capabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CapabilitiesBuilder b) {
    $CapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CapabilitiesBuilder b) {
    $CapabilitiesInterface._validate(b);
  }
}

/// Serialization extension for `ShareesapiSearchShareType`.
extension $ShareesapiSearchShareTypeExtension on ShareesapiSearchShareType {
  /// Serializer for ShareesapiSearchShareType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ShareesapiSearchShareType> get serializer => $07eaa0304017ba8abe7f9f20d6a736f3Extension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static ShareesapiSearchShareType fromJson(Object? json) => $07eaa0304017ba8abe7f9f20d6a736f3Extension._fromJson(json);
}

/// Serialization extension for `ShareesapiFindRecommendedShareType`.
extension $ShareesapiFindRecommendedShareTypeExtension on ShareesapiFindRecommendedShareType {
  /// Serializer for ShareesapiFindRecommendedShareType.
  @BuiltValueSerializer(custom: true)
  static Serializer<ShareesapiFindRecommendedShareType> get serializer =>
      $07eaa0304017ba8abe7f9f20d6a736f3Extension._serializer;

  /// Creates a new object from the given [json] data.
  ///
  /// Use `toJson` to serialize it back into json.
  static ShareesapiFindRecommendedShareType fromJson(Object? json) =>
      $07eaa0304017ba8abe7f9f20d6a736f3Extension._fromJson(json);
}

typedef _$07eaa0304017ba8abe7f9f20d6a736f3 = ({BuiltList<int>? builtListInt, int? $int});

/// @nodoc
// ignore: library_private_types_in_public_api
extension $07eaa0304017ba8abe7f9f20d6a736f3Extension on _$07eaa0304017ba8abe7f9f20d6a736f3 {
  List<dynamic> get _values => [builtListInt, $int];
  List<String> get _names => const ['builtListInt', r'$int'];

  /// {@macro Dynamite.validateOneOf}
  void validateOneOf() => _i5.validateOneOf(
        _values,
        _names,
      );

  /// {@macro Dynamite.validateAnyOf}
  void validateAnyOf() => _i5.validateAnyOf(
        _values,
        _names,
      );
  static Serializer<_$07eaa0304017ba8abe7f9f20d6a736f3> get _serializer =>
      const _$07eaa0304017ba8abe7f9f20d6a736f3Serializer();
  static _$07eaa0304017ba8abe7f9f20d6a736f3 _fromJson(Object? json) =>
      _$jsonSerializers.deserializeWith(_serializer, json)!;

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  Object? toJson() => _$jsonSerializers.serializeWith(_serializer, this);
}

class _$07eaa0304017ba8abe7f9f20d6a736f3Serializer implements PrimitiveSerializer<_$07eaa0304017ba8abe7f9f20d6a736f3> {
  const _$07eaa0304017ba8abe7f9f20d6a736f3Serializer();

  @override
  Iterable<Type> get types => const [_$07eaa0304017ba8abe7f9f20d6a736f3];

  @override
  String get wireName => r'_$07eaa0304017ba8abe7f9f20d6a736f3';

  @override
  Object serialize(
    Serializers serializers,
    _$07eaa0304017ba8abe7f9f20d6a736f3 object, {
    FullType specifiedType = FullType.unspecified,
  }) {
    dynamic value;
    value = object.builtListInt;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(BuiltList, [FullType(int)]))!;
    }
    value = object.$int;
    if (value != null) {
      return serializers.serialize(value, specifiedType: const FullType(int))!;
    }
// Should not be possible after validation.
    throw StateError('Tried to serialize without any value.');
  }

  @override
  _$07eaa0304017ba8abe7f9f20d6a736f3 deserialize(
    Serializers serializers,
    Object data, {
    FullType specifiedType = FullType.unspecified,
  }) {
    BuiltList<int>? builtListInt;
    try {
      builtListInt = serializers.deserialize(
        data,
        specifiedType: const FullType(BuiltList, [FullType(int)]),
      )! as BuiltList<int>;
    } catch (_) {}
    int? $int;
    try {
      $int = serializers.deserialize(
        data,
        specifiedType: const FullType(int),
      )! as int;
    } catch (_) {}
    return (builtListInt: builtListInt, $int: $int);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(
        const FullType(DeletedShareapiIndexResponseApplicationJson),
        DeletedShareapiIndexResponseApplicationJsonBuilder.new,
      )
      ..add(DeletedShareapiIndexResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DeletedShareapiIndexResponseApplicationJson_Ocs),
        DeletedShareapiIndexResponseApplicationJson_OcsBuilder.new,
      )
      ..add(DeletedShareapiIndexResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(const FullType(DeletedShare), DeletedShareBuilder.new)
      ..add(DeletedShare.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(DeletedShare)]), ListBuilder<DeletedShare>.new)
      ..addBuilderFactory(
        const FullType(DeletedShareapiUndeleteResponseApplicationJson),
        DeletedShareapiUndeleteResponseApplicationJsonBuilder.new,
      )
      ..add(DeletedShareapiUndeleteResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DeletedShareapiUndeleteResponseApplicationJson_Ocs),
        DeletedShareapiUndeleteResponseApplicationJson_OcsBuilder.new,
      )
      ..add(DeletedShareapiUndeleteResponseApplicationJson_Ocs.serializer)
      ..add(PublicPreviewGetPreviewA.serializer)
      ..addBuilderFactory(
        const FullType(RemoteGetSharesResponseApplicationJson),
        RemoteGetSharesResponseApplicationJsonBuilder.new,
      )
      ..add(RemoteGetSharesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(RemoteGetSharesResponseApplicationJson_Ocs),
        RemoteGetSharesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(RemoteGetSharesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(RemoteShare), RemoteShareBuilder.new)
      ..add(RemoteShare.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(RemoteShare)]), ListBuilder<RemoteShare>.new)
      ..addBuilderFactory(
        const FullType(RemoteGetOpenSharesResponseApplicationJson),
        RemoteGetOpenSharesResponseApplicationJsonBuilder.new,
      )
      ..add(RemoteGetOpenSharesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(RemoteGetOpenSharesResponseApplicationJson_Ocs),
        RemoteGetOpenSharesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(RemoteGetOpenSharesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(RemoteAcceptShareResponseApplicationJson),
        RemoteAcceptShareResponseApplicationJsonBuilder.new,
      )
      ..add(RemoteAcceptShareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(RemoteAcceptShareResponseApplicationJson_Ocs),
        RemoteAcceptShareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(RemoteAcceptShareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(RemoteDeclineShareResponseApplicationJson),
        RemoteDeclineShareResponseApplicationJsonBuilder.new,
      )
      ..add(RemoteDeclineShareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(RemoteDeclineShareResponseApplicationJson_Ocs),
        RemoteDeclineShareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(RemoteDeclineShareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(RemoteGetShareResponseApplicationJson),
        RemoteGetShareResponseApplicationJsonBuilder.new,
      )
      ..add(RemoteGetShareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(RemoteGetShareResponseApplicationJson_Ocs),
        RemoteGetShareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(RemoteGetShareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(RemoteUnshareResponseApplicationJson),
        RemoteUnshareResponseApplicationJsonBuilder.new,
      )
      ..add(RemoteUnshareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(RemoteUnshareResponseApplicationJson_Ocs),
        RemoteUnshareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(RemoteUnshareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ShareInfoInfoRequestApplicationJson),
        ShareInfoInfoRequestApplicationJsonBuilder.new,
      )
      ..add(ShareInfoInfoRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(ShareInfo), ShareInfoBuilder.new)
      ..add(ShareInfo.serializer)
      ..addBuilderFactory(
        const FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
        MapBuilder<String, JsonObject>.new,
      )
      ..addBuilderFactory(
        const FullType(BuiltList, [
          FullType(BuiltMap, [FullType(String), FullType(JsonObject)]),
        ]),
        ListBuilder<BuiltMap<String, JsonObject>>.new,
      )
      ..addBuilderFactory(
        const FullType(ShareapiGetSharesResponseApplicationJson),
        ShareapiGetSharesResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiGetSharesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiGetSharesResponseApplicationJson_Ocs),
        ShareapiGetSharesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiGetSharesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Share), ShareBuilder.new)
      ..add(Share.serializer)
      ..add(Share_HideDownload.serializer)
      ..add(Share_ItemType.serializer)
      ..add(Share_MailSend.serializer)
      ..addBuilderFactory(const FullType(Share_Status), Share_StatusBuilder.new)
      ..add(Share_Status.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Share)]), ListBuilder<Share>.new)
      ..addBuilderFactory(
        const FullType(ShareapiCreateShareRequestApplicationJson),
        ShareapiCreateShareRequestApplicationJsonBuilder.new,
      )
      ..add(ShareapiCreateShareRequestApplicationJson.serializer)
      ..add(ShareapiCreateShareRequestApplicationJson_SendMail.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiCreateShareResponseApplicationJson),
        ShareapiCreateShareResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiCreateShareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiCreateShareResponseApplicationJson_Ocs),
        ShareapiCreateShareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiCreateShareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiGetInheritedSharesResponseApplicationJson),
        ShareapiGetInheritedSharesResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiGetInheritedSharesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiGetInheritedSharesResponseApplicationJson_Ocs),
        ShareapiGetInheritedSharesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiGetInheritedSharesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiPendingSharesResponseApplicationJson),
        ShareapiPendingSharesResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiPendingSharesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiPendingSharesResponseApplicationJson_Ocs),
        ShareapiPendingSharesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiPendingSharesResponseApplicationJson_Ocs.serializer)
      ..add(ShareapiGetShareIncludeTags.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiGetShareResponseApplicationJson),
        ShareapiGetShareResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiGetShareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiGetShareResponseApplicationJson_Ocs),
        ShareapiGetShareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiGetShareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiUpdateShareRequestApplicationJson),
        ShareapiUpdateShareRequestApplicationJsonBuilder.new,
      )
      ..add(ShareapiUpdateShareRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiUpdateShareResponseApplicationJson),
        ShareapiUpdateShareResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiUpdateShareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiUpdateShareResponseApplicationJson_Ocs),
        ShareapiUpdateShareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiUpdateShareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiDeleteShareResponseApplicationJson),
        ShareapiDeleteShareResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiDeleteShareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiDeleteShareResponseApplicationJson_Ocs),
        ShareapiDeleteShareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiDeleteShareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiSendShareEmailRequestApplicationJson),
        ShareapiSendShareEmailRequestApplicationJsonBuilder.new,
      )
      ..add(ShareapiSendShareEmailRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiSendShareEmailResponseApplicationJson),
        ShareapiSendShareEmailResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiSendShareEmailResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiSendShareEmailResponseApplicationJson_Ocs),
        ShareapiSendShareEmailResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiSendShareEmailResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiAcceptShareResponseApplicationJson),
        ShareapiAcceptShareResponseApplicationJsonBuilder.new,
      )
      ..add(ShareapiAcceptShareResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareapiAcceptShareResponseApplicationJson_Ocs),
        ShareapiAcceptShareResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareapiAcceptShareResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(int)]), ListBuilder<int>.new)
      ..add($07eaa0304017ba8abe7f9f20d6a736f3Extension._serializer)
      ..add(ShareesapiSearchLookup.serializer)
      ..addBuilderFactory(
        const FullType(ShareesapiSearchResponseApplicationJson),
        ShareesapiSearchResponseApplicationJsonBuilder.new,
      )
      ..add(ShareesapiSearchResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareesapiSearchResponseApplicationJson_Ocs),
        ShareesapiSearchResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareesapiSearchResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(ShareesSearchResult), ShareesSearchResultBuilder.new)
      ..add(ShareesSearchResult.serializer)
      ..addBuilderFactory(const FullType(ShareesSearchResult_Exact), ShareesSearchResult_ExactBuilder.new)
      ..add(ShareesSearchResult_Exact.serializer)
      ..addBuilderFactory(const FullType(ShareeCircle), ShareeCircleBuilder.new)
      ..add(ShareeCircle.serializer)
      ..addBuilderFactory(const FullType(Sharee), ShareeBuilder.new)
      ..add(Sharee.serializer)
      ..addBuilderFactory(const FullType(ShareeCircle_Value), ShareeCircle_ValueBuilder.new)
      ..add(ShareeCircle_Value.serializer)
      ..addBuilderFactory(const FullType(ShareeValue), ShareeValueBuilder.new)
      ..add(ShareeValue.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(ShareeCircle)]), ListBuilder<ShareeCircle>.new)
      ..addBuilderFactory(const FullType(ShareeEmail), ShareeEmailBuilder.new)
      ..add(ShareeEmail.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(ShareeEmail)]), ListBuilder<ShareeEmail>.new)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Sharee)]), ListBuilder<Sharee>.new)
      ..addBuilderFactory(const FullType(ShareeRemoteGroup), ShareeRemoteGroupBuilder.new)
      ..add(ShareeRemoteGroup.serializer)
      ..addBuilderFactory(const FullType(ShareeRemoteGroup_Value), ShareeRemoteGroup_ValueBuilder.new)
      ..add(ShareeRemoteGroup_Value.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(ShareeRemoteGroup)]), ListBuilder<ShareeRemoteGroup>.new)
      ..addBuilderFactory(const FullType(ShareeRemote), ShareeRemoteBuilder.new)
      ..add(ShareeRemote.serializer)
      ..addBuilderFactory(const FullType(ShareeRemote_Value), ShareeRemote_ValueBuilder.new)
      ..add(ShareeRemote_Value.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(ShareeRemote)]), ListBuilder<ShareeRemote>.new)
      ..addBuilderFactory(const FullType(ShareeUser), ShareeUserBuilder.new)
      ..add(ShareeUser.serializer)
      ..addBuilderFactory(const FullType(ShareeUser_Status), ShareeUser_StatusBuilder.new)
      ..add(ShareeUser_Status.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(ShareeUser)]), ListBuilder<ShareeUser>.new)
      ..addBuilderFactory(const FullType(ShareeLookup), ShareeLookupBuilder.new)
      ..add(ShareeLookup.serializer)
      ..addBuilderFactory(const FullType(ShareeLookup_Extra), ShareeLookup_ExtraBuilder.new)
      ..add(ShareeLookup_Extra.serializer)
      ..addBuilderFactory(const FullType(Lookup), LookupBuilder.new)
      ..add(Lookup.serializer)
      ..addBuilderFactory(const FullType(ShareeLookup_Value), ShareeLookup_ValueBuilder.new)
      ..add(ShareeLookup_Value.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(ShareeLookup)]), ListBuilder<ShareeLookup>.new)
      ..addBuilderFactory(
        const FullType(ShareesapiShareesapiSearchHeaders),
        ShareesapiShareesapiSearchHeadersBuilder.new,
      )
      ..add(ShareesapiShareesapiSearchHeaders.serializer)
      ..addBuilderFactory(
        const FullType(ShareesapiFindRecommendedResponseApplicationJson),
        ShareesapiFindRecommendedResponseApplicationJsonBuilder.new,
      )
      ..add(ShareesapiFindRecommendedResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(ShareesapiFindRecommendedResponseApplicationJson_Ocs),
        ShareesapiFindRecommendedResponseApplicationJson_OcsBuilder.new,
      )
      ..add(ShareesapiFindRecommendedResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(ShareesRecommendedResult), ShareesRecommendedResultBuilder.new)
      ..add(ShareesRecommendedResult.serializer)
      ..addBuilderFactory(const FullType(ShareesRecommendedResult_Exact), ShareesRecommendedResult_ExactBuilder.new)
      ..add(ShareesRecommendedResult_Exact.serializer)
      ..addBuilderFactory(const FullType(Capabilities), CapabilitiesBuilder.new)
      ..add(Capabilities.serializer)
      ..addBuilderFactory(const FullType(Capabilities_FilesSharing), Capabilities_FilesSharingBuilder.new)
      ..add(Capabilities_FilesSharing.serializer)
      ..addBuilderFactory(const FullType(Capabilities_FilesSharing_Public), Capabilities_FilesSharing_PublicBuilder.new)
      ..add(Capabilities_FilesSharing_Public.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_Public_Password),
        Capabilities_FilesSharing_Public_PasswordBuilder.new,
      )
      ..add(Capabilities_FilesSharing_Public_Password.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_Public_ExpireDate),
        Capabilities_FilesSharing_Public_ExpireDateBuilder.new,
      )
      ..add(Capabilities_FilesSharing_Public_ExpireDate.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_Public_ExpireDateInternal),
        Capabilities_FilesSharing_Public_ExpireDateInternalBuilder.new,
      )
      ..add(Capabilities_FilesSharing_Public_ExpireDateInternal.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_Public_ExpireDateRemote),
        Capabilities_FilesSharing_Public_ExpireDateRemoteBuilder.new,
      )
      ..add(Capabilities_FilesSharing_Public_ExpireDateRemote.serializer)
      ..addBuilderFactory(const FullType(Capabilities_FilesSharing_User), Capabilities_FilesSharing_UserBuilder.new)
      ..add(Capabilities_FilesSharing_User.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_User_ExpireDate),
        Capabilities_FilesSharing_User_ExpireDateBuilder.new,
      )
      ..add(Capabilities_FilesSharing_User_ExpireDate.serializer)
      ..addBuilderFactory(const FullType(Capabilities_FilesSharing_Group), Capabilities_FilesSharing_GroupBuilder.new)
      ..add(Capabilities_FilesSharing_Group.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_Group_ExpireDate),
        Capabilities_FilesSharing_Group_ExpireDateBuilder.new,
      )
      ..add(Capabilities_FilesSharing_Group_ExpireDate.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_Federation),
        Capabilities_FilesSharing_FederationBuilder.new,
      )
      ..add(Capabilities_FilesSharing_Federation.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_Federation_ExpireDate),
        Capabilities_FilesSharing_Federation_ExpireDateBuilder.new,
      )
      ..add(Capabilities_FilesSharing_Federation_ExpireDate.serializer)
      ..addBuilderFactory(
        const FullType(Capabilities_FilesSharing_Federation_ExpireDateSupported),
        Capabilities_FilesSharing_Federation_ExpireDateSupportedBuilder.new,
      )
      ..add(Capabilities_FilesSharing_Federation_ExpireDateSupported.serializer)
      ..addBuilderFactory(const FullType(Capabilities_FilesSharing_Sharee), Capabilities_FilesSharing_ShareeBuilder.new)
      ..add(Capabilities_FilesSharing_Sharee.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(_i8.StandardJsonPlugin(typesToLeaveAsList: const {_$07eaa0304017ba8abe7f9f20d6a736f3}))
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
