// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// files Version: 0.0.1.
///
/// File Management.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';
import 'dart:typed_data';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i6;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i4;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i5;

part 'files.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $ApiClient api = $ApiClient(this);

  late final $DirectEditingClient directEditing = $DirectEditingClient(this);

  late final $OpenLocalEditorClient openLocalEditor = $OpenLocalEditorClient(this);

  late final $TemplateClient template = $TemplateClient(this);

  late final $TransferOwnershipClient transferOwnership = $TransferOwnershipClient(this);
}

class $ApiClient {
  /// Creates a new `DynamiteClient` for api requests.
  $ApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getThumbnail_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getThumbnail_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Gets a thumbnail of the specified file.
  ///
  /// Returns a `DynamiteRequest` backing the [getThumbnail] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [x] Width of the thumbnail.
  ///   * [y] Height of the thumbnail.
  ///   * [file] URL-encoded filename.
  ///
  /// Status codes:
  ///   * 200: Thumbnail returned
  ///   * 400: Getting thumbnail is not possible
  ///   * 404: File not found
  ///
  /// See:
  ///  * [getThumbnail] for a method executing this request and parsing the response.
  ///  * [$getThumbnail_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getThumbnail_Request({
    required int x,
    required int y,
    required String file,
  }) {
    final _parameters = <String, Object?>{};
    final __x = _$jsonSerializers.serialize(x, specifiedType: const FullType(int));
    _parameters['x'] = __x;

    final __y = _$jsonSerializers.serialize(y, specifiedType: const FullType(int));
    _parameters['y'] = __y;

    final __file = _$jsonSerializers.serialize(file, specifiedType: const FullType(String));
    _i4.checkString(
      __file,
      'file',
      pattern: RegExp(r'^.+$'),
    );
    _parameters['file'] = __file;

    final _path = _i5.UriTemplate('/index.php/apps/files/api/v1/thumbnail/{x}/{y}/{file}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Gets a thumbnail of the specified file.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [x] Width of the thumbnail.
  ///   * [y] Height of the thumbnail.
  ///   * [file] URL-encoded filename.
  ///
  /// Status codes:
  ///   * 200: Thumbnail returned
  ///   * 400: Getting thumbnail is not possible
  ///   * 404: File not found
  ///
  /// See:
  ///  * [$getThumbnail_Request] for the request send by this method.
  ///  * [$getThumbnail_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getThumbnail({
    required int x,
    required int y,
    required String file,
  }) async {
    final _request = $getThumbnail_Request(
      x: x,
      y: y,
      file: file,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getThumbnail_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getFolderTree_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<FolderTree>, void> $getFolderTree_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(FolderTree)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns the folder tree of the user.
  ///
  /// Returns a `DynamiteRequest` backing the [getFolderTree] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [path] The path relative to the user folder. Defaults to `"/"`.
  ///   * [depth] The depth of the tree. Defaults to `1`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Folder tree returned successfully
  ///   * 401: Unauthorized
  ///   * 400: Invalid folder path
  ///   * 404: Folder not found
  ///
  /// See:
  ///  * [getFolderTree] for a method executing this request and parsing the response.
  ///  * [$getFolderTree_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getFolderTree_Request({
    String? path,
    int? depth,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __path = _$jsonSerializers.serialize(path, specifiedType: const FullType(String));
    __path ??= '/';
    _parameters['path'] = __path;

    var __depth = _$jsonSerializers.serialize(depth, specifiedType: const FullType(int));
    __depth ??= 1;
    _parameters['depth'] = __depth;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/files/api/v1/folder-tree{?path*,depth*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Returns the folder tree of the user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [path] The path relative to the user folder. Defaults to `"/"`.
  ///   * [depth] The depth of the tree. Defaults to `1`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Folder tree returned successfully
  ///   * 401: Unauthorized
  ///   * 400: Invalid folder path
  ///   * 404: Folder not found
  ///
  /// See:
  ///  * [$getFolderTree_Request] for the request send by this method.
  ///  * [$getFolderTree_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<FolderTree>, void>> getFolderTree({
    String? path,
    int? depth,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getFolderTree_Request(
      path: path,
      depth: depth,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getFolderTree_Serializer();
    return _i1.ResponseConverter<BuiltList<FolderTree>, void>(_serializer).convert(_response);
  }
}

class $DirectEditingClient {
  /// Creates a new `DynamiteClient` for direct_editing requests.
  $DirectEditingClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$info_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DirectEditingInfoResponseApplicationJson, void> $info_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(DirectEditingInfoResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the direct editing capabilities.
  ///
  /// Returns a `DynamiteRequest` backing the [info] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Direct editing capabilities returned
  ///
  /// See:
  ///  * [info] for a method executing this request and parsing the response.
  ///  * [$info_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $info_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/files/api/v1/directEditing';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the direct editing capabilities.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Direct editing capabilities returned
  ///
  /// See:
  ///  * [$info_Request] for the request send by this method.
  ///  * [$info_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DirectEditingInfoResponseApplicationJson, void>> info({bool? oCSAPIRequest}) async {
    final _request = $info_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $info_Serializer();
    return _i1.ResponseConverter<DirectEditingInfoResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$templates_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DirectEditingTemplatesResponseApplicationJson, void> $templates_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(DirectEditingTemplatesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the templates for direct editing.
  ///
  /// Returns a `DynamiteRequest` backing the [templates] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [editorId] ID of the editor.
  ///   * [creatorId] ID of the creator.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Templates returned
  ///   * 500
  ///
  /// See:
  ///  * [templates] for a method executing this request and parsing the response.
  ///  * [$templates_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $templates_Request({
    required String editorId,
    required String creatorId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __editorId = _$jsonSerializers.serialize(editorId, specifiedType: const FullType(String));
    _parameters['editorId'] = __editorId;

    final __creatorId = _$jsonSerializers.serialize(creatorId, specifiedType: const FullType(String));
    _parameters['creatorId'] = __creatorId;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/files/api/v1/directEditing/templates/{editorId}/{creatorId}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the templates for direct editing.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [editorId] ID of the editor.
  ///   * [creatorId] ID of the creator.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Templates returned
  ///   * 500
  ///
  /// See:
  ///  * [$templates_Request] for the request send by this method.
  ///  * [$templates_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DirectEditingTemplatesResponseApplicationJson, void>> templates({
    required String editorId,
    required String creatorId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $templates_Request(
      editorId: editorId,
      creatorId: creatorId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $templates_Serializer();
    return _i1.ResponseConverter<DirectEditingTemplatesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$open_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DirectEditingOpenResponseApplicationJson, void> $open_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(DirectEditingOpenResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Open a file for direct editing.
  ///
  /// Returns a `DynamiteRequest` backing the [open] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: URL for direct editing returned
  ///   * 403: Opening file is not allowed
  ///   * 500
  ///
  /// See:
  ///  * [open] for a method executing this request and parsing the response.
  ///  * [$open_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $open_Request({
    required DirectEditingOpenRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/files/api/v1/directEditing/open';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(DirectEditingOpenRequestApplicationJson)),
    );
    return _request;
  }

  /// Open a file for direct editing.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: URL for direct editing returned
  ///   * 403: Opening file is not allowed
  ///   * 500
  ///
  /// See:
  ///  * [$open_Request] for the request send by this method.
  ///  * [$open_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DirectEditingOpenResponseApplicationJson, void>> open({
    required DirectEditingOpenRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $open_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $open_Serializer();
    return _i1.ResponseConverter<DirectEditingOpenResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$create_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DirectEditingCreateResponseApplicationJson, void> $create_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(DirectEditingCreateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a file for direct editing.
  ///
  /// Returns a `DynamiteRequest` backing the [create] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: URL for direct editing returned
  ///   * 403: Opening file is not allowed
  ///   * 500
  ///
  /// See:
  ///  * [create] for a method executing this request and parsing the response.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $create_Request({
    required DirectEditingCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/files/api/v1/directEditing/create';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(DirectEditingCreateRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a file for direct editing.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: URL for direct editing returned
  ///   * 403: Opening file is not allowed
  ///   * 500
  ///
  /// See:
  ///  * [$create_Request] for the request send by this method.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DirectEditingCreateResponseApplicationJson, void>> create({
    required DirectEditingCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $create_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $create_Serializer();
    return _i1.ResponseConverter<DirectEditingCreateResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $OpenLocalEditorClient {
  /// Creates a new `DynamiteClient` for open_local_editor requests.
  $OpenLocalEditorClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$create_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<OpenLocalEditorCreateResponseApplicationJson, void> $create_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(OpenLocalEditorCreateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a local editor.
  ///
  /// Returns a `DynamiteRequest` backing the [create] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Local editor returned
  ///   * 500
  ///
  /// See:
  ///  * [create] for a method executing this request and parsing the response.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $create_Request({
    required OpenLocalEditorCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/files/api/v1/openlocaleditor';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(OpenLocalEditorCreateRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a local editor.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Local editor returned
  ///   * 500
  ///
  /// See:
  ///  * [$create_Request] for the request send by this method.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<OpenLocalEditorCreateResponseApplicationJson, void>> create({
    required OpenLocalEditorCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $create_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $create_Serializer();
    return _i1.ResponseConverter<OpenLocalEditorCreateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$validate_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<OpenLocalEditorValidateResponseApplicationJson, void> $validate_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(OpenLocalEditorValidateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Validate a local editor.
  ///
  /// Returns a `DynamiteRequest` backing the [validate] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [token] Token of the local editor.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Local editor validated successfully
  ///   * 404: Local editor not found
  ///
  /// See:
  ///  * [validate] for a method executing this request and parsing the response.
  ///  * [$validate_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $validate_Request({
    required String token,
    required OpenLocalEditorValidateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __token = _$jsonSerializers.serialize(token, specifiedType: const FullType(String));
    _parameters['token'] = __token;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/files/api/v1/openlocaleditor/{token}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(OpenLocalEditorValidateRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Validate a local editor.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [token] Token of the local editor.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Local editor validated successfully
  ///   * 404: Local editor not found
  ///
  /// See:
  ///  * [$validate_Request] for the request send by this method.
  ///  * [$validate_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<OpenLocalEditorValidateResponseApplicationJson, void>> validate({
    required String token,
    required OpenLocalEditorValidateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $validate_Request(
      token: token,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $validate_Serializer();
    return _i1.ResponseConverter<OpenLocalEditorValidateResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $TemplateClient {
  /// Creates a new `DynamiteClient` for template requests.
  $TemplateClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$list_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TemplateListResponseApplicationJson, void> $list_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(TemplateListResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// List the available templates.
  ///
  /// Returns a `DynamiteRequest` backing the [list] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Available templates returned
  ///
  /// See:
  ///  * [list] for a method executing this request and parsing the response.
  ///  * [$list_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $list_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/apps/files/api/v1/templates';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// List the available templates.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Available templates returned
  ///
  /// See:
  ///  * [$list_Request] for the request send by this method.
  ///  * [$list_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TemplateListResponseApplicationJson, void>> list({bool? oCSAPIRequest}) async {
    final _request = $list_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $list_Serializer();
    return _i1.ResponseConverter<TemplateListResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$create_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TemplateCreateResponseApplicationJson, void> $create_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(TemplateCreateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a template.
  ///
  /// Returns a `DynamiteRequest` backing the [create] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Template created successfully
  ///   * 403: Creating template is not allowed
  ///
  /// See:
  ///  * [create] for a method executing this request and parsing the response.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $create_Request({
    required TemplateCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/files/api/v1/templates/create';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(TemplateCreateRequestApplicationJson)),
    );
    return _request;
  }

  /// Create a template.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Template created successfully
  ///   * 403: Creating template is not allowed
  ///
  /// See:
  ///  * [$create_Request] for the request send by this method.
  ///  * [$create_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TemplateCreateResponseApplicationJson, void>> create({
    required TemplateCreateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $create_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $create_Serializer();
    return _i1.ResponseConverter<TemplateCreateResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$path_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TemplatePathResponseApplicationJson, void> $path_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(TemplatePathResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Initialize the template directory.
  ///
  /// Returns a `DynamiteRequest` backing the [path] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Template directory initialized successfully
  ///   * 403: Initializing the template directory is not allowed
  ///
  /// See:
  ///  * [path] for a method executing this request and parsing the response.
  ///  * [$path_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $path_Request({
    bool? oCSAPIRequest,
    TemplatePathRequestApplicationJson? $body,
  }) {
    const _path = '/ocs/v2.php/apps/files/api/v1/templates/path';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize($body, specifiedType: const FullType(TemplatePathRequestApplicationJson)),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              TemplatePathRequestApplicationJson(),
              specifiedType: const FullType(TemplatePathRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Initialize the template directory.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Template directory initialized successfully
  ///   * 403: Initializing the template directory is not allowed
  ///
  /// See:
  ///  * [$path_Request] for the request send by this method.
  ///  * [$path_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TemplatePathResponseApplicationJson, void>> path({
    bool? oCSAPIRequest,
    TemplatePathRequestApplicationJson? $body,
  }) async {
    final _request = $path_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $path_Serializer();
    return _i1.ResponseConverter<TemplatePathResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $TransferOwnershipClient {
  /// Creates a new `DynamiteClient` for transfer_ownership requests.
  $TransferOwnershipClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$transfer_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TransferOwnershipTransferResponseApplicationJson, void> $transfer_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TransferOwnershipTransferResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400, 403},
      );

  /// Transfer the ownership to another user.
  ///
  /// Returns a `DynamiteRequest` backing the [transfer] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership transferred successfully
  ///   * 400: Transferring ownership is not possible
  ///   * 403: Transferring ownership is not allowed
  ///
  /// See:
  ///  * [transfer] for a method executing this request and parsing the response.
  ///  * [$transfer_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $transfer_Request({
    required TransferOwnershipTransferRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/files/api/v1/transferownership';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(TransferOwnershipTransferRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Transfer the ownership to another user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership transferred successfully
  ///   * 400: Transferring ownership is not possible
  ///   * 403: Transferring ownership is not allowed
  ///
  /// See:
  ///  * [$transfer_Request] for the request send by this method.
  ///  * [$transfer_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TransferOwnershipTransferResponseApplicationJson, void>> transfer({
    required TransferOwnershipTransferRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $transfer_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $transfer_Serializer();
    return _i1.ResponseConverter<TransferOwnershipTransferResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$accept_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TransferOwnershipAcceptResponseApplicationJson, void> $accept_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TransferOwnershipAcceptResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 403, 404},
      );

  /// Accept an ownership transfer.
  ///
  /// Returns a `DynamiteRequest` backing the [accept] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the ownership transfer.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership transfer accepted successfully
  ///   * 403: Accepting ownership transfer is not allowed
  ///   * 404: Ownership transfer not found
  ///
  /// See:
  ///  * [accept] for a method executing this request and parsing the response.
  ///  * [$accept_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $accept_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/files/api/v1/transferownership/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Accept an ownership transfer.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the ownership transfer.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership transfer accepted successfully
  ///   * 403: Accepting ownership transfer is not allowed
  ///   * 404: Ownership transfer not found
  ///
  /// See:
  ///  * [$accept_Request] for the request send by this method.
  ///  * [$accept_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TransferOwnershipAcceptResponseApplicationJson, void>> accept({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $accept_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $accept_Serializer();
    return _i1.ResponseConverter<TransferOwnershipAcceptResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$reject_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TransferOwnershipRejectResponseApplicationJson, void> $reject_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TransferOwnershipRejectResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 403, 404},
      );

  /// Reject an ownership transfer.
  ///
  /// Returns a `DynamiteRequest` backing the [reject] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the ownership transfer.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership transfer rejected successfully
  ///   * 403: Rejecting ownership transfer is not allowed
  ///   * 404: Ownership transfer not found
  ///
  /// See:
  ///  * [reject] for a method executing this request and parsing the response.
  ///  * [$reject_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $reject_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/ocs/v2.php/apps/files/api/v1/transferownership/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i6.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i4.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Reject an ownership transfer.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] ID of the ownership transfer.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Ownership transfer rejected successfully
  ///   * 403: Rejecting ownership transfer is not allowed
  ///   * 404: Ownership transfer not found
  ///
  /// See:
  ///  * [$reject_Request] for the request send by this method.
  ///  * [$reject_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TransferOwnershipRejectResponseApplicationJson, void>> reject({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $reject_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $reject_Serializer();
    return _i1.ResponseConverter<TransferOwnershipRejectResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $FolderTreeInterface {
  int get id;
  String get basename;
  String? get displayName;
  BuiltList<JsonObject> get children;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FolderTreeInterfaceBuilder].
  $FolderTreeInterface rebuild(void Function($FolderTreeInterfaceBuilder) updates);

  /// Converts the instance to a builder [$FolderTreeInterfaceBuilder].
  $FolderTreeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FolderTreeInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FolderTreeInterfaceBuilder b) {}
}

abstract class FolderTree implements $FolderTreeInterface, Built<FolderTree, FolderTreeBuilder> {
  /// Creates a new FolderTree object using the builder pattern.
  factory FolderTree([void Function(FolderTreeBuilder)? b]) = _$FolderTree;

  // coverage:ignore-start
  const FolderTree._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FolderTree.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FolderTree.
  static Serializer<FolderTree> get serializer => _$folderTreeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FolderTreeBuilder b) {
    $FolderTreeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FolderTreeBuilder b) {
    $FolderTreeInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterface {
  String get id;
  String get name;
  BuiltList<String> get mimetypes;
  BuiltList<String> get optionalMimetypes;
  bool get secure;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterface rebuild(
    void Function($DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterfaceBuilder b) {}
}

abstract class DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors
    implements
        $DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterface,
        Built<DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors,
            DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsBuilder> {
  /// Creates a new DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors object using the builder pattern.
  factory DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors([
    void Function(DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsBuilder)? b,
  ]) = _$DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors;

  // coverage:ignore-start
  const DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors.
  static Serializer<DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors> get serializer =>
      _$directEditingInfoResponseApplicationJsonOcsDataEditorsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsBuilder b) {
    $DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsBuilder b) {
    $DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterface {
  String get id;
  String get editor;
  String get name;
  @BuiltValueField(wireName: 'extension')
  String get $extension;
  bool get templates;
  BuiltList<String> get mimetypes;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterface rebuild(
    void Function($DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterfaceBuilder b) {}
}

abstract class DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators
    implements
        $DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterface,
        Built<DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators,
            DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsBuilder> {
  /// Creates a new DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators object using the builder pattern.
  factory DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators([
    void Function(DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsBuilder)? b,
  ]) = _$DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators;

  // coverage:ignore-start
  const DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators.
  static Serializer<DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators> get serializer =>
      _$directEditingInfoResponseApplicationJsonOcsDataCreatorsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsBuilder b) {
    $DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsBuilder b) {
    $DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingInfoResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors> get editors;
  BuiltMap<String, DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators> get creators;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingInfoResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($DirectEditingInfoResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingInfoResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingInfoResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingInfoResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class DirectEditingInfoResponseApplicationJson_Ocs_Data
    implements
        $DirectEditingInfoResponseApplicationJson_Ocs_DataInterface,
        Built<DirectEditingInfoResponseApplicationJson_Ocs_Data,
            DirectEditingInfoResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new DirectEditingInfoResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory DirectEditingInfoResponseApplicationJson_Ocs_Data([
    void Function(DirectEditingInfoResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$DirectEditingInfoResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const DirectEditingInfoResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingInfoResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingInfoResponseApplicationJson_Ocs_Data.
  static Serializer<DirectEditingInfoResponseApplicationJson_Ocs_Data> get serializer =>
      _$directEditingInfoResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingInfoResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectEditingInfoResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingInfoResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectEditingInfoResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingInfoResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  DirectEditingInfoResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingInfoResponseApplicationJson_OcsInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJson_OcsInterface rebuild(
    void Function($DirectEditingInfoResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingInfoResponseApplicationJson_OcsInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingInfoResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingInfoResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class DirectEditingInfoResponseApplicationJson_Ocs
    implements
        $DirectEditingInfoResponseApplicationJson_OcsInterface,
        Built<DirectEditingInfoResponseApplicationJson_Ocs, DirectEditingInfoResponseApplicationJson_OcsBuilder> {
  /// Creates a new DirectEditingInfoResponseApplicationJson_Ocs object using the builder pattern.
  factory DirectEditingInfoResponseApplicationJson_Ocs([
    void Function(DirectEditingInfoResponseApplicationJson_OcsBuilder)? b,
  ]) = _$DirectEditingInfoResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const DirectEditingInfoResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingInfoResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingInfoResponseApplicationJson_Ocs.
  static Serializer<DirectEditingInfoResponseApplicationJson_Ocs> get serializer =>
      _$directEditingInfoResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingInfoResponseApplicationJson_OcsBuilder b) {
    $DirectEditingInfoResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingInfoResponseApplicationJson_OcsBuilder b) {
    $DirectEditingInfoResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingInfoResponseApplicationJsonInterface {
  DirectEditingInfoResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingInfoResponseApplicationJsonInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJsonInterface rebuild(
    void Function($DirectEditingInfoResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingInfoResponseApplicationJsonInterfaceBuilder].
  $DirectEditingInfoResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingInfoResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingInfoResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DirectEditingInfoResponseApplicationJson
    implements
        $DirectEditingInfoResponseApplicationJsonInterface,
        Built<DirectEditingInfoResponseApplicationJson, DirectEditingInfoResponseApplicationJsonBuilder> {
  /// Creates a new DirectEditingInfoResponseApplicationJson object using the builder pattern.
  factory DirectEditingInfoResponseApplicationJson([
    void Function(DirectEditingInfoResponseApplicationJsonBuilder)? b,
  ]) = _$DirectEditingInfoResponseApplicationJson;

  // coverage:ignore-start
  const DirectEditingInfoResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingInfoResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingInfoResponseApplicationJson.
  static Serializer<DirectEditingInfoResponseApplicationJson> get serializer =>
      _$directEditingInfoResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingInfoResponseApplicationJsonBuilder b) {
    $DirectEditingInfoResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingInfoResponseApplicationJsonBuilder b) {
    $DirectEditingInfoResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterface {
  String get id;
  String get title;
  String? get preview;
  @BuiltValueField(wireName: 'extension')
  String get $extension;
  String get mimetype;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterfaceBuilder].
  $DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterface rebuild(
    void Function($DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterfaceBuilder].
  $DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterfaceBuilder b) {}
}

abstract class DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates
    implements
        $DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterface,
        Built<DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates,
            DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesBuilder> {
  /// Creates a new DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates object using the builder pattern.
  factory DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates([
    void Function(DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesBuilder)? b,
  ]) = _$DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates;

  // coverage:ignore-start
  const DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates.
  static Serializer<DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates> get serializer =>
      _$directEditingTemplatesResponseApplicationJsonOcsDataTemplatesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesBuilder b) {
    $DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesBuilder b) {
    $DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates> get templates;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class DirectEditingTemplatesResponseApplicationJson_Ocs_Data
    implements
        $DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterface,
        Built<DirectEditingTemplatesResponseApplicationJson_Ocs_Data,
            DirectEditingTemplatesResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new DirectEditingTemplatesResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory DirectEditingTemplatesResponseApplicationJson_Ocs_Data([
    void Function(DirectEditingTemplatesResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$DirectEditingTemplatesResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const DirectEditingTemplatesResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingTemplatesResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingTemplatesResponseApplicationJson_Ocs_Data.
  static Serializer<DirectEditingTemplatesResponseApplicationJson_Ocs_Data> get serializer =>
      _$directEditingTemplatesResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingTemplatesResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingTemplatesResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectEditingTemplatesResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingTemplatesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  DirectEditingTemplatesResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingTemplatesResponseApplicationJson_OcsInterfaceBuilder].
  $DirectEditingTemplatesResponseApplicationJson_OcsInterface rebuild(
    void Function($DirectEditingTemplatesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingTemplatesResponseApplicationJson_OcsInterfaceBuilder].
  $DirectEditingTemplatesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingTemplatesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingTemplatesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class DirectEditingTemplatesResponseApplicationJson_Ocs
    implements
        $DirectEditingTemplatesResponseApplicationJson_OcsInterface,
        Built<DirectEditingTemplatesResponseApplicationJson_Ocs,
            DirectEditingTemplatesResponseApplicationJson_OcsBuilder> {
  /// Creates a new DirectEditingTemplatesResponseApplicationJson_Ocs object using the builder pattern.
  factory DirectEditingTemplatesResponseApplicationJson_Ocs([
    void Function(DirectEditingTemplatesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$DirectEditingTemplatesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const DirectEditingTemplatesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingTemplatesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingTemplatesResponseApplicationJson_Ocs.
  static Serializer<DirectEditingTemplatesResponseApplicationJson_Ocs> get serializer =>
      _$directEditingTemplatesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingTemplatesResponseApplicationJson_OcsBuilder b) {
    $DirectEditingTemplatesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingTemplatesResponseApplicationJson_OcsBuilder b) {
    $DirectEditingTemplatesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingTemplatesResponseApplicationJsonInterface {
  DirectEditingTemplatesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingTemplatesResponseApplicationJsonInterfaceBuilder].
  $DirectEditingTemplatesResponseApplicationJsonInterface rebuild(
    void Function($DirectEditingTemplatesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingTemplatesResponseApplicationJsonInterfaceBuilder].
  $DirectEditingTemplatesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingTemplatesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingTemplatesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DirectEditingTemplatesResponseApplicationJson
    implements
        $DirectEditingTemplatesResponseApplicationJsonInterface,
        Built<DirectEditingTemplatesResponseApplicationJson, DirectEditingTemplatesResponseApplicationJsonBuilder> {
  /// Creates a new DirectEditingTemplatesResponseApplicationJson object using the builder pattern.
  factory DirectEditingTemplatesResponseApplicationJson([
    void Function(DirectEditingTemplatesResponseApplicationJsonBuilder)? b,
  ]) = _$DirectEditingTemplatesResponseApplicationJson;

  // coverage:ignore-start
  const DirectEditingTemplatesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingTemplatesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingTemplatesResponseApplicationJson.
  static Serializer<DirectEditingTemplatesResponseApplicationJson> get serializer =>
      _$directEditingTemplatesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingTemplatesResponseApplicationJsonBuilder b) {
    $DirectEditingTemplatesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingTemplatesResponseApplicationJsonBuilder b) {
    $DirectEditingTemplatesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingOpenRequestApplicationJsonInterface {
  /// Path of the file.
  String get path;

  /// ID of the editor.
  String? get editorId;

  /// ID of the file.
  int? get fileId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingOpenRequestApplicationJsonInterfaceBuilder].
  $DirectEditingOpenRequestApplicationJsonInterface rebuild(
    void Function($DirectEditingOpenRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingOpenRequestApplicationJsonInterfaceBuilder].
  $DirectEditingOpenRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingOpenRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingOpenRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class DirectEditingOpenRequestApplicationJson
    implements
        $DirectEditingOpenRequestApplicationJsonInterface,
        Built<DirectEditingOpenRequestApplicationJson, DirectEditingOpenRequestApplicationJsonBuilder> {
  /// Creates a new DirectEditingOpenRequestApplicationJson object using the builder pattern.
  factory DirectEditingOpenRequestApplicationJson([void Function(DirectEditingOpenRequestApplicationJsonBuilder)? b]) =
      _$DirectEditingOpenRequestApplicationJson;

  // coverage:ignore-start
  const DirectEditingOpenRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingOpenRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingOpenRequestApplicationJson.
  static Serializer<DirectEditingOpenRequestApplicationJson> get serializer =>
      _$directEditingOpenRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingOpenRequestApplicationJsonBuilder b) {
    $DirectEditingOpenRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingOpenRequestApplicationJsonBuilder b) {
    $DirectEditingOpenRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingOpenResponseApplicationJson_Ocs_DataInterface {
  String get url;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingOpenResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectEditingOpenResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($DirectEditingOpenResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingOpenResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectEditingOpenResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingOpenResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingOpenResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class DirectEditingOpenResponseApplicationJson_Ocs_Data
    implements
        $DirectEditingOpenResponseApplicationJson_Ocs_DataInterface,
        Built<DirectEditingOpenResponseApplicationJson_Ocs_Data,
            DirectEditingOpenResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new DirectEditingOpenResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory DirectEditingOpenResponseApplicationJson_Ocs_Data([
    void Function(DirectEditingOpenResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$DirectEditingOpenResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const DirectEditingOpenResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingOpenResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingOpenResponseApplicationJson_Ocs_Data.
  static Serializer<DirectEditingOpenResponseApplicationJson_Ocs_Data> get serializer =>
      _$directEditingOpenResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingOpenResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectEditingOpenResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingOpenResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectEditingOpenResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingOpenResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  DirectEditingOpenResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingOpenResponseApplicationJson_OcsInterfaceBuilder].
  $DirectEditingOpenResponseApplicationJson_OcsInterface rebuild(
    void Function($DirectEditingOpenResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingOpenResponseApplicationJson_OcsInterfaceBuilder].
  $DirectEditingOpenResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingOpenResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingOpenResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class DirectEditingOpenResponseApplicationJson_Ocs
    implements
        $DirectEditingOpenResponseApplicationJson_OcsInterface,
        Built<DirectEditingOpenResponseApplicationJson_Ocs, DirectEditingOpenResponseApplicationJson_OcsBuilder> {
  /// Creates a new DirectEditingOpenResponseApplicationJson_Ocs object using the builder pattern.
  factory DirectEditingOpenResponseApplicationJson_Ocs([
    void Function(DirectEditingOpenResponseApplicationJson_OcsBuilder)? b,
  ]) = _$DirectEditingOpenResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const DirectEditingOpenResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingOpenResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingOpenResponseApplicationJson_Ocs.
  static Serializer<DirectEditingOpenResponseApplicationJson_Ocs> get serializer =>
      _$directEditingOpenResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingOpenResponseApplicationJson_OcsBuilder b) {
    $DirectEditingOpenResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingOpenResponseApplicationJson_OcsBuilder b) {
    $DirectEditingOpenResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingOpenResponseApplicationJsonInterface {
  DirectEditingOpenResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingOpenResponseApplicationJsonInterfaceBuilder].
  $DirectEditingOpenResponseApplicationJsonInterface rebuild(
    void Function($DirectEditingOpenResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingOpenResponseApplicationJsonInterfaceBuilder].
  $DirectEditingOpenResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingOpenResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingOpenResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DirectEditingOpenResponseApplicationJson
    implements
        $DirectEditingOpenResponseApplicationJsonInterface,
        Built<DirectEditingOpenResponseApplicationJson, DirectEditingOpenResponseApplicationJsonBuilder> {
  /// Creates a new DirectEditingOpenResponseApplicationJson object using the builder pattern.
  factory DirectEditingOpenResponseApplicationJson([
    void Function(DirectEditingOpenResponseApplicationJsonBuilder)? b,
  ]) = _$DirectEditingOpenResponseApplicationJson;

  // coverage:ignore-start
  const DirectEditingOpenResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingOpenResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingOpenResponseApplicationJson.
  static Serializer<DirectEditingOpenResponseApplicationJson> get serializer =>
      _$directEditingOpenResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingOpenResponseApplicationJsonBuilder b) {
    $DirectEditingOpenResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingOpenResponseApplicationJsonBuilder b) {
    $DirectEditingOpenResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingCreateRequestApplicationJsonInterface {
  /// Path of the file.
  String get path;

  /// ID of the editor.
  String get editorId;

  /// ID of the creator.
  String get creatorId;

  /// ID of the template.
  String? get templateId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingCreateRequestApplicationJsonInterfaceBuilder].
  $DirectEditingCreateRequestApplicationJsonInterface rebuild(
    void Function($DirectEditingCreateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingCreateRequestApplicationJsonInterfaceBuilder].
  $DirectEditingCreateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingCreateRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingCreateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class DirectEditingCreateRequestApplicationJson
    implements
        $DirectEditingCreateRequestApplicationJsonInterface,
        Built<DirectEditingCreateRequestApplicationJson, DirectEditingCreateRequestApplicationJsonBuilder> {
  /// Creates a new DirectEditingCreateRequestApplicationJson object using the builder pattern.
  factory DirectEditingCreateRequestApplicationJson([
    void Function(DirectEditingCreateRequestApplicationJsonBuilder)? b,
  ]) = _$DirectEditingCreateRequestApplicationJson;

  // coverage:ignore-start
  const DirectEditingCreateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingCreateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingCreateRequestApplicationJson.
  static Serializer<DirectEditingCreateRequestApplicationJson> get serializer =>
      _$directEditingCreateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingCreateRequestApplicationJsonBuilder b) {
    $DirectEditingCreateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingCreateRequestApplicationJsonBuilder b) {
    $DirectEditingCreateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingCreateResponseApplicationJson_Ocs_DataInterface {
  String get url;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingCreateResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectEditingCreateResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($DirectEditingCreateResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingCreateResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectEditingCreateResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingCreateResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingCreateResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class DirectEditingCreateResponseApplicationJson_Ocs_Data
    implements
        $DirectEditingCreateResponseApplicationJson_Ocs_DataInterface,
        Built<DirectEditingCreateResponseApplicationJson_Ocs_Data,
            DirectEditingCreateResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new DirectEditingCreateResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory DirectEditingCreateResponseApplicationJson_Ocs_Data([
    void Function(DirectEditingCreateResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$DirectEditingCreateResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const DirectEditingCreateResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingCreateResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingCreateResponseApplicationJson_Ocs_Data.
  static Serializer<DirectEditingCreateResponseApplicationJson_Ocs_Data> get serializer =>
      _$directEditingCreateResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingCreateResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectEditingCreateResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingCreateResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectEditingCreateResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingCreateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  DirectEditingCreateResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingCreateResponseApplicationJson_OcsInterfaceBuilder].
  $DirectEditingCreateResponseApplicationJson_OcsInterface rebuild(
    void Function($DirectEditingCreateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingCreateResponseApplicationJson_OcsInterfaceBuilder].
  $DirectEditingCreateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class DirectEditingCreateResponseApplicationJson_Ocs
    implements
        $DirectEditingCreateResponseApplicationJson_OcsInterface,
        Built<DirectEditingCreateResponseApplicationJson_Ocs, DirectEditingCreateResponseApplicationJson_OcsBuilder> {
  /// Creates a new DirectEditingCreateResponseApplicationJson_Ocs object using the builder pattern.
  factory DirectEditingCreateResponseApplicationJson_Ocs([
    void Function(DirectEditingCreateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$DirectEditingCreateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const DirectEditingCreateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingCreateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingCreateResponseApplicationJson_Ocs.
  static Serializer<DirectEditingCreateResponseApplicationJson_Ocs> get serializer =>
      _$directEditingCreateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingCreateResponseApplicationJson_OcsBuilder b) {
    $DirectEditingCreateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingCreateResponseApplicationJson_OcsBuilder b) {
    $DirectEditingCreateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectEditingCreateResponseApplicationJsonInterface {
  DirectEditingCreateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectEditingCreateResponseApplicationJsonInterfaceBuilder].
  $DirectEditingCreateResponseApplicationJsonInterface rebuild(
    void Function($DirectEditingCreateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectEditingCreateResponseApplicationJsonInterfaceBuilder].
  $DirectEditingCreateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectEditingCreateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectEditingCreateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DirectEditingCreateResponseApplicationJson
    implements
        $DirectEditingCreateResponseApplicationJsonInterface,
        Built<DirectEditingCreateResponseApplicationJson, DirectEditingCreateResponseApplicationJsonBuilder> {
  /// Creates a new DirectEditingCreateResponseApplicationJson object using the builder pattern.
  factory DirectEditingCreateResponseApplicationJson([
    void Function(DirectEditingCreateResponseApplicationJsonBuilder)? b,
  ]) = _$DirectEditingCreateResponseApplicationJson;

  // coverage:ignore-start
  const DirectEditingCreateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectEditingCreateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectEditingCreateResponseApplicationJson.
  static Serializer<DirectEditingCreateResponseApplicationJson> get serializer =>
      _$directEditingCreateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectEditingCreateResponseApplicationJsonBuilder b) {
    $DirectEditingCreateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectEditingCreateResponseApplicationJsonBuilder b) {
    $DirectEditingCreateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenLocalEditorCreateRequestApplicationJsonInterface {
  /// Path of the file.
  String get path;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenLocalEditorCreateRequestApplicationJsonInterfaceBuilder].
  $OpenLocalEditorCreateRequestApplicationJsonInterface rebuild(
    void Function($OpenLocalEditorCreateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OpenLocalEditorCreateRequestApplicationJsonInterfaceBuilder].
  $OpenLocalEditorCreateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenLocalEditorCreateRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenLocalEditorCreateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class OpenLocalEditorCreateRequestApplicationJson
    implements
        $OpenLocalEditorCreateRequestApplicationJsonInterface,
        Built<OpenLocalEditorCreateRequestApplicationJson, OpenLocalEditorCreateRequestApplicationJsonBuilder> {
  /// Creates a new OpenLocalEditorCreateRequestApplicationJson object using the builder pattern.
  factory OpenLocalEditorCreateRequestApplicationJson([
    void Function(OpenLocalEditorCreateRequestApplicationJsonBuilder)? b,
  ]) = _$OpenLocalEditorCreateRequestApplicationJson;

  // coverage:ignore-start
  const OpenLocalEditorCreateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenLocalEditorCreateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenLocalEditorCreateRequestApplicationJson.
  static Serializer<OpenLocalEditorCreateRequestApplicationJson> get serializer =>
      _$openLocalEditorCreateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenLocalEditorCreateRequestApplicationJsonBuilder b) {
    $OpenLocalEditorCreateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenLocalEditorCreateRequestApplicationJsonBuilder b) {
    $OpenLocalEditorCreateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterface {
  String? get userId;
  String get pathHash;
  int get expirationTime;
  String get token;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class OpenLocalEditorCreateResponseApplicationJson_Ocs_Data
    implements
        $OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterface,
        Built<OpenLocalEditorCreateResponseApplicationJson_Ocs_Data,
            OpenLocalEditorCreateResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new OpenLocalEditorCreateResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory OpenLocalEditorCreateResponseApplicationJson_Ocs_Data([
    void Function(OpenLocalEditorCreateResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$OpenLocalEditorCreateResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const OpenLocalEditorCreateResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenLocalEditorCreateResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenLocalEditorCreateResponseApplicationJson_Ocs_Data.
  static Serializer<OpenLocalEditorCreateResponseApplicationJson_Ocs_Data> get serializer =>
      _$openLocalEditorCreateResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenLocalEditorCreateResponseApplicationJson_Ocs_DataBuilder b) {
    $OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenLocalEditorCreateResponseApplicationJson_Ocs_DataBuilder b) {
    $OpenLocalEditorCreateResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenLocalEditorCreateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  OpenLocalEditorCreateResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenLocalEditorCreateResponseApplicationJson_OcsInterfaceBuilder].
  $OpenLocalEditorCreateResponseApplicationJson_OcsInterface rebuild(
    void Function($OpenLocalEditorCreateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OpenLocalEditorCreateResponseApplicationJson_OcsInterfaceBuilder].
  $OpenLocalEditorCreateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenLocalEditorCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenLocalEditorCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class OpenLocalEditorCreateResponseApplicationJson_Ocs
    implements
        $OpenLocalEditorCreateResponseApplicationJson_OcsInterface,
        Built<OpenLocalEditorCreateResponseApplicationJson_Ocs,
            OpenLocalEditorCreateResponseApplicationJson_OcsBuilder> {
  /// Creates a new OpenLocalEditorCreateResponseApplicationJson_Ocs object using the builder pattern.
  factory OpenLocalEditorCreateResponseApplicationJson_Ocs([
    void Function(OpenLocalEditorCreateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$OpenLocalEditorCreateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const OpenLocalEditorCreateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenLocalEditorCreateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenLocalEditorCreateResponseApplicationJson_Ocs.
  static Serializer<OpenLocalEditorCreateResponseApplicationJson_Ocs> get serializer =>
      _$openLocalEditorCreateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenLocalEditorCreateResponseApplicationJson_OcsBuilder b) {
    $OpenLocalEditorCreateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenLocalEditorCreateResponseApplicationJson_OcsBuilder b) {
    $OpenLocalEditorCreateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenLocalEditorCreateResponseApplicationJsonInterface {
  OpenLocalEditorCreateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenLocalEditorCreateResponseApplicationJsonInterfaceBuilder].
  $OpenLocalEditorCreateResponseApplicationJsonInterface rebuild(
    void Function($OpenLocalEditorCreateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OpenLocalEditorCreateResponseApplicationJsonInterfaceBuilder].
  $OpenLocalEditorCreateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenLocalEditorCreateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenLocalEditorCreateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class OpenLocalEditorCreateResponseApplicationJson
    implements
        $OpenLocalEditorCreateResponseApplicationJsonInterface,
        Built<OpenLocalEditorCreateResponseApplicationJson, OpenLocalEditorCreateResponseApplicationJsonBuilder> {
  /// Creates a new OpenLocalEditorCreateResponseApplicationJson object using the builder pattern.
  factory OpenLocalEditorCreateResponseApplicationJson([
    void Function(OpenLocalEditorCreateResponseApplicationJsonBuilder)? b,
  ]) = _$OpenLocalEditorCreateResponseApplicationJson;

  // coverage:ignore-start
  const OpenLocalEditorCreateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenLocalEditorCreateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenLocalEditorCreateResponseApplicationJson.
  static Serializer<OpenLocalEditorCreateResponseApplicationJson> get serializer =>
      _$openLocalEditorCreateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenLocalEditorCreateResponseApplicationJsonBuilder b) {
    $OpenLocalEditorCreateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenLocalEditorCreateResponseApplicationJsonBuilder b) {
    $OpenLocalEditorCreateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenLocalEditorValidateRequestApplicationJsonInterface {
  /// Path of the file.
  String get path;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenLocalEditorValidateRequestApplicationJsonInterfaceBuilder].
  $OpenLocalEditorValidateRequestApplicationJsonInterface rebuild(
    void Function($OpenLocalEditorValidateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OpenLocalEditorValidateRequestApplicationJsonInterfaceBuilder].
  $OpenLocalEditorValidateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenLocalEditorValidateRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenLocalEditorValidateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class OpenLocalEditorValidateRequestApplicationJson
    implements
        $OpenLocalEditorValidateRequestApplicationJsonInterface,
        Built<OpenLocalEditorValidateRequestApplicationJson, OpenLocalEditorValidateRequestApplicationJsonBuilder> {
  /// Creates a new OpenLocalEditorValidateRequestApplicationJson object using the builder pattern.
  factory OpenLocalEditorValidateRequestApplicationJson([
    void Function(OpenLocalEditorValidateRequestApplicationJsonBuilder)? b,
  ]) = _$OpenLocalEditorValidateRequestApplicationJson;

  // coverage:ignore-start
  const OpenLocalEditorValidateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenLocalEditorValidateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenLocalEditorValidateRequestApplicationJson.
  static Serializer<OpenLocalEditorValidateRequestApplicationJson> get serializer =>
      _$openLocalEditorValidateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenLocalEditorValidateRequestApplicationJsonBuilder b) {
    $OpenLocalEditorValidateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenLocalEditorValidateRequestApplicationJsonBuilder b) {
    $OpenLocalEditorValidateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterface {
  String get userId;
  String get pathHash;
  int get expirationTime;
  String get token;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class OpenLocalEditorValidateResponseApplicationJson_Ocs_Data
    implements
        $OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterface,
        Built<OpenLocalEditorValidateResponseApplicationJson_Ocs_Data,
            OpenLocalEditorValidateResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new OpenLocalEditorValidateResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory OpenLocalEditorValidateResponseApplicationJson_Ocs_Data([
    void Function(OpenLocalEditorValidateResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$OpenLocalEditorValidateResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const OpenLocalEditorValidateResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenLocalEditorValidateResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenLocalEditorValidateResponseApplicationJson_Ocs_Data.
  static Serializer<OpenLocalEditorValidateResponseApplicationJson_Ocs_Data> get serializer =>
      _$openLocalEditorValidateResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenLocalEditorValidateResponseApplicationJson_Ocs_DataBuilder b) {
    $OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenLocalEditorValidateResponseApplicationJson_Ocs_DataBuilder b) {
    $OpenLocalEditorValidateResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenLocalEditorValidateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  OpenLocalEditorValidateResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenLocalEditorValidateResponseApplicationJson_OcsInterfaceBuilder].
  $OpenLocalEditorValidateResponseApplicationJson_OcsInterface rebuild(
    void Function($OpenLocalEditorValidateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OpenLocalEditorValidateResponseApplicationJson_OcsInterfaceBuilder].
  $OpenLocalEditorValidateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenLocalEditorValidateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenLocalEditorValidateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class OpenLocalEditorValidateResponseApplicationJson_Ocs
    implements
        $OpenLocalEditorValidateResponseApplicationJson_OcsInterface,
        Built<OpenLocalEditorValidateResponseApplicationJson_Ocs,
            OpenLocalEditorValidateResponseApplicationJson_OcsBuilder> {
  /// Creates a new OpenLocalEditorValidateResponseApplicationJson_Ocs object using the builder pattern.
  factory OpenLocalEditorValidateResponseApplicationJson_Ocs([
    void Function(OpenLocalEditorValidateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$OpenLocalEditorValidateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const OpenLocalEditorValidateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenLocalEditorValidateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenLocalEditorValidateResponseApplicationJson_Ocs.
  static Serializer<OpenLocalEditorValidateResponseApplicationJson_Ocs> get serializer =>
      _$openLocalEditorValidateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenLocalEditorValidateResponseApplicationJson_OcsBuilder b) {
    $OpenLocalEditorValidateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenLocalEditorValidateResponseApplicationJson_OcsBuilder b) {
    $OpenLocalEditorValidateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenLocalEditorValidateResponseApplicationJsonInterface {
  OpenLocalEditorValidateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenLocalEditorValidateResponseApplicationJsonInterfaceBuilder].
  $OpenLocalEditorValidateResponseApplicationJsonInterface rebuild(
    void Function($OpenLocalEditorValidateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OpenLocalEditorValidateResponseApplicationJsonInterfaceBuilder].
  $OpenLocalEditorValidateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenLocalEditorValidateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenLocalEditorValidateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class OpenLocalEditorValidateResponseApplicationJson
    implements
        $OpenLocalEditorValidateResponseApplicationJsonInterface,
        Built<OpenLocalEditorValidateResponseApplicationJson, OpenLocalEditorValidateResponseApplicationJsonBuilder> {
  /// Creates a new OpenLocalEditorValidateResponseApplicationJson object using the builder pattern.
  factory OpenLocalEditorValidateResponseApplicationJson([
    void Function(OpenLocalEditorValidateResponseApplicationJsonBuilder)? b,
  ]) = _$OpenLocalEditorValidateResponseApplicationJson;

  // coverage:ignore-start
  const OpenLocalEditorValidateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenLocalEditorValidateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenLocalEditorValidateResponseApplicationJson.
  static Serializer<OpenLocalEditorValidateResponseApplicationJson> get serializer =>
      _$openLocalEditorValidateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenLocalEditorValidateResponseApplicationJsonBuilder b) {
    $OpenLocalEditorValidateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenLocalEditorValidateResponseApplicationJsonBuilder b) {
    $OpenLocalEditorValidateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplateFileCreatorInterface {
  String get app;
  String get label;
  @BuiltValueField(wireName: 'extension')
  String get $extension;
  String? get iconClass;
  String? get iconSvgInline;
  BuiltList<String> get mimetypes;
  double? get ratio;
  String get actionLabel;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplateFileCreatorInterfaceBuilder].
  $TemplateFileCreatorInterface rebuild(void Function($TemplateFileCreatorInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TemplateFileCreatorInterfaceBuilder].
  $TemplateFileCreatorInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplateFileCreatorInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplateFileCreatorInterfaceBuilder b) {}
}

abstract class TemplateFileCreator
    implements $TemplateFileCreatorInterface, Built<TemplateFileCreator, TemplateFileCreatorBuilder> {
  /// Creates a new TemplateFileCreator object using the builder pattern.
  factory TemplateFileCreator([void Function(TemplateFileCreatorBuilder)? b]) = _$TemplateFileCreator;

  // coverage:ignore-start
  const TemplateFileCreator._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplateFileCreator.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplateFileCreator.
  static Serializer<TemplateFileCreator> get serializer => _$templateFileCreatorSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplateFileCreatorBuilder b) {
    $TemplateFileCreatorInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplateFileCreatorBuilder b) {
    $TemplateFileCreatorInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplateListResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<TemplateFileCreator> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplateListResponseApplicationJson_OcsInterfaceBuilder].
  $TemplateListResponseApplicationJson_OcsInterface rebuild(
    void Function($TemplateListResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplateListResponseApplicationJson_OcsInterfaceBuilder].
  $TemplateListResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplateListResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplateListResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TemplateListResponseApplicationJson_Ocs
    implements
        $TemplateListResponseApplicationJson_OcsInterface,
        Built<TemplateListResponseApplicationJson_Ocs, TemplateListResponseApplicationJson_OcsBuilder> {
  /// Creates a new TemplateListResponseApplicationJson_Ocs object using the builder pattern.
  factory TemplateListResponseApplicationJson_Ocs([void Function(TemplateListResponseApplicationJson_OcsBuilder)? b]) =
      _$TemplateListResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TemplateListResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplateListResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplateListResponseApplicationJson_Ocs.
  static Serializer<TemplateListResponseApplicationJson_Ocs> get serializer =>
      _$templateListResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplateListResponseApplicationJson_OcsBuilder b) {
    $TemplateListResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplateListResponseApplicationJson_OcsBuilder b) {
    $TemplateListResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplateListResponseApplicationJsonInterface {
  TemplateListResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplateListResponseApplicationJsonInterfaceBuilder].
  $TemplateListResponseApplicationJsonInterface rebuild(
    void Function($TemplateListResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplateListResponseApplicationJsonInterfaceBuilder].
  $TemplateListResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplateListResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplateListResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TemplateListResponseApplicationJson
    implements
        $TemplateListResponseApplicationJsonInterface,
        Built<TemplateListResponseApplicationJson, TemplateListResponseApplicationJsonBuilder> {
  /// Creates a new TemplateListResponseApplicationJson object using the builder pattern.
  factory TemplateListResponseApplicationJson([void Function(TemplateListResponseApplicationJsonBuilder)? b]) =
      _$TemplateListResponseApplicationJson;

  // coverage:ignore-start
  const TemplateListResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplateListResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplateListResponseApplicationJson.
  static Serializer<TemplateListResponseApplicationJson> get serializer =>
      _$templateListResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplateListResponseApplicationJsonBuilder b) {
    $TemplateListResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplateListResponseApplicationJsonBuilder b) {
    $TemplateListResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplateFieldInterface {
  String get index;
  String get content;
  String get type;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplateFieldInterfaceBuilder].
  $TemplateFieldInterface rebuild(void Function($TemplateFieldInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TemplateFieldInterfaceBuilder].
  $TemplateFieldInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplateFieldInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplateFieldInterfaceBuilder b) {}
}

abstract class TemplateField implements $TemplateFieldInterface, Built<TemplateField, TemplateFieldBuilder> {
  /// Creates a new TemplateField object using the builder pattern.
  factory TemplateField([void Function(TemplateFieldBuilder)? b]) = _$TemplateField;

  // coverage:ignore-start
  const TemplateField._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplateField.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplateField.
  static Serializer<TemplateField> get serializer => _$templateFieldSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplateFieldBuilder b) {
    $TemplateFieldInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplateFieldBuilder b) {
    $TemplateFieldInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplateCreateRequestApplicationJsonInterface {
  static final _$templatePath = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$templateType = _$jsonSerializers.deserialize(
    'user',
    specifiedType: const FullType(String),
  )! as String;

  static final _$templateFields = _$jsonSerializers.deserialize(
    const [],
    specifiedType: const FullType(BuiltList, [FullType(TemplateField)]),
  )! as BuiltList<TemplateField>;

  /// Path of the file.
  String get filePath;

  /// Name of the template.
  String get templatePath;

  /// Type of the template.
  String get templateType;

  /// Fields of the template.
  BuiltList<TemplateField> get templateFields;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplateCreateRequestApplicationJsonInterfaceBuilder].
  $TemplateCreateRequestApplicationJsonInterface rebuild(
    void Function($TemplateCreateRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplateCreateRequestApplicationJsonInterfaceBuilder].
  $TemplateCreateRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplateCreateRequestApplicationJsonInterfaceBuilder b) {
    b.templatePath = _$templatePath;
    b.templateType = _$templateType;
    b.templateFields.replace(_$templateFields);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplateCreateRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class TemplateCreateRequestApplicationJson
    implements
        $TemplateCreateRequestApplicationJsonInterface,
        Built<TemplateCreateRequestApplicationJson, TemplateCreateRequestApplicationJsonBuilder> {
  /// Creates a new TemplateCreateRequestApplicationJson object using the builder pattern.
  factory TemplateCreateRequestApplicationJson([void Function(TemplateCreateRequestApplicationJsonBuilder)? b]) =
      _$TemplateCreateRequestApplicationJson;

  // coverage:ignore-start
  const TemplateCreateRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplateCreateRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplateCreateRequestApplicationJson.
  static Serializer<TemplateCreateRequestApplicationJson> get serializer =>
      _$templateCreateRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplateCreateRequestApplicationJsonBuilder b) {
    $TemplateCreateRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplateCreateRequestApplicationJsonBuilder b) {
    $TemplateCreateRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplateFileInterface {
  String get basename;
  String get etag;
  int get fileid;
  String? get filename;
  int get lastmod;
  String get mime;
  int get size;
  String get type;
  bool get hasPreview;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplateFileInterfaceBuilder].
  $TemplateFileInterface rebuild(void Function($TemplateFileInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TemplateFileInterfaceBuilder].
  $TemplateFileInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplateFileInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplateFileInterfaceBuilder b) {}
}

abstract class TemplateFile implements $TemplateFileInterface, Built<TemplateFile, TemplateFileBuilder> {
  /// Creates a new TemplateFile object using the builder pattern.
  factory TemplateFile([void Function(TemplateFileBuilder)? b]) = _$TemplateFile;

  // coverage:ignore-start
  const TemplateFile._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplateFile.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplateFile.
  static Serializer<TemplateFile> get serializer => _$templateFileSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplateFileBuilder b) {
    $TemplateFileInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplateFileBuilder b) {
    $TemplateFileInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplateCreateResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TemplateFile get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplateCreateResponseApplicationJson_OcsInterfaceBuilder].
  $TemplateCreateResponseApplicationJson_OcsInterface rebuild(
    void Function($TemplateCreateResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplateCreateResponseApplicationJson_OcsInterfaceBuilder].
  $TemplateCreateResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplateCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplateCreateResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TemplateCreateResponseApplicationJson_Ocs
    implements
        $TemplateCreateResponseApplicationJson_OcsInterface,
        Built<TemplateCreateResponseApplicationJson_Ocs, TemplateCreateResponseApplicationJson_OcsBuilder> {
  /// Creates a new TemplateCreateResponseApplicationJson_Ocs object using the builder pattern.
  factory TemplateCreateResponseApplicationJson_Ocs([
    void Function(TemplateCreateResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TemplateCreateResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TemplateCreateResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplateCreateResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplateCreateResponseApplicationJson_Ocs.
  static Serializer<TemplateCreateResponseApplicationJson_Ocs> get serializer =>
      _$templateCreateResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplateCreateResponseApplicationJson_OcsBuilder b) {
    $TemplateCreateResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplateCreateResponseApplicationJson_OcsBuilder b) {
    $TemplateCreateResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplateCreateResponseApplicationJsonInterface {
  TemplateCreateResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplateCreateResponseApplicationJsonInterfaceBuilder].
  $TemplateCreateResponseApplicationJsonInterface rebuild(
    void Function($TemplateCreateResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplateCreateResponseApplicationJsonInterfaceBuilder].
  $TemplateCreateResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplateCreateResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplateCreateResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TemplateCreateResponseApplicationJson
    implements
        $TemplateCreateResponseApplicationJsonInterface,
        Built<TemplateCreateResponseApplicationJson, TemplateCreateResponseApplicationJsonBuilder> {
  /// Creates a new TemplateCreateResponseApplicationJson object using the builder pattern.
  factory TemplateCreateResponseApplicationJson([void Function(TemplateCreateResponseApplicationJsonBuilder)? b]) =
      _$TemplateCreateResponseApplicationJson;

  // coverage:ignore-start
  const TemplateCreateResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplateCreateResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplateCreateResponseApplicationJson.
  static Serializer<TemplateCreateResponseApplicationJson> get serializer =>
      _$templateCreateResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplateCreateResponseApplicationJsonBuilder b) {
    $TemplateCreateResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplateCreateResponseApplicationJsonBuilder b) {
    $TemplateCreateResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplatePathRequestApplicationJsonInterface {
  static final _$templatePath = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$copySystemTemplates = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  /// Path of the template directory.
  String get templatePath;

  /// Whether to copy the system templates to the template directory.
  bool get copySystemTemplates;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplatePathRequestApplicationJsonInterfaceBuilder].
  $TemplatePathRequestApplicationJsonInterface rebuild(
    void Function($TemplatePathRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplatePathRequestApplicationJsonInterfaceBuilder].
  $TemplatePathRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplatePathRequestApplicationJsonInterfaceBuilder b) {
    b.templatePath = _$templatePath;
    b.copySystemTemplates = _$copySystemTemplates;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplatePathRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class TemplatePathRequestApplicationJson
    implements
        $TemplatePathRequestApplicationJsonInterface,
        Built<TemplatePathRequestApplicationJson, TemplatePathRequestApplicationJsonBuilder> {
  /// Creates a new TemplatePathRequestApplicationJson object using the builder pattern.
  factory TemplatePathRequestApplicationJson([void Function(TemplatePathRequestApplicationJsonBuilder)? b]) =
      _$TemplatePathRequestApplicationJson;

  // coverage:ignore-start
  const TemplatePathRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplatePathRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplatePathRequestApplicationJson.
  static Serializer<TemplatePathRequestApplicationJson> get serializer =>
      _$templatePathRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplatePathRequestApplicationJsonBuilder b) {
    $TemplatePathRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplatePathRequestApplicationJsonBuilder b) {
    $TemplatePathRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplatePathResponseApplicationJson_Ocs_DataInterface {
  @BuiltValueField(wireName: 'template_path')
  String get templatePath;
  BuiltList<TemplateFileCreator> get templates;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplatePathResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TemplatePathResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TemplatePathResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplatePathResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TemplatePathResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplatePathResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplatePathResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TemplatePathResponseApplicationJson_Ocs_Data
    implements
        $TemplatePathResponseApplicationJson_Ocs_DataInterface,
        Built<TemplatePathResponseApplicationJson_Ocs_Data, TemplatePathResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TemplatePathResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TemplatePathResponseApplicationJson_Ocs_Data([
    void Function(TemplatePathResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TemplatePathResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TemplatePathResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplatePathResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplatePathResponseApplicationJson_Ocs_Data.
  static Serializer<TemplatePathResponseApplicationJson_Ocs_Data> get serializer =>
      _$templatePathResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplatePathResponseApplicationJson_Ocs_DataBuilder b) {
    $TemplatePathResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplatePathResponseApplicationJson_Ocs_DataBuilder b) {
    $TemplatePathResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplatePathResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TemplatePathResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplatePathResponseApplicationJson_OcsInterfaceBuilder].
  $TemplatePathResponseApplicationJson_OcsInterface rebuild(
    void Function($TemplatePathResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplatePathResponseApplicationJson_OcsInterfaceBuilder].
  $TemplatePathResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplatePathResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplatePathResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TemplatePathResponseApplicationJson_Ocs
    implements
        $TemplatePathResponseApplicationJson_OcsInterface,
        Built<TemplatePathResponseApplicationJson_Ocs, TemplatePathResponseApplicationJson_OcsBuilder> {
  /// Creates a new TemplatePathResponseApplicationJson_Ocs object using the builder pattern.
  factory TemplatePathResponseApplicationJson_Ocs([void Function(TemplatePathResponseApplicationJson_OcsBuilder)? b]) =
      _$TemplatePathResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TemplatePathResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplatePathResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplatePathResponseApplicationJson_Ocs.
  static Serializer<TemplatePathResponseApplicationJson_Ocs> get serializer =>
      _$templatePathResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplatePathResponseApplicationJson_OcsBuilder b) {
    $TemplatePathResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplatePathResponseApplicationJson_OcsBuilder b) {
    $TemplatePathResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TemplatePathResponseApplicationJsonInterface {
  TemplatePathResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TemplatePathResponseApplicationJsonInterfaceBuilder].
  $TemplatePathResponseApplicationJsonInterface rebuild(
    void Function($TemplatePathResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TemplatePathResponseApplicationJsonInterfaceBuilder].
  $TemplatePathResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TemplatePathResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TemplatePathResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TemplatePathResponseApplicationJson
    implements
        $TemplatePathResponseApplicationJsonInterface,
        Built<TemplatePathResponseApplicationJson, TemplatePathResponseApplicationJsonBuilder> {
  /// Creates a new TemplatePathResponseApplicationJson object using the builder pattern.
  factory TemplatePathResponseApplicationJson([void Function(TemplatePathResponseApplicationJsonBuilder)? b]) =
      _$TemplatePathResponseApplicationJson;

  // coverage:ignore-start
  const TemplatePathResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TemplatePathResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TemplatePathResponseApplicationJson.
  static Serializer<TemplatePathResponseApplicationJson> get serializer =>
      _$templatePathResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TemplatePathResponseApplicationJsonBuilder b) {
    $TemplatePathResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TemplatePathResponseApplicationJsonBuilder b) {
    $TemplatePathResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TransferOwnershipTransferRequestApplicationJsonInterface {
  /// Username of the recipient.
  String get recipient;

  /// Path of the file.
  String get path;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TransferOwnershipTransferRequestApplicationJsonInterfaceBuilder].
  $TransferOwnershipTransferRequestApplicationJsonInterface rebuild(
    void Function($TransferOwnershipTransferRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TransferOwnershipTransferRequestApplicationJsonInterfaceBuilder].
  $TransferOwnershipTransferRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TransferOwnershipTransferRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TransferOwnershipTransferRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class TransferOwnershipTransferRequestApplicationJson
    implements
        $TransferOwnershipTransferRequestApplicationJsonInterface,
        Built<TransferOwnershipTransferRequestApplicationJson, TransferOwnershipTransferRequestApplicationJsonBuilder> {
  /// Creates a new TransferOwnershipTransferRequestApplicationJson object using the builder pattern.
  factory TransferOwnershipTransferRequestApplicationJson([
    void Function(TransferOwnershipTransferRequestApplicationJsonBuilder)? b,
  ]) = _$TransferOwnershipTransferRequestApplicationJson;

  // coverage:ignore-start
  const TransferOwnershipTransferRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TransferOwnershipTransferRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TransferOwnershipTransferRequestApplicationJson.
  static Serializer<TransferOwnershipTransferRequestApplicationJson> get serializer =>
      _$transferOwnershipTransferRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TransferOwnershipTransferRequestApplicationJsonBuilder b) {
    $TransferOwnershipTransferRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TransferOwnershipTransferRequestApplicationJsonBuilder b) {
    $TransferOwnershipTransferRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TransferOwnershipTransferResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TransferOwnershipTransferResponseApplicationJson_OcsInterfaceBuilder].
  $TransferOwnershipTransferResponseApplicationJson_OcsInterface rebuild(
    void Function($TransferOwnershipTransferResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TransferOwnershipTransferResponseApplicationJson_OcsInterfaceBuilder].
  $TransferOwnershipTransferResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TransferOwnershipTransferResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TransferOwnershipTransferResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TransferOwnershipTransferResponseApplicationJson_Ocs
    implements
        $TransferOwnershipTransferResponseApplicationJson_OcsInterface,
        Built<TransferOwnershipTransferResponseApplicationJson_Ocs,
            TransferOwnershipTransferResponseApplicationJson_OcsBuilder> {
  /// Creates a new TransferOwnershipTransferResponseApplicationJson_Ocs object using the builder pattern.
  factory TransferOwnershipTransferResponseApplicationJson_Ocs([
    void Function(TransferOwnershipTransferResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TransferOwnershipTransferResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TransferOwnershipTransferResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TransferOwnershipTransferResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TransferOwnershipTransferResponseApplicationJson_Ocs.
  static Serializer<TransferOwnershipTransferResponseApplicationJson_Ocs> get serializer =>
      _$transferOwnershipTransferResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TransferOwnershipTransferResponseApplicationJson_OcsBuilder b) {
    $TransferOwnershipTransferResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TransferOwnershipTransferResponseApplicationJson_OcsBuilder b) {
    $TransferOwnershipTransferResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TransferOwnershipTransferResponseApplicationJsonInterface {
  TransferOwnershipTransferResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TransferOwnershipTransferResponseApplicationJsonInterfaceBuilder].
  $TransferOwnershipTransferResponseApplicationJsonInterface rebuild(
    void Function($TransferOwnershipTransferResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TransferOwnershipTransferResponseApplicationJsonInterfaceBuilder].
  $TransferOwnershipTransferResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TransferOwnershipTransferResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TransferOwnershipTransferResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TransferOwnershipTransferResponseApplicationJson
    implements
        $TransferOwnershipTransferResponseApplicationJsonInterface,
        Built<TransferOwnershipTransferResponseApplicationJson,
            TransferOwnershipTransferResponseApplicationJsonBuilder> {
  /// Creates a new TransferOwnershipTransferResponseApplicationJson object using the builder pattern.
  factory TransferOwnershipTransferResponseApplicationJson([
    void Function(TransferOwnershipTransferResponseApplicationJsonBuilder)? b,
  ]) = _$TransferOwnershipTransferResponseApplicationJson;

  // coverage:ignore-start
  const TransferOwnershipTransferResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TransferOwnershipTransferResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TransferOwnershipTransferResponseApplicationJson.
  static Serializer<TransferOwnershipTransferResponseApplicationJson> get serializer =>
      _$transferOwnershipTransferResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TransferOwnershipTransferResponseApplicationJsonBuilder b) {
    $TransferOwnershipTransferResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TransferOwnershipTransferResponseApplicationJsonBuilder b) {
    $TransferOwnershipTransferResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TransferOwnershipAcceptResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TransferOwnershipAcceptResponseApplicationJson_OcsInterfaceBuilder].
  $TransferOwnershipAcceptResponseApplicationJson_OcsInterface rebuild(
    void Function($TransferOwnershipAcceptResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TransferOwnershipAcceptResponseApplicationJson_OcsInterfaceBuilder].
  $TransferOwnershipAcceptResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TransferOwnershipAcceptResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TransferOwnershipAcceptResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TransferOwnershipAcceptResponseApplicationJson_Ocs
    implements
        $TransferOwnershipAcceptResponseApplicationJson_OcsInterface,
        Built<TransferOwnershipAcceptResponseApplicationJson_Ocs,
            TransferOwnershipAcceptResponseApplicationJson_OcsBuilder> {
  /// Creates a new TransferOwnershipAcceptResponseApplicationJson_Ocs object using the builder pattern.
  factory TransferOwnershipAcceptResponseApplicationJson_Ocs([
    void Function(TransferOwnershipAcceptResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TransferOwnershipAcceptResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TransferOwnershipAcceptResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TransferOwnershipAcceptResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TransferOwnershipAcceptResponseApplicationJson_Ocs.
  static Serializer<TransferOwnershipAcceptResponseApplicationJson_Ocs> get serializer =>
      _$transferOwnershipAcceptResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TransferOwnershipAcceptResponseApplicationJson_OcsBuilder b) {
    $TransferOwnershipAcceptResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TransferOwnershipAcceptResponseApplicationJson_OcsBuilder b) {
    $TransferOwnershipAcceptResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TransferOwnershipAcceptResponseApplicationJsonInterface {
  TransferOwnershipAcceptResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TransferOwnershipAcceptResponseApplicationJsonInterfaceBuilder].
  $TransferOwnershipAcceptResponseApplicationJsonInterface rebuild(
    void Function($TransferOwnershipAcceptResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TransferOwnershipAcceptResponseApplicationJsonInterfaceBuilder].
  $TransferOwnershipAcceptResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TransferOwnershipAcceptResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TransferOwnershipAcceptResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TransferOwnershipAcceptResponseApplicationJson
    implements
        $TransferOwnershipAcceptResponseApplicationJsonInterface,
        Built<TransferOwnershipAcceptResponseApplicationJson, TransferOwnershipAcceptResponseApplicationJsonBuilder> {
  /// Creates a new TransferOwnershipAcceptResponseApplicationJson object using the builder pattern.
  factory TransferOwnershipAcceptResponseApplicationJson([
    void Function(TransferOwnershipAcceptResponseApplicationJsonBuilder)? b,
  ]) = _$TransferOwnershipAcceptResponseApplicationJson;

  // coverage:ignore-start
  const TransferOwnershipAcceptResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TransferOwnershipAcceptResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TransferOwnershipAcceptResponseApplicationJson.
  static Serializer<TransferOwnershipAcceptResponseApplicationJson> get serializer =>
      _$transferOwnershipAcceptResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TransferOwnershipAcceptResponseApplicationJsonBuilder b) {
    $TransferOwnershipAcceptResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TransferOwnershipAcceptResponseApplicationJsonBuilder b) {
    $TransferOwnershipAcceptResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TransferOwnershipRejectResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TransferOwnershipRejectResponseApplicationJson_OcsInterfaceBuilder].
  $TransferOwnershipRejectResponseApplicationJson_OcsInterface rebuild(
    void Function($TransferOwnershipRejectResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TransferOwnershipRejectResponseApplicationJson_OcsInterfaceBuilder].
  $TransferOwnershipRejectResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TransferOwnershipRejectResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TransferOwnershipRejectResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TransferOwnershipRejectResponseApplicationJson_Ocs
    implements
        $TransferOwnershipRejectResponseApplicationJson_OcsInterface,
        Built<TransferOwnershipRejectResponseApplicationJson_Ocs,
            TransferOwnershipRejectResponseApplicationJson_OcsBuilder> {
  /// Creates a new TransferOwnershipRejectResponseApplicationJson_Ocs object using the builder pattern.
  factory TransferOwnershipRejectResponseApplicationJson_Ocs([
    void Function(TransferOwnershipRejectResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TransferOwnershipRejectResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TransferOwnershipRejectResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TransferOwnershipRejectResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TransferOwnershipRejectResponseApplicationJson_Ocs.
  static Serializer<TransferOwnershipRejectResponseApplicationJson_Ocs> get serializer =>
      _$transferOwnershipRejectResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TransferOwnershipRejectResponseApplicationJson_OcsBuilder b) {
    $TransferOwnershipRejectResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TransferOwnershipRejectResponseApplicationJson_OcsBuilder b) {
    $TransferOwnershipRejectResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TransferOwnershipRejectResponseApplicationJsonInterface {
  TransferOwnershipRejectResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TransferOwnershipRejectResponseApplicationJsonInterfaceBuilder].
  $TransferOwnershipRejectResponseApplicationJsonInterface rebuild(
    void Function($TransferOwnershipRejectResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TransferOwnershipRejectResponseApplicationJsonInterfaceBuilder].
  $TransferOwnershipRejectResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TransferOwnershipRejectResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TransferOwnershipRejectResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TransferOwnershipRejectResponseApplicationJson
    implements
        $TransferOwnershipRejectResponseApplicationJsonInterface,
        Built<TransferOwnershipRejectResponseApplicationJson, TransferOwnershipRejectResponseApplicationJsonBuilder> {
  /// Creates a new TransferOwnershipRejectResponseApplicationJson object using the builder pattern.
  factory TransferOwnershipRejectResponseApplicationJson([
    void Function(TransferOwnershipRejectResponseApplicationJsonBuilder)? b,
  ]) = _$TransferOwnershipRejectResponseApplicationJson;

  // coverage:ignore-start
  const TransferOwnershipRejectResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TransferOwnershipRejectResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TransferOwnershipRejectResponseApplicationJson.
  static Serializer<TransferOwnershipRejectResponseApplicationJson> get serializer =>
      _$transferOwnershipRejectResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TransferOwnershipRejectResponseApplicationJsonBuilder b) {
    $TransferOwnershipRejectResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TransferOwnershipRejectResponseApplicationJsonBuilder b) {
    $TransferOwnershipRejectResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_Files_DirectEditingInterface {
  String get url;
  String get etag;
  bool get supportsFileId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_Files_DirectEditingInterfaceBuilder].
  $Capabilities_Files_DirectEditingInterface rebuild(
    void Function($Capabilities_Files_DirectEditingInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$Capabilities_Files_DirectEditingInterfaceBuilder].
  $Capabilities_Files_DirectEditingInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_Files_DirectEditingInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_Files_DirectEditingInterfaceBuilder b) {}
}

abstract class Capabilities_Files_DirectEditing
    implements
        $Capabilities_Files_DirectEditingInterface,
        Built<Capabilities_Files_DirectEditing, Capabilities_Files_DirectEditingBuilder> {
  /// Creates a new Capabilities_Files_DirectEditing object using the builder pattern.
  factory Capabilities_Files_DirectEditing([void Function(Capabilities_Files_DirectEditingBuilder)? b]) =
      _$Capabilities_Files_DirectEditing;

  // coverage:ignore-start
  const Capabilities_Files_DirectEditing._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_Files_DirectEditing.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_Files_DirectEditing.
  static Serializer<Capabilities_Files_DirectEditing> get serializer => _$capabilitiesFilesDirectEditingSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_Files_DirectEditingBuilder b) {
    $Capabilities_Files_DirectEditingInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_Files_DirectEditingBuilder b) {
    $Capabilities_Files_DirectEditingInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_FilesInterface {
  @BuiltValueField(wireName: r'$comment')
  String? get comment;
  bool get bigfilechunking;
  @BuiltValueField(wireName: 'blacklisted_files')
  BuiltList<JsonObject> get blacklistedFiles;
  @BuiltValueField(wireName: 'forbidden_filenames')
  BuiltList<String> get forbiddenFilenames;
  @BuiltValueField(wireName: 'forbidden_filename_basenames')
  BuiltList<String> get forbiddenFilenameBasenames;
  @BuiltValueField(wireName: 'forbidden_filename_characters')
  BuiltList<String> get forbiddenFilenameCharacters;
  @BuiltValueField(wireName: 'forbidden_filename_extensions')
  BuiltList<String> get forbiddenFilenameExtensions;
  Capabilities_Files_DirectEditing get directEditing;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_FilesInterfaceBuilder].
  $Capabilities_FilesInterface rebuild(void Function($Capabilities_FilesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Capabilities_FilesInterfaceBuilder].
  $Capabilities_FilesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_FilesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_FilesInterfaceBuilder b) {}
}

abstract class Capabilities_Files
    implements $Capabilities_FilesInterface, Built<Capabilities_Files, Capabilities_FilesBuilder> {
  /// Creates a new Capabilities_Files object using the builder pattern.
  factory Capabilities_Files([void Function(Capabilities_FilesBuilder)? b]) = _$Capabilities_Files;

  // coverage:ignore-start
  const Capabilities_Files._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_Files.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_Files.
  static Serializer<Capabilities_Files> get serializer => _$capabilitiesFilesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_FilesBuilder b) {
    $Capabilities_FilesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_FilesBuilder b) {
    $Capabilities_FilesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CapabilitiesInterface {
  Capabilities_Files get files;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterface rebuild(void Function($CapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CapabilitiesInterfaceBuilder b) {}
}

abstract class Capabilities implements $CapabilitiesInterface, Built<Capabilities, CapabilitiesBuilder> {
  /// Creates a new Capabilities object using the builder pattern.
  factory Capabilities([void Function(CapabilitiesBuilder)? b]) = _$Capabilities;

  // coverage:ignore-start
  const Capabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities.
  static Serializer<Capabilities> get serializer => _$capabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CapabilitiesBuilder b) {
    $CapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CapabilitiesBuilder b) {
    $CapabilitiesInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(const FullType(FolderTree), FolderTreeBuilder.new)
      ..add(FolderTree.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(JsonObject)]), ListBuilder<JsonObject>.new)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(FolderTree)]), ListBuilder<FolderTree>.new)
      ..addBuilderFactory(
        const FullType(DirectEditingInfoResponseApplicationJson),
        DirectEditingInfoResponseApplicationJsonBuilder.new,
      )
      ..add(DirectEditingInfoResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingInfoResponseApplicationJson_Ocs),
        DirectEditingInfoResponseApplicationJson_OcsBuilder.new,
      )
      ..add(DirectEditingInfoResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingInfoResponseApplicationJson_Ocs_Data),
        DirectEditingInfoResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(DirectEditingInfoResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors),
        DirectEditingInfoResponseApplicationJson_Ocs_Data_EditorsBuilder.new,
      )
      ..add(DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(String)]), ListBuilder<String>.new)
      ..addBuilderFactory(
        const FullType(
          BuiltMap,
          [FullType(String), FullType(DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors)],
        ),
        MapBuilder<String, DirectEditingInfoResponseApplicationJson_Ocs_Data_Editors>.new,
      )
      ..addBuilderFactory(
        const FullType(DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators),
        DirectEditingInfoResponseApplicationJson_Ocs_Data_CreatorsBuilder.new,
      )
      ..add(DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators.serializer)
      ..addBuilderFactory(
        const FullType(
          BuiltMap,
          [FullType(String), FullType(DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators)],
        ),
        MapBuilder<String, DirectEditingInfoResponseApplicationJson_Ocs_Data_Creators>.new,
      )
      ..addBuilderFactory(
        const FullType(DirectEditingTemplatesResponseApplicationJson),
        DirectEditingTemplatesResponseApplicationJsonBuilder.new,
      )
      ..add(DirectEditingTemplatesResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingTemplatesResponseApplicationJson_Ocs),
        DirectEditingTemplatesResponseApplicationJson_OcsBuilder.new,
      )
      ..add(DirectEditingTemplatesResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingTemplatesResponseApplicationJson_Ocs_Data),
        DirectEditingTemplatesResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(DirectEditingTemplatesResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates),
        DirectEditingTemplatesResponseApplicationJson_Ocs_Data_TemplatesBuilder.new,
      )
      ..add(DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates.serializer)
      ..addBuilderFactory(
        const FullType(
          BuiltMap,
          [FullType(String), FullType(DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates)],
        ),
        MapBuilder<String, DirectEditingTemplatesResponseApplicationJson_Ocs_Data_Templates>.new,
      )
      ..addBuilderFactory(
        const FullType(DirectEditingOpenRequestApplicationJson),
        DirectEditingOpenRequestApplicationJsonBuilder.new,
      )
      ..add(DirectEditingOpenRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingOpenResponseApplicationJson),
        DirectEditingOpenResponseApplicationJsonBuilder.new,
      )
      ..add(DirectEditingOpenResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingOpenResponseApplicationJson_Ocs),
        DirectEditingOpenResponseApplicationJson_OcsBuilder.new,
      )
      ..add(DirectEditingOpenResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingOpenResponseApplicationJson_Ocs_Data),
        DirectEditingOpenResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(DirectEditingOpenResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingCreateRequestApplicationJson),
        DirectEditingCreateRequestApplicationJsonBuilder.new,
      )
      ..add(DirectEditingCreateRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingCreateResponseApplicationJson),
        DirectEditingCreateResponseApplicationJsonBuilder.new,
      )
      ..add(DirectEditingCreateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingCreateResponseApplicationJson_Ocs),
        DirectEditingCreateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(DirectEditingCreateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(DirectEditingCreateResponseApplicationJson_Ocs_Data),
        DirectEditingCreateResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(DirectEditingCreateResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(OpenLocalEditorCreateRequestApplicationJson),
        OpenLocalEditorCreateRequestApplicationJsonBuilder.new,
      )
      ..add(OpenLocalEditorCreateRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OpenLocalEditorCreateResponseApplicationJson),
        OpenLocalEditorCreateResponseApplicationJsonBuilder.new,
      )
      ..add(OpenLocalEditorCreateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OpenLocalEditorCreateResponseApplicationJson_Ocs),
        OpenLocalEditorCreateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(OpenLocalEditorCreateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(OpenLocalEditorCreateResponseApplicationJson_Ocs_Data),
        OpenLocalEditorCreateResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(OpenLocalEditorCreateResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(OpenLocalEditorValidateRequestApplicationJson),
        OpenLocalEditorValidateRequestApplicationJsonBuilder.new,
      )
      ..add(OpenLocalEditorValidateRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OpenLocalEditorValidateResponseApplicationJson),
        OpenLocalEditorValidateResponseApplicationJsonBuilder.new,
      )
      ..add(OpenLocalEditorValidateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OpenLocalEditorValidateResponseApplicationJson_Ocs),
        OpenLocalEditorValidateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(OpenLocalEditorValidateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(OpenLocalEditorValidateResponseApplicationJson_Ocs_Data),
        OpenLocalEditorValidateResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(OpenLocalEditorValidateResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(TemplateListResponseApplicationJson),
        TemplateListResponseApplicationJsonBuilder.new,
      )
      ..add(TemplateListResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(TemplateListResponseApplicationJson_Ocs),
        TemplateListResponseApplicationJson_OcsBuilder.new,
      )
      ..add(TemplateListResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(TemplateFileCreator), TemplateFileCreatorBuilder.new)
      ..add(TemplateFileCreator.serializer)
      ..addBuilderFactory(
        const FullType(BuiltList, [FullType(TemplateFileCreator)]),
        ListBuilder<TemplateFileCreator>.new,
      )
      ..addBuilderFactory(
        const FullType(TemplateCreateRequestApplicationJson),
        TemplateCreateRequestApplicationJsonBuilder.new,
      )
      ..add(TemplateCreateRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(TemplateField), TemplateFieldBuilder.new)
      ..add(TemplateField.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(TemplateField)]), ListBuilder<TemplateField>.new)
      ..addBuilderFactory(
        const FullType(TemplateCreateResponseApplicationJson),
        TemplateCreateResponseApplicationJsonBuilder.new,
      )
      ..add(TemplateCreateResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(TemplateCreateResponseApplicationJson_Ocs),
        TemplateCreateResponseApplicationJson_OcsBuilder.new,
      )
      ..add(TemplateCreateResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(TemplateFile), TemplateFileBuilder.new)
      ..add(TemplateFile.serializer)
      ..addBuilderFactory(
        const FullType(TemplatePathRequestApplicationJson),
        TemplatePathRequestApplicationJsonBuilder.new,
      )
      ..add(TemplatePathRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(TemplatePathResponseApplicationJson),
        TemplatePathResponseApplicationJsonBuilder.new,
      )
      ..add(TemplatePathResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(TemplatePathResponseApplicationJson_Ocs),
        TemplatePathResponseApplicationJson_OcsBuilder.new,
      )
      ..add(TemplatePathResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(TemplatePathResponseApplicationJson_Ocs_Data),
        TemplatePathResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(TemplatePathResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(TransferOwnershipTransferRequestApplicationJson),
        TransferOwnershipTransferRequestApplicationJsonBuilder.new,
      )
      ..add(TransferOwnershipTransferRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(TransferOwnershipTransferResponseApplicationJson),
        TransferOwnershipTransferResponseApplicationJsonBuilder.new,
      )
      ..add(TransferOwnershipTransferResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(TransferOwnershipTransferResponseApplicationJson_Ocs),
        TransferOwnershipTransferResponseApplicationJson_OcsBuilder.new,
      )
      ..add(TransferOwnershipTransferResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(TransferOwnershipAcceptResponseApplicationJson),
        TransferOwnershipAcceptResponseApplicationJsonBuilder.new,
      )
      ..add(TransferOwnershipAcceptResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(TransferOwnershipAcceptResponseApplicationJson_Ocs),
        TransferOwnershipAcceptResponseApplicationJson_OcsBuilder.new,
      )
      ..add(TransferOwnershipAcceptResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(TransferOwnershipRejectResponseApplicationJson),
        TransferOwnershipRejectResponseApplicationJsonBuilder.new,
      )
      ..add(TransferOwnershipRejectResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(TransferOwnershipRejectResponseApplicationJson_Ocs),
        TransferOwnershipRejectResponseApplicationJson_OcsBuilder.new,
      )
      ..add(TransferOwnershipRejectResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(Capabilities), CapabilitiesBuilder.new)
      ..add(Capabilities.serializer)
      ..addBuilderFactory(const FullType(Capabilities_Files), Capabilities_FilesBuilder.new)
      ..add(Capabilities_Files.serializer)
      ..addBuilderFactory(const FullType(Capabilities_Files_DirectEditing), Capabilities_Files_DirectEditingBuilder.new)
      ..add(Capabilities_Files_DirectEditing.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(_i8.StandardJsonPlugin())
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
