// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// dav Version: 0.0.1.
///
/// WebDAV endpoint.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/utils.dart' as _i5;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i6;

part 'dav.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $DirectClient direct = $DirectClient(this);

  late final $OutOfOfficeClient outOfOffice = $OutOfOfficeClient(this);

  late final $UpcomingEventsClient upcomingEvents = $UpcomingEventsClient(this);
}

class $DirectClient {
  /// Creates a new `DynamiteClient` for direct requests.
  $DirectClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getUrl_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<DirectGetUrlResponseApplicationJson, void> $getUrl_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(DirectGetUrlResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a direct link to a file.
  ///
  /// Returns a `DynamiteRequest` backing the [getUrl] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Direct link returned
  ///   * 404: File not found
  ///   * 400: Getting direct link is not possible
  ///   * 403: Missing permissions to get direct link
  ///
  /// See:
  ///  * [getUrl] for a method executing this request and parsing the response.
  ///  * [$getUrl_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUrl_Request({
    required DirectGetUrlRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/apps/dav/api/v1/direct';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(DirectGetUrlRequestApplicationJson)));
    return _request;
  }

  /// Get a direct link to a file.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Direct link returned
  ///   * 404: File not found
  ///   * 400: Getting direct link is not possible
  ///   * 403: Missing permissions to get direct link
  ///
  /// See:
  ///  * [$getUrl_Request] for the request send by this method.
  ///  * [$getUrl_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<DirectGetUrlResponseApplicationJson, void>> getUrl({
    required DirectGetUrlRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUrl_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUrl_Serializer();
    return _i1.ResponseConverter<DirectGetUrlResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $OutOfOfficeClient {
  /// Creates a new `DynamiteClient` for out_of_office requests.
  $OutOfOfficeClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getCurrentOutOfOfficeData_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson, void>
      $getCurrentOutOfOfficeData_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the currently configured out-of-office data of a user.
  ///
  /// Returns a `DynamiteRequest` backing the [getCurrentOutOfOfficeData] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] The user id to get out-of-office data for.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Out-of-office data
  ///   * 404: No out-of-office data was found
  ///
  /// See:
  ///  * [getCurrentOutOfOfficeData] for a method executing this request and parsing the response.
  ///  * [$getCurrentOutOfOfficeData_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getCurrentOutOfOfficeData_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/dav/api/v1/outOfOffice/{userId}/now').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the currently configured out-of-office data of a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] The user id to get out-of-office data for.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Out-of-office data
  ///   * 404: No out-of-office data was found
  ///
  /// See:
  ///  * [$getCurrentOutOfOfficeData_Request] for the request send by this method.
  ///  * [$getCurrentOutOfOfficeData_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson, void>>
      getCurrentOutOfOfficeData({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getCurrentOutOfOfficeData_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getCurrentOutOfOfficeData_Serializer();
    return _i1.ResponseConverter<OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getOutOfOffice_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<OutOfOfficeGetOutOfOfficeResponseApplicationJson, void> $getOutOfOffice_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(OutOfOfficeGetOutOfOfficeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the configured out-of-office data of a user.
  ///
  /// Returns a `DynamiteRequest` backing the [getOutOfOffice] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] The user id to get out-of-office data for.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Out-of-office data
  ///   * 404: No out-of-office data was found
  ///
  /// See:
  ///  * [getOutOfOffice] for a method executing this request and parsing the response.
  ///  * [$getOutOfOffice_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getOutOfOffice_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/dav/api/v1/outOfOffice/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the configured out-of-office data of a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] The user id to get out-of-office data for.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Out-of-office data
  ///   * 404: No out-of-office data was found
  ///
  /// See:
  ///  * [$getOutOfOffice_Request] for the request send by this method.
  ///  * [$getOutOfOffice_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<OutOfOfficeGetOutOfOfficeResponseApplicationJson, void>> getOutOfOffice({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getOutOfOffice_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getOutOfOffice_Serializer();
    return _i1.ResponseConverter<OutOfOfficeGetOutOfOfficeResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setOutOfOffice_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<OutOfOfficeSetOutOfOfficeResponseApplicationJson, void> $setOutOfOffice_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(OutOfOfficeSetOutOfOfficeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set out-of-office absence.
  ///
  /// Returns a `DynamiteRequest` backing the [setOutOfOffice] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Absence data
  ///   * 400: When the first day is not before the last day
  ///   * 401: When the user is not logged in
  ///   * 404: When the replacementUserId was provided but replacement user was not found
  ///
  /// See:
  ///  * [setOutOfOffice] for a method executing this request and parsing the response.
  ///  * [$setOutOfOffice_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setOutOfOffice_Request({
    required String userId,
    required OutOfOfficeSetOutOfOfficeRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/dav/api/v1/outOfOffice/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(OutOfOfficeSetOutOfOfficeRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Set out-of-office absence.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Absence data
  ///   * 400: When the first day is not before the last day
  ///   * 401: When the user is not logged in
  ///   * 404: When the replacementUserId was provided but replacement user was not found
  ///
  /// See:
  ///  * [$setOutOfOffice_Request] for the request send by this method.
  ///  * [$setOutOfOffice_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<OutOfOfficeSetOutOfOfficeResponseApplicationJson, void>> setOutOfOffice({
    required String userId,
    required OutOfOfficeSetOutOfOfficeRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setOutOfOffice_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setOutOfOffice_Serializer();
    return _i1.ResponseConverter<OutOfOfficeSetOutOfOfficeResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$clearOutOfOffice_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<OutOfOfficeClearOutOfOfficeResponseApplicationJson, void> $clearOutOfOffice_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(OutOfOfficeClearOutOfOfficeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 401},
      );

  /// Clear the out-of-office.
  ///
  /// Returns a `DynamiteRequest` backing the [clearOutOfOffice] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: When the absence was cleared successfully
  ///   * 401: When the user is not logged in
  ///
  /// See:
  ///  * [clearOutOfOffice] for a method executing this request and parsing the response.
  ///  * [$clearOutOfOffice_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $clearOutOfOffice_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/dav/api/v1/outOfOffice/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Clear the out-of-office.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId]
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: When the absence was cleared successfully
  ///   * 401: When the user is not logged in
  ///
  /// See:
  ///  * [$clearOutOfOffice_Request] for the request send by this method.
  ///  * [$clearOutOfOffice_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<OutOfOfficeClearOutOfOfficeResponseApplicationJson, void>> clearOutOfOffice({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $clearOutOfOffice_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $clearOutOfOffice_Serializer();
    return _i1.ResponseConverter<OutOfOfficeClearOutOfOfficeResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $UpcomingEventsClient {
  /// Creates a new `DynamiteClient` for upcoming_events requests.
  $UpcomingEventsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getEvents_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UpcomingEventsGetEventsResponseApplicationJson, void> $getEvents_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UpcomingEventsGetEventsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get information about upcoming events.
  ///
  /// Returns a `DynamiteRequest` backing the [getEvents] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [location] location/URL to filter by.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Upcoming events
  ///   * 401: When not authenticated
  ///
  /// See:
  ///  * [getEvents] for a method executing this request and parsing the response.
  ///  * [$getEvents_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getEvents_Request({
    String? location,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __location = _$jsonSerializers.serialize(location, specifiedType: const FullType(String));
    _parameters['location'] = __location;

    final _path = _i6.UriTemplate('/ocs/v2.php/apps/dav/api/v1/events/upcoming{?location*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get information about upcoming events.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [location] location/URL to filter by.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Upcoming events
  ///   * 401: When not authenticated
  ///
  /// See:
  ///  * [$getEvents_Request] for the request send by this method.
  ///  * [$getEvents_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UpcomingEventsGetEventsResponseApplicationJson, void>> getEvents({
    String? location,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getEvents_Request(
      location: location,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getEvents_Serializer();
    return _i1.ResponseConverter<UpcomingEventsGetEventsResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectGetUrlRequestApplicationJsonInterface {
  /// ID of the file.
  int get fileId;

  /// Duration until the link expires.
  int get expirationTime;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectGetUrlRequestApplicationJsonInterfaceBuilder].
  $DirectGetUrlRequestApplicationJsonInterface rebuild(
    void Function($DirectGetUrlRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectGetUrlRequestApplicationJsonInterfaceBuilder].
  $DirectGetUrlRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectGetUrlRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectGetUrlRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class DirectGetUrlRequestApplicationJson
    implements
        $DirectGetUrlRequestApplicationJsonInterface,
        Built<DirectGetUrlRequestApplicationJson, DirectGetUrlRequestApplicationJsonBuilder> {
  /// Creates a new DirectGetUrlRequestApplicationJson object using the builder pattern.
  factory DirectGetUrlRequestApplicationJson([void Function(DirectGetUrlRequestApplicationJsonBuilder)? b]) =
      _$DirectGetUrlRequestApplicationJson;

  // coverage:ignore-start
  const DirectGetUrlRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectGetUrlRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectGetUrlRequestApplicationJson.
  static Serializer<DirectGetUrlRequestApplicationJson> get serializer =>
      _$directGetUrlRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectGetUrlRequestApplicationJsonBuilder b) {
    $DirectGetUrlRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectGetUrlRequestApplicationJsonBuilder b) {
    $DirectGetUrlRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectGetUrlResponseApplicationJson_Ocs_DataInterface {
  String get url;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectGetUrlResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectGetUrlResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($DirectGetUrlResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectGetUrlResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $DirectGetUrlResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectGetUrlResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectGetUrlResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class DirectGetUrlResponseApplicationJson_Ocs_Data
    implements
        $DirectGetUrlResponseApplicationJson_Ocs_DataInterface,
        Built<DirectGetUrlResponseApplicationJson_Ocs_Data, DirectGetUrlResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new DirectGetUrlResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory DirectGetUrlResponseApplicationJson_Ocs_Data([
    void Function(DirectGetUrlResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$DirectGetUrlResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const DirectGetUrlResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectGetUrlResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectGetUrlResponseApplicationJson_Ocs_Data.
  static Serializer<DirectGetUrlResponseApplicationJson_Ocs_Data> get serializer =>
      _$directGetUrlResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectGetUrlResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectGetUrlResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectGetUrlResponseApplicationJson_Ocs_DataBuilder b) {
    $DirectGetUrlResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectGetUrlResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  DirectGetUrlResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectGetUrlResponseApplicationJson_OcsInterfaceBuilder].
  $DirectGetUrlResponseApplicationJson_OcsInterface rebuild(
    void Function($DirectGetUrlResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectGetUrlResponseApplicationJson_OcsInterfaceBuilder].
  $DirectGetUrlResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectGetUrlResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectGetUrlResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class DirectGetUrlResponseApplicationJson_Ocs
    implements
        $DirectGetUrlResponseApplicationJson_OcsInterface,
        Built<DirectGetUrlResponseApplicationJson_Ocs, DirectGetUrlResponseApplicationJson_OcsBuilder> {
  /// Creates a new DirectGetUrlResponseApplicationJson_Ocs object using the builder pattern.
  factory DirectGetUrlResponseApplicationJson_Ocs([void Function(DirectGetUrlResponseApplicationJson_OcsBuilder)? b]) =
      _$DirectGetUrlResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const DirectGetUrlResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectGetUrlResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectGetUrlResponseApplicationJson_Ocs.
  static Serializer<DirectGetUrlResponseApplicationJson_Ocs> get serializer =>
      _$directGetUrlResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectGetUrlResponseApplicationJson_OcsBuilder b) {
    $DirectGetUrlResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectGetUrlResponseApplicationJson_OcsBuilder b) {
    $DirectGetUrlResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DirectGetUrlResponseApplicationJsonInterface {
  DirectGetUrlResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DirectGetUrlResponseApplicationJsonInterfaceBuilder].
  $DirectGetUrlResponseApplicationJsonInterface rebuild(
    void Function($DirectGetUrlResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DirectGetUrlResponseApplicationJsonInterfaceBuilder].
  $DirectGetUrlResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DirectGetUrlResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DirectGetUrlResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class DirectGetUrlResponseApplicationJson
    implements
        $DirectGetUrlResponseApplicationJsonInterface,
        Built<DirectGetUrlResponseApplicationJson, DirectGetUrlResponseApplicationJsonBuilder> {
  /// Creates a new DirectGetUrlResponseApplicationJson object using the builder pattern.
  factory DirectGetUrlResponseApplicationJson([void Function(DirectGetUrlResponseApplicationJsonBuilder)? b]) =
      _$DirectGetUrlResponseApplicationJson;

  // coverage:ignore-start
  const DirectGetUrlResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DirectGetUrlResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DirectGetUrlResponseApplicationJson.
  static Serializer<DirectGetUrlResponseApplicationJson> get serializer =>
      _$directGetUrlResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DirectGetUrlResponseApplicationJsonBuilder b) {
    $DirectGetUrlResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DirectGetUrlResponseApplicationJsonBuilder b) {
    $DirectGetUrlResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeDataCommonInterface {
  String get userId;
  String get message;
  String? get replacementUserId;
  String? get replacementUserDisplayName;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeDataCommonInterfaceBuilder].
  $OutOfOfficeDataCommonInterface rebuild(void Function($OutOfOfficeDataCommonInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OutOfOfficeDataCommonInterfaceBuilder].
  $OutOfOfficeDataCommonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeDataCommonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeDataCommonInterfaceBuilder b) {}
}

abstract class OutOfOfficeDataCommon
    implements $OutOfOfficeDataCommonInterface, Built<OutOfOfficeDataCommon, OutOfOfficeDataCommonBuilder> {
  /// Creates a new OutOfOfficeDataCommon object using the builder pattern.
  factory OutOfOfficeDataCommon([void Function(OutOfOfficeDataCommonBuilder)? b]) = _$OutOfOfficeDataCommon;

  // coverage:ignore-start
  const OutOfOfficeDataCommon._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeDataCommon.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeDataCommon.
  static Serializer<OutOfOfficeDataCommon> get serializer => _$outOfOfficeDataCommonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeDataCommonBuilder b) {
    $OutOfOfficeDataCommonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeDataCommonBuilder b) {
    $OutOfOfficeDataCommonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CurrentOutOfOfficeDataInterface implements $OutOfOfficeDataCommonInterface {
  String get id;
  int get startDate;
  int get endDate;
  String get shortMessage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CurrentOutOfOfficeDataInterfaceBuilder].
  @override
  $CurrentOutOfOfficeDataInterface rebuild(void Function($CurrentOutOfOfficeDataInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CurrentOutOfOfficeDataInterfaceBuilder].
  @override
  $CurrentOutOfOfficeDataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CurrentOutOfOfficeDataInterfaceBuilder b) {
    $OutOfOfficeDataCommonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CurrentOutOfOfficeDataInterfaceBuilder b) {
    $OutOfOfficeDataCommonInterface._validate(b);
  }
}

abstract class CurrentOutOfOfficeData
    implements $CurrentOutOfOfficeDataInterface, Built<CurrentOutOfOfficeData, CurrentOutOfOfficeDataBuilder> {
  /// Creates a new CurrentOutOfOfficeData object using the builder pattern.
  factory CurrentOutOfOfficeData([void Function(CurrentOutOfOfficeDataBuilder)? b]) = _$CurrentOutOfOfficeData;

  // coverage:ignore-start
  const CurrentOutOfOfficeData._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CurrentOutOfOfficeData.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CurrentOutOfOfficeData.
  static Serializer<CurrentOutOfOfficeData> get serializer => _$currentOutOfOfficeDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CurrentOutOfOfficeDataBuilder b) {
    $CurrentOutOfOfficeDataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CurrentOutOfOfficeDataBuilder b) {
    $CurrentOutOfOfficeDataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  CurrentOutOfOfficeData get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterfaceBuilder].
  $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterface rebuild(
    void Function($OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterfaceBuilder].
  $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs
    implements
        $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterface,
        Built<OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs,
            OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsBuilder> {
  /// Creates a new OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs object using the builder pattern.
  factory OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs([
    void Function(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsBuilder)? b,
  ]) = _$OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs.
  static Serializer<OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs> get serializer =>
      _$outOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsBuilder b) {
    $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsBuilder b) {
    $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterface {
  OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterfaceBuilder].
  $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterface rebuild(
    void Function($OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterfaceBuilder].
  $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson
    implements
        $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterface,
        Built<OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson,
            OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonBuilder> {
  /// Creates a new OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson object using the builder pattern.
  factory OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson([
    void Function(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonBuilder)? b,
  ]) = _$OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson;

  // coverage:ignore-start
  const OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson.
  static Serializer<OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson> get serializer =>
      _$outOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonBuilder b) {
    $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonBuilder b) {
    $OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeDataInterface implements $OutOfOfficeDataCommonInterface {
  int get id;
  String get firstDay;
  String get lastDay;
  String get status;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeDataInterfaceBuilder].
  @override
  $OutOfOfficeDataInterface rebuild(void Function($OutOfOfficeDataInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OutOfOfficeDataInterfaceBuilder].
  @override
  $OutOfOfficeDataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeDataInterfaceBuilder b) {
    $OutOfOfficeDataCommonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeDataInterfaceBuilder b) {
    $OutOfOfficeDataCommonInterface._validate(b);
  }
}

abstract class OutOfOfficeData implements $OutOfOfficeDataInterface, Built<OutOfOfficeData, OutOfOfficeDataBuilder> {
  /// Creates a new OutOfOfficeData object using the builder pattern.
  factory OutOfOfficeData([void Function(OutOfOfficeDataBuilder)? b]) = _$OutOfOfficeData;

  // coverage:ignore-start
  const OutOfOfficeData._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeData.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeData.
  static Serializer<OutOfOfficeData> get serializer => _$outOfOfficeDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeDataBuilder b) {
    $OutOfOfficeDataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeDataBuilder b) {
    $OutOfOfficeDataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  OutOfOfficeData get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder].
  $OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterface rebuild(
    void Function($OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder].
  $OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs
    implements
        $OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterface,
        Built<OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs,
            OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsBuilder> {
  /// Creates a new OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs object using the builder pattern.
  factory OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs([
    void Function(OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs.
  static Serializer<OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs> get serializer =>
      _$outOfOfficeGetOutOfOfficeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsBuilder b) {
    $OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsBuilder b) {
    $OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterface {
  OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterfaceBuilder].
  $OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterface rebuild(
    void Function($OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterfaceBuilder].
  $OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class OutOfOfficeGetOutOfOfficeResponseApplicationJson
    implements
        $OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterface,
        Built<OutOfOfficeGetOutOfOfficeResponseApplicationJson,
            OutOfOfficeGetOutOfOfficeResponseApplicationJsonBuilder> {
  /// Creates a new OutOfOfficeGetOutOfOfficeResponseApplicationJson object using the builder pattern.
  factory OutOfOfficeGetOutOfOfficeResponseApplicationJson([
    void Function(OutOfOfficeGetOutOfOfficeResponseApplicationJsonBuilder)? b,
  ]) = _$OutOfOfficeGetOutOfOfficeResponseApplicationJson;

  // coverage:ignore-start
  const OutOfOfficeGetOutOfOfficeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeGetOutOfOfficeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeGetOutOfOfficeResponseApplicationJson.
  static Serializer<OutOfOfficeGetOutOfOfficeResponseApplicationJson> get serializer =>
      _$outOfOfficeGetOutOfOfficeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeGetOutOfOfficeResponseApplicationJsonBuilder b) {
    $OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeGetOutOfOfficeResponseApplicationJsonBuilder b) {
    $OutOfOfficeGetOutOfOfficeResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterface {
  /// First day of the absence in format `YYYY-MM-DD`.
  String get firstDay;

  /// Last day of the absence in format `YYYY-MM-DD`.
  String get lastDay;

  /// Short text that is set as user status during the absence.
  String get status;

  /// Longer multiline message that is shown to others during the absence.
  String get message;

  /// User id of the replacement user.
  String? get replacementUserId;

  /// Display name of the replacement user.
  String? get replacementUserDisplayName;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterfaceBuilder].
  $OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterface rebuild(
    void Function($OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterfaceBuilder].
  $OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class OutOfOfficeSetOutOfOfficeRequestApplicationJson
    implements
        $OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterface,
        Built<OutOfOfficeSetOutOfOfficeRequestApplicationJson, OutOfOfficeSetOutOfOfficeRequestApplicationJsonBuilder> {
  /// Creates a new OutOfOfficeSetOutOfOfficeRequestApplicationJson object using the builder pattern.
  factory OutOfOfficeSetOutOfOfficeRequestApplicationJson([
    void Function(OutOfOfficeSetOutOfOfficeRequestApplicationJsonBuilder)? b,
  ]) = _$OutOfOfficeSetOutOfOfficeRequestApplicationJson;

  // coverage:ignore-start
  const OutOfOfficeSetOutOfOfficeRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeSetOutOfOfficeRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeSetOutOfOfficeRequestApplicationJson.
  static Serializer<OutOfOfficeSetOutOfOfficeRequestApplicationJson> get serializer =>
      _$outOfOfficeSetOutOfOfficeRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeSetOutOfOfficeRequestApplicationJsonBuilder b) {
    $OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeSetOutOfOfficeRequestApplicationJsonBuilder b) {
    $OutOfOfficeSetOutOfOfficeRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  OutOfOfficeData get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder].
  $OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterface rebuild(
    void Function($OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder].
  $OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs
    implements
        $OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterface,
        Built<OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs,
            OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsBuilder> {
  /// Creates a new OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs object using the builder pattern.
  factory OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs([
    void Function(OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs.
  static Serializer<OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs> get serializer =>
      _$outOfOfficeSetOutOfOfficeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsBuilder b) {
    $OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsBuilder b) {
    $OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterface {
  OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterfaceBuilder].
  $OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterface rebuild(
    void Function($OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterfaceBuilder].
  $OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class OutOfOfficeSetOutOfOfficeResponseApplicationJson
    implements
        $OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterface,
        Built<OutOfOfficeSetOutOfOfficeResponseApplicationJson,
            OutOfOfficeSetOutOfOfficeResponseApplicationJsonBuilder> {
  /// Creates a new OutOfOfficeSetOutOfOfficeResponseApplicationJson object using the builder pattern.
  factory OutOfOfficeSetOutOfOfficeResponseApplicationJson([
    void Function(OutOfOfficeSetOutOfOfficeResponseApplicationJsonBuilder)? b,
  ]) = _$OutOfOfficeSetOutOfOfficeResponseApplicationJson;

  // coverage:ignore-start
  const OutOfOfficeSetOutOfOfficeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeSetOutOfOfficeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeSetOutOfOfficeResponseApplicationJson.
  static Serializer<OutOfOfficeSetOutOfOfficeResponseApplicationJson> get serializer =>
      _$outOfOfficeSetOutOfOfficeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeSetOutOfOfficeResponseApplicationJsonBuilder b) {
    $OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeSetOutOfOfficeResponseApplicationJsonBuilder b) {
    $OutOfOfficeSetOutOfOfficeResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject? get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder].
  $OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterface rebuild(
    void Function($OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder].
  $OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs
    implements
        $OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterface,
        Built<OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs,
            OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsBuilder> {
  /// Creates a new OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs object using the builder pattern.
  factory OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs([
    void Function(OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsBuilder)? b,
  ]) = _$OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs.
  static Serializer<OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs> get serializer =>
      _$outOfOfficeClearOutOfOfficeResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsBuilder b) {
    $OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsBuilder b) {
    $OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterface {
  OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterfaceBuilder].
  $OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterface rebuild(
    void Function($OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterfaceBuilder].
  $OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class OutOfOfficeClearOutOfOfficeResponseApplicationJson
    implements
        $OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterface,
        Built<OutOfOfficeClearOutOfOfficeResponseApplicationJson,
            OutOfOfficeClearOutOfOfficeResponseApplicationJsonBuilder> {
  /// Creates a new OutOfOfficeClearOutOfOfficeResponseApplicationJson object using the builder pattern.
  factory OutOfOfficeClearOutOfOfficeResponseApplicationJson([
    void Function(OutOfOfficeClearOutOfOfficeResponseApplicationJsonBuilder)? b,
  ]) = _$OutOfOfficeClearOutOfOfficeResponseApplicationJson;

  // coverage:ignore-start
  const OutOfOfficeClearOutOfOfficeResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OutOfOfficeClearOutOfOfficeResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OutOfOfficeClearOutOfOfficeResponseApplicationJson.
  static Serializer<OutOfOfficeClearOutOfOfficeResponseApplicationJson> get serializer =>
      _$outOfOfficeClearOutOfOfficeResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OutOfOfficeClearOutOfOfficeResponseApplicationJsonBuilder b) {
    $OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OutOfOfficeClearOutOfOfficeResponseApplicationJsonBuilder b) {
    $OutOfOfficeClearOutOfOfficeResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UpcomingEventInterface {
  String get uri;
  String get calendarUri;
  int? get start;
  String? get summary;
  String? get location;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UpcomingEventInterfaceBuilder].
  $UpcomingEventInterface rebuild(void Function($UpcomingEventInterfaceBuilder) updates);

  /// Converts the instance to a builder [$UpcomingEventInterfaceBuilder].
  $UpcomingEventInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UpcomingEventInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UpcomingEventInterfaceBuilder b) {}
}

abstract class UpcomingEvent implements $UpcomingEventInterface, Built<UpcomingEvent, UpcomingEventBuilder> {
  /// Creates a new UpcomingEvent object using the builder pattern.
  factory UpcomingEvent([void Function(UpcomingEventBuilder)? b]) = _$UpcomingEvent;

  // coverage:ignore-start
  const UpcomingEvent._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UpcomingEvent.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UpcomingEvent.
  static Serializer<UpcomingEvent> get serializer => _$upcomingEventSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UpcomingEventBuilder b) {
    $UpcomingEventInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UpcomingEventBuilder b) {
    $UpcomingEventInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterface {
  BuiltList<UpcomingEvent> get events;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data
    implements
        $UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterface,
        Built<UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data,
            UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data([
    void Function(UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data.
  static Serializer<UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data> get serializer =>
      _$upcomingEventsGetEventsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataBuilder b) {
    $UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataBuilder b) {
    $UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UpcomingEventsGetEventsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UpcomingEventsGetEventsResponseApplicationJson_OcsInterfaceBuilder].
  $UpcomingEventsGetEventsResponseApplicationJson_OcsInterface rebuild(
    void Function($UpcomingEventsGetEventsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UpcomingEventsGetEventsResponseApplicationJson_OcsInterfaceBuilder].
  $UpcomingEventsGetEventsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UpcomingEventsGetEventsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UpcomingEventsGetEventsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class UpcomingEventsGetEventsResponseApplicationJson_Ocs
    implements
        $UpcomingEventsGetEventsResponseApplicationJson_OcsInterface,
        Built<UpcomingEventsGetEventsResponseApplicationJson_Ocs,
            UpcomingEventsGetEventsResponseApplicationJson_OcsBuilder> {
  /// Creates a new UpcomingEventsGetEventsResponseApplicationJson_Ocs object using the builder pattern.
  factory UpcomingEventsGetEventsResponseApplicationJson_Ocs([
    void Function(UpcomingEventsGetEventsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$UpcomingEventsGetEventsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const UpcomingEventsGetEventsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UpcomingEventsGetEventsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UpcomingEventsGetEventsResponseApplicationJson_Ocs.
  static Serializer<UpcomingEventsGetEventsResponseApplicationJson_Ocs> get serializer =>
      _$upcomingEventsGetEventsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UpcomingEventsGetEventsResponseApplicationJson_OcsBuilder b) {
    $UpcomingEventsGetEventsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UpcomingEventsGetEventsResponseApplicationJson_OcsBuilder b) {
    $UpcomingEventsGetEventsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UpcomingEventsGetEventsResponseApplicationJsonInterface {
  UpcomingEventsGetEventsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UpcomingEventsGetEventsResponseApplicationJsonInterfaceBuilder].
  $UpcomingEventsGetEventsResponseApplicationJsonInterface rebuild(
    void Function($UpcomingEventsGetEventsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UpcomingEventsGetEventsResponseApplicationJsonInterfaceBuilder].
  $UpcomingEventsGetEventsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UpcomingEventsGetEventsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UpcomingEventsGetEventsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class UpcomingEventsGetEventsResponseApplicationJson
    implements
        $UpcomingEventsGetEventsResponseApplicationJsonInterface,
        Built<UpcomingEventsGetEventsResponseApplicationJson, UpcomingEventsGetEventsResponseApplicationJsonBuilder> {
  /// Creates a new UpcomingEventsGetEventsResponseApplicationJson object using the builder pattern.
  factory UpcomingEventsGetEventsResponseApplicationJson([
    void Function(UpcomingEventsGetEventsResponseApplicationJsonBuilder)? b,
  ]) = _$UpcomingEventsGetEventsResponseApplicationJson;

  // coverage:ignore-start
  const UpcomingEventsGetEventsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UpcomingEventsGetEventsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UpcomingEventsGetEventsResponseApplicationJson.
  static Serializer<UpcomingEventsGetEventsResponseApplicationJson> get serializer =>
      _$upcomingEventsGetEventsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UpcomingEventsGetEventsResponseApplicationJsonBuilder b) {
    $UpcomingEventsGetEventsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UpcomingEventsGetEventsResponseApplicationJsonBuilder b) {
    $UpcomingEventsGetEventsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $Capabilities_DavInterface {
  String get chunking;
  String? get bulkupload;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$Capabilities_DavInterfaceBuilder].
  $Capabilities_DavInterface rebuild(void Function($Capabilities_DavInterfaceBuilder) updates);

  /// Converts the instance to a builder [$Capabilities_DavInterfaceBuilder].
  $Capabilities_DavInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($Capabilities_DavInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($Capabilities_DavInterfaceBuilder b) {}
}

abstract class Capabilities_Dav
    implements $Capabilities_DavInterface, Built<Capabilities_Dav, Capabilities_DavBuilder> {
  /// Creates a new Capabilities_Dav object using the builder pattern.
  factory Capabilities_Dav([void Function(Capabilities_DavBuilder)? b]) = _$Capabilities_Dav;

  // coverage:ignore-start
  const Capabilities_Dav._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities_Dav.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities_Dav.
  static Serializer<Capabilities_Dav> get serializer => _$capabilitiesDavSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(Capabilities_DavBuilder b) {
    $Capabilities_DavInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(Capabilities_DavBuilder b) {
    $Capabilities_DavInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CapabilitiesInterface {
  Capabilities_Dav get dav;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterface rebuild(void Function($CapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CapabilitiesInterfaceBuilder].
  $CapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CapabilitiesInterfaceBuilder b) {}
}

abstract class Capabilities implements $CapabilitiesInterface, Built<Capabilities, CapabilitiesBuilder> {
  /// Creates a new Capabilities object using the builder pattern.
  factory Capabilities([void Function(CapabilitiesBuilder)? b]) = _$Capabilities;

  // coverage:ignore-start
  const Capabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Capabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Capabilities.
  static Serializer<Capabilities> get serializer => _$capabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CapabilitiesBuilder b) {
    $CapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CapabilitiesBuilder b) {
    $CapabilitiesInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(
        const FullType(DirectGetUrlRequestApplicationJson),
        DirectGetUrlRequestApplicationJsonBuilder.new,
      )
      ..add(DirectGetUrlRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DirectGetUrlResponseApplicationJson),
        DirectGetUrlResponseApplicationJsonBuilder.new,
      )
      ..add(DirectGetUrlResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(DirectGetUrlResponseApplicationJson_Ocs),
        DirectGetUrlResponseApplicationJson_OcsBuilder.new,
      )
      ..add(DirectGetUrlResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OCSMeta), OCSMetaBuilder.new)
      ..add(OCSMeta.serializer)
      ..addBuilderFactory(
        const FullType(DirectGetUrlResponseApplicationJson_Ocs_Data),
        DirectGetUrlResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(DirectGetUrlResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson),
        OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJsonBuilder.new,
      )
      ..add(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs),
        OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_OcsBuilder.new,
      )
      ..add(OutOfOfficeGetCurrentOutOfOfficeDataResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(CurrentOutOfOfficeData), CurrentOutOfOfficeDataBuilder.new)
      ..add(CurrentOutOfOfficeData.serializer)
      ..addBuilderFactory(const FullType(OutOfOfficeDataCommon), OutOfOfficeDataCommonBuilder.new)
      ..add(OutOfOfficeDataCommon.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeGetOutOfOfficeResponseApplicationJson),
        OutOfOfficeGetOutOfOfficeResponseApplicationJsonBuilder.new,
      )
      ..add(OutOfOfficeGetOutOfOfficeResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs),
        OutOfOfficeGetOutOfOfficeResponseApplicationJson_OcsBuilder.new,
      )
      ..add(OutOfOfficeGetOutOfOfficeResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(const FullType(OutOfOfficeData), OutOfOfficeDataBuilder.new)
      ..add(OutOfOfficeData.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeSetOutOfOfficeRequestApplicationJson),
        OutOfOfficeSetOutOfOfficeRequestApplicationJsonBuilder.new,
      )
      ..add(OutOfOfficeSetOutOfOfficeRequestApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeSetOutOfOfficeResponseApplicationJson),
        OutOfOfficeSetOutOfOfficeResponseApplicationJsonBuilder.new,
      )
      ..add(OutOfOfficeSetOutOfOfficeResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs),
        OutOfOfficeSetOutOfOfficeResponseApplicationJson_OcsBuilder.new,
      )
      ..add(OutOfOfficeSetOutOfOfficeResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeClearOutOfOfficeResponseApplicationJson),
        OutOfOfficeClearOutOfOfficeResponseApplicationJsonBuilder.new,
      )
      ..add(OutOfOfficeClearOutOfOfficeResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs),
        OutOfOfficeClearOutOfOfficeResponseApplicationJson_OcsBuilder.new,
      )
      ..add(OutOfOfficeClearOutOfOfficeResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UpcomingEventsGetEventsResponseApplicationJson),
        UpcomingEventsGetEventsResponseApplicationJsonBuilder.new,
      )
      ..add(UpcomingEventsGetEventsResponseApplicationJson.serializer)
      ..addBuilderFactory(
        const FullType(UpcomingEventsGetEventsResponseApplicationJson_Ocs),
        UpcomingEventsGetEventsResponseApplicationJson_OcsBuilder.new,
      )
      ..add(UpcomingEventsGetEventsResponseApplicationJson_Ocs.serializer)
      ..addBuilderFactory(
        const FullType(UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data),
        UpcomingEventsGetEventsResponseApplicationJson_Ocs_DataBuilder.new,
      )
      ..add(UpcomingEventsGetEventsResponseApplicationJson_Ocs_Data.serializer)
      ..addBuilderFactory(const FullType(UpcomingEvent), UpcomingEventBuilder.new)
      ..add(UpcomingEvent.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(UpcomingEvent)]), ListBuilder<UpcomingEvent>.new)
      ..addBuilderFactory(const FullType(Capabilities), CapabilitiesBuilder.new)
      ..add(Capabilities.serializer)
      ..addBuilderFactory(const FullType(Capabilities_Dav), Capabilities_DavBuilder.new)
      ..add(Capabilities_Dav.serializer))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i7.DynamiteDoubleSerializer())
      ..addPlugin(_i8.StandardJsonPlugin())
      ..addPlugin(const _i7.HeaderPlugin())
      ..addPlugin(const _i7.ContentStringPlugin()))
    .build();
// coverage:ignore-end
