// Use of this source code is governed by a agpl license. It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// core Version: 0.0.1.
///
/// Core functionality of Nextcloud.
///
/// Use of this source code is governed by a agpl license.
/// It can be obtained at `https://spdx.org/licenses/AGPL-3.0-only.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';
import 'dart:typed_data';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i8;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i7;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:dynamite_runtime/models.dart';
import 'package:dynamite_runtime/utils.dart' as _i5;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i6;

part 'core.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  late final $AppPasswordClient appPassword = $AppPasswordClient(this);

  late final $AutoCompleteClient autoComplete = $AutoCompleteClient(this);

  /// Class AvatarController.
  late final $AvatarClient avatar = $AvatarClient(this);

  late final $ClientFlowLoginV2Client clientFlowLoginV2 = $ClientFlowLoginV2Client(this);

  late final $CollaborationResourcesClient collaborationResources = $CollaborationResourcesClient(this);

  late final $CsrfTokenClient csrfToken = $CsrfTokenClient(this);

  /// This controller handles guest avatar requests.
  late final $GuestAvatarClient guestAvatar = $GuestAvatarClient(this);

  late final $HoverCardClient hoverCard = $HoverCardClient(this);

  late final $LoginClient login = $LoginClient(this);

  late final $NavigationClient navigation = $NavigationClient(this);

  /// Controller about the endpoint /ocm-provider/.
  late final $OcmClient ocm = $OcmClient(this);

  late final $OcsClient ocs = $OcsClient(this);

  late final $PreviewClient preview = $PreviewClient(this);

  late final $ProfileApiClient profileApi = $ProfileApiClient(this);

  late final $ReferenceClient reference = $ReferenceClient(this);

  late final $ReferenceApiClient referenceApi = $ReferenceApiClient(this);

  late final $TaskProcessingApiClient taskProcessingApi = $TaskProcessingApiClient(this);

  late final $TeamsApiClient teamsApi = $TeamsApiClient(this);

  late final $TextProcessingApiClient textProcessingApi = $TextProcessingApiClient(this);

  late final $TextToImageApiClient textToImageApi = $TextToImageApiClient(this);

  late final $TranslationApiClient translationApi = $TranslationApiClient(this);

  late final $UnifiedSearchClient unifiedSearch = $UnifiedSearchClient(this);

  late final $WhatsNewClient whatsNew = $WhatsNewClient(this);

  late final $WipeClient wipe = $WipeClient(this);

  /// Builds a serializer to parse the response of [$getStatus_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Status, void> $getStatus_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Status),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a `DynamiteRequest` backing the [getStatus] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Status returned
  ///
  /// See:
  ///  * [getStatus] for a method executing this request and parsing the response.
  ///  * [$getStatus_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getStatus_Request() {
    const _path = '/status.php';
    final _uri = Uri.parse('$baseURL$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
    return _request;
  }

  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Status returned
  ///
  /// See:
  ///  * [$getStatus_Request] for the request send by this method.
  ///  * [$getStatus_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Status, void>> getStatus() async {
    final _request = $getStatus_Request();
    final _streamedResponse = await httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getStatus_Serializer();
    return _i1.ResponseConverter<Status, void>(_serializer).convert(_response);
  }
}

class $AppPasswordClient {
  /// Creates a new `DynamiteClient` for app_password requests.
  $AppPasswordClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getAppPassword_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppPasswordGetAppPasswordResponseApplicationJson, void> $getAppPassword_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(AppPasswordGetAppPasswordResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create app password.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [getAppPassword] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App password returned
  ///   * 403: Creating app password is not allowed
  ///
  /// See:
  ///  * [getAppPassword] for a method executing this request and parsing the response.
  ///  * [$getAppPassword_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAppPassword_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/core/getapppassword';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Create app password.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App password returned
  ///   * 403: Creating app password is not allowed
  ///
  /// See:
  ///  * [$getAppPassword_Request] for the request send by this method.
  ///  * [$getAppPassword_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppPasswordGetAppPasswordResponseApplicationJson, void>> getAppPassword({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getAppPassword_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAppPassword_Serializer();
    return _i1.ResponseConverter<AppPasswordGetAppPasswordResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteAppPassword_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppPasswordDeleteAppPasswordResponseApplicationJson, void> $deleteAppPassword_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(AppPasswordDeleteAppPasswordResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 403},
      );

  /// Delete app password.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteAppPassword] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App password deleted successfully
  ///   * 403: Deleting app password is not allowed
  ///
  /// See:
  ///  * [deleteAppPassword] for a method executing this request and parsing the response.
  ///  * [$deleteAppPassword_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteAppPassword_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/core/apppassword';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Delete app password.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App password deleted successfully
  ///   * 403: Deleting app password is not allowed
  ///
  /// See:
  ///  * [$deleteAppPassword_Request] for the request send by this method.
  ///  * [$deleteAppPassword_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppPasswordDeleteAppPasswordResponseApplicationJson, void>> deleteAppPassword({
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteAppPassword_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteAppPassword_Serializer();
    return _i1.ResponseConverter<AppPasswordDeleteAppPasswordResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$rotateAppPassword_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppPasswordRotateAppPasswordResponseApplicationJson, void> $rotateAppPassword_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(AppPasswordRotateAppPasswordResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Rotate app password.
  ///
  /// Returns a `DynamiteRequest` backing the [rotateAppPassword] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App password returned
  ///   * 403: Rotating app password is not allowed
  ///
  /// See:
  ///  * [rotateAppPassword] for a method executing this request and parsing the response.
  ///  * [$rotateAppPassword_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $rotateAppPassword_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/core/apppassword/rotate';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Rotate app password.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: App password returned
  ///   * 403: Rotating app password is not allowed
  ///
  /// See:
  ///  * [$rotateAppPassword_Request] for the request send by this method.
  ///  * [$rotateAppPassword_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppPasswordRotateAppPasswordResponseApplicationJson, void>> rotateAppPassword({
    bool? oCSAPIRequest,
  }) async {
    final _request = $rotateAppPassword_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $rotateAppPassword_Serializer();
    return _i1.ResponseConverter<AppPasswordRotateAppPasswordResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$confirmUserPassword_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AppPasswordConfirmUserPasswordResponseApplicationJson, void>
      $confirmUserPassword_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(AppPasswordConfirmUserPasswordResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Confirm the user password.
  ///
  /// Returns a `DynamiteRequest` backing the [confirmUserPassword] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Password confirmation succeeded
  ///   * 403: Password confirmation failed
  ///
  /// See:
  ///  * [confirmUserPassword] for a method executing this request and parsing the response.
  ///  * [$confirmUserPassword_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $confirmUserPassword_Request({
    required AppPasswordConfirmUserPasswordRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/core/apppassword/confirm';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(AppPasswordConfirmUserPasswordRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Confirm the user password.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Password confirmation succeeded
  ///   * 403: Password confirmation failed
  ///
  /// See:
  ///  * [$confirmUserPassword_Request] for the request send by this method.
  ///  * [$confirmUserPassword_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AppPasswordConfirmUserPasswordResponseApplicationJson, void>> confirmUserPassword({
    required AppPasswordConfirmUserPasswordRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $confirmUserPassword_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $confirmUserPassword_Serializer();
    return _i1.ResponseConverter<AppPasswordConfirmUserPasswordResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $AutoCompleteClient {
  /// Creates a new `DynamiteClient` for auto_complete requests.
  $AutoCompleteClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$$get_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<AutoCompleteGetResponseApplicationJson, void> $$get_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(AutoCompleteGetResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Autocomplete a query.
  ///
  /// Returns a `DynamiteRequest` backing the [$get] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for.
  ///   * [itemType] Type of the items to search for.
  ///   * [itemId] ID of the items to search for.
  ///   * [sorter] can be piped, top prio first, e.g.: "commenters|share-recipients".
  ///   * [shareTypes] Types of shares to search for. Defaults to `[]`.
  ///   * [limit] Maximum number of results to return. Defaults to `10`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Autocomplete results returned
  ///
  /// See:
  ///  * [$get] for a method executing this request and parsing the response.
  ///  * [$$get_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$get_Request({
    required String search,
    String? itemType,
    String? itemId,
    String? sorter,
    BuiltList<int>? shareTypes,
    int? limit,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __search = _$jsonSerializers.serialize(search, specifiedType: const FullType(String));
    _parameters['search'] = __search;

    final __itemType = _$jsonSerializers.serialize(itemType, specifiedType: const FullType(String));
    _parameters['itemType'] = __itemType;

    final __itemId = _$jsonSerializers.serialize(itemId, specifiedType: const FullType(String));
    _parameters['itemId'] = __itemId;

    final __sorter = _$jsonSerializers.serialize(sorter, specifiedType: const FullType(String));
    _parameters['sorter'] = __sorter;

    var __shareTypes =
        _$jsonSerializers.serialize(shareTypes, specifiedType: const FullType(BuiltList, [FullType(int)]));
    __shareTypes ??= const [];
    _parameters['shareTypes%5B%5D'] = __shareTypes;

    var __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    __limit ??= 10;
    _parameters['limit'] = __limit;

    final _path = _i6.UriTemplate(
      '/ocs/v2.php/core/autocomplete/get{?search*,itemType*,itemId*,sorter*,shareTypes%5B%5D*,limit*}',
    ).expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Autocomplete a query.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [search] Text to search for.
  ///   * [itemType] Type of the items to search for.
  ///   * [itemId] ID of the items to search for.
  ///   * [sorter] can be piped, top prio first, e.g.: "commenters|share-recipients".
  ///   * [shareTypes] Types of shares to search for. Defaults to `[]`.
  ///   * [limit] Maximum number of results to return. Defaults to `10`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Autocomplete results returned
  ///
  /// See:
  ///  * [$$get_Request] for the request send by this method.
  ///  * [$$get_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<AutoCompleteGetResponseApplicationJson, void>> $get({
    required String search,
    String? itemType,
    String? itemId,
    String? sorter,
    BuiltList<int>? shareTypes,
    int? limit,
    bool? oCSAPIRequest,
  }) async {
    final _request = $$get_Request(
      search: search,
      itemType: itemType,
      itemId: itemId,
      sorter: sorter,
      shareTypes: shareTypes,
      limit: limit,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$get_Serializer();
    return _i1.ResponseConverter<AutoCompleteGetResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

/// Class AvatarController.
class $AvatarClient {
  /// Creates a new `DynamiteClient` for avatar requests.
  $AvatarClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getAvatarDark_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, AvatarAvatarGetAvatarDarkHeaders> $getAvatarDark_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: const FullType(AvatarAvatarGetAvatarDarkHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201},
      );

  /// Get the dark avatar.
  ///
  /// Returns a `DynamiteRequest` backing the [getAvatarDark] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [size] Size of the avatar.
  ///   * [guestFallback] Fallback to guest avatar if not found. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Avatar returned
  ///   * 201: Avatar returned
  ///   * 404: Avatar not found
  ///   * 500
  ///
  /// See:
  ///  * [getAvatarDark] for a method executing this request and parsing the response.
  ///  * [$getAvatarDark_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAvatarDark_Request({
    required String userId,
    required AvatarGetAvatarDarkSize size,
    AvatarGetAvatarDarkGuestFallback? guestFallback,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final __size = _$jsonSerializers.serialize(size, specifiedType: const FullType(AvatarGetAvatarDarkSize));
    _parameters['size'] = __size;

    var __guestFallback =
        _$jsonSerializers.serialize(guestFallback, specifiedType: const FullType(AvatarGetAvatarDarkGuestFallback));
    __guestFallback ??= 0;
    _parameters['guestFallback'] = __guestFallback;

    final _path = _i6.UriTemplate('/index.php/avatar/{userId}/{size}/dark{?guestFallback*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get the dark avatar.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [size] Size of the avatar.
  ///   * [guestFallback] Fallback to guest avatar if not found. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Avatar returned
  ///   * 201: Avatar returned
  ///   * 404: Avatar not found
  ///   * 500
  ///
  /// See:
  ///  * [$getAvatarDark_Request] for the request send by this method.
  ///  * [$getAvatarDark_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, AvatarAvatarGetAvatarDarkHeaders>> getAvatarDark({
    required String userId,
    required AvatarGetAvatarDarkSize size,
    AvatarGetAvatarDarkGuestFallback? guestFallback,
  }) async {
    final _request = $getAvatarDark_Request(
      userId: userId,
      size: size,
      guestFallback: guestFallback,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAvatarDark_Serializer();
    return _i1.ResponseConverter<Uint8List, AvatarAvatarGetAvatarDarkHeaders>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, AvatarAvatarGetAvatarHeaders> $getAvatar_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: const FullType(AvatarAvatarGetAvatarHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201},
      );

  /// Get the avatar.
  ///
  /// Returns a `DynamiteRequest` backing the [getAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [size] Size of the avatar.
  ///   * [guestFallback] Fallback to guest avatar if not found. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Avatar returned
  ///   * 201: Avatar returned
  ///   * 404: Avatar not found
  ///   * 500
  ///
  /// See:
  ///  * [getAvatar] for a method executing this request and parsing the response.
  ///  * [$getAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAvatar_Request({
    required String userId,
    required AvatarGetAvatarSize size,
    AvatarGetAvatarGuestFallback? guestFallback,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final __size = _$jsonSerializers.serialize(size, specifiedType: const FullType(AvatarGetAvatarSize));
    _parameters['size'] = __size;

    var __guestFallback =
        _$jsonSerializers.serialize(guestFallback, specifiedType: const FullType(AvatarGetAvatarGuestFallback));
    __guestFallback ??= 0;
    _parameters['guestFallback'] = __guestFallback;

    final _path = _i6.UriTemplate('/index.php/avatar/{userId}/{size}{?guestFallback*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get the avatar.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [size] Size of the avatar.
  ///   * [guestFallback] Fallback to guest avatar if not found. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Avatar returned
  ///   * 201: Avatar returned
  ///   * 404: Avatar not found
  ///   * 500
  ///
  /// See:
  ///  * [$getAvatar_Request] for the request send by this method.
  ///  * [$getAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, AvatarAvatarGetAvatarHeaders>> getAvatar({
    required String userId,
    required AvatarGetAvatarSize size,
    AvatarGetAvatarGuestFallback? guestFallback,
  }) async {
    final _request = $getAvatar_Request(
      userId: userId,
      size: size,
      guestFallback: guestFallback,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAvatar_Serializer();
    return _i1.ResponseConverter<Uint8List, AvatarAvatarGetAvatarHeaders>(_serializer).convert(_response);
  }
}

class $ClientFlowLoginV2Client {
  /// Creates a new `DynamiteClient` for client_flow_login_v2 requests.
  $ClientFlowLoginV2Client(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$poll_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<LoginFlowV2Credentials, void> $poll_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(LoginFlowV2Credentials),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Poll the login flow credentials.
  ///
  /// Returns a `DynamiteRequest` backing the [poll] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Login flow credentials returned
  ///   * 404: Login flow not found or completed
  ///
  /// See:
  ///  * [poll] for a method executing this request and parsing the response.
  ///  * [$poll_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $poll_Request({required ClientFlowLoginV2PollRequestApplicationJson $body}) {
    const _path = '/index.php/login/v2/poll';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ClientFlowLoginV2PollRequestApplicationJson)),
    );
    return _request;
  }

  /// Poll the login flow credentials.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Login flow credentials returned
  ///   * 404: Login flow not found or completed
  ///
  /// See:
  ///  * [$poll_Request] for the request send by this method.
  ///  * [$poll_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<LoginFlowV2Credentials, void>> poll({
    required ClientFlowLoginV2PollRequestApplicationJson $body,
  }) async {
    final _request = $poll_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $poll_Serializer();
    return _i1.ResponseConverter<LoginFlowV2Credentials, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$init_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<LoginFlowV2, void> $init_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(LoginFlowV2),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Init a login flow.
  ///
  /// Returns a `DynamiteRequest` backing the [init] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Login flow init returned
  ///
  /// See:
  ///  * [init] for a method executing this request and parsing the response.
  ///  * [$init_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $init_Request() {
    const _path = '/index.php/login/v2';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Init a login flow.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Login flow init returned
  ///
  /// See:
  ///  * [$init_Request] for the request send by this method.
  ///  * [$init_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<LoginFlowV2, void>> init() async {
    final _request = $init_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $init_Serializer();
    return _i1.ResponseConverter<LoginFlowV2, void>(_serializer).convert(_response);
  }
}

class $CollaborationResourcesClient {
  /// Creates a new `DynamiteClient` for collaboration_resources requests.
  $CollaborationResourcesClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listCollection_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CollaborationResourcesListCollectionResponseApplicationJson, void>
      $listCollection_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(CollaborationResourcesListCollectionResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get a collection.
  ///
  /// Returns a `DynamiteRequest` backing the [listCollection] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [collectionId] ID of the collection.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 404: Collection not found
  ///   * 500
  ///
  /// See:
  ///  * [listCollection] for a method executing this request and parsing the response.
  ///  * [$listCollection_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listCollection_Request({
    required int collectionId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __collectionId = _$jsonSerializers.serialize(collectionId, specifiedType: const FullType(int));
    _parameters['collectionId'] = __collectionId;

    final _path = _i6.UriTemplate('/ocs/v2.php/collaboration/resources/collections/{collectionId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get a collection.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [collectionId] ID of the collection.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 404: Collection not found
  ///   * 500
  ///
  /// See:
  ///  * [$listCollection_Request] for the request send by this method.
  ///  * [$listCollection_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CollaborationResourcesListCollectionResponseApplicationJson, void>> listCollection({
    required int collectionId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listCollection_Request(
      collectionId: collectionId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listCollection_Serializer();
    return _i1.ResponseConverter<CollaborationResourcesListCollectionResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$renameCollection_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CollaborationResourcesRenameCollectionResponseApplicationJson, void>
      $renameCollection_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(CollaborationResourcesRenameCollectionResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Rename a collection.
  ///
  /// Returns a `DynamiteRequest` backing the [renameCollection] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [collectionId] ID of the collection.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 404: Collection not found
  ///   * 500
  ///
  /// See:
  ///  * [renameCollection] for a method executing this request and parsing the response.
  ///  * [$renameCollection_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $renameCollection_Request({
    required int collectionId,
    required CollaborationResourcesRenameCollectionRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __collectionId = _$jsonSerializers.serialize(collectionId, specifiedType: const FullType(int));
    _parameters['collectionId'] = __collectionId;

    final _path = _i6.UriTemplate('/ocs/v2.php/collaboration/resources/collections/{collectionId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(CollaborationResourcesRenameCollectionRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Rename a collection.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [collectionId] ID of the collection.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 404: Collection not found
  ///   * 500
  ///
  /// See:
  ///  * [$renameCollection_Request] for the request send by this method.
  ///  * [$renameCollection_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CollaborationResourcesRenameCollectionResponseApplicationJson, void>> renameCollection({
    required int collectionId,
    required CollaborationResourcesRenameCollectionRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $renameCollection_Request(
      collectionId: collectionId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $renameCollection_Serializer();
    return _i1.ResponseConverter<CollaborationResourcesRenameCollectionResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$addResource_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CollaborationResourcesAddResourceResponseApplicationJson, void> $addResource_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(CollaborationResourcesAddResourceResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Add a resource to a collection.
  ///
  /// Returns a `DynamiteRequest` backing the [addResource] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [collectionId] ID of the collection.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 404: Collection not found or resource inaccessible
  ///   * 500
  ///
  /// See:
  ///  * [addResource] for a method executing this request and parsing the response.
  ///  * [$addResource_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $addResource_Request({
    required int collectionId,
    required CollaborationResourcesAddResourceRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __collectionId = _$jsonSerializers.serialize(collectionId, specifiedType: const FullType(int));
    _parameters['collectionId'] = __collectionId;

    final _path = _i6.UriTemplate('/ocs/v2.php/collaboration/resources/collections/{collectionId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(CollaborationResourcesAddResourceRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Add a resource to a collection.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [collectionId] ID of the collection.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 404: Collection not found or resource inaccessible
  ///   * 500
  ///
  /// See:
  ///  * [$addResource_Request] for the request send by this method.
  ///  * [$addResource_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CollaborationResourcesAddResourceResponseApplicationJson, void>> addResource({
    required int collectionId,
    required CollaborationResourcesAddResourceRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $addResource_Request(
      collectionId: collectionId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $addResource_Serializer();
    return _i1.ResponseConverter<CollaborationResourcesAddResourceResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$removeResource_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CollaborationResourcesRemoveResourceResponseApplicationJson, void>
      $removeResource_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(CollaborationResourcesRemoveResourceResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Remove a resource from a collection.
  ///
  /// Returns a `DynamiteRequest` backing the [removeResource] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [collectionId] ID of the collection.
  ///   * [resourceType] Name of the resource.
  ///   * [resourceId] ID of the resource.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 404: Collection or resource not found
  ///   * 500
  ///
  /// See:
  ///  * [removeResource] for a method executing this request and parsing the response.
  ///  * [$removeResource_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $removeResource_Request({
    required int collectionId,
    required String resourceType,
    required String resourceId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __collectionId = _$jsonSerializers.serialize(collectionId, specifiedType: const FullType(int));
    _parameters['collectionId'] = __collectionId;

    final __resourceType = _$jsonSerializers.serialize(resourceType, specifiedType: const FullType(String));
    _parameters['resourceType'] = __resourceType;

    final __resourceId = _$jsonSerializers.serialize(resourceId, specifiedType: const FullType(String));
    _parameters['resourceId'] = __resourceId;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/collaboration/resources/collections/{collectionId}{?resourceType*,resourceId*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Remove a resource from a collection.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [collectionId] ID of the collection.
  ///   * [resourceType] Name of the resource.
  ///   * [resourceId] ID of the resource.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 404: Collection or resource not found
  ///   * 500
  ///
  /// See:
  ///  * [$removeResource_Request] for the request send by this method.
  ///  * [$removeResource_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CollaborationResourcesRemoveResourceResponseApplicationJson, void>> removeResource({
    required int collectionId,
    required String resourceType,
    required String resourceId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $removeResource_Request(
      collectionId: collectionId,
      resourceType: resourceType,
      resourceId: resourceId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $removeResource_Serializer();
    return _i1.ResponseConverter<CollaborationResourcesRemoveResourceResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$searchCollections_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CollaborationResourcesSearchCollectionsResponseApplicationJson, void>
      $searchCollections_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(CollaborationResourcesSearchCollectionsResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Search for collections.
  ///
  /// Returns a `DynamiteRequest` backing the [searchCollections] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [filter] Filter collections.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collections returned
  ///   * 404: Collection not found
  ///
  /// See:
  ///  * [searchCollections] for a method executing this request and parsing the response.
  ///  * [$searchCollections_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $searchCollections_Request({
    required String filter,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __filter = _$jsonSerializers.serialize(filter, specifiedType: const FullType(String));
    _parameters['filter'] = __filter;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/collaboration/resources/collections/search/{filter}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Search for collections.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [filter] Filter collections.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collections returned
  ///   * 404: Collection not found
  ///
  /// See:
  ///  * [$searchCollections_Request] for the request send by this method.
  ///  * [$searchCollections_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CollaborationResourcesSearchCollectionsResponseApplicationJson, void>> searchCollections({
    required String filter,
    bool? oCSAPIRequest,
  }) async {
    final _request = $searchCollections_Request(
      filter: filter,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $searchCollections_Serializer();
    return _i1.ResponseConverter<CollaborationResourcesSearchCollectionsResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getCollectionsByResource_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CollaborationResourcesGetCollectionsByResourceResponseApplicationJson, void>
      $getCollectionsByResource_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(CollaborationResourcesGetCollectionsByResourceResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get collections by resource.
  ///
  /// Returns a `DynamiteRequest` backing the [getCollectionsByResource] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [resourceType] Type of the resource.
  ///   * [resourceId] ID of the resource.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collections returned
  ///   * 404: Resource not accessible
  ///
  /// See:
  ///  * [getCollectionsByResource] for a method executing this request and parsing the response.
  ///  * [$getCollectionsByResource_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getCollectionsByResource_Request({
    required String resourceType,
    required String resourceId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __resourceType = _$jsonSerializers.serialize(resourceType, specifiedType: const FullType(String));
    _parameters['resourceType'] = __resourceType;

    final __resourceId = _$jsonSerializers.serialize(resourceId, specifiedType: const FullType(String));
    _parameters['resourceId'] = __resourceId;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/collaboration/resources/{resourceType}/{resourceId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get collections by resource.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [resourceType] Type of the resource.
  ///   * [resourceId] ID of the resource.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collections returned
  ///   * 404: Resource not accessible
  ///
  /// See:
  ///  * [$getCollectionsByResource_Request] for the request send by this method.
  ///  * [$getCollectionsByResource_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CollaborationResourcesGetCollectionsByResourceResponseApplicationJson, void>>
      getCollectionsByResource({
    required String resourceType,
    required String resourceId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getCollectionsByResource_Request(
      resourceType: resourceType,
      resourceId: resourceId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getCollectionsByResource_Serializer();
    return _i1.ResponseConverter<CollaborationResourcesGetCollectionsByResourceResponseApplicationJson, void>(
      _serializer,
    ).convert(_response);
  }

  /// Builds a serializer to parse the response of [$createCollectionOnResource_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson, void>
      $createCollectionOnResource_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Create a collection for a resource.
  ///
  /// Returns a `DynamiteRequest` backing the [createCollectionOnResource] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [baseResourceType] Type of the base resource.
  ///   * [baseResourceId] ID of the base resource.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 400: Creating collection is not possible
  ///   * 404: Resource inaccessible
  ///   * 500
  ///
  /// See:
  ///  * [createCollectionOnResource] for a method executing this request and parsing the response.
  ///  * [$createCollectionOnResource_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $createCollectionOnResource_Request({
    required String baseResourceType,
    required String baseResourceId,
    required CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __baseResourceType = _$jsonSerializers.serialize(baseResourceType, specifiedType: const FullType(String));
    _parameters['baseResourceType'] = __baseResourceType;

    final __baseResourceId = _$jsonSerializers.serialize(baseResourceId, specifiedType: const FullType(String));
    _parameters['baseResourceId'] = __baseResourceId;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/collaboration/resources/{baseResourceType}/{baseResourceId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Create a collection for a resource.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [baseResourceType] Type of the base resource.
  ///   * [baseResourceId] ID of the base resource.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Collection returned
  ///   * 400: Creating collection is not possible
  ///   * 404: Resource inaccessible
  ///   * 500
  ///
  /// See:
  ///  * [$createCollectionOnResource_Request] for the request send by this method.
  ///  * [$createCollectionOnResource_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson, void>>
      createCollectionOnResource({
    required String baseResourceType,
    required String baseResourceId,
    required CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $createCollectionOnResource_Request(
      baseResourceType: baseResourceType,
      baseResourceId: baseResourceId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $createCollectionOnResource_Serializer();
    return _i1.ResponseConverter<CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson, void>(
      _serializer,
    ).convert(_response);
  }
}

class $CsrfTokenClient {
  /// Creates a new `DynamiteClient` for csrf_token requests.
  $CsrfTokenClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$index_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<CsrfTokenIndexResponseApplicationJson, void> $index_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(CsrfTokenIndexResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns a new CSRF token.
  ///
  /// Returns a `DynamiteRequest` backing the [index] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: CSRF token returned
  ///   * 403: Strict cookie check failed
  ///
  /// See:
  ///  * [index] for a method executing this request and parsing the response.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $index_Request() {
    const _path = '/index.php/csrftoken';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a new CSRF token.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: CSRF token returned
  ///   * 403: Strict cookie check failed
  ///
  /// See:
  ///  * [$index_Request] for the request send by this method.
  ///  * [$index_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<CsrfTokenIndexResponseApplicationJson, void>> index() async {
    final _request = $index_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $index_Serializer();
    return _i1.ResponseConverter<CsrfTokenIndexResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

/// This controller handles guest avatar requests.
class $GuestAvatarClient {
  /// Creates a new `DynamiteClient` for guest_avatar requests.
  $GuestAvatarClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getAvatar_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, GuestAvatarGuestAvatarGetAvatarHeaders> $getAvatar_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: const FullType(GuestAvatarGuestAvatarGetAvatarHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201},
      );

  /// Returns a guest avatar image response.
  ///
  /// Returns a `DynamiteRequest` backing the [getAvatar] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [guestName] The guest name, e.g. "Albert".
  ///   * [size] The desired avatar size, e.g. 64 for 64x64px.
  ///   * [darkTheme] Return dark avatar. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Custom avatar returned
  ///   * 201: Avatar returned
  ///   * 500
  ///
  /// See:
  ///  * [getAvatar] for a method executing this request and parsing the response.
  ///  * [$getAvatar_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAvatar_Request({
    required String guestName,
    required GuestAvatarGetAvatarSize size,
    GuestAvatarGetAvatarDarkTheme? darkTheme,
  }) {
    final _parameters = <String, Object?>{};
    final __guestName = _$jsonSerializers.serialize(guestName, specifiedType: const FullType(String));
    _parameters['guestName'] = __guestName;

    final __size = _$jsonSerializers.serialize(size, specifiedType: const FullType(GuestAvatarGetAvatarSize));
    _parameters['size'] = __size;

    var __darkTheme =
        _$jsonSerializers.serialize(darkTheme, specifiedType: const FullType(GuestAvatarGetAvatarDarkTheme));
    __darkTheme ??= 0;
    _parameters['darkTheme'] = __darkTheme;

    final _path = _i6.UriTemplate('/index.php/avatar/guest/{guestName}/{size}{?darkTheme*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a guest avatar image response.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [guestName] The guest name, e.g. "Albert".
  ///   * [size] The desired avatar size, e.g. 64 for 64x64px.
  ///   * [darkTheme] Return dark avatar. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Custom avatar returned
  ///   * 201: Avatar returned
  ///   * 500
  ///
  /// See:
  ///  * [$getAvatar_Request] for the request send by this method.
  ///  * [$getAvatar_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, GuestAvatarGuestAvatarGetAvatarHeaders>> getAvatar({
    required String guestName,
    required GuestAvatarGetAvatarSize size,
    GuestAvatarGetAvatarDarkTheme? darkTheme,
  }) async {
    final _request = $getAvatar_Request(
      guestName: guestName,
      size: size,
      darkTheme: darkTheme,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAvatar_Serializer();
    return _i1.ResponseConverter<Uint8List, GuestAvatarGuestAvatarGetAvatarHeaders>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getAvatarDark_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, GuestAvatarGuestAvatarGetAvatarDarkHeaders> $getAvatarDark_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: const FullType(GuestAvatarGuestAvatarGetAvatarDarkHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200, 201},
      );

  /// Returns a dark guest avatar image response.
  ///
  /// Returns a `DynamiteRequest` backing the [getAvatarDark] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [guestName] The guest name, e.g. "Albert".
  ///   * [size] The desired avatar size, e.g. 64 for 64x64px.
  ///
  /// Status codes:
  ///   * 200: Custom avatar returned
  ///   * 201: Avatar returned
  ///   * 500
  ///
  /// See:
  ///  * [getAvatarDark] for a method executing this request and parsing the response.
  ///  * [$getAvatarDark_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAvatarDark_Request({
    required String guestName,
    required GuestAvatarGetAvatarDarkSize size,
  }) {
    final _parameters = <String, Object?>{};
    final __guestName = _$jsonSerializers.serialize(guestName, specifiedType: const FullType(String));
    _parameters['guestName'] = __guestName;

    final __size = _$jsonSerializers.serialize(size, specifiedType: const FullType(GuestAvatarGetAvatarDarkSize));
    _parameters['size'] = __size;

    final _path = _i6.UriTemplate('/index.php/avatar/guest/{guestName}/{size}/dark').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Returns a dark guest avatar image response.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [guestName] The guest name, e.g. "Albert".
  ///   * [size] The desired avatar size, e.g. 64 for 64x64px.
  ///
  /// Status codes:
  ///   * 200: Custom avatar returned
  ///   * 201: Avatar returned
  ///   * 500
  ///
  /// See:
  ///  * [$getAvatarDark_Request] for the request send by this method.
  ///  * [$getAvatarDark_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, GuestAvatarGuestAvatarGetAvatarDarkHeaders>> getAvatarDark({
    required String guestName,
    required GuestAvatarGetAvatarDarkSize size,
  }) async {
    final _request = $getAvatarDark_Request(
      guestName: guestName,
      size: size,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAvatarDark_Serializer();
    return _i1.ResponseConverter<Uint8List, GuestAvatarGuestAvatarGetAvatarDarkHeaders>(_serializer).convert(_response);
  }
}

class $HoverCardClient {
  /// Creates a new `DynamiteClient` for hover_card requests.
  $HoverCardClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getUser_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<HoverCardGetUserResponseApplicationJson, void> $getUser_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(HoverCardGetUserResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the account details for a hovercard.
  ///
  /// Returns a `DynamiteRequest` backing the [getUser] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Account details returned
  ///   * 404: Account not found
  ///
  /// See:
  ///  * [getUser] for a method executing this request and parsing the response.
  ///  * [$getUser_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getUser_Request({
    required String userId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __userId = _$jsonSerializers.serialize(userId, specifiedType: const FullType(String));
    _parameters['userId'] = __userId;

    final _path = _i6.UriTemplate('/ocs/v2.php/hovercard/v1/{userId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the account details for a hovercard.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [userId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Account details returned
  ///   * 404: Account not found
  ///
  /// See:
  ///  * [$getUser_Request] for the request send by this method.
  ///  * [$getUser_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<HoverCardGetUserResponseApplicationJson, void>> getUser({
    required String userId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getUser_Request(
      userId: userId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getUser_Serializer();
    return _i1.ResponseConverter<HoverCardGetUserResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $LoginClient {
  /// Creates a new `DynamiteClient` for login requests.
  $LoginClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$confirmPassword_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<LoginConfirmPasswordResponseApplicationJson, void> $confirmPassword_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(LoginConfirmPasswordResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Confirm the user password.
  ///
  /// Returns a `DynamiteRequest` backing the [confirmPassword] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Password confirmation succeeded
  ///   * 403: Password confirmation failed
  ///
  /// See:
  ///  * [confirmPassword] for a method executing this request and parsing the response.
  ///  * [$confirmPassword_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $confirmPassword_Request({required LoginConfirmPasswordRequestApplicationJson $body}) {
    const _path = '/index.php/login/confirm';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(LoginConfirmPasswordRequestApplicationJson)),
    );
    return _request;
  }

  /// Confirm the user password.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Password confirmation succeeded
  ///   * 403: Password confirmation failed
  ///
  /// See:
  ///  * [$confirmPassword_Request] for the request send by this method.
  ///  * [$confirmPassword_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<LoginConfirmPasswordResponseApplicationJson, void>> confirmPassword({
    required LoginConfirmPasswordRequestApplicationJson $body,
  }) async {
    final _request = $confirmPassword_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $confirmPassword_Serializer();
    return _i1.ResponseConverter<LoginConfirmPasswordResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $NavigationClient {
  /// Creates a new `DynamiteClient` for navigation requests.
  $NavigationClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getAppsNavigation_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<NavigationGetAppsNavigationResponseApplicationJson, void> $getAppsNavigation_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(NavigationGetAppsNavigationResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the apps navigation.
  ///
  /// Returns a `DynamiteRequest` backing the [getAppsNavigation] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [absolute] Rewrite URLs to absolute ones. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Apps navigation returned
  ///   * 304: No apps navigation changed
  ///
  /// See:
  ///  * [getAppsNavigation] for a method executing this request and parsing the response.
  ///  * [$getAppsNavigation_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getAppsNavigation_Request({
    NavigationGetAppsNavigationAbsolute? absolute,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __absolute =
        _$jsonSerializers.serialize(absolute, specifiedType: const FullType(NavigationGetAppsNavigationAbsolute));
    __absolute ??= 0;
    _parameters['absolute'] = __absolute;

    final _path = _i6.UriTemplate('/ocs/v2.php/core/navigation/apps{?absolute*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the apps navigation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [absolute] Rewrite URLs to absolute ones. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Apps navigation returned
  ///   * 304: No apps navigation changed
  ///
  /// See:
  ///  * [$getAppsNavigation_Request] for the request send by this method.
  ///  * [$getAppsNavigation_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<NavigationGetAppsNavigationResponseApplicationJson, void>> getAppsNavigation({
    NavigationGetAppsNavigationAbsolute? absolute,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getAppsNavigation_Request(
      absolute: absolute,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getAppsNavigation_Serializer();
    return _i1.ResponseConverter<NavigationGetAppsNavigationResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getSettingsNavigation_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<NavigationGetSettingsNavigationResponseApplicationJson, void>
      $getSettingsNavigation_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(NavigationGetSettingsNavigationResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Get the settings navigation.
  ///
  /// Returns a `DynamiteRequest` backing the [getSettingsNavigation] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [absolute] Rewrite URLs to absolute ones. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Apps navigation returned
  ///   * 304: No apps navigation changed
  ///
  /// See:
  ///  * [getSettingsNavigation] for a method executing this request and parsing the response.
  ///  * [$getSettingsNavigation_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getSettingsNavigation_Request({
    NavigationGetSettingsNavigationAbsolute? absolute,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __absolute =
        _$jsonSerializers.serialize(absolute, specifiedType: const FullType(NavigationGetSettingsNavigationAbsolute));
    __absolute ??= 0;
    _parameters['absolute'] = __absolute;

    final _path = _i6.UriTemplate('/ocs/v2.php/core/navigation/settings{?absolute*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the settings navigation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [absolute] Rewrite URLs to absolute ones. Defaults to `0`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Apps navigation returned
  ///   * 304: No apps navigation changed
  ///
  /// See:
  ///  * [$getSettingsNavigation_Request] for the request send by this method.
  ///  * [$getSettingsNavigation_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<NavigationGetSettingsNavigationResponseApplicationJson, void>> getSettingsNavigation({
    NavigationGetSettingsNavigationAbsolute? absolute,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getSettingsNavigation_Request(
      absolute: absolute,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getSettingsNavigation_Serializer();
    return _i1.ResponseConverter<NavigationGetSettingsNavigationResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

/// Controller about the endpoint /ocm-provider/.
class $OcmClient {
  /// Creates a new `DynamiteClient` for ocm requests.
  $OcmClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$discovery_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<OcmDiscoveryResponseApplicationJson, OcmOcmDiscoveryHeaders> $discovery_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(OcmDiscoveryResponseApplicationJson),
        headersType: const FullType(OcmOcmDiscoveryHeaders),
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// generate a OCMProvider with local data and send it as DataResponse. This replaces the old PHP file ocm-provider/index.php.
  ///
  /// Returns a `DynamiteRequest` backing the [discovery] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: OCM Provider details returned
  ///   * 500: OCM not supported
  ///
  /// See:
  ///  * [discovery] for a method executing this request and parsing the response.
  ///  * [$discovery_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $discovery_Request() {
    const _path = '/index.php/ocm-provider';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// generate a OCMProvider with local data and send it as DataResponse. This replaces the old PHP file ocm-provider/index.php.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: OCM Provider details returned
  ///   * 500: OCM not supported
  ///
  /// See:
  ///  * [$discovery_Request] for the request send by this method.
  ///  * [$discovery_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<OcmDiscoveryResponseApplicationJson, OcmOcmDiscoveryHeaders>> discovery() async {
    final _request = $discovery_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $discovery_Serializer();
    return _i1.ResponseConverter<OcmDiscoveryResponseApplicationJson, OcmOcmDiscoveryHeaders>(_serializer)
        .convert(_response);
  }
}

class $OcsClient {
  /// Creates a new `DynamiteClient` for ocs requests.
  $OcsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getCapabilities_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<OcsGetCapabilitiesResponseApplicationJson, void> $getCapabilities_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(OcsGetCapabilitiesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the capabilities.
  ///
  /// Returns a `DynamiteRequest` backing the [getCapabilities] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Capabilities returned
  ///
  /// See:
  ///  * [getCapabilities] for a method executing this request and parsing the response.
  ///  * [$getCapabilities_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getCapabilities_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/cloud/capabilities';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the capabilities.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Capabilities returned
  ///
  /// See:
  ///  * [$getCapabilities_Request] for the request send by this method.
  ///  * [$getCapabilities_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<OcsGetCapabilitiesResponseApplicationJson, void>> getCapabilities({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getCapabilities_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getCapabilities_Serializer();
    return _i1.ResponseConverter<OcsGetCapabilitiesResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $PreviewClient {
  /// Creates a new `DynamiteClient` for preview requests.
  $PreviewClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getPreview_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getPreview_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a preview by file path.
  ///
  /// Returns a `DynamiteRequest` backing the [getPreview] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [file] Path of the file. Defaults to `""`.
  ///   * [x] Width of the preview. A width of -1 will use the original image width. Defaults to `32`.
  ///   * [y] Height of the preview. A height of -1 will use the original image height. Defaults to `32`.
  ///   * [a] Preserve the aspect ratio. Defaults to `0`.
  ///   * [forceIcon] Force returning an icon. Defaults to `1`.
  ///   * [mode] How to crop the image. Defaults to `"fill"`.
  ///   * [mimeFallback] Whether to fallback to the mime icon if no preview is available. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 400: Getting preview is not possible
  ///   * 403: Getting preview is not allowed
  ///   * 404: Preview not found
  ///   * 303: Redirect to the mime icon url if mimeFallback is true
  ///
  /// See:
  ///  * [getPreview] for a method executing this request and parsing the response.
  ///  * [$getPreview_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getPreview_Request({
    String? file,
    int? x,
    int? y,
    PreviewGetPreviewA? a,
    PreviewGetPreviewForceIcon? forceIcon,
    PreviewGetPreviewMode? mode,
    PreviewGetPreviewMimeFallback? mimeFallback,
  }) {
    final _parameters = <String, Object?>{};
    var __file = _$jsonSerializers.serialize(file, specifiedType: const FullType(String));
    __file ??= '';
    _parameters['file'] = __file;

    var __x = _$jsonSerializers.serialize(x, specifiedType: const FullType(int));
    __x ??= 32;
    _parameters['x'] = __x;

    var __y = _$jsonSerializers.serialize(y, specifiedType: const FullType(int));
    __y ??= 32;
    _parameters['y'] = __y;

    var __a = _$jsonSerializers.serialize(a, specifiedType: const FullType(PreviewGetPreviewA));
    __a ??= 0;
    _parameters['a'] = __a;

    var __forceIcon = _$jsonSerializers.serialize(forceIcon, specifiedType: const FullType(PreviewGetPreviewForceIcon));
    __forceIcon ??= 1;
    _parameters['forceIcon'] = __forceIcon;

    var __mode = _$jsonSerializers.serialize(mode, specifiedType: const FullType(PreviewGetPreviewMode));
    __mode ??= 'fill';
    _parameters['mode'] = __mode;

    var __mimeFallback =
        _$jsonSerializers.serialize(mimeFallback, specifiedType: const FullType(PreviewGetPreviewMimeFallback));
    __mimeFallback ??= 0;
    _parameters['mimeFallback'] = __mimeFallback;

    final _path = _i6.UriTemplate('/index.php/core/preview.png{?file*,x*,y*,a*,forceIcon*,mode*,mimeFallback*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a preview by file path.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [file] Path of the file. Defaults to `""`.
  ///   * [x] Width of the preview. A width of -1 will use the original image width. Defaults to `32`.
  ///   * [y] Height of the preview. A height of -1 will use the original image height. Defaults to `32`.
  ///   * [a] Preserve the aspect ratio. Defaults to `0`.
  ///   * [forceIcon] Force returning an icon. Defaults to `1`.
  ///   * [mode] How to crop the image. Defaults to `"fill"`.
  ///   * [mimeFallback] Whether to fallback to the mime icon if no preview is available. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 400: Getting preview is not possible
  ///   * 403: Getting preview is not allowed
  ///   * 404: Preview not found
  ///   * 303: Redirect to the mime icon url if mimeFallback is true
  ///
  /// See:
  ///  * [$getPreview_Request] for the request send by this method.
  ///  * [$getPreview_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getPreview({
    String? file,
    int? x,
    int? y,
    PreviewGetPreviewA? a,
    PreviewGetPreviewForceIcon? forceIcon,
    PreviewGetPreviewMode? mode,
    PreviewGetPreviewMimeFallback? mimeFallback,
  }) async {
    final _request = $getPreview_Request(
      file: file,
      x: x,
      y: y,
      a: a,
      forceIcon: forceIcon,
      mode: mode,
      mimeFallback: mimeFallback,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getPreview_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getPreviewByFileId_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getPreviewByFileId_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a preview by file ID.
  ///
  /// Returns a `DynamiteRequest` backing the [getPreviewByFileId] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [fileId] ID of the file. Defaults to `-1`.
  ///   * [x] Width of the preview. A width of -1 will use the original image width. Defaults to `32`.
  ///   * [y] Height of the preview. A height of -1 will use the original image height. Defaults to `32`.
  ///   * [a] Preserve the aspect ratio. Defaults to `0`.
  ///   * [forceIcon] Force returning an icon. Defaults to `1`.
  ///   * [mode] How to crop the image. Defaults to `"fill"`.
  ///   * [mimeFallback] Whether to fallback to the mime icon if no preview is available. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 400: Getting preview is not possible
  ///   * 403: Getting preview is not allowed
  ///   * 404: Preview not found
  ///   * 303: Redirect to the mime icon url if mimeFallback is true
  ///
  /// See:
  ///  * [getPreviewByFileId] for a method executing this request and parsing the response.
  ///  * [$getPreviewByFileId_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getPreviewByFileId_Request({
    int? fileId,
    int? x,
    int? y,
    PreviewGetPreviewByFileIdA? a,
    PreviewGetPreviewByFileIdForceIcon? forceIcon,
    PreviewGetPreviewByFileIdMode? mode,
    PreviewGetPreviewByFileIdMimeFallback? mimeFallback,
  }) {
    final _parameters = <String, Object?>{};
    var __fileId = _$jsonSerializers.serialize(fileId, specifiedType: const FullType(int));
    __fileId ??= -1;
    _parameters['fileId'] = __fileId;

    var __x = _$jsonSerializers.serialize(x, specifiedType: const FullType(int));
    __x ??= 32;
    _parameters['x'] = __x;

    var __y = _$jsonSerializers.serialize(y, specifiedType: const FullType(int));
    __y ??= 32;
    _parameters['y'] = __y;

    var __a = _$jsonSerializers.serialize(a, specifiedType: const FullType(PreviewGetPreviewByFileIdA));
    __a ??= 0;
    _parameters['a'] = __a;

    var __forceIcon =
        _$jsonSerializers.serialize(forceIcon, specifiedType: const FullType(PreviewGetPreviewByFileIdForceIcon));
    __forceIcon ??= 1;
    _parameters['forceIcon'] = __forceIcon;

    var __mode = _$jsonSerializers.serialize(mode, specifiedType: const FullType(PreviewGetPreviewByFileIdMode));
    __mode ??= 'fill';
    _parameters['mode'] = __mode;

    var __mimeFallback =
        _$jsonSerializers.serialize(mimeFallback, specifiedType: const FullType(PreviewGetPreviewByFileIdMimeFallback));
    __mimeFallback ??= 0;
    _parameters['mimeFallback'] = __mimeFallback;

    final _path = _i6.UriTemplate('/index.php/core/preview{?fileId*,x*,y*,a*,forceIcon*,mode*,mimeFallback*}')
        .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a preview by file ID.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [fileId] ID of the file. Defaults to `-1`.
  ///   * [x] Width of the preview. A width of -1 will use the original image width. Defaults to `32`.
  ///   * [y] Height of the preview. A height of -1 will use the original image height. Defaults to `32`.
  ///   * [a] Preserve the aspect ratio. Defaults to `0`.
  ///   * [forceIcon] Force returning an icon. Defaults to `1`.
  ///   * [mode] How to crop the image. Defaults to `"fill"`.
  ///   * [mimeFallback] Whether to fallback to the mime icon if no preview is available. Defaults to `0`.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 400: Getting preview is not possible
  ///   * 403: Getting preview is not allowed
  ///   * 404: Preview not found
  ///   * 303: Redirect to the mime icon url if mimeFallback is true
  ///
  /// See:
  ///  * [$getPreviewByFileId_Request] for the request send by this method.
  ///  * [$getPreviewByFileId_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getPreviewByFileId({
    int? fileId,
    int? x,
    int? y,
    PreviewGetPreviewByFileIdA? a,
    PreviewGetPreviewByFileIdForceIcon? forceIcon,
    PreviewGetPreviewByFileIdMode? mode,
    PreviewGetPreviewByFileIdMimeFallback? mimeFallback,
  }) async {
    final _request = $getPreviewByFileId_Request(
      fileId: fileId,
      x: x,
      y: y,
      a: a,
      forceIcon: forceIcon,
      mode: mode,
      mimeFallback: mimeFallback,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getPreviewByFileId_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }
}

class $ProfileApiClient {
  /// Creates a new `DynamiteClient` for profile_api requests.
  $ProfileApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$setVisibility_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ProfileApiSetVisibilityResponseApplicationJson, void> $setVisibility_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ProfileApiSetVisibilityResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 400, 403, 404},
      );

  /// Update the visibility of a parameter.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a `DynamiteRequest` backing the [setVisibility] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [targetUserId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Visibility updated successfully
  ///   * 400: Updating visibility is not possible
  ///   * 403: Not allowed to edit other users visibility
  ///   * 404: Account not found
  ///
  /// See:
  ///  * [setVisibility] for a method executing this request and parsing the response.
  ///  * [$setVisibility_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setVisibility_Request({
    required String targetUserId,
    required ProfileApiSetVisibilityRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __targetUserId = _$jsonSerializers.serialize(targetUserId, specifiedType: const FullType(String));
    _parameters['targetUserId'] = __targetUserId;

    final _path = _i6.UriTemplate('/ocs/v2.php/profile/{targetUserId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ProfileApiSetVisibilityRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Update the visibility of a parameter.
  ///
  /// This endpoint requires password confirmation.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [targetUserId] ID of the user.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Visibility updated successfully
  ///   * 400: Updating visibility is not possible
  ///   * 403: Not allowed to edit other users visibility
  ///   * 404: Account not found
  ///
  /// See:
  ///  * [$setVisibility_Request] for the request send by this method.
  ///  * [$setVisibility_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ProfileApiSetVisibilityResponseApplicationJson, void>> setVisibility({
    required String targetUserId,
    required ProfileApiSetVisibilityRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setVisibility_Request(
      targetUserId: targetUserId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setVisibility_Serializer();
    return _i1.ResponseConverter<ProfileApiSetVisibilityResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $ReferenceClient {
  /// Creates a new `DynamiteClient` for reference requests.
  $ReferenceClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$preview_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $preview_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a preview for a reference.
  ///
  /// Returns a `DynamiteRequest` backing the [preview] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [referenceId] the reference cache key.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 404: Reference not found
  ///
  /// See:
  ///  * [preview] for a method executing this request and parsing the response.
  ///  * [$preview_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $preview_Request({required String referenceId}) {
    final _parameters = <String, Object?>{};
    final __referenceId = _$jsonSerializers.serialize(referenceId, specifiedType: const FullType(String));
    _parameters['referenceId'] = __referenceId;

    final _path = _i6.UriTemplate('/index.php/core/references/preview/{referenceId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a preview for a reference.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [referenceId] the reference cache key.
  ///
  /// Status codes:
  ///   * 200: Preview returned
  ///   * 404: Reference not found
  ///
  /// See:
  ///  * [$preview_Request] for the request send by this method.
  ///  * [$preview_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> preview({required String referenceId}) async {
    final _request = $preview_Request(
      referenceId: referenceId,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $preview_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }
}

class $ReferenceApiClient {
  /// Creates a new `DynamiteClient` for reference_api requests.
  $ReferenceApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$extract_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReferenceApiExtractResponseApplicationJson, void> $extract_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReferenceApiExtractResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Extract references from a text.
  ///
  /// Returns a `DynamiteRequest` backing the [extract] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: References returned
  ///
  /// See:
  ///  * [extract] for a method executing this request and parsing the response.
  ///  * [$extract_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $extract_Request({
    required ReferenceApiExtractRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/references/extract';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ReferenceApiExtractRequestApplicationJson)),
    );
    return _request;
  }

  /// Extract references from a text.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: References returned
  ///
  /// See:
  ///  * [$extract_Request] for the request send by this method.
  ///  * [$extract_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReferenceApiExtractResponseApplicationJson, void>> extract({
    required ReferenceApiExtractRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $extract_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $extract_Serializer();
    return _i1.ResponseConverter<ReferenceApiExtractResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$extractPublic_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReferenceApiExtractPublicResponseApplicationJson, void> $extractPublic_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReferenceApiExtractPublicResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Extract references from a text.
  ///
  /// Returns a `DynamiteRequest` backing the [extractPublic] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: References returned
  ///
  /// See:
  ///  * [extractPublic] for a method executing this request and parsing the response.
  ///  * [$extractPublic_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $extractPublic_Request({
    required ReferenceApiExtractPublicRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/references/extractPublic';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ReferenceApiExtractPublicRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Extract references from a text.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: References returned
  ///
  /// See:
  ///  * [$extractPublic_Request] for the request send by this method.
  ///  * [$extractPublic_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReferenceApiExtractPublicResponseApplicationJson, void>> extractPublic({
    required ReferenceApiExtractPublicRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $extractPublic_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $extractPublic_Serializer();
    return _i1.ResponseConverter<ReferenceApiExtractPublicResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$resolveOne_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReferenceApiResolveOneResponseApplicationJson, void> $resolveOne_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReferenceApiResolveOneResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Resolve a reference.
  ///
  /// Returns a `DynamiteRequest` backing the [resolveOne] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [reference] Reference to resolve.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reference returned
  ///
  /// See:
  ///  * [resolveOne] for a method executing this request and parsing the response.
  ///  * [$resolveOne_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $resolveOne_Request({
    required String reference,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __reference = _$jsonSerializers.serialize(reference, specifiedType: const FullType(String));
    _parameters['reference'] = __reference;

    final _path = _i6.UriTemplate('/ocs/v2.php/references/resolve{?reference*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Resolve a reference.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [reference] Reference to resolve.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reference returned
  ///
  /// See:
  ///  * [$resolveOne_Request] for the request send by this method.
  ///  * [$resolveOne_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReferenceApiResolveOneResponseApplicationJson, void>> resolveOne({
    required String reference,
    bool? oCSAPIRequest,
  }) async {
    final _request = $resolveOne_Request(
      reference: reference,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $resolveOne_Serializer();
    return _i1.ResponseConverter<ReferenceApiResolveOneResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$resolve_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReferenceApiResolveResponseApplicationJson, void> $resolve_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReferenceApiResolveResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Resolve multiple references.
  ///
  /// Returns a `DynamiteRequest` backing the [resolve] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: References returned
  ///
  /// See:
  ///  * [resolve] for a method executing this request and parsing the response.
  ///  * [$resolve_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $resolve_Request({
    required ReferenceApiResolveRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/references/resolve';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(ReferenceApiResolveRequestApplicationJson)),
    );
    return _request;
  }

  /// Resolve multiple references.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: References returned
  ///
  /// See:
  ///  * [$resolve_Request] for the request send by this method.
  ///  * [$resolve_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReferenceApiResolveResponseApplicationJson, void>> resolve({
    required ReferenceApiResolveRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $resolve_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $resolve_Serializer();
    return _i1.ResponseConverter<ReferenceApiResolveResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$resolveOnePublic_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReferenceApiResolveOnePublicResponseApplicationJson, void> $resolveOnePublic_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReferenceApiResolveOnePublicResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Resolve from a public page.
  ///
  /// Returns a `DynamiteRequest` backing the [resolveOnePublic] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [reference] Reference to resolve.
  ///   * [sharingToken] Token of the public share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reference returned
  ///
  /// See:
  ///  * [resolveOnePublic] for a method executing this request and parsing the response.
  ///  * [$resolveOnePublic_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $resolveOnePublic_Request({
    required String reference,
    required String sharingToken,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __reference = _$jsonSerializers.serialize(reference, specifiedType: const FullType(String));
    _parameters['reference'] = __reference;

    final __sharingToken = _$jsonSerializers.serialize(sharingToken, specifiedType: const FullType(String));
    _parameters['sharingToken'] = __sharingToken;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/references/resolvePublic{?reference*,sharingToken*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Resolve from a public page.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [reference] Reference to resolve.
  ///   * [sharingToken] Token of the public share.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Reference returned
  ///
  /// See:
  ///  * [$resolveOnePublic_Request] for the request send by this method.
  ///  * [$resolveOnePublic_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReferenceApiResolveOnePublicResponseApplicationJson, void>> resolveOnePublic({
    required String reference,
    required String sharingToken,
    bool? oCSAPIRequest,
  }) async {
    final _request = $resolveOnePublic_Request(
      reference: reference,
      sharingToken: sharingToken,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $resolveOnePublic_Serializer();
    return _i1.ResponseConverter<ReferenceApiResolveOnePublicResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$resolvePublic_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReferenceApiResolvePublicResponseApplicationJson, void> $resolvePublic_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReferenceApiResolvePublicResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Resolve multiple references from a public page.
  ///
  /// Returns a `DynamiteRequest` backing the [resolvePublic] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: References returned
  ///
  /// See:
  ///  * [resolvePublic] for a method executing this request and parsing the response.
  ///  * [$resolvePublic_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $resolvePublic_Request({
    required ReferenceApiResolvePublicRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/references/resolvePublic';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(ReferenceApiResolvePublicRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Resolve multiple references from a public page.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: References returned
  ///
  /// See:
  ///  * [$resolvePublic_Request] for the request send by this method.
  ///  * [$resolvePublic_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReferenceApiResolvePublicResponseApplicationJson, void>> resolvePublic({
    required ReferenceApiResolvePublicRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $resolvePublic_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $resolvePublic_Serializer();
    return _i1.ResponseConverter<ReferenceApiResolvePublicResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getProvidersInfo_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReferenceApiGetProvidersInfoResponseApplicationJson, void> $getProvidersInfo_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReferenceApiGetProvidersInfoResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the providers.
  ///
  /// Returns a `DynamiteRequest` backing the [getProvidersInfo] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Providers returned
  ///
  /// See:
  ///  * [getProvidersInfo] for a method executing this request and parsing the response.
  ///  * [$getProvidersInfo_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getProvidersInfo_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/references/providers';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the providers.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Providers returned
  ///
  /// See:
  ///  * [$getProvidersInfo_Request] for the request send by this method.
  ///  * [$getProvidersInfo_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReferenceApiGetProvidersInfoResponseApplicationJson, void>> getProvidersInfo({
    bool? oCSAPIRequest,
  }) async {
    final _request = $getProvidersInfo_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getProvidersInfo_Serializer();
    return _i1.ResponseConverter<ReferenceApiGetProvidersInfoResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$touchProvider_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<ReferenceApiTouchProviderResponseApplicationJson, void> $touchProvider_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(ReferenceApiTouchProviderResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Touch a provider.
  ///
  /// Returns a `DynamiteRequest` backing the [touchProvider] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [providerId] ID of the provider.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Provider touched
  ///
  /// See:
  ///  * [touchProvider] for a method executing this request and parsing the response.
  ///  * [$touchProvider_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $touchProvider_Request({
    required String providerId,
    bool? oCSAPIRequest,
    ReferenceApiTouchProviderRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __providerId = _$jsonSerializers.serialize(providerId, specifiedType: const FullType(String));
    _parameters['providerId'] = __providerId;

    final _path = _i6.UriTemplate('/ocs/v2.php/references/provider/{providerId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(ReferenceApiTouchProviderRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              ReferenceApiTouchProviderRequestApplicationJson(),
              specifiedType: const FullType(ReferenceApiTouchProviderRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Touch a provider.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [providerId] ID of the provider.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Provider touched
  ///
  /// See:
  ///  * [$touchProvider_Request] for the request send by this method.
  ///  * [$touchProvider_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<ReferenceApiTouchProviderResponseApplicationJson, void>> touchProvider({
    required String providerId,
    bool? oCSAPIRequest,
    ReferenceApiTouchProviderRequestApplicationJson? $body,
  }) async {
    final _request = $touchProvider_Request(
      providerId: providerId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $touchProvider_Serializer();
    return _i1.ResponseConverter<ReferenceApiTouchProviderResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $TaskProcessingApiClient {
  /// Creates a new `DynamiteClient` for task_processing_api requests.
  $TaskProcessingApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$taskTypes_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiTaskTypesResponseApplicationJson, void> $taskTypes_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiTaskTypesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns all available TaskProcessing task types.
  ///
  /// Returns a `DynamiteRequest` backing the [taskTypes] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task types returned
  ///
  /// See:
  ///  * [taskTypes] for a method executing this request and parsing the response.
  ///  * [$taskTypes_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $taskTypes_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/taskprocessing/tasktypes';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Returns all available TaskProcessing task types.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task types returned
  ///
  /// See:
  ///  * [$taskTypes_Request] for the request send by this method.
  ///  * [$taskTypes_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiTaskTypesResponseApplicationJson, void>> taskTypes({
    bool? oCSAPIRequest,
  }) async {
    final _request = $taskTypes_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $taskTypes_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiTaskTypesResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$schedule_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiScheduleResponseApplicationJson, void> $schedule_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiScheduleResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Schedules a task.
  ///
  /// Returns a `DynamiteRequest` backing the [schedule] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task scheduled successfully
  ///   * 500
  ///   * 400: Scheduling task is not possible
  ///   * 412: Scheduling task is not possible
  ///   * 401: Cannot schedule task because it references files in its input that the user doesn't have access to
  ///
  /// See:
  ///  * [schedule] for a method executing this request and parsing the response.
  ///  * [$schedule_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $schedule_Request({
    required TaskProcessingApiScheduleRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/taskprocessing/schedule';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(TaskProcessingApiScheduleRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Schedules a task.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task scheduled successfully
  ///   * 500
  ///   * 400: Scheduling task is not possible
  ///   * 412: Scheduling task is not possible
  ///   * 401: Cannot schedule task because it references files in its input that the user doesn't have access to
  ///
  /// See:
  ///  * [$schedule_Request] for the request send by this method.
  ///  * [$schedule_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiScheduleResponseApplicationJson, void>> schedule({
    required TaskProcessingApiScheduleRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $schedule_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $schedule_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiScheduleResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getTask_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiGetTaskResponseApplicationJson, void> $getTask_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiGetTaskResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Gets a task including status and result.
  ///
  /// Tasks are removed 1 week after receiving their last update.
  ///
  /// Returns a `DynamiteRequest` backing the [getTask] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [getTask] for a method executing this request and parsing the response.
  ///  * [$getTask_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getTask_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/task/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Gets a task including status and result.
  ///
  /// Tasks are removed 1 week after receiving their last update.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [$getTask_Request] for the request send by this method.
  ///  * [$getTask_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiGetTaskResponseApplicationJson, void>> getTask({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getTask_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getTask_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiGetTaskResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteTask_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiDeleteTaskResponseApplicationJson, void> $deleteTask_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiDeleteTaskResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Deletes a task.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteTask] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task deleted
  ///   * 500
  ///
  /// See:
  ///  * [deleteTask] for a method executing this request and parsing the response.
  ///  * [$deleteTask_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteTask_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/task/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Deletes a task.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task deleted
  ///   * 500
  ///
  /// See:
  ///  * [$deleteTask_Request] for the request send by this method.
  ///  * [$deleteTask_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiDeleteTaskResponseApplicationJson, void>> deleteTask({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteTask_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteTask_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiDeleteTaskResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$listTasksByApp_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiListTasksByAppResponseApplicationJson, void> $listTasksByApp_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiListTasksByAppResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns tasks for the current user filtered by the appId and optional customId.
  ///
  /// Returns a `DynamiteRequest` backing the [listTasksByApp] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [customId] An arbitrary identifier for the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tasks returned
  ///   * 500
  ///
  /// See:
  ///  * [listTasksByApp] for a method executing this request and parsing the response.
  ///  * [$listTasksByApp_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listTasksByApp_Request({
    required String appId,
    String? customId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __appId = _$jsonSerializers.serialize(appId, specifiedType: const FullType(String));
    _parameters['appId'] = __appId;

    final __customId = _$jsonSerializers.serialize(customId, specifiedType: const FullType(String));
    _parameters['customId'] = __customId;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks/app/{appId}{?customId*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Returns tasks for the current user filtered by the appId and optional customId.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [customId] An arbitrary identifier for the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tasks returned
  ///   * 500
  ///
  /// See:
  ///  * [$listTasksByApp_Request] for the request send by this method.
  ///  * [$listTasksByApp_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiListTasksByAppResponseApplicationJson, void>> listTasksByApp({
    required String appId,
    String? customId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listTasksByApp_Request(
      appId: appId,
      customId: customId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listTasksByApp_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiListTasksByAppResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$listTasks_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiListTasksResponseApplicationJson, void> $listTasks_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiListTasksResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns tasks for the current user filtered by the optional taskType and optional customId.
  ///
  /// Returns a `DynamiteRequest` backing the [listTasks] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskType] The task type to filter by.
  ///   * [customId] An arbitrary identifier for the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tasks returned
  ///   * 500
  ///
  /// See:
  ///  * [listTasks] for a method executing this request and parsing the response.
  ///  * [$listTasks_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listTasks_Request({
    String? taskType,
    String? customId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __taskType = _$jsonSerializers.serialize(taskType, specifiedType: const FullType(String));
    _parameters['taskType'] = __taskType;

    final __customId = _$jsonSerializers.serialize(customId, specifiedType: const FullType(String));
    _parameters['customId'] = __customId;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks{?taskType*,customId*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Returns tasks for the current user filtered by the optional taskType and optional customId.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskType] The task type to filter by.
  ///   * [customId] An arbitrary identifier for the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Tasks returned
  ///   * 500
  ///
  /// See:
  ///  * [$listTasks_Request] for the request send by this method.
  ///  * [$listTasks_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiListTasksResponseApplicationJson, void>> listTasks({
    String? taskType,
    String? customId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listTasks_Request(
      taskType: taskType,
      customId: customId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listTasks_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiListTasksResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getFileContents_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getFileContents_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns the contents of a file referenced in a task.
  ///
  /// Returns a `DynamiteRequest` backing the [getFileContents] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [fileId] The file id of the file to retrieve.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: File content returned
  ///   * 500
  ///   * 404: Task or file not found
  ///
  /// See:
  ///  * [getFileContents] for a method executing this request and parsing the response.
  ///  * [$getFileContents_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getFileContents_Request({
    required int taskId,
    required int fileId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __taskId = _$jsonSerializers.serialize(taskId, specifiedType: const FullType(int));
    _parameters['taskId'] = __taskId;

    final __fileId = _$jsonSerializers.serialize(fileId, specifiedType: const FullType(int));
    _parameters['fileId'] = __fileId;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks/{taskId}/file/{fileId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Returns the contents of a file referenced in a task.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [fileId] The file id of the file to retrieve.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: File content returned
  ///   * 500
  ///   * 404: Task or file not found
  ///
  /// See:
  ///  * [$getFileContents_Request] for the request send by this method.
  ///  * [$getFileContents_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getFileContents({
    required int taskId,
    required int fileId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getFileContents_Request(
      taskId: taskId,
      fileId: fileId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getFileContents_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$cancelTask_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiCancelTaskResponseApplicationJson, void> $cancelTask_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiCancelTaskResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Cancels a task.
  ///
  /// Returns a `DynamiteRequest` backing the [cancelTask] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task canceled successfully
  ///   * 500
  ///   * 404: Task not found
  ///
  /// See:
  ///  * [cancelTask] for a method executing this request and parsing the response.
  ///  * [$cancelTask_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $cancelTask_Request({
    required int taskId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __taskId = _$jsonSerializers.serialize(taskId, specifiedType: const FullType(int));
    _parameters['taskId'] = __taskId;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks/{taskId}/cancel').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Cancels a task.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task canceled successfully
  ///   * 500
  ///   * 404: Task not found
  ///
  /// See:
  ///  * [$cancelTask_Request] for the request send by this method.
  ///  * [$cancelTask_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiCancelTaskResponseApplicationJson, void>> cancelTask({
    required int taskId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $cancelTask_Request(
      taskId: taskId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $cancelTask_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiCancelTaskResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getFileContentsExApp_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getFileContentsExApp_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Returns the contents of a file referenced in a task(ExApp route version).
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getFileContentsExApp] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [fileId] The file id of the file to retrieve.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: File content returned
  ///   * 500
  ///   * 404: Task or file not found
  ///
  /// See:
  ///  * [getFileContentsExApp] for a method executing this request and parsing the response.
  ///  * [$getFileContentsExApp_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getFileContentsExApp_Request({
    required int taskId,
    required int fileId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __taskId = _$jsonSerializers.serialize(taskId, specifiedType: const FullType(int));
    _parameters['taskId'] = __taskId;

    final __fileId = _$jsonSerializers.serialize(fileId, specifiedType: const FullType(int));
    _parameters['fileId'] = __fileId;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks_provider/{taskId}/file/{fileId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Returns the contents of a file referenced in a task(ExApp route version).
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [fileId] The file id of the file to retrieve.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: File content returned
  ///   * 500
  ///   * 404: Task or file not found
  ///
  /// See:
  ///  * [$getFileContentsExApp_Request] for the request send by this method.
  ///  * [$getFileContentsExApp_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getFileContentsExApp({
    required int taskId,
    required int fileId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getFileContentsExApp_Request(
      taskId: taskId,
      fileId: fileId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getFileContentsExApp_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setFileContentsExApp_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiSetFileContentsExAppResponseApplicationJson, void>
      $setFileContentsExApp_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(TaskProcessingApiSetFileContentsExAppResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {201},
          );

  /// Upload a file so it can be referenced in a task result (ExApp route version).
  ///
  /// Use field 'file' for the file upload.
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [setFileContentsExApp] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: File created
  ///   * 400: File upload failed or no file was uploaded
  ///   * 500
  ///   * 404: Task not found
  ///
  /// See:
  ///  * [setFileContentsExApp] for a method executing this request and parsing the response.
  ///  * [$setFileContentsExApp_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setFileContentsExApp_Request({
    required int taskId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __taskId = _$jsonSerializers.serialize(taskId, specifiedType: const FullType(int));
    _parameters['taskId'] = __taskId;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks_provider/{taskId}/file').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Upload a file so it can be referenced in a task result (ExApp route version).
  ///
  /// Use field 'file' for the file upload.
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 201: File created
  ///   * 400: File upload failed or no file was uploaded
  ///   * 500
  ///   * 404: Task not found
  ///
  /// See:
  ///  * [$setFileContentsExApp_Request] for the request send by this method.
  ///  * [$setFileContentsExApp_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiSetFileContentsExAppResponseApplicationJson, void>>
      setFileContentsExApp({
    required int taskId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setFileContentsExApp_Request(
      taskId: taskId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setFileContentsExApp_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiSetFileContentsExAppResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setProgress_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiSetProgressResponseApplicationJson, void> $setProgress_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiSetProgressResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Sets the task progress.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [setProgress] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Progress updated successfully
  ///   * 500
  ///   * 404: Task not found
  ///
  /// See:
  ///  * [setProgress] for a method executing this request and parsing the response.
  ///  * [$setProgress_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setProgress_Request({
    required int taskId,
    required TaskProcessingApiSetProgressRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __taskId = _$jsonSerializers.serialize(taskId, specifiedType: const FullType(int));
    _parameters['taskId'] = __taskId;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks_provider/{taskId}/progress').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(TaskProcessingApiSetProgressRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Sets the task progress.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Progress updated successfully
  ///   * 500
  ///   * 404: Task not found
  ///
  /// See:
  ///  * [$setProgress_Request] for the request send by this method.
  ///  * [$setProgress_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiSetProgressResponseApplicationJson, void>> setProgress({
    required int taskId,
    required TaskProcessingApiSetProgressRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $setProgress_Request(
      taskId: taskId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setProgress_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiSetProgressResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$setResult_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiSetResultResponseApplicationJson, void> $setResult_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TaskProcessingApiSetResultResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Sets the task result.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [setResult] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Result updated successfully
  ///   * 500
  ///   * 404: Task not found
  ///
  /// See:
  ///  * [setResult] for a method executing this request and parsing the response.
  ///  * [$setResult_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setResult_Request({
    required int taskId,
    bool? oCSAPIRequest,
    TaskProcessingApiSetResultRequestApplicationJson? $body,
  }) {
    final _parameters = <String, Object?>{};
    final __taskId = _$jsonSerializers.serialize(taskId, specifiedType: const FullType(int));
    _parameters['taskId'] = __taskId;

    final _path = _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks_provider/{taskId}/result').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = $body != null
        ? json.encode(
            _$jsonSerializers.serialize(
              $body,
              specifiedType: const FullType(TaskProcessingApiSetResultRequestApplicationJson),
            ),
          )
        : json.encode(
            _$jsonSerializers.serialize(
              TaskProcessingApiSetResultRequestApplicationJson(),
              specifiedType: const FullType(TaskProcessingApiSetResultRequestApplicationJson),
            ),
          );
    return _request;
  }

  /// Sets the task result.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [taskId] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Result updated successfully
  ///   * 500
  ///   * 404: Task not found
  ///
  /// See:
  ///  * [$setResult_Request] for the request send by this method.
  ///  * [$setResult_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiSetResultResponseApplicationJson, void>> setResult({
    required int taskId,
    bool? oCSAPIRequest,
    TaskProcessingApiSetResultRequestApplicationJson? $body,
  }) async {
    final _request = $setResult_Request(
      taskId: taskId,
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setResult_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiSetResultResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getNextScheduledTask_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson, void>
      $getNextScheduledTask_Serializer() => _i1.DynamiteSerializer(
            bodyType: const FullType(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson),
            headersType: null,
            serializers: _$jsonSerializers,
            validStatuses: const {200},
          );

  /// Returns the next scheduled task for the taskTypeId.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a `DynamiteRequest` backing the [getNextScheduledTask] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [providerIds] The ids of the providers.
  ///   * [taskTypeIds] The ids of the task types.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 204: No task found
  ///   * 500
  ///
  /// See:
  ///  * [getNextScheduledTask] for a method executing this request and parsing the response.
  ///  * [$getNextScheduledTask_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getNextScheduledTask_Request({
    required BuiltList<String> providerIds,
    required BuiltList<String> taskTypeIds,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __providerIds =
        _$jsonSerializers.serialize(providerIds, specifiedType: const FullType(BuiltList, [FullType(String)]));
    _parameters['providerIds%5B%5D'] = __providerIds;

    final __taskTypeIds =
        _$jsonSerializers.serialize(taskTypeIds, specifiedType: const FullType(BuiltList, [FullType(String)]));
    _parameters['taskTypeIds%5B%5D'] = __taskTypeIds;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/taskprocessing/tasks_provider/next{?providerIds%5B%5D*,taskTypeIds%5B%5D*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Returns the next scheduled task for the taskTypeId.
  ///
  /// This endpoint requires admin access.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [providerIds] The ids of the providers.
  ///   * [taskTypeIds] The ids of the task types.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 204: No task found
  ///   * 500
  ///
  /// See:
  ///  * [$getNextScheduledTask_Request] for the request send by this method.
  ///  * [$getNextScheduledTask_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson, void>>
      getNextScheduledTask({
    required BuiltList<String> providerIds,
    required BuiltList<String> taskTypeIds,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getNextScheduledTask_Request(
      providerIds: providerIds,
      taskTypeIds: taskTypeIds,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getNextScheduledTask_Serializer();
    return _i1.ResponseConverter<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $TeamsApiClient {
  /// Creates a new `DynamiteClient` for teams_api requests.
  $TeamsApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$resolveOne_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TeamsApiResolveOneResponseApplicationJson, void> $resolveOne_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TeamsApiResolveOneResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all resources of a team.
  ///
  /// Returns a `DynamiteRequest` backing the [resolveOne] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [teamId] Unique id of the team.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Resources returned
  ///
  /// See:
  ///  * [resolveOne] for a method executing this request and parsing the response.
  ///  * [$resolveOne_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $resolveOne_Request({
    required String teamId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __teamId = _$jsonSerializers.serialize(teamId, specifiedType: const FullType(String));
    _parameters['teamId'] = __teamId;

    final _path = _i6.UriTemplate('/ocs/v2.php/teams/{teamId}/resources').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get all resources of a team.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [teamId] Unique id of the team.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Resources returned
  ///
  /// See:
  ///  * [$resolveOne_Request] for the request send by this method.
  ///  * [$resolveOne_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TeamsApiResolveOneResponseApplicationJson, void>> resolveOne({
    required String teamId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $resolveOne_Request(
      teamId: teamId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $resolveOne_Serializer();
    return _i1.ResponseConverter<TeamsApiResolveOneResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$listTeams_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TeamsApiListTeamsResponseApplicationJson, void> $listTeams_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TeamsApiListTeamsResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all teams of a resource.
  ///
  /// Returns a `DynamiteRequest` backing the [listTeams] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [providerId] Identifier of the provider (e.g. deck, talk, collectives).
  ///   * [resourceId] Unique id of the resource to list teams for (e.g. deck board id).
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Teams returned
  ///
  /// See:
  ///  * [listTeams] for a method executing this request and parsing the response.
  ///  * [$listTeams_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listTeams_Request({
    required String providerId,
    required String resourceId,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __providerId = _$jsonSerializers.serialize(providerId, specifiedType: const FullType(String));
    _parameters['providerId'] = __providerId;

    final __resourceId = _$jsonSerializers.serialize(resourceId, specifiedType: const FullType(String));
    _parameters['resourceId'] = __resourceId;

    final _path = _i6.UriTemplate('/ocs/v2.php/teams/resources/{providerId}/{resourceId}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get all teams of a resource.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [providerId] Identifier of the provider (e.g. deck, talk, collectives).
  ///   * [resourceId] Unique id of the resource to list teams for (e.g. deck board id).
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Teams returned
  ///
  /// See:
  ///  * [$listTeams_Request] for the request send by this method.
  ///  * [$listTeams_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TeamsApiListTeamsResponseApplicationJson, void>> listTeams({
    required String providerId,
    required String resourceId,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listTeams_Request(
      providerId: providerId,
      resourceId: resourceId,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listTeams_Serializer();
    return _i1.ResponseConverter<TeamsApiListTeamsResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $TextProcessingApiClient {
  /// Creates a new `DynamiteClient` for text_processing_api requests.
  $TextProcessingApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$taskTypes_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextProcessingApiTaskTypesResponseApplicationJson, void> $taskTypes_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextProcessingApiTaskTypesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint returns all available LanguageModel task types.
  ///
  /// Returns a `DynamiteRequest` backing the [taskTypes] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task types returned
  ///
  /// See:
  ///  * [taskTypes] for a method executing this request and parsing the response.
  ///  * [$taskTypes_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $taskTypes_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/textprocessing/tasktypes';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// This endpoint returns all available LanguageModel task types.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task types returned
  ///
  /// See:
  ///  * [$taskTypes_Request] for the request send by this method.
  ///  * [$taskTypes_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextProcessingApiTaskTypesResponseApplicationJson, void>> taskTypes({
    bool? oCSAPIRequest,
  }) async {
    final _request = $taskTypes_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $taskTypes_Serializer();
    return _i1.ResponseConverter<TextProcessingApiTaskTypesResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$schedule_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextProcessingApiScheduleResponseApplicationJson, void> $schedule_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextProcessingApiScheduleResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint allows scheduling a language model task.
  ///
  /// Returns a `DynamiteRequest` backing the [schedule] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task scheduled successfully
  ///   * 500
  ///   * 400: Scheduling task is not possible
  ///   * 412: Scheduling task is not possible
  ///
  /// See:
  ///  * [schedule] for a method executing this request and parsing the response.
  ///  * [$schedule_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $schedule_Request({
    required TextProcessingApiScheduleRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/textprocessing/schedule';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(TextProcessingApiScheduleRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// This endpoint allows scheduling a language model task.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task scheduled successfully
  ///   * 500
  ///   * 400: Scheduling task is not possible
  ///   * 412: Scheduling task is not possible
  ///
  /// See:
  ///  * [$schedule_Request] for the request send by this method.
  ///  * [$schedule_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextProcessingApiScheduleResponseApplicationJson, void>> schedule({
    required TextProcessingApiScheduleRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $schedule_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $schedule_Serializer();
    return _i1.ResponseConverter<TextProcessingApiScheduleResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$getTask_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextProcessingApiGetTaskResponseApplicationJson, void> $getTask_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextProcessingApiGetTaskResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint allows checking the status and results of a task. Tasks are removed 1 week after receiving their last update.
  ///
  /// Returns a `DynamiteRequest` backing the [getTask] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [getTask] for a method executing this request and parsing the response.
  ///  * [$getTask_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getTask_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/textprocessing/task/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// This endpoint allows checking the status and results of a task. Tasks are removed 1 week after receiving their last update.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [$getTask_Request] for the request send by this method.
  ///  * [$getTask_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextProcessingApiGetTaskResponseApplicationJson, void>> getTask({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getTask_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getTask_Serializer();
    return _i1.ResponseConverter<TextProcessingApiGetTaskResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteTask_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextProcessingApiDeleteTaskResponseApplicationJson, void> $deleteTask_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextProcessingApiDeleteTaskResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint allows to delete a scheduled task for a user.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteTask] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [deleteTask] for a method executing this request and parsing the response.
  ///  * [$deleteTask_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteTask_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/textprocessing/task/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// This endpoint allows to delete a scheduled task for a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [$deleteTask_Request] for the request send by this method.
  ///  * [$deleteTask_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextProcessingApiDeleteTaskResponseApplicationJson, void>> deleteTask({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteTask_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteTask_Serializer();
    return _i1.ResponseConverter<TextProcessingApiDeleteTaskResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$listTasksByApp_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextProcessingApiListTasksByAppResponseApplicationJson, void> $listTasksByApp_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextProcessingApiListTasksByAppResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint returns a list of tasks of a user that are related with a specific appId and optionally with an identifier.
  ///
  /// Returns a `DynamiteRequest` backing the [listTasksByApp] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [identifier] An arbitrary identifier for the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task list returned
  ///   * 500
  ///
  /// See:
  ///  * [listTasksByApp] for a method executing this request and parsing the response.
  ///  * [$listTasksByApp_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listTasksByApp_Request({
    required String appId,
    String? identifier,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __appId = _$jsonSerializers.serialize(appId, specifiedType: const FullType(String));
    _parameters['appId'] = __appId;

    final __identifier = _$jsonSerializers.serialize(identifier, specifiedType: const FullType(String));
    _parameters['identifier'] = __identifier;

    final _path = _i6.UriTemplate('/ocs/v2.php/textprocessing/tasks/app/{appId}{?identifier*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// This endpoint returns a list of tasks of a user that are related with a specific appId and optionally with an identifier.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [identifier] An arbitrary identifier for the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task list returned
  ///   * 500
  ///
  /// See:
  ///  * [$listTasksByApp_Request] for the request send by this method.
  ///  * [$listTasksByApp_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextProcessingApiListTasksByAppResponseApplicationJson, void>> listTasksByApp({
    required String appId,
    String? identifier,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listTasksByApp_Request(
      appId: appId,
      identifier: identifier,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listTasksByApp_Serializer();
    return _i1.ResponseConverter<TextProcessingApiListTasksByAppResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $TextToImageApiClient {
  /// Creates a new `DynamiteClient` for text_to_image_api requests.
  $TextToImageApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$isAvailable_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextToImageApiIsAvailableResponseApplicationJson, void> $isAvailable_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextToImageApiIsAvailableResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Check whether this feature is available.
  ///
  /// Returns a `DynamiteRequest` backing the [isAvailable] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Returns availability status
  ///
  /// See:
  ///  * [isAvailable] for a method executing this request and parsing the response.
  ///  * [$isAvailable_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $isAvailable_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/text2image/is_available';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Check whether this feature is available.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Returns availability status
  ///
  /// See:
  ///  * [$isAvailable_Request] for the request send by this method.
  ///  * [$isAvailable_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextToImageApiIsAvailableResponseApplicationJson, void>> isAvailable({
    bool? oCSAPIRequest,
  }) async {
    final _request = $isAvailable_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $isAvailable_Serializer();
    return _i1.ResponseConverter<TextToImageApiIsAvailableResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$schedule_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextToImageApiScheduleResponseApplicationJson, void> $schedule_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextToImageApiScheduleResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint allows scheduling a text to image task.
  ///
  /// Returns a `DynamiteRequest` backing the [schedule] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task scheduled successfully
  ///   * 412: Scheduling task is not possible
  ///   * 500
  ///
  /// See:
  ///  * [schedule] for a method executing this request and parsing the response.
  ///  * [$schedule_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $schedule_Request({
    required TextToImageApiScheduleRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/text2image/schedule';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(TextToImageApiScheduleRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// This endpoint allows scheduling a text to image task.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task scheduled successfully
  ///   * 412: Scheduling task is not possible
  ///   * 500
  ///
  /// See:
  ///  * [$schedule_Request] for the request send by this method.
  ///  * [$schedule_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextToImageApiScheduleResponseApplicationJson, void>> schedule({
    required TextToImageApiScheduleRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $schedule_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $schedule_Serializer();
    return _i1.ResponseConverter<TextToImageApiScheduleResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getTask_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextToImageApiGetTaskResponseApplicationJson, void> $getTask_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextToImageApiGetTaskResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint allows checking the status and results of a task. Tasks are removed 1 week after receiving their last update.
  ///
  /// Returns a `DynamiteRequest` backing the [getTask] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [getTask] for a method executing this request and parsing the response.
  ///  * [$getTask_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getTask_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/text2image/task/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// This endpoint allows checking the status and results of a task. Tasks are removed 1 week after receiving their last update.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [$getTask_Request] for the request send by this method.
  ///  * [$getTask_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextToImageApiGetTaskResponseApplicationJson, void>> getTask({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getTask_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getTask_Serializer();
    return _i1.ResponseConverter<TextToImageApiGetTaskResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteTask_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextToImageApiDeleteTaskResponseApplicationJson, void> $deleteTask_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextToImageApiDeleteTaskResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint allows to delete a scheduled task for a user.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteTask] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [deleteTask] for a method executing this request and parsing the response.
  ///  * [$deleteTask_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteTask_Request({
    required int id,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final _path = _i6.UriTemplate('/ocs/v2.php/text2image/task/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// This endpoint allows to delete a scheduled task for a user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task returned
  ///   * 404: Task not found
  ///   * 500
  ///
  /// See:
  ///  * [$deleteTask_Request] for the request send by this method.
  ///  * [$deleteTask_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextToImageApiDeleteTaskResponseApplicationJson, void>> deleteTask({
    required int id,
    bool? oCSAPIRequest,
  }) async {
    final _request = $deleteTask_Request(
      id: id,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteTask_Serializer();
    return _i1.ResponseConverter<TextToImageApiDeleteTaskResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getImage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getImage_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint allows downloading the resulting image of a task.
  ///
  /// Returns a `DynamiteRequest` backing the [getImage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [index] The index of the image to retrieve.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Image returned
  ///   * 404: Task or image not found
  ///   * 500
  ///
  /// See:
  ///  * [getImage] for a method executing this request and parsing the response.
  ///  * [$getImage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getImage_Request({
    required int id,
    required int index,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(int));
    _parameters['id'] = __id;

    final __index = _$jsonSerializers.serialize(index, specifiedType: const FullType(int));
    _parameters['index'] = __index;

    final _path = _i6.UriTemplate('/ocs/v2.php/text2image/task/{id}/image/{index}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = '*/*';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// This endpoint allows downloading the resulting image of a task.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the task.
  ///   * [index] The index of the image to retrieve.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Image returned
  ///   * 404: Task or image not found
  ///   * 500
  ///
  /// See:
  ///  * [$getImage_Request] for the request send by this method.
  ///  * [$getImage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getImage({
    required int id,
    required int index,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getImage_Request(
      id: id,
      index: index,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getImage_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$listTasksByApp_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TextToImageApiListTasksByAppResponseApplicationJson, void> $listTasksByApp_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TextToImageApiListTasksByAppResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// This endpoint returns a list of tasks of a user that are related with a specific appId and optionally with an identifier.
  ///
  /// Returns a `DynamiteRequest` backing the [listTasksByApp] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [identifier] An arbitrary identifier for the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task list returned
  ///   * 500
  ///
  /// See:
  ///  * [listTasksByApp] for a method executing this request and parsing the response.
  ///  * [$listTasksByApp_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listTasksByApp_Request({
    required String appId,
    String? identifier,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __appId = _$jsonSerializers.serialize(appId, specifiedType: const FullType(String));
    _parameters['appId'] = __appId;

    final __identifier = _$jsonSerializers.serialize(identifier, specifiedType: const FullType(String));
    _parameters['identifier'] = __identifier;

    final _path = _i6.UriTemplate('/ocs/v2.php/text2image/tasks/app/{appId}{?identifier*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// This endpoint returns a list of tasks of a user that are related with a specific appId and optionally with an identifier.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [appId] ID of the app.
  ///   * [identifier] An arbitrary identifier for the task.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Task list returned
  ///   * 500
  ///
  /// See:
  ///  * [$listTasksByApp_Request] for the request send by this method.
  ///  * [$listTasksByApp_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TextToImageApiListTasksByAppResponseApplicationJson, void>> listTasksByApp({
    required String appId,
    String? identifier,
    bool? oCSAPIRequest,
  }) async {
    final _request = $listTasksByApp_Request(
      appId: appId,
      identifier: identifier,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listTasksByApp_Serializer();
    return _i1.ResponseConverter<TextToImageApiListTasksByAppResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }
}

class $TranslationApiClient {
  /// Creates a new `DynamiteClient` for translation_api requests.
  $TranslationApiClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$languages_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TranslationApiLanguagesResponseApplicationJson, void> $languages_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TranslationApiLanguagesResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the list of supported languages.
  ///
  /// Returns a `DynamiteRequest` backing the [languages] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Supported languages returned
  ///
  /// See:
  ///  * [languages] for a method executing this request and parsing the response.
  ///  * [$languages_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $languages_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/translation/languages';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the list of supported languages.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Supported languages returned
  ///
  /// See:
  ///  * [$languages_Request] for the request send by this method.
  ///  * [$languages_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TranslationApiLanguagesResponseApplicationJson, void>> languages({
    bool? oCSAPIRequest,
  }) async {
    final _request = $languages_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $languages_Serializer();
    return _i1.ResponseConverter<TranslationApiLanguagesResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$translate_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<TranslationApiTranslateResponseApplicationJson, void> $translate_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(TranslationApiTranslateResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Translate a text.
  ///
  /// Returns a `DynamiteRequest` backing the [translate] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Translated text returned
  ///   * 400: Language not detected or unable to translate
  ///   * 412: Translating is not possible
  ///   * 500
  ///
  /// See:
  ///  * [translate] for a method executing this request and parsing the response.
  ///  * [$translate_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $translate_Request({
    required TranslationApiTranslateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/translation/translate';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize(
        $body,
        specifiedType: const FullType(TranslationApiTranslateRequestApplicationJson),
      ),
    );
    return _request;
  }

  /// Translate a text.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Translated text returned
  ///   * 400: Language not detected or unable to translate
  ///   * 412: Translating is not possible
  ///   * 500
  ///
  /// See:
  ///  * [$translate_Request] for the request send by this method.
  ///  * [$translate_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<TranslationApiTranslateResponseApplicationJson, void>> translate({
    required TranslationApiTranslateRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $translate_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $translate_Serializer();
    return _i1.ResponseConverter<TranslationApiTranslateResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $UnifiedSearchClient {
  /// Creates a new `DynamiteClient` for unified_search requests.
  $UnifiedSearchClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$getProviders_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UnifiedSearchGetProvidersResponseApplicationJson, void> $getProviders_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UnifiedSearchGetProvidersResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the providers for unified search.
  ///
  /// Returns a `DynamiteRequest` backing the [getProviders] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [from] the url the user is currently at. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Providers returned
  ///
  /// See:
  ///  * [getProviders] for a method executing this request and parsing the response.
  ///  * [$getProviders_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getProviders_Request({
    String? from,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    var __from = _$jsonSerializers.serialize(from, specifiedType: const FullType(String));
    __from ??= '';
    _parameters['from'] = __from;

    final _path = _i6.UriTemplate('/ocs/v2.php/search/providers{?from*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the providers for unified search.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [from] the url the user is currently at. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Providers returned
  ///
  /// See:
  ///  * [$getProviders_Request] for the request send by this method.
  ///  * [$getProviders_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UnifiedSearchGetProvidersResponseApplicationJson, void>> getProviders({
    String? from,
    bool? oCSAPIRequest,
  }) async {
    final _request = $getProviders_Request(
      from: from,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getProviders_Serializer();
    return _i1.ResponseConverter<UnifiedSearchGetProvidersResponseApplicationJson, void>(_serializer)
        .convert(_response);
  }

  /// Builds a serializer to parse the response of [$search_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<UnifiedSearchSearchResponseApplicationJson, void> $search_Serializer() =>
      _i1.DynamiteSerializer(
        bodyType: const FullType(UnifiedSearchSearchResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Launch a search for a specific search provider.
  ///
  /// Additional filters are available for each provider. Send a request to /providers endpoint to list providers with their available filters.
  ///
  /// Returns a `DynamiteRequest` backing the [search] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [providerId] ID of the provider.
  ///   * [term] Term to search. Defaults to `""`.
  ///   * [sortOrder] Order of entries.
  ///   * [limit] Maximum amount of entries, limited to 25.
  ///   * [cursor] Offset for searching.
  ///   * [from] The current user URL. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Search entries returned
  ///   * 400: Searching is not possible
  ///
  /// See:
  ///  * [search] for a method executing this request and parsing the response.
  ///  * [$search_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $search_Request({
    required String providerId,
    String? term,
    int? sortOrder,
    int? limit,
    UnifiedSearchSearchCursor? cursor,
    String? from,
    bool? oCSAPIRequest,
  }) {
    final _parameters = <String, Object?>{};
    final __providerId = _$jsonSerializers.serialize(providerId, specifiedType: const FullType(String));
    _parameters['providerId'] = __providerId;

    var __term = _$jsonSerializers.serialize(term, specifiedType: const FullType(String));
    __term ??= '';
    _parameters['term'] = __term;

    final __sortOrder = _$jsonSerializers.serialize(sortOrder, specifiedType: const FullType(int));
    _parameters['sortOrder'] = __sortOrder;

    final __limit = _$jsonSerializers.serialize(limit, specifiedType: const FullType(int));
    _parameters['limit'] = __limit;

    final __cursor = _$jsonSerializers.serialize(cursor, specifiedType: const FullType(UnifiedSearchSearchCursor));
    _parameters['cursor'] = __cursor;

    var __from = _$jsonSerializers.serialize(from, specifiedType: const FullType(String));
    __from ??= '';
    _parameters['from'] = __from;

    final _path =
        _i6.UriTemplate('/ocs/v2.php/search/providers/{providerId}/search{?term*,sortOrder*,limit*,cursor*,from*}')
            .expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Launch a search for a specific search provider.
  ///
  /// Additional filters are available for each provider. Send a request to /providers endpoint to list providers with their available filters.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [providerId] ID of the provider.
  ///   * [term] Term to search. Defaults to `""`.
  ///   * [sortOrder] Order of entries.
  ///   * [limit] Maximum amount of entries, limited to 25.
  ///   * [cursor] Offset for searching.
  ///   * [from] The current user URL. Defaults to `""`.
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Search entries returned
  ///   * 400: Searching is not possible
  ///
  /// See:
  ///  * [$search_Request] for the request send by this method.
  ///  * [$search_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<UnifiedSearchSearchResponseApplicationJson, void>> search({
    required String providerId,
    String? term,
    int? sortOrder,
    int? limit,
    UnifiedSearchSearchCursor? cursor,
    String? from,
    bool? oCSAPIRequest,
  }) async {
    final _request = $search_Request(
      providerId: providerId,
      term: term,
      sortOrder: sortOrder,
      limit: limit,
      cursor: cursor,
      from: from,
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $search_Serializer();
    return _i1.ResponseConverter<UnifiedSearchSearchResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $WhatsNewClient {
  /// Creates a new `DynamiteClient` for whats_new requests.
  $WhatsNewClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$$get_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WhatsNewGetResponseApplicationJson, void> $$get_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(WhatsNewGetResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the changes.
  ///
  /// Returns a `DynamiteRequest` backing the [$get] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Changes returned
  ///   * 204: No changes
  ///
  /// See:
  ///  * [$get] for a method executing this request and parsing the response.
  ///  * [$$get_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$get_Request({bool? oCSAPIRequest}) {
    const _path = '/ocs/v2.php/core/whatsnew';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    return _request;
  }

  /// Get the changes.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Changes returned
  ///   * 204: No changes
  ///
  /// See:
  ///  * [$$get_Request] for the request send by this method.
  ///  * [$$get_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WhatsNewGetResponseApplicationJson, void>> $get({bool? oCSAPIRequest}) async {
    final _request = $$get_Request(
      oCSAPIRequest: oCSAPIRequest,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$get_Serializer();
    return _i1.ResponseConverter<WhatsNewGetResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$dismiss_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WhatsNewDismissResponseApplicationJson, void> $dismiss_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(WhatsNewDismissResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Dismiss the changes.
  ///
  /// Returns a `DynamiteRequest` backing the [dismiss] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Changes dismissed
  ///   * 500
  ///
  /// See:
  ///  * [dismiss] for a method executing this request and parsing the response.
  ///  * [$dismiss_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $dismiss_Request({
    required WhatsNewDismissRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) {
    const _path = '/ocs/v2.php/core/whatsnew';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for bearer_auth or basic_auth');
    }

// coverage:ignore-end
    var __oCSAPIRequest = _$jsonSerializers.serialize(oCSAPIRequest, specifiedType: const FullType(bool));
    __oCSAPIRequest ??= true;
    _request.headers['OCS-APIRequest'] = const _i5.HeaderEncoder().convert(__oCSAPIRequest);

    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(WhatsNewDismissRequestApplicationJson)),
    );
    return _request;
  }

  /// Dismiss the changes.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [oCSAPIRequest] Required to be true for the API request to pass. Defaults to `true`.
  ///
  /// Status codes:
  ///   * 200: Changes dismissed
  ///   * 500
  ///
  /// See:
  ///  * [$dismiss_Request] for the request send by this method.
  ///  * [$dismiss_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WhatsNewDismissResponseApplicationJson, void>> dismiss({
    required WhatsNewDismissRequestApplicationJson $body,
    bool? oCSAPIRequest,
  }) async {
    final _request = $dismiss_Request(
      oCSAPIRequest: oCSAPIRequest,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $dismiss_Serializer();
    return _i1.ResponseConverter<WhatsNewDismissResponseApplicationJson, void>(_serializer).convert(_response);
  }
}

class $WipeClient {
  /// Creates a new `DynamiteClient` for wipe requests.
  $WipeClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$checkWipe_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<WipeCheckWipeResponseApplicationJson, void> $checkWipe_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(WipeCheckWipeResponseApplicationJson),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Check if the device should be wiped.
  ///
  /// Returns a `DynamiteRequest` backing the [checkWipe] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Device should be wiped
  ///   * 404: Device should not be wiped
  ///
  /// See:
  ///  * [checkWipe] for a method executing this request and parsing the response.
  ///  * [$checkWipe_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $checkWipe_Request({required WipeCheckWipeRequestApplicationJson $body}) {
    const _path = '/index.php/core/wipe/check';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(WipeCheckWipeRequestApplicationJson)));
    return _request;
  }

  /// Check if the device should be wiped.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Device should be wiped
  ///   * 404: Device should not be wiped
  ///
  /// See:
  ///  * [$checkWipe_Request] for the request send by this method.
  ///  * [$checkWipe_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<WipeCheckWipeResponseApplicationJson, void>> checkWipe({
    required WipeCheckWipeRequestApplicationJson $body,
  }) async {
    final _request = $checkWipe_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $checkWipe_Serializer();
    return _i1.ResponseConverter<WipeCheckWipeResponseApplicationJson, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$wipeDone_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<JsonObject, void> $wipeDone_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(JsonObject),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200, 404},
      );

  /// Finish the wipe.
  ///
  /// Returns a `DynamiteRequest` backing the [wipeDone] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Wipe finished successfully
  ///   * 404: Device should not be wiped
  ///
  /// See:
  ///  * [wipeDone] for a method executing this request and parsing the response.
  ///  * [$wipeDone_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $wipeDone_Request({required WipeWipeDoneRequestApplicationJson $body}) {
    const _path = '/index.php/core/wipe/success';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBearerAuthentication() || _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json
        .encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(WipeWipeDoneRequestApplicationJson)));
    return _request;
  }

  /// Finish the wipe.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Wipe finished successfully
  ///   * 404: Device should not be wiped
  ///
  /// See:
  ///  * [$wipeDone_Request] for the request send by this method.
  ///  * [$wipeDone_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<JsonObject, void>> wipeDone({required WipeWipeDoneRequestApplicationJson $body}) async {
    final _request = $wipeDone_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $wipeDone_Serializer();
    return _i1.ResponseConverter<JsonObject, void>(_serializer).convert(_response);
  }
}

@BuiltValue(instantiable: false)
sealed class $StatusInterface {
  bool get installed;
  bool get maintenance;
  bool get needsDbUpgrade;
  String get version;
  String get versionstring;
  String get edition;
  String get productname;
  bool get extendedSupport;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$StatusInterfaceBuilder].
  $StatusInterface rebuild(void Function($StatusInterfaceBuilder) updates);

  /// Converts the instance to a builder [$StatusInterfaceBuilder].
  $StatusInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($StatusInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($StatusInterfaceBuilder b) {}
}

abstract class Status implements $StatusInterface, Built<Status, StatusBuilder> {
  /// Creates a new Status object using the builder pattern.
  factory Status([void Function(StatusBuilder)? b]) = _$Status;

  // coverage:ignore-start
  const Status._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Status.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Status.
  static Serializer<Status> get serializer => _$statusSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(StatusBuilder b) {
    $StatusInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(StatusBuilder b) {
    $StatusInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OCSMetaInterface {
  String get status;
  int get statuscode;
  String? get message;
  String? get totalitems;
  String? get itemsperpage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterface rebuild(void Function($OCSMetaInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OCSMetaInterfaceBuilder].
  $OCSMetaInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OCSMetaInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OCSMetaInterfaceBuilder b) {}
}

abstract class OCSMeta implements $OCSMetaInterface, Built<OCSMeta, OCSMetaBuilder> {
  /// Creates a new OCSMeta object using the builder pattern.
  factory OCSMeta([void Function(OCSMetaBuilder)? b]) = _$OCSMeta;

  // coverage:ignore-start
  const OCSMeta._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OCSMeta.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OCSMeta.
  static Serializer<OCSMeta> get serializer => _$oCSMetaSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OCSMetaBuilder b) {
    $OCSMetaInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OCSMetaBuilder b) {
    $OCSMetaInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterface {
  String get apppassword;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data
    implements
        $AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterface,
        Built<AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data,
            AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data([
    void Function(AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data.
  static Serializer<AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data> get serializer =>
      _$appPasswordGetAppPasswordResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataBuilder b) {
    $AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataBuilder b) {
    $AppPasswordGetAppPasswordResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordGetAppPasswordResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  AppPasswordGetAppPasswordResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordGetAppPasswordResponseApplicationJson_OcsInterfaceBuilder].
  $AppPasswordGetAppPasswordResponseApplicationJson_OcsInterface rebuild(
    void Function($AppPasswordGetAppPasswordResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordGetAppPasswordResponseApplicationJson_OcsInterfaceBuilder].
  $AppPasswordGetAppPasswordResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordGetAppPasswordResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordGetAppPasswordResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppPasswordGetAppPasswordResponseApplicationJson_Ocs
    implements
        $AppPasswordGetAppPasswordResponseApplicationJson_OcsInterface,
        Built<AppPasswordGetAppPasswordResponseApplicationJson_Ocs,
            AppPasswordGetAppPasswordResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppPasswordGetAppPasswordResponseApplicationJson_Ocs object using the builder pattern.
  factory AppPasswordGetAppPasswordResponseApplicationJson_Ocs([
    void Function(AppPasswordGetAppPasswordResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AppPasswordGetAppPasswordResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppPasswordGetAppPasswordResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordGetAppPasswordResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordGetAppPasswordResponseApplicationJson_Ocs.
  static Serializer<AppPasswordGetAppPasswordResponseApplicationJson_Ocs> get serializer =>
      _$appPasswordGetAppPasswordResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordGetAppPasswordResponseApplicationJson_OcsBuilder b) {
    $AppPasswordGetAppPasswordResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordGetAppPasswordResponseApplicationJson_OcsBuilder b) {
    $AppPasswordGetAppPasswordResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordGetAppPasswordResponseApplicationJsonInterface {
  AppPasswordGetAppPasswordResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordGetAppPasswordResponseApplicationJsonInterfaceBuilder].
  $AppPasswordGetAppPasswordResponseApplicationJsonInterface rebuild(
    void Function($AppPasswordGetAppPasswordResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordGetAppPasswordResponseApplicationJsonInterfaceBuilder].
  $AppPasswordGetAppPasswordResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordGetAppPasswordResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordGetAppPasswordResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppPasswordGetAppPasswordResponseApplicationJson
    implements
        $AppPasswordGetAppPasswordResponseApplicationJsonInterface,
        Built<AppPasswordGetAppPasswordResponseApplicationJson,
            AppPasswordGetAppPasswordResponseApplicationJsonBuilder> {
  /// Creates a new AppPasswordGetAppPasswordResponseApplicationJson object using the builder pattern.
  factory AppPasswordGetAppPasswordResponseApplicationJson([
    void Function(AppPasswordGetAppPasswordResponseApplicationJsonBuilder)? b,
  ]) = _$AppPasswordGetAppPasswordResponseApplicationJson;

  // coverage:ignore-start
  const AppPasswordGetAppPasswordResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordGetAppPasswordResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordGetAppPasswordResponseApplicationJson.
  static Serializer<AppPasswordGetAppPasswordResponseApplicationJson> get serializer =>
      _$appPasswordGetAppPasswordResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordGetAppPasswordResponseApplicationJsonBuilder b) {
    $AppPasswordGetAppPasswordResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordGetAppPasswordResponseApplicationJsonBuilder b) {
    $AppPasswordGetAppPasswordResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterfaceBuilder].
  $AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterface rebuild(
    void Function($AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterfaceBuilder].
  $AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs
    implements
        $AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterface,
        Built<AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs,
            AppPasswordDeleteAppPasswordResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs object using the builder pattern.
  factory AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs([
    void Function(AppPasswordDeleteAppPasswordResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs.
  static Serializer<AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs> get serializer =>
      _$appPasswordDeleteAppPasswordResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordDeleteAppPasswordResponseApplicationJson_OcsBuilder b) {
    $AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordDeleteAppPasswordResponseApplicationJson_OcsBuilder b) {
    $AppPasswordDeleteAppPasswordResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordDeleteAppPasswordResponseApplicationJsonInterface {
  AppPasswordDeleteAppPasswordResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordDeleteAppPasswordResponseApplicationJsonInterfaceBuilder].
  $AppPasswordDeleteAppPasswordResponseApplicationJsonInterface rebuild(
    void Function($AppPasswordDeleteAppPasswordResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordDeleteAppPasswordResponseApplicationJsonInterfaceBuilder].
  $AppPasswordDeleteAppPasswordResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordDeleteAppPasswordResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordDeleteAppPasswordResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppPasswordDeleteAppPasswordResponseApplicationJson
    implements
        $AppPasswordDeleteAppPasswordResponseApplicationJsonInterface,
        Built<AppPasswordDeleteAppPasswordResponseApplicationJson,
            AppPasswordDeleteAppPasswordResponseApplicationJsonBuilder> {
  /// Creates a new AppPasswordDeleteAppPasswordResponseApplicationJson object using the builder pattern.
  factory AppPasswordDeleteAppPasswordResponseApplicationJson([
    void Function(AppPasswordDeleteAppPasswordResponseApplicationJsonBuilder)? b,
  ]) = _$AppPasswordDeleteAppPasswordResponseApplicationJson;

  // coverage:ignore-start
  const AppPasswordDeleteAppPasswordResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordDeleteAppPasswordResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordDeleteAppPasswordResponseApplicationJson.
  static Serializer<AppPasswordDeleteAppPasswordResponseApplicationJson> get serializer =>
      _$appPasswordDeleteAppPasswordResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordDeleteAppPasswordResponseApplicationJsonBuilder b) {
    $AppPasswordDeleteAppPasswordResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordDeleteAppPasswordResponseApplicationJsonBuilder b) {
    $AppPasswordDeleteAppPasswordResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterface {
  String get apppassword;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data
    implements
        $AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterface,
        Built<AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data,
            AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data([
    void Function(AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data.
  static Serializer<AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data> get serializer =>
      _$appPasswordRotateAppPasswordResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataBuilder b) {
    $AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataBuilder b) {
    $AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  AppPasswordRotateAppPasswordResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterfaceBuilder].
  $AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterface rebuild(
    void Function($AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterfaceBuilder].
  $AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppPasswordRotateAppPasswordResponseApplicationJson_Ocs
    implements
        $AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterface,
        Built<AppPasswordRotateAppPasswordResponseApplicationJson_Ocs,
            AppPasswordRotateAppPasswordResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppPasswordRotateAppPasswordResponseApplicationJson_Ocs object using the builder pattern.
  factory AppPasswordRotateAppPasswordResponseApplicationJson_Ocs([
    void Function(AppPasswordRotateAppPasswordResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AppPasswordRotateAppPasswordResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppPasswordRotateAppPasswordResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordRotateAppPasswordResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordRotateAppPasswordResponseApplicationJson_Ocs.
  static Serializer<AppPasswordRotateAppPasswordResponseApplicationJson_Ocs> get serializer =>
      _$appPasswordRotateAppPasswordResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordRotateAppPasswordResponseApplicationJson_OcsBuilder b) {
    $AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordRotateAppPasswordResponseApplicationJson_OcsBuilder b) {
    $AppPasswordRotateAppPasswordResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordRotateAppPasswordResponseApplicationJsonInterface {
  AppPasswordRotateAppPasswordResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordRotateAppPasswordResponseApplicationJsonInterfaceBuilder].
  $AppPasswordRotateAppPasswordResponseApplicationJsonInterface rebuild(
    void Function($AppPasswordRotateAppPasswordResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordRotateAppPasswordResponseApplicationJsonInterfaceBuilder].
  $AppPasswordRotateAppPasswordResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordRotateAppPasswordResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordRotateAppPasswordResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppPasswordRotateAppPasswordResponseApplicationJson
    implements
        $AppPasswordRotateAppPasswordResponseApplicationJsonInterface,
        Built<AppPasswordRotateAppPasswordResponseApplicationJson,
            AppPasswordRotateAppPasswordResponseApplicationJsonBuilder> {
  /// Creates a new AppPasswordRotateAppPasswordResponseApplicationJson object using the builder pattern.
  factory AppPasswordRotateAppPasswordResponseApplicationJson([
    void Function(AppPasswordRotateAppPasswordResponseApplicationJsonBuilder)? b,
  ]) = _$AppPasswordRotateAppPasswordResponseApplicationJson;

  // coverage:ignore-start
  const AppPasswordRotateAppPasswordResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordRotateAppPasswordResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordRotateAppPasswordResponseApplicationJson.
  static Serializer<AppPasswordRotateAppPasswordResponseApplicationJson> get serializer =>
      _$appPasswordRotateAppPasswordResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordRotateAppPasswordResponseApplicationJsonBuilder b) {
    $AppPasswordRotateAppPasswordResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordRotateAppPasswordResponseApplicationJsonBuilder b) {
    $AppPasswordRotateAppPasswordResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordConfirmUserPasswordRequestApplicationJsonInterface {
  /// The password of the user.
  String get password;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordConfirmUserPasswordRequestApplicationJsonInterfaceBuilder].
  $AppPasswordConfirmUserPasswordRequestApplicationJsonInterface rebuild(
    void Function($AppPasswordConfirmUserPasswordRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordConfirmUserPasswordRequestApplicationJsonInterfaceBuilder].
  $AppPasswordConfirmUserPasswordRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordConfirmUserPasswordRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordConfirmUserPasswordRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class AppPasswordConfirmUserPasswordRequestApplicationJson
    implements
        $AppPasswordConfirmUserPasswordRequestApplicationJsonInterface,
        Built<AppPasswordConfirmUserPasswordRequestApplicationJson,
            AppPasswordConfirmUserPasswordRequestApplicationJsonBuilder> {
  /// Creates a new AppPasswordConfirmUserPasswordRequestApplicationJson object using the builder pattern.
  factory AppPasswordConfirmUserPasswordRequestApplicationJson([
    void Function(AppPasswordConfirmUserPasswordRequestApplicationJsonBuilder)? b,
  ]) = _$AppPasswordConfirmUserPasswordRequestApplicationJson;

  // coverage:ignore-start
  const AppPasswordConfirmUserPasswordRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordConfirmUserPasswordRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordConfirmUserPasswordRequestApplicationJson.
  static Serializer<AppPasswordConfirmUserPasswordRequestApplicationJson> get serializer =>
      _$appPasswordConfirmUserPasswordRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordConfirmUserPasswordRequestApplicationJsonBuilder b) {
    $AppPasswordConfirmUserPasswordRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordConfirmUserPasswordRequestApplicationJsonBuilder b) {
    $AppPasswordConfirmUserPasswordRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterface {
  int get lastLogin;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data
    implements
        $AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterface,
        Built<AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data,
            AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data([
    void Function(AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data.
  static Serializer<AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data> get serializer =>
      _$appPasswordConfirmUserPasswordResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataBuilder b) {
    $AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataBuilder b) {
    $AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterfaceBuilder].
  $AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterface rebuild(
    void Function($AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterfaceBuilder].
  $AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs
    implements
        $AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterface,
        Built<AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs,
            AppPasswordConfirmUserPasswordResponseApplicationJson_OcsBuilder> {
  /// Creates a new AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs object using the builder pattern.
  factory AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs([
    void Function(AppPasswordConfirmUserPasswordResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs.
  static Serializer<AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs> get serializer =>
      _$appPasswordConfirmUserPasswordResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordConfirmUserPasswordResponseApplicationJson_OcsBuilder b) {
    $AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordConfirmUserPasswordResponseApplicationJson_OcsBuilder b) {
    $AppPasswordConfirmUserPasswordResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AppPasswordConfirmUserPasswordResponseApplicationJsonInterface {
  AppPasswordConfirmUserPasswordResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AppPasswordConfirmUserPasswordResponseApplicationJsonInterfaceBuilder].
  $AppPasswordConfirmUserPasswordResponseApplicationJsonInterface rebuild(
    void Function($AppPasswordConfirmUserPasswordResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AppPasswordConfirmUserPasswordResponseApplicationJsonInterfaceBuilder].
  $AppPasswordConfirmUserPasswordResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AppPasswordConfirmUserPasswordResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AppPasswordConfirmUserPasswordResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AppPasswordConfirmUserPasswordResponseApplicationJson
    implements
        $AppPasswordConfirmUserPasswordResponseApplicationJsonInterface,
        Built<AppPasswordConfirmUserPasswordResponseApplicationJson,
            AppPasswordConfirmUserPasswordResponseApplicationJsonBuilder> {
  /// Creates a new AppPasswordConfirmUserPasswordResponseApplicationJson object using the builder pattern.
  factory AppPasswordConfirmUserPasswordResponseApplicationJson([
    void Function(AppPasswordConfirmUserPasswordResponseApplicationJsonBuilder)? b,
  ]) = _$AppPasswordConfirmUserPasswordResponseApplicationJson;

  // coverage:ignore-start
  const AppPasswordConfirmUserPasswordResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AppPasswordConfirmUserPasswordResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AppPasswordConfirmUserPasswordResponseApplicationJson.
  static Serializer<AppPasswordConfirmUserPasswordResponseApplicationJson> get serializer =>
      _$appPasswordConfirmUserPasswordResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AppPasswordConfirmUserPasswordResponseApplicationJsonBuilder b) {
    $AppPasswordConfirmUserPasswordResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AppPasswordConfirmUserPasswordResponseApplicationJsonBuilder b) {
    $AppPasswordConfirmUserPasswordResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AutocompleteResult_Status0Interface {
  String get status;
  String? get message;
  String? get icon;
  int? get clearAt;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AutocompleteResult_Status0InterfaceBuilder].
  $AutocompleteResult_Status0Interface rebuild(void Function($AutocompleteResult_Status0InterfaceBuilder) updates);

  /// Converts the instance to a builder [$AutocompleteResult_Status0InterfaceBuilder].
  $AutocompleteResult_Status0InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AutocompleteResult_Status0InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AutocompleteResult_Status0InterfaceBuilder b) {}
}

abstract class AutocompleteResult_Status0
    implements
        $AutocompleteResult_Status0Interface,
        Built<AutocompleteResult_Status0, AutocompleteResult_Status0Builder> {
  /// Creates a new AutocompleteResult_Status0 object using the builder pattern.
  factory AutocompleteResult_Status0([void Function(AutocompleteResult_Status0Builder)? b]) =
      _$AutocompleteResult_Status0;

  // coverage:ignore-start
  const AutocompleteResult_Status0._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AutocompleteResult_Status0.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AutocompleteResult_Status0.
  static Serializer<AutocompleteResult_Status0> get serializer => _$autocompleteResultStatus0Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AutocompleteResult_Status0Builder b) {
    $AutocompleteResult_Status0Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AutocompleteResult_Status0Builder b) {
    $AutocompleteResult_Status0Interface._validate(b);
  }
}

typedef AutocompleteResult_Status = ({AutocompleteResult_Status0? autocompleteResultStatus0, String? string});

@BuiltValue(instantiable: false)
sealed class $AutocompleteResultInterface {
  String get id;
  String get label;
  String get icon;
  String get source;
  AutocompleteResult_Status get status;
  String get subline;
  String get shareWithDisplayNameUnique;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AutocompleteResultInterfaceBuilder].
  $AutocompleteResultInterface rebuild(void Function($AutocompleteResultInterfaceBuilder) updates);

  /// Converts the instance to a builder [$AutocompleteResultInterfaceBuilder].
  $AutocompleteResultInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AutocompleteResultInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AutocompleteResultInterfaceBuilder b) {
    b.status?.validateOneOf();
  }
}

abstract class AutocompleteResult
    implements $AutocompleteResultInterface, Built<AutocompleteResult, AutocompleteResultBuilder> {
  /// Creates a new AutocompleteResult object using the builder pattern.
  factory AutocompleteResult([void Function(AutocompleteResultBuilder)? b]) = _$AutocompleteResult;

  // coverage:ignore-start
  const AutocompleteResult._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AutocompleteResult.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AutocompleteResult.
  static Serializer<AutocompleteResult> get serializer => _$autocompleteResultSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AutocompleteResultBuilder b) {
    $AutocompleteResultInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AutocompleteResultBuilder b) {
    $AutocompleteResultInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AutoCompleteGetResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<AutocompleteResult> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AutoCompleteGetResponseApplicationJson_OcsInterfaceBuilder].
  $AutoCompleteGetResponseApplicationJson_OcsInterface rebuild(
    void Function($AutoCompleteGetResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AutoCompleteGetResponseApplicationJson_OcsInterfaceBuilder].
  $AutoCompleteGetResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AutoCompleteGetResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AutoCompleteGetResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class AutoCompleteGetResponseApplicationJson_Ocs
    implements
        $AutoCompleteGetResponseApplicationJson_OcsInterface,
        Built<AutoCompleteGetResponseApplicationJson_Ocs, AutoCompleteGetResponseApplicationJson_OcsBuilder> {
  /// Creates a new AutoCompleteGetResponseApplicationJson_Ocs object using the builder pattern.
  factory AutoCompleteGetResponseApplicationJson_Ocs([
    void Function(AutoCompleteGetResponseApplicationJson_OcsBuilder)? b,
  ]) = _$AutoCompleteGetResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const AutoCompleteGetResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AutoCompleteGetResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AutoCompleteGetResponseApplicationJson_Ocs.
  static Serializer<AutoCompleteGetResponseApplicationJson_Ocs> get serializer =>
      _$autoCompleteGetResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AutoCompleteGetResponseApplicationJson_OcsBuilder b) {
    $AutoCompleteGetResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AutoCompleteGetResponseApplicationJson_OcsBuilder b) {
    $AutoCompleteGetResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $AutoCompleteGetResponseApplicationJsonInterface {
  AutoCompleteGetResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AutoCompleteGetResponseApplicationJsonInterfaceBuilder].
  $AutoCompleteGetResponseApplicationJsonInterface rebuild(
    void Function($AutoCompleteGetResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AutoCompleteGetResponseApplicationJsonInterfaceBuilder].
  $AutoCompleteGetResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AutoCompleteGetResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AutoCompleteGetResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class AutoCompleteGetResponseApplicationJson
    implements
        $AutoCompleteGetResponseApplicationJsonInterface,
        Built<AutoCompleteGetResponseApplicationJson, AutoCompleteGetResponseApplicationJsonBuilder> {
  /// Creates a new AutoCompleteGetResponseApplicationJson object using the builder pattern.
  factory AutoCompleteGetResponseApplicationJson([void Function(AutoCompleteGetResponseApplicationJsonBuilder)? b]) =
      _$AutoCompleteGetResponseApplicationJson;

  // coverage:ignore-start
  const AutoCompleteGetResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AutoCompleteGetResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AutoCompleteGetResponseApplicationJson.
  static Serializer<AutoCompleteGetResponseApplicationJson> get serializer =>
      _$autoCompleteGetResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AutoCompleteGetResponseApplicationJsonBuilder b) {
    $AutoCompleteGetResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AutoCompleteGetResponseApplicationJsonBuilder b) {
    $AutoCompleteGetResponseApplicationJsonInterface._validate(b);
  }
}

class AvatarGetAvatarDarkSize extends EnumClass {
  const AvatarGetAvatarDarkSize._(super.name);

  /// `64`
  @BuiltValueEnumConst(wireName: '64')
  static const AvatarGetAvatarDarkSize $64 = _$avatarGetAvatarDarkSize$64;

  /// `512`
  @BuiltValueEnumConst(wireName: '512')
  static const AvatarGetAvatarDarkSize $512 = _$avatarGetAvatarDarkSize$512;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetAvatarDarkSize> get values => _$avatarGetAvatarDarkSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetAvatarDarkSize valueOf(String name) => _$valueOfAvatarGetAvatarDarkSize(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetAvatarDarkSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetAvatarDarkSize> get serializer => const _$AvatarGetAvatarDarkSizeSerializer();
}

class _$AvatarGetAvatarDarkSizeSerializer implements PrimitiveSerializer<AvatarGetAvatarDarkSize> {
  const _$AvatarGetAvatarDarkSizeSerializer();

  static const Map<AvatarGetAvatarDarkSize, Object> _toWire = <AvatarGetAvatarDarkSize, Object>{
    AvatarGetAvatarDarkSize.$64: 64,
    AvatarGetAvatarDarkSize.$512: 512,
  };

  static const Map<Object, AvatarGetAvatarDarkSize> _fromWire = <Object, AvatarGetAvatarDarkSize>{
    64: AvatarGetAvatarDarkSize.$64,
    512: AvatarGetAvatarDarkSize.$512,
  };

  @override
  Iterable<Type> get types => const [AvatarGetAvatarDarkSize];

  @override
  String get wireName => 'AvatarGetAvatarDarkSize';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetAvatarDarkSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetAvatarDarkSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetAvatarDarkGuestFallback extends EnumClass {
  const AvatarGetAvatarDarkGuestFallback._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const AvatarGetAvatarDarkGuestFallback $0 = _$avatarGetAvatarDarkGuestFallback$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const AvatarGetAvatarDarkGuestFallback $1 = _$avatarGetAvatarDarkGuestFallback$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetAvatarDarkGuestFallback> get values => _$avatarGetAvatarDarkGuestFallbackValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetAvatarDarkGuestFallback valueOf(String name) => _$valueOfAvatarGetAvatarDarkGuestFallback(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetAvatarDarkGuestFallback.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetAvatarDarkGuestFallback> get serializer =>
      const _$AvatarGetAvatarDarkGuestFallbackSerializer();
}

class _$AvatarGetAvatarDarkGuestFallbackSerializer implements PrimitiveSerializer<AvatarGetAvatarDarkGuestFallback> {
  const _$AvatarGetAvatarDarkGuestFallbackSerializer();

  static const Map<AvatarGetAvatarDarkGuestFallback, Object> _toWire = <AvatarGetAvatarDarkGuestFallback, Object>{
    AvatarGetAvatarDarkGuestFallback.$0: 0,
    AvatarGetAvatarDarkGuestFallback.$1: 1,
  };

  static const Map<Object, AvatarGetAvatarDarkGuestFallback> _fromWire = <Object, AvatarGetAvatarDarkGuestFallback>{
    0: AvatarGetAvatarDarkGuestFallback.$0,
    1: AvatarGetAvatarDarkGuestFallback.$1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetAvatarDarkGuestFallback];

  @override
  String get wireName => 'AvatarGetAvatarDarkGuestFallback';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetAvatarDarkGuestFallback object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetAvatarDarkGuestFallback deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $AvatarAvatarGetAvatarDarkHeadersInterface {
  @BuiltValueField(wireName: 'x-nc-iscustomavatar')
  Header<int?>? get xNcIscustomavatar;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarAvatarGetAvatarDarkHeadersInterfaceBuilder].
  $AvatarAvatarGetAvatarDarkHeadersInterface rebuild(
    void Function($AvatarAvatarGetAvatarDarkHeadersInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$AvatarAvatarGetAvatarDarkHeadersInterfaceBuilder].
  $AvatarAvatarGetAvatarDarkHeadersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarAvatarGetAvatarDarkHeadersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarAvatarGetAvatarDarkHeadersInterfaceBuilder b) {}
}

abstract class AvatarAvatarGetAvatarDarkHeaders
    implements
        $AvatarAvatarGetAvatarDarkHeadersInterface,
        Built<AvatarAvatarGetAvatarDarkHeaders, AvatarAvatarGetAvatarDarkHeadersBuilder> {
  /// Creates a new AvatarAvatarGetAvatarDarkHeaders object using the builder pattern.
  factory AvatarAvatarGetAvatarDarkHeaders([void Function(AvatarAvatarGetAvatarDarkHeadersBuilder)? b]) =
      _$AvatarAvatarGetAvatarDarkHeaders;

  // coverage:ignore-start
  const AvatarAvatarGetAvatarDarkHeaders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarAvatarGetAvatarDarkHeaders.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarAvatarGetAvatarDarkHeaders.
  static Serializer<AvatarAvatarGetAvatarDarkHeaders> get serializer => _$avatarAvatarGetAvatarDarkHeadersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarAvatarGetAvatarDarkHeadersBuilder b) {
    $AvatarAvatarGetAvatarDarkHeadersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarAvatarGetAvatarDarkHeadersBuilder b) {
    $AvatarAvatarGetAvatarDarkHeadersInterface._validate(b);
  }
}

class AvatarGetAvatarSize extends EnumClass {
  const AvatarGetAvatarSize._(super.name);

  /// `64`
  @BuiltValueEnumConst(wireName: '64')
  static const AvatarGetAvatarSize $64 = _$avatarGetAvatarSize$64;

  /// `512`
  @BuiltValueEnumConst(wireName: '512')
  static const AvatarGetAvatarSize $512 = _$avatarGetAvatarSize$512;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetAvatarSize> get values => _$avatarGetAvatarSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetAvatarSize valueOf(String name) => _$valueOfAvatarGetAvatarSize(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetAvatarSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetAvatarSize> get serializer => const _$AvatarGetAvatarSizeSerializer();
}

class _$AvatarGetAvatarSizeSerializer implements PrimitiveSerializer<AvatarGetAvatarSize> {
  const _$AvatarGetAvatarSizeSerializer();

  static const Map<AvatarGetAvatarSize, Object> _toWire = <AvatarGetAvatarSize, Object>{
    AvatarGetAvatarSize.$64: 64,
    AvatarGetAvatarSize.$512: 512,
  };

  static const Map<Object, AvatarGetAvatarSize> _fromWire = <Object, AvatarGetAvatarSize>{
    64: AvatarGetAvatarSize.$64,
    512: AvatarGetAvatarSize.$512,
  };

  @override
  Iterable<Type> get types => const [AvatarGetAvatarSize];

  @override
  String get wireName => 'AvatarGetAvatarSize';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetAvatarSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetAvatarSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class AvatarGetAvatarGuestFallback extends EnumClass {
  const AvatarGetAvatarGuestFallback._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const AvatarGetAvatarGuestFallback $0 = _$avatarGetAvatarGuestFallback$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const AvatarGetAvatarGuestFallback $1 = _$avatarGetAvatarGuestFallback$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<AvatarGetAvatarGuestFallback> get values => _$avatarGetAvatarGuestFallbackValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static AvatarGetAvatarGuestFallback valueOf(String name) => _$valueOfAvatarGetAvatarGuestFallback(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for AvatarGetAvatarGuestFallback.
  @BuiltValueSerializer(custom: true)
  static Serializer<AvatarGetAvatarGuestFallback> get serializer => const _$AvatarGetAvatarGuestFallbackSerializer();
}

class _$AvatarGetAvatarGuestFallbackSerializer implements PrimitiveSerializer<AvatarGetAvatarGuestFallback> {
  const _$AvatarGetAvatarGuestFallbackSerializer();

  static const Map<AvatarGetAvatarGuestFallback, Object> _toWire = <AvatarGetAvatarGuestFallback, Object>{
    AvatarGetAvatarGuestFallback.$0: 0,
    AvatarGetAvatarGuestFallback.$1: 1,
  };

  static const Map<Object, AvatarGetAvatarGuestFallback> _fromWire = <Object, AvatarGetAvatarGuestFallback>{
    0: AvatarGetAvatarGuestFallback.$0,
    1: AvatarGetAvatarGuestFallback.$1,
  };

  @override
  Iterable<Type> get types => const [AvatarGetAvatarGuestFallback];

  @override
  String get wireName => 'AvatarGetAvatarGuestFallback';

  @override
  Object serialize(
    Serializers serializers,
    AvatarGetAvatarGuestFallback object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  AvatarGetAvatarGuestFallback deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $AvatarAvatarGetAvatarHeadersInterface {
  @BuiltValueField(wireName: 'x-nc-iscustomavatar')
  Header<int?>? get xNcIscustomavatar;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$AvatarAvatarGetAvatarHeadersInterfaceBuilder].
  $AvatarAvatarGetAvatarHeadersInterface rebuild(void Function($AvatarAvatarGetAvatarHeadersInterfaceBuilder) updates);

  /// Converts the instance to a builder [$AvatarAvatarGetAvatarHeadersInterfaceBuilder].
  $AvatarAvatarGetAvatarHeadersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($AvatarAvatarGetAvatarHeadersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($AvatarAvatarGetAvatarHeadersInterfaceBuilder b) {}
}

abstract class AvatarAvatarGetAvatarHeaders
    implements
        $AvatarAvatarGetAvatarHeadersInterface,
        Built<AvatarAvatarGetAvatarHeaders, AvatarAvatarGetAvatarHeadersBuilder> {
  /// Creates a new AvatarAvatarGetAvatarHeaders object using the builder pattern.
  factory AvatarAvatarGetAvatarHeaders([void Function(AvatarAvatarGetAvatarHeadersBuilder)? b]) =
      _$AvatarAvatarGetAvatarHeaders;

  // coverage:ignore-start
  const AvatarAvatarGetAvatarHeaders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory AvatarAvatarGetAvatarHeaders.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for AvatarAvatarGetAvatarHeaders.
  static Serializer<AvatarAvatarGetAvatarHeaders> get serializer => _$avatarAvatarGetAvatarHeadersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(AvatarAvatarGetAvatarHeadersBuilder b) {
    $AvatarAvatarGetAvatarHeadersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(AvatarAvatarGetAvatarHeadersBuilder b) {
    $AvatarAvatarGetAvatarHeadersInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ClientFlowLoginV2PollRequestApplicationJsonInterface {
  /// Token of the flow.
  String get token;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ClientFlowLoginV2PollRequestApplicationJsonInterfaceBuilder].
  $ClientFlowLoginV2PollRequestApplicationJsonInterface rebuild(
    void Function($ClientFlowLoginV2PollRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ClientFlowLoginV2PollRequestApplicationJsonInterfaceBuilder].
  $ClientFlowLoginV2PollRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ClientFlowLoginV2PollRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ClientFlowLoginV2PollRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ClientFlowLoginV2PollRequestApplicationJson
    implements
        $ClientFlowLoginV2PollRequestApplicationJsonInterface,
        Built<ClientFlowLoginV2PollRequestApplicationJson, ClientFlowLoginV2PollRequestApplicationJsonBuilder> {
  /// Creates a new ClientFlowLoginV2PollRequestApplicationJson object using the builder pattern.
  factory ClientFlowLoginV2PollRequestApplicationJson([
    void Function(ClientFlowLoginV2PollRequestApplicationJsonBuilder)? b,
  ]) = _$ClientFlowLoginV2PollRequestApplicationJson;

  // coverage:ignore-start
  const ClientFlowLoginV2PollRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ClientFlowLoginV2PollRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ClientFlowLoginV2PollRequestApplicationJson.
  static Serializer<ClientFlowLoginV2PollRequestApplicationJson> get serializer =>
      _$clientFlowLoginV2PollRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ClientFlowLoginV2PollRequestApplicationJsonBuilder b) {
    $ClientFlowLoginV2PollRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ClientFlowLoginV2PollRequestApplicationJsonBuilder b) {
    $ClientFlowLoginV2PollRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LoginFlowV2CredentialsInterface {
  String get server;
  String get loginName;
  String get appPassword;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LoginFlowV2CredentialsInterfaceBuilder].
  $LoginFlowV2CredentialsInterface rebuild(void Function($LoginFlowV2CredentialsInterfaceBuilder) updates);

  /// Converts the instance to a builder [$LoginFlowV2CredentialsInterfaceBuilder].
  $LoginFlowV2CredentialsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LoginFlowV2CredentialsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LoginFlowV2CredentialsInterfaceBuilder b) {}
}

abstract class LoginFlowV2Credentials
    implements $LoginFlowV2CredentialsInterface, Built<LoginFlowV2Credentials, LoginFlowV2CredentialsBuilder> {
  /// Creates a new LoginFlowV2Credentials object using the builder pattern.
  factory LoginFlowV2Credentials([void Function(LoginFlowV2CredentialsBuilder)? b]) = _$LoginFlowV2Credentials;

  // coverage:ignore-start
  const LoginFlowV2Credentials._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory LoginFlowV2Credentials.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for LoginFlowV2Credentials.
  static Serializer<LoginFlowV2Credentials> get serializer => _$loginFlowV2CredentialsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LoginFlowV2CredentialsBuilder b) {
    $LoginFlowV2CredentialsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LoginFlowV2CredentialsBuilder b) {
    $LoginFlowV2CredentialsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LoginFlowV2_PollInterface {
  String get token;
  String get endpoint;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LoginFlowV2_PollInterfaceBuilder].
  $LoginFlowV2_PollInterface rebuild(void Function($LoginFlowV2_PollInterfaceBuilder) updates);

  /// Converts the instance to a builder [$LoginFlowV2_PollInterfaceBuilder].
  $LoginFlowV2_PollInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LoginFlowV2_PollInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LoginFlowV2_PollInterfaceBuilder b) {}
}

abstract class LoginFlowV2_Poll
    implements $LoginFlowV2_PollInterface, Built<LoginFlowV2_Poll, LoginFlowV2_PollBuilder> {
  /// Creates a new LoginFlowV2_Poll object using the builder pattern.
  factory LoginFlowV2_Poll([void Function(LoginFlowV2_PollBuilder)? b]) = _$LoginFlowV2_Poll;

  // coverage:ignore-start
  const LoginFlowV2_Poll._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory LoginFlowV2_Poll.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for LoginFlowV2_Poll.
  static Serializer<LoginFlowV2_Poll> get serializer => _$loginFlowV2PollSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LoginFlowV2_PollBuilder b) {
    $LoginFlowV2_PollInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LoginFlowV2_PollBuilder b) {
    $LoginFlowV2_PollInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LoginFlowV2Interface {
  LoginFlowV2_Poll get poll;
  String get login;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LoginFlowV2InterfaceBuilder].
  $LoginFlowV2Interface rebuild(void Function($LoginFlowV2InterfaceBuilder) updates);

  /// Converts the instance to a builder [$LoginFlowV2InterfaceBuilder].
  $LoginFlowV2InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LoginFlowV2InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LoginFlowV2InterfaceBuilder b) {}
}

abstract class LoginFlowV2 implements $LoginFlowV2Interface, Built<LoginFlowV2, LoginFlowV2Builder> {
  /// Creates a new LoginFlowV2 object using the builder pattern.
  factory LoginFlowV2([void Function(LoginFlowV2Builder)? b]) = _$LoginFlowV2;

  // coverage:ignore-start
  const LoginFlowV2._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory LoginFlowV2.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for LoginFlowV2.
  static Serializer<LoginFlowV2> get serializer => _$loginFlowV2Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LoginFlowV2Builder b) {
    $LoginFlowV2Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LoginFlowV2Builder b) {
    $LoginFlowV2Interface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OpenGraphObjectInterface {
  String get id;
  String get name;
  String? get description;
  String? get thumb;
  String get link;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OpenGraphObjectInterfaceBuilder].
  $OpenGraphObjectInterface rebuild(void Function($OpenGraphObjectInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OpenGraphObjectInterfaceBuilder].
  $OpenGraphObjectInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OpenGraphObjectInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OpenGraphObjectInterfaceBuilder b) {}
}

abstract class OpenGraphObject implements $OpenGraphObjectInterface, Built<OpenGraphObject, OpenGraphObjectBuilder> {
  /// Creates a new OpenGraphObject object using the builder pattern.
  factory OpenGraphObject([void Function(OpenGraphObjectBuilder)? b]) = _$OpenGraphObject;

  // coverage:ignore-start
  const OpenGraphObject._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OpenGraphObject.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OpenGraphObject.
  static Serializer<OpenGraphObject> get serializer => _$openGraphObjectSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OpenGraphObjectBuilder b) {
    $OpenGraphObjectInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OpenGraphObjectBuilder b) {
    $OpenGraphObjectInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ResourceInterface {
  String get richObjectType;
  BuiltMap<String, JsonObject?> get richObject;
  OpenGraphObject get openGraphObject;
  bool get accessible;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ResourceInterfaceBuilder].
  $ResourceInterface rebuild(void Function($ResourceInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ResourceInterfaceBuilder].
  $ResourceInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ResourceInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ResourceInterfaceBuilder b) {}
}

abstract class Resource implements $ResourceInterface, Built<Resource, ResourceBuilder> {
  /// Creates a new Resource object using the builder pattern.
  factory Resource([void Function(ResourceBuilder)? b]) = _$Resource;

  // coverage:ignore-start
  const Resource._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Resource.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Resource.
  static Serializer<Resource> get serializer => _$resourceSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ResourceBuilder b) {
    $ResourceInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ResourceBuilder b) {
    $ResourceInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollectionInterface {
  int get id;
  String get name;
  BuiltList<Resource> get resources;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollectionInterfaceBuilder].
  $CollectionInterface rebuild(void Function($CollectionInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CollectionInterfaceBuilder].
  $CollectionInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollectionInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollectionInterfaceBuilder b) {}
}

abstract class Collection implements $CollectionInterface, Built<Collection, CollectionBuilder> {
  /// Creates a new Collection object using the builder pattern.
  factory Collection([void Function(CollectionBuilder)? b]) = _$Collection;

  // coverage:ignore-start
  const Collection._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Collection.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Collection.
  static Serializer<Collection> get serializer => _$collectionSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollectionBuilder b) {
    $CollectionInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollectionBuilder b) {
    $CollectionInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesListCollectionResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Collection get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesListCollectionResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesListCollectionResponseApplicationJson_OcsInterface rebuild(
    void Function($CollaborationResourcesListCollectionResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesListCollectionResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesListCollectionResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesListCollectionResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesListCollectionResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CollaborationResourcesListCollectionResponseApplicationJson_Ocs
    implements
        $CollaborationResourcesListCollectionResponseApplicationJson_OcsInterface,
        Built<CollaborationResourcesListCollectionResponseApplicationJson_Ocs,
            CollaborationResourcesListCollectionResponseApplicationJson_OcsBuilder> {
  /// Creates a new CollaborationResourcesListCollectionResponseApplicationJson_Ocs object using the builder pattern.
  factory CollaborationResourcesListCollectionResponseApplicationJson_Ocs([
    void Function(CollaborationResourcesListCollectionResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CollaborationResourcesListCollectionResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CollaborationResourcesListCollectionResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesListCollectionResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesListCollectionResponseApplicationJson_Ocs.
  static Serializer<CollaborationResourcesListCollectionResponseApplicationJson_Ocs> get serializer =>
      _$collaborationResourcesListCollectionResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesListCollectionResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesListCollectionResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesListCollectionResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesListCollectionResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesListCollectionResponseApplicationJsonInterface {
  CollaborationResourcesListCollectionResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesListCollectionResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesListCollectionResponseApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesListCollectionResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesListCollectionResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesListCollectionResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesListCollectionResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesListCollectionResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesListCollectionResponseApplicationJson
    implements
        $CollaborationResourcesListCollectionResponseApplicationJsonInterface,
        Built<CollaborationResourcesListCollectionResponseApplicationJson,
            CollaborationResourcesListCollectionResponseApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesListCollectionResponseApplicationJson object using the builder pattern.
  factory CollaborationResourcesListCollectionResponseApplicationJson([
    void Function(CollaborationResourcesListCollectionResponseApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesListCollectionResponseApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesListCollectionResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesListCollectionResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesListCollectionResponseApplicationJson.
  static Serializer<CollaborationResourcesListCollectionResponseApplicationJson> get serializer =>
      _$collaborationResourcesListCollectionResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesListCollectionResponseApplicationJsonBuilder b) {
    $CollaborationResourcesListCollectionResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesListCollectionResponseApplicationJsonBuilder b) {
    $CollaborationResourcesListCollectionResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesRenameCollectionRequestApplicationJsonInterface {
  /// New name.
  String get collectionName;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesRenameCollectionRequestApplicationJsonInterfaceBuilder].
  $CollaborationResourcesRenameCollectionRequestApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesRenameCollectionRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesRenameCollectionRequestApplicationJsonInterfaceBuilder].
  $CollaborationResourcesRenameCollectionRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesRenameCollectionRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesRenameCollectionRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesRenameCollectionRequestApplicationJson
    implements
        $CollaborationResourcesRenameCollectionRequestApplicationJsonInterface,
        Built<CollaborationResourcesRenameCollectionRequestApplicationJson,
            CollaborationResourcesRenameCollectionRequestApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesRenameCollectionRequestApplicationJson object using the builder pattern.
  factory CollaborationResourcesRenameCollectionRequestApplicationJson([
    void Function(CollaborationResourcesRenameCollectionRequestApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesRenameCollectionRequestApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesRenameCollectionRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesRenameCollectionRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesRenameCollectionRequestApplicationJson.
  static Serializer<CollaborationResourcesRenameCollectionRequestApplicationJson> get serializer =>
      _$collaborationResourcesRenameCollectionRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesRenameCollectionRequestApplicationJsonBuilder b) {
    $CollaborationResourcesRenameCollectionRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesRenameCollectionRequestApplicationJsonBuilder b) {
    $CollaborationResourcesRenameCollectionRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Collection get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterface rebuild(
    void Function($CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs
    implements
        $CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterface,
        Built<CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs,
            CollaborationResourcesRenameCollectionResponseApplicationJson_OcsBuilder> {
  /// Creates a new CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs object using the builder pattern.
  factory CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs([
    void Function(CollaborationResourcesRenameCollectionResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs.
  static Serializer<CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs> get serializer =>
      _$collaborationResourcesRenameCollectionResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesRenameCollectionResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesRenameCollectionResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesRenameCollectionResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesRenameCollectionResponseApplicationJsonInterface {
  CollaborationResourcesRenameCollectionResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesRenameCollectionResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesRenameCollectionResponseApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesRenameCollectionResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesRenameCollectionResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesRenameCollectionResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesRenameCollectionResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesRenameCollectionResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesRenameCollectionResponseApplicationJson
    implements
        $CollaborationResourcesRenameCollectionResponseApplicationJsonInterface,
        Built<CollaborationResourcesRenameCollectionResponseApplicationJson,
            CollaborationResourcesRenameCollectionResponseApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesRenameCollectionResponseApplicationJson object using the builder pattern.
  factory CollaborationResourcesRenameCollectionResponseApplicationJson([
    void Function(CollaborationResourcesRenameCollectionResponseApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesRenameCollectionResponseApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesRenameCollectionResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesRenameCollectionResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesRenameCollectionResponseApplicationJson.
  static Serializer<CollaborationResourcesRenameCollectionResponseApplicationJson> get serializer =>
      _$collaborationResourcesRenameCollectionResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesRenameCollectionResponseApplicationJsonBuilder b) {
    $CollaborationResourcesRenameCollectionResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesRenameCollectionResponseApplicationJsonBuilder b) {
    $CollaborationResourcesRenameCollectionResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesAddResourceRequestApplicationJsonInterface {
  /// Name of the resource.
  String get resourceType;

  /// ID of the resource.
  String get resourceId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesAddResourceRequestApplicationJsonInterfaceBuilder].
  $CollaborationResourcesAddResourceRequestApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesAddResourceRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesAddResourceRequestApplicationJsonInterfaceBuilder].
  $CollaborationResourcesAddResourceRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesAddResourceRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesAddResourceRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesAddResourceRequestApplicationJson
    implements
        $CollaborationResourcesAddResourceRequestApplicationJsonInterface,
        Built<CollaborationResourcesAddResourceRequestApplicationJson,
            CollaborationResourcesAddResourceRequestApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesAddResourceRequestApplicationJson object using the builder pattern.
  factory CollaborationResourcesAddResourceRequestApplicationJson([
    void Function(CollaborationResourcesAddResourceRequestApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesAddResourceRequestApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesAddResourceRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesAddResourceRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesAddResourceRequestApplicationJson.
  static Serializer<CollaborationResourcesAddResourceRequestApplicationJson> get serializer =>
      _$collaborationResourcesAddResourceRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesAddResourceRequestApplicationJsonBuilder b) {
    $CollaborationResourcesAddResourceRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesAddResourceRequestApplicationJsonBuilder b) {
    $CollaborationResourcesAddResourceRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesAddResourceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Collection get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesAddResourceResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesAddResourceResponseApplicationJson_OcsInterface rebuild(
    void Function($CollaborationResourcesAddResourceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesAddResourceResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesAddResourceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesAddResourceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesAddResourceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CollaborationResourcesAddResourceResponseApplicationJson_Ocs
    implements
        $CollaborationResourcesAddResourceResponseApplicationJson_OcsInterface,
        Built<CollaborationResourcesAddResourceResponseApplicationJson_Ocs,
            CollaborationResourcesAddResourceResponseApplicationJson_OcsBuilder> {
  /// Creates a new CollaborationResourcesAddResourceResponseApplicationJson_Ocs object using the builder pattern.
  factory CollaborationResourcesAddResourceResponseApplicationJson_Ocs([
    void Function(CollaborationResourcesAddResourceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CollaborationResourcesAddResourceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CollaborationResourcesAddResourceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesAddResourceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesAddResourceResponseApplicationJson_Ocs.
  static Serializer<CollaborationResourcesAddResourceResponseApplicationJson_Ocs> get serializer =>
      _$collaborationResourcesAddResourceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesAddResourceResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesAddResourceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesAddResourceResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesAddResourceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesAddResourceResponseApplicationJsonInterface {
  CollaborationResourcesAddResourceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesAddResourceResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesAddResourceResponseApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesAddResourceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesAddResourceResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesAddResourceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesAddResourceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesAddResourceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesAddResourceResponseApplicationJson
    implements
        $CollaborationResourcesAddResourceResponseApplicationJsonInterface,
        Built<CollaborationResourcesAddResourceResponseApplicationJson,
            CollaborationResourcesAddResourceResponseApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesAddResourceResponseApplicationJson object using the builder pattern.
  factory CollaborationResourcesAddResourceResponseApplicationJson([
    void Function(CollaborationResourcesAddResourceResponseApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesAddResourceResponseApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesAddResourceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesAddResourceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesAddResourceResponseApplicationJson.
  static Serializer<CollaborationResourcesAddResourceResponseApplicationJson> get serializer =>
      _$collaborationResourcesAddResourceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesAddResourceResponseApplicationJsonBuilder b) {
    $CollaborationResourcesAddResourceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesAddResourceResponseApplicationJsonBuilder b) {
    $CollaborationResourcesAddResourceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Collection get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterface rebuild(
    void Function($CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs
    implements
        $CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterface,
        Built<CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs,
            CollaborationResourcesRemoveResourceResponseApplicationJson_OcsBuilder> {
  /// Creates a new CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs object using the builder pattern.
  factory CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs([
    void Function(CollaborationResourcesRemoveResourceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs.
  static Serializer<CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs> get serializer =>
      _$collaborationResourcesRemoveResourceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesRemoveResourceResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesRemoveResourceResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesRemoveResourceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesRemoveResourceResponseApplicationJsonInterface {
  CollaborationResourcesRemoveResourceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesRemoveResourceResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesRemoveResourceResponseApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesRemoveResourceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesRemoveResourceResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesRemoveResourceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesRemoveResourceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesRemoveResourceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesRemoveResourceResponseApplicationJson
    implements
        $CollaborationResourcesRemoveResourceResponseApplicationJsonInterface,
        Built<CollaborationResourcesRemoveResourceResponseApplicationJson,
            CollaborationResourcesRemoveResourceResponseApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesRemoveResourceResponseApplicationJson object using the builder pattern.
  factory CollaborationResourcesRemoveResourceResponseApplicationJson([
    void Function(CollaborationResourcesRemoveResourceResponseApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesRemoveResourceResponseApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesRemoveResourceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesRemoveResourceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesRemoveResourceResponseApplicationJson.
  static Serializer<CollaborationResourcesRemoveResourceResponseApplicationJson> get serializer =>
      _$collaborationResourcesRemoveResourceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesRemoveResourceResponseApplicationJsonBuilder b) {
    $CollaborationResourcesRemoveResourceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesRemoveResourceResponseApplicationJsonBuilder b) {
    $CollaborationResourcesRemoveResourceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Collection> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterface rebuild(
    void Function($CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs
    implements
        $CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterface,
        Built<CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs,
            CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsBuilder> {
  /// Creates a new CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs object using the builder pattern.
  factory CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs([
    void Function(CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs.
  static Serializer<CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs> get serializer =>
      _$collaborationResourcesSearchCollectionsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesSearchCollectionsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesSearchCollectionsResponseApplicationJsonInterface {
  CollaborationResourcesSearchCollectionsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesSearchCollectionsResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesSearchCollectionsResponseApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesSearchCollectionsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesSearchCollectionsResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesSearchCollectionsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesSearchCollectionsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesSearchCollectionsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesSearchCollectionsResponseApplicationJson
    implements
        $CollaborationResourcesSearchCollectionsResponseApplicationJsonInterface,
        Built<CollaborationResourcesSearchCollectionsResponseApplicationJson,
            CollaborationResourcesSearchCollectionsResponseApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesSearchCollectionsResponseApplicationJson object using the builder pattern.
  factory CollaborationResourcesSearchCollectionsResponseApplicationJson([
    void Function(CollaborationResourcesSearchCollectionsResponseApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesSearchCollectionsResponseApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesSearchCollectionsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesSearchCollectionsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesSearchCollectionsResponseApplicationJson.
  static Serializer<CollaborationResourcesSearchCollectionsResponseApplicationJson> get serializer =>
      _$collaborationResourcesSearchCollectionsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesSearchCollectionsResponseApplicationJsonBuilder b) {
    $CollaborationResourcesSearchCollectionsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesSearchCollectionsResponseApplicationJsonBuilder b) {
    $CollaborationResourcesSearchCollectionsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<Collection> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterface rebuild(
    void Function($CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs
    implements
        $CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterface,
        Built<CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs,
            CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsBuilder> {
  /// Creates a new CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs object using the builder pattern.
  factory CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs([
    void Function(CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs.fromJson(
    Map<String, dynamic> json,
  ) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs.
  static Serializer<CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs> get serializer =>
      _$collaborationResourcesGetCollectionsByResourceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterface {
  CollaborationResourcesGetCollectionsByResourceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesGetCollectionsByResourceResponseApplicationJson
    implements
        $CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterface,
        Built<CollaborationResourcesGetCollectionsByResourceResponseApplicationJson,
            CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesGetCollectionsByResourceResponseApplicationJson object using the builder pattern.
  factory CollaborationResourcesGetCollectionsByResourceResponseApplicationJson([
    void Function(CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesGetCollectionsByResourceResponseApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesGetCollectionsByResourceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesGetCollectionsByResourceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesGetCollectionsByResourceResponseApplicationJson.
  static Serializer<CollaborationResourcesGetCollectionsByResourceResponseApplicationJson> get serializer =>
      _$collaborationResourcesGetCollectionsByResourceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonBuilder b) {
    $CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonBuilder b) {
    $CollaborationResourcesGetCollectionsByResourceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterface {
  /// Name of the collection.
  String get name;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterfaceBuilder].
  $CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterfaceBuilder].
  $CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson
    implements
        $CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterface,
        Built<CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson,
            CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson object using the builder pattern.
  factory CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson([
    void Function(CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson.
  static Serializer<CollaborationResourcesCreateCollectionOnResourceRequestApplicationJson> get serializer =>
      _$collaborationResourcesCreateCollectionOnResourceRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonBuilder b) {
    $CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonBuilder b) {
    $CollaborationResourcesCreateCollectionOnResourceRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  Collection get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterface rebuild(
    void Function($CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterfaceBuilder].
  $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(
    $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterfaceBuilder b,
  ) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(
    $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterfaceBuilder b,
  ) {}
}

abstract class CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs
    implements
        $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterface,
        Built<CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs,
            CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsBuilder> {
  /// Creates a new CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs object using the builder pattern.
  factory CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs([
    void Function(CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsBuilder)? b,
  ]) = _$CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs.fromJson(
    Map<String, dynamic> json,
  ) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs.
  static Serializer<CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs> get serializer =>
      _$collaborationResourcesCreateCollectionOnResourceResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsBuilder b) {
    $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterface {
  CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterface rebuild(
    void Function($CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterfaceBuilder].
  $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson
    implements
        $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterface,
        Built<CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson,
            CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonBuilder> {
  /// Creates a new CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson object using the builder pattern.
  factory CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson([
    void Function(CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonBuilder)? b,
  ]) = _$CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson;

  // coverage:ignore-start
  const CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson.
  static Serializer<CollaborationResourcesCreateCollectionOnResourceResponseApplicationJson> get serializer =>
      _$collaborationResourcesCreateCollectionOnResourceResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonBuilder b) {
    $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonBuilder b) {
    $CollaborationResourcesCreateCollectionOnResourceResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CsrfTokenIndexResponseApplicationJsonInterface {
  String get token;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CsrfTokenIndexResponseApplicationJsonInterfaceBuilder].
  $CsrfTokenIndexResponseApplicationJsonInterface rebuild(
    void Function($CsrfTokenIndexResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CsrfTokenIndexResponseApplicationJsonInterfaceBuilder].
  $CsrfTokenIndexResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CsrfTokenIndexResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CsrfTokenIndexResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class CsrfTokenIndexResponseApplicationJson
    implements
        $CsrfTokenIndexResponseApplicationJsonInterface,
        Built<CsrfTokenIndexResponseApplicationJson, CsrfTokenIndexResponseApplicationJsonBuilder> {
  /// Creates a new CsrfTokenIndexResponseApplicationJson object using the builder pattern.
  factory CsrfTokenIndexResponseApplicationJson([void Function(CsrfTokenIndexResponseApplicationJsonBuilder)? b]) =
      _$CsrfTokenIndexResponseApplicationJson;

  // coverage:ignore-start
  const CsrfTokenIndexResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CsrfTokenIndexResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CsrfTokenIndexResponseApplicationJson.
  static Serializer<CsrfTokenIndexResponseApplicationJson> get serializer =>
      _$csrfTokenIndexResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CsrfTokenIndexResponseApplicationJsonBuilder b) {
    $CsrfTokenIndexResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CsrfTokenIndexResponseApplicationJsonBuilder b) {
    $CsrfTokenIndexResponseApplicationJsonInterface._validate(b);
  }
}

class GuestAvatarGetAvatarSize extends EnumClass {
  const GuestAvatarGetAvatarSize._(super.name);

  /// `64`
  @BuiltValueEnumConst(wireName: '64')
  static const GuestAvatarGetAvatarSize $64 = _$guestAvatarGetAvatarSize$64;

  /// `512`
  @BuiltValueEnumConst(wireName: '512')
  static const GuestAvatarGetAvatarSize $512 = _$guestAvatarGetAvatarSize$512;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<GuestAvatarGetAvatarSize> get values => _$guestAvatarGetAvatarSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static GuestAvatarGetAvatarSize valueOf(String name) => _$valueOfGuestAvatarGetAvatarSize(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for GuestAvatarGetAvatarSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<GuestAvatarGetAvatarSize> get serializer => const _$GuestAvatarGetAvatarSizeSerializer();
}

class _$GuestAvatarGetAvatarSizeSerializer implements PrimitiveSerializer<GuestAvatarGetAvatarSize> {
  const _$GuestAvatarGetAvatarSizeSerializer();

  static const Map<GuestAvatarGetAvatarSize, Object> _toWire = <GuestAvatarGetAvatarSize, Object>{
    GuestAvatarGetAvatarSize.$64: 64,
    GuestAvatarGetAvatarSize.$512: 512,
  };

  static const Map<Object, GuestAvatarGetAvatarSize> _fromWire = <Object, GuestAvatarGetAvatarSize>{
    64: GuestAvatarGetAvatarSize.$64,
    512: GuestAvatarGetAvatarSize.$512,
  };

  @override
  Iterable<Type> get types => const [GuestAvatarGetAvatarSize];

  @override
  String get wireName => 'GuestAvatarGetAvatarSize';

  @override
  Object serialize(
    Serializers serializers,
    GuestAvatarGetAvatarSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  GuestAvatarGetAvatarSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class GuestAvatarGetAvatarDarkTheme extends EnumClass {
  const GuestAvatarGetAvatarDarkTheme._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const GuestAvatarGetAvatarDarkTheme $0 = _$guestAvatarGetAvatarDarkTheme$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const GuestAvatarGetAvatarDarkTheme $1 = _$guestAvatarGetAvatarDarkTheme$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<GuestAvatarGetAvatarDarkTheme> get values => _$guestAvatarGetAvatarDarkThemeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static GuestAvatarGetAvatarDarkTheme valueOf(String name) => _$valueOfGuestAvatarGetAvatarDarkTheme(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for GuestAvatarGetAvatarDarkTheme.
  @BuiltValueSerializer(custom: true)
  static Serializer<GuestAvatarGetAvatarDarkTheme> get serializer => const _$GuestAvatarGetAvatarDarkThemeSerializer();
}

class _$GuestAvatarGetAvatarDarkThemeSerializer implements PrimitiveSerializer<GuestAvatarGetAvatarDarkTheme> {
  const _$GuestAvatarGetAvatarDarkThemeSerializer();

  static const Map<GuestAvatarGetAvatarDarkTheme, Object> _toWire = <GuestAvatarGetAvatarDarkTheme, Object>{
    GuestAvatarGetAvatarDarkTheme.$0: 0,
    GuestAvatarGetAvatarDarkTheme.$1: 1,
  };

  static const Map<Object, GuestAvatarGetAvatarDarkTheme> _fromWire = <Object, GuestAvatarGetAvatarDarkTheme>{
    0: GuestAvatarGetAvatarDarkTheme.$0,
    1: GuestAvatarGetAvatarDarkTheme.$1,
  };

  @override
  Iterable<Type> get types => const [GuestAvatarGetAvatarDarkTheme];

  @override
  String get wireName => 'GuestAvatarGetAvatarDarkTheme';

  @override
  Object serialize(
    Serializers serializers,
    GuestAvatarGetAvatarDarkTheme object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  GuestAvatarGetAvatarDarkTheme deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $GuestAvatarGuestAvatarGetAvatarHeadersInterface {
  @BuiltValueField(wireName: 'x-nc-iscustomavatar')
  Header<int?>? get xNcIscustomavatar;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GuestAvatarGuestAvatarGetAvatarHeadersInterfaceBuilder].
  $GuestAvatarGuestAvatarGetAvatarHeadersInterface rebuild(
    void Function($GuestAvatarGuestAvatarGetAvatarHeadersInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GuestAvatarGuestAvatarGetAvatarHeadersInterfaceBuilder].
  $GuestAvatarGuestAvatarGetAvatarHeadersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GuestAvatarGuestAvatarGetAvatarHeadersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GuestAvatarGuestAvatarGetAvatarHeadersInterfaceBuilder b) {}
}

abstract class GuestAvatarGuestAvatarGetAvatarHeaders
    implements
        $GuestAvatarGuestAvatarGetAvatarHeadersInterface,
        Built<GuestAvatarGuestAvatarGetAvatarHeaders, GuestAvatarGuestAvatarGetAvatarHeadersBuilder> {
  /// Creates a new GuestAvatarGuestAvatarGetAvatarHeaders object using the builder pattern.
  factory GuestAvatarGuestAvatarGetAvatarHeaders([void Function(GuestAvatarGuestAvatarGetAvatarHeadersBuilder)? b]) =
      _$GuestAvatarGuestAvatarGetAvatarHeaders;

  // coverage:ignore-start
  const GuestAvatarGuestAvatarGetAvatarHeaders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GuestAvatarGuestAvatarGetAvatarHeaders.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GuestAvatarGuestAvatarGetAvatarHeaders.
  static Serializer<GuestAvatarGuestAvatarGetAvatarHeaders> get serializer =>
      _$guestAvatarGuestAvatarGetAvatarHeadersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GuestAvatarGuestAvatarGetAvatarHeadersBuilder b) {
    $GuestAvatarGuestAvatarGetAvatarHeadersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GuestAvatarGuestAvatarGetAvatarHeadersBuilder b) {
    $GuestAvatarGuestAvatarGetAvatarHeadersInterface._validate(b);
  }
}

class GuestAvatarGetAvatarDarkSize extends EnumClass {
  const GuestAvatarGetAvatarDarkSize._(super.name);

  /// `64`
  @BuiltValueEnumConst(wireName: '64')
  static const GuestAvatarGetAvatarDarkSize $64 = _$guestAvatarGetAvatarDarkSize$64;

  /// `512`
  @BuiltValueEnumConst(wireName: '512')
  static const GuestAvatarGetAvatarDarkSize $512 = _$guestAvatarGetAvatarDarkSize$512;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<GuestAvatarGetAvatarDarkSize> get values => _$guestAvatarGetAvatarDarkSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static GuestAvatarGetAvatarDarkSize valueOf(String name) => _$valueOfGuestAvatarGetAvatarDarkSize(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for GuestAvatarGetAvatarDarkSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<GuestAvatarGetAvatarDarkSize> get serializer => const _$GuestAvatarGetAvatarDarkSizeSerializer();
}

class _$GuestAvatarGetAvatarDarkSizeSerializer implements PrimitiveSerializer<GuestAvatarGetAvatarDarkSize> {
  const _$GuestAvatarGetAvatarDarkSizeSerializer();

  static const Map<GuestAvatarGetAvatarDarkSize, Object> _toWire = <GuestAvatarGetAvatarDarkSize, Object>{
    GuestAvatarGetAvatarDarkSize.$64: 64,
    GuestAvatarGetAvatarDarkSize.$512: 512,
  };

  static const Map<Object, GuestAvatarGetAvatarDarkSize> _fromWire = <Object, GuestAvatarGetAvatarDarkSize>{
    64: GuestAvatarGetAvatarDarkSize.$64,
    512: GuestAvatarGetAvatarDarkSize.$512,
  };

  @override
  Iterable<Type> get types => const [GuestAvatarGetAvatarDarkSize];

  @override
  String get wireName => 'GuestAvatarGetAvatarDarkSize';

  @override
  Object serialize(
    Serializers serializers,
    GuestAvatarGetAvatarDarkSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  GuestAvatarGetAvatarDarkSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $GuestAvatarGuestAvatarGetAvatarDarkHeadersInterface {
  @BuiltValueField(wireName: 'x-nc-iscustomavatar')
  Header<int?>? get xNcIscustomavatar;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$GuestAvatarGuestAvatarGetAvatarDarkHeadersInterfaceBuilder].
  $GuestAvatarGuestAvatarGetAvatarDarkHeadersInterface rebuild(
    void Function($GuestAvatarGuestAvatarGetAvatarDarkHeadersInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$GuestAvatarGuestAvatarGetAvatarDarkHeadersInterfaceBuilder].
  $GuestAvatarGuestAvatarGetAvatarDarkHeadersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($GuestAvatarGuestAvatarGetAvatarDarkHeadersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($GuestAvatarGuestAvatarGetAvatarDarkHeadersInterfaceBuilder b) {}
}

abstract class GuestAvatarGuestAvatarGetAvatarDarkHeaders
    implements
        $GuestAvatarGuestAvatarGetAvatarDarkHeadersInterface,
        Built<GuestAvatarGuestAvatarGetAvatarDarkHeaders, GuestAvatarGuestAvatarGetAvatarDarkHeadersBuilder> {
  /// Creates a new GuestAvatarGuestAvatarGetAvatarDarkHeaders object using the builder pattern.
  factory GuestAvatarGuestAvatarGetAvatarDarkHeaders([
    void Function(GuestAvatarGuestAvatarGetAvatarDarkHeadersBuilder)? b,
  ]) = _$GuestAvatarGuestAvatarGetAvatarDarkHeaders;

  // coverage:ignore-start
  const GuestAvatarGuestAvatarGetAvatarDarkHeaders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory GuestAvatarGuestAvatarGetAvatarDarkHeaders.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for GuestAvatarGuestAvatarGetAvatarDarkHeaders.
  static Serializer<GuestAvatarGuestAvatarGetAvatarDarkHeaders> get serializer =>
      _$guestAvatarGuestAvatarGetAvatarDarkHeadersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(GuestAvatarGuestAvatarGetAvatarDarkHeadersBuilder b) {
    $GuestAvatarGuestAvatarGetAvatarDarkHeadersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(GuestAvatarGuestAvatarGetAvatarDarkHeadersBuilder b) {
    $GuestAvatarGuestAvatarGetAvatarDarkHeadersInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ContactsActionInterface {
  String get title;
  String get icon;
  String get hyperlink;
  String get appId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ContactsActionInterfaceBuilder].
  $ContactsActionInterface rebuild(void Function($ContactsActionInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ContactsActionInterfaceBuilder].
  $ContactsActionInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ContactsActionInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ContactsActionInterfaceBuilder b) {}
}

abstract class ContactsAction implements $ContactsActionInterface, Built<ContactsAction, ContactsActionBuilder> {
  /// Creates a new ContactsAction object using the builder pattern.
  factory ContactsAction([void Function(ContactsActionBuilder)? b]) = _$ContactsAction;

  // coverage:ignore-start
  const ContactsAction._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ContactsAction.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ContactsAction.
  static Serializer<ContactsAction> get serializer => _$contactsActionSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ContactsActionBuilder b) {
    $ContactsActionInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ContactsActionBuilder b) {
    $ContactsActionInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $HoverCardGetUserResponseApplicationJson_Ocs_DataInterface {
  String get userId;
  String get displayName;
  BuiltList<ContactsAction> get actions;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$HoverCardGetUserResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $HoverCardGetUserResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($HoverCardGetUserResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$HoverCardGetUserResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $HoverCardGetUserResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($HoverCardGetUserResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($HoverCardGetUserResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class HoverCardGetUserResponseApplicationJson_Ocs_Data
    implements
        $HoverCardGetUserResponseApplicationJson_Ocs_DataInterface,
        Built<HoverCardGetUserResponseApplicationJson_Ocs_Data,
            HoverCardGetUserResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new HoverCardGetUserResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory HoverCardGetUserResponseApplicationJson_Ocs_Data([
    void Function(HoverCardGetUserResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$HoverCardGetUserResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const HoverCardGetUserResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory HoverCardGetUserResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for HoverCardGetUserResponseApplicationJson_Ocs_Data.
  static Serializer<HoverCardGetUserResponseApplicationJson_Ocs_Data> get serializer =>
      _$hoverCardGetUserResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(HoverCardGetUserResponseApplicationJson_Ocs_DataBuilder b) {
    $HoverCardGetUserResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(HoverCardGetUserResponseApplicationJson_Ocs_DataBuilder b) {
    $HoverCardGetUserResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $HoverCardGetUserResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  HoverCardGetUserResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$HoverCardGetUserResponseApplicationJson_OcsInterfaceBuilder].
  $HoverCardGetUserResponseApplicationJson_OcsInterface rebuild(
    void Function($HoverCardGetUserResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$HoverCardGetUserResponseApplicationJson_OcsInterfaceBuilder].
  $HoverCardGetUserResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($HoverCardGetUserResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($HoverCardGetUserResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class HoverCardGetUserResponseApplicationJson_Ocs
    implements
        $HoverCardGetUserResponseApplicationJson_OcsInterface,
        Built<HoverCardGetUserResponseApplicationJson_Ocs, HoverCardGetUserResponseApplicationJson_OcsBuilder> {
  /// Creates a new HoverCardGetUserResponseApplicationJson_Ocs object using the builder pattern.
  factory HoverCardGetUserResponseApplicationJson_Ocs([
    void Function(HoverCardGetUserResponseApplicationJson_OcsBuilder)? b,
  ]) = _$HoverCardGetUserResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const HoverCardGetUserResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory HoverCardGetUserResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for HoverCardGetUserResponseApplicationJson_Ocs.
  static Serializer<HoverCardGetUserResponseApplicationJson_Ocs> get serializer =>
      _$hoverCardGetUserResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(HoverCardGetUserResponseApplicationJson_OcsBuilder b) {
    $HoverCardGetUserResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(HoverCardGetUserResponseApplicationJson_OcsBuilder b) {
    $HoverCardGetUserResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $HoverCardGetUserResponseApplicationJsonInterface {
  HoverCardGetUserResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$HoverCardGetUserResponseApplicationJsonInterfaceBuilder].
  $HoverCardGetUserResponseApplicationJsonInterface rebuild(
    void Function($HoverCardGetUserResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$HoverCardGetUserResponseApplicationJsonInterfaceBuilder].
  $HoverCardGetUserResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($HoverCardGetUserResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($HoverCardGetUserResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class HoverCardGetUserResponseApplicationJson
    implements
        $HoverCardGetUserResponseApplicationJsonInterface,
        Built<HoverCardGetUserResponseApplicationJson, HoverCardGetUserResponseApplicationJsonBuilder> {
  /// Creates a new HoverCardGetUserResponseApplicationJson object using the builder pattern.
  factory HoverCardGetUserResponseApplicationJson([void Function(HoverCardGetUserResponseApplicationJsonBuilder)? b]) =
      _$HoverCardGetUserResponseApplicationJson;

  // coverage:ignore-start
  const HoverCardGetUserResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory HoverCardGetUserResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for HoverCardGetUserResponseApplicationJson.
  static Serializer<HoverCardGetUserResponseApplicationJson> get serializer =>
      _$hoverCardGetUserResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(HoverCardGetUserResponseApplicationJsonBuilder b) {
    $HoverCardGetUserResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(HoverCardGetUserResponseApplicationJsonBuilder b) {
    $HoverCardGetUserResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LoginConfirmPasswordRequestApplicationJsonInterface {
  /// The password of the user.
  String get password;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LoginConfirmPasswordRequestApplicationJsonInterfaceBuilder].
  $LoginConfirmPasswordRequestApplicationJsonInterface rebuild(
    void Function($LoginConfirmPasswordRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$LoginConfirmPasswordRequestApplicationJsonInterfaceBuilder].
  $LoginConfirmPasswordRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LoginConfirmPasswordRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LoginConfirmPasswordRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class LoginConfirmPasswordRequestApplicationJson
    implements
        $LoginConfirmPasswordRequestApplicationJsonInterface,
        Built<LoginConfirmPasswordRequestApplicationJson, LoginConfirmPasswordRequestApplicationJsonBuilder> {
  /// Creates a new LoginConfirmPasswordRequestApplicationJson object using the builder pattern.
  factory LoginConfirmPasswordRequestApplicationJson([
    void Function(LoginConfirmPasswordRequestApplicationJsonBuilder)? b,
  ]) = _$LoginConfirmPasswordRequestApplicationJson;

  // coverage:ignore-start
  const LoginConfirmPasswordRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory LoginConfirmPasswordRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for LoginConfirmPasswordRequestApplicationJson.
  static Serializer<LoginConfirmPasswordRequestApplicationJson> get serializer =>
      _$loginConfirmPasswordRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LoginConfirmPasswordRequestApplicationJsonBuilder b) {
    $LoginConfirmPasswordRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LoginConfirmPasswordRequestApplicationJsonBuilder b) {
    $LoginConfirmPasswordRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $LoginConfirmPasswordResponseApplicationJsonInterface {
  int get lastLogin;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$LoginConfirmPasswordResponseApplicationJsonInterfaceBuilder].
  $LoginConfirmPasswordResponseApplicationJsonInterface rebuild(
    void Function($LoginConfirmPasswordResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$LoginConfirmPasswordResponseApplicationJsonInterfaceBuilder].
  $LoginConfirmPasswordResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($LoginConfirmPasswordResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($LoginConfirmPasswordResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class LoginConfirmPasswordResponseApplicationJson
    implements
        $LoginConfirmPasswordResponseApplicationJsonInterface,
        Built<LoginConfirmPasswordResponseApplicationJson, LoginConfirmPasswordResponseApplicationJsonBuilder> {
  /// Creates a new LoginConfirmPasswordResponseApplicationJson object using the builder pattern.
  factory LoginConfirmPasswordResponseApplicationJson([
    void Function(LoginConfirmPasswordResponseApplicationJsonBuilder)? b,
  ]) = _$LoginConfirmPasswordResponseApplicationJson;

  // coverage:ignore-start
  const LoginConfirmPasswordResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory LoginConfirmPasswordResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for LoginConfirmPasswordResponseApplicationJson.
  static Serializer<LoginConfirmPasswordResponseApplicationJson> get serializer =>
      _$loginConfirmPasswordResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(LoginConfirmPasswordResponseApplicationJsonBuilder b) {
    $LoginConfirmPasswordResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(LoginConfirmPasswordResponseApplicationJsonBuilder b) {
    $LoginConfirmPasswordResponseApplicationJsonInterface._validate(b);
  }
}

class NavigationGetAppsNavigationAbsolute extends EnumClass {
  const NavigationGetAppsNavigationAbsolute._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const NavigationGetAppsNavigationAbsolute $0 = _$navigationGetAppsNavigationAbsolute$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const NavigationGetAppsNavigationAbsolute $1 = _$navigationGetAppsNavigationAbsolute$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<NavigationGetAppsNavigationAbsolute> get values => _$navigationGetAppsNavigationAbsoluteValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static NavigationGetAppsNavigationAbsolute valueOf(String name) => _$valueOfNavigationGetAppsNavigationAbsolute(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for NavigationGetAppsNavigationAbsolute.
  @BuiltValueSerializer(custom: true)
  static Serializer<NavigationGetAppsNavigationAbsolute> get serializer =>
      const _$NavigationGetAppsNavigationAbsoluteSerializer();
}

class _$NavigationGetAppsNavigationAbsoluteSerializer
    implements PrimitiveSerializer<NavigationGetAppsNavigationAbsolute> {
  const _$NavigationGetAppsNavigationAbsoluteSerializer();

  static const Map<NavigationGetAppsNavigationAbsolute, Object> _toWire = <NavigationGetAppsNavigationAbsolute, Object>{
    NavigationGetAppsNavigationAbsolute.$0: 0,
    NavigationGetAppsNavigationAbsolute.$1: 1,
  };

  static const Map<Object, NavigationGetAppsNavigationAbsolute> _fromWire =
      <Object, NavigationGetAppsNavigationAbsolute>{
    0: NavigationGetAppsNavigationAbsolute.$0,
    1: NavigationGetAppsNavigationAbsolute.$1,
  };

  @override
  Iterable<Type> get types => const [NavigationGetAppsNavigationAbsolute];

  @override
  String get wireName => 'NavigationGetAppsNavigationAbsolute';

  @override
  Object serialize(
    Serializers serializers,
    NavigationGetAppsNavigationAbsolute object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  NavigationGetAppsNavigationAbsolute deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

typedef NavigationEntry_Order = ({int? $int, String? string});

@BuiltValue(instantiable: false)
sealed class $NavigationEntryInterface {
  String get id;
  NavigationEntry_Order? get order;
  String get href;
  String get icon;
  String get type;
  String get name;
  String? get app;
  @BuiltValueField(wireName: 'default')
  bool? get $default;
  bool get active;
  String get classes;
  int get unread;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NavigationEntryInterfaceBuilder].
  $NavigationEntryInterface rebuild(void Function($NavigationEntryInterfaceBuilder) updates);

  /// Converts the instance to a builder [$NavigationEntryInterfaceBuilder].
  $NavigationEntryInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NavigationEntryInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NavigationEntryInterfaceBuilder b) {
    b.order?.validateOneOf();
  }
}

abstract class NavigationEntry implements $NavigationEntryInterface, Built<NavigationEntry, NavigationEntryBuilder> {
  /// Creates a new NavigationEntry object using the builder pattern.
  factory NavigationEntry([void Function(NavigationEntryBuilder)? b]) = _$NavigationEntry;

  // coverage:ignore-start
  const NavigationEntry._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NavigationEntry.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NavigationEntry.
  static Serializer<NavigationEntry> get serializer => _$navigationEntrySerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NavigationEntryBuilder b) {
    $NavigationEntryInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NavigationEntryBuilder b) {
    $NavigationEntryInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NavigationGetAppsNavigationResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<NavigationEntry> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NavigationGetAppsNavigationResponseApplicationJson_OcsInterfaceBuilder].
  $NavigationGetAppsNavigationResponseApplicationJson_OcsInterface rebuild(
    void Function($NavigationGetAppsNavigationResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$NavigationGetAppsNavigationResponseApplicationJson_OcsInterfaceBuilder].
  $NavigationGetAppsNavigationResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NavigationGetAppsNavigationResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NavigationGetAppsNavigationResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class NavigationGetAppsNavigationResponseApplicationJson_Ocs
    implements
        $NavigationGetAppsNavigationResponseApplicationJson_OcsInterface,
        Built<NavigationGetAppsNavigationResponseApplicationJson_Ocs,
            NavigationGetAppsNavigationResponseApplicationJson_OcsBuilder> {
  /// Creates a new NavigationGetAppsNavigationResponseApplicationJson_Ocs object using the builder pattern.
  factory NavigationGetAppsNavigationResponseApplicationJson_Ocs([
    void Function(NavigationGetAppsNavigationResponseApplicationJson_OcsBuilder)? b,
  ]) = _$NavigationGetAppsNavigationResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const NavigationGetAppsNavigationResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NavigationGetAppsNavigationResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NavigationGetAppsNavigationResponseApplicationJson_Ocs.
  static Serializer<NavigationGetAppsNavigationResponseApplicationJson_Ocs> get serializer =>
      _$navigationGetAppsNavigationResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NavigationGetAppsNavigationResponseApplicationJson_OcsBuilder b) {
    $NavigationGetAppsNavigationResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NavigationGetAppsNavigationResponseApplicationJson_OcsBuilder b) {
    $NavigationGetAppsNavigationResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NavigationGetAppsNavigationResponseApplicationJsonInterface {
  NavigationGetAppsNavigationResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NavigationGetAppsNavigationResponseApplicationJsonInterfaceBuilder].
  $NavigationGetAppsNavigationResponseApplicationJsonInterface rebuild(
    void Function($NavigationGetAppsNavigationResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$NavigationGetAppsNavigationResponseApplicationJsonInterfaceBuilder].
  $NavigationGetAppsNavigationResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NavigationGetAppsNavigationResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NavigationGetAppsNavigationResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class NavigationGetAppsNavigationResponseApplicationJson
    implements
        $NavigationGetAppsNavigationResponseApplicationJsonInterface,
        Built<NavigationGetAppsNavigationResponseApplicationJson,
            NavigationGetAppsNavigationResponseApplicationJsonBuilder> {
  /// Creates a new NavigationGetAppsNavigationResponseApplicationJson object using the builder pattern.
  factory NavigationGetAppsNavigationResponseApplicationJson([
    void Function(NavigationGetAppsNavigationResponseApplicationJsonBuilder)? b,
  ]) = _$NavigationGetAppsNavigationResponseApplicationJson;

  // coverage:ignore-start
  const NavigationGetAppsNavigationResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NavigationGetAppsNavigationResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NavigationGetAppsNavigationResponseApplicationJson.
  static Serializer<NavigationGetAppsNavigationResponseApplicationJson> get serializer =>
      _$navigationGetAppsNavigationResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NavigationGetAppsNavigationResponseApplicationJsonBuilder b) {
    $NavigationGetAppsNavigationResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NavigationGetAppsNavigationResponseApplicationJsonBuilder b) {
    $NavigationGetAppsNavigationResponseApplicationJsonInterface._validate(b);
  }
}

class NavigationGetSettingsNavigationAbsolute extends EnumClass {
  const NavigationGetSettingsNavigationAbsolute._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const NavigationGetSettingsNavigationAbsolute $0 = _$navigationGetSettingsNavigationAbsolute$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const NavigationGetSettingsNavigationAbsolute $1 = _$navigationGetSettingsNavigationAbsolute$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<NavigationGetSettingsNavigationAbsolute> get values =>
      _$navigationGetSettingsNavigationAbsoluteValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static NavigationGetSettingsNavigationAbsolute valueOf(String name) =>
      _$valueOfNavigationGetSettingsNavigationAbsolute(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for NavigationGetSettingsNavigationAbsolute.
  @BuiltValueSerializer(custom: true)
  static Serializer<NavigationGetSettingsNavigationAbsolute> get serializer =>
      const _$NavigationGetSettingsNavigationAbsoluteSerializer();
}

class _$NavigationGetSettingsNavigationAbsoluteSerializer
    implements PrimitiveSerializer<NavigationGetSettingsNavigationAbsolute> {
  const _$NavigationGetSettingsNavigationAbsoluteSerializer();

  static const Map<NavigationGetSettingsNavigationAbsolute, Object> _toWire =
      <NavigationGetSettingsNavigationAbsolute, Object>{
    NavigationGetSettingsNavigationAbsolute.$0: 0,
    NavigationGetSettingsNavigationAbsolute.$1: 1,
  };

  static const Map<Object, NavigationGetSettingsNavigationAbsolute> _fromWire =
      <Object, NavigationGetSettingsNavigationAbsolute>{
    0: NavigationGetSettingsNavigationAbsolute.$0,
    1: NavigationGetSettingsNavigationAbsolute.$1,
  };

  @override
  Iterable<Type> get types => const [NavigationGetSettingsNavigationAbsolute];

  @override
  String get wireName => 'NavigationGetSettingsNavigationAbsolute';

  @override
  Object serialize(
    Serializers serializers,
    NavigationGetSettingsNavigationAbsolute object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  NavigationGetSettingsNavigationAbsolute deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $NavigationGetSettingsNavigationResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<NavigationEntry> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NavigationGetSettingsNavigationResponseApplicationJson_OcsInterfaceBuilder].
  $NavigationGetSettingsNavigationResponseApplicationJson_OcsInterface rebuild(
    void Function($NavigationGetSettingsNavigationResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$NavigationGetSettingsNavigationResponseApplicationJson_OcsInterfaceBuilder].
  $NavigationGetSettingsNavigationResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NavigationGetSettingsNavigationResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NavigationGetSettingsNavigationResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class NavigationGetSettingsNavigationResponseApplicationJson_Ocs
    implements
        $NavigationGetSettingsNavigationResponseApplicationJson_OcsInterface,
        Built<NavigationGetSettingsNavigationResponseApplicationJson_Ocs,
            NavigationGetSettingsNavigationResponseApplicationJson_OcsBuilder> {
  /// Creates a new NavigationGetSettingsNavigationResponseApplicationJson_Ocs object using the builder pattern.
  factory NavigationGetSettingsNavigationResponseApplicationJson_Ocs([
    void Function(NavigationGetSettingsNavigationResponseApplicationJson_OcsBuilder)? b,
  ]) = _$NavigationGetSettingsNavigationResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const NavigationGetSettingsNavigationResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NavigationGetSettingsNavigationResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NavigationGetSettingsNavigationResponseApplicationJson_Ocs.
  static Serializer<NavigationGetSettingsNavigationResponseApplicationJson_Ocs> get serializer =>
      _$navigationGetSettingsNavigationResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NavigationGetSettingsNavigationResponseApplicationJson_OcsBuilder b) {
    $NavigationGetSettingsNavigationResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NavigationGetSettingsNavigationResponseApplicationJson_OcsBuilder b) {
    $NavigationGetSettingsNavigationResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NavigationGetSettingsNavigationResponseApplicationJsonInterface {
  NavigationGetSettingsNavigationResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NavigationGetSettingsNavigationResponseApplicationJsonInterfaceBuilder].
  $NavigationGetSettingsNavigationResponseApplicationJsonInterface rebuild(
    void Function($NavigationGetSettingsNavigationResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$NavigationGetSettingsNavigationResponseApplicationJsonInterfaceBuilder].
  $NavigationGetSettingsNavigationResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NavigationGetSettingsNavigationResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NavigationGetSettingsNavigationResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class NavigationGetSettingsNavigationResponseApplicationJson
    implements
        $NavigationGetSettingsNavigationResponseApplicationJsonInterface,
        Built<NavigationGetSettingsNavigationResponseApplicationJson,
            NavigationGetSettingsNavigationResponseApplicationJsonBuilder> {
  /// Creates a new NavigationGetSettingsNavigationResponseApplicationJson object using the builder pattern.
  factory NavigationGetSettingsNavigationResponseApplicationJson([
    void Function(NavigationGetSettingsNavigationResponseApplicationJsonBuilder)? b,
  ]) = _$NavigationGetSettingsNavigationResponseApplicationJson;

  // coverage:ignore-start
  const NavigationGetSettingsNavigationResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NavigationGetSettingsNavigationResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NavigationGetSettingsNavigationResponseApplicationJson.
  static Serializer<NavigationGetSettingsNavigationResponseApplicationJson> get serializer =>
      _$navigationGetSettingsNavigationResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NavigationGetSettingsNavigationResponseApplicationJsonBuilder b) {
    $NavigationGetSettingsNavigationResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NavigationGetSettingsNavigationResponseApplicationJsonBuilder b) {
    $NavigationGetSettingsNavigationResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterface {
  String get webdav;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterfaceBuilder].
  $OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterface rebuild(
    void Function($OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterfaceBuilder].
  $OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterfaceBuilder b) {}
}

abstract class OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols
    implements
        $OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterface,
        Built<OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols,
            OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsBuilder> {
  /// Creates a new OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols object using the builder pattern.
  factory OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols([
    void Function(OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsBuilder)? b,
  ]) = _$OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols;

  // coverage:ignore-start
  const OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols.
  static Serializer<OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols> get serializer =>
      _$ocmDiscoveryResponseApplicationJsonResourceTypesProtocolsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsBuilder b) {
    $OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsBuilder b) {
    $OcmDiscoveryResponseApplicationJson_ResourceTypes_ProtocolsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OcmDiscoveryResponseApplicationJson_ResourceTypesInterface {
  String get name;
  BuiltList<String> get shareTypes;
  OcmDiscoveryResponseApplicationJson_ResourceTypes_Protocols get protocols;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OcmDiscoveryResponseApplicationJson_ResourceTypesInterfaceBuilder].
  $OcmDiscoveryResponseApplicationJson_ResourceTypesInterface rebuild(
    void Function($OcmDiscoveryResponseApplicationJson_ResourceTypesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OcmDiscoveryResponseApplicationJson_ResourceTypesInterfaceBuilder].
  $OcmDiscoveryResponseApplicationJson_ResourceTypesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OcmDiscoveryResponseApplicationJson_ResourceTypesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OcmDiscoveryResponseApplicationJson_ResourceTypesInterfaceBuilder b) {}
}

abstract class OcmDiscoveryResponseApplicationJson_ResourceTypes
    implements
        $OcmDiscoveryResponseApplicationJson_ResourceTypesInterface,
        Built<OcmDiscoveryResponseApplicationJson_ResourceTypes,
            OcmDiscoveryResponseApplicationJson_ResourceTypesBuilder> {
  /// Creates a new OcmDiscoveryResponseApplicationJson_ResourceTypes object using the builder pattern.
  factory OcmDiscoveryResponseApplicationJson_ResourceTypes([
    void Function(OcmDiscoveryResponseApplicationJson_ResourceTypesBuilder)? b,
  ]) = _$OcmDiscoveryResponseApplicationJson_ResourceTypes;

  // coverage:ignore-start
  const OcmDiscoveryResponseApplicationJson_ResourceTypes._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OcmDiscoveryResponseApplicationJson_ResourceTypes.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OcmDiscoveryResponseApplicationJson_ResourceTypes.
  static Serializer<OcmDiscoveryResponseApplicationJson_ResourceTypes> get serializer =>
      _$ocmDiscoveryResponseApplicationJsonResourceTypesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OcmDiscoveryResponseApplicationJson_ResourceTypesBuilder b) {
    $OcmDiscoveryResponseApplicationJson_ResourceTypesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OcmDiscoveryResponseApplicationJson_ResourceTypesBuilder b) {
    $OcmDiscoveryResponseApplicationJson_ResourceTypesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OcmDiscoveryResponseApplicationJsonInterface {
  bool get enabled;
  String get apiVersion;
  String get endPoint;
  BuiltList<OcmDiscoveryResponseApplicationJson_ResourceTypes> get resourceTypes;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OcmDiscoveryResponseApplicationJsonInterfaceBuilder].
  $OcmDiscoveryResponseApplicationJsonInterface rebuild(
    void Function($OcmDiscoveryResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OcmDiscoveryResponseApplicationJsonInterfaceBuilder].
  $OcmDiscoveryResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OcmDiscoveryResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OcmDiscoveryResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class OcmDiscoveryResponseApplicationJson
    implements
        $OcmDiscoveryResponseApplicationJsonInterface,
        Built<OcmDiscoveryResponseApplicationJson, OcmDiscoveryResponseApplicationJsonBuilder> {
  /// Creates a new OcmDiscoveryResponseApplicationJson object using the builder pattern.
  factory OcmDiscoveryResponseApplicationJson([void Function(OcmDiscoveryResponseApplicationJsonBuilder)? b]) =
      _$OcmDiscoveryResponseApplicationJson;

  // coverage:ignore-start
  const OcmDiscoveryResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OcmDiscoveryResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OcmDiscoveryResponseApplicationJson.
  static Serializer<OcmDiscoveryResponseApplicationJson> get serializer =>
      _$ocmDiscoveryResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OcmDiscoveryResponseApplicationJsonBuilder b) {
    $OcmDiscoveryResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OcmDiscoveryResponseApplicationJsonBuilder b) {
    $OcmDiscoveryResponseApplicationJsonInterface._validate(b);
  }
}

class OcmOcmDiscoveryHeaders_XNextcloudOcmProviders extends EnumClass {
  const OcmOcmDiscoveryHeaders_XNextcloudOcmProviders._(super.name);

  /// `true`
  @BuiltValueEnumConst(wireName: 'true')
  static const OcmOcmDiscoveryHeaders_XNextcloudOcmProviders $true =
      _$ocmOcmDiscoveryHeadersXNextcloudOcmProviders$true;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<OcmOcmDiscoveryHeaders_XNextcloudOcmProviders> get values =>
      _$ocmOcmDiscoveryHeadersXNextcloudOcmProvidersValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static OcmOcmDiscoveryHeaders_XNextcloudOcmProviders valueOf(String name) =>
      _$valueOfOcmOcmDiscoveryHeaders_XNextcloudOcmProviders(name);

  /// Returns the serialized value of this enum value.
  bool get value => _$jsonSerializers.serializeWith(serializer, this)! as bool;

  /// Serializer for OcmOcmDiscoveryHeaders_XNextcloudOcmProviders.
  @BuiltValueSerializer(custom: true)
  static Serializer<OcmOcmDiscoveryHeaders_XNextcloudOcmProviders> get serializer =>
      const _$OcmOcmDiscoveryHeaders_XNextcloudOcmProvidersSerializer();
}

class _$OcmOcmDiscoveryHeaders_XNextcloudOcmProvidersSerializer
    implements PrimitiveSerializer<OcmOcmDiscoveryHeaders_XNextcloudOcmProviders> {
  const _$OcmOcmDiscoveryHeaders_XNextcloudOcmProvidersSerializer();

  static const Map<OcmOcmDiscoveryHeaders_XNextcloudOcmProviders, Object> _toWire =
      <OcmOcmDiscoveryHeaders_XNextcloudOcmProviders, Object>{
    OcmOcmDiscoveryHeaders_XNextcloudOcmProviders.$true: true,
  };

  static const Map<Object, OcmOcmDiscoveryHeaders_XNextcloudOcmProviders> _fromWire =
      <Object, OcmOcmDiscoveryHeaders_XNextcloudOcmProviders>{
    true: OcmOcmDiscoveryHeaders_XNextcloudOcmProviders.$true,
  };

  @override
  Iterable<Type> get types => const [OcmOcmDiscoveryHeaders_XNextcloudOcmProviders];

  @override
  String get wireName => 'OcmOcmDiscoveryHeaders_XNextcloudOcmProviders';

  @override
  Object serialize(
    Serializers serializers,
    OcmOcmDiscoveryHeaders_XNextcloudOcmProviders object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  OcmOcmDiscoveryHeaders_XNextcloudOcmProviders deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $OcmOcmDiscoveryHeadersInterface {
  @BuiltValueField(wireName: 'x-nextcloud-ocm-providers')
  Header<OcmOcmDiscoveryHeaders_XNextcloudOcmProviders?>? get xNextcloudOcmProviders;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OcmOcmDiscoveryHeadersInterfaceBuilder].
  $OcmOcmDiscoveryHeadersInterface rebuild(void Function($OcmOcmDiscoveryHeadersInterfaceBuilder) updates);

  /// Converts the instance to a builder [$OcmOcmDiscoveryHeadersInterfaceBuilder].
  $OcmOcmDiscoveryHeadersInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OcmOcmDiscoveryHeadersInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OcmOcmDiscoveryHeadersInterfaceBuilder b) {}
}

abstract class OcmOcmDiscoveryHeaders
    implements $OcmOcmDiscoveryHeadersInterface, Built<OcmOcmDiscoveryHeaders, OcmOcmDiscoveryHeadersBuilder> {
  /// Creates a new OcmOcmDiscoveryHeaders object using the builder pattern.
  factory OcmOcmDiscoveryHeaders([void Function(OcmOcmDiscoveryHeadersBuilder)? b]) = _$OcmOcmDiscoveryHeaders;

  // coverage:ignore-start
  const OcmOcmDiscoveryHeaders._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OcmOcmDiscoveryHeaders.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OcmOcmDiscoveryHeaders.
  static Serializer<OcmOcmDiscoveryHeaders> get serializer => _$ocmOcmDiscoveryHeadersSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OcmOcmDiscoveryHeadersBuilder b) {
    $OcmOcmDiscoveryHeadersInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OcmOcmDiscoveryHeadersBuilder b) {
    $OcmOcmDiscoveryHeadersInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterface {
  int get major;
  int get minor;
  int get micro;
  String get string;
  String get edition;
  bool get extendedSupport;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterfaceBuilder].
  $OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterface rebuild(
    void Function($OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterfaceBuilder].
  $OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterfaceBuilder b) {}
}

abstract class OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version
    implements
        $OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterface,
        Built<OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version,
            OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionBuilder> {
  /// Creates a new OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version object using the builder pattern.
  factory OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version([
    void Function(OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionBuilder)? b,
  ]) = _$OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version;

  // coverage:ignore-start
  const OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version.
  static Serializer<OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version> get serializer =>
      _$ocsGetCapabilitiesResponseApplicationJsonOcsDataVersionSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionBuilder b) {
    $OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionBuilder b) {
    $OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_VersionInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CoreCapabilities_CoreInterface {
  int get pollinterval;
  @BuiltValueField(wireName: 'webdav-root')
  String get webdavRoot;
  @BuiltValueField(wireName: 'reference-api')
  bool get referenceApi;
  @BuiltValueField(wireName: 'reference-regex')
  String get referenceRegex;
  @BuiltValueField(wireName: 'mod-rewrite-working')
  bool? get modRewriteWorking;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CoreCapabilities_CoreInterfaceBuilder].
  $CoreCapabilities_CoreInterface rebuild(void Function($CoreCapabilities_CoreInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CoreCapabilities_CoreInterfaceBuilder].
  $CoreCapabilities_CoreInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CoreCapabilities_CoreInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CoreCapabilities_CoreInterfaceBuilder b) {}
}

abstract class CoreCapabilities_Core
    implements $CoreCapabilities_CoreInterface, Built<CoreCapabilities_Core, CoreCapabilities_CoreBuilder> {
  /// Creates a new CoreCapabilities_Core object using the builder pattern.
  factory CoreCapabilities_Core([void Function(CoreCapabilities_CoreBuilder)? b]) = _$CoreCapabilities_Core;

  // coverage:ignore-start
  const CoreCapabilities_Core._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CoreCapabilities_Core.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CoreCapabilities_Core.
  static Serializer<CoreCapabilities_Core> get serializer => _$coreCapabilitiesCoreSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CoreCapabilities_CoreBuilder b) {
    $CoreCapabilities_CoreInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CoreCapabilities_CoreBuilder b) {
    $CoreCapabilities_CoreInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CoreCapabilitiesInterface {
  CoreCapabilities_Core get core;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CoreCapabilitiesInterfaceBuilder].
  $CoreCapabilitiesInterface rebuild(void Function($CoreCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CoreCapabilitiesInterfaceBuilder].
  $CoreCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CoreCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CoreCapabilitiesInterfaceBuilder b) {}
}

abstract class CoreCapabilities
    implements $CoreCapabilitiesInterface, Built<CoreCapabilities, CoreCapabilitiesBuilder> {
  /// Creates a new CoreCapabilities object using the builder pattern.
  factory CoreCapabilities([void Function(CoreCapabilitiesBuilder)? b]) = _$CoreCapabilities;

  // coverage:ignore-start
  const CoreCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CoreCapabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CoreCapabilities.
  static Serializer<CoreCapabilities> get serializer => _$coreCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CoreCapabilitiesBuilder b) {
    $CoreCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CoreCapabilitiesBuilder b) {
    $CoreCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CorePublicCapabilities_BruteforceInterface {
  int get delay;
  @BuiltValueField(wireName: 'allow-listed')
  bool get allowListed;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CorePublicCapabilities_BruteforceInterfaceBuilder].
  $CorePublicCapabilities_BruteforceInterface rebuild(
    void Function($CorePublicCapabilities_BruteforceInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$CorePublicCapabilities_BruteforceInterfaceBuilder].
  $CorePublicCapabilities_BruteforceInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CorePublicCapabilities_BruteforceInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CorePublicCapabilities_BruteforceInterfaceBuilder b) {}
}

abstract class CorePublicCapabilities_Bruteforce
    implements
        $CorePublicCapabilities_BruteforceInterface,
        Built<CorePublicCapabilities_Bruteforce, CorePublicCapabilities_BruteforceBuilder> {
  /// Creates a new CorePublicCapabilities_Bruteforce object using the builder pattern.
  factory CorePublicCapabilities_Bruteforce([void Function(CorePublicCapabilities_BruteforceBuilder)? b]) =
      _$CorePublicCapabilities_Bruteforce;

  // coverage:ignore-start
  const CorePublicCapabilities_Bruteforce._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CorePublicCapabilities_Bruteforce.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CorePublicCapabilities_Bruteforce.
  static Serializer<CorePublicCapabilities_Bruteforce> get serializer => _$corePublicCapabilitiesBruteforceSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CorePublicCapabilities_BruteforceBuilder b) {
    $CorePublicCapabilities_BruteforceInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CorePublicCapabilities_BruteforceBuilder b) {
    $CorePublicCapabilities_BruteforceInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CorePublicCapabilitiesInterface {
  CorePublicCapabilities_Bruteforce get bruteforce;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CorePublicCapabilitiesInterfaceBuilder].
  $CorePublicCapabilitiesInterface rebuild(void Function($CorePublicCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CorePublicCapabilitiesInterfaceBuilder].
  $CorePublicCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CorePublicCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CorePublicCapabilitiesInterfaceBuilder b) {}
}

abstract class CorePublicCapabilities
    implements $CorePublicCapabilitiesInterface, Built<CorePublicCapabilities, CorePublicCapabilitiesBuilder> {
  /// Creates a new CorePublicCapabilities object using the builder pattern.
  factory CorePublicCapabilities([void Function(CorePublicCapabilitiesBuilder)? b]) = _$CorePublicCapabilities;

  // coverage:ignore-start
  const CorePublicCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CorePublicCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CorePublicCapabilities.
  static Serializer<CorePublicCapabilities> get serializer => _$corePublicCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CorePublicCapabilitiesBuilder b) {
    $CorePublicCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CorePublicCapabilitiesBuilder b) {
    $CorePublicCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CommentsCapabilities_FilesInterface {
  bool get comments;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CommentsCapabilities_FilesInterfaceBuilder].
  $CommentsCapabilities_FilesInterface rebuild(void Function($CommentsCapabilities_FilesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CommentsCapabilities_FilesInterfaceBuilder].
  $CommentsCapabilities_FilesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CommentsCapabilities_FilesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CommentsCapabilities_FilesInterfaceBuilder b) {}
}

abstract class CommentsCapabilities_Files
    implements
        $CommentsCapabilities_FilesInterface,
        Built<CommentsCapabilities_Files, CommentsCapabilities_FilesBuilder> {
  /// Creates a new CommentsCapabilities_Files object using the builder pattern.
  factory CommentsCapabilities_Files([void Function(CommentsCapabilities_FilesBuilder)? b]) =
      _$CommentsCapabilities_Files;

  // coverage:ignore-start
  const CommentsCapabilities_Files._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CommentsCapabilities_Files.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CommentsCapabilities_Files.
  static Serializer<CommentsCapabilities_Files> get serializer => _$commentsCapabilitiesFilesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CommentsCapabilities_FilesBuilder b) {
    $CommentsCapabilities_FilesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CommentsCapabilities_FilesBuilder b) {
    $CommentsCapabilities_FilesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $CommentsCapabilitiesInterface {
  CommentsCapabilities_Files get files;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CommentsCapabilitiesInterfaceBuilder].
  $CommentsCapabilitiesInterface rebuild(void Function($CommentsCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CommentsCapabilitiesInterfaceBuilder].
  $CommentsCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CommentsCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CommentsCapabilitiesInterfaceBuilder b) {}
}

abstract class CommentsCapabilities
    implements $CommentsCapabilitiesInterface, Built<CommentsCapabilities, CommentsCapabilitiesBuilder> {
  /// Creates a new CommentsCapabilities object using the builder pattern.
  factory CommentsCapabilities([void Function(CommentsCapabilitiesBuilder)? b]) = _$CommentsCapabilities;

  // coverage:ignore-start
  const CommentsCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CommentsCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CommentsCapabilities.
  static Serializer<CommentsCapabilities> get serializer => _$commentsCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CommentsCapabilitiesBuilder b) {
    $CommentsCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CommentsCapabilitiesBuilder b) {
    $CommentsCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DavCapabilities_DavInterface {
  String get chunking;
  String? get bulkupload;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DavCapabilities_DavInterfaceBuilder].
  $DavCapabilities_DavInterface rebuild(void Function($DavCapabilities_DavInterfaceBuilder) updates);

  /// Converts the instance to a builder [$DavCapabilities_DavInterfaceBuilder].
  $DavCapabilities_DavInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DavCapabilities_DavInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DavCapabilities_DavInterfaceBuilder b) {}
}

abstract class DavCapabilities_Dav
    implements $DavCapabilities_DavInterface, Built<DavCapabilities_Dav, DavCapabilities_DavBuilder> {
  /// Creates a new DavCapabilities_Dav object using the builder pattern.
  factory DavCapabilities_Dav([void Function(DavCapabilities_DavBuilder)? b]) = _$DavCapabilities_Dav;

  // coverage:ignore-start
  const DavCapabilities_Dav._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DavCapabilities_Dav.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DavCapabilities_Dav.
  static Serializer<DavCapabilities_Dav> get serializer => _$davCapabilitiesDavSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DavCapabilities_DavBuilder b) {
    $DavCapabilities_DavInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DavCapabilities_DavBuilder b) {
    $DavCapabilities_DavInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DavCapabilitiesInterface {
  DavCapabilities_Dav get dav;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DavCapabilitiesInterfaceBuilder].
  $DavCapabilitiesInterface rebuild(void Function($DavCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$DavCapabilitiesInterfaceBuilder].
  $DavCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DavCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DavCapabilitiesInterfaceBuilder b) {}
}

abstract class DavCapabilities implements $DavCapabilitiesInterface, Built<DavCapabilities, DavCapabilitiesBuilder> {
  /// Creates a new DavCapabilities object using the builder pattern.
  factory DavCapabilities([void Function(DavCapabilitiesBuilder)? b]) = _$DavCapabilities;

  // coverage:ignore-start
  const DavCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DavCapabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DavCapabilities.
  static Serializer<DavCapabilities> get serializer => _$davCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DavCapabilitiesBuilder b) {
    $DavCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DavCapabilitiesBuilder b) {
    $DavCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DropAccountCapabilities_DropAccount_DelayInterface {
  bool get enabled;
  int get hours;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DropAccountCapabilities_DropAccount_DelayInterfaceBuilder].
  $DropAccountCapabilities_DropAccount_DelayInterface rebuild(
    void Function($DropAccountCapabilities_DropAccount_DelayInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DropAccountCapabilities_DropAccount_DelayInterfaceBuilder].
  $DropAccountCapabilities_DropAccount_DelayInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DropAccountCapabilities_DropAccount_DelayInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DropAccountCapabilities_DropAccount_DelayInterfaceBuilder b) {}
}

abstract class DropAccountCapabilities_DropAccount_Delay
    implements
        $DropAccountCapabilities_DropAccount_DelayInterface,
        Built<DropAccountCapabilities_DropAccount_Delay, DropAccountCapabilities_DropAccount_DelayBuilder> {
  /// Creates a new DropAccountCapabilities_DropAccount_Delay object using the builder pattern.
  factory DropAccountCapabilities_DropAccount_Delay([
    void Function(DropAccountCapabilities_DropAccount_DelayBuilder)? b,
  ]) = _$DropAccountCapabilities_DropAccount_Delay;

  // coverage:ignore-start
  const DropAccountCapabilities_DropAccount_Delay._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DropAccountCapabilities_DropAccount_Delay.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DropAccountCapabilities_DropAccount_Delay.
  static Serializer<DropAccountCapabilities_DropAccount_Delay> get serializer =>
      _$dropAccountCapabilitiesDropAccountDelaySerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DropAccountCapabilities_DropAccount_DelayBuilder b) {
    $DropAccountCapabilities_DropAccount_DelayInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DropAccountCapabilities_DropAccount_DelayBuilder b) {
    $DropAccountCapabilities_DropAccount_DelayInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DropAccountCapabilities_DropAccountInterface {
  bool get enabled;
  @BuiltValueField(wireName: 'api-version')
  String get apiVersion;
  DropAccountCapabilities_DropAccount_Delay get delay;
  String? get details;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DropAccountCapabilities_DropAccountInterfaceBuilder].
  $DropAccountCapabilities_DropAccountInterface rebuild(
    void Function($DropAccountCapabilities_DropAccountInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$DropAccountCapabilities_DropAccountInterfaceBuilder].
  $DropAccountCapabilities_DropAccountInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DropAccountCapabilities_DropAccountInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DropAccountCapabilities_DropAccountInterfaceBuilder b) {}
}

abstract class DropAccountCapabilities_DropAccount
    implements
        $DropAccountCapabilities_DropAccountInterface,
        Built<DropAccountCapabilities_DropAccount, DropAccountCapabilities_DropAccountBuilder> {
  /// Creates a new DropAccountCapabilities_DropAccount object using the builder pattern.
  factory DropAccountCapabilities_DropAccount([void Function(DropAccountCapabilities_DropAccountBuilder)? b]) =
      _$DropAccountCapabilities_DropAccount;

  // coverage:ignore-start
  const DropAccountCapabilities_DropAccount._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DropAccountCapabilities_DropAccount.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DropAccountCapabilities_DropAccount.
  static Serializer<DropAccountCapabilities_DropAccount> get serializer =>
      _$dropAccountCapabilitiesDropAccountSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DropAccountCapabilities_DropAccountBuilder b) {
    $DropAccountCapabilities_DropAccountInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DropAccountCapabilities_DropAccountBuilder b) {
    $DropAccountCapabilities_DropAccountInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $DropAccountCapabilitiesInterface {
  @BuiltValueField(wireName: 'drop-account')
  DropAccountCapabilities_DropAccount get dropAccount;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$DropAccountCapabilitiesInterfaceBuilder].
  $DropAccountCapabilitiesInterface rebuild(void Function($DropAccountCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$DropAccountCapabilitiesInterfaceBuilder].
  $DropAccountCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($DropAccountCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($DropAccountCapabilitiesInterfaceBuilder b) {}
}

abstract class DropAccountCapabilities
    implements $DropAccountCapabilitiesInterface, Built<DropAccountCapabilities, DropAccountCapabilitiesBuilder> {
  /// Creates a new DropAccountCapabilities object using the builder pattern.
  factory DropAccountCapabilities([void Function(DropAccountCapabilitiesBuilder)? b]) = _$DropAccountCapabilities;

  // coverage:ignore-start
  const DropAccountCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory DropAccountCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for DropAccountCapabilities.
  static Serializer<DropAccountCapabilities> get serializer => _$dropAccountCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(DropAccountCapabilitiesBuilder b) {
    $DropAccountCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(DropAccountCapabilitiesBuilder b) {
    $DropAccountCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesCapabilities_Files_DirectEditingInterface {
  String get url;
  String get etag;
  bool get supportsFileId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesCapabilities_Files_DirectEditingInterfaceBuilder].
  $FilesCapabilities_Files_DirectEditingInterface rebuild(
    void Function($FilesCapabilities_Files_DirectEditingInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesCapabilities_Files_DirectEditingInterfaceBuilder].
  $FilesCapabilities_Files_DirectEditingInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesCapabilities_Files_DirectEditingInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesCapabilities_Files_DirectEditingInterfaceBuilder b) {}
}

abstract class FilesCapabilities_Files_DirectEditing
    implements
        $FilesCapabilities_Files_DirectEditingInterface,
        Built<FilesCapabilities_Files_DirectEditing, FilesCapabilities_Files_DirectEditingBuilder> {
  /// Creates a new FilesCapabilities_Files_DirectEditing object using the builder pattern.
  factory FilesCapabilities_Files_DirectEditing([void Function(FilesCapabilities_Files_DirectEditingBuilder)? b]) =
      _$FilesCapabilities_Files_DirectEditing;

  // coverage:ignore-start
  const FilesCapabilities_Files_DirectEditing._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesCapabilities_Files_DirectEditing.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesCapabilities_Files_DirectEditing.
  static Serializer<FilesCapabilities_Files_DirectEditing> get serializer =>
      _$filesCapabilitiesFilesDirectEditingSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesCapabilities_Files_DirectEditingBuilder b) {
    $FilesCapabilities_Files_DirectEditingInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesCapabilities_Files_DirectEditingBuilder b) {
    $FilesCapabilities_Files_DirectEditingInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesCapabilities_FilesInterface {
  @BuiltValueField(wireName: r'$comment')
  String? get comment;
  bool get bigfilechunking;
  @BuiltValueField(wireName: 'blacklisted_files')
  BuiltList<JsonObject> get blacklistedFiles;
  @BuiltValueField(wireName: 'forbidden_filenames')
  BuiltList<String> get forbiddenFilenames;
  @BuiltValueField(wireName: 'forbidden_filename_basenames')
  BuiltList<String> get forbiddenFilenameBasenames;
  @BuiltValueField(wireName: 'forbidden_filename_characters')
  BuiltList<String> get forbiddenFilenameCharacters;
  @BuiltValueField(wireName: 'forbidden_filename_extensions')
  BuiltList<String> get forbiddenFilenameExtensions;
  FilesCapabilities_Files_DirectEditing get directEditing;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesCapabilities_FilesInterfaceBuilder].
  $FilesCapabilities_FilesInterface rebuild(void Function($FilesCapabilities_FilesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$FilesCapabilities_FilesInterfaceBuilder].
  $FilesCapabilities_FilesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesCapabilities_FilesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesCapabilities_FilesInterfaceBuilder b) {}
}

abstract class FilesCapabilities_Files
    implements $FilesCapabilities_FilesInterface, Built<FilesCapabilities_Files, FilesCapabilities_FilesBuilder> {
  /// Creates a new FilesCapabilities_Files object using the builder pattern.
  factory FilesCapabilities_Files([void Function(FilesCapabilities_FilesBuilder)? b]) = _$FilesCapabilities_Files;

  // coverage:ignore-start
  const FilesCapabilities_Files._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesCapabilities_Files.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesCapabilities_Files.
  static Serializer<FilesCapabilities_Files> get serializer => _$filesCapabilitiesFilesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesCapabilities_FilesBuilder b) {
    $FilesCapabilities_FilesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesCapabilities_FilesBuilder b) {
    $FilesCapabilities_FilesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesCapabilitiesInterface {
  FilesCapabilities_Files get files;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesCapabilitiesInterfaceBuilder].
  $FilesCapabilitiesInterface rebuild(void Function($FilesCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$FilesCapabilitiesInterfaceBuilder].
  $FilesCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesCapabilitiesInterfaceBuilder b) {}
}

abstract class FilesCapabilities
    implements $FilesCapabilitiesInterface, Built<FilesCapabilities, FilesCapabilitiesBuilder> {
  /// Creates a new FilesCapabilities object using the builder pattern.
  factory FilesCapabilities([void Function(FilesCapabilitiesBuilder)? b]) = _$FilesCapabilities;

  // coverage:ignore-start
  const FilesCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesCapabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesCapabilities.
  static Serializer<FilesCapabilities> get serializer => _$filesCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesCapabilitiesBuilder b) {
    $FilesCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesCapabilitiesBuilder b) {
    $FilesCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_Public_PasswordInterface {
  bool get enforced;
  bool get askForOptionalPassword;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_Public_PasswordInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Public_PasswordInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_Public_PasswordInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_Public_PasswordInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Public_PasswordInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_Public_PasswordInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_Public_PasswordInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Public_Password
    implements
        $FilesSharingCapabilities_FilesSharing_Public_PasswordInterface,
        Built<FilesSharingCapabilities_FilesSharing_Public_Password,
            FilesSharingCapabilities_FilesSharing_Public_PasswordBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Public_Password object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Public_Password([
    void Function(FilesSharingCapabilities_FilesSharing_Public_PasswordBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Public_Password;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Public_Password._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Public_Password.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Public_Password.
  static Serializer<FilesSharingCapabilities_FilesSharing_Public_Password> get serializer =>
      _$filesSharingCapabilitiesFilesSharingPublicPasswordSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_Public_PasswordBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Public_PasswordInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_Public_PasswordBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Public_PasswordInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterface {
  bool get enabled;
  int? get days;
  bool? get enforced;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Public_ExpireDate
    implements
        $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterface,
        Built<FilesSharingCapabilities_FilesSharing_Public_ExpireDate,
            FilesSharingCapabilities_FilesSharing_Public_ExpireDateBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Public_ExpireDate object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Public_ExpireDate([
    void Function(FilesSharingCapabilities_FilesSharing_Public_ExpireDateBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Public_ExpireDate;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Public_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Public_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Public_ExpireDate.
  static Serializer<FilesSharingCapabilities_FilesSharing_Public_ExpireDate> get serializer =>
      _$filesSharingCapabilitiesFilesSharingPublicExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_Public_ExpireDateBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_Public_ExpireDateBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterface {
  bool get enabled;
  int? get days;
  bool? get enforced;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal
    implements
        $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterface,
        Built<FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal,
            FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal([
    void Function(FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal.
  static Serializer<FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal> get serializer =>
      _$filesSharingCapabilitiesFilesSharingPublicExpireDateInternalSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternalInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterface {
  bool get enabled;
  int? get days;
  bool? get enforced;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote
    implements
        $FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterface,
        Built<FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote,
            FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote([
    void Function(FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote.
  static Serializer<FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote> get serializer =>
      _$filesSharingCapabilitiesFilesSharingPublicExpireDateRemoteSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemoteInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_PublicInterface {
  bool get enabled;
  FilesSharingCapabilities_FilesSharing_Public_Password? get password;
  @BuiltValueField(wireName: 'multiple_links')
  bool? get multipleLinks;
  @BuiltValueField(wireName: 'expire_date')
  FilesSharingCapabilities_FilesSharing_Public_ExpireDate? get expireDate;
  @BuiltValueField(wireName: 'expire_date_internal')
  FilesSharingCapabilities_FilesSharing_Public_ExpireDateInternal? get expireDateInternal;
  @BuiltValueField(wireName: 'expire_date_remote')
  FilesSharingCapabilities_FilesSharing_Public_ExpireDateRemote? get expireDateRemote;
  @BuiltValueField(wireName: 'send_mail')
  bool? get sendMail;
  bool? get upload;
  @BuiltValueField(wireName: 'upload_files_drop')
  bool? get uploadFilesDrop;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_PublicInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_PublicInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_PublicInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_PublicInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_PublicInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_PublicInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_PublicInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Public
    implements
        $FilesSharingCapabilities_FilesSharing_PublicInterface,
        Built<FilesSharingCapabilities_FilesSharing_Public, FilesSharingCapabilities_FilesSharing_PublicBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Public object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Public([
    void Function(FilesSharingCapabilities_FilesSharing_PublicBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Public;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Public._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Public.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Public.
  static Serializer<FilesSharingCapabilities_FilesSharing_Public> get serializer =>
      _$filesSharingCapabilitiesFilesSharingPublicSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_PublicBuilder b) {
    $FilesSharingCapabilities_FilesSharing_PublicInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_PublicBuilder b) {
    $FilesSharingCapabilities_FilesSharing_PublicInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_User_ExpireDateInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_User_ExpireDateInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_User_ExpireDateInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_User_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_User_ExpireDateInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_User_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_User_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_User_ExpireDateInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_User_ExpireDate
    implements
        $FilesSharingCapabilities_FilesSharing_User_ExpireDateInterface,
        Built<FilesSharingCapabilities_FilesSharing_User_ExpireDate,
            FilesSharingCapabilities_FilesSharing_User_ExpireDateBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_User_ExpireDate object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_User_ExpireDate([
    void Function(FilesSharingCapabilities_FilesSharing_User_ExpireDateBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_User_ExpireDate;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_User_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_User_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_User_ExpireDate.
  static Serializer<FilesSharingCapabilities_FilesSharing_User_ExpireDate> get serializer =>
      _$filesSharingCapabilitiesFilesSharingUserExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_User_ExpireDateBuilder b) {
    $FilesSharingCapabilities_FilesSharing_User_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_User_ExpireDateBuilder b) {
    $FilesSharingCapabilities_FilesSharing_User_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_UserInterface {
  @BuiltValueField(wireName: 'send_mail')
  bool get sendMail;
  @BuiltValueField(wireName: 'expire_date')
  FilesSharingCapabilities_FilesSharing_User_ExpireDate? get expireDate;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_UserInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_UserInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_UserInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_UserInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_UserInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_UserInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_UserInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_User
    implements
        $FilesSharingCapabilities_FilesSharing_UserInterface,
        Built<FilesSharingCapabilities_FilesSharing_User, FilesSharingCapabilities_FilesSharing_UserBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_User object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_User([
    void Function(FilesSharingCapabilities_FilesSharing_UserBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_User;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_User._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_User.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_User.
  static Serializer<FilesSharingCapabilities_FilesSharing_User> get serializer =>
      _$filesSharingCapabilitiesFilesSharingUserSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_UserBuilder b) {
    $FilesSharingCapabilities_FilesSharing_UserInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_UserBuilder b) {
    $FilesSharingCapabilities_FilesSharing_UserInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Group_ExpireDate
    implements
        $FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterface,
        Built<FilesSharingCapabilities_FilesSharing_Group_ExpireDate,
            FilesSharingCapabilities_FilesSharing_Group_ExpireDateBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Group_ExpireDate object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Group_ExpireDate([
    void Function(FilesSharingCapabilities_FilesSharing_Group_ExpireDateBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Group_ExpireDate;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Group_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Group_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Group_ExpireDate.
  static Serializer<FilesSharingCapabilities_FilesSharing_Group_ExpireDate> get serializer =>
      _$filesSharingCapabilitiesFilesSharingGroupExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_Group_ExpireDateBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_Group_ExpireDateBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Group_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_GroupInterface {
  bool get enabled;
  @BuiltValueField(wireName: 'expire_date')
  FilesSharingCapabilities_FilesSharing_Group_ExpireDate? get expireDate;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_GroupInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_GroupInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_GroupInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_GroupInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_GroupInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_GroupInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_GroupInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Group
    implements
        $FilesSharingCapabilities_FilesSharing_GroupInterface,
        Built<FilesSharingCapabilities_FilesSharing_Group, FilesSharingCapabilities_FilesSharing_GroupBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Group object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Group([
    void Function(FilesSharingCapabilities_FilesSharing_GroupBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Group;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Group._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Group.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Group.
  static Serializer<FilesSharingCapabilities_FilesSharing_Group> get serializer =>
      _$filesSharingCapabilitiesFilesSharingGroupSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_GroupBuilder b) {
    $FilesSharingCapabilities_FilesSharing_GroupInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_GroupBuilder b) {
    $FilesSharingCapabilities_FilesSharing_GroupInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Federation_ExpireDate
    implements
        $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterface,
        Built<FilesSharingCapabilities_FilesSharing_Federation_ExpireDate,
            FilesSharingCapabilities_FilesSharing_Federation_ExpireDateBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Federation_ExpireDate object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Federation_ExpireDate([
    void Function(FilesSharingCapabilities_FilesSharing_Federation_ExpireDateBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Federation_ExpireDate;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Federation_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Federation_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Federation_ExpireDate.
  static Serializer<FilesSharingCapabilities_FilesSharing_Federation_ExpireDate> get serializer =>
      _$filesSharingCapabilitiesFilesSharingFederationExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_Federation_ExpireDateBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_Federation_ExpireDateBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported
    implements
        $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterface,
        Built<FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported,
            FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported([
    void Function(FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported.
  static Serializer<FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported> get serializer =>
      _$filesSharingCapabilitiesFilesSharingFederationExpireDateSupportedSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedBuilder b) {
    $FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupportedInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_FederationInterface {
  bool get outgoing;
  bool get incoming;
  @BuiltValueField(wireName: 'expire_date')
  FilesSharingCapabilities_FilesSharing_Federation_ExpireDate get expireDate;
  @BuiltValueField(wireName: 'expire_date_supported')
  FilesSharingCapabilities_FilesSharing_Federation_ExpireDateSupported get expireDateSupported;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_FederationInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_FederationInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_FederationInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_FederationInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_FederationInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_FederationInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_FederationInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Federation
    implements
        $FilesSharingCapabilities_FilesSharing_FederationInterface,
        Built<FilesSharingCapabilities_FilesSharing_Federation,
            FilesSharingCapabilities_FilesSharing_FederationBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Federation object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Federation([
    void Function(FilesSharingCapabilities_FilesSharing_FederationBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Federation;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Federation._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Federation.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Federation.
  static Serializer<FilesSharingCapabilities_FilesSharing_Federation> get serializer =>
      _$filesSharingCapabilitiesFilesSharingFederationSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_FederationBuilder b) {
    $FilesSharingCapabilities_FilesSharing_FederationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_FederationBuilder b) {
    $FilesSharingCapabilities_FilesSharing_FederationInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharing_ShareeInterface {
  @BuiltValueField(wireName: 'query_lookup_default')
  bool get queryLookupDefault;
  @BuiltValueField(wireName: 'always_show_unique')
  bool get alwaysShowUnique;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharing_ShareeInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_ShareeInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharing_ShareeInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharing_ShareeInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharing_ShareeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharing_ShareeInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharing_ShareeInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing_Sharee
    implements
        $FilesSharingCapabilities_FilesSharing_ShareeInterface,
        Built<FilesSharingCapabilities_FilesSharing_Sharee, FilesSharingCapabilities_FilesSharing_ShareeBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing_Sharee object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing_Sharee([
    void Function(FilesSharingCapabilities_FilesSharing_ShareeBuilder)? b,
  ]) = _$FilesSharingCapabilities_FilesSharing_Sharee;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing_Sharee._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing_Sharee.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing_Sharee.
  static Serializer<FilesSharingCapabilities_FilesSharing_Sharee> get serializer =>
      _$filesSharingCapabilitiesFilesSharingShareeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharing_ShareeBuilder b) {
    $FilesSharingCapabilities_FilesSharing_ShareeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharing_ShareeBuilder b) {
    $FilesSharingCapabilities_FilesSharing_ShareeInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilities_FilesSharingInterface {
  @BuiltValueField(wireName: 'api_enabled')
  bool get apiEnabled;
  FilesSharingCapabilities_FilesSharing_Public get public;
  FilesSharingCapabilities_FilesSharing_User get user;
  bool get resharing;
  @BuiltValueField(wireName: 'group_sharing')
  bool? get groupSharing;
  FilesSharingCapabilities_FilesSharing_Group? get group;
  @BuiltValueField(wireName: 'default_permissions')
  int? get defaultPermissions;
  FilesSharingCapabilities_FilesSharing_Federation get federation;
  FilesSharingCapabilities_FilesSharing_Sharee get sharee;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilities_FilesSharingInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharingInterface rebuild(
    void Function($FilesSharingCapabilities_FilesSharingInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesSharingCapabilities_FilesSharingInterfaceBuilder].
  $FilesSharingCapabilities_FilesSharingInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilities_FilesSharingInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilities_FilesSharingInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities_FilesSharing
    implements
        $FilesSharingCapabilities_FilesSharingInterface,
        Built<FilesSharingCapabilities_FilesSharing, FilesSharingCapabilities_FilesSharingBuilder> {
  /// Creates a new FilesSharingCapabilities_FilesSharing object using the builder pattern.
  factory FilesSharingCapabilities_FilesSharing([void Function(FilesSharingCapabilities_FilesSharingBuilder)? b]) =
      _$FilesSharingCapabilities_FilesSharing;

  // coverage:ignore-start
  const FilesSharingCapabilities_FilesSharing._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities_FilesSharing.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities_FilesSharing.
  static Serializer<FilesSharingCapabilities_FilesSharing> get serializer =>
      _$filesSharingCapabilitiesFilesSharingSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilities_FilesSharingBuilder b) {
    $FilesSharingCapabilities_FilesSharingInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilities_FilesSharingBuilder b) {
    $FilesSharingCapabilities_FilesSharingInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesSharingCapabilitiesInterface {
  @BuiltValueField(wireName: 'files_sharing')
  FilesSharingCapabilities_FilesSharing get filesSharing;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesSharingCapabilitiesInterfaceBuilder].
  $FilesSharingCapabilitiesInterface rebuild(void Function($FilesSharingCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$FilesSharingCapabilitiesInterfaceBuilder].
  $FilesSharingCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesSharingCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesSharingCapabilitiesInterfaceBuilder b) {}
}

abstract class FilesSharingCapabilities
    implements $FilesSharingCapabilitiesInterface, Built<FilesSharingCapabilities, FilesSharingCapabilitiesBuilder> {
  /// Creates a new FilesSharingCapabilities object using the builder pattern.
  factory FilesSharingCapabilities([void Function(FilesSharingCapabilitiesBuilder)? b]) = _$FilesSharingCapabilities;

  // coverage:ignore-start
  const FilesSharingCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesSharingCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesSharingCapabilities.
  static Serializer<FilesSharingCapabilities> get serializer => _$filesSharingCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesSharingCapabilitiesBuilder b) {
    $FilesSharingCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesSharingCapabilitiesBuilder b) {
    $FilesSharingCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesTrashbinCapabilities_FilesInterface {
  bool get undelete;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesTrashbinCapabilities_FilesInterfaceBuilder].
  $FilesTrashbinCapabilities_FilesInterface rebuild(
    void Function($FilesTrashbinCapabilities_FilesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesTrashbinCapabilities_FilesInterfaceBuilder].
  $FilesTrashbinCapabilities_FilesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesTrashbinCapabilities_FilesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesTrashbinCapabilities_FilesInterfaceBuilder b) {}
}

abstract class FilesTrashbinCapabilities_Files
    implements
        $FilesTrashbinCapabilities_FilesInterface,
        Built<FilesTrashbinCapabilities_Files, FilesTrashbinCapabilities_FilesBuilder> {
  /// Creates a new FilesTrashbinCapabilities_Files object using the builder pattern.
  factory FilesTrashbinCapabilities_Files([void Function(FilesTrashbinCapabilities_FilesBuilder)? b]) =
      _$FilesTrashbinCapabilities_Files;

  // coverage:ignore-start
  const FilesTrashbinCapabilities_Files._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesTrashbinCapabilities_Files.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesTrashbinCapabilities_Files.
  static Serializer<FilesTrashbinCapabilities_Files> get serializer => _$filesTrashbinCapabilitiesFilesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesTrashbinCapabilities_FilesBuilder b) {
    $FilesTrashbinCapabilities_FilesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesTrashbinCapabilities_FilesBuilder b) {
    $FilesTrashbinCapabilities_FilesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesTrashbinCapabilitiesInterface {
  FilesTrashbinCapabilities_Files get files;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesTrashbinCapabilitiesInterfaceBuilder].
  $FilesTrashbinCapabilitiesInterface rebuild(void Function($FilesTrashbinCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$FilesTrashbinCapabilitiesInterfaceBuilder].
  $FilesTrashbinCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesTrashbinCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesTrashbinCapabilitiesInterfaceBuilder b) {}
}

abstract class FilesTrashbinCapabilities
    implements $FilesTrashbinCapabilitiesInterface, Built<FilesTrashbinCapabilities, FilesTrashbinCapabilitiesBuilder> {
  /// Creates a new FilesTrashbinCapabilities object using the builder pattern.
  factory FilesTrashbinCapabilities([void Function(FilesTrashbinCapabilitiesBuilder)? b]) = _$FilesTrashbinCapabilities;

  // coverage:ignore-start
  const FilesTrashbinCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesTrashbinCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesTrashbinCapabilities.
  static Serializer<FilesTrashbinCapabilities> get serializer => _$filesTrashbinCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesTrashbinCapabilitiesBuilder b) {
    $FilesTrashbinCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesTrashbinCapabilitiesBuilder b) {
    $FilesTrashbinCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesVersionsCapabilities_FilesInterface {
  bool get versioning;
  @BuiltValueField(wireName: 'version_labeling')
  bool get versionLabeling;
  @BuiltValueField(wireName: 'version_deletion')
  bool get versionDeletion;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesVersionsCapabilities_FilesInterfaceBuilder].
  $FilesVersionsCapabilities_FilesInterface rebuild(
    void Function($FilesVersionsCapabilities_FilesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$FilesVersionsCapabilities_FilesInterfaceBuilder].
  $FilesVersionsCapabilities_FilesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesVersionsCapabilities_FilesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesVersionsCapabilities_FilesInterfaceBuilder b) {}
}

abstract class FilesVersionsCapabilities_Files
    implements
        $FilesVersionsCapabilities_FilesInterface,
        Built<FilesVersionsCapabilities_Files, FilesVersionsCapabilities_FilesBuilder> {
  /// Creates a new FilesVersionsCapabilities_Files object using the builder pattern.
  factory FilesVersionsCapabilities_Files([void Function(FilesVersionsCapabilities_FilesBuilder)? b]) =
      _$FilesVersionsCapabilities_Files;

  // coverage:ignore-start
  const FilesVersionsCapabilities_Files._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesVersionsCapabilities_Files.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesVersionsCapabilities_Files.
  static Serializer<FilesVersionsCapabilities_Files> get serializer => _$filesVersionsCapabilitiesFilesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesVersionsCapabilities_FilesBuilder b) {
    $FilesVersionsCapabilities_FilesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesVersionsCapabilities_FilesBuilder b) {
    $FilesVersionsCapabilities_FilesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $FilesVersionsCapabilitiesInterface {
  FilesVersionsCapabilities_Files get files;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$FilesVersionsCapabilitiesInterfaceBuilder].
  $FilesVersionsCapabilitiesInterface rebuild(void Function($FilesVersionsCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$FilesVersionsCapabilitiesInterfaceBuilder].
  $FilesVersionsCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($FilesVersionsCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($FilesVersionsCapabilitiesInterfaceBuilder b) {}
}

abstract class FilesVersionsCapabilities
    implements $FilesVersionsCapabilitiesInterface, Built<FilesVersionsCapabilities, FilesVersionsCapabilitiesBuilder> {
  /// Creates a new FilesVersionsCapabilities object using the builder pattern.
  factory FilesVersionsCapabilities([void Function(FilesVersionsCapabilitiesBuilder)? b]) = _$FilesVersionsCapabilities;

  // coverage:ignore-start
  const FilesVersionsCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory FilesVersionsCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for FilesVersionsCapabilities.
  static Serializer<FilesVersionsCapabilities> get serializer => _$filesVersionsCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(FilesVersionsCapabilitiesBuilder b) {
    $FilesVersionsCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(FilesVersionsCapabilitiesBuilder b) {
    $FilesVersionsCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NotificationsCapabilities_NotificationsInterface {
  @BuiltValueField(wireName: 'ocs-endpoints')
  BuiltList<String> get ocsEndpoints;
  BuiltList<String> get push;
  @BuiltValueField(wireName: 'admin-notifications')
  BuiltList<String> get adminNotifications;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NotificationsCapabilities_NotificationsInterfaceBuilder].
  $NotificationsCapabilities_NotificationsInterface rebuild(
    void Function($NotificationsCapabilities_NotificationsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$NotificationsCapabilities_NotificationsInterfaceBuilder].
  $NotificationsCapabilities_NotificationsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NotificationsCapabilities_NotificationsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NotificationsCapabilities_NotificationsInterfaceBuilder b) {}
}

abstract class NotificationsCapabilities_Notifications
    implements
        $NotificationsCapabilities_NotificationsInterface,
        Built<NotificationsCapabilities_Notifications, NotificationsCapabilities_NotificationsBuilder> {
  /// Creates a new NotificationsCapabilities_Notifications object using the builder pattern.
  factory NotificationsCapabilities_Notifications([void Function(NotificationsCapabilities_NotificationsBuilder)? b]) =
      _$NotificationsCapabilities_Notifications;

  // coverage:ignore-start
  const NotificationsCapabilities_Notifications._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NotificationsCapabilities_Notifications.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NotificationsCapabilities_Notifications.
  static Serializer<NotificationsCapabilities_Notifications> get serializer =>
      _$notificationsCapabilitiesNotificationsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NotificationsCapabilities_NotificationsBuilder b) {
    $NotificationsCapabilities_NotificationsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NotificationsCapabilities_NotificationsBuilder b) {
    $NotificationsCapabilities_NotificationsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NotificationsCapabilitiesInterface {
  NotificationsCapabilities_Notifications get notifications;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NotificationsCapabilitiesInterfaceBuilder].
  $NotificationsCapabilitiesInterface rebuild(void Function($NotificationsCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$NotificationsCapabilitiesInterfaceBuilder].
  $NotificationsCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NotificationsCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NotificationsCapabilitiesInterfaceBuilder b) {}
}

abstract class NotificationsCapabilities
    implements $NotificationsCapabilitiesInterface, Built<NotificationsCapabilities, NotificationsCapabilitiesBuilder> {
  /// Creates a new NotificationsCapabilities object using the builder pattern.
  factory NotificationsCapabilities([void Function(NotificationsCapabilitiesBuilder)? b]) = _$NotificationsCapabilities;

  // coverage:ignore-start
  const NotificationsCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NotificationsCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NotificationsCapabilities.
  static Serializer<NotificationsCapabilities> get serializer => _$notificationsCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NotificationsCapabilitiesBuilder b) {
    $NotificationsCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NotificationsCapabilitiesBuilder b) {
    $NotificationsCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ProvisioningApiCapabilities_ProvisioningApiInterface {
  String get version;
  @BuiltValueField(wireName: 'AccountPropertyScopesVersion')
  int get accountPropertyScopesVersion;
  @BuiltValueField(wireName: 'AccountPropertyScopesFederatedEnabled')
  bool get accountPropertyScopesFederatedEnabled;
  @BuiltValueField(wireName: 'AccountPropertyScopesPublishedEnabled')
  bool get accountPropertyScopesPublishedEnabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ProvisioningApiCapabilities_ProvisioningApiInterfaceBuilder].
  $ProvisioningApiCapabilities_ProvisioningApiInterface rebuild(
    void Function($ProvisioningApiCapabilities_ProvisioningApiInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ProvisioningApiCapabilities_ProvisioningApiInterfaceBuilder].
  $ProvisioningApiCapabilities_ProvisioningApiInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ProvisioningApiCapabilities_ProvisioningApiInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ProvisioningApiCapabilities_ProvisioningApiInterfaceBuilder b) {}
}

abstract class ProvisioningApiCapabilities_ProvisioningApi
    implements
        $ProvisioningApiCapabilities_ProvisioningApiInterface,
        Built<ProvisioningApiCapabilities_ProvisioningApi, ProvisioningApiCapabilities_ProvisioningApiBuilder> {
  /// Creates a new ProvisioningApiCapabilities_ProvisioningApi object using the builder pattern.
  factory ProvisioningApiCapabilities_ProvisioningApi([
    void Function(ProvisioningApiCapabilities_ProvisioningApiBuilder)? b,
  ]) = _$ProvisioningApiCapabilities_ProvisioningApi;

  // coverage:ignore-start
  const ProvisioningApiCapabilities_ProvisioningApi._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ProvisioningApiCapabilities_ProvisioningApi.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ProvisioningApiCapabilities_ProvisioningApi.
  static Serializer<ProvisioningApiCapabilities_ProvisioningApi> get serializer =>
      _$provisioningApiCapabilitiesProvisioningApiSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ProvisioningApiCapabilities_ProvisioningApiBuilder b) {
    $ProvisioningApiCapabilities_ProvisioningApiInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ProvisioningApiCapabilities_ProvisioningApiBuilder b) {
    $ProvisioningApiCapabilities_ProvisioningApiInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ProvisioningApiCapabilitiesInterface {
  @BuiltValueField(wireName: 'provisioning_api')
  ProvisioningApiCapabilities_ProvisioningApi get provisioningApi;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ProvisioningApiCapabilitiesInterfaceBuilder].
  $ProvisioningApiCapabilitiesInterface rebuild(void Function($ProvisioningApiCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ProvisioningApiCapabilitiesInterfaceBuilder].
  $ProvisioningApiCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ProvisioningApiCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ProvisioningApiCapabilitiesInterfaceBuilder b) {}
}

abstract class ProvisioningApiCapabilities
    implements
        $ProvisioningApiCapabilitiesInterface,
        Built<ProvisioningApiCapabilities, ProvisioningApiCapabilitiesBuilder> {
  /// Creates a new ProvisioningApiCapabilities object using the builder pattern.
  factory ProvisioningApiCapabilities([void Function(ProvisioningApiCapabilitiesBuilder)? b]) =
      _$ProvisioningApiCapabilities;

  // coverage:ignore-start
  const ProvisioningApiCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ProvisioningApiCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ProvisioningApiCapabilities.
  static Serializer<ProvisioningApiCapabilities> get serializer => _$provisioningApiCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ProvisioningApiCapabilitiesBuilder b) {
    $ProvisioningApiCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ProvisioningApiCapabilitiesBuilder b) {
    $ProvisioningApiCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterface rebuild(
    void Function($SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterfaceBuilder b) {}
}

abstract class SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop
    implements
        $SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterface,
        Built<SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop,
            SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropBuilder> {
  /// Creates a new SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop object using the builder pattern.
  factory SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop([
    void Function(SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropBuilder)? b,
  ]) = _$SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop;

  // coverage:ignore-start
  const SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop.
  static Serializer<SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop> get serializer =>
      _$sharebymailCapabilities0FilesSharingSharebymailUploadFilesDropSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropBuilder b) {
    $SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropBuilder b) {
    $SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDropInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterface {
  bool get enabled;
  bool get enforced;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterface rebuild(
    void Function($SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterfaceBuilder b) {}
}

abstract class SharebymailCapabilities0_FilesSharing_Sharebymail_Password
    implements
        $SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterface,
        Built<SharebymailCapabilities0_FilesSharing_Sharebymail_Password,
            SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordBuilder> {
  /// Creates a new SharebymailCapabilities0_FilesSharing_Sharebymail_Password object using the builder pattern.
  factory SharebymailCapabilities0_FilesSharing_Sharebymail_Password([
    void Function(SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordBuilder)? b,
  ]) = _$SharebymailCapabilities0_FilesSharing_Sharebymail_Password;

  // coverage:ignore-start
  const SharebymailCapabilities0_FilesSharing_Sharebymail_Password._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SharebymailCapabilities0_FilesSharing_Sharebymail_Password.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SharebymailCapabilities0_FilesSharing_Sharebymail_Password.
  static Serializer<SharebymailCapabilities0_FilesSharing_Sharebymail_Password> get serializer =>
      _$sharebymailCapabilities0FilesSharingSharebymailPasswordSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordBuilder b) {
    $SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordBuilder b) {
    $SharebymailCapabilities0_FilesSharing_Sharebymail_PasswordInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterface {
  bool get enabled;
  bool get enforced;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterface rebuild(
    void Function($SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterfaceBuilder b) {}
}

abstract class SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate
    implements
        $SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterface,
        Built<SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate,
            SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateBuilder> {
  /// Creates a new SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate object using the builder pattern.
  factory SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate([
    void Function(SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateBuilder)? b,
  ]) = _$SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate;

  // coverage:ignore-start
  const SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate.
  static Serializer<SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate> get serializer =>
      _$sharebymailCapabilities0FilesSharingSharebymailExpireDateSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateBuilder b) {
    $SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateBuilder b) {
    $SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDateInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SharebymailCapabilities0_FilesSharing_SharebymailInterface {
  bool get enabled;
  @BuiltValueField(wireName: 'send_password_by_mail')
  bool get sendPasswordByMail;
  @BuiltValueField(wireName: 'upload_files_drop')
  SharebymailCapabilities0_FilesSharing_Sharebymail_UploadFilesDrop get uploadFilesDrop;
  SharebymailCapabilities0_FilesSharing_Sharebymail_Password get password;
  @BuiltValueField(wireName: 'expire_date')
  SharebymailCapabilities0_FilesSharing_Sharebymail_ExpireDate get expireDate;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SharebymailCapabilities0_FilesSharing_SharebymailInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharing_SharebymailInterface rebuild(
    void Function($SharebymailCapabilities0_FilesSharing_SharebymailInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SharebymailCapabilities0_FilesSharing_SharebymailInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharing_SharebymailInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SharebymailCapabilities0_FilesSharing_SharebymailInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SharebymailCapabilities0_FilesSharing_SharebymailInterfaceBuilder b) {}
}

abstract class SharebymailCapabilities0_FilesSharing_Sharebymail
    implements
        $SharebymailCapabilities0_FilesSharing_SharebymailInterface,
        Built<SharebymailCapabilities0_FilesSharing_Sharebymail,
            SharebymailCapabilities0_FilesSharing_SharebymailBuilder> {
  /// Creates a new SharebymailCapabilities0_FilesSharing_Sharebymail object using the builder pattern.
  factory SharebymailCapabilities0_FilesSharing_Sharebymail([
    void Function(SharebymailCapabilities0_FilesSharing_SharebymailBuilder)? b,
  ]) = _$SharebymailCapabilities0_FilesSharing_Sharebymail;

  // coverage:ignore-start
  const SharebymailCapabilities0_FilesSharing_Sharebymail._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SharebymailCapabilities0_FilesSharing_Sharebymail.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SharebymailCapabilities0_FilesSharing_Sharebymail.
  static Serializer<SharebymailCapabilities0_FilesSharing_Sharebymail> get serializer =>
      _$sharebymailCapabilities0FilesSharingSharebymailSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SharebymailCapabilities0_FilesSharing_SharebymailBuilder b) {
    $SharebymailCapabilities0_FilesSharing_SharebymailInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SharebymailCapabilities0_FilesSharing_SharebymailBuilder b) {
    $SharebymailCapabilities0_FilesSharing_SharebymailInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SharebymailCapabilities0_FilesSharingInterface {
  SharebymailCapabilities0_FilesSharing_Sharebymail get sharebymail;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SharebymailCapabilities0_FilesSharingInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharingInterface rebuild(
    void Function($SharebymailCapabilities0_FilesSharingInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SharebymailCapabilities0_FilesSharingInterfaceBuilder].
  $SharebymailCapabilities0_FilesSharingInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SharebymailCapabilities0_FilesSharingInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SharebymailCapabilities0_FilesSharingInterfaceBuilder b) {}
}

abstract class SharebymailCapabilities0_FilesSharing
    implements
        $SharebymailCapabilities0_FilesSharingInterface,
        Built<SharebymailCapabilities0_FilesSharing, SharebymailCapabilities0_FilesSharingBuilder> {
  /// Creates a new SharebymailCapabilities0_FilesSharing object using the builder pattern.
  factory SharebymailCapabilities0_FilesSharing([void Function(SharebymailCapabilities0_FilesSharingBuilder)? b]) =
      _$SharebymailCapabilities0_FilesSharing;

  // coverage:ignore-start
  const SharebymailCapabilities0_FilesSharing._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SharebymailCapabilities0_FilesSharing.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SharebymailCapabilities0_FilesSharing.
  static Serializer<SharebymailCapabilities0_FilesSharing> get serializer =>
      _$sharebymailCapabilities0FilesSharingSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SharebymailCapabilities0_FilesSharingBuilder b) {
    $SharebymailCapabilities0_FilesSharingInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SharebymailCapabilities0_FilesSharingBuilder b) {
    $SharebymailCapabilities0_FilesSharingInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SharebymailCapabilities0Interface {
  @BuiltValueField(wireName: 'files_sharing')
  SharebymailCapabilities0_FilesSharing get filesSharing;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SharebymailCapabilities0InterfaceBuilder].
  $SharebymailCapabilities0Interface rebuild(void Function($SharebymailCapabilities0InterfaceBuilder) updates);

  /// Converts the instance to a builder [$SharebymailCapabilities0InterfaceBuilder].
  $SharebymailCapabilities0InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SharebymailCapabilities0InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SharebymailCapabilities0InterfaceBuilder b) {}
}

abstract class SharebymailCapabilities0
    implements $SharebymailCapabilities0Interface, Built<SharebymailCapabilities0, SharebymailCapabilities0Builder> {
  /// Creates a new SharebymailCapabilities0 object using the builder pattern.
  factory SharebymailCapabilities0([void Function(SharebymailCapabilities0Builder)? b]) = _$SharebymailCapabilities0;

  // coverage:ignore-start
  const SharebymailCapabilities0._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SharebymailCapabilities0.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SharebymailCapabilities0.
  static Serializer<SharebymailCapabilities0> get serializer => _$sharebymailCapabilities0Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SharebymailCapabilities0Builder b) {
    $SharebymailCapabilities0Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SharebymailCapabilities0Builder b) {
    $SharebymailCapabilities0Interface._validate(b);
  }
}

typedef SharebymailCapabilities = ({
  BuiltList<Never>? builtListNever,
  SharebymailCapabilities0? sharebymailCapabilities0
});

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilities_Config_AttachmentsInterface {
  bool get allowed;
  String? get folder;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilities_Config_AttachmentsInterfaceBuilder].
  $SpreedCapabilities_Config_AttachmentsInterface rebuild(
    void Function($SpreedCapabilities_Config_AttachmentsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SpreedCapabilities_Config_AttachmentsInterfaceBuilder].
  $SpreedCapabilities_Config_AttachmentsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilities_Config_AttachmentsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilities_Config_AttachmentsInterfaceBuilder b) {}
}

abstract class SpreedCapabilities_Config_Attachments
    implements
        $SpreedCapabilities_Config_AttachmentsInterface,
        Built<SpreedCapabilities_Config_Attachments, SpreedCapabilities_Config_AttachmentsBuilder> {
  /// Creates a new SpreedCapabilities_Config_Attachments object using the builder pattern.
  factory SpreedCapabilities_Config_Attachments([void Function(SpreedCapabilities_Config_AttachmentsBuilder)? b]) =
      _$SpreedCapabilities_Config_Attachments;

  // coverage:ignore-start
  const SpreedCapabilities_Config_Attachments._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities_Config_Attachments.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities_Config_Attachments.
  static Serializer<SpreedCapabilities_Config_Attachments> get serializer =>
      _$spreedCapabilitiesConfigAttachmentsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilities_Config_AttachmentsBuilder b) {
    $SpreedCapabilities_Config_AttachmentsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilities_Config_AttachmentsBuilder b) {
    $SpreedCapabilities_Config_AttachmentsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilities_Config_CallInterface {
  bool get enabled;
  @BuiltValueField(wireName: 'breakout-rooms')
  bool get breakoutRooms;
  bool get recording;
  @BuiltValueField(wireName: 'recording-consent')
  int get recordingConsent;
  @BuiltValueField(wireName: 'supported-reactions')
  BuiltList<String> get supportedReactions;
  @BuiltValueField(wireName: 'predefined-backgrounds')
  BuiltList<String> get predefinedBackgrounds;
  @BuiltValueField(wireName: 'can-upload-background')
  bool get canUploadBackground;
  @BuiltValueField(wireName: 'sip-enabled')
  bool get sipEnabled;
  @BuiltValueField(wireName: 'sip-dialout-enabled')
  bool get sipDialoutEnabled;
  @BuiltValueField(wireName: 'can-enable-sip')
  bool get canEnableSip;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilities_Config_CallInterfaceBuilder].
  $SpreedCapabilities_Config_CallInterface rebuild(
    void Function($SpreedCapabilities_Config_CallInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SpreedCapabilities_Config_CallInterfaceBuilder].
  $SpreedCapabilities_Config_CallInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilities_Config_CallInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilities_Config_CallInterfaceBuilder b) {}
}

abstract class SpreedCapabilities_Config_Call
    implements
        $SpreedCapabilities_Config_CallInterface,
        Built<SpreedCapabilities_Config_Call, SpreedCapabilities_Config_CallBuilder> {
  /// Creates a new SpreedCapabilities_Config_Call object using the builder pattern.
  factory SpreedCapabilities_Config_Call([void Function(SpreedCapabilities_Config_CallBuilder)? b]) =
      _$SpreedCapabilities_Config_Call;

  // coverage:ignore-start
  const SpreedCapabilities_Config_Call._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities_Config_Call.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities_Config_Call.
  static Serializer<SpreedCapabilities_Config_Call> get serializer => _$spreedCapabilitiesConfigCallSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilities_Config_CallBuilder b) {
    $SpreedCapabilities_Config_CallInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilities_Config_CallBuilder b) {
    $SpreedCapabilities_Config_CallInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilities_Config_ChatInterface {
  @BuiltValueField(wireName: 'max-length')
  int get maxLength;
  @BuiltValueField(wireName: 'read-privacy')
  int get readPrivacy;
  @BuiltValueField(wireName: 'has-translation-providers')
  bool get hasTranslationProviders;
  @BuiltValueField(wireName: 'typing-privacy')
  int get typingPrivacy;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilities_Config_ChatInterfaceBuilder].
  $SpreedCapabilities_Config_ChatInterface rebuild(
    void Function($SpreedCapabilities_Config_ChatInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SpreedCapabilities_Config_ChatInterfaceBuilder].
  $SpreedCapabilities_Config_ChatInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilities_Config_ChatInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilities_Config_ChatInterfaceBuilder b) {}
}

abstract class SpreedCapabilities_Config_Chat
    implements
        $SpreedCapabilities_Config_ChatInterface,
        Built<SpreedCapabilities_Config_Chat, SpreedCapabilities_Config_ChatBuilder> {
  /// Creates a new SpreedCapabilities_Config_Chat object using the builder pattern.
  factory SpreedCapabilities_Config_Chat([void Function(SpreedCapabilities_Config_ChatBuilder)? b]) =
      _$SpreedCapabilities_Config_Chat;

  // coverage:ignore-start
  const SpreedCapabilities_Config_Chat._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities_Config_Chat.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities_Config_Chat.
  static Serializer<SpreedCapabilities_Config_Chat> get serializer => _$spreedCapabilitiesConfigChatSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilities_Config_ChatBuilder b) {
    $SpreedCapabilities_Config_ChatInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilities_Config_ChatBuilder b) {
    $SpreedCapabilities_Config_ChatInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilities_Config_ConversationsInterface {
  @BuiltValueField(wireName: 'can-create')
  bool get canCreate;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilities_Config_ConversationsInterfaceBuilder].
  $SpreedCapabilities_Config_ConversationsInterface rebuild(
    void Function($SpreedCapabilities_Config_ConversationsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SpreedCapabilities_Config_ConversationsInterfaceBuilder].
  $SpreedCapabilities_Config_ConversationsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilities_Config_ConversationsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilities_Config_ConversationsInterfaceBuilder b) {}
}

abstract class SpreedCapabilities_Config_Conversations
    implements
        $SpreedCapabilities_Config_ConversationsInterface,
        Built<SpreedCapabilities_Config_Conversations, SpreedCapabilities_Config_ConversationsBuilder> {
  /// Creates a new SpreedCapabilities_Config_Conversations object using the builder pattern.
  factory SpreedCapabilities_Config_Conversations([void Function(SpreedCapabilities_Config_ConversationsBuilder)? b]) =
      _$SpreedCapabilities_Config_Conversations;

  // coverage:ignore-start
  const SpreedCapabilities_Config_Conversations._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities_Config_Conversations.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities_Config_Conversations.
  static Serializer<SpreedCapabilities_Config_Conversations> get serializer =>
      _$spreedCapabilitiesConfigConversationsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilities_Config_ConversationsBuilder b) {
    $SpreedCapabilities_Config_ConversationsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilities_Config_ConversationsBuilder b) {
    $SpreedCapabilities_Config_ConversationsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilities_Config_FederationInterface {
  bool get enabled;
  @BuiltValueField(wireName: 'incoming-enabled')
  bool get incomingEnabled;
  @BuiltValueField(wireName: 'outgoing-enabled')
  bool get outgoingEnabled;
  @BuiltValueField(wireName: 'only-trusted-servers')
  bool get onlyTrustedServers;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilities_Config_FederationInterfaceBuilder].
  $SpreedCapabilities_Config_FederationInterface rebuild(
    void Function($SpreedCapabilities_Config_FederationInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SpreedCapabilities_Config_FederationInterfaceBuilder].
  $SpreedCapabilities_Config_FederationInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilities_Config_FederationInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilities_Config_FederationInterfaceBuilder b) {}
}

abstract class SpreedCapabilities_Config_Federation
    implements
        $SpreedCapabilities_Config_FederationInterface,
        Built<SpreedCapabilities_Config_Federation, SpreedCapabilities_Config_FederationBuilder> {
  /// Creates a new SpreedCapabilities_Config_Federation object using the builder pattern.
  factory SpreedCapabilities_Config_Federation([void Function(SpreedCapabilities_Config_FederationBuilder)? b]) =
      _$SpreedCapabilities_Config_Federation;

  // coverage:ignore-start
  const SpreedCapabilities_Config_Federation._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities_Config_Federation.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities_Config_Federation.
  static Serializer<SpreedCapabilities_Config_Federation> get serializer =>
      _$spreedCapabilitiesConfigFederationSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilities_Config_FederationBuilder b) {
    $SpreedCapabilities_Config_FederationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilities_Config_FederationBuilder b) {
    $SpreedCapabilities_Config_FederationInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilities_Config_PreviewsInterface {
  @BuiltValueField(wireName: 'max-gif-size')
  int get maxGifSize;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilities_Config_PreviewsInterfaceBuilder].
  $SpreedCapabilities_Config_PreviewsInterface rebuild(
    void Function($SpreedCapabilities_Config_PreviewsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SpreedCapabilities_Config_PreviewsInterfaceBuilder].
  $SpreedCapabilities_Config_PreviewsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilities_Config_PreviewsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilities_Config_PreviewsInterfaceBuilder b) {}
}

abstract class SpreedCapabilities_Config_Previews
    implements
        $SpreedCapabilities_Config_PreviewsInterface,
        Built<SpreedCapabilities_Config_Previews, SpreedCapabilities_Config_PreviewsBuilder> {
  /// Creates a new SpreedCapabilities_Config_Previews object using the builder pattern.
  factory SpreedCapabilities_Config_Previews([void Function(SpreedCapabilities_Config_PreviewsBuilder)? b]) =
      _$SpreedCapabilities_Config_Previews;

  // coverage:ignore-start
  const SpreedCapabilities_Config_Previews._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities_Config_Previews.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities_Config_Previews.
  static Serializer<SpreedCapabilities_Config_Previews> get serializer => _$spreedCapabilitiesConfigPreviewsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilities_Config_PreviewsBuilder b) {
    $SpreedCapabilities_Config_PreviewsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilities_Config_PreviewsBuilder b) {
    $SpreedCapabilities_Config_PreviewsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilities_Config_SignalingInterface {
  @BuiltValueField(wireName: 'session-ping-limit')
  int get sessionPingLimit;
  @BuiltValueField(wireName: 'hello-v2-token-key')
  String? get helloV2TokenKey;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilities_Config_SignalingInterfaceBuilder].
  $SpreedCapabilities_Config_SignalingInterface rebuild(
    void Function($SpreedCapabilities_Config_SignalingInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SpreedCapabilities_Config_SignalingInterfaceBuilder].
  $SpreedCapabilities_Config_SignalingInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilities_Config_SignalingInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilities_Config_SignalingInterfaceBuilder b) {}
}

abstract class SpreedCapabilities_Config_Signaling
    implements
        $SpreedCapabilities_Config_SignalingInterface,
        Built<SpreedCapabilities_Config_Signaling, SpreedCapabilities_Config_SignalingBuilder> {
  /// Creates a new SpreedCapabilities_Config_Signaling object using the builder pattern.
  factory SpreedCapabilities_Config_Signaling([void Function(SpreedCapabilities_Config_SignalingBuilder)? b]) =
      _$SpreedCapabilities_Config_Signaling;

  // coverage:ignore-start
  const SpreedCapabilities_Config_Signaling._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities_Config_Signaling.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities_Config_Signaling.
  static Serializer<SpreedCapabilities_Config_Signaling> get serializer =>
      _$spreedCapabilitiesConfigSignalingSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilities_Config_SignalingBuilder b) {
    $SpreedCapabilities_Config_SignalingInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilities_Config_SignalingBuilder b) {
    $SpreedCapabilities_Config_SignalingInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilities_ConfigInterface {
  SpreedCapabilities_Config_Attachments get attachments;
  SpreedCapabilities_Config_Call get call;
  SpreedCapabilities_Config_Chat get chat;
  SpreedCapabilities_Config_Conversations get conversations;
  SpreedCapabilities_Config_Federation? get federation;
  SpreedCapabilities_Config_Previews get previews;
  SpreedCapabilities_Config_Signaling get signaling;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilities_ConfigInterfaceBuilder].
  $SpreedCapabilities_ConfigInterface rebuild(void Function($SpreedCapabilities_ConfigInterfaceBuilder) updates);

  /// Converts the instance to a builder [$SpreedCapabilities_ConfigInterfaceBuilder].
  $SpreedCapabilities_ConfigInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilities_ConfigInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilities_ConfigInterfaceBuilder b) {}
}

abstract class SpreedCapabilities_Config
    implements $SpreedCapabilities_ConfigInterface, Built<SpreedCapabilities_Config, SpreedCapabilities_ConfigBuilder> {
  /// Creates a new SpreedCapabilities_Config object using the builder pattern.
  factory SpreedCapabilities_Config([void Function(SpreedCapabilities_ConfigBuilder)? b]) = _$SpreedCapabilities_Config;

  // coverage:ignore-start
  const SpreedCapabilities_Config._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities_Config.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities_Config.
  static Serializer<SpreedCapabilities_Config> get serializer => _$spreedCapabilitiesConfigSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilities_ConfigBuilder b) {
    $SpreedCapabilities_ConfigInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilities_ConfigBuilder b) {
    $SpreedCapabilities_ConfigInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedCapabilitiesInterface {
  BuiltList<String> get features;
  @BuiltValueField(wireName: 'features-local')
  BuiltList<String> get featuresLocal;
  SpreedCapabilities_Config get config;
  @BuiltValueField(wireName: 'config-local')
  BuiltMap<String, BuiltList<String>> get configLocal;
  String get version;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedCapabilitiesInterfaceBuilder].
  $SpreedCapabilitiesInterface rebuild(void Function($SpreedCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$SpreedCapabilitiesInterfaceBuilder].
  $SpreedCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedCapabilitiesInterfaceBuilder b) {}
}

abstract class SpreedCapabilities
    implements $SpreedCapabilitiesInterface, Built<SpreedCapabilities, SpreedCapabilitiesBuilder> {
  /// Creates a new SpreedCapabilities object using the builder pattern.
  factory SpreedCapabilities([void Function(SpreedCapabilitiesBuilder)? b]) = _$SpreedCapabilities;

  // coverage:ignore-start
  const SpreedCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedCapabilities.
  static Serializer<SpreedCapabilities> get serializer => _$spreedCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedCapabilitiesBuilder b) {
    $SpreedCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedCapabilitiesBuilder b) {
    $SpreedCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SpreedPublicCapabilities0Interface {
  SpreedCapabilities get spreed;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SpreedPublicCapabilities0InterfaceBuilder].
  $SpreedPublicCapabilities0Interface rebuild(void Function($SpreedPublicCapabilities0InterfaceBuilder) updates);

  /// Converts the instance to a builder [$SpreedPublicCapabilities0InterfaceBuilder].
  $SpreedPublicCapabilities0InterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SpreedPublicCapabilities0InterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SpreedPublicCapabilities0InterfaceBuilder b) {}
}

abstract class SpreedPublicCapabilities0
    implements $SpreedPublicCapabilities0Interface, Built<SpreedPublicCapabilities0, SpreedPublicCapabilities0Builder> {
  /// Creates a new SpreedPublicCapabilities0 object using the builder pattern.
  factory SpreedPublicCapabilities0([void Function(SpreedPublicCapabilities0Builder)? b]) = _$SpreedPublicCapabilities0;

  // coverage:ignore-start
  const SpreedPublicCapabilities0._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SpreedPublicCapabilities0.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SpreedPublicCapabilities0.
  static Serializer<SpreedPublicCapabilities0> get serializer => _$spreedPublicCapabilities0Serializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SpreedPublicCapabilities0Builder b) {
    $SpreedPublicCapabilities0Interface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SpreedPublicCapabilities0Builder b) {
    $SpreedPublicCapabilities0Interface._validate(b);
  }
}

typedef SpreedPublicCapabilities = ({
  BuiltList<Never>? builtListNever,
  SpreedPublicCapabilities0? spreedPublicCapabilities0
});

class SystemtagsCapabilities_Systemtags_Enabled extends EnumClass {
  const SystemtagsCapabilities_Systemtags_Enabled._(super.name);

  /// `true`
  @BuiltValueEnumConst(wireName: 'true')
  static const SystemtagsCapabilities_Systemtags_Enabled $true = _$systemtagsCapabilitiesSystemtagsEnabled$true;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<SystemtagsCapabilities_Systemtags_Enabled> get values =>
      _$systemtagsCapabilitiesSystemtagsEnabledValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static SystemtagsCapabilities_Systemtags_Enabled valueOf(String name) =>
      _$valueOfSystemtagsCapabilities_Systemtags_Enabled(name);

  /// Returns the serialized value of this enum value.
  bool get value => _$jsonSerializers.serializeWith(serializer, this)! as bool;

  /// Serializer for SystemtagsCapabilities_Systemtags_Enabled.
  @BuiltValueSerializer(custom: true)
  static Serializer<SystemtagsCapabilities_Systemtags_Enabled> get serializer =>
      const _$SystemtagsCapabilities_Systemtags_EnabledSerializer();
}

class _$SystemtagsCapabilities_Systemtags_EnabledSerializer
    implements PrimitiveSerializer<SystemtagsCapabilities_Systemtags_Enabled> {
  const _$SystemtagsCapabilities_Systemtags_EnabledSerializer();

  static const Map<SystemtagsCapabilities_Systemtags_Enabled, Object> _toWire =
      <SystemtagsCapabilities_Systemtags_Enabled, Object>{
    SystemtagsCapabilities_Systemtags_Enabled.$true: true,
  };

  static const Map<Object, SystemtagsCapabilities_Systemtags_Enabled> _fromWire =
      <Object, SystemtagsCapabilities_Systemtags_Enabled>{
    true: SystemtagsCapabilities_Systemtags_Enabled.$true,
  };

  @override
  Iterable<Type> get types => const [SystemtagsCapabilities_Systemtags_Enabled];

  @override
  String get wireName => 'SystemtagsCapabilities_Systemtags_Enabled';

  @override
  Object serialize(
    Serializers serializers,
    SystemtagsCapabilities_Systemtags_Enabled object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  SystemtagsCapabilities_Systemtags_Enabled deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $SystemtagsCapabilities_SystemtagsInterface {
  SystemtagsCapabilities_Systemtags_Enabled get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SystemtagsCapabilities_SystemtagsInterfaceBuilder].
  $SystemtagsCapabilities_SystemtagsInterface rebuild(
    void Function($SystemtagsCapabilities_SystemtagsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$SystemtagsCapabilities_SystemtagsInterfaceBuilder].
  $SystemtagsCapabilities_SystemtagsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SystemtagsCapabilities_SystemtagsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SystemtagsCapabilities_SystemtagsInterfaceBuilder b) {}
}

abstract class SystemtagsCapabilities_Systemtags
    implements
        $SystemtagsCapabilities_SystemtagsInterface,
        Built<SystemtagsCapabilities_Systemtags, SystemtagsCapabilities_SystemtagsBuilder> {
  /// Creates a new SystemtagsCapabilities_Systemtags object using the builder pattern.
  factory SystemtagsCapabilities_Systemtags([void Function(SystemtagsCapabilities_SystemtagsBuilder)? b]) =
      _$SystemtagsCapabilities_Systemtags;

  // coverage:ignore-start
  const SystemtagsCapabilities_Systemtags._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SystemtagsCapabilities_Systemtags.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SystemtagsCapabilities_Systemtags.
  static Serializer<SystemtagsCapabilities_Systemtags> get serializer => _$systemtagsCapabilitiesSystemtagsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SystemtagsCapabilities_SystemtagsBuilder b) {
    $SystemtagsCapabilities_SystemtagsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SystemtagsCapabilities_SystemtagsBuilder b) {
    $SystemtagsCapabilities_SystemtagsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $SystemtagsCapabilitiesInterface {
  SystemtagsCapabilities_Systemtags get systemtags;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$SystemtagsCapabilitiesInterfaceBuilder].
  $SystemtagsCapabilitiesInterface rebuild(void Function($SystemtagsCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$SystemtagsCapabilitiesInterfaceBuilder].
  $SystemtagsCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($SystemtagsCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($SystemtagsCapabilitiesInterfaceBuilder b) {}
}

abstract class SystemtagsCapabilities
    implements $SystemtagsCapabilitiesInterface, Built<SystemtagsCapabilities, SystemtagsCapabilitiesBuilder> {
  /// Creates a new SystemtagsCapabilities object using the builder pattern.
  factory SystemtagsCapabilities([void Function(SystemtagsCapabilitiesBuilder)? b]) = _$SystemtagsCapabilities;

  // coverage:ignore-start
  const SystemtagsCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory SystemtagsCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for SystemtagsCapabilities.
  static Serializer<SystemtagsCapabilities> get serializer => _$systemtagsCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(SystemtagsCapabilitiesBuilder b) {
    $SystemtagsCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(SystemtagsCapabilitiesBuilder b) {
    $SystemtagsCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TablesCapabilities_TablesInterface {
  bool get enabled;
  String get version;
  BuiltList<String> get apiVersions;
  BuiltList<String> get features;
  @BuiltValueField(wireName: 'column_types')
  BuiltList<String> get columnTypes;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TablesCapabilities_TablesInterfaceBuilder].
  $TablesCapabilities_TablesInterface rebuild(void Function($TablesCapabilities_TablesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TablesCapabilities_TablesInterfaceBuilder].
  $TablesCapabilities_TablesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TablesCapabilities_TablesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TablesCapabilities_TablesInterfaceBuilder b) {}
}

abstract class TablesCapabilities_Tables
    implements $TablesCapabilities_TablesInterface, Built<TablesCapabilities_Tables, TablesCapabilities_TablesBuilder> {
  /// Creates a new TablesCapabilities_Tables object using the builder pattern.
  factory TablesCapabilities_Tables([void Function(TablesCapabilities_TablesBuilder)? b]) = _$TablesCapabilities_Tables;

  // coverage:ignore-start
  const TablesCapabilities_Tables._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TablesCapabilities_Tables.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TablesCapabilities_Tables.
  static Serializer<TablesCapabilities_Tables> get serializer => _$tablesCapabilitiesTablesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TablesCapabilities_TablesBuilder b) {
    $TablesCapabilities_TablesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TablesCapabilities_TablesBuilder b) {
    $TablesCapabilities_TablesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TablesCapabilitiesInterface {
  TablesCapabilities_Tables get tables;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TablesCapabilitiesInterfaceBuilder].
  $TablesCapabilitiesInterface rebuild(void Function($TablesCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TablesCapabilitiesInterfaceBuilder].
  $TablesCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TablesCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TablesCapabilitiesInterfaceBuilder b) {}
}

abstract class TablesCapabilities
    implements $TablesCapabilitiesInterface, Built<TablesCapabilities, TablesCapabilitiesBuilder> {
  /// Creates a new TablesCapabilities object using the builder pattern.
  factory TablesCapabilities([void Function(TablesCapabilitiesBuilder)? b]) = _$TablesCapabilities;

  // coverage:ignore-start
  const TablesCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TablesCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TablesCapabilities.
  static Serializer<TablesCapabilities> get serializer => _$tablesCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TablesCapabilitiesBuilder b) {
    $TablesCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TablesCapabilitiesBuilder b) {
    $TablesCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ThemingPublicCapabilities_ThemingInterface {
  String get name;
  String get url;
  String get slogan;
  String get color;
  @BuiltValueField(wireName: 'color-text')
  String get colorText;
  @BuiltValueField(wireName: 'color-element')
  String get colorElement;
  @BuiltValueField(wireName: 'color-element-bright')
  String get colorElementBright;
  @BuiltValueField(wireName: 'color-element-dark')
  String get colorElementDark;
  String get logo;
  String get background;
  @BuiltValueField(wireName: 'background-text')
  String? get backgroundText;
  @BuiltValueField(wireName: 'background-plain')
  bool get backgroundPlain;
  @BuiltValueField(wireName: 'background-default')
  bool get backgroundDefault;
  String get logoheader;
  String get favicon;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ThemingPublicCapabilities_ThemingInterfaceBuilder].
  $ThemingPublicCapabilities_ThemingInterface rebuild(
    void Function($ThemingPublicCapabilities_ThemingInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ThemingPublicCapabilities_ThemingInterfaceBuilder].
  $ThemingPublicCapabilities_ThemingInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ThemingPublicCapabilities_ThemingInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ThemingPublicCapabilities_ThemingInterfaceBuilder b) {}
}

abstract class ThemingPublicCapabilities_Theming
    implements
        $ThemingPublicCapabilities_ThemingInterface,
        Built<ThemingPublicCapabilities_Theming, ThemingPublicCapabilities_ThemingBuilder> {
  /// Creates a new ThemingPublicCapabilities_Theming object using the builder pattern.
  factory ThemingPublicCapabilities_Theming([void Function(ThemingPublicCapabilities_ThemingBuilder)? b]) =
      _$ThemingPublicCapabilities_Theming;

  // coverage:ignore-start
  const ThemingPublicCapabilities_Theming._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ThemingPublicCapabilities_Theming.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ThemingPublicCapabilities_Theming.
  static Serializer<ThemingPublicCapabilities_Theming> get serializer => _$themingPublicCapabilitiesThemingSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ThemingPublicCapabilities_ThemingBuilder b) {
    $ThemingPublicCapabilities_ThemingInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ThemingPublicCapabilities_ThemingBuilder b) {
    $ThemingPublicCapabilities_ThemingInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ThemingPublicCapabilitiesInterface {
  ThemingPublicCapabilities_Theming get theming;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ThemingPublicCapabilitiesInterfaceBuilder].
  $ThemingPublicCapabilitiesInterface rebuild(void Function($ThemingPublicCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ThemingPublicCapabilitiesInterfaceBuilder].
  $ThemingPublicCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ThemingPublicCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ThemingPublicCapabilitiesInterfaceBuilder b) {}
}

abstract class ThemingPublicCapabilities
    implements $ThemingPublicCapabilitiesInterface, Built<ThemingPublicCapabilities, ThemingPublicCapabilitiesBuilder> {
  /// Creates a new ThemingPublicCapabilities object using the builder pattern.
  factory ThemingPublicCapabilities([void Function(ThemingPublicCapabilitiesBuilder)? b]) = _$ThemingPublicCapabilities;

  // coverage:ignore-start
  const ThemingPublicCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ThemingPublicCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ThemingPublicCapabilities.
  static Serializer<ThemingPublicCapabilities> get serializer => _$themingPublicCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ThemingPublicCapabilitiesBuilder b) {
    $ThemingPublicCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ThemingPublicCapabilitiesBuilder b) {
    $ThemingPublicCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusCapabilities_UserStatusInterface {
  bool get enabled;
  bool get restore;
  @BuiltValueField(wireName: 'supports_emoji')
  bool get supportsEmoji;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusCapabilities_UserStatusInterfaceBuilder].
  $UserStatusCapabilities_UserStatusInterface rebuild(
    void Function($UserStatusCapabilities_UserStatusInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$UserStatusCapabilities_UserStatusInterfaceBuilder].
  $UserStatusCapabilities_UserStatusInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusCapabilities_UserStatusInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusCapabilities_UserStatusInterfaceBuilder b) {}
}

abstract class UserStatusCapabilities_UserStatus
    implements
        $UserStatusCapabilities_UserStatusInterface,
        Built<UserStatusCapabilities_UserStatus, UserStatusCapabilities_UserStatusBuilder> {
  /// Creates a new UserStatusCapabilities_UserStatus object using the builder pattern.
  factory UserStatusCapabilities_UserStatus([void Function(UserStatusCapabilities_UserStatusBuilder)? b]) =
      _$UserStatusCapabilities_UserStatus;

  // coverage:ignore-start
  const UserStatusCapabilities_UserStatus._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusCapabilities_UserStatus.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusCapabilities_UserStatus.
  static Serializer<UserStatusCapabilities_UserStatus> get serializer => _$userStatusCapabilitiesUserStatusSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusCapabilities_UserStatusBuilder b) {
    $UserStatusCapabilities_UserStatusInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusCapabilities_UserStatusBuilder b) {
    $UserStatusCapabilities_UserStatusInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UserStatusCapabilitiesInterface {
  @BuiltValueField(wireName: 'user_status')
  UserStatusCapabilities_UserStatus get userStatus;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UserStatusCapabilitiesInterfaceBuilder].
  $UserStatusCapabilitiesInterface rebuild(void Function($UserStatusCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$UserStatusCapabilitiesInterfaceBuilder].
  $UserStatusCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UserStatusCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UserStatusCapabilitiesInterfaceBuilder b) {}
}

abstract class UserStatusCapabilities
    implements $UserStatusCapabilitiesInterface, Built<UserStatusCapabilities, UserStatusCapabilitiesBuilder> {
  /// Creates a new UserStatusCapabilities object using the builder pattern.
  factory UserStatusCapabilities([void Function(UserStatusCapabilitiesBuilder)? b]) = _$UserStatusCapabilities;

  // coverage:ignore-start
  const UserStatusCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory UserStatusCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for UserStatusCapabilities.
  static Serializer<UserStatusCapabilities> get serializer => _$userStatusCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UserStatusCapabilitiesBuilder b) {
    $UserStatusCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UserStatusCapabilitiesBuilder b) {
    $UserStatusCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusCapabilities_WeatherStatusInterface {
  bool get enabled;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusCapabilities_WeatherStatusInterfaceBuilder].
  $WeatherStatusCapabilities_WeatherStatusInterface rebuild(
    void Function($WeatherStatusCapabilities_WeatherStatusInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$WeatherStatusCapabilities_WeatherStatusInterfaceBuilder].
  $WeatherStatusCapabilities_WeatherStatusInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusCapabilities_WeatherStatusInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusCapabilities_WeatherStatusInterfaceBuilder b) {}
}

abstract class WeatherStatusCapabilities_WeatherStatus
    implements
        $WeatherStatusCapabilities_WeatherStatusInterface,
        Built<WeatherStatusCapabilities_WeatherStatus, WeatherStatusCapabilities_WeatherStatusBuilder> {
  /// Creates a new WeatherStatusCapabilities_WeatherStatus object using the builder pattern.
  factory WeatherStatusCapabilities_WeatherStatus([void Function(WeatherStatusCapabilities_WeatherStatusBuilder)? b]) =
      _$WeatherStatusCapabilities_WeatherStatus;

  // coverage:ignore-start
  const WeatherStatusCapabilities_WeatherStatus._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusCapabilities_WeatherStatus.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusCapabilities_WeatherStatus.
  static Serializer<WeatherStatusCapabilities_WeatherStatus> get serializer =>
      _$weatherStatusCapabilitiesWeatherStatusSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusCapabilities_WeatherStatusBuilder b) {
    $WeatherStatusCapabilities_WeatherStatusInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusCapabilities_WeatherStatusBuilder b) {
    $WeatherStatusCapabilities_WeatherStatusInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $WeatherStatusCapabilitiesInterface {
  @BuiltValueField(wireName: 'weather_status')
  WeatherStatusCapabilities_WeatherStatus get weatherStatus;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$WeatherStatusCapabilitiesInterfaceBuilder].
  $WeatherStatusCapabilitiesInterface rebuild(void Function($WeatherStatusCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$WeatherStatusCapabilitiesInterfaceBuilder].
  $WeatherStatusCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($WeatherStatusCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($WeatherStatusCapabilitiesInterfaceBuilder b) {}
}

abstract class WeatherStatusCapabilities
    implements $WeatherStatusCapabilitiesInterface, Built<WeatherStatusCapabilities, WeatherStatusCapabilitiesBuilder> {
  /// Creates a new WeatherStatusCapabilities object using the builder pattern.
  factory WeatherStatusCapabilities([void Function(WeatherStatusCapabilitiesBuilder)? b]) = _$WeatherStatusCapabilities;

  // coverage:ignore-start
  const WeatherStatusCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory WeatherStatusCapabilities.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for WeatherStatusCapabilities.
  static Serializer<WeatherStatusCapabilities> get serializer => _$weatherStatusCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(WeatherStatusCapabilitiesBuilder b) {
    $WeatherStatusCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(WeatherStatusCapabilitiesBuilder b) {
    $WeatherStatusCapabilitiesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NotesCapabilities_NotesInterface {
  @BuiltValueField(wireName: 'api_version')
  BuiltList<String>? get apiVersion;
  String? get version;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NotesCapabilities_NotesInterfaceBuilder].
  $NotesCapabilities_NotesInterface rebuild(void Function($NotesCapabilities_NotesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$NotesCapabilities_NotesInterfaceBuilder].
  $NotesCapabilities_NotesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NotesCapabilities_NotesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NotesCapabilities_NotesInterfaceBuilder b) {}
}

abstract class NotesCapabilities_Notes
    implements $NotesCapabilities_NotesInterface, Built<NotesCapabilities_Notes, NotesCapabilities_NotesBuilder> {
  /// Creates a new NotesCapabilities_Notes object using the builder pattern.
  factory NotesCapabilities_Notes([void Function(NotesCapabilities_NotesBuilder)? b]) = _$NotesCapabilities_Notes;

  // coverage:ignore-start
  const NotesCapabilities_Notes._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NotesCapabilities_Notes.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NotesCapabilities_Notes.
  static Serializer<NotesCapabilities_Notes> get serializer => _$notesCapabilitiesNotesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NotesCapabilities_NotesBuilder b) {
    $NotesCapabilities_NotesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NotesCapabilities_NotesBuilder b) {
    $NotesCapabilities_NotesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NotesCapabilitiesInterface {
  NotesCapabilities_Notes get notes;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NotesCapabilitiesInterfaceBuilder].
  $NotesCapabilitiesInterface rebuild(void Function($NotesCapabilitiesInterfaceBuilder) updates);

  /// Converts the instance to a builder [$NotesCapabilitiesInterfaceBuilder].
  $NotesCapabilitiesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NotesCapabilitiesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NotesCapabilitiesInterfaceBuilder b) {}
}

abstract class NotesCapabilities
    implements $NotesCapabilitiesInterface, Built<NotesCapabilities, NotesCapabilitiesBuilder> {
  /// Creates a new NotesCapabilities object using the builder pattern.
  factory NotesCapabilities([void Function(NotesCapabilitiesBuilder)? b]) = _$NotesCapabilities;

  // coverage:ignore-start
  const NotesCapabilities._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory NotesCapabilities.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for NotesCapabilities.
  static Serializer<NotesCapabilities> get serializer => _$notesCapabilitiesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NotesCapabilitiesBuilder b) {
    $NotesCapabilitiesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NotesCapabilitiesBuilder b) {
    $NotesCapabilitiesInterface._validate(b);
  }
}

typedef OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Capabilities = ({
  CommentsCapabilities? commentsCapabilities,
  CoreCapabilities? coreCapabilities,
  CorePublicCapabilities? corePublicCapabilities,
  DavCapabilities? davCapabilities,
  DropAccountCapabilities? dropAccountCapabilities,
  FilesCapabilities? filesCapabilities,
  FilesSharingCapabilities? filesSharingCapabilities,
  FilesTrashbinCapabilities? filesTrashbinCapabilities,
  FilesVersionsCapabilities? filesVersionsCapabilities,
  NotesCapabilities? notesCapabilities,
  NotificationsCapabilities? notificationsCapabilities,
  ProvisioningApiCapabilities? provisioningApiCapabilities,
  SharebymailCapabilities? sharebymailCapabilities,
  SpreedCapabilities? spreedCapabilities,
  SpreedPublicCapabilities? spreedPublicCapabilities,
  SystemtagsCapabilities? systemtagsCapabilities,
  TablesCapabilities? tablesCapabilities,
  ThemingPublicCapabilities? themingPublicCapabilities,
  UserStatusCapabilities? userStatusCapabilities,
  WeatherStatusCapabilities? weatherStatusCapabilities
});

@BuiltValue(instantiable: false)
sealed class $OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterface {
  OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Version get version;
  OcsGetCapabilitiesResponseApplicationJson_Ocs_Data_Capabilities get capabilities;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterfaceBuilder b) {
    b.capabilities?.validateAnyOf();
  }
}

abstract class OcsGetCapabilitiesResponseApplicationJson_Ocs_Data
    implements
        $OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterface,
        Built<OcsGetCapabilitiesResponseApplicationJson_Ocs_Data,
            OcsGetCapabilitiesResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new OcsGetCapabilitiesResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory OcsGetCapabilitiesResponseApplicationJson_Ocs_Data([
    void Function(OcsGetCapabilitiesResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$OcsGetCapabilitiesResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const OcsGetCapabilitiesResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OcsGetCapabilitiesResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OcsGetCapabilitiesResponseApplicationJson_Ocs_Data.
  static Serializer<OcsGetCapabilitiesResponseApplicationJson_Ocs_Data> get serializer =>
      _$ocsGetCapabilitiesResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OcsGetCapabilitiesResponseApplicationJson_Ocs_DataBuilder b) {
    $OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OcsGetCapabilitiesResponseApplicationJson_Ocs_DataBuilder b) {
    $OcsGetCapabilitiesResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OcsGetCapabilitiesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  OcsGetCapabilitiesResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OcsGetCapabilitiesResponseApplicationJson_OcsInterfaceBuilder].
  $OcsGetCapabilitiesResponseApplicationJson_OcsInterface rebuild(
    void Function($OcsGetCapabilitiesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OcsGetCapabilitiesResponseApplicationJson_OcsInterfaceBuilder].
  $OcsGetCapabilitiesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OcsGetCapabilitiesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OcsGetCapabilitiesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class OcsGetCapabilitiesResponseApplicationJson_Ocs
    implements
        $OcsGetCapabilitiesResponseApplicationJson_OcsInterface,
        Built<OcsGetCapabilitiesResponseApplicationJson_Ocs, OcsGetCapabilitiesResponseApplicationJson_OcsBuilder> {
  /// Creates a new OcsGetCapabilitiesResponseApplicationJson_Ocs object using the builder pattern.
  factory OcsGetCapabilitiesResponseApplicationJson_Ocs([
    void Function(OcsGetCapabilitiesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$OcsGetCapabilitiesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const OcsGetCapabilitiesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OcsGetCapabilitiesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OcsGetCapabilitiesResponseApplicationJson_Ocs.
  static Serializer<OcsGetCapabilitiesResponseApplicationJson_Ocs> get serializer =>
      _$ocsGetCapabilitiesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OcsGetCapabilitiesResponseApplicationJson_OcsBuilder b) {
    $OcsGetCapabilitiesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OcsGetCapabilitiesResponseApplicationJson_OcsBuilder b) {
    $OcsGetCapabilitiesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $OcsGetCapabilitiesResponseApplicationJsonInterface {
  OcsGetCapabilitiesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$OcsGetCapabilitiesResponseApplicationJsonInterfaceBuilder].
  $OcsGetCapabilitiesResponseApplicationJsonInterface rebuild(
    void Function($OcsGetCapabilitiesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$OcsGetCapabilitiesResponseApplicationJsonInterfaceBuilder].
  $OcsGetCapabilitiesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($OcsGetCapabilitiesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($OcsGetCapabilitiesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class OcsGetCapabilitiesResponseApplicationJson
    implements
        $OcsGetCapabilitiesResponseApplicationJsonInterface,
        Built<OcsGetCapabilitiesResponseApplicationJson, OcsGetCapabilitiesResponseApplicationJsonBuilder> {
  /// Creates a new OcsGetCapabilitiesResponseApplicationJson object using the builder pattern.
  factory OcsGetCapabilitiesResponseApplicationJson([
    void Function(OcsGetCapabilitiesResponseApplicationJsonBuilder)? b,
  ]) = _$OcsGetCapabilitiesResponseApplicationJson;

  // coverage:ignore-start
  const OcsGetCapabilitiesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory OcsGetCapabilitiesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for OcsGetCapabilitiesResponseApplicationJson.
  static Serializer<OcsGetCapabilitiesResponseApplicationJson> get serializer =>
      _$ocsGetCapabilitiesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(OcsGetCapabilitiesResponseApplicationJsonBuilder b) {
    $OcsGetCapabilitiesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(OcsGetCapabilitiesResponseApplicationJsonBuilder b) {
    $OcsGetCapabilitiesResponseApplicationJsonInterface._validate(b);
  }
}

class PreviewGetPreviewA extends EnumClass {
  const PreviewGetPreviewA._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const PreviewGetPreviewA $0 = _$previewGetPreviewA$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const PreviewGetPreviewA $1 = _$previewGetPreviewA$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PreviewGetPreviewA> get values => _$previewGetPreviewAValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PreviewGetPreviewA valueOf(String name) => _$valueOfPreviewGetPreviewA(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for PreviewGetPreviewA.
  @BuiltValueSerializer(custom: true)
  static Serializer<PreviewGetPreviewA> get serializer => const _$PreviewGetPreviewASerializer();
}

class _$PreviewGetPreviewASerializer implements PrimitiveSerializer<PreviewGetPreviewA> {
  const _$PreviewGetPreviewASerializer();

  static const Map<PreviewGetPreviewA, Object> _toWire = <PreviewGetPreviewA, Object>{
    PreviewGetPreviewA.$0: 0,
    PreviewGetPreviewA.$1: 1,
  };

  static const Map<Object, PreviewGetPreviewA> _fromWire = <Object, PreviewGetPreviewA>{
    0: PreviewGetPreviewA.$0,
    1: PreviewGetPreviewA.$1,
  };

  @override
  Iterable<Type> get types => const [PreviewGetPreviewA];

  @override
  String get wireName => 'PreviewGetPreviewA';

  @override
  Object serialize(
    Serializers serializers,
    PreviewGetPreviewA object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PreviewGetPreviewA deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class PreviewGetPreviewForceIcon extends EnumClass {
  const PreviewGetPreviewForceIcon._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const PreviewGetPreviewForceIcon $0 = _$previewGetPreviewForceIcon$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const PreviewGetPreviewForceIcon $1 = _$previewGetPreviewForceIcon$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PreviewGetPreviewForceIcon> get values => _$previewGetPreviewForceIconValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PreviewGetPreviewForceIcon valueOf(String name) => _$valueOfPreviewGetPreviewForceIcon(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for PreviewGetPreviewForceIcon.
  @BuiltValueSerializer(custom: true)
  static Serializer<PreviewGetPreviewForceIcon> get serializer => const _$PreviewGetPreviewForceIconSerializer();
}

class _$PreviewGetPreviewForceIconSerializer implements PrimitiveSerializer<PreviewGetPreviewForceIcon> {
  const _$PreviewGetPreviewForceIconSerializer();

  static const Map<PreviewGetPreviewForceIcon, Object> _toWire = <PreviewGetPreviewForceIcon, Object>{
    PreviewGetPreviewForceIcon.$0: 0,
    PreviewGetPreviewForceIcon.$1: 1,
  };

  static const Map<Object, PreviewGetPreviewForceIcon> _fromWire = <Object, PreviewGetPreviewForceIcon>{
    0: PreviewGetPreviewForceIcon.$0,
    1: PreviewGetPreviewForceIcon.$1,
  };

  @override
  Iterable<Type> get types => const [PreviewGetPreviewForceIcon];

  @override
  String get wireName => 'PreviewGetPreviewForceIcon';

  @override
  Object serialize(
    Serializers serializers,
    PreviewGetPreviewForceIcon object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PreviewGetPreviewForceIcon deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class PreviewGetPreviewMode extends EnumClass {
  const PreviewGetPreviewMode._(super.name);

  /// `fill`
  static const PreviewGetPreviewMode fill = _$previewGetPreviewModeFill;

  /// `cover`
  static const PreviewGetPreviewMode cover = _$previewGetPreviewModeCover;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PreviewGetPreviewMode> get values => _$previewGetPreviewModeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PreviewGetPreviewMode valueOf(String name) => _$valueOfPreviewGetPreviewMode(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for PreviewGetPreviewMode.
  @BuiltValueSerializer(custom: true)
  static Serializer<PreviewGetPreviewMode> get serializer => const _$PreviewGetPreviewModeSerializer();
}

class _$PreviewGetPreviewModeSerializer implements PrimitiveSerializer<PreviewGetPreviewMode> {
  const _$PreviewGetPreviewModeSerializer();

  static const Map<PreviewGetPreviewMode, Object> _toWire = <PreviewGetPreviewMode, Object>{
    PreviewGetPreviewMode.fill: 'fill',
    PreviewGetPreviewMode.cover: 'cover',
  };

  static const Map<Object, PreviewGetPreviewMode> _fromWire = <Object, PreviewGetPreviewMode>{
    'fill': PreviewGetPreviewMode.fill,
    'cover': PreviewGetPreviewMode.cover,
  };

  @override
  Iterable<Type> get types => const [PreviewGetPreviewMode];

  @override
  String get wireName => 'PreviewGetPreviewMode';

  @override
  Object serialize(
    Serializers serializers,
    PreviewGetPreviewMode object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PreviewGetPreviewMode deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class PreviewGetPreviewMimeFallback extends EnumClass {
  const PreviewGetPreviewMimeFallback._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const PreviewGetPreviewMimeFallback $0 = _$previewGetPreviewMimeFallback$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const PreviewGetPreviewMimeFallback $1 = _$previewGetPreviewMimeFallback$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PreviewGetPreviewMimeFallback> get values => _$previewGetPreviewMimeFallbackValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PreviewGetPreviewMimeFallback valueOf(String name) => _$valueOfPreviewGetPreviewMimeFallback(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for PreviewGetPreviewMimeFallback.
  @BuiltValueSerializer(custom: true)
  static Serializer<PreviewGetPreviewMimeFallback> get serializer => const _$PreviewGetPreviewMimeFallbackSerializer();
}

class _$PreviewGetPreviewMimeFallbackSerializer implements PrimitiveSerializer<PreviewGetPreviewMimeFallback> {
  const _$PreviewGetPreviewMimeFallbackSerializer();

  static const Map<PreviewGetPreviewMimeFallback, Object> _toWire = <PreviewGetPreviewMimeFallback, Object>{
    PreviewGetPreviewMimeFallback.$0: 0,
    PreviewGetPreviewMimeFallback.$1: 1,
  };

  static const Map<Object, PreviewGetPreviewMimeFallback> _fromWire = <Object, PreviewGetPreviewMimeFallback>{
    0: PreviewGetPreviewMimeFallback.$0,
    1: PreviewGetPreviewMimeFallback.$1,
  };

  @override
  Iterable<Type> get types => const [PreviewGetPreviewMimeFallback];

  @override
  String get wireName => 'PreviewGetPreviewMimeFallback';

  @override
  Object serialize(
    Serializers serializers,
    PreviewGetPreviewMimeFallback object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PreviewGetPreviewMimeFallback deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class PreviewGetPreviewByFileIdA extends EnumClass {
  const PreviewGetPreviewByFileIdA._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const PreviewGetPreviewByFileIdA $0 = _$previewGetPreviewByFileIdA$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const PreviewGetPreviewByFileIdA $1 = _$previewGetPreviewByFileIdA$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PreviewGetPreviewByFileIdA> get values => _$previewGetPreviewByFileIdAValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PreviewGetPreviewByFileIdA valueOf(String name) => _$valueOfPreviewGetPreviewByFileIdA(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for PreviewGetPreviewByFileIdA.
  @BuiltValueSerializer(custom: true)
  static Serializer<PreviewGetPreviewByFileIdA> get serializer => const _$PreviewGetPreviewByFileIdASerializer();
}

class _$PreviewGetPreviewByFileIdASerializer implements PrimitiveSerializer<PreviewGetPreviewByFileIdA> {
  const _$PreviewGetPreviewByFileIdASerializer();

  static const Map<PreviewGetPreviewByFileIdA, Object> _toWire = <PreviewGetPreviewByFileIdA, Object>{
    PreviewGetPreviewByFileIdA.$0: 0,
    PreviewGetPreviewByFileIdA.$1: 1,
  };

  static const Map<Object, PreviewGetPreviewByFileIdA> _fromWire = <Object, PreviewGetPreviewByFileIdA>{
    0: PreviewGetPreviewByFileIdA.$0,
    1: PreviewGetPreviewByFileIdA.$1,
  };

  @override
  Iterable<Type> get types => const [PreviewGetPreviewByFileIdA];

  @override
  String get wireName => 'PreviewGetPreviewByFileIdA';

  @override
  Object serialize(
    Serializers serializers,
    PreviewGetPreviewByFileIdA object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PreviewGetPreviewByFileIdA deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class PreviewGetPreviewByFileIdForceIcon extends EnumClass {
  const PreviewGetPreviewByFileIdForceIcon._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const PreviewGetPreviewByFileIdForceIcon $0 = _$previewGetPreviewByFileIdForceIcon$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const PreviewGetPreviewByFileIdForceIcon $1 = _$previewGetPreviewByFileIdForceIcon$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PreviewGetPreviewByFileIdForceIcon> get values => _$previewGetPreviewByFileIdForceIconValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PreviewGetPreviewByFileIdForceIcon valueOf(String name) => _$valueOfPreviewGetPreviewByFileIdForceIcon(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for PreviewGetPreviewByFileIdForceIcon.
  @BuiltValueSerializer(custom: true)
  static Serializer<PreviewGetPreviewByFileIdForceIcon> get serializer =>
      const _$PreviewGetPreviewByFileIdForceIconSerializer();
}

class _$PreviewGetPreviewByFileIdForceIconSerializer
    implements PrimitiveSerializer<PreviewGetPreviewByFileIdForceIcon> {
  const _$PreviewGetPreviewByFileIdForceIconSerializer();

  static const Map<PreviewGetPreviewByFileIdForceIcon, Object> _toWire = <PreviewGetPreviewByFileIdForceIcon, Object>{
    PreviewGetPreviewByFileIdForceIcon.$0: 0,
    PreviewGetPreviewByFileIdForceIcon.$1: 1,
  };

  static const Map<Object, PreviewGetPreviewByFileIdForceIcon> _fromWire = <Object, PreviewGetPreviewByFileIdForceIcon>{
    0: PreviewGetPreviewByFileIdForceIcon.$0,
    1: PreviewGetPreviewByFileIdForceIcon.$1,
  };

  @override
  Iterable<Type> get types => const [PreviewGetPreviewByFileIdForceIcon];

  @override
  String get wireName => 'PreviewGetPreviewByFileIdForceIcon';

  @override
  Object serialize(
    Serializers serializers,
    PreviewGetPreviewByFileIdForceIcon object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PreviewGetPreviewByFileIdForceIcon deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class PreviewGetPreviewByFileIdMode extends EnumClass {
  const PreviewGetPreviewByFileIdMode._(super.name);

  /// `fill`
  static const PreviewGetPreviewByFileIdMode fill = _$previewGetPreviewByFileIdModeFill;

  /// `cover`
  static const PreviewGetPreviewByFileIdMode cover = _$previewGetPreviewByFileIdModeCover;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PreviewGetPreviewByFileIdMode> get values => _$previewGetPreviewByFileIdModeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PreviewGetPreviewByFileIdMode valueOf(String name) => _$valueOfPreviewGetPreviewByFileIdMode(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for PreviewGetPreviewByFileIdMode.
  @BuiltValueSerializer(custom: true)
  static Serializer<PreviewGetPreviewByFileIdMode> get serializer => const _$PreviewGetPreviewByFileIdModeSerializer();
}

class _$PreviewGetPreviewByFileIdModeSerializer implements PrimitiveSerializer<PreviewGetPreviewByFileIdMode> {
  const _$PreviewGetPreviewByFileIdModeSerializer();

  static const Map<PreviewGetPreviewByFileIdMode, Object> _toWire = <PreviewGetPreviewByFileIdMode, Object>{
    PreviewGetPreviewByFileIdMode.fill: 'fill',
    PreviewGetPreviewByFileIdMode.cover: 'cover',
  };

  static const Map<Object, PreviewGetPreviewByFileIdMode> _fromWire = <Object, PreviewGetPreviewByFileIdMode>{
    'fill': PreviewGetPreviewByFileIdMode.fill,
    'cover': PreviewGetPreviewByFileIdMode.cover,
  };

  @override
  Iterable<Type> get types => const [PreviewGetPreviewByFileIdMode];

  @override
  String get wireName => 'PreviewGetPreviewByFileIdMode';

  @override
  Object serialize(
    Serializers serializers,
    PreviewGetPreviewByFileIdMode object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PreviewGetPreviewByFileIdMode deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

class PreviewGetPreviewByFileIdMimeFallback extends EnumClass {
  const PreviewGetPreviewByFileIdMimeFallback._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const PreviewGetPreviewByFileIdMimeFallback $0 = _$previewGetPreviewByFileIdMimeFallback$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const PreviewGetPreviewByFileIdMimeFallback $1 = _$previewGetPreviewByFileIdMimeFallback$1;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<PreviewGetPreviewByFileIdMimeFallback> get values => _$previewGetPreviewByFileIdMimeFallbackValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static PreviewGetPreviewByFileIdMimeFallback valueOf(String name) =>
      _$valueOfPreviewGetPreviewByFileIdMimeFallback(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for PreviewGetPreviewByFileIdMimeFallback.
  @BuiltValueSerializer(custom: true)
  static Serializer<PreviewGetPreviewByFileIdMimeFallback> get serializer =>
      const _$PreviewGetPreviewByFileIdMimeFallbackSerializer();
}

class _$PreviewGetPreviewByFileIdMimeFallbackSerializer
    implements PrimitiveSerializer<PreviewGetPreviewByFileIdMimeFallback> {
  const _$PreviewGetPreviewByFileIdMimeFallbackSerializer();

  static const Map<PreviewGetPreviewByFileIdMimeFallback, Object> _toWire =
      <PreviewGetPreviewByFileIdMimeFallback, Object>{
    PreviewGetPreviewByFileIdMimeFallback.$0: 0,
    PreviewGetPreviewByFileIdMimeFallback.$1: 1,
  };

  static const Map<Object, PreviewGetPreviewByFileIdMimeFallback> _fromWire =
      <Object, PreviewGetPreviewByFileIdMimeFallback>{
    0: PreviewGetPreviewByFileIdMimeFallback.$0,
    1: PreviewGetPreviewByFileIdMimeFallback.$1,
  };

  @override
  Iterable<Type> get types => const [PreviewGetPreviewByFileIdMimeFallback];

  @override
  String get wireName => 'PreviewGetPreviewByFileIdMimeFallback';

  @override
  Object serialize(
    Serializers serializers,
    PreviewGetPreviewByFileIdMimeFallback object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  PreviewGetPreviewByFileIdMimeFallback deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $ProfileApiSetVisibilityRequestApplicationJsonInterface {
  /// ID of the parameter.
  String get paramId;

  /// New visibility.
  String get visibility;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ProfileApiSetVisibilityRequestApplicationJsonInterfaceBuilder].
  $ProfileApiSetVisibilityRequestApplicationJsonInterface rebuild(
    void Function($ProfileApiSetVisibilityRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ProfileApiSetVisibilityRequestApplicationJsonInterfaceBuilder].
  $ProfileApiSetVisibilityRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ProfileApiSetVisibilityRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ProfileApiSetVisibilityRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ProfileApiSetVisibilityRequestApplicationJson
    implements
        $ProfileApiSetVisibilityRequestApplicationJsonInterface,
        Built<ProfileApiSetVisibilityRequestApplicationJson, ProfileApiSetVisibilityRequestApplicationJsonBuilder> {
  /// Creates a new ProfileApiSetVisibilityRequestApplicationJson object using the builder pattern.
  factory ProfileApiSetVisibilityRequestApplicationJson([
    void Function(ProfileApiSetVisibilityRequestApplicationJsonBuilder)? b,
  ]) = _$ProfileApiSetVisibilityRequestApplicationJson;

  // coverage:ignore-start
  const ProfileApiSetVisibilityRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ProfileApiSetVisibilityRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ProfileApiSetVisibilityRequestApplicationJson.
  static Serializer<ProfileApiSetVisibilityRequestApplicationJson> get serializer =>
      _$profileApiSetVisibilityRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ProfileApiSetVisibilityRequestApplicationJsonBuilder b) {
    $ProfileApiSetVisibilityRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ProfileApiSetVisibilityRequestApplicationJsonBuilder b) {
    $ProfileApiSetVisibilityRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ProfileApiSetVisibilityResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ProfileApiSetVisibilityResponseApplicationJson_OcsInterfaceBuilder].
  $ProfileApiSetVisibilityResponseApplicationJson_OcsInterface rebuild(
    void Function($ProfileApiSetVisibilityResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ProfileApiSetVisibilityResponseApplicationJson_OcsInterfaceBuilder].
  $ProfileApiSetVisibilityResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ProfileApiSetVisibilityResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ProfileApiSetVisibilityResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ProfileApiSetVisibilityResponseApplicationJson_Ocs
    implements
        $ProfileApiSetVisibilityResponseApplicationJson_OcsInterface,
        Built<ProfileApiSetVisibilityResponseApplicationJson_Ocs,
            ProfileApiSetVisibilityResponseApplicationJson_OcsBuilder> {
  /// Creates a new ProfileApiSetVisibilityResponseApplicationJson_Ocs object using the builder pattern.
  factory ProfileApiSetVisibilityResponseApplicationJson_Ocs([
    void Function(ProfileApiSetVisibilityResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ProfileApiSetVisibilityResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ProfileApiSetVisibilityResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ProfileApiSetVisibilityResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ProfileApiSetVisibilityResponseApplicationJson_Ocs.
  static Serializer<ProfileApiSetVisibilityResponseApplicationJson_Ocs> get serializer =>
      _$profileApiSetVisibilityResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ProfileApiSetVisibilityResponseApplicationJson_OcsBuilder b) {
    $ProfileApiSetVisibilityResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ProfileApiSetVisibilityResponseApplicationJson_OcsBuilder b) {
    $ProfileApiSetVisibilityResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ProfileApiSetVisibilityResponseApplicationJsonInterface {
  ProfileApiSetVisibilityResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ProfileApiSetVisibilityResponseApplicationJsonInterfaceBuilder].
  $ProfileApiSetVisibilityResponseApplicationJsonInterface rebuild(
    void Function($ProfileApiSetVisibilityResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ProfileApiSetVisibilityResponseApplicationJsonInterfaceBuilder].
  $ProfileApiSetVisibilityResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ProfileApiSetVisibilityResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ProfileApiSetVisibilityResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ProfileApiSetVisibilityResponseApplicationJson
    implements
        $ProfileApiSetVisibilityResponseApplicationJsonInterface,
        Built<ProfileApiSetVisibilityResponseApplicationJson, ProfileApiSetVisibilityResponseApplicationJsonBuilder> {
  /// Creates a new ProfileApiSetVisibilityResponseApplicationJson object using the builder pattern.
  factory ProfileApiSetVisibilityResponseApplicationJson([
    void Function(ProfileApiSetVisibilityResponseApplicationJsonBuilder)? b,
  ]) = _$ProfileApiSetVisibilityResponseApplicationJson;

  // coverage:ignore-start
  const ProfileApiSetVisibilityResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ProfileApiSetVisibilityResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ProfileApiSetVisibilityResponseApplicationJson.
  static Serializer<ProfileApiSetVisibilityResponseApplicationJson> get serializer =>
      _$profileApiSetVisibilityResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ProfileApiSetVisibilityResponseApplicationJsonBuilder b) {
    $ProfileApiSetVisibilityResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ProfileApiSetVisibilityResponseApplicationJsonBuilder b) {
    $ProfileApiSetVisibilityResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiExtractRequestApplicationJsonInterface {
  static final _$resolve = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$limit = _$jsonSerializers.deserialize(
    1,
    specifiedType: const FullType(int),
  )! as int;

  /// Text to extract from.
  String get text;

  /// Resolve the references.
  bool get resolve;

  /// Maximum amount of references to extract.
  int get limit;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiExtractRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiExtractRequestApplicationJsonInterface rebuild(
    void Function($ReferenceApiExtractRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiExtractRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiExtractRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiExtractRequestApplicationJsonInterfaceBuilder b) {
    b.resolve = _$resolve;
    b.limit = _$limit;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiExtractRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiExtractRequestApplicationJson
    implements
        $ReferenceApiExtractRequestApplicationJsonInterface,
        Built<ReferenceApiExtractRequestApplicationJson, ReferenceApiExtractRequestApplicationJsonBuilder> {
  /// Creates a new ReferenceApiExtractRequestApplicationJson object using the builder pattern.
  factory ReferenceApiExtractRequestApplicationJson([
    void Function(ReferenceApiExtractRequestApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiExtractRequestApplicationJson;

  // coverage:ignore-start
  const ReferenceApiExtractRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiExtractRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiExtractRequestApplicationJson.
  static Serializer<ReferenceApiExtractRequestApplicationJson> get serializer =>
      _$referenceApiExtractRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiExtractRequestApplicationJsonBuilder b) {
    $ReferenceApiExtractRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiExtractRequestApplicationJsonBuilder b) {
    $ReferenceApiExtractRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceInterface {
  String get richObjectType;
  BuiltMap<String, JsonObject?> get richObject;
  OpenGraphObject get openGraphObject;
  bool get accessible;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceInterfaceBuilder].
  $ReferenceInterface rebuild(void Function($ReferenceInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ReferenceInterfaceBuilder].
  $ReferenceInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceInterfaceBuilder b) {}
}

abstract class Reference implements $ReferenceInterface, Built<Reference, ReferenceBuilder> {
  /// Creates a new Reference object using the builder pattern.
  factory Reference([void Function(ReferenceBuilder)? b]) = _$Reference;

  // coverage:ignore-start
  const Reference._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Reference.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Reference.
  static Serializer<Reference> get serializer => _$referenceSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceBuilder b) {
    $ReferenceInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceBuilder b) {
    $ReferenceInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiExtractResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, Reference?> get references;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiExtractResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiExtractResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ReferenceApiExtractResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiExtractResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiExtractResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiExtractResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiExtractResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ReferenceApiExtractResponseApplicationJson_Ocs_Data
    implements
        $ReferenceApiExtractResponseApplicationJson_Ocs_DataInterface,
        Built<ReferenceApiExtractResponseApplicationJson_Ocs_Data,
            ReferenceApiExtractResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ReferenceApiExtractResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ReferenceApiExtractResponseApplicationJson_Ocs_Data([
    void Function(ReferenceApiExtractResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ReferenceApiExtractResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ReferenceApiExtractResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiExtractResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiExtractResponseApplicationJson_Ocs_Data.
  static Serializer<ReferenceApiExtractResponseApplicationJson_Ocs_Data> get serializer =>
      _$referenceApiExtractResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiExtractResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiExtractResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiExtractResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiExtractResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiExtractResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ReferenceApiExtractResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiExtractResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiExtractResponseApplicationJson_OcsInterface rebuild(
    void Function($ReferenceApiExtractResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiExtractResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiExtractResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiExtractResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiExtractResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ReferenceApiExtractResponseApplicationJson_Ocs
    implements
        $ReferenceApiExtractResponseApplicationJson_OcsInterface,
        Built<ReferenceApiExtractResponseApplicationJson_Ocs, ReferenceApiExtractResponseApplicationJson_OcsBuilder> {
  /// Creates a new ReferenceApiExtractResponseApplicationJson_Ocs object using the builder pattern.
  factory ReferenceApiExtractResponseApplicationJson_Ocs([
    void Function(ReferenceApiExtractResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ReferenceApiExtractResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ReferenceApiExtractResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiExtractResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiExtractResponseApplicationJson_Ocs.
  static Serializer<ReferenceApiExtractResponseApplicationJson_Ocs> get serializer =>
      _$referenceApiExtractResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiExtractResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiExtractResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiExtractResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiExtractResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiExtractResponseApplicationJsonInterface {
  ReferenceApiExtractResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiExtractResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiExtractResponseApplicationJsonInterface rebuild(
    void Function($ReferenceApiExtractResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiExtractResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiExtractResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiExtractResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiExtractResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiExtractResponseApplicationJson
    implements
        $ReferenceApiExtractResponseApplicationJsonInterface,
        Built<ReferenceApiExtractResponseApplicationJson, ReferenceApiExtractResponseApplicationJsonBuilder> {
  /// Creates a new ReferenceApiExtractResponseApplicationJson object using the builder pattern.
  factory ReferenceApiExtractResponseApplicationJson([
    void Function(ReferenceApiExtractResponseApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiExtractResponseApplicationJson;

  // coverage:ignore-start
  const ReferenceApiExtractResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiExtractResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiExtractResponseApplicationJson.
  static Serializer<ReferenceApiExtractResponseApplicationJson> get serializer =>
      _$referenceApiExtractResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiExtractResponseApplicationJsonBuilder b) {
    $ReferenceApiExtractResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiExtractResponseApplicationJsonBuilder b) {
    $ReferenceApiExtractResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiExtractPublicRequestApplicationJsonInterface {
  static final _$resolve = _$jsonSerializers.deserialize(
    false,
    specifiedType: const FullType(bool),
  )! as bool;

  static final _$limit = _$jsonSerializers.deserialize(
    1,
    specifiedType: const FullType(int),
  )! as int;

  /// Text to extract from.
  String get text;

  /// Token of the public share.
  String get sharingToken;

  /// Resolve the references.
  bool get resolve;

  /// Maximum amount of references to extract, limited to 15.
  int get limit;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiExtractPublicRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiExtractPublicRequestApplicationJsonInterface rebuild(
    void Function($ReferenceApiExtractPublicRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiExtractPublicRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiExtractPublicRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiExtractPublicRequestApplicationJsonInterfaceBuilder b) {
    b.resolve = _$resolve;
    b.limit = _$limit;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiExtractPublicRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiExtractPublicRequestApplicationJson
    implements
        $ReferenceApiExtractPublicRequestApplicationJsonInterface,
        Built<ReferenceApiExtractPublicRequestApplicationJson, ReferenceApiExtractPublicRequestApplicationJsonBuilder> {
  /// Creates a new ReferenceApiExtractPublicRequestApplicationJson object using the builder pattern.
  factory ReferenceApiExtractPublicRequestApplicationJson([
    void Function(ReferenceApiExtractPublicRequestApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiExtractPublicRequestApplicationJson;

  // coverage:ignore-start
  const ReferenceApiExtractPublicRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiExtractPublicRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiExtractPublicRequestApplicationJson.
  static Serializer<ReferenceApiExtractPublicRequestApplicationJson> get serializer =>
      _$referenceApiExtractPublicRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiExtractPublicRequestApplicationJsonBuilder b) {
    $ReferenceApiExtractPublicRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiExtractPublicRequestApplicationJsonBuilder b) {
    $ReferenceApiExtractPublicRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, Reference?> get references;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data
    implements
        $ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterface,
        Built<ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data,
            ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data([
    void Function(ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data.
  static Serializer<ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data> get serializer =>
      _$referenceApiExtractPublicResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiExtractPublicResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiExtractPublicResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ReferenceApiExtractPublicResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiExtractPublicResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiExtractPublicResponseApplicationJson_OcsInterface rebuild(
    void Function($ReferenceApiExtractPublicResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiExtractPublicResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiExtractPublicResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiExtractPublicResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiExtractPublicResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ReferenceApiExtractPublicResponseApplicationJson_Ocs
    implements
        $ReferenceApiExtractPublicResponseApplicationJson_OcsInterface,
        Built<ReferenceApiExtractPublicResponseApplicationJson_Ocs,
            ReferenceApiExtractPublicResponseApplicationJson_OcsBuilder> {
  /// Creates a new ReferenceApiExtractPublicResponseApplicationJson_Ocs object using the builder pattern.
  factory ReferenceApiExtractPublicResponseApplicationJson_Ocs([
    void Function(ReferenceApiExtractPublicResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ReferenceApiExtractPublicResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ReferenceApiExtractPublicResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiExtractPublicResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiExtractPublicResponseApplicationJson_Ocs.
  static Serializer<ReferenceApiExtractPublicResponseApplicationJson_Ocs> get serializer =>
      _$referenceApiExtractPublicResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiExtractPublicResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiExtractPublicResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiExtractPublicResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiExtractPublicResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiExtractPublicResponseApplicationJsonInterface {
  ReferenceApiExtractPublicResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiExtractPublicResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiExtractPublicResponseApplicationJsonInterface rebuild(
    void Function($ReferenceApiExtractPublicResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiExtractPublicResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiExtractPublicResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiExtractPublicResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiExtractPublicResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiExtractPublicResponseApplicationJson
    implements
        $ReferenceApiExtractPublicResponseApplicationJsonInterface,
        Built<ReferenceApiExtractPublicResponseApplicationJson,
            ReferenceApiExtractPublicResponseApplicationJsonBuilder> {
  /// Creates a new ReferenceApiExtractPublicResponseApplicationJson object using the builder pattern.
  factory ReferenceApiExtractPublicResponseApplicationJson([
    void Function(ReferenceApiExtractPublicResponseApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiExtractPublicResponseApplicationJson;

  // coverage:ignore-start
  const ReferenceApiExtractPublicResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiExtractPublicResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiExtractPublicResponseApplicationJson.
  static Serializer<ReferenceApiExtractPublicResponseApplicationJson> get serializer =>
      _$referenceApiExtractPublicResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiExtractPublicResponseApplicationJsonBuilder b) {
    $ReferenceApiExtractPublicResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiExtractPublicResponseApplicationJsonBuilder b) {
    $ReferenceApiExtractPublicResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, Reference?> get references;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveOneResponseApplicationJson_Ocs_Data
    implements
        $ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterface,
        Built<ReferenceApiResolveOneResponseApplicationJson_Ocs_Data,
            ReferenceApiResolveOneResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ReferenceApiResolveOneResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ReferenceApiResolveOneResponseApplicationJson_Ocs_Data([
    void Function(ReferenceApiResolveOneResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ReferenceApiResolveOneResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ReferenceApiResolveOneResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveOneResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveOneResponseApplicationJson_Ocs_Data.
  static Serializer<ReferenceApiResolveOneResponseApplicationJson_Ocs_Data> get serializer =>
      _$referenceApiResolveOneResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveOneResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveOneResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiResolveOneResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveOneResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ReferenceApiResolveOneResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveOneResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiResolveOneResponseApplicationJson_OcsInterface rebuild(
    void Function($ReferenceApiResolveOneResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveOneResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiResolveOneResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveOneResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveOneResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveOneResponseApplicationJson_Ocs
    implements
        $ReferenceApiResolveOneResponseApplicationJson_OcsInterface,
        Built<ReferenceApiResolveOneResponseApplicationJson_Ocs,
            ReferenceApiResolveOneResponseApplicationJson_OcsBuilder> {
  /// Creates a new ReferenceApiResolveOneResponseApplicationJson_Ocs object using the builder pattern.
  factory ReferenceApiResolveOneResponseApplicationJson_Ocs([
    void Function(ReferenceApiResolveOneResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ReferenceApiResolveOneResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ReferenceApiResolveOneResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveOneResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveOneResponseApplicationJson_Ocs.
  static Serializer<ReferenceApiResolveOneResponseApplicationJson_Ocs> get serializer =>
      _$referenceApiResolveOneResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveOneResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiResolveOneResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveOneResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiResolveOneResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveOneResponseApplicationJsonInterface {
  ReferenceApiResolveOneResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveOneResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiResolveOneResponseApplicationJsonInterface rebuild(
    void Function($ReferenceApiResolveOneResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveOneResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiResolveOneResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveOneResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveOneResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveOneResponseApplicationJson
    implements
        $ReferenceApiResolveOneResponseApplicationJsonInterface,
        Built<ReferenceApiResolveOneResponseApplicationJson, ReferenceApiResolveOneResponseApplicationJsonBuilder> {
  /// Creates a new ReferenceApiResolveOneResponseApplicationJson object using the builder pattern.
  factory ReferenceApiResolveOneResponseApplicationJson([
    void Function(ReferenceApiResolveOneResponseApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiResolveOneResponseApplicationJson;

  // coverage:ignore-start
  const ReferenceApiResolveOneResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveOneResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveOneResponseApplicationJson.
  static Serializer<ReferenceApiResolveOneResponseApplicationJson> get serializer =>
      _$referenceApiResolveOneResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveOneResponseApplicationJsonBuilder b) {
    $ReferenceApiResolveOneResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveOneResponseApplicationJsonBuilder b) {
    $ReferenceApiResolveOneResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveRequestApplicationJsonInterface {
  static final _$limit = _$jsonSerializers.deserialize(
    1,
    specifiedType: const FullType(int),
  )! as int;

  /// References to resolve.
  BuiltList<String> get references;

  /// Maximum amount of references to resolve.
  int get limit;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiResolveRequestApplicationJsonInterface rebuild(
    void Function($ReferenceApiResolveRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiResolveRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveRequestApplicationJsonInterfaceBuilder b) {
    b.limit = _$limit;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveRequestApplicationJson
    implements
        $ReferenceApiResolveRequestApplicationJsonInterface,
        Built<ReferenceApiResolveRequestApplicationJson, ReferenceApiResolveRequestApplicationJsonBuilder> {
  /// Creates a new ReferenceApiResolveRequestApplicationJson object using the builder pattern.
  factory ReferenceApiResolveRequestApplicationJson([
    void Function(ReferenceApiResolveRequestApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiResolveRequestApplicationJson;

  // coverage:ignore-start
  const ReferenceApiResolveRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveRequestApplicationJson.
  static Serializer<ReferenceApiResolveRequestApplicationJson> get serializer =>
      _$referenceApiResolveRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveRequestApplicationJsonBuilder b) {
    $ReferenceApiResolveRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveRequestApplicationJsonBuilder b) {
    $ReferenceApiResolveRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, Reference?> get references;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiResolveResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ReferenceApiResolveResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiResolveResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveResponseApplicationJson_Ocs_Data
    implements
        $ReferenceApiResolveResponseApplicationJson_Ocs_DataInterface,
        Built<ReferenceApiResolveResponseApplicationJson_Ocs_Data,
            ReferenceApiResolveResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ReferenceApiResolveResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ReferenceApiResolveResponseApplicationJson_Ocs_Data([
    void Function(ReferenceApiResolveResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ReferenceApiResolveResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ReferenceApiResolveResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveResponseApplicationJson_Ocs_Data.
  static Serializer<ReferenceApiResolveResponseApplicationJson_Ocs_Data> get serializer =>
      _$referenceApiResolveResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiResolveResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiResolveResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ReferenceApiResolveResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiResolveResponseApplicationJson_OcsInterface rebuild(
    void Function($ReferenceApiResolveResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiResolveResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveResponseApplicationJson_Ocs
    implements
        $ReferenceApiResolveResponseApplicationJson_OcsInterface,
        Built<ReferenceApiResolveResponseApplicationJson_Ocs, ReferenceApiResolveResponseApplicationJson_OcsBuilder> {
  /// Creates a new ReferenceApiResolveResponseApplicationJson_Ocs object using the builder pattern.
  factory ReferenceApiResolveResponseApplicationJson_Ocs([
    void Function(ReferenceApiResolveResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ReferenceApiResolveResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ReferenceApiResolveResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveResponseApplicationJson_Ocs.
  static Serializer<ReferenceApiResolveResponseApplicationJson_Ocs> get serializer =>
      _$referenceApiResolveResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiResolveResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiResolveResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveResponseApplicationJsonInterface {
  ReferenceApiResolveResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiResolveResponseApplicationJsonInterface rebuild(
    void Function($ReferenceApiResolveResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiResolveResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveResponseApplicationJson
    implements
        $ReferenceApiResolveResponseApplicationJsonInterface,
        Built<ReferenceApiResolveResponseApplicationJson, ReferenceApiResolveResponseApplicationJsonBuilder> {
  /// Creates a new ReferenceApiResolveResponseApplicationJson object using the builder pattern.
  factory ReferenceApiResolveResponseApplicationJson([
    void Function(ReferenceApiResolveResponseApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiResolveResponseApplicationJson;

  // coverage:ignore-start
  const ReferenceApiResolveResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveResponseApplicationJson.
  static Serializer<ReferenceApiResolveResponseApplicationJson> get serializer =>
      _$referenceApiResolveResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveResponseApplicationJsonBuilder b) {
    $ReferenceApiResolveResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveResponseApplicationJsonBuilder b) {
    $ReferenceApiResolveResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, Reference?> get references;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data
    implements
        $ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterface,
        Built<ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data,
            ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data([
    void Function(ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data.
  static Serializer<ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data> get serializer =>
      _$referenceApiResolveOnePublicResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ReferenceApiResolveOnePublicResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterface rebuild(
    void Function($ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveOnePublicResponseApplicationJson_Ocs
    implements
        $ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterface,
        Built<ReferenceApiResolveOnePublicResponseApplicationJson_Ocs,
            ReferenceApiResolveOnePublicResponseApplicationJson_OcsBuilder> {
  /// Creates a new ReferenceApiResolveOnePublicResponseApplicationJson_Ocs object using the builder pattern.
  factory ReferenceApiResolveOnePublicResponseApplicationJson_Ocs([
    void Function(ReferenceApiResolveOnePublicResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ReferenceApiResolveOnePublicResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ReferenceApiResolveOnePublicResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveOnePublicResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveOnePublicResponseApplicationJson_Ocs.
  static Serializer<ReferenceApiResolveOnePublicResponseApplicationJson_Ocs> get serializer =>
      _$referenceApiResolveOnePublicResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveOnePublicResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveOnePublicResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiResolveOnePublicResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolveOnePublicResponseApplicationJsonInterface {
  ReferenceApiResolveOnePublicResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolveOnePublicResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiResolveOnePublicResponseApplicationJsonInterface rebuild(
    void Function($ReferenceApiResolveOnePublicResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolveOnePublicResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiResolveOnePublicResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolveOnePublicResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolveOnePublicResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiResolveOnePublicResponseApplicationJson
    implements
        $ReferenceApiResolveOnePublicResponseApplicationJsonInterface,
        Built<ReferenceApiResolveOnePublicResponseApplicationJson,
            ReferenceApiResolveOnePublicResponseApplicationJsonBuilder> {
  /// Creates a new ReferenceApiResolveOnePublicResponseApplicationJson object using the builder pattern.
  factory ReferenceApiResolveOnePublicResponseApplicationJson([
    void Function(ReferenceApiResolveOnePublicResponseApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiResolveOnePublicResponseApplicationJson;

  // coverage:ignore-start
  const ReferenceApiResolveOnePublicResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolveOnePublicResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolveOnePublicResponseApplicationJson.
  static Serializer<ReferenceApiResolveOnePublicResponseApplicationJson> get serializer =>
      _$referenceApiResolveOnePublicResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolveOnePublicResponseApplicationJsonBuilder b) {
    $ReferenceApiResolveOnePublicResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolveOnePublicResponseApplicationJsonBuilder b) {
    $ReferenceApiResolveOnePublicResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolvePublicRequestApplicationJsonInterface {
  static final _$limit = _$jsonSerializers.deserialize(
    1,
    specifiedType: const FullType(int),
  )! as int;

  /// References to resolve.
  BuiltList<String> get references;

  /// Token of the public share.
  String get sharingToken;

  /// Maximum amount of references to resolve, limited to 15.
  int get limit;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolvePublicRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiResolvePublicRequestApplicationJsonInterface rebuild(
    void Function($ReferenceApiResolvePublicRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolvePublicRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiResolvePublicRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolvePublicRequestApplicationJsonInterfaceBuilder b) {
    b.limit = _$limit;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolvePublicRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiResolvePublicRequestApplicationJson
    implements
        $ReferenceApiResolvePublicRequestApplicationJsonInterface,
        Built<ReferenceApiResolvePublicRequestApplicationJson, ReferenceApiResolvePublicRequestApplicationJsonBuilder> {
  /// Creates a new ReferenceApiResolvePublicRequestApplicationJson object using the builder pattern.
  factory ReferenceApiResolvePublicRequestApplicationJson([
    void Function(ReferenceApiResolvePublicRequestApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiResolvePublicRequestApplicationJson;

  // coverage:ignore-start
  const ReferenceApiResolvePublicRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolvePublicRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolvePublicRequestApplicationJson.
  static Serializer<ReferenceApiResolvePublicRequestApplicationJson> get serializer =>
      _$referenceApiResolvePublicRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolvePublicRequestApplicationJsonBuilder b) {
    $ReferenceApiResolvePublicRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolvePublicRequestApplicationJsonBuilder b) {
    $ReferenceApiResolvePublicRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, Reference?> get references;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data
    implements
        $ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterface,
        Built<ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data,
            ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data([
    void Function(ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data.
  static Serializer<ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data> get serializer =>
      _$referenceApiResolvePublicResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiResolvePublicResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolvePublicResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ReferenceApiResolvePublicResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolvePublicResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiResolvePublicResponseApplicationJson_OcsInterface rebuild(
    void Function($ReferenceApiResolvePublicResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolvePublicResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiResolvePublicResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolvePublicResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolvePublicResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ReferenceApiResolvePublicResponseApplicationJson_Ocs
    implements
        $ReferenceApiResolvePublicResponseApplicationJson_OcsInterface,
        Built<ReferenceApiResolvePublicResponseApplicationJson_Ocs,
            ReferenceApiResolvePublicResponseApplicationJson_OcsBuilder> {
  /// Creates a new ReferenceApiResolvePublicResponseApplicationJson_Ocs object using the builder pattern.
  factory ReferenceApiResolvePublicResponseApplicationJson_Ocs([
    void Function(ReferenceApiResolvePublicResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ReferenceApiResolvePublicResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ReferenceApiResolvePublicResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolvePublicResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolvePublicResponseApplicationJson_Ocs.
  static Serializer<ReferenceApiResolvePublicResponseApplicationJson_Ocs> get serializer =>
      _$referenceApiResolvePublicResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolvePublicResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiResolvePublicResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolvePublicResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiResolvePublicResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiResolvePublicResponseApplicationJsonInterface {
  ReferenceApiResolvePublicResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiResolvePublicResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiResolvePublicResponseApplicationJsonInterface rebuild(
    void Function($ReferenceApiResolvePublicResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiResolvePublicResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiResolvePublicResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiResolvePublicResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiResolvePublicResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiResolvePublicResponseApplicationJson
    implements
        $ReferenceApiResolvePublicResponseApplicationJsonInterface,
        Built<ReferenceApiResolvePublicResponseApplicationJson,
            ReferenceApiResolvePublicResponseApplicationJsonBuilder> {
  /// Creates a new ReferenceApiResolvePublicResponseApplicationJson object using the builder pattern.
  factory ReferenceApiResolvePublicResponseApplicationJson([
    void Function(ReferenceApiResolvePublicResponseApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiResolvePublicResponseApplicationJson;

  // coverage:ignore-start
  const ReferenceApiResolvePublicResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiResolvePublicResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiResolvePublicResponseApplicationJson.
  static Serializer<ReferenceApiResolvePublicResponseApplicationJson> get serializer =>
      _$referenceApiResolvePublicResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiResolvePublicResponseApplicationJsonBuilder b) {
    $ReferenceApiResolvePublicResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiResolvePublicResponseApplicationJsonBuilder b) {
    $ReferenceApiResolvePublicResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceProviderInterface {
  String get id;
  String get title;
  @BuiltValueField(wireName: 'icon_url')
  String get iconUrl;
  int get order;
  @BuiltValueField(wireName: 'search_providers_ids')
  BuiltList<String>? get searchProvidersIds;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceProviderInterfaceBuilder].
  $ReferenceProviderInterface rebuild(void Function($ReferenceProviderInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ReferenceProviderInterfaceBuilder].
  $ReferenceProviderInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceProviderInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceProviderInterfaceBuilder b) {}
}

abstract class ReferenceProvider
    implements $ReferenceProviderInterface, Built<ReferenceProvider, ReferenceProviderBuilder> {
  /// Creates a new ReferenceProvider object using the builder pattern.
  factory ReferenceProvider([void Function(ReferenceProviderBuilder)? b]) = _$ReferenceProvider;

  // coverage:ignore-start
  const ReferenceProvider._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceProvider.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceProvider.
  static Serializer<ReferenceProvider> get serializer => _$referenceProviderSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceProviderBuilder b) {
    $ReferenceProviderInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceProviderBuilder b) {
    $ReferenceProviderInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  BuiltList<ReferenceProvider> get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterface rebuild(
    void Function($ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs
    implements
        $ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterface,
        Built<ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs,
            ReferenceApiGetProvidersInfoResponseApplicationJson_OcsBuilder> {
  /// Creates a new ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs object using the builder pattern.
  factory ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs([
    void Function(ReferenceApiGetProvidersInfoResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs.
  static Serializer<ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs> get serializer =>
      _$referenceApiGetProvidersInfoResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiGetProvidersInfoResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiGetProvidersInfoResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiGetProvidersInfoResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiGetProvidersInfoResponseApplicationJsonInterface {
  ReferenceApiGetProvidersInfoResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiGetProvidersInfoResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiGetProvidersInfoResponseApplicationJsonInterface rebuild(
    void Function($ReferenceApiGetProvidersInfoResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiGetProvidersInfoResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiGetProvidersInfoResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiGetProvidersInfoResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiGetProvidersInfoResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiGetProvidersInfoResponseApplicationJson
    implements
        $ReferenceApiGetProvidersInfoResponseApplicationJsonInterface,
        Built<ReferenceApiGetProvidersInfoResponseApplicationJson,
            ReferenceApiGetProvidersInfoResponseApplicationJsonBuilder> {
  /// Creates a new ReferenceApiGetProvidersInfoResponseApplicationJson object using the builder pattern.
  factory ReferenceApiGetProvidersInfoResponseApplicationJson([
    void Function(ReferenceApiGetProvidersInfoResponseApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiGetProvidersInfoResponseApplicationJson;

  // coverage:ignore-start
  const ReferenceApiGetProvidersInfoResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiGetProvidersInfoResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiGetProvidersInfoResponseApplicationJson.
  static Serializer<ReferenceApiGetProvidersInfoResponseApplicationJson> get serializer =>
      _$referenceApiGetProvidersInfoResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiGetProvidersInfoResponseApplicationJsonBuilder b) {
    $ReferenceApiGetProvidersInfoResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiGetProvidersInfoResponseApplicationJsonBuilder b) {
    $ReferenceApiGetProvidersInfoResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiTouchProviderRequestApplicationJsonInterface {
  /// Timestamp of the last usage.
  int? get timestamp;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiTouchProviderRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiTouchProviderRequestApplicationJsonInterface rebuild(
    void Function($ReferenceApiTouchProviderRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiTouchProviderRequestApplicationJsonInterfaceBuilder].
  $ReferenceApiTouchProviderRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiTouchProviderRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiTouchProviderRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiTouchProviderRequestApplicationJson
    implements
        $ReferenceApiTouchProviderRequestApplicationJsonInterface,
        Built<ReferenceApiTouchProviderRequestApplicationJson, ReferenceApiTouchProviderRequestApplicationJsonBuilder> {
  /// Creates a new ReferenceApiTouchProviderRequestApplicationJson object using the builder pattern.
  factory ReferenceApiTouchProviderRequestApplicationJson([
    void Function(ReferenceApiTouchProviderRequestApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiTouchProviderRequestApplicationJson;

  // coverage:ignore-start
  const ReferenceApiTouchProviderRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiTouchProviderRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiTouchProviderRequestApplicationJson.
  static Serializer<ReferenceApiTouchProviderRequestApplicationJson> get serializer =>
      _$referenceApiTouchProviderRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiTouchProviderRequestApplicationJsonBuilder b) {
    $ReferenceApiTouchProviderRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiTouchProviderRequestApplicationJsonBuilder b) {
    $ReferenceApiTouchProviderRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterface {
  bool get success;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data
    implements
        $ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterface,
        Built<ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data,
            ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data([
    void Function(ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data.
  static Serializer<ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data> get serializer =>
      _$referenceApiTouchProviderResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataBuilder b) {
    $ReferenceApiTouchProviderResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiTouchProviderResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  ReferenceApiTouchProviderResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiTouchProviderResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiTouchProviderResponseApplicationJson_OcsInterface rebuild(
    void Function($ReferenceApiTouchProviderResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiTouchProviderResponseApplicationJson_OcsInterfaceBuilder].
  $ReferenceApiTouchProviderResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiTouchProviderResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiTouchProviderResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class ReferenceApiTouchProviderResponseApplicationJson_Ocs
    implements
        $ReferenceApiTouchProviderResponseApplicationJson_OcsInterface,
        Built<ReferenceApiTouchProviderResponseApplicationJson_Ocs,
            ReferenceApiTouchProviderResponseApplicationJson_OcsBuilder> {
  /// Creates a new ReferenceApiTouchProviderResponseApplicationJson_Ocs object using the builder pattern.
  factory ReferenceApiTouchProviderResponseApplicationJson_Ocs([
    void Function(ReferenceApiTouchProviderResponseApplicationJson_OcsBuilder)? b,
  ]) = _$ReferenceApiTouchProviderResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const ReferenceApiTouchProviderResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiTouchProviderResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiTouchProviderResponseApplicationJson_Ocs.
  static Serializer<ReferenceApiTouchProviderResponseApplicationJson_Ocs> get serializer =>
      _$referenceApiTouchProviderResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiTouchProviderResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiTouchProviderResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiTouchProviderResponseApplicationJson_OcsBuilder b) {
    $ReferenceApiTouchProviderResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $ReferenceApiTouchProviderResponseApplicationJsonInterface {
  ReferenceApiTouchProviderResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ReferenceApiTouchProviderResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiTouchProviderResponseApplicationJsonInterface rebuild(
    void Function($ReferenceApiTouchProviderResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$ReferenceApiTouchProviderResponseApplicationJsonInterfaceBuilder].
  $ReferenceApiTouchProviderResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ReferenceApiTouchProviderResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ReferenceApiTouchProviderResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class ReferenceApiTouchProviderResponseApplicationJson
    implements
        $ReferenceApiTouchProviderResponseApplicationJsonInterface,
        Built<ReferenceApiTouchProviderResponseApplicationJson,
            ReferenceApiTouchProviderResponseApplicationJsonBuilder> {
  /// Creates a new ReferenceApiTouchProviderResponseApplicationJson object using the builder pattern.
  factory ReferenceApiTouchProviderResponseApplicationJson([
    void Function(ReferenceApiTouchProviderResponseApplicationJsonBuilder)? b,
  ]) = _$ReferenceApiTouchProviderResponseApplicationJson;

  // coverage:ignore-start
  const ReferenceApiTouchProviderResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory ReferenceApiTouchProviderResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for ReferenceApiTouchProviderResponseApplicationJson.
  static Serializer<ReferenceApiTouchProviderResponseApplicationJson> get serializer =>
      _$referenceApiTouchProviderResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ReferenceApiTouchProviderResponseApplicationJsonBuilder b) {
    $ReferenceApiTouchProviderResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ReferenceApiTouchProviderResponseApplicationJsonBuilder b) {
    $ReferenceApiTouchProviderResponseApplicationJsonInterface._validate(b);
  }
}

class TaskProcessingShape_Type extends EnumClass {
  const TaskProcessingShape_Type._(super.name);

  /// `Number`
  @BuiltValueEnumConst(wireName: 'Number')
  static const TaskProcessingShape_Type number = _$taskProcessingShapeTypeNumber;

  /// `Text`
  @BuiltValueEnumConst(wireName: 'Text')
  static const TaskProcessingShape_Type text = _$taskProcessingShapeTypeText;

  /// `Audio`
  @BuiltValueEnumConst(wireName: 'Audio')
  static const TaskProcessingShape_Type audio = _$taskProcessingShapeTypeAudio;

  /// `Image`
  @BuiltValueEnumConst(wireName: 'Image')
  static const TaskProcessingShape_Type image = _$taskProcessingShapeTypeImage;

  /// `Video`
  @BuiltValueEnumConst(wireName: 'Video')
  static const TaskProcessingShape_Type video = _$taskProcessingShapeTypeVideo;

  /// `File`
  @BuiltValueEnumConst(wireName: 'File')
  static const TaskProcessingShape_Type file = _$taskProcessingShapeTypeFile;

  /// `Enum`
  @BuiltValueEnumConst(wireName: 'Enum')
  static const TaskProcessingShape_Type $enum = _$taskProcessingShapeType$enum;

  /// `ListOfNumbers`
  @BuiltValueEnumConst(wireName: 'ListOfNumbers')
  static const TaskProcessingShape_Type listOfNumbers = _$taskProcessingShapeTypeListOfNumbers;

  /// `ListOfTexts`
  @BuiltValueEnumConst(wireName: 'ListOfTexts')
  static const TaskProcessingShape_Type listOfTexts = _$taskProcessingShapeTypeListOfTexts;

  /// `ListOfImages`
  @BuiltValueEnumConst(wireName: 'ListOfImages')
  static const TaskProcessingShape_Type listOfImages = _$taskProcessingShapeTypeListOfImages;

  /// `ListOfAudios`
  @BuiltValueEnumConst(wireName: 'ListOfAudios')
  static const TaskProcessingShape_Type listOfAudios = _$taskProcessingShapeTypeListOfAudios;

  /// `ListOfVideos`
  @BuiltValueEnumConst(wireName: 'ListOfVideos')
  static const TaskProcessingShape_Type listOfVideos = _$taskProcessingShapeTypeListOfVideos;

  /// `ListOfFiles`
  @BuiltValueEnumConst(wireName: 'ListOfFiles')
  static const TaskProcessingShape_Type listOfFiles = _$taskProcessingShapeTypeListOfFiles;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<TaskProcessingShape_Type> get values => _$taskProcessingShapeTypeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static TaskProcessingShape_Type valueOf(String name) => _$valueOfTaskProcessingShape_Type(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for TaskProcessingShape_Type.
  @BuiltValueSerializer(custom: true)
  static Serializer<TaskProcessingShape_Type> get serializer => const _$TaskProcessingShape_TypeSerializer();
}

class _$TaskProcessingShape_TypeSerializer implements PrimitiveSerializer<TaskProcessingShape_Type> {
  const _$TaskProcessingShape_TypeSerializer();

  static const Map<TaskProcessingShape_Type, Object> _toWire = <TaskProcessingShape_Type, Object>{
    TaskProcessingShape_Type.number: 'Number',
    TaskProcessingShape_Type.text: 'Text',
    TaskProcessingShape_Type.audio: 'Audio',
    TaskProcessingShape_Type.image: 'Image',
    TaskProcessingShape_Type.video: 'Video',
    TaskProcessingShape_Type.file: 'File',
    TaskProcessingShape_Type.$enum: 'Enum',
    TaskProcessingShape_Type.listOfNumbers: 'ListOfNumbers',
    TaskProcessingShape_Type.listOfTexts: 'ListOfTexts',
    TaskProcessingShape_Type.listOfImages: 'ListOfImages',
    TaskProcessingShape_Type.listOfAudios: 'ListOfAudios',
    TaskProcessingShape_Type.listOfVideos: 'ListOfVideos',
    TaskProcessingShape_Type.listOfFiles: 'ListOfFiles',
  };

  static const Map<Object, TaskProcessingShape_Type> _fromWire = <Object, TaskProcessingShape_Type>{
    'Number': TaskProcessingShape_Type.number,
    'Text': TaskProcessingShape_Type.text,
    'Audio': TaskProcessingShape_Type.audio,
    'Image': TaskProcessingShape_Type.image,
    'Video': TaskProcessingShape_Type.video,
    'File': TaskProcessingShape_Type.file,
    'Enum': TaskProcessingShape_Type.$enum,
    'ListOfNumbers': TaskProcessingShape_Type.listOfNumbers,
    'ListOfTexts': TaskProcessingShape_Type.listOfTexts,
    'ListOfImages': TaskProcessingShape_Type.listOfImages,
    'ListOfAudios': TaskProcessingShape_Type.listOfAudios,
    'ListOfVideos': TaskProcessingShape_Type.listOfVideos,
    'ListOfFiles': TaskProcessingShape_Type.listOfFiles,
  };

  @override
  Iterable<Type> get types => const [TaskProcessingShape_Type];

  @override
  String get wireName => 'TaskProcessingShape_Type';

  @override
  Object serialize(
    Serializers serializers,
    TaskProcessingShape_Type object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  TaskProcessingShape_Type deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingShapeInterface {
  String get name;
  String get description;
  TaskProcessingShape_Type get type;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingShapeInterfaceBuilder].
  $TaskProcessingShapeInterface rebuild(void Function($TaskProcessingShapeInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TaskProcessingShapeInterfaceBuilder].
  $TaskProcessingShapeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingShapeInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingShapeInterfaceBuilder b) {}
}

abstract class TaskProcessingShape
    implements $TaskProcessingShapeInterface, Built<TaskProcessingShape, TaskProcessingShapeBuilder> {
  /// Creates a new TaskProcessingShape object using the builder pattern.
  factory TaskProcessingShape([void Function(TaskProcessingShapeBuilder)? b]) = _$TaskProcessingShape;

  // coverage:ignore-start
  const TaskProcessingShape._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingShape.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingShape.
  static Serializer<TaskProcessingShape> get serializer => _$taskProcessingShapeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingShapeBuilder b) {
    $TaskProcessingShapeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingShapeBuilder b) {
    $TaskProcessingShapeInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingTaskType_InputShapeEnumValuesInterface {
  String get name;
  String get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingTaskType_InputShapeEnumValuesInterfaceBuilder].
  $TaskProcessingTaskType_InputShapeEnumValuesInterface rebuild(
    void Function($TaskProcessingTaskType_InputShapeEnumValuesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingTaskType_InputShapeEnumValuesInterfaceBuilder].
  $TaskProcessingTaskType_InputShapeEnumValuesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingTaskType_InputShapeEnumValuesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingTaskType_InputShapeEnumValuesInterfaceBuilder b) {}
}

abstract class TaskProcessingTaskType_InputShapeEnumValues
    implements
        $TaskProcessingTaskType_InputShapeEnumValuesInterface,
        Built<TaskProcessingTaskType_InputShapeEnumValues, TaskProcessingTaskType_InputShapeEnumValuesBuilder> {
  /// Creates a new TaskProcessingTaskType_InputShapeEnumValues object using the builder pattern.
  factory TaskProcessingTaskType_InputShapeEnumValues([
    void Function(TaskProcessingTaskType_InputShapeEnumValuesBuilder)? b,
  ]) = _$TaskProcessingTaskType_InputShapeEnumValues;

  // coverage:ignore-start
  const TaskProcessingTaskType_InputShapeEnumValues._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingTaskType_InputShapeEnumValues.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingTaskType_InputShapeEnumValues.
  static Serializer<TaskProcessingTaskType_InputShapeEnumValues> get serializer =>
      _$taskProcessingTaskTypeInputShapeEnumValuesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingTaskType_InputShapeEnumValuesBuilder b) {
    $TaskProcessingTaskType_InputShapeEnumValuesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingTaskType_InputShapeEnumValuesBuilder b) {
    $TaskProcessingTaskType_InputShapeEnumValuesInterface._validate(b);
  }
}

typedef TaskProcessingTaskType_InputShapeDefaults = ({num? $num, String? string});

@BuiltValue(instantiable: false)
sealed class $TaskProcessingTaskType_OptionalInputShapeEnumValuesInterface {
  String get name;
  String get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingTaskType_OptionalInputShapeEnumValuesInterfaceBuilder].
  $TaskProcessingTaskType_OptionalInputShapeEnumValuesInterface rebuild(
    void Function($TaskProcessingTaskType_OptionalInputShapeEnumValuesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingTaskType_OptionalInputShapeEnumValuesInterfaceBuilder].
  $TaskProcessingTaskType_OptionalInputShapeEnumValuesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingTaskType_OptionalInputShapeEnumValuesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingTaskType_OptionalInputShapeEnumValuesInterfaceBuilder b) {}
}

abstract class TaskProcessingTaskType_OptionalInputShapeEnumValues
    implements
        $TaskProcessingTaskType_OptionalInputShapeEnumValuesInterface,
        Built<TaskProcessingTaskType_OptionalInputShapeEnumValues,
            TaskProcessingTaskType_OptionalInputShapeEnumValuesBuilder> {
  /// Creates a new TaskProcessingTaskType_OptionalInputShapeEnumValues object using the builder pattern.
  factory TaskProcessingTaskType_OptionalInputShapeEnumValues([
    void Function(TaskProcessingTaskType_OptionalInputShapeEnumValuesBuilder)? b,
  ]) = _$TaskProcessingTaskType_OptionalInputShapeEnumValues;

  // coverage:ignore-start
  const TaskProcessingTaskType_OptionalInputShapeEnumValues._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingTaskType_OptionalInputShapeEnumValues.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingTaskType_OptionalInputShapeEnumValues.
  static Serializer<TaskProcessingTaskType_OptionalInputShapeEnumValues> get serializer =>
      _$taskProcessingTaskTypeOptionalInputShapeEnumValuesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingTaskType_OptionalInputShapeEnumValuesBuilder b) {
    $TaskProcessingTaskType_OptionalInputShapeEnumValuesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingTaskType_OptionalInputShapeEnumValuesBuilder b) {
    $TaskProcessingTaskType_OptionalInputShapeEnumValuesInterface._validate(b);
  }
}

typedef TaskProcessingTaskType_OptionalInputShapeDefaults = ({num? $num, String? string});

@BuiltValue(instantiable: false)
sealed class $TaskProcessingTaskType_OutputShapeEnumValuesInterface {
  String get name;
  String get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingTaskType_OutputShapeEnumValuesInterfaceBuilder].
  $TaskProcessingTaskType_OutputShapeEnumValuesInterface rebuild(
    void Function($TaskProcessingTaskType_OutputShapeEnumValuesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingTaskType_OutputShapeEnumValuesInterfaceBuilder].
  $TaskProcessingTaskType_OutputShapeEnumValuesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingTaskType_OutputShapeEnumValuesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingTaskType_OutputShapeEnumValuesInterfaceBuilder b) {}
}

abstract class TaskProcessingTaskType_OutputShapeEnumValues
    implements
        $TaskProcessingTaskType_OutputShapeEnumValuesInterface,
        Built<TaskProcessingTaskType_OutputShapeEnumValues, TaskProcessingTaskType_OutputShapeEnumValuesBuilder> {
  /// Creates a new TaskProcessingTaskType_OutputShapeEnumValues object using the builder pattern.
  factory TaskProcessingTaskType_OutputShapeEnumValues([
    void Function(TaskProcessingTaskType_OutputShapeEnumValuesBuilder)? b,
  ]) = _$TaskProcessingTaskType_OutputShapeEnumValues;

  // coverage:ignore-start
  const TaskProcessingTaskType_OutputShapeEnumValues._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingTaskType_OutputShapeEnumValues.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingTaskType_OutputShapeEnumValues.
  static Serializer<TaskProcessingTaskType_OutputShapeEnumValues> get serializer =>
      _$taskProcessingTaskTypeOutputShapeEnumValuesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingTaskType_OutputShapeEnumValuesBuilder b) {
    $TaskProcessingTaskType_OutputShapeEnumValuesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingTaskType_OutputShapeEnumValuesBuilder b) {
    $TaskProcessingTaskType_OutputShapeEnumValuesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterface {
  String get name;
  String get value;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterfaceBuilder].
  $TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterface rebuild(
    void Function($TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterfaceBuilder].
  $TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterfaceBuilder b) {}
}

abstract class TaskProcessingTaskType_OptionalOutputShapeEnumValues
    implements
        $TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterface,
        Built<TaskProcessingTaskType_OptionalOutputShapeEnumValues,
            TaskProcessingTaskType_OptionalOutputShapeEnumValuesBuilder> {
  /// Creates a new TaskProcessingTaskType_OptionalOutputShapeEnumValues object using the builder pattern.
  factory TaskProcessingTaskType_OptionalOutputShapeEnumValues([
    void Function(TaskProcessingTaskType_OptionalOutputShapeEnumValuesBuilder)? b,
  ]) = _$TaskProcessingTaskType_OptionalOutputShapeEnumValues;

  // coverage:ignore-start
  const TaskProcessingTaskType_OptionalOutputShapeEnumValues._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingTaskType_OptionalOutputShapeEnumValues.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingTaskType_OptionalOutputShapeEnumValues.
  static Serializer<TaskProcessingTaskType_OptionalOutputShapeEnumValues> get serializer =>
      _$taskProcessingTaskTypeOptionalOutputShapeEnumValuesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingTaskType_OptionalOutputShapeEnumValuesBuilder b) {
    $TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingTaskType_OptionalOutputShapeEnumValuesBuilder b) {
    $TaskProcessingTaskType_OptionalOutputShapeEnumValuesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingTaskTypeInterface {
  String get name;
  String get description;
  BuiltList<TaskProcessingShape> get inputShape;
  BuiltList<BuiltList<TaskProcessingTaskType_InputShapeEnumValues>> get inputShapeEnumValues;
  BuiltMap<String, TaskProcessingTaskType_InputShapeDefaults> get inputShapeDefaults;
  BuiltList<TaskProcessingShape> get optionalInputShape;
  BuiltList<BuiltList<TaskProcessingTaskType_OptionalInputShapeEnumValues>> get optionalInputShapeEnumValues;
  BuiltMap<String, TaskProcessingTaskType_OptionalInputShapeDefaults> get optionalInputShapeDefaults;
  BuiltList<TaskProcessingShape> get outputShape;
  BuiltList<BuiltList<TaskProcessingTaskType_OutputShapeEnumValues>> get outputShapeEnumValues;
  BuiltList<TaskProcessingShape> get optionalOutputShape;
  BuiltList<BuiltList<TaskProcessingTaskType_OptionalOutputShapeEnumValues>> get optionalOutputShapeEnumValues;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingTaskTypeInterfaceBuilder].
  $TaskProcessingTaskTypeInterface rebuild(void Function($TaskProcessingTaskTypeInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TaskProcessingTaskTypeInterfaceBuilder].
  $TaskProcessingTaskTypeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingTaskTypeInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingTaskTypeInterfaceBuilder b) {}
}

abstract class TaskProcessingTaskType
    implements $TaskProcessingTaskTypeInterface, Built<TaskProcessingTaskType, TaskProcessingTaskTypeBuilder> {
  /// Creates a new TaskProcessingTaskType object using the builder pattern.
  factory TaskProcessingTaskType([void Function(TaskProcessingTaskTypeBuilder)? b]) = _$TaskProcessingTaskType;

  // coverage:ignore-start
  const TaskProcessingTaskType._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingTaskType.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingTaskType.
  static Serializer<TaskProcessingTaskType> get serializer => _$taskProcessingTaskTypeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingTaskTypeBuilder b) {
    $TaskProcessingTaskTypeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingTaskTypeBuilder b) {
    $TaskProcessingTaskTypeInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface {
  BuiltMap<String, TaskProcessingTaskType> get types;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data,
            TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiTaskTypesResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiTaskTypesResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiTaskTypesResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiTaskTypesResponseApplicationJson_Ocs,
            TaskProcessingApiTaskTypesResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiTaskTypesResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiTaskTypesResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiTaskTypesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiTaskTypesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiTaskTypesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiTaskTypesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiTaskTypesResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiTaskTypesResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiTaskTypesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiTaskTypesResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiTaskTypesResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiTaskTypesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiTaskTypesResponseApplicationJsonInterface {
  TaskProcessingApiTaskTypesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiTaskTypesResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiTaskTypesResponseApplicationJson
    implements
        $TaskProcessingApiTaskTypesResponseApplicationJsonInterface,
        Built<TaskProcessingApiTaskTypesResponseApplicationJson,
            TaskProcessingApiTaskTypesResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiTaskTypesResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiTaskTypesResponseApplicationJson([
    void Function(TaskProcessingApiTaskTypesResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiTaskTypesResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiTaskTypesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiTaskTypesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiTaskTypesResponseApplicationJson.
  static Serializer<TaskProcessingApiTaskTypesResponseApplicationJson> get serializer =>
      _$taskProcessingApiTaskTypesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiTaskTypesResponseApplicationJsonBuilder b) {
    $TaskProcessingApiTaskTypesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiTaskTypesResponseApplicationJsonBuilder b) {
    $TaskProcessingApiTaskTypesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiScheduleRequestApplicationJsonInterface {
  static final _$customId = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// Task's input parameters.
  BuiltMap<String, JsonObject> get input;

  /// Type of the task.
  String get type;

  /// ID of the app that will execute the task.
  String get appId;

  /// An arbitrary identifier for the task.
  String get customId;

  /// URI to be requested when the task finishes.
  String? get webhookUri;

  /// Method used for the webhook request (HTTP:GET, HTTP:POST, HTTP:PUT, HTTP:DELETE or AppAPI:APP_ID:GET, AppAPI:APP_ID:POST...).
  String? get webhookMethod;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiScheduleRequestApplicationJsonInterfaceBuilder].
  $TaskProcessingApiScheduleRequestApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiScheduleRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiScheduleRequestApplicationJsonInterfaceBuilder].
  $TaskProcessingApiScheduleRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiScheduleRequestApplicationJsonInterfaceBuilder b) {
    b.customId = _$customId;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiScheduleRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiScheduleRequestApplicationJson
    implements
        $TaskProcessingApiScheduleRequestApplicationJsonInterface,
        Built<TaskProcessingApiScheduleRequestApplicationJson, TaskProcessingApiScheduleRequestApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiScheduleRequestApplicationJson object using the builder pattern.
  factory TaskProcessingApiScheduleRequestApplicationJson([
    void Function(TaskProcessingApiScheduleRequestApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiScheduleRequestApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiScheduleRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiScheduleRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiScheduleRequestApplicationJson.
  static Serializer<TaskProcessingApiScheduleRequestApplicationJson> get serializer =>
      _$taskProcessingApiScheduleRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiScheduleRequestApplicationJsonBuilder b) {
    $TaskProcessingApiScheduleRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiScheduleRequestApplicationJsonBuilder b) {
    $TaskProcessingApiScheduleRequestApplicationJsonInterface._validate(b);
  }
}

class TaskProcessingTask_Status extends EnumClass {
  const TaskProcessingTask_Status._(super.name);

  /// `STATUS_CANCELLED`
  @BuiltValueEnumConst(wireName: 'STATUS_CANCELLED')
  static const TaskProcessingTask_Status sTATUSCANCELLED = _$taskProcessingTaskStatusSTATUSCANCELLED;

  /// `STATUS_FAILED`
  @BuiltValueEnumConst(wireName: 'STATUS_FAILED')
  static const TaskProcessingTask_Status sTATUSFAILED = _$taskProcessingTaskStatusSTATUSFAILED;

  /// `STATUS_SUCCESSFUL`
  @BuiltValueEnumConst(wireName: 'STATUS_SUCCESSFUL')
  static const TaskProcessingTask_Status sTATUSSUCCESSFUL = _$taskProcessingTaskStatusSTATUSSUCCESSFUL;

  /// `STATUS_RUNNING`
  @BuiltValueEnumConst(wireName: 'STATUS_RUNNING')
  static const TaskProcessingTask_Status sTATUSRUNNING = _$taskProcessingTaskStatusSTATUSRUNNING;

  /// `STATUS_SCHEDULED`
  @BuiltValueEnumConst(wireName: 'STATUS_SCHEDULED')
  static const TaskProcessingTask_Status sTATUSSCHEDULED = _$taskProcessingTaskStatusSTATUSSCHEDULED;

  /// `STATUS_UNKNOWN`
  @BuiltValueEnumConst(wireName: 'STATUS_UNKNOWN')
  static const TaskProcessingTask_Status sTATUSUNKNOWN = _$taskProcessingTaskStatusSTATUSUNKNOWN;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<TaskProcessingTask_Status> get values => _$taskProcessingTaskStatusValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static TaskProcessingTask_Status valueOf(String name) => _$valueOfTaskProcessingTask_Status(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for TaskProcessingTask_Status.
  @BuiltValueSerializer(custom: true)
  static Serializer<TaskProcessingTask_Status> get serializer => const _$TaskProcessingTask_StatusSerializer();
}

class _$TaskProcessingTask_StatusSerializer implements PrimitiveSerializer<TaskProcessingTask_Status> {
  const _$TaskProcessingTask_StatusSerializer();

  static const Map<TaskProcessingTask_Status, Object> _toWire = <TaskProcessingTask_Status, Object>{
    TaskProcessingTask_Status.sTATUSCANCELLED: 'STATUS_CANCELLED',
    TaskProcessingTask_Status.sTATUSFAILED: 'STATUS_FAILED',
    TaskProcessingTask_Status.sTATUSSUCCESSFUL: 'STATUS_SUCCESSFUL',
    TaskProcessingTask_Status.sTATUSRUNNING: 'STATUS_RUNNING',
    TaskProcessingTask_Status.sTATUSSCHEDULED: 'STATUS_SCHEDULED',
    TaskProcessingTask_Status.sTATUSUNKNOWN: 'STATUS_UNKNOWN',
  };

  static const Map<Object, TaskProcessingTask_Status> _fromWire = <Object, TaskProcessingTask_Status>{
    'STATUS_CANCELLED': TaskProcessingTask_Status.sTATUSCANCELLED,
    'STATUS_FAILED': TaskProcessingTask_Status.sTATUSFAILED,
    'STATUS_SUCCESSFUL': TaskProcessingTask_Status.sTATUSSUCCESSFUL,
    'STATUS_RUNNING': TaskProcessingTask_Status.sTATUSRUNNING,
    'STATUS_SCHEDULED': TaskProcessingTask_Status.sTATUSSCHEDULED,
    'STATUS_UNKNOWN': TaskProcessingTask_Status.sTATUSUNKNOWN,
  };

  @override
  Iterable<Type> get types => const [TaskProcessingTask_Status];

  @override
  String get wireName => 'TaskProcessingTask_Status';

  @override
  Object serialize(
    Serializers serializers,
    TaskProcessingTask_Status object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  TaskProcessingTask_Status deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

typedef TaskProcessingIO = ({
  BuiltList<num>? builtListNum,
  BuiltList<String>? builtListString,
  num? $num,
  String? string
});

@BuiltValue(instantiable: false)
sealed class $TaskProcessingTaskInterface {
  int get id;
  int get lastUpdated;
  String get type;
  TaskProcessingTask_Status get status;
  String? get userId;
  String get appId;
  BuiltMap<String, TaskProcessingIO> get input;
  BuiltMap<String, TaskProcessingIO>? get output;
  String? get customId;
  int? get completionExpectedAt;
  double? get progress;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingTaskInterfaceBuilder].
  $TaskProcessingTaskInterface rebuild(void Function($TaskProcessingTaskInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TaskProcessingTaskInterfaceBuilder].
  $TaskProcessingTaskInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingTaskInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingTaskInterfaceBuilder b) {}
}

abstract class TaskProcessingTask
    implements $TaskProcessingTaskInterface, Built<TaskProcessingTask, TaskProcessingTaskBuilder> {
  /// Creates a new TaskProcessingTask object using the builder pattern.
  factory TaskProcessingTask([void Function(TaskProcessingTaskBuilder)? b]) = _$TaskProcessingTask;

  // coverage:ignore-start
  const TaskProcessingTask._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingTask.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingTask.
  static Serializer<TaskProcessingTask> get serializer => _$taskProcessingTaskSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingTaskBuilder b) {
    $TaskProcessingTaskInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingTaskBuilder b) {
    $TaskProcessingTaskInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface {
  TaskProcessingTask get task;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data,
            TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiScheduleResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiScheduleResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiScheduleResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiScheduleResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiScheduleResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiScheduleResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiScheduleResponseApplicationJson_Ocs,
            TaskProcessingApiScheduleResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiScheduleResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiScheduleResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiScheduleResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiScheduleResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiScheduleResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiScheduleResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiScheduleResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiScheduleResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiScheduleResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiScheduleResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiScheduleResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiScheduleResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiScheduleResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiScheduleResponseApplicationJsonInterface {
  TaskProcessingApiScheduleResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiScheduleResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiScheduleResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiScheduleResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiScheduleResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiScheduleResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiScheduleResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiScheduleResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiScheduleResponseApplicationJson
    implements
        $TaskProcessingApiScheduleResponseApplicationJsonInterface,
        Built<TaskProcessingApiScheduleResponseApplicationJson,
            TaskProcessingApiScheduleResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiScheduleResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiScheduleResponseApplicationJson([
    void Function(TaskProcessingApiScheduleResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiScheduleResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiScheduleResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiScheduleResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiScheduleResponseApplicationJson.
  static Serializer<TaskProcessingApiScheduleResponseApplicationJson> get serializer =>
      _$taskProcessingApiScheduleResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiScheduleResponseApplicationJsonBuilder b) {
    $TaskProcessingApiScheduleResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiScheduleResponseApplicationJsonBuilder b) {
    $TaskProcessingApiScheduleResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface {
  TaskProcessingTask get task;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data,
            TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiGetTaskResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiGetTaskResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiGetTaskResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiGetTaskResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiGetTaskResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiGetTaskResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiGetTaskResponseApplicationJson_Ocs,
            TaskProcessingApiGetTaskResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiGetTaskResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiGetTaskResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiGetTaskResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiGetTaskResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiGetTaskResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiGetTaskResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiGetTaskResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiGetTaskResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiGetTaskResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiGetTaskResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiGetTaskResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiGetTaskResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiGetTaskResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiGetTaskResponseApplicationJsonInterface {
  TaskProcessingApiGetTaskResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiGetTaskResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiGetTaskResponseApplicationJson
    implements
        $TaskProcessingApiGetTaskResponseApplicationJsonInterface,
        Built<TaskProcessingApiGetTaskResponseApplicationJson, TaskProcessingApiGetTaskResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiGetTaskResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiGetTaskResponseApplicationJson([
    void Function(TaskProcessingApiGetTaskResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiGetTaskResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiGetTaskResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiGetTaskResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiGetTaskResponseApplicationJson.
  static Serializer<TaskProcessingApiGetTaskResponseApplicationJson> get serializer =>
      _$taskProcessingApiGetTaskResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiGetTaskResponseApplicationJsonBuilder b) {
    $TaskProcessingApiGetTaskResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiGetTaskResponseApplicationJsonBuilder b) {
    $TaskProcessingApiGetTaskResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  JsonObject? get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs,
            TaskProcessingApiDeleteTaskResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiDeleteTaskResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiDeleteTaskResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiDeleteTaskResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiDeleteTaskResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiDeleteTaskResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiDeleteTaskResponseApplicationJsonInterface {
  TaskProcessingApiDeleteTaskResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiDeleteTaskResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiDeleteTaskResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiDeleteTaskResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiDeleteTaskResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiDeleteTaskResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiDeleteTaskResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiDeleteTaskResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiDeleteTaskResponseApplicationJson
    implements
        $TaskProcessingApiDeleteTaskResponseApplicationJsonInterface,
        Built<TaskProcessingApiDeleteTaskResponseApplicationJson,
            TaskProcessingApiDeleteTaskResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiDeleteTaskResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiDeleteTaskResponseApplicationJson([
    void Function(TaskProcessingApiDeleteTaskResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiDeleteTaskResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiDeleteTaskResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiDeleteTaskResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiDeleteTaskResponseApplicationJson.
  static Serializer<TaskProcessingApiDeleteTaskResponseApplicationJson> get serializer =>
      _$taskProcessingApiDeleteTaskResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiDeleteTaskResponseApplicationJsonBuilder b) {
    $TaskProcessingApiDeleteTaskResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiDeleteTaskResponseApplicationJsonBuilder b) {
    $TaskProcessingApiDeleteTaskResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterface {
  BuiltList<TaskProcessingTask> get tasks;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data,
            TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiListTasksByAppResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs,
            TaskProcessingApiListTasksByAppResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiListTasksByAppResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiListTasksByAppResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiListTasksByAppResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiListTasksByAppResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiListTasksByAppResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiListTasksByAppResponseApplicationJsonInterface {
  TaskProcessingApiListTasksByAppResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiListTasksByAppResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiListTasksByAppResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiListTasksByAppResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiListTasksByAppResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiListTasksByAppResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiListTasksByAppResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiListTasksByAppResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiListTasksByAppResponseApplicationJson
    implements
        $TaskProcessingApiListTasksByAppResponseApplicationJsonInterface,
        Built<TaskProcessingApiListTasksByAppResponseApplicationJson,
            TaskProcessingApiListTasksByAppResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiListTasksByAppResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiListTasksByAppResponseApplicationJson([
    void Function(TaskProcessingApiListTasksByAppResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiListTasksByAppResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiListTasksByAppResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiListTasksByAppResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiListTasksByAppResponseApplicationJson.
  static Serializer<TaskProcessingApiListTasksByAppResponseApplicationJson> get serializer =>
      _$taskProcessingApiListTasksByAppResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiListTasksByAppResponseApplicationJsonBuilder b) {
    $TaskProcessingApiListTasksByAppResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiListTasksByAppResponseApplicationJsonBuilder b) {
    $TaskProcessingApiListTasksByAppResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterface {
  BuiltList<TaskProcessingTask> get tasks;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data,
            TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiListTasksResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiListTasksResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiListTasksResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiListTasksResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiListTasksResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiListTasksResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiListTasksResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiListTasksResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiListTasksResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiListTasksResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiListTasksResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiListTasksResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiListTasksResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiListTasksResponseApplicationJson_Ocs,
            TaskProcessingApiListTasksResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiListTasksResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiListTasksResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiListTasksResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiListTasksResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiListTasksResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiListTasksResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiListTasksResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiListTasksResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiListTasksResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiListTasksResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiListTasksResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiListTasksResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiListTasksResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiListTasksResponseApplicationJsonInterface {
  TaskProcessingApiListTasksResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiListTasksResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiListTasksResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiListTasksResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiListTasksResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiListTasksResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiListTasksResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiListTasksResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiListTasksResponseApplicationJson
    implements
        $TaskProcessingApiListTasksResponseApplicationJsonInterface,
        Built<TaskProcessingApiListTasksResponseApplicationJson,
            TaskProcessingApiListTasksResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiListTasksResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiListTasksResponseApplicationJson([
    void Function(TaskProcessingApiListTasksResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiListTasksResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiListTasksResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiListTasksResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiListTasksResponseApplicationJson.
  static Serializer<TaskProcessingApiListTasksResponseApplicationJson> get serializer =>
      _$taskProcessingApiListTasksResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiListTasksResponseApplicationJsonBuilder b) {
    $TaskProcessingApiListTasksResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiListTasksResponseApplicationJsonBuilder b) {
    $TaskProcessingApiListTasksResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterface {
  TaskProcessingTask get task;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data,
            TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiCancelTaskResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiCancelTaskResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiCancelTaskResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiCancelTaskResponseApplicationJson_Ocs,
            TaskProcessingApiCancelTaskResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiCancelTaskResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiCancelTaskResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiCancelTaskResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiCancelTaskResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiCancelTaskResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiCancelTaskResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiCancelTaskResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiCancelTaskResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiCancelTaskResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiCancelTaskResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiCancelTaskResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiCancelTaskResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiCancelTaskResponseApplicationJsonInterface {
  TaskProcessingApiCancelTaskResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiCancelTaskResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiCancelTaskResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiCancelTaskResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiCancelTaskResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiCancelTaskResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiCancelTaskResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiCancelTaskResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiCancelTaskResponseApplicationJson
    implements
        $TaskProcessingApiCancelTaskResponseApplicationJsonInterface,
        Built<TaskProcessingApiCancelTaskResponseApplicationJson,
            TaskProcessingApiCancelTaskResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiCancelTaskResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiCancelTaskResponseApplicationJson([
    void Function(TaskProcessingApiCancelTaskResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiCancelTaskResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiCancelTaskResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiCancelTaskResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiCancelTaskResponseApplicationJson.
  static Serializer<TaskProcessingApiCancelTaskResponseApplicationJson> get serializer =>
      _$taskProcessingApiCancelTaskResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiCancelTaskResponseApplicationJsonBuilder b) {
    $TaskProcessingApiCancelTaskResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiCancelTaskResponseApplicationJsonBuilder b) {
    $TaskProcessingApiCancelTaskResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterface {
  int get fileId;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data,
            TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiSetFileContentsExAppResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs,
            TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiSetFileContentsExAppResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiSetFileContentsExAppResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterface {
  TaskProcessingApiSetFileContentsExAppResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetFileContentsExAppResponseApplicationJson
    implements
        $TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterface,
        Built<TaskProcessingApiSetFileContentsExAppResponseApplicationJson,
            TaskProcessingApiSetFileContentsExAppResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiSetFileContentsExAppResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiSetFileContentsExAppResponseApplicationJson([
    void Function(TaskProcessingApiSetFileContentsExAppResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiSetFileContentsExAppResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiSetFileContentsExAppResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetFileContentsExAppResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetFileContentsExAppResponseApplicationJson.
  static Serializer<TaskProcessingApiSetFileContentsExAppResponseApplicationJson> get serializer =>
      _$taskProcessingApiSetFileContentsExAppResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetFileContentsExAppResponseApplicationJsonBuilder b) {
    $TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetFileContentsExAppResponseApplicationJsonBuilder b) {
    $TaskProcessingApiSetFileContentsExAppResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetProgressRequestApplicationJsonInterface {
  /// The progress.
  double get progress;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetProgressRequestApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetProgressRequestApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiSetProgressRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetProgressRequestApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetProgressRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetProgressRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetProgressRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetProgressRequestApplicationJson
    implements
        $TaskProcessingApiSetProgressRequestApplicationJsonInterface,
        Built<TaskProcessingApiSetProgressRequestApplicationJson,
            TaskProcessingApiSetProgressRequestApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiSetProgressRequestApplicationJson object using the builder pattern.
  factory TaskProcessingApiSetProgressRequestApplicationJson([
    void Function(TaskProcessingApiSetProgressRequestApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiSetProgressRequestApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiSetProgressRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetProgressRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetProgressRequestApplicationJson.
  static Serializer<TaskProcessingApiSetProgressRequestApplicationJson> get serializer =>
      _$taskProcessingApiSetProgressRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetProgressRequestApplicationJsonBuilder b) {
    $TaskProcessingApiSetProgressRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetProgressRequestApplicationJsonBuilder b) {
    $TaskProcessingApiSetProgressRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterface {
  TaskProcessingTask get task;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data,
            TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiSetProgressResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiSetProgressResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetProgressResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiSetProgressResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetProgressResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiSetProgressResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiSetProgressResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetProgressResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiSetProgressResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetProgressResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetProgressResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetProgressResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiSetProgressResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiSetProgressResponseApplicationJson_Ocs,
            TaskProcessingApiSetProgressResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiSetProgressResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiSetProgressResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiSetProgressResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiSetProgressResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiSetProgressResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetProgressResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetProgressResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiSetProgressResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiSetProgressResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetProgressResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiSetProgressResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetProgressResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiSetProgressResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetProgressResponseApplicationJsonInterface {
  TaskProcessingApiSetProgressResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetProgressResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetProgressResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiSetProgressResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetProgressResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetProgressResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetProgressResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetProgressResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetProgressResponseApplicationJson
    implements
        $TaskProcessingApiSetProgressResponseApplicationJsonInterface,
        Built<TaskProcessingApiSetProgressResponseApplicationJson,
            TaskProcessingApiSetProgressResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiSetProgressResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiSetProgressResponseApplicationJson([
    void Function(TaskProcessingApiSetProgressResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiSetProgressResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiSetProgressResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetProgressResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetProgressResponseApplicationJson.
  static Serializer<TaskProcessingApiSetProgressResponseApplicationJson> get serializer =>
      _$taskProcessingApiSetProgressResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetProgressResponseApplicationJsonBuilder b) {
    $TaskProcessingApiSetProgressResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetProgressResponseApplicationJsonBuilder b) {
    $TaskProcessingApiSetProgressResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetResultRequestApplicationJsonInterface {
  /// The resulting task output, files are represented by their IDs.
  BuiltMap<String, JsonObject>? get output;

  /// An error message if the task failed.
  String? get errorMessage;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetResultRequestApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetResultRequestApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiSetResultRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetResultRequestApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetResultRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetResultRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetResultRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetResultRequestApplicationJson
    implements
        $TaskProcessingApiSetResultRequestApplicationJsonInterface,
        Built<TaskProcessingApiSetResultRequestApplicationJson,
            TaskProcessingApiSetResultRequestApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiSetResultRequestApplicationJson object using the builder pattern.
  factory TaskProcessingApiSetResultRequestApplicationJson([
    void Function(TaskProcessingApiSetResultRequestApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiSetResultRequestApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiSetResultRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetResultRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetResultRequestApplicationJson.
  static Serializer<TaskProcessingApiSetResultRequestApplicationJson> get serializer =>
      _$taskProcessingApiSetResultRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetResultRequestApplicationJsonBuilder b) {
    $TaskProcessingApiSetResultRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetResultRequestApplicationJsonBuilder b) {
    $TaskProcessingApiSetResultRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterface {
  TaskProcessingTask get task;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data,
            TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiSetResultResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiSetResultResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetResultResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiSetResultResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetResultResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiSetResultResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiSetResultResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetResultResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiSetResultResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetResultResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetResultResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetResultResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiSetResultResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiSetResultResponseApplicationJson_Ocs,
            TaskProcessingApiSetResultResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiSetResultResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiSetResultResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiSetResultResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiSetResultResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiSetResultResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetResultResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetResultResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiSetResultResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiSetResultResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetResultResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiSetResultResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetResultResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiSetResultResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiSetResultResponseApplicationJsonInterface {
  TaskProcessingApiSetResultResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiSetResultResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetResultResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiSetResultResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiSetResultResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiSetResultResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiSetResultResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiSetResultResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiSetResultResponseApplicationJson
    implements
        $TaskProcessingApiSetResultResponseApplicationJsonInterface,
        Built<TaskProcessingApiSetResultResponseApplicationJson,
            TaskProcessingApiSetResultResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiSetResultResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiSetResultResponseApplicationJson([
    void Function(TaskProcessingApiSetResultResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiSetResultResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiSetResultResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiSetResultResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiSetResultResponseApplicationJson.
  static Serializer<TaskProcessingApiSetResultResponseApplicationJson> get serializer =>
      _$taskProcessingApiSetResultResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiSetResultResponseApplicationJsonBuilder b) {
    $TaskProcessingApiSetResultResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiSetResultResponseApplicationJsonBuilder b) {
    $TaskProcessingApiSetResultResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterface {
  String get name;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterfaceBuilder].
  $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterface rebuild(
    void Function($TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterfaceBuilder)
        updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterfaceBuilder].
  $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterfaceBuilder b,
  ) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterfaceBuilder b,
  ) {}
}

abstract class TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider
    implements
        $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterface,
        Built<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider,
            TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderBuilder> {
  /// Creates a new TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider object using the builder pattern.
  factory TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider([
    void Function(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderBuilder)? b,
  ]) = _$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider;

  // coverage:ignore-start
  const TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider.fromJson(
    Map<String, dynamic> json,
  ) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider.
  static Serializer<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider> get serializer =>
      _$taskProcessingApiGetNextScheduledTaskResponseApplicationJsonOcsDataProviderSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderBuilder b) {
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderBuilder b) {
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_ProviderInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterface {
  TaskProcessingTask get task;
  TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data_Provider get provider;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data
    implements
        $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterface,
        Built<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data,
            TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data([
    void Function(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data.
  static Serializer<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data> get serializer =>
      _$taskProcessingApiGetNextScheduledTaskResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataBuilder b) {
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterface rebuild(
    void Function($TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs
    implements
        $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterface,
        Built<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs,
            TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsBuilder> {
  /// Creates a new TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs object using the builder pattern.
  factory TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs([
    void Function(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs.
  static Serializer<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs> get serializer =>
      _$taskProcessingApiGetNextScheduledTaskResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsBuilder b) {
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterface {
  TaskProcessingApiGetNextScheduledTaskResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterface rebuild(
    void Function($TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterfaceBuilder].
  $TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TaskProcessingApiGetNextScheduledTaskResponseApplicationJson
    implements
        $TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterface,
        Built<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson,
            TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonBuilder> {
  /// Creates a new TaskProcessingApiGetNextScheduledTaskResponseApplicationJson object using the builder pattern.
  factory TaskProcessingApiGetNextScheduledTaskResponseApplicationJson([
    void Function(TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonBuilder)? b,
  ]) = _$TaskProcessingApiGetNextScheduledTaskResponseApplicationJson;

  // coverage:ignore-start
  const TaskProcessingApiGetNextScheduledTaskResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TaskProcessingApiGetNextScheduledTaskResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TaskProcessingApiGetNextScheduledTaskResponseApplicationJson.
  static Serializer<TaskProcessingApiGetNextScheduledTaskResponseApplicationJson> get serializer =>
      _$taskProcessingApiGetNextScheduledTaskResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonBuilder b) {
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonBuilder b) {
    $TaskProcessingApiGetNextScheduledTaskResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TeamResourceInterface {
  int get id;
  String get label;
  String get url;
  String? get iconSvg;
  String? get iconURL;
  String? get iconEmoji;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TeamResourceInterfaceBuilder].
  $TeamResourceInterface rebuild(void Function($TeamResourceInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TeamResourceInterfaceBuilder].
  $TeamResourceInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TeamResourceInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TeamResourceInterfaceBuilder b) {}
}

abstract class TeamResource implements $TeamResourceInterface, Built<TeamResource, TeamResourceBuilder> {
  /// Creates a new TeamResource object using the builder pattern.
  factory TeamResource([void Function(TeamResourceBuilder)? b]) = _$TeamResource;

  // coverage:ignore-start
  const TeamResource._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TeamResource.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TeamResource.
  static Serializer<TeamResource> get serializer => _$teamResourceSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TeamResourceBuilder b) {
    $TeamResourceInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TeamResourceBuilder b) {
    $TeamResourceInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterface {
  BuiltList<TeamResource> get resources;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TeamsApiResolveOneResponseApplicationJson_Ocs_Data
    implements
        $TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterface,
        Built<TeamsApiResolveOneResponseApplicationJson_Ocs_Data,
            TeamsApiResolveOneResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TeamsApiResolveOneResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TeamsApiResolveOneResponseApplicationJson_Ocs_Data([
    void Function(TeamsApiResolveOneResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TeamsApiResolveOneResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TeamsApiResolveOneResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TeamsApiResolveOneResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TeamsApiResolveOneResponseApplicationJson_Ocs_Data.
  static Serializer<TeamsApiResolveOneResponseApplicationJson_Ocs_Data> get serializer =>
      _$teamsApiResolveOneResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TeamsApiResolveOneResponseApplicationJson_Ocs_DataBuilder b) {
    $TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TeamsApiResolveOneResponseApplicationJson_Ocs_DataBuilder b) {
    $TeamsApiResolveOneResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TeamsApiResolveOneResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TeamsApiResolveOneResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TeamsApiResolveOneResponseApplicationJson_OcsInterfaceBuilder].
  $TeamsApiResolveOneResponseApplicationJson_OcsInterface rebuild(
    void Function($TeamsApiResolveOneResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TeamsApiResolveOneResponseApplicationJson_OcsInterfaceBuilder].
  $TeamsApiResolveOneResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TeamsApiResolveOneResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TeamsApiResolveOneResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TeamsApiResolveOneResponseApplicationJson_Ocs
    implements
        $TeamsApiResolveOneResponseApplicationJson_OcsInterface,
        Built<TeamsApiResolveOneResponseApplicationJson_Ocs, TeamsApiResolveOneResponseApplicationJson_OcsBuilder> {
  /// Creates a new TeamsApiResolveOneResponseApplicationJson_Ocs object using the builder pattern.
  factory TeamsApiResolveOneResponseApplicationJson_Ocs([
    void Function(TeamsApiResolveOneResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TeamsApiResolveOneResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TeamsApiResolveOneResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TeamsApiResolveOneResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TeamsApiResolveOneResponseApplicationJson_Ocs.
  static Serializer<TeamsApiResolveOneResponseApplicationJson_Ocs> get serializer =>
      _$teamsApiResolveOneResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TeamsApiResolveOneResponseApplicationJson_OcsBuilder b) {
    $TeamsApiResolveOneResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TeamsApiResolveOneResponseApplicationJson_OcsBuilder b) {
    $TeamsApiResolveOneResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TeamsApiResolveOneResponseApplicationJsonInterface {
  TeamsApiResolveOneResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TeamsApiResolveOneResponseApplicationJsonInterfaceBuilder].
  $TeamsApiResolveOneResponseApplicationJsonInterface rebuild(
    void Function($TeamsApiResolveOneResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TeamsApiResolveOneResponseApplicationJsonInterfaceBuilder].
  $TeamsApiResolveOneResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TeamsApiResolveOneResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TeamsApiResolveOneResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TeamsApiResolveOneResponseApplicationJson
    implements
        $TeamsApiResolveOneResponseApplicationJsonInterface,
        Built<TeamsApiResolveOneResponseApplicationJson, TeamsApiResolveOneResponseApplicationJsonBuilder> {
  /// Creates a new TeamsApiResolveOneResponseApplicationJson object using the builder pattern.
  factory TeamsApiResolveOneResponseApplicationJson([
    void Function(TeamsApiResolveOneResponseApplicationJsonBuilder)? b,
  ]) = _$TeamsApiResolveOneResponseApplicationJson;

  // coverage:ignore-start
  const TeamsApiResolveOneResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TeamsApiResolveOneResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TeamsApiResolveOneResponseApplicationJson.
  static Serializer<TeamsApiResolveOneResponseApplicationJson> get serializer =>
      _$teamsApiResolveOneResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TeamsApiResolveOneResponseApplicationJsonBuilder b) {
    $TeamsApiResolveOneResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TeamsApiResolveOneResponseApplicationJsonBuilder b) {
    $TeamsApiResolveOneResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TeamInterface {
  String get id;
  String get name;
  String get icon;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TeamInterfaceBuilder].
  $TeamInterface rebuild(void Function($TeamInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TeamInterfaceBuilder].
  $TeamInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TeamInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TeamInterfaceBuilder b) {}
}

abstract class Team implements $TeamInterface, Built<Team, TeamBuilder> {
  /// Creates a new Team object using the builder pattern.
  factory Team([void Function(TeamBuilder)? b]) = _$Team;

  // coverage:ignore-start
  const Team._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Team.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Team.
  static Serializer<Team> get serializer => _$teamSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TeamBuilder b) {
    $TeamInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TeamBuilder b) {
    $TeamInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterface {
  BuiltList<Team> get teams;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TeamsApiListTeamsResponseApplicationJson_Ocs_Data
    implements
        $TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterface,
        Built<TeamsApiListTeamsResponseApplicationJson_Ocs_Data,
            TeamsApiListTeamsResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TeamsApiListTeamsResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TeamsApiListTeamsResponseApplicationJson_Ocs_Data([
    void Function(TeamsApiListTeamsResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TeamsApiListTeamsResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TeamsApiListTeamsResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TeamsApiListTeamsResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TeamsApiListTeamsResponseApplicationJson_Ocs_Data.
  static Serializer<TeamsApiListTeamsResponseApplicationJson_Ocs_Data> get serializer =>
      _$teamsApiListTeamsResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TeamsApiListTeamsResponseApplicationJson_Ocs_DataBuilder b) {
    $TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TeamsApiListTeamsResponseApplicationJson_Ocs_DataBuilder b) {
    $TeamsApiListTeamsResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TeamsApiListTeamsResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TeamsApiListTeamsResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TeamsApiListTeamsResponseApplicationJson_OcsInterfaceBuilder].
  $TeamsApiListTeamsResponseApplicationJson_OcsInterface rebuild(
    void Function($TeamsApiListTeamsResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TeamsApiListTeamsResponseApplicationJson_OcsInterfaceBuilder].
  $TeamsApiListTeamsResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TeamsApiListTeamsResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TeamsApiListTeamsResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TeamsApiListTeamsResponseApplicationJson_Ocs
    implements
        $TeamsApiListTeamsResponseApplicationJson_OcsInterface,
        Built<TeamsApiListTeamsResponseApplicationJson_Ocs, TeamsApiListTeamsResponseApplicationJson_OcsBuilder> {
  /// Creates a new TeamsApiListTeamsResponseApplicationJson_Ocs object using the builder pattern.
  factory TeamsApiListTeamsResponseApplicationJson_Ocs([
    void Function(TeamsApiListTeamsResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TeamsApiListTeamsResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TeamsApiListTeamsResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TeamsApiListTeamsResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TeamsApiListTeamsResponseApplicationJson_Ocs.
  static Serializer<TeamsApiListTeamsResponseApplicationJson_Ocs> get serializer =>
      _$teamsApiListTeamsResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TeamsApiListTeamsResponseApplicationJson_OcsBuilder b) {
    $TeamsApiListTeamsResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TeamsApiListTeamsResponseApplicationJson_OcsBuilder b) {
    $TeamsApiListTeamsResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TeamsApiListTeamsResponseApplicationJsonInterface {
  TeamsApiListTeamsResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TeamsApiListTeamsResponseApplicationJsonInterfaceBuilder].
  $TeamsApiListTeamsResponseApplicationJsonInterface rebuild(
    void Function($TeamsApiListTeamsResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TeamsApiListTeamsResponseApplicationJsonInterfaceBuilder].
  $TeamsApiListTeamsResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TeamsApiListTeamsResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TeamsApiListTeamsResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TeamsApiListTeamsResponseApplicationJson
    implements
        $TeamsApiListTeamsResponseApplicationJsonInterface,
        Built<TeamsApiListTeamsResponseApplicationJson, TeamsApiListTeamsResponseApplicationJsonBuilder> {
  /// Creates a new TeamsApiListTeamsResponseApplicationJson object using the builder pattern.
  factory TeamsApiListTeamsResponseApplicationJson([
    void Function(TeamsApiListTeamsResponseApplicationJsonBuilder)? b,
  ]) = _$TeamsApiListTeamsResponseApplicationJson;

  // coverage:ignore-start
  const TeamsApiListTeamsResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TeamsApiListTeamsResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TeamsApiListTeamsResponseApplicationJson.
  static Serializer<TeamsApiListTeamsResponseApplicationJson> get serializer =>
      _$teamsApiListTeamsResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TeamsApiListTeamsResponseApplicationJsonBuilder b) {
    $TeamsApiListTeamsResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TeamsApiListTeamsResponseApplicationJsonBuilder b) {
    $TeamsApiListTeamsResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterface {
  String get id;
  String get name;
  String get description;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterfaceBuilder].
  $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterface rebuild(
    void Function($TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterfaceBuilder].
  $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterfaceBuilder b) {}
}

abstract class TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types
    implements
        $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterface,
        Built<TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types,
            TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesBuilder> {
  /// Creates a new TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types object using the builder pattern.
  factory TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types([
    void Function(TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesBuilder)? b,
  ]) = _$TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types;

  // coverage:ignore-start
  const TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types.
  static Serializer<TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types> get serializer =>
      _$textProcessingApiTaskTypesResponseApplicationJsonOcsDataTypesSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesBuilder b) {
    $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesBuilder b) {
    $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_TypesInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface {
  BuiltList<TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data_Types> get types;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data
    implements
        $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface,
        Built<TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data,
            TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data([
    void Function(TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data.
  static Serializer<TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data> get serializer =>
      _$textProcessingApiTaskTypesResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataBuilder b) {
    $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataBuilder b) {
    $TextProcessingApiTaskTypesResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiTaskTypesResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TextProcessingApiTaskTypesResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder].
  $TextProcessingApiTaskTypesResponseApplicationJson_OcsInterface rebuild(
    void Function($TextProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder].
  $TextProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiTaskTypesResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TextProcessingApiTaskTypesResponseApplicationJson_Ocs
    implements
        $TextProcessingApiTaskTypesResponseApplicationJson_OcsInterface,
        Built<TextProcessingApiTaskTypesResponseApplicationJson_Ocs,
            TextProcessingApiTaskTypesResponseApplicationJson_OcsBuilder> {
  /// Creates a new TextProcessingApiTaskTypesResponseApplicationJson_Ocs object using the builder pattern.
  factory TextProcessingApiTaskTypesResponseApplicationJson_Ocs([
    void Function(TextProcessingApiTaskTypesResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TextProcessingApiTaskTypesResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TextProcessingApiTaskTypesResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiTaskTypesResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiTaskTypesResponseApplicationJson_Ocs.
  static Serializer<TextProcessingApiTaskTypesResponseApplicationJson_Ocs> get serializer =>
      _$textProcessingApiTaskTypesResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiTaskTypesResponseApplicationJson_OcsBuilder b) {
    $TextProcessingApiTaskTypesResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiTaskTypesResponseApplicationJson_OcsBuilder b) {
    $TextProcessingApiTaskTypesResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiTaskTypesResponseApplicationJsonInterface {
  TextProcessingApiTaskTypesResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder].
  $TextProcessingApiTaskTypesResponseApplicationJsonInterface rebuild(
    void Function($TextProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder].
  $TextProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiTaskTypesResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TextProcessingApiTaskTypesResponseApplicationJson
    implements
        $TextProcessingApiTaskTypesResponseApplicationJsonInterface,
        Built<TextProcessingApiTaskTypesResponseApplicationJson,
            TextProcessingApiTaskTypesResponseApplicationJsonBuilder> {
  /// Creates a new TextProcessingApiTaskTypesResponseApplicationJson object using the builder pattern.
  factory TextProcessingApiTaskTypesResponseApplicationJson([
    void Function(TextProcessingApiTaskTypesResponseApplicationJsonBuilder)? b,
  ]) = _$TextProcessingApiTaskTypesResponseApplicationJson;

  // coverage:ignore-start
  const TextProcessingApiTaskTypesResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiTaskTypesResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiTaskTypesResponseApplicationJson.
  static Serializer<TextProcessingApiTaskTypesResponseApplicationJson> get serializer =>
      _$textProcessingApiTaskTypesResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiTaskTypesResponseApplicationJsonBuilder b) {
    $TextProcessingApiTaskTypesResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiTaskTypesResponseApplicationJsonBuilder b) {
    $TextProcessingApiTaskTypesResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiScheduleRequestApplicationJsonInterface {
  static final _$identifier = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// Input text.
  String get input;

  /// Type of the task.
  String get type;

  /// ID of the app that will execute the task.
  String get appId;

  /// An arbitrary identifier for the task.
  String get identifier;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiScheduleRequestApplicationJsonInterfaceBuilder].
  $TextProcessingApiScheduleRequestApplicationJsonInterface rebuild(
    void Function($TextProcessingApiScheduleRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiScheduleRequestApplicationJsonInterfaceBuilder].
  $TextProcessingApiScheduleRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiScheduleRequestApplicationJsonInterfaceBuilder b) {
    b.identifier = _$identifier;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiScheduleRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class TextProcessingApiScheduleRequestApplicationJson
    implements
        $TextProcessingApiScheduleRequestApplicationJsonInterface,
        Built<TextProcessingApiScheduleRequestApplicationJson, TextProcessingApiScheduleRequestApplicationJsonBuilder> {
  /// Creates a new TextProcessingApiScheduleRequestApplicationJson object using the builder pattern.
  factory TextProcessingApiScheduleRequestApplicationJson([
    void Function(TextProcessingApiScheduleRequestApplicationJsonBuilder)? b,
  ]) = _$TextProcessingApiScheduleRequestApplicationJson;

  // coverage:ignore-start
  const TextProcessingApiScheduleRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiScheduleRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiScheduleRequestApplicationJson.
  static Serializer<TextProcessingApiScheduleRequestApplicationJson> get serializer =>
      _$textProcessingApiScheduleRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiScheduleRequestApplicationJsonBuilder b) {
    $TextProcessingApiScheduleRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiScheduleRequestApplicationJsonBuilder b) {
    $TextProcessingApiScheduleRequestApplicationJsonInterface._validate(b);
  }
}

class TextProcessingTask_Status extends EnumClass {
  const TextProcessingTask_Status._(super.name);

  /// `0`
  @BuiltValueEnumConst(wireName: '0')
  static const TextProcessingTask_Status $0 = _$textProcessingTaskStatus$0;

  /// `1`
  @BuiltValueEnumConst(wireName: '1')
  static const TextProcessingTask_Status $1 = _$textProcessingTaskStatus$1;

  /// `2`
  @BuiltValueEnumConst(wireName: '2')
  static const TextProcessingTask_Status $2 = _$textProcessingTaskStatus$2;

  /// `3`
  @BuiltValueEnumConst(wireName: '3')
  static const TextProcessingTask_Status $3 = _$textProcessingTaskStatus$3;

  /// `4`
  @BuiltValueEnumConst(wireName: '4')
  static const TextProcessingTask_Status $4 = _$textProcessingTaskStatus$4;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<TextProcessingTask_Status> get values => _$textProcessingTaskStatusValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static TextProcessingTask_Status valueOf(String name) => _$valueOfTextProcessingTask_Status(name);

  /// Returns the serialized value of this enum value.
  int get value => _$jsonSerializers.serializeWith(serializer, this)! as int;

  /// Serializer for TextProcessingTask_Status.
  @BuiltValueSerializer(custom: true)
  static Serializer<TextProcessingTask_Status> get serializer => const _$TextProcessingTask_StatusSerializer();
}

class _$TextProcessingTask_StatusSerializer implements PrimitiveSerializer<TextProcessingTask_Status> {
  const _$TextProcessingTask_StatusSerializer();

  static const Map<TextProcessingTask_Status, Object> _toWire = <TextProcessingTask_Status, Object>{
    TextProcessingTask_Status.$0: 0,
    TextProcessingTask_Status.$1: 1,
    TextProcessingTask_Status.$2: 2,
    TextProcessingTask_Status.$3: 3,
    TextProcessingTask_Status.$4: 4,
  };

  static const Map<Object, TextProcessingTask_Status> _fromWire = <Object, TextProcessingTask_Status>{
    0: TextProcessingTask_Status.$0,
    1: TextProcessingTask_Status.$1,
    2: TextProcessingTask_Status.$2,
    3: TextProcessingTask_Status.$3,
    4: TextProcessingTask_Status.$4,
  };

  @override
  Iterable<Type> get types => const [TextProcessingTask_Status];

  @override
  String get wireName => 'TextProcessingTask_Status';

  @override
  Object serialize(
    Serializers serializers,
    TextProcessingTask_Status object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  TextProcessingTask_Status deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingTaskInterface {
  int? get id;
  String get type;
  TextProcessingTask_Status get status;
  String? get userId;
  String get appId;
  String get input;
  String? get output;
  String get identifier;
  int? get completionExpectedAt;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingTaskInterfaceBuilder].
  $TextProcessingTaskInterface rebuild(void Function($TextProcessingTaskInterfaceBuilder) updates);

  /// Converts the instance to a builder [$TextProcessingTaskInterfaceBuilder].
  $TextProcessingTaskInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingTaskInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingTaskInterfaceBuilder b) {}
}

abstract class TextProcessingTask
    implements $TextProcessingTaskInterface, Built<TextProcessingTask, TextProcessingTaskBuilder> {
  /// Creates a new TextProcessingTask object using the builder pattern.
  factory TextProcessingTask([void Function(TextProcessingTaskBuilder)? b]) = _$TextProcessingTask;

  // coverage:ignore-start
  const TextProcessingTask._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingTask.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingTask.
  static Serializer<TextProcessingTask> get serializer => _$textProcessingTaskSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingTaskBuilder b) {
    $TextProcessingTaskInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingTaskBuilder b) {
    $TextProcessingTaskInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface {
  TextProcessingTask get task;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TextProcessingApiScheduleResponseApplicationJson_Ocs_Data
    implements
        $TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface,
        Built<TextProcessingApiScheduleResponseApplicationJson_Ocs_Data,
            TextProcessingApiScheduleResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TextProcessingApiScheduleResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TextProcessingApiScheduleResponseApplicationJson_Ocs_Data([
    void Function(TextProcessingApiScheduleResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TextProcessingApiScheduleResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TextProcessingApiScheduleResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiScheduleResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiScheduleResponseApplicationJson_Ocs_Data.
  static Serializer<TextProcessingApiScheduleResponseApplicationJson_Ocs_Data> get serializer =>
      _$textProcessingApiScheduleResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiScheduleResponseApplicationJson_Ocs_DataBuilder b) {
    $TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiScheduleResponseApplicationJson_Ocs_DataBuilder b) {
    $TextProcessingApiScheduleResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiScheduleResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TextProcessingApiScheduleResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder].
  $TextProcessingApiScheduleResponseApplicationJson_OcsInterface rebuild(
    void Function($TextProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder].
  $TextProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiScheduleResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TextProcessingApiScheduleResponseApplicationJson_Ocs
    implements
        $TextProcessingApiScheduleResponseApplicationJson_OcsInterface,
        Built<TextProcessingApiScheduleResponseApplicationJson_Ocs,
            TextProcessingApiScheduleResponseApplicationJson_OcsBuilder> {
  /// Creates a new TextProcessingApiScheduleResponseApplicationJson_Ocs object using the builder pattern.
  factory TextProcessingApiScheduleResponseApplicationJson_Ocs([
    void Function(TextProcessingApiScheduleResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TextProcessingApiScheduleResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TextProcessingApiScheduleResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiScheduleResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiScheduleResponseApplicationJson_Ocs.
  static Serializer<TextProcessingApiScheduleResponseApplicationJson_Ocs> get serializer =>
      _$textProcessingApiScheduleResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiScheduleResponseApplicationJson_OcsBuilder b) {
    $TextProcessingApiScheduleResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiScheduleResponseApplicationJson_OcsBuilder b) {
    $TextProcessingApiScheduleResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiScheduleResponseApplicationJsonInterface {
  TextProcessingApiScheduleResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiScheduleResponseApplicationJsonInterfaceBuilder].
  $TextProcessingApiScheduleResponseApplicationJsonInterface rebuild(
    void Function($TextProcessingApiScheduleResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiScheduleResponseApplicationJsonInterfaceBuilder].
  $TextProcessingApiScheduleResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiScheduleResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiScheduleResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TextProcessingApiScheduleResponseApplicationJson
    implements
        $TextProcessingApiScheduleResponseApplicationJsonInterface,
        Built<TextProcessingApiScheduleResponseApplicationJson,
            TextProcessingApiScheduleResponseApplicationJsonBuilder> {
  /// Creates a new TextProcessingApiScheduleResponseApplicationJson object using the builder pattern.
  factory TextProcessingApiScheduleResponseApplicationJson([
    void Function(TextProcessingApiScheduleResponseApplicationJsonBuilder)? b,
  ]) = _$TextProcessingApiScheduleResponseApplicationJson;

  // coverage:ignore-start
  const TextProcessingApiScheduleResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiScheduleResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiScheduleResponseApplicationJson.
  static Serializer<TextProcessingApiScheduleResponseApplicationJson> get serializer =>
      _$textProcessingApiScheduleResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiScheduleResponseApplicationJsonBuilder b) {
    $TextProcessingApiScheduleResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiScheduleResponseApplicationJsonBuilder b) {
    $TextProcessingApiScheduleResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface {
  TextProcessingTask get task;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
}

abstract class TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data
    implements
        $TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface,
        Built<TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data,
            TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataBuilder> {
  /// Creates a new TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data object using the builder pattern.
  factory TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data([
    void Function(TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataBuilder)? b,
  ]) = _$TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data;

  // coverage:ignore-start
  const TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data.
  static Serializer<TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data> get serializer =>
      _$textProcessingApiGetTaskResponseApplicationJsonOcsDataSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataBuilder b) {
    $TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataBuilder b) {
    $TextProcessingApiGetTaskResponseApplicationJson_Ocs_DataInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiGetTaskResponseApplicationJson_OcsInterface {
  OCSMeta get meta;
  TextProcessingApiGetTaskResponseApplicationJson_Ocs_Data get data;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TextProcessingApiGetTaskResponseApplicationJson_OcsInterface rebuild(
    void Function($TextProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder].
  $TextProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiGetTaskResponseApplicationJson_OcsInterfaceBuilder b) {}
}

abstract class TextProcessingApiGetTaskResponseApplicationJson_Ocs
    implements
        $TextProcessingApiGetTaskResponseApplicationJson_OcsInterface,
        Built<TextProcessingApiGetTaskResponseApplicationJson_Ocs,
            TextProcessingApiGetTaskResponseApplicationJson_OcsBuilder> {
  /// Creates a new TextProcessingApiGetTaskResponseApplicationJson_Ocs object using the builder pattern.
  factory TextProcessingApiGetTaskResponseApplicationJson_Ocs([
    void Function(TextProcessingApiGetTaskResponseApplicationJson_OcsBuilder)? b,
  ]) = _$TextProcessingApiGetTaskResponseApplicationJson_Ocs;

  // coverage:ignore-start
  const TextProcessingApiGetTaskResponseApplicationJson_Ocs._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiGetTaskResponseApplicationJson_Ocs.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiGetTaskResponseApplicationJson_Ocs.
  static Serializer<TextProcessingApiGetTaskResponseApplicationJson_Ocs> get serializer =>
      _$textProcessingApiGetTaskResponseApplicationJsonOcsSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiGetTaskResponseApplicationJson_OcsBuilder b) {
    $TextProcessingApiGetTaskResponseApplicationJson_OcsInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiGetTaskResponseApplicationJson_OcsBuilder b) {
    $TextProcessingApiGetTaskResponseApplicationJson_OcsInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiGetTaskResponseApplicationJsonInterface {
  TextProcessingApiGetTaskResponseApplicationJson_Ocs get ocs;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder].
  $TextProcessingApiGetTaskResponseApplicationJsonInterface rebuild(
    void Function($TextProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder].
  $TextProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($TextProcessingApiGetTaskResponseApplicationJsonInterfaceBuilder b) {}
}

abstract class TextProcessingApiGetTaskResponseApplicationJson
    implements
        $TextProcessingApiGetTaskResponseApplicationJsonInterface,
        Built<TextProcessingApiGetTaskResponseApplicationJson, TextProcessingApiGetTaskResponseApplicationJsonBuilder> {
  /// Creates a new TextProcessingApiGetTaskResponseApplicationJson object using the builder pattern.
  factory TextProcessingApiGetTaskResponseApplicationJson([
    void Function(TextProcessingApiGetTaskResponseApplicationJsonBuilder)? b,
  ]) = _$TextProcessingApiGetTaskResponseApplicationJson;

  // coverage:ignore-start
  const TextProcessingApiGetTaskResponseApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory TextProcessingApiGetTaskResponseApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for TextProcessingApiGetTaskResponseApplicationJson.
  static Serializer<TextProcessingApiGetTaskResponseApplicationJson> get serializer =>
      _$textProcessingApiGetTaskResponseApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(TextProcessingApiGetTaskResponseApplicationJsonBuilder b) {
    $TextProcessingApiGetTaskResponseApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(TextProcessingApiGetTaskResponseApplicationJsonBuilder b) {
    $TextProcessingApiGetTaskResponseApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $TextProcessingApiDeleteTaskResponseApplicationJson_Ocs_DataInterface {
  TextProcessingTask get task;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$TextProcessingApiDeleteTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TextProcessingApiDeleteTaskResponseApplicationJson_Ocs_DataInterface rebuild(
    void Function($TextProcessingApiDeleteTaskResponseApplicationJson_Ocs_DataInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$TextProcessingApiDeleteTaskResponseApplicationJson_Ocs_DataInterfaceBuilder].
  $TextProcessingApiDeleteTaskResponseApplicationJson_Ocs_DataInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($TextProcessingApiDeleteTaskResponseApplicationJson_Ocs_DataInterfaceBuilder b) {}
  @BuiltValu