// Use of this source code is governed by a AGPL-3 license. It can be obtained at `http://www.gnu.org/licenses/agpl-3.0.de.html`.

// OpenAPI client generated by Dynamite. Do not manually edit this file.

// ignore_for_file: camel_case_extensions, camel_case_types, cascade_invocations
// ignore_for_file: discarded_futures
// ignore_for_file: no_leading_underscores_for_local_identifiers
// ignore_for_file: non_constant_identifier_names, public_member_api_docs
// ignore_for_file: unreachable_switch_case

/// Nextcloud cookbook app Version: 0.1.2.
///
/// This is the public API definition of the [cookbook app](https://github.com/nextcloud/cookbook) for the [nextcloud server](http://nextcloud.com).
///
/// The total API is separated into two parts:
/// - There is the public API part that can be used from 3rd party apps and scripts.
/// - There is the internal API that is used only by the web app of the cookbook app. This is described here.
///
/// The internal part is intended only to be used by the internal web app. It uses session based authentication and thus requires a `requesttoken` to protect against CSRF attacks. The generation and updating of these tokens is not part of the app but the regular browser capabilities and the nextcloud web frontend is used here instead.
///
/// In contrast, the External APIs are intended for use by external services. These endpoints require the user credentials to be present in every request. Thus, no session is created and no cookies or similar needs to be handled. Technically, there is a CORS preflight possible but it is not required for the function of the endpoints.
///
/// Further contact can be found on the matrix.org server in the room [#nextcloud-cookbook:matrix.org](https://matrix.to/#/#nextcloud-cookbook:matrix.org) for general questions. Additionally, there is [#nextcloud-cookbook-integration:matrix.org](https://matrix.to/#/#nextcloud-cookbook-integration:matrix.org) for questions related to the API and third party integration. Further information on the different versions can be found in [the API overview page](https://nextcloud.github.io/cookbook/dev/api/index).
///
/// Use of this source code is governed by a AGPL-3 license.
/// It can be obtained at `http://www.gnu.org/licenses/agpl-3.0.de.html`.
library; // ignore_for_file: no_leading_underscores_for_library_prefixes

import 'dart:convert';
import 'dart:typed_data';

import 'package:built_collection/built_collection.dart';
import 'package:built_value/built_value.dart';
import 'package:built_value/json_object.dart';
import 'package:built_value/serializer.dart';
import 'package:built_value/standard_json_plugin.dart' as _i7;
import 'package:collection/collection.dart' as _i4;
import 'package:dynamite_runtime/built_value.dart' as _i6;
import 'package:dynamite_runtime/http_client.dart' as _i1;
import 'package:http/http.dart' as _i3;
import 'package:meta/meta.dart' as _i2;
import 'package:uri/uri.dart' as _i5;

part 'cookbook.openapi.g.dart';

class $Client extends _i1.DynamiteClient {
  /// Creates a new `DynamiteClient` for untagged requests.
  $Client(
    super.baseURL, {
    super.httpClient,
    super.authentications,
  });

  /// Creates a new [$Client] from another [client].
  $Client.fromClient(_i1.DynamiteClient client)
      : super(
          client.baseURL,
          httpClient: client.httpClient,
          authentications: client.authentications,
        );

  /// Access to the categories of the recipes.
  late final $CategoriesClient categories = $CategoriesClient(this);

  /// Other API endpoints.
  late final $MiscClient misc = $MiscClient(this);

  /// Everything related to recipes and their usage.
  late final $RecipesClient recipes = $RecipesClient(this);

  /// Access to tags/keywords of recipes.
  late final $TagsClient tags = $TagsClient(this);
}

/// Access to the categories of the recipes.
class $CategoriesClient {
  /// Creates a new `DynamiteClient` for Categories requests.
  $CategoriesClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listCategories_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Category>, void> $listCategories_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Category)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all known categories.
  ///
  /// Returns a `DynamiteRequest` backing the [listCategories] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Sucessfully obtained all categories
  ///
  /// Please note: A category name of `*` indicates the number of recipes with no category associated.
  ///
  /// See:
  ///  * [listCategories] for a method executing this request and parsing the response.
  ///  * [$listCategories_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listCategories_Request() {
    const _path = '/index.php/apps/cookbook/api/v1/categories';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all known categories.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Sucessfully obtained all categories
  ///
  /// Please note: A category name of `*` indicates the number of recipes with no category associated.
  ///
  /// See:
  ///  * [$listCategories_Request] for the request send by this method.
  ///  * [$listCategories_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Category>, void>> listCategories() async {
    final _request = $listCategories_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listCategories_Serializer();
    return _i1.ResponseConverter<BuiltList<Category>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$recipesInCategory_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<RecipeStub>, void> $recipesInCategory_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(RecipeStub)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all recipes of a certain category.
  ///
  /// Returns a `DynamiteRequest` backing the [recipesInCategory] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [category] The name of the category to be queried as urlencoded string.
  ///
  /// Put the string `_` to obtain all recipes with no category.
  ///
  /// Status codes:
  ///   * 200: The filtered recipes belonging to the category
  ///   * 500: An exception was issued.
  ///
  /// See:
  ///  * [recipesInCategory] for a method executing this request and parsing the response.
  ///  * [$recipesInCategory_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $recipesInCategory_Request({required String category}) {
    final _parameters = <String, Object?>{};
    final __category = _$jsonSerializers.serialize(category, specifiedType: const FullType(String));
    _parameters['category'] = __category;

    final _path = _i5.UriTemplate('/index.php/apps/cookbook/api/v1/category/{category}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all recipes of a certain category.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [category] The name of the category to be queried as urlencoded string.
  ///
  /// Put the string `_` to obtain all recipes with no category.
  ///
  /// Status codes:
  ///   * 200: The filtered recipes belonging to the category
  ///   * 500: An exception was issued.
  ///
  /// See:
  ///  * [$recipesInCategory_Request] for the request send by this method.
  ///  * [$recipesInCategory_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<RecipeStub>, void>> recipesInCategory({required String category}) async {
    final _request = $recipesInCategory_Request(
      category: category,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $recipesInCategory_Serializer();
    return _i1.ResponseConverter<BuiltList<RecipeStub>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$renameCategory_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<String, void> $renameCategory_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(String),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Rename a category.
  ///
  /// Returns a `DynamiteRequest` backing the [renameCategory] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [category] The name of the category to be queried as urlencoded string.
  ///
  /// Put the string `_` to obtain all recipes with no category.
  ///
  /// Status codes:
  ///   * 200: The category was renamed successfully
  ///   * 400: The new category name was not included during the request.
  ///   * 500: The renaming did not succeed.
  ///
  /// See:
  ///  * [renameCategory] for a method executing this request and parsing the response.
  ///  * [$renameCategory_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $renameCategory_Request({
    required String category,
    required RenameCategoryRequestApplicationJson $body,
  }) {
    final _parameters = <String, Object?>{};
    final __category = _$jsonSerializers.serialize(category, specifiedType: const FullType(String));
    _parameters['category'] = __category;

    final _path = _i5.UriTemplate('/index.php/apps/cookbook/api/v1/category/{category}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(
      _$jsonSerializers.serialize($body, specifiedType: const FullType(RenameCategoryRequestApplicationJson)),
    );
    return _request;
  }

  /// Rename a category.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [category] The name of the category to be queried as urlencoded string.
  ///
  /// Put the string `_` to obtain all recipes with no category.
  ///
  /// Status codes:
  ///   * 200: The category was renamed successfully
  ///   * 400: The new category name was not included during the request.
  ///   * 500: The renaming did not succeed.
  ///
  /// See:
  ///  * [$renameCategory_Request] for the request send by this method.
  ///  * [$renameCategory_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<String, void>> renameCategory({
    required String category,
    required RenameCategoryRequestApplicationJson $body,
  }) async {
    final _request = $renameCategory_Request(
      category: category,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $renameCategory_Serializer();
    return _i1.ResponseConverter<String, void>(_serializer).convert(_response);
  }
}

/// Other API endpoints.
class $MiscClient {
  /// Creates a new `DynamiteClient` for Misc requests.
  $MiscClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$version_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Version, void> $version_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Version),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the version of the API endpoint.
  ///
  /// Returns a `DynamiteRequest` backing the [version] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: API version
  ///
  /// See:
  ///  * [version] for a method executing this request and parsing the response.
  ///  * [$version_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $version_Request() {
    const _path = '/index.php/apps/cookbook/api/version';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get the version of the API endpoint.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: API version
  ///
  /// See:
  ///  * [$version_Request] for the request send by this method.
  ///  * [$version_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Version, void>> version() async {
    final _request = $version_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $version_Serializer();
    return _i1.ResponseConverter<Version, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$reindex_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<String, void> $reindex_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(String),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Trigger a rescan of all recipes into the caching database.
  ///
  /// Returns a `DynamiteRequest` backing the [reindex] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The reindex process was done.
  ///
  /// See:
  ///  * [reindex] for a method executing this request and parsing the response.
  ///  * [$reindex_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $reindex_Request() {
    const _path = '/index.php/apps/cookbook/api/v1/reindex';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Trigger a rescan of all recipes into the caching database.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The reindex process was done.
  ///
  /// See:
  ///  * [$reindex_Request] for the request send by this method.
  ///  * [$reindex_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<String, void>> reindex() async {
    final _request = $reindex_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $reindex_Serializer();
    return _i1.ResponseConverter<String, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getConfig_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Config, void> $getConfig_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Config),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the current configuration of the app.
  ///
  /// Returns a `DynamiteRequest` backing the [getConfig] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The config was read successfully
  ///
  /// See:
  ///  * [getConfig] for a method executing this request and parsing the response.
  ///  * [$getConfig_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getConfig_Request() {
    const _path = '/index.php/apps/cookbook/api/v1/config';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get the current configuration of the app.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The config was read successfully
  ///
  /// See:
  ///  * [$getConfig_Request] for the request send by this method.
  ///  * [$getConfig_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Config, void>> getConfig() async {
    final _request = $getConfig_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getConfig_Serializer();
    return _i1.ResponseConverter<Config, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$setConfig_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<String, void> $setConfig_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(String),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Set the configuration for the current user.
  ///
  /// Returns a `DynamiteRequest` backing the [setConfig] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The configuration was successfully saved.
  ///
  /// See:
  ///  * [setConfig] for a method executing this request and parsing the response.
  ///  * [$setConfig_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $setConfig_Request({required Config $body}) {
    const _path = '/index.php/apps/cookbook/api/v1/config';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(Config)));
    return _request;
  }

  /// Set the configuration for the current user.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The configuration was successfully saved.
  ///
  /// See:
  ///  * [$setConfig_Request] for the request send by this method.
  ///  * [$setConfig_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<String, void>> setConfig({required Config $body}) async {
    final _request = $setConfig_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $setConfig_Serializer();
    return _i1.ResponseConverter<String, void>(_serializer).convert(_response);
  }
}

/// Everything related to recipes and their usage.
class $RecipesClient {
  /// Creates a new `DynamiteClient` for Recipes requests.
  $RecipesClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$$import_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Recipe, void> $$import_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Recipe),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Import a recipe using schema.org metadata from a website.
  ///
  /// Returns a `DynamiteRequest` backing the [$import] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Successfully imported recipe
  ///   * 400: The URL to be imported was not inserted in the request or any other issue was rosen.
  ///   * 409: There exists a recipe with that name already. Import was aborted.
  ///
  /// See:
  ///  * [$import] for a method executing this request and parsing the response.
  ///  * [$$import_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $$import_Request({required Url $body}) {
    const _path = '/index.php/apps/cookbook/api/v1/import';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(Url)));
    return _request;
  }

  /// Import a recipe using schema.org metadata from a website.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Successfully imported recipe
  ///   * 400: The URL to be imported was not inserted in the request or any other issue was rosen.
  ///   * 409: There exists a recipe with that name already. Import was aborted.
  ///
  /// See:
  ///  * [$$import_Request] for the request send by this method.
  ///  * [$$import_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Recipe, void>> $import({required Url $body}) async {
    final _request = $$import_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $$import_Serializer();
    return _i1.ResponseConverter<Recipe, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$getImage_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Uint8List, void> $getImage_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Uint8List),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get the main image of a recipe. If no image is stored a fallback image is delivered.
  ///
  /// Returns a `DynamiteRequest` backing the [getImage] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the recipe to obtain the image for.
  ///   * [size] The size of the requested image.
  /// * `full`    - Full resolution image (size full res) * `thumb`   - thumbnail of the image (size 250px) * `thumb16` - icon of the image (size 16px).
  /// by default the full size image will be returned.
  ///
  ///
  /// Status codes:
  ///   * 200: Image was obtained and will be in response either as image/jpeg or image/svg+xml
  ///   * 406: The recipe has no image whose MIME type matches the Accept header
  ///
  /// See:
  ///  * [getImage] for a method executing this request and parsing the response.
  ///  * [$getImage_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $getImage_Request({
    required String id,
    GetImageSize? size,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final __size = _$jsonSerializers.serialize(size, specifiedType: const FullType(GetImageSize));
    _parameters['size'] = __size;

    final _path = _i5.UriTemplate('/index.php/apps/cookbook/api/v1/recipes/{id}/image{?size*}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'image/jpeg,image/svg+xml';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get the main image of a recipe. If no image is stored a fallback image is delivered.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [id] The id of the recipe to obtain the image for.
  ///   * [size] The size of the requested image.
  /// * `full`    - Full resolution image (size full res) * `thumb`   - thumbnail of the image (size 250px) * `thumb16` - icon of the image (size 16px).
  /// by default the full size image will be returned.
  ///
  ///
  /// Status codes:
  ///   * 200: Image was obtained and will be in response either as image/jpeg or image/svg+xml
  ///   * 406: The recipe has no image whose MIME type matches the Accept header
  ///
  /// See:
  ///  * [$getImage_Request] for the request send by this method.
  ///  * [$getImage_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Uint8List, void>> getImage({
    required String id,
    GetImageSize? size,
  }) async {
    final _request = $getImage_Request(
      id: id,
      size: size,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $getImage_Serializer();
    return _i1.ResponseConverter<Uint8List, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$search_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<RecipeStub>, void> $search_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(RecipeStub)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Search for recipes for keywords, tags and categories with the named search string.
  ///
  /// Returns a `DynamiteRequest` backing the [search] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The recipes were obtained successfully
  ///   * 500: An error has been thrown
  ///
  /// See:
  ///  * [search] for a method executing this request and parsing the response.
  ///  * [$search_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $search_Request({required String query}) {
    final _parameters = <String, Object?>{};
    final __query = _$jsonSerializers.serialize(query, specifiedType: const FullType(String));
    _parameters['query'] = __query;

    final _path = _i5.UriTemplate('/index.php/apps/cookbook/api/v1/search/{query}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Search for recipes for keywords, tags and categories with the named search string.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The recipes were obtained successfully
  ///   * 500: An error has been thrown
  ///
  /// See:
  ///  * [$search_Request] for the request send by this method.
  ///  * [$search_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<RecipeStub>, void>> search({required String query}) async {
    final _request = $search_Request(
      query: query,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $search_Serializer();
    return _i1.ResponseConverter<BuiltList<RecipeStub>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$listRecipes_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<RecipeStub>, void> $listRecipes_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(RecipeStub)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all recipes in the database.
  ///
  /// Returns a `DynamiteRequest` backing the [listRecipes] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Successfully obtained all recipes
  ///
  /// See:
  ///  * [listRecipes] for a method executing this request and parsing the response.
  ///  * [$listRecipes_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listRecipes_Request() {
    const _path = '/index.php/apps/cookbook/api/v1/recipes';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all recipes in the database.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Successfully obtained all recipes
  ///
  /// See:
  ///  * [$listRecipes_Request] for the request send by this method.
  ///  * [$listRecipes_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<RecipeStub>, void>> listRecipes() async {
    final _request = $listRecipes_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listRecipes_Serializer();
    return _i1.ResponseConverter<BuiltList<RecipeStub>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$newRecipe_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<int, void> $newRecipe_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(int),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Create a new recipe.
  ///
  /// Returns a `DynamiteRequest` backing the [newRecipe] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Request body: [$body] A JSON representation of the recipe to be saved.
  ///
  /// See also the structure at https://schema.org/Recipe
  ///
  ///
  /// Status codes:
  ///   * 200: Successfully created new recipe
  ///   * 409: A recipe with the name was already found on the server. No recipe is created.
  ///   * 422: There was no name in the request given for the recipe. Cannot save the recipe.
  ///
  /// See:
  ///  * [newRecipe] for a method executing this request and parsing the response.
  ///  * [$newRecipe_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $newRecipe_Request({required Recipe $body}) {
    const _path = '/index.php/apps/cookbook/api/v1/recipes';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('post', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(Recipe)));
    return _request;
  }

  /// Create a new recipe.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Request body: [$body] A JSON representation of the recipe to be saved.
  ///
  /// See also the structure at https://schema.org/Recipe
  ///
  ///
  /// Status codes:
  ///   * 200: Successfully created new recipe
  ///   * 409: A recipe with the name was already found on the server. No recipe is created.
  ///   * 422: There was no name in the request given for the recipe. Cannot save the recipe.
  ///
  /// See:
  ///  * [$newRecipe_Request] for the request send by this method.
  ///  * [$newRecipe_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<int, void>> newRecipe({required Recipe $body}) async {
    final _request = $newRecipe_Request(
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $newRecipe_Serializer();
    return _i1.ResponseConverter<int, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$recipeDetails_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<Recipe, void> $recipeDetails_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(Recipe),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get a single recipe from the server.
  ///
  /// Returns a `DynamiteRequest` backing the [recipeDetails] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Recipe was sucessfully obtained
  ///   * 404: The given recipe id was not found
  ///
  /// See:
  ///  * [recipeDetails] for a method executing this request and parsing the response.
  ///  * [$recipeDetails_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $recipeDetails_Request({required String id}) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/index.php/apps/cookbook/api/v1/recipes/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get a single recipe from the server.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Recipe was sucessfully obtained
  ///   * 404: The given recipe id was not found
  ///
  /// See:
  ///  * [$recipeDetails_Request] for the request send by this method.
  ///  * [$recipeDetails_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<Recipe, void>> recipeDetails({required String id}) async {
    final _request = $recipeDetails_Request(
      id: id,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $recipeDetails_Serializer();
    return _i1.ResponseConverter<Recipe, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$updateRecipe_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<int, void> $updateRecipe_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(int),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Update a recipe.
  ///
  /// Returns a `DynamiteRequest` backing the [updateRecipe] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The recipe was sucessfully updated
  ///   * 422: There was no name in the request given for the recipe. Cannot save the recipe.
  ///
  /// See:
  ///  * [updateRecipe] for a method executing this request and parsing the response.
  ///  * [$updateRecipe_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $updateRecipe_Request({
    required String id,
    required Recipe $body,
  }) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/index.php/apps/cookbook/api/v1/recipes/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('put', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    _request.headers['Content-Type'] = 'application/json';
    _request.body = json.encode(_$jsonSerializers.serialize($body, specifiedType: const FullType(Recipe)));
    return _request;
  }

  /// Update a recipe.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The recipe was sucessfully updated
  ///   * 422: There was no name in the request given for the recipe. Cannot save the recipe.
  ///
  /// See:
  ///  * [$updateRecipe_Request] for the request send by this method.
  ///  * [$updateRecipe_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<int, void>> updateRecipe({
    required String id,
    required Recipe $body,
  }) async {
    final _request = $updateRecipe_Request(
      id: id,
      $body: $body,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $updateRecipe_Serializer();
    return _i1.ResponseConverter<int, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$deleteRecipe_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<String, void> $deleteRecipe_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(String),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Delete an existing recipe.
  ///
  /// Returns a `DynamiteRequest` backing the [deleteRecipe] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The recipe was deleted successfully
  ///   * 502: An Exception was thrown
  ///
  /// See:
  ///  * [deleteRecipe] for a method executing this request and parsing the response.
  ///  * [$deleteRecipe_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $deleteRecipe_Request({required String id}) {
    final _parameters = <String, Object?>{};
    final __id = _$jsonSerializers.serialize(id, specifiedType: const FullType(String));
    _parameters['id'] = __id;

    final _path = _i5.UriTemplate('/index.php/apps/cookbook/api/v1/recipes/{id}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('delete', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Delete an existing recipe.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: The recipe was deleted successfully
  ///   * 502: An Exception was thrown
  ///
  /// See:
  ///  * [$deleteRecipe_Request] for the request send by this method.
  ///  * [$deleteRecipe_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<String, void>> deleteRecipe({required String id}) async {
    final _request = $deleteRecipe_Request(
      id: id,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $deleteRecipe_Serializer();
    return _i1.ResponseConverter<String, void>(_serializer).convert(_response);
  }
}

/// Access to tags/keywords of recipes.
class $TagsClient {
  /// Creates a new `DynamiteClient` for Tags requests.
  $TagsClient(this._rootClient);

  final $Client _rootClient;

  /// Builds a serializer to parse the response of [$listKeywords_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<Keyword>, void> $listKeywords_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(Keyword)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all known keywords.
  ///
  /// Returns a `DynamiteRequest` backing the [listKeywords] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Successfully obtained all keywords
  ///
  /// See:
  ///  * [listKeywords] for a method executing this request and parsing the response.
  ///  * [$listKeywords_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $listKeywords_Request() {
    const _path = '/index.php/apps/cookbook/api/v1/keywords';
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all known keywords.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Status codes:
  ///   * 200: Successfully obtained all keywords
  ///
  /// See:
  ///  * [$listKeywords_Request] for the request send by this method.
  ///  * [$listKeywords_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<Keyword>, void>> listKeywords() async {
    final _request = $listKeywords_Request();
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $listKeywords_Serializer();
    return _i1.ResponseConverter<BuiltList<Keyword>, void>(_serializer).convert(_response);
  }

  /// Builds a serializer to parse the response of [$recipesWithKeyword_Request].
  @_i2.experimental
  _i1.DynamiteSerializer<BuiltList<RecipeStub>, void> $recipesWithKeyword_Serializer() => _i1.DynamiteSerializer(
        bodyType: const FullType(BuiltList, [FullType(RecipeStub)]),
        headersType: null,
        serializers: _$jsonSerializers,
        validStatuses: const {200},
      );

  /// Get all recipes associated with certain keywords.
  ///
  /// Returns a `DynamiteRequest` backing the [recipesWithKeyword] operation.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [keywords] Comma separated list of keywords, urlencoded.
  ///
  /// Status codes:
  ///   * 200: Recipes were successfully obtained
  ///   * 500: An error occured
  ///
  /// See:
  ///  * [recipesWithKeyword] for a method executing this request and parsing the response.
  ///  * [$recipesWithKeyword_Serializer] for a converter to parse the `Response` from an executed this request.
  @_i2.experimental
  _i3.Request $recipesWithKeyword_Request({required String keywords}) {
    final _parameters = <String, Object?>{};
    final __keywords = _$jsonSerializers.serialize(keywords, specifiedType: const FullType(String));
    _parameters['keywords'] = __keywords;

    final _path = _i5.UriTemplate('/index.php/apps/cookbook/api/v1/tags/{keywords}').expand(_parameters);
    final _uri = Uri.parse('${_rootClient.baseURL}$_path');
    final _request = _i3.Request('get', _uri);
    _request.headers['Accept'] = 'application/json';
// coverage:ignore-start
    final authentication = _i4.IterableExtension(_rootClient.authentications)?.firstWhereOrNull(
      (auth) => switch (auth) {
        _i1.DynamiteHttpBasicAuthentication() => true,
        _ => false,
      },
    );

    if (authentication != null) {
      _request.headers.addAll(
        authentication.headers,
      );
    } else {
      throw Exception('Missing authentication for app_password');
    }

// coverage:ignore-end
    return _request;
  }

  /// Get all recipes associated with certain keywords.
  ///
  /// Returns a [Future] containing a `DynamiteResponse` with the status code, deserialized body and headers.
  /// Throws a `DynamiteApiException` if the API call does not return an expected status code.
  ///
  /// Parameters:
  ///   * [keywords] Comma separated list of keywords, urlencoded.
  ///
  /// Status codes:
  ///   * 200: Recipes were successfully obtained
  ///   * 500: An error occured
  ///
  /// See:
  ///  * [$recipesWithKeyword_Request] for the request send by this method.
  ///  * [$recipesWithKeyword_Serializer] for a converter to parse the `Response` from an executed request.
  Future<_i1.DynamiteResponse<BuiltList<RecipeStub>, void>> recipesWithKeyword({required String keywords}) async {
    final _request = $recipesWithKeyword_Request(
      keywords: keywords,
    );
    final _streamedResponse = await _rootClient.httpClient.send(_request);
    final _response = await _i3.Response.fromStream(_streamedResponse);

    final _serializer = $recipesWithKeyword_Serializer();
    return _i1.ResponseConverter<BuiltList<RecipeStub>, void>(_serializer).convert(_response);
  }
}

/// A single tool for a recipe. A tool is not consumed but only used.
typedef Tool = String;

/// A single ingredient for a recipe.
typedef Ingredient = String;

/// An instruction step for processing the recipe.
typedef Instruction = String;

/// The very basic information of a category.
/// Please note: A category name of `*` indicates the number of recipes with no category associated.
@BuiltValue(instantiable: false)
sealed class $CategoryInformationInterface {
  /// The name of the category.
  String get name;

  /// The number of recipes in the category.
  @BuiltValueField(wireName: 'recipe_count')
  int get recipeCount;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CategoryInformationInterfaceBuilder].
  $CategoryInformationInterface rebuild(void Function($CategoryInformationInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CategoryInformationInterfaceBuilder].
  $CategoryInformationInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CategoryInformationInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CategoryInformationInterfaceBuilder b) {}
}

/// The very basic information of a category.
/// Please note: A category name of `*` indicates the number of recipes with no category associated.
abstract class CategoryInformation
    implements $CategoryInformationInterface, Built<CategoryInformation, CategoryInformationBuilder> {
  /// Creates a new CategoryInformation object using the builder pattern.
  factory CategoryInformation([void Function(CategoryInformationBuilder)? b]) = _$CategoryInformation;

  // coverage:ignore-start
  const CategoryInformation._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory CategoryInformation.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for CategoryInformation.
  static Serializer<CategoryInformation> get serializer => _$categoryInformationSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CategoryInformationBuilder b) {
    $CategoryInformationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CategoryInformationBuilder b) {
    $CategoryInformationInterface._validate(b);
  }
}

/// A category.
@BuiltValue(instantiable: false)
sealed class $CategoryInterface implements $CategoryInformationInterface {
  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$CategoryInterfaceBuilder].
  @override
  $CategoryInterface rebuild(void Function($CategoryInterfaceBuilder) updates);

  /// Converts the instance to a builder [$CategoryInterfaceBuilder].
  @override
  $CategoryInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($CategoryInterfaceBuilder b) {
    $CategoryInformationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($CategoryInterfaceBuilder b) {
    $CategoryInformationInterface._validate(b);
  }
}

/// A category.
abstract class Category implements $CategoryInterface, Built<Category, CategoryBuilder> {
  /// Creates a new Category object using the builder pattern.
  factory Category([void Function(CategoryBuilder)? b]) = _$Category;

  // coverage:ignore-start
  const Category._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Category.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Category.
  static Serializer<Category> get serializer => _$categorySerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(CategoryBuilder b) {
    $CategoryInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(CategoryBuilder b) {
    $CategoryInterface._validate(b);
  }
}

/// The very basic information of a recipe.
@BuiltValue(instantiable: false)
sealed class $RecipeStubInformationInterface {
  static final _$keywords = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$imageUrl = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$imagePlaceholderUrl = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// The name of the recipe.
  String get name;

  /// A comma-separated list of recipe keywords, can be empty string.
  String get keywords;

  /// The date the recipe was created in the app.
  String get dateCreated;

  /// The date the recipe was modified lastly in the app.
  String? get dateModified;

  /// The URL of the recipe image.
  String get imageUrl;

  /// The URL of the placeholder of the recipe image.
  String get imagePlaceholderUrl;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RecipeStubInformationInterfaceBuilder].
  $RecipeStubInformationInterface rebuild(void Function($RecipeStubInformationInterfaceBuilder) updates);

  /// Converts the instance to a builder [$RecipeStubInformationInterfaceBuilder].
  $RecipeStubInformationInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RecipeStubInformationInterfaceBuilder b) {
    b.keywords = _$keywords;
    b.imageUrl = _$imageUrl;
    b.imagePlaceholderUrl = _$imagePlaceholderUrl;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RecipeStubInformationInterfaceBuilder b) {}
}

/// The very basic information of a recipe.
abstract class RecipeStubInformation
    implements $RecipeStubInformationInterface, Built<RecipeStubInformation, RecipeStubInformationBuilder> {
  /// Creates a new RecipeStubInformation object using the builder pattern.
  factory RecipeStubInformation([void Function(RecipeStubInformationBuilder)? b]) = _$RecipeStubInformation;

  // coverage:ignore-start
  const RecipeStubInformation._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RecipeStubInformation.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RecipeStubInformation.
  static Serializer<RecipeStubInformation> get serializer => _$recipeStubInformationSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RecipeStubInformationBuilder b) {
    $RecipeStubInformationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RecipeStubInformationBuilder b) {
    $RecipeStubInformationInterface._validate(b);
  }
}

/// A stub of a recipe with some basic information present.
@BuiltValue(instantiable: false)
sealed class $RecipeStubInterface implements $RecipeStubInformationInterface {
  /// The index of the recipe.
  @Deprecated('')
  @BuiltValueField(wireName: 'recipe_id')
  int get recipeId;

  /// The identifier of the recipe.
  String get id;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RecipeStubInterfaceBuilder].
  @override
  $RecipeStubInterface rebuild(void Function($RecipeStubInterfaceBuilder) updates);

  /// Converts the instance to a builder [$RecipeStubInterfaceBuilder].
  @override
  $RecipeStubInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RecipeStubInterfaceBuilder b) {
    $RecipeStubInformationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RecipeStubInterfaceBuilder b) {
    $RecipeStubInformationInterface._validate(b);
  }
}

/// A stub of a recipe with some basic information present.
abstract class RecipeStub implements $RecipeStubInterface, Built<RecipeStub, RecipeStubBuilder> {
  /// Creates a new RecipeStub object using the builder pattern.
  factory RecipeStub([void Function(RecipeStubBuilder)? b]) = _$RecipeStub;

  // coverage:ignore-start
  const RecipeStub._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RecipeStub.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RecipeStub.
  static Serializer<RecipeStub> get serializer => _$recipeStubSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RecipeStubBuilder b) {
    $RecipeStubInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RecipeStubBuilder b) {
    $RecipeStubInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $RenameCategoryRequestApplicationJsonInterface {
  /// The new name to rename the category to.
  String get name;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RenameCategoryRequestApplicationJsonInterfaceBuilder].
  $RenameCategoryRequestApplicationJsonInterface rebuild(
    void Function($RenameCategoryRequestApplicationJsonInterfaceBuilder) updates,
  );

  /// Converts the instance to a builder [$RenameCategoryRequestApplicationJsonInterfaceBuilder].
  $RenameCategoryRequestApplicationJsonInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RenameCategoryRequestApplicationJsonInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RenameCategoryRequestApplicationJsonInterfaceBuilder b) {}
}

abstract class RenameCategoryRequestApplicationJson
    implements
        $RenameCategoryRequestApplicationJsonInterface,
        Built<RenameCategoryRequestApplicationJson, RenameCategoryRequestApplicationJsonBuilder> {
  /// Creates a new RenameCategoryRequestApplicationJson object using the builder pattern.
  factory RenameCategoryRequestApplicationJson([void Function(RenameCategoryRequestApplicationJsonBuilder)? b]) =
      _$RenameCategoryRequestApplicationJson;

  // coverage:ignore-start
  const RenameCategoryRequestApplicationJson._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory RenameCategoryRequestApplicationJson.fromJson(Map<String, dynamic> json) =>
      _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for RenameCategoryRequestApplicationJson.
  static Serializer<RenameCategoryRequestApplicationJson> get serializer =>
      _$renameCategoryRequestApplicationJsonSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RenameCategoryRequestApplicationJsonBuilder b) {
    $RenameCategoryRequestApplicationJsonInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RenameCategoryRequestApplicationJsonBuilder b) {
    $RenameCategoryRequestApplicationJsonInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $APIVersionInterface {
  /// An epoch to cope with bad API versions.
  int get epoch;

  /// The major number of the API.
  int get major;

  /// The minor number of the API.
  int get minor;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$APIVersionInterfaceBuilder].
  $APIVersionInterface rebuild(void Function($APIVersionInterfaceBuilder) updates);

  /// Converts the instance to a builder [$APIVersionInterfaceBuilder].
  $APIVersionInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($APIVersionInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($APIVersionInterfaceBuilder b) {}
}

abstract class APIVersion implements $APIVersionInterface, Built<APIVersion, APIVersionBuilder> {
  /// Creates a new APIVersion object using the builder pattern.
  factory APIVersion([void Function(APIVersionBuilder)? b]) = _$APIVersion;

  // coverage:ignore-start
  const APIVersion._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory APIVersion.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for APIVersion.
  static Serializer<APIVersion> get serializer => _$aPIVersionSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(APIVersionBuilder b) {
    $APIVersionInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(APIVersionBuilder b) {
    $APIVersionInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $VersionInterface {
  @BuiltValueField(wireName: 'cookbook_version')
  BuiltList<JsonObject>? get cookbookVersion;
  @BuiltValueField(wireName: 'api_version')
  APIVersion? get apiVersion;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$VersionInterfaceBuilder].
  $VersionInterface rebuild(void Function($VersionInterfaceBuilder) updates);

  /// Converts the instance to a builder [$VersionInterfaceBuilder].
  $VersionInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($VersionInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($VersionInterfaceBuilder b) {}
}

abstract class Version implements $VersionInterface, Built<Version, VersionBuilder> {
  /// Creates a new Version object using the builder pattern.
  factory Version([void Function(VersionBuilder)? b]) = _$Version;

  // coverage:ignore-start
  const Version._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Version.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Version.
  static Serializer<Version> get serializer => _$versionSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(VersionBuilder b) {
    $VersionInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(VersionBuilder b) {
    $VersionInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $VisibleInfoBlocksInterface {
  /// Show the preparation time in UI.
  @BuiltValueField(wireName: 'preparation-time')
  bool? get preparationTime;

  /// Show the time required for cooking in the UI.
  @BuiltValueField(wireName: 'cooking-time')
  bool? get cookingTime;

  /// Show the total time required to carry out the complee recipe.
  @BuiltValueField(wireName: 'total-time')
  bool? get totalTime;

  /// Show the nutrition information in the UI.
  @BuiltValueField(wireName: 'nutrition-information')
  bool? get nutritionInformation;

  /// Show the list of tools in the UI.
  bool? get tools;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$VisibleInfoBlocksInterfaceBuilder].
  $VisibleInfoBlocksInterface rebuild(void Function($VisibleInfoBlocksInterfaceBuilder) updates);

  /// Converts the instance to a builder [$VisibleInfoBlocksInterfaceBuilder].
  $VisibleInfoBlocksInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($VisibleInfoBlocksInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($VisibleInfoBlocksInterfaceBuilder b) {}
}

abstract class VisibleInfoBlocks
    implements $VisibleInfoBlocksInterface, Built<VisibleInfoBlocks, VisibleInfoBlocksBuilder> {
  /// Creates a new VisibleInfoBlocks object using the builder pattern.
  factory VisibleInfoBlocks([void Function(VisibleInfoBlocksBuilder)? b]) = _$VisibleInfoBlocks;

  // coverage:ignore-start
  const VisibleInfoBlocks._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory VisibleInfoBlocks.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for VisibleInfoBlocks.
  static Serializer<VisibleInfoBlocks> get serializer => _$visibleInfoBlocksSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(VisibleInfoBlocksBuilder b) {
    $VisibleInfoBlocksInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(VisibleInfoBlocksBuilder b) {
    $VisibleInfoBlocksInterface._validate(b);
  }
}

/// An object describing the configuration of the web app.
@BuiltValue(instantiable: false)
sealed class $ConfigInterface {
  /// The folder in the user's files that contains the recipes.
  String? get folder;

  /// The interval between automatic rescans to rebuild the database cache in minutes.
  @BuiltValueField(wireName: 'update_interval')
  int? get updateInterval;

  /// True, if the user wished to print the recipe images with the rest of the recipes.
  @BuiltValueField(wireName: 'print_image')
  bool? get printImage;
  VisibleInfoBlocks? get visibleInfoBlocks;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ConfigInterfaceBuilder].
  $ConfigInterface rebuild(void Function($ConfigInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ConfigInterfaceBuilder].
  $ConfigInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ConfigInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ConfigInterfaceBuilder b) {}
}

/// An object describing the configuration of the web app.
abstract class Config implements $ConfigInterface, Built<Config, ConfigBuilder> {
  /// Creates a new Config object using the builder pattern.
  factory Config([void Function(ConfigBuilder)? b]) = _$Config;

  // coverage:ignore-start
  const Config._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Config.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Config.
  static Serializer<Config> get serializer => _$configSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ConfigBuilder b) {
    $ConfigInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ConfigBuilder b) {
    $ConfigInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $UrlInterface {
  String get url;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$UrlInterfaceBuilder].
  $UrlInterface rebuild(void Function($UrlInterfaceBuilder) updates);

  /// Converts the instance to a builder [$UrlInterfaceBuilder].
  $UrlInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($UrlInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($UrlInterfaceBuilder b) {}
}

abstract class Url implements $UrlInterface, Built<Url, UrlBuilder> {
  /// Creates a new Url object using the builder pattern.
  factory Url([void Function(UrlBuilder)? b]) = _$Url;

  // coverage:ignore-start
  const Url._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Url.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Url.
  static Serializer<Url> get serializer => _$urlSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(UrlBuilder b) {
    $UrlInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(UrlBuilder b) {
    $UrlInterface._validate(b);
  }
}

@BuiltValue(instantiable: false)
sealed class $NutritionInterface {
  static final _$type = _$jsonSerializers.deserialize(
    'NutritionInformation',
    specifiedType: const FullType(String),
  )! as String;

  /// Schema.org object description.
  @BuiltValueField(wireName: '@type')
  String get type;

  /// The number of calories for the given amount.
  String? get calories;

  /// The number of grams of carbohydrates.
  String? get carbohydrateContent;

  /// The number of milligrams of cholesterol.
  String? get cholesterolContent;

  /// The number of grams of fat.
  String? get fatContent;

  /// The number of grams of fiber.
  String? get fiberContent;

  /// The number of grams of protein.
  String? get proteinContent;

  /// The number of grams of saturated fat.
  String? get saturatedFatContent;

  /// The serving size, in terms of the number of volume or mass.
  String? get servingSize;

  /// The number of milligrams of sodium.
  String? get sodiumContent;

  /// The number of grams of sugar.
  String? get sugarContent;

  /// The number of grams of trans fat.
  String? get transFatContent;

  /// The number of grams of unsaturated fat.
  String? get unsaturatedFatContent;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$NutritionInterfaceBuilder].
  $NutritionInterface rebuild(void Function($NutritionInterfaceBuilder) updates);

  /// Converts the instance to a builder [$NutritionInterfaceBuilder].
  $NutritionInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($NutritionInterfaceBuilder b) {
    b.type = _$type;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($NutritionInterfaceBuilder b) {}
}

abstract class Nutrition implements $NutritionInterface, Built<Nutrition, NutritionBuilder> {
  /// Creates a new Nutrition object using the builder pattern.
  factory Nutrition([void Function(NutritionBuilder)? b]) = _$Nutrition;

  // coverage:ignore-start
  const Nutrition._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Nutrition.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Nutrition.
  static Serializer<Nutrition> get serializer => _$nutritionSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(NutritionBuilder b) {
    $NutritionInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(NutritionBuilder b) {
    $NutritionInterface._validate(b);
  }
}

/// A recipe according to [schema.org](http://schema.org/Recipe).
@BuiltValue(instantiable: false)
sealed class $RecipeInterface implements $RecipeStubInformationInterface {
  static final _$type = _$jsonSerializers.deserialize(
    'Recipe',
    specifiedType: const FullType(String),
  )! as String;

  static final _$description = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$url = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$image = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  static final _$recipeYield = _$jsonSerializers.deserialize(
    1,
    specifiedType: const FullType(int),
  )! as int;

  static final _$recipeCategory = _$jsonSerializers.deserialize(
    '',
    specifiedType: const FullType(String),
  )! as String;

  /// Schema.org object type identifier.
  @BuiltValueField(wireName: '@type')
  String get type;

  /// The index of the recipe. Note the representation as a string as the representation might change in the future.
  String? get id;

  /// The time required for preparation in ISO8601 format.
  String? get prepTime;

  /// The time required for cooking in ISO8601 format.
  String? get cookTime;

  /// The time required for the complete processing in ISO8601 format.
  String? get totalTime;

  /// A description of the recipe or the empty string.
  String get description;

  /// The URL the recipe was found at or the empty string.
  String get url;

  /// The URL of the original recipe.
  String get image;

  /// Number of servings in recipe.
  int get recipeYield;

  /// The category of the recipe.
  String get recipeCategory;
  BuiltList<String> get tool;
  BuiltList<String> get recipeIngredient;
  BuiltList<String> get recipeInstructions;
  Nutrition get nutrition;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$RecipeInterfaceBuilder].
  @override
  $RecipeInterface rebuild(void Function($RecipeInterfaceBuilder) updates);

  /// Converts the instance to a builder [$RecipeInterfaceBuilder].
  @override
  $RecipeInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($RecipeInterfaceBuilder b) {
    $RecipeStubInformationInterface._defaults(b);
    b.type = _$type;
    b.description = _$description;
    b.url = _$url;
    b.image = _$image;
    b.recipeYield = _$recipeYield;
    b.recipeCategory = _$recipeCategory;
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($RecipeInterfaceBuilder b) {
    $RecipeStubInformationInterface._validate(b);
  }
}

/// A recipe according to [schema.org](http://schema.org/Recipe).
abstract class Recipe implements $RecipeInterface, Built<Recipe, RecipeBuilder> {
  /// Creates a new Recipe object using the builder pattern.
  factory Recipe([void Function(RecipeBuilder)? b]) = _$Recipe;

  // coverage:ignore-start
  const Recipe._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Recipe.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Recipe.
  static Serializer<Recipe> get serializer => _$recipeSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(RecipeBuilder b) {
    $RecipeInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(RecipeBuilder b) {
    $RecipeInterface._validate(b);
  }
}

class GetImageSize extends EnumClass {
  const GetImageSize._(super.name);

  /// `full`
  static const GetImageSize full = _$getImageSizeFull;

  /// `thumb`
  static const GetImageSize thumb = _$getImageSizeThumb;

  /// `thumb16`
  static const GetImageSize thumb16 = _$getImageSizeThumb16;

  /// Returns a set with all values this enum contains.
  // coverage:ignore-start
  static BuiltSet<GetImageSize> get values => _$getImageSizeValues;
  // coverage:ignore-end

  /// Returns the enum value associated to the [name].
  static GetImageSize valueOf(String name) => _$valueOfGetImageSize(name);

  /// Returns the serialized value of this enum value.
  String get value => _$jsonSerializers.serializeWith(serializer, this)! as String;

  /// Serializer for GetImageSize.
  @BuiltValueSerializer(custom: true)
  static Serializer<GetImageSize> get serializer => const _$GetImageSizeSerializer();
}

class _$GetImageSizeSerializer implements PrimitiveSerializer<GetImageSize> {
  const _$GetImageSizeSerializer();

  static const Map<GetImageSize, Object> _toWire = <GetImageSize, Object>{
    GetImageSize.full: 'full',
    GetImageSize.thumb: 'thumb',
    GetImageSize.thumb16: 'thumb16',
  };

  static const Map<Object, GetImageSize> _fromWire = <Object, GetImageSize>{
    'full': GetImageSize.full,
    'thumb': GetImageSize.thumb,
    'thumb16': GetImageSize.thumb16,
  };

  @override
  Iterable<Type> get types => const [GetImageSize];

  @override
  String get wireName => 'GetImageSize';

  @override
  Object serialize(
    Serializers serializers,
    GetImageSize object, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _toWire[object]!;

  @override
  GetImageSize deserialize(
    Serializers serializers,
    Object serialized, {
    FullType specifiedType = FullType.unspecified,
  }) =>
      _fromWire[serialized]!;
}

/// An Keyword.
@BuiltValue(instantiable: false)
sealed class $KeywordInterface implements $CategoryInformationInterface {
  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$KeywordInterfaceBuilder].
  @override
  $KeywordInterface rebuild(void Function($KeywordInterfaceBuilder) updates);

  /// Converts the instance to a builder [$KeywordInterfaceBuilder].
  @override
  $KeywordInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($KeywordInterfaceBuilder b) {
    $CategoryInformationInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($KeywordInterfaceBuilder b) {
    $CategoryInformationInterface._validate(b);
  }
}

/// An Keyword.
abstract class Keyword implements $KeywordInterface, Built<Keyword, KeywordBuilder> {
  /// Creates a new Keyword object using the builder pattern.
  factory Keyword([void Function(KeywordBuilder)? b]) = _$Keyword;

  // coverage:ignore-start
  const Keyword._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Keyword.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Keyword.
  static Serializer<Keyword> get serializer => _$keywordSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(KeywordBuilder b) {
    $KeywordInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(KeywordBuilder b) {
    $KeywordInterface._validate(b);
  }
}

/// An error description.
@BuiltValue(instantiable: false)
sealed class $ErrorInterface {
  /// The error message.
  String? get msg;

  /// The file in which the exception was thrown.
  String? get file;

  /// The line where the exception is thrown.
  int? get line;

  /// Rebuilds the instance.
  ///
  /// The result is the same as this instance but with [updates] applied.
  /// [updates] is a function that takes a builder [$ErrorInterfaceBuilder].
  $ErrorInterface rebuild(void Function($ErrorInterfaceBuilder) updates);

  /// Converts the instance to a builder [$ErrorInterfaceBuilder].
  $ErrorInterfaceBuilder toBuilder();
  @BuiltValueHook(initializeBuilder: true)
  static void _defaults($ErrorInterfaceBuilder b) {}
  @BuiltValueHook(finalizeBuilder: true)
  static void _validate($ErrorInterfaceBuilder b) {}
}

/// An error description.
abstract class Error implements $ErrorInterface, Built<Error, ErrorBuilder> {
  /// Creates a new Error object using the builder pattern.
  factory Error([void Function(ErrorBuilder)? b]) = _$Error;

  // coverage:ignore-start
  const Error._();
  // coverage:ignore-end

  /// Creates a new object from the given [json] data.
  ///
  /// Use [toJson] to serialize it back into json.
  // coverage:ignore-start
  factory Error.fromJson(Map<String, dynamic> json) => _$jsonSerializers.deserializeWith(serializer, json)!;
  // coverage:ignore-end

  /// Parses this object into a json like map.
  ///
  /// Use the fromJson factory to revive it again.
  // coverage:ignore-start
  Map<String, dynamic> toJson() => _$jsonSerializers.serializeWith(serializer, this)! as Map<String, dynamic>;
  // coverage:ignore-end

  /// Serializer for Error.
  static Serializer<Error> get serializer => _$errorSerializer;

  @BuiltValueHook(initializeBuilder: true)
  static void _defaults(ErrorBuilder b) {
    $ErrorInterface._defaults(b);
  }

  @BuiltValueHook(finalizeBuilder: true)
  static void _validate(ErrorBuilder b) {
    $ErrorInterface._validate(b);
  }
}

// coverage:ignore-start
/// Serializer for all values in this library.
///
/// Serializes values into the `built_value` wire format.
/// See: [$jsonSerializers] for serializing into json.
@_i2.visibleForTesting
final Serializers $serializers = _$serializers;
final Serializers _$serializers = (Serializers().toBuilder()
      ..addBuilderFactory(const FullType(Category), CategoryBuilder.new)
      ..add(Category.serializer)
      ..addBuilderFactory(const FullType(CategoryInformation), CategoryInformationBuilder.new)
      ..add(CategoryInformation.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Category)]), ListBuilder<Category>.new)
      ..addBuilderFactory(const FullType(RecipeStub), RecipeStubBuilder.new)
      ..add(RecipeStub.serializer)
      ..addBuilderFactory(const FullType(RecipeStubInformation), RecipeStubInformationBuilder.new)
      ..add(RecipeStubInformation.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(RecipeStub)]), ListBuilder<RecipeStub>.new)
      ..addBuilderFactory(
        const FullType(RenameCategoryRequestApplicationJson),
        RenameCategoryRequestApplicationJsonBuilder.new,
      )
      ..add(RenameCategoryRequestApplicationJson.serializer)
      ..addBuilderFactory(const FullType(Version), VersionBuilder.new)
      ..add(Version.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(JsonObject)]), ListBuilder<JsonObject>.new)
      ..addBuilderFactory(const FullType(APIVersion), APIVersionBuilder.new)
      ..add(APIVersion.serializer)
      ..addBuilderFactory(const FullType(Config), ConfigBuilder.new)
      ..add(Config.serializer)
      ..addBuilderFactory(const FullType(VisibleInfoBlocks), VisibleInfoBlocksBuilder.new)
      ..add(VisibleInfoBlocks.serializer)
      ..addBuilderFactory(const FullType(Url), UrlBuilder.new)
      ..add(Url.serializer)
      ..addBuilderFactory(const FullType(Recipe), RecipeBuilder.new)
      ..add(Recipe.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(String)]), ListBuilder<String>.new)
      ..addBuilderFactory(const FullType(Nutrition), NutritionBuilder.new)
      ..add(Nutrition.serializer)
      ..add(GetImageSize.serializer)
      ..addBuilderFactory(const FullType(Keyword), KeywordBuilder.new)
      ..add(Keyword.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Keyword)]), ListBuilder<Keyword>.new)
      ..addBuilderFactory(const FullType(Error), ErrorBuilder.new)
      ..add(Error.serializer)
      ..addBuilderFactory(const FullType(BuiltList, [FullType(Recipe)]), ListBuilder<Recipe>.new))
    .build();

/// Serializer for all values in this library.
///
/// Serializes values into the json. Json serialization is more expensive than the built_value wire format.
/// See: [$serializers] for serializing into the `built_value` wire format.
@_i2.visibleForTesting
final Serializers $jsonSerializers = _$jsonSerializers;
final Serializers _$jsonSerializers = (_$serializers.toBuilder()
      ..add(_i6.DynamiteDoubleSerializer())
      ..addPlugin(_i7.StandardJsonPlugin())
      ..addPlugin(const _i6.HeaderPlugin())
      ..addPlugin(const _i6.ContentStringPlugin()))
    .build();
// coverage:ignore-end
