part of '../bidi.dart';

/// The type of Unicode character decomposition.
enum DecompositionType {
  // A base form or no special variant.
  // none,

  /// A font variant (e.g. a blackletter form).
  font,

  /// A no-break version of a space or hyphen.
  noBreak,

  /// An initial presentation form (Persian).
  initial,

  /// A medial presentation form (Persian).
  medial,

  /// A final presentation form (Persian).
  finalForm,

  /// An isolated presentation form (Persian).
  isolated,

  /// An encircled form.
  circle,

  /// A superscript form.
  superscript,

  /// A subscript form.
  subscript,

  /// A vertical layout presentation form.
  vertical,

  /// A wide (or zenkaku) compatibility character.
  wide,

  /// A narrow (or hankaku) compatibility character.>
  narrow,

  /// A small variant form (CNS compatibility).
  small,

  /// A CJK squared font variant.
  square,

  /// A vulgar fraction form.
  fraction,

  /// Otherwise unspecified compatibility character.
  compat
}

/// Decomposition Types.
const decompositionTypes = <int, DecompositionType>{
  8450: DecompositionType.font,
  8458: DecompositionType.font,
  8459: DecompositionType.font,
  8460: DecompositionType.font,
  8461: DecompositionType.font,
  8462: DecompositionType.font,
  8463: DecompositionType.font,
  8464: DecompositionType.font,
  8465: DecompositionType.font,
  8466: DecompositionType.font,
  8467: DecompositionType.font,
  8469: DecompositionType.font,
  8473: DecompositionType.font,
  8474: DecompositionType.font,
  8475: DecompositionType.font,
  8476: DecompositionType.font,
  8477: DecompositionType.font,
  8484: DecompositionType.font,
  8488: DecompositionType.font,
  8492: DecompositionType.font,
  8493: DecompositionType.font,
  8495: DecompositionType.font,
  8496: DecompositionType.font,
  8497: DecompositionType.font,
  8499: DecompositionType.font,
  8500: DecompositionType.font,
  8505: DecompositionType.font,
  8508: DecompositionType.font,
  8509: DecompositionType.font,
  8510: DecompositionType.font,
  8511: DecompositionType.font,
  8512: DecompositionType.font,
  8517: DecompositionType.font,
  8518: DecompositionType.font,
  8519: DecompositionType.font,
  8520: DecompositionType.font,
  8521: DecompositionType.font,
  64288: DecompositionType.font,
  64289: DecompositionType.font,
  64290: DecompositionType.font,
  64291: DecompositionType.font,
  64292: DecompositionType.font,
  64293: DecompositionType.font,
  64294: DecompositionType.font,
  64295: DecompositionType.font,
  64296: DecompositionType.font,
  64297: DecompositionType.font,
  160: DecompositionType.noBreak,
  3852: DecompositionType.noBreak,
  8199: DecompositionType.noBreak,
  8209: DecompositionType.noBreak,
  8239: DecompositionType.noBreak,
  64340: DecompositionType.initial,
  64344: DecompositionType.initial,
  64348: DecompositionType.initial,
  64352: DecompositionType.initial,
  64356: DecompositionType.initial,
  64360: DecompositionType.initial,
  64364: DecompositionType.initial,
  64368: DecompositionType.initial,
  64372: DecompositionType.initial,
  64376: DecompositionType.initial,
  64380: DecompositionType.initial,
  64384: DecompositionType.initial,
  64400: DecompositionType.initial,
  64404: DecompositionType.initial,
  64408: DecompositionType.initial,
  64412: DecompositionType.initial,
  64418: DecompositionType.initial,
  64424: DecompositionType.initial,
  64428: DecompositionType.initial,
  64469: DecompositionType.initial,
  64486: DecompositionType.initial,
  64488: DecompositionType.initial,
  64504: DecompositionType.initial,
  64507: DecompositionType.initial,
  64510: DecompositionType.initial,
  64663: DecompositionType.initial,
  64664: DecompositionType.initial,
  64665: DecompositionType.initial,
  64666: DecompositionType.initial,
  64667: DecompositionType.initial,
  64668: DecompositionType.initial,
  64669: DecompositionType.initial,
  64670: DecompositionType.initial,
  64671: DecompositionType.initial,
  64672: DecompositionType.initial,
  64673: DecompositionType.initial,
  64674: DecompositionType.initial,
  64675: DecompositionType.initial,
  64676: DecompositionType.initial,
  64677: DecompositionType.initial,
  64678: DecompositionType.initial,
  64679: DecompositionType.initial,
  64680: DecompositionType.initial,
  64681: DecompositionType.initial,
  64682: DecompositionType.initial,
  64683: DecompositionType.initial,
  64684: DecompositionType.initial,
  64685: DecompositionType.initial,
  64686: DecompositionType.initial,
  64687: DecompositionType.initial,
  64688: DecompositionType.initial,
  64689: DecompositionType.initial,
  64690: DecompositionType.initial,
  64691: DecompositionType.initial,
  64692: DecompositionType.initial,
  64693: DecompositionType.initial,
  64694: DecompositionType.initial,
  64695: DecompositionType.initial,
  64696: DecompositionType.initial,
  64697: DecompositionType.initial,
  64698: DecompositionType.initial,
  64699: DecompositionType.initial,
  64700: DecompositionType.initial,
  64701: DecompositionType.initial,
  64702: DecompositionType.initial,
  64703: DecompositionType.initial,
  64704: DecompositionType.initial,
  64705: DecompositionType.initial,
  64706: DecompositionType.initial,
  64707: DecompositionType.initial,
  64708: DecompositionType.initial,
  64709: DecompositionType.initial,
  64710: DecompositionType.initial,
  64711: DecompositionType.initial,
  64712: DecompositionType.initial,
  64713: DecompositionType.initial,
  64714: DecompositionType.initial,
  64715: DecompositionType.initial,
  64716: DecompositionType.initial,
  64717: DecompositionType.initial,
  64718: DecompositionType.initial,
  64719: DecompositionType.initial,
  64720: DecompositionType.initial,
  64721: DecompositionType.initial,
  64722: DecompositionType.initial,
  64723: DecompositionType.initial,
  64724: DecompositionType.initial,
  64725: DecompositionType.initial,
  64726: DecompositionType.initial,
  64727: DecompositionType.initial,
  64728: DecompositionType.initial,
  64729: DecompositionType.initial,
  64730: DecompositionType.initial,
  64731: DecompositionType.initial,
  64732: DecompositionType.initial,
  64733: DecompositionType.initial,
  64734: DecompositionType.initial,
  64813: DecompositionType.initial,
  64814: DecompositionType.initial,
  64815: DecompositionType.initial,
  64816: DecompositionType.initial,
  64817: DecompositionType.initial,
  64818: DecompositionType.initial,
  64819: DecompositionType.initial,
  64848: DecompositionType.initial,
  64850: DecompositionType.initial,
  64851: DecompositionType.initial,
  64852: DecompositionType.initial,
  64853: DecompositionType.initial,
  64854: DecompositionType.initial,
  64855: DecompositionType.initial,
  64857: DecompositionType.initial,
  64860: DecompositionType.initial,
  64861: DecompositionType.initial,
  64864: DecompositionType.initial,
  64865: DecompositionType.initial,
  64867: DecompositionType.initial,
  64869: DecompositionType.initial,
  64872: DecompositionType.initial,
  64875: DecompositionType.initial,
  64877: DecompositionType.initial,
  64880: DecompositionType.initial,
  64882: DecompositionType.initial,
  64883: DecompositionType.initial,
  64887: DecompositionType.initial,
  64893: DecompositionType.initial,
  64899: DecompositionType.initial,
  64902: DecompositionType.initial,
  64904: DecompositionType.initial,
  64905: DecompositionType.initial,
  64906: DecompositionType.initial,
  64908: DecompositionType.initial,
  64909: DecompositionType.initial,
  64910: DecompositionType.initial,
  64911: DecompositionType.initial,
  64914: DecompositionType.initial,
  64915: DecompositionType.initial,
  64916: DecompositionType.initial,
  64917: DecompositionType.initial,
  64920: DecompositionType.initial,
  64925: DecompositionType.initial,
  64948: DecompositionType.initial,
  64949: DecompositionType.initial,
  64952: DecompositionType.initial,
  64954: DecompositionType.initial,
  64963: DecompositionType.initial,
  64964: DecompositionType.initial,
  64965: DecompositionType.initial,
  65163: DecompositionType.initial,
  65169: DecompositionType.initial,
  65175: DecompositionType.initial,
  65179: DecompositionType.initial,
  65183: DecompositionType.initial,
  65187: DecompositionType.initial,
  65191: DecompositionType.initial,
  65203: DecompositionType.initial,
  65207: DecompositionType.initial,
  65211: DecompositionType.initial,
  65215: DecompositionType.initial,
  65219: DecompositionType.initial,
  65223: DecompositionType.initial,
  65227: DecompositionType.initial,
  65231: DecompositionType.initial,
  65235: DecompositionType.initial,
  65239: DecompositionType.initial,
  65243: DecompositionType.initial,
  65247: DecompositionType.initial,
  65251: DecompositionType.initial,
  65255: DecompositionType.initial,
  65259: DecompositionType.initial,
  65267: DecompositionType.initial,
  64341: DecompositionType.medial,
  64345: DecompositionType.medial,
  64349: DecompositionType.medial,
  64353: DecompositionType.medial,
  64357: DecompositionType.medial,
  64361: DecompositionType.medial,
  64365: DecompositionType.medial,
  64369: DecompositionType.medial,
  64373: DecompositionType.medial,
  64377: DecompositionType.medial,
  64381: DecompositionType.medial,
  64385: DecompositionType.medial,
  64401: DecompositionType.medial,
  64405: DecompositionType.medial,
  64409: DecompositionType.medial,
  64413: DecompositionType.medial,
  64419: DecompositionType.medial,
  64425: DecompositionType.medial,
  64429: DecompositionType.medial,
  64470: DecompositionType.medial,
  64487: DecompositionType.medial,
  64489: DecompositionType.medial,
  64511: DecompositionType.medial,
  64735: DecompositionType.medial,
  64736: DecompositionType.medial,
  64737: DecompositionType.medial,
  64738: DecompositionType.medial,
  64739: DecompositionType.medial,
  64740: DecompositionType.medial,
  64741: DecompositionType.medial,
  64742: DecompositionType.medial,
  64743: DecompositionType.medial,
  64744: DecompositionType.medial,
  64745: DecompositionType.medial,
  64746: DecompositionType.medial,
  64747: DecompositionType.medial,
  64748: DecompositionType.medial,
  64749: DecompositionType.medial,
  64750: DecompositionType.medial,
  64751: DecompositionType.medial,
  64752: DecompositionType.medial,
  64753: DecompositionType.medial,
  64754: DecompositionType.medial,
  64755: DecompositionType.medial,
  64756: DecompositionType.medial,
  64820: DecompositionType.medial,
  64821: DecompositionType.medial,
  64822: DecompositionType.medial,
  64823: DecompositionType.medial,
  64824: DecompositionType.medial,
  64825: DecompositionType.medial,
  64826: DecompositionType.medial,
  64827: DecompositionType.medial,
  65137: DecompositionType.medial,
  65143: DecompositionType.medial,
  65145: DecompositionType.medial,
  65147: DecompositionType.medial,
  65149: DecompositionType.medial,
  65151: DecompositionType.medial,
  65164: DecompositionType.medial,
  65170: DecompositionType.medial,
  65176: DecompositionType.medial,
  65180: DecompositionType.medial,
  65184: DecompositionType.medial,
  65188: DecompositionType.medial,
  65192: DecompositionType.medial,
  65204: DecompositionType.medial,
  65208: DecompositionType.medial,
  65212: DecompositionType.medial,
  65216: DecompositionType.medial,
  65220: DecompositionType.medial,
  65224: DecompositionType.medial,
  65228: DecompositionType.medial,
  65232: DecompositionType.medial,
  65236: DecompositionType.medial,
  65240: DecompositionType.medial,
  65244: DecompositionType.medial,
  65248: DecompositionType.medial,
  65252: DecompositionType.medial,
  65256: DecompositionType.medial,
  65260: DecompositionType.medial,
  65268: DecompositionType.medial,
  64337: DecompositionType.finalForm,
  64339: DecompositionType.finalForm,
  64343: DecompositionType.finalForm,
  64347: DecompositionType.finalForm,
  64351: DecompositionType.finalForm,
  64355: DecompositionType.finalForm,
  64359: DecompositionType.finalForm,
  64363: DecompositionType.finalForm,
  64367: DecompositionType.finalForm,
  64371: DecompositionType.finalForm,
  64375: DecompositionType.finalForm,
  64379: DecompositionType.finalForm,
  64383: DecompositionType.finalForm,
  64387: DecompositionType.finalForm,
  64389: DecompositionType.finalForm,
  64391: DecompositionType.finalForm,
  64393: DecompositionType.finalForm,
  64395: DecompositionType.finalForm,
  64397: DecompositionType.finalForm,
  64399: DecompositionType.finalForm,
  64403: DecompositionType.finalForm,
  64407: DecompositionType.finalForm,
  64411: DecompositionType.finalForm,
  64415: DecompositionType.finalForm,
  64417: DecompositionType.finalForm,
  64421: DecompositionType.finalForm,
  64423: DecompositionType.finalForm,
  64427: DecompositionType.finalForm,
  64431: DecompositionType.finalForm,
  64433: DecompositionType.finalForm,
  64468: DecompositionType.finalForm,
  64472: DecompositionType.finalForm,
  64474: DecompositionType.finalForm,
  64476: DecompositionType.finalForm,
  64479: DecompositionType.finalForm,
  64481: DecompositionType.finalForm,
  64483: DecompositionType.finalForm,
  64485: DecompositionType.finalForm,
  64491: DecompositionType.finalForm,
  64493: DecompositionType.finalForm,
  64495: DecompositionType.finalForm,
  64497: DecompositionType.finalForm,
  64499: DecompositionType.finalForm,
  64501: DecompositionType.finalForm,
  64503: DecompositionType.finalForm,
  64506: DecompositionType.finalForm,
  64509: DecompositionType.finalForm,
  64612: DecompositionType.finalForm,
  64613: DecompositionType.finalForm,
  64614: DecompositionType.finalForm,
  64615: DecompositionType.finalForm,
  64616: DecompositionType.finalForm,
  64617: DecompositionType.finalForm,
  64618: DecompositionType.finalForm,
  64619: DecompositionType.finalForm,
  64620: DecompositionType.finalForm,
  64621: DecompositionType.finalForm,
  64622: DecompositionType.finalForm,
  64623: DecompositionType.finalForm,
  64624: DecompositionType.finalForm,
  64625: DecompositionType.finalForm,
  64626: DecompositionType.finalForm,
  64627: DecompositionType.finalForm,
  64628: DecompositionType.finalForm,
  64629: DecompositionType.finalForm,
  64630: DecompositionType.finalForm,
  64631: DecompositionType.finalForm,
  64632: DecompositionType.finalForm,
  64633: DecompositionType.finalForm,
  64634: DecompositionType.finalForm,
  64635: DecompositionType.finalForm,
  64636: DecompositionType.finalForm,
  64637: DecompositionType.finalForm,
  64638: DecompositionType.finalForm,
  64639: DecompositionType.finalForm,
  64640: DecompositionType.finalForm,
  64641: DecompositionType.finalForm,
  64642: DecompositionType.finalForm,
  64643: DecompositionType.finalForm,
  64644: DecompositionType.finalForm,
  64645: DecompositionType.finalForm,
  64646: DecompositionType.finalForm,
  64647: DecompositionType.finalForm,
  64648: DecompositionType.finalForm,
  64649: DecompositionType.finalForm,
  64650: DecompositionType.finalForm,
  64651: DecompositionType.finalForm,
  64652: DecompositionType.finalForm,
  64653: DecompositionType.finalForm,
  64654: DecompositionType.finalForm,
  64655: DecompositionType.finalForm,
  64656: DecompositionType.finalForm,
  64657: DecompositionType.finalForm,
  64658: DecompositionType.finalForm,
  64659: DecompositionType.finalForm,
  64660: DecompositionType.finalForm,
  64661: DecompositionType.finalForm,
  64662: DecompositionType.finalForm,
  64785: DecompositionType.finalForm,
  64786: DecompositionType.finalForm,
  64787: DecompositionType.finalForm,
  64788: DecompositionType.finalForm,
  64789: DecompositionType.finalForm,
  64790: DecompositionType.finalForm,
  64791: DecompositionType.finalForm,
  64792: DecompositionType.finalForm,
  64793: DecompositionType.finalForm,
  64794: DecompositionType.finalForm,
  64795: DecompositionType.finalForm,
  64796: DecompositionType.finalForm,
  64797: DecompositionType.finalForm,
  64798: DecompositionType.finalForm,
  64799: DecompositionType.finalForm,
  64800: DecompositionType.finalForm,
  64801: DecompositionType.finalForm,
  64802: DecompositionType.finalForm,
  64803: DecompositionType.finalForm,
  64804: DecompositionType.finalForm,
  64805: DecompositionType.finalForm,
  64806: DecompositionType.finalForm,
  64807: DecompositionType.finalForm,
  64808: DecompositionType.finalForm,
  64809: DecompositionType.finalForm,
  64810: DecompositionType.finalForm,
  64811: DecompositionType.finalForm,
  64812: DecompositionType.finalForm,
  64828: DecompositionType.finalForm,
  64849: DecompositionType.finalForm,
  64856: DecompositionType.finalForm,
  64858: DecompositionType.finalForm,
  64859: DecompositionType.finalForm,
  64862: DecompositionType.finalForm,
  64863: DecompositionType.finalForm,
  64866: DecompositionType.finalForm,
  64868: DecompositionType.finalForm,
  64870: DecompositionType.finalForm,
  64871: DecompositionType.finalForm,
  64873: DecompositionType.finalForm,
  64874: DecompositionType.finalForm,
  64876: DecompositionType.finalForm,
  64878: DecompositionType.finalForm,
  64879: DecompositionType.finalForm,
  64881: DecompositionType.finalForm,
  64884: DecompositionType.finalForm,
  64885: DecompositionType.finalForm,
  64886: DecompositionType.finalForm,
  64888: DecompositionType.finalForm,
  64889: DecompositionType.finalForm,
  64890: DecompositionType.finalForm,
  64891: DecompositionType.finalForm,
  64892: DecompositionType.finalForm,
  64894: DecompositionType.finalForm,
  64895: DecompositionType.finalForm,
  64896: DecompositionType.finalForm,
  64897: DecompositionType.finalForm,
  64898: DecompositionType.finalForm,
  64900: DecompositionType.finalForm,
  64901: DecompositionType.finalForm,
  64903: DecompositionType.finalForm,
  64907: DecompositionType.finalForm,
  64918: DecompositionType.finalForm,
  64919: DecompositionType.finalForm,
  64921: DecompositionType.finalForm,
  64922: DecompositionType.finalForm,
  64923: DecompositionType.finalForm,
  64924: DecompositionType.finalForm,
  64926: DecompositionType.finalForm,
  64927: DecompositionType.finalForm,
  64928: DecompositionType.finalForm,
  64929: DecompositionType.finalForm,
  64930: DecompositionType.finalForm,
  64931: DecompositionType.finalForm,
  64932: DecompositionType.finalForm,
  64933: DecompositionType.finalForm,
  64934: DecompositionType.finalForm,
  64935: DecompositionType.finalForm,
  64936: DecompositionType.finalForm,
  64937: DecompositionType.finalForm,
  64938: DecompositionType.finalForm,
  64939: DecompositionType.finalForm,
  64940: DecompositionType.finalForm,
  64941: DecompositionType.finalForm,
  64942: DecompositionType.finalForm,
  64943: DecompositionType.finalForm,
  64944: DecompositionType.finalForm,
  64945: DecompositionType.finalForm,
  64946: DecompositionType.finalForm,
  64947: DecompositionType.finalForm,
  64950: DecompositionType.finalForm,
  64951: DecompositionType.finalForm,
  64953: DecompositionType.finalForm,
  64955: DecompositionType.finalForm,
  64956: DecompositionType.finalForm,
  64957: DecompositionType.finalForm,
  64958: DecompositionType.finalForm,
  64959: DecompositionType.finalForm,
  64960: DecompositionType.finalForm,
  64961: DecompositionType.finalForm,
  64962: DecompositionType.finalForm,
  64966: DecompositionType.finalForm,
  64967: DecompositionType.finalForm,
  65154: DecompositionType.finalForm,
  65156: DecompositionType.finalForm,
  65158: DecompositionType.finalForm,
  65160: DecompositionType.finalForm,
  65162: DecompositionType.finalForm,
  65166: DecompositionType.finalForm,
  65168: DecompositionType.finalForm,
  65172: DecompositionType.finalForm,
  65174: DecompositionType.finalForm,
  65178: DecompositionType.finalForm,
  65182: DecompositionType.finalForm,
  65186: DecompositionType.finalForm,
  65190: DecompositionType.finalForm,
  65194: DecompositionType.finalForm,
  65196: DecompositionType.finalForm,
  65198: DecompositionType.finalForm,
  65200: DecompositionType.finalForm,
  65202: DecompositionType.finalForm,
  65206: DecompositionType.finalForm,
  65210: DecompositionType.finalForm,
  65214: DecompositionType.finalForm,
  65218: DecompositionType.finalForm,
  65222: DecompositionType.finalForm,
  65226: DecompositionType.finalForm,
  65230: DecompositionType.finalForm,
  65234: DecompositionType.finalForm,
  65238: DecompositionType.finalForm,
  65242: DecompositionType.finalForm,
  65246: DecompositionType.finalForm,
  65250: DecompositionType.finalForm,
  65254: DecompositionType.finalForm,
  65258: DecompositionType.finalForm,
  65262: DecompositionType.finalForm,
  65264: DecompositionType.finalForm,
  65266: DecompositionType.finalForm,
  65270: DecompositionType.finalForm,
  65272: DecompositionType.finalForm,
  65274: DecompositionType.finalForm,
  65276: DecompositionType.finalForm,
  64336: DecompositionType.isolated,
  64338: DecompositionType.isolated,
  64342: DecompositionType.isolated,
  64346: DecompositionType.isolated,
  64350: DecompositionType.isolated,
  64354: DecompositionType.isolated,
  64358: DecompositionType.isolated,
  64362: DecompositionType.isolated,
  64366: DecompositionType.isolated,
  64370: DecompositionType.isolated,
  64374: DecompositionType.isolated,
  64378: DecompositionType.isolated,
  64382: DecompositionType.isolated,
  64386: DecompositionType.isolated,
  64388: DecompositionType.isolated,
  64390: DecompositionType.isolated,
  64392: DecompositionType.isolated,
  64394: DecompositionType.isolated,
  64396: DecompositionType.isolated,
  64398: DecompositionType.isolated,
  64402: DecompositionType.isolated,
  64406: DecompositionType.isolated,
  64410: DecompositionType.isolated,
  64414: DecompositionType.isolated,
  64416: DecompositionType.isolated,
  64420: DecompositionType.isolated,
  64422: DecompositionType.isolated,
  64426: DecompositionType.isolated,
  64430: DecompositionType.isolated,
  64432: DecompositionType.isolated,
  64467: DecompositionType.isolated,
  64471: DecompositionType.isolated,
  64473: DecompositionType.isolated,
  64475: DecompositionType.isolated,
  64477: DecompositionType.isolated,
  64478: DecompositionType.isolated,
  64480: DecompositionType.isolated,
  64482: DecompositionType.isolated,
  64484: DecompositionType.isolated,
  64490: DecompositionType.isolated,
  64492: DecompositionType.isolated,
  64494: DecompositionType.isolated,
  64496: DecompositionType.isolated,
  64498: DecompositionType.isolated,
  64500: DecompositionType.isolated,
  64502: DecompositionType.isolated,
  64505: DecompositionType.isolated,
  64508: DecompositionType.isolated,
  64512: DecompositionType.isolated,
  64513: DecompositionType.isolated,
  64514: DecompositionType.isolated,
  64515: DecompositionType.isolated,
  64516: DecompositionType.isolated,
  64517: DecompositionType.isolated,
  64518: DecompositionType.isolated,
  64519: DecompositionType.isolated,
  64520: DecompositionType.isolated,
  64521: DecompositionType.isolated,
  64522: DecompositionType.isolated,
  64523: DecompositionType.isolated,
  64524: DecompositionType.isolated,
  64525: DecompositionType.isolated,
  64526: DecompositionType.isolated,
  64527: DecompositionType.isolated,
  64528: DecompositionType.isolated,
  64529: DecompositionType.isolated,
  64530: DecompositionType.isolated,
  64531: DecompositionType.isolated,
  64532: DecompositionType.isolated,
  64533: DecompositionType.isolated,
  64534: DecompositionType.isolated,
  64535: DecompositionType.isolated,
  64536: DecompositionType.isolated,
  64537: DecompositionType.isolated,
  64538: DecompositionType.isolated,
  64539: DecompositionType.isolated,
  64540: DecompositionType.isolated,
  64541: DecompositionType.isolated,
  64542: DecompositionType.isolated,
  64543: DecompositionType.isolated,
  64544: DecompositionType.isolated,
  64545: DecompositionType.isolated,
  64546: DecompositionType.isolated,
  64547: DecompositionType.isolated,
  64548: DecompositionType.isolated,
  64549: DecompositionType.isolated,
  64550: DecompositionType.isolated,
  64551: DecompositionType.isolated,
  64552: DecompositionType.isolated,
  64553: DecompositionType.isolated,
  64554: DecompositionType.isolated,
  64555: DecompositionType.isolated,
  64556: DecompositionType.isolated,
  64557: DecompositionType.isolated,
  64558: DecompositionType.isolated,
  64559: DecompositionType.isolated,
  64560: DecompositionType.isolated,
  64561: DecompositionType.isolated,
  64562: DecompositionType.isolated,
  64563: DecompositionType.isolated,
  64564: DecompositionType.isolated,
  64565: DecompositionType.isolated,
  64566: DecompositionType.isolated,
  64567: DecompositionType.isolated,
  64568: DecompositionType.isolated,
  64569: DecompositionType.isolated,
  64570: DecompositionType.isolated,
  64571: DecompositionType.isolated,
  64572: DecompositionType.isolated,
  64573: DecompositionType.isolated,
  64574: DecompositionType.isolated,
  64575: DecompositionType.isolated,
  64576: DecompositionType.isolated,
  64577: DecompositionType.isolated,
  64578: DecompositionType.isolated,
  64579: DecompositionType.isolated,
  64580: DecompositionType.isolated,
  64581: DecompositionType.isolated,
  64582: DecompositionType.isolated,
  64583: DecompositionType.isolated,
  64584: DecompositionType.isolated,
  64585: DecompositionType.isolated,
  64586: DecompositionType.isolated,
  64587: DecompositionType.isolated,
  64588: DecompositionType.isolated,
  64589: DecompositionType.isolated,
  64590: DecompositionType.isolated,
  64591: DecompositionType.isolated,
  64592: DecompositionType.isolated,
  64593: DecompositionType.isolated,
  64594: DecompositionType.isolated,
  64595: DecompositionType.isolated,
  64596: DecompositionType.isolated,
  64597: DecompositionType.isolated,
  64598: DecompositionType.isolated,
  64599: DecompositionType.isolated,
  64600: DecompositionType.isolated,
  64601: DecompositionType.isolated,
  64602: DecompositionType.isolated,
  64603: DecompositionType.isolated,
  64604: DecompositionType.isolated,
  64605: DecompositionType.isolated,
  64606: DecompositionType.isolated,
  64607: DecompositionType.isolated,
  64608: DecompositionType.isolated,
  64609: DecompositionType.isolated,
  64610: DecompositionType.isolated,
  64611: DecompositionType.isolated,
  64757: DecompositionType.isolated,
  64758: DecompositionType.isolated,
  64759: DecompositionType.isolated,
  64760: DecompositionType.isolated,
  64761: DecompositionType.isolated,
  64762: DecompositionType.isolated,
  64763: DecompositionType.isolated,
  64764: DecompositionType.isolated,
  64765: DecompositionType.isolated,
  64766: DecompositionType.isolated,
  64767: DecompositionType.isolated,
  64768: DecompositionType.isolated,
  64769: DecompositionType.isolated,
  64770: DecompositionType.isolated,
  64771: DecompositionType.isolated,
  64772: DecompositionType.isolated,
  64773: DecompositionType.isolated,
  64774: DecompositionType.isolated,
  64775: DecompositionType.isolated,
  64776: DecompositionType.isolated,
  64777: DecompositionType.isolated,
  64778: DecompositionType.isolated,
  64779: DecompositionType.isolated,
  64780: DecompositionType.isolated,
  64781: DecompositionType.isolated,
  64782: DecompositionType.isolated,
  64783: DecompositionType.isolated,
  64784: DecompositionType.isolated,
  64829: DecompositionType.isolated,
  65008: DecompositionType.isolated,
  65009: DecompositionType.isolated,
  65010: DecompositionType.isolated,
  65011: DecompositionType.isolated,
  65012: DecompositionType.isolated,
  65013: DecompositionType.isolated,
  65014: DecompositionType.isolated,
  65015: DecompositionType.isolated,
  65016: DecompositionType.isolated,
  65017: DecompositionType.isolated,
  65018: DecompositionType.isolated,
  65019: DecompositionType.isolated,
  65020: DecompositionType.isolated,
  65136: DecompositionType.isolated,
  65138: DecompositionType.isolated,
  65140: DecompositionType.isolated,
  65142: DecompositionType.isolated,
  65144: DecompositionType.isolated,
  65146: DecompositionType.isolated,
  65148: DecompositionType.isolated,
  65150: DecompositionType.isolated,
  65152: DecompositionType.isolated,
  65153: DecompositionType.isolated,
  65155: DecompositionType.isolated,
  65157: DecompositionType.isolated,
  65159: DecompositionType.isolated,
  65161: DecompositionType.isolated,
  65165: DecompositionType.isolated,
  65167: DecompositionType.isolated,
  65171: DecompositionType.isolated,
  65173: DecompositionType.isolated,
  65177: DecompositionType.isolated,
  65181: DecompositionType.isolated,
  65185: DecompositionType.isolated,
  65189: DecompositionType.isolated,
  65193: DecompositionType.isolated,
  65195: DecompositionType.isolated,
  65197: DecompositionType.isolated,
  65199: DecompositionType.isolated,
  65201: DecompositionType.isolated,
  65205: DecompositionType.isolated,
  65209: DecompositionType.isolated,
  65213: DecompositionType.isolated,
  65217: DecompositionType.isolated,
  65221: DecompositionType.isolated,
  65225: DecompositionType.isolated,
  65229: DecompositionType.isolated,
  65233: DecompositionType.isolated,
  65237: DecompositionType.isolated,
  65241: DecompositionType.isolated,
  65245: DecompositionType.isolated,
  65249: DecompositionType.isolated,
  65253: DecompositionType.isolated,
  65257: DecompositionType.isolated,
  65261: DecompositionType.isolated,
  65263: DecompositionType.isolated,
  65265: DecompositionType.isolated,
  65269: DecompositionType.isolated,
  65271: DecompositionType.isolated,
  65273: DecompositionType.isolated,
  65275: DecompositionType.isolated,
  9312: DecompositionType.circle,
  9313: DecompositionType.circle,
  9314: DecompositionType.circle,
  9315: DecompositionType.circle,
  9316: DecompositionType.circle,
  9317: DecompositionType.circle,
  9318: DecompositionType.circle,
  9319: DecompositionType.circle,
  9320: DecompositionType.circle,
  9321: DecompositionType.circle,
  9322: DecompositionType.circle,
  9323: DecompositionType.circle,
  9324: DecompositionType.circle,
  9325: DecompositionType.circle,
  9326: DecompositionType.circle,
  9327: DecompositionType.circle,
  9328: DecompositionType.circle,
  9329: DecompositionType.circle,
  9330: DecompositionType.circle,
  9331: DecompositionType.circle,
  9398: DecompositionType.circle,
  9399: DecompositionType.circle,
  9400: DecompositionType.circle,
  9401: DecompositionType.circle,
  9402: DecompositionType.circle,
  9403: DecompositionType.circle,
  9404: DecompositionType.circle,
  9405: DecompositionType.circle,
  9406: DecompositionType.circle,
  9407: DecompositionType.circle,
  9408: DecompositionType.circle,
  9409: DecompositionType.circle,
  9410: DecompositionType.circle,
  9411: DecompositionType.circle,
  9412: DecompositionType.circle,
  9413: DecompositionType.circle,
  9414: DecompositionType.circle,
  9415: DecompositionType.circle,
  9416: DecompositionType.circle,
  9417: DecompositionType.circle,
  9418: DecompositionType.circle,
  9419: DecompositionType.circle,
  9420: DecompositionType.circle,
  9421: DecompositionType.circle,
  9422: DecompositionType.circle,
  9423: DecompositionType.circle,
  9424: DecompositionType.circle,
  9425: DecompositionType.circle,
  9426: DecompositionType.circle,
  9427: DecompositionType.circle,
  9428: DecompositionType.circle,
  9429: DecompositionType.circle,
  9430: DecompositionType.circle,
  9431: DecompositionType.circle,
  9432: DecompositionType.circle,
  9433: DecompositionType.circle,
  9434: DecompositionType.circle,
  9435: DecompositionType.circle,
  9436: DecompositionType.circle,
  9437: DecompositionType.circle,
  9438: DecompositionType.circle,
  9439: DecompositionType.circle,
  9440: DecompositionType.circle,
  9441: DecompositionType.circle,
  9442: DecompositionType.circle,
  9443: DecompositionType.circle,
  9444: DecompositionType.circle,
  9445: DecompositionType.circle,
  9446: DecompositionType.circle,
  9447: DecompositionType.circle,
  9448: DecompositionType.circle,
  9449: DecompositionType.circle,
  9450: DecompositionType.circle,
  12868: DecompositionType.circle,
  12869: DecompositionType.circle,
  12870: DecompositionType.circle,
  12871: DecompositionType.circle,
  12881: DecompositionType.circle,
  12882: DecompositionType.circle,
  12883: DecompositionType.circle,
  12884: DecompositionType.circle,
  12885: DecompositionType.circle,
  12886: DecompositionType.circle,
  12887: DecompositionType.circle,
  12888: DecompositionType.circle,
  12889: DecompositionType.circle,
  12890: DecompositionType.circle,
  12891: DecompositionType.circle,
  12892: DecompositionType.circle,
  12893: DecompositionType.circle,
  12894: DecompositionType.circle,
  12895: DecompositionType.circle,
  12896: DecompositionType.circle,
  12897: DecompositionType.circle,
  12898: DecompositionType.circle,
  12899: DecompositionType.circle,
  12900: DecompositionType.circle,
  12901: DecompositionType.circle,
  12902: DecompositionType.circle,
  12903: DecompositionType.circle,
  12904: DecompositionType.circle,
  12905: DecompositionType.circle,
  12906: DecompositionType.circle,
  12907: DecompositionType.circle,
  12908: DecompositionType.circle,
  12909: DecompositionType.circle,
  12910: DecompositionType.circle,
  12911: DecompositionType.circle,
  12912: DecompositionType.circle,
  12913: DecompositionType.circle,
  12914: DecompositionType.circle,
  12915: DecompositionType.circle,
  12916: DecompositionType.circle,
  12917: DecompositionType.circle,
  12918: DecompositionType.circle,
  12919: DecompositionType.circle,
  12920: DecompositionType.circle,
  12921: DecompositionType.circle,
  12922: DecompositionType.circle,
  12923: DecompositionType.circle,
  12924: DecompositionType.circle,
  12925: DecompositionType.circle,
  12926: DecompositionType.circle,
  12928: DecompositionType.circle,
  12929: DecompositionType.circle,
  12930: DecompositionType.circle,
  12931: DecompositionType.circle,
  12932: DecompositionType.circle,
  12933: DecompositionType.circle,
  12934: DecompositionType.circle,
  12935: DecompositionType.circle,
  12936: DecompositionType.circle,
  12937: DecompositionType.circle,
  12938: DecompositionType.circle,
  12939: DecompositionType.circle,
  12940: DecompositionType.circle,
  12941: DecompositionType.circle,
  12942: DecompositionType.circle,
  12943: DecompositionType.circle,
  12944: DecompositionType.circle,
  12945: DecompositionType.circle,
  12946: DecompositionType.circle,
  12947: DecompositionType.circle,
  12948: DecompositionType.circle,
  12949: DecompositionType.circle,
  12950: DecompositionType.circle,
  12951: DecompositionType.circle,
  12952: DecompositionType.circle,
  12953: DecompositionType.circle,
  12954: DecompositionType.circle,
  12955: DecompositionType.circle,
  12956: DecompositionType.circle,
  12957: DecompositionType.circle,
  12958: DecompositionType.circle,
  12959: DecompositionType.circle,
  12960: DecompositionType.circle,
  12961: DecompositionType.circle,
  12962: DecompositionType.circle,
  12963: DecompositionType.circle,
  12964: DecompositionType.circle,
  12965: DecompositionType.circle,
  12966: DecompositionType.circle,
  12967: DecompositionType.circle,
  12968: DecompositionType.circle,
  12969: DecompositionType.circle,
  12970: DecompositionType.circle,
  12971: DecompositionType.circle,
  12972: DecompositionType.circle,
  12973: DecompositionType.circle,
  12974: DecompositionType.circle,
  12975: DecompositionType.circle,
  12976: DecompositionType.circle,
  12977: DecompositionType.circle,
  12978: DecompositionType.circle,
  12979: DecompositionType.circle,
  12980: DecompositionType.circle,
  12981: DecompositionType.circle,
  12982: DecompositionType.circle,
  12983: DecompositionType.circle,
  12984: DecompositionType.circle,
  12985: DecompositionType.circle,
  12986: DecompositionType.circle,
  12987: DecompositionType.circle,
  12988: DecompositionType.circle,
  12989: DecompositionType.circle,
  12990: DecompositionType.circle,
  12991: DecompositionType.circle,
  13008: DecompositionType.circle,
  13009: DecompositionType.circle,
  13010: DecompositionType.circle,
  13011: DecompositionType.circle,
  13012: DecompositionType.circle,
  13013: DecompositionType.circle,
  13014: DecompositionType.circle,
  13015: DecompositionType.circle,
  13016: DecompositionType.circle,
  13017: DecompositionType.circle,
  13018: DecompositionType.circle,
  13019: DecompositionType.circle,
  13020: DecompositionType.circle,
  13021: DecompositionType.circle,
  13022: DecompositionType.circle,
  13023: DecompositionType.circle,
  13024: DecompositionType.circle,
  13025: DecompositionType.circle,
  13026: DecompositionType.circle,
  13027: DecompositionType.circle,
  13028: DecompositionType.circle,
  13029: DecompositionType.circle,
  13030: DecompositionType.circle,
  13031: DecompositionType.circle,
  13032: DecompositionType.circle,
  13033: DecompositionType.circle,
  13034: DecompositionType.circle,
  13035: DecompositionType.circle,
  13036: DecompositionType.circle,
  13037: DecompositionType.circle,
  13038: DecompositionType.circle,
  13039: DecompositionType.circle,
  13040: DecompositionType.circle,
  13041: DecompositionType.circle,
  13042: DecompositionType.circle,
  13043: DecompositionType.circle,
  13044: DecompositionType.circle,
  13045: DecompositionType.circle,
  13046: DecompositionType.circle,
  13047: DecompositionType.circle,
  13048: DecompositionType.circle,
  13049: DecompositionType.circle,
  13050: DecompositionType.circle,
  13051: DecompositionType.circle,
  13052: DecompositionType.circle,
  13053: DecompositionType.circle,
  13054: DecompositionType.circle,
  170: DecompositionType.superscript,
  178: DecompositionType.superscript,
  179: DecompositionType.superscript,
  185: DecompositionType.superscript,
  186: DecompositionType.superscript,
  688: DecompositionType.superscript,
  689: DecompositionType.superscript,
  690: DecompositionType.superscript,
  691: DecompositionType.superscript,
  692: DecompositionType.superscript,
  693: DecompositionType.superscript,
  694: DecompositionType.superscript,
  695: DecompositionType.superscript,
  696: DecompositionType.superscript,
  736: DecompositionType.superscript,
  737: DecompositionType.superscript,
  738: DecompositionType.superscript,
  739: DecompositionType.superscript,
  740: DecompositionType.superscript,
  4348: DecompositionType.superscript,
  7468: DecompositionType.superscript,
  7469: DecompositionType.superscript,
  7470: DecompositionType.superscript,
  7472: DecompositionType.superscript,
  7473: DecompositionType.superscript,
  7474: DecompositionType.superscript,
  7475: DecompositionType.superscript,
  7476: DecompositionType.superscript,
  7477: DecompositionType.superscript,
  7478: DecompositionType.superscript,
  7479: DecompositionType.superscript,
  7480: DecompositionType.superscript,
  7481: DecompositionType.superscript,
  7482: DecompositionType.superscript,
  7484: DecompositionType.superscript,
  7485: DecompositionType.superscript,
  7486: DecompositionType.superscript,
  7487: DecompositionType.superscript,
  7488: DecompositionType.superscript,
  7489: DecompositionType.superscript,
  7490: DecompositionType.superscript,
  7491: DecompositionType.superscript,
  7492: DecompositionType.superscript,
  7493: DecompositionType.superscript,
  7494: DecompositionType.superscript,
  7495: DecompositionType.superscript,
  7496: DecompositionType.superscript,
  7497: DecompositionType.superscript,
  7498: DecompositionType.superscript,
  7499: DecompositionType.superscript,
  7500: DecompositionType.superscript,
  7501: DecompositionType.superscript,
  7503: DecompositionType.superscript,
  7504: DecompositionType.superscript,
  7505: DecompositionType.superscript,
  7506: DecompositionType.superscript,
  7507: DecompositionType.superscript,
  7508: DecompositionType.superscript,
  7509: DecompositionType.superscript,
  7510: DecompositionType.superscript,
  7511: DecompositionType.superscript,
  7512: DecompositionType.superscript,
  7513: DecompositionType.superscript,
  7514: DecompositionType.superscript,
  7515: DecompositionType.superscript,
  7516: DecompositionType.superscript,
  7517: DecompositionType.superscript,
  7518: DecompositionType.superscript,
  7519: DecompositionType.superscript,
  7520: DecompositionType.superscript,
  7521: DecompositionType.superscript,
  7544: DecompositionType.superscript,
  7579: DecompositionType.superscript,
  7580: DecompositionType.superscript,
  7581: DecompositionType.superscript,
  7582: DecompositionType.superscript,
  7583: DecompositionType.superscript,
  7584: DecompositionType.superscript,
  7585: DecompositionType.superscript,
  7586: DecompositionType.superscript,
  7587: DecompositionType.superscript,
  7588: DecompositionType.superscript,
  7589: DecompositionType.superscript,
  7590: DecompositionType.superscript,
  7591: DecompositionType.superscript,
  7592: DecompositionType.superscript,
  7593: DecompositionType.superscript,
  7594: DecompositionType.superscript,
  7595: DecompositionType.superscript,
  7596: DecompositionType.superscript,
  7597: DecompositionType.superscript,
  7598: DecompositionType.superscript,
  7599: DecompositionType.superscript,
  7600: DecompositionType.superscript,
  7601: DecompositionType.superscript,
  7602: DecompositionType.superscript,
  7603: DecompositionType.superscript,
  7604: DecompositionType.superscript,
  7605: DecompositionType.superscript,
  7606: DecompositionType.superscript,
  7607: DecompositionType.superscript,
  7608: DecompositionType.superscript,
  7609: DecompositionType.superscript,
  7610: DecompositionType.superscript,
  7611: DecompositionType.superscript,
  7612: DecompositionType.superscript,
  7613: DecompositionType.superscript,
  7614: DecompositionType.superscript,
  7615: DecompositionType.superscript,
  8304: DecompositionType.superscript,
  8305: DecompositionType.superscript,
  8308: DecompositionType.superscript,
  8309: DecompositionType.superscript,
  8310: DecompositionType.superscript,
  8311: DecompositionType.superscript,
  8312: DecompositionType.superscript,
  8313: DecompositionType.superscript,
  8314: DecompositionType.superscript,
  8315: DecompositionType.superscript,
  8316: DecompositionType.superscript,
  8317: DecompositionType.superscript,
  8318: DecompositionType.superscript,
  8319: DecompositionType.superscript,
  8480: DecompositionType.superscript,
  8482: DecompositionType.superscript,
  11389: DecompositionType.superscript,
  11631: DecompositionType.superscript,
  12690: DecompositionType.superscript,
  12691: DecompositionType.superscript,
  12692: DecompositionType.superscript,
  12693: DecompositionType.superscript,
  12694: DecompositionType.superscript,
  12695: DecompositionType.superscript,
  12696: DecompositionType.superscript,
  12697: DecompositionType.superscript,
  12698: DecompositionType.superscript,
  12699: DecompositionType.superscript,
  12700: DecompositionType.superscript,
  12701: DecompositionType.superscript,
  12702: DecompositionType.superscript,
  12703: DecompositionType.superscript,
  42652: DecompositionType.superscript,
  42653: DecompositionType.superscript,
  42864: DecompositionType.superscript,
  43000: DecompositionType.superscript,
  43001: DecompositionType.superscript,
  43868: DecompositionType.superscript,
  43869: DecompositionType.superscript,
  43870: DecompositionType.superscript,
  43871: DecompositionType.superscript,
  7522: DecompositionType.subscript,
  7523: DecompositionType.subscript,
  7524: DecompositionType.subscript,
  7525: DecompositionType.subscript,
  7526: DecompositionType.subscript,
  7527: DecompositionType.subscript,
  7528: DecompositionType.subscript,
  7529: DecompositionType.subscript,
  7530: DecompositionType.subscript,
  8320: DecompositionType.subscript,
  8321: DecompositionType.subscript,
  8322: DecompositionType.subscript,
  8323: DecompositionType.subscript,
  8324: DecompositionType.subscript,
  8325: DecompositionType.subscript,
  8326: DecompositionType.subscript,
  8327: DecompositionType.subscript,
  8328: DecompositionType.subscript,
  8329: DecompositionType.subscript,
  8330: DecompositionType.subscript,
  8331: DecompositionType.subscript,
  8332: DecompositionType.subscript,
  8333: DecompositionType.subscript,
  8334: DecompositionType.subscript,
  8336: DecompositionType.subscript,
  8337: DecompositionType.subscript,
  8338: DecompositionType.subscript,
  8339: DecompositionType.subscript,
  8340: DecompositionType.subscript,
  8341: DecompositionType.subscript,
  8342: DecompositionType.subscript,
  8343: DecompositionType.subscript,
  8344: DecompositionType.subscript,
  8345: DecompositionType.subscript,
  8346: DecompositionType.subscript,
  8347: DecompositionType.subscript,
  8348: DecompositionType.subscript,
  11388: DecompositionType.subscript,
  12447: DecompositionType.vertical,
  12543: DecompositionType.vertical,
  65040: DecompositionType.vertical,
  65041: DecompositionType.vertical,
  65042: DecompositionType.vertical,
  65043: DecompositionType.vertical,
  65044: DecompositionType.vertical,
  65045: DecompositionType.vertical,
  65046: DecompositionType.vertical,
  65047: DecompositionType.vertical,
  65048: DecompositionType.vertical,
  65049: DecompositionType.vertical,
  65072: DecompositionType.vertical,
  65073: DecompositionType.vertical,
  65074: DecompositionType.vertical,
  65075: DecompositionType.vertical,
  65076: DecompositionType.vertical,
  65077: DecompositionType.vertical,
  65078: DecompositionType.vertical,
  65079: DecompositionType.vertical,
  65080: DecompositionType.vertical,
  65081: DecompositionType.vertical,
  65082: DecompositionType.vertical,
  65083: DecompositionType.vertical,
  65084: DecompositionType.vertical,
  65085: DecompositionType.vertical,
  65086: DecompositionType.vertical,
  65087: DecompositionType.vertical,
  65088: DecompositionType.vertical,
  65089: DecompositionType.vertical,
  65090: DecompositionType.vertical,
  65091: DecompositionType.vertical,
  65092: DecompositionType.vertical,
  65095: DecompositionType.vertical,
  65096: DecompositionType.vertical,
  12288: DecompositionType.wide,
  65281: DecompositionType.wide,
  65282: DecompositionType.wide,
  65283: DecompositionType.wide,
  65284: DecompositionType.wide,
  65285: DecompositionType.wide,
  65286: DecompositionType.wide,
  65287: DecompositionType.wide,
  65288: DecompositionType.wide,
  65289: DecompositionType.wide,
  65290: DecompositionType.wide,
  65291: DecompositionType.wide,
  65292: DecompositionType.wide,
  65293: DecompositionType.wide,
  65294: DecompositionType.wide,
  65295: DecompositionType.wide,
  65296: DecompositionType.wide,
  65297: DecompositionType.wide,
  65298: DecompositionType.wide,
  65299: DecompositionType.wide,
  65300: DecompositionType.wide,
  65301: DecompositionType.wide,
  65302: DecompositionType.wide,
  65303: DecompositionType.wide,
  65304: DecompositionType.wide,
  65305: DecompositionType.wide,
  65306: DecompositionType.wide,
  65307: DecompositionType.wide,
  65308: DecompositionType.wide,
  65309: DecompositionType.wide,
  65310: DecompositionType.wide,
  65311: DecompositionType.wide,
  65312: DecompositionType.wide,
  65313: DecompositionType.wide,
  65314: DecompositionType.wide,
  65315: DecompositionType.wide,
  65316: DecompositionType.wide,
  65317: DecompositionType.wide,
  65318: DecompositionType.wide,
  65319: DecompositionType.wide,
  65320: DecompositionType.wide,
  65321: DecompositionType.wide,
  65322: DecompositionType.wide,
  65323: DecompositionType.wide,
  65324: DecompositionType.wide,
  65325: DecompositionType.wide,
  65326: DecompositionType.wide,
  65327: DecompositionType.wide,
  65328: DecompositionType.wide,
  65329: DecompositionType.wide,
  65330: DecompositionType.wide,
  65331: DecompositionType.wide,
  65332: DecompositionType.wide,
  65333: DecompositionType.wide,
  65334: DecompositionType.wide,
  65335: DecompositionType.wide,
  65336: DecompositionType.wide,
  65337: DecompositionType.wide,
  65338: DecompositionType.wide,
  65339: DecompositionType.wide,
  65340: DecompositionType.wide,
  65341: DecompositionType.wide,
  65342: DecompositionType.wide,
  65343: DecompositionType.wide,
  65344: DecompositionType.wide,
  65345: DecompositionType.wide,
  65346: DecompositionType.wide,
  65347: DecompositionType.wide,
  65348: DecompositionType.wide,
  65349: DecompositionType.wide,
  65350: DecompositionType.wide,
  65351: DecompositionType.wide,
  65352: DecompositionType.wide,
  65353: DecompositionType.wide,
  65354: DecompositionType.wide,
  65355: DecompositionType.wide,
  65356: DecompositionType.wide,
  65357: DecompositionType.wide,
  65358: DecompositionType.wide,
  65359: DecompositionType.wide,
  65360: DecompositionType.wide,
  65361: DecompositionType.wide,
  65362: DecompositionType.wide,
  65363: DecompositionType.wide,
  65364: DecompositionType.wide,
  65365: DecompositionType.wide,
  65366: DecompositionType.wide,
  65367: DecompositionType.wide,
  65368: DecompositionType.wide,
  65369: DecompositionType.wide,
  65370: DecompositionType.wide,
  65371: DecompositionType.wide,
  65372: DecompositionType.wide,
  65373: DecompositionType.wide,
  65374: DecompositionType.wide,
  65375: DecompositionType.wide,
  65376: DecompositionType.wide,
  65504: DecompositionType.wide,
  65505: DecompositionType.wide,
  65506: DecompositionType.wide,
  65507: DecompositionType.wide,
  65508: DecompositionType.wide,
  65509: DecompositionType.wide,
  65510: DecompositionType.wide,
  65377: DecompositionType.narrow,
  65378: DecompositionType.narrow,
  65379: DecompositionType.narrow,
  65380: DecompositionType.narrow,
  65381: DecompositionType.narrow,
  65382: DecompositionType.narrow,
  65383: DecompositionType.narrow,
  65384: DecompositionType.narrow,
  65385: DecompositionType.narrow,
  65386: DecompositionType.narrow,
  65387: DecompositionType.narrow,
  65388: DecompositionType.narrow,
  65389: DecompositionType.narrow,
  65390: DecompositionType.narrow,
  65391: DecompositionType.narrow,
  65392: DecompositionType.narrow,
  65393: DecompositionType.narrow,
  65394: DecompositionType.narrow,
  65395: DecompositionType.narrow,
  65396: DecompositionType.narrow,
  65397: DecompositionType.narrow,
  65398: DecompositionType.narrow,
  65399: DecompositionType.narrow,
  65400: DecompositionType.narrow,
  65401: DecompositionType.narrow,
  65402: DecompositionType.narrow,
  65403: DecompositionType.narrow,
  65404: DecompositionType.narrow,
  65405: DecompositionType.narrow,
  65406: DecompositionType.narrow,
  65407: DecompositionType.narrow,
  65408: DecompositionType.narrow,
  65409: DecompositionType.narrow,
  65410: DecompositionType.narrow,
  65411: DecompositionType.narrow,
  65412: DecompositionType.narrow,
  65413: DecompositionType.narrow,
  65414: DecompositionType.narrow,
  65415: DecompositionType.narrow,
  65416: DecompositionType.narrow,
  65417: DecompositionType.narrow,
  65418: DecompositionType.narrow,
  65419: DecompositionType.narrow,
  65420: DecompositionType.narrow,
  65421: DecompositionType.narrow,
  65422: DecompositionType.narrow,
  65423: DecompositionType.narrow,
  65424: DecompositionType.narrow,
  65425: DecompositionType.narrow,
  65426: DecompositionType.narrow,
  65427: DecompositionType.narrow,
  65428: DecompositionType.narrow,
  65429: DecompositionType.narrow,
  65430: DecompositionType.narrow,
  65431: DecompositionType.narrow,
  65432: DecompositionType.narrow,
  65433: DecompositionType.narrow,
  65434: DecompositionType.narrow,
  65435: DecompositionType.narrow,
  65436: DecompositionType.narrow,
  65437: DecompositionType.narrow,
  65438: DecompositionType.narrow,
  65439: DecompositionType.narrow,
  65440: DecompositionType.narrow,
  65441: DecompositionType.narrow,
  65442: DecompositionType.narrow,
  65443: DecompositionType.narrow,
  65444: DecompositionType.narrow,
  65445: DecompositionType.narrow,
  65446: DecompositionType.narrow,
  65447: DecompositionType.narrow,
  65448: DecompositionType.narrow,
  65449: DecompositionType.narrow,
  65450: DecompositionType.narrow,
  65451: DecompositionType.narrow,
  65452: DecompositionType.narrow,
  65453: DecompositionType.narrow,
  65454: DecompositionType.narrow,
  65455: DecompositionType.narrow,
  65456: DecompositionType.narrow,
  65457: DecompositionType.narrow,
  65458: DecompositionType.narrow,
  65459: DecompositionType.narrow,
  65460: DecompositionType.narrow,
  65461: DecompositionType.narrow,
  65462: DecompositionType.narrow,
  65463: DecompositionType.narrow,
  65464: DecompositionType.narrow,
  65465: DecompositionType.narrow,
  65466: DecompositionType.narrow,
  65467: DecompositionType.narrow,
  65468: DecompositionType.narrow,
  65469: DecompositionType.narrow,
  65470: DecompositionType.narrow,
  65474: DecompositionType.narrow,
  65475: DecompositionType.narrow,
  65476: DecompositionType.narrow,
  65477: DecompositionType.narrow,
  65478: DecompositionType.narrow,
  65479: DecompositionType.narrow,
  65482: DecompositionType.narrow,
  65483: DecompositionType.narrow,
  65484: DecompositionType.narrow,
  65485: DecompositionType.narrow,
  65486: DecompositionType.narrow,
  65487: DecompositionType.narrow,
  65490: DecompositionType.narrow,
  65491: DecompositionType.narrow,
  65492: DecompositionType.narrow,
  65493: DecompositionType.narrow,
  65494: DecompositionType.narrow,
  65495: DecompositionType.narrow,
  65498: DecompositionType.narrow,
  65499: DecompositionType.narrow,
  65500: DecompositionType.narrow,
  65512: DecompositionType.narrow,
  65513: DecompositionType.narrow,
  65514: DecompositionType.narrow,
  65515: DecompositionType.narrow,
  65516: DecompositionType.narrow,
  65517: DecompositionType.narrow,
  65518: DecompositionType.narrow,
  65104: DecompositionType.small,
  65105: DecompositionType.small,
  65106: DecompositionType.small,
  65108: DecompositionType.small,
  65109: DecompositionType.small,
  65110: DecompositionType.small,
  65111: DecompositionType.small,
  65112: DecompositionType.small,
  65113: DecompositionType.small,
  65114: DecompositionType.small,
  65115: DecompositionType.small,
  65116: DecompositionType.small,
  65117: DecompositionType.small,
  65118: DecompositionType.small,
  65119: DecompositionType.small,
  65120: DecompositionType.small,
  65121: DecompositionType.small,
  65122: DecompositionType.small,
  65123: DecompositionType.small,
  65124: DecompositionType.small,
  65125: DecompositionType.small,
  65126: DecompositionType.small,
  65128: DecompositionType.small,
  65129: DecompositionType.small,
  65130: DecompositionType.small,
  65131: DecompositionType.small,
  12880: DecompositionType.square,
  13004: DecompositionType.square,
  13005: DecompositionType.square,
  13006: DecompositionType.square,
  13007: DecompositionType.square,
  13056: DecompositionType.square,
  13057: DecompositionType.square,
  13058: DecompositionType.square,
  13059: DecompositionType.square,
  13060: DecompositionType.square,
  13061: DecompositionType.square,
  13062: DecompositionType.square,
  13063: DecompositionType.square,
  13064: DecompositionType.square,
  13065: DecompositionType.square,
  13066: DecompositionType.square,
  13067: DecompositionType.square,
  13068: DecompositionType.square,
  13069: DecompositionType.square,
  13070: DecompositionType.square,
  13071: DecompositionType.square,
  13072: DecompositionType.square,
  13073: DecompositionType.square,
  13074: DecompositionType.square,
  13075: DecompositionType.square,
  13076: DecompositionType.square,
  13077: DecompositionType.square,
  13078: DecompositionType.square,
  13079: DecompositionType.square,
  13080: DecompositionType.square,
  13081: DecompositionType.square,
  13082: DecompositionType.square,
  13083: DecompositionType.square,
  13084: DecompositionType.square,
  13085: DecompositionType.square,
  13086: DecompositionType.square,
  13087: DecompositionType.square,
  13088: DecompositionType.square,
  13089: DecompositionType.square,
  13090: DecompositionType.square,
  13091: DecompositionType.square,
  13092: DecompositionType.square,
  13093: DecompositionType.square,
  13094: DecompositionType.square,
  13095: DecompositionType.square,
  13096: DecompositionType.square,
  13097: DecompositionType.square,
  13098: DecompositionType.square,
  13099: DecompositionType.square,
  13100: DecompositionType.square,
  13101: DecompositionType.square,
  13102: DecompositionType.square,
  13103: DecompositionType.square,
  13104: DecompositionType.square,
  13105: DecompositionType.square,
  13106: DecompositionType.square,
  13107: DecompositionType.square,
  13108: DecompositionType.square,
  13109: DecompositionType.square,
  13110: DecompositionType.square,
  13111: DecompositionType.square,
  13112: DecompositionType.square,
  13113: DecompositionType.square,
  13114: DecompositionType.square,
  13115: DecompositionType.square,
  13116: DecompositionType.square,
  13117: DecompositionType.square,
  13118: DecompositionType.square,
  13119: DecompositionType.square,
  13120: DecompositionType.square,
  13121: DecompositionType.square,
  13122: DecompositionType.square,
  13123: DecompositionType.square,
  13124: DecompositionType.square,
  13125: DecompositionType.square,
  13126: DecompositionType.square,
  13127: DecompositionType.square,
  13128: DecompositionType.square,
  13129: DecompositionType.square,
  13130: DecompositionType.square,
  13131: DecompositionType.square,
  13132: DecompositionType.square,
  13133: DecompositionType.square,
  13134: DecompositionType.square,
  13135: DecompositionType.square,
  13136: DecompositionType.square,
  13137: DecompositionType.square,
  13138: DecompositionType.square,
  13139: DecompositionType.square,
  13140: DecompositionType.square,
  13141: DecompositionType.square,
  13142: DecompositionType.square,
  13143: DecompositionType.square,
  13169: DecompositionType.square,
  13170: DecompositionType.square,
  13171: DecompositionType.square,
  13172: DecompositionType.square,
  13173: DecompositionType.square,
  13174: DecompositionType.square,
  13175: DecompositionType.square,
  13176: DecompositionType.square,
  13177: DecompositionType.square,
  13178: DecompositionType.square,
  13179: DecompositionType.square,
  13180: DecompositionType.square,
  13181: DecompositionType.square,
  13182: DecompositionType.square,
  13183: DecompositionType.square,
  13184: DecompositionType.square,
  13185: DecompositionType.square,
  13186: DecompositionType.square,
  13187: DecompositionType.square,
  13188: DecompositionType.square,
  13189: DecompositionType.square,
  13190: DecompositionType.square,
  13191: DecompositionType.square,
  13192: DecompositionType.square,
  13193: DecompositionType.square,
  13194: DecompositionType.square,
  13195: DecompositionType.square,
  13196: DecompositionType.square,
  13197: DecompositionType.square,
  13198: DecompositionType.square,
  13199: DecompositionType.square,
  13200: DecompositionType.square,
  13201: DecompositionType.square,
  13202: DecompositionType.square,
  13203: DecompositionType.square,
  13204: DecompositionType.square,
  13205: DecompositionType.square,
  13206: DecompositionType.square,
  13207: DecompositionType.square,
  13208: DecompositionType.square,
  13209: DecompositionType.square,
  13210: DecompositionType.square,
  13211: DecompositionType.square,
  13212: DecompositionType.square,
  13213: DecompositionType.square,
  13214: DecompositionType.square,
  13215: DecompositionType.square,
  13216: DecompositionType.square,
  13217: DecompositionType.square,
  13218: DecompositionType.square,
  13219: DecompositionType.square,
  13220: DecompositionType.square,
  13221: DecompositionType.square,
  13222: DecompositionType.square,
  13223: DecompositionType.square,
  13224: DecompositionType.square,
  13225: DecompositionType.square,
  13226: DecompositionType.square,
  13227: DecompositionType.square,
  13228: DecompositionType.square,
  13229: DecompositionType.square,
  13230: DecompositionType.square,
  13231: DecompositionType.square,
  13232: DecompositionType.square,
  13233: DecompositionType.square,
  13234: DecompositionType.square,
  13235: DecompositionType.square,
  13236: DecompositionType.square,
  13237: DecompositionType.square,
  13238: DecompositionType.square,
  13239: DecompositionType.square,
  13240: DecompositionType.square,
  13241: DecompositionType.square,
  13242: DecompositionType.square,
  13243: DecompositionType.square,
  13244: DecompositionType.square,
  13245: DecompositionType.square,
  13246: DecompositionType.square,
  13247: DecompositionType.square,
  13248: DecompositionType.square,
  13249: DecompositionType.square,
  13250: DecompositionType.square,
  13251: DecompositionType.square,
  13252: DecompositionType.square,
  13253: DecompositionType.square,
  13254: DecompositionType.square,
  13255: DecompositionType.square,
  13256: DecompositionType.square,
  13257: DecompositionType.square,
  13258: DecompositionType.square,
  13259: DecompositionType.square,
  13260: DecompositionType.square,
  13261: DecompositionType.square,
  13262: DecompositionType.square,
  13263: DecompositionType.square,
  13264: DecompositionType.square,
  13265: DecompositionType.square,
  13266: DecompositionType.square,
  13267: DecompositionType.square,
  13268: DecompositionType.square,
  13269: DecompositionType.square,
  13270: DecompositionType.square,
  13271: DecompositionType.square,
  13272: DecompositionType.square,
  13273: DecompositionType.square,
  13274: DecompositionType.square,
  13275: DecompositionType.square,
  13276: DecompositionType.square,
  13277: DecompositionType.square,
  13278: DecompositionType.square,
  13279: DecompositionType.square,
  13311: DecompositionType.square,
  188: DecompositionType.fraction,
  189: DecompositionType.fraction,
  190: DecompositionType.fraction,
  8528: DecompositionType.fraction,
  8529: DecompositionType.fraction,
  8530: DecompositionType.fraction,
  8531: DecompositionType.fraction,
  8532: DecompositionType.fraction,
  8533: DecompositionType.fraction,
  8534: DecompositionType.fraction,
  8535: DecompositionType.fraction,
  8536: DecompositionType.fraction,
  8537: DecompositionType.fraction,
  8538: DecompositionType.fraction,
  8539: DecompositionType.fraction,
  8540: DecompositionType.fraction,
  8541: DecompositionType.fraction,
  8542: DecompositionType.fraction,
  8543: DecompositionType.fraction,
  8585: DecompositionType.fraction,
  168: DecompositionType.compat,
  175: DecompositionType.compat,
  180: DecompositionType.compat,
  181: DecompositionType.compat,
  184: DecompositionType.compat,
  306: DecompositionType.compat,
  307: DecompositionType.compat,
  319: DecompositionType.compat,
  320: DecompositionType.compat,
  329: DecompositionType.compat,
  383: DecompositionType.compat,
  452: DecompositionType.compat,
  453: DecompositionType.compat,
  454: DecompositionType.compat,
  455: DecompositionType.compat,
  456: DecompositionType.compat,
  457: DecompositionType.compat,
  458: DecompositionType.compat,
  459: DecompositionType.compat,
  460: DecompositionType.compat,
  497: DecompositionType.compat,
  498: DecompositionType.compat,
  499: DecompositionType.compat,
  728: DecompositionType.compat,
  729: DecompositionType.compat,
  730: DecompositionType.compat,
  731: DecompositionType.compat,
  732: DecompositionType.compat,
  733: DecompositionType.compat,
  890: DecompositionType.compat,
  900: DecompositionType.compat,
  976: DecompositionType.compat,
  977: DecompositionType.compat,
  978: DecompositionType.compat,
  981: DecompositionType.compat,
  982: DecompositionType.compat,
  1008: DecompositionType.compat,
  1009: DecompositionType.compat,
  1010: DecompositionType.compat,
  1012: DecompositionType.compat,
  1013: DecompositionType.compat,
  1017: DecompositionType.compat,
  1415: DecompositionType.compat,
  1653: DecompositionType.compat,
  1654: DecompositionType.compat,
  1655: DecompositionType.compat,
  1656: DecompositionType.compat,
  3635: DecompositionType.compat,
  3763: DecompositionType.compat,
  3804: DecompositionType.compat,
  3805: DecompositionType.compat,
  3959: DecompositionType.compat,
  3961: DecompositionType.compat,
  7834: DecompositionType.compat,
  8125: DecompositionType.compat,
  8127: DecompositionType.compat,
  8128: DecompositionType.compat,
  8190: DecompositionType.compat,
  8194: DecompositionType.compat,
  8195: DecompositionType.compat,
  8196: DecompositionType.compat,
  8197: DecompositionType.compat,
  8198: DecompositionType.compat,
  8200: DecompositionType.compat,
  8201: DecompositionType.compat,
  8202: DecompositionType.compat,
  8215: DecompositionType.compat,
  8228: DecompositionType.compat,
  8229: DecompositionType.compat,
  8230: DecompositionType.compat,
  8243: DecompositionType.compat,
  8244: DecompositionType.compat,
  8246: DecompositionType.compat,
  8247: DecompositionType.compat,
  8252: DecompositionType.compat,
  8254: DecompositionType.compat,
  8263: DecompositionType.compat,
  8264: DecompositionType.compat,
  8265: DecompositionType.compat,
  8279: DecompositionType.compat,
  8287: DecompositionType.compat,
  8360: DecompositionType.compat,
  8448: DecompositionType.compat,
  8449: DecompositionType.compat,
  8451: DecompositionType.compat,
  8453: DecompositionType.compat,
  8454: DecompositionType.compat,
  8455: DecompositionType.compat,
  8457: DecompositionType.compat,
  8470: DecompositionType.compat,
  8481: DecompositionType.compat,
  8501: DecompositionType.compat,
  8502: DecompositionType.compat,
  8503: DecompositionType.compat,
  8504: DecompositionType.compat,
  8507: DecompositionType.compat,
  8544: DecompositionType.compat,
  8545: DecompositionType.compat,
  8546: DecompositionType.compat,
  8547: DecompositionType.compat,
  8548: DecompositionType.compat,
  8549: DecompositionType.compat,
  8550: DecompositionType.compat,
  8551: DecompositionType.compat,
  8552: DecompositionType.compat,
  8553: DecompositionType.compat,
  8554: DecompositionType.compat,
  8555: DecompositionType.compat,
  8556: DecompositionType.compat,
  8557: DecompositionType.compat,
  8558: DecompositionType.compat,
  8559: DecompositionType.compat,
  8560: DecompositionType.compat,
  8561: DecompositionType.compat,
  8562: DecompositionType.compat,
  8563: DecompositionType.compat,
  8564: DecompositionType.compat,
  8565: DecompositionType.compat,
  8566: DecompositionType.compat,
  8567: DecompositionType.compat,
  8568: DecompositionType.compat,
  8569: DecompositionType.compat,
  8570: DecompositionType.compat,
  8571: DecompositionType.compat,
  8572: DecompositionType.compat,
  8573: DecompositionType.compat,
  8574: DecompositionType.compat,
  8575: DecompositionType.compat,
  8748: DecompositionType.compat,
  8749: DecompositionType.compat,
  8751: DecompositionType.compat,
  8752: DecompositionType.compat,
  9332: DecompositionType.compat,
  9333: DecompositionType.compat,
  9334: DecompositionType.compat,
  9335: DecompositionType.compat,
  9336: DecompositionType.compat,
  9337: DecompositionType.compat,
  9338: DecompositionType.compat,
  9339: DecompositionType.compat,
  9340: DecompositionType.compat,
  9341: DecompositionType.compat,
  9342: DecompositionType.compat,
  9343: DecompositionType.compat,
  9344: DecompositionType.compat,
  9345: DecompositionType.compat,
  9346: DecompositionType.compat,
  9347: DecompositionType.compat,
  9348: DecompositionType.compat,
  9349: DecompositionType.compat,
  9350: DecompositionType.compat,
  9351: DecompositionType.compat,
  9352: DecompositionType.compat,
  9353: DecompositionType.compat,
  9354: DecompositionType.compat,
  9355: DecompositionType.compat,
  9356: DecompositionType.compat,
  9357: DecompositionType.compat,
  9358: DecompositionType.compat,
  9359: DecompositionType.compat,
  9360: DecompositionType.compat,
  9361: DecompositionType.compat,
  9362: DecompositionType.compat,
  9363: DecompositionType.compat,
  9364: DecompositionType.compat,
  9365: DecompositionType.compat,
  9366: DecompositionType.compat,
  9367: DecompositionType.compat,
  9368: DecompositionType.compat,
  9369: DecompositionType.compat,
  9370: DecompositionType.compat,
  9371: DecompositionType.compat,
  9372: DecompositionType.compat,
  9373: DecompositionType.compat,
  9374: DecompositionType.compat,
  9375: DecompositionType.compat,
  9376: DecompositionType.compat,
  9377: DecompositionType.compat,
  9378: DecompositionType.compat,
  9379: DecompositionType.compat,
  9380: DecompositionType.compat,
  9381: DecompositionType.compat,
  9382: DecompositionType.compat,
  9383: DecompositionType.compat,
  9384: DecompositionType.compat,
  9385: DecompositionType.compat,
  9386: DecompositionType.compat,
  9387: DecompositionType.compat,
  9388: DecompositionType.compat,
  9389: DecompositionType.compat,
  9390: DecompositionType.compat,
  9391: DecompositionType.compat,
  9392: DecompositionType.compat,
  9393: DecompositionType.compat,
  9394: DecompositionType.compat,
  9395: DecompositionType.compat,
  9396: DecompositionType.compat,
  9397: DecompositionType.compat,
  10764: DecompositionType.compat,
  10868: DecompositionType.compat,
  10869: DecompositionType.compat,
  10870: DecompositionType.compat,
  11935: DecompositionType.compat,
  12019: DecompositionType.compat,
  12032: DecompositionType.compat,
  12033: DecompositionType.compat,
  12034: DecompositionType.compat,
  12035: DecompositionType.compat,
  12036: DecompositionType.compat,
  12037: DecompositionType.compat,
  12038: DecompositionType.compat,
  12039: DecompositionType.compat,
  12040: DecompositionType.compat,
  12041: DecompositionType.compat,
  12042: DecompositionType.compat,
  12043: DecompositionType.compat,
  12044: DecompositionType.compat,
  12045: DecompositionType.compat,
  12046: DecompositionType.compat,
  12047: DecompositionType.compat,
  12048: DecompositionType.compat,
  12049: DecompositionType.compat,
  12050: DecompositionType.compat,
  12051: DecompositionType.compat,
  12052: DecompositionType.compat,
  12053: DecompositionType.compat,
  12054: DecompositionType.compat,
  12055: DecompositionType.compat,
  12056: DecompositionType.compat,
  12057: DecompositionType.compat,
  12058: DecompositionType.compat,
  12059: DecompositionType.compat,
  12060: DecompositionType.compat,
  12061: DecompositionType.compat,
  12062: DecompositionType.compat,
  12063: DecompositionType.compat,
  12064: DecompositionType.compat,
  12065: DecompositionType.compat,
  12066: DecompositionType.compat,
  12067: DecompositionType.compat,
  12068: DecompositionType.compat,
  12069: DecompositionType.compat,
  12070: DecompositionType.compat,
  12071: DecompositionType.compat,
  12072: DecompositionType.compat,
  12073: DecompositionType.compat,
  12074: DecompositionType.compat,
  12075: DecompositionType.compat,
  12076: DecompositionType.compat,
  12077: DecompositionType.compat,
  12078: DecompositionType.compat,
  12079: DecompositionType.compat,
  12080: DecompositionType.compat,
  12081: DecompositionType.compat,
  12082: DecompositionType.compat,
  12083: DecompositionType.compat,
  12084: DecompositionType.compat,
  12085: DecompositionType.compat,
  12086: DecompositionType.compat,
  12087: DecompositionType.compat,
  12088: DecompositionType.compat,
  12089: DecompositionType.compat,
  12090: DecompositionType.compat,
  12091: DecompositionType.compat,
  12092: DecompositionType.compat,
  12093: DecompositionType.compat,
  12094: DecompositionType.compat,
  12095: DecompositionType.compat,
  12096: DecompositionType.compat,
  12097: DecompositionType.compat,
  12098: DecompositionType.compat,
  12099: DecompositionType.compat,
  12100: DecompositionType.compat,
  12101: DecompositionType.compat,
  12102: DecompositionType.compat,
  12103: DecompositionType.compat,
  12104: DecompositionType.compat,
  12105: DecompositionType.compat,
  12106: DecompositionType.compat,
  12107: DecompositionType.compat,
  12108: DecompositionType.compat,
  12109: DecompositionType.compat,
  12110: DecompositionType.compat,
  12111: DecompositionType.compat,
  12112: DecompositionType.compat,
  12113: DecompositionType.compat,
  12114: DecompositionType.compat,
  12115: DecompositionType.compat,
  12116: DecompositionType.compat,
  12117: DecompositionType.compat,
  12118: DecompositionType.compat,
  12119: DecompositionType.compat,
  12120: DecompositionType.compat,
  12121: DecompositionType.compat,
  12122: DecompositionType.compat,
  12123: DecompositionType.compat,
  12124: DecompositionType.compat,
  12125: DecompositionType.compat,
  12126: DecompositionType.compat,
  12127: DecompositionType.compat,
  12128: DecompositionType.compat,
  12129: DecompositionType.compat,
  12130: DecompositionType.compat,
  12131: DecompositionType.compat,
  12132: DecompositionType.compat,
  12133: DecompositionType.compat,
  12134: DecompositionType.compat,
  12135: DecompositionType.compat,
  12136: DecompositionType.compat,
  12137: DecompositionType.compat,
  12138: DecompositionType.compat,
  12139: DecompositionType.compat,
  12140: DecompositionType.compat,
  12141: DecompositionType.compat,
  12142: DecompositionType.compat,
  12143: DecompositionType.compat,
  12144: DecompositionType.compat,
  12145: DecompositionType.compat,
  12146: DecompositionType.compat,
  12147: DecompositionType.compat,
  12148: DecompositionType.compat,
  12149: DecompositionType.compat,
  12150: DecompositionType.compat,
  12151: DecompositionType.compat,
  12152: DecompositionType.compat,
  12153: DecompositionType.compat,
  12154: DecompositionType.compat,
  12155: DecompositionType.compat,
  12156: DecompositionType.compat,
  12157: DecompositionType.compat,
  12158: DecompositionType.compat,
  12159: DecompositionType.compat,
  12160: DecompositionType.compat,
  12161: DecompositionType.compat,
  12162: DecompositionType.compat,
  12163: DecompositionType.compat,
  12164: DecompositionType.compat,
  12165: DecompositionType.compat,
  12166: DecompositionType.compat,
  12167: DecompositionType.compat,
  12168: DecompositionType.compat,
  12169: DecompositionType.compat,
  12170: DecompositionType.compat,
  12171: DecompositionType.compat,
  12172: DecompositionType.compat,
  12173: DecompositionType.compat,
  12174: DecompositionType.compat,
  12175: DecompositionType.compat,
  12176: DecompositionType.compat,
  12177: DecompositionType.compat,
  12178: DecompositionType.compat,
  12179: DecompositionType.compat,
  12180: DecompositionType.compat,
  12181: DecompositionType.compat,
  12182: DecompositionType.compat,
  12183: DecompositionType.compat,
  12184: DecompositionType.compat,
  12185: DecompositionType.compat,
  12186: DecompositionType.compat,
  12187: DecompositionType.compat,
  12188: DecompositionType.compat,
  12189: DecompositionType.compat,
  12190: DecompositionType.compat,
  12191: DecompositionType.compat,
  12192: DecompositionType.compat,
  12193: DecompositionType.compat,
  12194: DecompositionType.compat,
  12195: DecompositionType.compat,
  12196: DecompositionType.compat,
  12197: DecompositionType.compat,
  12198: DecompositionType.compat,
  12199: DecompositionType.compat,
  12200: DecompositionType.compat,
  12201: DecompositionType.compat,
  12202: DecompositionType.compat,
  12203: DecompositionType.compat,
  12204: DecompositionType.compat,
  12205: DecompositionType.compat,
  12206: DecompositionType.compat,
  12207: DecompositionType.compat,
  12208: DecompositionType.compat,
  12209: DecompositionType.compat,
  12210: DecompositionType.compat,
  12211: DecompositionType.compat,
  12212: DecompositionType.compat,
  12213: DecompositionType.compat,
  12214: DecompositionType.compat,
  12215: DecompositionType.compat,
  12216: DecompositionType.compat,
  12217: DecompositionType.compat,
  12218: DecompositionType.compat,
  12219: DecompositionType.compat,
  12220: DecompositionType.compat,
  12221: DecompositionType.compat,
  12222: DecompositionType.compat,
  12223: DecompositionType.compat,
  12224: DecompositionType.compat,
  12225: DecompositionType.compat,
  12226: DecompositionType.compat,
  12227: DecompositionType.compat,
  12228: DecompositionType.compat,
  12229: DecompositionType.compat,
  12230: DecompositionType.compat,
  12231: DecompositionType.compat,
  12232: DecompositionType.compat,
  12233: DecompositionType.compat,
  12234: DecompositionType.compat,
  12235: DecompositionType.compat,
  12236: DecompositionType.compat,
  12237: DecompositionType.compat,
  12238: DecompositionType.compat,
  12239: DecompositionType.compat,
  12240: DecompositionType.compat,
  12241: DecompositionType.compat,
  12242: DecompositionType.compat,
  12243: DecompositionType.compat,
  12244: DecompositionType.compat,
  12245: DecompositionType.compat,
  12342: DecompositionType.compat,
  12344: DecompositionType.compat,
  12345: DecompositionType.compat,
  12346: DecompositionType.compat,
  12443: DecompositionType.compat,
  12444: DecompositionType.compat,
  12593: DecompositionType.compat,
  12594: DecompositionType.compat,
  12595: DecompositionType.compat,
  12596: DecompositionType.compat,
  12597: DecompositionType.compat,
  12598: DecompositionType.compat,
  12599: DecompositionType.compat,
  12600: DecompositionType.compat,
  12601: DecompositionType.compat,
  12602: DecompositionType.compat,
  12603: DecompositionType.compat,
  12604: DecompositionType.compat,
  12605: DecompositionType.compat,
  12606: DecompositionType.compat,
  12607: DecompositionType.compat,
  12608: DecompositionType.compat,
  12609: DecompositionType.compat,
  12610: DecompositionType.compat,
  12611: DecompositionType.compat,
  12612: DecompositionType.compat,
  12613: DecompositionType.compat,
  12614: DecompositionType.compat,
  12615: DecompositionType.compat,
  12616: DecompositionType.compat,
  12617: DecompositionType.compat,
  12618: DecompositionType.compat,
  12619: DecompositionType.compat,
  12620: DecompositionType.compat,
  12621: DecompositionType.compat,
  12622: DecompositionType.compat,
  12623: DecompositionType.compat,
  12624: DecompositionType.compat,
  12625: DecompositionType.compat,
  12626: DecompositionType.compat,
  12627: DecompositionType.compat,
  12628: DecompositionType.compat,
  12629: DecompositionType.compat,
  12630: DecompositionType.compat,
  12631: DecompositionType.compat,
  12632: DecompositionType.compat,
  12633: DecompositionType.compat,
  12634: DecompositionType.compat,
  12635: DecompositionType.compat,
  12636: DecompositionType.compat,
  12637: DecompositionType.compat,
  12638: DecompositionType.compat,
  12639: DecompositionType.compat,
  12640: DecompositionType.compat,
  12641: DecompositionType.compat,
  12642: DecompositionType.compat,
  12643: DecompositionType.compat,
  12644: DecompositionType.compat,
  12645: DecompositionType.compat,
  12646: DecompositionType.compat,
  12647: DecompositionType.compat,
  12648: DecompositionType.compat,
  12649: DecompositionType.compat,
  12650: DecompositionType.compat,
  12651: DecompositionType.compat,
  12652: DecompositionType.compat,
  12653: DecompositionType.compat,
  12654: DecompositionType.compat,
  12655: DecompositionType.compat,
  12656: DecompositionType.compat,
  12657: DecompositionType.compat,
  12658: DecompositionType.compat,
  12659: DecompositionType.compat,
  12660: DecompositionType.compat,
  12661: DecompositionType.compat,
  12662: DecompositionType.compat,
  12663: DecompositionType.compat,
  12664: DecompositionType.compat,
  12665: DecompositionType.compat,
  12666: DecompositionType.compat,
  12667: DecompositionType.compat,
  12668: DecompositionType.compat,
  12669: DecompositionType.compat,
  12670: DecompositionType.compat,
  12671: DecompositionType.compat,
  12672: DecompositionType.compat,
  12673: DecompositionType.compat,
  12674: DecompositionType.compat,
  12675: DecompositionType.compat,
  12676: DecompositionType.compat,
  12677: DecompositionType.compat,
  12678: DecompositionType.compat,
  12679: DecompositionType.compat,
  12680: DecompositionType.compat,
  12681: DecompositionType.compat,
  12682: DecompositionType.compat,
  12683: DecompositionType.compat,
  12684: DecompositionType.compat,
  12685: DecompositionType.compat,
  12686: DecompositionType.compat,
  12800: DecompositionType.compat,
  12801: DecompositionType.compat,
  12802: DecompositionType.compat,
  12803: DecompositionType.compat,
  12804: DecompositionType.compat,
  12805: DecompositionType.compat,
  12806: DecompositionType.compat,
  12807: DecompositionType.compat,
  12808: DecompositionType.compat,
  12809: DecompositionType.compat,
  12810: DecompositionType.compat,
  12811: DecompositionType.compat,
  12812: DecompositionType.compat,
  12813: DecompositionType.compat,
  12814: DecompositionType.compat,
  12815: DecompositionType.compat,
  12816: DecompositionType.compat,
  12817: DecompositionType.compat,
  12818: DecompositionType.compat,
  12819: DecompositionType.compat,
  12820: DecompositionType.compat,
  12821: DecompositionType.compat,
  12822: DecompositionType.compat,
  12823: DecompositionType.compat,
  12824: DecompositionType.compat,
  12825: DecompositionType.compat,
  12826: DecompositionType.compat,
  12827: DecompositionType.compat,
  12828: DecompositionType.compat,
  12829: DecompositionType.compat,
  12830: DecompositionType.compat,
  12832: DecompositionType.compat,
  12833: DecompositionType.compat,
  12834: DecompositionType.compat,
  12835: DecompositionType.compat,
  12836: DecompositionType.compat,
  12837: DecompositionType.compat,
  12838: DecompositionType.compat,
  12839: DecompositionType.compat,
  12840: DecompositionType.compat,
  12841: DecompositionType.compat,
  12842: DecompositionType.compat,
  12843: DecompositionType.compat,
  12844: DecompositionType.compat,
  12845: DecompositionType.compat,
  12846: DecompositionType.compat,
  12847: DecompositionType.compat,
  12848: DecompositionType.compat,
  12849: DecompositionType.compat,
  12850: DecompositionType.compat,
  12851: DecompositionType.compat,
  12852: DecompositionType.compat,
  12853: DecompositionType.compat,
  12854: DecompositionType.compat,
  12855: DecompositionType.compat,
  12856: DecompositionType.compat,
  12857: DecompositionType.compat,
  12858: DecompositionType.compat,
  12859: DecompositionType.compat,
  12860: DecompositionType.compat,
  12861: DecompositionType.compat,
  12862: DecompositionType.compat,
  12863: DecompositionType.compat,
  12864: DecompositionType.compat,
  12865: DecompositionType.compat,
  12866: DecompositionType.compat,
  12867: DecompositionType.compat,
  12992: DecompositionType.compat,
  12993: DecompositionType.compat,
  12994: DecompositionType.compat,
  12995: DecompositionType.compat,
  12996: DecompositionType.compat,
  12997: DecompositionType.compat,
  12998: DecompositionType.compat,
  12999: DecompositionType.compat,
  13000: DecompositionType.compat,
  13001: DecompositionType.compat,
  13002: DecompositionType.compat,
  13003: DecompositionType.compat,
  13144: DecompositionType.compat,
  13145: DecompositionType.compat,
  13146: DecompositionType.compat,
  13147: DecompositionType.compat,
  13148: DecompositionType.compat,
  13149: DecompositionType.compat,
  13150: DecompositionType.compat,
  13151: DecompositionType.compat,
  13152: DecompositionType.compat,
  13153: DecompositionType.compat,
  13154: DecompositionType.compat,
  13155: DecompositionType.compat,
  13156: DecompositionType.compat,
  13157: DecompositionType.compat,
  13158: DecompositionType.compat,
  13159: DecompositionType.compat,
  13160: DecompositionType.compat,
  13161: DecompositionType.compat,
  13162: DecompositionType.compat,
  13163: DecompositionType.compat,
  13164: DecompositionType.compat,
  13165: DecompositionType.compat,
  13166: DecompositionType.compat,
  13167: DecompositionType.compat,
  13168: DecompositionType.compat,
  13280: DecompositionType.compat,
  13281: DecompositionType.compat,
  13282: DecompositionType.compat,
  13283: DecompositionType.compat,
  13284: DecompositionType.compat,
  13285: DecompositionType.compat,
  13286: DecompositionType.compat,
  13287: DecompositionType.compat,
  13288: DecompositionType.compat,
  13289: DecompositionType.compat,
  13290: DecompositionType.compat,
  13291: DecompositionType.compat,
  13292: DecompositionType.compat,
  13293: DecompositionType.compat,
  13294: DecompositionType.compat,
  13295: DecompositionType.compat,
  13296: DecompositionType.compat,
  13297: DecompositionType.compat,
  13298: DecompositionType.compat,
  13299: DecompositionType.compat,
  13300: DecompositionType.compat,
  13301: DecompositionType.compat,
  13302: DecompositionType.compat,
  13303: DecompositionType.compat,
  13304: DecompositionType.compat,
  13305: DecompositionType.compat,
  13306: DecompositionType.compat,
  13307: DecompositionType.compat,
  13308: DecompositionType.compat,
  13309: DecompositionType.compat,
  13310: DecompositionType.compat,
  64256: DecompositionType.compat,
  64257: DecompositionType.compat,
  64258: DecompositionType.compat,
  64259: DecompositionType.compat,
  64260: DecompositionType.compat,
  64261: DecompositionType.compat,
  64262: DecompositionType.compat,
  64275: DecompositionType.compat,
  64276: DecompositionType.compat,
  64277: DecompositionType.compat,
  64278: DecompositionType.compat,
  64279: DecompositionType.compat,
  64335: DecompositionType.compat,
  65097: DecompositionType.compat,
  65098: DecompositionType.compat,
  65099: DecompositionType.compat,
  65100: DecompositionType.compat,
  65101: DecompositionType.compat,
  65102: DecompositionType.compat,
  65103: DecompositionType.compat
};

/// Gets the Unicode decomposition type.
DecompositionType? getDecompositionType(int character) {
  return decompositionTypes[character];
}
