# 📝 Flutter Markdown Editor

Introducing the Markdown Editor app, the perfect tool for anyone who needs to create and edit markdown files with ease. With the ability to open ".md" files directly from the explorer, you can easily access your files and start working on them right away.

The app also offers a convenient way to style your text with options such as bold, italics, headings, and more. Adding links is also a breeze with the simple interface.

In addition, you can preview JPEG, PNG, GIF, WebP, BMP, and WBMP image formats right within the app. You can easily open links from the preview, making it easy to navigate between different files and sources.

Choose between Light and Dark Theme Modes, and use the Dual View Mode to simultaneously view both the preview and editing views. Alternatively, you can use Single View Mode to focus on either the preview or editing view.

The app also offers the ability to clear text and start from scratch, as well as create new .md files or edit existing ones.

This Editor was developed using Flutter and is mainly targeted for mobile devices as currently there aren't any standalone markdown editors available.

Please star⭐ the repo if you like what you see😊.

## 💻 Installation links

<table>
  <tr>
    <th>Platform</th>
    <th>Installation Links</th>
  </tr>
  <tr>
    <td>Android</td>
    <td>
      <a href="https://play.google.com/store/apps/details?id=com.adeeteya.markdown_editor">
        <img height="80" alt="Get it on Google Play" src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png">
      </a>
      <br>
      <a href="https://f-droid.org/packages/com.adeeteya.markdown_editor">
        <img height="80" alt="Get it on F-Droid" src="https://f-droid.org/badge/get-it-on.png">
      </a>
      <br>
      <a href="https://github.com/adeeteya/FlutterMarkdownEditor/releases/latest/download/MarkdownEditor-Android.apk">
        <img alt="APK download" src="https://img.shields.io/static/v1?label=Download&message=Android+.apk&color=2ea44f&style=for-the-badge&logo=Android&logoColor=white&logoSize=auto">
      </a>
    </td>
  </tr>

  <tr>
      <td>Linux</td>
      <td>
        <a href="https://github.com/adeeteya/FlutterMarkdownEditor/releases/latest/download/MarkdownEditor-Linux-AppImage.AppImage">
          <img alt="Download .AppImage" src="https://img.shields.io/static/v1?label=Download&message=.AppImage&color=FCC624&style=for-the-badge&logo=linux&logoColor=white&logoSize=auto">
        </a>
        <br>
        <br>
        <a href="https://github.com/adeeteya/FlutterMarkdownEditor/releases/latest/download/MarkdownEditor-Linux-deb.deb">
          <img alt="Download .deb" src="https://img.shields.io/static/v1?label=Download&message=%20%20%20%20%20.deb&color=A81D33&style=for-the-badge&logo=debian&logoColor=white&logoSize=auto">
        </a>
        <br>
        <br>
        <a href="https://github.com/adeeteya/FlutterMarkdownEditor/releases/latest/download/MarkdownEditor-Linux-rpm.rpm">
          <img alt="Download .rpm" src="https://img.shields.io/static/v1?label=Download&message=.rpm&color=EE0000&style=for-the-badge&logo=redhat&logoColor=white&logoSize=auto">
        </a>
        <br>
        <br>
        <a href="https://snapcraft.io/markdown-editor">
          <img alt="Get it from the Snap Store" src=https://snapcraft.io/en/dark/install.svg />
        </a>
      </td>
  </tr>

  <tr>
      <td>Windows</td>
      <td>
        <a href="https://github.com/adeeteya/FlutterMarkdownEditor/releases/latest/download/MarkdownEditor-Windows.exe">
          <img alt="Download Windows Installer" src="https://img.shields.io/static/v1?label=Download&message=Windows+.exe&color=blue&style=for-the-badge&logo=webtrees&logoColor=white&logoSize=auto">
        </a>
      </td>
  </tr>

  <tr>
      <td>Web App</td>
      <td>
        <a href="https://adeeteya.github.io/FlutterMarkdownEditor/#/">
          <img alt="Web App" src="https://img.shields.io/static/v1?label=Webapp&message=Visit+Website&color=blueviolet&style=for-the-badge&logo=googlechrome&logoColor=white&logoSize=auto">
        </a>
      </td>
  </tr>

</table>

## ✨ Features

- [x] Ability to open .md files directly from the explorer
- [x] Convenient way to style text (bold,italics,headings and etc)
- [x] Convenient way to add links
- [x] Convenient way to add tables
- [x] Ability to preview JPEG, PNG, GIF, WebP, BMP, and WBMP image formats.
- [x] Easily open links from the preview
- [x] Light and Dark Theme Modes available
- [x] Dual View Mode available (Both Preview and Editing View)
- [x] Single View Mode available (Either Preview or the Editing View)
- [x] Added Multi Language Support (For Some of the most popular languages of the world)
- [x] Ability to clear text and start from scratch
- [x] Create new .md files
- [x] Edit existing .md files
- [x] LaTex support
- [x] Horizontal Swipe to Switch between Preview and Editing View in Single View Mode
- [x] Default Folder for Opening and Saving .md files
- [x] Added Print/Save as Pdf Option
- [x] Added the option to check/uncheck checkboxes in preview mode

## 📸 Screenshots

<img alt="Light Mode Image" src="screenshots/screenshot_1.png" height="587px" width="256px"/> <img alt="Dark Mode Image" src="screenshots/screenshot_2.png" height="587px" width="256px"/> <img alt="File Explorer Image" src="screenshots/screenshot_3.png" height="587px" width="256px"/> <img alt="Add Link Image" src="screenshots/screenshot_4.png" height="587px" width="256px"/> <img alt="Markdown Preview Image" src="screenshots/screenshot_5.png" height="587px" width="256px"/> <img alt="Markdown Editor Image" src="screenshots/screenshot_6.png" height="587px" width="256px"/>

## 🔌 Plugins

| Name                                                                                        | Usage                                                       |
|---------------------------------------------------------------------------------------------|-------------------------------------------------------------|
| [**expandable**](https://pub.dev/packages/expandable)                                       | To create expandable header buttons                         |
| [**file_picker**](https://pub.dev/packages/file_picker)                                     | To open markdown files directly from the app                |
| [**flutter_localizations**](https://pub.dev/packages/flutter_localizations)                 | Internationalizing app                                      |
| [**flutter_math_fork**](https://pub.dev/packages/flutter_math_fork)                         | Help with LaTeX support                                     |
| [**flutter_svg**](https://pub.dev/packages/flutter_svg)                                     | To Display Svg Images                                       |
| [**flutter_widget_from_html_core**](https://pub.dev/packages/flutter_widget_from_html_core) | To add html display support                                 |
| [**html**](https://pub.dev/packages/html)                                                   | To help display html format                                 |
| [**htmltopdfwidgets**](https://pub.dev/packages/htmltopdfwidgets)                           | To convert html to pdf for printing                         |
| [**intl**](https://pub.dev/packages/intl)                                                   | Provides internationalization and localization facilities   |
| [**markdown**](https://pub.dev/packages/markdown)                                           | To convert markdown to html format                          |
| [**markdown_widget**](https://pub.dev/packages/markdown_widget)                             | To help display markdown/custom markdown                    |
| [**pdf**](https://pub.dev/packages/pdf)                                                     | To help save/create a pdf                                   |
| [**permission_handler**](https://pub.dev/packages/permission_handler)                       | To get storage permissions for opening and saving .md files |
| [**printing**](https://pub.dev/packages/printing)                                           | To help printing a pdf                                      |
| [**shared_preferences**](https://pub.dev/packages/shared_preferences)                       | To store device preferences for persistence                 |
| [**url_launcher**](https://pub.dev/packages/url_launcher)                                   | To launch markdown links                                    |
| [**flutter_lints**](https://pub.dev/packages/flutter_lints)                                 | For linting                                                 |

## 🤓 Author

**[Aditya R](https://github.com/adeeteya)**

## 🔖 LICENCE
Copyright (c) 2023 Aditya R
[MIT LICENCE](https://github.com/adeeteya/FlutterMarkdownEditor/blob/master/LICENSE)

## 🙏 Attributions
<a href="https://www.flaticon.com/free-icons/text-editor" title="text editor icons">Text Editor icons created by Freepik - Flaticon</a>
