# HTMLtoPDFWidgets


HTMLtoPDFWidgets is a Flutter package that allows you to convert HTML and Markdown content into PDF documents with support for various Rich Text Editor formats. With this package, you can effortlessly generate PDF files that include elements such as lists, paragraphs, images, quotes, and headings.

## Help Maintenance

I've been maintaining quite many repos these days and burning out slowly. If you could help me cheer up, buying me a cup of coffee will make my life really happy and get much energy out of it.

<a href="https://www.buymeacoffee.com/alihassan13" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/purple_img.png" alt="Buy Me A Coffee" style="height: auto !important;width: auto !important;" ></a>

## Features

- Convert HTML content to PDF documents in Flutter apps
- Support for Markdown to PDF conversion
- Rich Text Editor formatting support
- Seamless integration with your Flutter project
- Lightweight and easy to use

## Installation

Add the following dependency to your `pubspec.yaml` file:

```yaml
dependencies:
  htmltopdfwidgets: ^1.0.5
```

## Usage

To use HTMLtoPDFWidgets in your Flutter project, follow these simple steps:

1. Import the package:

```dart
import 'package:htmltopdfwidgets/htmltopdfwidgets.dart';
```

2. Convert HTML to PDF:

```dart
final htmlContent = '''
  <h1>Heading Example</h1>
  <p>This is a paragraph.</p>
  <img src="image.jpg" alt="Example Image" />
  <blockquote>This is a quote.</blockquote>
  <ul>
    <li>First item</li>
    <li>Second item</li>
    <li>Third item</li>
  </ul>
''';

  var filePath = 'test/example.pdf';
  var file = File(filePath);
  final newpdf = Document();
  List<Widget> widgets = await HTMLToPdf().convert(htmlContent);
  newpdf.addPage(MultiPage(
      maxPages: 200,
      build: (context) {
        return widgets;
      }));
  await file.writeAsBytes(await newpdf.save());
```
3. Converting Markdown to PDF:

```dart
final markDown = '''
  # Basic Markdown Demo
---
The Basic Markdown Demo shows the effect of the four Markdown extension sets
on formatting basic and extended Markdown tags.

## Overview

The Dart [markdown](https://pub.dev/packages/markdown) package parses Markdown
into HTML. The flutter_markdown package builds on this package using the
abstract syntax tree generated by the parser to make a tree of widgets instead
of HTML elements.

The markdown package supports the basic block and inline Markdown syntax
specified in the original Markdown implementation as well as a few Markdown
extensions. The markdown package uses extension sets to make extension
management easy. There are four pre-defined extension sets; none, Common Mark,
GitHub Flavored, and GitHub Web. The default extension set used by the
flutter_markdown package is GitHub Flavored.

The Basic Markdown Demo shows the effect each of the pre-defined extension sets
has on a test Markdown document with basic and extended Markdown tags. Use the
Extension Set dropdown menu to select an extension set and view the Markdown
widget's output.

## Comments

Since GitHub Flavored is the default extension set, it is the initial setting
for the formatted Markdown view in the demo.
''';

  final List<Widget> markdownWidgets = await HTMLToPdf().convertMarkdown(markDown);
final markdownPdf = Document();
markdownPdf.addPage(MultiPage(
  build: (context) => markdownWidgets,
));
await File('markdown_example.pdf').writeAsBytes(await markdownPdf.save());
```

For more details on usage and available options, please refer to the [API documentation](https://pub.dev/documentation/htmltopdfwidgets/latest).

## Example

You can find a complete example in the [example](https://github.com/alihassan143/htmltopdfwidgets/tree/main/example) directory of this repository.

## License

This package is licensed under the [MIT License](https://github.com/alihassan143/htmltopdfwidgets/blob/main/LICENSE).

## Contributing

Contributions are welcome! If you encounter any issues or have suggestions for improvements, please feel free to open an issue or submit a pull request on the [GitHub repository](https://github.com/alihassan143/htmltopdfwidgets).

## Acknowledgments

Special thanks to the Appflowy editor:
I use their Html To Document plugin as reference

- Appflowy ([@AppFlowy-IO](https://github.com/AppFlowy-IO/appflowy-editor))



Happy PDF generation with HTMLtoPDFWidgets in your Flutter apps!



