///
/// HybridCryptonoteSpec.hpp
/// This file was generated by nitrogen. DO NOT MODIFY THIS FILE.
/// https://github.com/mrousavy/nitro
/// Copyright © 2025 Marc Rousavy @ Margelo
///

#pragma once

#if __has_include(<NitroModules/HybridObject.hpp>)
#include <NitroModules/HybridObject.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif



#include <string>
#include <vector>

namespace margelo::nitro::concealcrypto {

  using namespace margelo::nitro;

  /**
   * An abstract base class for `Cryptonote`
   * Inherit this class to create instances of `HybridCryptonoteSpec` in C++.
   * You must explicitly call `HybridObject`'s constructor yourself, because it is virtual.
   * @example
   * ```cpp
   * class HybridCryptonote: public HybridCryptonoteSpec {
   * public:
   *   HybridCryptonote(...): HybridObject(TAG) { ... }
   *   // ...
   * };
   * ```
   */
  class HybridCryptonoteSpec: public virtual HybridObject {
    public:
      // Constructor
      explicit HybridCryptonoteSpec(): HybridObject(TAG) { }

      // Destructor
      ~HybridCryptonoteSpec() override = default;

    public:
      // Properties
      

    public:
      // Methods
      virtual std::string generateKeyDerivation(const std::string& publicKeyHex, const std::string& secretKeyHex) = 0;
      virtual std::string derivePublicKey(const std::string& derivationHex, double outputIndex, const std::string& publicKeyHex) = 0;
      virtual std::string geScalarmult(const std::string& publicKeyHex, const std::string& secretKeyHex) = 0;
      virtual std::string geAdd(const std::string& point1Hex, const std::string& point2Hex) = 0;
      virtual std::string geScalarmultBase(const std::string& secretKeyHex) = 0;
      virtual std::string geDoubleScalarmultBaseVartime(const std::string& cHex, const std::string& PHex, const std::string& rHex) = 0;
      virtual std::string geDoubleScalarmultPostcompVartime(const std::string& rHex, const std::string& PHex, const std::string& cHex, const std::string& IHex) = 0;
      virtual std::string cnFastHash(const std::string& inputHex) = 0;
      virtual std::string encodeVarint(double value) = 0;
      virtual std::vector<std::string> generateRingSignature(const std::string& prefixHashHex, const std::string& keyImageHex, const std::vector<std::string>& publicKeysHex, const std::string& secretKeyHex, double secretIndex) = 0;

    protected:
      // Hybrid Setup
      void loadHybridMethods() override;

    protected:
      // Tag for logging
      static constexpr auto TAG = "Cryptonote";
  };

} // namespace margelo::nitro::concealcrypto
