///
/// HybridConcealCryptoSpec.hpp
/// This file was generated by nitrogen. DO NOT MODIFY THIS FILE.
/// https://github.com/mrousavy/nitro
/// Copyright © 2025 Marc Rousavy @ Margelo
///

#pragma once

#if __has_include(<NitroModules/HybridObject.hpp>)
#include <NitroModules/HybridObject.hpp>
#else
#error NitroModules cannot be found! Are you sure you installed NitroModules properly?
#endif

// Forward declaration of `HybridCryptonoteSpec` to properly resolve imports.
namespace margelo::nitro::concealcrypto { class HybridCryptonoteSpec; }
// Forward declaration of `HybridMnemonicsSpec` to properly resolve imports.
namespace margelo::nitro::concealcrypto { class HybridMnemonicsSpec; }
// Forward declaration of `ArrayBuffer` to properly resolve imports.
namespace NitroModules { class ArrayBuffer; }

#include <memory>
#include "HybridCryptonoteSpec.hpp"
#include "HybridMnemonicsSpec.hpp"
#include <NitroModules/ArrayBuffer.hpp>
#include <string>
#include <optional>

namespace margelo::nitro::concealcrypto {

  using namespace margelo::nitro;

  /**
   * An abstract base class for `ConcealCrypto`
   * Inherit this class to create instances of `HybridConcealCryptoSpec` in C++.
   * You must explicitly call `HybridObject`'s constructor yourself, because it is virtual.
   * @example
   * ```cpp
   * class HybridConcealCrypto: public HybridConcealCryptoSpec {
   * public:
   *   HybridConcealCrypto(...): HybridObject(TAG) { ... }
   *   // ...
   * };
   * ```
   */
  class HybridConcealCryptoSpec: public virtual HybridObject {
    public:
      // Constructor
      explicit HybridConcealCryptoSpec(): HybridObject(TAG) { }

      // Destructor
      ~HybridConcealCryptoSpec() override = default;

    public:
      // Properties
      virtual std::shared_ptr<HybridCryptonoteSpec> getCryptonote() = 0;
      virtual std::shared_ptr<HybridMnemonicsSpec> getMnemonics() = 0;

    public:
      // Methods
      virtual std::shared_ptr<ArrayBuffer> hextobin(const std::string& hex) = 0;
      virtual std::string bintohex(const std::shared_ptr<ArrayBuffer>& buffer) = 0;
      virtual std::string bin2base64(const std::shared_ptr<ArrayBuffer>& buffer) = 0;
      virtual std::shared_ptr<ArrayBuffer> base642bin(const std::string& base64) = 0;
      virtual std::shared_ptr<ArrayBuffer> chacha8(const std::shared_ptr<ArrayBuffer>& input, const std::shared_ptr<ArrayBuffer>& key, const std::shared_ptr<ArrayBuffer>& iv) = 0;
      virtual std::shared_ptr<ArrayBuffer> chacha12(const std::shared_ptr<ArrayBuffer>& input, const std::shared_ptr<ArrayBuffer>& key, const std::shared_ptr<ArrayBuffer>& iv) = 0;
      virtual std::shared_ptr<ArrayBuffer> hmacSha1(const std::shared_ptr<ArrayBuffer>& key, const std::shared_ptr<ArrayBuffer>& data) = 0;
      virtual std::string random(double bits) = 0;
      virtual std::shared_ptr<ArrayBuffer> randomBytes(double bytes) = 0;
      virtual std::shared_ptr<ArrayBuffer> secretbox(const std::shared_ptr<ArrayBuffer>& message, const std::shared_ptr<ArrayBuffer>& nonce, const std::shared_ptr<ArrayBuffer>& key) = 0;
      virtual std::optional<std::shared_ptr<ArrayBuffer>> secretboxOpen(const std::shared_ptr<ArrayBuffer>& ciphertext, const std::shared_ptr<ArrayBuffer>& nonce, const std::shared_ptr<ArrayBuffer>& key) = 0;

    protected:
      // Hybrid Setup
      void loadHybridMethods() override;

    protected:
      // Tag for logging
      static constexpr auto TAG = "ConcealCrypto";
  };

} // namespace margelo::nitro::concealcrypto
