/*
 * Copyright (c) 2018 Gnock
 * Copyright (c) 2018-2019 The Masari Project
 * Copyright (c) 2018-2020 The Karbo developers
 * Copyright (c) 2018-2023 Conceal Community, Conceal.Network & Conceal Devs
 *
 * Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used to endorse or promote products derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

export class MnemonicLang {
  prefixLen = 0;
  words: Array<string> = [];
  trunc_words: Array<string> = [];
  name = '';
  shortLang = '';

  constructor(name: string, shortLang: string, prefixLen: number, words: Array<string>) {
    this.prefixLen = prefixLen;
    this.words = words;
    this.name = name;
    this.shortLang = shortLang;
    this.calculateTruncWords();
  }

  private calculateTruncWords() {
    if (this.prefixLen === 0) return;

    this.trunc_words = [];
    for (const word of this.words) {
      this.trunc_words.push(word.slice(0, this.prefixLen));
    }
  }

  static getLangs(): Array<MnemonicLang> {
    const langs = [];
    langs.push(
      new MnemonicLang('electrum', 'el', 0, [
        'like',
        'just',
        'love',
        'know',
        'never',
        'want',
        'time',
        'out',
        'there',
        'make',
        'look',
        'eye',
        'down',
        'only',
        'think',
        'heart',
        'back',
        'then',
        'into',
        'about',
        'more',
        'away',
        'still',
        'them',
        'take',
        'thing',
        'even',
        'through',
        'long',
        'always',
        'world',
        'too',
        'friend',
        'tell',
        'try',
        'hand',
        'thought',
        'over',
        'here',
        'other',
        'need',
        'smile',
        'again',
        'much',
        'cry',
        'been',
        'night',
        'ever',
        'little',
        'said',
        'end',
        'some',
        'those',
        'around',
        'mind',
        'people',
        'girl',
        'leave',
        'dream',
        'left',
        'turn',
        'myself',
        'give',
        'nothing',
        'really',
        'off',
        'before',
        'something',
        'find',
        'walk',
        'wish',
        'good',
        'once',
        'place',
        'ask',
        'stop',
        'keep',
        'watch',
        'seem',
        'everything',
        'wait',
        'got',
        'yet',
        'made',
        'remember',
        'start',
        'alone',
        'run',
        'hope',
        'maybe',
        'believe',
        'body',
        'hate',
        'after',
        'close',
        'talk',
        'stand',
        'own',
        'each',
        'hurt',
        'help',
        'home',
        'god',
        'soul',
        'new',
        'many',
        'two',
        'inside',
        'should',
        'true',
        'first',
        'fear',
        'mean',
        'better',
        'play',
        'another',
        'gone',
        'change',
        'use',
        'wonder',
        'someone',
        'hair',
        'cold',
        'open',
        'best',
        'any',
        'behind',
        'happen',
        'water',
        'dark',
        'laugh',
        'stay',
        'forever',
        'name',
        'work',
        'show',
        'sky',
        'break',
        'came',
        'deep',
        'door',
        'put',
        'black',
        'together',
        'upon',
        'happy',
        'such',
        'great',
        'white',
        'matter',
        'fill',
        'past',
        'please',
        'burn',
        'cause',
        'enough',
        'touch',
        'moment',
        'soon',
        'voice',
        'scream',
        'anything',
        'stare',
        'sound',
        'red',
        'everyone',
        'hide',
        'kiss',
        'truth',
        'death',
        'beautiful',
        'mine',
        'blood',
        'broken',
        'very',
        'pass',
        'next',
        'forget',
        'tree',
        'wrong',
        'air',
        'mother',
        'understand',
        'lip',
        'hit',
        'wall',
        'memory',
        'sleep',
        'free',
        'high',
        'realize',
        'school',
        'might',
        'skin',
        'sweet',
        'perfect',
        'blue',
        'kill',
        'breath',
        'dance',
        'against',
        'fly',
        'between',
        'grow',
        'strong',
        'under',
        'listen',
        'bring',
        'sometimes',
        'speak',
        'pull',
        'person',
        'become',
        'family',
        'begin',
        'ground',
        'real',
        'small',
        'father',
        'sure',
        'feet',
        'rest',
        'young',
        'finally',
        'land',
        'across',
        'today',
        'different',
        'guy',
        'line',
        'fire',
        'reason',
        'reach',
        'second',
        'slowly',
        'write',
        'eat',
        'smell',
        'mouth',
        'step',
        'learn',
        'three',
        'floor',
        'promise',
        'breathe',
        'darkness',
        'push',
        'earth',
        'guess',
        'save',
        'song',
        'above',
        'along',
        'both',
        'color',
        'house',
        'almost',
        'sorry',
        'anymore',
        'brother',
        'okay',
        'dear',
        'game',
        'fade',
        'already',
        'apart',
        'warm',
        'beauty',
        'heard',
        'notice',
        'question',
        'shine',
        'began',
        'piece',
        'whole',
        'shadow',
        'secret',
        'street',
        'within',
        'finger',
        'point',
        'morning',
        'whisper',
        'child',
        'moon',
        'green',
        'story',
        'glass',
        'kid',
        'silence',
        'since',
        'soft',
        'yourself',
        'empty',
        'shall',
        'angel',
        'answer',
        'baby',
        'bright',
        'dad',
        'path',
        'worry',
        'hour',
        'drop',
        'follow',
        'power',
        'war',
        'half',
        'flow',
        'heaven',
        'act',
        'chance',
        'fact',
        'least',
        'tired',
        'children',
        'near',
        'quite',
        'afraid',
        'rise',
        'sea',
        'taste',
        'window',
        'cover',
        'nice',
        'trust',
        'lot',
        'sad',
        'cool',
        'force',
        'peace',
        'return',
        'blind',
        'easy',
        'ready',
        'roll',
        'rose',
        'drive',
        'held',
        'music',
        'beneath',
        'hang',
        'mom',
        'paint',
        'emotion',
        'quiet',
        'clear',
        'cloud',
        'few',
        'pretty',
        'bird',
        'outside',
        'paper',
        'picture',
        'front',
        'rock',
        'simple',
        'anyone',
        'meant',
        'reality',
        'road',
        'sense',
        'waste',
        'bit',
        'leaf',
        'thank',
        'happiness',
        'meet',
        'men',
        'smoke',
        'truly',
        'decide',
        'self',
        'age',
        'book',
        'form',
        'alive',
        'carry',
        'escape',
        'damn',
        'instead',
        'able',
        'ice',
        'minute',
        'throw',
        'catch',
        'leg',
        'ring',
        'course',
        'goodbye',
        'lead',
        'poem',
        'sick',
        'corner',
        'desire',
        'known',
        'problem',
        'remind',
        'shoulder',
        'suppose',
        'toward',
        'wave',
        'drink',
        'jump',
        'woman',
        'pretend',
        'sister',
        'week',
        'human',
        'joy',
        'crack',
        'grey',
        'pray',
        'surprise',
        'dry',
        'knee',
        'less',
        'search',
        'bleed',
        'caught',
        'clean',
        'embrace',
        'future',
        'king',
        'son',
        'sorrow',
        'chest',
        'hug',
        'remain',
        'sat',
        'worth',
        'blow',
        'daddy',
        'final',
        'parent',
        'tight',
        'also',
        'create',
        'lonely',
        'safe',
        'cross',
        'dress',
        'evil',
        'silent',
        'bone',
        'fate',
        'perhaps',
        'anger',
        'class',
        'scar',
        'snow',
        'tiny',
        'tonight',
        'continue',
        'control',
        'dog',
        'edge',
        'mirror',
        'month',
        'suddenly',
        'comfort',
        'given',
        'loud',
        'quickly',
        'gaze',
        'plan',
        'rush',
        'stone',
        'town',
        'battle',
        'ignore',
        'spirit',
        'stood',
        'stupid',
        'yours',
        'brown',
        'build',
        'dust',
        'hey',
        'kept',
        'pay',
        'phone',
        'twist',
        'although',
        'ball',
        'beyond',
        'hidden',
        'nose',
        'taken',
        'fail',
        'float',
        'pure',
        'somehow',
        'wash',
        'wrap',
        'angry',
        'cheek',
        'creature',
        'forgotten',
        'heat',
        'rip',
        'single',
        'space',
        'special',
        'weak',
        'whatever',
        'yell',
        'anyway',
        'blame',
        'job',
        'choose',
        'country',
        'curse',
        'drift',
        'echo',
        'figure',
        'grew',
        'laughter',
        'neck',
        'suffer',
        'worse',
        'yeah',
        'disappear',
        'foot',
        'forward',
        'knife',
        'mess',
        'somewhere',
        'stomach',
        'storm',
        'beg',
        'idea',
        'lift',
        'offer',
        'breeze',
        'field',
        'five',
        'often',
        'simply',
        'stuck',
        'win',
        'allow',
        'confuse',
        'enjoy',
        'except',
        'flower',
        'seek',
        'strength',
        'calm',
        'grin',
        'gun',
        'heavy',
        'hill',
        'large',
        'ocean',
        'shoe',
        'sigh',
        'straight',
        'summer',
        'tongue',
        'accept',
        'crazy',
        'everyday',
        'exist',
        'grass',
        'mistake',
        'sent',
        'shut',
        'surround',
        'table',
        'ache',
        'brain',
        'destroy',
        'heal',
        'nature',
        'shout',
        'sign',
        'stain',
        'choice',
        'doubt',
        'glance',
        'glow',
        'mountain',
        'queen',
        'stranger',
        'throat',
        'tomorrow',
        'city',
        'either',
        'fish',
        'flame',
        'rather',
        'shape',
        'spin',
        'spread',
        'ash',
        'distance',
        'finish',
        'image',
        'imagine',
        'important',
        'nobody',
        'shatter',
        'warmth',
        'became',
        'feed',
        'flesh',
        'funny',
        'lust',
        'shirt',
        'trouble',
        'yellow',
        'attention',
        'bare',
        'bite',
        'money',
        'protect',
        'amaze',
        'appear',
        'born',
        'choke',
        'completely',
        'daughter',
        'fresh',
        'friendship',
        'gentle',
        'probably',
        'six',
        'deserve',
        'expect',
        'grab',
        'middle',
        'nightmare',
        'river',
        'thousand',
        'weight',
        'worst',
        'wound',
        'barely',
        'bottle',
        'cream',
        'regret',
        'relationship',
        'stick',
        'test',
        'crush',
        'endless',
        'fault',
        'itself',
        'rule',
        'spill',
        'art',
        'circle',
        'join',
        'kick',
        'mask',
        'master',
        'passion',
        'quick',
        'raise',
        'smooth',
        'unless',
        'wander',
        'actually',
        'broke',
        'chair',
        'deal',
        'favorite',
        'gift',
        'note',
        'number',
        'sweat',
        'box',
        'chill',
        'clothes',
        'lady',
        'mark',
        'park',
        'poor',
        'sadness',
        'tie',
        'animal',
        'belong',
        'brush',
        'consume',
        'dawn',
        'forest',
        'innocent',
        'pen',
        'pride',
        'stream',
        'thick',
        'clay',
        'complete',
        'count',
        'draw',
        'faith',
        'press',
        'silver',
        'struggle',
        'surface',
        'taught',
        'teach',
        'wet',
        'bless',
        'chase',
        'climb',
        'enter',
        'letter',
        'melt',
        'metal',
        'movie',
        'stretch',
        'swing',
        'vision',
        'wife',
        'beside',
        'crash',
        'forgot',
        'guide',
        'haunt',
        'joke',
        'knock',
        'plant',
        'pour',
        'prove',
        'reveal',
        'steal',
        'stuff',
        'trip',
        'wood',
        'wrist',
        'bother',
        'bottom',
        'crawl',
        'crowd',
        'fix',
        'forgive',
        'frown',
        'grace',
        'loose',
        'lucky',
        'party',
        'release',
        'surely',
        'survive',
        'teacher',
        'gently',
        'grip',
        'speed',
        'suicide',
        'travel',
        'treat',
        'vein',
        'written',
        'cage',
        'chain',
        'conversation',
        'date',
        'enemy',
        'however',
        'interest',
        'million',
        'page',
        'pink',
        'proud',
        'sway',
        'themselves',
        'winter',
        'church',
        'cruel',
        'cup',
        'demon',
        'experience',
        'freedom',
        'pair',
        'pop',
        'purpose',
        'respect',
        'shoot',
        'softly',
        'state',
        'strange',
        'bar',
        'birth',
        'curl',
        'dirt',
        'excuse',
        'lord',
        'lovely',
        'monster',
        'order',
        'pack',
        'pants',
        'pool',
        'scene',
        'seven',
        'shame',
        'slide',
        'ugly',
        'among',
        'blade',
        'blonde',
        'closet',
        'creek',
        'deny',
        'drug',
        'eternity',
        'gain',
        'grade',
        'handle',
        'key',
        'linger',
        'pale',
        'prepare',
        'swallow',
        'swim',
        'tremble',
        'wheel',
        'won',
        'cast',
        'cigarette',
        'claim',
        'college',
        'direction',
        'dirty',
        'gather',
        'ghost',
        'hundred',
        'loss',
        'lung',
        'orange',
        'present',
        'swear',
        'swirl',
        'twice',
        'wild',
        'bitter',
        'blanket',
        'doctor',
        'everywhere',
        'flash',
        'grown',
        'knowledge',
        'numb',
        'pressure',
        'radio',
        'repeat',
        'ruin',
        'spend',
        'unknown',
        'buy',
        'clock',
        'devil',
        'early',
        'false',
        'fantasy',
        'pound',
        'precious',
        'refuse',
        'sheet',
        'teeth',
        'welcome',
        'add',
        'ahead',
        'block',
        'bury',
        'caress',
        'content',
        'depth',
        'despite',
        'distant',
        'marry',
        'purple',
        'threw',
        'whenever',
        'bomb',
        'dull',
        'easily',
        'grasp',
        'hospital',
        'innocence',
        'normal',
        'receive',
        'reply',
        'rhyme',
        'shade',
        'someday',
        'sword',
        'toe',
        'visit',
        'asleep',
        'bought',
        'center',
        'consider',
        'flat',
        'hero',
        'history',
        'ink',
        'insane',
        'muscle',
        'mystery',
        'pocket',
        'reflection',
        'shove',
        'silently',
        'smart',
        'soldier',
        'spot',
        'stress',
        'train',
        'type',
        'view',
        'whether',
        'bus',
        'energy',
        'explain',
        'holy',
        'hunger',
        'inch',
        'magic',
        'mix',
        'noise',
        'nowhere',
        'prayer',
        'presence',
        'shock',
        'snap',
        'spider',
        'study',
        'thunder',
        'trail',
        'admit',
        'agree',
        'bag',
        'bang',
        'bound',
        'butterfly',
        'cute',
        'exactly',
        'explode',
        'familiar',
        'fold',
        'further',
        'pierce',
        'reflect',
        'scent',
        'selfish',
        'sharp',
        'sink',
        'spring',
        'stumble',
        'universe',
        'weep',
        'women',
        'wonderful',
        'action',
        'ancient',
        'attempt',
        'avoid',
        'birthday',
        'branch',
        'chocolate',
        'core',
        'depress',
        'drunk',
        'especially',
        'focus',
        'fruit',
        'honest',
        'match',
        'palm',
        'perfectly',
        'pillow',
        'pity',
        'poison',
        'roar',
        'shift',
        'slightly',
        'thump',
        'truck',
        'tune',
        'twenty',
        'unable',
        'wipe',
        'wrote',
        'coat',
        'constant',
        'dinner',
        'drove',
        'egg',
        'eternal',
        'flight',
        'flood',
        'frame',
        'freak',
        'gasp',
        'glad',
        'hollow',
        'motion',
        'peer',
        'plastic',
        'root',
        'screen',
        'season',
        'sting',
        'strike',
        'team',
        'unlike',
        'victim',
        'volume',
        'warn',
        'weird',
        'attack',
        'await',
        'awake',
        'built',
        'charm',
        'crave',
        'despair',
        'fought',
        'grant',
        'grief',
        'horse',
        'limit',
        'message',
        'ripple',
        'sanity',
        'scatter',
        'serve',
        'split',
        'string',
        'trick',
        'annoy',
        'blur',
        'boat',
        'brave',
        'clearly',
        'cling',
        'connect',
        'fist',
        'forth',
        'imagination',
        'iron',
        'jock',
        'judge',
        'lesson',
        'milk',
        'misery',
        'nail',
        'naked',
        'ourselves',
        'poet',
        'possible',
        'princess',
        'sail',
        'size',
        'snake',
        'society',
        'stroke',
        'torture',
        'toss',
        'trace',
        'wise',
        'bloom',
        'bullet',
        'cell',
        'check',
        'cost',
        'darling',
        'during',
        'footstep',
        'fragile',
        'hallway',
        'hardly',
        'horizon',
        'invisible',
        'journey',
        'midnight',
        'mud',
        'nod',
        'pause',
        'relax',
        'shiver',
        'sudden',
        'value',
        'youth',
        'abuse',
        'admire',
        'blink',
        'breast',
        'bruise',
        'constantly',
        'couple',
        'creep',
        'curve',
        'difference',
        'dumb',
        'emptiness',
        'gotta',
        'honor',
        'plain',
        'planet',
        'recall',
        'rub',
        'ship',
        'slam',
        'soar',
        'somebody',
        'tightly',
        'weather',
        'adore',
        'approach',
        'bond',
        'bread',
        'burst',
        'candle',
        'coffee',
        'cousin',
        'crime',
        'desert',
        'flutter',
        'frozen',
        'grand',
        'heel',
        'hello',
        'language',
        'level',
        'movement',
        'pleasure',
        'powerful',
        'random',
        'rhythm',
        'settle',
        'silly',
        'slap',
        'sort',
        'spoken',
        'steel',
        'threaten',
        'tumble',
        'upset',
        'aside',
        'awkward',
        'bee',
        'blank',
        'board',
        'button',
        'card',
        'carefully',
        'complain',
        'crap',
        'deeply',
        'discover',
        'drag',
        'dread',
        'effort',
        'entire',
        'fairy',
        'giant',
        'gotten',
        'greet',
        'illusion',
        'jeans',
        'leap',
        'liquid',
        'march',
        'mend',
        'nervous',
        'nine',
        'replace',
        'rope',
        'spine',
        'stole',
        'terror',
        'accident',
        'apple',
        'balance',
        'boom',
        'childhood',
        'collect',
        'demand',
        'depression',
        'eventually',
        'faint',
        'glare',
        'goal',
        'group',
        'honey',
        'kitchen',
        'laid',
        'limb',
        'machine',
        'mere',
        'mold',
        'murder',
        'nerve',
        'painful',
        'poetry',
        'prince',
        'rabbit',
        'shelter',
        'shore',
        'shower',
        'soothe',
        'stair',
        'steady',
        'sunlight',
        'tangle',
        'tease',
        'treasure',
        'uncle',
        'begun',
        'bliss',
        'canvas',
        'cheer',
        'claw',
        'clutch',
        'commit',
        'crimson',
        'crystal',
        'delight',
        'doll',
        'existence',
        'express',
        'fog',
        'football',
        'gay',
        'goose',
        'guard',
        'hatred',
        'illuminate',
        'mass',
        'math',
        'mourn',
        'rich',
        'rough',
        'skip',
        'stir',
        'student',
        'style',
        'support',
        'thorn',
        'tough',
        'yard',
        'yearn',
        'yesterday',
        'advice',
        'appreciate',
        'autumn',
        'bank',
        'beam',
        'bowl',
        'capture',
        'carve',
        'collapse',
        'confusion',
        'creation',
        'dove',
        'feather',
        'girlfriend',
        'glory',
        'government',
        'harsh',
        'hop',
        'inner',
        'loser',
        'moonlight',
        'neighbor',
        'neither',
        'peach',
        'pig',
        'praise',
        'screw',
        'shield',
        'shimmer',
        'sneak',
        'stab',
        'subject',
        'throughout',
        'thrown',
        'tower',
        'twirl',
        'wow',
        'army',
        'arrive',
        'bathroom',
        'bump',
        'cease',
        'cookie',
        'couch',
        'courage',
        'dim',
        'guilt',
        'howl',
        'hum',
        'husband',
        'insult',
        'led',
        'lunch',
        'mock',
        'mostly',
        'natural',
        'nearly',
        'needle',
        'nerd',
        'peaceful',
        'perfection',
        'pile',
        'price',
        'remove',
        'roam',
        'sanctuary',
        'serious',
        'shiny',
        'shook',
        'sob',
        'stolen',
        'tap',
        'vain',
        'void',
        'warrior',
        'wrinkle',
        'affection',
        'apologize',
        'blossom',
        'bounce',
        'bridge',
        'cheap',
        'crumble',
        'decision',
        'descend',
        'desperately',
        'dig',
        'dot',
        'flip',
        'frighten',
        'heartbeat',
        'huge',
        'lazy',
        'lick',
        'odd',
        'opinion',
        'process',
        'puzzle',
        'quietly',
        'retreat',
        'score',
        'sentence',
        'separate',
        'situation',
        'skill',
        'soak',
        'square',
        'stray',
        'taint',
        'task',
        'tide',
        'underneath',
        'veil',
        'whistle',
        'anywhere',
        'bedroom',
        'bid',
        'bloody',
        'burden',
        'careful',
        'compare',
        'concern',
        'curtain',
        'decay',
        'defeat',
        'describe',
        'double',
        'dreamer',
        'driver',
        'dwell',
        'evening',
        'flare',
        'flicker',
        'grandma',
        'guitar',
        'harm',
        'horrible',
        'hungry',
        'indeed',
        'lace',
        'melody',
        'monkey',
        'nation',
        'object',
        'obviously',
        'rainbow',
        'salt',
        'scratch',
        'shown',
        'shy',
        'stage',
        'stun',
        'third',
        'tickle',
        'useless',
        'weakness',
        'worship',
        'worthless',
        'afternoon',
        'beard',
        'boyfriend',
        'bubble',
        'busy',
        'certain',
        'chin',
        'concrete',
        'desk',
        'diamond',
        'doom',
        'drawn',
        'due',
        'felicity',
        'freeze',
        'frost',
        'garden',
        'glide',
        'harmony',
        'hopefully',
        'hunt',
        'jealous',
        'lightning',
        'mama',
        'mercy',
        'peel',
        'physical',
        'position',
        'pulse',
        'punch',
        'quit',
        'rant',
        'respond',
        'salty',
        'sane',
        'satisfy',
        'savior',
        'sheep',
        'slept',
        'social',
        'sport',
        'tuck',
        'utter',
        'valley',
        'wolf',
        'aim',
        'alas',
        'alter',
        'arrow',
        'awaken',
        'beaten',
        'belief',
        'brand',
        'ceiling',
        'cheese',
        'clue',
        'confidence',
        'connection',
        'daily',
        'disguise',
        'eager',
        'erase',
        'essence',
        'everytime',
        'expression',
        'fan',
        'flag',
        'flirt',
        'foul',
        'fur',
        'giggle',
        'glorious',
        'ignorance',
        'law',
        'lifeless',
        'measure',
        'mighty',
        'muse',
        'north',
        'opposite',
        'paradise',
        'patience',
        'patient',
        'pencil',
        'petal',
        'plate',
        'ponder',
        'possibly',
        'practice',
        'slice',
        'spell',
        'stock',
        'strife',
        'strip',
        'suffocate',
        'suit',
        'tender',
        'tool',
        'trade',
        'velvet',
        'verse',
        'waist',
        'witch',
        'aunt',
        'bench',
        'bold',
        'cap',
        'certainly',
        'click',
        'companion',
        'creator',
        'dart',
        'delicate',
        'determine',
        'dish',
        'dragon',
        'drama',
        'drum',
        'dude',
        'everybody',
        'feast',
        'forehead',
        'former',
        'fright',
        'fully',
        'gas',
        'hook',
        'hurl',
        'invite',
        'juice',
        'manage',
        'moral',
        'possess',
        'raw',
        'rebel',
        'royal',
        'scale',
        'scary',
        'several',
        'slight',
        'stubborn',
        'swell',
        'talent',
        'tea',
        'terrible',
        'thread',
        'torment',
        'trickle',
        'usually',
        'vast',
        'violence',
        'weave',
        'acid',
        'agony',
        'ashamed',
        'awe',
        'belly',
        'blend',
        'blush',
        'character',
        'cheat',
        'common',
        'company',
        'coward',
        'creak',
        'danger',
        'deadly',
        'defense',
        'define',
        'depend',
        'desperate',
        'destination',
        'dew',
        'duck',
        'dusty',
        'embarrass',
        'engine',
        'example',
        'explore',
        'foe',
        'freely',
        'frustrate',
        'generation',
        'glove',
        'guilty',
        'health',
        'hurry',
        'idiot',
        'impossible',
        'inhale',
        'jaw',
        'kingdom',
        'mention',
        'mist',
        'moan',
        'mumble',
        'mutter',
        'observe',
        'ode',
        'pathetic',
        'pattern',
        'pie',
        'prefer',
        'puff',
        'rape',
        'rare',
        'revenge',
        'rude',
        'scrape',
        'spiral',
        'squeeze',
        'strain',
        'sunset',
        'suspend',
        'sympathy',
        'thigh',
        'throne',
        'total',
        'unseen',
        'weapon',
        'weary',
      ])
    );
    langs.push(
      new MnemonicLang('english', 'en', 3, [
        'abbey',
        'abducts',
        'ability',
        'ablaze',
        'abnormal',
        'abort',
        'abrasive',
        'absorb',
        'abyss',
        'academy',
        'aces',
        'aching',
        'acidic',
        'acoustic',
        'acquire',
        'across',
        'actress',
        'acumen',
        'adapt',
        'addicted',
        'adept',
        'adhesive',
        'adjust',
        'adopt',
        'adrenalin',
        'adult',
        'adventure',
        'aerial',
        'afar',
        'affair',
        'afield',
        'afloat',
        'afoot',
        'afraid',
        'after',
        'against',
        'agenda',
        'aggravate',
        'agile',
        'aglow',
        'agnostic',
        'agony',
        'agreed',
        'ahead',
        'aided',
        'ailments',
        'aimless',
        'airport',
        'aisle',
        'ajar',
        'akin',
        'alarms',
        'album',
        'alchemy',
        'alerts',
        'algebra',
        'alkaline',
        'alley',
        'almost',
        'aloof',
        'alpine',
        'already',
        'also',
        'altitude',
        'alumni',
        'always',
        'amaze',
        'ambush',
        'amended',
        'amidst',
        'ammo',
        'amnesty',
        'among',
        'amply',
        'amused',
        'anchor',
        'android',
        'anecdote',
        'angled',
        'ankle',
        'annoyed',
        'answers',
        'antics',
        'anvil',
        'anxiety',
        'anybody',
        'apart',
        'apex',
        'aphid',
        'aplomb',
        'apology',
        'apply',
        'apricot',
        'aptitude',
        'aquarium',
        'arbitrary',
        'archer',
        'ardent',
        'arena',
        'argue',
        'arises',
        'army',
        'around',
        'arrow',
        'arsenic',
        'artistic',
        'ascend',
        'ashtray',
        'aside',
        'asked',
        'asleep',
        'aspire',
        'assorted',
        'asylum',
        'athlete',
        'atlas',
        'atom',
        'atrium',
        'attire',
        'auburn',
        'auctions',
        'audio',
        'august',
        'aunt',
        'austere',
        'autumn',
        'avatar',
        'avidly',
        'avoid',
        'awakened',
        'awesome',
        'awful',
        'awkward',
        'awning',
        'awoken',
        'axes',
        'axis',
        'axle',
        'aztec',
        'azure',
        'baby',
        'bacon',
        'badge',
        'baffles',
        'bagpipe',
        'bailed',
        'bakery',
        'balding',
        'bamboo',
        'banjo',
        'baptism',
        'basin',
        'batch',
        'bawled',
        'bays',
        'because',
        'beer',
        'befit',
        'begun',
        'behind',
        'being',
        'below',
        'bemused',
        'benches',
        'berries',
        'bested',
        'betting',
        'bevel',
        'beware',
        'beyond',
        'bias',
        'bicycle',
        'bids',
        'bifocals',
        'biggest',
        'bikini',
        'bimonthly',
        'binocular',
        'biology',
        'biplane',
        'birth',
        'biscuit',
        'bite',
        'biweekly',
        'blender',
        'blip',
        'bluntly',
        'boat',
        'bobsled',
        'bodies',
        'bogeys',
        'boil',
        'boldly',
        'bomb',
        'border',
        'boss',
        'both',
        'bounced',
        'bovine',
        'bowling',
        'boxes',
        'boyfriend',
        'broken',
        'brunt',
        'bubble',
        'buckets',
        'budget',
        'buffet',
        'bugs',
        'building',
        'bulb',
        'bumper',
        'bunch',
        'business',
        'butter',
        'buying',
        'buzzer',
        'bygones',
        'byline',
        'bypass',
        'cabin',
        'cactus',
        'cadets',
        'cafe',
        'cage',
        'cajun',
        'cake',
        'calamity',
        'camp',
        'candy',
        'casket',
        'catch',
        'cause',
        'cavernous',
        'cease',
        'cedar',
        'ceiling',
        'cell',
        'cement',
        'cent',
        'certain',
        'chlorine',
        'chrome',
        'cider',
        'cigar',
        'cinema',
        'circle',
        'cistern',
        'citadel',
        'civilian',
        'claim',
        'click',
        'clue',
        'coal',
        'cobra',
        'cocoa',
        'code',
        'coexist',
        'coffee',
        'cogs',
        'cohesive',
        'coils',
        'colony',
        'comb',
        'cool',
        'copy',
        'corrode',
        'costume',
        'cottage',
        'cousin',
        'cowl',
        'criminal',
        'cube',
        'cucumber',
        'cuddled',
        'cuffs',
        'cuisine',
        'cunning',
        'cupcake',
        'custom',
        'cycling',
        'cylinder',
        'cynical',
        'dabbing',
        'dads',
        'daft',
        'dagger',
        'daily',
        'damp',
        'dangerous',
        'dapper',
        'darted',
        'dash',
        'dating',
        'dauntless',
        'dawn',
        'daytime',
        'dazed',
        'debut',
        'decay',
        'dedicated',
        'deepest',
        'deftly',
        'degrees',
        'dehydrate',
        'deity',
        'dejected',
        'delayed',
        'demonstrate',
        'dented',
        'deodorant',
        'depth',
        'desk',
        'devoid',
        'dewdrop',
        'dexterity',
        'dialect',
        'dice',
        'diet',
        'different',
        'digit',
        'dilute',
        'dime',
        'dinner',
        'diode',
        'diplomat',
        'directed',
        'distance',
        'ditch',
        'divers',
        'dizzy',
        'doctor',
        'dodge',
        'does',
        'dogs',
        'doing',
        'dolphin',
        'domestic',
        'donuts',
        'doorway',
        'dormant',
        'dosage',
        'dotted',
        'double',
        'dove',
        'down',
        'dozen',
        'dreams',
        'drinks',
        'drowning',
        'drunk',
        'drying',
        'dual',
        'dubbed',
        'duckling',
        'dude',
        'duets',
        'duke',
        'dullness',
        'dummy',
        'dunes',
        'duplex',
        'duration',
        'dusted',
        'duties',
        'dwarf',
        'dwelt',
        'dwindling',
        'dying',
        'dynamite',
        'dyslexic',
        'each',
        'eagle',
        'earth',
        'easy',
        'eating',
        'eavesdrop',
        'eccentric',
        'echo',
        'eclipse',
        'economics',
        'ecstatic',
        'eden',
        'edgy',
        'edited',
        'educated',
        'eels',
        'efficient',
        'eggs',
        'egotistic',
        'eight',
        'either',
        'eject',
        'elapse',
        'elbow',
        'eldest',
        'eleven',
        'elite',
        'elope',
        'else',
        'eluded',
        'emails',
        'ember',
        'emerge',
        'emit',
        'emotion',
        'empty',
        'emulate',
        'energy',
        'enforce',
        'enhanced',
        'enigma',
        'enjoy',
        'enlist',
        'enmity',
        'enough',
        'enraged',
        'ensign',
        'entrance',
        'envy',
        'epoxy',
        'equip',
        'erase',
        'erected',
        'erosion',
        'error',
        'eskimos',
        'espionage',
        'essential',
        'estate',
        'etched',
        'eternal',
        'ethics',
        'etiquette',
        'evaluate',
        'evenings',
        'evicted',
        'evolved',
        'examine',
        'excess',
        'exhale',
        'exit',
        'exotic',
        'exquisite',
        'extra',
        'exult',
        'fabrics',
        'factual',
        'fading',
        'fainted',
        'faked',
        'fall',
        'family',
        'fancy',
        'farming',
        'fatal',
        'faulty',
        'fawns',
        'faxed',
        'fazed',
        'feast',
        'february',
        'federal',
        'feel',
        'feline',
        'females',
        'fences',
        'ferry',
        'festival',
        'fetches',
        'fever',
        'fewest',
        'fiat',
        'fibula',
        'fictional',
        'fidget',
        'fierce',
        'fifteen',
        'fight',
        'films',
        'firm',
        'fishing',
        'fitting',
        'five',
        'fixate',
        'fizzle',
        'fleet',
        'flippant',
        'flying',
        'foamy',
        'focus',
        'foes',
        'foggy',
        'foiled',
        'folding',
        'fonts',
        'foolish',
        'fossil',
        'fountain',
        'fowls',
        'foxes',
        'foyer',
        'framed',
        'friendly',
        'frown',
        'fruit',
        'frying',
        'fudge',
        'fuel',
        'fugitive',
        'fully',
        'fuming',
        'fungal',
        'furnished',
        'fuselage',
        'future',
        'fuzzy',
        'gables',
        'gadget',
        'gags',
        'gained',
        'galaxy',
        'gambit',
        'gang',
        'gasp',
        'gather',
        'gauze',
        'gave',
        'gawk',
        'gaze',
        'gearbox',
        'gecko',
        'geek',
        'gels',
        'gemstone',
        'general',
        'geometry',
        'germs',
        'gesture',
        'getting',
        'geyser',
        'ghetto',
        'ghost',
        'giant',
        'giddy',
        'gifts',
        'gigantic',
        'gills',
        'gimmick',
        'ginger',
        'girth',
        'giving',
        'glass',
        'gleeful',
        'glide',
        'gnaw',
        'gnome',
        'goat',
        'goblet',
        'godfather',
        'goes',
        'goggles',
        'going',
        'goldfish',
        'gone',
        'goodbye',
        'gopher',
        'gorilla',
        'gossip',
        'gotten',
        'gourmet',
        'governing',
        'gown',
        'greater',
        'grunt',
        'guarded',
        'guest',
        'guide',
        'gulp',
        'gumball',
        'guru',
        'gusts',
        'gutter',
        'guys',
        'gymnast',
        'gypsy',
        'gyrate',
        'habitat',
        'hacksaw',
        'haggled',
        'hairy',
        'hamburger',
        'happens',
        'hashing',
        'hatchet',
        'haunted',
        'having',
        'hawk',
        'haystack',
        'hazard',
        'hectare',
        'hedgehog',
        'heels',
        'hefty',
        'height',
        'hemlock',
        'hence',
        'heron',
        'hesitate',
        'hexagon',
        'hickory',
        'hiding',
        'highway',
        'hijack',
        'hiker',
        'hills',
        'himself',
        'hinder',
        'hippo',
        'hire',
        'history',
        'hitched',
        'hive',
        'hoax',
        'hobby',
        'hockey',
        'hoisting',
        'hold',
        'honked',
        'hookup',
        'hope',
        'hornet',
        'hospital',
        'hotel',
        'hounded',
        'hover',
        'howls',
        'hubcaps',
        'huddle',
        'huge',
        'hull',
        'humid',
        'hunter',
        'hurried',
        'husband',
        'huts',
        'hybrid',
        'hydrogen',
        'hyper',
        'iceberg',
        'icing',
        'icon',
        'identity',
        'idiom',
        'idled',
        'idols',
        'igloo',
        'ignore',
        'iguana',
        'illness',
        'imagine',
        'imbalance',
        'imitate',
        'impel',
        'inactive',
        'inbound',
        'incur',
        'industrial',
        'inexact',
        'inflamed',
        'ingested',
        'initiate',
        'injury',
        'inkling',
        'inline',
        'inmate',
        'innocent',
        'inorganic',
        'input',
        'inquest',
        'inroads',
        'insult',
        'intended',
        'inundate',
        'invoke',
        'inwardly',
        'ionic',
        'irate',
        'iris',
        'irony',
        'irritate',
        'island',
        'isolated',
        'issued',
        'italics',
        'itches',
        'items',
        'itinerary',
        'itself',
        'ivory',
        'jabbed',
        'jackets',
        'jaded',
        'jagged',
        'jailed',
        'jamming',
        'january',
        'jargon',
        'jaunt',
        'javelin',
        'jaws',
        'jazz',
        'jeans',
        'jeers',
        'jellyfish',
        'jeopardy',
        'jerseys',
        'jester',
        'jetting',
        'jewels',
        'jigsaw',
        'jingle',
        'jittery',
        'jive',
        'jobs',
        'jockey',
        'jogger',
        'joining',
        'joking',
        'jolted',
        'jostle',
        'journal',
        'joyous',
        'jubilee',
        'judge',
        'juggled',
        'juicy',
        'jukebox',
        'july',
        'jump',
        'junk',
        'jury',
        'justice',
        'juvenile',
        'kangaroo',
        'karate',
        'keep',
        'kennel',
        'kept',
        'kernels',
        'kettle',
        'keyboard',
        'kickoff',
        'kidneys',
        'king',
        'kiosk',
        'kisses',
        'kitchens',
        'kiwi',
        'knapsack',
        'knee',
        'knife',
        'knowledge',
        'knuckle',
        'koala',
        'laboratory',
        'ladder',
        'lagoon',
        'lair',
        'lakes',
        'lamb',
        'language',
        'laptop',
        'large',
        'last',
        'later',
        'launching',
        'lava',
        'lawsuit',
        'layout',
        'lazy',
        'lectures',
        'ledge',
        'leech',
        'left',
        'legion',
        'leisure',
        'lemon',
        'lending',
        'leopard',
        'lesson',
        'lettuce',
        'lexicon',
        'liar',
        'library',
        'licks',
        'lids',
        'lied',
        'lifestyle',
        'light',
        'likewise',
        'lilac',
        'limits',
        'linen',
        'lion',
        'lipstick',
        'liquid',
        'listen',
        'lively',
        'loaded',
        'lobster',
        'locker',
        'lodge',
        'lofty',
        'logic',
        'loincloth',
        'long',
        'looking',
        'lopped',
        'lordship',
        'losing',
        'lottery',
        'loudly',
        'love',
        'lower',
        'loyal',
        'lucky',
        'luggage',
        'lukewarm',
        'lullaby',
        'lumber',
        'lunar',
        'lurk',
        'lush',
        'luxury',
        'lymph',
        'lynx',
        'lyrics',
        'macro',
        'madness',
        'magically',
        'mailed',
        'major',
        'makeup',
        'malady',
        'mammal',
        'maps',
        'masterful',
        'match',
        'maul',
        'maverick',
        'maximum',
        'mayor',
        'maze',
        'meant',
        'mechanic',
        'medicate',
        'meeting',
        'megabyte',
        'melting',
        'memoir',
        'menu',
        'merger',
        'mesh',
        'metro',
        'mews',
        'mice',
        'midst',
        'mighty',
        'mime',
        'mirror',
        'misery',
        'mittens',
        'mixture',
        'moat',
        'mobile',
        'mocked',
        'mohawk',
        'moisture',
        'molten',
        'moment',
        'money',
        'moon',
        'mops',
        'morsel',
        'mostly',
        'motherly',
        'mouth',
        'movement',
        'mowing',
        'much',
        'muddy',
        'muffin',
        'mugged',
        'mullet',
        'mumble',
        'mundane',
        'muppet',
        'mural',
        'musical',
        'muzzle',
        'myriad',
        'mystery',
        'myth',
        'nabbing',
        'nagged',
        'nail',
        'names',
        'nanny',
        'napkin',
        'narrate',
        'nasty',
        'natural',
        'nautical',
        'navy',
        'nearby',
        'necklace',
        'needed',
        'negative',
        'neither',
        'neon',
        'nephew',
        'nerves',
        'nestle',
        'network',
        'neutral',
        'never',
        'newt',
        'nexus',
        'nibs',
        'niche',
        'niece',
        'nifty',
        'nightly',
        'nimbly',
        'nineteen',
        'nirvana',
        'nitrogen',
        'nobody',
        'nocturnal',
        'nodes',
        'noises',
        'nomad',
        'noodles',
        'northern',
        'nostril',
        'noted',
        'nouns',
        'novelty',
        'nowhere',
        'nozzle',
        'nuance',
        'nucleus',
        'nudged',
        'nugget',
        'nuisance',
        'null',
        'number',
        'nuns',
        'nurse',
        'nutshell',
        'nylon',
        'oaks',
        'oars',
        'oasis',
        'oatmeal',
        'obedient',
        'object',
        'obliged',
        'obnoxious',
        'observant',
        'obtains',
        'obvious',
        'occur',
        'ocean',
        'october',
        'odds',
        'odometer',
        'offend',
        'often',
        'oilfield',
        'ointment',
        'okay',
        'older',
        'olive',
        'olympics',
        'omega',
        'omission',
        'omnibus',
        'onboard',
        'oncoming',
        'oneself',
        'ongoing',
        'onion',
        'online',
        'onslaught',
        'onto',
        'onward',
        'oozed',
        'opacity',
        'opened',
        'opposite',
        'optical',
        'opus',
        'orange',
        'orbit',
        'orchid',
        'orders',
        'organs',
        'origin',
        'ornament',
        'orphans',
        'oscar',
        'ostrich',
        'otherwise',
        'otter',
        'ouch',
        'ought',
        'ounce',
        'ourselves',
        'oust',
        'outbreak',
        'oval',
        'oven',
        'owed',
        'owls',
        'owner',
        'oxidant',
        'oxygen',
        'oyster',
        'ozone',
        'pact',
        'paddles',
        'pager',
        'pairing',
        'palace',
        'pamphlet',
        'pancakes',
        'paper',
        'paradise',
        'pastry',
        'patio',
        'pause',
        'pavements',
        'pawnshop',
        'payment',
        'peaches',
        'pebbles',
        'peculiar',
        'pedantic',
        'peeled',
        'pegs',
        'pelican',
        'pencil',
        'people',
        'pepper',
        'perfect',
        'pests',
        'petals',
        'phase',
        'pheasants',
        'phone',
        'phrases',
        'physics',
        'piano',
        'picked',
        'pierce',
        'pigment',
        'piloted',
        'pimple',
        'pinched',
        'pioneer',
        'pipeline',
        'pirate',
        'pistons',
        'pitched',
        'pivot',
        'pixels',
        'pizza',
        'playful',
        'pledge',
        'pliers',
        'plotting',
        'plus',
        'plywood',
        'poaching',
        'pockets',
        'podcast',
        'poetry',
        'point',
        'poker',
        'polar',
        'ponies',
        'pool',
        'popular',
        'portents',
        'possible',
        'potato',
        'pouch',
        'poverty',
        'powder',
        'pram',
        'present',
        'pride',
        'problems',
        'pruned',
        'prying',
        'psychic',
        'public',
        'puck',
        'puddle',
        'puffin',
        'pulp',
        'pumpkins',
        'punch',
        'puppy',
        'purged',
        'push',
        'putty',
        'puzzled',
        'pylons',
        'pyramid',
        'python',
        'queen',
        'quick',
        'quote',
        'rabbits',
        'racetrack',
        'radar',
        'rafts',
        'rage',
        'railway',
        'raking',
        'rally',
        'ramped',
        'randomly',
        'rapid',
        'rarest',
        'rash',
        'rated',
        'ravine',
        'rays',
        'razor',
        'react',
        'rebel',
        'recipe',
        'reduce',
        'reef',
        'refer',
        'regular',
        'reheat',
        'reinvest',
        'rejoices',
        'rekindle',
        'relic',
        'remedy',
        'renting',
        'reorder',
        'repent',
        'request',
        'reruns',
        'rest',
        'return',
        'reunion',
        'revamp',
        'rewind',
        'rhino',
        'rhythm',
        'ribbon',
        'richly',
        'ridges',
        'rift',
        'rigid',
        'rims',
        'ringing',
        'riots',
        'ripped',
        'rising',
        'ritual',
        'river',
        'roared',
        'robot',
        'rockets',
        'rodent',
        'rogue',
        'roles',
        'romance',
        'roomy',
        'roped',
        'roster',
        'rotate',
        'rounded',
        'rover',
        'rowboat',
        'royal',
        'ruby',
        'rudely',
        'ruffled',
        'rugged',
        'ruined',
        'ruling',
        'rumble',
        'runway',
        'rural',
        'rustled',
        'ruthless',
        'sabotage',
        'sack',
        'sadness',
        'safety',
        'saga',
        'sailor',
        'sake',
        'salads',
        'sample',
        'sanity',
        'sapling',
        'sarcasm',
        'sash',
        'satin',
        'saucepan',
        'saved',
        'sawmill',
        'saxophone',
        'sayings',
        'scamper',
        'scenic',
        'school',
        'science',
        'scoop',
        'scrub',
        'scuba',
        'seasons',
        'second',
        'sedan',
        'seeded',
        'segments',
        'seismic',
        'selfish',
        'semifinal',
        'sensible',
        'september',
        'sequence',
        'serving',
        'session',
        'setup',
        'seventh',
        'sewage',
        'shackles',
        'shelter',
        'shipped',
        'shocking',
        'shrugged',
        'shuffled',
        'shyness',
        'siblings',
        'sickness',
        'sidekick',
        'sieve',
        'sifting',
        'sighting',
        'silk',
        'simplest',
        'sincerely',
        'sipped',
        'siren',
        'situated',
        'sixteen',
        'sizes',
        'skater',
        'skew',
        'skirting',
        'skulls',
        'skydive',
        'slackens',
        'sleepless',
        'slid',
        'slower',
        'slug',
        'smash',
        'smelting',
        'smidgen',
        'smog',
        'smuggled',
        'snake',
        'sneeze',
        'sniff',
        'snout',
        'snug',
        'soapy',
        'sober',
        'soccer',
        'soda',
        'software',
        'soggy',
        'soil',
        'solved',
        'somewhere',
        'sonic',
        'soothe',
        'soprano',
        'sorry',
        'southern',
        'sovereign',
        'sowed',
        'soya',
        'space',
        'speedy',
        'sphere',
        'spiders',
        'splendid',
        'spout',
        'sprig',
        'spud',
        'spying',
        'square',
        'stacking',
        'stellar',
        'stick',
        'stockpile',
        'strained',
        'stunning',
        'stylishly',
        'subtly',
        'succeed',
        'suddenly',
        'suede',
        'suffice',
        'sugar',
        'suitcase',
        'sulking',
        'summon',
        'sunken',
        'superior',
        'surfer',
        'sushi',
        'suture',
        'swagger',
        'swept',
        'swiftly',
        'sword',
        'swung',
        'syllabus',
        'symptoms',
        'syndrome',
        'syringe',
        'system',
        'taboo',
        'tacit',
        'tadpoles',
        'tagged',
        'tail',
        'taken',
        'talent',
        'tamper',
        'tanks',
        'tapestry',
        'tarnished',
        'tasked',
        'tattoo',
        'taunts',
        'tavern',
        'tawny',
        'taxi',
        'teardrop',
        'technical',
        'tedious',
        'teeming',
        'tell',
        'template',
        'tender',
        'tepid',
        'tequila',
        'terminal',
        'testing',
        'tether',
        'textbook',
        'thaw',
        'theatrics',
        'thirsty',
        'thorn',
        'threaten',
        'thumbs',
        'thwart',
        'ticket',
        'tidy',
        'tiers',
        'tiger',
        'tilt',
        'timber',
        'tinted',
        'tipsy',
        'tirade',
        'tissue',
        'titans',
        'toaster',
        'tobacco',
        'today',
        'toenail',
        'toffee',
        'together',
        'toilet',
        'token',
        'tolerant',
        'tomorrow',
        'tonic',
        'toolbox',
        'topic',
        'torch',
        'tossed',
        'total',
        'touchy',
        'towel',
        'toxic',
        'toyed',
        'trash',
        'trendy',
        'tribal',
        'trolling',
        'truth',
        'trying',
        'tsunami',
        'tubes',
        'tucks',
        'tudor',
        'tuesday',
        'tufts',
        'tugs',
        'tuition',
        'tulips',
        'tumbling',
        'tunnel',
        'turnip',
        'tusks',
        'tutor',
        'tuxedo',
        'twang',
        'tweezers',
        'twice',
        'twofold',
        'tycoon',
        'typist',
        'tyrant',
        'ugly',
        'ulcers',
        'ultimate',
        'umbrella',
        'umpire',
        'unafraid',
        'unbending',
        'uncle',
        'under',
        'uneven',
        'unfit',
        'ungainly',
        'unhappy',
        'union',
        'unjustly',
        'unknown',
        'unlikely',
        'unmask',
        'unnoticed',
        'unopened',
        'unplugs',
        'unquoted',
        'unrest',
        'unsafe',
        'until',
        'unusual',
        'unveil',
        'unwind',
        'unzip',
        'upbeat',
        'upcoming',
        'update',
        'upgrade',
        'uphill',
        'upkeep',
        'upload',
        'upon',
        'upper',
        'upright',
        'upstairs',
        'uptight',
        'upwards',
        'urban',
        'urchins',
        'urgent',
        'usage',
        'useful',
        'usher',
        'using',
        'usual',
        'utensils',
        'utility',
        'utmost',
        'utopia',
        'uttered',
        'vacation',
        'vague',
        'vain',
        'value',
        'vampire',
        'vane',
        'vapidly',
        'vary',
        'vastness',
        'vats',
        'vaults',
        'vector',
        'veered',
        'vegan',
        'vehicle',
        'vein',
        'velvet',
        'venomous',
        'verification',
        'vessel',
        'veteran',
        'vexed',
        'vials',
        'vibrate',
        'victim',
        'video',
        'viewpoint',
        'vigilant',
        'viking',
        'village',
        'vinegar',
        'violin',
        'vipers',
        'virtual',
        'visited',
        'vitals',
        'vivid',
        'vixen',
        'vocal',
        'vogue',
        'voice',
        'volcano',
        'vortex',
        'voted',
        'voucher',
        'vowels',
        'voyage',
        'vulture',
        'wade',
        'waffle',
        'wagtail',
        'waist',
        'waking',
        'wallets',
        'wanted',
        'warped',
        'washing',
        'water',
        'waveform',
        'waxing',
        'wayside',
        'weavers',
        'website',
        'wedge',
        'weekday',
        'weird',
        'welders',
        'went',
        'wept',
        'were',
        'western',
        'wetsuit',
        'whale',
        'when',
        'whipped',
        'whole',
        'wickets',
        'width',
        'wield',
        'wife',
        'wiggle',
        'wildly',
        'winter',
        'wipeout',
        'wiring',
        'wise',
        'withdrawn',
        'wives',
        'wizard',
        'wobbly',
        'woes',
        'woken',
        'wolf',
        'womanly',
        'wonders',
        'woozy',
        'worry',
        'wounded',
        'woven',
        'wrap',
        'wrist',
        'wrong',
        'yacht',
        'yahoo',
        'yanks',
        'yard',
        'yawning',
        'yearbook',
        'yellow',
        'yesterday',
        'yeti',
        'yields',
        'yodel',
        'yoga',
        'younger',
        'yoyo',
        'zapped',
        'zeal',
        'zebra',
        'zero',
        'zesty',
        'zigzags',
        'zinger',
        'zippers',
        'zodiac',
        'zombie',
        'zones',
        'zoom',
      ])
    );
    langs.push(
      new MnemonicLang('spanish', 'es', 4, [
        'ábaco',
        'abdomen',
        'abeja',
        'abierto',
        'abogado',
        'abono',
        'aborto',
        'abrazo',
        'abrir',
        'abuelo',
        'abuso',
        'acabar',
        'academia',
        'acceso',
        'acción',
        'aceite',
        'acelga',
        'acento',
        'aceptar',
        'ácido',
        'aclarar',
        'acné',
        'acoger',
        'acoso',
        'activo',
        'acto',
        'actriz',
        'actuar',
        'acudir',
        'acuerdo',
        'acusar',
        'adicto',
        'admitir',
        'adoptar',
        'adorno',
        'aduana',
        'adulto',
        'aéreo',
        'afectar',
        'afición',
        'afinar',
        'afirmar',
        'ágil',
        'agitar',
        'agonía',
        'agosto',
        'agotar',
        'agregar',
        'agrio',
        'agua',
        'agudo',
        'águila',
        'aguja',
        'ahogo',
        'ahorro',
        'aire',
        'aislar',
        'ajedrez',
        'ajeno',
        'ajuste',
        'alacrán',
        'alambre',
        'alarma',
        'alba',
        'álbum',
        'alcalde',
        'aldea',
        'alegre',
        'alejar',
        'alerta',
        'aleta',
        'alfiler',
        'alga',
        'algodón',
        'aliado',
        'aliento',
        'alivio',
        'alma',
        'almeja',
        'almíbar',
        'altar',
        'alteza',
        'altivo',
        'alto',
        'altura',
        'alumno',
        'alzar',
        'amable',
        'amante',
        'amapola',
        'amargo',
        'amasar',
        'ámbar',
        'ámbito',
        'ameno',
        'amigo',
        'amistad',
        'amor',
        'amparo',
        'amplio',
        'ancho',
        'anciano',
        'ancla',
        'andar',
        'andén',
        'anemia',
        'ángulo',
        'anillo',
        'ánimo',
        'anís',
        'anotar',
        'antena',
        'antiguo',
        'antojo',
        'anual',
        'anular',
        'anuncio',
        'añadir',
        'añejo',
        'año',
        'apagar',
        'aparato',
        'apetito',
        'apio',
        'aplicar',
        'apodo',
        'aporte',
        'apoyo',
        'aprender',
        'aprobar',
        'apuesta',
        'apuro',
        'arado',
        'araña',
        'arar',
        'árbitro',
        'árbol',
        'arbusto',
        'archivo',
        'arco',
        'arder',
        'ardilla',
        'arduo',
        'área',
        'árido',
        'aries',
        'armonía',
        'arnés',
        'aroma',
        'arpa',
        'arpón',
        'arreglo',
        'arroz',
        'arruga',
        'arte',
        'artista',
        'asa',
        'asado',
        'asalto',
        'ascenso',
        'asegurar',
        'aseo',
        'asesor',
        'asiento',
        'asilo',
        'asistir',
        'asno',
        'asombro',
        'áspero',
        'astilla',
        'astro',
        'astuto',
        'asumir',
        'asunto',
        'atajo',
        'ataque',
        'atar',
        'atento',
        'ateo',
        'ático',
        'atleta',
        'átomo',
        'atraer',
        'atroz',
        'atún',
        'audaz',
        'audio',
        'auge',
        'aula',
        'aumento',
        'ausente',
        'autor',
        'aval',
        'avance',
        'avaro',
        'ave',
        'avellana',
        'avena',
        'avestruz',
        'avión',
        'aviso',
        'ayer',
        'ayuda',
        'ayuno',
        'azafrán',
        'azar',
        'azote',
        'azúcar',
        'azufre',
        'azul',
        'baba',
        'babor',
        'bache',
        'bahía',
        'baile',
        'bajar',
        'balanza',
        'balcón',
        'balde',
        'bambú',
        'banco',
        'banda',
        'baño',
        'barba',
        'barco',
        'barniz',
        'barro',
        'báscula',
        'bastón',
        'basura',
        'batalla',
        'batería',
        'batir',
        'batuta',
        'baúl',
        'bazar',
        'bebé',
        'bebida',
        'bello',
        'besar',
        'beso',
        'bestia',
        'bicho',
        'bien',
        'bingo',
        'blanco',
        'bloque',
        'blusa',
        'boa',
        'bobina',
        'bobo',
        'boca',
        'bocina',
        'boda',
        'bodega',
        'boina',
        'bola',
        'bolero',
        'bolsa',
        'bomba',
        'bondad',
        'bonito',
        'bono',
        'bonsái',
        'borde',
        'borrar',
        'bosque',
        'bote',
        'botín',
        'bóveda',
        'bozal',
        'bravo',
        'brazo',
        'brecha',
        'breve',
        'brillo',
        'brinco',
        'brisa',
        'broca',
        'broma',
        'bronce',
        'brote',
        'bruja',
        'brusco',
        'bruto',
        'buceo',
        'bucle',
        'bueno',
        'buey',
        'bufanda',
        'bufón',
        'búho',
        'buitre',
        'bulto',
        'burbuja',
        'burla',
        'burro',
        'buscar',
        'butaca',
        'buzón',
        'caballo',
        'cabeza',
        'cabina',
        'cabra',
        'cacao',
        'cadáver',
        'cadena',
        'caer',
        'café',
        'caída',
        'caimán',
        'caja',
        'cajón',
        'cal',
        'calamar',
        'calcio',
        'caldo',
        'calidad',
        'calle',
        'calma',
        'calor',
        'calvo',
        'cama',
        'cambio',
        'camello',
        'camino',
        'campo',
        'cáncer',
        'candil',
        'canela',
        'canguro',
        'canica',
        'canto',
        'caña',
        'cañón',
        'caoba',
        'caos',
        'capaz',
        'capitán',
        'capote',
        'captar',
        'capucha',
        'cara',
        'carbón',
        'cárcel',
        'careta',
        'carga',
        'cariño',
        'carne',
        'carpeta',
        'carro',
        'carta',
        'casa',
        'casco',
        'casero',
        'caspa',
        'castor',
        'catorce',
        'catre',
        'caudal',
        'causa',
        'cazo',
        'cebolla',
        'ceder',
        'cedro',
        'celda',
        'célebre',
        'celoso',
        'célula',
        'cemento',
        'ceniza',
        'centro',
        'cerca',
        'cerdo',
        'cereza',
        'cero',
        'cerrar',
        'certeza',
        'césped',
        'cetro',
        'chacal',
        'chaleco',
        'champú',
        'chancla',
        'chapa',
        'charla',
        'chico',
        'chiste',
        'chivo',
        'choque',
        'choza',
        'chuleta',
        'chupar',
        'ciclón',
        'ciego',
        'cielo',
        'cien',
        'cierto',
        'cifra',
        'cigarro',
        'cima',
        'cinco',
        'cine',
        'cinta',
        'ciprés',
        'circo',
        'ciruela',
        'cisne',
        'cita',
        'ciudad',
        'clamor',
        'clan',
        'claro',
        'clase',
        'clave',
        'cliente',
        'clima',
        'clínica',
        'cobre',
        'cocción',
        'cochino',
        'cocina',
        'coco',
        'código',
        'codo',
        'cofre',
        'coger',
        'cohete',
        'cojín',
        'cojo',
        'cola',
        'colcha',
        'colegio',
        'colgar',
        'colina',
        'collar',
        'colmo',
        'columna',
        'combate',
        'comer',
        'comida',
        'cómodo',
        'compra',
        'conde',
        'conejo',
        'conga',
        'conocer',
        'consejo',
        'contar',
        'copa',
        'copia',
        'corazón',
        'corbata',
        'corcho',
        'cordón',
        'corona',
        'correr',
        'coser',
        'cosmos',
        'costa',
        'cráneo',
        'cráter',
        'crear',
        'crecer',
        'creído',
        'crema',
        'cría',
        'crimen',
        'cripta',
        'crisis',
        'cromo',
        'crónica',
        'croqueta',
        'crudo',
        'cruz',
        'cuadro',
        'cuarto',
        'cuatro',
        'cubo',
        'cubrir',
        'cuchara',
        'cuello',
        'cuento',
        'cuerda',
        'cuesta',
        'cueva',
        'cuidar',
        'culebra',
        'culpa',
        'culto',
        'cumbre',
        'cumplir',
        'cuna',
        'cuneta',
        'cuota',
        'cupón',
        'cúpula',
        'curar',
        'curioso',
        'curso',
        'curva',
        'cutis',
        'dama',
        'danza',
        'dar',
        'dardo',
        'dátil',
        'deber',
        'débil',
        'década',
        'decir',
        'dedo',
        'defensa',
        'definir',
        'dejar',
        'delfín',
        'delgado',
        'delito',
        'demora',
        'denso',
        'dental',
        'deporte',
        'derecho',
        'derrota',
        'desayuno',
        'deseo',
        'desfile',
        'desnudo',
        'destino',
        'desvío',
        'detalle',
        'detener',
        'deuda',
        'día',
        'diablo',
        'diadema',
        'diamante',
        'diana',
        'diario',
        'dibujo',
        'dictar',
        'diente',
        'dieta',
        'diez',
        'difícil',
        'digno',
        'dilema',
        'diluir',
        'dinero',
        'directo',
        'dirigir',
        'disco',
        'diseño',
        'disfraz',
        'diva',
        'divino',
        'doble',
        'doce',
        'dolor',
        'domingo',
        'don',
        'donar',
        'dorado',
        'dormir',
        'dorso',
        'dos',
        'dosis',
        'dragón',
        'droga',
        'ducha',
        'duda',
        'duelo',
        'dueño',
        'dulce',
        'dúo',
        'duque',
        'durar',
        'dureza',
        'duro',
        'ébano',
        'ebrio',
        'echar',
        'eco',
        'ecuador',
        'edad',
        'edición',
        'edificio',
        'editor',
        'educar',
        'efecto',
        'eficaz',
        'eje',
        'ejemplo',
        'elefante',
        'elegir',
        'elemento',
        'elevar',
        'elipse',
        'élite',
        'elixir',
        'elogio',
        'eludir',
        'embudo',
        'emitir',
        'emoción',
        'empate',
        'empeño',
        'empleo',
        'empresa',
        'enano',
        'encargo',
        'enchufe',
        'encía',
        'enemigo',
        'enero',
        'enfado',
        'enfermo',
        'engaño',
        'enigma',
        'enlace',
        'enorme',
        'enredo',
        'ensayo',
        'enseñar',
        'entero',
        'entrar',
        'envase',
        'envío',
        'época',
        'equipo',
        'erizo',
        'escala',
        'escena',
        'escolar',
        'escribir',
        'escudo',
        'esencia',
        'esfera',
        'esfuerzo',
        'espada',
        'espejo',
        'espía',
        'esposa',
        'espuma',
        'esquí',
        'estar',
        'este',
        'estilo',
        'estufa',
        'etapa',
        'eterno',
        'ética',
        'etnia',
        'evadir',
        'evaluar',
        'evento',
        'evitar',
        'exacto',
        'examen',
        'exceso',
        'excusa',
        'exento',
        'exigir',
        'exilio',
        'existir',
        'éxito',
        'experto',
        'explicar',
        'exponer',
        'extremo',
        'fábrica',
        'fábula',
        'fachada',
        'fácil',
        'factor',
        'faena',
        'faja',
        'falda',
        'fallo',
        'falso',
        'faltar',
        'fama',
        'familia',
        'famoso',
        'faraón',
        'farmacia',
        'farol',
        'farsa',
        'fase',
        'fatiga',
        'fauna',
        'favor',
        'fax',
        'febrero',
        'fecha',
        'feliz',
        'feo',
        'feria',
        'feroz',
        'fértil',
        'fervor',
        'festín',
        'fiable',
        'fianza',
        'fiar',
        'fibra',
        'ficción',
        'ficha',
        'fideo',
        'fiebre',
        'fiel',
        'fiera',
        'fiesta',
        'figura',
        'fijar',
        'fijo',
        'fila',
        'filete',
        'filial',
        'filtro',
        'fin',
        'finca',
        'fingir',
        'finito',
        'firma',
        'flaco',
        'flauta',
        'flecha',
        'flor',
        'flota',
        'fluir',
        'flujo',
        'flúor',
        'fobia',
        'foca',
        'fogata',
        'fogón',
        'folio',
        'folleto',
        'fondo',
        'forma',
        'forro',
        'fortuna',
        'forzar',
        'fosa',
        'foto',
        'fracaso',
        'frágil',
        'franja',
        'frase',
        'fraude',
        'freír',
        'freno',
        'fresa',
        'frío',
        'frito',
        'fruta',
        'fuego',
        'fuente',
        'fuerza',
        'fuga',
        'fumar',
        'función',
        'funda',
        'furgón',
        'furia',
        'fusil',
        'fútbol',
        'futuro',
        'gacela',
        'gafas',
        'gaita',
        'gajo',
        'gala',
        'galería',
        'gallo',
        'gamba',
        'ganar',
        'gancho',
        'ganga',
        'ganso',
        'garaje',
        'garza',
        'gasolina',
        'gastar',
        'gato',
        'gavilán',
        'gemelo',
        'gemir',
        'gen',
        'género',
        'genio',
        'gente',
        'geranio',
        'gerente',
        'germen',
        'gesto',
        'gigante',
        'gimnasio',
        'girar',
        'giro',
        'glaciar',
        'globo',
        'gloria',
        'gol',
        'golfo',
        'goloso',
        'golpe',
        'goma',
        'gordo',
        'gorila',
        'gorra',
        'gota',
        'goteo',
        'gozar',
        'grada',
        'gráfico',
        'grano',
        'grasa',
        'gratis',
        'grave',
        'grieta',
        'grillo',
        'gripe',
        'gris',
        'grito',
        'grosor',
        'grúa',
        'grueso',
        'grumo',
        'grupo',
        'guante',
        'guapo',
        'guardia',
        'guerra',
        'guía',
        'guiño',
        'guion',
        'guiso',
        'guitarra',
        'gusano',
        'gustar',
        'haber',
        'hábil',
        'hablar',
        'hacer',
        'hacha',
        'hada',
        'hallar',
        'hamaca',
        'harina',
        'haz',
        'hazaña',
        'hebilla',
        'hebra',
        'hecho',
        'helado',
        'helio',
        'hembra',
        'herir',
        'hermano',
        'héroe',
        'hervir',
        'hielo',
        'hierro',
        'hígado',
        'higiene',
        'hijo',
        'himno',
        'historia',
        'hocico',
        'hogar',
        'hoguera',
        'hoja',
        'hombre',
        'hongo',
        'honor',
        'honra',
        'hora',
        'hormiga',
        'horno',
        'hostil',
        'hoyo',
        'hueco',
        'huelga',
        'huerta',
        'hueso',
        'huevo',
        'huida',
        'huir',
        'humano',
        'húmedo',
        'humilde',
        'humo',
        'hundir',
        'huracán',
        'hurto',
        'icono',
        'ideal',
        'idioma',
        'ídolo',
        'iglesia',
        'iglú',
        'igual',
        'ilegal',
        'ilusión',
        'imagen',
        'imán',
        'imitar',
        'impar',
        'imperio',
        'imponer',
        'impulso',
        'incapaz',
        'índice',
        'inerte',
        'infiel',
        'informe',
        'ingenio',
        'inicio',
        'inmenso',
        'inmune',
        'innato',
        'insecto',
        'instante',
        'interés',
        'íntimo',
        'intuir',
        'inútil',
        'invierno',
        'ira',
        'iris',
        'ironía',
        'isla',
        'islote',
        'jabalí',
        'jabón',
        'jamón',
        'jarabe',
        'jardín',
        'jarra',
        'jaula',
        'jazmín',
        'jefe',
        'jeringa',
        'jinete',
        'jornada',
        'joroba',
        'joven',
        'joya',
        'juerga',
        'jueves',
        'juez',
        'jugador',
        'jugo',
        'juguete',
        'juicio',
        'junco',
        'jungla',
        'junio',
        'juntar',
        'júpiter',
        'jurar',
        'justo',
        'juvenil',
        'juzgar',
        'kilo',
        'koala',
        'labio',
        'lacio',
        'lacra',
        'lado',
        'ladrón',
        'lagarto',
        'lágrima',
        'laguna',
        'laico',
        'lamer',
        'lámina',
        'lámpara',
        'lana',
        'lancha',
        'langosta',
        'lanza',
        'lápiz',
        'largo',
        'larva',
        'lástima',
        'lata',
        'látex',
        'latir',
        'laurel',
        'lavar',
        'lazo',
        'leal',
        'lección',
        'leche',
        'lector',
        'leer',
        'legión',
        'legumbre',
        'lejano',
        'lengua',
        'lento',
        'leña',
        'león',
        'leopardo',
        'lesión',
        'letal',
        'letra',
        'leve',
        'leyenda',
        'libertad',
        'libro',
        'licor',
        'líder',
        'lidiar',
        'lienzo',
        'liga',
        'ligero',
        'lima',
        'límite',
        'limón',
        'limpio',
        'lince',
        'lindo',
        'línea',
        'lingote',
        'lino',
        'linterna',
        'líquido',
        'liso',
        'lista',
        'litera',
        'litio',
        'litro',
        'llaga',
        'llama',
        'llanto',
        'llave',
        'llegar',
        'llenar',
        'llevar',
        'llorar',
        'llover',
        'lluvia',
        'lobo',
        'loción',
        'loco',
        'locura',
        'lógica',
        'logro',
        'lombriz',
        'lomo',
        'lonja',
        'lote',
        'lucha',
        'lucir',
        'lugar',
        'lujo',
        'luna',
        'lunes',
        'lupa',
        'lustro',
        'luto',
        'luz',
        'maceta',
        'macho',
        'madera',
        'madre',
        'maduro',
        'maestro',
        'mafia',
        'magia',
        'mago',
        'maíz',
        'maldad',
        'maleta',
        'malla',
        'malo',
        'mamá',
        'mambo',
        'mamut',
        'manco',
        'mando',
        'manejar',
        'manga',
        'maniquí',
        'manjar',
        'mano',
        'manso',
        'manta',
        'mañana',
        'mapa',
        'máquina',
        'mar',
        'marco',
        'marea',
        'marfil',
        'margen',
        'marido',
        'mármol',
        'marrón',
        'martes',
        'marzo',
        'masa',
        'máscara',
        'masivo',
        'matar',
        'materia',
        'matiz',
        'matriz',
        'máximo',
        'mayor',
        'mazorca',
        'mecha',
        'medalla',
        'medio',
        'médula',
        'mejilla',
        'mejor',
        'melena',
        'melón',
        'memoria',
        'menor',
        'mensaje',
        'mente',
        'menú',
        'mercado',
        'merengue',
        'mérito',
        'mes',
        'mesón',
        'meta',
        'meter',
        'método',
        'metro',
        'mezcla',
        'miedo',
        'miel',
        'miembro',
        'miga',
        'mil',
        'milagro',
        'militar',
        'millón',
        'mimo',
        'mina',
        'minero',
        'mínimo',
        'minuto',
        'miope',
        'mirar',
        'misa',
        'miseria',
        'misil',
        'mismo',
        'mitad',
        'mito',
        'mochila',
        'moción',
        'moda',
        'modelo',
        'moho',
        'mojar',
        'molde',
        'moler',
        'molino',
        'momento',
        'momia',
        'monarca',
        'moneda',
        'monja',
        'monto',
        'moño',
        'morada',
        'morder',
        'moreno',
        'morir',
        'morro',
        'morsa',
        'mortal',
        'mosca',
        'mostrar',
        'motivo',
        'mover',
        'móvil',
        'mozo',
        'mucho',
        'mudar',
        'mueble',
        'muela',
        'muerte',
        'muestra',
        'mugre',
        'mujer',
        'mula',
        'muleta',
        'multa',
        'mundo',
        'muñeca',
        'mural',
        'muro',
        'músculo',
        'museo',
        'musgo',
        'música',
        'muslo',
        'nácar',
        'nación',
        'nadar',
        'naipe',
        'naranja',
        'nariz',
        'narrar',
        'nasal',
        'natal',
        'nativo',
        'natural',
        'náusea',
        'naval',
        'nave',
        'navidad',
        'necio',
        'néctar',
        'negar',
        'negocio',
        'negro',
        'neón',
        'nervio',
        'neto',
        'neutro',
        'nevar',
        'nevera',
        'nicho',
        'nido',
        'niebla',
        'nieto',
        'niñez',
        'niño',
        'nítido',
        'nivel',
        'nobleza',
        'noche',
        'nómina',
        'noria',
        'norma',
        'norte',
        'nota',
        'noticia',
        'novato',
        'novela',
        'novio',
        'nube',
        'nuca',
        'núcleo',
        'nudillo',
        'nudo',
        'nuera',
        'nueve',
        'nuez',
        'nulo',
        'número',
        'nutria',
        'oasis',
        'obeso',
        'obispo',
        'objeto',
        'obra',
        'obrero',
        'observar',
        'obtener',
        'obvio',
        'oca',
        'ocaso',
        'océano',
        'ochenta',
        'ocho',
        'ocio',
        'ocre',
        'octavo',
        'octubre',
        'oculto',
        'ocupar',
        'ocurrir',
        'odiar',
        'odio',
        'odisea',
        'oeste',
        'ofensa',
        'oferta',
        'oficio',
        'ofrecer',
        'ogro',
        'oído',
        'oír',
        'ojo',
        'ola',
        'oleada',
        'olfato',
        'olivo',
        'olla',
        'olmo',
        'olor',
        'olvido',
        'ombligo',
        'onda',
        'onza',
        'opaco',
        'opción',
        'ópera',
        'opinar',
        'oponer',
        'optar',
        'óptica',
        'opuesto',
        'oración',
        'orador',
        'oral',
        'órbita',
        'orca',
        'orden',
        'oreja',
        'órgano',
        'orgía',
        'orgullo',
        'oriente',
        'origen',
        'orilla',
        'oro',
        'orquesta',
        'oruga',
        'osadía',
        'oscuro',
        'osezno',
        'oso',
        'ostra',
        'otoño',
        'otro',
        'oveja',
        'óvulo',
        'óxido',
        'oxígeno',
        'oyente',
        'ozono',
        'pacto',
        'padre',
        'paella',
        'página',
        'pago',
        'país',
        'pájaro',
        'palabra',
        'palco',
        'paleta',
        'pálido',
        'palma',
        'paloma',
        'palpar',
        'pan',
        'panal',
        'pánico',
        'pantera',
        'pañuelo',
        'papá',
        'papel',
        'papilla',
        'paquete',
        'parar',
        'parcela',
        'pared',
        'parir',
        'paro',
        'párpado',
        'parque',
        'párrafo',
        'parte',
        'pasar',
        'paseo',
        'pasión',
        'paso',
        'pasta',
        'pata',
        'patio',
        'patria',
        'pausa',
        'pauta',
        'pavo',
        'payaso',
        'peatón',
        'pecado',
        'pecera',
        'pecho',
        'pedal',
        'pedir',
        'pegar',
        'peine',
        'pelar',
        'peldaño',
        'pelea',
        'peligro',
        'pellejo',
        'pelo',
        'peluca',
        'pena',
        'pensar',
        'peñón',
        'peón',
        'peor',
        'pepino',
        'pequeño',
        'pera',
        'percha',
        'perder',
        'pereza',
        'perfil',
        'perico',
        'perla',
        'permiso',
        'perro',
        'persona',
        'pesa',
        'pesca',
        'pésimo',
        'pestaña',
        'pétalo',
        'petróleo',
        'pez',
        'pezuña',
        'picar',
        'pichón',
        'pie',
        'piedra',
        'pierna',
        'pieza',
        'pijama',
        'pilar',
        'piloto',
        'pimienta',
        'pino',
        'pintor',
        'pinza',
        'piña',
        'piojo',
        'pipa',
        'pirata',
        'pisar',
        'piscina',
        'piso',
        'pista',
        'pitón',
        'pizca',
        'placa',
        'plan',
        'plata',
        'playa',
        'plaza',
        'pleito',
        'pleno',
        'plomo',
        'pluma',
        'plural',
        'pobre',
        'poco',
        'poder',
        'podio',
        'poema',
        'poesía',
        'poeta',
        'polen',
        'policía',
        'pollo',
        'polvo',
        'pomada',
        'pomelo',
        'pomo',
        'pompa',
        'poner',
        'porción',
        'portal',
        'posada',
        'poseer',
        'posible',
        'poste',
        'potencia',
        'potro',
        'pozo',
        'prado',
        'precoz',
        'pregunta',
        'premio',
        'prensa',
        'preso',
        'previo',
        'primo',
        'príncipe',
        'prisión',
        'privar',
        'proa',
        'probar',
        'proceso',
        'producto',
        'proeza',
        'profesor',
        'programa',
        'prole',
        'promesa',
        'pronto',
        'propio',
        'próximo',
        'prueba',
        'público',
        'puchero',
        'pudor',
        'pueblo',
        'puerta',
        'puesto',
        'pulga',
        'pulir',
        'pulmón',
        'pulpo',
        'pulso',
        'puma',
        'punto',
        'puñal',
        'puño',
        'pupa',
        'pupila',
        'puré',
        'quedar',
        'queja',
        'quemar',
        'querer',
        'queso',
        'quieto',
        'química',
        'quince',
        'quitar',
        'rábano',
        'rabia',
        'rabo',
        'ración',
        'radical',
        'raíz',
        'rama',
        'rampa',
        'rancho',
        'rango',
        'rapaz',
        'rápido',
        'rapto',
        'rasgo',
        'raspa',
        'rato',
        'rayo',
        'raza',
        'razón',
        'reacción',
        'realidad',
        'rebaño',
        'rebote',
        'recaer',
        'receta',
        'rechazo',
        'recoger',
        'recreo',
        'recto',
        'recurso',
        'red',
        'redondo',
        'reducir',
        'reflejo',
        'reforma',
        'refrán',
        'refugio',
        'regalo',
        'regir',
        'regla',
        'regreso',
        'rehén',
        'reino',
        'reír',
        'reja',
        'relato',
        'relevo',
        'relieve',
        'relleno',
        'reloj',
        'remar',
        'remedio',
        'remo',
        'rencor',
        'rendir',
        'renta',
        'reparto',
        'repetir',
        'reposo',
        'reptil',
        'res',
        'rescate',
        'resina',
        'respeto',
        'resto',
        'resumen',
        'retiro',
        'retorno',
        'retrato',
        'reunir',
        'revés',
        'revista',
        'rey',
        'rezar',
        'rico',
        'riego',
        'rienda',
        'riesgo',
        'rifa',
        'rígido',
        'rigor',
        'rincón',
        'riñón',
        'río',
        'riqueza',
        'risa',
        'ritmo',
        'rito',
      ])
    );
    langs.push(
      new MnemonicLang('portuguese', 'pt', 3, [
        'abaular',
        'abdominal',
        'abeto',
        'abissinio',
        'abjeto',
        'ablucao',
        'abnegar',
        'abotoar',
        'abrutalhar',
        'absurdo',
        'abutre',
        'acautelar',
        'accessorios',
        'acetona',
        'achocolatado',
        'acirrar',
        'acne',
        'acovardar',
        'acrostico',
        'actinomicete',
        'acustico',
        'adaptavel',
        'adeus',
        'adivinho',
        'adjunto',
        'admoestar',
        'adnominal',
        'adotivo',
        'adquirir',
        'adriatico',
        'adsorcao',
        'adutora',
        'advogar',
        'aerossol',
        'afazeres',
        'afetuoso',
        'afixo',
        'afluir',
        'afortunar',
        'afrouxar',
        'aftosa',
        'afunilar',
        'agentes',
        'agito',
        'aglutinar',
        'aiatola',
        'aimore',
        'aino',
        'aipo',
        'airoso',
        'ajeitar',
        'ajoelhar',
        'ajudante',
        'ajuste',
        'alazao',
        'albumina',
        'alcunha',
        'alegria',
        'alexandre',
        'alforriar',
        'alguns',
        'alhures',
        'alivio',
        'almoxarife',
        'alotropico',
        'alpiste',
        'alquimista',
        'alsaciano',
        'altura',
        'aluviao',
        'alvura',
        'amazonico',
        'ambulatorio',
        'ametodico',
        'amizades',
        'amniotico',
        'amovivel',
        'amurada',
        'anatomico',
        'ancorar',
        'anexo',
        'anfora',
        'aniversario',
        'anjo',
        'anotar',
        'ansioso',
        'anturio',
        'anuviar',
        'anverso',
        'anzol',
        'aonde',
        'apaziguar',
        'apito',
        'aplicavel',
        'apoteotico',
        'aprimorar',
        'aprumo',
        'apto',
        'apuros',
        'aquoso',
        'arauto',
        'arbusto',
        'arduo',
        'aresta',
        'arfar',
        'arguto',
        'aritmetico',
        'arlequim',
        'armisticio',
        'aromatizar',
        'arpoar',
        'arquivo',
        'arrumar',
        'arsenio',
        'arturiano',
        'aruaque',
        'arvores',
        'asbesto',
        'ascorbico',
        'aspirina',
        'asqueroso',
        'assustar',
        'astuto',
        'atazanar',
        'ativo',
        'atletismo',
        'atmosferico',
        'atormentar',
        'atroz',
        'aturdir',
        'audivel',
        'auferir',
        'augusto',
        'aula',
        'aumento',
        'aurora',
        'autuar',
        'avatar',
        'avexar',
        'avizinhar',
        'avolumar',
        'avulso',
        'axiomatico',
        'azerbaijano',
        'azimute',
        'azoto',
        'azulejo',
        'bacteriologista',
        'badulaque',
        'baforada',
        'baixote',
        'bajular',
        'balzaquiana',
        'bambuzal',
        'banzo',
        'baoba',
        'baqueta',
        'barulho',
        'bastonete',
        'batuta',
        'bauxita',
        'bavaro',
        'bazuca',
        'bcrepuscular',
        'beato',
        'beduino',
        'begonia',
        'behaviorista',
        'beisebol',
        'belzebu',
        'bemol',
        'benzido',
        'beocio',
        'bequer',
        'berro',
        'besuntar',
        'betume',
        'bexiga',
        'bezerro',
        'biatlon',
        'biboca',
        'bicuspide',
        'bidirecional',
        'bienio',
        'bifurcar',
        'bigorna',
        'bijuteria',
        'bimotor',
        'binormal',
        'bioxido',
        'bipolarizacao',
        'biquini',
        'birutice',
        'bisturi',
        'bituca',
        'biunivoco',
        'bivalve',
        'bizarro',
        'blasfemo',
        'blenorreia',
        'blindar',
        'bloqueio',
        'blusao',
        'boazuda',
        'bofete',
        'bojudo',
        'bolso',
        'bombordo',
        'bonzo',
        'botina',
        'boquiaberto',
        'bostoniano',
        'botulismo',
        'bourbon',
        'bovino',
        'boximane',
        'bravura',
        'brevidade',
        'britar',
        'broxar',
        'bruno',
        'bruxuleio',
        'bubonico',
        'bucolico',
        'buda',
        'budista',
        'bueiro',
        'buffer',
        'bugre',
        'bujao',
        'bumerangue',
        'burundines',
        'busto',
        'butique',
        'buzios',
        'caatinga',
        'cabuqui',
        'cacunda',
        'cafuzo',
        'cajueiro',
        'camurca',
        'canudo',
        'caquizeiro',
        'carvoeiro',
        'casulo',
        'catuaba',
        'cauterizar',
        'cebolinha',
        'cedula',
        'ceifeiro',
        'celulose',
        'cerzir',
        'cesto',
        'cetro',
        'ceus',
        'cevar',
        'chavena',
        'cheroqui',
        'chita',
        'chovido',
        'chuvoso',
        'ciatico',
        'cibernetico',
        'cicuta',
        'cidreira',
        'cientistas',
        'cifrar',
        'cigarro',
        'cilio',
        'cimo',
        'cinzento',
        'cioso',
        'cipriota',
        'cirurgico',
        'cisto',
        'citrico',
        'ciumento',
        'civismo',
        'clavicula',
        'clero',
        'clitoris',
        'cluster',
        'coaxial',
        'cobrir',
        'cocota',
        'codorniz',
        'coexistir',
        'cogumelo',
        'coito',
        'colusao',
        'compaixao',
        'comutativo',
        'contentamento',
        'convulsivo',
        'coordenativa',
        'coquetel',
        'correto',
        'corvo',
        'costureiro',
        'cotovia',
        'covil',
        'cozinheiro',
        'cretino',
        'cristo',
        'crivo',
        'crotalo',
        'cruzes',
        'cubo',
        'cucuia',
        'cueiro',
        'cuidar',
        'cujo',
        'cultural',
        'cunilingua',
        'cupula',
        'curvo',
        'custoso',
        'cutucar',
        'czarismo',
        'dablio',
        'dacota',
        'dados',
        'daguerreotipo',
        'daiquiri',
        'daltonismo',
        'damista',
        'dantesco',
        'daquilo',
        'darwinista',
        'dasein',
        'dativo',
        'deao',
        'debutantes',
        'decurso',
        'deduzir',
        'defunto',
        'degustar',
        'dejeto',
        'deltoide',
        'demover',
        'denunciar',
        'deputado',
        'deque',
        'dervixe',
        'desvirtuar',
        'deturpar',
        'deuteronomio',
        'devoto',
        'dextrose',
        'dezoito',
        'diatribe',
        'dicotomico',
        'didatico',
        'dietista',
        'difuso',
        'digressao',
        'diluvio',
        'diminuto',
        'dinheiro',
        'dinossauro',
        'dioxido',
        'diplomatico',
        'dique',
        'dirimivel',
        'disturbio',
        'diurno',
        'divulgar',
        'dizivel',
        'doar',
        'dobro',
        'docura',
        'dodoi',
        'doer',
        'dogue',
        'doloso',
        'domo',
        'donzela',
        'doping',
        'dorsal',
        'dossie',
        'dote',
        'doutro',
        'doze',
        'dravidico',
        'dreno',
        'driver',
        'dropes',
        'druso',
        'dubnio',
        'ducto',
        'dueto',
        'dulija',
        'dundum',
        'duodeno',
        'duquesa',
        'durou',
        'duvidoso',
        'duzia',
        'ebano',
        'ebrio',
        'eburneo',
        'echarpe',
        'eclusa',
        'ecossistema',
        'ectoplasma',
        'ecumenismo',
        'eczema',
        'eden',
        'editorial',
        'edredom',
        'edulcorar',
        'efetuar',
        'efigie',
        'efluvio',
        'egiptologo',
        'egresso',
        'egua',
        'einsteiniano',
        'eira',
        'eivar',
        'eixos',
        'ejetar',
        'elastomero',
        'eldorado',
        'elixir',
        'elmo',
        'eloquente',
        'elucidativo',
        'emaranhar',
        'embutir',
        'emerito',
        'emfa',
        'emitir',
        'emotivo',
        'empuxo',
        'emulsao',
        'enamorar',
        'encurvar',
        'enduro',
        'enevoar',
        'enfurnar',
        'enguico',
        'enho',
        'enigmista',
        'enlutar',
        'enormidade',
        'enpreendimento',
        'enquanto',
        'enriquecer',
        'enrugar',
        'entusiastico',
        'enunciar',
        'envolvimento',
        'enxuto',
        'enzimatico',
        'eolico',
        'epiteto',
        'epoxi',
        'epura',
        'equivoco',
        'erario',
        'erbio',
        'ereto',
        'erguido',
        'erisipela',
        'ermo',
        'erotizar',
        'erros',
        'erupcao',
        'ervilha',
        'esburacar',
        'escutar',
        'esfuziante',
        'esguio',
        'esloveno',
        'esmurrar',
        'esoterismo',
        'esperanca',
        'espirito',
        'espurio',
        'essencialmente',
        'esturricar',
        'esvoacar',
        'etario',
        'eterno',
        'etiquetar',
        'etnologo',
        'etos',
        'etrusco',
        'euclidiano',
        'euforico',
        'eugenico',
        'eunuco',
        'europio',
        'eustaquio',
        'eutanasia',
        'evasivo',
        'eventualidade',
        'evitavel',
        'evoluir',
        'exaustor',
        'excursionista',
        'exercito',
        'exfoliado',
        'exito',
        'exotico',
        'expurgo',
        'exsudar',
        'extrusora',
        'exumar',
        'fabuloso',
        'facultativo',
        'fado',
        'fagulha',
        'faixas',
        'fajuto',
        'faltoso',
        'famoso',
        'fanzine',
        'fapesp',
        'faquir',
        'fartura',
        'fastio',
        'faturista',
        'fausto',
        'favorito',
        'faxineira',
        'fazer',
        'fealdade',
        'febril',
        'fecundo',
        'fedorento',
        'feerico',
        'feixe',
        'felicidade',
        'felipe',
        'feltro',
        'femur',
        'fenotipo',
        'fervura',
        'festivo',
        'feto',
        'feudo',
        'fevereiro',
        'fezinha',
        'fiasco',
        'fibra',
        'ficticio',
        'fiduciario',
        'fiesp',
        'fifa',
        'figurino',
        'fijiano',
        'filtro',
        'finura',
        'fiorde',
        'fiquei',
        'firula',
        'fissurar',
        'fitoteca',
        'fivela',
        'fixo',
        'flavio',
        'flexor',
        'flibusteiro',
        'flotilha',
        'fluxograma',
        'fobos',
        'foco',
        'fofura',
        'foguista',
        'foie',
        'foliculo',
        'fominha',
        'fonte',
        'forum',
        'fosso',
        'fotossintese',
        'foxtrote',
        'fraudulento',
        'frevo',
        'frivolo',
        'frouxo',
        'frutose',
        'fuba',
        'fucsia',
        'fugitivo',
        'fuinha',
        'fujao',
        'fulustreco',
        'fumo',
        'funileiro',
        'furunculo',
        'fustigar',
        'futurologo',
        'fuxico',
        'fuzue',
        'gabriel',
        'gado',
        'gaelico',
        'gafieira',
        'gaguejo',
        'gaivota',
        'gajo',
        'galvanoplastico',
        'gamo',
        'ganso',
        'garrucha',
        'gastronomo',
        'gatuno',
        'gaussiano',
        'gaviao',
        'gaxeta',
        'gazeteiro',
        'gear',
        'geiser',
        'geminiano',
        'generoso',
        'genuino',
        'geossinclinal',
        'gerundio',
        'gestual',
        'getulista',
        'gibi',
        'gigolo',
        'gilete',
        'ginseng',
        'giroscopio',
        'glaucio',
        'glacial',
        'gleba',
        'glifo',
        'glote',
        'glutonia',
        'gnostico',
        'goela',
        'gogo',
        'goitaca',
        'golpista',
        'gomo',
        'gonzo',
        'gorro',
        'gostou',
        'goticula',
        'gourmet',
        'governo',
        'gozo',
        'graxo',
        'grevista',
        'grito',
        'grotesco',
        'gruta',
        'guaxinim',
        'gude',
        'gueto',
        'guizo',
        'guloso',
        'gume',
        'guru',
        'gustativo',
        'gustavo',
        'gutural',
        'habitue',
        'haitiano',
        'halterofilista',
        'hamburguer',
        'hanseniase',
        'happening',
        'harpista',
        'hastear',
        'haveres',
        'hebreu',
        'hectometro',
        'hedonista',
        'hegira',
        'helena',
        'helminto',
        'hemorroidas',
        'henrique',
        'heptassilabo',
        'hertziano',
        'hesitar',
        'heterossexual',
        'heuristico',
        'hexagono',
        'hiato',
        'hibrido',
        'hidrostatico',
        'hieroglifo',
        'hifenizar',
        'higienizar',
        'hilario',
        'himen',
        'hino',
        'hippie',
        'hirsuto',
        'historiografia',
        'hitlerista',
        'hodometro',
        'hoje',
        'holograma',
        'homus',
        'honroso',
        'hoquei',
        'horto',
        'hostilizar',
        'hotentote',
        'huguenote',
        'humilde',
        'huno',
        'hurra',
        'hutu',
        'iaia',
        'ialorixa',
        'iambico',
        'iansa',
        'iaque',
        'iara',
        'iatista',
        'iberico',
        'ibis',
        'icar',
        'iceberg',
        'icosagono',
        'idade',
        'ideologo',
        'idiotice',
        'idoso',
        'iemenita',
        'iene',
        'igarape',
        'iglu',
        'ignorar',
        'igreja',
        'iguaria',
        'iidiche',
        'ilativo',
        'iletrado',
        'ilharga',
        'ilimitado',
        'ilogismo',
        'ilustrissimo',
        'imaturo',
        'imbuzeiro',
        'imerso',
        'imitavel',
        'imovel',
        'imputar',
        'imutavel',
        'inaveriguavel',
        'incutir',
        'induzir',
        'inextricavel',
        'infusao',
        'ingua',
        'inhame',
        'iniquo',
        'injusto',
        'inning',
        'inoxidavel',
        'inquisitorial',
        'insustentavel',
        'intumescimento',
        'inutilizavel',
        'invulneravel',
        'inzoneiro',
        'iodo',
        'iogurte',
        'ioio',
        'ionosfera',
        'ioruba',
        'iota',
        'ipsilon',
        'irascivel',
        'iris',
        'irlandes',
        'irmaos',
        'iroques',
        'irrupcao',
        'isca',
        'isento',
        'islandes',
        'isotopo',
        'isqueiro',
        'israelita',
        'isso',
        'isto',
        'iterbio',
        'itinerario',
        'itrio',
        'iuane',
        'iugoslavo',
        'jabuticabeira',
        'jacutinga',
        'jade',
        'jagunco',
        'jainista',
        'jaleco',
        'jambo',
        'jantarada',
        'japones',
        'jaqueta',
        'jarro',
        'jasmim',
        'jato',
        'jaula',
        'javel',
        'jazz',
        'jegue',
        'jeitoso',
        'jejum',
        'jenipapo',
        'jeova',
        'jequitiba',
        'jersei',
        'jesus',
        'jetom',
        'jiboia',
        'jihad',
        'jilo',
        'jingle',
        'jipe',
        'jocoso',
        'joelho',
        'joguete',
        'joio',
        'jojoba',
        'jorro',
        'jota',
        'joule',
        'joviano',
        'jubiloso',
        'judoca',
        'jugular',
        'juizo',
        'jujuba',
        'juliano',
        'jumento',
        'junto',
        'jururu',
        'justo',
        'juta',
        'juventude',
        'labutar',
        'laguna',
        'laico',
        'lajota',
        'lanterninha',
        'lapso',
        'laquear',
        'lastro',
        'lauto',
        'lavrar',
        'laxativo',
        'lazer',
        'leasing',
        'lebre',
        'lecionar',
        'ledo',
        'leguminoso',
        'leitura',
        'lele',
        'lemure',
        'lento',
        'leonardo',
        'leopardo',
        'lepton',
        'leque',
        'leste',
        'letreiro',
        'leucocito',
        'levitico',
        'lexicologo',
        'lhama',
        'lhufas',
        'liame',
        'licoroso',
        'lidocaina',
        'liliputiano',
        'limusine',
        'linotipo',
        'lipoproteina',
        'liquidos',
        'lirismo',
        'lisura',
        'liturgico',
        'livros',
        'lixo',
        'lobulo',
        'locutor',
        'lodo',
        'logro',
        'lojista',
        'lombriga',
        'lontra',
        'loop',
        'loquaz',
        'lorota',
        'losango',
        'lotus',
        'louvor',
        'luar',
        'lubrificavel',
        'lucros',
        'lugubre',
        'luis',
        'luminoso',
        'luneta',
        'lustroso',
        'luto',
        'luvas',
        'luxuriante',
        'luzeiro',
        'maduro',
        'maestro',
        'mafioso',
        'magro',
        'maiuscula',
        'majoritario',
        'malvisto',
        'mamute',
        'manutencao',
        'mapoteca',
        'maquinista',
        'marzipa',
        'masturbar',
        'matuto',
        'mausoleu',
        'mavioso',
        'maxixe',
        'mazurca',
        'meandro',
        'mecha',
        'medusa',
        'mefistofelico',
        'megera',
        'meirinho',
        'melro',
        'memorizar',
        'menu',
        'mequetrefe',
        'mertiolate',
        'mestria',
        'metroviario',
        'mexilhao',
        'mezanino',
        'miau',
        'microssegundo',
        'midia',
        'migratorio',
        'mimosa',
        'minuto',
        'miosotis',
        'mirtilo',
        'misturar',
        'mitzvah',
        'miudos',
        'mixuruca',
        'mnemonico',
        'moagem',
        'mobilizar',
        'modulo',
        'moer',
        'mofo',
        'mogno',
        'moita',
        'molusco',
        'monumento',
        'moqueca',
        'morubixaba',
        'mostruario',
        'motriz',
        'mouse',
        'movivel',
        'mozarela',
        'muarra',
        'muculmano',
        'mudo',
        'mugir',
        'muitos',
        'mumunha',
        'munir',
        'muon',
        'muquira',
        'murros',
        'musselina',
        'nacoes',
        'nado',
        'naftalina',
        'nago',
        'naipe',
        'naja',
        'nalgum',
        'namoro',
        'nanquim',
        'napolitano',
        'naquilo',
        'nascimento',
        'nautilo',
        'navios',
        'nazista',
        'nebuloso',
        'nectarina',
        'nefrologo',
        'negus',
        'nelore',
        'nenufar',
        'nepotismo',
        'nervura',
        'neste',
        'netuno',
        'neutron',
        'nevoeiro',
        'newtoniano',
        'nexo',
        'nhenhenhem',
        'nhoque',
        'nigeriano',
        'niilista',
        'ninho',
        'niobio',
        'niponico',
        'niquelar',
        'nirvana',
        'nisto',
        'nitroglicerina',
        'nivoso',
        'nobreza',
        'nocivo',
        'noel',
        'nogueira',
        'noivo',
        'nojo',
        'nominativo',
        'nonuplo',
        'noruegues',
        'nostalgico',
        'noturno',
        'nouveau',
        'nuanca',
        'nublar',
        'nucleotideo',
        'nudista',
        'nulo',
        'numismatico',
        'nunquinha',
        'nupcias',
        'nutritivo',
        'nuvens',
        'oasis',
        'obcecar',
        'obeso',
        'obituario',
        'objetos',
        'oblongo',
        'obnoxio',
        'obrigatorio',
        'obstruir',
        'obtuso',
        'obus',
        'obvio',
        'ocaso',
        'occipital',
        'oceanografo',
        'ocioso',
        'oclusivo',
        'ocorrer',
        'ocre',
        'octogono',
        'odalisca',
        'odisseia',
        'odorifico',
        'oersted',
        'oeste',
        'ofertar',
        'ofidio',
        'oftalmologo',
        'ogiva',
        'ogum',
        'oigale',
        'oitavo',
        'oitocentos',
        'ojeriza',
        'olaria',
        'oleoso',
        'olfato',
        'olhos',
        'oliveira',
        'olmo',
        'olor',
        'olvidavel',
        'ombudsman',
        'omeleteira',
        'omitir',
        'omoplata',
        'onanismo',
        'ondular',
        'oneroso',
        'onomatopeico',
        'ontologico',
        'onus',
        'onze',
        'opalescente',
        'opcional',
        'operistico',
        'opio',
        'oposto',
        'oprobrio',
        'optometrista',
        'opusculo',
        'oratorio',
        'orbital',
        'orcar',
        'orfao',
        'orixa',
        'orla',
        'ornitologo',
        'orquidea',
        'ortorrombico',
        'orvalho',
        'osculo',
        'osmotico',
        'ossudo',
        'ostrogodo',
        'otario',
        'otite',
        'ouro',
        'ousar',
        'outubro',
        'ouvir',
        'ovario',
        'overnight',
        'oviparo',
        'ovni',
        'ovoviviparo',
        'ovulo',
        'oxala',
        'oxente',
        'oxiuro',
        'oxossi',
        'ozonizar',
        'paciente',
        'pactuar',
        'padronizar',
        'paete',
        'pagodeiro',
        'paixao',
        'pajem',
        'paludismo',
        'pampas',
        'panturrilha',
        'papudo',
        'paquistanes',
        'pastoso',
        'patua',
        'paulo',
        'pauzinhos',
        'pavoroso',
        'paxa',
        'pazes',
        'peao',
        'pecuniario',
        'pedunculo',
        'pegaso',
        'peixinho',
        'pejorativo',
        'pelvis',
        'penuria',
        'pequno',
        'petunia',
        'pezada',
        'piauiense',
        'pictorico',
        'pierro',
        'pigmeu',
        'pijama',
        'pilulas',
        'pimpolho',
        'pintura',
        'piorar',
        'pipocar',
        'piqueteiro',
        'pirulito',
        'pistoleiro',
        'pituitaria',
        'pivotar',
        'pixote',
        'pizzaria',
        'plistoceno',
        'plotar',
        'pluviometrico',
        'pneumonico',
        'poco',
        'podridao',
        'poetisa',
        'pogrom',
        'pois',
        'polvorosa',
        'pomposo',
        'ponderado',
        'pontudo',
        'populoso',
        'poquer',
        'porvir',
        'posudo',
        'potro',
        'pouso',
        'povoar',
        'prazo',
        'prezar',
        'privilegios',
        'proximo',
        'prussiano',
        'pseudopode',
        'psoriase',
        'pterossauros',
        'ptialina',
        'ptolemaico',
        'pudor',
        'pueril',
        'pufe',
        'pugilista',
        'puir',
        'pujante',
        'pulverizar',
        'pumba',
        'punk',
        'purulento',
        'pustula',
        'putsch',
        'puxe',
        'quatrocentos',
        'quetzal',
        'quixotesco',
        'quotizavel',
        'rabujice',
        'racista',
        'radonio',
        'rafia',
        'ragu',
        'rajado',
        'ralo',
        'rampeiro',
        'ranzinza',
        'raptor',
        'raquitismo',
        'raro',
        'rasurar',
        'ratoeira',
        'ravioli',
        'razoavel',
        'reavivar',
        'rebuscar',
        'recusavel',
        'reduzivel',
        'reexposicao',
        'refutavel',
        'regurgitar',
        'reivindicavel',
        'rejuvenescimento',
        'relva',
        'remuneravel',
        'renunciar',
        'reorientar',
        'repuxo',
        'requisito',
        'resumo',
        'returno',
        'reutilizar',
        'revolvido',
        'rezonear',
        'riacho',
        'ribossomo',
        'ricota',
        'ridiculo',
        'rifle',
        'rigoroso',
        'rijo',
        'rimel',
        'rins',
        'rios',
        'riqueza',
        'riquixa',
        'rissole',
        'ritualistico',
        'rivalizar',
        'rixa',
        'robusto',
        'rococo',
        'rodoviario',
        'roer',
        'rogo',
        'rojao',
        'rolo',
        'rompimento',
        'ronronar',
        'roqueiro',
        'rorqual',
        'rosto',
        'rotundo',
        'rouxinol',
        'roxo',
        'royal',
        'ruas',
        'rucula',
        'rudimentos',
        'ruela',
        'rufo',
        'rugoso',
        'ruivo',
        'rule',
        'rumoroso',
        'runico',
        'ruptura',
        'rural',
        'rustico',
        'rutilar',
        'saariano',
        'sabujo',
        'sacudir',
        'sadomasoquista',
        'safra',
        'sagui',
        'sais',
        'samurai',
        'santuario',
        'sapo',
        'saquear',
        'sartriano',
        'saturno',
        'saude',
        'sauva',
        'saveiro',
        'saxofonista',
        'sazonal',
        'scherzo',
        'script',
        'seara',
        'seborreia',
        'secura',
        'seduzir',
        'sefardim',
        'seguro',
        'seja',
        'selvas',
        'sempre',
        'senzala',
        'sepultura',
        'sequoia',
        'sestercio',
        'setuplo',
        'seus',
        'seviciar',
        'sezonismo',
        'shalom',
        'siames',
        'sibilante',
        'sicrano',
        'sidra',
        'sifilitico',
        'signos',
        'silvo',
        'simultaneo',
        'sinusite',
        'sionista',
        'sirio',
        'sisudo',
        'situar',
        'sivan',
        'slide',
        'slogan',
        'soar',
        'sobrio',
        'socratico',
        'sodomizar',
        'soerguer',
        'software',
        'sogro',
        'soja',
        'solver',
        'somente',
        'sonso',
        'sopro',
        'soquete',
        'sorveteiro',
        'sossego',
        'soturno',
        'sousafone',
        'sovinice',
        'sozinho',
        'suavizar',
        'subverter',
        'sucursal',
        'sudoriparo',
        'sufragio',
        'sugestoes',
        'suite',
        'sujo',
        'sultao',
        'sumula',
        'suntuoso',
        'suor',
        'supurar',
        'suruba',
        'susto',
        'suturar',
        'suvenir',
        'tabuleta',
        'taco',
        'tadjique',
        'tafeta',
        'tagarelice',
        'taitiano',
        'talvez',
        'tampouco',
        'tanzaniano',
        'taoista',
        'tapume',
        'taquion',
        'tarugo',
        'tascar',
        'tatuar',
        'tautologico',
        'tavola',
        'taxionomista',
        'tchecoslovaco',
        'teatrologo',
        'tectonismo',
        'tedioso',
        'teflon',
        'tegumento',
        'teixo',
        'telurio',
        'temporas',
        'tenue',
        'teosofico',
        'tepido',
        'tequila',
        'terrorista',
        'testosterona',
        'tetrico',
        'teutonico',
        'teve',
        'texugo',
        'tiara',
        'tibia',
        'tiete',
        'tifoide',
        'tigresa',
        'tijolo',
        'tilintar',
        'timpano',
        'tintureiro',
        'tiquete',
        'tiroteio',
        'tisico',
        'titulos',
        'tive',
        'toar',
        'toboga',
        'tofu',
        'togoles',
        'toicinho',
        'tolueno',
        'tomografo',
        'tontura',
        'toponimo',
        'toquio',
        'torvelinho',
        'tostar',
        'toto',
        'touro',
        'toxina',
        'trazer',
        'trezentos',
        'trivialidade',
        'trovoar',
        'truta',
        'tuaregue',
        'tubular',
        'tucano',
        'tudo',
        'tufo',
        'tuiste',
        'tulipa',
        'tumultuoso',
        'tunisino',
        'tupiniquim',
        'turvo',
        'tutu',
        'ucraniano',
        'udenista',
        'ufanista',
        'ufologo',
        'ugaritico',
        'uiste',
        'uivo',
        'ulceroso',
        'ulema',
        'ultravioleta',
        'umbilical',
        'umero',
        'umido',
        'umlaut',
        'unanimidade',
        'unesco',
        'ungulado',
        'unheiro',
        'univoco',
        'untuoso',
        'urano',
        'urbano',
        'urdir',
        'uretra',
        'urgente',
        'urinol',
        'urna',
        'urologo',
        'urro',
        'ursulina',
        'urtiga',
        'urupe',
        'usavel',
        'usbeque',
        'usei',
        'usineiro',
        'usurpar',
        'utero',
        'utilizar',
        'utopico',
        'uvular',
        'uxoricidio',
        'vacuo',
        'vadio',
        'vaguear',
        'vaivem',
        'valvula',
        'vampiro',
        'vantajoso',
        'vaporoso',
        'vaquinha',
        'varziano',
        'vasto',
        'vaticinio',
        'vaudeville',
        'vazio',
        'veado',
        'vedico',
        'veemente',
        'vegetativo',
        'veio',
        'veja',
        'veludo',
        'venusiano',
        'verdade',
        'verve',
        'vestuario',
        'vetusto',
        'vexatorio',
        'vezes',
        'viavel',
        'vibratorio',
        'victor',
        'vicunha',
        'vidros',
        'vietnamita',
        'vigoroso',
        'vilipendiar',
        'vime',
        'vintem',
        'violoncelo',
        'viquingue',
        'virus',
        'visualizar',
        'vituperio',
        'viuvo',
        'vivo',
        'vizir',
        'voar',
        'vociferar',
        'vodu',
        'vogar',
        'voile',
        'volver',
        'vomito',
        'vontade',
        'vortice',
        'vosso',
        'voto',
        'vovozinha',
        'voyeuse',
        'vozes',
        'vulva',
        'vupt',
        'western',
        'xadrez',
        'xale',
        'xampu',
        'xango',
        'xarope',
        'xaual',
        'xavante',
        'xaxim',
        'xenonio',
        'xepa',
        'xerox',
        'xicara',
        'xifopago',
        'xiita',
        'xilogravura',
        'xinxim',
        'xistoso',
        'xixi',
        'xodo',
        'xogum',
        'xucro',
        'zabumba',
        'zagueiro',
        'zambiano',
        'zanzar',
        'zarpar',
        'zebu',
        'zefiro',
        'zeloso',
        'zenite',
        'zumbi',
      ])
    );
    langs.push(
      new MnemonicLang('japanese', 'ja', 4, [
        'あいこくしん',
        'あいさつ',
        'あいだ',
        'あおぞら',
        'あかちゃん',
        'あきる',
        'あけがた',
        'あける',
        'あこがれる',
        'あさい',
        'あさひ',
        'あしあと',
        'あじわう',
        'あずかる',
        'あずき',
        'あそぶ',
        'あたえる',
        'あたためる',
        'あたりまえ',
        'あたる',
        'あつい',
        'あつかう',
        'あっしゅく',
        'あつまり',
        'あつめる',
        'あてな',
        'あてはまる',
        'あひる',
        'あぶら',
        'あぶる',
        'あふれる',
        'あまい',
        'あまど',
        'あまやかす',
        'あまり',
        'あみもの',
        'あめりか',
        'あやまる',
        'あゆむ',
        'あらいぐま',
        'あらし',
        'あらすじ',
        'あらためる',
        'あらゆる',
        'あらわす',
        'ありがとう',
        'あわせる',
        'あわてる',
        'あんい',
        'あんがい',
        'あんこ',
        'あんぜん',
        'あんてい',
        'あんない',
        'あんまり',
        'いいだす',
        'いおん',
        'いがい',
        'いがく',
        'いきおい',
        'いきなり',
        'いきもの',
        'いきる',
        'いくじ',
        'いくぶん',
        'いけばな',
        'いけん',
        'いこう',
        'いこく',
        'いこつ',
        'いさましい',
        'いさん',
        'いしき',
        'いじゅう',
        'いじょう',
        'いじわる',
        'いずみ',
        'いずれ',
        'いせい',
        'いせえび',
        'いせかい',
        'いせき',
        'いぜん',
        'いそうろう',
        'いそがしい',
        'いだい',
        'いだく',
        'いたずら',
        'いたみ',
        'いたりあ',
        'いちおう',
        'いちじ',
        'いちど',
        'いちば',
        'いちぶ',
        'いちりゅう',
        'いつか',
        'いっしゅん',
        'いっせい',
        'いっそう',
        'いったん',
        'いっち',
        'いってい',
        'いっぽう',
        'いてざ',
        'いてん',
        'いどう',
        'いとこ',
        'いない',
        'いなか',
        'いねむり',
        'いのち',
        'いのる',
        'いはつ',
        'いばる',
        'いはん',
        'いびき',
        'いひん',
        'いふく',
        'いへん',
        'いほう',
        'いみん',
        'いもうと',
        'いもたれ',
        'いもり',
        'いやがる',
        'いやす',
        'いよかん',
        'いよく',
        'いらい',
        'いらすと',
        'いりぐち',
        'いりょう',
        'いれい',
        'いれもの',
        'いれる',
        'いろえんぴつ',
        'いわい',
        'いわう',
        'いわかん',
        'いわば',
        'いわゆる',
        'いんげんまめ',
        'いんさつ',
        'いんしょう',
        'いんよう',
        'うえき',
        'うえる',
        'うおざ',
        'うがい',
        'うかぶ',
        'うかべる',
        'うきわ',
        'うくらいな',
        'うくれれ',
        'うけたまわる',
        'うけつけ',
        'うけとる',
        'うけもつ',
        'うける',
        'うごかす',
        'うごく',
        'うこん',
        'うさぎ',
        'うしなう',
        'うしろがみ',
        'うすい',
        'うすぎ',
        'うすぐらい',
        'うすめる',
        'うせつ',
        'うちあわせ',
        'うちがわ',
        'うちき',
        'うちゅう',
        'うっかり',
        'うつくしい',
        'うったえる',
        'うつる',
        'うどん',
        'うなぎ',
        'うなじ',
        'うなずく',
        'うなる',
        'うねる',
        'うのう',
        'うぶげ',
        'うぶごえ',
        'うまれる',
        'うめる',
        'うもう',
        'うやまう',
        'うよく',
        'うらがえす',
        'うらぐち',
        'うらない',
        'うりあげ',
        'うりきれ',
        'うるさい',
        'うれしい',
        'うれゆき',
        'うれる',
        'うろこ',
        'うわき',
        'うわさ',
        'うんこう',
        'うんちん',
        'うんてん',
        'うんどう',
        'えいえん',
        'えいが',
        'えいきょう',
        'えいご',
        'えいせい',
        'えいぶん',
        'えいよう',
        'えいわ',
        'えおり',
        'えがお',
        'えがく',
        'えきたい',
        'えくせる',
        'えしゃく',
        'えすて',
        'えつらん',
        'えのぐ',
        'えほうまき',
        'えほん',
        'えまき',
        'えもじ',
        'えもの',
        'えらい',
        'えらぶ',
        'えりあ',
        'えんえん',
        'えんかい',
        'えんぎ',
        'えんげき',
        'えんしゅう',
        'えんぜつ',
        'えんそく',
        'えんちょう',
        'えんとつ',
        'おいかける',
        'おいこす',
        'おいしい',
        'おいつく',
        'おうえん',
        'おうさま',
        'おうじ',
        'おうせつ',
        'おうたい',
        'おうふく',
        'おうべい',
        'おうよう',
        'おえる',
        'おおい',
        'おおう',
        'おおどおり',
        'おおや',
        'おおよそ',
        'おかえり',
        'おかず',
        'おがむ',
        'おかわり',
        'おぎなう',
        'おきる',
        'おくさま',
        'おくじょう',
        'おくりがな',
        'おくる',
        'おくれる',
        'おこす',
        'おこなう',
        'おこる',
        'おさえる',
        'おさない',
        'おさめる',
        'おしいれ',
        'おしえる',
        'おじぎ',
        'おじさん',
        'おしゃれ',
        'おそらく',
        'おそわる',
        'おたがい',
        'おたく',
        'おだやか',
        'おちつく',
        'おっと',
        'おつり',
        'おでかけ',
        'おとしもの',
        'おとなしい',
        'おどり',
        'おどろかす',
        'おばさん',
        'おまいり',
        'おめでとう',
        'おもいで',
        'おもう',
        'おもたい',
        'おもちゃ',
        'おやつ',
        'おやゆび',
        'およぼす',
        'おらんだ',
        'おろす',
        'おんがく',
        'おんけい',
        'おんしゃ',
        'おんせん',
        'おんだん',
        'おんちゅう',
        'おんどけい',
        'かあつ',
        'かいが',
        'がいき',
        'がいけん',
        'がいこう',
        'かいさつ',
        'かいしゃ',
        'かいすいよく',
        'かいぜん',
        'かいぞうど',
        'かいつう',
        'かいてん',
        'かいとう',
        'かいふく',
        'がいへき',
        'かいほう',
        'かいよう',
        'がいらい',
        'かいわ',
        'かえる',
        'かおり',
        'かかえる',
        'かがく',
        'かがし',
        'かがみ',
        'かくご',
        'かくとく',
        'かざる',
        'がぞう',
        'かたい',
        'かたち',
        'がちょう',
        'がっきゅう',
        'がっこう',
        'がっさん',
        'がっしょう',
        'かなざわし',
        'かのう',
        'がはく',
        'かぶか',
        'かほう',
        'かほご',
        'かまう',
        'かまぼこ',
        'かめれおん',
        'かゆい',
        'かようび',
        'からい',
        'かるい',
        'かろう',
        'かわく',
        'かわら',
        'がんか',
        'かんけい',
        'かんこう',
        'かんしゃ',
        'かんそう',
        'かんたん',
        'かんち',
        'がんばる',
        'きあい',
        'きあつ',
        'きいろ',
        'ぎいん',
        'きうい',
        'きうん',
        'きえる',
        'きおう',
        'きおく',
        'きおち',
        'きおん',
        'きかい',
        'きかく',
        'きかんしゃ',
        'ききて',
        'きくばり',
        'きくらげ',
        'きけんせい',
        'きこう',
        'きこえる',
        'きこく',
        'きさい',
        'きさく',
        'きさま',
        'きさらぎ',
        'ぎじかがく',
        'ぎしき',
        'ぎじたいけん',
        'ぎじにってい',
        'ぎじゅつしゃ',
        'きすう',
        'きせい',
        'きせき',
        'きせつ',
        'きそう',
        'きぞく',
        'きぞん',
        'きたえる',
        'きちょう',
        'きつえん',
        'ぎっちり',
        'きつつき',
        'きつね',
        'きてい',
        'きどう',
        'きどく',
        'きない',
        'きなが',
        'きなこ',
        'きぬごし',
        'きねん',
        'きのう',
        'きのした',
        'きはく',
        'きびしい',
        'きひん',
        'きふく',
        'きぶん',
        'きぼう',
        'きほん',
        'きまる',
        'きみつ',
        'きむずかしい',
        'きめる',
        'きもだめし',
        'きもち',
        'きもの',
        'きゃく',
        'きやく',
        'ぎゅうにく',
        'きよう',
        'きょうりゅう',
        'きらい',
        'きらく',
        'きりん',
        'きれい',
        'きれつ',
        'きろく',
        'ぎろん',
        'きわめる',
        'ぎんいろ',
        'きんかくじ',
        'きんじょ',
        'きんようび',
        'ぐあい',
        'くいず',
        'くうかん',
        'くうき',
        'くうぐん',
        'くうこう',
        'ぐうせい',
        'くうそう',
        'ぐうたら',
        'くうふく',
        'くうぼ',
        'くかん',
        'くきょう',
        'くげん',
        'ぐこう',
        'くさい',
        'くさき',
        'くさばな',
        'くさる',
        'くしゃみ',
        'くしょう',
        'くすのき',
        'くすりゆび',
        'くせげ',
        'くせん',
        'ぐたいてき',
        'くださる',
        'くたびれる',
        'くちこみ',
        'くちさき',
        'くつした',
        'ぐっすり',
        'くつろぐ',
        'くとうてん',
        'くどく',
        'くなん',
        'くねくね',
        'くのう',
        'くふう',
        'くみあわせ',
        'くみたてる',
        'くめる',
        'くやくしょ',
        'くらす',
        'くらべる',
        'くるま',
        'くれる',
        'くろう',
        'くわしい',
        'ぐんかん',
        'ぐんしょく',
        'ぐんたい',
        'ぐんて',
        'けあな',
        'けいかく',
        'けいけん',
        'けいこ',
        'けいさつ',
        'げいじゅつ',
        'けいたい',
        'げいのうじん',
        'けいれき',
        'けいろ',
        'けおとす',
        'けおりもの',
        'げきか',
        'げきげん',
        'げきだん',
        'げきちん',
        'げきとつ',
        'げきは',
        'げきやく',
        'げこう',
        'げこくじょう',
        'げざい',
        'けさき',
        'げざん',
        'けしき',
        'けしごむ',
        'けしょう',
        'げすと',
        'けたば',
        'けちゃっぷ',
        'けちらす',
        'けつあつ',
        'けつい',
        'けつえき',
        'けっこん',
        'けつじょ',
        'けっせき',
        'けってい',
        'けつまつ',
        'げつようび',
        'げつれい',
        'けつろん',
        'げどく',
        'けとばす',
        'けとる',
        'けなげ',
        'けなす',
        'けなみ',
        'けぬき',
        'げねつ',
        'けねん',
        'けはい',
        'げひん',
        'けぶかい',
        'げぼく',
        'けまり',
        'けみかる',
        'けむし',
        'けむり',
        'けもの',
        'けらい',
        'けろけろ',
        'けわしい',
        'けんい',
        'けんえつ',
        'けんお',
        'けんか',
        'げんき',
        'けんげん',
        'けんこう',
        'けんさく',
        'けんしゅう',
        'けんすう',
        'げんそう',
        'けんちく',
        'けんてい',
        'けんとう',
        'けんない',
        'けんにん',
        'げんぶつ',
        'けんま',
        'けんみん',
        'けんめい',
        'けんらん',
        'けんり',
        'こあくま',
        'こいぬ',
        'こいびと',
        'ごうい',
        'こうえん',
        'こうおん',
        'こうかん',
        'ごうきゅう',
        'ごうけい',
        'こうこう',
        'こうさい',
        'こうじ',
        'こうすい',
        'ごうせい',
        'こうそく',
        'こうたい',
        'こうちゃ',
        'こうつう',
        'こうてい',
        'こうどう',
        'こうない',
        'こうはい',
        'ごうほう',
        'ごうまん',
        'こうもく',
        'こうりつ',
        'こえる',
        'こおり',
        'ごかい',
        'ごがつ',
        'ごかん',
        'こくご',
        'こくさい',
        'こくとう',
        'こくない',
        'こくはく',
        'こぐま',
        'こけい',
        'こける',
        'ここのか',
        'こころ',
        'こさめ',
        'こしつ',
        'こすう',
        'こせい',
        'こせき',
        'こぜん',
        'こそだて',
        'こたい',
        'こたえる',
        'こたつ',
        'こちょう',
        'こっか',
        'こつこつ',
        'こつばん',
        'こつぶ',
        'こてい',
        'こてん',
        'ことがら',
        'ことし',
        'ことば',
        'ことり',
        'こなごな',
        'こねこね',
        'このまま',
        'このみ',
        'このよ',
        'ごはん',
        'こひつじ',
        'こふう',
        'こふん',
        'こぼれる',
        'ごまあぶら',
        'こまかい',
        'ごますり',
        'こまつな',
        'こまる',
        'こむぎこ',
        'こもじ',
        'こもち',
        'こもの',
        'こもん',
        'こやく',
        'こやま',
        'こゆう',
        'こゆび',
        'こよい',
        'こよう',
        'こりる',
        'これくしょん',
        'ころっけ',
        'こわもて',
        'こわれる',
        'こんいん',
        'こんかい',
        'こんき',
        'こんしゅう',
        'こんすい',
        'こんだて',
        'こんとん',
        'こんなん',
        'こんびに',
        'こんぽん',
        'こんまけ',
        'こんや',
        'こんれい',
        'こんわく',
        'ざいえき',
        'さいかい',
        'さいきん',
        'ざいげん',
        'ざいこ',
        'さいしょ',
        'さいせい',
        'ざいたく',
        'ざいちゅう',
        'さいてき',
        'ざいりょう',
        'さうな',
        'さかいし',
        'さがす',
        'さかな',
        'さかみち',
        'さがる',
        'さぎょう',
        'さくし',
        'さくひん',
        'さくら',
        'さこく',
        'さこつ',
        'さずかる',
        'ざせき',
        'さたん',
        'さつえい',
        'ざつおん',
        'ざっか',
        'ざつがく',
        'さっきょく',
        'ざっし',
        'さつじん',
        'ざっそう',
        'さつたば',
        'さつまいも',
        'さてい',
        'さといも',
        'さとう',
        'さとおや',
        'さとし',
        'さとる',
        'さのう',
        'さばく',
        'さびしい',
        'さべつ',
        'さほう',
        'さほど',
        'さます',
        'さみしい',
        'さみだれ',
        'さむけ',
        'さめる',
        'さやえんどう',
        'さゆう',
        'さよう',
        'さよく',
        'さらだ',
        'ざるそば',
        'さわやか',
        'さわる',
        'さんいん',
        'さんか',
        'さんきゃく',
        'さんこう',
        'さんさい',
        'ざんしょ',
        'さんすう',
        'さんせい',
        'さんそ',
        'さんち',
        'さんま',
        'さんみ',
        'さんらん',
        'しあい',
        'しあげ',
        'しあさって',
        'しあわせ',
        'しいく',
        'しいん',
        'しうち',
        'しえい',
        'しおけ',
        'しかい',
        'しかく',
        'じかん',
        'しごと',
        'しすう',
        'じだい',
        'したうけ',
        'したぎ',
        'したて',
        'したみ',
        'しちょう',
        'しちりん',
        'しっかり',
        'しつじ',
        'しつもん',
        'してい',
        'してき',
        'してつ',
        'じてん',
        'じどう',
        'しなぎれ',
        'しなもの',
        'しなん',
        'しねま',
        'しねん',
        'しのぐ',
        'しのぶ',
        'しはい',
        'しばかり',
        'しはつ',
        'しはらい',
        'しはん',
        'しひょう',
        'しふく',
        'じぶん',
        'しへい',
        'しほう',
        'しほん',
        'しまう',
        'しまる',
        'しみん',
        'しむける',
        'じむしょ',
        'しめい',
        'しめる',
        'しもん',
        'しゃいん',
        'しゃうん',
        'しゃおん',
        'じゃがいも',
        'しやくしょ',
        'しゃくほう',
        'しゃけん',
        'しゃこ',
        'しゃざい',
        'しゃしん',
        'しゃせん',
        'しゃそう',
        'しゃたい',
        'しゃちょう',
        'しゃっきん',
        'じゃま',
        'しゃりん',
        'しゃれい',
        'じゆう',
        'じゅうしょ',
        'しゅくはく',
        'じゅしん',
        'しゅっせき',
        'しゅみ',
        'しゅらば',
        'じゅんばん',
        'しょうかい',
        'しょくたく',
        'しょっけん',
        'しょどう',
        'しょもつ',
        'しらせる',
        'しらべる',
        'しんか',
        'しんこう',
        'じんじゃ',
        'しんせいじ',
        'しんちく',
        'しんりん',
        'すあげ',
        'すあし',
        'すあな',
        'ずあん',
        'すいえい',
        'すいか',
        'すいとう',
        'ずいぶん',
        'すいようび',
        'すうがく',
        'すうじつ',
        'すうせん',
        'すおどり',
        'すきま',
        'すくう',
        'すくない',
        'すける',
        'すごい',
        'すこし',
        'ずさん',
        'すずしい',
        'すすむ',
        'すすめる',
        'すっかり',
        'ずっしり',
        'ずっと',
        'すてき',
        'すてる',
        'すねる',
        'すのこ',
        'すはだ',
        'すばらしい',
        'ずひょう',
        'ずぶぬれ',
        'すぶり',
        'すふれ',
        'すべて',
        'すべる',
        'ずほう',
        'すぼん',
        'すまい',
        'すめし',
        'すもう',
        'すやき',
        'すらすら',
        'するめ',
        'すれちがう',
        'すろっと',
        'すわる',
        'すんぜん',
        'すんぽう',
        'せあぶら',
        'せいかつ',
        'せいげん',
        'せいじ',
        'せいよう',
        'せおう',
        'せかいかん',
        'せきにん',
        'せきむ',
        'せきゆ',
        'せきらんうん',
        'せけん',
        'せこう',
        'せすじ',
        'せたい',
        'せたけ',
        'せっかく',
        'せっきゃく',
        'ぜっく',
        'せっけん',
        'せっこつ',
        'せっさたくま',
        'せつぞく',
        'せつだん',
        'せつでん',
        'せっぱん',
        'せつび',
        'せつぶん',
        'せつめい',
        'せつりつ',
        'せなか',
        'せのび',
        'せはば',
        'せびろ',
        'せぼね',
        'せまい',
        'せまる',
        'せめる',
        'せもたれ',
        'せりふ',
        'ぜんあく',
        'せんい',
        'せんえい',
        'せんか',
        'せんきょ',
        'せんく',
        'せんげん',
        'ぜんご',
        'せんさい',
        'せんしゅ',
        'せんすい',
        'せんせい',
        'せんぞ',
        'せんたく',
        'せんちょう',
        'せんてい',
        'せんとう',
        'せんぬき',
        'せんねん',
        'せんぱい',
        'ぜんぶ',
        'ぜんぽう',
        'せんむ',
        'せんめんじょ',
        'せんもん',
        'せんやく',
        'せんゆう',
        'せんよう',
        'ぜんら',
        'ぜんりゃく',
        'せんれい',
        'せんろ',
        'そあく',
        'そいとげる',
        'そいね',
        'そうがんきょう',
        'そうき',
        'そうご',
        'そうしん',
        'そうだん',
        'そうなん',
        'そうび',
        'そうめん',
        'そうり',
        'そえもの',
        'そえん',
        'そがい',
        'そげき',
        'そこう',
        'そこそこ',
        'そざい',
        'そしな',
        'そせい',
        'そせん',
        'そそぐ',
        'そだてる',
        'そつう',
        'そつえん',
        'そっかん',
        'そつぎょう',
        'そっけつ',
        'そっこう',
        'そっせん',
        'そっと',
        'そとがわ',
        'そとづら',
        'そなえる',
        'そなた',
        'そふぼ',
        'そぼく',
        'そぼろ',
        'そまつ',
        'そまる',
        'そむく',
        'そむりえ',
        'そめる',
        'そもそも',
        'そよかぜ',
        'そらまめ',
        'そろう',
        'そんかい',
        'そんけい',
        'そんざい',
        'そんしつ',
        'そんぞく',
        'そんちょう',
        'ぞんび',
        'ぞんぶん',
        'そんみん',
        'たあい',
        'たいいん',
        'たいうん',
        'たいえき',
        'たいおう',
        'だいがく',
        'たいき',
        'たいぐう',
        'たいけん',
        'たいこ',
        'たいざい',
        'だいじょうぶ',
        'だいすき',
        'たいせつ',
        'たいそう',
        'だいたい',
        'たいちょう',
        'たいてい',
        'だいどころ',
        'たいない',
        'たいねつ',
        'たいのう',
        'たいはん',
        'だいひょう',
        'たいふう',
        'たいへん',
        'たいほ',
        'たいまつばな',
        'たいみんぐ',
        'たいむ',
        'たいめん',
        'たいやき',
        'たいよう',
        'たいら',
        'たいりょく',
        'たいる',
        'たいわん',
        'たうえ',
        'たえる',
        'たおす',
        'たおる',
        'たおれる',
        'たかい',
        'たかね',
        'たきび',
        'たくさん',
        'たこく',
        'たこやき',
        'たさい',
        'たしざん',
        'だじゃれ',
        'たすける',
        'たずさわる',
        'たそがれ',
        'たたかう',
        'たたく',
        'ただしい',
        'たたみ',
        'たちばな',
        'だっかい',
        'だっきゃく',
        'だっこ',
        'だっしゅつ',
        'だったい',
        'たてる',
        'たとえる',
        'たなばた',
        'たにん',
        'たぬき',
        'たのしみ',
        'たはつ',
        'たぶん',
        'たべる',
        'たぼう',
        'たまご',
        'たまる',
        'だむる',
        'ためいき',
        'ためす',
        'ためる',
        'たもつ',
        'たやすい',
        'たよる',
        'たらす',
        'たりきほんがん',
        'たりょう',
        'たりる',
        'たると',
        'たれる',
        'たれんと',
        'たろっと',
        'たわむれる',
        'だんあつ',
        'たんい',
        'たんおん',
        'たんか',
        'たんき',
        'たんけん',
        'たんご',
        'たんさん',
        'たんじょうび',
        'だんせい',
        'たんそく',
        'たんたい',
        'だんち',
        'たんてい',
        'たんとう',
        'だんな',
        'たんにん',
        'だんねつ',
        'たんのう',
        'たんぴん',
        'だんぼう',
        'たんまつ',
        'たんめい',
        'だんれつ',
        'だんろ',
        'だんわ',
        'ちあい',
        'ちあん',
        'ちいき',
        'ちいさい',
        'ちえん',
        'ちかい',
        'ちから',
        'ちきゅう',
        'ちきん',
        'ちけいず',
        'ちけん',
        'ちこく',
        'ちさい',
        'ちしき',
        'ちしりょう',
        'ちせい',
        'ちそう',
        'ちたい',
        'ちたん',
        'ちちおや',
        'ちつじょ',
        'ちてき',
        'ちてん',
        'ちぬき',
        'ちぬり',
        'ちのう',
        'ちひょう',
        'ちへいせん',
        'ちほう',
        'ちまた',
        'ちみつ',
        'ちみどろ',
        'ちめいど',
        'ちゃんこなべ',
        'ちゅうい',
        'ちゆりょく',
        'ちょうし',
        'ちょさくけん',
        'ちらし',
        'ちらみ',
        'ちりがみ',
        'ちりょう',
        'ちるど',
        'ちわわ',
        'ちんたい',
        'ちんもく',
        'ついか',
        'ついたち',
        'つうか',
        'つうじょう',
        'つうはん',
        'つうわ',
        'つかう',
        'つかれる',
        'つくね',
        'つくる',
        'つけね',
        'つける',
        'つごう',
        'つたえる',
        'つづく',
        'つつじ',
        'つつむ',
        'つとめる',
        'つながる',
        'つなみ',
        'つねづね',
        'つのる',
        'つぶす',
        'つまらない',
        'つまる',
        'つみき',
        'つめたい',
        'つもり',
        'つもる',
        'つよい',
        'つるぼ',
        'つるみく',
        'つわもの',
        'つわり',
        'てあし',
        'てあて',
        'てあみ',
        'ていおん',
        'ていか',
        'ていき',
        'ていけい',
        'ていこく',
        'ていさつ',
        'ていし',
        'ていせい',
        'ていたい',
        'ていど',
        'ていねい',
        'ていひょう',
        'ていへん',
        'ていぼう',
        'てうち',
        'ておくれ',
        'てきとう',
        'てくび',
        'でこぼこ',
        'てさぎょう',
        'てさげ',
        'てすり',
        'てそう',
        'てちがい',
        'てちょう',
        'てつがく',
        'てつづき',
        'でっぱ',
        'てつぼう',
        'てつや',
        'でぬかえ',
        'てぬき',
        'てぬぐい',
        'てのひら',
        'てはい',
        'てぶくろ',
        'てふだ',
        'てほどき',
        'てほん',
        'てまえ',
        'てまきずし',
        'てみじか',
        'てみやげ',
        'てらす',
        'てれび',
        'てわけ',
        'てわたし',
        'でんあつ',
        'てんいん',
        'てんかい',
        'てんき',
        'てんぐ',
        'てんけん',
        'てんごく',
        'てんさい',
        'てんし',
        'てんすう',
        'でんち',
        'てんてき',
        'てんとう',
        'てんない',
        'てんぷら',
        'てんぼうだい',
        'てんめつ',
        'てんらんかい',
        'でんりょく',
        'でんわ',
        'どあい',
        'といれ',
        'どうかん',
        'とうきゅう',
        'どうぐ',
        'とうし',
        'とうむぎ',
        'とおい',
        'とおか',
        'とおく',
        'とおす',
        'とおる',
        'とかい',
        'とかす',
        'ときおり',
        'ときどき',
        'とくい',
        'とくしゅう',
        'とくてん',
        'とくに',
        'とくべつ',
        'とけい',
        'とける',
        'とこや',
        'とさか',
        'としょかん',
        'とそう',
        'とたん',
        'とちゅう',
        'とっきゅう',
        'とっくん',
        'とつぜん',
        'とつにゅう',
        'とどける',
        'ととのえる',
        'とない',
        'となえる',
        'となり',
        'とのさま',
        'とばす',
        'どぶがわ',
        'とほう',
        'とまる',
        'とめる',
        'ともだち',
        'ともる',
        'どようび',
        'とらえる',
        'とんかつ',
        'どんぶり',
        'ないかく',
        'ないこう',
        'ないしょ',
        'ないす',
        'ないせん',
        'ないそう',
        'なおす',
        'ながい',
        'なくす',
        'なげる',
        'なこうど',
        'なさけ',
        'なたでここ',
        'なっとう',
        'なつやすみ',
        'ななおし',
        'なにごと',
        'なにもの',
        'なにわ',
        'なのか',
        'なふだ',
        'なまいき',
        'なまえ',
        'なまみ',
        'なみだ',
        'なめらか',
        'なめる',
        'なやむ',
        'ならう',
        'ならび',
        'ならぶ',
        'なれる',
        'なわとび',
        'なわばり',
        'にあう',
        'にいがた',
        'にうけ',
        'におい',
        'にかい',
        'にがて',
        'にきび',
        'にくしみ',
        'にくまん',
        'にげる',
        'にさんかたんそ',
        'にしき',
        'にせもの',
        'にちじょう',
        'にちようび',
        'にっか',
        'にっき',
        'にっけい',
        'にっこう',
        'にっさん',
        'にっしょく',
        'にっすう',
        'にっせき',
        'にってい',
        'になう',
        'にほん',
        'にまめ',
        'にもつ',
        'にやり',
        'にゅういん',
        'にりんしゃ',
        'にわとり',
        'にんい',
        'にんか',
        'にんき',
        'にんげん',
        'にんしき',
        'にんずう',
        'にんそう',
        'にんたい',
        'にんち',
        'にんてい',
        'にんにく',
        'にんぷ',
        'にんまり',
        'にんむ',
        'にんめい',
        'にんよう',
        'ぬいくぎ',
        'ぬかす',
        'ぬぐいとる',
        'ぬぐう',
        'ぬくもり',
        'ぬすむ',
        'ぬまえび',
        'ぬめり',
        'ぬらす',
        'ぬんちゃく',
        'ねあげ',
        'ねいき',
        'ねいる',
        'ねいろ',
        'ねぐせ',
        'ねくたい',
        'ねくら',
        'ねこぜ',
        'ねこむ',
        'ねさげ',
        'ねすごす',
        'ねそべる',
        'ねだん',
        'ねつい',
        'ねっしん',
        'ねつぞう',
        'ねったいぎょ',
        'ねぶそく',
        'ねふだ',
        'ねぼう',
        'ねほりはほり',
        'ねまき',
        'ねまわし',
        'ねみみ',
        'ねむい',
        'ねむたい',
        'ねもと',
        'ねらう',
        'ねわざ',
        'ねんいり',
        'ねんおし',
        'ねんかん',
        'ねんきん',
        'ねんぐ',
        'ねんざ',
        'ねんし',
        'ねんちゃく',
        'ねんど',
        'ねんぴ',
        'ねんぶつ',
        'ねんまつ',
        'ねんりょう',
        'ねんれい',
        'のいず',
        'のおづま',
        'のがす',
        'のきなみ',
        'のこぎり',
        'のこす',
        'のこる',
        'のせる',
        'のぞく',
        'のぞむ',
        'のたまう',
        'のちほど',
        'のっく',
        'のばす',
        'のはら',
        'のべる',
        'のぼる',
        'のみもの',
        'のやま',
        'のらいぬ',
        'のらねこ',
        'のりもの',
        'のりゆき',
        'のれん',
        'のんき',
        'ばあい',
        'はあく',
        'ばあさん',
        'ばいか',
        'ばいく',
        'はいけん',
        'はいご',
        'はいしん',
        'はいすい',
        'はいせん',
        'はいそう',
        'はいち',
        'ばいばい',
        'はいれつ',
        'はえる',
        'はおる',
        'はかい',
        'ばかり',
        'はかる',
        'はくしゅ',
        'はけん',
        'はこぶ',
        'はさみ',
        'はさん',
        'はしご',
        'ばしょ',
        'はしる',
        'はせる',
        'ぱそこん',
        'はそん',
        'はたん',
        'はちみつ',
        'はつおん',
        'はっかく',
        'はづき',
        'はっきり',
        'はっくつ',
        'はっけん',
        'はっこう',
        'はっさん',
        'はっしん',
        'はったつ',
        'はっちゅう',
        'はってん',
        'はっぴょう',
        'はっぽう',
        'はなす',
        'はなび',
        'はにかむ',
        'はぶらし',
        'はみがき',
        'はむかう',
        'はめつ',
        'はやい',
        'はやし',
        'はらう',
        'はろうぃん',
        'はわい',
        'はんい',
        'はんえい',
        'はんおん',
        'はんかく',
        'はんきょう',
        'ばんぐみ',
        'はんこ',
        'はんしゃ',
        'はんすう',
        'はんだん',
        'ぱんち',
        'ぱんつ',
        'はんてい',
        'はんとし',
        'はんのう',
        'はんぱ',
        'はんぶん',
        'はんぺん',
        'はんぼうき',
        'はんめい',
        'はんらん',
        'はんろん',
        'ひいき',
        'ひうん',
        'ひえる',
        'ひかく',
        'ひかり',
        'ひかる',
        'ひかん',
        'ひくい',
        'ひけつ',
        'ひこうき',
        'ひこく',
        'ひさい',
        'ひさしぶり',
        'ひさん',
        'びじゅつかん',
        'ひしょ',
      ])
    );
    langs.push(
      new MnemonicLang('french', 'fr', 4, [
        'abandon',
        'abattre',
        'aboi',
        'abolir',
        'aborder',
        'abri',
        'absence',
        'absolu',
        'abuser',
        'acacia',
        'acajou',
        'accent',
        'accord',
        'accrocher',
        'accuser',
        'acerbe',
        'achat',
        'acheter',
        'acide',
        'acier',
        'acquis',
        'acte',
        'action',
        'adage',
        'adepte',
        'adieu',
        'admettre',
        'admis',
        'adorer',
        'adresser',
        'aduler',
        'affaire',
        'affirmer',
        'afin',
        'agacer',
        'agent',
        'agir',
        'agiter',
        'agonie',
        'agrafe',
        'agrume',
        'aider',
        'aigle',
        'aigre',
        'aile',
        'ailleurs',
        'aimant',
        'aimer',
        'ainsi',
        'aise',
        'ajouter',
        'alarme',
        'album',
        'alcool',
        'alerte',
        'algue',
        'alibi',
        'aller',
        'allumer',
        'alors',
        'amande',
        'amener',
        'amie',
        'amorcer',
        'amour',
        'ample',
        'amuser',
        'ananas',
        'ancien',
        'anglais',
        'angoisse',
        'animal',
        'anneau',
        'annoncer',
        'apercevoir',
        'apparence',
        'appel',
        'apporter',
        'apprendre',
        'appuyer',
        'arbre',
        'arcade',
        'arceau',
        'arche',
        'ardeur',
        'argent',
        'argile',
        'aride',
        'arme',
        'armure',
        'arracher',
        'arriver',
        'article',
        'asile',
        'aspect',
        'assaut',
        'assez',
        'assister',
        'assurer',
        'astre',
        'astuce',
        'atlas',
        'atroce',
        'attacher',
        'attente',
        'attirer',
        'aube',
        'aucun',
        'audace',
        'auparavant',
        'auquel',
        'aurore',
        'aussi',
        'autant',
        'auteur',
        'autoroute',
        'autre',
        'aval',
        'avant',
        'avec',
        'avenir',
        'averse',
        'aveu',
        'avide',
        'avion',
        'avis',
        'avoir',
        'avouer',
        'avril',
        'azote',
        'azur',
        'badge',
        'bagage',
        'bague',
        'bain',
        'baisser',
        'balai',
        'balcon',
        'balise',
        'balle',
        'bambou',
        'banane',
        'banc',
        'bandage',
        'banjo',
        'banlieue',
        'bannir',
        'banque',
        'baobab',
        'barbe',
        'barque',
        'barrer',
        'bassine',
        'bataille',
        'bateau',
        'battre',
        'baver',
        'bavoir',
        'bazar',
        'beau',
        'beige',
        'berger',
        'besoin',
        'beurre',
        'biais',
        'biceps',
        'bidule',
        'bien',
        'bijou',
        'bilan',
        'billet',
        'blanc',
        'blason',
        'bleu',
        'bloc',
        'blond',
        'bocal',
        'boire',
        'boiserie',
        'boiter',
        'bonbon',
        'bondir',
        'bonheur',
        'bordure',
        'borgne',
        'borner',
        'bosse',
        'bouche',
        'bouder',
        'bouger',
        'boule',
        'bourse',
        'bout',
        'boxe',
        'brader',
        'braise',
        'branche',
        'braquer',
        'bras',
        'brave',
        'brebis',
        'brevet',
        'brider',
        'briller',
        'brin',
        'brique',
        'briser',
        'broche',
        'broder',
        'bronze',
        'brosser',
        'brouter',
        'bruit',
        'brute',
        'budget',
        'buffet',
        'bulle',
        'bureau',
        'buriner',
        'buste',
        'buter',
        'butiner',
        'cabas',
        'cabinet',
        'cabri',
        'cacao',
        'cacher',
        'cadeau',
        'cadre',
        'cage',
        'caisse',
        'caler',
        'calme',
        'camarade',
        'camion',
        'campagne',
        'canal',
        'canif',
        'capable',
        'capot',
        'carat',
        'caresser',
        'carie',
        'carpe',
        'cartel',
        'casier',
        'casque',
        'casserole',
        'cause',
        'cavale',
        'cave',
        'ceci',
        'cela',
        'celui',
        'cendre',
        'cent',
        'cependant',
        'cercle',
        'cerise',
        'cerner',
        'certes',
        'cerveau',
        'cesser',
        'chacun',
        'chair',
        'chaleur',
        'chamois',
        'chanson',
        'chaque',
        'charge',
        'chasse',
        'chat',
        'chaud',
        'chef',
        'chemin',
        'cheveu',
        'chez',
        'chicane',
        'chien',
        'chiffre',
        'chiner',
        'chiot',
        'chlore',
        'choc',
        'choix',
        'chose',
        'chou',
        'chute',
        'cibler',
        'cidre',
        'ciel',
        'cigale',
        'cinq',
        'cintre',
        'cirage',
        'cirque',
        'ciseau',
        'citation',
        'citer',
        'citron',
        'civet',
        'clairon',
        'clan',
        'classe',
        'clavier',
        'clef',
        'climat',
        'cloche',
        'cloner',
        'clore',
        'clos',
        'clou',
        'club',
        'cobra',
        'cocon',
        'coiffer',
        'coin',
        'colline',
        'colon',
        'combat',
        'comme',
        'compte',
        'conclure',
        'conduire',
        'confier',
        'connu',
        'conseil',
        'contre',
        'convenir',
        'copier',
        'cordial',
        'cornet',
        'corps',
        'cosmos',
        'coton',
        'couche',
        'coude',
        'couler',
        'coupure',
        'cour',
        'couteau',
        'couvrir',
        'crabe',
        'crainte',
        'crampe',
        'cran',
        'creuser',
        'crever',
        'crier',
        'crime',
        'crin',
        'crise',
        'crochet',
        'croix',
        'cruel',
        'cuisine',
        'cuite',
        'culot',
        'culte',
        'cumul',
        'cure',
        'curieux',
        'cuve',
        'dame',
        'danger',
        'dans',
        'davantage',
        'debout',
        'dedans',
        'dehors',
        'delta',
        'demain',
        'demeurer',
        'demi',
        'dense',
        'dent',
        'depuis',
        'dernier',
        'descendre',
        'dessus',
        'destin',
        'dette',
        'deuil',
        'deux',
        'devant',
        'devenir',
        'devin',
        'devoir',
        'dicton',
        'dieu',
        'difficile',
        'digestion',
        'digue',
        'diluer',
        'dimanche',
        'dinde',
        'diode',
        'dire',
        'diriger',
        'discours',
        'disposer',
        'distance',
        'divan',
        'divers',
        'docile',
        'docteur',
        'dodu',
        'dogme',
        'doigt',
        'dominer',
        'donation',
        'donjon',
        'donner',
        'dopage',
        'dorer',
        'dormir',
        'doseur',
        'douane',
        'double',
        'douche',
        'douleur',
        'doute',
        'doux',
        'douzaine',
        'draguer',
        'drame',
        'drap',
        'dresser',
        'droit',
        'duel',
        'dune',
        'duper',
        'durant',
        'durcir',
        'durer',
        'eaux',
        'effacer',
        'effet',
        'effort',
        'effrayant',
        'elle',
        'embrasser',
        'emmener',
        'emparer',
        'empire',
        'employer',
        'emporter',
        'enclos',
        'encore',
        'endive',
        'endormir',
        'endroit',
        'enduit',
        'enfant',
        'enfermer',
        'enfin',
        'enfler',
        'enfoncer',
        'enfuir',
        'engager',
        'engin',
        'enjeu',
        'enlever',
        'ennemi',
        'ennui',
        'ensemble',
        'ensuite',
        'entamer',
        'entendre',
        'entier',
        'entourer',
        'entre',
        'envelopper',
        'envie',
        'envoyer',
        'erreur',
        'escalier',
        'espace',
        'espoir',
        'esprit',
        'essai',
        'essor',
        'essuyer',
        'estimer',
        'exact',
        'examiner',
        'excuse',
        'exemple',
        'exiger',
        'exil',
        'exister',
        'exode',
        'expliquer',
        'exposer',
        'exprimer',
        'extase',
        'fable',
        'facette',
        'facile',
        'fade',
        'faible',
        'faim',
        'faire',
        'fait',
        'falloir',
        'famille',
        'faner',
        'farce',
        'farine',
        'fatigue',
        'faucon',
        'faune',
        'faute',
        'faux',
        'faveur',
        'favori',
        'faxer',
        'feinter',
        'femme',
        'fendre',
        'fente',
        'ferme',
        'festin',
        'feuille',
        'feutre',
        'fiable',
        'fibre',
        'ficher',
        'fier',
        'figer',
        'figure',
        'filet',
        'fille',
        'filmer',
        'fils',
        'filtre',
        'final',
        'finesse',
        'finir',
        'fiole',
        'firme',
        'fixe',
        'flacon',
        'flair',
        'flamme',
        'flan',
        'flaque',
        'fleur',
        'flocon',
        'flore',
        'flot',
        'flou',
        'fluide',
        'fluor',
        'flux',
        'focus',
        'foin',
        'foire',
        'foison',
        'folie',
        'fonction',
        'fondre',
        'fonte',
        'force',
        'forer',
        'forger',
        'forme',
        'fort',
        'fosse',
        'fouet',
        'fouine',
        'foule',
        'four',
        'foyer',
        'frais',
        'franc',
        'frapper',
        'freiner',
        'frimer',
        'friser',
        'frite',
        'froid',
        'froncer',
        'fruit',
        'fugue',
        'fuir',
        'fuite',
        'fumer',
        'fureur',
        'furieux',
        'fuser',
        'fusil',
        'futile',
        'futur',
        'gagner',
        'gain',
        'gala',
        'galet',
        'galop',
        'gamme',
        'gant',
        'garage',
        'garde',
        'garer',
        'gauche',
        'gaufre',
        'gaule',
        'gaver',
        'gazon',
        'geler',
        'genou',
        'genre',
        'gens',
        'gercer',
        'germer',
        'geste',
        'gibier',
        'gicler',
        'gilet',
        'girafe',
        'givre',
        'glace',
        'glisser',
        'globe',
        'gloire',
        'gluant',
        'gober',
        'golf',
        'gommer',
        'gorge',
        'gosier',
        'goutte',
        'grain',
        'gramme',
        'grand',
        'gras',
        'grave',
        'gredin',
        'griffure',
        'griller',
        'gris',
        'gronder',
        'gros',
        'grotte',
        'groupe',
        'grue',
        'guerrier',
        'guetter',
        'guider',
        'guise',
        'habiter',
        'hache',
        'haie',
        'haine',
        'halte',
        'hamac',
        'hanche',
        'hangar',
        'hanter',
        'haras',
        'hareng',
        'harpe',
        'hasard',
        'hausse',
        'haut',
        'havre',
        'herbe',
        'heure',
        'hibou',
        'hier',
        'histoire',
        'hiver',
        'hochet',
        'homme',
        'honneur',
        'honte',
        'horde',
        'horizon',
        'hormone',
        'houle',
        'housse',
        'hublot',
        'huile',
        'huit',
        'humain',
        'humble',
        'humide',
        'humour',
        'hurler',
        'idole',
        'igloo',
        'ignorer',
        'illusion',
        'image',
        'immense',
        'immobile',
        'imposer',
        'impression',
        'incapable',
        'inconnu',
        'index',
        'indiquer',
        'infime',
        'injure',
        'inox',
        'inspirer',
        'instant',
        'intention',
        'intime',
        'inutile',
        'inventer',
        'inviter',
        'iode',
        'iris',
        'issue',
        'ivre',
        'jade',
        'jadis',
        'jamais',
        'jambe',
        'janvier',
        'jardin',
        'jauge',
        'jaunisse',
        'jeter',
        'jeton',
        'jeudi',
        'jeune',
        'joie',
        'joindre',
        'joli',
        'joueur',
        'journal',
        'judo',
        'juge',
        'juillet',
        'juin',
        'jument',
        'jungle',
        'jupe',
        'jupon',
        'jurer',
        'juron',
        'jury',
        'jusque',
        'juste',
        'kayak',
        'ketchup',
        'kilo',
        'kiwi',
        'koala',
        'label',
        'lacet',
        'lacune',
        'laine',
        'laisse',
        'lait',
        'lame',
        'lancer',
        'lande',
        'laque',
        'lard',
        'largeur',
        'larme',
        'larve',
        'lasso',
        'laver',
        'lendemain',
        'lentement',
        'lequel',
        'lettre',
        'leur',
        'lever',
        'levure',
        'liane',
        'libre',
        'lien',
        'lier',
        'lieutenant',
        'ligne',
        'ligoter',
        'liguer',
        'limace',
        'limer',
        'limite',
        'lingot',
        'lion',
        'lire',
        'lisser',
        'litre',
        'livre',
        'lobe',
        'local',
        'logis',
        'loin',
        'loisir',
        'long',
        'loque',
        'lors',
        'lotus',
        'louer',
        'loup',
        'lourd',
        'louve',
        'loyer',
        'lubie',
        'lucide',
        'lueur',
        'luge',
        'luire',
        'lundi',
        'lune',
        'lustre',
        'lutin',
        'lutte',
        'luxe',
        'machine',
        'madame',
        'magie',
        'magnifique',
        'magot',
        'maigre',
        'main',
        'mairie',
        'maison',
        'malade',
        'malheur',
        'malin',
        'manche',
        'manger',
        'manier',
        'manoir',
        'manquer',
        'marche',
        'mardi',
        'marge',
        'mariage',
        'marquer',
        'mars',
        'masque',
        'masse',
        'matin',
        'mauvais',
        'meilleur',
        'melon',
        'membre',
        'menacer',
        'mener',
        'mensonge',
        'mentir',
        'menu',
        'merci',
        'merlu',
        'mesure',
        'mettre',
        'meuble',
        'meunier',
        'meute',
        'miche',
        'micro',
        'midi',
        'miel',
        'miette',
        'mieux',
        'milieu',
        'mille',
        'mimer',
        'mince',
        'mineur',
        'ministre',
        'minute',
        'mirage',
        'miroir',
        'miser',
        'mite',
        'mixte',
        'mobile',
        'mode',
        'module',
        'moins',
        'mois',
        'moment',
        'momie',
        'monde',
        'monsieur',
        'monter',
        'moquer',
        'moral',
        'morceau',
        'mordre',
        'morose',
        'morse',
        'mortier',
        'morue',
        'motif',
        'motte',
        'moudre',
        'moule',
        'mourir',
        'mousse',
        'mouton',
        'mouvement',
        'moyen',
        'muer',
        'muette',
        'mugir',
        'muguet',
        'mulot',
        'multiple',
        'munir',
        'muret',
        'muse',
        'musique',
        'muter',
        'nacre',
        'nager',
        'nain',
        'naissance',
        'narine',
        'narrer',
        'naseau',
        'nasse',
        'nation',
        'nature',
        'naval',
        'navet',
        'naviguer',
        'navrer',
        'neige',
        'nerf',
        'nerveux',
        'neuf',
        'neutre',
        'neuve',
        'neveu',
        'niche',
        'nier',
        'niveau',
        'noble',
        'noce',
        'nocif',
        'noir',
        'nomade',
        'nombre',
        'nommer',
        'nord',
        'norme',
        'notaire',
        'notice',
        'notre',
        'nouer',
        'nougat',
        'nourrir',
        'nous',
        'nouveau',
        'novice',
        'noyade',
        'noyer',
        'nuage',
        'nuance',
        'nuire',
        'nuit',
        'nulle',
        'nuque',
        'oasis',
        'objet',
        'obliger',
        'obscur',
        'observer',
        'obtenir',
        'obus',
        'occasion',
        'occuper',
        'ocre',
        'octet',
        'odeur',
        'odorat',
        'offense',
        'officier',
        'offrir',
        'ogive',
        'oiseau',
        'olive',
        'ombre',
        'onctueux',
        'onduler',
        'ongle',
        'onze',
        'opter',
        'option',
        'orageux',
        'oral',
        'orange',
        'orbite',
        'ordinaire',
        'ordre',
        'oreille',
        'organe',
        'orgie',
        'orgueil',
        'orient',
        'origan',
        'orner',
        'orteil',
        'ortie',
        'oser',
        'osselet',
        'otage',
        'otarie',
        'ouate',
        'oublier',
        'ouest',
        'ours',
        'outil',
        'outre',
        'ouvert',
        'ouvrir',
        'ovale',
        'ozone',
        'pacte',
        'page',
        'paille',
        'pain',
        'paire',
        'paix',
        'palace',
        'palissade',
        'palmier',
        'palpiter',
        'panda',
        'panneau',
        'papa',
        'papier',
        'paquet',
        'parc',
        'pardi',
        'parfois',
        'parler',
        'parmi',
        'parole',
        'partir',
        'parvenir',
        'passer',
        'pastel',
        'patin',
        'patron',
        'paume',
        'pause',
        'pauvre',
        'paver',
        'pavot',
        'payer',
        'pays',
        'peau',
        'peigne',
        'peinture',
        'pelage',
        'pelote',
        'pencher',
        'pendre',
        'penser',
        'pente',
        'percer',
        'perdu',
        'perle',
        'permettre',
        'personne',
        'perte',
        'peser',
        'pesticide',
        'petit',
        'peuple',
        'peur',
        'phase',
        'photo',
        'phrase',
        'piano',
        'pied',
        'pierre',
        'pieu',
        'pile',
        'pilier',
        'pilote',
        'pilule',
        'piment',
        'pincer',
        'pinson',
        'pinte',
        'pion',
        'piquer',
        'pirate',
        'pire',
        'piste',
        'piton',
        'pitre',
        'pivot',
        'pizza',
        'placer',
        'plage',
        'plaire',
        'plan',
        'plaque',
        'plat',
        'plein',
        'pleurer',
        'pliage',
        'plier',
        'plonger',
        'plot',
        'pluie',
        'plume',
        'plus',
        'pneu',
        'poche',
        'podium',
        'poids',
        'poil',
        'point',
        'poire',
        'poison',
        'poitrine',
        'poivre',
        'police',
        'pollen',
        'pomme',
        'pompier',
        'poncer',
        'pondre',
        'pont',
        'portion',
        'poser',
        'position',
        'possible',
        'poste',
        'potage',
        'potin',
        'pouce',
        'poudre',
        'poulet',
        'poumon',
        'poupe',
        'pour',
        'pousser',
        'poutre',
        'pouvoir',
        'prairie',
        'premier',
        'prendre',
        'presque',
        'preuve',
        'prier',
        'primeur',
        'prince',
        'prison',
        'priver',
        'prix',
        'prochain',
        'produire',
        'profond',
        'proie',
        'projet',
        'promener',
        'prononcer',
        'propre',
        'prose',
        'prouver',
        'prune',
        'public',
        'puce',
        'pudeur',
        'puiser',
        'pull',
        'pulpe',
        'puma',
        'punir',
        'purge',
        'putois',
        'quand',
        'quartier',
        'quasi',
        'quatre',
        'quel',
        'question',
        'queue',
        'quiche',
        'quille',
        'quinze',
        'quitter',
        'quoi',
        'rabais',
        'raboter',
        'race',
        'racheter',
        'racine',
        'racler',
        'raconter',
        'radar',
        'radio',
        'rafale',
        'rage',
        'ragot',
        'raideur',
        'raie',
        'rail',
        'raison',
        'ramasser',
        'ramener',
        'rampe',
        'rance',
        'rang',
        'rapace',
        'rapide',
        'rapport',
        'rarement',
        'rasage',
        'raser',
        'rasoir',
        'rassurer',
        'rater',
        'ratio',
        'rature',
        'ravage',
        'ravir',
        'rayer',
        'rayon',
        'rebond',
        'recevoir',
        'recherche',
        'record',
        'reculer',
        'redevenir',
        'refuser',
        'regard',
        'regretter',
        'rein',
        'rejeter',
        'rejoindre',
        'relation',
        'relever',
        'religion',
        'remarquer',
        'remettre',
        'remise',
        'remonter',
        'remplir',
        'remuer',
        'rencontre',
        'rendre',
        'renier',
        'renoncer',
        'rentrer',
        'renverser',
        'repas',
        'repli',
        'reposer',
        'reproche',
        'requin',
        'respect',
        'ressembler',
        'reste',
        'retard',
        'retenir',
        'retirer',
        'retour',
        'retrouver',
        'revenir',
        'revoir',
        'revue',
        'rhume',
        'ricaner',
        'riche',
        'rideau',
        'ridicule',
        'rien',
        'rigide',
        'rincer',
        'rire',
        'risquer',
        'rituel',
        'rivage',
        'rive',
        'robe',
        'robot',
        'robuste',
        'rocade',
        'roche',
        'rodeur',
        'rogner',
        'roman',
        'rompre',
        'ronce',
        'rondeur',
        'ronger',
        'roque',
        'rose',
        'rosir',
        'rotation',
        'rotule',
        'roue',
        'rouge',
        'rouler',
        'route',
        'ruban',
        'rubis',
        'ruche',
        'rude',
        'ruelle',
        'ruer',
        'rugby',
        'rugir',
        'ruine',
        'rumeur',
        'rural',
        'ruse',
        'rustre',
        'sable',
        'sabot',
        'sabre',
        'sacre',
        'sage',
        'saint',
        'saisir',
        'salade',
        'salive',
        'salle',
        'salon',
        'salto',
        'salut',
        'salve',
        'samba',
        'sandale',
        'sanguin',
        'sapin',
        'sarcasme',
        'satisfaire',
        'sauce',
        'sauf',
        'sauge',
        'saule',
        'sauna',
        'sauter',
        'sauver',
        'savoir',
        'science',
        'scoop',
        'score',
        'second',
        'secret',
        'secte',
        'seigneur',
        'sein',
        'seize',
        'selle',
        'selon',
        'semaine',
        'sembler',
        'semer',
        'semis',
        'sensuel',
        'sentir',
        'sept',
        'serpe',
        'serrer',
        'sertir',
        'service',
        'seuil',
        'seulement',
        'short',
        'sien',
        'sigle',
        'signal',
        'silence',
        'silo',
        'simple',
        'singe',
        'sinon',
        'sinus',
        'sioux',
        'sirop',
        'site',
        'situation',
        'skier',
        'snob',
        'sobre',
        'social',
        'socle',
        'sodium',
        'soigner',
        'soir',
        'soixante',
        'soja',
        'solaire',
        'soldat',
        'soleil',
        'solide',
        'solo',
        'solvant',
        'sombre',
        'somme',
        'somnoler',
        'sondage',
        'songeur',
        'sonner',
        'sorte',
        'sosie',
        'sottise',
        'souci',
        'soudain',
        'souffrir',
        'souhaiter',
        'soulever',
        'soumettre',
        'soupe',
        'sourd',
        'soustraire',
        'soutenir',
        'souvent',
        'soyeux',
        'spectacle',
        'sport',
        'stade',
        'stagiaire',
        'stand',
        'star',
        'statue',
        'stock',
        'stop',
        'store',
        'style',
        'suave',
        'subir',
        'sucre',
        'suer',
        'suffire',
        'suie',
        'suite',
        'suivre',
        'sujet',
        'sulfite',
        'supposer',
        'surf',
        'surprendre',
        'surtout',
        'surveiller',
        'tabac',
        'table',
        'tabou',
        'tache',
        'tacler',
        'tacot',
        'tact',
        'taie',
        'taille',
        'taire',
        'talon',
        'talus',
        'tandis',
        'tango',
        'tanin',
        'tant',
        'taper',
        'tapis',
        'tard',
        'tarif',
        'tarot',
        'tarte',
        'tasse',
        'taureau',
        'taux',
        'taverne',
        'taxer',
        'taxi',
        'tellement',
        'temple',
        'tendre',
        'tenir',
        'tenter',
        'tenu',
        'terme',
        'ternir',
        'terre',
        'test',
        'texte',
        'thym',
        'tibia',
        'tiers',
        'tige',
        'tipi',
        'tique',
        'tirer',
        'tissu',
        'titre',
        'toast',
        'toge',
        'toile',
        'toiser',
        'toiture',
        'tomber',
        'tome',
        'tonne',
        'tonte',
        'toque',
        'torse',
        'tortue',
        'totem',
        'toucher',
        'toujours',
        'tour',
        'tousser',
        'tout',
        'toux',
        'trace',
        'train',
        'trame',
        'tranquille',
        'travail',
        'trembler',
        'trente',
        'tribu',
        'trier',
        'trio',
        'tripe',
        'triste',
        'troc',
        'trois',
        'tromper',
        'tronc',
        'trop',
        'trotter',
        'trouer',
        'truc',
        'truite',
        'tuba',
        'tuer',
        'tuile',
        'turbo',
        'tutu',
        'tuyau',
        'type',
        'union',
        'unique',
        'unir',
        'unisson',
        'untel',
        'urne',
        'usage',
        'user',
        'usiner',
        'usure',
        'utile',
        'vache',
        'vague',
        'vaincre',
        'valeur',
        'valoir',
        'valser',
        'valve',
        'vampire',
        'vaseux',
        'vaste',
        'veau',
        'veille',
        'veine',
        'velours',
        'velu',
        'vendre',
        'venir',
        'vent',
        'venue',
        'verbe',
        'verdict',
        'version',
        'vertige',
        'verve',
        'veste',
        'veto',
        'vexer',
        'vice',
        'victime',
        'vide',
        'vieil',
        'vieux',
        'vigie',
        'vigne',
        'ville',
        'vingt',
        'violent',
        'virer',
        'virus',
        'visage',
        'viser',
        'visite',
        'visuel',
        'vitamine',
        'vitrine',
        'vivant',
        'vivre',
        'vocal',
        'vodka',
        'vogue',
        'voici',
        'voile',
        'voir',
        'voisin',
        'voiture',
        'volaille',
        'volcan',
        'voler',
        'volt',
        'votant',
        'votre',
        'vouer',
        'vouloir',
        'vous',
        'voyage',
        'voyou',
        'vrac',
        'vrai',
        'yacht',
        'yeti',
        'yeux',
        'yoga',
        'zeste',
        'zinc',
        'zone',
        'zoom',
      ])
    );
    langs.push(
      new MnemonicLang('german', 'de', 4, [
        'Abakus',
        'Abart',
        'abbilden',
        'Abbruch',
        'Abdrift',
        'Abendrot',
        'Abfahrt',
        'abfeuern',
        'Abflug',
        'abfragen',
        'Abglanz',
        'abhärten',
        'abheben',
        'Abhilfe',
        'Abitur',
        'Abkehr',
        'Ablauf',
        'ablecken',
        'Ablösung',
        'Abnehmer',
        'abnutzen',
        'Abonnent',
        'Abrasion',
        'Abrede',
        'abrüsten',
        'Absicht',
        'Absprung',
        'Abstand',
        'absuchen',
        'Abteil',
        'Abundanz',
        'abwarten',
        'Abwurf',
        'Abzug',
        'Achse',
        'Achtung',
        'Acker',
        'Aderlass',
        'Adler',
        'Admiral',
        'Adresse',
        'Affe',
        'Affront',
        'Afrika',
        'Aggregat',
        'Agilität',
        'ähneln',
        'Ahnung',
        'Ahorn',
        'Akazie',
        'Akkord',
        'Akrobat',
        'Aktfoto',
        'Aktivist',
        'Albatros',
        'Alchimie',
        'Alemanne',
        'Alibi',
        'Alkohol',
        'Allee',
        'Allüre',
        'Almosen',
        'Almweide',
        'Aloe',
        'Alpaka',
        'Alpental',
        'Alphabet',
        'Alpinist',
        'Alraune',
        'Altbier',
        'Alter',
        'Altflöte',
        'Altruist',
        'Alublech',
        'Aludose',
        'Amateur',
        'Amazonas',
        'Ameise',
        'Amnesie',
        'Amok',
        'Ampel',
        'Amphibie',
        'Ampulle',
        'Amsel',
        'Amulett',
        'Anakonda',
        'Analogie',
        'Ananas',
        'Anarchie',
        'Anatomie',
        'Anbau',
        'Anbeginn',
        'anbieten',
        'Anblick',
        'ändern',
        'andocken',
        'Andrang',
        'anecken',
        'Anflug',
        'Anfrage',
        'Anführer',
        'Angebot',
        'Angler',
        'Anhalter',
        'Anhöhe',
        'Animator',
        'Anis',
        'Anker',
        'ankleben',
        'Ankunft',
        'Anlage',
        'anlocken',
        'Anmut',
        'Annahme',
        'Anomalie',
        'Anonymus',
        'Anorak',
        'anpeilen',
        'Anrecht',
        'Anruf',
        'Ansage',
        'Anschein',
        'Ansicht',
        'Ansporn',
        'Anteil',
        'Antlitz',
        'Antrag',
        'Antwort',
        'Anwohner',
        'Aorta',
        'Apfel',
        'Appetit',
        'Applaus',
        'Aquarium',
        'Arbeit',
        'Arche',
        'Argument',
        'Arktis',
        'Armband',
        'Aroma',
        'Asche',
        'Askese',
        'Asphalt',
        'Asteroid',
        'Ästhetik',
        'Astronom',
        'Atelier',
        'Athlet',
        'Atlantik',
        'Atmung',
        'Audienz',
        'aufatmen',
        'Auffahrt',
        'aufholen',
        'aufregen',
        'Aufsatz',
        'Auftritt',
        'Aufwand',
        'Augapfel',
        'Auktion',
        'Ausbruch',
        'Ausflug',
        'Ausgabe',
        'Aushilfe',
        'Ausland',
        'Ausnahme',
        'Aussage',
        'Autobahn',
        'Avocado',
        'Axthieb',
        'Bach',
        'backen',
        'Badesee',
        'Bahnhof',
        'Balance',
        'Balkon',
        'Ballett',
        'Balsam',
        'Banane',
        'Bandage',
        'Bankett',
        'Barbar',
        'Barde',
        'Barett',
        'Bargeld',
        'Barkasse',
        'Barriere',
        'Bart',
        'Bass',
        'Bastler',
        'Batterie',
        'Bauch',
        'Bauer',
        'Bauholz',
        'Baujahr',
        'Baum',
        'Baustahl',
        'Bauteil',
        'Bauweise',
        'Bazar',
        'beachten',
        'Beatmung',
        'beben',
        'Becher',
        'Becken',
        'bedanken',
        'beeilen',
        'beenden',
        'Beere',
        'befinden',
        'Befreier',
        'Begabung',
        'Begierde',
        'begrüßen',
        'Beiboot',
        'Beichte',
        'Beifall',
        'Beigabe',
        'Beil',
        'Beispiel',
        'Beitrag',
        'beizen',
        'bekommen',
        'beladen',
        'Beleg',
        'bellen',
        'belohnen',
        'Bemalung',
        'Bengel',
        'Benutzer',
        'Benzin',
        'beraten',
        'Bereich',
        'Bergluft',
        'Bericht',
        'Bescheid',
        'Besitz',
        'besorgen',
        'Bestand',
        'Besuch',
        'betanken',
        'beten',
        'betören',
        'Bett',
        'Beule',
        'Beute',
        'Bewegung',
        'bewirken',
        'Bewohner',
        'bezahlen',
        'Bezug',
        'biegen',
        'Biene',
        'Bierzelt',
        'bieten',
        'Bikini',
        'Bildung',
        'Billard',
        'binden',
        'Biobauer',
        'Biologe',
        'Bionik',
        'Biotop',
        'Birke',
        'Bison',
        'Bitte',
        'Biwak',
        'Bizeps',
        'blasen',
        'Blatt',
        'Blauwal',
        'Blende',
        'Blick',
        'Blitz',
        'Blockade',
        'Blödelei',
        'Blondine',
        'Blues',
        'Blume',
        'Blut',
        'Bodensee',
        'Bogen',
        'Boje',
        'Bollwerk',
        'Bonbon',
        'Bonus',
        'Boot',
        'Bordarzt',
        'Börse',
        'Böschung',
        'Boudoir',
        'Boxkampf',
        'Boykott',
        'Brahms',
        'Brandung',
        'Brauerei',
        'Brecher',
        'Breitaxt',
        'Bremse',
        'brennen',
        'Brett',
        'Brief',
        'Brigade',
        'Brillanz',
        'bringen',
        'brodeln',
        'Brosche',
        'Brötchen',
        'Brücke',
        'Brunnen',
        'Brüste',
        'Brutofen',
        'Buch',
        'Büffel',
        'Bugwelle',
        'Bühne',
        'Buletten',
        'Bullauge',
        'Bumerang',
        'bummeln',
        'Buntglas',
        'Bürde',
        'Burgherr',
        'Bursche',
        'Busen',
        'Buslinie',
        'Bussard',
        'Butangas',
        'Butter',
        'Cabrio',
        'campen',
        'Captain',
        'Cartoon',
        'Cello',
        'Chalet',
        'Charisma',
        'Chefarzt',
        'Chiffon',
        'Chipsatz',
        'Chirurg',
        'Chor',
        'Chronik',
        'Chuzpe',
        'Clubhaus',
        'Cockpit',
        'Codewort',
        'Cognac',
        'Coladose',
        'Computer',
        'Coupon',
        'Cousin',
        'Cracking',
        'Crash',
        'Curry',
        'Dach',
        'Dackel',
        'daddeln',
        'daliegen',
        'Dame',
        'Dammbau',
        'Dämon',
        'Dampflok',
        'Dank',
        'Darm',
        'Datei',
        'Datsche',
        'Datteln',
        'Datum',
        'Dauer',
        'Daunen',
        'Deckel',
        'Decoder',
        'Defekt',
        'Degen',
        'Dehnung',
        'Deiche',
        'Dekade',
        'Dekor',
        'Delfin',
        'Demut',
        'denken',
        'Deponie',
        'Design',
        'Desktop',
        'Dessert',
        'Detail',
        'Detektiv',
        'Dezibel',
        'Diadem',
        'Diagnose',
        'Dialekt',
        'Diamant',
        'Dichter',
        'Dickicht',
        'Diesel',
        'Diktat',
        'Diplom',
        'Direktor',
        'Dirne',
        'Diskurs',
        'Distanz',
        'Docht',
        'Dohle',
        'Dolch',
        'Domäne',
        'Donner',
        'Dorade',
        'Dorf',
        'Dörrobst',
        'Dorsch',
        'Dossier',
        'Dozent',
        'Drachen',
        'Draht',
        'Drama',
        'Drang',
        'Drehbuch',
        'Dreieck',
        'Dressur',
        'Drittel',
        'Drossel',
        'Druck',
        'Duell',
        'Duft',
        'Düne',
        'Dünung',
        'dürfen',
        'Duschbad',
        'Düsenjet',
        'Dynamik',
        'Ebbe',
        'Echolot',
        'Echse',
        'Eckball',
        'Edding',
        'Edelweiß',
        'Eden',
        'Edition',
        'Efeu',
        'Effekte',
        'Egoismus',
        'Ehre',
        'Eiablage',
        'Eiche',
        'Eidechse',
        'Eidotter',
        'Eierkopf',
        'Eigelb',
        'Eiland',
        'Eilbote',
        'Eimer',
        'einatmen',
        'Einband',
        'Eindruck',
        'Einfall',
        'Eingang',
        'Einkauf',
        'einladen',
        'Einöde',
        'Einrad',
        'Eintopf',
        'Einwurf',
        'Einzug',
        'Eisbär',
        'Eisen',
        'Eishöhle',
        'Eismeer',
        'Eiweiß',
        'Ekstase',
        'Elan',
        'Elch',
        'Elefant',
        'Eleganz',
        'Element',
        'Elfe',
        'Elite',
        'Elixier',
        'Ellbogen',
        'Eloquenz',
        'Emigrant',
        'Emission',
        'Emotion',
        'Empathie',
        'Empfang',
        'Endzeit',
        'Energie',
        'Engpass',
        'Enkel',
        'Enklave',
        'Ente',
        'entheben',
        'Entität',
        'entladen',
        'Entwurf',
        'Episode',
        'Epoche',
        'erachten',
        'Erbauer',
        'erblühen',
        'Erdbeere',
        'Erde',
        'Erdgas',
        'Erdkunde',
        'Erdnuss',
        'Erdöl',
        'Erdteil',
        'Ereignis',
        'Eremit',
        'erfahren',
        'Erfolg',
        'erfreuen',
        'erfüllen',
        'Ergebnis',
        'erhitzen',
        'erkalten',
        'erkennen',
        'erleben',
        'Erlösung',
        'ernähren',
        'erneuern',
        'Ernte',
        'Eroberer',
        'eröffnen',
        'Erosion',
        'Erotik',
        'Erpel',
        'erraten',
        'Erreger',
        'erröten',
        'Ersatz',
        'Erstflug',
        'Ertrag',
        'Eruption',
        'erwarten',
        'erwidern',
        'Erzbau',
        'Erzeuger',
        'erziehen',
        'Esel',
        'Eskimo',
        'Eskorte',
        'Espe',
        'Espresso',
        'essen',
        'Etage',
        'Etappe',
        'Etat',
        'Ethik',
        'Etikett',
        'Etüde',
        'Eule',
        'Euphorie',
        'Europa',
        'Everest',
        'Examen',
        'Exil',
        'Exodus',
        'Extrakt',
        'Fabel',
        'Fabrik',
        'Fachmann',
        'Fackel',
        'Faden',
        'Fagott',
        'Fahne',
        'Faible',
        'Fairness',
        'Fakt',
        'Fakultät',
        'Falke',
        'Fallobst',
        'Fälscher',
        'Faltboot',
        'Familie',
        'Fanclub',
        'Fanfare',
        'Fangarm',
        'Fantasie',
        'Farbe',
        'Farmhaus',
        'Farn',
        'Fasan',
        'Faser',
        'Fassung',
        'fasten',
        'Faulheit',
        'Fauna',
        'Faust',
        'Favorit',
        'Faxgerät',
        'Fazit',
        'fechten',
        'Federboa',
        'Fehler',
        'Feier',
        'Feige',
        'feilen',
        'Feinripp',
        'Feldbett',
        'Felge',
        'Fellpony',
        'Felswand',
        'Ferien',
        'Ferkel',
        'Fernweh',
        'Ferse',
        'Fest',
        'Fettnapf',
        'Feuer',
        'Fiasko',
        'Fichte',
        'Fiktion',
        'Film',
        'Filter',
        'Filz',
        'Finanzen',
        'Findling',
        'Finger',
        'Fink',
        'Finnwal',
        'Fisch',
        'Fitness',
        'Fixpunkt',
        'Fixstern',
        'Fjord',
        'Flachbau',
        'Flagge',
        'Flamenco',
        'Flanke',
        'Flasche',
        'Flaute',
        'Fleck',
        'Flegel',
        'flehen',
        'Fleisch',
        'fliegen',
        'Flinte',
        'Flirt',
        'Flocke',
        'Floh',
        'Floskel',
        'Floß',
        'Flöte',
        'Flugzeug',
        'Flunder',
        'Flusstal',
        'Flutung',
        'Fockmast',
        'Fohlen',
        'Föhnlage',
        'Fokus',
        'folgen',
        'Foliant',
        'Folklore',
        'Fontäne',
        'Förde',
        'Forelle',
        'Format',
        'Forscher',
        'Fortgang',
        'Forum',
        'Fotograf',
        'Frachter',
        'Fragment',
        'Fraktion',
        'fräsen',
        'Frauenpo',
        'Freak',
        'Fregatte',
        'Freiheit',
        'Freude',
        'Frieden',
        'Frohsinn',
        'Frosch',
        'Frucht',
        'Frühjahr',
        'Fuchs',
        'Fügung',
        'fühlen',
        'Füller',
        'Fundbüro',
        'Funkboje',
        'Funzel',
        'Furnier',
        'Fürsorge',
        'Fusel',
        'Fußbad',
        'Futteral',
        'Gabelung',
        'gackern',
        'Gage',
        'gähnen',
        'Galaxie',
        'Galeere',
        'Galopp',
        'Gameboy',
        'Gamsbart',
        'Gandhi',
        'Gang',
        'Garage',
        'Gardine',
        'Garküche',
        'Garten',
        'Gasthaus',
        'Gattung',
        'gaukeln',
        'Gazelle',
        'Gebäck',
        'Gebirge',
        'Gebräu',
        'Geburt',
        'Gedanke',
        'Gedeck',
        'Gedicht',
        'Gefahr',
        'Gefieder',
        'Geflügel',
        'Gefühl',
        'Gegend',
        'Gehirn',
        'Gehöft',
        'Gehweg',
        'Geige',
        'Geist',
        'Gelage',
        'Geld',
        'Gelenk',
        'Gelübde',
        'Gemälde',
        'Gemeinde',
        'Gemüse',
        'genesen',
        'Genuss',
        'Gepäck',
        'Geranie',
        'Gericht',
        'Germane',
        'Geruch',
        'Gesang',
        'Geschenk',
        'Gesetz',
        'Gesindel',
        'Gesöff',
        'Gespan',
        'Gestade',
        'Gesuch',
        'Getier',
        'Getränk',
        'Getümmel',
        'Gewand',
        'Geweih',
        'Gewitter',
        'Gewölbe',
        'Geysir',
        'Giftzahn',
        'Gipfel',
        'Giraffe',
        'Gitarre',
        'glänzen',
        'Glasauge',
        'Glatze',
        'Gleis',
        'Globus',
        'Glück',
        'glühen',
        'Glutofen',
        'Goldzahn',
        'Gondel',
        'gönnen',
        'Gottheit',
        'graben',
        'Grafik',
        'Grashalm',
        'Graugans',
        'greifen',
        'Grenze',
        'grillen',
        'Groschen',
        'Grotte',
        'Grube',
        'Grünalge',
        'Gruppe',
        'gruseln',
        'Gulasch',
        'Gummibär',
        'Gurgel',
        'Gürtel',
        'Güterzug',
        'Haarband',
        'Habicht',
        'hacken',
        'hadern',
        'Hafen',
        'Hagel',
        'Hähnchen',
        'Haifisch',
        'Haken',
        'Halbaffe',
        'Halsader',
        'halten',
        'Halunke',
        'Handbuch',
        'Hanf',
        'Harfe',
        'Harnisch',
        'härten',
        'Harz',
        'Hasenohr',
        'Haube',
        'hauchen',
        'Haupt',
        'Haut',
        'Havarie',
        'Hebamme',
        'hecheln',
        'Heck',
        'Hedonist',
        'Heiler',
        'Heimat',
        'Heizung',
        'Hektik',
        'Held',
        'helfen',
        'Helium',
        'Hemd',
        'hemmen',
        'Hengst',
        'Herd',
        'Hering',
        'Herkunft',
        'Hermelin',
        'Herrchen',
        'Herzdame',
        'Heulboje',
        'Hexe',
        'Hilfe',
        'Himbeere',
        'Himmel',
        'Hingabe',
        'hinhören',
        'Hinweis',
        'Hirsch',
        'Hirte',
        'Hitzkopf',
        'Hobel',
        'Hochform',
        'Hocker',
        'hoffen',
        'Hofhund',
        'Hofnarr',
        'Höhenzug',
        'Hohlraum',
        'Hölle',
        'Holzboot',
        'Honig',
        'Honorar',
        'horchen',
        'Hörprobe',
        'Höschen',
        'Hotel',
        'Hubraum',
        'Hufeisen',
        'Hügel',
        'huldigen',
        'Hülle',
        'Humbug',
        'Hummer',
        'Humor',
        'Hund',
        'Hunger',
        'Hupe',
        'Hürde',
        'Hurrikan',
        'Hydrant',
        'Hypnose',
        'Ibis',
        'Idee',
        'Idiot',
        'Igel',
        'Illusion',
        'Imitat',
        'impfen',
        'Import',
        'Inferno',
        'Ingwer',
        'Inhalte',
        'Inland',
        'Insekt',
        'Ironie',
        'Irrfahrt',
        'Irrtum',
        'Isolator',
        'Istwert',
        'Jacke',
        'Jade',
        'Jagdhund',
        'Jäger',
        'Jaguar',
        'Jahr',
        'Jähzorn',
        'Jazzfest',
        'Jetpilot',
        'jobben',
        'Jochbein',
        'jodeln',
        'Jodsalz',
        'Jolle',
        'Journal',
        'Jubel',
        'Junge',
        'Junimond',
        'Jupiter',
        'Jutesack',
        'Juwel',
        'Kabarett',
        'Kabine',
        'Kabuff',
        'Käfer',
        'Kaffee',
        'Kahlkopf',
        'Kaimauer',
        'Kajüte',
        'Kaktus',
        'Kaliber',
        'Kaltluft',
        'Kamel',
        'kämmen',
        'Kampagne',
        'Kanal',
        'Känguru',
        'Kanister',
        'Kanone',
        'Kante',
        'Kanu',
        'kapern',
        'Kapitän',
        'Kapuze',
        'Karneval',
        'Karotte',
        'Käsebrot',
        'Kasper',
        'Kastanie',
        'Katalog',
        'Kathode',
        'Katze',
        'kaufen',
        'Kaugummi',
        'Kauz',
        'Kehle',
        'Keilerei',
        'Keksdose',
        'Kellner',
        'Keramik',
        'Kerze',
        'Kessel',
        'Kette',
        'keuchen',
        'kichern',
        'Kielboot',
        'Kindheit',
        'Kinnbart',
        'Kinosaal',
        'Kiosk',
        'Kissen',
        'Klammer',
        'Klang',
        'Klapprad',
        'Klartext',
        'kleben',
        'Klee',
        'Kleinod',
        'Klima',
        'Klingel',
        'Klippe',
        'Klischee',
        'Kloster',
        'Klugheit',
        'Klüngel',
        'kneten',
        'Knie',
        'Knöchel',
        'knüpfen',
        'Kobold',
        'Kochbuch',
        'Kohlrabi',
        'Koje',
        'Kokosöl',
        'Kolibri',
        'Kolumne',
        'Kombüse',
        'Komiker',
        'kommen',
        'Konto',
        'Konzept',
        'Kopfkino',
        'Kordhose',
        'Korken',
        'Korsett',
        'Kosename',
        'Krabbe',
        'Krach',
        'Kraft',
        'Krähe',
        'Kralle',
        'Krapfen',
        'Krater',
        'kraulen',
        'Kreuz',
        'Krokodil',
        'Kröte',
        'Kugel',
        'Kuhhirt',
        'Kühnheit',
        'Künstler',
        'Kurort',
        'Kurve',
        'Kurzfilm',
        'kuscheln',
        'küssen',
        'Kutter',
        'Labor',
        'lachen',
        'Lackaffe',
        'Ladeluke',
        'Lagune',
        'Laib',
        'Lakritze',
        'Lammfell',
        'Land',
        'Langmut',
        'Lappalie',
        'Last',
        'Laterne',
        'Latzhose',
        'Laubsäge',
        'laufen',
        'Laune',
        'Lausbub',
        'Lavasee',
        'Leben',
        'Leder',
        'Leerlauf',
        'Lehm',
        'Lehrer',
        'leihen',
        'Lektüre',
        'Lenker',
        'Lerche',
        'Leseecke',
        'Leuchter',
        'Lexikon',
        'Libelle',
        'Libido',
        'Licht',
        'Liebe',
        'liefern',
        'Liftboy',
        'Limonade',
        'Lineal',
        'Linoleum',
        'List',
        'Liveband',
        'Lobrede',
        'locken',
        'Löffel',
        'Logbuch',
        'Logik',
        'Lohn',
        'Loipe',
        'Lokal',
        'Lorbeer',
        'Lösung',
        'löten',
        'Lottofee',
        'Löwe',
        'Luchs',
        'Luder',
        'Luftpost',
        'Luke',
        'Lümmel',
        'Lunge',
        'lutschen',
        'Luxus',
        'Macht',
        'Magazin',
        'Magier',
        'Magnet',
        'mähen',
        'Mahlzeit',
        'Mahnmal',
        'Maibaum',
        'Maisbrei',
        'Makel',
        'malen',
        'Mammut',
        'Maniküre',
        'Mantel',
        'Marathon',
        'Marder',
        'Marine',
        'Marke',
        'Marmor',
        'Märzluft',
        'Maske',
        'Maßanzug',
        'Maßkrug',
        'Mastkorb',
        'Material',
        'Matratze',
        'Mauerbau',
        'Maulkorb',
        'Mäuschen',
        'Mäzen',
        'Medium',
        'Meinung',
        'melden',
        'Melodie',
        'Mensch',
        'Merkmal',
        'Messe',
        'Metall',
        'Meteor',
        'Methode',
        'Metzger',
        'Mieze',
        'Milchkuh',
        'Mimose',
        'Minirock',
        'Minute',
        'mischen',
        'Missetat',
        'mitgehen',
        'Mittag',
        'Mixtape',
        'Möbel',
        'Modul',
        'mögen',
        'Möhre',
        'Molch',
        'Moment',
        'Monat',
        'Mondflug',
        'Monitor',
        'Monokini',
        'Monster',
        'Monument',
        'Moorhuhn',
        'Moos',
        'Möpse',
        'Moral',
        'Mörtel',
        'Motiv',
        'Motorrad',
        'Möwe',
        'Mühe',
        'Mulatte',
        'Müller',
        'Mumie',
        'Mund',
        'Münze',
        'Muschel',
        'Muster',
        'Mythos',
        'Nabel',
        'Nachtzug',
        'Nackedei',
        'Nagel',
        'Nähe',
        'Nähnadel',
        'Namen',
        'Narbe',
        'Narwal',
        'Nasenbär',
        'Natur',
        'Nebel',
        'necken',
        'Neffe',
        'Neigung',
        'Nektar',
        'Nenner',
        'Neptun',
        'Nerz',
        'Nessel',
        'Nestbau',
        'Netz',
        'Neubau',
        'Neuerung',
        'Neugier',
        'nicken',
        'Niere',
        'Nilpferd',
        'nisten',
        'Nocke',
        'Nomade',
        'Nordmeer',
        'Notdurft',
        'Notstand',
        'Notwehr',
        'Nudismus',
        'Nuss',
        'Nutzhanf',
        'Oase',
        'Obdach',
        'Oberarzt',
        'Objekt',
        'Oboe',
        'Obsthain',
        'Ochse',
        'Odyssee',
        'Ofenholz',
        'öffnen',
        'Ohnmacht',
        'Ohrfeige',
        'Ohrwurm',
        'Ökologie',
        'Oktave',
        'Ölberg',
        'Olive',
        'Ölkrise',
        'Omelett',
        'Onkel',
        'Oper',
        'Optiker',
        'Orange',
        'Orchidee',
        'ordnen',
        'Orgasmus',
        'Orkan',
        'Ortskern',
        'Ortung',
        'Ostasien',
        'Ozean',
        'Paarlauf',
        'Packeis',
        'paddeln',
        'Paket',
        'Palast',
        'Pandabär',
        'Panik',
        'Panorama',
        'Panther',
        'Papagei',
        'Papier',
        'Paprika',
        'Paradies',
        'Parka',
        'Parodie',
        'Partner',
        'Passant',
        'Patent',
        'Patzer',
        'Pause',
        'Pavian',
        'Pedal',
        'Pegel',
        'peilen',
        'Perle',
        'Person',
        'Pfad',
        'Pfau',
        'Pferd',
        'Pfleger',
        'Physik',
        'Pier',
        'Pilotwal',
        'Pinzette',
        'Piste',
        'Plakat',
        'Plankton',
        'Platin',
        'Plombe',
        'plündern',
        'Pobacke',
        'Pokal',
        'polieren',
        'Popmusik',
        'Porträt',
        'Posaune',
        'Postamt',
        'Pottwal',
        'Pracht',
        'Pranke',
        'Preis',
        'Primat',
        'Prinzip',
        'Protest',
        'Proviant',
        'Prüfung',
        'Pubertät',
        'Pudding',
        'Pullover',
        'Pulsader',
        'Punkt',
        'Pute',
        'Putsch',
        'Puzzle',
        'Python',
        'quaken',
        'Qualle',
        'Quark',
        'Quellsee',
        'Querkopf',
        'Quitte',
        'Quote',
        'Rabauke',
        'Rache',
        'Radclub',
        'Radhose',
        'Radio',
        'Radtour',
        'Rahmen',
        'Rampe',
        'Randlage',
        'Ranzen',
        'Rapsöl',
        'Raserei',
        'rasten',
        'Rasur',
        'Rätsel',
        'Raubtier',
        'Raumzeit',
        'Rausch',
        'Reaktor',
        'Realität',
        'Rebell',
        'Rede',
        'Reetdach',
        'Regatta',
        'Regen',
        'Rehkitz',
        'Reifen',
        'Reim',
        'Reise',
        'Reizung',
        'Rekord',
        'Relevanz',
        'Rennboot',
        'Respekt',
        'Restmüll',
        'retten',
        'Reue',
        'Revolte',
        'Rhetorik',
        'Rhythmus',
        'Richtung',
        'Riegel',
        'Rindvieh',
        'Rippchen',
        'Ritter',
        'Robbe',
        'Roboter',
        'Rockband',
        'Rohdaten',
        'Roller',
        'Roman',
        'röntgen',
        'Rose',
        'Rosskur',
        'Rost',
        'Rotahorn',
        'Rotglut',
        'Rotznase',
        'Rubrik',
        'Rückweg',
        'Rufmord',
        'Ruhe',
        'Ruine',
        'Rumpf',
        'Runde',
        'Rüstung',
        'rütteln',
        'Saaltür',
        'Saatguts',
        'Säbel',
        'Sachbuch',
        'Sack',
        'Saft',
        'sagen',
        'Sahneeis',
        'Salat',
        'Salbe',
        'Salz',
        'Sammlung',
        'Samt',
        'Sandbank',
        'Sanftmut',
        'Sardine',
        'Satire',
        'Sattel',
        'Satzbau',
        'Sauerei',
        'Saum',
        'Säure',
        'Schall',
        'Scheitel',
        'Schiff',
        'Schlager',
        'Schmied',
        'Schnee',
        'Scholle',
        'Schrank',
        'Schulbus',
        'Schwan',
        'Seeadler',
        'Seefahrt',
        'Seehund',
        'Seeufer',
        'segeln',
        'Sehnerv',
        'Seide',
        'Seilzug',
        'Senf',
        'Sessel',
        'Seufzer',
        'Sexgott',
        'Sichtung',
        'Signal',
        'Silber',
        'singen',
        'Sinn',
        'Sirup',
        'Sitzbank',
        'Skandal',
        'Skikurs',
        'Skipper',
        'Skizze',
        'Smaragd',
        'Socke',
        'Sohn',
        'Sommer',
        'Songtext',
        'Sorte',
        'Spagat',
        'Spannung',
        'Spargel',
        'Specht',
        'Speiseöl',
        'Spiegel',
        'Sport',
        'spülen',
        'Stadtbus',
        'Stall',
        'Stärke',
        'Stativ',
        'staunen',
        'Stern',
        'Stiftung',
        'Stollen',
        'Strömung',
        'Sturm',
        'Substanz',
        'Südalpen',
        'Sumpf',
        'surfen',
        'Tabak',
        'Tafel',
        'Tagebau',
        'takeln',
        'Taktung',
        'Talsohle',
        'Tand',
        'Tanzbär',
        'Tapir',
        'Tarantel',
        'Tarnname',
        'Tasse',
        'Tatnacht',
        'Tatsache',
        'Tatze',
        'Taube',
        'tauchen',
        'Taufpate',
        'Taumel',
        'Teelicht',
        'Teich',
        'teilen',
        'Tempo',
        'Tenor',
        'Terrasse',
        'Testflug',
        'Theater',
        'Thermik',
        'ticken',
        'Tiefflug',
        'Tierart',
        'Tigerhai',
        'Tinte',
        'Tischler',
        'toben',
        'Toleranz',
        'Tölpel',
        'Tonband',
        'Topf',
        'Topmodel',
        'Torbogen',
        'Torlinie',
        'Torte',
        'Tourist',
        'Tragesel',
        'trampeln',
        'Trapez',
        'Traum',
        'treffen',
        'Trennung',
        'Treue',
        'Trick',
        'trimmen',
        'Trödel',
        'Trost',
        'Trumpf',
        'tüfteln',
        'Turban',
        'Turm',
        'Übermut',
        'Ufer',
        'Uhrwerk',
        'umarmen',
        'Umbau',
        'Umfeld',
        'Umgang',
        'Umsturz',
        'Unart',
        'Unfug',
        'Unimog',
        'Unruhe',
        'Unwucht',
        'Uranerz',
        'Urlaub',
        'Urmensch',
        'Utopie',
        'Vakuum',
        'Valuta',
        'Vandale',
        'Vase',
        'Vektor',
        'Ventil',
        'Verb',
        'Verdeck',
        'Verfall',
        'Vergaser',
        'verhexen',
        'Verlag',
        'Vers',
        'Vesper',
        'Vieh',
        'Viereck',
        'Vinyl',
        'Virus',
        'Vitrine',
        'Vollblut',
        'Vorbote',
        'Vorrat',
        'Vorsicht',
        'Vulkan',
        'Wachstum',
        'Wade',
        'Wagemut',
        'Wahlen',
        'Wahrheit',
        'Wald',
        'Walhai',
        'Wallach',
        'Walnuss',
        'Walzer',
        'wandeln',
        'Wanze',
        'wärmen',
        'Warnruf',
        'Wäsche',
        'Wasser',
        'Weberei',
        'wechseln',
        'Wegegeld',
        'wehren',
        'Weiher',
        'Weinglas',
        'Weißbier',
        'Weitwurf',
        'Welle',
        'Weltall',
        'Werkbank',
        'Werwolf',
        'Wetter',
        'wiehern',
        'Wildgans',
        'Wind',
        'Wohl',
        'Wohnort',
        'Wolf',
        'Wollust',
        'Wortlaut',
        'Wrack',
        'Wunder',
        'Wurfaxt',
        'Wurst',
        'Yacht',
        'Yeti',
        'Zacke',
        'Zahl',
        'zähmen',
        'Zahnfee',
        'Zäpfchen',
        'Zaster',
        'Zaumzeug',
        'Zebra',
        'zeigen',
        'Zeitlupe',
        'Zellkern',
        'Zeltdach',
        'Zensor',
        'Zerfall',
        'Zeug',
        'Ziege',
        'Zielfoto',
        'Zimteis',
        'Zobel',
        'Zollhund',
        'Zombie',
        'Zöpfe',
        'Zucht',
        'Zufahrt',
        'Zugfahrt',
        'Zugvogel',
        'Zündung',
        'Zweck',
        'Zyklop',
      ])
    );
    langs.push(
      new MnemonicLang('italian', 'it', 4, [
        'abbinare',
        'abbonato',
        'abisso',
        'abitare',
        'abominio',
        'accadere',
        'accesso',
        'acciaio',
        'accordo',
        'accumulo',
        'acido',
        'acqua',
        'acrobata',
        'acustico',
        'adattare',
        'addetto',
        'addio',
        'addome',
        'adeguato',
        'aderire',
        'adorare',
        'adottare',
        'adozione',
        'adulto',
        'aereo',
        'aerobica',
        'affare',
        'affetto',
        'affidare',
        'affogato',
        'affronto',
        'africano',
        'afrodite',
        'agenzia',
        'aggancio',
        'aggeggio',
        'aggiunta',
        'agio',
        'agire',
        'agitare',
        'aglio',
        'agnello',
        'agosto',
        'aiutare',
        'albero',
        'albo',
        'alce',
        'alchimia',
        'alcool',
        'alfabeto',
        'algebra',
        'alimento',
        'allarme',
        'alleanza',
        'allievo',
        'alloggio',
        'alluce',
        'alpi',
        'alterare',
        'altro',
        'aluminio',
        'amante',
        'amarezza',
        'ambiente',
        'ambrosia',
        'america',
        'amico',
        'ammalare',
        'ammirare',
        'amnesia',
        'amnistia',
        'amore',
        'ampliare',
        'amputare',
        'analisi',
        'anamnesi',
        'ananas',
        'anarchia',
        'anatra',
        'anca',
        'ancorato',
        'andare',
        'androide',
        'aneddoto',
        'anello',
        'angelo',
        'angolino',
        'anguilla',
        'anidride',
        'anima',
        'annegare',
        'anno',
        'annuncio',
        'anomalia',
        'antenna',
        'anticipo',
        'aperto',
        'apostolo',
        'appalto',
        'appello',
        'appiglio',
        'applauso',
        'appoggio',
        'appurare',
        'aprile',
        'aquila',
        'arabo',
        'arachidi',
        'aragosta',
        'arancia',
        'arbitrio',
        'archivio',
        'arco',
        'argento',
        'argilla',
        'aria',
        'ariete',
        'arma',
        'armonia',
        'aroma',
        'arrivare',
        'arrosto',
        'arsenale',
        'arte',
        'artiglio',
        'asfalto',
        'asfissia',
        'asino',
        'asparagi',
        'aspirina',
        'assalire',
        'assegno',
        'assolto',
        'assurdo',
        'asta',
        'astratto',
        'atlante',
        'atletica',
        'atomo',
        'atropina',
        'attacco',
        'attesa',
        'attico',
        'atto',
        'attrarre',
        'auguri',
        'aula',
        'aumento',
        'aurora',
        'auspicio',
        'autista',
        'auto',
        'autunno',
        'avanzare',
        'avarizia',
        'avere',
        'aviatore',
        'avido',
        'avorio',
        'avvenire',
        'avviso',
        'avvocato',
        'azienda',
        'azione',
        'azzardo',
        'azzurro',
        'babbuino',
        'bacio',
        'badante',
        'baffi',
        'bagaglio',
        'bagliore',
        'bagno',
        'balcone',
        'balena',
        'ballare',
        'balordo',
        'balsamo',
        'bambola',
        'bancomat',
        'banda',
        'barato',
        'barba',
        'barista',
        'barriera',
        'basette',
        'basilico',
        'bassista',
        'bastare',
        'battello',
        'bavaglio',
        'beccare',
        'beduino',
        'bellezza',
        'bene',
        'benzina',
        'berretto',
        'bestia',
        'bevitore',
        'bianco',
        'bibbia',
        'biberon',
        'bibita',
        'bici',
        'bidone',
        'bilancia',
        'biliardo',
        'binario',
        'binocolo',
        'biologia',
        'biondina',
        'biopsia',
        'biossido',
        'birbante',
        'birra',
        'biscotto',
        'bisogno',
        'bistecca',
        'bivio',
        'blindare',
        'bloccare',
        'bocca',
        'bollire',
        'bombola',
        'bonifico',
        'borghese',
        'borsa',
        'bottino',
        'botulino',
        'braccio',
        'bradipo',
        'branco',
        'bravo',
        'bresaola',
        'bretelle',
        'brevetto',
        'briciola',
        'brigante',
        'brillare',
        'brindare',
        'brivido',
        'broccoli',
        'brontolo',
        'bruciare',
        'brufolo',
        'bucare',
        'buddista',
        'budino',
        'bufera',
        'buffo',
        'bugiardo',
        'buio',
        'buono',
        'burrone',
        'bussola',
        'bustina',
        'buttare',
        'cabernet',
        'cabina',
        'cacao',
        'cacciare',
        'cactus',
        'cadavere',
        'caffe',
        'calamari',
        'calcio',
        'caldaia',
        'calmare',
        'calunnia',
        'calvario',
        'calzone',
        'cambiare',
        'camera',
        'camion',
        'cammello',
        'campana',
        'canarino',
        'cancello',
        'candore',
        'cane',
        'canguro',
        'cannone',
        'canoa',
        'cantare',
        'canzone',
        'caos',
        'capanna',
        'capello',
        'capire',
        'capo',
        'capperi',
        'capra',
        'capsula',
        'caraffa',
        'carbone',
        'carciofo',
        'cardigan',
        'carenza',
        'caricare',
        'carota',
        'carrello',
        'carta',
        'casa',
        'cascare',
        'caserma',
        'cashmere',
        'casino',
        'cassetta',
        'castello',
        'catalogo',
        'catena',
        'catorcio',
        'cattivo',
        'causa',
        'cauzione',
        'cavallo',
        'caverna',
        'caviglia',
        'cavo',
        'cazzotto',
        'celibato',
        'cemento',
        'cenare',
        'centrale',
        'ceramica',
        'cercare',
        'ceretta',
        'cerniera',
        'certezza',
        'cervello',
        'cessione',
        'cestino',
        'cetriolo',
        'chiave',
        'chiedere',
        'chilo',
        'chimera',
        'chiodo',
        'chirurgo',
        'chitarra',
        'chiudere',
        'ciabatta',
        'ciao',
        'cibo',
        'ciccia',
        'cicerone',
        'ciclone',
        'cicogna',
        'cielo',
        'cifra',
        'cigno',
        'ciliegia',
        'cimitero',
        'cinema',
        'cinque',
        'cintura',
        'ciondolo',
        'ciotola',
        'cipolla',
        'cippato',
        'circuito',
        'cisterna',
        'citofono',
        'ciuccio',
        'civetta',
        'civico',
        'clausola',
        'cliente',
        'clima',
        'clinica',
        'cobra',
        'coccole',
        'cocktail',
        'cocomero',
        'codice',
        'coesione',
        'cogliere',
        'cognome',
        'colla',
        'colomba',
        'colpire',
        'coltello',
        'comando',
        'comitato',
        'commedia',
        'comodino',
        'compagna',
        'comune',
        'concerto',
        'condotto',
        'conforto',
        'congiura',
        'coniglio',
        'consegna',
        'conto',
        'convegno',
        'coperta',
        'copia',
        'coprire',
        'corazza',
        'corda',
        'corleone',
        'cornice',
        'corona',
        'corpo',
        'corrente',
        'corsa',
        'cortesia',
        'corvo',
        'coso',
        'costume',
        'cotone',
        'cottura',
        'cozza',
        'crampo',
        'cratere',
        'cravatta',
        'creare',
        'credere',
        'crema',
        'crescere',
        'crimine',
        'criterio',
        'croce',
        'crollare',
        'cronaca',
        'crostata',
        'croupier',
        'cubetto',
        'cucciolo',
        'cucina',
        'cultura',
        'cuoco',
        'cuore',
        'cupido',
        'cupola',
        'cura',
        'curva',
        'cuscino',
        'custode',
        'danzare',
        'data',
        'decennio',
        'decidere',
        'decollo',
        'dedicare',
        'dedurre',
        'definire',
        'delegare',
        'delfino',
        'delitto',
        'demone',
        'dentista',
        'denuncia',
        'deposito',
        'derivare',
        'deserto',
        'designer',
        'destino',
        'detonare',
        'dettagli',
        'diagnosi',
        'dialogo',
        'diamante',
        'diario',
        'diavolo',
        'dicembre',
        'difesa',
        'digerire',
        'digitare',
        'diluvio',
        'dinamica',
        'dipinto',
        'diploma',
        'diramare',
        'dire',
        'dirigere',
        'dirupo',
        'discesa',
        'disdetta',
        'disegno',
        'disporre',
        'dissenso',
        'distacco',
        'dito',
        'ditta',
        'diva',
        'divenire',
        'dividere',
        'divorare',
        'docente',
        'dolcetto',
        'dolore',
        'domatore',
        'domenica',
        'dominare',
        'donatore',
        'donna',
        'dorato',
        'dormire',
        'dorso',
        'dosaggio',
        'dottore',
        'dovere',
        'download',
        'dragone',
        'dramma',
        'dubbio',
        'dubitare',
        'duetto',
        'durata',
        'ebbrezza',
        'eccesso',
        'eccitare',
        'eclissi',
        'economia',
        'edera',
        'edificio',
        'editore',
        'edizione',
        'educare',
        'effetto',
        'egitto',
        'egiziano',
        'elastico',
        'elefante',
        'eleggere',
        'elemento',
        'elenco',
        'elezione',
        'elmetto',
        'elogio',
        'embrione',
        'emergere',
        'emettere',
        'eminenza',
        'emisfero',
        'emozione',
        'empatia',
        'energia',
        'enfasi',
        'enigma',
        'entrare',
        'enzima',
        'epidemia',
        'epilogo',
        'episodio',
        'epoca',
        'equivoco',
        'erba',
        'erede',
        'eroe',
        'erotico',
        'errore',
        'eruzione',
        'esaltare',
        'esame',
        'esaudire',
        'eseguire',
        'esempio',
        'esigere',
        'esistere',
        'esito',
        'esperto',
        'espresso',
        'essere',
        'estasi',
        'esterno',
        'estrarre',
        'eterno',
        'etica',
        'euforico',
        'europa',
        'evacuare',
        'evasione',
        'evento',
        'evidenza',
        'evitare',
        'evolvere',
        'fabbrica',
        'facciata',
        'fagiano',
        'fagotto',
        'falco',
        'fame',
        'famiglia',
        'fanale',
        'fango',
        'fantasia',
        'farfalla',
        'farmacia',
        'faro',
        'fase',
        'fastidio',
        'faticare',
        'fatto',
        'favola',
        'febbre',
        'femmina',
        'femore',
        'fenomeno',
        'fermata',
        'feromoni',
        'ferrari',
        'fessura',
        'festa',
        'fiaba',
        'fiamma',
        'fianco',
        'fiat',
        'fibbia',
        'fidare',
        'fieno',
        'figa',
        'figlio',
        'figura',
        'filetto',
        'filmato',
        'filosofo',
        'filtrare',
        'finanza',
        'finestra',
        'fingere',
        'finire',
        'finta',
        'finzione',
        'fiocco',
        'fioraio',
        'firewall',
        'firmare',
        'fisico',
        'fissare',
        'fittizio',
        'fiume',
        'flacone',
        'flagello',
        'flirtare',
        'flusso',
        'focaccia',
        'foglio',
        'fognario',
        'follia',
        'fonderia',
        'fontana',
        'forbici',
        'forcella',
        'foresta',
        'forgiare',
        'formare',
        'fornace',
        'foro',
        'fortuna',
        'forzare',
        'fosforo',
        'fotoni',
        'fracasso',
        'fragola',
        'frantumi',
        'fratello',
        'frazione',
        'freccia',
        'freddo',
        'frenare',
        'fresco',
        'friggere',
        'frittata',
        'frivolo',
        'frizione',
        'fronte',
        'frullato',
        'frumento',
        'frusta',
        'frutto',
        'fucile',
        'fuggire',
        'fulmine',
        'fumare',
        'funzione',
        'fuoco',
        'furbizia',
        'furgone',
        'furia',
        'furore',
        'fusibile',
        'fuso',
        'futuro',
        'gabbiano',
        'galassia',
        'gallina',
        'gamba',
        'gancio',
        'garanzia',
        'garofano',
        'gasolio',
        'gatto',
        'gazebo',
        'gazzetta',
        'gelato',
        'gemelli',
        'generare',
        'genitori',
        'gennaio',
        'geologia',
        'germania',
        'gestire',
        'gettare',
        'ghepardo',
        'ghiaccio',
        'giaccone',
        'giaguaro',
        'giallo',
        'giappone',
        'giardino',
        'gigante',
        'gioco',
        'gioiello',
        'giorno',
        'giovane',
        'giraffa',
        'giudizio',
        'giurare',
        'giusto',
        'globo',
        'gloria',
        'glucosio',
        'gnocca',
        'gocciola',
        'godere',
        'gomito',
        'gomma',
        'gonfiare',
        'gorilla',
        'governo',
        'gradire',
        'graffiti',
        'granchio',
        'grappolo',
        'grasso',
        'grattare',
        'gridare',
        'grissino',
        'grondaia',
        'grugnito',
        'gruppo',
        'guadagno',
        'guaio',
        'guancia',
        'guardare',
        'gufo',
        'guidare',
        'guscio',
        'gusto',
        'icona',
        'idea',
        'identico',
        'idolo',
        'idoneo',
        'idrante',
        'idrogeno',
        'igiene',
        'ignoto',
        'imbarco',
        'immagine',
        'immobile',
        'imparare',
        'impedire',
        'impianto',
        'importo',
        'impresa',
        'impulso',
        'incanto',
        'incendio',
        'incidere',
        'incontro',
        'incrocia',
        'incubo',
        'indagare',
        'indice',
        'indotto',
        'infanzia',
        'inferno',
        'infinito',
        'infranto',
        'ingerire',
        'inglese',
        'ingoiare',
        'ingresso',
        'iniziare',
        'innesco',
        'insalata',
        'inserire',
        'insicuro',
        'insonnia',
        'insulto',
        'interno',
        'introiti',
        'invasori',
        'inverno',
        'invito',
        'invocare',
        'ipnosi',
        'ipocrita',
        'ipotesi',
        'ironia',
        'irrigare',
        'iscritto',
        'isola',
        'ispirare',
        'isterico',
        'istinto',
        'istruire',
        'italiano',
        'jazz',
        'labbra',
        'labrador',
        'ladro',
        'lago',
        'lamento',
        'lampone',
        'lancetta',
        'lanterna',
        'lapide',
        'larva',
        'lasagne',
        'lasciare',
        'lastra',
        'latte',
        'laurea',
        'lavagna',
        'lavorare',
        'leccare',
        'legare',
        'leggere',
        'lenzuolo',
        'leone',
        'lepre',
        'letargo',
        'lettera',
        'levare',
        'levitare',
        'lezione',
        'liberare',
        'libidine',
        'libro',
        'licenza',
        'lievito',
        'limite',
        'lince',
        'lingua',
        'liquore',
        'lire',
        'listino',
        'litigare',
        'litro',
        'locale',
        'lottare',
        'lucciola',
        'lucidare',
        'luglio',
        'luna',
        'macchina',
        'madama',
        'madre',
        'maestro',
        'maggio',
        'magico',
        'maglione',
        'magnolia',
        'mago',
        'maialino',
        'maionese',
        'malattia',
        'male',
        'malloppo',
        'mancare',
        'mandorla',
        'mangiare',
        'manico',
        'manopola',
        'mansarda',
        'mantello',
        'manubrio',
        'manzo',
        'mappa',
        'mare',
        'margine',
        'marinaio',
        'marmotta',
        'marocco',
        'martello',
        'marzo',
        'maschera',
        'matrice',
        'maturare',
        'mazzetta',
        'meandri',
        'medaglia',
        'medico',
        'medusa',
        'megafono',
        'melone',
        'membrana',
        'menta',
        'mercato',
        'meritare',
        'merluzzo',
        'mese',
        'mestiere',
        'metafora',
        'meteo',
        'metodo',
        'mettere',
        'miele',
        'miglio',
        'miliardo',
        'mimetica',
        'minatore',
        'minuto',
        'miracolo',
        'mirtillo',
        'missile',
        'mistero',
        'misura',
        'mito',
        'mobile',
        'moda',
        'moderare',
        'moglie',
        'molecola',
        'molle',
        'momento',
        'moneta',
        'mongolia',
        'monologo',
        'montagna',
        'morale',
        'morbillo',
        'mordere',
        'mosaico',
        'mosca',
        'mostro',
        'motivare',
        'moto',
        'mulino',
        'mulo',
        'muovere',
        'muraglia',
        'muscolo',
        'museo',
        'musica',
        'mutande',
        'nascere',
        'nastro',
        'natale',
        'natura',
        'nave',
        'navigare',
        'negare',
        'negozio',
        'nemico',
        'nero',
        'nervo',
        'nessuno',
        'nettare',
        'neutroni',
        'neve',
        'nevicare',
        'nicotina',
        'nido',
        'nipote',
        'nocciola',
        'noleggio',
        'nome',
        'nonno',
        'norvegia',
        'notare',
        'notizia',
        'nove',
        'nucleo',
        'nuda',
        'nuotare',
        'nutrire',
        'obbligo',
        'occhio',
        'occupare',
        'oceano',
        'odissea',
        'odore',
        'offerta',
        'officina',
        'offrire',
        'oggetto',
        'oggi',
        'olfatto',
        'olio',
        'oliva',
        'ombelico',
        'ombrello',
        'omuncolo',
        'ondata',
        'onore',
        'opera',
        'opinione',
        'opuscolo',
        'opzione',
        'orario',
        'orbita',
        'orchidea',
        'ordine',
        'orecchio',
        'orgasmo',
        'orgoglio',
        'origine',
        'orologio',
        'oroscopo',
        'orso',
        'oscurare',
        'ospedale',
        'ospite',
        'ossigeno',
        'ostacolo',
        'ostriche',
        'ottenere',
        'ottimo',
        'ottobre',
        'ovest',
        'pacco',
        'pace',
        'pacifico',
        'padella',
        'pagare',
        'pagina',
        'pagnotta',
        'palazzo',
        'palestra',
        'palpebre',
        'pancetta',
        'panfilo',
        'panino',
        'pannello',
        'panorama',
        'papa',
        'paperino',
        'paradiso',
        'parcella',
        'parente',
        'parlare',
        'parodia',
        'parrucca',
        'partire',
        'passare',
        'pasta',
        'patata',
        'patente',
        'patogeno',
        'patriota',
        'pausa',
        'pazienza',
        'peccare',
        'pecora',
        'pedalare',
        'pelare',
        'pena',
        'pendenza',
        'penisola',
        'pennello',
        'pensare',
        'pentirsi',
        'percorso',
        'perdono',
        'perfetto',
        'perizoma',
        'perla',
        'permesso',
        'persona',
        'pesare',
        'pesce',
        'peso',
        'petardo',
        'petrolio',
        'pezzo',
        'piacere',
        'pianeta',
        'piastra',
        'piatto',
        'piazza',
        'piccolo',
        'piede',
        'piegare',
        'pietra',
        'pigiama',
        'pigliare',
        'pigrizia',
        'pilastro',
        'pilota',
        'pinguino',
        'pioggia',
        'piombo',
        'pionieri',
        'piovra',
        'pipa',
        'pirata',
        'pirolisi',
        'piscina',
        'pisolino',
        'pista',
        'pitone',
        'piumino',
        'pizza',
        'plastica',
        'platino',
        'poesia',
        'poiana',
        'polaroid',
        'polenta',
        'polimero',
        'pollo',
        'polmone',
        'polpetta',
        'poltrona',
        'pomodoro',
        'pompa',
        'popolo',
        'porco',
        'porta',
        'porzione',
        'possesso',
        'postino',
        'potassio',
        'potere',
        'poverino',
        'pranzo',
        'prato',
        'prefisso',
        'prelievo',
        'premio',
        'prendere',
        'prestare',
        'pretesa',
        'prezzo',
        'primario',
        'privacy',
        'problema',
        'processo',
        'prodotto',
        'profeta',
        'progetto',
        'promessa',
        'pronto',
        'proposta',
        'proroga',
        'prossimo',
        'proteina',
        'prova',
        'prudenza',
        'pubblico',
        'pudore',
        'pugilato',
        'pulire',
        'pulsante',
        'puntare',
        'pupazzo',
        'puzzle',
        'quaderno',
        'qualcuno',
        'quarzo',
        'quercia',
        'quintale',
        'rabbia',
        'racconto',
        'radice',
        'raffica',
        'ragazza',
        'ragione',
        'rammento',
        'ramo',
        'rana',
        'randagio',
        'rapace',
        'rapinare',
        'rapporto',
        'rasatura',
        'ravioli',
        'reagire',
        'realista',
        'reattore',
        'reazione',
        'recitare',
        'recluso',
        'record',
        'recupero',
        'redigere',
        'regalare',
        'regina',
        'regola',
        'relatore',
        'reliquia',
        'remare',
        'rendere',
        'reparto',
        'resina',
        'resto',
        'rete',
        'retorica',
        'rettile',
        'revocare',
        'riaprire',
        'ribadire',
        'ribelle',
        'ricambio',
        'ricetta',
        'richiamo',
        'ricordo',
        'ridurre',
        'riempire',
        'riferire',
        'riflesso',
        'righello',
        'rilancio',
        'rilevare',
        'rilievo',
        'rimanere',
        'rimborso',
        'rinforzo',
        'rinuncia',
        'riparo',
        'ripetere',
        'riposare',
        'ripulire',
        'risalita',
        'riscatto',
        'riserva',
        'riso',
        'rispetto',
        'ritaglio',
        'ritmo',
        'ritorno',
        'ritratto',
        'rituale',
        'riunione',
        'riuscire',
        'riva',
        'robotica',
        'rondine',
        'rosa',
        'rospo',
        'rosso',
        'rotonda',
        'rotta',
        'roulotte',
        'rubare',
        'rubrica',
        'ruffiano',
        'rumore',
        'ruota',
        'ruscello',
        'sabbia',
        'sacco',
        'saggio',
        'sale',
        'salire',
        'salmone',
        'salto',
        'salutare',
        'salvia',
        'sangue',
        'sanzioni',
        'sapere',
        'sapienza',
        'sarcasmo',
        'sardine',
        'sartoria',
        'sbalzo',
        'sbarcare',
        'sberla',
        'sborsare',
        'scadenza',
        'scafo',
        'scala',
        'scambio',
        'scappare',
        'scarpa',
        'scatola',
        'scelta',
        'scena',
        'sceriffo',
        'scheggia',
        'schiuma',
        'sciarpa',
        'scienza',
        'scimmia',
        'sciopero',
        'scivolo',
        'sclerare',
        'scolpire',
        'sconto',
        'scopa',
        'scordare',
        'scossa',
        'scrivere',
        'scrupolo',
        'scuderia',
        'scultore',
        'scuola',
        'scusare',
        'sdraiare',
        'secolo',
        'sedativo',
        'sedere',
        'sedia',
        'segare',
        'segreto',
        'seguire',
        'semaforo',
        'seme',
        'senape',
        'seno',
        'sentiero',
        'separare',
        'sepolcro',
        'sequenza',
        'serata',
        'serpente',
        'servizio',
        'sesso',
        'seta',
        'settore',
        'sfamare',
        'sfera',
        'sfidare',
        'sfiorare',
        'sfogare',
        'sgabello',
        'sicuro',
        'siepe',
        'sigaro',
        'silenzio',
        'silicone',
        'simbiosi',
        'simpatia',
        'simulare',
        'sinapsi',
        'sindrome',
        'sinergia',
        'sinonimo',
        'sintonia',
        'sirena',
        'siringa',
        'sistema',
        'sito',
        'smalto',
        'smentire',
        'smontare',
        'soccorso',
        'socio',
        'soffitto',
        'software',
        'soggetto',
        'sogliola',
        'sognare',
        'soldi',
        'sole',
        'sollievo',
        'solo',
        'sommario',
        'sondare',
        'sonno',
        'sorpresa',
        'sorriso',
        'sospiro',
        'sostegno',
        'sovrano',
        'spaccare',
        'spada',
        'spagnolo',
        'spalla',
        'sparire',
        'spavento',
        'spazio',
        'specchio',
        'spedire',
        'spegnere',
        'spendere',
        'speranza',
        'spessore',
        'spezzare',
        'spiaggia',
        'spiccare',
        'spiegare',
        'spiffero',
        'spingere',
        'sponda',
        'sporcare',
        'spostare',
        'spremuta',
        'spugna',
        'spumante',
        'spuntare',
        'squadra',
        'squillo',
        'staccare',
        'stadio',
        'stagione',
        'stallone',
        'stampa',
        'stancare',
        'starnuto',
        'statura',
        'stella',
        'stendere',
        'sterzo',
        'stilista',
        'stimolo',
        'stinco',
        'stiva',
        'stoffa',
        'storia',
        'strada',
        'stregone',
        'striscia',
        'studiare',
        'stufa',
        'stupendo',
        'subire',
        'successo',
        'sudare',
        'suono',
        'superare',
        'supporto',
        'surfista',
        'sussurro',
        'svelto',
        'svenire',
        'sviluppo',
        'svolta',
        'svuotare',
        'tabacco',
        'tabella',
        'tabu',
        'tacchino',
        'tacere',
        'taglio',
        'talento',
        'tangente',
        'tappeto',
        'tartufo',
        'tassello',
        'tastiera',
        'tavolo',
        'tazza',
        'teatro',
        'tedesco',
        'telaio',
        'telefono',
        'tema',
        'temere',
        'tempo',
        'tendenza',
        'tenebre',
        'tensione',
        'tentare',
        'teologia',
        'teorema',
        'termica',
        'terrazzo',
        'teschio',
        'tesi',
        'tesoro',
        'tessera',
        'testa',
        'thriller',
        'tifoso',
        'tigre',
        'timbrare',
        'timido',
        'tinta',
        'tirare',
        'tisana',
        'titano',
        'titolo',
        'toccare',
        'togliere',
        'topolino',
        'torcia',
        'torrente',
        'tovaglia',
        'traffico',
        'tragitto',
        'training',
        'tramonto',
        'transito',
        'trapezio',
        'trasloco',
        'trattore',
        'trazione',
        'treccia',
        'tregua',
        'treno',
        'triciclo',
        'tridente',
        'trilogia',
        'tromba',
        'troncare',
        'trota',
        'trovare',
        'trucco',
        'tubo',
        'tulipano',
        'tumulto',
        'tunisia',
        'tuono',
        'turista',
        'tuta',
        'tutelare',
        'tutore',
        'ubriaco',
        'uccello',
        'udienza',
        'udito',
        'uffa',
        'umanoide',
        'umore',
        'unghia',
        'unguento',
        'unicorno',
        'unione',
        'universo',
        'uomo',
        'uragano',
        'uranio',
        'urlare',
        'uscire',
        'utente',
        'utilizzo',
        'vacanza',
        'vacca',
        'vaglio',
        'vagonata',
        'valle',
        'valore',
        'valutare',
        'valvola',
        'vampiro',
        'vaniglia',
        'vanto',
        'vapore',
        'variante',
        'vasca',
        'vaselina',
        'vassoio',
        'vedere',
        'vegetale',
        'veglia',
        'veicolo',
        'vela',
        'veleno',
        'velivolo',
        'velluto',
        'vendere',
        'venerare',
        'venire',
        'vento',
        'veranda',
        'verbo',
        'verdura',
        'vergine',
        'verifica',
        'vernice',
        'vero',
        'verruca',
        'versare',
        'vertebra',
        'vescica',
        'vespaio',
        'vestito',
        'vesuvio',
        'veterano',
        'vetro',
        'vetta',
        'viadotto',
        'viaggio',
        'vibrare',
        'vicenda',
        'vichingo',
        'vietare',
        'vigilare',
        'vigneto',
        'villa',
        'vincere',
        'violino',
        'vipera',
        'virgola',
        'virtuoso',
        'visita',
        'vita',
        'vitello',
        'vittima',
        'vivavoce',
        'vivere',
        'viziato',
        'voglia',
        'volare',
        'volpe',
        'volto',
        'volume',
        'vongole',
        'voragine',
        'vortice',
        'votare',
        'vulcano',
        'vuotare',
        'zabaione',
        'zaffiro',
        'zainetto',
        'zampa',
        'zanzara',
        'zattera',
        'zavorra',
        'zenzero',
        'zero',
        'zingaro',
        'zittire',
        'zoccolo',
        'zolfo',
        'zombie',
        'zucchero',
      ])
    );
    langs.push(
      new MnemonicLang('dutch', 'nl', 4, [
        'aalglad',
        'aalscholver',
        'aambeeld',
        'aangeef',
        'aanlandig',
        'aanvaard',
        'aanwakker',
        'aapmens',
        'aarten',
        'abdicatie',
        'abnormaal',
        'abrikoos',
        'accu',
        'acuut',
        'adjudant',
        'admiraal',
        'advies',
        'afbidding',
        'afdracht',
        'affaire',
        'affiche',
        'afgang',
        'afkick',
        'afknap',
        'aflees',
        'afmijner',
        'afname',
        'afpreekt',
        'afrader',
        'afspeel',
        'aftocht',
        'aftrek',
        'afzijdig',
        'ahornboom',
        'aktetas',
        'akzo',
        'alchemist',
        'alcohol',
        'aldaar',
        'alexander',
        'alfabet',
        'alfredo',
        'alice',
        'alikruik',
        'allrisk',
        'altsax',
        'alufolie',
        'alziend',
        'amai',
        'ambacht',
        'ambieer',
        'amina',
        'amnestie',
        'amok',
        'ampul',
        'amuzikaal',
        'angela',
        'aniek',
        'antje',
        'antwerpen',
        'anya',
        'aorta',
        'apache',
        'apekool',
        'appelaar',
        'arganolie',
        'argeloos',
        'armoede',
        'arrenslee',
        'artritis',
        'arubaan',
        'asbak',
        'ascii',
        'asgrauw',
        'asjes',
        'asml',
        'aspunt',
        'asurn',
        'asveld',
        'aterling',
        'atomair',
        'atrium',
        'atsma',
        'atypisch',
        'auping',
        'aura',
        'avifauna',
        'axiaal',
        'azoriaan',
        'azteek',
        'azuur',
        'bachelor',
        'badderen',
        'badhotel',
        'badmantel',
        'badsteden',
        'balie',
        'ballans',
        'balvers',
        'bamibal',
        'banneling',
        'barracuda',
        'basaal',
        'batelaan',
        'batje',
        'beambte',
        'bedlamp',
        'bedwelmd',
        'befaamd',
        'begierd',
        'begraaf',
        'behield',
        'beijaard',
        'bejaagd',
        'bekaaid',
        'beks',
        'bektas',
        'belaad',
        'belboei',
        'belderbos',
        'beloerd',
        'beluchten',
        'bemiddeld',
        'benadeeld',
        'benijd',
        'berechten',
        'beroemd',
        'besef',
        'besseling',
        'best',
        'betichten',
        'bevind',
        'bevochten',
        'bevraagd',
        'bewust',
        'bidplaats',
        'biefstuk',
        'biemans',
        'biezen',
        'bijbaan',
        'bijeenkom',
        'bijfiguur',
        'bijkaart',
        'bijlage',
        'bijpaard',
        'bijtgaar',
        'bijweg',
        'bimmel',
        'binck',
        'bint',
        'biobak',
        'biotisch',
        'biseks',
        'bistro',
        'bitter',
        'bitumen',
        'bizar',
        'blad',
        'bleken',
        'blender',
        'bleu',
        'blief',
        'blijven',
        'blozen',
        'bock',
        'boef',
        'boei',
        'boks',
        'bolder',
        'bolus',
        'bolvormig',
        'bomaanval',
        'bombarde',
        'bomma',
        'bomtapijt',
        'bookmaker',
        'boos',
        'borg',
        'bosbes',
        'boshuizen',
        'bosloop',
        'botanicus',
        'bougie',
        'bovag',
        'boxspring',
        'braad',
        'brasem',
        'brevet',
        'brigade',
        'brinckman',
        'bruid',
        'budget',
        'buffel',
        'buks',
        'bulgaar',
        'buma',
        'butaan',
        'butler',
        'buuf',
        'cactus',
        'cafeetje',
        'camcorder',
        'cannabis',
        'canyon',
        'capoeira',
        'capsule',
        'carkit',
        'casanova',
        'catalaan',
        'ceintuur',
        'celdeling',
        'celplasma',
        'cement',
        'censeren',
        'ceramisch',
        'cerberus',
        'cerebraal',
        'cesium',
        'cirkel',
        'citeer',
        'civiel',
        'claxon',
        'clenbuterol',
        'clicheren',
        'clijsen',
        'coalitie',
        'coassistentschap',
        'coaxiaal',
        'codetaal',
        'cofinanciering',
        'cognac',
        'coltrui',
        'comfort',
        'commandant',
        'condensaat',
        'confectie',
        'conifeer',
        'convector',
        'copier',
        'corfu',
        'correct',
        'coup',
        'couvert',
        'creatie',
        'credit',
        'crematie',
        'cricket',
        'croupier',
        'cruciaal',
        'cruijff',
        'cuisine',
        'culemborg',
        'culinair',
        'curve',
        'cyrano',
        'dactylus',
        'dading',
        'dagblind',
        'dagje',
        'daglicht',
        'dagprijs',
        'dagranden',
        'dakdekker',
        'dakpark',
        'dakterras',
        'dalgrond',
        'dambord',
        'damkat',
        'damlengte',
        'damman',
        'danenberg',
        'debbie',
        'decibel',
        'defect',
        'deformeer',
        'degelijk',
        'degradant',
        'dejonghe',
        'dekken',
        'deppen',
        'derek',
        'derf',
        'derhalve',
        'detineren',
        'devalueer',
        'diaken',
        'dicht',
        'dictaat',
        'dief',
        'digitaal',
        'dijbreuk',
        'dijkmans',
        'dimbaar',
        'dinsdag',
        'diode',
        'dirigeer',
        'disbalans',
        'dobermann',
        'doenbaar',
        'doerak',
        'dogma',
        'dokhaven',
        'dokwerker',
        'doling',
        'dolphijn',
        'dolven',
        'dombo',
        'dooraderd',
        'dopeling',
        'doping',
        'draderig',
        'drama',
        'drenkbak',
        'dreumes',
        'drol',
        'drug',
        'duaal',
        'dublin',
        'duplicaat',
        'durven',
        'dusdanig',
        'dutchbat',
        'dutje',
        'dutten',
        'duur',
        'duwwerk',
        'dwaal',
        'dweil',
        'dwing',
        'dyslexie',
        'ecostroom',
        'ecotaks',
        'educatie',
        'eeckhout',
        'eede',
        'eemland',
        'eencellig',
        'eeneiig',
        'eenruiter',
        'eenwinter',
        'eerenberg',
        'eerrover',
        'eersel',
        'eetmaal',
        'efteling',
        'egaal',
        'egtberts',
        'eickhoff',
        'eidooier',
        'eiland',
        'eind',
        'eisden',
        'ekster',
        'elburg',
        'elevatie',
        'elfkoppig',
        'elfrink',
        'elftal',
        'elimineer',
        'elleboog',
        'elma',
        'elodie',
        'elsa',
        'embleem',
        'embolie',
        'emoe',
        'emonds',
        'emplooi',
        'enduro',
        'enfin',
        'engageer',
        'entourage',
        'entstof',
        'epileer',
        'episch',
        'eppo',
        'erasmus',
        'erboven',
        'erebaan',
        'erelijst',
        'ereronden',
        'ereteken',
        'erfhuis',
        'erfwet',
        'erger',
        'erica',
        'ermitage',
        'erna',
        'ernie',
        'erts',
        'ertussen',
        'eruitzien',
        'ervaar',
        'erven',
        'erwt',
        'esbeek',
        'escort',
        'esdoorn',
        'essing',
        'etage',
        'eter',
        'ethanol',
        'ethicus',
        'etholoog',
        'eufonisch',
        'eurocent',
        'evacuatie',
        'exact',
        'examen',
        'executant',
        'exen',
        'exit',
        'exogeen',
        'exotherm',
        'expeditie',
        'expletief',
        'expres',
        'extase',
        'extinctie',
        'faal',
        'faam',
        'fabel',
        'facultair',
        'fakir',
        'fakkel',
        'faliekant',
        'fallisch',
        'famke',
        'fanclub',
        'fase',
        'fatsoen',
        'fauna',
        'federaal',
        'feedback',
        'feest',
        'feilbaar',
        'feitelijk',
        'felblauw',
        'figurante',
        'fiod',
        'fitheid',
        'fixeer',
        'flap',
        'fleece',
        'fleur',
        'flexibel',
        'flits',
        'flos',
        'flow',
        'fluweel',
        'foezelen',
        'fokkelman',
        'fokpaard',
        'fokvee',
        'folder',
        'follikel',
        'folmer',
        'folteraar',
        'fooi',
        'foolen',
        'forfait',
        'forint',
        'formule',
        'fornuis',
        'fosfaat',
        'foxtrot',
        'foyer',
        'fragiel',
        'frater',
        'freak',
        'freddie',
        'fregat',
        'freon',
        'frijnen',
        'fructose',
        'frunniken',
        'fuiven',
        'funshop',
        'furieus',
        'fysica',
        'gadget',
        'galder',
        'galei',
        'galg',
        'galvlieg',
        'galzuur',
        'ganesh',
        'gaswet',
        'gaza',
        'gazelle',
        'geaaid',
        'gebiecht',
        'gebufferd',
        'gedijd',
        'geef',
        'geflanst',
        'gefreesd',
        'gegaan',
        'gegijzeld',
        'gegniffel',
        'gegraaid',
        'gehikt',
        'gehobbeld',
        'gehucht',
        'geiser',
        'geiten',
        'gekaakt',
        'gekheid',
        'gekijf',
        'gekmakend',
        'gekocht',
        'gekskap',
        'gekte',
        'gelubberd',
        'gemiddeld',
        'geordend',
        'gepoederd',
        'gepuft',
        'gerda',
        'gerijpt',
        'geseald',
        'geshockt',
        'gesierd',
        'geslaagd',
        'gesnaaid',
        'getracht',
        'getwijfel',
        'geuit',
        'gevecht',
        'gevlagd',
        'gewicht',
        'gezaagd',
        'gezocht',
        'ghanees',
        'giebelen',
        'giechel',
        'giepmans',
        'gips',
        'giraal',
        'gistachtig',
        'gitaar',
        'glaasje',
        'gletsjer',
        'gleuf',
        'glibberen',
        'glijbaan',
        'gloren',
        'gluipen',
        'gluren',
        'gluur',
        'gnoe',
        'goddelijk',
        'godgans',
        'godschalk',
        'godzalig',
        'goeierd',
        'gogme',
        'goklustig',
        'gokwereld',
        'gonggrijp',
        'gonje',
        'goor',
        'grabbel',
        'graf',
        'graveer',
        'grif',
        'grolleman',
        'grom',
        'groosman',
        'grubben',
        'gruijs',
        'grut',
        'guacamole',
        'guido',
        'guppy',
        'haazen',
        'hachelijk',
        'haex',
        'haiku',
        'hakhout',
        'hakken',
        'hanegem',
        'hans',
        'hanteer',
        'harrie',
        'hazebroek',
        'hedonist',
        'heil',
        'heineken',
        'hekhuis',
        'hekman',
        'helbig',
        'helga',
        'helwegen',
        'hengelaar',
        'herkansen',
        'hermafrodiet',
        'hertaald',
        'hiaat',
        'hikspoors',
        'hitachi',
        'hitparade',
        'hobo',
        'hoeve',
        'holocaust',
        'hond',
        'honnepon',
        'hoogacht',
        'hotelbed',
        'hufter',
        'hugo',
        'huilbier',
        'hulk',
        'humus',
        'huwbaar',
        'huwelijk',
        'hype',
        'iconisch',
        'idema',
        'ideogram',
        'idolaat',
        'ietje',
        'ijker',
        'ijkheid',
        'ijklijn',
        'ijkmaat',
        'ijkwezen',
        'ijmuiden',
        'ijsbox',
        'ijsdag',
        'ijselijk',
        'ijskoud',
        'ilse',
        'immuun',
        'impliceer',
        'impuls',
        'inbijten',
        'inbuigen',
        'indijken',
        'induceer',
        'indy',
        'infecteer',
        'inhaak',
        'inkijk',
        'inluiden',
        'inmijnen',
        'inoefenen',
        'inpolder',
        'inrijden',
        'inslaan',
        'invitatie',
        'inwaaien',
        'ionisch',
        'isaac',
        'isolatie',
        'isotherm',
        'isra',
        'italiaan',
        'ivoor',
        'jacobs',
        'jakob',
        'jammen',
        'jampot',
        'jarig',
        'jehova',
        'jenever',
        'jezus',
        'joana',
        'jobdienst',
        'josua',
        'joule',
        'juich',
        'jurk',
        'juut',
        'kaas',
        'kabelaar',
        'kabinet',
        'kagenaar',
        'kajuit',
        'kalebas',
        'kalm',
        'kanjer',
        'kapucijn',
        'karregat',
        'kart',
        'katvanger',
        'katwijk',
        'kegelaar',
        'keiachtig',
        'keizer',
        'kenletter',
        'kerdijk',
        'keus',
        'kevlar',
        'kezen',
        'kickback',
        'kieviet',
        'kijken',
        'kikvors',
        'kilheid',
        'kilobit',
        'kilsdonk',
        'kipschnitzel',
        'kissebis',
        'klad',
        'klagelijk',
        'klak',
        'klapbaar',
        'klaver',
        'klene',
        'klets',
        'klijnhout',
        'klit',
        'klok',
        'klonen',
        'klotefilm',
        'kluif',
        'klumper',
        'klus',
        'knabbel',
        'knagen',
        'knaven',
        'kneedbaar',
        'knmi',
        'knul',
        'knus',
        'kokhals',
        'komiek',
        'komkommer',
        'kompaan',
        'komrij',
        'komvormig',
        'koning',
        'kopbal',
        'kopklep',
        'kopnagel',
        'koppejan',
        'koptekst',
        'kopwand',
        'koraal',
        'kosmisch',
        'kostbaar',
        'kram',
        'kraneveld',
        'kras',
        'kreling',
        'krengen',
        'kribbe',
        'krik',
        'kruid',
        'krulbol',
        'kuijper',
        'kuipbank',
        'kuit',
        'kuiven',
        'kutsmoes',
        'kuub',
        'kwak',
        'kwatong',
        'kwetsbaar',
        'kwezelaar',
        'kwijnen',
        'kwik',
        'kwinkslag',
        'kwitantie',
        'lading',
        'lakbeits',
        'lakken',
        'laklaag',
        'lakmoes',
        'lakwijk',
        'lamheid',
        'lamp',
        'lamsbout',
        'lapmiddel',
        'larve',
        'laser',
        'latijn',
        'latuw',
        'lawaai',
        'laxeerpil',
        'lebberen',
        'ledeboer',
        'leefbaar',
        'leeman',
        'lefdoekje',
        'lefhebber',
        'legboor',
        'legsel',
        'leguaan',
        'leiplaat',
        'lekdicht',
        'lekrijden',
        'leksteen',
        'lenen',
        'leraar',
        'lesbienne',
        'leugenaar',
        'leut',
        'lexicaal',
        'lezing',
        'lieten',
        'liggeld',
        'lijdzaam',
        'lijk',
        'lijmstang',
        'lijnschip',
        'likdoorn',
        'likken',
        'liksteen',
        'limburg',
        'link',
        'linoleum',
        'lipbloem',
        'lipman',
        'lispelen',
        'lissabon',
        'litanie',
        'liturgie',
        'lochem',
        'loempia',
        'loesje',
        'logheid',
        'lonen',
        'lonneke',
        'loom',
        'loos',
        'losbaar',
        'loslaten',
        'losplaats',
        'loting',
        'lotnummer',
        'lots',
        'louie',
        'lourdes',
        'louter',
        'lowbudget',
        'luijten',
        'luikenaar',
        'luilak',
        'luipaard',
        'luizenbos',
        'lulkoek',
        'lumen',
        'lunzen',
        'lurven',
        'lutjeboer',
        'luttel',
        'lutz',
        'luuk',
        'luwte',
        'luyendijk',
        'lyceum',
        'lynx',
        'maakbaar',
        'magdalena',
        'malheid',
        'manchet',
        'manfred',
        'manhaftig',
        'mank',
        'mantel',
        'marion',
        'marxist',
        'masmeijer',
        'massaal',
        'matsen',
        'matverf',
        'matze',
        'maude',
        'mayonaise',
        'mechanica',
        'meifeest',
        'melodie',
        'meppelink',
        'midvoor',
        'midweeks',
        'midzomer',
        'miezel',
        'mijnraad',
        'minus',
        'mirck',
        'mirte',
        'mispakken',
        'misraden',
        'miswassen',
        'mitella',
        'moker',
        'molecule',
        'mombakkes',
        'moonen',
        'mopperaar',
        'moraal',
        'morgana',
        'mormel',
        'mosselaar',
        'motregen',
        'mouw',
        'mufheid',
        'mutueel',
        'muzelman',
        'naaidoos',
        'naald',
        'nadeel',
        'nadruk',
        'nagy',
        'nahon',
        'naima',
        'nairobi',
        'napalm',
        'napels',
        'napijn',
        'napoleon',
        'narigheid',
        'narratief',
        'naseizoen',
        'nasibal',
        'navigatie',
        'nawijn',
        'negatief',
        'nekletsel',
        'nekwervel',
        'neolatijn',
        'neonataal',
        'neptunus',
        'nerd',
        'nest',
        'neuzelaar',
        'nihiliste',
        'nijenhuis',
        'nijging',
        'nijhoff',
        'nijl',
        'nijptang',
        'nippel',
        'nokkenas',
        'noordam',
        'noren',
        'normaal',
        'nottelman',
        'notulant',
        'nout',
        'nuance',
        'nuchter',
        'nudorp',
        'nulde',
        'nullijn',
        'nulmeting',
        'nunspeet',
        'nylon',
        'obelisk',
        'object',
        'oblie',
        'obsceen',
        'occlusie',
        'oceaan',
        'ochtend',
        'ockhuizen',
        'oerdom',
        'oergezond',
        'oerlaag',
        'oester',
        'okhuijsen',
        'olifant',
        'olijfboer',
        'omaans',
        'ombudsman',
        'omdat',
        'omdijken',
        'omdoen',
        'omgebouwd',
        'omkeer',
        'omkomen',
        'ommegaand',
        'ommuren',
        'omroep',
        'omruil',
        'omslaan',
        'omsmeden',
        'omvaar',
        'onaardig',
        'onedel',
        'onenig',
        'onheilig',
        'onrecht',
        'onroerend',
        'ontcijfer',
        'onthaal',
        'ontvallen',
        'ontzadeld',
        'onzacht',
        'onzin',
        'onzuiver',
        'oogappel',
        'ooibos',
        'ooievaar',
        'ooit',
        'oorarts',
        'oorhanger',
        'oorijzer',
        'oorklep',
        'oorschelp',
        'oorworm',
        'oorzaak',
        'opdagen',
        'opdien',
        'opdweilen',
        'opel',
        'opgebaard',
        'opinie',
        'opjutten',
        'opkijken',
        'opklaar',
        'opkuisen',
        'opkwam',
        'opnaaien',
        'opossum',
        'opsieren',
        'opsmeer',
        'optreden',
        'opvijzel',
        'opvlammen',
        'opwind',
        'oraal',
        'orchidee',
        'orkest',
        'ossuarium',
        'ostendorf',
        'oublie',
        'oudachtig',
        'oudbakken',
        'oudnoors',
        'oudshoorn',
        'oudtante',
        'oven',
        'over',
        'oxidant',
        'pablo',
        'pacht',
        'paktafel',
        'pakzadel',
        'paljas',
        'panharing',
        'papfles',
        'paprika',
        'parochie',
        'paus',
        'pauze',
        'paviljoen',
        'peek',
        'pegel',
        'peigeren',
        'pekela',
        'pendant',
        'penibel',
        'pepmiddel',
        'peptalk',
        'periferie',
        'perron',
        'pessarium',
        'peter',
        'petfles',
        'petgat',
        'peuk',
        'pfeifer',
        'picknick',
        'pief',
        'pieneman',
        'pijlkruid',
        'pijnacker',
        'pijpelink',
        'pikdonker',
        'pikeer',
        'pilaar',
        'pionier',
        'pipet',
        'piscine',
        'pissebed',
        'pitchen',
        'pixel',
        'plamuren',
        'plan',
        'plausibel',
        'plegen',
        'plempen',
        'pleonasme',
        'plezant',
        'podoloog',
        'pofmouw',
        'pokdalig',
        'ponywagen',
        'popachtig',
        'popidool',
        'porren',
        'positie',
        'potten',
        'pralen',
        'prezen',
        'prijzen',
        'privaat',
        'proef',
        'prooi',
        'prozawerk',
        'pruik',
        'prul',
        'publiceer',
        'puck',
        'puilen',
        'pukkelig',
        'pulveren',
        'pupil',
        'puppy',
        'purmerend',
        'pustjens',
        'putemmer',
        'puzzelaar',
        'queenie',
        'quiche',
        'raam',
        'raar',
        'raat',
        'raes',
        'ralf',
        'rally',
        'ramona',
        'ramselaar',
        'ranonkel',
        'rapen',
        'rapunzel',
        'rarekiek',
        'rarigheid',
        'rattenhol',
        'ravage',
        'reactie',
        'recreant',
        'redacteur',
        'redster',
        'reewild',
        'regie',
        'reijnders',
        'rein',
        'replica',
        'revanche',
        'rigide',
        'rijbaan',
        'rijdansen',
        'rijgen',
        'rijkdom',
        'rijles',
        'rijnwijn',
        'rijpma',
        'rijstafel',
        'rijtaak',
        'rijzwepen',
        'rioleer',
        'ripdeal',
        'riphagen',
        'riskant',
        'rits',
        'rivaal',
        'robbedoes',
        'robot',
        'rockact',
        'rodijk',
        'rogier',
        'rohypnol',
        'rollaag',
        'rolpaal',
        'roltafel',
        'roof',
        'roon',
        'roppen',
        'rosbief',
        'rosharig',
        'rosielle',
        'rotan',
        'rotleven',
        'rotten',
        'rotvaart',
        'royaal',
        'royeer',
        'rubato',
        'ruby',
        'ruche',
        'rudge',
        'ruggetje',
        'rugnummer',
        'rugpijn',
        'rugtitel',
        'rugzak',
        'ruilbaar',
        'ruis',
        'ruit',
        'rukwind',
        'rulijs',
        'rumoeren',
        'rumsdorp',
        'rumtaart',
        'runnen',
        'russchen',
        'ruwkruid',
        'saboteer',
        'saksisch',
        'salade',
        'salpeter',
        'sambabal',
        'samsam',
        'satelliet',
        'satineer',
        'saus',
        'scampi',
        'scarabee',
        'scenario',
        'schobben',
        'schubben',
        'scout',
        'secessie',
        'secondair',
        'seculair',
        'sediment',
        'seeland',
        'settelen',
        'setwinst',
        'sheriff',
        'shiatsu',
        'siciliaan',
        'sidderaal',
        'sigma',
        'sijben',
        'silvana',
        'simkaart',
        'sinds',
        'situatie',
        'sjaak',
        'sjardijn',
        'sjezen',
        'sjor',
        'skinhead',
        'skylab',
        'slamixen',
        'sleijpen',
        'slijkerig',
        'slordig',
        'slowaak',
        'sluieren',
        'smadelijk',
        'smiecht',
        'smoel',
        'smos',
        'smukken',
        'snackcar',
        'snavel',
        'sneaker',
        'sneu',
        'snijdbaar',
        'snit',
        'snorder',
        'soapbox',
        'soetekouw',
        'soigneren',
        'sojaboon',
        'solo',
        'solvabel',
        'somber',
        'sommatie',
        'soort',
        'soppen',
        'sopraan',
        'soundbar',
        'spanen',
        'spawater',
        'spijgat',
        'spinaal',
        'spionage',
        'spiraal',
        'spleet',
        'splijt',
        'spoed',
        'sporen',
        'spul',
        'spuug',
        'spuw',
        'stalen',
        'standaard',
        'star',
        'stefan',
        'stencil',
        'stijf',
        'stil',
        'stip',
        'stopdas',
        'stoten',
        'stoven',
        'straat',
        'strobbe',
        'strubbel',
        'stucadoor',
        'stuif',
        'stukadoor',
        'subhoofd',
        'subregent',
        'sudoku',
        'sukade',
        'sulfaat',
        'surinaams',
        'suus',
        'syfilis',
        'symboliek',
        'sympathie',
        'synagoge',
        'synchroon',
        'synergie',
        'systeem',
        'taanderij',
        'tabak',
        'tachtig',
        'tackelen',
        'taiwanees',
        'talman',
        'tamheid',
        'tangaslip',
        'taps',
        'tarkan',
        'tarwe',
        'tasman',
        'tatjana',
        'taxameter',
        'teil',
        'teisman',
        'telbaar',
        'telco',
        'telganger',
        'telstar',
        'tenant',
        'tepel',
        'terzet',
        'testament',
        'ticket',
        'tiesinga',
        'tijdelijk',
        'tika',
        'tiksel',
        'tilleman',
        'timbaal',
        'tinsteen',
        'tiplijn',
        'tippelaar',
        'tjirpen',
        'toezeggen',
        'tolbaas',
        'tolgeld',
        'tolhek',
        'tolo',
        'tolpoort',
        'toltarief',
        'tolvrij',
        'tomaat',
        'tondeuse',
        'toog',
        'tooi',
        'toonbaar',
        'toos',
        'topclub',
        'toppen',
        'toptalent',
        'topvrouw',
        'toque',
        'torment',
        'tornado',
        'tosti',
        'totdat',
        'toucheer',
        'toulouse',
        'tournedos',
        'tout',
        'trabant',
        'tragedie',
        'trailer',
        'traject',
        'traktaat',
        'trauma',
        'tray',
        'trechter',
        'tred',
        'tref',
        'treur',
        'troebel',
        'tros',
        'trucage',
        'truffel',
        'tsaar',
        'tucht',
        'tuenter',
        'tuitelig',
        'tukje',
        'tuktuk',
        'tulp',
        'tuma',
        'tureluurs',
        'twijfel',
        'twitteren',
        'tyfoon',
        'typograaf',
        'ugandees',
        'uiachtig',
        'uier',
        'uisnipper',
        'ultiem',
        'unitair',
        'uranium',
        'urbaan',
        'urendag',
        'ursula',
        'uurcirkel',
        'uurglas',
        'uzelf',
        'vaat',
        'vakantie',
        'vakleraar',
        'valbijl',
        'valpartij',
        'valreep',
        'valuatie',
        'vanmiddag',
        'vanonder',
        'varaan',
        'varken',
        'vaten',
        'veenbes',
        'veeteler',
        'velgrem',
        'vellekoop',
        'velvet',
        'veneberg',
        'venlo',
        'vent',
        'venusberg',
        'venw',
        'veredeld',
        'verf',
        'verhaaf',
        'vermaak',
        'vernaaid',
        'verraad',
        'vers',
        'veruit',
        'verzaagd',
        'vetachtig',
        'vetlok',
        'vetmesten',
        'veto',
        'vetrek',
        'vetstaart',
        'vetten',
        'veurink',
        'viaduct',
        'vibrafoon',
        'vicariaat',
        'vieux',
        'vieveen',
        'vijfvoud',
        'villa',
        'vilt',
        'vimmetje',
        'vindbaar',
        'vips',
        'virtueel',
        'visdieven',
        'visee',
        'visie',
        'vlaag',
        'vleugel',
        'vmbo',
        'vocht',
        'voesenek',
        'voicemail',
        'voip',
        'volg',
        'vork',
        'vorselaar',
        'voyeur',
        'vracht',
        'vrekkig',
        'vreten',
        'vrije',
        'vrozen',
        'vrucht',
        'vucht',
        'vugt',
        'vulkaan',
        'vulmiddel',
        'vulva',
        'vuren',
        'waas',
        'wacht',
        'wadvogel',
        'wafel',
        'waffel',
        'walhalla',
        'walnoot',
        'walraven',
        'wals',
        'walvis',
        'wandaad',
        'wanen',
        'wanmolen',
        'want',
        'warklomp',
        'warm',
        'wasachtig',
        'wasteil',
        'watt',
        'webhandel',
        'weblog',
        'webpagina',
        'webzine',
        'wedereis',
        'wedstrijd',
        'weeda',
        'weert',
        'wegmaaien',
        'wegscheer',
        'wekelijks',
        'wekken',
        'wekroep',
        'wektoon',
        'weldaad',
        'welwater',
        'wendbaar',
        'wenkbrauw',
        'wens',
        'wentelaar',
        'wervel',
        'wesseling',
        'wetboek',
        'wetmatig',
        'whirlpool',
        'wijbrands',
        'wijdbeens',
        'wijk',
        'wijnbes',
        'wijting',
        'wild',
        'wimpelen',
        'wingebied',
        'winplaats',
        'winter',
        'winzucht',
        'wipstaart',
        'wisgerhof',
        'withaar',
        'witmaker',
        'wokkel',
        'wolf',
        'wonenden',
        'woning',
        'worden',
        'worp',
        'wortel',
        'wrat',
        'wrijf',
        'wringen',
        'yoghurt',
        'ypsilon',
        'zaaijer',
        'zaak',
        'zacharias',
        'zakelijk',
        'zakkam',
        'zakwater',
        'zalf',
        'zalig',
        'zaniken',
        'zebracode',
        'zeeblauw',
        'zeef',
        'zeegaand',
        'zeeuw',
        'zege',
        'zegje',
        'zeil',
        'zesbaans',
        'zesenhalf',
        'zeskantig',
        'zesmaal',
        'zetbaas',
        'zetpil',
        'zeulen',
        'ziezo',
        'zigzag',
        'zijaltaar',
        'zijbeuk',
        'zijlijn',
        'zijmuur',
        'zijn',
        'zijwaarts',
        'zijzelf',
        'zilt',
        'zimmerman',
        'zinledig',
        'zinnelijk',
        'zionist',
        'zitdag',
        'zitruimte',
        'zitzak',
        'zoal',
        'zodoende',
        'zoekbots',
        'zoem',
        'zoiets',
        'zojuist',
        'zondaar',
        'zotskap',
        'zottebol',
        'zucht',
        'zuivel',
        'zulk',
        'zult',
        'zuster',
        'zuur',
        'zweedijk',
        'zwendel',
        'zwepen',
        'zwiep',
        'zwijmel',
        'zworen',
      ])
    );
    langs.push(
      new MnemonicLang('chinese', 'zh', 1, [
        '的',
        '一',
        '是',
        '在',
        '不',
        '了',
        '有',
        '和',
        '人',
        '这',
        '中',
        '大',
        '为',
        '上',
        '个',
        '国',
        '我',
        '以',
        '要',
        '他',
        '时',
        '来',
        '用',
        '们',
        '生',
        '到',
        '作',
        '地',
        '于',
        '出',
        '就',
        '分',
        '对',
        '成',
        '会',
        '可',
        '主',
        '发',
        '年',
        '动',
        '同',
        '工',
        '也',
        '能',
        '下',
        '过',
        '子',
        '说',
        '产',
        '种',
        '面',
        '而',
        '方',
        '后',
        '多',
        '定',
        '行',
        '学',
        '法',
        '所',
        '民',
        '得',
        '经',
        '十',
        '三',
        '之',
        '进',
        '着',
        '等',
        '部',
        '度',
        '家',
        '电',
        '力',
        '里',
        '如',
        '水',
        '化',
        '高',
        '自',
        '二',
        '理',
        '起',
        '小',
        '物',
        '现',
        '实',
        '加',
        '量',
        '都',
        '两',
        '体',
        '制',
        '机',
        '当',
        '使',
        '点',
        '从',
        '业',
        '本',
        '去',
        '把',
        '性',
        '好',
        '应',
        '开',
        '它',
        '合',
        '还',
        '因',
        '由',
        '其',
        '些',
        '然',
        '前',
        '外',
        '天',
        '政',
        '四',
        '日',
        '那',
        '社',
        '义',
        '事',
        '平',
        '形',
        '相',
        '全',
        '表',
        '间',
        '样',
        '与',
        '关',
        '各',
        '重',
        '新',
        '线',
        '内',
        '数',
        '正',
        '心',
        '反',
        '你',
        '明',
        '看',
        '原',
        '又',
        '么',
        '利',
        '比',
        '或',
        '但',
        '质',
        '气',
        '第',
        '向',
        '道',
        '命',
        '此',
        '变',
        '条',
        '只',
        '没',
        '结',
        '解',
        '问',
        '意',
        '建',
        '月',
        '公',
        '无',
        '系',
        '军',
        '很',
        '情',
        '者',
        '最',
        '立',
        '代',
        '想',
        '已',
        '通',
        '并',
        '提',
        '直',
        '题',
        '党',
        '程',
        '展',
        '五',
        '果',
        '料',
        '象',
        '员',
        '革',
        '位',
        '入',
        '常',
        '文',
        '总',
        '次',
        '品',
        '式',
        '活',
        '设',
        '及',
        '管',
        '特',
        '件',
        '长',
        '求',
        '老',
        '头',
        '基',
        '资',
        '边',
        '流',
        '路',
        '级',
        '少',
        '图',
        '山',
        '统',
        '接',
        '知',
        '较',
        '将',
        '组',
        '见',
        '计',
        '别',
        '她',
        '手',
        '角',
        '期',
        '根',
        '论',
        '运',
        '农',
        '指',
        '几',
        '九',
        '区',
        '强',
        '放',
        '决',
        '西',
        '被',
        '干',
        '做',
        '必',
        '战',
        '先',
        '回',
        '则',
        '任',
        '取',
        '据',
        '处',
        '队',
        '南',
        '给',
        '色',
        '光',
        '门',
        '即',
        '保',
        '治',
        '北',
        '造',
        '百',
        '规',
        '热',
        '领',
        '七',
        '海',
        '口',
        '东',
        '导',
        '器',
        '压',
        '志',
        '世',
        '金',
        '增',
        '争',
        '济',
        '阶',
        '油',
        '思',
        '术',
        '极',
        '交',
        '受',
        '联',
        '什',
        '认',
        '六',
        '共',
        '权',
        '收',
        '证',
        '改',
        '清',
        '美',
        '再',
        '采',
        '转',
        '更',
        '单',
        '风',
        '切',
        '打',
        '白',
        '教',
        '速',
        '花',
        '带',
        '安',
        '场',
        '身',
        '车',
        '例',
        '真',
        '务',
        '具',
        '万',
        '每',
        '目',
        '至',
        '达',
        '走',
        '积',
        '示',
        '议',
        '声',
        '报',
        '斗',
        '完',
        '类',
        '八',
        '离',
        '华',
        '名',
        '确',
        '才',
        '科',
        '张',
        '信',
        '马',
        '节',
        '话',
        '米',
        '整',
        '空',
        '元',
        '况',
        '今',
        '集',
        '温',
        '传',
        '土',
        '许',
        '步',
        '群',
        '广',
        '石',
        '记',
        '需',
        '段',
        '研',
        '界',
        '拉',
        '林',
        '律',
        '叫',
        '且',
        '究',
        '观',
        '越',
        '织',
        '装',
        '影',
        '算',
        '低',
        '持',
        '音',
        '众',
        '书',
        '布',
        '复',
        '容',
        '儿',
        '须',
        '际',
        '商',
        '非',
        '验',
        '连',
        '断',
        '深',
        '难',
        '近',
        '矿',
        '千',
        '周',
        '委',
        '素',
        '技',
        '备',
        '半',
        '办',
        '青',
        '省',
        '列',
        '习',
        '响',
        '约',
        '支',
        '般',
        '史',
        '感',
        '劳',
        '便',
        '团',
        '往',
        '酸',
        '历',
        '市',
        '克',
        '何',
        '除',
        '消',
        '构',
        '府',
        '称',
        '太',
        '准',
        '精',
        '值',
        '号',
        '率',
        '族',
        '维',
        '划',
        '选',
        '标',
        '写',
        '存',
        '候',
        '毛',
        '亲',
        '快',
        '效',
        '斯',
        '院',
        '查',
        '江',
        '型',
        '眼',
        '王',
        '按',
        '格',
        '养',
        '易',
        '置',
        '派',
        '层',
        '片',
        '始',
        '却',
        '专',
        '状',
        '育',
        '厂',
        '京',
        '识',
        '适',
        '属',
        '圆',
        '包',
        '火',
        '住',
        '调',
        '满',
        '县',
        '局',
        '照',
        '参',
        '红',
        '细',
        '引',
        '听',
        '该',
        '铁',
        '价',
        '严',
        '首',
        '底',
        '液',
        '官',
        '德',
        '随',
        '病',
        '苏',
        '失',
        '尔',
        '死',
        '讲',
        '配',
        '女',
        '黄',
        '推',
        '显',
        '谈',
        '罪',
        '神',
        '艺',
        '呢',
        '席',
        '含',
        '企',
        '望',
        '密',
        '批',
        '营',
        '项',
        '防',
        '举',
        '球',
        '英',
        '氧',
        '势',
        '告',
        '李',
        '台',
        '落',
        '木',
        '帮',
        '轮',
        '破',
        '亚',
        '师',
        '围',
        '注',
        '远',
        '字',
        '材',
        '排',
        '供',
        '河',
        '态',
        '封',
        '另',
        '施',
        '减',
        '树',
        '溶',
        '怎',
        '止',
        '案',
        '言',
        '士',
        '均',
        '武',
        '固',
        '叶',
        '鱼',
        '波',
        '视',
        '仅',
        '费',
        '紧',
        '爱',
        '左',
        '章',
        '早',
        '朝',
        '害',
        '续',
        '轻',
        '服',
        '试',
        '食',
        '充',
        '兵',
        '源',
        '判',
        '护',
        '司',
        '足',
        '某',
        '练',
        '差',
        '致',
        '板',
        '田',
        '降',
        '黑',
        '犯',
        '负',
        '击',
        '范',
        '继',
        '兴',
        '似',
        '余',
        '坚',
        '曲',
        '输',
        '修',
        '故',
        '城',
        '夫',
        '够',
        '送',
        '笔',
        '船',
        '占',
        '右',
        '财',
        '吃',
        '富',
        '春',
        '职',
        '觉',
        '汉',
        '画',
        '功',
        '巴',
        '跟',
        '虽',
        '杂',
        '飞',
        '检',
        '吸',
        '助',
        '升',
        '阳',
        '互',
        '初',
        '创',
        '抗',
        '考',
        '投',
        '坏',
        '策',
        '古',
        '径',
        '换',
        '未',
        '跑',
        '留',
        '钢',
        '曾',
        '端',
        '责',
        '站',
        '简',
        '述',
        '钱',
        '副',
        '尽',
        '帝',
        '射',
        '草',
        '冲',
        '承',
        '独',
        '令',
        '限',
        '阿',
        '宣',
        '环',
        '双',
        '请',
        '超',
        '微',
        '让',
        '控',
        '州',
        '良',
        '轴',
        '找',
        '否',
        '纪',
        '益',
        '依',
        '优',
        '顶',
        '础',
        '载',
        '倒',
        '房',
        '突',
        '坐',
        '粉',
        '敌',
        '略',
        '客',
        '袁',
        '冷',
        '胜',
        '绝',
        '析',
        '块',
        '剂',
        '测',
        '丝',
        '协',
        '诉',
        '念',
        '陈',
        '仍',
        '罗',
        '盐',
        '友',
        '洋',
        '错',
        '苦',
        '夜',
        '刑',
        '移',
        '频',
        '逐',
        '靠',
        '混',
        '母',
        '短',
        '皮',
        '终',
        '聚',
        '汽',
        '村',
        '云',
        '哪',
        '既',
        '距',
        '卫',
        '停',
        '烈',
        '央',
        '察',
        '烧',
        '迅',
        '境',
        '若',
        '印',
        '洲',
        '刻',
        '括',
        '激',
        '孔',
        '搞',
        '甚',
        '室',
        '待',
        '核',
        '校',
        '散',
        '侵',
        '吧',
        '甲',
        '游',
        '久',
        '菜',
        '味',
        '旧',
        '模',
        '湖',
        '货',
        '损',
        '预',
        '阻',
        '毫',
        '普',
        '稳',
        '乙',
        '妈',
        '植',
        '息',
        '扩',
        '银',
        '语',
        '挥',
        '酒',
        '守',
        '拿',
        '序',
        '纸',
        '医',
        '缺',
        '雨',
        '吗',
        '针',
        '刘',
        '啊',
        '急',
        '唱',
        '误',
        '训',
        '愿',
        '审',
        '附',
        '获',
        '茶',
        '鲜',
        '粮',
        '斤',
        '孩',
        '脱',
        '硫',
        '肥',
        '善',
        '龙',
        '演',
        '父',
        '渐',
        '血',
        '欢',
        '械',
        '掌',
        '歌',
        '沙',
        '刚',
        '攻',
        '谓',
        '盾',
        '讨',
        '晚',
        '粒',
        '乱',
        '燃',
        '矛',
        '乎',
        '杀',
        '药',
        '宁',
        '鲁',
        '贵',
        '钟',
        '煤',
        '读',
        '班',
        '伯',
        '香',
        '介',
        '迫',
        '句',
        '丰',
        '培',
        '握',
        '兰',
        '担',
        '弦',
        '蛋',
        '沉',
        '假',
        '穿',
        '执',
        '答',
        '乐',
        '谁',
        '顺',
        '烟',
        '缩',
        '征',
        '脸',
        '喜',
        '松',
        '脚',
        '困',
        '异',
        '免',
        '背',
        '星',
        '福',
        '买',
        '染',
        '井',
        '概',
        '慢',
        '怕',
        '磁',
        '倍',
        '祖',
        '皇',
        '促',
        '静',
        '补',
        '评',
        '翻',
        '肉',
        '践',
        '尼',
        '衣',
        '宽',
        '扬',
        '棉',
        '希',
        '伤',
        '操',
        '垂',
        '秋',
        '宜',
        '氢',
        '套',
        '督',
        '振',
        '架',
        '亮',
        '末',
        '宪',
        '庆',
        '编',
        '牛',
        '触',
        '映',
        '雷',
        '销',
        '诗',
        '座',
        '居',
        '抓',
        '裂',
        '胞',
        '呼',
        '娘',
        '景',
        '威',
        '绿',
        '晶',
        '厚',
        '盟',
        '衡',
        '鸡',
        '孙',
        '延',
        '危',
        '胶',
        '屋',
        '乡',
        '临',
        '陆',
        '顾',
        '掉',
        '呀',
        '灯',
        '岁',
        '措',
        '束',
        '耐',
        '剧',
        '玉',
        '赵',
        '跳',
        '哥',
        '季',
        '课',
        '凯',
        '胡',
        '额',
        '款',
        '绍',
        '卷',
        '齐',
        '伟',
        '蒸',
        '殖',
        '永',
        '宗',
        '苗',
        '川',
        '炉',
        '岩',
        '弱',
        '零',
        '杨',
        '奏',
        '沿',
        '露',
        '杆',
        '探',
        '滑',
        '镇',
        '饭',
        '浓',
        '航',
        '怀',
        '赶',
        '库',
        '夺',
        '伊',
        '灵',
        '税',
        '途',
        '灭',
        '赛',
        '归',
        '召',
        '鼓',
        '播',
        '盘',
        '裁',
        '险',
        '康',
        '唯',
        '录',
        '菌',
        '纯',
        '借',
        '糖',
        '盖',
        '横',
        '符',
        '私',
        '努',
        '堂',
        '域',
        '枪',
        '润',
        '幅',
        '哈',
        '竟',
        '熟',
        '虫',
        '泽',
        '脑',
        '壤',
        '碳',
        '欧',
        '遍',
        '侧',
        '寨',
        '敢',
        '彻',
        '虑',
        '斜',
        '薄',
        '庭',
        '纳',
        '弹',
        '饲',
        '伸',
        '折',
        '麦',
        '湿',
        '暗',
        '荷',
        '瓦',
        '塞',
        '床',
        '筑',
        '恶',
        '户',
        '访',
        '塔',
        '奇',
        '透',
        '梁',
        '刀',
        '旋',
        '迹',
        '卡',
        '氯',
        '遇',
        '份',
        '毒',
        '泥',
        '退',
        '洗',
        '摆',
        '灰',
        '彩',
        '卖',
        '耗',
        '夏',
        '择',
        '忙',
        '铜',
        '献',
        '硬',
        '予',
        '繁',
        '圈',
        '雪',
        '函',
        '亦',
        '抽',
        '篇',
        '阵',
        '阴',
        '丁',
        '尺',
        '追',
        '堆',
        '雄',
        '迎',
        '泛',
        '爸',
        '楼',
        '避',
        '谋',
        '吨',
        '野',
        '猪',
        '旗',
        '累',
        '偏',
        '典',
        '馆',
        '索',
        '秦',
        '脂',
        '潮',
        '爷',
        '豆',
        '忽',
        '托',
        '惊',
        '塑',
        '遗',
        '愈',
        '朱',
        '替',
        '纤',
        '粗',
        '倾',
        '尚',
        '痛',
        '楚',
        '谢',
        '奋',
        '购',
        '磨',
        '君',
        '池',
        '旁',
        '碎',
        '骨',
        '监',
        '捕',
        '弟',
        '暴',
        '割',
        '贯',
        '殊',
        '释',
        '词',
        '亡',
        '壁',
        '顿',
        '宝',
        '午',
        '尘',
        '闻',
        '揭',
        '炮',
        '残',
        '冬',
        '桥',
        '妇',
        '警',
        '综',
        '招',
        '吴',
        '付',
        '浮',
        '遭',
        '徐',
        '您',
        '摇',
        '谷',
        '赞',
        '箱',
        '隔',
        '订',
        '男',
        '吹',
        '园',
        '纷',
        '唐',
        '败',
        '宋',
        '玻',
        '巨',
        '耕',
        '坦',
        '荣',
        '闭',
        '湾',
        '键',
        '凡',
        '驻',
        '锅',
        '救',
        '恩',
        '剥',
        '凝',
        '碱',
        '齿',
        '截',
        '炼',
        '麻',
        '纺',
        '禁',
        '废',
        '盛',
        '版',
        '缓',
        '净',
        '睛',
        '昌',
        '婚',
        '涉',
        '筒',
        '嘴',
        '插',
        '岸',
        '朗',
        '庄',
        '街',
        '藏',
        '姑',
        '贸',
        '腐',
        '奴',
        '啦',
        '惯',
        '乘',
        '伙',
        '恢',
        '匀',
        '纱',
        '扎',
        '辩',
        '耳',
        '彪',
        '臣',
        '亿',
        '璃',
        '抵',
        '脉',
        '秀',
        '萨',
        '俄',
        '网',
        '舞',
        '店',
        '喷',
        '纵',
        '寸',
        '汗',
        '挂',
        '洪',
        '贺',
        '闪',
        '柬',
        '爆',
        '烯',
        '津',
        '稻',
        '墙',
        '软',
        '勇',
        '像',
        '滚',
        '厘',
        '蒙',
        '芳',
        '肯',
        '坡',
        '柱',
        '荡',
        '腿',
        '仪',
        '旅',
        '尾',
        '轧',
        '冰',
        '贡',
        '登',
        '黎',
        '削',
        '钻',
        '勒',
        '逃',
        '障',
        '氨',
        '郭',
        '峰',
        '币',
        '港',
        '伏',
        '轨',
        '亩',
        '毕',
        '擦',
        '莫',
        '刺',
        '浪',
        '秘',
        '援',
        '株',
        '健',
        '售',
        '股',
        '岛',
        '甘',
        '泡',
        '睡',
        '童',
        '铸',
        '汤',
        '阀',
        '休',
        '汇',
        '舍',
        '牧',
        '绕',
        '炸',
        '哲',
        '磷',
        '绩',
        '朋',
        '淡',
        '尖',
        '启',
        '陷',
        '柴',
        '呈',
        '徒',
        '颜',
        '泪',
        '稍',
        '忘',
        '泵',
        '蓝',
        '拖',
        '洞',
        '授',
        '镜',
        '辛',
        '壮',
        '锋',
        '贫',
        '虚',
        '弯',
        '摩',
        '泰',
        '幼',
        '廷',
        '尊',
        '窗',
        '纲',
        '弄',
        '隶',
        '疑',
        '氏',
        '宫',
        '姐',
        '震',
        '瑞',
        '怪',
        '尤',
        '琴',
        '循',
        '描',
        '膜',
        '违',
        '夹',
        '腰',
        '缘',
        '珠',
        '穷',
        '森',
        '枝',
        '竹',
        '沟',
        '催',
        '绳',
        '忆',
        '邦',
        '剩',
        '幸',
        '浆',
        '栏',
        '拥',
        '牙',
        '贮',
        '礼',
        '滤',
        '钠',
        '纹',
        '罢',
        '拍',
        '咱',
        '喊',
        '袖',
        '埃',
        '勤',
        '罚',
        '焦',
        '潜',
        '伍',
        '墨',
        '欲',
        '缝',
        '姓',
        '刊',
        '饱',
        '仿',
        '奖',
        '铝',
        '鬼',
        '丽',
        '跨',
        '默',
        '挖',
        '链',
        '扫',
        '喝',
        '袋',
        '炭',
        '污',
        '幕',
        '诸',
        '弧',
        '励',
        '梅',
        '奶',
        '洁',
        '灾',
        '舟',
        '鉴',
        '苯',
        '讼',
        '抱',
        '毁',
        '懂',
        '寒',
        '智',
        '埔',
        '寄',
        '届',
        '跃',
        '渡',
        '挑',
        '丹',
        '艰',
        '贝',
        '碰',
        '拔',
        '爹',
        '戴',
        '码',
        '梦',
        '芽',
        '熔',
        '赤',
        '渔',
        '哭',
        '敬',
        '颗',
        '奔',
        '铅',
        '仲',
        '虎',
        '稀',
        '妹',
        '乏',
        '珍',
        '申',
        '桌',
        '遵',
        '允',
        '隆',
        '螺',
        '仓',
        '魏',
        '锐',
        '晓',
        '氮',
        '兼',
        '隐',
        '碍',
        '赫',
        '拨',
        '忠',
        '肃',
        '缸',
        '牵',
        '抢',
        '博',
        '巧',
        '壳',
        '兄',
        '杜',
        '讯',
        '诚',
        '碧',
        '祥',
        '柯',
        '页',
        '巡',
        '矩',
        '悲',
        '灌',
        '龄',
        '伦',
        '票',
        '寻',
        '桂',
        '铺',
        '圣',
        '恐',
        '恰',
        '郑',
        '趣',
        '抬',
        '荒',
        '腾',
        '贴',
        '柔',
        '滴',
        '猛',
        '阔',
        '辆',
        '妻',
        '填',
        '撤',
        '储',
        '签',
        '闹',
        '扰',
        '紫',
        '砂',
        '递',
        '戏',
        '吊',
        '陶',
        '伐',
        '喂',
        '疗',
        '瓶',
        '婆',
        '抚',
        '臂',
        '摸',
        '忍',
        '虾',
        '蜡',
        '邻',
        '胸',
        '巩',
        '挤',
        '偶',
        '弃',
        '槽',
        '劲',
        '乳',
        '邓',
        '吉',
        '仁',
        '烂',
        '砖',
        '租',
        '乌',
        '舰',
        '伴',
        '瓜',
        '浅',
        '丙',
        '暂',
        '燥',
        '橡',
        '柳',
        '迷',
        '暖',
        '牌',
        '秧',
        '胆',
        '详',
        '簧',
        '踏',
        '瓷',
        '谱',
        '呆',
        '宾',
        '糊',
        '洛',
        '辉',
        '愤',
        '竞',
        '隙',
        '怒',
        '粘',
        '乃',
        '绪',
        '肩',
        '籍',
        '敏',
        '涂',
        '熙',
        '皆',
        '侦',
        '悬',
        '掘',
        '享',
        '纠',
        '醒',
        '狂',
        '锁',
        '淀',
        '恨',
        '牲',
        '霸',
        '爬',
        '赏',
        '逆',
        '玩',
        '陵',
        '祝',
        '秒',
        '浙',
        '貌',
      ])
    );
    langs.push(
      new MnemonicLang('russian', 'ru', 4, [
        'абажур',
        'абзац',
        'абонент',
        'абрикос',
        'абсурд',
        'авангард',
        'август',
        'авиация',
        'авоська',
        'автор',
        'агат',
        'агент',
        'агитатор',
        'агнец',
        'агония',
        'агрегат',
        'адвокат',
        'адмирал',
        'адрес',
        'ажиотаж',
        'азарт',
        'азбука',
        'азот',
        'аист',
        'айсберг',
        'академия',
        'аквариум',
        'аккорд',
        'акробат',
        'аксиома',
        'актер',
        'акула',
        'акция',
        'алгоритм',
        'алебарда',
        'аллея',
        'алмаз',
        'алтарь',
        'алфавит',
        'алхимик',
        'алый',
        'альбом',
        'алюминий',
        'амбар',
        'аметист',
        'амнезия',
        'ампула',
        'амфора',
        'анализ',
        'ангел',
        'анекдот',
        'анимация',
        'анкета',
        'аномалия',
        'ансамбль',
        'антенна',
        'апатия',
        'апельсин',
        'апофеоз',
        'аппарат',
        'апрель',
        'аптека',
        'арабский',
        'арбуз',
        'аргумент',
        'арест',
        'ария',
        'арка',
        'армия',
        'аромат',
        'арсенал',
        'артист',
        'архив',
        'аршин',
        'асбест',
        'аскетизм',
        'аспект',
        'ассорти',
        'астроном',
        'асфальт',
        'атака',
        'ателье',
        'атлас',
        'атом',
        'атрибут',
        'аудитор',
        'аукцион',
        'аура',
        'афера',
        'афиша',
        'ахинея',
        'ацетон',
        'аэропорт',
        'бабушка',
        'багаж',
        'бадья',
        'база',
        'баклажан',
        'балкон',
        'бампер',
        'банк',
        'барон',
        'бассейн',
        'батарея',
        'бахрома',
        'башня',
        'баян',
        'бегство',
        'бедро',
        'бездна',
        'бекон',
        'белый',
        'бензин',
        'берег',
        'беседа',
        'бетонный',
        'биатлон',
        'библия',
        'бивень',
        'бигуди',
        'бидон',
        'бизнес',
        'бикини',
        'билет',
        'бинокль',
        'биология',
        'биржа',
        'бисер',
        'битва',
        'бицепс',
        'благо',
        'бледный',
        'близкий',
        'блок',
        'блуждать',
        'блюдо',
        'бляха',
        'бобер',
        'богатый',
        'бодрый',
        'боевой',
        'бокал',
        'большой',
        'борьба',
        'босой',
        'ботинок',
        'боцман',
        'бочка',
        'боярин',
        'брать',
        'бревно',
        'бригада',
        'бросать',
        'брызги',
        'брюки',
        'бублик',
        'бугор',
        'будущее',
        'буква',
        'бульвар',
        'бумага',
        'бунт',
        'бурный',
        'бусы',
        'бутылка',
        'буфет',
        'бухта',
        'бушлат',
        'бывалый',
        'быль',
        'быстрый',
        'быть',
        'бюджет',
        'бюро',
        'бюст',
        'вагон',
        'важный',
        'ваза',
        'вакцина',
        'валюта',
        'вампир',
        'ванная',
        'вариант',
        'вассал',
        'вата',
        'вафля',
        'вахта',
        'вдова',
        'вдыхать',
        'ведущий',
        'веер',
        'вежливый',
        'везти',
        'веко',
        'великий',
        'вена',
        'верить',
        'веселый',
        'ветер',
        'вечер',
        'вешать',
        'вещь',
        'веяние',
        'взаимный',
        'взбучка',
        'взвод',
        'взгляд',
        'вздыхать',
        'взлетать',
        'взмах',
        'взнос',
        'взор',
        'взрыв',
        'взывать',
        'взятка',
        'вибрация',
        'визит',
        'вилка',
        'вино',
        'вирус',
        'висеть',
        'витрина',
        'вихрь',
        'вишневый',
        'включать',
        'вкус',
        'власть',
        'влечь',
        'влияние',
        'влюблять',
        'внешний',
        'внимание',
        'внук',
        'внятный',
        'вода',
        'воевать',
        'вождь',
        'воздух',
        'войти',
        'вокзал',
        'волос',
        'вопрос',
        'ворота',
        'восток',
        'впадать',
        'впускать',
        'врач',
        'время',
        'вручать',
        'всадник',
        'всеобщий',
        'вспышка',
        'встреча',
        'вторник',
        'вулкан',
        'вурдалак',
        'входить',
        'въезд',
        'выбор',
        'вывод',
        'выгодный',
        'выделять',
        'выезжать',
        'выживать',
        'вызывать',
        'выигрыш',
        'вылезать',
        'выносить',
        'выпивать',
        'высокий',
        'выходить',
        'вычет',
        'вышка',
        'выяснять',
        'вязать',
        'вялый',
        'гавань',
        'гадать',
        'газета',
        'гаишник',
        'галстук',
        'гамма',
        'гарантия',
        'гастроли',
        'гвардия',
        'гвоздь',
        'гектар',
        'гель',
        'генерал',
        'геолог',
        'герой',
        'гешефт',
        'гибель',
        'гигант',
        'гильза',
        'гимн',
        'гипотеза',
        'гитара',
        'глаз',
        'глина',
        'глоток',
        'глубокий',
        'глыба',
        'глядеть',
        'гнать',
        'гнев',
        'гнить',
        'гном',
        'гнуть',
        'говорить',
        'годовой',
        'голова',
        'гонка',
        'город',
        'гость',
        'готовый',
        'граница',
        'грех',
        'гриб',
        'громкий',
        'группа',
        'грызть',
        'грязный',
        'губа',
        'гудеть',
        'гулять',
        'гуманный',
        'густой',
        'гуща',
        'давать',
        'далекий',
        'дама',
        'данные',
        'дарить',
        'дать',
        'дача',
        'дверь',
        'движение',
        'двор',
        'дебют',
        'девушка',
        'дедушка',
        'дежурный',
        'дезертир',
        'действие',
        'декабрь',
        'дело',
        'демократ',
        'день',
        'депутат',
        'держать',
        'десяток',
        'детский',
        'дефицит',
        'дешевый',
        'деятель',
        'джаз',
        'джинсы',
        'джунгли',
        'диалог',
        'диван',
        'диета',
        'дизайн',
        'дикий',
        'динамика',
        'диплом',
        'директор',
        'диск',
        'дитя',
        'дичь',
        'длинный',
        'дневник',
        'добрый',
        'доверие',
        'договор',
        'дождь',
        'доза',
        'документ',
        'должен',
        'домашний',
        'допрос',
        'дорога',
        'доход',
        'доцент',
        'дочь',
        'дощатый',
        'драка',
        'древний',
        'дрожать',
        'друг',
        'дрянь',
        'дубовый',
        'дуга',
        'дудка',
        'дукат',
        'дуло',
        'думать',
        'дупло',
        'дурак',
        'дуть',
        'духи',
        'душа',
        'дуэт',
        'дымить',
        'дыня',
        'дыра',
        'дыханье',
        'дышать',
        'дьявол',
        'дюжина',
        'дюйм',
        'дюна',
        'дядя',
        'дятел',
        'егерь',
        'единый',
        'едкий',
        'ежевика',
        'ежик',
        'езда',
        'елка',
        'емкость',
        'ерунда',
        'ехать',
        'жадный',
        'жажда',
        'жалеть',
        'жанр',
        'жара',
        'жать',
        'жгучий',
        'ждать',
        'жевать',
        'желание',
        'жемчуг',
        'женщина',
        'жертва',
        'жесткий',
        'жечь',
        'живой',
        'жидкость',
        'жизнь',
        'жилье',
        'жирный',
        'житель',
        'журнал',
        'жюри',
        'забывать',
        'завод',
        'загадка',
        'задача',
        'зажечь',
        'зайти',
        'закон',
        'замечать',
        'занимать',
        'западный',
        'зарплата',
        'засыпать',
        'затрата',
        'захват',
        'зацепка',
        'зачет',
        'защита',
        'заявка',
        'звать',
        'звезда',
        'звонить',
        'звук',
        'здание',
        'здешний',
        'здоровье',
        'зебра',
        'зевать',
        'зеленый',
        'земля',
        'зенит',
        'зеркало',
        'зефир',
        'зигзаг',
        'зима',
        'зиять',
        'злак',
        'злой',
        'змея',
        'знать',
        'зной',
        'зодчий',
        'золотой',
        'зомби',
        'зона',
        'зоопарк',
        'зоркий',
        'зрачок',
        'зрение',
        'зритель',
        'зубной',
        'зыбкий',
        'зять',
        'игла',
        'иголка',
        'играть',
        'идея',
        'идиот',
        'идол',
        'идти',
        'иерархия',
        'избрать',
        'известие',
        'изгонять',
        'издание',
        'излагать',
        'изменять',
        'износ',
        'изоляция',
        'изрядный',
        'изучать',
        'изымать',
        'изящный',
        'икона',
        'икра',
        'иллюзия',
        'имбирь',
        'иметь',
        'имидж',
        'иммунный',
        'империя',
        'инвестор',
        'индивид',
        'инерция',
        'инженер',
        'иномарка',
        'институт',
        'интерес',
        'инфекция',
        'инцидент',
        'ипподром',
        'ирис',
        'ирония',
        'искать',
        'история',
        'исходить',
        'исчезать',
        'итог',
        'июль',
        'июнь',
        'кабинет',
        'кавалер',
        'кадр',
        'казарма',
        'кайф',
        'кактус',
        'калитка',
        'камень',
        'канал',
        'капитан',
        'картина',
        'касса',
        'катер',
        'кафе',
        'качество',
        'каша',
        'каюта',
        'квартира',
        'квинтет',
        'квота',
        'кедр',
        'кекс',
        'кенгуру',
        'кепка',
        'керосин',
        'кетчуп',
        'кефир',
        'кибитка',
        'кивнуть',
        'кидать',
        'километр',
        'кино',
        'киоск',
        'кипеть',
        'кирпич',
        'кисть',
        'китаец',
        'класс',
        'клетка',
        'клиент',
        'клоун',
        'клуб',
        'клык',
        'ключ',
        'клятва',
        'книга',
        'кнопка',
        'кнут',
        'князь',
        'кобура',
        'ковер',
        'коготь',
        'кодекс',
        'кожа',
        'козел',
        'койка',
        'коктейль',
        'колено',
        'компания',
        'конец',
        'копейка',
        'короткий',
        'костюм',
        'котел',
        'кофе',
        'кошка',
        'красный',
        'кресло',
        'кричать',
        'кровь',
        'крупный',
        'крыша',
        'крючок',
        'кубок',
        'кувшин',
        'кудрявый',
        'кузов',
        'кукла',
        'культура',
        'кумир',
        'купить',
        'курс',
        'кусок',
        'кухня',
        'куча',
        'кушать',
        'кювет',
        'лабиринт',
        'лавка',
        'лагерь',
        'ладонь',
        'лазерный',
        'лайнер',
        'лакей',
        'лампа',
        'ландшафт',
        'лапа',
        'ларек',
        'ласковый',
        'лауреат',
        'лачуга',
        'лаять',
        'лгать',
        'лебедь',
        'левый',
        'легкий',
        'ледяной',
        'лежать',
        'лекция',
        'лента',
        'лепесток',
        'лесной',
        'лето',
        'лечь',
        'леший',
        'лживый',
        'либерал',
        'ливень',
        'лига',
        'лидер',
        'ликовать',
        'лиловый',
        'лимон',
        'линия',
        'липа',
        'лирика',
        'лист',
        'литр',
        'лифт',
        'лихой',
        'лицо',
        'личный',
        'лишний',
        'лобовой',
        'ловить',
        'логика',
        'лодка',
        'ложка',
        'лозунг',
        'локоть',
        'ломать',
        'лоно',
        'лопата',
        'лорд',
        'лось',
        'лоток',
        'лохматый',
        'лошадь',
        'лужа',
        'лукавый',
        'луна',
        'лупить',
        'лучший',
        'лыжный',
        'лысый',
        'львиный',
        'льгота',
        'льдина',
        'любить',
        'людской',
        'люстра',
        'лютый',
        'лягушка',
        'магазин',
        'мадам',
        'мазать',
        'майор',
        'максимум',
        'мальчик',
        'манера',
        'март',
        'масса',
        'мать',
        'мафия',
        'махать',
        'мачта',
        'машина',
        'маэстро',
        'маяк',
        'мгла',
        'мебель',
        'медведь',
        'мелкий',
        'мемуары',
        'менять',
        'мера',
        'место',
        'метод',
        'механизм',
        'мечтать',
        'мешать',
        'миграция',
        'мизинец',
        'микрофон',
        'миллион',
        'минута',
        'мировой',
        'миссия',
        'митинг',
        'мишень',
        'младший',
        'мнение',
        'мнимый',
        'могила',
        'модель',
        'мозг',
        'мойка',
        'мокрый',
        'молодой',
        'момент',
        'монах',
        'море',
        'мост',
        'мотор',
        'мохнатый',
        'мочь',
        'мошенник',
        'мощный',
        'мрачный',
        'мстить',
        'мудрый',
        'мужчина',
        'музыка',
        'мука',
        'мумия',
        'мундир',
        'муравей',
        'мусор',
        'мутный',
        'муфта',
        'муха',
        'мучить',
        'мушкетер',
        'мыло',
        'мысль',
        'мыть',
        'мычать',
        'мышь',
        'мэтр',
        'мюзикл',
        'мягкий',
        'мякиш',
        'мясо',
        'мятый',
        'мячик',
        'набор',
        'навык',
        'нагрузка',
        'надежда',
        'наемный',
        'нажать',
        'называть',
        'наивный',
        'накрыть',
        'налог',
        'намерен',
        'наносить',
        'написать',
        'народ',
        'натура',
        'наука',
        'нация',
        'начать',
        'небо',
        'невеста',
        'негодяй',
        'неделя',
        'нежный',
        'незнание',
        'нелепый',
        'немалый',
        'неправда',
        'нервный',
        'нести',
        'нефть',
        'нехватка',
        'нечистый',
        'неясный',
        'нива',
        'нижний',
        'низкий',
        'никель',
        'нирвана',
        'нить',
        'ничья',
        'ниша',
        'нищий',
        'новый',
        'нога',
        'ножницы',
        'ноздря',
        'ноль',
        'номер',
        'норма',
        'нота',
        'ночь',
        'ноша',
        'ноябрь',
        'нрав',
        'нужный',
        'нутро',
        'нынешний',
        'нырнуть',
        'ныть',
        'нюанс',
        'нюхать',
        'няня',
        'оазис',
        'обаяние',
        'обвинять',
        'обгонять',
        'обещать',
        'обжигать',
        'обзор',
        'обида',
        'область',
        'обмен',
        'обнимать',
        'оборона',
        'образ',
        'обучение',
        'обходить',
        'обширный',
        'общий',
        'объект',
        'обычный',
        'обязать',
        'овальный',
        'овес',
        'овощи',
        'овраг',
        'овца',
        'овчарка',
        'огненный',
        'огонь',
        'огромный',
        'огурец',
        'одежда',
        'одинокий',
        'одобрить',
        'ожидать',
        'ожог',
        'озарение',
        'озеро',
        'означать',
        'оказать',
        'океан',
        'оклад',
        'окно',
        'округ',
        'октябрь',
        'окурок',
        'олень',
        'опасный',
        'операция',
        'описать',
        'оплата',
        'опора',
        'оппонент',
        'опрос',
        'оптимизм',
        'опускать',
        'опыт',
        'орать',
        'орбита',
        'орган',
        'орден',
        'орел',
        'оригинал',
        'оркестр',
        'орнамент',
        'оружие',
        'осадок',
        'освещать',
        'осень',
        'осина',
        'осколок',
        'осмотр',
        'основной',
        'особый',
        'осуждать',
        'отбор',
        'отвечать',
        'отдать',
        'отец',
        'отзыв',
        'открытие',
        'отмечать',
        'относить',
        'отпуск',
        'отрасль',
        'отставка',
        'оттенок',
        'отходить',
        'отчет',
        'отъезд',
        'офицер',
        'охапка',
        'охота',
        'охрана',
        'оценка',
        'очаг',
        'очередь',
        'очищать',
        'очки',
        'ошейник',
        'ошибка',
        'ощущение',
        'павильон',
        'падать',
        'паек',
        'пакет',
        'палец',
        'память',
        'панель',
        'папка',
        'партия',
        'паспорт',
        'патрон',
        'пауза',
        'пафос',
        'пахнуть',
        'пациент',
        'пачка',
        'пашня',
        'певец',
        'педагог',
        'пейзаж',
        'пельмень',
        'пенсия',
        'пепел',
        'период',
        'песня',
        'петля',
        'пехота',
        'печать',
        'пешеход',
        'пещера',
        'пианист',
        'пиво',
        'пиджак',
        'пиковый',
        'пилот',
        'пионер',
        'пирог',
        'писать',
        'пить',
        'пицца',
        'пишущий',
        'пища',
        'план',
        'плечо',
        'плита',
        'плохой',
        'плыть',
        'плюс',
        'пляж',
        'победа',
        'повод',
        'погода',
        'подумать',
        'поехать',
        'пожимать',
        'позиция',
        'поиск',
        'покой',
        'получать',
        'помнить',
        'пони',
        'поощрять',
        'попадать',
        'порядок',
        'пост',
        'поток',
        'похожий',
        'поцелуй',
        'почва',
        'пощечина',
        'поэт',
        'пояснить',
        'право',
        'предмет',
        'проблема',
        'пруд',
        'прыгать',
        'прямой',
        'психолог',
        'птица',
        'публика',
        'пугать',
        'пудра',
        'пузырь',
        'пуля',
        'пункт',
        'пурга',
        'пустой',
        'путь',
        'пухлый',
        'пучок',
        'пушистый',
        'пчела',
        'пшеница',
        'пыль',
        'пытка',
        'пыхтеть',
        'пышный',
        'пьеса',
        'пьяный',
        'пятно',
        'работа',
        'равный',
        'радость',
        'развитие',
        'район',
        'ракета',
        'рамка',
        'ранний',
        'рапорт',
        'рассказ',
        'раунд',
        'рация',
        'рвать',
        'реальный',
        'ребенок',
        'реветь',
        'регион',
        'редакция',
        'реестр',
        'режим',
        'резкий',
        'рейтинг',
        'река',
        'религия',
        'ремонт',
        'рента',
        'реплика',
        'ресурс',
        'реформа',
        'рецепт',
        'речь',
        'решение',
        'ржавый',
        'рисунок',
        'ритм',
        'рифма',
        'робкий',
        'ровный',
        'рогатый',
        'родитель',
        'рождение',
        'розовый',
        'роковой',
        'роль',
        'роман',
        'ронять',
        'рост',
        'рота',
        'роща',
        'рояль',
        'рубль',
        'ругать',
        'руда',
        'ружье',
        'руины',
        'рука',
        'руль',
        'румяный',
        'русский',
        'ручка',
        'рыба',
        'рывок',
        'рыдать',
        'рыжий',
        'рынок',
        'рысь',
        'рыть',
        'рыхлый',
        'рыцарь',
        'рычаг',
        'рюкзак',
        'рюмка',
        'рябой',
        'рядовой',
        'сабля',
        'садовый',
        'сажать',
        'салон',
        'самолет',
        'сани',
        'сапог',
        'сарай',
        'сатира',
        'сауна',
        'сахар',
        'сбегать',
        'сбивать',
        'сбор',
        'сбыт',
        'свадьба',
        'свет',
        'свидание',
        'свобода',
        'связь',
        'сгорать',
        'сдвигать',
        'сеанс',
        'северный',
        'сегмент',
        'седой',
        'сезон',
        'сейф',
        'секунда',
        'сельский',
        'семья',
        'сентябрь',
        'сердце',
        'сеть',
        'сечение',
        'сеять',
        'сигнал',
        'сидеть',
        'сизый',
        'сила',
        'символ',
        'синий',
        'сирота',
        'система',
        'ситуация',
        'сиять',
        'сказать',
        'скважина',
        'скелет',
        'скидка',
        'склад',
        'скорый',
        'скрывать',
        'скучный',
        'слава',
        'слеза',
        'слияние',
        'слово',
        'случай',
        'слышать',
        'слюна',
        'смех',
        'смирение',
        'смотреть',
        'смутный',
        'смысл',
        'смятение',
        'снаряд',
        'снег',
        'снижение',
        'сносить',
        'снять',
        'событие',
        'совет',
        'согласие',
        'сожалеть',
        'сойти',
        'сокол',
        'солнце',
        'сомнение',
        'сонный',
        'сообщать',
        'соперник',
        'сорт',
        'состав',
        'сотня',
        'соус',
        'социолог',
        'сочинять',
        'союз',
        'спать',
        'спешить',
        'спина',
        'сплошной',
        'способ',
        'спутник',
        'средство',
        'срок',
        'срывать',
        'стать',
        'ствол',
        'стена',
        'стихи',
        'сторона',
        'страна',
        'студент',
        'стыд',
        'субъект',
        'сувенир',
        'сугроб',
        'судьба',
        'суета',
        'суждение',
        'сукно',
        'сулить',
        'сумма',
        'сунуть',
        'супруг',
        'суровый',
        'сустав',
        'суть',
        'сухой',
        'суша',
        'существо',
        'сфера',
        'схема',
        'сцена',
        'счастье',
        'счет',
        'считать',
        'сшивать',
        'съезд',
        'сынок',
        'сыпать',
        'сырье',
        'сытый',
        'сыщик',
        'сюжет',
        'сюрприз',
        'таблица',
        'таежный',
        'таинство',
        'тайна',
        'такси',
        'талант',
        'таможня',
        'танец',
        'тарелка',
        'таскать',
        'тахта',
        'тачка',
        'таять',
        'тварь',
        'твердый',
        'творить',
        'театр',
        'тезис',
        'текст',
        'тело',
        'тема',
        'тень',
        'теория',
        'теплый',
        'терять',
        'тесный',
        'тетя',
        'техника',
        'течение',
        'тигр',
        'типичный',
        'тираж',
        'титул',
        'тихий',
        'тишина',
        'ткань',
        'товарищ',
        'толпа',
        'тонкий',
        'топливо',
        'торговля',
        'тоска',
        'точка',
        'тощий',
        'традиция',
        'тревога',
        'трибуна',
        'трогать',
        'труд',
        'трюк',
        'тряпка',
        'туалет',
        'тугой',
        'туловище',
        'туман',
        'тундра',
        'тупой',
        'турнир',
        'тусклый',
        'туфля',
        'туча',
        'туша',
        'тыкать',
        'тысяча',
        'тьма',
        'тюльпан',
        'тюрьма',
        'тяга',
        'тяжелый',
        'тянуть',
        'убеждать',
        'убирать',
        'убогий',
        'убыток',
        'уважение',
        'уверять',
        'увлекать',
        'угнать',
        'угол',
        'угроза',
        'удар',
        'удивлять',
        'удобный',
        'уезд',
        'ужас',
        'ужин',
        'узел',
        'узкий',
        'узнавать',
        'узор',
        'уйма',
        'уклон',
        'укол',
        'уксус',
        'улетать',
        'улица',
        'улучшать',
        'улыбка',
        'уметь',
        'умиление',
        'умный',
        'умолять',
        'умысел',
        'унижать',
        'уносить',
        'уныние',
        'упасть',
        'уплата',
        'упор',
        'упрекать',
        'упускать',
        'уран',
        'урна',
        'уровень',
        'усадьба',
        'усердие',
        'усилие',
        'ускорять',
        'условие',
        'усмешка',
        'уснуть',
        'успеть',
        'усыпать',
        'утешать',
        'утка',
        'уточнять',
        'утро',
        'утюг',
        'уходить',
        'уцелеть',
        'участие',
        'ученый',
        'учитель',
        'ушко',
        'ущерб',
        'уютный',
        'уяснять',
        'фабрика',
        'фаворит',
        'фаза',
        'файл',
        'факт',
        'фамилия',
        'фантазия',
        'фара',
        'фасад',
        'февраль',
        'фельдшер',
        'феномен',
        'ферма',
        'фигура',
        'физика',
        'фильм',
        'финал',
        'фирма',
        'фишка',
        'флаг',
        'флейта',
        'флот',
        'фокус',
        'фольклор',
        'фонд',
        'форма',
        'фото',
        'фраза',
        'фреска',
        'фронт',
        'фрукт',
        'функция',
        'фуражка',
        'футбол',
        'фыркать',
        'халат',
        'хамство',
        'хаос',
        'характер',
        'хата',
        'хватать',
        'хвост',
        'хижина',
        'хилый',
        'химия',
        'хирург',
        'хитрый',
        'хищник',
        'хлам',
        'хлеб',
        'хлопать',
        'хмурый',
        'ходить',
        'хозяин',
        'хоккей',
        'холодный',
        'хороший',
        'хотеть',
        'хохотать',
        'храм',
        'хрен',
        'хриплый',
        'хроника',
        'хрупкий',
        'художник',
        'хулиган',
        'хутор',
        'царь',
        'цвет',
        'цель',
        'цемент',
        'центр',
        'цепь',
        'церковь',
        'цикл',
        'цилиндр',
        'циничный',
        'цирк',
        'цистерна',
        'цитата',
        'цифра',
        'цыпленок',
        'чадо',
        'чайник',
        'часть',
        'чашка',
        'человек',
        'чемодан',
        'чепуха',
        'черный',
        'честь',
        'четкий',
        'чехол',
        'чиновник',
        'число',
        'читать',
        'членство',
        'чреватый',
        'чтение',
        'чувство',
        'чугунный',
        'чудо',
        'чужой',
        'чукча',
        'чулок',
        'чума',
        'чуткий',
        'чучело',
        'чушь',
        'шаблон',
        'шагать',
        'шайка',
        'шакал',
        'шалаш',
        'шампунь',
        'шанс',
        'шапка',
        'шарик',
        'шасси',
        'шатер',
        'шахта',
        'шашлык',
        'швейный',
        'швырять',
        'шевелить',
        'шедевр',
        'шейка',
        'шелковый',
        'шептать',
        'шерсть',
        'шестерка',
        'шикарный',
        'шинель',
        'шипеть',
        'широкий',
        'шить',
        'шишка',
        'шкаф',
        'школа',
        'шкура',
        'шланг',
        'шлем',
        'шлюпка',
        'шляпа',
        'шнур',
        'шоколад',
        'шорох',
        'шоссе',
        'шофер',
        'шпага',
        'шпион',
        'шприц',
        'шрам',
        'шрифт',
        'штаб',
        'штора',
        'штраф',
        'штука',
        'штык',
        'шуба',
        'шуметь',
        'шуршать',
        'шутка',
        'щадить',
        'щедрый',
        'щека',
        'щель',
        'щенок',
        'щепка',
        'щетка',
        'щука',
        'эволюция',
        'эгоизм',
        'экзамен',
        'экипаж',
        'экономия',
        'экран',
        'эксперт',
        'элемент',
        'элита',
        'эмблема',
        'эмигрант',
        'эмоция',
        'энергия',
        'эпизод',
        'эпоха',
        'эскиз',
        'эссе',
        'эстрада',
        'этап',
        'этика',
        'этюд',
        'эфир',
        'эффект',
        'эшелон',
        'юбилей',
        'юбка',
        'южный',
        'юмор',
        'юноша',
        'юрист',
        'яблоко',
        'явление',
        'ягода',
        'ядерный',
        'ядовитый',
        'ядро',
        'язва',
        'язык',
        'яйцо',
        'якорь',
        'январь',
        'японец',
        'яркий',
        'ярмарка',
        'ярость',
        'ярус',
        'ясный',
        'яхта',
        'ячейка',
        'ящик',
      ])
    );
    langs.push(
      new MnemonicLang('lojban', '', 4, [
        'backi',
        'bacru',
        'badna',
        'badri',
        'bajra',
        'bakfu',
        'bakni',
        'bakri',
        'baktu',
        'balji',
        'balni',
        'balre',
        'balvi',
        'bambu',
        'bancu',
        'bandu',
        'banfi',
        'bangu',
        'banli',
        'banro',
        'banxa',
        'banzu',
        'bapli',
        'barda',
        'bargu',
        'barja',
        'barna',
        'bartu',
        'basfa',
        'basna',
        'basti',
        'batci',
        'batke',
        'bavmi',
        'baxso',
        'bebna',
        'bekpi',
        'bemro',
        'bende',
        'bengo',
        'benji',
        'benre',
        'benzo',
        'bergu',
        'bersa',
        'berti',
        'besna',
        'besto',
        'betfu',
        'betri',
        'bevri',
        'bidju',
        'bifce',
        'bikla',
        'bilga',
        'bilma',
        'bilni',
        'bindo',
        'binra',
        'binxo',
        'birje',
        'birka',
        'birti',
        'bisli',
        'bitmu',
        'bitni',
        'blabi',
        'blaci',
        'blanu',
        'bliku',
        'bloti',
        'bolci',
        'bongu',
        'boske',
        'botpi',
        'boxfo',
        'boxna',
        'bradi',
        'brano',
        'bratu',
        'brazo',
        'bredi',
        'bridi',
        'brife',
        'briju',
        'brito',
        'brivo',
        'broda',
        'bruna',
        'budjo',
        'bukpu',
        'bumru',
        'bunda',
        'bunre',
        'burcu',
        'burna',
        'cabna',
        'cabra',
        'cacra',
        'cadga',
        'cadzu',
        'cafne',
        'cagna',
        'cakla',
        'calku',
        'calse',
        'canci',
        'cando',
        'cange',
        'canja',
        'canko',
        'canlu',
        'canpa',
        'canre',
        'canti',
        'carce',
        'carfu',
        'carmi',
        'carna',
        'cartu',
        'carvi',
        'casnu',
        'catke',
        'catlu',
        'catni',
        'catra',
        'caxno',
        'cecla',
        'cecmu',
        'cedra',
        'cenba',
        'censa',
        'centi',
        'cerda',
        'cerni',
        'certu',
        'cevni',
        'cfale',
        'cfari',
        'cfika',
        'cfila',
        'cfine',
        'cfipu',
        'ciblu',
        'cicna',
        'cidja',
        'cidni',
        'cidro',
        'cifnu',
        'cigla',
        'cikna',
        'cikre',
        'ciksi',
        'cilce',
        'cilfu',
        'cilmo',
        'cilre',
        'cilta',
        'cimde',
        'cimni',
        'cinba',
        'cindu',
        'cinfo',
        'cinje',
        'cinki',
        'cinla',
        'cinmo',
        'cinri',
        'cinse',
        'cinta',
        'cinza',
        'cipni',
        'cipra',
        'cirko',
        'cirla',
        'ciska',
        'cisma',
        'cisni',
        'ciste',
        'citka',
        'citno',
        'citri',
        'citsi',
        'civla',
        'cizra',
        'ckabu',
        'ckafi',
        'ckaji',
        'ckana',
        'ckape',
        'ckasu',
        'ckeji',
        'ckiku',
        'ckilu',
        'ckini',
        'ckire',
        'ckule',
        'ckunu',
        'cladu',
        'clani',
        'claxu',
        'cletu',
        'clika',
        'clinu',
        'clira',
        'clite',
        'cliva',
        'clupa',
        'cmaci',
        'cmalu',
        'cmana',
        'cmavo',
        'cmene',
        'cmeta',
        'cmevo',
        'cmila',
        'cmima',
        'cmoni',
        'cnano',
        'cnebo',
        'cnemu',
        'cnici',
        'cnino',
        'cnisa',
        'cnita',
        'cokcu',
        'condi',
        'conka',
        'corci',
        'cortu',
        'cpacu',
        'cpana',
        'cpare',
        'cpedu',
        'cpina',
        'cradi',
        'crane',
        'creka',
        'crepu',
        'cribe',
        'crida',
        'crino',
        'cripu',
        'crisa',
        'critu',
        'ctaru',
        'ctebi',
        'cteki',
        'ctile',
        'ctino',
        'ctuca',
        'cukla',
        'cukre',
        'cukta',
        'culno',
        'cumki',
        'cumla',
        'cunmi',
        'cunso',
        'cuntu',
        'cupra',
        'curmi',
        'curnu',
        'curve',
        'cusku',
        'cusna',
        'cutci',
        'cutne',
        'cuxna',
        'dacru',
        'dacti',
        'dadjo',
        'dakfu',
        'dakli',
        'damba',
        'damri',
        'dandu',
        'danfu',
        'danlu',
        'danmo',
        'danre',
        'dansu',
        'danti',
        'daplu',
        'dapma',
        'darca',
        'dargu',
        'darlu',
        'darno',
        'darsi',
        'darxi',
        'daski',
        'dasni',
        'daspo',
        'dasri',
        'datka',
        'datni',
        'datro',
        'decti',
        'degji',
        'dejni',
        'dekpu',
        'dekto',
        'delno',
        'dembi',
        'denci',
        'denmi',
        'denpa',
        'dertu',
        'derxi',
        'desku',
        'detri',
        'dicma',
        'dicra',
        'didni',
        'digno',
        'dikca',
        'diklo',
        'dikni',
        'dilcu',
        'dilma',
        'dilnu',
        'dimna',
        'dindi',
        'dinju',
        'dinko',
        'dinso',
        'dirba',
        'dirce',
        'dirgo',
        'disko',
        'ditcu',
        'divzi',
        'dizlo',
        'djacu',
        'djedi',
        'djica',
        'djine',
        'djuno',
        'donri',
        'dotco',
        'draci',
        'drani',
        'drata',
        'drudi',
        'dugri',
        'dukse',
        'dukti',
        'dunda',
        'dunja',
        'dunku',
        'dunli',
        'dunra',
        'dutso',
        'dzena',
        'dzipo',
        'facki',
        'fadni',
        'fagri',
        'falnu',
        'famti',
        'fancu',
        'fange',
        'fanmo',
        'fanri',
        'fanta',
        'fanva',
        'fanza',
        'fapro',
        'farka',
        'farlu',
        'farna',
        'farvi',
        'fasnu',
        'fatci',
        'fatne',
        'fatri',
        'febvi',
        'fegli',
        'femti',
        'fendi',
        'fengu',
        'fenki',
        'fenra',
        'fenso',
        'fepni',
        'fepri',
        'ferti',
        'festi',
        'fetsi',
        'figre',
        'filso',
        'finpe',
        'finti',
        'firca',
        'fisli',
        'fizbu',
        'flaci',
        'flalu',
        'flani',
        'flecu',
        'flese',
        'fliba',
        'flira',
        'foldi',
        'fonmo',
        'fonxa',
        'forca',
        'forse',
        'fraso',
        'frati',
        'fraxu',
        'frica',
        'friko',
        'frili',
        'frinu',
        'friti',
        'frumu',
        'fukpi',
        'fulta',
        'funca',
        'fusra',
        'fuzme',
        'gacri',
        'gadri',
        'galfi',
        'galtu',
        'galxe',
        'ganlo',
        'ganra',
        'ganse',
        'ganti',
        'ganxo',
        'ganzu',
        'gapci',
        'gapru',
        'garna',
        'gasnu',
        'gaspo',
        'gasta',
        'genja',
        'gento',
        'genxu',
        'gerku',
        'gerna',
        'gidva',
        'gigdo',
        'ginka',
        'girzu',
        'gismu',
        'glare',
        'gleki',
        'gletu',
        'glico',
        'glife',
        'glosa',
        'gluta',
        'gocti',
        'gomsi',
        'gotro',
        'gradu',
        'grafu',
        'grake',
        'grana',
        'grasu',
        'grava',
        'greku',
        'grusi',
        'grute',
        'gubni',
        'gugde',
        'gugle',
        'gumri',
        'gundi',
        'gunka',
        'gunma',
        'gunro',
        'gunse',
        'gunta',
        'gurni',
        'guska',
        'gusni',
        'gusta',
        'gutci',
        'gutra',
        'guzme',
        'jabre',
        'jadni',
        'jakne',
        'jalge',
        'jalna',
        'jalra',
        'jamfu',
        'jamna',
        'janbe',
        'janco',
        'janli',
        'jansu',
        'janta',
        'jarbu',
        'jarco',
        'jarki',
        'jaspu',
        'jatna',
        'javni',
        'jbama',
        'jbari',
        'jbena',
        'jbera',
        'jbini',
        'jdari',
        'jdice',
        'jdika',
        'jdima',
        'jdini',
        'jduli',
        'jecta',
        'jeftu',
        'jegvo',
        'jelca',
        'jemna',
        'jenca',
        'jendu',
        'jenmi',
        'jensi',
        'jerna',
        'jersi',
        'jerxo',
        'jesni',
        'jetce',
        'jetnu',
        'jgalu',
        'jganu',
        'jgari',
        'jgena',
        'jgina',
        'jgira',
        'jgita',
        'jibni',
        'jibri',
        'jicla',
        'jicmu',
        'jijnu',
        'jikca',
        'jikfi',
        'jikni',
        'jikru',
        'jilka',
        'jilra',
        'jimca',
        'jimpe',
        'jimte',
        'jinci',
        'jinda',
        'jinga',
        'jinku',
        'jinme',
        'jinru',
        'jinsa',
        'jinto',
        'jinvi',
        'jinzi',
        'jipci',
        'jipno',
        'jirna',
        'jisra',
        'jitfa',
        'jitro',
        'jivbu',
        'jivna',
        'jmaji',
        'jmifa',
        'jmina',
        'jmive',
        'jonse',
        'jordo',
        'jorne',
        'jubme',
        'judri',
        'jufra',
        'jukni',
        'jukpa',
        'julne',
        'julro',
        'jundi',
        'jungo',
        'junla',
        'junri',
        'junta',
        'jurme',
        'jursa',
        'jutsi',
        'juxre',
        'jvinu',
        'jviso',
        'kabri',
        'kacma',
        'kadno',
        'kafke',
        'kagni',
        'kajde',
        'kajna',
        'kakne',
        'kakpa',
        'kalci',
        'kalri',
        'kalsa',
        'kalte',
        'kamju',
        'kamni',
        'kampu',
        'kamre',
        'kanba',
        'kancu',
        'kandi',
        'kanji',
        'kanla',
        'kanpe',
        'kanro',
        'kansa',
        'kantu',
        'kanxe',
        'karbi',
        'karce',
        'karda',
        'kargu',
        'karli',
        'karni',
        'katci',
        'katna',
        'kavbu',
        'kazra',
        'kecti',
        'kekli',
        'kelci',
        'kelvo',
        'kenka',
        'kenra',
        'kensa',
        'kerfa',
        'kerlo',
        'kesri',
        'ketco',
        'ketsu',
        'kevna',
        'kibro',
        'kicne',
        'kijno',
        'kilto',
        'kinda',
        'kinli',
        'kisto',
        'klaji',
        'klaku',
        'klama',
        'klani',
        'klesi',
        'kliki',
        'klina',
        'kliru',
        'kliti',
        'klupe',
        'kluza',
        'kobli',
        'kogno',
        'kojna',
        'kokso',
        'kolme',
        'komcu',
        'konju',
        'korbi',
        'korcu',
        'korka',
        'korvo',
        'kosmu',
        'kosta',
        'krali',
        'kramu',
        'krasi',
        'krati',
        'krefu',
        'krici',
        'krili',
        'krinu',
        'krixa',
        'kruca',
        'kruji',
        'kruvi',
        'kubli',
        'kucli',
        'kufra',
        'kukte',
        'kulnu',
        'kumfa',
        'kumte',
        'kunra',
        'kunti',
        'kurfa',
        'kurji',
        'kurki',
        'kuspe',
        'kusru',
        'labno',
        'lacni',
        'lacpu',
        'lacri',
        'ladru',
        'lafti',
        'lakne',
        'lakse',
        'laldo',
        'lalxu',
        'lamji',
        'lanbi',
        'lanci',
        'landa',
        'lanka',
        'lanli',
        'lanme',
        'lante',
        'lanxe',
        'lanzu',
        'larcu',
        'larva',
        'lasna',
        'lastu',
        'latmo',
        'latna',
        'lazni',
        'lebna',
        'lelxe',
        'lenga',
        'lenjo',
        'lenku',
        'lerci',
        'lerfu',
        'libjo',
        'lidne',
        'lifri',
        'lijda',
        'limfa',
        'limna',
        'lince',
        'lindi',
        'linga',
        'linji',
        'linsi',
        'linto',
        'lisri',
        'liste',
        'litce',
        'litki',
        'litru',
        'livga',
        'livla',
        'logji',
        'loglo',
        'lojbo',
        'loldi',
        'lorxu',
        'lubno',
        'lujvo',
        'luksi',
        'lumci',
        'lunbe',
        'lunra',
        'lunsa',
        'luska',
        'lusto',
        'mabla',
        'mabru',
        'macnu',
        'majga',
        'makcu',
        'makfa',
        'maksi',
        'malsi',
        'mamta',
        'manci',
        'manfo',
        'mango',
        'manku',
        'manri',
        'mansa',
        'manti',
        'mapku',
        'mapni',
        'mapra',
        'mapti',
        'marbi',
        'marce',
        'marde',
        'margu',
        'marji',
        'marna',
        'marxa',
        'masno',
        'masti',
        'matci',
        'matli',
        'matne',
        'matra',
        'mavji',
        'maxri',
        'mebri',
        'megdo',
        'mekso',
        'melbi',
        'meljo',
        'melmi',
        'menli',
        'menre',
        'mensi',
        'mentu',
        'merko',
        'merli',
        'metfo',
        'mexno',
        'midju',
        'mifra',
        'mikce',
        'mikri',
        'milti',
        'milxe',
        'minde',
        'minji',
        'minli',
        'minra',
        'mintu',
        'mipri',
        'mirli',
        'misno',
        'misro',
        'mitre',
        'mixre',
        'mlana',
        'mlatu',
        'mleca',
        'mledi',
        'mluni',
        'mogle',
        'mokca',
        'moklu',
        'molki',
        'molro',
        'morji',
        'morko',
        'morna',
        'morsi',
        'mosra',
        'mraji',
        'mrilu',
        'mruli',
        'mucti',
        'mudri',
        'mugle',
        'mukti',
        'mulno',
        'munje',
        'mupli',
        'murse',
        'murta',
        'muslo',
        'mutce',
        'muvdu',
        'muzga',
        'nabmi',
        'nakni',
        'nalci',
        'namcu',
        'nanba',
        'nanca',
        'nandu',
        'nanla',
        'nanmu',
        'nanvi',
        'narge',
        'narju',
        'natfe',
        'natmi',
        'natsi',
        'navni',
        'naxle',
        'nazbi',
        'nejni',
        'nelci',
        'nenri',
        'nerde',
        'nibli',
        'nicfa',
        'nicte',
        'nikle',
        'nilce',
        'nimre',
        'ninja',
        'ninmu',
        'nirna',
        'nitcu',
        'nivji',
        'nixli',
        'nobli',
        'norgo',
        'notci',
        'nudle',
        'nukni',
        'nunmu',
        'nupre',
        'nurma',
        'nusna',
        'nutka',
        'nutli',
        'nuzba',
        'nuzlo',
        'pacna',
        'pagbu',
        'pagre',
        'pajni',
        'palci',
        'palku',
        'palma',
        'palne',
        'palpi',
        'palta',
        'pambe',
        'pamga',
        'panci',
        'pandi',
        'panje',
        'panka',
        'panlo',
        'panpi',
        'panra',
        'pante',
        'panzi',
        'papri',
        'parbi',
        'pardu',
        'parji',
        'pastu',
        'patfu',
        'patlu',
        'patxu',
        'paznu',
        'pelji',
        'pelxu',
        'pemci',
        'penbi',
        'pencu',
        'pendo',
        'penmi',
        'pensi',
        'pentu',
        'perli',
        'pesxu',
        'petso',
        'pevna',
        'pezli',
        'picti',
        'pijne',
        'pikci',
        'pikta',
        'pilda',
        'pilji',
        'pilka',
        'pilno',
        'pimlu',
        'pinca',
        'pindi',
        'pinfu',
        'pinji',
        'pinka',
        'pinsi',
        'pinta',
        'pinxe',
        'pipno',
        'pixra',
        'plana',
        'platu',
        'pleji',
        'plibu',
        'plini',
        'plipe',
        'plise',
        'plita',
        'plixa',
        'pluja',
        'pluka',
        'pluta',
        'pocli',
        'polje',
        'polno',
        'ponjo',
        'ponse',
        'poplu',
        'porpi',
        'porsi',
        'porto',
        'prali',
        'prami',
        'prane',
        'preja',
        'prenu',
        'preri',
        'preti',
        'prije',
        'prina',
        'pritu',
        'proga',
        'prosa',
        'pruce',
        'pruni',
        'pruri',
        'pruxi',
        'pulce',
        'pulji',
        'pulni',
        'punji',
        'punli',
        'pupsu',
        'purci',
        'purdi',
        'purmo',
        'racli',
        'ractu',
        'radno',
        'rafsi',
        'ragbi',
        'ragve',
        'rakle',
        'rakso',
        'raktu',
        'ralci',
        'ralju',
        'ralte',
        'randa',
        'rango',
        'ranji',
        'ranmi',
        'ransu',
        'ranti',
        'ranxi',
        'rapli',
        'rarna',
        'ratcu',
        'ratni',
        'rebla',
        'rectu',
        'rekto',
        'remna',
        'renro',
        'renvi',
        'respa',
        'rexsa',
        'ricfu',
        'rigni',
        'rijno',
        'rilti',
        'rimni',
        'rinci',
        'rindo',
        'rinju',
        'rinka',
        'rinsa',
        'rirci',
        'rirni',
        'rirxe',
        'rismi',
        'risna',
        'ritli',
        'rivbi',
        'rokci',
        'romge',
        'romlo',
        'ronte',
        'ropno',
        'rorci',
        'rotsu',
        'rozgu',
        'ruble',
        'rufsu',
        'runme',
        'runta',
        'rupnu',
        'rusko',
        'rutni',
        'sabji',
        'sabnu',
        'sacki',
        'saclu',
        'sadjo',
        'sakci',
        'sakli',
        'sakta',
        'salci',
        'salpo',
        'salri',
        'salta',
        'samcu',
        'sampu',
        'sanbu',
        'sance',
        'sanga',
        'sanji',
        'sanli',
        'sanmi',
        'sanso',
        'santa',
        'sarcu',
        'sarji',
        'sarlu',
        'sarni',
        'sarxe',
        'saske',
        'satci',
        'satre',
        'savru',
        'sazri',
        'sefsi',
        'sefta',
        'sekre',
        'selci',
        'selfu',
        'semto',
        'senci',
        'sengi',
        'senpi',
        'senta',
        'senva',
        'sepli',
        'serti',
        'sesre',
        'setca',
        'sevzi',
        'sfani',
        'sfasa',
        'sfofa',
        'sfubu',
        'sibli',
        'siclu',
        'sicni',
        'sicpi',
        'sidbo',
        'sidju',
        'sigja',
        'sigma',
        'sikta',
        'silka',
        'silna',
        'simlu',
        'simsa',
        'simxu',
        'since',
        'sinma',
        'sinso',
        'sinxa',
        'sipna',
        'sirji',
        'sirxo',
        'sisku',
        'sisti',
        'sitna',
        'sivni',
        'skaci',
        'skami',
        'skapi',
        'skari',
        'skicu',
        'skiji',
        'skina',
        'skori',
        'skoto',
        'skuba',
        'skuro',
        'slabu',
        'slaka',
        'slami',
        'slanu',
        'slari',
        'slasi',
        'sligu',
        'slilu',
        'sliri',
        'slovo',
        'sluji',
        'sluni',
        'smacu',
        'smadi',
        'smaji',
        'smaka',
        'smani',
        'smela',
        'smoka',
        'smuci',
        'smuni',
        'smusu',
        'snada',
        'snanu',
        'snidu',
        'snime',
        'snipa',
        'snuji',
        'snura',
        'snuti',
        'sobde',
        'sodna',
        'sodva',
        'softo',
        'solji',
        'solri',
        'sombo',
        'sonci',
        'sorcu',
        'sorgu',
        'sorni',
        'sorta',
        'sovda',
        'spaji',
        'spali',
        'spano',
        'spati',
        'speni',
        'spero',
        'spisa',
        'spita',
        'spofu',
        'spoja',
        'spuda',
        'sputu',
        'sraji',
        'sraku',
        'sralo',
        'srana',
        'srasu',
        'srera',
        'srito',
        'sruma',
        'sruri',
        'stace',
        'stagi',
        'staku',
        'stali',
        'stani',
        'stapa',
        'stasu',
        'stati',
        'steba',
        'steci',
        'stedu',
        'stela',
        'stero',
        'stici',
        'stidi',
        'stika',
        'stizu',
        'stodi',
        'stuna',
        'stura',
        'stuzi',
        'sucta',
        'sudga',
        'sufti',
        'suksa',
        'sumji',
        'sumne',
        'sumti',
        'sunga',
        'sunla',
        'surla',
        'sutra',
        'tabno',
        'tabra',
        'tadji',
        'tadni',
        'tagji',
        'taksi',
        'talsa',
        'tamca',
        'tamji',
        'tamne',
        'tanbo',
        'tance',
        'tanjo',
        'tanko',
        'tanru',
        'tansi',
        'tanxe',
        'tapla',
        'tarbi',
        'tarci',
        'tarla',
        'tarmi',
        'tarti',
        'taske',
        'tasmi',
        'tasta',
        'tatpi',
        'tatru',
        'tavla',
        'taxfu',
        'tcaci',
        'tcadu',
        'tcana',
        'tcati',
        'tcaxe',
        'tcena',
        'tcese',
        'tcica',
        'tcidu',
        'tcika',
        'tcila',
        'tcima',
        'tcini',
        'tcita',
        'temci',
        'temse',
        'tende',
        'tenfa',
        'tengu',
        'terdi',
        'terpa',
        'terto',
        'tifri',
        'tigni',
        'tigra',
        'tikpa',
        'tilju',
        'tinbe',
        'tinci',
        'tinsa',
        'tirna',
        'tirse',
        'tirxu',
        'tisna',
        'titla',
        'tivni',
        'tixnu',
        'toknu',
        'toldi',
        'tonga',
        'tordu',
        'torni',
        'torso',
        'traji',
        'trano',
        'trati',
        'trene',
        'tricu',
        'trina',
        'trixe',
        'troci',
        'tsaba',
        'tsali',
        'tsani',
        'tsapi',
        'tsiju',
        'tsina',
        'tsuku',
        'tubnu',
        'tubra',
        'tugni',
        'tujli',
        'tumla',
        'tunba',
        'tunka',
        'tunlo',
        'tunta',
        'tuple',
        'turko',
        'turni',
        'tutci',
        'tutle',
        'tutra',
        'vacri',
        'vajni',
        'valsi',
        'vamji',
        'vamtu',
        'vanbi',
        'vanci',
        'vanju',
        'vasru',
        'vasxu',
        'vecnu',
        'vedli',
        'venfu',
        'vensa',
        'vente',
        'vepre',
        'verba',
        'vibna',
        'vidni',
        'vidru',
        'vifne',
        'vikmi',
        'viknu',
        'vimcu',
        'vindu',
        'vinji',
        'vinta',
        'vipsi',
        'virnu',
        'viska',
        'vitci',
        'vitke',
        'vitno',
        'vlagi',
        'vlile',
        'vlina',
        'vlipa',
        'vofli',
        'voksa',
        'volve',
        'vorme',
        'vraga',
        'vreji',
        'vreta',
        'vrici',
        'vrude',
        'vrusi',
        'vubla',
        'vujnu',
        'vukna',
        'vukro',
        'xabju',
        'xadba',
        'xadji',
        'xadni',
        'xagji',
        'xagri',
        'xajmi',
        'xaksu',
        'xalbo',
        'xalka',
        'xalni',
        'xamgu',
        'xampo',
        'xamsi',
        'xance',
        'xango',
        'xanka',
        'xanri',
        'xansa',
        'xanto',
        'xarci',
        'xarju',
        'xarnu',
        'xasli',
        'xasne',
        'xatra',
        'xatsi',
        'xazdo',
        'xebni',
        'xebro',
        'xecto',
        'xedja',
        'xekri',
        'xelso',
        'xendo',
        'xenru',
        'xexso',
        'xigzo',
        'xindo',
        'xinmo',
        'xirma',
        'xislu',
        'xispo',
        'xlali',
        'xlura',
        'xorbo',
        'xorlo',
        'xotli',
        'xrabo',
        'xrani',
        'xriso',
        'xrotu',
        'xruba',
        'xruki',
        'xrula',
        'xruti',
        'xukmi',
        'xulta',
        'xunre',
        'xurdo',
        'xusra',
        'xutla',
        'zabna',
        'zajba',
        'zalvi',
        'zanru',
        'zarci',
        'zargu',
        'zasni',
        'zasti',
        'zbabu',
        'zbani',
        'zbasu',
        'zbepi',
        'zdani',
        'zdile',
        'zekri',
        'zenba',
        'zepti',
        'zetro',
        'zevla',
        'zgadi',
        'zgana',
        'zgike',
        'zifre',
        'zinki',
        'zirpu',
        'zivle',
        'zmadu',
        'zmiku',
        'zucna',
        'zukte',
        'zumri',
        'zungi',
        'zunle',
        'zunti',
        'zutse',
        'zvati',
        'zviki',
        'jbobau',
        'jbopre',
        'karsna',
        'cabdei',
        'zunsna',
        'gendra',
        'glibau',
        'nintadni',
        'pavyseljirna',
        'vlaste',
        'selbri',
        "latro'a",
        "zdakemkulgu'a",
        'mriste',
        'selsku',
        "fu'ivla",
        "tolmo'i",
        'snavei',
        'xagmau',
        'retsku',
        'ckupau',
        'skudji',
        'smudra',
        'prulamdei',
        "vokta'a",
        "tinju'i",
        "jefyfa'o",
        'bavlamdei',
        'kinzga',
        'jbocre',
        'jbovla',
        'xauzma',
        'selkei',
        'xuncku',
        'spusku',
        "jbogu'e",
        "pampe'o",
        'bripre',
        'jbosnu',
        "zi'evla",
        'gimste',
        'tolzdi',
        'velski',
        'samselpla',
        'cnegau',
        'velcki',
        "selja'e",
        'fasybau',
        'zanfri',
        'reisku',
        'favgau',
        "jbota'a",
        'rejgau',
        'malgli',
        'zilkai',
        'keidji',
        "tersu'i",
        "jbofi'e",
        "cnima'o",
        'mulgau',
        'ningau',
        'ponbau',
        "mrobi'o",
        'rarbau',
        'zmanei',
        "famyma'o",
        'vacysai',
        'jetmlu',
        'jbonunsla',
        "nunpe'i",
        "fa'orma'o",
        "crezenzu'e",
        'jbojbe',
        "cmicu'a",
        'zilcmi',
        'tolcando',
        'zukcfu',
        "depybu'i",
        'mencre',
        'matmau',
        'nunctu',
        "selma'o",
        'titnanba',
        'naldra',
        'jvajvo',
        'nunsnu',
        'nerkla',
        'cimjvo',
        'muvgau',
        'zipcpi',
        'runbau',
        'faumlu',
        'terbri',
        "balcu'e",
        'dragau',
        'smuvelcki',
        'piksku',
        'selpli',
        'bregau',
        "zvafa'i",
        "ci'izra",
        "noltruti'u",
        'samtci',
        "snaxa'a",
      ])
    );
    langs.push(
      new MnemonicLang('esperanto', '', 4, [
        'abako',
        'abdiki',
        'abelo',
        'abituriento',
        'ablativo',
        'abnorma',
        'abonantoj',
        'abrikoto',
        'absoluta',
        'abunda',
        'acetono',
        'acida',
        'adapti',
        'adekvata',
        'adheri',
        'adicii',
        'adjektivo',
        'administri',
        'adolesko',
        'adreso',
        'adstringa',
        'adulto',
        'advokato',
        'adzo',
        'aeroplano',
        'aferulo',
        'afgana',
        'afiksi',
        'aflaba',
        'aforismo',
        'afranki',
        'aftozo',
        'afusto',
        'agavo',
        'agento',
        'agiti',
        'aglo',
        'agmaniero',
        'agnoski',
        'agordo',
        'agrabla',
        'agtipo',
        'agutio',
        'aikido',
        'ailanto',
        'aina',
        'ajatolo',
        'ajgenvaloro',
        'ajlobulbo',
        'ajnlitera',
        'ajuto',
        'ajzi',
        'akademio',
        'akcepti',
        'akeo',
        'akiri',
        'aklamado',
        'akmeo',
        'akno',
        'akompani',
        'akrobato',
        'akselo',
        'aktiva',
        'akurata',
        'akvofalo',
        'alarmo',
        'albumo',
        'alcedo',
        'aldoni',
        'aleo',
        'alfabeto',
        'algo',
        'alhasti',
        'aligatoro',
        'alkoholo',
        'almozo',
        'alnomo',
        'alojo',
        'alpinisto',
        'alrigardi',
        'alskribi',
        'alta',
        'alumeto',
        'alveni',
        'alzaca',
        'amaso',
        'ambasado',
        'amdeklaro',
        'amebo',
        'amfibio',
        'amhara',
        'amiko',
        'amkanto',
        'amletero',
        'amnestio',
        'amoranto',
        'amplekso',
        'amrakonto',
        'amsterdama',
        'amuzi',
        'ananaso',
        'androido',
        'anekdoto',
        'anfrakto',
        'angulo',
        'anheli',
        'animo',
        'anjono',
        'ankro',
        'anonci',
        'anpriskribo',
        'ansero',
        'antikva',
        'anuitato',
        'aorto',
        'aparta',
        'aperti',
        'apika',
        'aplikado',
        'apneo',
        'apogi',
        'aprobi',
        'apsido',
        'apterigo',
        'apudesto',
        'araneo',
        'arbo',
        'ardeco',
        'aresti',
        'argilo',
        'aristokrato',
        'arko',
        'arlekeno',
        'armi',
        'arniko',
        'aromo',
        'arpio',
        'arsenalo',
        'artisto',
        'aruba',
        'arvorto',
        'asaio',
        'asbesto',
        'ascendi',
        'asekuri',
        'asfalto',
        'asisti',
        'askalono',
        'asocio',
        'aspekti',
        'astro',
        'asulo',
        'atakonto',
        'atendi',
        'atingi',
        'atleto',
        'atmosfero',
        'atomo',
        'atropino',
        'atuto',
        'avataro',
        'aventuro',
        'aviadilo',
        'avokado',
        'azaleo',
        'azbuko',
        'azenino',
        'azilpetanto',
        'azoto',
        'azteka',
        'babili',
        'bacilo',
        'badmintono',
        'bagatelo',
        'bahama',
        'bajoneto',
        'baki',
        'balai',
        'bambuo',
        'bani',
        'baobabo',
        'bapti',
        'baro',
        'bastono',
        'batilo',
        'bavara',
        'bazalto',
        'beata',
        'bebofono',
        'bedo',
        'begonio',
        'behaviorismo',
        'bejlo',
        'bekero',
        'belarto',
        'bemolo',
        'benko',
        'bereto',
        'besto',
        'betulo',
        'bevelo',
        'bezoni',
        'biaso',
        'biblioteko',
        'biciklo',
        'bidaro',
        'bieno',
        'bifsteko',
        'bigamiulo',
        'bijekcio',
        'bikino',
        'bildo',
        'bimetalismo',
        'bindi',
        'biografio',
        'birdo',
        'biskvito',
        'bitlibro',
        'bivako',
        'bizara',
        'bjalistoka',
        'blanka',
        'bleki',
        'blinda',
        'blovi',
        'blua',
        'boato',
        'bobsledo',
        'bocvanano',
        'bodisatvo',
        'bofratino',
        'bogefratoj',
        'bohema',
        'boji',
        'bokalo',
        'boli',
        'bombono',
        'bona',
        'bopatrino',
        'bordo',
        'bosko',
        'botelo',
        'bovido',
        'brakpleno',
        'bretaro',
        'brikmuro',
        'broso',
        'brulema',
        'bubalo',
        'buctrapi',
        'budo',
        'bufedo',
        'bugio',
        'bujabeso',
        'buklo',
        'buldozo',
        'bumerango',
        'bunta',
        'burokrataro',
        'busbileto',
        'butero',
        'buzuko',
        'caro',
        'cebo',
        'ceceo',
        'cedro',
        'cefalo',
        'cejana',
        'cekumo',
        'celebri',
        'cemento',
        'cent',
        'cepo',
        'certa',
        'cetera',
        'cezio',
        'ciano',
        'cibeto',
        'cico',
        'cidro',
        'cifero',
        'cigaredo',
        'ciklo',
        'cilindro',
        'cimbalo',
        'cinamo',
        'cipreso',
        'cirkonstanco',
        'cisterno',
        'citrono',
        'ciumi',
        'civilizado',
        'colo',
        'congo',
        'cunamo',
        'cvana',
        'dabi',
        'daco',
        'dadaismo',
        'dafodilo',
        'dago',
        'daimio',
        'dajmono',
        'daktilo',
        'dalio',
        'damo',
        'danki',
        'darmo',
        'datumoj',
        'dazipo',
        'deadmoni',
        'debeto',
        'decidi',
        'dedukti',
        'deerigi',
        'defendi',
        'degeli',
        'dehaki',
        'deirpunkto',
        'deklaracio',
        'delikata',
        'demandi',
        'dento',
        'dependi',
        'derivi',
        'desegni',
        'detrui',
        'devi',
        'deziri',
        'dialogo',
        'dicentro',
        'didaktika',
        'dieto',
        'diferenci',
        'digesti',
        'diino',
        'dikfingro',
        'diligenta',
        'dimensio',
        'dinamo',
        'diodo',
        'diplomo',
        'direkte',
        'diskuti',
        'diurno',
        'diversa',
        'dizajno',
        'dobrogitaro',
        'docento',
        'dogano',
        'dojeno',
        'doktoro',
        'dolori',
        'domego',
        'donaci',
        'dopado',
        'dormi',
        'dosierujo',
        'dotita',
        'dozeno',
        'drato',
        'dresi',
        'drinki',
        'droni',
        'druido',
        'duaranga',
        'dubi',
        'ducent',
        'dudek',
        'duelo',
        'dufoje',
        'dugongo',
        'duhufa',
        'duilo',
        'dujare',
        'dukato',
        'duloka',
        'dumtempe',
        'dungi',
        'duobla',
        'dupiedulo',
        'dura',
        'dusenca',
        'dutaga',
        'duuma',
        'duvalvuloj',
        'duzo',
        'ebena',
        'eblecoj',
        'ebono',
        'ebria',
        'eburo',
        'ecaro',
        'ecigi',
        'ecoj',
        'edelvejso',
        'editoro',
        'edro',
        'eduki',
        'edzino',
        'efektiva',
        'efiki',
        'efloreski',
        'egala',
        'egeco',
        'egiptologo',
        'eglefino',
        'egoista',
        'egreto',
        'ejakuli',
        'ejlo',
        'ekarto',
        'ekbruligi',
        'ekceli',
        'ekde',
        'ekesti',
        'ekfirmao',
        'ekgliti',
        'ekhavi',
        'ekipi',
        'ekkapti',
        'eklezio',
        'ekmalsati',
        'ekonomio',
        'ekpluvi',
        'ekrano',
        'ekster',
        'ektiri',
        'ekumeno',
        'ekvilibro',
        'ekzemplo',
        'elasta',
        'elbalai',
        'elcento',
        'eldoni',
        'elektro',
        'elfari',
        'elgliti',
        'elhaki',
        'elipso',
        'elkovi',
        'ellasi',
        'elmeti',
        'elnutri',
        'elokventa',
        'elparoli',
        'elrevigi',
        'elstari',
        'elteni',
        'eluzita',
        'elvoki',
        'elzasa',
        'emajlo',
        'embaraso',
        'emerito',
        'emfazo',
        'eminenta',
        'emocio',
        'empiria',
        'emulsio',
        'enarkivigi',
        'enboteligi',
        'enciklopedio',
        'endorfino',
        'energio',
        'enfermi',
        'engluti',
        'enhavo',
        'enigmo',
        'enjekcio',
        'enketi',
        'enlanda',
        'enmeti',
        'enorma',
        'enplanti',
        'enradiki',
        'enspezo',
        'entrepreni',
        'enui',
        'envolvi',
        'enzimo',
        'eono',
        'eosto',
        'epitafo',
        'epoko',
        'epriskribebla',
        'epsilono',
        'erari',
        'erbio',
        'erco',
        'erekti',
        'ergonomia',
        'erikejo',
        'ermito',
        'erotika',
        'erpilo',
        'erupcio',
        'esameno',
        'escepti',
        'esenco',
        'eskapi',
        'esotera',
        'esperi',
        'estonto',
        'etapo',
        'etendi',
        'etfingro',
        'etikedo',
        'etlitero',
        'etmakleristo',
        'etnika',
        'etoso',
        'etradio',
        'etskala',
        'etullernejo',
        'evakui',
        'evento',
        'eviti',
        'evolui',
        'ezoko',
        'fabriko',
        'facila',
        'fadeno',
        'fagoto',
        'fajro',
        'fakto',
        'fali',
        'familio',
        'fanatiko',
        'farbo',
        'fasko',
        'fatala',
        'favora',
        'fazeolo',
        'febro',
        'federacio',
        'feino',
        'fekunda',
        'felo',
        'femuro',
        'fenestro',
        'fermi',
        'festi',
        'fetora',
        'fezo',
        'fiasko',
        'fibro',
        'fidela',
        'fiera',
        'fifama',
        'figuro',
        'fiherbo',
        'fiinsekto',
        'fiksa',
        'filmo',
        'fimensa',
        'finalo',
        'fiolo',
        'fiparoli',
        'firmao',
        'fisko',
        'fitingo',
        'fiuzanto',
        'fivorto',
        'fiziko',
        'fjordo',
        'flago',
        'flegi',
        'flirti',
        'floro',
        'flugi',
        'fobio',
        'foceno',
        'foirejo',
        'fojfoje',
        'fokuso',
        'folio',
        'fomenti',
        'fonto',
        'formulo',
        'fosforo',
        'fotografi',
        'fratino',
        'fremda',
        'friti',
        'frosto',
        'frua',
        'ftizo',
        'fuelo',
        'fugo',
        'fuksia',
        'fulmilo',
        'fumanto',
        'fundamento',
        'fuorto',
        'furioza',
        'fusilo',
        'futbalo',
        'fuzio',
        'gabardino',
        'gado',
        'gaela',
        'gafo',
        'gagato',
        'gaja',
        'gaki',
        'galanta',
        'gamao',
        'ganto',
        'gapulo',
        'gardi',
        'gasto',
        'gavio',
        'gazeto',
        'geamantoj',
        'gebani',
        'geedzeco',
        'gefratoj',
        'geheno',
        'gejsero',
        'geko',
        'gelateno',
        'gemisto',
        'geniulo',
        'geografio',
        'gepardo',
        'geranio',
        'gestolingvo',
        'geto',
        'geumo',
        'gibono',
        'giganta',
        'gildo',
        'gimnastiko',
        'ginekologo',
        'gipsi',
        'girlando',
        'gistfungo',
        'gitaro',
        'glazuro',
        'glebo',
        'gliti',
        'globo',
        'gluti',
        'gnafalio',
        'gnejso',
        'gnomo',
        'gnuo',
        'gobio',
        'godetio',
        'goeleto',
        'gojo',
        'golfludejo',
        'gombo',
        'gondolo',
        'gorilo',
        'gospelo',
        'gotika',
        'granda',
        'greno',
        'griza',
        'groto',
        'grupo',
        'guano',
        'gubernatoro',
        'gudrotuko',
        'gufo',
        'gujavo',
        'guldeno',
        'gumi',
        'gupio',
        'guruo',
        'gusto',
        'guto',
        'guvernistino',
        'gvardio',
        'gverilo',
        'gvidanto',
        'habitato',
        'hadito',
        'hafnio',
        'hagiografio',
        'haitiano',
        'hajlo',
        'hakbloko',
        'halti',
        'hamstro',
        'hangaro',
        'hapalo',
        'haro',
        'hasta',
        'hati',
        'havebla',
        'hazardo',
        'hebrea',
        'hedero',
        'hegemonio',
        'hejmo',
        'hektaro',
        'helpi',
        'hemisfero',
        'heni',
        'hepato',
        'herbo',
        'hesa',
        'heterogena',
        'heziti',
        'hiacinto',
        'hibrida',
        'hidrogeno',
        'hieroglifo',
        'higieno',
        'hihii',
        'hilumo',
        'himno',
        'hindino',
        'hiperteksto',
        'hirundo',
        'historio',
        'hobio',
        'hojli',
        'hokeo',
        'hologramo',
        'homido',
        'honesta',
        'hopi',
        'horizonto',
        'hospitalo',
        'hotelo',
        'huadi',
        'hubo',
        'hufumo',
        'hugenoto',
        'hukero',
        'huligano',
        'humana',
        'hundo',
        'huoj',
        'hupilo',
        'hurai',
        'husaro',
        'hutuo',
        'huzo',
        'iafoje',
        'iagrade',
        'iamaniere',
        'iarelate',
        'iaspeca',
        'ibekso',
        'ibiso',
        'idaro',
        'ideala',
        'idiomo',
        'idolo',
        'iele',
        'igluo',
        'ignori',
        'iguamo',
        'igvano',
        'ikono',
        'iksodo',
        'ikto',
        'iliaflanke',
        'ilkomputilo',
        'ilobreto',
        'ilremedo',
        'ilumini',
        'imagi',
        'imitado',
        'imperio',
        'imuna',
        'incidento',
        'industrio',
        'inerta',
        'infano',
        'ingenra',
        'inhali',
        'iniciati',
        'injekti',
        'inklino',
        'inokuli',
        'insekto',
        'inteligenta',
        'inundi',
        'inviti',
        'ioma',
        'ionosfero',
        'iperito',
        'ipomeo',
        'irana',
        'irejo',
        'irigacio',
        'ironio',
        'isato',
        'islamo',
        'istempo',
        'itinero',
        'itrio',
        'iuloke',
        'iumaniere',
        'iutempe',
        'izolita',
        'jado',
        'jaguaro',
        'jakto',
        'jama',
        'januaro',
        'japano',
        'jarringo',
        'jazo',
        'jenoj',
        'jesulo',
        'jetavio',
        'jezuito',
        'jodli',
        'joviala',
        'juano',
        'jubileo',
        'judismo',
        'jufto',
        'juki',
        'julio',
        'juneca',
        'jupo',
        'juristo',
        'juste',
        'juvelo',
        'kabineto',
        'kadrato',
        'kafo',
        'kahelo',
        'kajako',
        'kakao',
        'kalkuli',
        'kampo',
        'kanti',
        'kapitalo',
        'karaktero',
        'kaserolo',
        'katapulto',
        'kaverna',
        'kazino',
        'kebabo',
        'kefiro',
        'keglo',
        'kejlo',
        'kekso',
        'kelka',
        'kemio',
        'kerno',
        'kesto',
        'kiamaniere',
        'kibuco',
        'kidnapi',
        'kielo',
        'kikero',
        'kilogramo',
        'kimono',
        'kinejo',
        'kiosko',
        'kirurgo',
        'kisi',
        'kitelo',
        'kivio',
        'klavaro',
        'klerulo',
        'klini',
        'klopodi',
        'klubo',
        'knabo',
        'knedi',
        'koalo',
        'kobalto',
        'kodigi',
        'kofro',
        'kohera',
        'koincidi',
        'kojoto',
        'kokoso',
        'koloro',
        'komenci',
        'kontrakto',
        'kopio',
        'korekte',
        'kosti',
        'kotono',
        'kovri',
        'krajono',
        'kredi',
        'krii',
        'krom',
        'kruco',
        'ksantino',
        'ksenono',
        'ksilofono',
        'ksosa',
        'kubuto',
        'kudri',
        'kuglo',
        'kuiri',
        'kuko',
        'kulero',
        'kumuluso',
        'kuneco',
        'kupro',
        'kuri',
        'kuseno',
        'kutimo',
        'kuvo',
        'kuzino',
        'kvalito',
        'kverko',
        'kvin',
        'kvoto',
        'labori',
        'laculo',
        'ladbotelo',
        'lafo',
        'laguno',
        'laikino',
        'laktobovino',
        'lampolumo',
        'landkarto',
        'laosa',
        'lapono',
        'larmoguto',
        'lastjare',
        'latitudo',
        'lavejo',
        'lazanjo',
        'leciono',
        'ledosako',
        'leganto',
        'lekcio',
        'lemura',
        'lentuga',
        'leopardo',
        'leporo',
        'lerni',
        'lesivo',
        'letero',
        'levilo',
        'lezi',
        'liano',
        'libera',
        'liceo',
        'lieno',
        'lifto',
        'ligilo',
        'likvoro',
        'lila',
        'limono',
        'lingvo',
        'lipo',
        'lirika',
        'listo',
        'literatura',
        'liveri',
        'lobio',
        'logika',
        'lojala',
        'lokalo',
        'longa',
        'lordo',
        'lotado',
        'loza',
        'luanto',
        'lubriki',
        'lucida',
        'ludema',
        'luigi',
        'lukso',
        'luli',
        'lumbilda',
        'lunde',
        'lupago',
        'lustro',
        'lutilo',
        'luzerno',
        'maato',
        'maceri',
        'madono',
        'mafiano',
        'magazeno',
        'mahometano',
        'maizo',
        'majstro',
        'maketo',
        'malgranda',
        'mamo',
        'mandareno',
        'maorio',
        'mapigi',
        'marini',
        'masko',
        'mateno',
        'mazuto',
        'meandro',
        'meblo',
        'mecenato',
        'medialo',
        'mefito',
        'megafono',
        'mejlo',
        'mekanika',
        'melodia',
        'membro',
        'mendi',
        'mergi',
        'mespilo',
        'metoda',
        'mevo',
        'mezuri',
        'miaflanke',
        'micelio',
        'mielo',
        'migdalo',
        'mikrofilmo',
        'militi',
        'mimiko',
        'mineralo',
        'miopa',
        'miri',
        'mistera',
        'mitralo',
        'mizeri',
        'mjelo',
        'mnemoniko',
        'mobilizi',
        'mocio',
        'moderna',
        'mohajro',
        'mokadi',
        'molaro',
        'momento',
        'masari',
        'mopso',
        'mordi',
        'moskito',
        'motoro',
        'movimento',
        'mozaiko',
        'mueli',
        'mukozo',
        'muldi',
        'mumio',
        'munti',
        'muro',
        'muskolo',
        'mutacio',
        'muzikisto',
        'nabo',
        'nacio',
        'nadlo',
        'nafto',
        'naiva',
        'najbaro',
        'nanometro',
        'napo',
        'narciso',
        'naski',
        'naturo',
        'navigi',
        'naztruo',
        'neatendite',
        'nebulo',
        'necesa',
        'nedankinde',
        'neebla',
        'nefari',
        'negoco',
        'nehavi',
        'neimagebla',
        'nektaro',
        'nelonga',
        'nematura',
        'nenia',
        'neordinara',
        'nepra',
        'nervuro',
        'nesto',
        'nete',
        'neulo',
        'nevino',
        'nifo',
        'nigra',
        'nihilisto',
        'nikotino',
        'nilono',
        'nimfeo',
        'nitrogeno',
        'nivelo',
        'nobla',
        'nocio',
        'nodozo',
        'nokto',
        'nomkarto',
        'norda',
        'nostalgio',
        'notbloko',
        'novico',
        'nuanco',
        'nuboza',
        'nuda',
        'nugato',
        'nuklea',
        'nuligi',
        'numero',
        'nuntempe',
        'nupto',
        'nura',
        'nutri',
        'oazo',
        'obei',
        'objekto',
        'oblikva',
        'obolo',
        'observi',
        'obtuza',
        'obuso',
        'oceano',
        'odekolono',
        'odori',
        'oferti',
        'oficiala',
        'ofsajdo',
        'ofte',
        'ogivo',
        'ogro',
        'ojstredoj',
        'okaze',
        'okcidenta',
        'okro',
        'oksido',
        'oktobro',
        'okulo',
        'oldulo',
        'oleo',
        'olivo',
        'omaro',
        'ombro',
        'omego',
        'omikrono',
        'omleto',
        'omnibuso',
        'onagro',
        'ondo',
        'oneco',
        'onidire',
        'onklino',
        'onlajna',
        'onomatopeo',
        'ontologio',
        'opaka',
        'operacii',
        'opinii',
        'oportuna',
        'opresi',
        'optimisto',
        'oratoro',
        'orbito',
        'ordinara',
        'orelo',
        'orfino',
        'organizi',
        'orienta',
        'orkestro',
        'orlo',
        'orminejo',
        'ornami',
        'ortangulo',
        'orumi',
        'oscedi',
        'osmozo',
        'ostocerbo',
        'ovalo',
        'ovingo',
        'ovoblanko',
        'ovri',
        'ovulado',
        'ozono',
        'pacama',
        'padeli',
        'pafilo',
        'pagigi',
        'pajlo',
        'paketo',
        'palaco',
        'pampelmo',
        'pantalono',
        'papero',
        'paroli',
        'pasejo',
        'patro',
        'pavimo',
        'peco',
        'pedalo',
        'peklita',
        'pelikano',
        'pensiono',
        'peplomo',
        'pesilo',
        'petanto',
        'pezoforto',
        'piano',
        'picejo',
        'piede',
        'pigmento',
        'pikema',
        'pilkoludo',
        'pimento',
        'pinglo',
        'pioniro',
        'pipromento',
        'pirato',
        'pistolo',
        'pitoreska',
        'piulo',
        'pivoti',
        'pizango',
        'planko',
        'plektita',
        'plibonigi',
        'ploradi',
        'plurlingva',
        'pobo',
        'podio',
        'poeto',
        'pogranda',
        'pohora',
        'pokalo',
        'politekniko',
        'pomarbo',
        'ponevosto',
        'populara',
        'porcelana',
        'postkompreno',
        'poteto',
        'poviga',
        'pozitiva',
        'prapatroj',
        'precize',
        'pridemandi',
        'probable',
        'pruntanto',
        'psalmo',
        'psikologio',
        'psoriazo',
        'pterido',
        'publiko',
        'pudro',
        'pufo',
        'pugnobato',
        'pulovero',
        'pumpi',
        'punkto',
        'pupo',
        'pureo',
        'puso',
        'putrema',
        'puzlo',
        'rabate',
        'racionala',
        'radiko',
        'rafinado',
        'raguo',
        'rajto',
        'rakonti',
        'ralio',
        'rampi',
        'rando',
        'rapida',
        'rastruma',
        'ratifiki',
        'raviolo',
        'razeno',
        'reakcio',
        'rebildo',
        'recepto',
        'redakti',
        'reenigi',
        'reformi',
        'regiono',
        'rehavi',
        'reinspekti',
        'rejesi',
        'reklamo',
        'relativa',
        'rememori',
        'renkonti',
        'reorganizado',
        'reprezenti',
        'respondi',
        'retumilo',
        'reuzebla',
        'revidi',
        'rezulti',
        'rialo',
        'ribeli',
        'ricevi',
        'ridiga',
        'rifuginto',
        'rigardi',
        'rikolti',
        'rilati',
        'rimarki',
        'rinocero',
        'ripozi',
        'riski',
        'ritmo',
        'rivero',
        'rizokampo',
        'roboto',
        'rododendro',
        'rojo',
        'rokmuziko',
        'rolvorto',
        'romantika',
        'ronroni',
        'rosino',
        'rotondo',
        'rovero',
        'rozeto',
        'rubando',
        'rudimenta',
        'rufa',
        'rugbeo',
        'ruino',
        'ruleto',
        'rumoro',
        'runo',
        'rupio',
        'rura',
        'rustimuna',
        'ruzulo',
        'sabato',
        'sadismo',
        'safario',
        'sagaca',
        'sakfluto',
        'salti',
        'samtage',
        'sandalo',
        'sapejo',
        'sarongo',
        'satelito',
        'savano',
        'sbiro',
        'sciado',
        'seanco',
        'sebo',
        'sedativo',
        'segligno',
        'sekretario',
        'selektiva',
        'semajno',
        'senpeza',
        'separeo',
        'servilo',
        'sesangulo',
        'setli',
        'seurigi',
        'severa',
        'sezono',
        'sfagno',
        'sfero',
        'sfinkso',
        'siatempe',
        'siblado',
        'sidejo',
        'siesto',
        'sifono',
        'signalo',
        'siklo',
        'silenti',
        'simpla',
        'sinjoro',
        'siropo',
        'sistemo',
        'situacio',
        'siverto',
        'sizifa',
        'skatolo',
        'skemo',
        'skianto',
        'sklavo',
        'skorpio',
        'skribisto',
        'skulpti',
        'skvamo',
        'slango',
        'sledeto',
        'sliparo',
        'smeraldo',
        'smirgi',
        'smokingo',
        'smuto',
        'snoba',
        'snufegi',
        'sobra',
        'sociano',
        'sodakvo',
        'sofo',
        'soifi',
        'sojlo',
        'soklo',
        'soldato',
        'somero',
        'sonilo',
        'sopiri',
        'sorto',
        'soulo',
        'soveto',
        'sparkado',
        'speciala',
        'spiri',
        'splito',
        'sporto',
        'sprita',
        'spuro',
        'stabila',
        'stelfiguro',
        'stimulo',
        'stomako',
        'strato',
        'studanto',
        'subgrupo',
        'suden',
        'suferanta',
        'sugesti',
        'suito',
        'sukero',
        'sulko',
        'sume',
        'sunlumo',
        'super',
        'surskribeto',
        'suspekti',
        'suturo',
        'svati',
        'svenfali',
        'svingi',
        'svopo',
        'tabako',
        'taglumo',
        'tajloro',
        'taksimetro',
        'talento',
        'tamen',
        'tanko',
        'taoismo',
        'tapioko',
        'tarifo',
        'tasko',
        'tatui',
        'taverno',
        'teatro',
        'tedlaboro',
        'tegmento',
        'tehoro',
        'teknika',
        'telefono',
        'tempo',
        'tenisejo',
        'teorie',
        'teraso',
        'testudo',
        'tetablo',
        'teujo',
        'tezo',
        'tialo',
        'tibio',
        'tielnomata',
        'tifono',
        'tigro',
        'tikli',
        'timida',
        'tinkturo',
        'tiom',
        'tiparo',
        'tirkesto',
        'titolo',
        'tiutempe',
        'tizano',
        'tobogano',
        'tofeo',
        'togo',
        'toksa',
        'tolerema',
        'tombolo',
        'tondri',
        'topografio',
        'tordeti',
        'tosti',
        'totalo',
        'traduko',
        'tredi',
        'triangulo',
        'tropika',
        'trumpeto',
        'tualeto',
        'tubisto',
        'tufgrebo',
        'tuja',
        'tukano',
        'tulipo',
        'tumulto',
        'tunelo',
        'turisto',
        'tusi',
        'tutmonda',
        'tvisto',
        'udono',
        'uesto',
        'ukazo',
        'ukelelo',
        'ulcero',
        'ulmo',
        'ultimato',
        'ululi',
        'umbiliko',
        'unco',
        'ungego',
        'uniformo',
        'unkti',
        'unukolora',
        'uragano',
        'urbano',
        'uretro',
        'urino',
        'ursido',
        'uskleco',
        'usonigi',
        'utero',
        'utila',
        'utopia',
        'uverturo',
        'uzadi',
        'uzeblo',
        'uzino',
        'uzkutimo',
        'uzofini',
        'uzurpi',
        'uzvaloro',
        'vadejo',
        'vafleto',
        'vagono',
        'vahabismo',
        'vajco',
        'vakcino',
        'valoro',
        'vampiro',
        'vangharoj',
        'vaporo',
        'varma',
        'vasta',
        'vato',
        'vazaro',
        'veaspekta',
        'vedismo',
        'vegetalo',
        'vehiklo',
        'vejno',
        'vekita',
        'velstango',
        'vemieno',
        'vendi',
        'vepro',
        'verando',
        'vespero',
        'veturi',
        'veziko',
        'viando',
        'vibri',
        'vico',
        'videbla',
        'vifio',
        'vigla',
        'viktimo',
        'vila',
        'vimeno',
        'vintro',
        'violo',
        'vippuno',
        'virtuala',
        'viskoza',
        'vitro',
        'viveca',
        'viziti',
        'vobli',
        'vodko',
        'vojeto',
        'vokegi',
        'volbo',
        'vomema',
        'vono',
        'vortaro',
        'vosto',
        'voti',
        'vrako',
        'vringi',
        'vualo',
        'vulkano',
        'vundo',
        'vuvuzelo',
        'zamenhofa',
        'zapi',
        'zebro',
        'zefiro',
        'zeloto',
        'zenismo',
        'zeolito',
        'zepelino',
        'zeto',
        'zigzagi',
        'zinko',
        'zipo',
        'zirkonio',
        'zodiako',
        'zoeto',
        'zombio',
        'zono',
        'zoologio',
        'zorgi',
        'zukino',
        'zumilo',
      ])
    );
    langs.push(
      new MnemonicLang('ukrainian', 'uk', 4, [
        'абат',
        'абощо',
        'абсурд',
        'автор',
        'агов',
        'адепт',
        'азарт',
        'акцент',
        'алея',
        'альбом',
        'альфа',
        'амінь',
        'ананас',
        'ангар',
        'анкета',
        'апарат',
        'арена',
        'арешт',
        'аркуш',
        'армія',
        'аромат',
        'артист',
        'артіль',
        'арфа',
        'аршин',
        'атлас',
        'атож',
        'афіша',
        'бабай',
        'бабин',
        'бавити',
        'багач',
        'бажати',
        'балон',
        'банан',
        'банк',
        'бариня',
        'барліг',
        'бармен',
        'барон',
        'бачити',
        'баюра',
        'береза',
        'бидло',
        'билина',
        'бильце',
        'битва',
        'битий',
        'бичок',
        'благо',
        'бланк',
        'ближче',
        'блиск',
        'бляха',
        'блідий',
        'бодай',
        'болото',
        'болт',
        'бомба',
        'бора',
        'борт',
        'борщ',
        'босий',
        'боягуз',
        'боязко',
        'брань',
        'браття',
        'брижа',
        'бритва',
        'бронза',
        'брук',
        'брусок',
        'бувало',
        'будка',
        'будяк',
        'буква',
        'букет',
        'було',
        'бурка',
        'буряк',
        'бути',
        'буття',
        'буфет',
        'бухати',
        'бюст',
        'бігти',
        'бігцем',
        'бідняк',
        'бізнес',
        'бійка',
        'білан',
        'бісик',
        'вабити',
        'вада',
        'вага',
        'вадити',
        'важіль',
        'вазон',
        'валер',
        'валити',
        'валун',
        'вальс',
        'валюта',
        'валяти',
        'валіза',
        'вампір',
        'вантаж',
        'варкий',
        'васал',
        'ватага',
        'вахтер',
        'вбити',
        'вбік',
        'вверх',
        'ввесь',
        'вгорі',
        'вдало',
        'вдати',
        'вдвох',
        'вдень',
        'вдова',
        'вдома',
        'вдягти',
        'вельми',
        'вепр',
        'верета',
        'версія',
        'вертеп',
        'вершок',
        'весло',
        'весна',
        'вести',
        'весь',
        'вечеря',
        'вжити',
        'взвод',
        'взимку',
        'взнати',
        'взятий',
        'вибрик',
        'вигляд',
        'визиск',
        'вийти',
        'викрик',
        'вилиця',
        'вимити',
        'винен',
        'винний',
        'вираз',
        'вирій',
        'витати',
        'виток',
        'вихід',
        'вишити',
        'вишкіл',
        'вишня',
        'вищати',
        'вищий',
        'вкрай',
        'вкупі',
        'вмерти',
        'вміст',
        'вміти',
        'вниз',
        'вовчий',
        'вогкий',
        'вогонь',
        'вода',
        'водний',
        'вождь',
        'возний',
        'вокзал',
        'волох',
        'волхв',
        'воля',
        'ворог',
        'воша',
        'вперше',
        'вплив',
        'вправо',
        'врешті',
        'врожай',
        'всього',
        'всюди',
        'всякий',
        'втерти',
        'втома',
        'втрата',
        'втіха',
        'вузлик',
        'вуйко',
        'вулиця',
        'вулкан',
        'вусик',
        'вчора',
        'вщент',
        'віват',
        'відати',
        'відлік',
        'відсік',
        'відхід',
        'відьма',
        'війна',
        'вікно',
        'вікінг',
        'віник',
        'вінок',
        'віра',
        'віршик',
        'віск',
        'вість',
        'вісім',
        'вітер',
        'віхоть',
        'вішати',
        'віяти',
        'гадати',
        'гайда',
        'галузь',
        'ганити',
        'гаплик',
        'гаразд',
        'гарба',
        'гарно',
        'гарт',
        'гатити',
        'гвинт',
        'генрі',
        'геолог',
        'герб',
        'герць',
        'гиря',
        'гладко',
        'глас',
        'глек',
        'глечик',
        'глузд',
        'глухий',
        'гнаний',
        'гнида',
        'гнилий',
        'гнути',
        'гнівно',
        'гнідий',
        'гніздо',
        'гній',
        'годен',
        'година',
        'голка',
        'голота',
        'голуб',
        'гонець',
        'гонор',
        'гопак',
        'гордий',
        'горло',
        'горня',
        'горст',
        'горщик',
        'гостя',
        'готово',
        'градус',
        'грань',
        'грати',
        'граф',
        'грація',
        'гребти',
        'грек',
        'грець',
        'гречка',
        'грубо',
        'грудка',
        'грюкіт',
        'грітий',
        'гріх',
        'губка',
        'гудок',
        'гуляти',
        'гумка',
        'гурт',
        'гусар',
        'гуси',
        'гусінь',
        'гута',
        'гуцул',
        'гяур',
        'гідний',
        'гімн',
        'гіпс',
        'гіркий',
        'гірше',
        'давити',
        'далеко',
        'далі',
        'дамба',
        'дань',
        'дарма',
        'даром',
        'дата',
        'датися',
        'датчик',
        'дашок',
        'дверці',
        'двійка',
        'двір',
        'двічі',
        'дедалі',
        'декан',
        'демон',
        'депеша',
        'дерево',
        'дерти',
        'десь',
        'деякий',
        'деінде',
        'джаз',
        'джинси',
        'джип',
        'дзьоб',
        'дибати',
        'дивина',
        'дивний',
        'дикий',
        'димар',
        'динька',
        'дитя',
        'днище',
        'добро',
        'добір',
        'довбня',
        'довго',
        'доволі',
        'довший',
        'догляд',
        'додати',
        'додому',
        'дожити',
        'дозвіл',
        'доки',
        'докір',
        'долати',
        'долу',
        'доля',
        'дома',
        'донизу',
        'донька',
        'доня',
        'допіру',
        'дорога',
        'досвід',
        'дослід',
        'доста',
        'досі',
        'дотик',
        'дотла',
        'доторк',
        'доцент',
        'доїти',
        'друг',
        'друкар',
        'дрібно',
        'дуга',
        'дуже',
        'дужий',
        'дукач',
        'думка',
        'дурно',
        'дуріти',
        'дути',
        'душно',
        'дюна',
        'дядина',
        'дятел',
        'дідусь',
        'дійти',
        'ділити',
        'діра',
        'дірка',
        'дітися',
        'егоїзм',
        'едем',
        'екстаз',
        'екіпаж',
        'еліта',
        'етап',
        'етюд',
        'ефект',
        'ешелон',
        'жадоба',
        'жалоба',
        'жаль',
        'жанр',
        'жахати',
        'жахний',
        'жваво',
        'жереб',
        'жертва',
        'жест',
        'живити',
        'живо',
        'жилка',
        'житися',
        'житло',
        'житній',
        'життя',
        'жменя',
        'жмут',
        'жнець',
        'жнива',
        'жовнір',
        'жовтий',
        'жовч',
        'жолоб',
        'жолудь',
        'жрець',
        'жупан',
        'журба',
        'журнал',
        'жучок',
        'жінка',
        'забити',
        'завити',
        'загал',
        'загс',
        'задати',
        'задля',
        'задній',
        'задом',
        'зажити',
        'зайвий',
        'закон',
        'закрут',
        'зала',
        'замет',
        'заміж',
        'заново',
        'заодно',
        'заочно',
        'запах',
        'запона',
        'засув',
        'зась',
        'затято',
        'захист',
        'зачати',
        'зашити',
        'заячий',
        'заєць',
        'збирач',
        'збити',
        'зблиск',
        'збоку',
        'зброя',
        'збіжжя',
        'збір',
        'звання',
        'звити',
        'звичай',
        'зворот',
        'звідти',
        'звір',
        'згаяти',
        'згоден',
        'здати',
        'здоров',
        'земля',
        'зигзаг',
        'зима',
        'зимний',
        'зиск',
        'зйомка',
        'злам',
        'злегка',
        'злий',
        'зліва',
        'злізти',
        'злість',
        'зліт',
        'змити',
        'змога',
        'змійка',
        'зміст',
        'знайда',
        'знання',
        'знову',
        'знятий',
        'зовні',
        'зозуля',
        'зойк',
        'зонд',
        'зорити',
        'зоря',
        'зоріти',
        'зроду',
        'зрідка',
        'зубок',
        'зуміти',
        'зілля',
        'ймення',
        'йолоп',
        'кабан',
        'каблук',
        'казан',
        'казино',
        'какао',
        'кала',
        'калина',
        'калоша',
        'калюжа',
        'канава',
        'канчук',
        'капець',
        'капище',
        'капітан',
        'карась',
        'карета',
        'карта',
        'касета',
        'касир',
        'каска',
        'катати',
        'качан',
        'каша',
        'кашель',
        'кашкет',
        'каяття',
        'каїн',
        'квач',
        'кваша',
        'кволо',
        'кедр',
        'кейс',
        'келих',
        'кефір',
        'кийок',
        'килим',
        'кирея',
        'кирка',
        'кисень',
        'кисло',
        'кисіль',
        'киця',
        'кишеня',
        'кишка',
        'кишіти',
        'клепка',
        'клин',
        'клон',
        'клоун',
        'клубок',
        'клунок',
        'ключ',
        'кліть',
        'книжка',
        'князь',
        'кобура',
        'коваль',
        'ковила',
        'ковпак',
        'ковчег',
        'кодекс',
        'кожух',
        'козеня',
        'козир',
        'козуб',
        'коледж',
        'колиба',
        'колоти',
        'коліно',
        'комаха',
        'комод',
        'конати',
        'конче',
        'конюх',
        'коняка',
        'кора',
        'коржик',
        'корона',
        'корпус',
        'корчма',
        'коса',
        'косий',
        'косяк',
        'котел',
        'котик',
        'котрий',
        'котяра',
        'кофта',
        'кохати',
        'коцюба',
        'кошик',
        'кошт',
        'крадій',
        'краля',
        'крам',
        'кран',
        'кратер',
        'кращий',
        'країна',
        'кредит',
        'крем',
        'кривда',
        'криза',
        'крити',
        'криця',
        'кролик',
        'кругом',
        'крук',
        'кряж',
        'крісло',
        'кубик',
        'кубло',
        'кузина',
        'кузня',
        'кукіль',
        'культ',
        'кума',
        'куна',
        'куняти',
        'купе',
        'купчик',
        'курган',
        'кури',
        'курний',
        'курява',
        'кусник',
        'кутик',
        'кутя',
        'кухоль',
        'кушнір',
        'кшталт',
        'кілер',
        'кіль',
        'кінець',
        'кінчик',
        'кінь',
        'кіоск',
        'кіска',
        'кістка',
        'кітель',
        'кішка',
        'лабети',
        'лава',
        'лавиця',
        'лагуна',
        'ладо',
        'лазити',
        'лазня',
        'ламати',
        'лантух',
        'лапа',
        'лапка',
        'ласка',
        'ласощі',
        'левада',
        'легко',
        'легіон',
        'ледар',
        'ледь',
        'лежак',
        'лезо',
        'лекція',
        'леле',
        'лемент',
        'летіти',
        'лижа',
        'линва',
        'линути',
        'липень',
        'лисиця',
        'лист',
        'литвин',
        'литися',
        'лихий',
        'лицар',
        'лице',
        'личина',
        'личко',
        'лишати',
        'лишити',
        'лобода',
        'логіка',
        'лоза',
        'лозина',
        'лозунг',
        'лопух',
        'лоро',
        'лунати',
        'лупати',
        'луска',
        'льон',
        'любов',
        'любчик',
        'людний',
        'люлька',
        'люто',
        'лягати',
        'ляда',
        'лячно',
        'ліана',
        'лігво',
        'ліжко',
        'ліки',
        'лікоть',
        'лілея',
        'лінь',
        'ліпити',
        'ліпший',
        'ліра',
        'ліса',
        'лісник',
        'літати',
        'літо',
        'лічити',
        'мабуть',
        'магнат',
        'мадам',
        'мазепа',
        'мазур',
        'майдан',
        'майже',
        'майка',
        'майно',
        'майя',
        'маклер',
        'максим',
        'макуха',
        'мальва',
        'малюк',
        'маліти',
        'мандри',
        'маневр',
        'мантія',
        'мара',
        'марка',
        'мармур',
        'марний',
        'марс',
        'марш',
        'масаж',
        'масний',
        'масово',
        'мастак',
        'матка',
        'матуся',
        'мафія',
        'махом',
        'машина',
        'маячня',
        'маєток',
        'медик',
        'медуза',
        'межа',
        'менш',
        'меню',
        'мерщій',
        'мести',
        'месія',
        'мета',
        'метеор',
        'меткий',
        'метод',
        'мечеть',
        'минати',
        'минути',
        'мирний',
        'миро',
        'миска',
        'мисль',
        'мити',
        'митра',
        'миттю',
        'миша',
        'млин',
        'млосно',
        'мляво',
        'мліти',
        'мовби',
        'мовний',
        'могти',
        'мода',
        'модний',
        'модуль',
        'мокро',
        'молоти',
        'монгол',
        'мораль',
        'морг',
        'морок',
        'мотати',
        'мотив',
        'мотор',
        'мотуз',
        'мощі',
        'мрець',
        'мрія',
        'мстити',
        'мудро',
        'мужньо',
        'муляти',
        'мураха',
        'мутний',
        'муха',
        'мушка',
        'мчати',
        'мідь',
        'мікроб',
        'мілкий',
        'міняти',
        'міраж',
        'місити',
        'місток',
        'міцний',
        'набити',
        'набік',
        'навіщо',
        'нагай',
        'нагорі',
        'надати',
        'надмір',
        'надпис',
        'надути',
        'наді',
        'назад',
        'наймит',
        'налити',
        'наліт',
        'намір',
        'напис',
        'напрям',
        'напій',
        'наразі',
        'нарком',
        'наруга',
        'насип',
        'наскок',
        'натовп',
        'натура',
        'нахил',
        'нацист',
        'начеб',
        'неволя',
        'негода',
        'недруг',
        'незле',
        'нелюд',
        'немає',
        'неміч',
        'неначе',
        'ненка',
        'нерв',
        'нехай',
        'нехотя',
        'нижче',
        'никати',
        'нитка',
        'нить',
        'нишком',
        'новак',
        'новела',
        'новина',
        'ножик',
        'носик',
        'носок',
        'носій',
        'нота',
        'нотка',
        'нудний',
        'нужда',
        'нуль',
        'нумо',
        'ніжно',
        'нізащо',
        'нікуди',
        'німб',
        'німець',
        'німота',
        'нічого',
        'ніяк',
        'обабіч',
        'обвал',
        'обидва',
        'обмаль',
        'обмін',
        'обняти',
        'обоз',
        'обора',
        'обоє',
        'обрис',
        'обруч',
        'обхід',
        'обшир',
        'обід',
        'обіч',
        'овал',
        'овес',
        'одежа',
        'одинак',
        'одійти',
        'ожина',
        'окань',
        'окраса',
        'окрім',
        'олія',
        'омар',
        'онде',
        'оний',
        'опора',
        'оправа',
        'опікун',
        'опір',
        'оракул',
        'орач',
        'оргазм',
        'особа',
        'осокір',
        'острів',
        'осуд',
        'осяяти',
        'осінь',
        'отак',
        'отам',
        'отвір',
        'отим',
        'отой',
        'отрок',
        'отрута',
        'офіс',
        'офіцер',
        'охайно',
        'охнути',
        'охота',
        'охочий',
        'оцей',
        'оцінка',
        'очерет',
        'очний',
        'падати',
        'падло',
        'пазуха',
        'пака',
        'палата',
        'палець',
        'палити',
        'палко',
        'пальма',
        'панель',
        'панна',
        'папаха',
        'паркет',
        'паста',
        'патли',
        'патрон',
        'патьок',
        'пафос',
        'пацан',
        'паче',
        'пашіти',
        'паща',
        'певен',
        'певне',
        'педаль',
        'пекуче',
        'пелька',
        'пенсне',
        'пень',
        'перина',
        'перон',
        'перст',
        'перший',
        'печаль',
        'печеня',
        'пилюка',
        'пиляти',
        'пиріг',
        'писар',
        'писк',
        'писок',
        'пиття',
        'пиха',
        'пищати',
        'пияк',
        'плазма',
        'плай',
        'план',
        'пласт',
        'плач',
        'плесо',
        'плече',
        'плин',
        'плугар',
        'плюс',
        'плямка',
        'плівка',
        'плід',
        'плітка',
        'побути',
        'побіля',
        'повз',
        'повний',
        'повіки',
        'погано',
        'погляд',
        'погон',
        'поезія',
        'поет',
        'пожежа',
        'пожива',
        'позад',
        'позов',
        'поки',
        'покора',
        'покров',
        'полин',
        'полк',
        'полюс',
        'поляк',
        'політ',
        'помалу',
        'помста',
        'поміж',
        'понад',
        'попадя',
        'попіл',
        'пора',
        'порив',
        'порода',
        'портал',
        'посаг',
        'посол',
        'потиск',
        'потому',
        'потуга',
        'потіха',
        'пошити',
        'пояс',
        'поїти',
        'право',
        'прадід',
        'праска',
        'присуд',
        'притча',
        'приціл',
        'пробіл',
        'провал',
        'проект',
        'пройти',
        'прокоп',
        'проміж',
        'прорив',
        'просо',
        'протяг',
        'прохід',
        'прояв',
        'пружно',
        'прямий',
        'прірва',
        'псалом',
        'птах',
        'пташка',
        'пузо',
        'пульс',
        'пункт',
        'пусто',
        'пуття',
        'путь',
        'пшоно',
        'півень',
        'півник',
        'піджак',
        'підло',
        'підряд',
        'підхід',
        'піжама',
        'пільга',
        'піна',
        'піонер',
        'після',
        'піст',
        'пітон',
        'піхва',
        'пічка',
        'рабиня',
        'равлик',
        'раджа',
        'ради',
        'радник',
        'район',
        'ракета',
        'рама',
        'рамено',
        'ранг',
        'ранець',
        'ранити',
        'ранком',
        'рано',
        'раніш',
        'раптом',
        'рать',
        'рачки',
        'ребро',
        'рева',
        'ревище',
        'ревний',
        'ревти',
        'регіт',
        'рейка',
        'рейс',
        'рекорд',
        'ректор',
        'ремінь',
        'рента',
        'рецепт',
        'речник',
        'ривок',
        'ридати',
        'ринути',
        'риса',
        'робити',
        'рогоза',
        'родити',
        'роза',
        'розбір',
        'розкіш',
        'розмір',
        'розпад',
        'розум',
        'роман',
        'ротик',
        'рубати',
        'рубець',
        'руда',
        'румун',
        'рурка',
        'русин',
        'рухати',
        'рученя',
        'ручка',
        'рушати',
        'рушій',
        'руїна',
        'рядком',
        'рядно',
        'рядок',
        'ряска',
        'ряст',
        'рівень',
        'рідко',
        'рідня',
        'різкий',
        'різник',
        'рішати',
        'рішучо',
        'сага',
        'садиба',
        'садок',
        'сакви',
        'сало',
        'салют',
        'самець',
        'самиця',
        'сапер',
        'сарана',
        'сварка',
        'сваха',
        'свинка',
        'свято',
        'свіжо',
        'світло',
        'свіча',
        'сейм',
        'секрет',
        'сектор',
        'секція',
        'селити',
        'селюк',
        'серб',
        'сердюк',
        'середа',
        'серп',
        'серія',
        'сизий',
        'синтез',
        'синяк',
        'синій',
        'сириця',
        'ситий',
        'сичати',
        'скала',
        'скарб',
        'скелет',
        'склад',
        'скніти',
        'скоба',
        'скорий',
        'скраю',
        'скриня',
        'слабий',
        'славка',
        'слати',
        'сливка',
        'слимак',
        'служба',
        'сльота',
        'сліпо',
        'смерть',
        'смик',
        'сморід',
        'смутно',
        'сміло',
        'снаряд',
        'снасть',
        'собака',
        'собі',
        'сокира',
        'сокіл',
        'солома',
        'солід',
        'соната',
        'сонний',
        'соня',
        'сопка',
        'сорт',
        'сосна',
        'сотка',
        'соус',
        'соціум',
        'союз',
        'спекти',
        'сперма',
        'спис',
        'спрут',
        'спів',
        'став',
        'старик',
        'стаття',
        'стегно',
        'стеля',
        'стен',
        'стерня',
        'стиль',
        'стисло',
        'стихія',
        'стовп',
        'стоячи',
        'страта',
        'стрий',
        'строфа',
        'струна',
        'стріла',
        'стукач',
        'стулка',
        'стусан',
        'стягти',
        'стіл',
        'стінка',
        'суворо',
        'сувій',
        'суглоб',
        'суддя',
        'судина',
        'судно',
        'судома',
        'сукно',
        'сумно',
        'сунути',
        'сутінь',
        'сухар',
        'сухо',
        'сушити',
        'сущий',
        'суєта',
        'схил',
        'схов',
        'схожий',
        'схрон',
        'схід',
        'сюжет',
        'сяючий',
        'сяяти',
        'сідати',
        'сікач',
        'сірко',
        'сірник',
        'сісти',
        'сіяти',
        'сіяч',
        'табло',
        'табу',
        'тавро',
        'така',
        'талант',
        'тандем',
        'танк',
        'танок',
        'танути',
        'тато',
        'тахта',
        'таїна',
        'таїти',
        'твань',
        'твар',
        'твердо',
        'театр',
        'теза',
        'тема',
        'темний',
        'темп',
        'темінь',
        'тепер',
        'тепло',
        'терези',
        'термос',
        'терор',
        'тертя',
        'тесати',
        'технік',
        'течія',
        'тигр',
        'тикати',
        'тисяча',
        'титар',
        'титул',
        'тихо',
        'тихцем',
        'тиша',
        'тлін',
        'товща',
        'того',
        'толока',
        'тонкий',
        'тонший',
        'тонус',
        'тополя',
        'торба',
        'трава',
        'тракт',
        'транс',
        'треба',
        'тренер',
        'тричі',
        'трон',
        'тропіки',
        'троян',
        'трудар',
        'труна',
        'трюк',
        'трішки',
        'туалет',
        'тугий',
        'тужний',
        'туніка',
        'тупати',
        'тупий',
        'турист',
        'туча',
        'тюрма',
        'тяга',
        'тягти',
        'тяжко',
        'тяжче',
        'тяжіти',
        'тяма',
        'тятива',
        'тіло',
        'тільце',
        'тітка',
        'тітчин',
        'тішити',
        'убір',
        'увесь',
        'уголос',
        'угору',
        'удар',
        'удача',
        'удвічі',
        'узвіз',
        'узяти',
        'укол',
        'украй',
        'улич',
        'уміло',
        'унизу',
        'уночі',
        'уніат',
        'унітаз',
        'унія',
        'уперше',
        'упир',
        'упокій',
        'ураз',
        'уранці',
        'урвище',
        'уряд',
        'услід',
        'усміх',
        'успіх',
        'уста',
        'усього',
        'усякий',
        'утроба',
        'уява',
        'уявити',
        'файл',
        'факт',
        'фальш',
        'фара',
        'фарба',
        'фарс',
        'фасон',
        'фата',
        'фермер',
        'флакон',
        'флот',
        'фляга',
        'фокус',
        'фонд',
        'фора',
        'фотель',
        'фото',
        'фрак',
        'франк',
        'фраза',
        'фреска',
        'футбол',
        'фікція',
        'філія',
        'фірма',
        'хабар',
        'халат',
        'халепа',
        'халупа',
        'хатка',
        'хвала',
        'хвіст',
        'хижка',
        'хитати',
        'хиткий',
        'хитро',
        'хлоп',
        'хмара',
        'хмиз',
        'ходити',
        'хоча',
        'хребет',
        'хрест',
        'хрипко',
        'хропти',
        'хруст',
        'хрущ',
        'хтось',
        'хутір',
        'хідник',
        'хімія',
        'царів',
        'цвісти',
        'цезар',
        'центр',
        'церква',
        'циклон',
        'цинізм',
        'цить',
        'цукор',
        'цупкий',
        'цівка',
        'цікаво',
        'цілий',
        'чавун',
        'чагар',
        'чадо',
        'чайка',
        'чайник',
        'чаклун',
        'чапля',
        'чарка',
        'часник',
        'часом',
        'часто',
        'чати',
        'чаша',
        'чашка',
        'чвара',
        'чекати',
        'чемно',
        'черва',
        'через',
        'черкас',
        'черінь',
        'чесати',
        'честь',
        'чийсь',
        'чимало',
        'чимраз',
        'чинний',
        'чирва',
        'число',
        'чисто',
        'читач',
        'член',
        'човник',
        'чоло',
        'чорний',
        'чорт',
        'чота',
        'чотири',
        'чувати',
        'чудно',
        'чудо',
        'чуже',
        'чужий',
        'чуйний',
        'чума',
        'чути',
        'чутка',
        'чітко',
        'шакал',
        'шалик',
        'шаман',
        'шанець',
        'шати',
        'шафа',
        'шахтар',
        'шашка',
        'швачка',
        'швед',
        'швидко',
        'шедевр',
        'шейх',
        'шеляг',
        'шерех',
        'шериф',
        'шиба',
        'шибка',
        'ширити',
        'широко',
        'ширше',
        'шитво',
        'шити',
        'шкала',
        'шквал',
        'шкода',
        'шкіпер',
        'шкірка',
        'шлик',
        'шлунок',
        'шляхта',
        'шовк',
        'шолом',
        'шофер',
        'шпарко',
        'шпигун',
        'шпиль',
        'шпичак',
        'шрифт',
        'штаб',
        'штамп',
        'штани',
        'штахет',
        'штик',
        'штраф',
        'шуба',
        'шубка',
        'шуліка',
        'шурхіт',
        'шхуна',
        'щабель',
        'щастя',
        'щезати',
        'щеня',
        'щиро',
        'щоби',
        'щодень',
        'щодня',
        'щомиті',
        'щораз',
        'щосили',
        'щічка',
        'ювелір',
        'ювілей',
        'юнга',
        'юрба',
        'юрист',
        'юрма',
        'юрта',
        'явити',
        'явище',
        'ягня',
        'ягода',
        'ягідка',
        'якір',
        'ямочка',
        'ярина',
        'ярка',
        'ярмо',
        'яруга',
        'ясла',
        'ясний',
        'ясніше',
        'ятаган',
        'яхта',
        'ячмінь',
        'ящик',
        'яєчня',
        'євро',
        'єдиний',
        'єство',
        'ідилія',
        'іззаду',
        'ікона',
        'імла',
        'індус',
        'іноді',
        'іній',
        'іржа',
        'іскра',
        'іслам',
        'істота',
        'їжак',
        'їжачок',
        'їздити',
        'їхній',
        'ґанок',
        'ґазда',
        'ґвалт',
        'ґрунт',
        'ґуля',
      ])
    );
    return langs;
  }

  static getLang(name: string): MnemonicLang | null {
    const langs = MnemonicLang.getLangs();
    for (const lang of langs) {
      if (lang.name == name) return lang;
    }
    return null;
  }
}
