package com.a4a.g8invoicing.ui.states

import androidx.compose.ui.text.input.TextFieldValue
import com.a4a.g8invoicing.ui.shared.ScreenElement
import java.math.BigDecimal
import java.util.UUID

// This Product is created to manipulate client data,
// without using the ProductSimple.kt generated by sql
// it allows to not specify the client id (that will be auto-incremented)
// and to change properties values (var instead of val)
data class ProductState(
    val id: Int? = null,
    val name: TextFieldValue = TextFieldValue(""),
    val description: TextFieldValue? = null,
    val taxRate: BigDecimal? = null,
    val unit: TextFieldValue? = null,
    val defaultPriceWithoutTax: BigDecimal? = null,
    val defaultPriceWithTax:  BigDecimal? = null,
    // This list would be populated on demand, not when initially fetching all products
    val additionalPrices: List<ProductPrice>? = null,
    val errors: MutableList<Pair<ScreenElement, String?>> = mutableListOf(),
)

data class ProductPrice(
    var id: Int? = null, // id in database
    val idStr: String = UUID.randomUUID().toString(), // Pour identifier chaque prix de manière unique
    var priceWithoutTax: BigDecimal? = null,
    var priceWithTax: BigDecimal? = null,
    var clients: List<ClientRef> = emptyList()

)

data class ClientRef(
    val id: Int,
    val name: String
)