package com.a4a.g8invoicing.ui.states

import androidx.compose.ui.text.input.TextFieldValue
import com.a4a.g8invoicing.ui.navigation.DocumentTag
import com.a4a.g8invoicing.ui.shared.DocumentType
import java.math.BigDecimal

// This Document is created to manipulate Document data,
// without using the DocumentSimple.kt generated by sql
// it allows to not specify the Document id (that will be auto-incremented)
// and to change properties values (var instead of val)

abstract class DocumentState {
    abstract var documentId: Int?
    abstract var documentType: DocumentType
    abstract var documentTag: DocumentTag
    abstract var documentNumber: TextFieldValue // TextFieldValue mandatory to control placing the cursor in the field
    abstract var documentDate: String
    abstract var reference: TextFieldValue?
    abstract var freeField: TextFieldValue?
    abstract var documentIssuer: ClientOrIssuerState?
    abstract var documentClient: ClientOrIssuerState?
    abstract var documentProducts: List<DocumentProductState>?
    abstract var documentTotalPrices: DocumentTotalPrices?
    abstract var currency: TextFieldValue
    abstract var footerText: TextFieldValue
    abstract var createdDate: String?
}

data class DocumentTotalPrices(
    var totalPriceWithoutTax: BigDecimal? = null,
    var totalAmountsOfEachTax: MutableList<Pair<BigDecimal, BigDecimal>>? = null, //ex:  [(20.0, 7.2), (10.0, 2.4)]
    var totalPriceWithTax: BigDecimal? = null,
)
