package com.a4a.g8invoicing.ui.states

import androidx.compose.ui.text.input.TextFieldValue
import com.a4a.g8invoicing.R
import com.a4a.g8invoicing.Strings
import com.a4a.g8invoicing.ui.shared.ScreenElement
import com.a4a.g8invoicing.ui.viewmodels.ClientOrIssuerType

// This object is created to manipulate client or issuer data,
// without using the Client.kt / Issuer.kt generated by sql
// it allows to not specify the client id (that will be auto-incremented)
// and to change properties values (var instead of val)
data class ClientOrIssuerState(
    var id: Int? = null,
    var type: ClientOrIssuerType? = null,
    var originalClientId: Int? = null, // ID du client original (pour les documents)
    var firstName: TextFieldValue? = null,
    var name: TextFieldValue = TextFieldValue(""),
    var addresses: List<AddressState>? = null,
    var phone: TextFieldValue? = null,
    var email: TextFieldValue? = null,
    var notes: TextFieldValue? = null,
    var companyId1Label: TextFieldValue? = TextFieldValue(Strings.get(R.string.document_default_issuer_company_label1)),
    var companyId1Number: TextFieldValue? = null,
    var companyId2Label: TextFieldValue? = TextFieldValue(Strings.get(R.string.document_default_issuer_company_label2)),
    var companyId2Number: TextFieldValue? = null,
    var companyId3Label: TextFieldValue? = TextFieldValue(Strings.get(R.string.document_default_issuer_company_label3)),
    var companyId3Number: TextFieldValue? = null,
    var errors: MutableList<Pair<ScreenElement, String?>> = mutableListOf(),
)

data class AddressState(
    var id: Int? = null,
    var addressTitle: TextFieldValue? = null,
    var addressLine1: TextFieldValue? = null,
    var addressLine2: TextFieldValue? = null,
    var zipCode: TextFieldValue? = null,
    var city: TextFieldValue? = null,
)