package cn.a10miaomiao.bilimiao.compose.pages.auth.components

import androidx.compose.foundation.layout.Box
import androidx.compose.material3.DropdownMenu
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue

@Composable
fun InternationalDialingPrefixSelect(
    value: String,
    onChange: (String) -> Unit,
) {
    var expanded by remember { mutableStateOf(false) }
    Box {
        TextButton(
            onClick = {
                expanded = true
            }
        ) {
            Text("+$value")
        }
        DropdownMenu(
            expanded = expanded,
            onDismissRequest = { expanded = false },
        ) {
            for (item in InternationalDialingPrefixList) {
                DropdownMenuItem(
                    text = {
                        Text(text = "${item.second}(+${item.first})")
                    },
                    onClick = {
                        onChange(item.first)
                        expanded = false
                    }
                )
            }
        }
    }

}

val InternationalDialingPrefixList = listOf(
    "86" to "中国大陆",
    "852" to "中国香港特别行政区",
    "853" to "中国澳门特别行政区",
    "886" to "中国台湾",
    "1" to "美国",
    "32" to "比利时",
    "61" to "澳大利亚",
    "33" to "法国",
    "1" to "加拿大",
    "81" to "日本",
    "65" to "新加坡",
    "82" to "韩国",
    "60" to "马来西亚",
    "44" to "英国",
    "39" to "意大利",
    "49" to "德国",
    "7" to "俄罗斯",
    "64" to "新西兰",
    "1681" to "瓦利斯群岛和富图纳群岛",
    "351" to "葡萄牙",
    "680" to "帕劳",
    "672" to "诺福克岛",
    "47" to "挪威",
    "683" to "纽埃岛",
    "234" to "尼日利亚",
    "227" to "尼日尔",
    "505" to "尼加拉瓜",
    "977" to "尼泊尔",
    "674" to "瑙鲁",
    "995" to "格鲁吉亚",
    "46" to "瑞典",
    "966" to "沙特阿拉伯",
    "259" to "桑给巴尔岛",
    "248" to "塞舌尔共和国",
    "357" to "塞浦路斯",
    "221" to "塞内加尔",
    "232" to "塞拉利昂",
    "684" to "萨摩亚，东部",
    "685" to "萨摩亚，西部",
    "503" to "萨尔瓦多",
    "41" to "瑞士",
    "239" to "圣多美和普林西比",
    "381" to "塞尔维亚",
    "27" to "南非",
    "222" to "毛里塔尼亚",
    "230" to "毛里求斯",
    "692" to "马歇尔岛",
    "596" to "马提尼克岛",
    "389" to "马其顿",
    "1670" to "马里亚纳岛",
    "223" to "马里",
    "265" to "马拉维",
    "356" to "马耳他",
    "960" to "马尔代夫",
    "976" to "蒙古",
    "1664" to "蒙特塞拉特岛",
    "264" to "纳米比亚",
    "52" to "墨西哥",
    "258" to "莫桑比克",
    "377" to "摩纳哥",
    "212" to "摩洛哥",
    "373" to "摩尔多瓦",
    "95" to "缅甸",
    "691" to "密克罗尼西亚",
    "51" to "秘鲁",
    "880" to "孟加拉国",
    "261" to "马达加斯加",
    "1784" to "圣卢西亚",
    "56" to "智利",
    "1876" to "牙买加",
    "963" to "叙利亚",
    "36" to "匈牙利",
    "225" to "科特迪瓦",
    "30" to "希腊",
    "34" to "西班牙",
    "998" to "乌兹别克斯坦",
    "598" to "乌拉圭",
    "380" to "乌克兰",
    "256" to "乌干达",
    "374" to "亚美尼亚",
    "967" to "也门",
    "350" to "直布罗陀",
    "235" to "乍得",
    "260" to "赞比亚",
    "84" to "越南",
    "962" to "约旦",
    "62" to "印尼",
    "91" to "印度",
    "972" to "以色列",
    "98" to "伊朗",
    "964" to "伊拉克",
    "673" to "文莱",
    "58" to "委内瑞拉",
    "1284" to "维珍群岛(英属)",
    "66" to "泰国",
    "252" to "索马里",
    "677" to "所罗门群岛",
    "597" to "苏里南",
    "249" to "苏丹",
    "268" to "斯威士兰",
    "386" to "斯洛文尼亚",
    "421" to "斯洛伐克",
    "94" to "斯里兰卡",
    "508" to "圣皮埃尔和密克隆群岛",
    "255" to "坦桑尼亚",
    "676" to "汤加",
    "1340" to "维珍群岛(美属)",
    "678" to "瓦努阿图",
    "690" to "托克劳岛",
    "993" to "土库曼斯坦",
    "90" to "土耳其",
    "688" to "图瓦卢",
    "216" to "突尼斯",
    "247" to "阿森松岛",
    "1868" to "特立尼达和多巴哥",
    "1649" to "特克斯和凯科斯",
    "378" to "圣马力诺",
    "594" to "法属圭亚那",
    "975" to "不丹",
    "267" to "博茨瓦纳",
    "501" to "伯利兹",
    "591" to "玻利维亚",
    "48" to "波兰",
    "387" to "波黑",
    "1787" to "波多黎各",
    "354" to "冰岛",
    "229" to "贝宁",
    "359" to "保加利亚",
    "226" to "布基纳法索",
    "257" to "布隆迪",
    "689" to "法属波利尼西亚",
    "298" to "法罗岛",
    "291" to "厄立特里亚",
    "593" to "厄瓜多尔",
    "1809" to "多米尼加代表",
    "1767" to "多米尼加",
    "228" to "多哥",
    "246" to "迪戈加西亚岛",
    "45" to "丹麦",
    "240" to "赤道几内亚",
    "1441" to "百慕大群岛",
    "375" to "白俄罗斯",
    "55" to "巴西",
    "353" to "爱尔兰",
    "251" to "埃塞俄比亚",
    "20" to "埃及",
    "994" to "阿塞拜疆",
    "968" to "阿曼",
    "971" to "阿联酋",
    "54" to "阿根廷",
    "93" to "阿富汗",
    "213" to "阿尔及利亚",
    "355" to "阿尔巴尼亚",
    "372" to "爱沙尼亚",
    "376" to "安道尔",
    "507" to "巴拿马",
    "973" to "巴林",
    "595" to "巴拉圭",
    "92" to "巴基斯坦",
    "1242" to "巴哈马群岛",
    "675" to "巴布亚新几内亚",
    "1246" to "巴巴多斯",
    "43" to "奥地利",
    "1268" to "安提瓜岛和巴布达",
    "244" to "安哥拉",
    "236" to "非洲中部",
    "40" to "罗马尼亚",
    "965" to "科威特",
    "269" to "科摩罗",
    "1345" to "开曼群岛",
    "974" to "卡塔尔",
    "237" to "喀麦隆",
    "262" to "聚会岛",
    "263" to "津巴布韦",
    "420" to "捷克",
    "855" to "柬埔寨",
    "241" to "加蓬",
    "385" to "克罗地亚",
    "254" to "肯尼亚",
    "250" to "卢旺达",
    "352" to "卢森堡",
    "218" to "利比亚",
    "231" to "利比里亚",
    "370" to "立陶宛",
    "961" to "黎巴嫩",
    "856" to "老挝",
    "266" to "莱索托",
    "371" to "拉脱维亚",
    "682" to "库克岛",
    "233" to "加纳",
    "245" to "几内亚比绍",
    "224" to "几内亚",
    "1473" to "格林纳达",
    "506" to "哥斯达黎加",
    "57" to "哥伦比亚",
    "243" to "刚果(金)",
    "242" to "刚果",
    "220" to "冈比亚",
    "500" to "福克兰岛",
    "238" to "佛得角",
    "358" to "芬兰",
    "679" to "斐济",
    "299" to "格陵兰岛",
    "53" to "古巴",
    "996" to "吉尔吉斯斯坦",
    "253" to "吉布提",
    "686" to "基里巴斯",
    "1808" to "维克岛",
    "504" to "洪都拉斯",
    "31" to "荷兰",
    "850" to "朝鲜",
    "509" to "海地",
    "1671" to "关岛",
    "590" to "瓜德罗普岛",
    "63" to "菲律宾",
)