package com.DartChecker;

import android.app.AlertDialog;
import android.content.Context;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.TextView;

import java.util.List;

public class viewadapter extends RecyclerView.Adapter<viewadapter.ViewHolder> {

    private final List<String> mData;
    private final LayoutInflater mInflater;
    private ItemClickListener mClickListener;
    private final Context con;

    // data is passed into the constructor
    viewadapter(Context context, List<String> data) {
        this.mInflater = LayoutInflater.from(context);
        this.mData = data;
        con = context;
    }

    // inflates the row layout from xml when needed
    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = mInflater.inflate(R.layout.recyclerview_row, parent, false);
        return new ViewHolder(view);
    }

    // binds the data to the TextView in each row
    @Override
    public void onBindViewHolder(final ViewHolder holder, final int position) {
        int positionActual = holder.getAdapterPosition();
        String animal = mData.get(positionActual);
        holder.myTextView.setText(animal);
        holder.deletebutton.setOnClickListener(v -> {
            String dummy2 = MainActivity.allPlayers.get(positionActual).playerName;
            AlertDialog alertDialog = new AlertDialog.Builder(holder.deletebutton.getContext()).create();
            alertDialog.setTitle(con.getResources().getString(R.string.caution));
            alertDialog.setMessage(String.format(con.getResources().getString(R.string.reallyDelete), dummy2));
            alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, con.getResources().getString(R.string.ok),
                    (dialog, which) -> {
                        // delete player completely
                        String itemLabel = mData.get(positionActual);
                        mData.remove(positionActual);
                        notifyItemRemoved(positionActual);
                        notifyItemRangeChanged(positionActual, mData.size());
                        MainActivity.allPlayers.remove(positionActual);
                    });
            alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, con.getResources().getString(R.string.cancel), (dialog, which) -> dialog.dismiss());
            alertDialog.show();
        });
    }

    // total number of rows
    @Override
    public int getItemCount() {
        return mData.size();
    }

    // convenience method for getting data at click position
    String getItem(int id) {
        return mData.get(id);
    }

    // allows clicks events to be caught
    void setClickListener(ItemClickListener itemClickListener) {
        this.mClickListener = itemClickListener;
    }

    // parent activity will implement this method to respond to click events
    public interface ItemClickListener {
        void onItemClick(int position);
    }

    // stores and recycles views as they are scrolled off screen
    public class ViewHolder extends RecyclerView.ViewHolder implements View.OnClickListener {
        final TextView myTextView;
        final ImageButton deletebutton;

        ViewHolder(View itemView) {
            super(itemView);
            myTextView = itemView.findViewById(R.id.tvAnimalName);
            deletebutton = itemView.findViewById(R.id.deletebutton);
            itemView.setOnClickListener(this);
        }

        @Override
        public void onClick(View view) {
            if (mClickListener != null) mClickListener.onItemClick(getAdapterPosition());
        }
    }
}