package com.DartChecker;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import android.os.Bundle;
import android.widget.Button;
import android.widget.TextView;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class info extends AppCompatActivity {
    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(dc_modules.updateBaseContextLocale(base));
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (MainActivity.themeSelected && MainActivity.subDesignChoice) setTheme(R.style.AppThemeBlack);
        else if (MainActivity.themeSelected) setTheme(R.style.AppThemeDark);
        else setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        setContentView(R.layout.activity_info);
        SharedPreferences settings = getSharedPreferences("preferences",0);
        ConstraintLayout main = findViewById(R.id.mainlayoutContent);
        if (settings.contains("keepscreenonmenu")) main.setKeepScreenOn(settings.getBoolean("keepscreenonmenu",false));
        final Button ok = findViewById(R.id.okb);
        ok.setOnClickListener(v -> finish());
        final TextView version = findViewById(R.id.version);
        version.setText(BuildConfig.VERSION_NAME);
        TextView changes = findViewById(R.id.changelog);
        String changesstring = "";
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = this.getResources().openRawResource(R.raw.changelog);
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while (true) {
            try {
                if ((changesstring = reader.readLine()) == null) break;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            stringBuilder.append(changesstring);
            stringBuilder.append(System.lineSeparator());
            changes.setText(stringBuilder);
        }
        try {
            inputStream.close();
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

