package com.DartChecker;

import static com.DartChecker.dc_modules.buttonSelect;
import static com.DartChecker.dc_modules.playAudio;
import static com.DartChecker.dc_modules.dart;
import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Handler;
import android.util.TypedValue;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;

public class halve extends AppCompatActivity {
    private int crazycricketRangeMinimum = 6;
    private final player[] players = new player[9];
    private final ArrayList<dart> dartsThrown = new ArrayList<>();
    private final boolean[] segmentActive = new boolean[26];
    private  ArrayList<Button> allButtons = new ArrayList<>();
    private long startTime = 0;
    private int bcolor;
    private int bcolorn;
    private int textcolorActive,
            textcolorPassive,
            buttonTextcolorActive,
            buttonTextcolorDisabled;
    private float textsizeActive,
            textsizePassive,
            textsizeScoreActive,
            textsizeScorePassive;
    private boolean tripleSelected = false;
    private boolean doubleSelected = false;
    private final View.OnClickListener doubletripleClick = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            Button doubleb = findViewById(R.id.doubleButton);
            Button tripleb = findViewById(R.id.tripleButton);
            Button doubleb_dt = findViewById(R.id.doublebutton_dt);
            Button tripleb_dt = findViewById(R.id.triple_dt);
            doubleb.setBackgroundColor(bcolorn);        // workaround for low api version (15)
            tripleb.setBackgroundColor(bcolorn);        // workaround for low api version (15)
            doubleb_dt.setBackgroundColor(bcolorn);
            tripleb_dt.setBackgroundColor(bcolorn);
            int buttonIdClicked = v.getId();
            if (buttonIdClicked == R.id.doubleButton) {
                    if (tripleSelected) {
                        tripleSelected = false;
                        tripleb.setBackgroundColor(bcolorn);
                    }
                    if (!doubleSelected) {
                        doubleSelected = true;
                        doubleb.setBackgroundColor(bcolor);
                    } else {
                        doubleSelected = false;
                        doubleb.setBackgroundColor(bcolorn);
                    }
            }
            else if (buttonIdClicked == R.id.tripleButton) {
                    if (doubleSelected) {
                        doubleSelected = false;
                        doubleb.setBackgroundColor(bcolorn);
                    }
                    if (!tripleSelected) {
                        tripleSelected = true;
                        tripleb.setBackgroundColor(bcolor);
                    } else {
                        tripleSelected = false;
                        tripleb.setBackgroundColor(bcolorn);
                    }
            }
            else if (buttonIdClicked == R.id.doublebutton_dt) {
                    if (tripleSelected) {
                        tripleSelected = false;
                        tripleb_dt.setBackgroundColor(bcolorn);
                    }
                    if (!doubleSelected) {
                        doubleSelected = true;
                        doubleb_dt.setBackgroundColor(bcolor);
                    } else {
                        doubleSelected = false;
                        doubleb_dt.setBackgroundColor(bcolorn);
                    }
            }
            else if (buttonIdClicked == R.id.triple_dt) {
                    if (doubleSelected) {
                        doubleSelected = false;
                        doubleb_dt.setBackgroundColor(bcolorn);
                    }
                    if (!tripleSelected) {
                        tripleSelected = true;
                        tripleb_dt.setBackgroundColor(bcolor);
                    } else {
                        tripleSelected = false;
                        tripleb_dt.setBackgroundColor(bcolorn);
                    }
            }
        }
    };

    public int 
            playerCount,
            activePlayer = 1,
            thrownDartsInRound = 0,
            scoreThrown,
            changetime = 1500,
            undoCounter = -1;
    private String s = "";
    private CharSequence gameMode;
    private boolean undoQuestionWanted = true;

    private final View.OnClickListener undoclick = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            // securityquestion
             if (undoQuestionWanted) {
                AlertDialog alertDialog = new AlertDialog.Builder(halve.this).create();
                alertDialog.setTitle(getResources().getString(R.string.caution));
                alertDialog.setMessage(getResources().getString(R.string.wantToUndo));
                alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesIDo),
                        (dialog, which) -> {
                            dialog.dismiss();
                            undo();
                        });
                alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.no), (dialog, which) -> dialog.dismiss());
                alertDialog.show();
                 final SharedPreferences settings = getApplicationContext().getSharedPreferences("preferences", 0);
                 if (settings.contains("undoSafetyQuestion")) {
                     if (!settings.getBoolean("undoSafetyQuestion",false)) {
                         alertDialog.hide();
                         alertDialog.getButton(AlertDialog.BUTTON_POSITIVE).performClick();
                     }
                 }
            } else {
                undoQuestionWanted = true;
                undo();
            }
        }

        private void undo() {
            int dart, factor, scoreToAdd;
            TextView darts = findViewById(R.id.darts);
            int activeSegment = activeSegment();
            if (undoCounter >= 0) {
                boolean split = false;
                if (undoCounter >= 2) {
                    int dart1 = dartsThrown.get(undoCounter - 2).factor * dartsThrown.get(undoCounter - 2).segment;
                    int dart2 = dartsThrown.get(undoCounter - 1).factor * dartsThrown.get(undoCounter - 1).segment;
                    int dart3 = dartsThrown.get(undoCounter).factor * dartsThrown.get(undoCounter).segment;
                    int score3darts = dart1+dart2+dart3;
                    if (score3darts == 0 && thrownDartsInRound == 0) split = true;
                }
                if (thrownDartsInRound == 0 && !gameover()) {
                    //player change
                    thrownDartsInRound = 2;
                    s = "..";
                    // deactivate old player
                    textField(1, activePlayer, 3).setTextColor(textcolorPassive);
                    textField(1, activePlayer, 2).setTextColor(textcolorPassive);
                    textField(1, activePlayer, 3).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizePassive);
                    textField(1, activePlayer, 2).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeScorePassive);
                    // change segment
                    if ((activePlayer ==1)) {
                        if (activeSegment!=0) {
                               activateLastSegment(allButtons);
                        }
                    }
                    // activated new player
                    activePlayer = dartsThrown.get(undoCounter).playerIndex;
                    textField(1, activePlayer, 3).setTextColor(textcolorActive);
                    textField(1, activePlayer, 2).setTextColor(textcolorActive);
                    textField(1, activePlayer, 3).setPaintFlags(textField(1, activePlayer, 3).getPaintFlags() & (~Paint.STRIKE_THRU_TEXT_FLAG));
                    textField(1, activePlayer, 2).setPaintFlags(textField(1, activePlayer, 2).getPaintFlags() & (~Paint.STRIKE_THRU_TEXT_FLAG));
                    textField(1, activePlayer, 3).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActive);
                    textField(1, activePlayer, 2).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeScoreActive);
                    if (players[activePlayer].ranking != 0)
                        players[activePlayer].ranking = 0;
                    // if splited, double it!
                    if (split) players[activePlayer].score= players[activePlayer].score*2;
                    scoreThrown = dartsThrown.get(undoCounter).scoreToAdd + dartsThrown.get(undoCounter -1).scoreToAdd + dartsThrown.get(undoCounter -2).scoreToAdd;
                }
                else if (gameover()) { //processing last possible undo
                    thrownDartsInRound = 2;
                    if (split) players[activePlayer].score= players[activePlayer].score*2;
                }
                else thrownDartsInRound--;
                switch (thrownDartsInRound) {
                    case 0:
                        s = "";
                        break;
                    case 1:
                        s = ".";
                        break;
                    case 2:
                        s = "..";
                        break;
                }
                darts.setText(s);
                dart = dartsThrown.get(undoCounter).segment;
                factor = dartsThrown.get(undoCounter).factor;
                scoreToAdd = dartsThrown.get(undoCounter).scoreToAdd;
                players[activePlayer].score -= scoreToAdd;
                String undoMessage = getResources().getString(R.string.undo_1_2_3) + ": ";
                switch (factor) {
                    case 0:
                        if (split)
                            undoMessage = undoMessage + getResources().getString(R.string.halved);
                        else
                            undoMessage = undoMessage + getResources().getString(R.string.missed);
                        break;
                    case 1:
                        undoMessage = undoMessage + dart;
                        break;
                    case 2:
                        undoMessage = undoMessage + getResources().getString(R.string.doublebutton) + " " + dart;
                        break;
                    case 3:
                        undoMessage = undoMessage + getResources().getString(R.string.triple) + " " + dart;
                        break;
                }
                undoMessage = undoMessage + " " + getResources().getString(R.string.from) + " " + players[dartsThrown.get(undoCounter).playerIndex].playerName;
                Toast.makeText(halve.this, undoMessage, Toast.LENGTH_SHORT).show();
                textField(1, activePlayer, 2).setText(String.format(Integer.toString(players[activePlayer].score)));
                int oldScore = 0;
                TextView scoreSegment = textField(activeSegment(), activePlayer,1);
                if (!scoreSegment.getText().toString().isEmpty())
                    oldScore = Integer.parseInt(scoreSegment.getText().toString());
                int newScore = oldScore - scoreToAdd;
                scoreSegment.setText(String.valueOf(newScore));
                if ((newScore == 0) && (thrownDartsInRound == 0))
                    textField(activeSegment(), activePlayer, 1).setText("");
                dartsThrown.remove(undoCounter);
                undoCounter--;
                scoreThrown -= scoreToAdd;
            } else Toast.makeText(halve.this, R.string.noUndo, Toast.LENGTH_LONG).show();
        }
    };

    private final View.OnClickListener weiter = v -> {
        Button missedB = findViewById(R.id.missedButton);
        switch (thrownDartsInRound) {
            case 0:
                missedB.performClick();
            case 1:
                missedB.performClick();
            case 2:
                missedB.performClick();
        }
    };

    private void setAllActive(Boolean active, int segment) {
            if (active) {
                for (int buttonNumber = 1; buttonNumber <= 26; buttonNumber++)
                    buttonSelect_dt(buttonNumber).setVisibility(View.VISIBLE);
                for (int buttonNumber = 0; buttonNumber <= allButtons.size() - 1; buttonNumber++)
                    allButtons.get(buttonNumber).setVisibility(View.GONE);
                for (int buttonNumber = 23; buttonNumber <= 28; buttonNumber++)
                    buttonSelect(buttonNumber,this).setVisibility(View.GONE);
                if (segment == 21) {
                    buttonSelect_dt(21).setTextColor(buttonTextcolorActive);
                    buttonSelect_dt(22).setVisibility(View.INVISIBLE);
                }
                if (segment == 22) {
                    buttonSelect_dt(22).setTextColor(buttonTextcolorActive);
                    buttonSelect_dt(21).setVisibility(View.INVISIBLE);
                }
            } else {
                for (int buttonNumber = 1; buttonNumber <= 26; buttonNumber++)
                    buttonSelect_dt(buttonNumber).setVisibility(View.GONE);
                for (int buttonNumber = 0; buttonNumber <= allButtons.size() - 1; buttonNumber++)
                    allButtons.get(buttonNumber).setVisibility(View.VISIBLE);
                for (int buttonNumber = 23; buttonNumber <= 28; buttonNumber++)
                    buttonSelect(buttonNumber, this).setVisibility(View.VISIBLE);
            }
    }

    private final View.OnClickListener buttonclick = new View.OnClickListener() {
        @SuppressLint("NonConstantResourceId")
        @Override
        public void onClick(View v) {
            int buttonIdClicked = v.getId();
            Button eingabe = findViewById(buttonIdClicked);
            int dart = 0,
                factor = 1,  //assume single as standard case
                addpunkte;
            // which button was pressed?
            switch (buttonIdClicked) {
                case R.id.bull:
                case R.id.bull_dt:
                    dart = 25;
                    break;
                case R.id.missedButton:
                case R.id.missed_dt:
                    factor = 0;
                    dart = activeSegment();
                    break;
                default:
                    try {
                        dart = Integer.parseInt(eingabe.getText().toString());
                    } catch (Exception e) {
                        dart = 255;         //error value - should never happen
                    }
                    break;
            }
            if (doubleSelected)
            {
                if (factor != 0) factor = 2;
                doubleSelected = false;
                Button doubleb = findViewById(R.id.doubleButton);
                doubleb.setBackgroundColor(bcolorn);
                Button double_dt = findViewById(R.id.doublebutton_dt);
                double_dt.setBackgroundColor(bcolorn);
            } else if (tripleSelected)
            {
                if (factor != 0) factor = 3;
                tripleSelected = false;
                Button tripleb = findViewById(R.id.tripleButton);
                tripleb.setBackgroundColor(bcolorn);
                Button tripleb_dt = findViewById(R.id.triple_dt);
                tripleb_dt.setBackgroundColor(bcolorn);
                if (dart == 25) {
                    Toast.makeText(getApplicationContext(), getResources().getString(R.string.tripleBull), Toast.LENGTH_LONG).show();
                    return;
                }
            }
            TextView darts = findViewById(R.id.darts);
            if (thrownDartsInRound < 2) {
                thrownDartsInRound++;
                s = s + (".");
            } else {
                thrownDartsInRound = 0;
                s = "";
            }
            if (segmentActive[21] && factor != 2) factor = 0;
            if (segmentActive[22] && factor != 3) factor = 0;
            players[activePlayer].hits[dart] += factor;
            addpunkte = factor * dart;
            scoreThrown += addpunkte;
            players[activePlayer].score += addpunkte;
            dart actualHit = new dart();
            actualHit.factor = factor;
            undoCounter++;
            actualHit.scoreToAdd = addpunkte;
            actualHit.playerIndex = activePlayer;
            actualHit.segment = dart;
            dartsThrown.add(undoCounter, actualHit);
            int oldscore = 0;
            TextView scorefield = textField(activeSegment(), activePlayer,1);
            if (!scorefield.getText().toString().isEmpty())
                oldscore = Integer.parseInt(scorefield.getText().toString());
            int newscore = oldscore + actualHit.scoreToAdd;
            if (thrownDartsInRound == 0 && scoreThrown == 0) {
                if (players[activePlayer].score % 2 != 0) players[activePlayer].score++;
                players[activePlayer].score = players[activePlayer].score / 2;
            }
            scorefield.setText(String.valueOf(newscore));
            scorefield.setVisibility(View.VISIBLE);
            textField(1, activePlayer, 2).setText(String.format(Integer.toString(players[activePlayer].score)));
            if (gameover()) {
                end();
                return;
            }
            // game continues
            if (thrownDartsInRound == 0) {  //player change
                String message;
                if (scoreThrown !=0) message = Integer.toString(scoreThrown);
                else {
                    message = getResources().getString(R.string.halved);
                }
                buttonfreeze(true);
                final TextView scoreThrownTV = findViewById(R.id.scoreThrown);
                if (players[activePlayer].ranking != 0)
                    scoreThrownTV.setText(String.valueOf(players[activePlayer].ranking).concat("."));
                else scoreThrownTV.setText(message);
                scoreThrownTV.setVisibility(View.VISIBLE);
                playAudio(getApplicationContext(), message);
                new Handler().postDelayed(() -> {
                    buttonfreeze(false);
                    scoreThrownTV.setVisibility(View.INVISIBLE);
                }, changetime);
                scoreThrown = 0;
                textField(1, activePlayer, 3).setTextColor(textcolorPassive);
                textField(1, activePlayer, 2).setTextColor(textcolorPassive);
                textField(1, activePlayer, 3).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizePassive);
                textField(1, activePlayer, 2).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeScorePassive);
                if (activePlayer < playerCount) activePlayer++;
                else activePlayer = 1;
                textField(1, activePlayer, 3).setTextColor(textcolorActive);
                textField(1, activePlayer, 2).setTextColor(textcolorActive);
                textField(1, activePlayer, 3).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActive);
                textField(1, activePlayer, 2).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeScoreActive);
                if (activePlayer == 1) {
                        activateNextSegment(allButtons);
                }
            }
            darts.setText(s);
        }


        private void end()
        {
            AlertDialog alertDialog = new AlertDialog.Builder(halve.this).create();
            alertDialog.setTitle(getResources().getString(R.string.caution));
            alertDialog.setMessage(getResources().getString(R.string.lastInputCorrect));
            alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yes),
                    (dialog, which) -> {
                        dialog.dismiss();
                        if (gameover()) {
                            long gameDuration = (System.currentTimeMillis() - startTime) / 1000;
                            Intent intent = new Intent(halve.this, endofgame.class);
                            intent.putExtra("playercount", playerCount);
                            intent.putExtra("cricket", true);
                            intent.putExtra("gameDuration", gameDuration);
                            for (int i = 1; i <= playerCount; i++) {
                                players[i].ranking = i;
                            }
                            boolean changed = true;
                            int save;
                            while (changed) {
                                changed = false;
                                for (int i = 1; i <= playerCount; i++) {
                                    for (int j = 1; j <= playerCount; j++) {
                                        if (players[i].score > players[j].score && players[i].ranking > players[j].ranking) {
                                            save = players[j].ranking;
                                            players[j].ranking = players[i].ranking;
                                            players[i].ranking = save;
                                            changed = true;
                                        }
                                    }
                                }
                            }
                            // count darts
                            for (int hitIndex = 0; hitIndex<= dartsThrown.size()-1; hitIndex++) {
                                players[dartsThrown.get(hitIndex).playerIndex].darts++;
                            }
                            for (int i = 1; i <= playerCount; i++) {
                                switch (players[i].ranking) {
                                    case 1:
                                        intent.putExtra("first", players[i].playerName);
                                        intent.putExtra("firstscore", players[i].score);
                                        intent.putExtra("firstdarts", players[i].darts);
                                        break;
                                    case 2:
                                        intent.putExtra("second", players[i].playerName);
                                        intent.putExtra("secondscore", players[i].score);
                                        intent.putExtra("seconddarts", players[i].darts);
                                        break;
                                    case 3:
                                        intent.putExtra("third", players[i].playerName);
                                        intent.putExtra("thirdscore", players[i].score);
                                        intent.putExtra("thirddarts", players[i].darts);
                                        break;
                                    case 4:
                                        intent.putExtra("fourth", players[i].playerName);
                                        intent.putExtra("fourthscore", players[i].score);
                                        intent.putExtra("fourthdarts", players[i].darts);
                                        break;
                                    case 5:
                                        intent.putExtra("fifth", players[i].playerName);
                                        intent.putExtra("fifthscore", players[i].score);
                                        intent.putExtra("fünfterpfeile", players[i].darts);
                                        break;
                                    case 6:
                                        intent.putExtra("sixth", players[i].playerName);
                                        intent.putExtra("sixthscore", players[i].score);
                                        intent.putExtra("sixthdarts", players[i].darts);
                                        break;
                                    case 7:
                                        intent.putExtra("seventh", players[i].playerName);
                                        intent.putExtra("seventhscore", players[i].score);
                                        intent.putExtra("seventhdarts", players[i].darts);
                                        break;
                                    case 8:
                                        intent.putExtra("eight", players[i].playerName);
                                        intent.putExtra("eightscore", players[i].score);
                                        intent.putExtra("eightdarts", players[i].darts);
                                        break;
                                }
                            }
                            startActivity(intent);
                            finish();
                            return;
                        }
                        TextView darts = findViewById(R.id.darts);
                        darts.setText(s);
                    });

            alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.no), (dialog, which) -> {
                dialog.dismiss();
                // last hit was a failure -> don't end game and undo last input, without asking
                TextView darts = findViewById(R.id.darts);
                darts.setText(s);
                undoQuestionWanted = false;
                findViewById(R.id.undoButton).performClick();
            });
            if (gameover()) {
                alertDialog.show();
            }
            else {
                alertDialog.getButton(AlertDialog.BUTTON_POSITIVE).performClick();
            }
        }
    };


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (MainActivity.themeSelected && MainActivity.subDesignChoice)
            setTheme(R.style.AppThemeBlack);
        else if (MainActivity.themeSelected) setTheme(R.style.AppThemeDark);
        else setTheme(R.style.Theme_AppCompat_Light_NoActionBar);
        setContentView(R.layout.activity_halve);
        TypedValue outValue = new TypedValue();
        halve.this.getTheme().resolveAttribute(R.attr.colorButtonNormal, outValue, true);
        bcolor = outValue.data;
        halve.this.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        bcolorn = outValue.data;
        SharedPreferences settings = getSharedPreferences("preferences", 0);
        ConstraintLayout main = findViewById(R.id.matchbereich);
        if (settings.contains("keepscreenongame"))
            main.setKeepScreenOn(settings.getBoolean("keepscreenongame", true));
        TextView p1name = findViewById(R.id.p1name);
        TextView p2name = findViewById(R.id.p2name);
        textcolorActive = p1name.getCurrentTextColor();
        textcolorPassive = p2name.getCurrentTextColor();
        textsizePassive = p2name.getTextSize();
        textsizeActive = textsizePassive + 4;
        TextView p1score = findViewById(R.id.p1score);
        textsizeScorePassive = p1score.getTextSize();
        textsizeScoreActive = p1score.getTextSize() + 4;
        buttonSelect(16,this).setEnabled(false);
        buttonTextcolorDisabled = buttonSelect(16,this).getCurrentTextColor();
        buttonSelect(16, this).setEnabled(true);
        buttonTextcolorActive = textcolorActive;
        textField(1, 1, 3).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeActive);
        textField(1, 1, 2).setTextSize(TypedValue.COMPLEX_UNIT_PX, textsizeScoreActive);
        Intent intent = getIntent();
        playerCount = Integer.parseInt(Objects.requireNonNull(intent.getStringExtra("playerCount")));
        gameMode = intent.getCharSequenceExtra("gameMode");
        CharSequence player1n = intent.getCharSequenceExtra("player1");
        CharSequence player2n = intent.getCharSequenceExtra("player2");
        CharSequence player3n = intent.getCharSequenceExtra("player3");
        CharSequence player4n = intent.getCharSequenceExtra("player4");
        CharSequence player5n = intent.getCharSequenceExtra("player5");
        CharSequence player6n = intent.getCharSequenceExtra("player6");
        CharSequence player7n = intent.getCharSequenceExtra("player7");
        CharSequence player8n = intent.getCharSequenceExtra("player8");
        player s1 = new player();
        player s2 = new player();
        player s3 = new player();
        player s4 = new player();
        player s5 = new player();
        player s6 = new player();
        player s7 = new player();
        player s8 = new player();
        players[1] = s1;
        players[2] = s2;
        players[3] = s3;
        players[4] = s4;
        players[5] = s5;
        players[6] = s6;
        players[7] = s7;
        players[8] = s8;
        for (int a = 1; a <= playerCount; a++) players[a].score = 0;
        switch (playerCount) {
            case 8:
                if (player8n != null) players[8].playerName = player8n.toString();
            case 7:
                if (player7n != null) players[7].playerName = player7n.toString();
            case 6:
                if (player6n != null) players[6].playerName = player6n.toString();
            case 5:
                if (player5n != null) players[5].playerName = player5n.toString();
            case 4:
                if (player4n != null) players[4].playerName = player4n.toString();
            case 3:
                if (player3n != null) players[3].playerName = player3n.toString();
            case 2:
                if (player2n != null) players[2].playerName = player2n.toString();
            case 1:
                if (player1n != null) players[1].playerName = player1n.toString();
        }
        TextView p3name = findViewById(R.id.p3name);
        TextView p4name = findViewById(R.id.p4name);
        TextView p5name = findViewById(R.id.p5name);
        TextView p6name = findViewById(R.id.p6name);
        TextView p7name = findViewById(R.id.p7name);
        TextView p8name = findViewById(R.id.p8name);
        TextView p2score = findViewById(R.id.p2score);
        TextView p3score = findViewById(R.id.p3score);
        TextView p4score = findViewById(R.id.p4score);
        TextView p5score = findViewById(R.id.p5score);
        TextView p6score = findViewById(R.id.p6score);
        TextView p7score = findViewById(R.id.p7score);
        TextView p8score = findViewById(R.id.p8score);
        // assign names and layout of them dependent of player count
        p1name.setText(players[1].playerName);
        switch (playerCount) {
            case 2:
                ConstraintSet cs = new ConstraintSet();
                cs.clone(main);
                cs.connect(p2name.getId(), ConstraintSet.END, ConstraintSet.PARENT_ID, ConstraintSet.END);
                cs.applyTo(main);
                p3name.setVisibility(View.GONE);
                p4name.setVisibility(View.GONE);
                p5name.setVisibility(View.GONE);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p3score.setVisibility(View.GONE);
                p4score.setVisibility(View.GONE);
                p5score.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                break;
            case 1:
                p2name.setVisibility(View.GONE);
                p3name.setVisibility(View.GONE);
                p4name.setVisibility(View.GONE);
                p5name.setVisibility(View.GONE);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p2score.setVisibility(View.GONE);
                p3score.setVisibility(View.GONE);
                p4score.setVisibility(View.GONE);
                p5score.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                break;
            case 3:
                ConstraintSet cs3 = new ConstraintSet();
                cs3.clone(main);
                cs3.connect(p2name.getId(), ConstraintSet.END, R.id.mittelinks, ConstraintSet.END);
                cs3.connect(p3name.getId(), ConstraintSet.START, R.id.middle, ConstraintSet.END);
                cs3.connect(p3name.getId(), ConstraintSet.END, ConstraintSet.PARENT_ID, ConstraintSet.END);
                cs3.applyTo(main);
                p4name.setVisibility(View.GONE);
                p5name.setVisibility(View.GONE);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p4score.setVisibility(View.GONE);
                p5score.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                break;
            case 4:
                ConstraintSet cs4 = new ConstraintSet();
                cs4.clone(main);
                cs4.connect(p2name.getId(), ConstraintSet.END, R.id.mittelinks, ConstraintSet.END);
                cs4.connect(p3name.getId(), ConstraintSet.START, R.id.middle, ConstraintSet.START);
                cs4.connect(p3name.getId(), ConstraintSet.END, R.id.p4name, ConstraintSet.START);
                cs4.connect(p4name.getId(), ConstraintSet.START, R.id.p3name, ConstraintSet.END);
                cs4.connect(p4name.getId(), ConstraintSet.END, ConstraintSet.PARENT_ID, ConstraintSet.END);
                cs4.applyTo(main);
                p5name.setVisibility(View.GONE);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p5score.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                break;
            case 5:
                ConstraintSet cs5 = new ConstraintSet();
                cs5.clone(main);
                cs5.connect(p3name.getId(), ConstraintSet.END, R.id.mittelinks, ConstraintSet.END);
                cs5.connect(p4name.getId(), ConstraintSet.START, R.id.middle, ConstraintSet.START);
                cs5.connect(p4name.getId(), ConstraintSet.END, R.id.p5name, ConstraintSet.START);
                cs5.connect(p5name.getId(), ConstraintSet.START, R.id.p4name, ConstraintSet.END);
                cs5.applyTo(main);
                p6name.setVisibility(View.GONE);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p6score.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                p5name.setText(players[5].playerName);
                break;
            case 6:
                ConstraintSet cs6 = new ConstraintSet();
                cs6.clone(main);
                cs6.connect(p3name.getId(), ConstraintSet.END, R.id.mittelinks, ConstraintSet.END);
                cs6.connect(p4name.getId(), ConstraintSet.START, R.id.middle, ConstraintSet.START);
                cs6.connect(p4name.getId(), ConstraintSet.END, R.id.p5name, ConstraintSet.START);
                cs6.connect(p5name.getId(), ConstraintSet.START, R.id.p4name, ConstraintSet.END);
                cs6.applyTo(main);
                p7name.setVisibility(View.GONE);
                p8name.setVisibility(View.GONE);
                p7score.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                p5name.setText(players[5].playerName);
                p6name.setText(players[6].playerName);
                break;
            case 7:
                p8name.setVisibility(View.GONE);
                p8score.setVisibility(View.GONE);
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                p5name.setText(players[5].playerName);
                p6name.setText(players[6].playerName);
                p7name.setText(players[7].playerName);
                break;
            case 8:
                p2name.setText(players[2].playerName);
                p3name.setText(players[3].playerName);
                p4name.setText(players[4].playerName);
                p5name.setText(players[5].playerName);
                p6name.setText(players[6].playerName);
                p7name.setText(players[7].playerName);
                p8name.setText(players[8].playerName);
                break;
        }
        Button b1 = findViewById(R.id.b1);
        Button b2 = findViewById(R.id.b2);
        Button b3 = findViewById(R.id.b3);
        Button b4 = findViewById(R.id.b4);
        Button b5 = findViewById(R.id.b5);
        Button b6 = findViewById(R.id.b6);
        Button b7 = findViewById(R.id.b7);
        Button b8 = findViewById(R.id.b8);
        Button b9 = findViewById(R.id.b9);
        Button b10 = findViewById(R.id.b10);
        Button b11 = findViewById(R.id.b11);
        Button b12 = findViewById(R.id.b12);
        Button b13 = findViewById(R.id.b13);
        Button b14 = findViewById(R.id.b14);
        Button b15 = findViewById(R.id.b15);
        Button b16 = findViewById(R.id.b16);
        Button b17 = findViewById(R.id.b17);
        Button b18 = findViewById(R.id.b18);
        Button b19 = findViewById(R.id.b19);
        Button b20 = findViewById(R.id.b20);
        Button bull = findViewById(R.id.bull);
        Button bdouble = findViewById(R.id.doubleButton);
        Button btripel = findViewById(R.id.tripleButton);
        Button bmissed = findViewById(R.id.missedButton);
        Button bcontinue = findViewById(R.id.continueButton);
        Button bundo = findViewById(R.id.undoButton);
        Button bdx = findViewById(R.id.bdx);
        Button btx = findViewById(R.id.btx);
        Button b1_dt = findViewById(R.id.b1_dt);
        Button b2_dt = findViewById(R.id.b2_dt);
        Button b3_dt = findViewById(R.id.b3_dt);
        Button b4_dt = findViewById(R.id.b4_dt);
        Button b5_dt = findViewById(R.id.b5_dt);
        Button b6_dt = findViewById(R.id.b6_dt);
        Button b7_dt = findViewById(R.id.b7_dt);
        Button b8_dt = findViewById(R.id.b8_dt);
        Button b9_dt = findViewById(R.id.b9_dt);
        Button b10_dt = findViewById(R.id.b10_dt);
        Button b11_dt = findViewById(R.id.b11_dt);
        Button b12_dt = findViewById(R.id.b12_dt);
        Button b13_dt = findViewById(R.id.b13_dt);
        Button b14_dt = findViewById(R.id.b14_dt);
        Button b15_dt = findViewById(R.id.b15_dt);
        Button b16_dt = findViewById(R.id.b16_dt);
        Button b17_dt = findViewById(R.id.b17_dt);
        Button b18_dt = findViewById(R.id.b18_dt);
        Button b19_dt = findViewById(R.id.b19_dt);
        Button b20_dt = findViewById(R.id.b20_dt);
        Button bull_dt = findViewById(R.id.bull_dt);
        Button missed_dt = findViewById(R.id.missed_dt);
        Button bcontinue_dt = findViewById(R.id.continue_dt);
        Button bundo_dt = findViewById(R.id.undo_dt);
        Button bdouble_dt = findViewById(R.id.doublebutton_dt);
        Button btriple_dt = findViewById(R.id.triple_dt);
        b1.setOnClickListener(buttonclick);
        b2.setOnClickListener(buttonclick);
        b3.setOnClickListener(buttonclick);
        b4.setOnClickListener(buttonclick);
        b5.setOnClickListener(buttonclick);
        b6.setOnClickListener(buttonclick);
        b7.setOnClickListener(buttonclick);
        b8.setOnClickListener(buttonclick);
        b9.setOnClickListener(buttonclick);
        b10.setOnClickListener(buttonclick);
        b11.setOnClickListener(buttonclick);
        b12.setOnClickListener(buttonclick);
        b13.setOnClickListener(buttonclick);
        b14.setOnClickListener(buttonclick);
        b15.setOnClickListener(buttonclick);
        b16.setOnClickListener(buttonclick);
        b17.setOnClickListener(buttonclick);
        b18.setOnClickListener(buttonclick);
        b19.setOnClickListener(buttonclick);
        b20.setOnClickListener(buttonclick);
        bmissed.setOnClickListener(buttonclick);
        bcontinue.setOnClickListener(weiter);
        bull.setOnClickListener(buttonclick);
        bdouble.setOnClickListener(doubletripleClick);
        btripel.setOnClickListener(doubletripleClick);
        bundo.setOnClickListener(undoclick);
        b1_dt.setOnClickListener(buttonclick);
        b2_dt.setOnClickListener(buttonclick);
        b3_dt.setOnClickListener(buttonclick);
        b4_dt.setOnClickListener(buttonclick);
        b5_dt.setOnClickListener(buttonclick);
        b6_dt.setOnClickListener(buttonclick);
        b7_dt.setOnClickListener(buttonclick);
        b8_dt.setOnClickListener(buttonclick);
        b9_dt.setOnClickListener(buttonclick);
        b10_dt.setOnClickListener(buttonclick);
        b11_dt.setOnClickListener(buttonclick);
        b12_dt.setOnClickListener(buttonclick);
        b13_dt.setOnClickListener(buttonclick);
        b14_dt.setOnClickListener(buttonclick);
        b15_dt.setOnClickListener(buttonclick);
        b16_dt.setOnClickListener(buttonclick);
        b17_dt.setOnClickListener(buttonclick);
        b18_dt.setOnClickListener(buttonclick);
        b19_dt.setOnClickListener(buttonclick);
        b20_dt.setOnClickListener(buttonclick);
        missed_dt.setOnClickListener(buttonclick);
        bcontinue_dt.setOnClickListener(weiter);
        bull_dt.setOnClickListener(buttonclick);
        bdouble_dt.setOnClickListener(doubletripleClick);
        btriple_dt.setOnClickListener(doubletripleClick);
        bundo_dt.setOnClickListener(undoclick);
        if (settings.contains("changetime"))
            changetime = settings.getInt("changetime", 1500);
        if (settings.contains("crazystart"))
            crazycricketRangeMinimum = settings.getInt("crazystart", 6);
        for (int z = 0; z <= 25; z++) {
            segmentActive[z] = false;
        }
        //change layout to match selected game
        b16.setEnabled(false);
        b17.setEnabled(false);
        b18.setEnabled(false);
        b19.setEnabled(false);
        b20.setEnabled(false);
        bull.setEnabled(false);
        bdx.setEnabled(false);
        btx.setEnabled(false);
        b1.setVisibility(View.GONE);
        b2.setVisibility(View.GONE);
        b3.setVisibility(View.GONE);
        b4.setVisibility(View.GONE);
        b5.setVisibility(View.GONE);
        b6.setVisibility(View.GONE);
        b7.setVisibility(View.GONE);
        b8.setVisibility(View.GONE);
        b9.setVisibility(View.GONE);
        String gamemode = gameMode.toString();
        switch (gamemode) {
            case "15-Bull":
                b10.setVisibility(View.GONE);
                b11.setVisibility(View.GONE);
                b12.setVisibility(View.GONE);
                b13.setVisibility(View.GONE);
                b14.setVisibility(View.GONE);
                segmentActive[15] = true;
                buttonSelect(15, this).setTextColor(buttonTextcolorActive);
                break;
            case "14-Bull":
                b10.setVisibility(View.GONE);
                b11.setVisibility(View.GONE);
                b12.setVisibility(View.GONE);
                b13.setVisibility(View.GONE);
                b15.setEnabled(false);
                segmentActive[14] = true;
                buttonSelect(14, this).setTextColor(buttonTextcolorActive);
                break;
            case "13-Bull":
                b10.setVisibility(View.GONE);
                b11.setVisibility(View.GONE);
                b12.setVisibility(View.GONE);
                b15.setEnabled(false);
                b14.setEnabled(false);
                segmentActive[13] = true;
                buttonSelect(13, this).setTextColor(buttonTextcolorActive);
                break;
            case "12-Bull":
                b10.setVisibility(View.GONE);
                b11.setVisibility(View.GONE);
                b15.setEnabled(false);
                b14.setEnabled(false);
                b13.setEnabled(false);
                buttonSelect(12, this).setTextColor(buttonTextcolorActive);
                segmentActive[12] = true;
                break;
            case "11-Bull":
                b10.setVisibility(View.GONE);
                b15.setEnabled(false);
                b14.setEnabled(false);
                b13.setEnabled(false);
                b12.setEnabled(false);
                segmentActive[11] = true;
                buttonSelect(11, this).setTextColor(buttonTextcolorActive);
                break;
            case "10-Bull":
                b15.setEnabled(false);
                b14.setEnabled(false);
                b13.setEnabled(false);
                b12.setEnabled(false);
                b11.setEnabled(false);
                segmentActive[10] = true;
                buttonSelect(10, this).setTextColor(buttonTextcolorActive);
                break;
            case "Crazy":
                allButtons = initialCrazySegmentSelection(9);
                initCrazySegmentOrder(allButtons);
                firstSegment().setEnabled(true);
                firstSegment().setTextColor(buttonTextcolorActive);
                segmentActive[getFirstSegmentNumber()] = true;
                break;
            case "Random":
                allButtons = initialRandomSegmentSelection(6);
                initRandomSegmentOrder();
                firstSegment().setEnabled(true);
                firstSegment().setTextColor(buttonTextcolorActive);
                segmentActive[getFirstSegmentNumber()] = true;
                break;
        }
        findViewById(android.R.id.content).invalidate();
        if (!(gameMode.equals("Random") || gameMode.equals("Crazy")))
            getButtonlistForRegular(allButtons); //important!
        startTime = System.currentTimeMillis();
    }

    private int getFirstSegmentNumber() {
        int firstSegmentNr;
        int firstSegmentID = firstSegment().getId();
        if (firstSegmentID == R.id.bull) {
            firstSegmentNr = 25;
        } else if (firstSegmentID == R.id.bdx) {
            firstSegmentNr = 21;
        } else if (firstSegmentID == R.id.btx) {
            firstSegmentNr = 22;
        } else
            firstSegmentNr = Integer.parseInt(firstSegment().getText().toString());
        return firstSegmentNr;
    }

    private void getButtonlistForRegular(ArrayList<Button> allButtons) {
        allButtons.clear();
        // add buttons before "Dx"
        for (int button = crazycricketRangeMinimum; button <= 16; button++) {
            if (buttonSelect(button,this).getVisibility() == View.VISIBLE) {
                allButtons.add(buttonSelect(button, this));
            }
        }
        allButtons.add(buttonSelect(21, this));  // "Dx"-Button
        // add buttons between "Dx" and "Tx"
        for (int button = 17; button <= 18; button++) {
            if (buttonSelect(button, this).getVisibility() == View.VISIBLE) {
                allButtons.add(buttonSelect(button, this));
            }
        }
        allButtons.add(buttonSelect(22, this)); // "Tx" Button
        // add buttons between "Tx" and "Bull"
        for (int button = 19; button <= 20; button++) {
            if (buttonSelect(button, this).getVisibility() == View.VISIBLE) {
                allButtons.add(buttonSelect(button, this));
            }
        }
        allButtons.add(buttonSelect(25, this)); // "Bull" Button
    }

    private void activateLastSegment(ArrayList<Button> allbutton) {
        // find first visible AND active segment
        for (int buttonIndex = 1; buttonIndex < allbutton.size(); buttonIndex++) {
            Button actualButton = allbutton.get(buttonIndex);
            if (actualButton.getCurrentTextColor() == buttonTextcolorActive) {
                // which button is the actual one?
                int actualButtonID = actualButton.getId();
                if (actualButtonID == R.id.bull) {
                    segmentActive[25] = false;
                } else if (actualButtonID == R.id.btx) {
                    setAllActive(false,1);
                    segmentActive[22] = false;
                } else if (actualButtonID == R.id.bdx) {
                    setAllActive(false,1);
                    segmentActive[21] = false;
                } else
                    segmentActive[Integer.parseInt(actualButton.getText().toString())] = false;

                // which button will be next?
                Button nextButton = allbutton.get(buttonIndex-1);
                int nextlButtonID = nextButton.getId();
                if (nextlButtonID == R.id.bull) {
                    segmentActive[25] = true;
                } else if (nextlButtonID == R.id.btx) {
                    setAllActive(true, 22);
                    segmentActive[22] = true;
                } else if (nextlButtonID == R.id.bdx) {
                    setAllActive(true, 21);
                    segmentActive[21] = true;
                } else
                    segmentActive[Integer.parseInt(allbutton.get(buttonIndex-1).getText().toString())] = true;

                if (buttonIndex > 0) {
                    allbutton.get(buttonIndex - 1).setEnabled(true);
                    allbutton.get(buttonIndex - 1).setTextColor(buttonTextcolorActive);
                    actualButton.setEnabled(false);
                    actualButton.setTextColor(buttonTextcolorDisabled);
                }
                break;
            }
        }
    }

    private void activateNextSegment(ArrayList<Button> allbutton){
        // find first visible AND active segment
        for (int buttonIndex = 0; buttonIndex < allbutton.size()-1; buttonIndex++) {
            Button actualButton = allbutton.get(buttonIndex);
            if (actualButton.getCurrentTextColor() == buttonTextcolorActive) {
                // which button/segment is the actual one?
                int actualButtonID = actualButton.getId();
                if (actualButtonID == R.id.bdx) {
                    setAllActive(false,1);
                    segmentActive[21] = false;
                } else if (actualButtonID == R.id.btx) {
                    setAllActive(false,1);
                    segmentActive[22] = false;
                } else if (actualButtonID == R.id.bull) {
                    segmentActive[25] = false;
                    break;
                } else
                    segmentActive[Integer.parseInt(actualButton.getText().toString())] = false;

                // which button will be next?
                int nextButtonID = allButtons.get(buttonIndex+1).getId();
                if (nextButtonID == R.id.bdx) {
                    setAllActive(true, 21);
                    segmentActive[21] = true;
                }
                else if (nextButtonID == R.id.btx) {
                    setAllActive(true, 22);
                    segmentActive[22] = true;
                }
                else if (nextButtonID == R.id.bull) {
                    segmentActive[25] = true;
                } else
                    segmentActive[Integer.parseInt(allbutton.get(buttonIndex+1).getText().toString())] = true;

                // if not last button
                if (actualButton != allbutton.get(allbutton.size()-1)) {
                    if (!(segmentActive[21] || segmentActive[22])) allbutton.get(buttonIndex + 1).setEnabled(true);
                    allbutton.get(buttonIndex + 1).setTextColor(buttonTextcolorActive);
                }
                actualButton.setEnabled(false);
                actualButton.setTextColor(buttonTextcolorDisabled);
                break;
            }
        }
    }

    private Button firstSegment() {
        Button buttonToReturn =  findViewById(R.id.b1);
        if (gameMode.equals("Crazy")) return allButtons.get(0);
        for (int button = crazycricketRangeMinimum; button <= 20; button++) {
            if (buttonSelect(button, this).getVisibility() == View.VISIBLE) {
                buttonToReturn = buttonSelect(button, this);
                break;
            }
        }
        return buttonToReturn;
    }

    // selects random segements and hides unneeded segments
    private void initCrazySegmentOrder(ArrayList<Button> crazybuttonlist) {
        ConstraintLayout main = findViewById(R.id.matchbereich);
        ConstraintSet cs = new ConstraintSet();
        cs.clone(main);
        int lastSegID = crazybuttonlist.get(crazybuttonlist.size()-1).getId();
        int firstSegID = crazybuttonlist.get(0).getId();
        // fix position of "next", "undo" etc. to last segment
        cs.connect(findViewById(R.id.missedButton).getId(),ConstraintSet.TOP,lastSegID, ConstraintSet.BOTTOM);
        cs.connect(findViewById(R.id.continueButton).getId(), ConstraintSet.TOP, lastSegID, ConstraintSet.BOTTOM);
        cs.connect(findViewById(R.id.undoButton).getId(), ConstraintSet.TOP, lastSegID, ConstraintSet.BOTTOM);
        // fix position of first and last button to parent
        cs.connect(findViewById(R.id.doubleButton).getId(), ConstraintSet.BOTTOM, firstSegID, ConstraintSet.TOP);
        cs.connect(firstSegID, ConstraintSet.TOP, findViewById(R.id.doubleButton).getId(), ConstraintSet.BOTTOM);
        cs.connect(firstSegID, ConstraintSet.BOTTOM, crazybuttonlist.get(1).getId(), ConstraintSet.TOP);
        cs.connect(lastSegID, ConstraintSet.BOTTOM, findViewById(R.id.missedButton).getId(), ConstraintSet.TOP);
        cs.connect(lastSegID, ConstraintSet.TOP, crazybuttonlist.get(crazybuttonlist.size()-2).getId(), ConstraintSet.BOTTOM);
        // arrange postion of buttons between first and last button
        for (int i=1; i<crazybuttonlist.size()-1; i++) {
            cs.connect(crazybuttonlist.get(i).getId(),ConstraintSet.TOP, crazybuttonlist.get(i-1).getId(), ConstraintSet.BOTTOM);
            cs.connect(crazybuttonlist.get(i).getId(),ConstraintSet.BOTTOM, crazybuttonlist.get(i+1).getId(), ConstraintSet.TOP);
        }
        cs.applyTo(main);
    }

    // set "Dx" to 3. position and "Tx" to 6. position from top
    private void initRandomSegmentOrder() {
        ArrayList<Button> allButtonsHere = new ArrayList<>();
        getButtonlistForRegular(allButtonsHere);
        int save=0;
        //drop dx button from list
        for (int i = 0; i <= allButtonsHere.size()-1; i++) {
            if (allButtonsHere.get(i).getText().toString().equals("Dx"))
                save=i;
        }
        allButtonsHere.remove(save);
        //drop tx button from list
        for (int i = 0; i <= allButtonsHere.size()-1; i++) {
            if (allButtonsHere.get(i).getText().toString().equals("Tx"))
                save=i;
        }
        allButtonsHere.remove(save);
        ConstraintLayout main = findViewById(R.id.matchbereich);
        ConstraintSet cs = new ConstraintSet();
        cs.clone(main);
        Button bdx = findViewById(R.id.bdx);
        Button b16 = findViewById(R.id.b16);
        Button b17 = findViewById(R.id.b17);
        Button btx = findViewById(R.id.btx);
        Button b18 = findViewById(R.id.b18);
        Button b19 = findViewById(R.id.b19);
        // set buttons, surrounding bdx
        cs.connect(b16.getId(),ConstraintSet.BOTTOM, b17.getId(), ConstraintSet.TOP);
        cs.connect(b17.getId(), ConstraintSet.TOP, b16.getId(), ConstraintSet.BOTTOM);
        // set buttons, surrounding btx
        cs.connect(b18.getId(),ConstraintSet.BOTTOM, b19.getId(), ConstraintSet.TOP);
        cs.connect(b19.getId(), ConstraintSet.TOP, b18.getId(), ConstraintSet.BOTTOM);
        // set bdx to visible buttons
        cs.connect(bdx.getId(),ConstraintSet.TOP, allButtonsHere.get(1).getId(), ConstraintSet.BOTTOM);
        cs.connect(bdx.getId(), ConstraintSet.BOTTOM, allButtonsHere.get(2).getId(), ConstraintSet.TOP);
        cs.connect(allButtonsHere.get(1).getId(),ConstraintSet.BOTTOM, bdx.getId(), ConstraintSet.TOP);
        cs.connect(allButtonsHere.get(2).getId(),ConstraintSet.TOP, bdx.getId(), ConstraintSet.BOTTOM);
        // set btx to visible buttons
        cs.connect(btx.getId(),ConstraintSet.TOP, allButtonsHere.get(3).getId(), ConstraintSet.BOTTOM);
        cs.connect(btx.getId(), ConstraintSet.BOTTOM, allButtonsHere.get(4).getId(), ConstraintSet.TOP);
        cs.connect(allButtonsHere.get(3).getId(),ConstraintSet.BOTTOM, btx.getId(), ConstraintSet.TOP);
        cs.connect(allButtonsHere.get(4).getId(),ConstraintSet.TOP, btx.getId(), ConstraintSet.BOTTOM);
        cs.applyTo(main);
    }

    // random segment selection
    private ArrayList<Button> initialRandomSegmentSelection(int segmentCount) {
        ArrayList<Button> buttonlist = new ArrayList<>();
        if (segmentCount > 20) return buttonlist;
        // hide all segments
        for (int segmentNr = 1; segmentNr <= 20; segmentNr++) {
            hideSegment(segmentNr);
        }
        // display random selected segments
        Random rand = new Random();
        int segmentnumber = rand.nextInt(21 - crazycricketRangeMinimum) + crazycricketRangeMinimum;
        for (int i = 1; i <= segmentCount; i++) {
            while (buttonSelect(segmentnumber, this).getVisibility() == View.VISIBLE) {
                segmentnumber = rand.nextInt(21 - crazycricketRangeMinimum) + crazycricketRangeMinimum;
            }
            buttonSelect(segmentnumber, this).setVisibility(View.VISIBLE);
            buttonSelect(segmentnumber, this).setEnabled(false);
        }
        // get visible segments in ascending order, assuming "Dx" and "Tx" are still visible
        int counter = 0;
        for (int i = 1; i <= 20; i++) {
            if (buttonSelect(i, this).getVisibility() == View.VISIBLE) {
                buttonlist.add(buttonSelect(i, this));
                counter++;
                if (counter == 2) buttonlist.add(findViewById(R.id.bdx));
                if (counter == 4) buttonlist.add(findViewById(R.id.btx));
            }
        }
        buttonlist.add(buttonSelect(25, this));
        return buttonlist;
    }
    // crazy segment selection
    private ArrayList<Button> initialCrazySegmentSelection(int segmentCount) {
        ArrayList<Button> buttonlist = new ArrayList<>();
        if (segmentCount > 20) return buttonlist;
        // hide all segments
        for (int i = 1; i <= 22; i++) {
            hideSegment(i);
        }
        hideSegment(25);
        // display random selected segments
        Random rand = new Random();
        int segmentnumber;
        do {
            segmentnumber = rand.nextInt(26 - crazycricketRangeMinimum) + crazycricketRangeMinimum;
        }  while (segmentnumber == 23 || segmentnumber == 24);
        for (int i = 1; i <= segmentCount; i++) {
            while (buttonSelect(segmentnumber, this).getVisibility() == View.VISIBLE) {
                do {
                    segmentnumber = rand.nextInt(26 - crazycricketRangeMinimum) + crazycricketRangeMinimum;
                }  while (segmentnumber == 23 || segmentnumber == 24);
            }
            buttonSelect(segmentnumber, this).setVisibility(View.VISIBLE);
            buttonSelect(segmentnumber, this).setEnabled(false);
            buttonlist.add(buttonSelect(segmentnumber, this));
        }
        return buttonlist;
    }

    private void hideSegment(int feld) {
        buttonSelect(feld, this).setVisibility(View.GONE);
        for (int playerIndex = 1; playerIndex <= playerCount; playerIndex++)
            textField(feld, playerIndex, 1).setVisibility(View.GONE);
    }

    private int activeSegment() {
        for (int i = 1 ;i <= 25 ;i++) {
            if (segmentActive[i])
                return i;
        }
        return 0;
    }


    private Button buttonSelect_dt(int buttonnumber) {
        String stt;
        switch (buttonnumber) {
            case 21:
                stt="doublebutton_dt";
                break;
            case 22:
                stt="triple_dt";
                break;
            case 23:
                stt="missed_dt";
                break;
            case 24:
                stt="continue_dt";
                break;
            case 25:
                stt="bull_dt";
                break;
            case 26:
                stt="undo_dt";
                break;
            default:
                stt = "b" + buttonnumber + "_dt";
                break;
        }
        int idd = getResources().getIdentifier(stt, "id", getPackageName());
        return findViewById(idd);
    }

    // returns wanted textview
    private TextView textField(int dart, int aktiverSpieler, int typ)
    // typ=1 -> hits TextView
    // typ=2 -> score TextView
    // typ=3 -> name Textview
    {
        String textViewName = "";
        switch (typ) {
            case 1:
                if (dart == 25) textViewName = "tbull" + "p" + aktiverSpieler;
                else if (dart == 21) textViewName = "tdx"+"p"+aktiverSpieler;
                     else if (dart == 22) textViewName = "ttx"+"p"+aktiverSpieler;
                          else textViewName = "t" + dart + "p" + aktiverSpieler;
                break;
            case 2:
                textViewName = "p" + aktiverSpieler + "score";
                break;
            case 3:
                textViewName = "p" + aktiverSpieler + "name";
                break;
        }
        int idd = getResources().getIdentifier(textViewName, "id", getPackageName());
        return findViewById(idd);
    }
     private boolean isSegmentActiv() {
         for (int i = 1; i <= 22; i++) {
             if (segmentActive[i]) return true;
         }
         return segmentActive[25];
     }

    private boolean gameover() {
        // game is over, if a) bull segment was activ, b) last player is/was active and c) he did 3 hits
        // game is over, if a) bull segment is activ or none b) last player is activ c) last player hits bull segment 3x

        if (gameMode.equals("Crazy")) {
            int lastButtonnumber;
            String buttonText = allButtons.get(allButtons.size() - 1).getText().toString();
            int buttonID = allButtons.get(allButtons.size()-1).getId();
            if (buttonID == R.id.bull) {
                    lastButtonnumber = 25;
            } else if (buttonID == R.id.bdx) {
                lastButtonnumber = 21;
            } else if (buttonID == R.id.btx) {
                lastButtonnumber = 22;
            } else
                lastButtonnumber = Integer.parseInt(buttonText);

            return  activePlayer == playerCount
                    && thrownDartsInRound == 0
                    && dartsThrown.get(dartsThrown.size()-1).segment == lastButtonnumber
                    && dartsThrown.get(dartsThrown.size()-1).playerIndex == activePlayer
                    && dartsThrown.get(dartsThrown.size()-2).segment == lastButtonnumber
                    && dartsThrown.get(dartsThrown.size()-2).playerIndex == activePlayer
                    && dartsThrown.get(dartsThrown.size()-3).segment == lastButtonnumber
                    && dartsThrown.get(dartsThrown.size()-3).playerIndex == activePlayer;
        }
        else
            return (segmentActive[25] || !isSegmentActiv())
                && activePlayer == playerCount
                && thrownDartsInRound == 0
                && dartsThrown.get(dartsThrown.size()-1).segment == 25
                && dartsThrown.get(dartsThrown.size()-1).playerIndex == activePlayer
                && dartsThrown.get(dartsThrown.size()-2).segment == 25
                && dartsThrown.get(dartsThrown.size()-2).playerIndex == activePlayer
                && dartsThrown.get(dartsThrown.size()-3).segment == 25
                && dartsThrown.get(dartsThrown.size()-3).playerIndex == activePlayer;
    }


    private void buttonfreeze(boolean freeze) {
        Button b1 = findViewById(R.id.b1);
        Button b2 = findViewById(R.id.b2);
        Button b3 = findViewById(R.id.b3);
        Button b4 = findViewById(R.id.b4);
        Button b5 = findViewById(R.id.b5);
        Button b6 = findViewById(R.id.b6);
        Button b7 = findViewById(R.id.b7);
        Button b8 = findViewById(R.id.b8);
        Button b9 = findViewById(R.id.b9);
        Button b10 = findViewById(R.id.b10);
        Button b11 = findViewById(R.id.b11);
        Button b12 = findViewById(R.id.b12);
        Button b13 = findViewById(R.id.b13);
        Button b14 = findViewById(R.id.b14);
        Button b15 = findViewById(R.id.b15);
        Button b16 = findViewById(R.id.b16);
        Button b17 = findViewById(R.id.b17);
        Button b18 = findViewById(R.id.b18);
        Button b19 = findViewById(R.id.b19);
        Button b20 = findViewById(R.id.b20);
        Button bull = findViewById(R.id.bull);
        Button bdouble = findViewById(R.id.doubleButton);
        Button btripel = findViewById(R.id.tripleButton);
        Button daneben = findViewById(R.id.missedButton);
        Button restdaneben = findViewById(R.id.continueButton);
        Button bundo = findViewById(R.id.undoButton);
        Button bdx = findViewById(R.id.bdx);
        Button btx = findViewById(R.id.btx);
        freeze = !freeze;
        bdouble.setEnabled(freeze);
        btripel.setEnabled(freeze);
        daneben.setEnabled(freeze);
        restdaneben.setEnabled(freeze);
        bundo.setEnabled(freeze);
        int aktseg = activeSegment();
        if (!freeze) {
                b1.setEnabled(false);
                b2.setEnabled(false);
                b3.setEnabled(false);
                b4.setEnabled(false);
                b5.setEnabled(false);
                b6.setEnabled(false);
                b7.setEnabled(false);
                b8.setEnabled(false);
                b9.setEnabled(false);
                b10.setEnabled(false);
                b11.setEnabled(false);
                b12.setEnabled(false);
                b13.setEnabled(false);
                b14.setEnabled(false);
                b15.setEnabled(false);
                b16.setEnabled(false);
                b17.setEnabled(false);
                b18.setEnabled(false);
                b19.setEnabled(false);
                b20.setEnabled(false);
                bull.setEnabled(false);
                bdx.setEnabled(false);
                btx.setEnabled(false);
                for (int i = 1; i <= 26; i++) buttonSelect_dt(i).setEnabled(false);
        } else {
            switch (aktseg) {
                case 21:
                    setAllActive(true, 21);
                    buttonSelect(21, this).setTextColor(buttonTextcolorActive);
                    break;
                case 22:
                    setAllActive(true, 22);
                    buttonSelect(22, this).setTextColor(buttonTextcolorActive);
                    break;
                default:
                    // not a Dx- or Tx-Segment
                    if (aktseg != 0) buttonSelect(aktseg, this).setEnabled(true);
                    break;
            }
            for (int i = 1; i <= 26; i++) buttonSelect_dt(i).setEnabled(true);
        }
    }


    public void onBackPressed() {
        AlertDialog alertDialog = new AlertDialog.Builder(halve.this).create();
        alertDialog.setTitle(getResources().getString(R.string.caution));
        alertDialog.setMessage(getResources().getString(R.string.quitMatch));
        alertDialog.setButton(AlertDialog.BUTTON_POSITIVE, getResources().getString(R.string.yesIDo),
                (dialog, which) -> {
                    dialog.dismiss();
                    finish();
                });
        alertDialog.setButton(AlertDialog.BUTTON_NEGATIVE, getResources().getString(R.string.returnToMatch), (dialog, which) -> dialog.dismiss());
        alertDialog.show();
    }

    private static class player {
        final int[] hits = new int[26]; // index 25 is bull counter, otherwise for segments 10-20, at crazy/random probably more
        String playerName;
        int score;
        int darts;
        int ranking;
    }

    @Override
    protected void attachBaseContext(Context base) {
        super.attachBaseContext(dc_modules.updateBaseContextLocale(base));
    }
}

