package com.arturo254.opentune.ui.component.shimmer

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import kotlin.random.Random

@Composable
fun TextPlaceholder(
    modifier: Modifier = Modifier,
    height: Dp = 16.dp,
) {
    Spacer(
        modifier =
            modifier
                .padding(vertical = 4.dp)
                .background(MaterialTheme.colorScheme.onSurface)
                .fillMaxWidth(remember { 0.25f + Random.nextFloat() * 0.5f })
                .height(height),
    )
}
