package com.arturo254.opentune.db.entities

import androidx.compose.runtime.Immutable
import androidx.room.Embedded
import androidx.room.Junction
import androidx.room.Relation

@Immutable
data class Album(
    @Embedded
    val album: AlbumEntity,
    @Relation(
        entity = ArtistEntity::class,
        entityColumn = "id",
        parentColumn = "id",
        associateBy =
            Junction(
                value = AlbumArtistMap::class,
                parentColumn = "albumId",
                entityColumn = "artistId",
            ),
    )
    val artists: List<ArtistEntity>,
    val songCountListened: Int? = 0,
    val timeListened: Int? = 0,
) : LocalItem() {
    override val id: String
        get() = album.id
    override val title: String
        get() = album.title
    override val thumbnailUrl: String?
        get() = album.thumbnailUrl
}
