---
name: Bug Report
about: Report a bug found in OpenTune to help us improve the application
title: "[BUG] Brief description of the issue"
labels: bug
assignees: Arturo254
---

## Bug Description
<!-- Provide a clear and concise description of what the bug is. -->

## Steps to Reproduce
<!-- Provide detailed steps to reproduce the behavior: -->
1. Go to ' '
2. Click on ' '
3. Scroll down to ' '
4. See error

## Expected Behavior
<!-- Describe what you expected to happen. -->

## Actual Behavior
<!-- Describe what actually happened instead. -->

## System Information
- **OpenTune Version:** <!-- e.g., 1.2.3 -->
- **Android Version:** <!-- e.g., Android 13 (API 33) -->
- **Device Model:** <!-- e.g., Samsung Galaxy S21 -->
- **Device Architecture:** <!-- e.g., arm64-v8a, armeabi-v7a -->
- **Available RAM:** <!-- e.g., 8GB -->
- **Available Storage:** <!-- e.g., 128GB total, 45GB free -->

## Frequency and Impact
- **How often does this occur?** <!-- Always / Sometimes / Rarely -->
- **Severity:** <!-- Critical / High / Medium / Low -->
- **Impact:** <!-- App crashes / Feature unusable / UI issue / Performance issue -->

## Environment Details
- **Installation Method:** <!-- Play Store / APK / F-Droid -->
- **First occurrence:** <!-- Version when bug first appeared, if known -->
- **Network Connection:** <!-- WiFi / Mobile Data / Offline -->

## Evidence
<!-- Attach screenshots, videos, or GIFs that demonstrate the issue -->
<!-- You can drag and drop files directly here -->

## Logcat Output (Optional but Recommended)
<!-- Include relevant logcat output if available -->
```
Paste logcat output here
```
**How to capture logs:**
- Use `adb logcat | grep -i opentune` for filtered logs
- Or use `adb logcat > logcat.txt` for full logs

## Additional Context
<!-- Add any other context about the problem here -->
- Is this a regression? (worked in previous version)
- Any recent system updates or changes?
- Other apps affected?
- Workaround found?

## Checklist
<!-- Please check the boxes that apply -->
- [ ] I have searched for existing issues before creating this report
- [ ] I have provided all the requested information above
- [ ] I can consistently reproduce this issue
- [ ] I have tested on the latest version of OpenTune

---

**Thank you for your contribution!** We will review this report as soon as possible.
