package co.adityarajput.notifilter.data.notification

import android.service.notification.StatusBarNotification
import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "notifications")
data class Notification(
    val title: String,
    val content: String,
    val packageName: String,
    val timestamp: Long = System.currentTimeMillis(),

    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,
) {
    constructor(sbn: StatusBarNotification, id: Int = 0) : this(
        sbn.notification.extras.getString("android.title") ?: "",
        sbn.notification.extras.getCharSequence("android.text")?.toString() ?: "",
        sbn.packageName, sbn.postTime, id = id,
    )
}
