package co.adityarajput.notifilter.utils

import androidx.compose.runtime.Composable
import androidx.compose.ui.res.stringResource
import co.adityarajput.notifilter.R

fun Long.toShortHumanReadableTime(): String {
    val now = System.currentTimeMillis()
    val delta = now - this

    val seconds = delta / 1000
    val minutes = seconds / 60
    val hours = minutes / 60
    val days = hours / 24

    return when {
        days > 1000 -> "1k+ days ago"
        days > 0 -> "$days day${if (days > 1) "s" else ""} ago"
        hours > 0 -> "$hours hr${if (hours > 1) "s" else ""} ago"
        minutes > 0 -> "$minutes min${if (minutes > 1) "s" else ""} ago"
        seconds > 0 -> "$seconds sec${if (seconds > 1) "s" else ""} ago"
        else -> "just now"
    }
}

fun Int.withUnit(unit: String): String {
    return when (this) {
        1 -> "1 $unit"
        else -> "$this ${unit}s"
    }
}

fun String.getLast(length: Int): String =
    if (this.length <= length) this else "..." + this.takeLast(length - 3)

@Composable
fun Boolean.getToggleString(): String =
    stringResource(if (this) R.string.disable else R.string.enable)
