package co.adityarajput.alarmetrics.views.components

import androidx.compose.foundation.layout.RowScope
import androidx.compose.material3.*
import androidx.compose.runtime.Composable
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.tooling.preview.Preview
import co.adityarajput.alarmetrics.R
import co.adityarajput.alarmetrics.views.Theme
import co.adityarajput.alarmetrics.views.icons.ArrowBack
import co.adityarajput.alarmetrics.views.icons.Snooze

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun AppBar(
    title: String,
    canNavigateBack: Boolean,
    leadingIconOnClick: () -> Unit = {},
    actions: @Composable RowScope.() -> Unit = {},
) {
    TopAppBar(
        {
            Text(
                title,
                style = MaterialTheme.typography.headlineMedium.copy(
                    fontSize = when {
                        canNavigateBack -> MaterialTheme.typography.headlineSmall.fontSize
                        else -> MaterialTheme.typography.headlineLarge.fontSize
                    }
                ),
            )
        },
        colors = TopAppBarDefaults.topAppBarColors().copy(
            containerColor = MaterialTheme.colorScheme.primary,
        ),
        navigationIcon = {
            IconButton(leadingIconOnClick) {
                if (canNavigateBack) {
                    Icon(
                        ArrowBack,
                        stringResource(R.string.alttext_back_button)
                    )
                } else {
                    Icon(
                        Snooze,
                        stringResource(R.string.alttext_app_logo)
                    )
                }
            }
        },
        actions = actions,
    )
}

@Preview
@Composable
private fun HomeAppBarPreview() {
    Theme {
        AppBar(stringResource(R.string.app_name), false)
    }
}

@Preview
@Composable
private fun AppBarPreview() {
    Theme {
        AppBar("Page Title", true)
    }
}
