/*
 * Copyright 2025 New Vector Ltd.
 *
 * SPDX-License-Identifier: AGPL-3.0-only OR LicenseRef-Element-Commercial
 * Please see LICENSE files in the repository root for full details.
 */

package io.element.android.libraries.designsystem.components.avatar.internal

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import io.element.android.libraries.designsystem.components.avatar.AvatarData
import io.element.android.libraries.designsystem.components.avatar.AvatarType
import io.element.android.libraries.designsystem.components.avatar.anAvatarData
import io.element.android.libraries.designsystem.components.avatar.avatarShape
import io.element.android.libraries.designsystem.preview.ElementThemedPreview
import io.element.android.libraries.designsystem.preview.PreviewGroup
import io.element.android.libraries.designsystem.utils.CommonDrawables

@Composable
internal fun SpaceAvatar(
    avatarData: AvatarData,
    avatarType: AvatarType.Space,
    modifier: Modifier = Modifier,
    forcedAvatarSize: Dp? = null,
    hideAvatarImage: Boolean = false,
    contentDescription: String? = null,
) {
    val size = forcedAvatarSize ?: avatarData.size.dp
    when {
        avatarType.isTombstoned -> TombstonedRoomAvatar(
            size = size,
            avatarShape = avatarType.avatarShape(size),
            modifier = modifier,
            contentDescription = contentDescription,
        )
        else -> InitialOrImageAvatar(
            avatarData = avatarData,
            hideAvatarImage = hideAvatarImage,
            avatarShape = avatarType.avatarShape(size),
            forcedAvatarSize = forcedAvatarSize,
            modifier = modifier,
            contentDescription = contentDescription,
        )
    }
}

@Preview(group = PreviewGroup.Avatars)
@Composable
internal fun SpaceAvatarPreview() =
    ElementThemedPreview(
        drawableFallbackForImages = CommonDrawables.sample_avatar,
    ) {
        Row(
            modifier = Modifier.padding(8.dp),
            horizontalArrangement = Arrangement.spacedBy(8.dp),
        ) {
            SpaceAvatar(
                avatarData = anAvatarData(),
                avatarType = AvatarType.Space(),
            )
            SpaceAvatar(
                avatarData = anAvatarData(),
                avatarType = AvatarType.Space(
                    isTombstoned = true,
                ),
            )
        }
    }
